# Streamlit Development Wiki

This wiki contains documentation for the Streamlit development process.

## Contents

- [Contributing](../CONTRIBUTING.md): How to contribute to Streamlit.
- [Code Style Guide](code-style-guide.md): Tips and best practices for writing code in Streamlit.
- [Running e2e tests and updating snapshots](running-e2e-tests.md): How to run e2e tests and update snapshots.

## Development Guides

Development guides for different parts of the Streamlit codebase. While written primarily for AI agents, these guides are also helpful for human developers.

- [Repo Overview](../AGENTS.md)
- [TypeScript](../frontend/AGENTS.md)
- [Python](../lib/AGENTS.md)
- [Streamlit Library (Python)](../lib/streamlit/AGENTS.md)
- [Python Unit Tests](../lib/tests/AGENTS.md)
- [Protobuf](../proto/streamlit/proto/AGENTS.md)
- [E2E Tests](../e2e_playwright/AGENTS.md)
