<a href="https://surrealdb.com" target="_blank">
    <img width="100%" src="https://github.com/surrealdb/surrealdb/blob/main/img/black/hero.png?raw=true" alt="SurrealDB Hero">
</a>

<p align="center">
	<a href="https://github.com/surrealdb/surrealdb"><img src="https://img.shields.io/badge/status-stable-ff00bb.svg?style=flat-square"></a>
	&nbsp;
	<a href="https://docs.rs/surrealdb/"><img src="https://img.shields.io/docsrs/surrealdb?style=flat-square"></a>
	&nbsp;
	<a href="https://crates.io/crates/surrealdb"><img src="https://img.shields.io/crates/v/surrealdb?style=flat-square"></a>
	&nbsp;
	<a href="https://github.com/surrealdb/surrealdb"><img src="https://img.shields.io/badge/license-Apache_License_2.0-00bfff.svg?style=flat-square"></a>
</p>

<p align="center">
	<a href="https://surrealdb.com/blog"><img height="25" src="https://github.com/surrealdb/surrealdb/blob/main/img/social/blog.svg?raw=true" alt="Blog"></a>
	&nbsp;
	<a href="https://github.com/surrealdb/surrealdb"><img height="25" src="https://github.com/surrealdb/surrealdb/blob/main/img/social/github.svg?raw=true" alt="Github"></a>
	&nbsp;
    <a href="https://www.linkedin.com/company/surrealdb/"><img height="25" src="https://github.com/surrealdb/surrealdb/blob/main/img/social/linkedin.svg?raw=true" alt="LinkedIn"></a>
    &nbsp;
    <a href="https://x.com/surrealdb"><img height="25" src="https://github.com/surrealdb/surrealdb/blob/main/img/social/x.svg?raw=true" alt="X"></a>
    &nbsp;
    <a href="https://www.youtube.com/@surrealdb"><img height="25" src="https://github.com/surrealdb/surrealdb/blob/main/img/social/youtube.svg?raw=true" alt="YouTube"></a>
    &nbsp;
    <a href="https://dev.to/surrealdb"><img height="25" src="https://github.com/surrealdb/surrealdb/blob/main/img/social/dev.svg?raw=true" alt="Dev"></a>
    &nbsp;
    <a href="https://surrealdb.com/discord"><img height="25" src="https://github.com/surrealdb/surrealdb/blob/main/img/social/discord.svg?raw=true" alt="Discord"></a>
    &nbsp;
    <a href="https://stackoverflow.com/questions/tagged/surrealdb"><img height="25" src="https://github.com/surrealdb/surrealdb/blob/main/img/social/stack-overflow.svg?raw=true" alt="Stack Overflow"></a>
</p>

<br>

<h2><img height="20" src="https://github.com/surrealdb/surrealdb/blob/main/img/whatissurreal.svg?raw=true">&nbsp;&nbsp;What is SurrealDB?</h2>

SurrealDB is an end-to-end cloud-native database designed for modern applications, including web, mobile, serverless, Jamstack, backend, and traditional applications. With SurrealDB, you can simplify your database and API infrastructure, reduce development time, and build secure, performant apps quickly and cost-effectively.

**Key features of SurrealDB include:**

- **Reduces development time**: SurrealDB simplifies your database and API stack by removing the need for most server-side components, allowing you to build secure, performant apps faster and cheaper.
- **Real-time collaborative API backend service:** SurrealDB functions as both a database and an API backend service, enabling real-time collaboration.
- **Support for multiple querying languages:** SurrealDB supports SQL querying from client devices, GraphQL, ACID transactions, WebSocket connections, structured and unstructured data, graph querying, full-text indexing, and geospatial querying.
- **Granular access control**: SurrealDB provides row-level permissions-based access control, giving you the ability to manage data access with precision.

View the [features](https://surrealdb.com/features), the latest [releases](https://surrealdb.com/releases), and [documentation](https://surrealdb.com/docs).

<img width="100%" src="https://github.com/surrealdb/surrealdb/blob/main/img/interface.png" alt="Surrealist">

<h2><img height="20" src="https://github.com/surrealdb/surrealdb/blob/main/img/features.svg?raw=true">&nbsp;&nbsp;Features</h2>

- [x] Database server, or embedded library
- [x] Multi-row, multi-table ACID transactions
- [x] Single-node, or highly-scalable distributed mode
- [x] Record links and directed typed graph connections
- [x] Store structured and unstructured data
- [x] Incrementally computed views for pre-computed advanced analytics
- [x] Realtime-api layer, and security permissions built in
- [x] Store and model data in any way with tables, documents, and graph
- [x] Simple schema definition for frontend and backend development
- [x] Connect and query directly from web-browsers and client devices
- [x] Use embedded JavaScript functions for custom advanced functionality

<h2><img height="20" src="https://github.com/surrealdb/surrealdb/blob/main/img/documentation.svg?raw=true">&nbsp;&nbsp;Documentation</h2>

For guidance on installation, development, deployment, and administration, take a look at the following resources:

- Documentation: https://surrealdb.com/docs
- SurrealDB University: https://surrealdb.com/learn/fundamentals
- Aeon's Surreal Renaissance (interative book): https://surrealdb.com/learn/book

<h2><img height="20" src="https://github.com/surrealdb/surrealdb/blob/main/img/cloud.svg?raw=true">&nbsp;&nbsp;Surreal Cloud</h2>
	
<a href="https://surrealdb.com/cloud" target="_blank">
    <img width="100%" src="https://github.com/surrealdb/surrealdb/blob/main/img/black/cloud.png" alt="Surreal Cloud">
</a>

SurrealDB is available as a [hosted platform](https://surrealist.app/cloud). Forget about infrastructure operations, monitoring, backups or capacity planning. [Surreal Cloud](https://surrealdb.com/cloud) allows you to focus on building great products using the power and flexibility of SurrealDB in just a few clicks. Grow from prototype to enterprise-scale. The Surreal Cloud scalable architecture allows your database to evolve as your application grows, ensuring you are always ahead of demand. However if you want to deploy SurrealDB yourself, keep reading below.

<h2><img height="20" src="https://github.com/surrealdb/surrealdb/blob/main/img/installation.svg?raw=true">&nbsp;&nbsp;Installation</h2>

SurrealDB is designed to be simple to install and simple to run - using just one command from your terminal. In addition to traditional installation, SurrealDB can be installed and run with HomeBrew, Docker, or using any other container orchestration tool such as Docker Compose, Docker Swarm, Rancher, or in Kubernetes.

<h4>
    <img width="20" src="https://github.com/surrealdb/surrealdb/blob/main/img/apple.svg?raw=true">
    &nbsp; Install on macOS
</h4>

The quickest way to get going with SurrealDB on macOS is to use Homebrew. This will install both the command-line tools, and the SurrealDB server as a single executable. If you don't use Homebrew, follow the instructions for Linux below to install SurrealDB.

```bash
brew install surrealdb/tap/surreal
```

<h4>
    <img width="20" src="https://github.com/surrealdb/surrealdb/blob/main/img/linux.svg?raw=true">
    &nbsp; Install on Linux
</h4>

The easiest and preferred way to get going with SurrealDB on Unix operating systems is to install and use the SurrealDB command-line tool. Run the following command in your terminal and follow the on-screen instructions.

```bash
curl -sSf https://install.surrealdb.com | sh
```

<h4>
    <img width="20" src="https://github.com/surrealdb/surrealdb/blob/main/img/windows.svg?raw=true">
    &nbsp; Install on Windows
</h4>

The easiest and preferred way to get going with SurrealDB on Windows is to install and use the SurrealDB command-line tool. Run the following command in your terminal and follow the on-screen instructions.

```bash
iwr https://install.surrealdb.com -useb | iex
```

<h4>
    <img width="20" src="https://github.com/surrealdb/surrealdb/blob/main/img/docker.svg?raw=true">
    &nbsp; Run using Docker
</h4>

Docker can be used to manage and run SurrealDB database instances without the need to install any command-line tools. The SurrealDB docker container contains the full command-line tools for importing and exporting data from a running server, or for running a server itself.

```bash
docker run --rm -p 8000:8000 surrealdb/surrealdb:latest start
```

Update the image to the latest version:

```bash
docker pull surrealdb/surrealdb:latest
```

<h2><img height="20" src="https://github.com/surrealdb/surrealdb/blob/main/img/gettingstarted.svg?raw=true">&nbsp;&nbsp;Getting started</h2>

Getting started with SurrealDB is as easy as starting up the SurrealDB database server, choosing your platform, and integrating its SDK into your code. You can easily get started with your platform of choice by reading one of our tutorials.

**Client side apps**

- [x] [Getting started with Javascript](https://surrealdb.com/docs/integration/libraries/javascript)
- [x] [Getting started with WebAssembly](https://surrealdb.com/docs/integration/libraries/webassembly)
- [x] [Getting started with Ember.js](https://surrealdb.com/docs/integration/libraries/emberjs)
- [ ] [Getting started with React.js](https://surrealdb.com/docs/integration/libraries/reactjs)
- [ ] [Getting started with Angular.js](https://surrealdb.com/docs/integration/libraries/angularjs)
- [ ] [Getting started with Vue.js](https://surrealdb.com/docs/integration/libraries/vuejs)
- [ ] [Getting started with Apollo GraphQL](https://surrealdb.com/docs/integration/libraries/apollo)

**Server side code**

- [x] [Getting started with Javascript](https://surrealdb.com/docs/integration/libraries/javascript)
- [x] [Getting started with Node.js](https://surrealdb.com/docs/integration/libraries/nodejs)
- [x] [Getting started with Golang](https://surrealdb.com/docs/integration/libraries/golang)
- [x] [Getting started with Rust](https://surrealdb.com/docs/integration/libraries/rust)
- [x] [Getting started with Deno](https://surrealdb.com/docs/integration/libraries/deno)
- [ ] [Getting started with Python](https://surrealdb.com/docs/integration/libraries/python) (coming soon)
- [ ] [Getting started with C](https://surrealdb.com/docs/integration/libraries/c) (coming soon)
- [ ] [Getting started with Java](https://surrealdb.com/docs/integration/libraries/java) (coming soon)
- [ ] [Getting started with Ruby](https://surrealdb.com/docs/integration/libraries/ruby) (coming soon)
- [ ] [Getting started with PHP](https://surrealdb.com/docs/integration/libraries/php) (coming soon)
- [ ] [Getting started with Swift](https://surrealdb.com/docs/integration/libraries/swift) (coming soon)
- [ ] [Getting started with R](https://surrealdb.com/docs/integration/libraries/r) (coming soon)

<h2><img height="20" src="https://github.com/surrealdb/surrealdb/blob/main/img/features.svg?raw=true">&nbsp;&nbsp;Quick look</h2>

With strongly-typed data types, data can be fully modelled right in the database.

```sql
UPDATE person SET
	waist = <int> "34.59",
	height = <float> 201,
	score = <decimal> 0.3 + 0.3 + 0.3 + 0.1
;
```

Easily work with unstructured or structured data, in schema-less or schema-full mode.

```sql
-- Create a schemafull table
DEFINE TABLE user SCHEMAFULL;

-- Specify fields on the user table
DEFINE FIELD name ON TABLE user TYPE object;
DEFINE FIELD name.first ON TABLE user TYPE string;
DEFINE FIELD name.last ON TABLE user TYPE string;
DEFINE FIELD email ON TABLE user TYPE string ASSERT string::is_email($value);

-- Add a unique index on the email field preventing duplicate values
DEFINE INDEX email ON TABLE user COLUMNS email UNIQUE;

-- Create a new event whenever a user changes their email address
DEFINE EVENT email ON TABLE user WHEN $before.email != $after.email THEN (
	CREATE event SET user = $this, time = time::now(), value = $after.email, action = 'email_changed'
);
```

Connect records together with fully directed graph edge connections.

```sql
-- Add a graph edge between user:tobie and article:surreal
RELATE user:tobie->write->article:surreal
	SET time.written = time::now()
;

-- Add a graph edge between specific users and developers
LET $from = (SELECT users FROM company:surrealdb);
LET $devs = (SELECT * FROM user WHERE tags CONTAINS 'developer');
RELATE $from->like->$devs UNIQUE
	SET time.connected = time::now()
;
```

Query data flexibly with advanced expressions and graph queries.

```sql
-- Select a nested array, and filter based on an attribute
SELECT emails[WHERE active = true] FROM person;

-- Select all 1st, 2nd, and 3rd level people who this specific person record knows, or likes, as separate outputs
SELECT ->knows->(? AS f1)->knows->(? AS f2)->(knows, likes AS e3 WHERE influencer = true)->(? AS f3) FROM person:tobie;

-- Select all person records (and their recipients), who have sent more than 5 emails
SELECT *, ->sent->email->to->person FROM person WHERE count(->sent->email) > 5;

-- Select other products purchased by people who purchased this laptop
SELECT <-purchased<-person->purchased->product FROM product:laptop;

-- Select products purchased by people in the last 3 weeks who have purchased the same products that we purchased
SELECT ->purchased->product<-purchased<-person->(purchased WHERE created_at > time::now() - 3w)->product FROM person:tobie;
```

Store GeoJSON geographical data types, including points, lines and polygons.

```sql
UPDATE city:london SET
	centre = (-0.118092, 51.509865),
	boundary = {
		type: "Polygon",
		coordinates: [[
			[-0.38314819, 51.37692386], [0.1785278, 51.37692386],
			[0.1785278, 51.61460570], [-0.38314819, 51.61460570],
			[-0.38314819, 51.37692386]
		]]
	}
;
```

Write custom embedded logic using JavaScript functions.

```sql
CREATE film SET
	ratings = [
		{ rating: 6, user: user:bt8e39uh1ouhfm8ko8s0 },
		{ rating: 8, user: user:bsilfhu88j04rgs0ga70 },
	],
	featured = function() {
		return this.ratings.filter(r => {
			return r.rating >= 7;
		}).map(r => {
			return { ...r, rating: r.rating * 10 };
		});
	}
;
```

Specify granular access permissions for client and application access.

```sql
-- Specify access permissions for the 'post' table
DEFINE TABLE post SCHEMALESS
	PERMISSIONS
		FOR select
			-- Published posts can be selected
			WHERE published = true
			-- A user can select all their own posts
			OR user = $auth.id
		FOR create, update
			-- A user can create or update their own posts
			WHERE user = $auth.id
		FOR delete
			-- A user can delete their own posts
			WHERE user = $auth.id
			-- Or an admin can delete any posts
			OR $auth.admin = true
;
```

<h2><img height="20" src="https://github.com/surrealdb/surrealdb/blob/main/img/community.svg?raw=true">&nbsp;&nbsp;Community</h2>

Join our growing community around the world, for help, ideas, and discussions regarding SurrealDB.

- View our official [Blog](https://surrealdb.com/blog)
- Follow us on [X](https://x.com/surrealdb)
- Connect with us on [LinkedIn](https://www.linkedin.com/company/surrealdb/)
- Visit us on [YouTube](https://www.youtube.com/@surrealdb)
- Join our [Dev community](https://dev.to/surrealdb)
- Chat live with us on [Discord](https://surrealdb.com/discord)
- Questions tagged #surrealdb on [Stack Overflow](https://stackoverflow.com/questions/tagged/surrealdb)

<h2><img height="20" src="https://github.com/surrealdb/surrealdb/blob/main/img/contributing.svg?raw=true">&nbsp;&nbsp;Contributing</h2>

We would &nbsp;<img width="15" src="https://github.com/surrealdb/surrealdb/blob/main/img/love.svg?raw=true">&nbsp; for you to get involved with SurrealDB development! If you wish to help, you can learn more about how you can contribute to this project in the [contribution guide](../CONTRIBUTING.md).

<h2><img height="20" src="https://github.com/surrealdb/surrealdb/blob/main/img/security.svg?raw=true">&nbsp;&nbsp;Security</h2>

For security issues, kindly email us at [security@surrealdb.com](mailto:security@surrealdb.com) instead of posting a public issue on GitHub.

<h2><img height="20" src="https://github.com/surrealdb/surrealdb/blob/main/img/license.svg?raw=true">&nbsp;&nbsp;License</h2>

Source code for SurrealDB is variously licensed under a number of different licenses. A copy of each license can be found in [each repository](https://github.com/surrealdb).

- Libraries and SDKs, each located in its own distinct repository, are released under either the [Apache License 2.0](https://github.com/surrealdb/license/blob/main/APL.txt) or [MIT License](https://github.com/surrealdb/license/blob/main/MIT.txt).
- Certain core database components, each located in its own distinct repository, are released under the [Apache License 2.0](https://github.com/surrealdb/license/blob/main/APL.txt).
- Core database code for SurrealDB, located in [this repository](https://github.com/surrealdb/surrealdb), is released under the [Business Source License 1.1](/LICENSE).

For more information, see the [licensing information](https://github.com/surrealdb/license).
