//! v3_0_0.rs - Generated file, DO NOT EDIT
//! Catalog compatibility fixtures for SurrealDB 3.0.0
//!
//! These fixtures represent the exact serialization format used in
//! SurrealDB 3.0.0. They must NEVER be modified after being committed.
//! If deserialization of any fixture fails, it indicates a backwards
//! compatibility regression.

// ======================================================================
// AccessDefinition
// ======================================================================

/// AccessDefinition: bearer access with JWT
pub const ACCESS_BEARER: &[u8] = &[
    0x01, 0x0a, 0x61, 0x70, 0x69, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73,
    0x01, 0x02, 0x01, 0x01, 0x00, 0x01, 0x00, 0x01, 0x01, 0x00, 0x01, 0x01,
    0x00, 0x0a, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x6b, 0x65, 0x79,
    0x01, 0x01, 0x01, 0x06, 0x0a, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x5f,
    0x6b, 0x65, 0x79, 0x01, 0x00, 0x00, 0x01, 0xfb, 0x10, 0x0e, 0x00, 0x01,
    0xfb, 0x84, 0x03, 0x00, 0x01, 0xfc, 0x80, 0x51, 0x01, 0x00, 0x00, 0x01,
    0x0a, 0x41, 0x50, 0x49, 0x20, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73
];
/// AccessDefinition: access with custom authenticate expression
pub const ACCESS_WITH_AUTHENTICATE: &[u8] = &[
    0x01, 0x0b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x61, 0x75, 0x74,
    0x68, 0x01, 0x02, 0x01, 0x01, 0x00, 0x01, 0x01, 0x01, 0x01, 0x00, 0x01,
    0x01, 0x04, 0x06, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x00, 0x01, 0x02,
    0x01, 0x28, 0x27, 0x53, 0x45, 0x4c, 0x45, 0x43, 0x54, 0x20, 0x2a, 0x20,
    0x46, 0x52, 0x4f, 0x4d, 0x20, 0x75, 0x73, 0x65, 0x72, 0x20, 0x57, 0x48,
    0x45, 0x52, 0x45, 0x20, 0x69, 0x64, 0x20, 0x3d, 0x20, 0x24, 0x61, 0x75,
    0x74, 0x68, 0x2e, 0x69, 0x64, 0x27, 0x00, 0x01, 0xfb, 0x10, 0x0e, 0x00,
    0x00, 0x00
];

// ======================================================================
// AccessGrant
// ======================================================================

/// AccessGrant: JWT access grant
pub const GRANT_JWT: &[u8] = &[
    0x01, 0x09, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x5f, 0x30, 0x30, 0x31, 0x0a,
    0x61, 0x70, 0x69, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x01, 0xfd,
    0xff, 0x23, 0xe4, 0x19, 0x29, 0x0f, 0x00, 0x00, 0x00, 0x01, 0x01, 0xfd,
    0xff, 0x23, 0xe4, 0x19, 0x29, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01,
    0x05, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x01, 0x24, 0x65, 0x79, 0x4a, 0x68, 0x62, 0x47, 0x63, 0x69, 0x4f,
    0x69, 0x4a, 0x49, 0x55, 0x7a, 0x49, 0x31, 0x4e, 0x69, 0x49, 0x73, 0x49,
    0x6e, 0x52, 0x35, 0x63, 0x43, 0x49, 0x36, 0x49, 0x6b, 0x70, 0x58, 0x56,
    0x43, 0x4a, 0x39
];
/// AccessGrant: revoked access grant
pub const GRANT_REVOKED: &[u8] = &[
    0x01, 0x09, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x5f, 0x30, 0x30, 0x32, 0x0a,
    0x61, 0x70, 0x69, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x01, 0xfd,
    0xff, 0x23, 0xe4, 0x19, 0x29, 0x0f, 0x00, 0x00, 0x00, 0x01, 0x01, 0xfd,
    0xff, 0x23, 0xe4, 0x19, 0x29, 0x0f, 0x00, 0x00, 0x00, 0x01, 0x01, 0xfd,
    0xff, 0x23, 0xe4, 0x19, 0x29, 0x0f, 0x00, 0x00, 0x00, 0x01, 0x01, 0x04,
    0x75, 0x73, 0x65, 0x72, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
];

// ======================================================================
// AnalyzerDefinition
// ======================================================================

/// AnalyzerDefinition: minimal analyzer
pub const ANALYZER_BASIC: &[u8] = &[
    0x01, 0x06, 0x73, 0x69, 0x6d, 0x70, 0x6c, 0x65, 0x00, 0x00, 0x00, 0x00
];
/// AnalyzerDefinition: analyzer with tokenizers and filters
pub const ANALYZER_WITH_TOKENIZERS: &[u8] = &[
    0x01, 0x07, 0x65, 0x6e, 0x67, 0x6c, 0x69, 0x73, 0x68, 0x01, 0x13, 0x66,
    0x6e, 0x3a, 0x3a, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x61, 0x6e,
    0x61, 0x6c, 0x79, 0x7a, 0x65, 0x72, 0x01, 0x02, 0x01, 0x01, 0x01, 0x02,
    0x01, 0x02, 0x01, 0x00, 0x01, 0x02, 0x01, 0x15, 0x45, 0x6e, 0x67, 0x6c,
    0x69, 0x73, 0x68, 0x20, 0x74, 0x65, 0x78, 0x74, 0x20, 0x61, 0x6e, 0x61,
    0x6c, 0x79, 0x7a, 0x65, 0x72
];

// ======================================================================
// ApiActionDefinition
// ======================================================================

/// ApiActionDefinition: minimal API action definition
pub const API_ACTION_BASIC: &[u8] = &[
    0x01, 0x01, 0x01, 0x01, 0x15, 0x27, 0x53, 0x45, 0x4c, 0x45, 0x43, 0x54,
    0x20, 0x2a, 0x20, 0x46, 0x52, 0x4f, 0x4d, 0x20, 0x75, 0x73, 0x65, 0x72,
    0x73, 0x27, 0x01, 0x00, 0x01, 0x01
];
/// ApiActionDefinition: API action with multiple methods
pub const API_ACTION_MULTI_METHOD: &[u8] = &[
    0x01, 0x03, 0x01, 0x01, 0x01, 0x03, 0x01, 0x04, 0x1c, 0x27, 0x43, 0x52,
    0x45, 0x41, 0x54, 0x45, 0x20, 0x75, 0x73, 0x65, 0x72, 0x73, 0x20, 0x43,
    0x4f, 0x4e, 0x54, 0x45, 0x4e, 0x54, 0x20, 0x24, 0x62, 0x6f, 0x64, 0x79,
    0x27, 0x01, 0x00, 0x01, 0x01
];

// ======================================================================
// ApiDefinition
// ======================================================================

/// ApiDefinition: minimal API endpoint
pub const API_BASIC: &[u8] = &[
    0x01, 0x0d, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x76, 0x31, 0x2f, 0x75, 0x73,
    0x65, 0x72, 0x73, 0x01, 0x01, 0x01, 0x01, 0x01, 0x15, 0x27, 0x53, 0x45,
    0x4c, 0x45, 0x43, 0x54, 0x20, 0x2a, 0x20, 0x46, 0x52, 0x4f, 0x4d, 0x20,
    0x75, 0x73, 0x65, 0x72, 0x73, 0x27, 0x01, 0x00, 0x01, 0x01, 0x00, 0x01,
    0x00, 0x01, 0x01, 0x00
];
/// ApiDefinition: API with middleware and multiple methods
pub const API_WITH_MIDDLEWARE: &[u8] = &[
    0x01, 0x0e, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x76, 0x31, 0x2f, 0x6f, 0x72,
    0x64, 0x65, 0x72, 0x73, 0x02, 0x01, 0x02, 0x01, 0x01, 0x01, 0x03, 0x16,
    0x27, 0x53, 0x45, 0x4c, 0x45, 0x43, 0x54, 0x20, 0x2a, 0x20, 0x46, 0x52,
    0x4f, 0x4d, 0x20, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x73, 0x27, 0x01, 0x00,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x14, 0x27, 0x44, 0x45, 0x4c, 0x45,
    0x54, 0x45, 0x20, 0x46, 0x52, 0x4f, 0x4d, 0x20, 0x6f, 0x72, 0x64, 0x65,
    0x72, 0x73, 0x27, 0x01, 0x00, 0x01, 0x01, 0x01, 0x0c, 0x27, 0x52, 0x45,
    0x54, 0x55, 0x52, 0x4e, 0x20, 0x34, 0x30, 0x34, 0x27, 0x01, 0x02, 0x01,
    0x04, 0x61, 0x75, 0x74, 0x68, 0x00, 0x01, 0x0a, 0x72, 0x61, 0x74, 0x65,
    0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x01, 0x01, 0x03, 0x01, 0x00, 0xc8,
    0x01, 0x01, 0x01, 0x14, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x20, 0x6d, 0x61,
    0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x20, 0x41, 0x50, 0x49
];

// ======================================================================
// Appending
// ======================================================================

/// Appending: appending with None values
pub const APPENDING_NONE: &[u8] = &[
    0x01, 0x00, 0x00, 0x01, 0x00, 0xf6
];
/// Appending: appending with old values
pub const APPENDING_OLD_VALUES: &[u8] = &[
    0x01, 0x01, 0x01, 0x01, 0x04, 0x09, 0x6f, 0x6c, 0x64, 0x20, 0x76, 0x61,
    0x6c, 0x75, 0x65, 0x00, 0x01, 0x00, 0xf6
];
/// Appending: appending with new values
pub const APPENDING_NEW_VALUES: &[u8] = &[
    0x01, 0x00, 0x01, 0x01, 0x01, 0x04, 0x09, 0x6e, 0x65, 0x77, 0x20, 0x76,
    0x61, 0x6c, 0x75, 0x65, 0x01, 0x00, 0xf6
];
/// Appending: appending with both old and new values
pub const APPENDING_BOTH: &[u8] = &[
    0x01, 0x01, 0x01, 0x01, 0x04, 0x09, 0x6f, 0x6c, 0x64, 0x20, 0x76, 0x61,
    0x6c, 0x75, 0x65, 0x01, 0x01, 0x01, 0x04, 0x09, 0x6e, 0x65, 0x77, 0x20,
    0x76, 0x61, 0x6c, 0x75, 0x65, 0x01, 0x00, 0xf6
];

// ======================================================================
// BatchValue
// ======================================================================

/// BatchValue: batch value with number value
pub const BATCH_VALUE_BASIC: &[u8] = &[
    0x01, 0xf6, 0x12, 0x3e, 0x45, 0x67, 0xe8, 0x9b, 0x12, 0xd3, 0xa4, 0x56,
    0x42, 0x66, 0x14, 0x17, 0x40, 0x00
];

// ======================================================================
// BucketDefinition
// ======================================================================

/// BucketDefinition: minimal bucket
pub const BUCKET_BASIC: &[u8] = &[
    0x01, 0x00, 0x07, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x00, 0x01,
    0x01, 0x00, 0x00
];
/// BucketDefinition: readonly bucket with backend
pub const BUCKET_READONLY: &[u8] = &[
    0x01, 0x01, 0x01, 0x7b, 0x08, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65,
    0x73, 0x01, 0x14, 0x73, 0x33, 0x3a, 0x2f, 0x2f, 0x62, 0x75, 0x63, 0x6b,
    0x65, 0x74, 0x2f, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x73, 0x01,
    0x00, 0x01, 0x01, 0x19, 0x52, 0x65, 0x61, 0x64, 0x2d, 0x6f, 0x6e, 0x6c,
    0x79, 0x20, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x20, 0x73, 0x74,
    0x6f, 0x72, 0x61, 0x67, 0x65
];

// ======================================================================
// ConfigDefinition
// ======================================================================

/// ConfigDefinition: GraphQL configuration
pub const CONFIG_GRAPHQL: &[u8] = &[
    0x01, 0x01, 0x01, 0x01, 0x00, 0x01, 0x00
];

// ======================================================================
// DatabaseDefinition
// ======================================================================

/// DatabaseDefinition: minimal database without changefeed
pub const DATABASE_BASIC: &[u8] = &[
    0x01, 0x01, 0x01, 0x04, 0x74, 0x65, 0x73, 0x74, 0x00, 0x00, 0x00
];
/// DatabaseDefinition: database with changefeed enabled
pub const DATABASE_WITH_CHANGEFEED: &[u8] = &[
    0x01, 0x7b, 0xfb, 0xc8, 0x01, 0x06, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73,
    0x01, 0x0b, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x20, 0x73, 0x74, 0x6f, 0x72,
    0x65, 0x01, 0x01, 0xfb, 0x10, 0x0e, 0x00, 0x01, 0x00
];
/// DatabaseDefinition: database with strict mode enabled
pub const DATABASE_STRICT: &[u8] = &[
    0x01, 0x01, 0x02, 0x09, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x5f, 0x64,
    0x62, 0x01, 0x14, 0x53, 0x74, 0x72, 0x69, 0x63, 0x74, 0x20, 0x6d, 0x6f,
    0x64, 0x65, 0x20, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x00,
    0x01
];

// ======================================================================
// DocLengthAndCount
// ======================================================================

/// DocLengthAndCount: document length and count
pub const DOC_LENGTH_AND_COUNT_BASIC: &[u8] = &[
    0x01, 0xf6, 0xfb, 0x90, 0x03
];

// ======================================================================
// EventDefinition
// ======================================================================

/// EventDefinition: table event trigger
pub const EVENT_BASIC: &[u8] = &[
    0x01, 0x09, 0x6f, 0x6e, 0x5f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x05,
    0x75, 0x73, 0x65, 0x72, 0x73, 0x13, 0x22, 0x24, 0x65, 0x76, 0x65, 0x6e,
    0x74, 0x20, 0x3d, 0x20, 0x27, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x27,
    0x22, 0x01, 0x24, 0x22, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x20, 0x61,
    0x75, 0x64, 0x69, 0x74, 0x20, 0x53, 0x45, 0x54, 0x20, 0x61, 0x63, 0x74,
    0x69, 0x6f, 0x6e, 0x20, 0x3d, 0x20, 0x27, 0x63, 0x72, 0x65, 0x61, 0x74,
    0x65, 0x27, 0x22, 0x01, 0x13, 0x41, 0x75, 0x64, 0x69, 0x74, 0x20, 0x6c,
    0x6f, 0x67, 0x20, 0x6f, 0x6e, 0x20, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65
];

// ======================================================================
// FieldDefinition
// ======================================================================

/// FieldDefinition: minimal field
pub const FIELD_BASIC: &[u8] = &[
    0x01, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x05, 0x75, 0x73, 0x65, 0x72, 0x73,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x00, 0x00
];
/// FieldDefinition: field with type constraint and default
pub const FIELD_WITH_TYPE: &[u8] = &[
    0x01, 0x05, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x05, 0x75, 0x73, 0x65, 0x72,
    0x73, 0x01, 0x01, 0x0c, 0x00, 0x00, 0x01, 0x1b, 0x27, 0x73, 0x74, 0x72,
    0x69, 0x6e, 0x67, 0x3a, 0x3a, 0x6c, 0x6f, 0x77, 0x65, 0x72, 0x63, 0x61,
    0x73, 0x65, 0x28, 0x24, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x29, 0x27, 0x01,
    0x1b, 0x27, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x3a, 0x3a, 0x69, 0x73,
    0x3a, 0x3a, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x28, 0x24, 0x76, 0x61, 0x6c,
    0x75, 0x65, 0x29, 0x27, 0x00, 0x01, 0x01, 0x02, 0x27, 0x27, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x12, 0x55, 0x73, 0x65, 0x72, 0x20, 0x65,
    0x6d, 0x61, 0x69, 0x6c, 0x20, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73,
    0x00
];
/// FieldDefinition: readonly computed field
pub const FIELD_READONLY: &[u8] = &[
    0x01, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74,
    0x05, 0x75, 0x73, 0x65, 0x72, 0x73, 0x01, 0x01, 0x05, 0x00, 0x01, 0x00,
    0x00, 0x01, 0x0d, 0x27, 0x74, 0x69, 0x6d, 0x65, 0x3a, 0x3a, 0x6e, 0x6f,
    0x77, 0x28, 0x29, 0x27, 0x01, 0x00, 0x01, 0x01, 0x01, 0x00, 0x01, 0x00,
    0x01, 0x19, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x20, 0x63, 0x72, 0x65,
    0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
    0x61, 0x6d, 0x70, 0x00
];

// ======================================================================
// FunctionDefinition
// ======================================================================

/// FunctionDefinition: simple function
pub const FUNCTION_BASIC: &[u8] = &[
    0x01, 0x05, 0x67, 0x72, 0x65, 0x65, 0x74, 0x00, 0x1c, 0x7b, 0x20, 0x22,
    0x52, 0x45, 0x54, 0x55, 0x52, 0x4e, 0x20, 0x27, 0x48, 0x65, 0x6c, 0x6c,
    0x6f, 0x2c, 0x20, 0x57, 0x6f, 0x72, 0x6c, 0x64, 0x21, 0x27, 0x22, 0x20,
    0x7d, 0x00, 0x01, 0x01, 0x00
];
/// FunctionDefinition: function with arguments and return type
pub const FUNCTION_WITH_ARGS: &[u8] = &[
    0x01, 0x0b, 0x61, 0x64, 0x64, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72,
    0x73, 0x02, 0x01, 0x61, 0x01, 0x0a, 0x01, 0x62, 0x01, 0x0a, 0x14, 0x7b,
    0x20, 0x27, 0x52, 0x45, 0x54, 0x55, 0x52, 0x4e, 0x20, 0x24, 0x61, 0x20,
    0x2b, 0x20, 0x24, 0x62, 0x27, 0x20, 0x7d, 0x01, 0x0f, 0x41, 0x64, 0x64,
    0x20, 0x74, 0x77, 0x6f, 0x20, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x73,
    0x01, 0x01, 0x01, 0x01, 0x0a
];

// ======================================================================
// ID Types
// ======================================================================

/// ID Types: IndexId fixture
pub const INDEX_ID_BASIC: &[u8] = &[
    0x2a
];
/// ID Types: DatabaseId fixture
pub const DATABASE_ID_BASIC: &[u8] = &[
    0x7b
];
/// ID Types: NamespaceId fixture
pub const NAMESPACE_ID_BASIC: &[u8] = &[
    0xfb, 0xc8, 0x01
];
/// ID Types: TableId fixture
pub const TABLE_ID_BASIC: &[u8] = &[
    0xfb, 0x15, 0x03
];

// ======================================================================
// IndexDefinition
// ======================================================================

/// IndexDefinition: basic index
pub const INDEX_BASIC: &[u8] = &[
    0x01, 0x01, 0x08, 0x69, 0x64, 0x78, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x05,
    0x75, 0x73, 0x65, 0x72, 0x73, 0x01, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x01,
    0x00, 0x00, 0x00
];
/// IndexDefinition: unique index on multiple columns
pub const INDEX_UNIQUE: &[u8] = &[
    0x01, 0x02, 0x10, 0x69, 0x64, 0x78, 0x5f, 0x65, 0x6d, 0x61, 0x69, 0x6c,
    0x5f, 0x75, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x05, 0x75, 0x73, 0x65, 0x72,
    0x73, 0x01, 0x05, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x01, 0x01, 0x01, 0x17,
    0x55, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x20, 0x65, 0x6d, 0x61, 0x69, 0x6c,
    0x20, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x00
];

// ======================================================================
// MlModelDefinition
// ======================================================================

/// MlModelDefinition: ML model definition
pub const MODEL_BASIC: &[u8] = &[
    0x01, 0x13, 0x73, 0x68, 0x61, 0x32, 0x35, 0x36, 0x3a, 0x61, 0x62, 0x63,
    0x31, 0x32, 0x33, 0x64, 0x65, 0x66, 0x34, 0x35, 0x36, 0x09, 0x73, 0x65,
    0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x05, 0x31, 0x2e, 0x30, 0x2e,
    0x30, 0x01, 0x18, 0x53, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74,
    0x20, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x20, 0x6d, 0x6f,
    0x64, 0x65, 0x6c, 0x01, 0x01
];

// ======================================================================
// ModuleDefinition
// ======================================================================

/// ModuleDefinition: module with Surrealism executable
pub const MODULE_SURREALISM: &[u8] = &[
    0x01, 0x01, 0x09, 0x6d, 0x79, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
    0x01, 0x0d, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x20, 0x6d, 0x6f, 0x64,
    0x75, 0x6c, 0x65, 0x01, 0x01, 0x01, 0x00, 0x01, 0x09, 0x6d, 0x79, 0x5f,
    0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x0a, 0x6d, 0x6f, 0x64, 0x75, 0x6c,
    0x65, 0x5f, 0x6b, 0x65, 0x79
];
/// ModuleDefinition: module with Silo executable
pub const MODULE_SILO: &[u8] = &[
    0x01, 0x01, 0x0b, 0x73, 0x69, 0x6c, 0x6f, 0x5f, 0x6d, 0x6f, 0x64, 0x75,
    0x6c, 0x65, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x03, 0x6f, 0x72, 0x67,
    0x03, 0x70, 0x6b, 0x67, 0x01, 0x02, 0x03
];

// ======================================================================
// NamespaceDefinition
// ======================================================================

/// NamespaceDefinition: minimal namespace without comment
pub const NAMESPACE_BASIC: &[u8] = &[
    0x01, 0x01, 0x04, 0x74, 0x65, 0x73, 0x74, 0x00
];
/// NamespaceDefinition: namespace with optional comment
pub const NAMESPACE_WITH_COMMENT: &[u8] = &[
    0x01, 0x7b, 0x0a, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x69, 0x6f,
    0x6e, 0x01, 0x14, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x69, 0x6f,
    0x6e, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65
];

// ======================================================================
// Node
// ======================================================================

/// Node: active node
pub const NODE_ACTIVE: &[u8] = &[
    0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xfc, 0xd2, 0x02, 0x96, 0x49, 0x00
];
/// Node: archived node
pub const NODE_ARCHIVED: &[u8] = &[
    0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xfd, 0xea, 0x16, 0xb0, 0x4c, 0x02,
    0x00, 0x00, 0x00, 0x01
];

// ======================================================================
// NodeLiveQuery
// ======================================================================

/// NodeLiveQuery: minimal node live query
pub const NODE_LIVE_QUERY_BASIC: &[u8] = &[
    0x01, 0x01, 0x02, 0x05, 0x75, 0x73, 0x65, 0x72, 0x73
];

// ======================================================================
// ParamDefinition
// ======================================================================

/// ParamDefinition: boolean parameter
pub const PARAM_BOOL: &[u8] = &[
    0x01, 0x05, 0x64, 0x65, 0x62, 0x75, 0x67, 0x01, 0x02, 0x01, 0x01, 0x0f,
    0x44, 0x65, 0x62, 0x75, 0x67, 0x20, 0x6d, 0x6f, 0x64, 0x65, 0x20, 0x66,
    0x6c, 0x61, 0x67, 0x01, 0x01
];
/// ParamDefinition: string parameter
pub const PARAM_STRING: &[u8] = &[
    0x01, 0x08, 0x61, 0x70, 0x70, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x01, 0x04,
    0x05, 0x4d, 0x79, 0x41, 0x70, 0x70, 0x00, 0x01, 0x01
];

// ======================================================================
// PrimaryAppending
// ======================================================================

/// PrimaryAppending: primary appending with number value
pub const PRIMARY_APPENDING_BASIC: &[u8] = &[
    0x01, 0x7b
];

// ======================================================================
// Record
// ======================================================================

/// Record: record with None value
pub const RECORD_NONE: &[u8] = &[
    0x01, 0x00, 0x01, 0x00
];
/// Record: record with Null value
pub const RECORD_NULL: &[u8] = &[
    0x01, 0x00, 0x01, 0x01
];
/// Record: record with boolean data
pub const RECORD_BOOL: &[u8] = &[
    0x01, 0x00, 0x01, 0x02, 0x01
];
/// Record: record with int number data
pub const RECORD_NUMBER_INT: &[u8] = &[
    0x01, 0x00, 0x01, 0x03, 0x01, 0x00, 0x54
];
/// Record: record with float number data
pub const RECORD_NUMBER_FLOAT: &[u8] = &[
    0x01, 0x00, 0x01, 0x03, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x45, 0x40
];
/// Record: record with decimal number data
pub const RECORD_NUMBER_DECIMAL: &[u8] = &[
    0x01, 0x00, 0x01, 0x03, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
];
/// Record: record with string data
pub const RECORD_STRING: &[u8] = &[
    0x01, 0x00, 0x01, 0x04, 0x09, 0x74, 0x65, 0x73, 0x74, 0x20, 0x64, 0x61,
    0x74, 0x61
];
/// Record: record with bytes data
pub const RECORD_BYTES: &[u8] = &[
    0x01, 0x00, 0x01, 0x0c, 0x01, 0x04, 0x01, 0x02, 0x03, 0x04
];
/// Record: record with duration data
pub const RECORD_DURATION: &[u8] = &[
    0x01, 0x00, 0x01, 0x05, 0x01, 0xfb, 0x10, 0x0e, 0x00
];
/// Record: record with datetime data
pub const RECORD_DATETIME: &[u8] = &[
    0x01, 0x00, 0x01, 0x06, 0x01, 0xfd, 0xff, 0x23, 0xe4, 0x19, 0x29, 0x0f,
    0x00, 0x00, 0x00
];
/// Record: record with UUID data
pub const RECORD_UUID: &[u8] = &[
    0x01, 0x00, 0x01, 0x07, 0x01, 0x12, 0x3e, 0x45, 0x67, 0xe8, 0x9b, 0x12,
    0xd3, 0xa4, 0x56, 0x42, 0x66, 0x14, 0x17, 0x40, 0x00
];
/// Record: record with geometry data (point)
pub const RECORD_GEOMETRY_POINT: &[u8] = &[
    0x01, 0x00, 0x01, 0x0b, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xf0, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40
];
/// Record: record with geometry data (line)
pub const RECORD_GEOMETRY_LINE: &[u8] = &[
    0x01, 0x00, 0x01, 0x0b, 0x01, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0xf0, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x10, 0x40
];
/// Record: record with geometry data (polygon)
pub const RECORD_GEOMETRY_POLYGON: &[u8] = &[
    0x01, 0x00, 0x01, 0x0b, 0x01, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0xf0, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x10, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x40, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0xf0, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x01,
    0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x40, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x20, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22,
    0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x40, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x26, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28,
    0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x40, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x20, 0x40
];
/// Record: record with geometry data (multi point)
pub const RECORD_GEOMETRY_MULTI_POINT: &[u8] = &[
    0x01, 0x00, 0x01, 0x0b, 0x01, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0xf0, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x10, 0x40
];
/// Record: record with geometry data (multi line)
pub const RECORD_GEOMETRY_MULTI_LINE: &[u8] = &[
    0x01, 0x00, 0x01, 0x0b, 0x01, 0x04, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xf0, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x40, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x10, 0x40, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14,
    0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x40, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x1c, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20,
    0x40
];
/// Record: record with geometry data (multi polygon)
pub const RECORD_GEOMETRY_MULTI_POLYGON: &[u8] = &[
    0x01, 0x00, 0x01, 0x0b, 0x01, 0x05, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xf0, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x40, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x10, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x40,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x40, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xf0, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40,
    0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x40, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x20, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x22, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x40, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x26, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x28, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x40, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x20, 0x40, 0x00
];
/// Record: record with geometry data (collection)
pub const RECORD_GEOMETRY_COLLECTION: &[u8] = &[
    0x01, 0x00, 0x01, 0x0b, 0x01, 0x06, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0xf0, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x01, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x40,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x40, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x14, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x40,
    0x01, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x40, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x22, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x40, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x28, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x40, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x40, 0x00
];
/// Record: record with table data
pub const RECORD_TABLE: &[u8] = &[
    0x01, 0x00, 0x01, 0x0d, 0x05, 0x75, 0x73, 0x65, 0x72, 0x73
];
/// Record: record with record ID data
pub const RECORD_RECORDID: &[u8] = &[
    0x01, 0x00, 0x01, 0x0e, 0x01, 0x05, 0x75, 0x73, 0x65, 0x72, 0x73, 0x01,
    0x00, 0xf6
];
/// Record: record with file data
pub const RECORD_FILE: &[u8] = &[
    0x01, 0x00, 0x01, 0x0f, 0x01, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74,
    0x04, 0x2f, 0x6b, 0x65, 0x79
];
/// Record: record with range data
pub const RECORD_RANGE_UNBOUNDED: &[u8] = &[
    0x01, 0x00, 0x01, 0x11, 0x01, 0x00, 0x00
];
/// Record: record with range data
pub const RECORD_RANGE_BOUNDED: &[u8] = &[
    0x01, 0x00, 0x01, 0x11, 0x01, 0x01, 0x01, 0x03, 0x01, 0x00, 0xf6, 0x02,
    0x01, 0x03, 0x01, 0x00, 0xfb, 0x90, 0x03
];
/// Record: record with regex data
pub const RECORD_REGEX: &[u8] = &[
    0x01, 0x00, 0x01, 0x10, 0x01, 0x07, 0x5e, 0x74, 0x65, 0x73, 0x74, 0x2e,
    0x2a
];
/// Record: record with array data
pub const RECORD_ARRAY: &[u8] = &[
    0x01, 0x00, 0x01, 0x08, 0x01, 0x03, 0x01, 0x04, 0x05, 0x69, 0x74, 0x65,
    0x6d, 0x31, 0x01, 0x03, 0x01, 0x00, 0xf6, 0x01, 0x02, 0x01
];
/// Record: record with object data
pub const RECORD_OBJECT: &[u8] = &[
    0x01, 0x00, 0x01, 0x0a, 0x01, 0x03, 0x06, 0x61, 0x63, 0x74, 0x69, 0x76,
    0x65, 0x01, 0x02, 0x01, 0x03, 0x61, 0x67, 0x65, 0x01, 0x03, 0x01, 0x00,
    0x3c, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x01, 0x04, 0x05, 0x41, 0x6c, 0x69,
    0x63, 0x65
];
/// Record: record with set data
pub const RECORD_SET: &[u8] = &[
    0x01, 0x00, 0x01, 0x09, 0x01, 0x03, 0x01, 0x04, 0x04, 0x74, 0x61, 0x67,
    0x31, 0x01, 0x04, 0x04, 0x74, 0x61, 0x67, 0x32, 0x01, 0x04, 0x04, 0x74,
    0x61, 0x67, 0x33
];
/// Record: record with metadata (Edge type)
pub const RECORD_WITH_METADATA: &[u8] = &[
    0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x01, 0x0a, 0x01, 0x00
];

// ======================================================================
// RecordId
// ======================================================================

/// RecordId: RecordId with number key
pub const RECORDID_NUMBER: &[u8] = &[
    0x01, 0x05, 0x75, 0x73, 0x65, 0x72, 0x73, 0x01, 0x00, 0xf6
];
/// RecordId: RecordId with string key
pub const RECORDID_STRING: &[u8] = &[
    0x01, 0x05, 0x75, 0x73, 0x65, 0x72, 0x73, 0x01, 0x01, 0x06, 0x61, 0x62,
    0x63, 0x31, 0x32, 0x33
];
/// RecordId: RecordId with UUID key
pub const RECORDID_UUID: &[u8] = &[
    0x01, 0x05, 0x75, 0x73, 0x65, 0x72, 0x73, 0x01, 0x02, 0x01, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00
];

// ======================================================================
// RecordIdKey
// ======================================================================

/// RecordIdKey: RecordIdKey with number
pub const RECORDID_KEY_NUMBER: &[u8] = &[
    0x01, 0x00, 0x54
];
/// RecordIdKey: RecordIdKey with string
pub const RECORDID_KEY_STRING: &[u8] = &[
    0x01, 0x01, 0x08, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x6b, 0x65, 0x79
];
/// RecordIdKey: RecordIdKey with UUID
pub const RECORDID_KEY_UUID: &[u8] = &[
    0x01, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
];
/// RecordIdKey: RecordIdKey with array
pub const RECORDID_KEY_ARRAY: &[u8] = &[
    0x01, 0x03, 0x01, 0x02, 0x01, 0x03, 0x01, 0x00, 0x02, 0x01, 0x04, 0x01,
    0x61
];
/// RecordIdKey: RecordIdKey with object
pub const RECORDID_KEY_OBJECT: &[u8] = &[
    0x01, 0x04, 0x01, 0x01, 0x02, 0x69, 0x64, 0x01, 0x03, 0x01, 0x00, 0xf6
];

// ======================================================================
// SequenceDefinition
// ======================================================================

/// SequenceDefinition: minimal sequence
pub const SEQUENCE_BASIC: &[u8] = &[
    0x01, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x01, 0x02,
    0x00
];
/// SequenceDefinition: sequence with custom options
pub const SEQUENCE_WITH_OPTIONS: &[u8] = &[
    0x01, 0x0e, 0x69, 0x6e, 0x76, 0x6f, 0x69, 0x63, 0x65, 0x5f, 0x6e, 0x75,
    0x6d, 0x62, 0x65, 0x72, 0x64, 0xfb, 0xd0, 0x07, 0x01, 0x1e, 0x00
];

// ======================================================================
// SequenceState
// ======================================================================

/// SequenceState: sequence state with number value
pub const SEQUENCE_STATE_BASIC: &[u8] = &[
    0x01, 0xf6
];

// ======================================================================
// SubscriptionDefinition
// ======================================================================

/// SubscriptionDefinition: minimal subscription with diff fields
pub const SUBSCRIPTION_BASIC: &[u8] = &[
    0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x07,
    0x27, 0x75, 0x73, 0x65, 0x72, 0x73, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00
];
/// SubscriptionDefinition: subscription with condition and fetch
pub const SUBSCRIPTION_WITH_FILTERS: &[u8] = &[
    0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01,
    0x01, 0x02, 0x01, 0x00, 0x01, 0x01, 0x01, 0x06, 0x27, 0x6e, 0x61, 0x6d,
    0x65, 0x27, 0x00, 0x07, 0x27, 0x75, 0x73, 0x65, 0x72, 0x73, 0x27, 0x01,
    0x0f, 0x27, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x20, 0x3d, 0x20, 0x74,
    0x72, 0x75, 0x65, 0x27, 0x01, 0x01, 0x01, 0x01, 0x09, 0x27, 0x70, 0x72,
    0x6f, 0x66, 0x69, 0x6c, 0x65, 0x27, 0x01, 0x01, 0x01, 0x01, 0x00, 0x05,
    0x14, 0x01, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00
];

// ======================================================================
// TableDefinition
// ======================================================================

/// TableDefinition: minimal table definition
pub const TABLE_BASIC: &[u8] = &[
    0x01, 0x01, 0x01, 0x01, 0x05, 0x75, 0x73, 0x65, 0x72, 0x73, 0x00, 0x00,
    0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00,
    0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00
];
/// TableDefinition: table with view definition
pub const TABLE_WITH_VIEW: &[u8] = &[
    0x01, 0x7b, 0xfb, 0xc8, 0x01, 0xfb, 0x15, 0x03, 0x0a, 0x75, 0x73, 0x65,
    0x72, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x00, 0x00, 0x01, 0x01, 0x02,
    0x01, 0x01, 0x02, 0x01, 0x00, 0x01, 0x01, 0x01, 0x07, 0x27, 0x63, 0x6f,
    0x75, 0x6e, 0x74, 0x27, 0x01, 0x05, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x01,
    0x05, 0x75, 0x73, 0x65, 0x72, 0x73, 0x01, 0x0f, 0x27, 0x61, 0x63, 0x74,
    0x69, 0x76, 0x65, 0x20, 0x3d, 0x20, 0x74, 0x72, 0x75, 0x65, 0x27, 0x01,
    0x01, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00,
    0x01, 0x14, 0x55, 0x73, 0x65, 0x72, 0x20, 0x73, 0x74, 0x61, 0x74, 0x69,
    0x73, 0x74, 0x69, 0x63, 0x73, 0x20, 0x76, 0x69, 0x65, 0x77, 0x01, 0x01,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00
];
/// TableDefinition: schemafull table with changefeed
pub const TABLE_SCHEMAFULL: &[u8] = &[
    0x01, 0x01, 0x01, 0x02, 0x06, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x73, 0x00,
    0x01, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0xfc, 0x80, 0x51, 0x01, 0x00, 0x00, 0x00, 0x01, 0x0d, 0x4f, 0x72,
    0x64, 0x65, 0x72, 0x20, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x73, 0x01,
    0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00
];

// ======================================================================
// TableMutations
// ======================================================================

/// TableMutations: table mutations with set operation
pub const TABLE_MUTATIONS_SET: &[u8] = &[
    0x01, 0x05, 0x75, 0x73, 0x65, 0x72, 0x73, 0x01, 0x01, 0x00, 0x01, 0x05,
    0x75, 0x73, 0x65, 0x72, 0x73, 0x01, 0x00, 0x02, 0x01, 0x0a, 0x01, 0x01,
    0x04, 0x6e, 0x61, 0x6d, 0x65, 0x01, 0x04, 0x05, 0x41, 0x6c, 0x69, 0x63,
    0x65
];
/// TableMutations: table mutations with delete operation
pub const TABLE_MUTATIONS_DEL: &[u8] = &[
    0x01, 0x05, 0x75, 0x73, 0x65, 0x72, 0x73, 0x01, 0x01, 0x01, 0x01, 0x05,
    0x75, 0x73, 0x65, 0x72, 0x73, 0x01, 0x00, 0x02
];

// ======================================================================
// TaskLease
// ======================================================================

/// TaskLease: task lease with UUID and datetime value
pub const TASK_LEASE_BASIC: &[u8] = &[
    0x01, 0x12, 0x3e, 0x45, 0x67, 0xe8, 0x9b, 0x12, 0xd3, 0xa4, 0x56, 0x42,
    0x66, 0x14, 0x17, 0x40, 0x00, 0xfc, 0x80, 0xc4, 0xc9, 0xd2, 0x00
];

// ======================================================================
// TermDocument
// ======================================================================

/// TermDocument: term document with offsets
pub const TERM_DOCUMENT_BASIC: &[u8] = &[
    0x01, 0x7b, 0x01, 0x01, 0x01, 0x02, 0x03, 0x04
];

// ======================================================================
// UserDefinition
// ======================================================================

/// UserDefinition: minimal user
pub const USER_BASIC: &[u8] = &[
    0x01, 0x05, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x23, 0x24, 0x61, 0x72, 0x67,
    0x6f, 0x6e, 0x32, 0x69, 0x64, 0x24, 0x76, 0x3d, 0x31, 0x39, 0x24, 0x6d,
    0x3d, 0x36, 0x35, 0x35, 0x33, 0x36, 0x2c, 0x74, 0x3d, 0x33, 0x2c, 0x70,
    0x3d, 0x34, 0x24, 0x68, 0x61, 0x73, 0x68, 0x09, 0x54, 0x4f, 0x54, 0x50,
    0x5f, 0x43, 0x4f, 0x44, 0x45, 0x01, 0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72,
    0x00, 0x00, 0x00, 0x01, 0x00
];
/// UserDefinition: user with custom token/session durations
pub const USER_WITH_DURATIONS: &[u8] = &[
    0x01, 0x08, 0x61, 0x70, 0x69, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x23, 0x24,
    0x61, 0x72, 0x67, 0x6f, 0x6e, 0x32, 0x69, 0x64, 0x24, 0x76, 0x3d, 0x31,
    0x39, 0x24, 0x6d, 0x3d, 0x36, 0x35, 0x35, 0x33, 0x36, 0x2c, 0x74, 0x3d,
    0x33, 0x2c, 0x70, 0x3d, 0x34, 0x24, 0x68, 0x61, 0x73, 0x68, 0x00, 0x02,
    0x06, 0x76, 0x69, 0x65, 0x77, 0x65, 0x72, 0x06, 0x65, 0x64, 0x69, 0x74,
    0x6f, 0x72, 0x01, 0xfb, 0x10, 0x0e, 0x00, 0x01, 0xfc, 0x80, 0x51, 0x01,
    0x00, 0x00, 0x01, 0x13, 0x41, 0x50, 0x49, 0x20, 0x73, 0x65, 0x72, 0x76,
    0x69, 0x63, 0x65, 0x20, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x01,
    0x01
];

// ======================================================================
// MajorVersion
// ======================================================================

/// MajorVersion: major version 1
pub const VERSION_1: &[u8] = &[
    0x00, 0x01
];
/// MajorVersion: major version 3
pub const VERSION_3: &[u8] = &[
    0x00, 0x03
];
