// Copyright 2017 The TensorFlow Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// DO NOT EDIT
// This file was machine generated by github.com/tensorflow/tensorflow/tensorflow/go/genop/internal
//
// WARNING: This generation of wrapper function for TensorFlow ops is in an
// experimental state. The generated API can change without notice.

package op

import tf "github.com/tensorflow/tensorflow/tensorflow/go"

// optionalAttr is an intentionally un-exported type to hide
// details of how optional attributes to operations are implemented.
type optionalAttr map[string]interface{}

func makeOutputList(op *tf.Operation, start int, output string) ([]tf.Output, int, error) {
	size, err := op.OutputListSize(output)
	if err != nil {
		return nil, start, err
	}
	list := make([]tf.Output, size)
	for i := 0; i < size; i++ {
		list[i] = op.Output(start + i)
	}
	return list, start + size, nil
}

// AbortAttr is an optional argument to Abort.
type AbortAttr func(optionalAttr)

// AbortErrorMsg sets the optional error_msg attribute to value.
//
// value: A string which is the message associated with the exception.
// If not specified, defaults to ""
func AbortErrorMsg(value string) AbortAttr {
	return func(m optionalAttr) {
		m["error_msg"] = value
	}
}

// AbortExitWithoutError sets the optional exit_without_error attribute to value.
// If not specified, defaults to false
func AbortExitWithoutError(value bool) AbortAttr {
	return func(m optionalAttr) {
		m["exit_without_error"] = value
	}
}

// Raise a exception to abort the process when called.
//
// If exit_without_error is true, the process will exit normally,
// otherwise it will exit with a SIGABORT signal.
//
// Returns nothing but an exception.
//
// Returns the created operation.
func Abort(scope *Scope, optional ...AbortAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Abort",

		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// Computes the absolute value of a tensor.
//
// Given a tensor `x`, this operation returns a tensor containing the absolute
// value of each element in `x`. For example, if x is an input element and y is
// an output element, this operation computes \\(y = |x|\\).
func Abs(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Abs",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the element-wise sum of a list of tensors.
//
// `tf.accumulate_n_v2` performs the same operation as `tf.add_n`, but does not
// wait for all of its inputs to be ready before beginning to sum. This can
// save memory if inputs are ready at different times, since minimum temporary
// storage is proportional to the output size rather than the inputs size.
//
// Unlike the original `accumulate_n`, `accumulate_n_v2` is differentiable.
//
// Returns a `Tensor` of same shape and type as the elements of `inputs`.
//
// Arguments:
//
//	inputs: A list of `Tensor` objects, each with same shape and type.
//	shape: Shape of elements of `inputs`.
func AccumulateNV2(scope *Scope, inputs []tf.Output, shape tf.Shape) (sum tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"shape": shape}
	opspec := tf.OpSpec{
		Type: "AccumulateNV2",
		Input: []tf.Input{
			tf.OutputList(inputs),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes acos of x element-wise.
//
//	Provided an input tensor, the `tf.math.acos` operation returns the inverse cosine of each element of the tensor. If `y = tf.math.cos(x)` then, `x = tf.math.acos(y)`.
//
//	Input range is `[-1, 1]` and the output has a range of `[0, pi]`.
func Acos(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Acos",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes inverse hyperbolic cosine of x element-wise.
//
// Given an input tensor, the function computes inverse hyperbolic cosine of every element.
// Input range is `[1, inf]`. It returns `nan` if the input lies outside the range.
//
// ```python
// x = tf.constant([-2, -0.5, 1, 1.2, 200, 10000, float("inf")])
// tf.math.acosh(x) ==> [nan nan 0. 0.62236255 5.9914584 9.903487 inf]
// ```
func Acosh(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Acosh",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns x + y element-wise.
//
// *NOTE*: `Add` supports broadcasting. `AddN` does not. More about broadcasting
// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
//
// Given two input tensors, the `tf.add` operation computes the sum for every element in the tensor.
//
// Both input and output have a range `(-inf, inf)`.
func Add(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Add",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// AddManySparseToTensorsMapAttr is an optional argument to AddManySparseToTensorsMap.
type AddManySparseToTensorsMapAttr func(optionalAttr)

// AddManySparseToTensorsMapContainer sets the optional container attribute to value.
//
// value: The container name for the `SparseTensorsMap` created by this op.
// If not specified, defaults to ""
func AddManySparseToTensorsMapContainer(value string) AddManySparseToTensorsMapAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// AddManySparseToTensorsMapSharedName sets the optional shared_name attribute to value.
//
// value: The shared name for the `SparseTensorsMap` created by this op.
// If blank, the new Operation's unique name is used.
// If not specified, defaults to ""
func AddManySparseToTensorsMapSharedName(value string) AddManySparseToTensorsMapAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Add an `N`-minibatch `SparseTensor` to a `SparseTensorsMap`, return `N` handles.
//
// A `SparseTensor` of rank `R` is represented by three tensors: `sparse_indices`,
// `sparse_values`, and `sparse_shape`, where
//
// ```sparse_indices.shape[1] == sparse_shape.shape[0] == R```
//
// An `N`-minibatch of `SparseTensor` objects is represented as a `SparseTensor`
// having a first `sparse_indices` column taking values between `[0, N)`, where
// the minibatch size `N == sparse_shape[0]`.
//
// The input `SparseTensor` must have rank `R` greater than 1, and the first
// dimension is treated as the minibatch dimension.  Elements of the `SparseTensor`
// must be sorted in increasing order of this first dimension.  The stored
// `SparseTensor` objects pointed to by each row of the output `sparse_handles`
// will have rank `R-1`.
//
// The `SparseTensor` values can then be read out as part of a minibatch by passing
// the given keys as vector elements to `TakeManySparseFromTensorsMap`.  To ensure
// the correct `SparseTensorsMap` is accessed, ensure that the same
// `container` and `shared_name` are passed to that Op.  If no `shared_name`
// is provided here, instead use the *name* of the Operation created by calling
// `AddManySparseToTensorsMap` as the `shared_name` passed to
// `TakeManySparseFromTensorsMap`.  Ensure the Operations are colocated.
//
// Arguments:
//
//	sparse_indices: 2-D.  The `indices` of the minibatch `SparseTensor`.
//
// `sparse_indices[:, 0]` must be ordered values in `[0, N)`.
//
//	sparse_values: 1-D.  The `values` of the minibatch `SparseTensor`.
//	sparse_shape: 1-D.  The `shape` of the minibatch `SparseTensor`.
//
// The minibatch size `N == sparse_shape[0]`.
//
// Returns 1-D.  The handles of the `SparseTensor` now stored in the
// `SparseTensorsMap`.  Shape: `[N]`.
func AddManySparseToTensorsMap(scope *Scope, sparse_indices tf.Output, sparse_values tf.Output, sparse_shape tf.Output, optional ...AddManySparseToTensorsMapAttr) (sparse_handles tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "AddManySparseToTensorsMap",
		Input: []tf.Input{
			sparse_indices, sparse_values, sparse_shape,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Add all input tensors element wise.
//
//	Inputs must be of same size and shape.
//
//	```python
//	x = [9, 7, 10]
//	tf.math.add_n(x) ==> 26
//	```
func AddN(scope *Scope, inputs []tf.Output) (sum tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "AddN",
		Input: []tf.Input{
			tf.OutputList(inputs),
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// AddSparseToTensorsMapAttr is an optional argument to AddSparseToTensorsMap.
type AddSparseToTensorsMapAttr func(optionalAttr)

// AddSparseToTensorsMapContainer sets the optional container attribute to value.
//
// value: The container name for the `SparseTensorsMap` created by this op.
// If not specified, defaults to ""
func AddSparseToTensorsMapContainer(value string) AddSparseToTensorsMapAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// AddSparseToTensorsMapSharedName sets the optional shared_name attribute to value.
//
// value: The shared name for the `SparseTensorsMap` created by this op.
// If blank, the new Operation's unique name is used.
// If not specified, defaults to ""
func AddSparseToTensorsMapSharedName(value string) AddSparseToTensorsMapAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Add a `SparseTensor` to a `SparseTensorsMap` return its handle.
//
// A `SparseTensor` is represented by three tensors: `sparse_indices`,
// `sparse_values`, and `sparse_shape`.
//
// This operator takes the given `SparseTensor` and adds it to a container
// object (a `SparseTensorsMap`).  A unique key within this container is generated
// in the form of an `int64`, and this is the value that is returned.
//
// The `SparseTensor` can then be read out as part of a minibatch by passing
// the key as a vector element to `TakeManySparseFromTensorsMap`.  To ensure
// the correct `SparseTensorsMap` is accessed, ensure that the same
// `container` and `shared_name` are passed to that Op.  If no `shared_name`
// is provided here, instead use the *name* of the Operation created by calling
// `AddSparseToTensorsMap` as the `shared_name` passed to
// `TakeManySparseFromTensorsMap`.  Ensure the Operations are colocated.
//
// Arguments:
//
//	sparse_indices: 2-D.  The `indices` of the `SparseTensor`.
//	sparse_values: 1-D.  The `values` of the `SparseTensor`.
//	sparse_shape: 1-D.  The `shape` of the `SparseTensor`.
//
// Returns 0-D.  The handle of the `SparseTensor` now stored in the
// `SparseTensorsMap`.
func AddSparseToTensorsMap(scope *Scope, sparse_indices tf.Output, sparse_values tf.Output, sparse_shape tf.Output, optional ...AddSparseToTensorsMapAttr) (sparse_handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "AddSparseToTensorsMap",
		Input: []tf.Input{
			sparse_indices, sparse_values, sparse_shape,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns x + y element-wise.
//
// *NOTE*: `Add` supports broadcasting. `AddN` does not. More about broadcasting
// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
func AddV2(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "AddV2",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Deprecated. Disallowed in GraphDef version >= 2.
//
// DEPRECATED at GraphDef version 2: Use AdjustContrastv2 instead
func AdjustContrast(scope *Scope, images tf.Output, contrast_factor tf.Output, min_value tf.Output, max_value tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "AdjustContrast",
		Input: []tf.Input{
			images, contrast_factor, min_value, max_value,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Adjust the contrast of one or more images.
//
// `images` is a tensor of at least 3 dimensions.  The last 3 dimensions are
// interpreted as `[height, width, channels]`.  The other dimensions only
// represent a collection of images, such as `[batch, height, width, channels].`
//
// Contrast is adjusted independently for each channel of each image.
//
// For each channel, the Op first computes the mean of the image pixels in the
// channel and then adjusts each component of each pixel to
// `(x - mean) * contrast_factor + mean`.
//
// Arguments:
//
//	images: Images to adjust.  At least 3-D.
//	contrast_factor: A float multiplier for adjusting contrast.
//
// Returns The contrast-adjusted image or images.
func AdjustContrastv2(scope *Scope, images tf.Output, contrast_factor tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "AdjustContrastv2",
		Input: []tf.Input{
			images, contrast_factor,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Adjust the hue of one or more images.
//
// `images` is a tensor of at least 3 dimensions.  The last dimension is
// interpreted as channels, and must be three.
//
// The input image is considered in the RGB colorspace. Conceptually, the RGB
// colors are first mapped into HSV. A delta is then applied all the hue values,
// and then remapped back to RGB colorspace.
//
// Arguments:
//
//	images: Images to adjust.  At least 3-D.
//	delta: A float delta to add to the hue.
//
// Returns The hue-adjusted image or images.
func AdjustHue(scope *Scope, images tf.Output, delta tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "AdjustHue",
		Input: []tf.Input{
			images, delta,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Adjust the saturation of one or more images.
//
// `images` is a tensor of at least 3 dimensions.  The last dimension is
// interpreted as channels, and must be three.
//
// The input image is considered in the RGB colorspace. Conceptually, the RGB
// colors are first mapped into HSV. A scale is then applied all the saturation
// values, and then remapped back to RGB colorspace.
//
// Arguments:
//
//	images: Images to adjust.  At least 3-D.
//	scale: A float scale to add to the saturation.
//
// Returns The hue-adjusted image or images.
func AdjustSaturation(scope *Scope, images tf.Output, scale tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "AdjustSaturation",
		Input: []tf.Input{
			images, scale,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// AllAttr is an optional argument to All.
type AllAttr func(optionalAttr)

// AllKeepDims sets the optional keep_dims attribute to value.
//
// value: If true, retain reduced dimensions with length 1.
// If not specified, defaults to false
func AllKeepDims(value bool) AllAttr {
	return func(m optionalAttr) {
		m["keep_dims"] = value
	}
}

// Computes the "logical and" of elements across dimensions of a tensor.
//
// Reduces `input` along the dimensions given in `axis`. Unless
// `keep_dims` is true, the rank of the tensor is reduced by 1 for each entry in
// `axis`. If `keep_dims` is true, the reduced dimensions are
// retained with length 1.
//
// Arguments:
//
//	input: The tensor to reduce.
//	axis: The dimensions to reduce. Must be in the range
//
// `[-rank(input), rank(input))`.
//
// Returns The reduced tensor.
func All(scope *Scope, input tf.Output, axis tf.Output, optional ...AllAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "All",
		Input: []tf.Input{
			input, axis,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// AllCandidateSamplerAttr is an optional argument to AllCandidateSampler.
type AllCandidateSamplerAttr func(optionalAttr)

// AllCandidateSamplerSeed sets the optional seed attribute to value.
//
// value: If either seed or seed2 are set to be non-zero, the random number
// generator is seeded by the given seed.  Otherwise, it is seeded by a
// random seed.
// If not specified, defaults to 0
func AllCandidateSamplerSeed(value int64) AllCandidateSamplerAttr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// AllCandidateSamplerSeed2 sets the optional seed2 attribute to value.
//
// value: An second seed to avoid seed collision.
// If not specified, defaults to 0
func AllCandidateSamplerSeed2(value int64) AllCandidateSamplerAttr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// Generates labels for candidate sampling with a learned unigram distribution.
//
// See explanations of candidate sampling and the data formats at
// go/candidate-sampling.
//
// For each batch, this op picks a single set of sampled candidate labels.
//
// The advantages of sampling candidates per-batch are simplicity and the
// possibility of efficient dense matrix multiplication. The disadvantage is that
// the sampled candidates must be chosen independently of the context and of the
// true labels.
//
// Arguments:
//
//	true_classes: A batch_size * num_true matrix, in which each row contains the
//
// IDs of the num_true target_classes in the corresponding original label.
//
//	num_true: Number of true labels per context.
//	num_sampled: Number of candidates to produce.
//	unique: If unique is true, we sample with rejection, so that all sampled
//
// candidates in a batch are unique. This requires some approximation to
// estimate the post-rejection sampling probabilities.
//
// Returns:
//
//	sampled_candidates: A vector of length num_sampled, in which each element is
//
// the ID of a sampled candidate.
//
//	true_expected_count: A batch_size * num_true matrix, representing
//
// the number of times each candidate is expected to occur in a batch
// of sampled candidates. If unique=true, then this is a probability.
//
//	sampled_expected_count: A vector of length num_sampled, for each sampled
//
// candidate representing the number of times the candidate is expected
// to occur in a batch of sampled candidates.  If unique=true, then this is a
// probability.
func AllCandidateSampler(scope *Scope, true_classes tf.Output, num_true int64, num_sampled int64, unique bool, optional ...AllCandidateSamplerAttr) (sampled_candidates tf.Output, true_expected_count tf.Output, sampled_expected_count tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_true": num_true, "num_sampled": num_sampled, "unique": unique}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "AllCandidateSampler",
		Input: []tf.Input{
			true_classes,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// An Op to exchange data across TPU replicas.
//
// On each replica, the input is split into `split_count` blocks along
// `split_dimension` and send to the other replicas given group_assignment. After
// receiving `split_count` - 1 blocks from other replicas, we concatenate the
// blocks along `concat_dimension` as the output.
//
// For example, suppose there are 2 TPU replicas:
// replica 0 receives input: `[[A, B]]`
// replica 1 receives input: `[[C, D]]`
//
// group_assignment=`[[0, 1]]`
// concat_dimension=0
// split_dimension=1
// split_count=2
//
// replica 0's output: `[[A], [C]]`
// replica 1's output: `[[B], [D]]`
//
// Arguments:
//
//	input: The local input to the sum.
//	group_assignment: An int32 tensor with shape
//
// [num_groups, num_replicas_per_group]. `group_assignment[i]` represents the
// replica ids in the ith subgroup.
//
//	concat_dimension: The dimension number to concatenate.
//	split_dimension: The dimension number to split.
//	split_count: The number of splits, this number must equal to the sub-group
//
// size(group_assignment.get_shape()[1])
//
// Returns The exchanged result.
func AllToAll(scope *Scope, input tf.Output, group_assignment tf.Output, concat_dimension int64, split_dimension int64, split_count int64) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"concat_dimension": concat_dimension, "split_dimension": split_dimension, "split_count": split_count}
	opspec := tf.OpSpec{
		Type: "AllToAll",
		Input: []tf.Input{
			input, group_assignment,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// AngleAttr is an optional argument to Angle.
type AngleAttr func(optionalAttr)

// AngleTout sets the optional Tout attribute to value.
// If not specified, defaults to DT_FLOAT
func AngleTout(value tf.DataType) AngleAttr {
	return func(m optionalAttr) {
		m["Tout"] = value
	}
}

// Returns the argument of a complex number.
//
// Given a tensor `input` of complex numbers, this operation returns a tensor of
// type `float` that is the argument of each element in `input`. All elements in
// `input` must be complex numbers of the form \\(a + bj\\), where *a*
// is the real part and *b* is the imaginary part.
//
// The argument returned by this operation is of the form \\(atan2(b, a)\\).
//
// For example:
//
// ```
// # tensor 'input' is [-2.25 + 4.75j, 3.25 + 5.75j]
// tf.math.angle(input) ==> [2.0132, 1.056]
// ```
//
// @compatibility(numpy)
// Equivalent to np.angle.
// @end_compatibility
func Angle(scope *Scope, input tf.Output, optional ...AngleAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Angle",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates a uninitialized anonymous hash table.
//
// This op creates a new anonymous hash table (as a resource) everytime
// it is executed, with the specified dtype of its keys and values,
// returning the resource handle.  Before using the table you will have
// to initialize it.  After initialization the table will be
// immutable. The table is anonymous in the sense that it can only be
// accessed by the returned resource handle (e.g. it cannot be looked up
// by a name in a resource manager). The table will be automatically
// deleted when all resource handles pointing to it are gone.
//
// Arguments:
//
//	key_dtype: Type of the table keys.
//	value_dtype: Type of the table values.
//
// Returns The resource handle to the newly created hash-table resource.
func AnonymousHashTable(scope *Scope, key_dtype tf.DataType, value_dtype tf.DataType) (table_handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"key_dtype": key_dtype, "value_dtype": value_dtype}
	opspec := tf.OpSpec{
		Type: "AnonymousHashTable",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// A container for an iterator resource.
//
// Returns A handle to the iterator that can be passed to a "MakeIterator" or
// "IteratorGetNext" op. In contrast to Iterator, AnonymousIterator prevents
// resource sharing by name, and does not keep a reference to the resource
// container.
func AnonymousIterator(scope *Scope, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "AnonymousIterator",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// A container for an iterator resource.
//
// Returns:
//
//	handle: A handle to the iterator that can be passed to a "MakeIterator" or
//
// "IteratorGetNext" op. In contrast to Iterator, AnonymousIterator prevents
// resource sharing by name, and does not keep a reference to the resource
// container.
//
//	deleter: A variant deleter that should be passed into the op that deletes the iterator.
func AnonymousIteratorV2(scope *Scope, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output, deleter tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "AnonymousIteratorV2",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// A container for an iterator resource.
//
// Returns A handle to the iterator that can be passed to a "MakeIterator" or
// "IteratorGetNext" op. In contrast to Iterator, AnonymousIterator prevents
// resource sharing by name, and does not keep a reference to the resource
// container.
func AnonymousIteratorV3(scope *Scope, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "AnonymousIteratorV3",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// A container for a multi device iterator resource.
//
// Returns:
//
//	handle: A handle to a multi device iterator that can be passed to a
//
// "MultiDeviceIteratorGetNextFromShard" op. In contrast to MultiDeviceIterator,
// AnonymousIterator prevents resource sharing by name, and does not keep a
// reference to the resource container.
//
//	deleter: A variant deleter that should be passed into the op that deletes the iterator.
func AnonymousMultiDeviceIterator(scope *Scope, devices []string, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output, deleter tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"devices": devices, "output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "AnonymousMultiDeviceIterator",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// A container for a multi device iterator resource.
//
// Returns A handle to a multi device iterator that can be passed to a
// "MultiDeviceIteratorGetNextFromShard" op. In contrast to MultiDeviceIterator,
// AnonymousIterator prevents resource sharing by name, and does not keep a
// reference to the resource container.
func AnonymousMultiDeviceIteratorV3(scope *Scope, devices []string, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"devices": devices, "output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "AnonymousMultiDeviceIteratorV3",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// AnonymousMutableDenseHashTableAttr is an optional argument to AnonymousMutableDenseHashTable.
type AnonymousMutableDenseHashTableAttr func(optionalAttr)

// AnonymousMutableDenseHashTableValueShape sets the optional value_shape attribute to value.
//
// value: The shape of each value.
// If not specified, defaults to {}
func AnonymousMutableDenseHashTableValueShape(value tf.Shape) AnonymousMutableDenseHashTableAttr {
	return func(m optionalAttr) {
		m["value_shape"] = value
	}
}

// AnonymousMutableDenseHashTableInitialNumBuckets sets the optional initial_num_buckets attribute to value.
//
// value: The initial number of hash table buckets. Must be a power
// to 2.
// If not specified, defaults to 131072
func AnonymousMutableDenseHashTableInitialNumBuckets(value int64) AnonymousMutableDenseHashTableAttr {
	return func(m optionalAttr) {
		m["initial_num_buckets"] = value
	}
}

// AnonymousMutableDenseHashTableMaxLoadFactor sets the optional max_load_factor attribute to value.
//
// value: The maximum ratio between number of entries and number of
// buckets before growing the table. Must be between 0 and 1.
// If not specified, defaults to 0.8
func AnonymousMutableDenseHashTableMaxLoadFactor(value float32) AnonymousMutableDenseHashTableAttr {
	return func(m optionalAttr) {
		m["max_load_factor"] = value
	}
}

// Creates an empty anonymous mutable hash table that uses tensors as the backing store.
//
// This op creates a new anonymous mutable hash table (as a resource) everytime
// it is executed, with the specified dtype of its keys and values,
// returning the resource handle. Each value must be a scalar.
// Data can be inserted into the table using
// the insert operations. It does not support the initialization operation.
//
// It uses "open addressing" with quadratic reprobing to resolve
// collisions.
//
// The table is anonymous in the sense that it can only be
// accessed by the returned resource handle (e.g. it cannot be looked up
// by a name in a resource manager). The table will be automatically
// deleted when all resource handles pointing to it are gone.
//
// Arguments:
//
//	empty_key: The key used to represent empty key buckets internally. Must not
//
// be used in insert or lookup operations.
//
//	value_dtype: Type of the table values.
//
// Returns The resource handle to the newly created hash-table resource.
func AnonymousMutableDenseHashTable(scope *Scope, empty_key tf.Output, deleted_key tf.Output, value_dtype tf.DataType, optional ...AnonymousMutableDenseHashTableAttr) (table_handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"value_dtype": value_dtype}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "AnonymousMutableDenseHashTable",
		Input: []tf.Input{
			empty_key, deleted_key,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates an empty anonymous mutable hash table.
//
// This op creates a new anonymous mutable hash table (as a resource) everytime
// it is executed, with the specified dtype of its keys and values,
// returning the resource handle. Each value must be a scalar.
// Data can be inserted into the table using
// the insert operations. It does not support the initialization operation.
// The table is anonymous in the sense that it can only be
// accessed by the returned resource handle (e.g. it cannot be looked up
// by a name in a resource manager). The table will be automatically
// deleted when all resource handles pointing to it are gone.
//
// Arguments:
//
//	key_dtype: Type of the table keys.
//	value_dtype: Type of the table values.
//
// Returns The resource handle to the newly created hash-table resource.
func AnonymousMutableHashTable(scope *Scope, key_dtype tf.DataType, value_dtype tf.DataType) (table_handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"key_dtype": key_dtype, "value_dtype": value_dtype}
	opspec := tf.OpSpec{
		Type: "AnonymousMutableHashTable",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// AnonymousMutableHashTableOfTensorsAttr is an optional argument to AnonymousMutableHashTableOfTensors.
type AnonymousMutableHashTableOfTensorsAttr func(optionalAttr)

// AnonymousMutableHashTableOfTensorsValueShape sets the optional value_shape attribute to value.
// If not specified, defaults to {}
func AnonymousMutableHashTableOfTensorsValueShape(value tf.Shape) AnonymousMutableHashTableOfTensorsAttr {
	return func(m optionalAttr) {
		m["value_shape"] = value
	}
}

// Creates an empty anonymous mutable hash table of vector values.
//
// This op creates a new anonymous mutable hash table (as a resource) everytime
// it is executed, with the specified dtype of its keys and values,
// returning the resource handle. Each value must be a vector.
// Data can be inserted into the table using
// the insert operations. It does not support the initialization operation.
// The table is anonymous in the sense that it can only be
// accessed by the returned resource handle (e.g. it cannot be looked up
// by a name in a resource manager). The table will be automatically
// deleted when all resource handles pointing to it are gone.
//
// Arguments:
//
//	key_dtype: Type of the table keys.
//	value_dtype: Type of the table values.
//
// Returns The resource handle to the newly created hash-table resource.
func AnonymousMutableHashTableOfTensors(scope *Scope, key_dtype tf.DataType, value_dtype tf.DataType, optional ...AnonymousMutableHashTableOfTensorsAttr) (table_handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"key_dtype": key_dtype, "value_dtype": value_dtype}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "AnonymousMutableHashTableOfTensors",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// AnyAttr is an optional argument to Any.
type AnyAttr func(optionalAttr)

// AnyKeepDims sets the optional keep_dims attribute to value.
//
// value: If true, retain reduced dimensions with length 1.
// If not specified, defaults to false
func AnyKeepDims(value bool) AnyAttr {
	return func(m optionalAttr) {
		m["keep_dims"] = value
	}
}

// Computes the "logical or" of elements across dimensions of a tensor.
//
// Reduces `input` along the dimensions given in `axis`. Unless
// `keep_dims` is true, the rank of the tensor is reduced by 1 for each entry in
// `axis`. If `keep_dims` is true, the reduced dimensions are
// retained with length 1.
//
// Arguments:
//
//	input: The tensor to reduce.
//	axis: The dimensions to reduce. Must be in the range
//
// `[-rank(input), rank(input))`.
//
// Returns The reduced tensor.
func Any(scope *Scope, input tf.Output, axis tf.Output, optional ...AnyAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Any",
		Input: []tf.Input{
			input, axis,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ApproxTopKAttr is an optional argument to ApproxTopK.
type ApproxTopKAttr func(optionalAttr)

// ApproxTopKReductionDimension sets the optional reduction_dimension attribute to value.
//
// value: Integer dimension along which to search. Default: -1.
// If not specified, defaults to -1
func ApproxTopKReductionDimension(value int64) ApproxTopKAttr {
	return func(m optionalAttr) {
		m["reduction_dimension"] = value
	}
}

// ApproxTopKRecallTarget sets the optional recall_target attribute to value.
//
// value: Recall target for the approximation. Range in (0,1]
// If not specified, defaults to 0.95
func ApproxTopKRecallTarget(value float32) ApproxTopKAttr {
	return func(m optionalAttr) {
		m["recall_target"] = value
	}
}

// ApproxTopKIsMaxK sets the optional is_max_k attribute to value.
//
// value: When true, computes max-k; otherwise computes min-k.
// If not specified, defaults to true
func ApproxTopKIsMaxK(value bool) ApproxTopKAttr {
	return func(m optionalAttr) {
		m["is_max_k"] = value
	}
}

// ApproxTopKReductionInputSizeOverride sets the optional reduction_input_size_override attribute to value.
//
// value: When set to a positive value, it overrides the size determined by
// `input[reduction_dim]` for evaluating the recall. This option is useful when
// the given `input` is only a subset of the overall computation in SPMD or
// distributed pipelines, where the true input size cannot be deferred by the
// `input` shape.
// If not specified, defaults to -1
func ApproxTopKReductionInputSizeOverride(value int64) ApproxTopKAttr {
	return func(m optionalAttr) {
		m["reduction_input_size_override"] = value
	}
}

// ApproxTopKAggregateToTopk sets the optional aggregate_to_topk attribute to value.
//
// value: When true, aggregates approximate results to top-k. When false, returns the
// approximate results. The number of the approximate results is implementation
// defined and is greater equals to the specified `k`.
// If not specified, defaults to true
func ApproxTopKAggregateToTopk(value bool) ApproxTopKAttr {
	return func(m optionalAttr) {
		m["aggregate_to_topk"] = value
	}
}

// Returns min/max k values and their indices of the input operand in an approximate manner.
//
// See https://arxiv.org/abs/2206.14286 for the algorithm details.
// This op is only optimized on TPU currently.
//
// Arguments:
//
//	input: Array to search. Must be at least 1-D of the floating type
//	k: Specifies the number of min/max-k.
//
// Returns:
//
//	values: The min/max k values along the `reduction_dimension` of the `input` operand.
//
// The dimension are the same as the `input` operand except for the
// `reduction_dimension`: when `aggregate_to_topk` is true, the reduction
// dimension is `k`; otherwise, it is greater equals to `k` where the size is
// implementation-defined.
//
//	indices: The indices of `values` along the `reduction_dimension` of the `input` operand.
func ApproxTopK(scope *Scope, input tf.Output, k int64, optional ...ApproxTopKAttr) (values tf.Output, indices tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"k": k}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ApproxTopK",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// ApproximateEqualAttr is an optional argument to ApproximateEqual.
type ApproximateEqualAttr func(optionalAttr)

// ApproximateEqualTolerance sets the optional tolerance attribute to value.
// If not specified, defaults to 1e-05
func ApproximateEqualTolerance(value float32) ApproximateEqualAttr {
	return func(m optionalAttr) {
		m["tolerance"] = value
	}
}

// Returns the truth value of abs(x-y) < tolerance element-wise.
func ApproximateEqual(scope *Scope, x tf.Output, y tf.Output, optional ...ApproximateEqualAttr) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ApproximateEqual",
		Input: []tf.Input{
			x, y,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ArgMaxAttr is an optional argument to ArgMax.
type ArgMaxAttr func(optionalAttr)

// ArgMaxOutputType sets the optional output_type attribute to value.
// If not specified, defaults to DT_INT64
func ArgMaxOutputType(value tf.DataType) ArgMaxAttr {
	return func(m optionalAttr) {
		m["output_type"] = value
	}
}

// Returns the index with the largest value across dimensions of a tensor.
//
// Note that in case of ties the identity of the return value is not guaranteed.
//
// Usage:
//
//	```python
//	import tensorflow as tf
//	a = [1, 10, 26.9, 2.8, 166.32, 62.3]
//	b = tf.math.argmax(input = a)
//	c = tf.keras.backend.eval(b)
//	# c = 4
//	# here a[4] = 166.32 which is the largest element of a across axis 0
//	```
//
// Arguments:
//
//	dimension: int16, int32 or int64, must be in the range `[-rank(input), rank(input))`.
//
// Describes which dimension of the input Tensor to reduce across. For vectors,
// use dimension = 0.
func ArgMax(scope *Scope, input tf.Output, dimension tf.Output, optional ...ArgMaxAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ArgMax",
		Input: []tf.Input{
			input, dimension,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ArgMinAttr is an optional argument to ArgMin.
type ArgMinAttr func(optionalAttr)

// ArgMinOutputType sets the optional output_type attribute to value.
// If not specified, defaults to DT_INT64
func ArgMinOutputType(value tf.DataType) ArgMinAttr {
	return func(m optionalAttr) {
		m["output_type"] = value
	}
}

// Returns the index with the smallest value across dimensions of a tensor.
//
// Note that in case of ties the identity of the return value is not guaranteed.
//
// Usage:
//
//	```python
//	import tensorflow as tf
//	a = [1, 10, 26.9, 2.8, 166.32, 62.3]
//	b = tf.math.argmin(input = a)
//	c = tf.keras.backend.eval(b)
//	# c = 0
//	# here a[0] = 1 which is the smallest element of a across axis 0
//	```
//
// Arguments:
//
//	dimension: int32 or int64, must be in the range `[-rank(input), rank(input))`.
//
// Describes which dimension of the input Tensor to reduce across. For vectors,
// use dimension = 0.
func ArgMin(scope *Scope, input tf.Output, dimension tf.Output, optional ...ArgMinAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ArgMin",
		Input: []tf.Input{
			input, dimension,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// AsStringAttr is an optional argument to AsString.
type AsStringAttr func(optionalAttr)

// AsStringPrecision sets the optional precision attribute to value.
//
// value: The post-decimal precision to use for floating point numbers.
// Only used if precision > -1.
// If not specified, defaults to -1
func AsStringPrecision(value int64) AsStringAttr {
	return func(m optionalAttr) {
		m["precision"] = value
	}
}

// AsStringScientific sets the optional scientific attribute to value.
//
// value: Use scientific notation for floating point numbers.
// Can't be specified to `True` when `shortest` is set to `True`.
// If not specified, defaults to false
func AsStringScientific(value bool) AsStringAttr {
	return func(m optionalAttr) {
		m["scientific"] = value
	}
}

// AsStringShortest sets the optional shortest attribute to value.
//
// value: Use shortest representation (either scientific or standard) for
// floating point numbers.
// Can't be specified to `True` when `scientific` is set to `True`.
// If not specified, defaults to false
func AsStringShortest(value bool) AsStringAttr {
	return func(m optionalAttr) {
		m["shortest"] = value
	}
}

// AsStringWidth sets the optional width attribute to value.
//
// value: Pad pre-decimal numbers to this width.
// Applies to both floating point and integer numbers.
// Only used if width > -1.
// If not specified, defaults to -1
func AsStringWidth(value int64) AsStringAttr {
	return func(m optionalAttr) {
		m["width"] = value
	}
}

// AsStringFill sets the optional fill attribute to value.
//
// value: The value to pad if width > -1.  If empty, pads with spaces.
// Another typical value is '0'.  String cannot be longer than 1 character.
// If not specified, defaults to ""
func AsStringFill(value string) AsStringAttr {
	return func(m optionalAttr) {
		m["fill"] = value
	}
}

// Converts each entry in the given tensor to strings.
//
// Supports many numeric types and boolean.
//
// For Unicode, see the
// [https://www.tensorflow.org/text/guide/unicode](Working with Unicode text)
// tutorial.
//
// Examples:
//
// >>> tf.strings.as_string([3, 2])
// <tf.Tensor: shape=(2,), dtype=string, numpy=array([b'3', b'2'], dtype=object)>
// >>> tf.strings.as_string([3.1415926, 2.71828], precision=2).numpy()
// array([b'3.14', b'2.72'], dtype=object)
func AsString(scope *Scope, input tf.Output, optional ...AsStringAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "AsString",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the trignometric inverse sine of x element-wise.
//
// The `tf.math.asin` operation returns the inverse of `tf.math.sin`, such that
// if `y = tf.math.sin(x)` then, `x = tf.math.asin(y)`.
//
// **Note**: The output of `tf.math.asin` will lie within the invertible range
// of sine, i.e [-pi/2, pi/2].
//
// For example:
//
// ```python
// # Note: [1.047, 0.785] ~= [(pi/3), (pi/4)]
// x = tf.constant([1.047, 0.785])
// y = tf.math.sin(x) # [0.8659266, 0.7068252]
//
// tf.math.asin(y) # [1.047, 0.785] = x
// ```
func Asin(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Asin",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes inverse hyperbolic sine of x element-wise.
//
//	Given an input tensor, this function computes inverse hyperbolic sine
//	for every element in the tensor. Both input and output has a range of
//	`[-inf, inf]`.
//
//	```python
//	x = tf.constant([-float("inf"), -2, -0.5, 1, 1.2, 200, 10000, float("inf")])
//	tf.math.asinh(x) ==> [-inf -1.4436355 -0.4812118 0.8813736 1.0159732 5.991471 9.903487 inf]
//	```
func Asinh(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Asinh",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// AssertAttr is an optional argument to Assert.
type AssertAttr func(optionalAttr)

// AssertSummarize sets the optional summarize attribute to value.
//
// value: Print this many entries of each tensor.
// If not specified, defaults to 3
func AssertSummarize(value int64) AssertAttr {
	return func(m optionalAttr) {
		m["summarize"] = value
	}
}

// Asserts that the given condition is true.
//
// If `condition` evaluates to false, print the list of tensors in `data`.
// `summarize` determines how many entries of the tensors to print.
//
// Arguments:
//
//	condition: The condition to evaluate.
//	data: The tensors to print out when condition is false.
//
// Returns the created operation.
func Assert(scope *Scope, condition tf.Output, data []tf.Output, optional ...AssertAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Assert",
		Input: []tf.Input{
			condition, tf.OutputList(data),
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// A transformation that asserts which transformations happen next.
//
// This transformation checks whether the camel-case names (i.e. "FlatMap", not
// "flat_map") of the transformations following this transformation match the list
// of names in the `transformations` argument. If there is a mismatch, the
// transformation raises an exception.
//
// The check occurs when iterating over the contents of the dataset, which
// means that the check happens *after* any static optimizations are applied
// to the dataset graph.
//
// Arguments:
//
//	input_dataset: A variant tensor representing the input dataset.
//
// `AssertNextDataset` passes through the outputs of its input dataset.
//
//	transformations: A `tf.string` vector `tf.Tensor` identifying the transformations that are
//
// expected to happen next.
func AssertNextDataset(scope *Scope, input_dataset tf.Output, transformations tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "AssertNextDataset",
		Input: []tf.Input{
			input_dataset, transformations,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// A transformation that asserts which transformations happened previously.
//
// This transformation checks the names and, optionally, the attribute name-value
// pairs in the `transformations` argument against those of the transformations
// that preceded this transformation.  If there is a mismatch, the transformation
// raises an exception.
//
// The check occurs when iterating over the contents of the dataset, which
// means that the check happens *after* any static optimizations are applied
// to the dataset graph.
//
// Arguments:
//
//	input_dataset: A variant tensor representing the input dataset.
//
// `AssertPrevDataset` passes through the outputs of its input dataset.
//
//	transformations: A `tf.string` vector `tf.Tensor` identifying the transformations, with optional
//
// attribute name-value pairs, that are expected to have happened previously.
func AssertPrevDataset(scope *Scope, input_dataset tf.Output, transformations tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "AssertPrevDataset",
		Input: []tf.Input{
			input_dataset, transformations,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Adds a value to the current value of a variable.
//
// Any ReadVariableOp with a control dependency on this op is guaranteed to
// see the incremented value or a subsequent newer one.
//
// Arguments:
//
//	resource: handle to the resource in which to store the variable.
//	value: the value by which the variable will be incremented.
//
// Returns the created operation.
func AssignAddVariableOp(scope *Scope, resource tf.Output, value tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "AssignAddVariableOp",
		Input: []tf.Input{
			resource, value,
		},
	}
	return scope.AddOperation(opspec)
}

// Subtracts a value from the current value of a variable.
//
// Any ReadVariableOp with a control dependency on this op is guaranteed to
// see the decremented value or a subsequent newer one.
//
// Arguments:
//
//	resource: handle to the resource in which to store the variable.
//	value: the value by which the variable will be incremented.
//
// Returns the created operation.
func AssignSubVariableOp(scope *Scope, resource tf.Output, value tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "AssignSubVariableOp",
		Input: []tf.Input{
			resource, value,
		},
	}
	return scope.AddOperation(opspec)
}

// AssignVariableOpAttr is an optional argument to AssignVariableOp.
type AssignVariableOpAttr func(optionalAttr)

// AssignVariableOpValidateShape sets the optional validate_shape attribute to value.
// If not specified, defaults to false
func AssignVariableOpValidateShape(value bool) AssignVariableOpAttr {
	return func(m optionalAttr) {
		m["validate_shape"] = value
	}
}

// Assigns a new value to a variable.
//
// Any ReadVariableOp with a control dependency on this op is guaranteed to return
// this value or a subsequent newer value of the variable.
//
// Arguments:
//
//	resource: handle to the resource in which to store the variable.
//	value: the value to set the new tensor to use.
//
// Returns the created operation.
func AssignVariableOp(scope *Scope, resource tf.Output, value tf.Output, optional ...AssignVariableOpAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "AssignVariableOp",
		Input: []tf.Input{
			resource, value,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// AssignVariableXlaConcatNDAttr is an optional argument to AssignVariableXlaConcatND.
type AssignVariableXlaConcatNDAttr func(optionalAttr)

// AssignVariableXlaConcatNDPaddings sets the optional paddings attribute to value.
//
// value: Optional list of right paddings per dimension to strip from the final merged
// tensor. These paddings must not exceed the dimension size of the merged result
// prior to stripping paddings.
// If not specified, defaults to {}
func AssignVariableXlaConcatNDPaddings(value []int64) AssignVariableXlaConcatNDAttr {
	return func(m optionalAttr) {
		m["paddings"] = value
	}
}

// Concats input tensor across all dimensions.
//
// An op which merges slices the input tensor based on the given num_splits
// attribute, strips paddings optionally, and writes the merged tensor without
// paddings to the resource variable.
//
// This op may be generated via the TPU bridge.
//
// For example, with `input` tensor:
// ```
// [[0, 1],
//
//	[4, 5]]
//
// [[2, 3],
//
//	[6, 7]]
//
// [[8, 9],
//
//	[12, 13]]
//
// [[10, 11],
//
//	[14, 15]]
//
// ```
// `num_splits`:
// ```
// [2, 2]
// ```
// and `paddings`:
// ```
// [1, 1]
// ```
// the expected `outputs` is:
// ```
// [[0, 1, 2],
//
//	[4, 5, 6],
//	[8, 9, 10]]
//
// ```
//
// Arguments:
//
//	resource: Resource variable for concatenated input tensors across all dimensions.
//	inputs: Input tensor slices in row-major order to merge across all dimensions. All
//
// inputs must have the same shape.
//
//	num_concats: Number of ways to merge per dimension.
//
// Returns the created operation.
func AssignVariableXlaConcatND(scope *Scope, resource tf.Output, inputs []tf.Output, num_concats []int64, optional ...AssignVariableXlaConcatNDAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_concats": num_concats}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "AssignVariableXlaConcatND",
		Input: []tf.Input{
			resource, tf.OutputList(inputs),
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// Computes the trignometric inverse tangent of x element-wise.
//
// The `tf.math.atan` operation returns the inverse of `tf.math.tan`, such that
// if `y = tf.math.tan(x)` then, `x = tf.math.atan(y)`.
//
// **Note**: The output of `tf.math.atan` will lie within the invertible range
// of tan, i.e (-pi/2, pi/2).
//
// For example:
//
// ```python
// # Note: [1.047, 0.785] ~= [(pi/3), (pi/4)]
// x = tf.constant([1.047, 0.785])
// y = tf.math.tan(x) # [1.731261, 0.99920404]
//
// tf.math.atan(y) # [1.047, 0.785] = x
// ```
func Atan(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Atan",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes arctangent of `y/x` element-wise, respecting signs of the arguments.
//
// This is the angle \\( \theta \in [-\pi, \pi] \\) such that
// \\[ x = r \cos(\theta) \\]
// and
// \\[ y = r \sin(\theta) \\]
// where \\(r = \sqrt{x^2 + y^2} \\).
//
// For example:
//
// >>> x = [1., 1.]
// >>> y = [1., -1.]
// >>> print((tf.math.atan2(y,x) * (180 / np.pi)).numpy())
// [ 45. -45.]
func Atan2(scope *Scope, y tf.Output, x tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Atan2",
		Input: []tf.Input{
			y, x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes inverse hyperbolic tangent of x element-wise.
//
//	Given an input tensor, this function computes inverse hyperbolic tangent
//	for every element in the tensor. Input range is `[-1,1]` and output range is
//	`[-inf, inf]`. If input is `-1`, output will be `-inf` and if the
//	input is `1`, output will be `inf`. Values outside the range will have
//	`nan` as output.
//
//	```python
//	x = tf.constant([-float("inf"), -1, -0.5, 1, 0, 0.5, 10, float("inf")])
//	tf.math.atanh(x) ==> [nan -inf -0.54930615 inf  0. 0.54930615 nan nan]
//	```
func Atanh(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Atanh",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// AudioSpectrogramAttr is an optional argument to AudioSpectrogram.
type AudioSpectrogramAttr func(optionalAttr)

// AudioSpectrogramMagnitudeSquared sets the optional magnitude_squared attribute to value.
//
// value: Whether to return the squared magnitude or just the
// magnitude. Using squared magnitude can avoid extra calculations.
// If not specified, defaults to false
func AudioSpectrogramMagnitudeSquared(value bool) AudioSpectrogramAttr {
	return func(m optionalAttr) {
		m["magnitude_squared"] = value
	}
}

// Produces a visualization of audio data over time.
//
// Spectrograms are a standard way of representing audio information as a series of
// slices of frequency information, one slice for each window of time. By joining
// these together into a sequence, they form a distinctive fingerprint of the sound
// over time.
//
// This op expects to receive audio data as an input, stored as floats in the range
// -1 to 1, together with a window width in samples, and a stride specifying how
// far to move the window between slices. From this it generates a three
// dimensional output. The first dimension is for the channels in the input, so a
// stereo audio input would have two here for example. The second dimension is time,
// with successive frequency slices. The third dimension has an amplitude value for
// each frequency during that time slice.
//
// This means the layout when converted and saved as an image is rotated 90 degrees
// clockwise from a typical spectrogram. Time is descending down the Y axis, and
// the frequency decreases from left to right.
//
// Each value in the result represents the square root of the sum of the real and
// imaginary parts of an FFT on the current window of samples. In this way, the
// lowest dimension represents the power of each frequency in the current window,
// and adjacent windows are concatenated in the next dimension.
//
// To get a more intuitive and visual look at what this operation does, you can run
// tensorflow/examples/wav_to_spectrogram to read in an audio file and save out the
// resulting spectrogram as a PNG image.
//
// Arguments:
//
//	input: Float representation of audio data.
//	window_size: How wide the input window is in samples. For the highest efficiency
//
// this should be a power of two, but other values are accepted.
//
//	stride: How widely apart the center of adjacent sample windows should be.
//
// Returns 3D representation of the audio frequencies as an image.
func AudioSpectrogram(scope *Scope, input tf.Output, window_size int64, stride int64, optional ...AudioSpectrogramAttr) (spectrogram tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"window_size": window_size, "stride": stride}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "AudioSpectrogram",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// AudioSummaryAttr is an optional argument to AudioSummary.
type AudioSummaryAttr func(optionalAttr)

// AudioSummaryMaxOutputs sets the optional max_outputs attribute to value.
//
// value: Max number of batch elements to generate audio for.
// If not specified, defaults to 3
//
// REQUIRES: value >= 1
func AudioSummaryMaxOutputs(value int64) AudioSummaryAttr {
	return func(m optionalAttr) {
		m["max_outputs"] = value
	}
}

// Outputs a `Summary` protocol buffer with audio.
//
// DEPRECATED at GraphDef version 15: Use AudioSummaryV2.
//
// The summary has up to `max_outputs` summary values containing audio. The
// audio is built from `tensor` which must be 3-D with shape `[batch_size,
// frames, channels]` or 2-D with shape `[batch_size, frames]`. The values are
// assumed to be in the range of `[-1.0, 1.0]` with a sample rate of `sample_rate`.
//
// The `tag` argument is a scalar `Tensor` of type `string`.  It is used to
// build the `tag` of the summary values:
//
//   - If `max_outputs` is 1, the summary value tag is '*tag*/audio'.
//   - If `max_outputs` is greater than 1, the summary value tags are
//     generated sequentially as '*tag*/audio/0', '*tag*/audio/1', etc.
//
// Arguments:
//
//	tag: Scalar. Used to build the `tag` attribute of the summary values.
//	tensor: 2-D of shape `[batch_size, frames]`.
//	sample_rate: The sample rate of the signal in hertz.
//
// Returns Scalar. Serialized `Summary` protocol buffer.
func AudioSummary(scope *Scope, tag tf.Output, tensor tf.Output, sample_rate float32, optional ...AudioSummaryAttr) (summary tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"sample_rate": sample_rate}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "AudioSummary",
		Input: []tf.Input{
			tag, tensor,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// AudioSummaryV2Attr is an optional argument to AudioSummaryV2.
type AudioSummaryV2Attr func(optionalAttr)

// AudioSummaryV2MaxOutputs sets the optional max_outputs attribute to value.
//
// value: Max number of batch elements to generate audio for.
// If not specified, defaults to 3
//
// REQUIRES: value >= 1
func AudioSummaryV2MaxOutputs(value int64) AudioSummaryV2Attr {
	return func(m optionalAttr) {
		m["max_outputs"] = value
	}
}

// Outputs a `Summary` protocol buffer with audio.
//
// The summary has up to `max_outputs` summary values containing audio. The
// audio is built from `tensor` which must be 3-D with shape `[batch_size,
// frames, channels]` or 2-D with shape `[batch_size, frames]`. The values are
// assumed to be in the range of `[-1.0, 1.0]` with a sample rate of `sample_rate`.
//
// The `tag` argument is a scalar `Tensor` of type `string`.  It is used to
// build the `tag` of the summary values:
//
//   - If `max_outputs` is 1, the summary value tag is '*tag*/audio'.
//   - If `max_outputs` is greater than 1, the summary value tags are
//     generated sequentially as '*tag*/audio/0', '*tag*/audio/1', etc.
//
// Arguments:
//
//	tag: Scalar. Used to build the `tag` attribute of the summary values.
//	tensor: 2-D of shape `[batch_size, frames]`.
//	sample_rate: The sample rate of the signal in hertz.
//
// Returns Scalar. Serialized `Summary` protocol buffer.
func AudioSummaryV2(scope *Scope, tag tf.Output, tensor tf.Output, sample_rate tf.Output, optional ...AudioSummaryV2Attr) (summary tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "AudioSummaryV2",
		Input: []tf.Input{
			tag, tensor, sample_rate,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// AutoShardDatasetAttr is an optional argument to AutoShardDataset.
type AutoShardDatasetAttr func(optionalAttr)

// AutoShardDatasetAutoShardPolicy sets the optional auto_shard_policy attribute to value.
// If not specified, defaults to 0
func AutoShardDatasetAutoShardPolicy(value int64) AutoShardDatasetAttr {
	return func(m optionalAttr) {
		m["auto_shard_policy"] = value
	}
}

// AutoShardDatasetNumReplicas sets the optional num_replicas attribute to value.
// If not specified, defaults to 0
func AutoShardDatasetNumReplicas(value int64) AutoShardDatasetAttr {
	return func(m optionalAttr) {
		m["num_replicas"] = value
	}
}

// Creates a dataset that shards the input dataset.
//
// Creates a dataset that shards the input dataset by num_workers, returning a
// sharded dataset for the index-th worker. This attempts to automatically shard
// a dataset by examining the Dataset graph and inserting a shard op before the
// inputs to a reader Dataset (e.g. CSVDataset, TFRecordDataset).
//
// This dataset will throw a NotFound error if we cannot shard the dataset
// automatically.
//
// Arguments:
//
//	input_dataset: A variant tensor representing the input dataset.
//	num_workers: A scalar representing the number of workers to distribute this dataset across.
//	index: A scalar representing the index of the current worker out of num_workers.
func AutoShardDataset(scope *Scope, input_dataset tf.Output, num_workers tf.Output, index tf.Output, output_types []tf.DataType, output_shapes []tf.Shape, optional ...AutoShardDatasetAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "AutoShardDataset",
		Input: []tf.Input{
			input_dataset, num_workers, index,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// AvgPoolAttr is an optional argument to AvgPool.
type AvgPoolAttr func(optionalAttr)

// AvgPoolDataFormat sets the optional data_format attribute to value.
//
// value: Specify the data format of the input and output data. With the
// default format "NHWC", the data is stored in the order of:
//
//	[batch, in_height, in_width, in_channels].
//
// Alternatively, the format could be "NCHW", the data storage order of:
//
//	[batch, in_channels, in_height, in_width].
//
// If not specified, defaults to "NHWC"
func AvgPoolDataFormat(value string) AvgPoolAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Performs average pooling on the input.
//
// Each entry in `output` is the mean of the corresponding size `ksize`
// window in `value`.
//
// Arguments:
//
//	value: 4-D with shape `[batch, height, width, channels]`.
//	ksize: The size of the sliding window for each dimension of `value`.
//	strides: The stride of the sliding window for each dimension of `value`.
//	padding: The type of padding algorithm to use.
//
// Returns The average pooled output tensor.
func AvgPool(scope *Scope, value tf.Output, ksize []int64, strides []int64, padding string, optional ...AvgPoolAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"ksize": ksize, "strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "AvgPool",
		Input: []tf.Input{
			value,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// AvgPool3DAttr is an optional argument to AvgPool3D.
type AvgPool3DAttr func(optionalAttr)

// AvgPool3DDataFormat sets the optional data_format attribute to value.
//
// value: The data format of the input and output data. With the
// default format "NDHWC", the data is stored in the order of:
//
//	[batch, in_depth, in_height, in_width, in_channels].
//
// Alternatively, the format could be "NCDHW", the data storage order is:
//
//	[batch, in_channels, in_depth, in_height, in_width].
//
// If not specified, defaults to "NDHWC"
func AvgPool3DDataFormat(value string) AvgPool3DAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Performs 3D average pooling on the input.
//
// Each entry in `output` is the mean of the corresponding size `ksize` window in
// `value`.
//
// Arguments:
//
//	input: Shape `[batch, depth, rows, cols, channels]` tensor to pool over.
//	ksize: 1-D tensor of length 5. The size of the window for each dimension of
//
// the input tensor. Must have `ksize[0] = ksize[4] = 1`.
//
//	strides: 1-D tensor of length 5. The stride of the sliding window for each
//
// dimension of `input`. Must have `strides[0] = strides[4] = 1`.
//
//	padding: The type of padding algorithm to use.
//
// Returns The average pooled output tensor.
func AvgPool3D(scope *Scope, input tf.Output, ksize []int64, strides []int64, padding string, optional ...AvgPool3DAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"ksize": ksize, "strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "AvgPool3D",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// AvgPool3DGradAttr is an optional argument to AvgPool3DGrad.
type AvgPool3DGradAttr func(optionalAttr)

// AvgPool3DGradDataFormat sets the optional data_format attribute to value.
//
// value: The data format of the input and output data. With the
// default format "NDHWC", the data is stored in the order of:
//
//	[batch, in_depth, in_height, in_width, in_channels].
//
// Alternatively, the format could be "NCDHW", the data storage order is:
//
//	[batch, in_channels, in_depth, in_height, in_width].
//
// If not specified, defaults to "NDHWC"
func AvgPool3DGradDataFormat(value string) AvgPool3DGradAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Computes gradients of average pooling function.
//
// Arguments:
//
//	orig_input_shape: The original input dimensions.
//	grad: Output backprop of shape `[batch, depth, rows, cols, channels]`.
//	ksize: 1-D tensor of length 5. The size of the window for each dimension of
//
// the input tensor. Must have `ksize[0] = ksize[4] = 1`.
//
//	strides: 1-D tensor of length 5. The stride of the sliding window for each
//
// dimension of `input`. Must have `strides[0] = strides[4] = 1`.
//
//	padding: The type of padding algorithm to use.
//
// Returns The backprop for input.
func AvgPool3DGrad(scope *Scope, orig_input_shape tf.Output, grad tf.Output, ksize []int64, strides []int64, padding string, optional ...AvgPool3DGradAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"ksize": ksize, "strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "AvgPool3DGrad",
		Input: []tf.Input{
			orig_input_shape, grad,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// AvgPoolGradAttr is an optional argument to AvgPoolGrad.
type AvgPoolGradAttr func(optionalAttr)

// AvgPoolGradDataFormat sets the optional data_format attribute to value.
//
// value: Specify the data format of the input and output data. With the
// default format "NHWC", the data is stored in the order of:
//
//	[batch, in_height, in_width, in_channels].
//
// Alternatively, the format could be "NCHW", the data storage order of:
//
//	[batch, in_channels, in_height, in_width].
//
// If not specified, defaults to "NHWC"
func AvgPoolGradDataFormat(value string) AvgPoolGradAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Computes gradients of the average pooling function.
//
// Arguments:
//
//	orig_input_shape: 1-D.  Shape of the original input to `avg_pool`.
//	grad: 4-D with shape `[batch, height, width, channels]`.  Gradients w.r.t.
//
// the output of `avg_pool`.
//
//	ksize: The size of the sliding window for each dimension of the input.
//	strides: The stride of the sliding window for each dimension of the input.
//	padding: The type of padding algorithm to use.
//
// Returns 4-D.  Gradients w.r.t. the input of `avg_pool`.
func AvgPoolGrad(scope *Scope, orig_input_shape tf.Output, grad tf.Output, ksize []int64, strides []int64, padding string, optional ...AvgPoolGradAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"ksize": ksize, "strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "AvgPoolGrad",
		Input: []tf.Input{
			orig_input_shape, grad,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// BatchAttr is an optional argument to Batch.
type BatchAttr func(optionalAttr)

// BatchMaxEnqueuedBatches sets the optional max_enqueued_batches attribute to value.
// If not specified, defaults to 10
func BatchMaxEnqueuedBatches(value int64) BatchAttr {
	return func(m optionalAttr) {
		m["max_enqueued_batches"] = value
	}
}

// BatchAllowedBatchSizes sets the optional allowed_batch_sizes attribute to value.
// If not specified, defaults to {}
func BatchAllowedBatchSizes(value []int64) BatchAttr {
	return func(m optionalAttr) {
		m["allowed_batch_sizes"] = value
	}
}

// BatchContainer sets the optional container attribute to value.
// If not specified, defaults to ""
func BatchContainer(value string) BatchAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// BatchSharedName sets the optional shared_name attribute to value.
// If not specified, defaults to ""
func BatchSharedName(value string) BatchAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// BatchBatchingQueue sets the optional batching_queue attribute to value.
// If not specified, defaults to ""
func BatchBatchingQueue(value string) BatchAttr {
	return func(m optionalAttr) {
		m["batching_queue"] = value
	}
}

// Batches all input tensors nondeterministically.
//
// When many instances of this Op are being run concurrently with the same
// container/shared_name in the same device, some will output zero-shaped Tensors
// and others will output Tensors of size up to max_batch_size.
//
// All Tensors in in_tensors are batched together (so, for example, labels and
// features should be batched with a single instance of this operation.
//
// Each invocation of batch emits an `id` scalar which will be used to identify
// this particular invocation when doing unbatch or its gradient.
//
// Each op which emits a non-empty batch will also emit a non-empty batch_index
// Tensor, which, is a [K, 3] matrix where each row contains the invocation's id,
// start, and length of elements of each set of Tensors present in batched_tensors.
//
// Batched tensors are concatenated along the first dimension, and all tensors in
// in_tensors must have the first dimension of the same size.
//
// in_tensors: The tensors to be batched.
// num_batch_threads: Number of scheduling threads for processing batches of work.
//
//	Determines the number of batches processed in parallel.
//
// max_batch_size: Batch sizes will never be bigger than this.
// batch_timeout_micros: Maximum number of microseconds to wait before outputting
//
//	an incomplete batch.
//
// allowed_batch_sizes: Optional list of allowed batch sizes. If left empty, does
//
//	nothing. Otherwise, supplies a list of batch sizes, causing the op to pad
//	batches up to one of those sizes. The entries must increase monotonically, and
//	the final entry must equal max_batch_size.
//
// grad_timeout_micros: The timeout to use for the gradient. See Unbatch.
// batched_tensors: Either empty tensors or a batch of concatenated Tensors.
// batch_index: If out_tensors is non-empty, has information to invert it.
// container: Controls the scope of sharing of this batch.
// id: always contains a scalar with a unique ID for this invocation of Batch.
// shared_name: Concurrently running instances of batch in the same device with the
//
//	same container and shared_name will batch their elements together. If left
//	empty, the op name will be used as the shared name.
//
// T: the types of tensors to be batched.
func Batch(scope *Scope, in_tensors []tf.Output, num_batch_threads int64, max_batch_size int64, batch_timeout_micros int64, grad_timeout_micros int64, optional ...BatchAttr) (batched_tensors []tf.Output, batch_index tf.Output, id tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_batch_threads": num_batch_threads, "max_batch_size": max_batch_size, "batch_timeout_micros": batch_timeout_micros, "grad_timeout_micros": grad_timeout_micros}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Batch",
		Input: []tf.Input{
			tf.OutputList(in_tensors),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if batched_tensors, idx, err = makeOutputList(op, idx, "batched_tensors"); err != nil {
		scope.UpdateErr("Batch", err)
		return
	}
	batch_index = op.Output(idx)
	id = op.Output(idx)
	return batched_tensors, batch_index, id
}

// BatchDatasetAttr is an optional argument to BatchDataset.
type BatchDatasetAttr func(optionalAttr)

// BatchDatasetMetadata sets the optional metadata attribute to value.
// If not specified, defaults to ""
func BatchDatasetMetadata(value string) BatchDatasetAttr {
	return func(m optionalAttr) {
		m["metadata"] = value
	}
}

// Creates a dataset that batches `batch_size` elements from `input_dataset`.
//
// Arguments:
//
//	batch_size: A scalar representing the number of elements to accumulate in a
//
// batch.
func BatchDataset(scope *Scope, input_dataset tf.Output, batch_size tf.Output, output_types []tf.DataType, output_shapes []tf.Shape, optional ...BatchDatasetAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "BatchDataset",
		Input: []tf.Input{
			input_dataset, batch_size,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// BatchDatasetV2Attr is an optional argument to BatchDatasetV2.
type BatchDatasetV2Attr func(optionalAttr)

// BatchDatasetV2ParallelCopy sets the optional parallel_copy attribute to value.
// If not specified, defaults to false
func BatchDatasetV2ParallelCopy(value bool) BatchDatasetV2Attr {
	return func(m optionalAttr) {
		m["parallel_copy"] = value
	}
}

// BatchDatasetV2Metadata sets the optional metadata attribute to value.
// If not specified, defaults to ""
func BatchDatasetV2Metadata(value string) BatchDatasetV2Attr {
	return func(m optionalAttr) {
		m["metadata"] = value
	}
}

// Creates a dataset that batches `batch_size` elements from `input_dataset`.
//
// Arguments:
//
//	batch_size: A scalar representing the number of elements to accumulate in a batch.
//	drop_remainder: A scalar representing whether the last batch should be dropped in case its size
//
// is smaller than desired.
func BatchDatasetV2(scope *Scope, input_dataset tf.Output, batch_size tf.Output, drop_remainder tf.Output, output_types []tf.DataType, output_shapes []tf.Shape, optional ...BatchDatasetV2Attr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "BatchDatasetV2",
		Input: []tf.Input{
			input_dataset, batch_size, drop_remainder,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// BatchMatMulAttr is an optional argument to BatchMatMul.
type BatchMatMulAttr func(optionalAttr)

// BatchMatMulAdjX sets the optional adj_x attribute to value.
//
// value: If `True`, adjoint the slices of `x`. Defaults to `False`.
// If not specified, defaults to false
func BatchMatMulAdjX(value bool) BatchMatMulAttr {
	return func(m optionalAttr) {
		m["adj_x"] = value
	}
}

// BatchMatMulAdjY sets the optional adj_y attribute to value.
//
// value: If `True`, adjoint the slices of `y`. Defaults to `False`.
// If not specified, defaults to false
func BatchMatMulAdjY(value bool) BatchMatMulAttr {
	return func(m optionalAttr) {
		m["adj_y"] = value
	}
}

// BatchMatMulGradX sets the optional grad_x attribute to value.
// If not specified, defaults to false
func BatchMatMulGradX(value bool) BatchMatMulAttr {
	return func(m optionalAttr) {
		m["grad_x"] = value
	}
}

// BatchMatMulGradY sets the optional grad_y attribute to value.
// If not specified, defaults to false
func BatchMatMulGradY(value bool) BatchMatMulAttr {
	return func(m optionalAttr) {
		m["grad_y"] = value
	}
}

// Multiplies slices of two tensors in batches.
//
// Multiplies all slices of `Tensor` `x` and `y` (each slice can be
// viewed as an element of a batch), and arranges the individual results
// in a single output tensor of the same batch size. Each of the
// individual slices can optionally be adjointed (to adjoint a matrix
// means to transpose and conjugate it) before multiplication by setting
// the `adj_x` or `adj_y` flag to `True`, which are by default `False`.
//
// The input tensors `x` and `y` are 2-D or higher with shape `[..., r_x, c_x]`
// and `[..., r_y, c_y]`.
//
// The output tensor is 2-D or higher with shape `[..., r_o, c_o]`, where:
//
//	r_o = c_x if adj_x else r_x
//	c_o = r_y if adj_y else c_y
//
// It is computed as:
//
//	output[..., :, :] = matrix(x[..., :, :]) * matrix(y[..., :, :])
//
// Arguments:
//
//	x: 2-D or higher with shape `[..., r_x, c_x]`.
//	y: 2-D or higher with shape `[..., r_y, c_y]`.
//
// Returns 3-D or higher with shape `[..., r_o, c_o]`
func BatchMatMul(scope *Scope, x tf.Output, y tf.Output, optional ...BatchMatMulAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "BatchMatMul",
		Input: []tf.Input{
			x, y,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// BatchMatMulV2Attr is an optional argument to BatchMatMulV2.
type BatchMatMulV2Attr func(optionalAttr)

// BatchMatMulV2AdjX sets the optional adj_x attribute to value.
//
// value: If `True`, adjoint the slices of `x`. Defaults to `False`.
// If not specified, defaults to false
func BatchMatMulV2AdjX(value bool) BatchMatMulV2Attr {
	return func(m optionalAttr) {
		m["adj_x"] = value
	}
}

// BatchMatMulV2AdjY sets the optional adj_y attribute to value.
//
// value: If `True`, adjoint the slices of `y`. Defaults to `False`.
// If not specified, defaults to false
func BatchMatMulV2AdjY(value bool) BatchMatMulV2Attr {
	return func(m optionalAttr) {
		m["adj_y"] = value
	}
}

// BatchMatMulV2GradX sets the optional grad_x attribute to value.
// If not specified, defaults to false
func BatchMatMulV2GradX(value bool) BatchMatMulV2Attr {
	return func(m optionalAttr) {
		m["grad_x"] = value
	}
}

// BatchMatMulV2GradY sets the optional grad_y attribute to value.
// If not specified, defaults to false
func BatchMatMulV2GradY(value bool) BatchMatMulV2Attr {
	return func(m optionalAttr) {
		m["grad_y"] = value
	}
}

// Multiplies slices of two tensors in batches.
//
// Multiplies all slices of `Tensor` `x` and `y` (each slice can be
// viewed as an element of a batch), and arranges the individual results
// in a single output tensor of the same batch size. Each of the
// individual slices can optionally be adjointed (to adjoint a matrix
// means to transpose and conjugate it) before multiplication by setting
// the `adj_x` or `adj_y` flag to `True`, which are by default `False`.
//
// The input tensors `x` and `y` are 2-D or higher with shape `[..., r_x, c_x]`
// and `[..., r_y, c_y]`.
//
// The output tensor is 2-D or higher with shape `[..., r_o, c_o]`, where:
//
//	r_o = c_x if adj_x else r_x
//	c_o = r_y if adj_y else c_y
//
// It is computed as:
//
//	output[..., :, :] = matrix(x[..., :, :]) * matrix(y[..., :, :])
//
// *NOTE*: `BatchMatMulV2` supports broadcasting in the batch dimensions. More
// about broadcasting
// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html).
//
// Arguments:
//
//	x: 2-D or higher with shape `[..., r_x, c_x]`.
//	y: 2-D or higher with shape `[..., r_y, c_y]`.
//
// Returns 3-D or higher with shape `[..., r_o, c_o]`
func BatchMatMulV2(scope *Scope, x tf.Output, y tf.Output, optional ...BatchMatMulV2Attr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "BatchMatMulV2",
		Input: []tf.Input{
			x, y,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// BatchMatMulV3Attr is an optional argument to BatchMatMulV3.
type BatchMatMulV3Attr func(optionalAttr)

// BatchMatMulV3AdjX sets the optional adj_x attribute to value.
//
// value: If `True`, adjoint the slices of `x`. Defaults to `False`.
// If not specified, defaults to false
func BatchMatMulV3AdjX(value bool) BatchMatMulV3Attr {
	return func(m optionalAttr) {
		m["adj_x"] = value
	}
}

// BatchMatMulV3AdjY sets the optional adj_y attribute to value.
//
// value: If `True`, adjoint the slices of `y`. Defaults to `False`.
// If not specified, defaults to false
func BatchMatMulV3AdjY(value bool) BatchMatMulV3Attr {
	return func(m optionalAttr) {
		m["adj_y"] = value
	}
}

// BatchMatMulV3GradX sets the optional grad_x attribute to value.
// If not specified, defaults to false
func BatchMatMulV3GradX(value bool) BatchMatMulV3Attr {
	return func(m optionalAttr) {
		m["grad_x"] = value
	}
}

// BatchMatMulV3GradY sets the optional grad_y attribute to value.
// If not specified, defaults to false
func BatchMatMulV3GradY(value bool) BatchMatMulV3Attr {
	return func(m optionalAttr) {
		m["grad_y"] = value
	}
}

// Multiplies slices of two tensors in batches.
//
// Multiplies all slices of `Tensor` `x` and `y` (each slice can be
// viewed as an element of a batch), and arranges the individual results
// in a single output tensor of the same batch size. Each of the
// individual slices can optionally be adjointed (to adjoint a matrix
// means to transpose and conjugate it) before multiplication by setting
// the `adj_x` or `adj_y` flag to `True`, which are by default `False`.
//
// The input tensors `x` and `y` are 2-D or higher with shape `[..., r_x, c_x]`
// and `[..., r_y, c_y]`.
//
// The output tensor is 2-D or higher with shape `[..., r_o, c_o]`, where:
//
//	r_o = c_x if adj_x else r_x
//	c_o = r_y if adj_y else c_y
//
// It is computed as:
//
//	output[..., :, :] = matrix(x[..., :, :]) * matrix(y[..., :, :])
//
// *NOTE*: `BatchMatMulV3` supports broadcasting in the batch dimensions. More
// about broadcasting
// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html).
//
// Arguments:
//
//	x: 2-D or higher with shape `[..., r_x, c_x]`.
//	y: 2-D or higher with shape `[..., r_y, c_y]`.
//	Tout: If not spcified, Tout is the same type to input type.
//
// Returns 3-D or higher with shape `[..., r_o, c_o]`
func BatchMatMulV3(scope *Scope, x tf.Output, y tf.Output, Tout tf.DataType, optional ...BatchMatMulV3Attr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"Tout": Tout}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "BatchMatMulV3",
		Input: []tf.Input{
			x, y,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Batch normalization.
//
// DEPRECATED at GraphDef version 9: Use tf.nn.batch_normalization()
//
// This op is deprecated. Prefer `tf.nn.batch_normalization`.
//
// Arguments:
//
//	t: A 4D input Tensor.
//	m: A 1D mean Tensor with size matching the last dimension of t.
//
// This is the first output from tf.nn.moments,
// or a saved moving average thereof.
//
//	v: A 1D variance Tensor with size matching the last dimension of t.
//
// This is the second output from tf.nn.moments,
// or a saved moving average thereof.
//
//	beta: A 1D beta Tensor with size matching the last dimension of t.
//
// An offset to be added to the normalized tensor.
//
//	gamma: A 1D gamma Tensor with size matching the last dimension of t.
//
// If "scale_after_normalization" is true, this tensor will be multiplied
// with the normalized tensor.
//
//	variance_epsilon: A small float number to avoid dividing by 0.
//	scale_after_normalization: A bool indicating whether the resulted tensor
//
// needs to be multiplied with gamma.
func BatchNormWithGlobalNormalization(scope *Scope, t tf.Output, m tf.Output, v tf.Output, beta tf.Output, gamma tf.Output, variance_epsilon float32, scale_after_normalization bool) (result tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"variance_epsilon": variance_epsilon, "scale_after_normalization": scale_after_normalization}
	opspec := tf.OpSpec{
		Type: "BatchNormWithGlobalNormalization",
		Input: []tf.Input{
			t, m, v, beta, gamma,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Gradients for batch normalization.
//
// DEPRECATED at GraphDef version 9: Use tf.nn.batch_normalization()
//
// This op is deprecated. See `tf.nn.batch_normalization`.
//
// Arguments:
//
//	t: A 4D input Tensor.
//	m: A 1D mean Tensor with size matching the last dimension of t.
//
// This is the first output from tf.nn.moments,
// or a saved moving average thereof.
//
//	v: A 1D variance Tensor with size matching the last dimension of t.
//
// This is the second output from tf.nn.moments,
// or a saved moving average thereof.
//
//	gamma: A 1D gamma Tensor with size matching the last dimension of t.
//
// If "scale_after_normalization" is true, this Tensor will be multiplied
// with the normalized Tensor.
//
//	backprop: 4D backprop Tensor.
//	variance_epsilon: A small float number to avoid dividing by 0.
//	scale_after_normalization: A bool indicating whether the resulted tensor
//
// needs to be multiplied with gamma.
//
// Returns:
//
//	dx: 4D backprop tensor for input.
//	dm: 1D backprop tensor for mean.
//	dv: 1D backprop tensor for variance.
//	db: 1D backprop tensor for beta.
//	dg: 1D backprop tensor for gamma.
func BatchNormWithGlobalNormalizationGrad(scope *Scope, t tf.Output, m tf.Output, v tf.Output, gamma tf.Output, backprop tf.Output, variance_epsilon float32, scale_after_normalization bool) (dx tf.Output, dm tf.Output, dv tf.Output, db tf.Output, dg tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"variance_epsilon": variance_epsilon, "scale_after_normalization": scale_after_normalization}
	opspec := tf.OpSpec{
		Type: "BatchNormWithGlobalNormalizationGrad",
		Input: []tf.Input{
			t, m, v, gamma, backprop,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3), op.Output(4)
}

// BatchToSpace for 4-D tensors of type T.
//
// This is a legacy version of the more general BatchToSpaceND.
//
// Rearranges (permutes) data from batch into blocks of spatial data, followed by
// cropping. This is the reverse transformation of SpaceToBatch. More specifically,
// this op outputs a copy of the input tensor where values from the `batch`
// dimension are moved in spatial blocks to the `height` and `width` dimensions,
// followed by cropping along the `height` and `width` dimensions.
//
// Arguments:
//
//	input: 4-D tensor with shape
//
// `[batch*block_size*block_size, height_pad/block_size, width_pad/block_size,
//
//	depth]`. Note that the batch size of the input tensor must be divisible by
//
// `block_size * block_size`.
//
//	crops: 2-D tensor of non-negative integers with shape `[2, 2]`. It specifies
//
// how many elements to crop from the intermediate result across the spatial
// dimensions as follows:
//
//	crops = [[crop_top, crop_bottom], [crop_left, crop_right]]
//
// Returns 4-D with shape `[batch, height, width, depth]`, where:
//
//	height = height_pad - crop_top - crop_bottom
//	width = width_pad - crop_left - crop_right
//
// The attr `block_size` must be greater than one. It indicates the block size.
//
// Some examples:
//
// (1) For the following input of shape `[4, 1, 1, 1]` and block_size of 2:
//
// ```
// [[[[1]]], [[[2]]], [[[3]]], [[[4]]]]
// ```
//
// The output tensor has shape `[1, 2, 2, 1]` and value:
//
// ```
// x = [[[[1], [2]], [[3], [4]]]]
// ```
//
// (2) For the following input of shape `[4, 1, 1, 3]` and block_size of 2:
//
// ```
// [[[[1, 2, 3]]], [[[4, 5, 6]]], [[[7, 8, 9]]], [[[10, 11, 12]]]]
// ```
//
// The output tensor has shape `[1, 2, 2, 3]` and value:
//
// ```
// x = [[[[1, 2, 3], [4, 5, 6]],
//
//	[[7, 8, 9], [10, 11, 12]]]]
//
// ```
//
// (3) For the following input of shape `[4, 2, 2, 1]` and block_size of 2:
//
// ```
// x = [[[[1], [3]], [[9], [11]]],
//
//	[[[2], [4]], [[10], [12]]],
//	[[[5], [7]], [[13], [15]]],
//	[[[6], [8]], [[14], [16]]]]
//
// ```
//
// The output tensor has shape `[1, 4, 4, 1]` and value:
//
// ```
// x = [[[[1],   [2],  [3],  [4]],
//
//	[[5],   [6],  [7],  [8]],
//	[[9],  [10], [11],  [12]],
//	[[13], [14], [15],  [16]]]]
//
// ```
//
// (4) For the following input of shape `[8, 1, 2, 1]` and block_size of 2:
//
// ```
// x = [[[[1], [3]]], [[[9], [11]]], [[[2], [4]]], [[[10], [12]]],
//
//	[[[5], [7]]], [[[13], [15]]], [[[6], [8]]], [[[14], [16]]]]
//
// ```
//
// The output tensor has shape `[2, 2, 4, 1]` and value:
//
// ```
// x = [[[[1], [3]], [[5], [7]]],
//
//	[[[2], [4]], [[10], [12]]],
//	[[[5], [7]], [[13], [15]]],
//	[[[6], [8]], [[14], [16]]]]
//
// ```
func BatchToSpace(scope *Scope, input tf.Output, crops tf.Output, block_size int64) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"block_size": block_size}
	opspec := tf.OpSpec{
		Type: "BatchToSpace",
		Input: []tf.Input{
			input, crops,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// BatchToSpace for N-D tensors of type T.
//
// This operation reshapes the "batch" dimension 0 into `M + 1` dimensions of shape
// `block_shape + [batch]`, interleaves these blocks back into the grid defined by
// the spatial dimensions `[1, ..., M]`, to obtain a result with the same rank as
// the input.  The spatial dimensions of this intermediate result are then
// optionally cropped according to `crops` to produce the output.  This is the
// reverse of SpaceToBatch.  See below for a precise description.
//
// Arguments:
//
//	input: N-D with shape `input_shape = [batch] + spatial_shape + remaining_shape`,
//
// where spatial_shape has M dimensions.
//
//		block_shape: 1-D with shape `[M]`, all values must be >= 1.
//		crops: 2-D with shape `[M, 2]`, all values must be >= 0.
//	  `crops[i] = [crop_start, crop_end]` specifies the amount to crop from input
//	  dimension `i + 1`, which corresponds to spatial dimension `i`.  It is
//	  required that
//	  `crop_start[i] + crop_end[i] <= block_shape[i] * input_shape[i + 1]`.
//
// This operation is equivalent to the following steps:
//
//  1. Reshape `input` to `reshaped` of shape:
//     [block_shape[0], ..., block_shape[M-1],
//     batch / prod(block_shape),
//     input_shape[1], ..., input_shape[N-1]]
//
//  2. Permute dimensions of `reshaped` to produce `permuted` of shape
//     [batch / prod(block_shape),
//
//     input_shape[1], block_shape[0],
//     ...,
//     input_shape[M], block_shape[M-1],
//
//     input_shape[M+1], ..., input_shape[N-1]]
//
//  3. Reshape `permuted` to produce `reshaped_permuted` of shape
//     [batch / prod(block_shape),
//
//     input_shape[1] * block_shape[0],
//     ...,
//     input_shape[M] * block_shape[M-1],
//
//     input_shape[M+1],
//     ...,
//     input_shape[N-1]]
//
//  4. Crop the start and end of dimensions `[1, ..., M]` of
//     `reshaped_permuted` according to `crops` to produce the output of shape:
//     [batch / prod(block_shape),
//
//     input_shape[1] * block_shape[0] - crops[0,0] - crops[0,1],
//     ...,
//     input_shape[M] * block_shape[M-1] - crops[M-1,0] - crops[M-1,1],
//
//     input_shape[M+1], ..., input_shape[N-1]]
//
// Some examples:
//
// (1) For the following input of shape `[4, 1, 1, 1]`, `block_shape = [2, 2]`, and
//
//	`crops = [[0, 0], [0, 0]]`:
//
// ```
// [[[[1]]], [[[2]]], [[[3]]], [[[4]]]]
// ```
//
// The output tensor has shape `[1, 2, 2, 1]` and value:
//
// ```
// x = [[[[1], [2]], [[3], [4]]]]
// ```
//
// (2) For the following input of shape `[4, 1, 1, 3]`, `block_shape = [2, 2]`, and
//
//	`crops = [[0, 0], [0, 0]]`:
//
// ```
// [[[[1, 2, 3]]], [[[4, 5, 6]]], [[[7, 8, 9]]], [[[10, 11, 12]]]]
// ```
//
// The output tensor has shape `[1, 2, 2, 3]` and value:
//
// ```
// x = [[[[1, 2, 3], [4, 5, 6]],
//
//	[[7, 8, 9], [10, 11, 12]]]]
//
// ```
//
// (3) For the following input of shape `[4, 2, 2, 1]`, `block_shape = [2, 2]`, and
//
//	`crops = [[0, 0], [0, 0]]`:
//
// ```
// x = [[[[1], [3]], [[9], [11]]],
//
//	[[[2], [4]], [[10], [12]]],
//	[[[5], [7]], [[13], [15]]],
//	[[[6], [8]], [[14], [16]]]]
//
// ```
//
// The output tensor has shape `[1, 4, 4, 1]` and value:
//
// ```
// x = [[[[1],   [2],  [3],  [4]],
//
//	[[5],   [6],  [7],  [8]],
//	[[9],  [10], [11],  [12]],
//	[[13], [14], [15],  [16]]]]
//
// ```
//
// (4) For the following input of shape `[8, 1, 3, 1]`, `block_shape = [2, 2]`, and
//
//	`crops = [[0, 0], [2, 0]]`:
//
// ```
// x = [[[[0], [1], [3]]], [[[0], [9], [11]]],
//
//	[[[0], [2], [4]]], [[[0], [10], [12]]],
//	[[[0], [5], [7]]], [[[0], [13], [15]]],
//	[[[0], [6], [8]]], [[[0], [14], [16]]]]
//
// ```
//
// The output tensor has shape `[2, 2, 4, 1]` and value:
//
// ```
// x = [[[[1],   [2],  [3],  [4]],
//
//	 [[5],   [6],  [7],  [8]]],
//	[[[9],  [10], [11],  [12]],
//	 [[13], [14], [15],  [16]]]]
//
// ```
func BatchToSpaceND(scope *Scope, input tf.Output, block_shape tf.Output, crops tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "BatchToSpaceND",
		Input: []tf.Input{
			input, block_shape, crops,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Compute the regularized incomplete beta integral \\(I_x(a, b)\\).
//
// The regularized incomplete beta integral is defined as:
//
// \\(I_x(a, b) = \frac{B(x; a, b)}{B(a, b)}\\)
//
// where
//
// \\(B(x; a, b) = \int_0^x t^{a-1} (1 - t)^{b-1} dt\\)
//
// is the incomplete beta function and \\(B(a, b)\\) is the *complete*
// beta function.
func Betainc(scope *Scope, a tf.Output, b tf.Output, x tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Betainc",
		Input: []tf.Input{
			a, b, x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// BiasAddAttr is an optional argument to BiasAdd.
type BiasAddAttr func(optionalAttr)

// BiasAddDataFormat sets the optional data_format attribute to value.
//
// value: Specify the data format of the input and output data. With the
// default format "NHWC", the bias tensor will be added to the last dimension
// of the value tensor.
// Alternatively, the format could be "NCHW", the data storage order of:
//
//	[batch, in_channels, in_height, in_width].
//
// The tensor will be added to "in_channels", the third-to-the-last
//
//	dimension.
//
// If not specified, defaults to "NHWC"
func BiasAddDataFormat(value string) BiasAddAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Adds `bias` to `value`.
//
// This is a special case of `tf.add` where `bias` is restricted to be 1-D.
// Broadcasting is supported, so `value` may have any number of dimensions.
//
// Arguments:
//
//	value: Any number of dimensions.
//	bias: 1-D with size the last dimension of `value`.
//
// Returns Broadcasted sum of `value` and `bias`.
func BiasAdd(scope *Scope, value tf.Output, bias tf.Output, optional ...BiasAddAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "BiasAdd",
		Input: []tf.Input{
			value, bias,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// BiasAddGradAttr is an optional argument to BiasAddGrad.
type BiasAddGradAttr func(optionalAttr)

// BiasAddGradDataFormat sets the optional data_format attribute to value.
//
// value: Specify the data format of the input and output data. With the
// default format "NHWC", the bias tensor will be added to the last dimension
// of the value tensor.
// Alternatively, the format could be "NCHW", the data storage order of:
//
//	[batch, in_channels, in_height, in_width].
//
// The tensor will be added to "in_channels", the third-to-the-last
//
//	dimension.
//
// If not specified, defaults to "NHWC"
func BiasAddGradDataFormat(value string) BiasAddGradAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// The backward operation for "BiasAdd" on the "bias" tensor.
//
// It accumulates all the values from out_backprop into the feature dimension.
// For NHWC data format, the feature dimension is the last. For NCHW data format,
// the feature dimension is the third-to-last.
//
// Arguments:
//
//	out_backprop: Any number of dimensions.
//
// Returns 1-D with size the feature dimension of `out_backprop`.
func BiasAddGrad(scope *Scope, out_backprop tf.Output, optional ...BiasAddGradAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "BiasAddGrad",
		Input: []tf.Input{
			out_backprop,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Adds `bias` to `value`.
//
// This is a deprecated version of BiasAdd and will be soon removed.
//
// This is a special case of `tf.add` where `bias` is restricted to be 1-D.
// Broadcasting is supported, so `value` may have any number of dimensions.
//
// Arguments:
//
//	value: Any number of dimensions.
//	bias: 1-D with size the last dimension of `value`.
//
// Returns Broadcasted sum of `value` and `bias`.
func BiasAddV1(scope *Scope, value tf.Output, bias tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "BiasAddV1",
		Input: []tf.Input{
			value, bias,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Counts the number of occurrences of each value in an integer array.
//
// Outputs a vector with length `size` and the same dtype as `weights`. If
// `weights` are empty, then index `i` stores the number of times the value `i` is
// counted in `arr`. If `weights` are non-empty, then index `i` stores the sum of
// the value in `weights` at each index where the corresponding value in `arr` is
// `i`.
//
// Values in `arr` outside of the range [0, size) are ignored.
//
// Arguments:
//
//	arr: int32 `Tensor`.
//	size: non-negative int32 scalar `Tensor`.
//	weights: is an int32, int64, float32, or float64 `Tensor` with the same
//
// shape as `arr`, or a length-0 `Tensor`, in which case it acts as all weights
// equal to 1.
//
// Returns 1D `Tensor` with length equal to `size`. The counts or summed weights for
// each value in the range [0, size).
func Bincount(scope *Scope, arr tf.Output, size tf.Output, weights tf.Output) (bins tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Bincount",
		Input: []tf.Input{
			arr, size, weights,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Bitcasts a tensor from one type to another without copying data.
//
// Given a tensor `input`, this operation returns a tensor that has the same buffer
// data as `input` with datatype `type`.
//
// If the input datatype `T` is larger than the output datatype `type` then the
// shape changes from [...] to [..., sizeof(`T`)/sizeof(`type`)].
//
// If `T` is smaller than `type`, the operator requires that the rightmost
// dimension be equal to sizeof(`type`)/sizeof(`T`). The shape then goes from
// [..., sizeof(`type`)/sizeof(`T`)] to [...].
//
// tf.bitcast() and tf.cast() work differently when real dtype is casted as a complex dtype
// (e.g. tf.complex64 or tf.complex128) as tf.cast() make imaginary part 0 while tf.bitcast()
// gives module error.
// For example,
//
// Example 1:
//
// >>> a = [1., 2., 3.]
// >>> equality_bitcast = tf.bitcast(a, tf.complex128)
// Traceback (most recent call last):
// ...
// InvalidArgumentError: Cannot bitcast from 1 to 18 [Op:Bitcast]
// >>> equality_cast = tf.cast(a, tf.complex128)
// >>> print(equality_cast)
// tf.Tensor([1.+0.j 2.+0.j 3.+0.j], shape=(3,), dtype=complex128)
//
// Example 2:
//
// >>> tf.bitcast(tf.constant(0xffffffff, dtype=tf.uint32), tf.uint8)
// <tf.Tensor: shape=(4,), dtype=uint8, numpy=array([255, 255, 255, 255], dtype=uint8)>
//
// Example 3:
//
// >>> x = [1., 2., 3.]
// >>> y = [0., 2., 3.]
// >>> equality= tf.equal(x,y)
// >>> equality_cast = tf.cast(equality,tf.float32)
// >>> equality_bitcast = tf.bitcast(equality_cast,tf.uint8)
// >>> print(equality)
// tf.Tensor([False True True], shape=(3,), dtype=bool)
// >>> print(equality_cast)
// tf.Tensor([0. 1. 1.], shape=(3,), dtype=float32)
// >>> print(equality_bitcast)
// tf.Tensor(
//
//	[[  0   0   0   0]
//	 [  0   0 128  63]
//	 [  0   0 128  63]], shape=(3, 4), dtype=uint8)
//
// *NOTE*: Bitcast is implemented as a low-level cast, so machines with different
// endian orderings will give different results. A copy from input buffer to output
// buffer is made on BE machines when types are of different sizes in order to get
// the same casting results as on LE machines.
func Bitcast(scope *Scope, input tf.Output, type_ tf.DataType) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"type": type_}
	opspec := tf.OpSpec{
		Type: "Bitcast",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Elementwise computes the bitwise AND of `x` and `y`.
//
// The result will have those bits set, that are set in both `x` and `y`. The
// computation is performed on the underlying representations of `x` and `y`.
//
// For example:
//
// ```python
// import tensorflow as tf
// from tensorflow.python.ops import bitwise_ops
// dtype_list = [tf.int8, tf.int16, tf.int32, tf.int64,
//
//	tf.uint8, tf.uint16, tf.uint32, tf.uint64]
//
// for dtype in dtype_list:
//
//	lhs = tf.constant([0, 5, 3, 14], dtype=dtype)
//	rhs = tf.constant([5, 0, 7, 11], dtype=dtype)
//	exp = tf.constant([0, 0, 3, 10], dtype=tf.float32)
//
//	res = bitwise_ops.bitwise_and(lhs, rhs)
//	tf.assert_equal(tf.cast(res, tf.float32), exp) # TRUE
//
// ```
func BitwiseAnd(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "BitwiseAnd",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Elementwise computes the bitwise OR of `x` and `y`.
//
// The result will have those bits set, that are set in `x`, `y` or both. The
// computation is performed on the underlying representations of `x` and `y`.
//
// For example:
//
// ```python
// import tensorflow as tf
// from tensorflow.python.ops import bitwise_ops
// dtype_list = [tf.int8, tf.int16, tf.int32, tf.int64,
//
//	tf.uint8, tf.uint16, tf.uint32, tf.uint64]
//
// for dtype in dtype_list:
//
//	lhs = tf.constant([0, 5, 3, 14], dtype=dtype)
//	rhs = tf.constant([5, 0, 7, 11], dtype=dtype)
//	exp = tf.constant([5, 5, 7, 15], dtype=tf.float32)
//
//	res = bitwise_ops.bitwise_or(lhs, rhs)
//	tf.assert_equal(tf.cast(res,  tf.float32), exp)  # TRUE
//
// ```
func BitwiseOr(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "BitwiseOr",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Elementwise computes the bitwise XOR of `x` and `y`.
//
// The result will have those bits set, that are different in `x` and `y`. The
// computation is performed on the underlying representations of `x` and `y`.
//
// For example:
//
// ```python
// import tensorflow as tf
// from tensorflow.python.ops import bitwise_ops
// dtype_list = [tf.int8, tf.int16, tf.int32, tf.int64,
//
//	tf.uint8, tf.uint16, tf.uint32, tf.uint64]
//
// for dtype in dtype_list:
//
//	lhs = tf.constant([0, 5, 3, 14], dtype=dtype)
//	rhs = tf.constant([5, 0, 7, 11], dtype=dtype)
//	exp = tf.constant([5, 5, 4, 5],  dtype=tf.float32)
//
//	res = bitwise_ops.bitwise_xor(lhs, rhs)
//	tf.assert_equal(tf.cast(res, tf.float32), exp) # TRUE
//
// ```
func BitwiseXor(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "BitwiseXor",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// BlockLSTMAttr is an optional argument to BlockLSTM.
type BlockLSTMAttr func(optionalAttr)

// BlockLSTMForgetBias sets the optional forget_bias attribute to value.
//
// value: The forget gate bias.
// If not specified, defaults to 1
func BlockLSTMForgetBias(value float32) BlockLSTMAttr {
	return func(m optionalAttr) {
		m["forget_bias"] = value
	}
}

// BlockLSTMCellClip sets the optional cell_clip attribute to value.
//
// value: Value to clip the 'cs' value to.
// If not specified, defaults to 3
func BlockLSTMCellClip(value float32) BlockLSTMAttr {
	return func(m optionalAttr) {
		m["cell_clip"] = value
	}
}

// BlockLSTMUsePeephole sets the optional use_peephole attribute to value.
//
// value: Whether to use peephole weights.
// If not specified, defaults to false
func BlockLSTMUsePeephole(value bool) BlockLSTMAttr {
	return func(m optionalAttr) {
		m["use_peephole"] = value
	}
}

// Computes the LSTM cell forward propagation for all the time steps.
//
// This is equivalent to applying LSTMBlockCell in a loop, like so:
//
// ```python
// for x1 in unpack(x):
//
//	i1, cs1, f1, o1, ci1, co1, h1 = LSTMBlock(
//	  x1, cs_prev, h_prev, w, wci, wcf, wco, b)
//	cs_prev = cs1
//	h_prev = h1
//	i.append(i1)
//	cs.append(cs1)
//	f.append(f1)
//	o.append(o1)
//	ci.append(ci1)
//	co.append(co1)
//	h.append(h1)
//
// return pack(i), pack(cs), pack(f), pack(o), pack(ci), pack(ch), pack(h)
// ```
//
// Arguments:
//
//	seq_len_max: Maximum time length actually used by this input. Outputs are padded
//
// with zeros beyond this length.
//
//	x: The sequence input to the LSTM, shape (timelen, batch_size, num_inputs).
//	cs_prev: Value of the initial cell state.
//	h_prev: Initial output of cell (to be used for peephole).
//	w: The weight matrix.
//	wci: The weight matrix for input gate peephole connection.
//	wcf: The weight matrix for forget gate peephole connection.
//	wco: The weight matrix for output gate peephole connection.
//	b: The bias vector.
//
// Returns:
//
//	i: The input gate over the whole time sequence.
//	cs: The cell state before the tanh over the whole time sequence.
//	f: The forget gate over the whole time sequence.
//	o: The output gate over the whole time sequence.
//	ci: The cell input over the whole time sequence.
//	co: The cell after the tanh over the whole time sequence.
//	h: The output h vector over the whole time sequence.
func BlockLSTM(scope *Scope, seq_len_max tf.Output, x tf.Output, cs_prev tf.Output, h_prev tf.Output, w tf.Output, wci tf.Output, wcf tf.Output, wco tf.Output, b tf.Output, optional ...BlockLSTMAttr) (i tf.Output, cs tf.Output, f tf.Output, o tf.Output, ci tf.Output, co tf.Output, h tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "BlockLSTM",
		Input: []tf.Input{
			seq_len_max, x, cs_prev, h_prev, w, wci, wcf, wco, b,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3), op.Output(4), op.Output(5), op.Output(6)
}

// Computes the LSTM cell backward propagation for the entire time sequence.
//
// This implementation is to be used in conjunction of LSTMBlock.
//
// Arguments:
//
//	seq_len_max: Maximum time length actually used by this input. Outputs are padded
//
// with zeros beyond this length.
//
//	x: The sequence input to the LSTM, shape (timelen, batch_size, num_inputs).
//	cs_prev: Value of the initial cell state.
//	h_prev: Initial output of cell (to be used for peephole).
//	w: The weight matrix.
//	wci: The weight matrix for input gate peephole connection.
//	wcf: The weight matrix for forget gate peephole connection.
//	wco: The weight matrix for output gate peephole connection.
//	b: The bias vector.
//	i: The input gate over the whole time sequence.
//	cs: The cell state before the tanh over the whole time sequence.
//	f: The forget gate over the whole time sequence.
//	o: The output gate over the whole time sequence.
//	ci: The cell input over the whole time sequence.
//	co: The cell after the tanh over the whole time sequence.
//	h: The output h vector over the whole time sequence.
//	cs_grad: The current gradient of cs.
//	h_grad: The gradient of h vector.
//	use_peephole: Whether to use peephole weights.
//
// Returns:
//
//	x_grad: The gradient of x to be back-propped.
//	cs_prev_grad: The gradient of cs_prev to be back-propped.
//	h_prev_grad: The gradient of h_prev to be back-propped.
//	w_grad: The gradient for w to be back-propped.
//	wci_grad: The gradient for wci to be back-propped.
//	wcf_grad: The gradient for wcf to be back-propped.
//	wco_grad: The gradient for wco to be back-propped.
//	b_grad: The gradient for w to be back-propped.
func BlockLSTMGrad(scope *Scope, seq_len_max tf.Output, x tf.Output, cs_prev tf.Output, h_prev tf.Output, w tf.Output, wci tf.Output, wcf tf.Output, wco tf.Output, b tf.Output, i tf.Output, cs tf.Output, f tf.Output, o tf.Output, ci tf.Output, co tf.Output, h tf.Output, cs_grad tf.Output, h_grad tf.Output, use_peephole bool) (x_grad tf.Output, cs_prev_grad tf.Output, h_prev_grad tf.Output, w_grad tf.Output, wci_grad tf.Output, wcf_grad tf.Output, wco_grad tf.Output, b_grad tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"use_peephole": use_peephole}
	opspec := tf.OpSpec{
		Type: "BlockLSTMGrad",
		Input: []tf.Input{
			seq_len_max, x, cs_prev, h_prev, w, wci, wcf, wco, b, i, cs, f, o, ci, co, h, cs_grad, h_grad,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3), op.Output(4), op.Output(5), op.Output(6), op.Output(7)
}

// Computes the LSTM cell backward propagation for the entire time sequence.
//
// This implementation is to be used in conjunction of BlockLSTMV2.
//
// Arguments:
//
//	seq_len_max: Maximum time length actually used by this input. Outputs are padded
//
// with zeros beyond this length.
//
//	x: The sequence input to the LSTM, shape (timelen, batch_size, num_inputs).
//	cs_prev: Value of the initial cell state.
//	h_prev: Initial output of cell (to be used for peephole).
//	w: The weight matrix.
//	wci: The weight matrix for input gate peephole connection.
//	wcf: The weight matrix for forget gate peephole connection.
//	wco: The weight matrix for output gate peephole connection.
//	b: The bias vector.
//	i: The input gate over the whole time sequence.
//	cs: The cell state before the tanh over the whole time sequence.
//	f: The forget gate over the whole time sequence.
//	o: The output gate over the whole time sequence.
//	ci: The cell input over the whole time sequence.
//	co: The cell after the tanh over the whole time sequence.
//	h: The output h vector over the whole time sequence.
//	cs_grad: The current gradient of cs.
//	h_grad: The gradient of h vector.
//	use_peephole: Whether to use peephole weights.
//
// Returns:
//
//	x_grad: The gradient of x to be back-propped.
//	cs_prev_grad: The gradient of cs_prev to be back-propped.
//	h_prev_grad: The gradient of h_prev to be back-propped.
//	w_grad: The gradient for w to be back-propped.
//	wci_grad: The gradient for wci to be back-propped.
//	wcf_grad: The gradient for wcf to be back-propped.
//	wco_grad: The gradient for wco to be back-propped.
//	b_grad: The gradient for w to be back-propped.
func BlockLSTMGradV2(scope *Scope, seq_len_max tf.Output, x tf.Output, cs_prev tf.Output, h_prev tf.Output, w tf.Output, wci tf.Output, wcf tf.Output, wco tf.Output, b tf.Output, i tf.Output, cs tf.Output, f tf.Output, o tf.Output, ci tf.Output, co tf.Output, h tf.Output, cs_grad tf.Output, h_grad tf.Output, use_peephole bool) (x_grad tf.Output, cs_prev_grad tf.Output, h_prev_grad tf.Output, w_grad tf.Output, wci_grad tf.Output, wcf_grad tf.Output, wco_grad tf.Output, b_grad tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"use_peephole": use_peephole}
	opspec := tf.OpSpec{
		Type: "BlockLSTMGradV2",
		Input: []tf.Input{
			seq_len_max, x, cs_prev, h_prev, w, wci, wcf, wco, b, i, cs, f, o, ci, co, h, cs_grad, h_grad,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3), op.Output(4), op.Output(5), op.Output(6), op.Output(7)
}

// BlockLSTMV2Attr is an optional argument to BlockLSTMV2.
type BlockLSTMV2Attr func(optionalAttr)

// BlockLSTMV2CellClip sets the optional cell_clip attribute to value.
//
// value: Value to clip the 'cs' value to.
// If not specified, defaults to 0
func BlockLSTMV2CellClip(value float32) BlockLSTMV2Attr {
	return func(m optionalAttr) {
		m["cell_clip"] = value
	}
}

// BlockLSTMV2UsePeephole sets the optional use_peephole attribute to value.
//
// value: Whether to use peephole weights.
// If not specified, defaults to false
func BlockLSTMV2UsePeephole(value bool) BlockLSTMV2Attr {
	return func(m optionalAttr) {
		m["use_peephole"] = value
	}
}

// Computes the LSTM cell forward propagation for all the time steps.
//
// This is equivalent to applying LSTMBlockCell in a loop, like so:
//
// ```python
// for x1 in unpack(x):
//
//	i1, cs1, f1, o1, ci1, co1, h1 = LSTMBlock(
//	  x1, cs_prev, h_prev, w, wci, wcf, wco, b)
//	cs_prev = cs1
//	h_prev = h1
//	i.append(i1)
//	cs.append(cs1)
//	f.append(f1)
//	o.append(o1)
//	ci.append(ci1)
//	co.append(co1)
//	h.append(h1)
//
// return pack(i), pack(cs), pack(f), pack(o), pack(ci), pack(ch), pack(h)
//
// Note that unlike LSTMBlockCell (and BlockLSTM) which uses ICFO gate layout,
// this op uses IFCO. So in order for the following snippet to be equivalent
// all gate-related outputs should be reordered.
// ```
//
// Arguments:
//
//	seq_len_max: Maximum time length actually used by this input. Outputs are padded
//
// with zeros beyond this length.
//
//	x: The sequence input to the LSTM, shape (timelen, batch_size, num_inputs).
//	cs_prev: Value of the initial cell state.
//	h_prev: Initial output of cell (to be used for peephole).
//	w: The weight matrix.
//	wci: The weight matrix for input gate peephole connection.
//	wcf: The weight matrix for forget gate peephole connection.
//	wco: The weight matrix for output gate peephole connection.
//	b: The bias vector.
//
// Returns:
//
//	i: The input gate over the whole time sequence.
//	cs: The cell state before the tanh over the whole time sequence.
//	f: The forget gate over the whole time sequence.
//	o: The output gate over the whole time sequence.
//	ci: The cell input over the whole time sequence.
//	co: The cell after the tanh over the whole time sequence.
//	h: The output h vector over the whole time sequence.
func BlockLSTMV2(scope *Scope, seq_len_max tf.Output, x tf.Output, cs_prev tf.Output, h_prev tf.Output, w tf.Output, wci tf.Output, wcf tf.Output, wco tf.Output, b tf.Output, optional ...BlockLSTMV2Attr) (i tf.Output, cs tf.Output, f tf.Output, o tf.Output, ci tf.Output, co tf.Output, h tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "BlockLSTMV2",
		Input: []tf.Input{
			seq_len_max, x, cs_prev, h_prev, w, wci, wcf, wco, b,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3), op.Output(4), op.Output(5), op.Output(6)
}

// Aggregates the summary of accumulated stats for the batch.
//
// The summary stats contains gradients and hessians accumulated for each node, feature dimension id and bucket.
//
// Arguments:
//
//	node_ids: int32; Rank 1 Tensor containing node ids for each example, shape [batch_size].
//	gradients: float32; Rank 2 Tensor (shape=[batch_size, logits_dimension]) with gradients for each example.
//	hessians: float32; Rank 2 Tensor (shape=[batch_size, hessian_dimension]) with hessians for each example.
//	feature: int32; Rank 2 feature Tensors (shape=[batch_size, feature_dimension]).
//	max_splits: int; the maximum number of splits possible in the whole tree.
//	num_buckets: int; equals to the maximum possible value of bucketized feature.
//
// Returns output Rank 4 Tensor (shape=[splits, feature_dimension, buckets, logits_dimension + hessian_dimension])
// containing accumulated stats for each node, feature dimension and bucket.
func BoostedTreesAggregateStats(scope *Scope, node_ids tf.Output, gradients tf.Output, hessians tf.Output, feature tf.Output, max_splits int64, num_buckets int64) (stats_summary tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"max_splits": max_splits, "num_buckets": num_buckets}
	opspec := tf.OpSpec{
		Type: "BoostedTreesAggregateStats",
		Input: []tf.Input{
			node_ids, gradients, hessians, feature,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Bucketize each feature based on bucket boundaries.
//
// An op that returns a list of float tensors, where each tensor represents the
// bucketized values for a single feature.
//
// Arguments:
//
//	float_values: float; List of Rank 1 Tensor each containing float values for a single feature.
//	bucket_boundaries: float; List of Rank 1 Tensors each containing the bucket boundaries for a single
//
// feature.
//
// Returns int; List of Rank 1 Tensors each containing the bucketized values for a single feature.
func BoostedTreesBucketize(scope *Scope, float_values []tf.Output, bucket_boundaries []tf.Output) (buckets []tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "BoostedTreesBucketize",
		Input: []tf.Input{
			tf.OutputList(float_values), tf.OutputList(bucket_boundaries),
		},
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if buckets, idx, err = makeOutputList(op, idx, "buckets"); err != nil {
		scope.UpdateErr("BoostedTreesBucketize", err)
		return
	}
	return buckets
}

// BoostedTreesCalculateBestFeatureSplitAttr is an optional argument to BoostedTreesCalculateBestFeatureSplit.
type BoostedTreesCalculateBestFeatureSplitAttr func(optionalAttr)

// BoostedTreesCalculateBestFeatureSplitSplitType sets the optional split_type attribute to value.
//
// value: A string indicating if this Op should perform inequality split or equality split.
// If not specified, defaults to "inequality"
func BoostedTreesCalculateBestFeatureSplitSplitType(value string) BoostedTreesCalculateBestFeatureSplitAttr {
	return func(m optionalAttr) {
		m["split_type"] = value
	}
}

// Calculates gains for each feature and returns the best possible split information for the feature.
//
// The split information is the best threshold (bucket id), gains and left/right node contributions per node for each feature.
//
// It is possible that not all nodes can be split on each feature. Hence, the list of possible nodes can differ between the features. Therefore, we return `node_ids_list` for each feature, containing the list of nodes that this feature can be used to split.
//
// In this manner, the output is the best split per features and per node, so that it needs to be combined later to produce the best split for each node (among all possible features).
//
// The output shapes are compatible in a way that the first dimension of all tensors are the same and equal to the number of possible split nodes for each feature.
//
// Arguments:
//
//	node_id_range: A Rank 1 tensor (shape=[2]) to specify the range [first, last) of node ids to process within `stats_summary_list`. The nodes are iterated between the two nodes specified by the tensor, as like `for node_id in range(node_id_range[0], node_id_range[1])` (Note that the last index node_id_range[1] is exclusive).
//	stats_summary: A Rank 4 tensor (#shape=[max_splits, feature_dims, bucket, stats_dims]) for accumulated stats summary (gradient/hessian) per node, per dimension, per buckets for each feature.
//
// The first dimension of the tensor is the maximum number of splits, and thus not all elements of it will be used, but only the indexes specified by node_ids will be used.
//
//	l1: l1 regularization factor on leaf weights, per instance based.
//	l2: l2 regularization factor on leaf weights, per instance based.
//	tree_complexity: adjustment to the gain, per leaf based.
//	min_node_weight: minimum avg of hessians in a node before required for the node to be considered for splitting.
//	logits_dimension: The dimension of logit, i.e., number of classes.
//
// Returns:
//
//	node_ids: A Rank 1 tensors indicating possible split node ids for each feature. The length of the list is num_features, but each tensor has different size as each feature provides different possible nodes. See above for details like shapes and sizes.
//	gains: A Rank 1 tensors indicating the best gains for each feature to split for certain nodes. See above for details like shapes and sizes.
//	feature_dimensions: A Rank 1 tensors indicating the best feature dimension for each feature to split for certain nodes if the feature is multi-dimension. See above for details like shapes and sizes.
//	thresholds: A Rank 1 tensors indicating the bucket id to compare with (as a threshold) for split in each node. See above for details like shapes and sizes.
//	left_node_contribs: A Rank 2 tensors indicating the contribution of the left nodes when branching from parent nodes (given by the tensor element in the output node_ids_list) to the left direction by the given threshold for each feature. This value will be used to make the left node value by adding to the parent node value. Second dimension size is 1 for 1-dimensional logits, but would be larger for multi-class problems. See above for details like shapes and sizes.
//	right_node_contribs: A Rank 2 tensors, with the same shape/conditions as left_node_contribs_list, but just that the value is for the right node.
//	split_with_default_directions: A Rank 1 tensors indicating the which direction to go if data is missing. See above for details like shapes and sizes.
//
// Inequality with default left returns 0, inequality with default right returns 1, equality with default right returns 2.
func BoostedTreesCalculateBestFeatureSplit(scope *Scope, node_id_range tf.Output, stats_summary tf.Output, l1 tf.Output, l2 tf.Output, tree_complexity tf.Output, min_node_weight tf.Output, logits_dimension int64, optional ...BoostedTreesCalculateBestFeatureSplitAttr) (node_ids tf.Output, gains tf.Output, feature_dimensions tf.Output, thresholds tf.Output, left_node_contribs tf.Output, right_node_contribs tf.Output, split_with_default_directions tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"logits_dimension": logits_dimension}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "BoostedTreesCalculateBestFeatureSplit",
		Input: []tf.Input{
			node_id_range, stats_summary, l1, l2, tree_complexity, min_node_weight,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3), op.Output(4), op.Output(5), op.Output(6)
}

// Calculates gains for each feature and returns the best possible split information for each node. However, if no split is found, then no split information is returned for that node.
//
// The split information is the best threshold (bucket id), gains and left/right node contributions per node for each feature.
//
// It is possible that not all nodes can be split on each feature. Hence, the list of possible nodes can differ between the features. Therefore, we return `node_ids_list` for each feature, containing the list of nodes that this feature can be used to split.
//
// In this manner, the output is the best split per features and per node, so that it needs to be combined later to produce the best split for each node (among all possible features).
//
// The output shapes are compatible in a way that the first dimension of all tensors are the same and equal to the number of possible split nodes for each feature.
//
// Arguments:
//
//	node_id_range: A Rank 1 tensor (shape=[2]) to specify the range [first, last) of node ids to process within `stats_summary_list`. The nodes are iterated between the two nodes specified by the tensor, as like `for node_id in range(node_id_range[0], node_id_range[1])` (Note that the last index node_id_range[1] is exclusive).
//	stats_summaries_list: A list of Rank 4 tensor (#shape=[max_splits, feature_dims, bucket, stats_dims]) for accumulated stats summary (gradient/hessian) per node, per dimension, per buckets for each feature.
//
// The first dimension of the tensor is the maximum number of splits, and thus not all elements of it will be used, but only the indexes specified by node_ids will be used.
//
//	split_types: A Rank 1 tensor indicating if this Op should perform inequality split or equality split per feature.
//	candidate_feature_ids: Rank 1 tensor with ids for each feature. This is the real id of the feature.
//	l1: l1 regularization factor on leaf weights, per instance based.
//	l2: l2 regularization factor on leaf weights, per instance based.
//	tree_complexity: adjustment to the gain, per leaf based.
//	min_node_weight: minimum avg of hessians in a node before required for the node to be considered for splitting.
//	logits_dimension: The dimension of logit, i.e., number of classes.
//
// Returns:
//
//	node_ids: A Rank 1 tensors indicating possible split node ids for each feature. The length of the list is num_features, but each tensor has different size as each feature provides different possible nodes. See above for details like shapes and sizes.
//	gains: A Rank 1 tensor indicating the best gains for each feature to split for certain nodes. See above for details like shapes and sizes.
//	feature_ids: A Rank 1 tensors indicating the best feature id for each node. See above for details like shapes and sizes.
//	feature_dimensions: A Rank 1 tensors indicating the best feature dimension for each feature to split for certain nodes if the feature is multi-dimension. See above for details like shapes and sizes.
//	thresholds: A Rank 1 tensors indicating the bucket id to compare with (as a threshold) for split in each node. See above for details like shapes and sizes.
//	left_node_contribs: A Rank 2 tensors indicating the contribution of the left nodes when branching from parent nodes (given by the tensor element in the output node_ids_list) to the left direction by the given threshold for each feature. This value will be used to make the left node value by adding to the parent node value. Second dimension size is 1 for 1-dimensional logits, but would be larger for multi-class problems. See above for details like shapes and sizes.
//	right_node_contribs: A Rank 2 tensors, with the same shape/conditions as left_node_contribs_list, but just that the value is for the right node.
//	split_with_default_directions: A Rank 1 tensors indicating the which direction to go if data is missing. See above for details like shapes and sizes.
//
// Inequality with default left returns 0, inequality with default right returns 1, equality with default right returns 2.
func BoostedTreesCalculateBestFeatureSplitV2(scope *Scope, node_id_range tf.Output, stats_summaries_list []tf.Output, split_types tf.Output, candidate_feature_ids tf.Output, l1 tf.Output, l2 tf.Output, tree_complexity tf.Output, min_node_weight tf.Output, logits_dimension int64) (node_ids tf.Output, gains tf.Output, feature_ids tf.Output, feature_dimensions tf.Output, thresholds tf.Output, left_node_contribs tf.Output, right_node_contribs tf.Output, split_with_default_directions tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"logits_dimension": logits_dimension}
	opspec := tf.OpSpec{
		Type: "BoostedTreesCalculateBestFeatureSplitV2",
		Input: []tf.Input{
			node_id_range, tf.OutputList(stats_summaries_list), split_types, candidate_feature_ids, l1, l2, tree_complexity, min_node_weight,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3), op.Output(4), op.Output(5), op.Output(6), op.Output(7)
}

// Calculates gains for each feature and returns the best possible split information for the feature.
//
// The split information is the best threshold (bucket id), gains and left/right node contributions per node for each feature.
//
// It is possible that not all nodes can be split on each feature. Hence, the list of possible nodes can differ between the features. Therefore, we return `node_ids_list` for each feature, containing the list of nodes that this feature can be used to split.
//
// In this manner, the output is the best split per features and per node, so that it needs to be combined later to produce the best split for each node (among all possible features).
//
// The length of output lists are all of the same length, `num_features`.
// The output shapes are compatible in a way that the first dimension of all tensors of all lists are the same and equal to the number of possible split nodes for each feature.
//
// Arguments:
//
//	node_id_range: A Rank 1 tensor (shape=[2]) to specify the range [first, last) of node ids to process within `stats_summary_list`. The nodes are iterated between the two nodes specified by the tensor, as like `for node_id in range(node_id_range[0], node_id_range[1])` (Note that the last index node_id_range[1] is exclusive).
//	stats_summary_list: A list of Rank 3 tensor (#shape=[max_splits, bucket, 2]) for accumulated stats summary (gradient/hessian) per node per buckets for each feature. The first dimension of the tensor is the maximum number of splits, and thus not all elements of it will be used, but only the indexes specified by node_ids will be used.
//	l1: l1 regularization factor on leaf weights, per instance based.
//	l2: l2 regularization factor on leaf weights, per instance based.
//	tree_complexity: adjustment to the gain, per leaf based.
//	min_node_weight: minimum avg of hessians in a node before required for the node to be considered for splitting.
//	max_splits: the number of nodes that can be split in the whole tree. Used as a dimension of output tensors.
//
// Returns:
//
//	node_ids_list: An output list of Rank 1 tensors indicating possible split node ids for each feature. The length of the list is num_features, but each tensor has different size as each feature provides different possible nodes. See above for details like shapes and sizes.
//	gains_list: An output list of Rank 1 tensors indicating the best gains for each feature to split for certain nodes. See above for details like shapes and sizes.
//	thresholds_list: An output list of Rank 1 tensors indicating the bucket id to compare with (as a threshold) for split in each node. See above for details like shapes and sizes.
//	left_node_contribs_list: A list of Rank 2 tensors indicating the contribution of the left nodes when branching from parent nodes (given by the tensor element in the output node_ids_list) to the left direction by the given threshold for each feature. This value will be used to make the left node value by adding to the parent node value. Second dimension size is 1 for 1-dimensional logits, but would be larger for multi-class problems. See above for details like shapes and sizes.
//	right_node_contribs_list: A list of Rank 2 tensors, with the same shape/conditions as left_node_contribs_list, but just that the value is for the right node.
func BoostedTreesCalculateBestGainsPerFeature(scope *Scope, node_id_range tf.Output, stats_summary_list []tf.Output, l1 tf.Output, l2 tf.Output, tree_complexity tf.Output, min_node_weight tf.Output, max_splits int64) (node_ids_list []tf.Output, gains_list []tf.Output, thresholds_list []tf.Output, left_node_contribs_list []tf.Output, right_node_contribs_list []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"max_splits": max_splits}
	opspec := tf.OpSpec{
		Type: "BoostedTreesCalculateBestGainsPerFeature",
		Input: []tf.Input{
			node_id_range, tf.OutputList(stats_summary_list), l1, l2, tree_complexity, min_node_weight,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if node_ids_list, idx, err = makeOutputList(op, idx, "node_ids_list"); err != nil {
		scope.UpdateErr("BoostedTreesCalculateBestGainsPerFeature", err)
		return
	}
	if gains_list, idx, err = makeOutputList(op, idx, "gains_list"); err != nil {
		scope.UpdateErr("BoostedTreesCalculateBestGainsPerFeature", err)
		return
	}
	if thresholds_list, idx, err = makeOutputList(op, idx, "thresholds_list"); err != nil {
		scope.UpdateErr("BoostedTreesCalculateBestGainsPerFeature", err)
		return
	}
	if left_node_contribs_list, idx, err = makeOutputList(op, idx, "left_node_contribs_list"); err != nil {
		scope.UpdateErr("BoostedTreesCalculateBestGainsPerFeature", err)
		return
	}
	if right_node_contribs_list, idx, err = makeOutputList(op, idx, "right_node_contribs_list"); err != nil {
		scope.UpdateErr("BoostedTreesCalculateBestGainsPerFeature", err)
		return
	}
	return node_ids_list, gains_list, thresholds_list, left_node_contribs_list, right_node_contribs_list
}

// Calculates the prior from the training data (the bias) and fills in the first node with the logits' prior. Returns a boolean indicating whether to continue centering.
//
// Arguments:
//
//	tree_ensemble_handle: Handle to the tree ensemble.
//	mean_gradients: A tensor with shape=[logits_dimension] with mean of gradients for a first node.
//	mean_hessians: A tensor with shape=[logits_dimension] mean of hessians for a first node.
//	l1: l1 regularization factor on leaf weights, per instance based.
//	l2: l2 regularization factor on leaf weights, per instance based.
//
// Returns Bool, whether to continue bias centering.
func BoostedTreesCenterBias(scope *Scope, tree_ensemble_handle tf.Output, mean_gradients tf.Output, mean_hessians tf.Output, l1 tf.Output, l2 tf.Output) (continue_centering tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "BoostedTreesCenterBias",
		Input: []tf.Input{
			tree_ensemble_handle, mean_gradients, mean_hessians, l1, l2,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates a tree ensemble model and returns a handle to it.
//
// Arguments:
//
//	tree_ensemble_handle: Handle to the tree ensemble resource to be created.
//	stamp_token: Token to use as the initial value of the resource stamp.
//	tree_ensemble_serialized: Serialized proto of the tree ensemble.
//
// Returns the created operation.
func BoostedTreesCreateEnsemble(scope *Scope, tree_ensemble_handle tf.Output, stamp_token tf.Output, tree_ensemble_serialized tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "BoostedTreesCreateEnsemble",
		Input: []tf.Input{
			tree_ensemble_handle, stamp_token, tree_ensemble_serialized,
		},
	}
	return scope.AddOperation(opspec)
}

// BoostedTreesCreateQuantileStreamResourceAttr is an optional argument to BoostedTreesCreateQuantileStreamResource.
type BoostedTreesCreateQuantileStreamResourceAttr func(optionalAttr)

// BoostedTreesCreateQuantileStreamResourceMaxElements sets the optional max_elements attribute to value.
//
// value: int; The maximum number of data points that can be fed to the stream.
// If not specified, defaults to 1099511627776
func BoostedTreesCreateQuantileStreamResourceMaxElements(value int64) BoostedTreesCreateQuantileStreamResourceAttr {
	return func(m optionalAttr) {
		m["max_elements"] = value
	}
}

// Create the Resource for Quantile Streams.
//
// Arguments:
//
//	quantile_stream_resource_handle: resource; Handle to quantile stream resource.
//	epsilon: float; The required approximation error of the stream resource.
//	num_streams: int; The number of streams managed by the resource that shares the same epsilon.
//
// Returns the created operation.
func BoostedTreesCreateQuantileStreamResource(scope *Scope, quantile_stream_resource_handle tf.Output, epsilon tf.Output, num_streams tf.Output, optional ...BoostedTreesCreateQuantileStreamResourceAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "BoostedTreesCreateQuantileStreamResource",
		Input: []tf.Input{
			quantile_stream_resource_handle, epsilon, num_streams,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// Deserializes a serialized tree ensemble config and replaces current tree
//
// ensemble.
//
// Arguments:
//
//	tree_ensemble_handle: Handle to the tree ensemble.
//	stamp_token: Token to use as the new value of the resource stamp.
//	tree_ensemble_serialized: Serialized proto of the ensemble.
//
// Returns the created operation.
func BoostedTreesDeserializeEnsemble(scope *Scope, tree_ensemble_handle tf.Output, stamp_token tf.Output, tree_ensemble_serialized tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "BoostedTreesDeserializeEnsemble",
		Input: []tf.Input{
			tree_ensemble_handle, stamp_token, tree_ensemble_serialized,
		},
	}
	return scope.AddOperation(opspec)
}

// BoostedTreesEnsembleResourceHandleOpAttr is an optional argument to BoostedTreesEnsembleResourceHandleOp.
type BoostedTreesEnsembleResourceHandleOpAttr func(optionalAttr)

// BoostedTreesEnsembleResourceHandleOpContainer sets the optional container attribute to value.
// If not specified, defaults to ""
func BoostedTreesEnsembleResourceHandleOpContainer(value string) BoostedTreesEnsembleResourceHandleOpAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// BoostedTreesEnsembleResourceHandleOpSharedName sets the optional shared_name attribute to value.
// If not specified, defaults to ""
func BoostedTreesEnsembleResourceHandleOpSharedName(value string) BoostedTreesEnsembleResourceHandleOpAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Creates a handle to a BoostedTreesEnsembleResource
func BoostedTreesEnsembleResourceHandleOp(scope *Scope, optional ...BoostedTreesEnsembleResourceHandleOpAttr) (resource tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "BoostedTreesEnsembleResourceHandleOp",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Debugging/model interpretability outputs for each example.
//
// It traverses all the trees and computes debug metrics for individual examples,
// such as getting split feature ids and logits after each split along the decision
// path used to compute directional feature contributions.
//
// Arguments:
//
//	bucketized_features: A list of rank 1 Tensors containing bucket id for each
//
// feature.
//
//	logits_dimension: scalar, dimension of the logits, to be used for constructing the protos in
//
// examples_debug_outputs_serialized.
//
// Returns Output rank 1 Tensor containing a proto serialized as a string for each example.
func BoostedTreesExampleDebugOutputs(scope *Scope, tree_ensemble_handle tf.Output, bucketized_features []tf.Output, logits_dimension int64) (examples_debug_outputs_serialized tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"logits_dimension": logits_dimension}
	opspec := tf.OpSpec{
		Type: "BoostedTreesExampleDebugOutputs",
		Input: []tf.Input{
			tree_ensemble_handle, tf.OutputList(bucketized_features),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Flush the quantile summaries from each quantile stream resource.
//
// An op that outputs a list of quantile summaries of a quantile stream resource.
// Each summary Tensor is rank 2, containing summaries (value, weight, min_rank,
// max_rank) for a single feature.
//
// Arguments:
//
//	quantile_stream_resource_handle: resource handle referring to a QuantileStreamResource.
func BoostedTreesFlushQuantileSummaries(scope *Scope, quantile_stream_resource_handle tf.Output, num_features int64) (summaries []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_features": num_features}
	opspec := tf.OpSpec{
		Type: "BoostedTreesFlushQuantileSummaries",
		Input: []tf.Input{
			quantile_stream_resource_handle,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if summaries, idx, err = makeOutputList(op, idx, "summaries"); err != nil {
		scope.UpdateErr("BoostedTreesFlushQuantileSummaries", err)
		return
	}
	return summaries
}

// Retrieves the tree ensemble resource stamp token, number of trees and growing statistics.
//
// Arguments:
//
//	tree_ensemble_handle: Handle to the tree ensemble.
//
// Returns:
//
//	stamp_token: Stamp token of the tree ensemble resource.
//	num_trees: The number of trees in the tree ensemble resource.
//	num_finalized_trees: The number of trees that were finished successfully.
//	num_attempted_layers: The number of layers we attempted to build (but not necessarily succeeded).
//	last_layer_nodes_range: Rank size 2 tensor that contains start and end ids of the nodes in the latest
//
// layer.
func BoostedTreesGetEnsembleStates(scope *Scope, tree_ensemble_handle tf.Output) (stamp_token tf.Output, num_trees tf.Output, num_finalized_trees tf.Output, num_attempted_layers tf.Output, last_layer_nodes_range tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "BoostedTreesGetEnsembleStates",
		Input: []tf.Input{
			tree_ensemble_handle,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3), op.Output(4)
}

// Makes the summary of quantiles for the batch.
//
// An op that takes a list of tensors (one tensor per feature) and outputs the
// quantile summaries for each tensor.
//
// Arguments:
//
//	float_values: float; List of Rank 1 Tensors each containing values for a single feature.
//	example_weights: float; Rank 1 Tensor with weights per instance.
//	epsilon: float; The required maximum approximation error.
//
// Returns float; List of Rank 2 Tensors each containing the quantile summary
// (value, weight, min_rank, max_rank) of a single feature.
func BoostedTreesMakeQuantileSummaries(scope *Scope, float_values []tf.Output, example_weights tf.Output, epsilon tf.Output) (summaries []tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "BoostedTreesMakeQuantileSummaries",
		Input: []tf.Input{
			tf.OutputList(float_values), example_weights, epsilon,
		},
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if summaries, idx, err = makeOutputList(op, idx, "summaries"); err != nil {
		scope.UpdateErr("BoostedTreesMakeQuantileSummaries", err)
		return
	}
	return summaries
}

// Makes the summary of accumulated stats for the batch.
//
// The summary stats contains gradients and hessians accumulated into the corresponding node and bucket for each example.
//
// Arguments:
//
//	node_ids: int32 Rank 1 Tensor containing node ids, which each example falls into for the requested layer.
//	gradients: float32; Rank 2 Tensor (shape=[#examples, 1]) for gradients.
//	hessians: float32; Rank 2 Tensor (shape=[#examples, 1]) for hessians.
//	bucketized_features_list: int32 list of Rank 1 Tensors, each containing the bucketized feature (for each feature column).
//	max_splits: int; the maximum number of splits possible in the whole tree.
//	num_buckets: int; equals to the maximum possible value of bucketized feature.
//
// Returns output Rank 4 Tensor (shape=[#features, #splits, #buckets, 2]) containing accumulated stats put into the corresponding node and bucket. The first index of 4th dimension refers to gradients, and the second to hessians.
func BoostedTreesMakeStatsSummary(scope *Scope, node_ids tf.Output, gradients tf.Output, hessians tf.Output, bucketized_features_list []tf.Output, max_splits int64, num_buckets int64) (stats_summary tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"max_splits": max_splits, "num_buckets": num_buckets}
	opspec := tf.OpSpec{
		Type: "BoostedTreesMakeStatsSummary",
		Input: []tf.Input{
			node_ids, gradients, hessians, tf.OutputList(bucketized_features_list),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Runs multiple additive regression ensemble predictors on input instances and
//
// computes the logits. It is designed to be used during prediction.
// It traverses all the trees and calculates the final score for each instance.
//
// Arguments:
//
//	bucketized_features: A list of rank 1 Tensors containing bucket id for each
//
// feature.
//
//	logits_dimension: scalar, dimension of the logits, to be used for partial logits
//
// shape.
//
// Returns Output rank 2 Tensor containing logits for each example.
func BoostedTreesPredict(scope *Scope, tree_ensemble_handle tf.Output, bucketized_features []tf.Output, logits_dimension int64) (logits tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"logits_dimension": logits_dimension}
	opspec := tf.OpSpec{
		Type: "BoostedTreesPredict",
		Input: []tf.Input{
			tree_ensemble_handle, tf.OutputList(bucketized_features),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Add the quantile summaries to each quantile stream resource.
//
// An op that adds a list of quantile summaries to a quantile stream resource. Each
// summary Tensor is rank 2, containing summaries (value, weight, min_rank, max_rank)
// for a single feature.
//
// Arguments:
//
//	quantile_stream_resource_handle: resource handle referring to a QuantileStreamResource.
//	summaries: string; List of Rank 2 Tensor each containing the summaries for a single feature.
//
// Returns the created operation.
func BoostedTreesQuantileStreamResourceAddSummaries(scope *Scope, quantile_stream_resource_handle tf.Output, summaries []tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "BoostedTreesQuantileStreamResourceAddSummaries",
		Input: []tf.Input{
			quantile_stream_resource_handle, tf.OutputList(summaries),
		},
	}
	return scope.AddOperation(opspec)
}

// Deserialize bucket boundaries and ready flag into current QuantileAccumulator.
//
// An op that deserializes bucket boundaries and are boundaries ready flag into current QuantileAccumulator.
//
// Arguments:
//
//	quantile_stream_resource_handle: resource handle referring to a QuantileStreamResource.
//	bucket_boundaries: float; List of Rank 1 Tensors each containing the bucket boundaries for a feature.
//
// Returns the created operation.
func BoostedTreesQuantileStreamResourceDeserialize(scope *Scope, quantile_stream_resource_handle tf.Output, bucket_boundaries []tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "BoostedTreesQuantileStreamResourceDeserialize",
		Input: []tf.Input{
			quantile_stream_resource_handle, tf.OutputList(bucket_boundaries),
		},
	}
	return scope.AddOperation(opspec)
}

// BoostedTreesQuantileStreamResourceFlushAttr is an optional argument to BoostedTreesQuantileStreamResourceFlush.
type BoostedTreesQuantileStreamResourceFlushAttr func(optionalAttr)

// BoostedTreesQuantileStreamResourceFlushGenerateQuantiles sets the optional generate_quantiles attribute to value.
//
// value: bool; If True, the output will be the num_quantiles for each stream where the ith
// entry is the ith quantile of the input with an approximation error of epsilon.
// Duplicate values may be present.
// If False, the output will be the points in the histogram that we got which roughly
// translates to 1/epsilon boundaries and without any duplicates.
// Default to False.
// If not specified, defaults to false
func BoostedTreesQuantileStreamResourceFlushGenerateQuantiles(value bool) BoostedTreesQuantileStreamResourceFlushAttr {
	return func(m optionalAttr) {
		m["generate_quantiles"] = value
	}
}

// Flush the summaries for a quantile stream resource.
//
// An op that flushes the summaries for a quantile stream resource.
//
// Arguments:
//
//	quantile_stream_resource_handle: resource handle referring to a QuantileStreamResource.
//	num_buckets: int; approximate number of buckets unless using generate_quantiles.
//
// Returns the created operation.
func BoostedTreesQuantileStreamResourceFlush(scope *Scope, quantile_stream_resource_handle tf.Output, num_buckets tf.Output, optional ...BoostedTreesQuantileStreamResourceFlushAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "BoostedTreesQuantileStreamResourceFlush",
		Input: []tf.Input{
			quantile_stream_resource_handle, num_buckets,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// Generate the bucket boundaries for each feature based on accumulated summaries.
//
// An op that returns a list of float tensors for a quantile stream resource. Each
// tensor is Rank 1 containing bucket boundaries for a single feature.
//
// Arguments:
//
//	quantile_stream_resource_handle: resource handle referring to a QuantileStreamResource.
//	num_features: inferred int; number of features to get bucket boundaries for.
//
// Returns float; List of Rank 1 Tensors each containing the bucket boundaries for a feature.
func BoostedTreesQuantileStreamResourceGetBucketBoundaries(scope *Scope, quantile_stream_resource_handle tf.Output, num_features int64) (bucket_boundaries []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_features": num_features}
	opspec := tf.OpSpec{
		Type: "BoostedTreesQuantileStreamResourceGetBucketBoundaries",
		Input: []tf.Input{
			quantile_stream_resource_handle,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if bucket_boundaries, idx, err = makeOutputList(op, idx, "bucket_boundaries"); err != nil {
		scope.UpdateErr("BoostedTreesQuantileStreamResourceGetBucketBoundaries", err)
		return
	}
	return bucket_boundaries
}

// BoostedTreesQuantileStreamResourceHandleOpAttr is an optional argument to BoostedTreesQuantileStreamResourceHandleOp.
type BoostedTreesQuantileStreamResourceHandleOpAttr func(optionalAttr)

// BoostedTreesQuantileStreamResourceHandleOpContainer sets the optional container attribute to value.
// If not specified, defaults to ""
func BoostedTreesQuantileStreamResourceHandleOpContainer(value string) BoostedTreesQuantileStreamResourceHandleOpAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// BoostedTreesQuantileStreamResourceHandleOpSharedName sets the optional shared_name attribute to value.
// If not specified, defaults to ""
func BoostedTreesQuantileStreamResourceHandleOpSharedName(value string) BoostedTreesQuantileStreamResourceHandleOpAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Creates a handle to a BoostedTreesQuantileStreamResource.
func BoostedTreesQuantileStreamResourceHandleOp(scope *Scope, optional ...BoostedTreesQuantileStreamResourceHandleOpAttr) (resource tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "BoostedTreesQuantileStreamResourceHandleOp",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Serializes the tree ensemble to a proto.
//
// Arguments:
//
//	tree_ensemble_handle: Handle to the tree ensemble.
//
// Returns:
//
//	stamp_token: Stamp token of the tree ensemble resource.
//	tree_ensemble_serialized: Serialized proto of the ensemble.
func BoostedTreesSerializeEnsemble(scope *Scope, tree_ensemble_handle tf.Output) (stamp_token tf.Output, tree_ensemble_serialized tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "BoostedTreesSerializeEnsemble",
		Input: []tf.Input{
			tree_ensemble_handle,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Aggregates the summary of accumulated stats for the batch.
//
// The summary stats contains gradients and hessians accumulated for each node, bucket and dimension id.
//
// Arguments:
//
//	node_ids: int32; Rank 1 Tensor containing node ids for each example, shape [batch_size].
//	gradients: float32; Rank 2 Tensor (shape=[batch_size, logits_dimension]) with gradients for each example.
//	hessians: float32; Rank 2 Tensor (shape=[batch_size, hessian_dimension]) with hessians for each example.
//	feature_indices: int32; Rank 2 indices of feature sparse Tensors (shape=[number of sparse entries, 2]).
//
// Number of sparse entries across all instances from the batch. The first value is
// the index of the instance, the second is dimension of the feature. The second axis
// can only have 2 values, i.e., the input dense version of Tensor can only be matrix.
//
//	feature_values: int32; Rank 1 values of feature sparse Tensors (shape=[number of sparse entries]).
//
// Number of sparse entries across all instances from the batch. The first value is
// the index of the instance, the second is dimension of the feature.
//
//	feature_shape: int32; Rank 1 dense shape of feature sparse Tensors (shape=[2]).
//
// The first axis can only have 2 values, [batch_size, feature_dimension].
//
//	max_splits: int; the maximum number of splits possible in the whole tree.
//	num_buckets: int; equals to the maximum possible value of bucketized feature + 1.
//
// Returns:
//
//	stats_summary_indices: int32; Rank 2 indices of summary sparse Tensors (shape=[number of non zero statistics, 4])
//
// The second axis can only be 4 including node id, feature dimension, bucket id, and statistics_dimension.
// statistics_dimension = logits_dimension + hessian_dimension.
//
//	stats_summary_values: output Rank 1 Tensor (shape=[number of non zero statistics])
//	stats_summary_shape: output Rank 1 Tensor (shape=[4])
//
// The tensor has following 4 values: [max_splits, feature_dimension, num_buckets, statistics_dimension],
// where statistics_dimension = gradient_dimension + hessian_dimension. gradient_dimension
// is the same as label_dimension, i.e., the output space. hessian_dimension can be the same
// as logits dimension when diagonal hessian is used, or label_dimension^2 when full
// hessian is used.
func BoostedTreesSparseAggregateStats(scope *Scope, node_ids tf.Output, gradients tf.Output, hessians tf.Output, feature_indices tf.Output, feature_values tf.Output, feature_shape tf.Output, max_splits int64, num_buckets int64) (stats_summary_indices tf.Output, stats_summary_values tf.Output, stats_summary_shape tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"max_splits": max_splits, "num_buckets": num_buckets}
	opspec := tf.OpSpec{
		Type: "BoostedTreesSparseAggregateStats",
		Input: []tf.Input{
			node_ids, gradients, hessians, feature_indices, feature_values, feature_shape,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// BoostedTreesSparseCalculateBestFeatureSplitAttr is an optional argument to BoostedTreesSparseCalculateBestFeatureSplit.
type BoostedTreesSparseCalculateBestFeatureSplitAttr func(optionalAttr)

// BoostedTreesSparseCalculateBestFeatureSplitSplitType sets the optional split_type attribute to value.
//
// value: A string indicating if this Op should perform inequality split or equality split.
// If not specified, defaults to "inequality"
func BoostedTreesSparseCalculateBestFeatureSplitSplitType(value string) BoostedTreesSparseCalculateBestFeatureSplitAttr {
	return func(m optionalAttr) {
		m["split_type"] = value
	}
}

// Calculates gains for each feature and returns the best possible split information for the feature.
//
// The split information is the best threshold (bucket id), gains and left/right node contributions per node for each feature.
//
// It is possible that not all nodes can be split on each feature. Hence, the list of possible nodes can differ between the features. Therefore, we return `node_ids_list` for each feature, containing the list of nodes that this feature can be used to split.
//
// In this manner, the output is the best split per features and per node, so that it needs to be combined later to produce the best split for each node (among all possible features).
//
// The output shapes are compatible in a way that the first dimension of all tensors are the same and equal to the number of possible split nodes for each feature.
//
// Arguments:
//
//	node_id_range: A Rank 1 tensor (shape=[2]) to specify the range [first, last) of node ids to process within `stats_summary_list`. The nodes are iterated between the two nodes specified by the tensor, as like `for node_id in range(node_id_range[0], node_id_range[1])` (Note that the last index node_id_range[1] is exclusive).
//	stats_summary_indices: A Rank 2 int64 tensor of dense shape [N, 4] (N specifies the number of non-zero values) for accumulated stats summary (gradient/hessian) per node per bucket for each feature. The second dimension contains node id, feature dimension, bucket id, and stats dim.
//
// stats dim is the sum of logits dimension and hessian dimension, hessian dimension can either be logits dimension if diagonal hessian is used, or logits dimension^2 if full hessian is used.
//
//	stats_summary_values: A Rank 1 float tensor of dense shape [N] (N specifies the number of non-zero values), which supplies the values for each element in summary_indices.
//	stats_summary_shape: A Rank 1 float tensor of dense shape [4], which specifies the dense shape of the sparse tensor, which is [num tree nodes, feature dimensions, num buckets, stats dim].
//	l1: l1 regularization factor on leaf weights, per instance based.
//	l2: l2 regularization factor on leaf weights, per instance based.
//	tree_complexity: adjustment to the gain, per leaf based.
//	min_node_weight: minimum avg of hessians in a node before required for the node to be considered for splitting.
//	logits_dimension: The dimension of logit, i.e., number of classes.
//
// Returns:
//
//	node_ids: A Rank 1 tensor indicating possible node ids that can be split.
//	gains: A Rank 1 tensor indicating the best gains to split each node.
//	feature_dimensions: A Rank 1 tensor indicating the best feature dimension for each feature to split for each node.
//	thresholds: A Rank 1 tensor indicating the bucket id to compare with (as a threshold) for split in each node.
//	left_node_contribs: A Rank 2 tensor indicating the contribution of the left nodes when branching from parent nodes to the left direction by the given threshold for each feature.
//
// This value will be used to make the left node value by adding to the parent node value. Second dimension size is logits dimension.
//
//	right_node_contribs: A Rank 2 tensor, with the same shape/conditions as left_node_contribs_list, but just that the value is for the right node.
//	split_with_default_directions: A Rank 1 tensor indicating which direction to go if data is missing.
//
// Inequality with default left returns 0, inequality with default right returns 1, equality with default right returns 2.
func BoostedTreesSparseCalculateBestFeatureSplit(scope *Scope, node_id_range tf.Output, stats_summary_indices tf.Output, stats_summary_values tf.Output, stats_summary_shape tf.Output, l1 tf.Output, l2 tf.Output, tree_complexity tf.Output, min_node_weight tf.Output, logits_dimension int64, optional ...BoostedTreesSparseCalculateBestFeatureSplitAttr) (node_ids tf.Output, gains tf.Output, feature_dimensions tf.Output, thresholds tf.Output, left_node_contribs tf.Output, right_node_contribs tf.Output, split_with_default_directions tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"logits_dimension": logits_dimension}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "BoostedTreesSparseCalculateBestFeatureSplit",
		Input: []tf.Input{
			node_id_range, stats_summary_indices, stats_summary_values, stats_summary_shape, l1, l2, tree_complexity, min_node_weight,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3), op.Output(4), op.Output(5), op.Output(6)
}

// Runs multiple additive regression ensemble predictors on input instances and
//
// computes the update to cached logits. It is designed to be used during training.
// It traverses the trees starting from cached tree id and cached node id and
// calculates the updates to be pushed to the cache.
//
// Arguments:
//
//	cached_tree_ids: Rank 1 Tensor containing cached tree ids which is the starting
//
// tree of prediction.
//
//	cached_node_ids: Rank 1 Tensor containing cached node id which is the starting
//
// node of prediction.
//
//	bucketized_features: A list of rank 1 Tensors containing bucket id for each
//
// feature.
//
//	logits_dimension: scalar, dimension of the logits, to be used for partial logits
//
// shape.
//
// Returns:
//
//	partial_logits: Rank 2 Tensor containing logits update (with respect to cached
//
// values stored) for each example.
//
//	tree_ids: Rank 1 Tensor containing new tree ids for each example.
//	node_ids: Rank 1 Tensor containing new node ids in the new tree_ids.
func BoostedTreesTrainingPredict(scope *Scope, tree_ensemble_handle tf.Output, cached_tree_ids tf.Output, cached_node_ids tf.Output, bucketized_features []tf.Output, logits_dimension int64) (partial_logits tf.Output, tree_ids tf.Output, node_ids tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"logits_dimension": logits_dimension}
	opspec := tf.OpSpec{
		Type: "BoostedTreesTrainingPredict",
		Input: []tf.Input{
			tree_ensemble_handle, cached_tree_ids, cached_node_ids, tf.OutputList(bucketized_features),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// Updates the tree ensemble by either adding a layer to the last tree being grown
//
// or by starting a new tree.
//
// Arguments:
//
//	tree_ensemble_handle: Handle to the ensemble variable.
//	feature_ids: Rank 1 tensor with ids for each feature. This is the real id of
//
// the feature that will be used in the split.
//
//	node_ids: List of rank 1 tensors representing the nodes for which this feature
//
// has a split.
//
//	gains: List of rank 1 tensors representing the gains for each of the feature's
//
// split.
//
//	thresholds: List of rank 1 tensors representing the thesholds for each of the
//
// feature's split.
//
//	left_node_contribs: List of rank 2 tensors with left leaf contribs for each of
//
// the feature's splits. Will be added to the previous node values to constitute
// the values of the left nodes.
//
//	right_node_contribs: List of rank 2 tensors with right leaf contribs for each
//
// of the feature's splits. Will be added to the previous node values to constitute
// the values of the right nodes.
//
//	max_depth: Max depth of the tree to build.
//	learning_rate: shrinkage const for each new tree.
//	pruning_mode: 0-No pruning, 1-Pre-pruning, 2-Post-pruning.
//
// Returns the created operation.
func BoostedTreesUpdateEnsemble(scope *Scope, tree_ensemble_handle tf.Output, feature_ids tf.Output, node_ids []tf.Output, gains []tf.Output, thresholds []tf.Output, left_node_contribs []tf.Output, right_node_contribs []tf.Output, max_depth tf.Output, learning_rate tf.Output, pruning_mode int64) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"pruning_mode": pruning_mode}
	opspec := tf.OpSpec{
		Type: "BoostedTreesUpdateEnsemble",
		Input: []tf.Input{
			tree_ensemble_handle, feature_ids, tf.OutputList(node_ids), tf.OutputList(gains), tf.OutputList(thresholds), tf.OutputList(left_node_contribs), tf.OutputList(right_node_contribs), max_depth, learning_rate,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// BoostedTreesUpdateEnsembleV2Attr is an optional argument to BoostedTreesUpdateEnsembleV2.
type BoostedTreesUpdateEnsembleV2Attr func(optionalAttr)

// BoostedTreesUpdateEnsembleV2LogitsDimension sets the optional logits_dimension attribute to value.
//
// value: scalar, dimension of the logits
// If not specified, defaults to 1
func BoostedTreesUpdateEnsembleV2LogitsDimension(value int64) BoostedTreesUpdateEnsembleV2Attr {
	return func(m optionalAttr) {
		m["logits_dimension"] = value
	}
}

// Updates the tree ensemble by adding a layer to the last tree being grown
//
// or by starting a new tree.
//
// Arguments:
//
//	tree_ensemble_handle: Handle to the ensemble variable.
//	feature_ids: Rank 1 tensor with ids for each feature. This is the real id of
//
// the feature that will be used in the split.
//
//	dimension_ids: List of rank 1 tensors representing the dimension in each feature.
//	node_ids: List of rank 1 tensors representing the nodes for which this feature
//
// has a split.
//
//	gains: List of rank 1 tensors representing the gains for each of the feature's
//
// split.
//
//	thresholds: List of rank 1 tensors representing the thesholds for each of the
//
// feature's split.
//
//	left_node_contribs: List of rank 2 tensors with left leaf contribs for each of
//
// the feature's splits. Will be added to the previous node values to constitute
// the values of the left nodes.
//
//	right_node_contribs: List of rank 2 tensors with right leaf contribs for each
//
// of the feature's splits. Will be added to the previous node values to constitute
// the values of the right nodes.
//
//	split_types: List of rank 1 tensors representing the split type for each feature.
//	max_depth: Max depth of the tree to build.
//	learning_rate: shrinkage const for each new tree.
//	pruning_mode: 0-No pruning, 1-Pre-pruning, 2-Post-pruning.
//
// Returns the created operation.
func BoostedTreesUpdateEnsembleV2(scope *Scope, tree_ensemble_handle tf.Output, feature_ids []tf.Output, dimension_ids []tf.Output, node_ids []tf.Output, gains []tf.Output, thresholds []tf.Output, left_node_contribs []tf.Output, right_node_contribs []tf.Output, split_types []tf.Output, max_depth tf.Output, learning_rate tf.Output, pruning_mode tf.Output, optional ...BoostedTreesUpdateEnsembleV2Attr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "BoostedTreesUpdateEnsembleV2",
		Input: []tf.Input{
			tree_ensemble_handle, tf.OutputList(feature_ids), tf.OutputList(dimension_ids), tf.OutputList(node_ids), tf.OutputList(gains), tf.OutputList(thresholds), tf.OutputList(left_node_contribs), tf.OutputList(right_node_contribs), tf.OutputList(split_types), max_depth, learning_rate, pruning_mode,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// Return the shape of s0 op s1 with broadcast.
//
// Given `s0` and `s1`, tensors that represent shapes, compute `r0`, the
// broadcasted shape. `s0`, `s1` and `r0` are all integer vectors.
func BroadcastArgs(scope *Scope, s0 tf.Output, s1 tf.Output) (r0 tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "BroadcastArgs",
		Input: []tf.Input{
			s0, s1,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Return the reduction indices for computing gradients of s0 op s1 with broadcast.
//
// This is typically used by gradient computations for a broadcasting operation.
func BroadcastGradientArgs(scope *Scope, s0 tf.Output, s1 tf.Output) (r0 tf.Output, r1 tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "BroadcastGradientArgs",
		Input: []tf.Input{
			s0, s1,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Broadcast an array for a compatible shape.
//
// Broadcasting is the process of making arrays to have compatible shapes
// for arithmetic operations. Two shapes are compatible if for each
// dimension pair they are either equal or one of them is one.
//
// For example:
//
// >>> x = tf.constant([[1, 2, 3]])   # Shape (1, 3,)
// >>> y = tf.broadcast_to(x, [2, 3])
// >>> print(y)
// tf.Tensor(
//
//	[[1 2 3]
//	 [1 2 3]], shape=(2, 3), dtype=int32)
//
// In the above example, the input Tensor with the shape of `[1, 3]`
// is broadcasted to output Tensor with shape of `[2, 3]`.
//
// When broadcasting, if a tensor has fewer axes than necessary its shape is
// padded on the left with ones. So this gives the same result as the previous
// example:
//
// >>> x = tf.constant([1, 2, 3])   # Shape (3,)
// >>> y = tf.broadcast_to(x, [2, 3])
//
// When doing broadcasted operations such as multiplying a tensor
// by a scalar, broadcasting (usually) confers some time or space
// benefit, as the broadcasted tensor is never materialized.
//
// However, `broadcast_to` does not carry with it any such benefits.
// The newly-created tensor takes the full memory of the broadcasted
// shape. (In a graph context, `broadcast_to` might be fused to
// subsequent operation and then be optimized away, however.)
//
// Arguments:
//
//	input: A Tensor to broadcast.
//	shape: An 1-D `int` Tensor. The shape of the desired output.
//
// Returns A Tensor.
func BroadcastTo(scope *Scope, input tf.Output, shape tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "BroadcastTo",
		Input: []tf.Input{
			input, shape,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Bucketizes 'input' based on 'boundaries'.
//
// For example, if the inputs are
//
//	boundaries = [0, 10, 100]
//	input = [[-5, 10000]
//	         [150,   10]
//	         [5,    100]]
//
// then the output will be
//
//	output = [[0, 3]
//	          [3, 2]
//	          [1, 3]]
//
// Arguments:
//
//	input: Any shape of Tensor contains with int or float type.
//	boundaries: A sorted list of floats gives the boundary of the buckets.
//
// Returns Same shape with 'input', each value of input replaced with bucket index.
//
// @compatibility(numpy)
// Equivalent to np.digitize.
// @end_compatibility
func Bucketize(scope *Scope, input tf.Output, boundaries []float32) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"boundaries": boundaries}
	opspec := tf.OpSpec{
		Type: "Bucketize",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Records the bytes size of each element of `input_dataset` in a StatsAggregator.
func BytesProducedStatsDataset(scope *Scope, input_dataset tf.Output, tag tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "BytesProducedStatsDataset",
		Input: []tf.Input{
			input_dataset, tag,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Reads out the CSR components at batch `index`.
//
// This op is meant only for debugging / testing, and its interface is not expected
// to be stable.
//
// Arguments:
//
//	csr_sparse_matrix: A batched CSRSparseMatrix.
//	index: The index in `csr_sparse_matrix`'s batch.
//
// Returns:
//
//	row_ptrs: An array containing CSR matrix row pointers.
//	col_inds: An array containing CSR matrix column indices.
//	values: An array containing CSR matrix nonzero values.
func CSRSparseMatrixComponents(scope *Scope, csr_sparse_matrix tf.Output, index tf.Output, type_ tf.DataType) (row_ptrs tf.Output, col_inds tf.Output, values tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"type": type_}
	opspec := tf.OpSpec{
		Type: "CSRSparseMatrixComponents",
		Input: []tf.Input{
			csr_sparse_matrix, index,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// Convert a (possibly batched) CSRSparseMatrix to dense.
//
// Arguments:
//
//	sparse_input: A batched CSRSparseMatrix.
//
// Returns A dense tensor.
func CSRSparseMatrixToDense(scope *Scope, sparse_input tf.Output, type_ tf.DataType) (dense_output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"type": type_}
	opspec := tf.OpSpec{
		Type: "CSRSparseMatrixToDense",
		Input: []tf.Input{
			sparse_input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Converts a (possibly batched) CSRSparesMatrix to a SparseTensor.
//
// Arguments:
//
//	sparse_matrix: A (possibly batched) CSRSparseMatrix.
//
// Returns:
//
//	indices: SparseTensor indices.
//	values: SparseTensor values.
//	dense_shape: SparseTensor dense shape.
func CSRSparseMatrixToSparseTensor(scope *Scope, sparse_matrix tf.Output, type_ tf.DataType) (indices tf.Output, values tf.Output, dense_shape tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"type": type_}
	opspec := tf.OpSpec{
		Type: "CSRSparseMatrixToSparseTensor",
		Input: []tf.Input{
			sparse_matrix,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// CTCBeamSearchDecoderAttr is an optional argument to CTCBeamSearchDecoder.
type CTCBeamSearchDecoderAttr func(optionalAttr)

// CTCBeamSearchDecoderMergeRepeated sets the optional merge_repeated attribute to value.
//
// value: If true, merge repeated classes in output.
// If not specified, defaults to true
func CTCBeamSearchDecoderMergeRepeated(value bool) CTCBeamSearchDecoderAttr {
	return func(m optionalAttr) {
		m["merge_repeated"] = value
	}
}

// Performs beam search decoding on the logits given in input.
//
// A note about the attribute merge_repeated: For the beam search decoder,
// this means that if consecutive entries in a beam are the same, only
// the first of these is emitted.  That is, when the top path is "A B B B B",
// "A B" is returned if merge_repeated = True but "A B B B B" is
// returned if merge_repeated = False.
//
// Arguments:
//
//	inputs: 3-D, shape: `(max_time x batch_size x num_classes)`, the logits.
//	sequence_length: A vector containing sequence lengths, size `(batch)`.
//	beam_width: A scalar >= 0 (beam search beam width).
//	top_paths: A scalar >= 0, <= beam_width (controls output size).
//
// Returns:
//
//	decoded_indices: A list (length: top_paths) of indices matrices.  Matrix j,
//
// size `(total_decoded_outputs[j] x 2)`, has indices of a
// `SparseTensor<int64, 2>`.  The rows store: [batch, time].
//
//	decoded_values: A list (length: top_paths) of values vectors.  Vector j,
//
// size `(length total_decoded_outputs[j])`, has the values of a
// `SparseTensor<int64, 2>`.  The vector stores the decoded classes for beam j.
//
//	decoded_shape: A list (length: top_paths) of shape vector.  Vector j,
//
// size `(2)`, stores the shape of the decoded `SparseTensor[j]`.
// Its values are: `[batch_size, max_decoded_length[j]]`.
//
//	log_probability: A matrix, shaped: `(batch_size x top_paths)`.  The
//
// sequence log-probabilities.
func CTCBeamSearchDecoder(scope *Scope, inputs tf.Output, sequence_length tf.Output, beam_width int64, top_paths int64, optional ...CTCBeamSearchDecoderAttr) (decoded_indices []tf.Output, decoded_values []tf.Output, decoded_shape []tf.Output, log_probability tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"beam_width": beam_width, "top_paths": top_paths}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CTCBeamSearchDecoder",
		Input: []tf.Input{
			inputs, sequence_length,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if decoded_indices, idx, err = makeOutputList(op, idx, "decoded_indices"); err != nil {
		scope.UpdateErr("CTCBeamSearchDecoder", err)
		return
	}
	if decoded_values, idx, err = makeOutputList(op, idx, "decoded_values"); err != nil {
		scope.UpdateErr("CTCBeamSearchDecoder", err)
		return
	}
	if decoded_shape, idx, err = makeOutputList(op, idx, "decoded_shape"); err != nil {
		scope.UpdateErr("CTCBeamSearchDecoder", err)
		return
	}
	log_probability = op.Output(idx)
	return decoded_indices, decoded_values, decoded_shape, log_probability
}

// CTCGreedyDecoderAttr is an optional argument to CTCGreedyDecoder.
type CTCGreedyDecoderAttr func(optionalAttr)

// CTCGreedyDecoderMergeRepeated sets the optional merge_repeated attribute to value.
//
// value: If True, merge repeated classes in output.
// If not specified, defaults to false
func CTCGreedyDecoderMergeRepeated(value bool) CTCGreedyDecoderAttr {
	return func(m optionalAttr) {
		m["merge_repeated"] = value
	}
}

// CTCGreedyDecoderBlankIndex sets the optional blank_index attribute to value.
// If not specified, defaults to -1
func CTCGreedyDecoderBlankIndex(value int64) CTCGreedyDecoderAttr {
	return func(m optionalAttr) {
		m["blank_index"] = value
	}
}

// Performs greedy decoding on the logits given in inputs.
//
// A note about the attribute merge_repeated: if enabled, when
// consecutive logits' maximum indices are the same, only the first of
// these is emitted.  Labeling the blank '*', the sequence "A B B * B B"
// becomes "A B B" if merge_repeated = True and "A B B B B" if
// merge_repeated = False.
//
// Regardless of the value of merge_repeated, if the maximum index of a given
// time and batch corresponds to the blank, index `(num_classes - 1)`, no new
// element is emitted.
//
// Arguments:
//
//	inputs: 3-D, shape: `(max_time x batch_size x num_classes)`, the logits.
//	sequence_length: A vector containing sequence lengths, size `(batch_size)`.
//
// Returns:
//
//	decoded_indices: Indices matrix, size `(total_decoded_outputs x 2)`,
//
// of a `SparseTensor<int64, 2>`.  The rows store: [batch, time].
//
//	decoded_values: Values vector, size: `(total_decoded_outputs)`,
//
// of a `SparseTensor<int64, 2>`.  The vector stores the decoded classes.
//
//	decoded_shape: Shape vector, size `(2)`, of the decoded SparseTensor.
//
// Values are: `[batch_size, max_decoded_length]`.
//
//	log_probability: Matrix, size `(batch_size x 1)`, containing sequence
//
// log-probabilities.
func CTCGreedyDecoder(scope *Scope, inputs tf.Output, sequence_length tf.Output, optional ...CTCGreedyDecoderAttr) (decoded_indices tf.Output, decoded_values tf.Output, decoded_shape tf.Output, log_probability tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CTCGreedyDecoder",
		Input: []tf.Input{
			inputs, sequence_length,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3)
}

// CTCLossAttr is an optional argument to CTCLoss.
type CTCLossAttr func(optionalAttr)

// CTCLossPreprocessCollapseRepeated sets the optional preprocess_collapse_repeated attribute to value.
//
// value: Scalar, if true then repeated labels are
// collapsed prior to the CTC calculation.
// If not specified, defaults to false
func CTCLossPreprocessCollapseRepeated(value bool) CTCLossAttr {
	return func(m optionalAttr) {
		m["preprocess_collapse_repeated"] = value
	}
}

// CTCLossCtcMergeRepeated sets the optional ctc_merge_repeated attribute to value.
//
// value: Scalar.  If set to false, *during* CTC calculation
// repeated non-blank labels will not be merged and are interpreted as
// individual labels.  This is a simplified version of CTC.
// If not specified, defaults to true
func CTCLossCtcMergeRepeated(value bool) CTCLossAttr {
	return func(m optionalAttr) {
		m["ctc_merge_repeated"] = value
	}
}

// CTCLossIgnoreLongerOutputsThanInputs sets the optional ignore_longer_outputs_than_inputs attribute to value.
//
// value: Scalar. If set to true, during CTC
// calculation, items that have longer output sequences than input sequences
// are skipped: they don't contribute to the loss term and have zero-gradient.
// If not specified, defaults to false
func CTCLossIgnoreLongerOutputsThanInputs(value bool) CTCLossAttr {
	return func(m optionalAttr) {
		m["ignore_longer_outputs_than_inputs"] = value
	}
}

// Calculates the CTC Loss (log probability) for each batch entry.  Also calculates
//
// the gradient.  This class performs the softmax operation for you, so inputs
// should be e.g. linear projections of outputs by an LSTM.
//
// Arguments:
//
//	inputs: 3-D, shape: `(max_time x batch_size x num_classes)`, the logits.
//	labels_indices: The indices of a `SparseTensor<int32, 2>`.
//
// `labels_indices(i, :) == [b, t]` means `labels_values(i)` stores the id for
// `(batch b, time t)`.
//
//	labels_values: The values (labels) associated with the given batch and time.
//	sequence_length: A vector containing sequence lengths (batch).
//
// Returns:
//
//	loss: A vector (batch) containing log-probabilities.
//	gradient: The gradient of `loss`.  3-D, shape:
//
// `(max_time x batch_size x num_classes)`.
func CTCLoss(scope *Scope, inputs tf.Output, labels_indices tf.Output, labels_values tf.Output, sequence_length tf.Output, optional ...CTCLossAttr) (loss tf.Output, gradient tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CTCLoss",
		Input: []tf.Input{
			inputs, labels_indices, labels_values, sequence_length,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// CTCLossV2Attr is an optional argument to CTCLossV2.
type CTCLossV2Attr func(optionalAttr)

// CTCLossV2PreprocessCollapseRepeated sets the optional preprocess_collapse_repeated attribute to value.
//
// value: Scalar, if true then repeated labels are
// collapsed prior to the CTC calculation.
// If not specified, defaults to false
func CTCLossV2PreprocessCollapseRepeated(value bool) CTCLossV2Attr {
	return func(m optionalAttr) {
		m["preprocess_collapse_repeated"] = value
	}
}

// CTCLossV2CtcMergeRepeated sets the optional ctc_merge_repeated attribute to value.
//
// value: Scalar.  If set to false, *during* CTC calculation
// repeated non-blank labels will not be merged and are interpreted as
// individual labels.  This is a simplified version of CTC.
// If not specified, defaults to true
func CTCLossV2CtcMergeRepeated(value bool) CTCLossV2Attr {
	return func(m optionalAttr) {
		m["ctc_merge_repeated"] = value
	}
}

// CTCLossV2IgnoreLongerOutputsThanInputs sets the optional ignore_longer_outputs_than_inputs attribute to value.
//
// value: Scalar. If set to true, during CTC
// calculation, items that have longer output sequences than input sequences
// are skipped: they don't contribute to the loss term and have zero-gradient.
// If not specified, defaults to false
func CTCLossV2IgnoreLongerOutputsThanInputs(value bool) CTCLossV2Attr {
	return func(m optionalAttr) {
		m["ignore_longer_outputs_than_inputs"] = value
	}
}

// Calculates the CTC Loss (log probability) for each batch entry.  Also calculates
//
// the gradient.  This class performs the softmax operation for you, so inputs
// should be e.g. linear projections of outputs by an LSTM.
//
// Arguments:
//
//	inputs: 3-D, shape: `(max_time x batch_size x num_classes)`, the logits. Default blank
//
// label is 0 rather num_classes - 1.
//
//	labels_indices: The indices of a `SparseTensor<int32, 2>`.
//
// `labels_indices(i, :) == [b, t]` means `labels_values(i)` stores the id for
// `(batch b, time t)`.
//
//	labels_values: The values (labels) associated with the given batch and time.
//	sequence_length: A vector containing sequence lengths (batch).
//
// Returns:
//
//	loss: A vector (batch) containing log-probabilities.
//	gradient: The gradient of `loss`.  3-D, shape:
//
// `(max_time x batch_size x num_classes)`.
func CTCLossV2(scope *Scope, inputs tf.Output, labels_indices tf.Output, labels_values tf.Output, sequence_length tf.Output, optional ...CTCLossV2Attr) (loss tf.Output, gradient tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CTCLossV2",
		Input: []tf.Input{
			inputs, labels_indices, labels_values, sequence_length,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// CacheDatasetAttr is an optional argument to CacheDataset.
type CacheDatasetAttr func(optionalAttr)

// CacheDatasetMetadata sets the optional metadata attribute to value.
// If not specified, defaults to ""
func CacheDatasetMetadata(value string) CacheDatasetAttr {
	return func(m optionalAttr) {
		m["metadata"] = value
	}
}

// Creates a dataset that caches elements from `input_dataset`.
//
// A CacheDataset will iterate over the input_dataset, and store tensors. If the
// cache already exists, the cache will be used. If the cache is inappropriate
// (e.g. cannot be opened, contains tensors of the wrong shape / size), an error
// will the returned when used.
//
// Arguments:
//
//	filename: A path on the filesystem where we should cache the dataset. Note: this
//
// will be a directory.
func CacheDataset(scope *Scope, input_dataset tf.Output, filename tf.Output, output_types []tf.DataType, output_shapes []tf.Shape, optional ...CacheDatasetAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CacheDataset",
		Input: []tf.Input{
			input_dataset, filename,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// CastAttr is an optional argument to Cast.
type CastAttr func(optionalAttr)

// CastTruncate sets the optional Truncate attribute to value.
// If not specified, defaults to false
func CastTruncate(value bool) CastAttr {
	return func(m optionalAttr) {
		m["Truncate"] = value
	}
}

// Cast x of type SrcT to y of DstT.
func Cast(scope *Scope, x tf.Output, DstT tf.DataType, optional ...CastAttr) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"DstT": DstT}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Cast",
		Input: []tf.Input{
			x,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns element-wise smallest integer not less than x.
func Ceil(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Ceil",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Checks a tensor for NaN and Inf values.
//
// When run, reports an `InvalidArgument` error if `tensor` has any values
// that are not a number (NaN) or infinity (Inf). Otherwise, returns the input
// tensor.
//
// Example usage:
//
// ``` python
// a = tf.Variable(1.0)
// tf.debugging.check_numerics(a, message=”)
//
// b = tf.Variable(np.nan)
// try:
//
//	tf.debugging.check_numerics(b, message='Checking b')
//
// except Exception as e:
//
//	assert "Checking b : Tensor had NaN values" in e.message
//
// c = tf.Variable(np.inf)
// try:
//
//	tf.debugging.check_numerics(c, message='Checking c')
//
// except Exception as e:
//
//	assert "Checking c : Tensor had Inf values" in e.message
//
// ```
//
// Arguments:
//
//	message: Prefix of the error message.
func CheckNumerics(scope *Scope, tensor tf.Output, message string) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"message": message}
	opspec := tf.OpSpec{
		Type: "CheckNumerics",
		Input: []tf.Input{
			tensor,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Checks a tensor for NaN, -Inf and +Inf values.
//
// When run, reports an `InvalidArgument` error if `tensor` has any values
// that are not a number (NaN) or infinity (Inf). Otherwise, returns the input
// tensor. Unlike CheckNumerics (V1), CheckNumericsV2 distinguishes -Inf and +Inf
// in the errors it throws.
//
// Arguments:
//
//	message: Prefix of the error message.
func CheckNumericsV2(scope *Scope, tensor tf.Output, message string) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"message": message}
	opspec := tf.OpSpec{
		Type: "CheckNumericsV2",
		Input: []tf.Input{
			tensor,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Checks whether a tensor is located in host memory pinned for GPU.
//
// When run:
// - Reports an `InvalidArgument` error if `tensor` is not in pinned memory.
// - Reports a `FailedPrecondition` error if not built with CUDA.
func CheckPinned(scope *Scope, tensor tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "CheckPinned",
		Input: []tf.Input{
			tensor,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the Cholesky decomposition of one or more square matrices.
//
// The input is a tensor of shape `[..., M, M]` whose inner-most 2 dimensions
// form square matrices.
//
// The input has to be symmetric and positive definite. Only the lower-triangular
// part of the input will be used for this operation. The upper-triangular part
// will not be read.
//
// The output is a tensor of the same shape as the input
// containing the Cholesky decompositions for all input submatrices `[..., :, :]`.
//
// **Note**: The gradient computation on GPU is faster for large matrices but
// not for large batch dimensions when the submatrices are small. In this
// case it might be faster to use the CPU.
//
// Arguments:
//
//	input: Shape is `[..., M, M]`.
//
// Returns Shape is `[..., M, M]`.
func Cholesky(scope *Scope, input tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Cholesky",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the reverse mode backpropagated gradient of the Cholesky algorithm.
//
// For an explanation see "Differentiation of the Cholesky algorithm" by
// Iain Murray http://arxiv.org/abs/1602.07527.
//
// Arguments:
//
//	l: Output of batch Cholesky algorithm l = cholesky(A). Shape is `[..., M, M]`.
//
// Algorithm depends only on lower triangular part of the innermost matrices of
// this tensor.
//
//	grad: df/dl where f is some scalar function. Shape is `[..., M, M]`.
//
// Algorithm depends only on lower triangular part of the innermost matrices of
// this tensor.
//
// Returns Symmetrized version of df/dA . Shape is `[..., M, M]`
func CholeskyGrad(scope *Scope, l tf.Output, grad tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "CholeskyGrad",
		Input: []tf.Input{
			l, grad,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Clips tensor values to a specified min and max.
//
// Given a tensor `t`, this operation returns a tensor of the same type and
// shape as `t` with its values clipped to `clip_value_min` and `clip_value_max`.
// Any values less than `clip_value_min` are set to `clip_value_min`. Any values
// greater than `clip_value_max` are set to `clip_value_max`.
//
// Arguments:
//
//	t: A `Tensor`.
//	clip_value_min: A 0-D (scalar) `Tensor`, or a `Tensor` with the same shape
//
// as `t`. The minimum value to clip by.
//
//	clip_value_max: A 0-D (scalar) `Tensor`, or a `Tensor` with the same shape
//
// as `t`. The maximum value to clip by.
//
// Returns A clipped `Tensor` with the same shape as input 't'.
func ClipByValue(scope *Scope, t tf.Output, clip_value_min tf.Output, clip_value_max tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ClipByValue",
		Input: []tf.Input{
			t, clip_value_min, clip_value_max,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// An op that merges the string-encoded memory config protos from all hosts.
//
// Arguments:
//
//	memory_configs: String-encoded memory config protos containing metadata about
//
// the memory allocations reserved for TPUEmbedding across all hosts.
func CollateTPUEmbeddingMemory(scope *Scope, memory_configs []tf.Output) (merged_memory_config tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "CollateTPUEmbeddingMemory",
		Input: []tf.Input{
			tf.OutputList(memory_configs),
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// CollectiveAllToAllV2Attr is an optional argument to CollectiveAllToAllV2.
type CollectiveAllToAllV2Attr func(optionalAttr)

// CollectiveAllToAllV2CommunicationHint sets the optional communication_hint attribute to value.
// If not specified, defaults to "auto"
func CollectiveAllToAllV2CommunicationHint(value string) CollectiveAllToAllV2Attr {
	return func(m optionalAttr) {
		m["communication_hint"] = value
	}
}

// CollectiveAllToAllV2TimeoutSeconds sets the optional timeout_seconds attribute to value.
// If not specified, defaults to 0
func CollectiveAllToAllV2TimeoutSeconds(value float32) CollectiveAllToAllV2Attr {
	return func(m optionalAttr) {
		m["timeout_seconds"] = value
	}
}

// CollectiveAllToAllV2IsStateless sets the optional is_stateless attribute to value.
// If not specified, defaults to false
func CollectiveAllToAllV2IsStateless(value bool) CollectiveAllToAllV2Attr {
	return func(m optionalAttr) {
		m["is_stateless"] = value
	}
}

// Mutually exchanges multiple tensors of identical type and shape.
//
// `is_stateless` means each op does not need control dependencies to other
// collective ops. In this case, keys that are unique at runtime
// (e.g. `instance_key`) should be used to distinguish collective groups.
func CollectiveAllToAllV2(scope *Scope, input tf.Output, group_size tf.Output, group_key tf.Output, instance_key tf.Output, ordering_token []tf.Output, optional ...CollectiveAllToAllV2Attr) (data tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CollectiveAllToAllV2",
		Input: []tf.Input{
			input, group_size, group_key, instance_key, tf.OutputList(ordering_token),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// CollectiveAllToAllV3Attr is an optional argument to CollectiveAllToAllV3.
type CollectiveAllToAllV3Attr func(optionalAttr)

// CollectiveAllToAllV3TimeoutSeconds sets the optional timeout_seconds attribute to value.
// If not specified, defaults to 0
func CollectiveAllToAllV3TimeoutSeconds(value float32) CollectiveAllToAllV3Attr {
	return func(m optionalAttr) {
		m["timeout_seconds"] = value
	}
}

// Mutually exchanges multiple tensors of identical type and shape.
func CollectiveAllToAllV3(scope *Scope, input tf.Output, communicator tf.Output, group_assignment tf.Output, optional ...CollectiveAllToAllV3Attr) (data tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CollectiveAllToAllV3",
		Input: []tf.Input{
			input, communicator, group_assignment,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Assign group keys based on group assignment.
func CollectiveAssignGroupV2(scope *Scope, group_assignment tf.Output, device_index tf.Output, base_key tf.Output) (group_size tf.Output, group_key tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "CollectiveAssignGroupV2",
		Input: []tf.Input{
			group_assignment, device_index, base_key,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// CollectiveBcastRecvAttr is an optional argument to CollectiveBcastRecv.
type CollectiveBcastRecvAttr func(optionalAttr)

// CollectiveBcastRecvCommunicationHint sets the optional communication_hint attribute to value.
// If not specified, defaults to "auto"
func CollectiveBcastRecvCommunicationHint(value string) CollectiveBcastRecvAttr {
	return func(m optionalAttr) {
		m["communication_hint"] = value
	}
}

// CollectiveBcastRecvTimeoutSeconds sets the optional timeout_seconds attribute to value.
// If not specified, defaults to 0
func CollectiveBcastRecvTimeoutSeconds(value float32) CollectiveBcastRecvAttr {
	return func(m optionalAttr) {
		m["timeout_seconds"] = value
	}
}

// Receives a tensor value broadcast from another device.
func CollectiveBcastRecv(scope *Scope, T tf.DataType, group_size int64, group_key int64, instance_key int64, shape tf.Shape, optional ...CollectiveBcastRecvAttr) (data tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"T": T, "group_size": group_size, "group_key": group_key, "instance_key": instance_key, "shape": shape}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CollectiveBcastRecv",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// CollectiveBcastRecvV2Attr is an optional argument to CollectiveBcastRecvV2.
type CollectiveBcastRecvV2Attr func(optionalAttr)

// CollectiveBcastRecvV2CommunicationHint sets the optional communication_hint attribute to value.
// If not specified, defaults to "auto"
func CollectiveBcastRecvV2CommunicationHint(value string) CollectiveBcastRecvV2Attr {
	return func(m optionalAttr) {
		m["communication_hint"] = value
	}
}

// CollectiveBcastRecvV2TimeoutSeconds sets the optional timeout_seconds attribute to value.
// If not specified, defaults to 0
func CollectiveBcastRecvV2TimeoutSeconds(value float32) CollectiveBcastRecvV2Attr {
	return func(m optionalAttr) {
		m["timeout_seconds"] = value
	}
}

// Receives a tensor value broadcast from another device.
func CollectiveBcastRecvV2(scope *Scope, group_size tf.Output, group_key tf.Output, instance_key tf.Output, shape tf.Output, T tf.DataType, optional ...CollectiveBcastRecvV2Attr) (data tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"T": T}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CollectiveBcastRecvV2",
		Input: []tf.Input{
			group_size, group_key, instance_key, shape,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// CollectiveBcastSendAttr is an optional argument to CollectiveBcastSend.
type CollectiveBcastSendAttr func(optionalAttr)

// CollectiveBcastSendCommunicationHint sets the optional communication_hint attribute to value.
// If not specified, defaults to "auto"
func CollectiveBcastSendCommunicationHint(value string) CollectiveBcastSendAttr {
	return func(m optionalAttr) {
		m["communication_hint"] = value
	}
}

// CollectiveBcastSendTimeoutSeconds sets the optional timeout_seconds attribute to value.
// If not specified, defaults to 0
func CollectiveBcastSendTimeoutSeconds(value float32) CollectiveBcastSendAttr {
	return func(m optionalAttr) {
		m["timeout_seconds"] = value
	}
}

// Broadcasts a tensor value to one or more other devices.
func CollectiveBcastSend(scope *Scope, input tf.Output, group_size int64, group_key int64, instance_key int64, shape tf.Shape, optional ...CollectiveBcastSendAttr) (data tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"group_size": group_size, "group_key": group_key, "instance_key": instance_key, "shape": shape}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CollectiveBcastSend",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// CollectiveBcastSendV2Attr is an optional argument to CollectiveBcastSendV2.
type CollectiveBcastSendV2Attr func(optionalAttr)

// CollectiveBcastSendV2CommunicationHint sets the optional communication_hint attribute to value.
// If not specified, defaults to "auto"
func CollectiveBcastSendV2CommunicationHint(value string) CollectiveBcastSendV2Attr {
	return func(m optionalAttr) {
		m["communication_hint"] = value
	}
}

// CollectiveBcastSendV2TimeoutSeconds sets the optional timeout_seconds attribute to value.
// If not specified, defaults to 0
func CollectiveBcastSendV2TimeoutSeconds(value float32) CollectiveBcastSendV2Attr {
	return func(m optionalAttr) {
		m["timeout_seconds"] = value
	}
}

// Broadcasts a tensor value to one or more other devices.
func CollectiveBcastSendV2(scope *Scope, input tf.Output, group_size tf.Output, group_key tf.Output, instance_key tf.Output, optional ...CollectiveBcastSendV2Attr) (data tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CollectiveBcastSendV2",
		Input: []tf.Input{
			input, group_size, group_key, instance_key,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// CollectiveGatherAttr is an optional argument to CollectiveGather.
type CollectiveGatherAttr func(optionalAttr)

// CollectiveGatherCommunicationHint sets the optional communication_hint attribute to value.
// If not specified, defaults to "auto"
func CollectiveGatherCommunicationHint(value string) CollectiveGatherAttr {
	return func(m optionalAttr) {
		m["communication_hint"] = value
	}
}

// CollectiveGatherTimeoutSeconds sets the optional timeout_seconds attribute to value.
// If not specified, defaults to 0
func CollectiveGatherTimeoutSeconds(value float32) CollectiveGatherAttr {
	return func(m optionalAttr) {
		m["timeout_seconds"] = value
	}
}

// Mutually accumulates multiple tensors of identical type and shape.
func CollectiveGather(scope *Scope, input tf.Output, group_size int64, group_key int64, instance_key int64, shape tf.Shape, optional ...CollectiveGatherAttr) (data tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"group_size": group_size, "group_key": group_key, "instance_key": instance_key, "shape": shape}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CollectiveGather",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// CollectiveGatherV2Attr is an optional argument to CollectiveGatherV2.
type CollectiveGatherV2Attr func(optionalAttr)

// CollectiveGatherV2CommunicationHint sets the optional communication_hint attribute to value.
// If not specified, defaults to "auto"
func CollectiveGatherV2CommunicationHint(value string) CollectiveGatherV2Attr {
	return func(m optionalAttr) {
		m["communication_hint"] = value
	}
}

// CollectiveGatherV2TimeoutSeconds sets the optional timeout_seconds attribute to value.
// If not specified, defaults to 0
func CollectiveGatherV2TimeoutSeconds(value float32) CollectiveGatherV2Attr {
	return func(m optionalAttr) {
		m["timeout_seconds"] = value
	}
}

// CollectiveGatherV2IsStateless sets the optional is_stateless attribute to value.
// If not specified, defaults to false
func CollectiveGatherV2IsStateless(value bool) CollectiveGatherV2Attr {
	return func(m optionalAttr) {
		m["is_stateless"] = value
	}
}

// Mutually accumulates multiple tensors of identical type and shape.
//
// `is_stateless` means each op does not need control dependencies to other
// collective ops. In this case, keys that are unique at runtime
// (e.g. `instance_key`) should be used to distinguish collective groups.
func CollectiveGatherV2(scope *Scope, input tf.Output, group_size tf.Output, group_key tf.Output, instance_key tf.Output, ordering_token []tf.Output, optional ...CollectiveGatherV2Attr) (data tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CollectiveGatherV2",
		Input: []tf.Input{
			input, group_size, group_key, instance_key, tf.OutputList(ordering_token),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// CollectiveInitializeCommunicatorAttr is an optional argument to CollectiveInitializeCommunicator.
type CollectiveInitializeCommunicatorAttr func(optionalAttr)

// CollectiveInitializeCommunicatorCommunicationHint sets the optional communication_hint attribute to value.
// If not specified, defaults to "auto"
func CollectiveInitializeCommunicatorCommunicationHint(value string) CollectiveInitializeCommunicatorAttr {
	return func(m optionalAttr) {
		m["communication_hint"] = value
	}
}

// CollectiveInitializeCommunicatorTimeoutSeconds sets the optional timeout_seconds attribute to value.
// If not specified, defaults to 0
func CollectiveInitializeCommunicatorTimeoutSeconds(value float32) CollectiveInitializeCommunicatorAttr {
	return func(m optionalAttr) {
		m["timeout_seconds"] = value
	}
}

// Initializes a group for collective operations.
func CollectiveInitializeCommunicator(scope *Scope, group_key tf.Output, rank tf.Output, group_size tf.Output, optional ...CollectiveInitializeCommunicatorAttr) (communicator tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CollectiveInitializeCommunicator",
		Input: []tf.Input{
			group_key, rank, group_size,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// An Op to permute tensors across replicated TPU instances.
//
// Each instance supplies its own input.
//
// For example, suppose there are 4 TPU instances: `[A, B, C, D]`. Passing
// source_target_pairs=`[[0,1],[1,2],[2,3],[3,0]]` gets the outputs:
// `[D, A, B, C]`.
//
// Arguments:
//
//	input: The local input to be permuted. Currently only supports float and
//
// bfloat16.
//
//	source_target_pairs: A tensor with shape [num_pairs, 2].
//
// Returns The permuted input.
func CollectivePermute(scope *Scope, input tf.Output, source_target_pairs tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "CollectivePermute",
		Input: []tf.Input{
			input, source_target_pairs,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// CollectiveReduceAttr is an optional argument to CollectiveReduce.
type CollectiveReduceAttr func(optionalAttr)

// CollectiveReduceWaitFor sets the optional wait_for attribute to value.
// If not specified, defaults to {}
func CollectiveReduceWaitFor(value []int64) CollectiveReduceAttr {
	return func(m optionalAttr) {
		m["wait_for"] = value
	}
}

// CollectiveReduceCommunicationHint sets the optional communication_hint attribute to value.
// If not specified, defaults to "auto"
func CollectiveReduceCommunicationHint(value string) CollectiveReduceAttr {
	return func(m optionalAttr) {
		m["communication_hint"] = value
	}
}

// CollectiveReduceTimeoutSeconds sets the optional timeout_seconds attribute to value.
// If not specified, defaults to 0
func CollectiveReduceTimeoutSeconds(value float32) CollectiveReduceAttr {
	return func(m optionalAttr) {
		m["timeout_seconds"] = value
	}
}

// Mutually reduces multiple tensors of identical type and shape.
func CollectiveReduce(scope *Scope, input tf.Output, group_size int64, group_key int64, instance_key int64, merge_op string, final_op string, subdiv_offsets []int64, optional ...CollectiveReduceAttr) (data tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"group_size": group_size, "group_key": group_key, "instance_key": instance_key, "merge_op": merge_op, "final_op": final_op, "subdiv_offsets": subdiv_offsets}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CollectiveReduce",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// CollectiveReduceScatterV2Attr is an optional argument to CollectiveReduceScatterV2.
type CollectiveReduceScatterV2Attr func(optionalAttr)

// CollectiveReduceScatterV2CommunicationHint sets the optional communication_hint attribute to value.
// If not specified, defaults to "auto"
func CollectiveReduceScatterV2CommunicationHint(value string) CollectiveReduceScatterV2Attr {
	return func(m optionalAttr) {
		m["communication_hint"] = value
	}
}

// CollectiveReduceScatterV2TimeoutSeconds sets the optional timeout_seconds attribute to value.
// If not specified, defaults to 0
func CollectiveReduceScatterV2TimeoutSeconds(value float32) CollectiveReduceScatterV2Attr {
	return func(m optionalAttr) {
		m["timeout_seconds"] = value
	}
}

// CollectiveReduceScatterV2IsStateless sets the optional is_stateless attribute to value.
// If not specified, defaults to false
func CollectiveReduceScatterV2IsStateless(value bool) CollectiveReduceScatterV2Attr {
	return func(m optionalAttr) {
		m["is_stateless"] = value
	}
}

// CollectiveReduceScatterV2MaxSubdivsPerDevice sets the optional max_subdivs_per_device attribute to value.
// If not specified, defaults to -1
func CollectiveReduceScatterV2MaxSubdivsPerDevice(value int64) CollectiveReduceScatterV2Attr {
	return func(m optionalAttr) {
		m["max_subdivs_per_device"] = value
	}
}

// Mutually reduces multiple tensors of identical type and shape and scatters the result.
//
// `is_stateless` means each op does not need control dependencies to other
// collective ops. In this case, keys that are unique at runtime
// (e.g. `instance_key`) should be used to distinguish collective groups.
func CollectiveReduceScatterV2(scope *Scope, input tf.Output, group_size tf.Output, group_key tf.Output, instance_key tf.Output, ordering_token []tf.Output, merge_op string, final_op string, optional ...CollectiveReduceScatterV2Attr) (data tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"merge_op": merge_op, "final_op": final_op}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CollectiveReduceScatterV2",
		Input: []tf.Input{
			input, group_size, group_key, instance_key, tf.OutputList(ordering_token),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// CollectiveReduceV2Attr is an optional argument to CollectiveReduceV2.
type CollectiveReduceV2Attr func(optionalAttr)

// CollectiveReduceV2CommunicationHint sets the optional communication_hint attribute to value.
// If not specified, defaults to "auto"
func CollectiveReduceV2CommunicationHint(value string) CollectiveReduceV2Attr {
	return func(m optionalAttr) {
		m["communication_hint"] = value
	}
}

// CollectiveReduceV2TimeoutSeconds sets the optional timeout_seconds attribute to value.
// If not specified, defaults to 0
func CollectiveReduceV2TimeoutSeconds(value float32) CollectiveReduceV2Attr {
	return func(m optionalAttr) {
		m["timeout_seconds"] = value
	}
}

// CollectiveReduceV2IsStateless sets the optional is_stateless attribute to value.
// If not specified, defaults to false
func CollectiveReduceV2IsStateless(value bool) CollectiveReduceV2Attr {
	return func(m optionalAttr) {
		m["is_stateless"] = value
	}
}

// CollectiveReduceV2MaxSubdivsPerDevice sets the optional max_subdivs_per_device attribute to value.
// If not specified, defaults to -1
func CollectiveReduceV2MaxSubdivsPerDevice(value int64) CollectiveReduceV2Attr {
	return func(m optionalAttr) {
		m["max_subdivs_per_device"] = value
	}
}

// Mutually reduces multiple tensors of identical type and shape.
//
// `is_stateless` means each op does not need control dependencies to other
// collective ops. In this case, keys that are unique at runtime
// (e.g. `instance_key`) should be used to distinguish collective groups.
func CollectiveReduceV2(scope *Scope, input tf.Output, group_size tf.Output, group_key tf.Output, instance_key tf.Output, ordering_token []tf.Output, merge_op string, final_op string, optional ...CollectiveReduceV2Attr) (data tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"merge_op": merge_op, "final_op": final_op}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CollectiveReduceV2",
		Input: []tf.Input{
			input, group_size, group_key, instance_key, tf.OutputList(ordering_token),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// CollectiveReduceV3Attr is an optional argument to CollectiveReduceV3.
type CollectiveReduceV3Attr func(optionalAttr)

// CollectiveReduceV3TimeoutSeconds sets the optional timeout_seconds attribute to value.
// If not specified, defaults to 0
func CollectiveReduceV3TimeoutSeconds(value float32) CollectiveReduceV3Attr {
	return func(m optionalAttr) {
		m["timeout_seconds"] = value
	}
}

// Mutually reduces multiple tensors of identical type and shape.
func CollectiveReduceV3(scope *Scope, input tf.Output, communicator tf.Output, group_assignment tf.Output, reduction string, optional ...CollectiveReduceV3Attr) (data tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"reduction": reduction}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CollectiveReduceV3",
		Input: []tf.Input{
			input, communicator, group_assignment,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// CombinedNonMaxSuppressionAttr is an optional argument to CombinedNonMaxSuppression.
type CombinedNonMaxSuppressionAttr func(optionalAttr)

// CombinedNonMaxSuppressionPadPerClass sets the optional pad_per_class attribute to value.
//
// value: If false, the output nmsed boxes, scores and classes
// are padded/clipped to `max_total_size`. If true, the
// output nmsed boxes, scores and classes are padded to be of length
// `max_size_per_class`*`num_classes`, unless it exceeds `max_total_size` in
// which case it is clipped to `max_total_size`. Defaults to false.
// If not specified, defaults to false
func CombinedNonMaxSuppressionPadPerClass(value bool) CombinedNonMaxSuppressionAttr {
	return func(m optionalAttr) {
		m["pad_per_class"] = value
	}
}

// CombinedNonMaxSuppressionClipBoxes sets the optional clip_boxes attribute to value.
//
// value: If true, assume the box coordinates are between [0, 1] and clip the output boxes
// if they fall beyond [0, 1]. If false, do not do clipping and output the box
// coordinates as it is.
// If not specified, defaults to true
func CombinedNonMaxSuppressionClipBoxes(value bool) CombinedNonMaxSuppressionAttr {
	return func(m optionalAttr) {
		m["clip_boxes"] = value
	}
}

// Greedily selects a subset of bounding boxes in descending order of score,
//
// This operation performs non_max_suppression on the inputs per batch, across
// all classes.
// Prunes away boxes that have high intersection-over-union (IOU) overlap
// with previously selected boxes.  Bounding boxes are supplied as
// [y1, x1, y2, x2], where (y1, x1) and (y2, x2) are the coordinates of any
// diagonal pair of box corners and the coordinates can be provided as normalized
// (i.e., lying in the interval [0, 1]) or absolute.  Note that this algorithm
// is agnostic to where the origin is in the coordinate system. Also note that
// this algorithm is invariant to orthogonal transformations and translations
// of the coordinate system; thus translating or reflections of the coordinate
// system result in the same boxes being selected by the algorithm.
// The output of this operation is the final boxes, scores and classes tensor
// returned after performing non_max_suppression.
//
// Arguments:
//
//	boxes: A 4-D float tensor of shape `[batch_size, num_boxes, q, 4]`. If `q` is 1 then
//
// same boxes are used for all classes otherwise, if `q` is equal to number of
// classes, class-specific boxes are used.
//
//	scores: A 3-D float tensor of shape `[batch_size, num_boxes, num_classes]`
//
// representing a single score corresponding to each box (each row of boxes).
//
//	max_output_size_per_class: A scalar integer tensor representing the maximum number of
//
// boxes to be selected by non max suppression per class
//
//	max_total_size: An int32 scalar representing the maximum number of boxes retained over all
//
// classes. Note that setting this value to a large number may result in OOM error
// depending on the system workload.
//
//	iou_threshold: A 0-D float tensor representing the threshold for deciding whether
//
// boxes overlap too much with respect to IOU.
//
//	score_threshold: A 0-D float tensor representing the threshold for deciding when to remove
//
// boxes based on score.
//
// Returns:
//
//	nmsed_boxes: A [batch_size, max_detections, 4] float32 tensor
//
// containing the non-max suppressed boxes.
//
//	nmsed_scores: A [batch_size, max_detections] float32 tensor
//
// containing the scores for the boxes.
//
//	nmsed_classes: A [batch_size, max_detections] float32 tensor
//
// containing the classes for the boxes.
//
//	valid_detections: A [batch_size] int32 tensor indicating the number of
//
// valid detections per batch item. Only the top num_detections[i] entries in
// nms_boxes[i], nms_scores[i] and nms_class[i] are valid. The rest of the
// entries are zero paddings.
func CombinedNonMaxSuppression(scope *Scope, boxes tf.Output, scores tf.Output, max_output_size_per_class tf.Output, max_total_size tf.Output, iou_threshold tf.Output, score_threshold tf.Output, optional ...CombinedNonMaxSuppressionAttr) (nmsed_boxes tf.Output, nmsed_scores tf.Output, nmsed_classes tf.Output, valid_detections tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CombinedNonMaxSuppression",
		Input: []tf.Input{
			boxes, scores, max_output_size_per_class, max_total_size, iou_threshold, score_threshold,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3)
}

// ComplexAttr is an optional argument to Complex.
type ComplexAttr func(optionalAttr)

// ComplexTout sets the optional Tout attribute to value.
// If not specified, defaults to DT_COMPLEX64
func ComplexTout(value tf.DataType) ComplexAttr {
	return func(m optionalAttr) {
		m["Tout"] = value
	}
}

// Converts two real numbers to a complex number.
//
// Given a tensor `real` representing the real part of a complex number, and a
// tensor `imag` representing the imaginary part of a complex number, this
// operation returns complex numbers elementwise of the form \\(a + bj\\), where
// *a* represents the `real` part and *b* represents the `imag` part.
//
// The input tensors `real` and `imag` must have the same shape.
//
// For example:
//
// ```
// # tensor 'real' is [2.25, 3.25]
// # tensor `imag` is [4.75, 5.75]
// tf.complex(real, imag) ==> [[2.25 + 4.75j], [3.25 + 5.75j]]
// ```
func Complex(scope *Scope, real tf.Output, imag tf.Output, optional ...ComplexAttr) (out tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Complex",
		Input: []tf.Input{
			real, imag,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ComplexAbsAttr is an optional argument to ComplexAbs.
type ComplexAbsAttr func(optionalAttr)

// ComplexAbsTout sets the optional Tout attribute to value.
//
// value: Need to be `tf.float32` when the type of `x` is `tf.complex64`.
// Need to be `tf.float64` when the type of `x` is `tf.complex128`.
// If not specified, defaults to DT_FLOAT
func ComplexAbsTout(value tf.DataType) ComplexAbsAttr {
	return func(m optionalAttr) {
		m["Tout"] = value
	}
}

// Computes the complex absolute value of a tensor.
//
// Given a tensor `x` of complex numbers, this operation returns a tensor of type
// `float` or `double` that is the absolute value of each element in `x`. All
// elements in `x` must be complex numbers of the form \\(a + bj\\). The absolute
// value is computed as \\( \sqrt{a^2 + b^2}\\).
//
// For example:
//
// >>> x = tf.complex(3.0, 4.0)
// >>> print((tf.raw_ops.ComplexAbs(x=x, Tout=tf.dtypes.float32, name=None)).numpy())
// 5.0
func ComplexAbs(scope *Scope, x tf.Output, optional ...ComplexAbsAttr) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ComplexAbs",
		Input: []tf.Input{
			x,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Encodes an `ExtensionType` value into a `variant` scalar Tensor.
//
// Returns a scalar variant tensor containing a single `CompositeTensorVariant`
// with the specified Tensor components and TypeSpec.
//
// Arguments:
//
//	components: The component tensors for the extension type value.
//	metadata: String serialization for the TypeSpec.  (Note: the encoding for the TypeSpec
//
// may change in future versions of TensorFlow.)
//
// Returns A `variant` Tensor that containing the encoded value.
func CompositeTensorVariantFromComponents(scope *Scope, components []tf.Output, metadata string) (encoded tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"metadata": metadata}
	opspec := tf.OpSpec{
		Type: "CompositeTensorVariantFromComponents",
		Input: []tf.Input{
			tf.OutputList(components),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Decodes a `variant` scalar Tensor into an `ExtensionType` value.
//
// Returns the Tensor components encoded in a `CompositeTensorVariant`.
//
// Raises an error if `type_spec_proto` doesn't match the TypeSpec
// in `encoded`.
//
// Arguments:
//
//	encoded: A scalar `variant` Tensor containing an encoded ExtensionType value.
//	metadata: String serialization for the TypeSpec.  Must be compatible with the
//
// `TypeSpec` contained in `encoded`.  (Note: the encoding for the TypeSpec
// may change in future versions of TensorFlow.)
//
//	Tcomponents: Expected dtypes for components.
//
// Returns The component tensors for the ExtensionType value in `encoded`.
func CompositeTensorVariantToComponents(scope *Scope, encoded tf.Output, metadata string, Tcomponents []tf.DataType) (components []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"metadata": metadata, "Tcomponents": Tcomponents}
	opspec := tf.OpSpec{
		Type: "CompositeTensorVariantToComponents",
		Input: []tf.Input{
			encoded,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if components, idx, err = makeOutputList(op, idx, "components"); err != nil {
		scope.UpdateErr("CompositeTensorVariantToComponents", err)
		return
	}
	return components
}

// Compresses a dataset element.
func CompressElement(scope *Scope, components []tf.Output) (compressed tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "CompressElement",
		Input: []tf.Input{
			tf.OutputList(components),
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ComputeAccidentalHitsAttr is an optional argument to ComputeAccidentalHits.
type ComputeAccidentalHitsAttr func(optionalAttr)

// ComputeAccidentalHitsSeed sets the optional seed attribute to value.
//
// value: If either seed or seed2 are set to be non-zero, the random number
// generator is seeded by the given seed.  Otherwise, it is seeded by a
// random seed.
// If not specified, defaults to 0
func ComputeAccidentalHitsSeed(value int64) ComputeAccidentalHitsAttr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// ComputeAccidentalHitsSeed2 sets the optional seed2 attribute to value.
//
// value: An second seed to avoid seed collision.
// If not specified, defaults to 0
func ComputeAccidentalHitsSeed2(value int64) ComputeAccidentalHitsAttr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// Computes the ids of the positions in sampled_candidates that match true_labels.
//
// When doing log-odds NCE, the result of this op should be passed through a
// SparseToDense op, then added to the logits of the sampled candidates. This has
// the effect of 'removing' the sampled labels that match the true labels by
// making the classifier sure that they are sampled labels.
//
// Arguments:
//
//	true_classes: The true_classes output of UnpackSparseLabels.
//	sampled_candidates: The sampled_candidates output of CandidateSampler.
//	num_true: Number of true labels per context.
//
// Returns:
//
//	indices: A vector of indices corresponding to rows of true_candidates.
//	ids: A vector of IDs of positions in sampled_candidates that match a true_label
//
// for the row with the corresponding index in indices.
//
//	weights: A vector of the same length as indices and ids, in which each element
//
// is -FLOAT_MAX.
func ComputeAccidentalHits(scope *Scope, true_classes tf.Output, sampled_candidates tf.Output, num_true int64, optional ...ComputeAccidentalHitsAttr) (indices tf.Output, ids tf.Output, weights tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_true": num_true}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ComputeAccidentalHits",
		Input: []tf.Input{
			true_classes, sampled_candidates,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// Computes the static batch size of a dataset sans partial batches.
func ComputeBatchSize(scope *Scope, input_dataset tf.Output) (batch_size tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ComputeBatchSize",
		Input: []tf.Input{
			input_dataset,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// An op computes the size of the deduplication data from embedding core and returns the updated config.
//
// This op is to compute size of the deduplication data so to provide this
// information to the op that computes the tuple mask of deduplication data can
// have static output shape.
//
// Arguments:
//
//	config: Serialized TPUEmbeddingConfiguration proto.
//
// Returns The size of the deduplicated data from infeed.
func ComputeDedupDataSize(scope *Scope, config string) (num_elements tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"config": config}
	opspec := tf.OpSpec{
		Type: "ComputeDedupDataSize",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// An op computes the size of the deduplication data from embedding core and returns the updated config.
//
// This op is to compute size of the deduplication data so to provide this
// information to the op that computes the tuple mask of deduplication data can
// have static output shape.
//
// Arguments:
//
//	config: Serialized TPUEmbeddingConfiguration proto.
//	embedding_partitions: Serialized EmbeddingPartitionsProto proto.
//	hbm_buffers_config: Serialized HbmBuffersConfig proto.
//	tpu_topology: Serialized TpuTopologyArgsProto proto.
//
// Returns The size of the deduplicated data from infeed.
func ComputeDedupDataSizeV2(scope *Scope, config string, embedding_partitions string, hbm_buffers_config string, tpu_topology string) (num_elements tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"config": config, "embedding_partitions": embedding_partitions, "hbm_buffers_config": hbm_buffers_config, "tpu_topology": tpu_topology}
	opspec := tf.OpSpec{
		Type: "ComputeDedupDataSizeV2",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// An op computes tuple mask of deduplication data from embedding core.
//
// The deduplication data receiving from embedding core is a Tensor with
// type=DT_VARIANT. The tensor itself is an XLA nested tuple, whose elements are
// rank 1 tensors. This op is to represents types and length of these elements.
//
// Arguments:
//
//	config: Serialized TPUEmbeddingConfiguration proto.
//
// Returns A 2-D int tensor represent mask of deduplication data tuple generated by
// `XlaRecvTPUEmbeddingDeduplicationData`. The tuple has several integer and float
// type 1-D tensor tuple elements. The first dimenion of this output_shape 2-D
// tensor is tensor type of tuple elements, `0` represents integer tensor, `1`
// represents float tensor. The second dimension of `output_shape` gives length of
// each tuple element.
func ComputeDedupDataTupleMask(scope *Scope, config string) (output_shape tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"config": config}
	opspec := tf.OpSpec{
		Type: "ComputeDedupDataTupleMask",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// An op computes tuple mask of deduplication data from embedding core.
//
// The deduplication data receiving from embedding core is a Tensor with
// type=DT_VARIANT. The tensor itself is an XLA nested tuple, whose elements are
// rank 1 tensors. This op is to represents types and length of these elements.
//
// Arguments:
//
//	config: Serialized TPUEmbeddingConfiguration proto.
//	embedding_partitions: Serialized EmbeddingPartitionsProto proto.
//	hbm_buffers_config: Serialized HbmBuffersConfig proto.
//	tpu_topology: Serialized TpuTopologyArgsProto proto.
//
// Returns A 2-D int tensor represent mask of deduplication data tuple generated by
// `XlaRecvTPUEmbeddingDeduplicationData`. The tuple has several integer and float
// type 1-D tensor tuple elements. The first dimenion of this output_shape 2-D
// tensor is tensor type of tuple elements, `0` represents integer tensor, `1`
// represents float tensor. The second dimension of `output_shape` gives length of
// each tuple element.
func ComputeDedupDataTupleMaskV2(scope *Scope, config string, embedding_partitions string, hbm_buffers_config string, tpu_topology string) (output_shape tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"config": config, "embedding_partitions": embedding_partitions, "hbm_buffers_config": hbm_buffers_config, "tpu_topology": tpu_topology}
	opspec := tf.OpSpec{
		Type: "ComputeDedupDataTupleMaskV2",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Concatenates tensors along one dimension.
//
// Arguments:
//
//	concat_dim: 0-D.  The dimension along which to concatenate.  Must be in the
//
// range [0, rank(values)).
//
//	values: The `N` Tensors to concatenate. Their ranks and types must match,
//
// and their sizes must match in all dimensions except `concat_dim`.
//
// Returns A `Tensor` with the concatenation of values stacked along the
// `concat_dim` dimension.  This tensor's shape matches that of `values` except
// in `concat_dim` where it has the sum of the sizes.
func Concat(scope *Scope, concat_dim tf.Output, values []tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Concat",
		Input: []tf.Input{
			concat_dim, tf.OutputList(values),
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes offsets of concat inputs within its output.
//
// For example:
//
// >>> x = [2, 2, 7]
// >>> y = [2, 3, 7]
// >>> z = [2, 9, 7]
// >>> offsets = concat_offset(1, [x, y, z])
// >>> [[a.item() for a in list(off.numpy())] for off in offsets]
// [[0, 0, 0], [0, 2, 0], [0, 5, 0]]
//
// This is typically used by gradient computations for a concat operation.
//
// Arguments:
//
//	concat_dim: The dimension along which to concatenate.
//	shape: The `N` int32 or int64 vectors representing shape of tensors being concatenated.
//
// Returns The `N` vectors representing the starting offset
// of input tensors within the concatenated output with type matching `shape`.
func ConcatOffset(scope *Scope, concat_dim tf.Output, shape []tf.Output) (offset []tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ConcatOffset",
		Input: []tf.Input{
			concat_dim, tf.OutputList(shape),
		},
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if offset, idx, err = makeOutputList(op, idx, "offset"); err != nil {
		scope.UpdateErr("ConcatOffset", err)
		return
	}
	return offset
}

// Concatenates tensors along one dimension.
//
// Arguments:
//
//	values: List of `N` Tensors to concatenate. Their ranks and types must match,
//
// and their sizes must match in all dimensions except `concat_dim`.
//
//	axis: 0-D.  The dimension along which to concatenate.  Must be in the
//
// range [-rank(values), rank(values)).
//
// Returns A `Tensor` with the concatenation of values stacked along the
// `concat_dim` dimension.  This tensor's shape matches that of `values` except
// in `concat_dim` where it has the sum of the sizes.
func ConcatV2(scope *Scope, values []tf.Output, axis tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ConcatV2",
		Input: []tf.Input{
			tf.OutputList(values), axis,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ConcatenateDatasetAttr is an optional argument to ConcatenateDataset.
type ConcatenateDatasetAttr func(optionalAttr)

// ConcatenateDatasetMetadata sets the optional metadata attribute to value.
// If not specified, defaults to ""
func ConcatenateDatasetMetadata(value string) ConcatenateDatasetAttr {
	return func(m optionalAttr) {
		m["metadata"] = value
	}
}

// Creates a dataset that concatenates `input_dataset` with `another_dataset`.
func ConcatenateDataset(scope *Scope, input_dataset tf.Output, another_dataset tf.Output, output_types []tf.DataType, output_shapes []tf.Shape, optional ...ConcatenateDatasetAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ConcatenateDataset",
		Input: []tf.Input{
			input_dataset, another_dataset,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ConfigureAndInitializeGlobalTPUAttr is an optional argument to ConfigureAndInitializeGlobalTPU.
type ConfigureAndInitializeGlobalTPUAttr func(optionalAttr)

// ConfigureAndInitializeGlobalTPUUseTfrtHostRuntime sets the optional use_tfrt_host_runtime attribute to value.
// If not specified, defaults to true
func ConfigureAndInitializeGlobalTPUUseTfrtHostRuntime(value bool) ConfigureAndInitializeGlobalTPUAttr {
	return func(m optionalAttr) {
		m["use_tfrt_host_runtime"] = value
	}
}

// An op that sets up the centralized structures for a distributed TPU system.
//
// Returns A vector containing the global TPU id of each TPU on the host.
func ConfigureAndInitializeGlobalTPU(scope *Scope, optional ...ConfigureAndInitializeGlobalTPUAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ConfigureAndInitializeGlobalTPU",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ConfigureDistributedTPUAttr is an optional argument to ConfigureDistributedTPU.
type ConfigureDistributedTPUAttr func(optionalAttr)

// ConfigureDistributedTPUEmbeddingConfig sets the optional embedding_config attribute to value.
//
// value: Reserved. Do not use.
// If not specified, defaults to ""
func ConfigureDistributedTPUEmbeddingConfig(value string) ConfigureDistributedTPUAttr {
	return func(m optionalAttr) {
		m["embedding_config"] = value
	}
}

// ConfigureDistributedTPUTpuEmbeddingConfig sets the optional tpu_embedding_config attribute to value.
//
// value: Serialized tensorflow.tpu.TPUEmbeddingConfiguration that
// describes the embedding lookups of the program.
// If not specified, defaults to ""
func ConfigureDistributedTPUTpuEmbeddingConfig(value string) ConfigureDistributedTPUAttr {
	return func(m optionalAttr) {
		m["tpu_embedding_config"] = value
	}
}

// ConfigureDistributedTPUIsGlobalInit sets the optional is_global_init attribute to value.
//
// value: Reserved. Do not use.
// If not specified, defaults to false
func ConfigureDistributedTPUIsGlobalInit(value bool) ConfigureDistributedTPUAttr {
	return func(m optionalAttr) {
		m["is_global_init"] = value
	}
}

// ConfigureDistributedTPUEnableWholeMeshCompilations sets the optional enable_whole_mesh_compilations attribute to value.
// If not specified, defaults to false
func ConfigureDistributedTPUEnableWholeMeshCompilations(value bool) ConfigureDistributedTPUAttr {
	return func(m optionalAttr) {
		m["enable_whole_mesh_compilations"] = value
	}
}

// ConfigureDistributedTPUCompilationFailureClosesChips sets the optional compilation_failure_closes_chips attribute to value.
// If not specified, defaults to true
func ConfigureDistributedTPUCompilationFailureClosesChips(value bool) ConfigureDistributedTPUAttr {
	return func(m optionalAttr) {
		m["compilation_failure_closes_chips"] = value
	}
}

// ConfigureDistributedTPUTpuCancellationClosesChips sets the optional tpu_cancellation_closes_chips attribute to value.
// If not specified, defaults to 0
func ConfigureDistributedTPUTpuCancellationClosesChips(value int64) ConfigureDistributedTPUAttr {
	return func(m optionalAttr) {
		m["tpu_cancellation_closes_chips"] = value
	}
}

// Sets up the centralized structures for a distributed TPU system.
//
// Returns A serialized tensorflow.tpu.TopologyProto that describes the TPU
// topology.
func ConfigureDistributedTPU(scope *Scope, optional ...ConfigureDistributedTPUAttr) (topology tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ConfigureDistributedTPU",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Sets up TPUEmbedding in a distributed TPU system.
//
// Arguments:
//
//	config: Serialized tensorflow.tpu.TPUEmbeddingConfiguration that
//
// describes the embedding lookups of the program.
//
// Returns the created operation.
func ConfigureTPUEmbedding(scope *Scope, config string) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"config": config}
	opspec := tf.OpSpec{
		Type: "ConfigureTPUEmbedding",

		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// An op that configures the TPUEmbedding software on a host.
//
// Arguments:
//
//	common_config: A string-encoded common configuration proto containing metadata
//
// about the TPUEmbedding partitioner output.
//
//	memory_config: A string-encoded memory config proto containing metadata about
//
// the memory allocations reserved for TPUEmbedding.
//
//	config: An TPUEmbeddingConfiguration proto serialized to a string,
//
// describing the desired TPUEmbedding configuration.
//
// Returns A string containing metadata about the hostname and RPC port
// used for communication with this host.
func ConfigureTPUEmbeddingHost(scope *Scope, common_config tf.Output, memory_config tf.Output, config string) (network_config tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"config": config}
	opspec := tf.OpSpec{
		Type: "ConfigureTPUEmbeddingHost",
		Input: []tf.Input{
			common_config, memory_config,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// An op that configures the TPUEmbedding software on a host.
//
// Arguments:
//
//	common_config: A string-encoded CommonConfiguration proto containing metadata
//
// about the TPUEmbedding partitioner output and the HBM size (in bytes) required
// for operation.
//
// Returns A string-encoded memory configuration containing metadata about
// the memory allocations reserved for TPUEmbedding.
func ConfigureTPUEmbeddingMemory(scope *Scope, common_config tf.Output) (memory_config tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ConfigureTPUEmbeddingMemory",
		Input: []tf.Input{
			common_config,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the complex conjugate of a complex number.
//
// Given a tensor `input` of complex numbers, this operation returns a tensor of
// complex numbers that are the complex conjugate of each element in `input`. The
// complex numbers in `input` must be of the form \\(a + bj\\), where *a* is the
// real part and *b* is the imaginary part.
//
// The complex conjugate returned by this operation is of the form \\(a - bj\\).
//
// For example:
//
// ```
// # tensor 'input' is [-2.25 + 4.75j, 3.25 + 5.75j]
// tf.conj(input) ==> [-2.25 - 4.75j, 3.25 - 5.75j]
// ```
func Conj(scope *Scope, input tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Conj",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Shuffle dimensions of x according to a permutation and conjugate the result.
//
// The output `y` has the same rank as `x`. The shapes of `x` and `y` satisfy:
//
//	`y.shape[i] == x.shape[perm[i]] for i in [0, 1, ..., rank(x) - 1]`
//	`y[i,j,k,...,s,t,u] == conj(x[perm[i], perm[j], perm[k],...,perm[s], perm[t], perm[u]])`
func ConjugateTranspose(scope *Scope, x tf.Output, perm tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ConjugateTranspose",
		Input: []tf.Input{
			x, perm,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// An op that sets up communication between TPUEmbedding host software instances
//
// after ConfigureTPUEmbeddingHost has been called on each host.
//
// Arguments:
//
//	network_configs: Strings containing metadata about the hostname and RPC port
//
// used for communication with all hosts.
//
// Returns the created operation.
func ConnectTPUEmbeddingHosts(scope *Scope, network_configs []tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ConnectTPUEmbeddingHosts",
		Input: []tf.Input{
			tf.OutputList(network_configs),
		},
	}
	return scope.AddOperation(opspec)
}

// This op consumes a lock created by `MutexLock`.
//
// This op exists to consume a tensor created by `MutexLock` (other than
// direct control dependencies).  It should be the only that consumes the tensor,
// and will raise an error if it is not.  Its only purpose is to keep the
// mutex lock tensor alive until it is consumed by this op.
//
// **NOTE**: This operation must run on the same device as its input.  This may
// be enforced via the `colocate_with` mechanism.
//
// Arguments:
//
//	mutex_lock: A tensor returned by `MutexLock`.
//
// Returns the created operation.
func ConsumeMutexLock(scope *Scope, mutex_lock tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ConsumeMutexLock",
		Input: []tf.Input{
			mutex_lock,
		},
	}
	return scope.AddOperation(opspec)
}

// Does nothing. Serves as a control trigger for scheduling.
//
// Only useful as a placeholder for control edges.
//
// Returns the created operation.
func ControlTrigger(scope *Scope) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ControlTrigger",
	}
	return scope.AddOperation(opspec)
}

// ConvAttr is an optional argument to Conv.
type ConvAttr func(optionalAttr)

// ConvExplicitPaddings sets the optional explicit_paddings attribute to value.
//
// value: If `padding` is `"EXPLICIT"`, the list of explicit padding amounts. For the ith
// dimension, the amount of padding inserted before and after the dimension is
// `explicit_paddings[2 * i]` and `explicit_paddings[2 * i + 1]`, respectively. If
// `padding` is not `"EXPLICIT"`, `explicit_paddings` must be empty.
// If not specified, defaults to {}
func ConvExplicitPaddings(value []int64) ConvAttr {
	return func(m optionalAttr) {
		m["explicit_paddings"] = value
	}
}

// ConvDataFormat sets the optional data_format attribute to value.
//
// value: Used to set the data format. By default `CHANNELS_FIRST`, uses
// `NHWC (2D) / NDHWC (3D)` or if `CHANNELS_LAST`, uses `NCHW (2D) / NCDHW (3D)`.
// If not specified, defaults to "CHANNELS_LAST"
func ConvDataFormat(value string) ConvAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// ConvDilations sets the optional dilations attribute to value.
//
// value: 1-D tensor of length `N+2`. The dilation factor for each dimension of
// `input`. If set to `k > 1`, there will be `k-1` skipped cells between each
// filter element on that dimension. The dimension order is determined by the
// value of `channels_last_format`, see above for details. Dilations in the batch
// and depth dimensions must be 1.
// If not specified, defaults to {}
func ConvDilations(value []int64) ConvAttr {
	return func(m optionalAttr) {
		m["dilations"] = value
	}
}

// ConvBatchDims sets the optional batch_dims attribute to value.
//
// value: A positive integer specifying the number of batch dimensions for the input
// tensor. Should be less than the rank of the input tensor.
// If not specified, defaults to 1
func ConvBatchDims(value int64) ConvAttr {
	return func(m optionalAttr) {
		m["batch_dims"] = value
	}
}

// ConvGroups sets the optional groups attribute to value.
//
// value: A positive integer specifying the number of groups in which the input is split
// along the channel axis. Each group is convolved separately with
// `filters / groups` filters. The output is the concatenation of all the groups
// results along the channel axis. Input channels and filters must both be
// divisible by groups.
// If not specified, defaults to 1
func ConvGroups(value int64) ConvAttr {
	return func(m optionalAttr) {
		m["groups"] = value
	}
}

// Computes a N-D convolution given (N+1+batch_dims)-D `input` and (N+2)-D `filter` tensors.
//
// General function for computing a N-D convolution. It is required that
// `1 <= N <= 3`.
//
// Arguments:
//
//	input: Tensor of type T and shape `batch_shape + spatial_shape + [in_channels]` in the
//
// case that `channels_last_format = true` or shape
// `batch_shape + [in_channels] + spatial_shape` if `channels_last_format = false`.
// spatial_shape is N-dimensional with `N=2` or `N=3`.
// Also note that `batch_shape` is dictated by the parameter `batch_dims`
// and defaults to 1.
//
//	filter: An `(N+2)-D` Tensor with the same type as `input` and shape
//
// `spatial_filter_shape + [in_channels, out_channels]`, where spatial_filter_shape
// is N-dimensional with `N=2` or `N=3`.
//
//	strides: 1-D tensor of length `N+2`. The stride of the sliding window for each
//
// dimension of `input`. Must have `strides[0] = strides[N+1] = 1`.
//
//	padding: The type of padding algorithm to use.
//
// Returns A (N+1+batch_dims)-D tensor. The dimension order is determined by the value of
// `channels_last_format`, see below for details.
func Conv(scope *Scope, input tf.Output, filter tf.Output, strides []int64, padding string, optional ...ConvAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Conv",
		Input: []tf.Input{
			input, filter,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Conv2DAttr is an optional argument to Conv2D.
type Conv2DAttr func(optionalAttr)

// Conv2DUseCudnnOnGpu sets the optional use_cudnn_on_gpu attribute to value.
// If not specified, defaults to true
func Conv2DUseCudnnOnGpu(value bool) Conv2DAttr {
	return func(m optionalAttr) {
		m["use_cudnn_on_gpu"] = value
	}
}

// Conv2DExplicitPaddings sets the optional explicit_paddings attribute to value.
//
// value: If `padding` is `"EXPLICIT"`, the list of explicit padding amounts. For the ith
// dimension, the amount of padding inserted before and after the dimension is
// `explicit_paddings[2 * i]` and `explicit_paddings[2 * i + 1]`, respectively. If
// `padding` is not `"EXPLICIT"`, `explicit_paddings` must be empty.
// If not specified, defaults to {}
func Conv2DExplicitPaddings(value []int64) Conv2DAttr {
	return func(m optionalAttr) {
		m["explicit_paddings"] = value
	}
}

// Conv2DDataFormat sets the optional data_format attribute to value.
//
// value: Specify the data format of the input and output data. With the
// default format "NHWC", the data is stored in the order of:
//
//	[batch, height, width, channels].
//
// Alternatively, the format could be "NCHW", the data storage order of:
//
//	[batch, channels, height, width].
//
// If not specified, defaults to "NHWC"
func Conv2DDataFormat(value string) Conv2DAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Conv2DDilations sets the optional dilations attribute to value.
//
// value: 1-D tensor of length 4.  The dilation factor for each dimension of
// `input`. If set to k > 1, there will be k-1 skipped cells between each
// filter element on that dimension. The dimension order is determined by the
// value of `data_format`, see above for details. Dilations in the batch and
// depth dimensions must be 1.
// If not specified, defaults to {i:1 i:1 i:1 i:1}
func Conv2DDilations(value []int64) Conv2DAttr {
	return func(m optionalAttr) {
		m["dilations"] = value
	}
}

// Computes a 2-D convolution given 4-D `input` and `filter` tensors.
//
// Given an input tensor of shape `[batch, in_height, in_width, in_channels]`
// and a filter / kernel tensor of shape
// `[filter_height, filter_width, in_channels, out_channels]`, this op
// performs the following:
//
//  1. Flattens the filter to a 2-D matrix with shape
//     `[filter_height * filter_width * in_channels, output_channels]`.
//  2. Extracts image patches from the input tensor to form a *virtual*
//     tensor of shape `[batch, out_height, out_width,
//     filter_height * filter_width * in_channels]`.
//  3. For each patch, right-multiplies the filter matrix and the image patch
//     vector.
//
// In detail, with the default NHWC format,
//
//	output[b, i, j, k] =
//	    sum_{di, dj, q} input[b, strides[1] * i + di, strides[2] * j + dj, q] *
//	                    filter[di, dj, q, k]
//
// Must have `strides[0] = strides[3] = 1`.  For the most common case of the same
// horizontal and vertices strides, `strides = [1, stride, stride, 1]`.
//
// Arguments:
//
//	input: A 4-D tensor. The dimension order is interpreted according to the value
//
// of `data_format`, see below for details.
//
//	filter: A 4-D tensor of shape
//
// `[filter_height, filter_width, in_channels, out_channels]`
//
//	strides: 1-D tensor of length 4.  The stride of the sliding window for each
//
// dimension of `input`. The dimension order is determined by the value of
// `data_format`, see below for details.
//
//	padding: The type of padding algorithm to use.
//
// Returns A 4-D tensor. The dimension order is determined by the value of
// `data_format`, see below for details.
func Conv2D(scope *Scope, input tf.Output, filter tf.Output, strides []int64, padding string, optional ...Conv2DAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Conv2D",
		Input: []tf.Input{
			input, filter,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Conv2DBackpropFilterAttr is an optional argument to Conv2DBackpropFilter.
type Conv2DBackpropFilterAttr func(optionalAttr)

// Conv2DBackpropFilterUseCudnnOnGpu sets the optional use_cudnn_on_gpu attribute to value.
// If not specified, defaults to true
func Conv2DBackpropFilterUseCudnnOnGpu(value bool) Conv2DBackpropFilterAttr {
	return func(m optionalAttr) {
		m["use_cudnn_on_gpu"] = value
	}
}

// Conv2DBackpropFilterExplicitPaddings sets the optional explicit_paddings attribute to value.
//
// value: If `padding` is `"EXPLICIT"`, the list of explicit padding amounts. For the ith
// dimension, the amount of padding inserted before and after the dimension is
// `explicit_paddings[2 * i]` and `explicit_paddings[2 * i + 1]`, respectively. If
// `padding` is not `"EXPLICIT"`, `explicit_paddings` must be empty.
// If not specified, defaults to {}
func Conv2DBackpropFilterExplicitPaddings(value []int64) Conv2DBackpropFilterAttr {
	return func(m optionalAttr) {
		m["explicit_paddings"] = value
	}
}

// Conv2DBackpropFilterDataFormat sets the optional data_format attribute to value.
//
// value: Specify the data format of the input and output data. With the
// default format "NHWC", the data is stored in the order of:
//
//	[batch, in_height, in_width, in_channels].
//
// Alternatively, the format could be "NCHW", the data storage order of:
//
//	[batch, in_channels, in_height, in_width].
//
// If not specified, defaults to "NHWC"
func Conv2DBackpropFilterDataFormat(value string) Conv2DBackpropFilterAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Conv2DBackpropFilterDilations sets the optional dilations attribute to value.
//
// value: 1-D tensor of length 4.  The dilation factor for each dimension of
// `input`. If set to k > 1, there will be k-1 skipped cells between each filter
// element on that dimension. The dimension order is determined by the value of
// `data_format`, see above for details. Dilations in the batch and depth
// dimensions must be 1.
// If not specified, defaults to {i:1 i:1 i:1 i:1}
func Conv2DBackpropFilterDilations(value []int64) Conv2DBackpropFilterAttr {
	return func(m optionalAttr) {
		m["dilations"] = value
	}
}

// Computes the gradients of convolution with respect to the filter.
//
// Arguments:
//
//	input: 4-D with shape `[batch, in_height, in_width, in_channels]`.
//	filter_sizes: An integer vector representing the tensor shape of `filter`,
//
// where `filter` is a 4-D
// `[filter_height, filter_width, in_channels, out_channels]` tensor.
//
//	out_backprop: 4-D with shape `[batch, out_height, out_width, out_channels]`.
//
// Gradients w.r.t. the output of the convolution.
//
//	strides: The stride of the sliding window for each dimension of the input
//
// of the convolution. Must be in the same order as the dimension specified with
// format.
//
//	padding: The type of padding algorithm to use.
//
// Returns 4-D with shape
// `[filter_height, filter_width, in_channels, out_channels]`.  Gradient w.r.t.
// the `filter` input of the convolution.
func Conv2DBackpropFilter(scope *Scope, input tf.Output, filter_sizes tf.Output, out_backprop tf.Output, strides []int64, padding string, optional ...Conv2DBackpropFilterAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Conv2DBackpropFilter",
		Input: []tf.Input{
			input, filter_sizes, out_backprop,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Conv2DBackpropFilterV2Attr is an optional argument to Conv2DBackpropFilterV2.
type Conv2DBackpropFilterV2Attr func(optionalAttr)

// Conv2DBackpropFilterV2UseCudnnOnGpu sets the optional use_cudnn_on_gpu attribute to value.
// If not specified, defaults to true
func Conv2DBackpropFilterV2UseCudnnOnGpu(value bool) Conv2DBackpropFilterV2Attr {
	return func(m optionalAttr) {
		m["use_cudnn_on_gpu"] = value
	}
}

// Conv2DBackpropFilterV2ExplicitPaddings sets the optional explicit_paddings attribute to value.
//
// value: If `padding` is `"EXPLICIT"`, the list of explicit padding amounts. For the ith
// dimension, the amount of padding inserted before and after the dimension is
// `explicit_paddings[2 * i]` and `explicit_paddings[2 * i + 1]`, respectively. If
// `padding` is not `"EXPLICIT"`, `explicit_paddings` must be empty.
// If not specified, defaults to {}
func Conv2DBackpropFilterV2ExplicitPaddings(value []int64) Conv2DBackpropFilterV2Attr {
	return func(m optionalAttr) {
		m["explicit_paddings"] = value
	}
}

// Conv2DBackpropFilterV2DataFormat sets the optional data_format attribute to value.
//
// value: Specify the data format of the input and output data. With the
// default format "NHWC", the data is stored in the order of:
//
//	[batch, in_height, in_width, in_channels].
//
// Alternatively, the format could be "NCHW", the data storage order of:
//
//	[batch, in_channels, in_height, in_width].
//
// If not specified, defaults to "NHWC"
func Conv2DBackpropFilterV2DataFormat(value string) Conv2DBackpropFilterV2Attr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Conv2DBackpropFilterV2Dilations sets the optional dilations attribute to value.
//
// value: 1-D tensor of length 4.  The dilation factor for each dimension of
// `input`. If set to k > 1, there will be k-1 skipped cells between each filter
// element on that dimension. The dimension order is determined by the value of
// `data_format`, see above for details. Dilations in the batch and depth
// dimensions must be 1.
// If not specified, defaults to {i:1 i:1 i:1 i:1}
func Conv2DBackpropFilterV2Dilations(value []int64) Conv2DBackpropFilterV2Attr {
	return func(m optionalAttr) {
		m["dilations"] = value
	}
}

// Computes the gradients of convolution with respect to the filter.
//
// Arguments:
//
//	input: 4-D with shape `[batch, in_height, in_width, in_channels]`.
//	filter: 4-D with shape `[filter_height, filter_width, in_channels, out_channels]`.
//
// Only shape of tensor is used.
//
//	out_backprop: 4-D with shape `[batch, out_height, out_width, out_channels]`.
//
// Gradients w.r.t. the output of the convolution.
//
//	strides: The stride of the sliding window for each dimension of the input
//
// of the convolution. Must be in the same order as the dimension specified with
// format.
//
//	padding: The type of padding algorithm to use.
//
// Returns 4-D with shape
// `[filter_height, filter_width, in_channels, out_channels]`.  Gradient w.r.t.
// the `filter` input of the convolution.
func Conv2DBackpropFilterV2(scope *Scope, input tf.Output, filter tf.Output, out_backprop tf.Output, strides []int64, padding string, optional ...Conv2DBackpropFilterV2Attr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Conv2DBackpropFilterV2",
		Input: []tf.Input{
			input, filter, out_backprop,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Conv2DBackpropInputAttr is an optional argument to Conv2DBackpropInput.
type Conv2DBackpropInputAttr func(optionalAttr)

// Conv2DBackpropInputUseCudnnOnGpu sets the optional use_cudnn_on_gpu attribute to value.
// If not specified, defaults to true
func Conv2DBackpropInputUseCudnnOnGpu(value bool) Conv2DBackpropInputAttr {
	return func(m optionalAttr) {
		m["use_cudnn_on_gpu"] = value
	}
}

// Conv2DBackpropInputExplicitPaddings sets the optional explicit_paddings attribute to value.
//
// value: If `padding` is `"EXPLICIT"`, the list of explicit padding amounts. For the ith
// dimension, the amount of padding inserted before and after the dimension is
// `explicit_paddings[2 * i]` and `explicit_paddings[2 * i + 1]`, respectively. If
// `padding` is not `"EXPLICIT"`, `explicit_paddings` must be empty.
// If not specified, defaults to {}
func Conv2DBackpropInputExplicitPaddings(value []int64) Conv2DBackpropInputAttr {
	return func(m optionalAttr) {
		m["explicit_paddings"] = value
	}
}

// Conv2DBackpropInputDataFormat sets the optional data_format attribute to value.
//
// value: Specify the data format of the input and output data. With the
// default format "NHWC", the data is stored in the order of:
//
//	[batch, in_height, in_width, in_channels].
//
// Alternatively, the format could be "NCHW", the data storage order of:
//
//	[batch, in_channels, in_height, in_width].
//
// If not specified, defaults to "NHWC"
func Conv2DBackpropInputDataFormat(value string) Conv2DBackpropInputAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Conv2DBackpropInputDilations sets the optional dilations attribute to value.
//
// value: 1-D tensor of length 4.  The dilation factor for each dimension of
// `input`. If set to k > 1, there will be k-1 skipped cells between each filter
// element on that dimension. The dimension order is determined by the value of
// `data_format`, see above for details. Dilations in the batch and depth
// dimensions must be 1.
// If not specified, defaults to {i:1 i:1 i:1 i:1}
func Conv2DBackpropInputDilations(value []int64) Conv2DBackpropInputAttr {
	return func(m optionalAttr) {
		m["dilations"] = value
	}
}

// Computes the gradients of convolution with respect to the input.
//
// Arguments:
//
//	input_sizes: An integer vector representing the shape of `input`,
//
// where `input` is a 4-D `[batch, height, width, channels]` tensor.
//
//	filter: 4-D with shape
//
// `[filter_height, filter_width, in_channels, out_channels]`.
//
//	out_backprop: 4-D with shape `[batch, out_height, out_width, out_channels]`.
//
// Gradients w.r.t. the output of the convolution.
//
//	strides: The stride of the sliding window for each dimension of the input
//
// of the convolution. Must be in the same order as the dimension specified with
// format.
//
//	padding: The type of padding algorithm to use.
//
// Returns 4-D with shape `[batch, in_height, in_width, in_channels]`.  Gradient
// w.r.t. the input of the convolution.
func Conv2DBackpropInput(scope *Scope, input_sizes tf.Output, filter tf.Output, out_backprop tf.Output, strides []int64, padding string, optional ...Conv2DBackpropInputAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Conv2DBackpropInput",
		Input: []tf.Input{
			input_sizes, filter, out_backprop,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Conv2DBackpropInputV2Attr is an optional argument to Conv2DBackpropInputV2.
type Conv2DBackpropInputV2Attr func(optionalAttr)

// Conv2DBackpropInputV2UseCudnnOnGpu sets the optional use_cudnn_on_gpu attribute to value.
// If not specified, defaults to true
func Conv2DBackpropInputV2UseCudnnOnGpu(value bool) Conv2DBackpropInputV2Attr {
	return func(m optionalAttr) {
		m["use_cudnn_on_gpu"] = value
	}
}

// Conv2DBackpropInputV2ExplicitPaddings sets the optional explicit_paddings attribute to value.
//
// value: If `padding` is `"EXPLICIT"`, the list of explicit padding amounts. For the ith
// dimension, the amount of padding inserted before and after the dimension is
// `explicit_paddings[2 * i]` and `explicit_paddings[2 * i + 1]`, respectively. If
// `padding` is not `"EXPLICIT"`, `explicit_paddings` must be empty.
// If not specified, defaults to {}
func Conv2DBackpropInputV2ExplicitPaddings(value []int64) Conv2DBackpropInputV2Attr {
	return func(m optionalAttr) {
		m["explicit_paddings"] = value
	}
}

// Conv2DBackpropInputV2DataFormat sets the optional data_format attribute to value.
//
// value: Specify the data format of the input and output data. With the
// default format "NHWC", the data is stored in the order of:
//
//	[batch, in_height, in_width, in_channels].
//
// Alternatively, the format could be "NCHW", the data storage order of:
//
//	[batch, in_channels, in_height, in_width].
//
// If not specified, defaults to "NHWC"
func Conv2DBackpropInputV2DataFormat(value string) Conv2DBackpropInputV2Attr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Conv2DBackpropInputV2Dilations sets the optional dilations attribute to value.
//
// value: 1-D tensor of length 4.  The dilation factor for each dimension of
// `input`. If set to k > 1, there will be k-1 skipped cells between each filter
// element on that dimension. The dimension order is determined by the value of
// `data_format`, see above for details. Dilations in the batch and depth
// dimensions must be 1.
// If not specified, defaults to {i:1 i:1 i:1 i:1}
func Conv2DBackpropInputV2Dilations(value []int64) Conv2DBackpropInputV2Attr {
	return func(m optionalAttr) {
		m["dilations"] = value
	}
}

// Computes the gradients of convolution with respect to the input.
//
// Arguments:
//
//	input: 4-D with shape `[batch, in_height, in_width, in_channels]`.
//
// Only shape of tensor is used.
//
//	filter: 4-D with shape
//
// `[filter_height, filter_width, in_channels, out_channels]`.
//
//	out_backprop: 4-D with shape `[batch, out_height, out_width, out_channels]`.
//
// Gradients w.r.t. the output of the convolution.
//
//	strides: The stride of the sliding window for each dimension of the input
//
// of the convolution. Must be in the same order as the dimension specified with
// format.
//
//	padding: The type of padding algorithm to use.
//
// Returns 4-D with shape `[batch, in_height, in_width, in_channels]`.  Gradient
// w.r.t. the input of the convolution.
func Conv2DBackpropInputV2(scope *Scope, input tf.Output, filter tf.Output, out_backprop tf.Output, strides []int64, padding string, optional ...Conv2DBackpropInputV2Attr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Conv2DBackpropInputV2",
		Input: []tf.Input{
			input, filter, out_backprop,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Conv3DAttr is an optional argument to Conv3D.
type Conv3DAttr func(optionalAttr)

// Conv3DDataFormat sets the optional data_format attribute to value.
//
// value: The data format of the input and output data. With the
// default format "NDHWC", the data is stored in the order of:
//
//	[batch, in_depth, in_height, in_width, in_channels].
//
// Alternatively, the format could be "NCDHW", the data storage order is:
//
//	[batch, in_channels, in_depth, in_height, in_width].
//
// If not specified, defaults to "NDHWC"
func Conv3DDataFormat(value string) Conv3DAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Conv3DDilations sets the optional dilations attribute to value.
//
// value: 1-D tensor of length 5.  The dilation factor for each dimension of
// `input`. If set to k > 1, there will be k-1 skipped cells between each
// filter element on that dimension. The dimension order is determined by the
// value of `data_format`, see above for details. Dilations in the batch and
// depth dimensions must be 1.
// If not specified, defaults to {i:1 i:1 i:1 i:1 i:1}
func Conv3DDilations(value []int64) Conv3DAttr {
	return func(m optionalAttr) {
		m["dilations"] = value
	}
}

// Computes a 3-D convolution given 5-D `input` and `filter` tensors.
//
// In signal processing, cross-correlation is a measure of similarity of
// two waveforms as a function of a time-lag applied to one of them. This
// is also known as a sliding dot product or sliding inner-product.
//
// Our Conv3D implements a form of cross-correlation.
//
// Arguments:
//
//	input: Shape `[batch, in_depth, in_height, in_width, in_channels]`.
//	filter: Shape `[filter_depth, filter_height, filter_width, in_channels,
//
// out_channels]`. `in_channels` must match between `input` and `filter`.
//
//	strides: 1-D tensor of length 5. The stride of the sliding window for each
//
// dimension of `input`. Must have `strides[0] = strides[4] = 1`.
//
//	padding: The type of padding algorithm to use.
func Conv3D(scope *Scope, input tf.Output, filter tf.Output, strides []int64, padding string, optional ...Conv3DAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Conv3D",
		Input: []tf.Input{
			input, filter,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Conv3DBackpropFilterAttr is an optional argument to Conv3DBackpropFilter.
type Conv3DBackpropFilterAttr func(optionalAttr)

// Conv3DBackpropFilterDilations sets the optional dilations attribute to value.
// If not specified, defaults to {i:1 i:1 i:1 i:1 i:1}
func Conv3DBackpropFilterDilations(value []int64) Conv3DBackpropFilterAttr {
	return func(m optionalAttr) {
		m["dilations"] = value
	}
}

// Computes the gradients of 3-D convolution with respect to the filter.
//
// DEPRECATED at GraphDef version 10: Use Conv3DBackpropFilterV2
//
// Arguments:
//
//	input: Shape `[batch, depth, rows, cols, in_channels]`.
//	filter: Shape `[depth, rows, cols, in_channels, out_channels]`.
//
// `in_channels` must match between `input` and `filter`.
//
//	out_backprop: Backprop signal of shape `[batch, out_depth, out_rows, out_cols,
//
// out_channels]`.
//
//	strides: 1-D tensor of length 5. The stride of the sliding window for each
//
// dimension of `input`. Must have `strides[0] = strides[4] = 1`.
//
//	padding: The type of padding algorithm to use.
func Conv3DBackpropFilter(scope *Scope, input tf.Output, filter tf.Output, out_backprop tf.Output, strides []int64, padding string, optional ...Conv3DBackpropFilterAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Conv3DBackpropFilter",
		Input: []tf.Input{
			input, filter, out_backprop,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Conv3DBackpropFilterV2Attr is an optional argument to Conv3DBackpropFilterV2.
type Conv3DBackpropFilterV2Attr func(optionalAttr)

// Conv3DBackpropFilterV2DataFormat sets the optional data_format attribute to value.
//
// value: The data format of the input and output data. With the
// default format "NDHWC", the data is stored in the order of:
//
//	[batch, in_depth, in_height, in_width, in_channels].
//
// Alternatively, the format could be "NCDHW", the data storage order is:
//
//	[batch, in_channels, in_depth, in_height, in_width].
//
// If not specified, defaults to "NDHWC"
func Conv3DBackpropFilterV2DataFormat(value string) Conv3DBackpropFilterV2Attr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Conv3DBackpropFilterV2Dilations sets the optional dilations attribute to value.
//
// value: 1-D tensor of length 5.  The dilation factor for each dimension of
// `input`. If set to k > 1, there will be k-1 skipped cells between each
// filter element on that dimension. The dimension order is determined by the
// value of `data_format`, see above for details. Dilations in the batch and
// depth dimensions must be 1.
// If not specified, defaults to {i:1 i:1 i:1 i:1 i:1}
func Conv3DBackpropFilterV2Dilations(value []int64) Conv3DBackpropFilterV2Attr {
	return func(m optionalAttr) {
		m["dilations"] = value
	}
}

// Computes the gradients of 3-D convolution with respect to the filter.
//
// Arguments:
//
//	input: Shape `[batch, depth, rows, cols, in_channels]`.
//	filter_sizes: An integer vector representing the tensor shape of `filter`,
//
// where `filter` is a 5-D
// `[filter_depth, filter_height, filter_width, in_channels, out_channels]`
// tensor.
//
//	out_backprop: Backprop signal of shape `[batch, out_depth, out_rows, out_cols,
//
// out_channels]`.
//
//	strides: 1-D tensor of length 5. The stride of the sliding window for each
//
// dimension of `input`. Must have `strides[0] = strides[4] = 1`.
//
//	padding: The type of padding algorithm to use.
func Conv3DBackpropFilterV2(scope *Scope, input tf.Output, filter_sizes tf.Output, out_backprop tf.Output, strides []int64, padding string, optional ...Conv3DBackpropFilterV2Attr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Conv3DBackpropFilterV2",
		Input: []tf.Input{
			input, filter_sizes, out_backprop,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Conv3DBackpropInputAttr is an optional argument to Conv3DBackpropInput.
type Conv3DBackpropInputAttr func(optionalAttr)

// Conv3DBackpropInputDilations sets the optional dilations attribute to value.
// If not specified, defaults to {i:1 i:1 i:1 i:1 i:1}
func Conv3DBackpropInputDilations(value []int64) Conv3DBackpropInputAttr {
	return func(m optionalAttr) {
		m["dilations"] = value
	}
}

// Computes the gradients of 3-D convolution with respect to the input.
//
// DEPRECATED at GraphDef version 10: Use Conv3DBackpropInputV2
//
// Arguments:
//
//	input: Shape `[batch, depth, rows, cols, in_channels]`.
//	filter: Shape `[depth, rows, cols, in_channels, out_channels]`.
//
// `in_channels` must match between `input` and `filter`.
//
//	out_backprop: Backprop signal of shape `[batch, out_depth, out_rows, out_cols,
//
// out_channels]`.
//
//	strides: 1-D tensor of length 5. The stride of the sliding window for each
//
// dimension of `input`. Must have `strides[0] = strides[4] = 1`.
//
//	padding: The type of padding algorithm to use.
func Conv3DBackpropInput(scope *Scope, input tf.Output, filter tf.Output, out_backprop tf.Output, strides []int64, padding string, optional ...Conv3DBackpropInputAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Conv3DBackpropInput",
		Input: []tf.Input{
			input, filter, out_backprop,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Conv3DBackpropInputV2Attr is an optional argument to Conv3DBackpropInputV2.
type Conv3DBackpropInputV2Attr func(optionalAttr)

// Conv3DBackpropInputV2DataFormat sets the optional data_format attribute to value.
//
// value: The data format of the input and output data. With the
// default format "NDHWC", the data is stored in the order of:
//
//	[batch, in_depth, in_height, in_width, in_channels].
//
// Alternatively, the format could be "NCDHW", the data storage order is:
//
//	[batch, in_channels, in_depth, in_height, in_width].
//
// If not specified, defaults to "NDHWC"
func Conv3DBackpropInputV2DataFormat(value string) Conv3DBackpropInputV2Attr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Conv3DBackpropInputV2Dilations sets the optional dilations attribute to value.
//
// value: 1-D tensor of length 5.  The dilation factor for each dimension of
// `input`. If set to k > 1, there will be k-1 skipped cells between each
// filter element on that dimension. The dimension order is determined by the
// value of `data_format`, see above for details. Dilations in the batch and
// depth dimensions must be 1.
// If not specified, defaults to {i:1 i:1 i:1 i:1 i:1}
func Conv3DBackpropInputV2Dilations(value []int64) Conv3DBackpropInputV2Attr {
	return func(m optionalAttr) {
		m["dilations"] = value
	}
}

// Computes the gradients of 3-D convolution with respect to the input.
//
// Arguments:
//
//	input_sizes: An integer vector representing the tensor shape of `input`,
//
// where `input` is a 5-D
// `[batch, depth, rows, cols, in_channels]` tensor.
//
//	filter: Shape `[depth, rows, cols, in_channels, out_channels]`.
//
// `in_channels` must match between `input` and `filter`.
//
//	out_backprop: Backprop signal of shape `[batch, out_depth, out_rows, out_cols,
//
// out_channels]`.
//
//	strides: 1-D tensor of length 5. The stride of the sliding window for each
//
// dimension of `input`. Must have `strides[0] = strides[4] = 1`.
//
//	padding: The type of padding algorithm to use.
func Conv3DBackpropInputV2(scope *Scope, input_sizes tf.Output, filter tf.Output, out_backprop tf.Output, strides []int64, padding string, optional ...Conv3DBackpropInputV2Attr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Conv3DBackpropInputV2",
		Input: []tf.Input{
			input_sizes, filter, out_backprop,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// CopyAttr is an optional argument to Copy.
type CopyAttr func(optionalAttr)

// CopyTensorName sets the optional tensor_name attribute to value.
//
// value: The name of the input tensor.
// If not specified, defaults to ""
func CopyTensorName(value string) CopyAttr {
	return func(m optionalAttr) {
		m["tensor_name"] = value
	}
}

// CopyDebugOpsSpec sets the optional debug_ops_spec attribute to value.
//
// value: A list of debug op spec (op, url, gated_grpc) for attached debug
// ops. Each element of the list has the format
// <debug_op>;<grpc_url>;<gated_grpc>, wherein gated_grpc is boolean represented
// as 0/1. E.g., "DebugIdentity;grpc://foo:3333;1",
// "DebugIdentity;file:///tmp/tfdbg_1;0".
// If not specified, defaults to {}
func CopyDebugOpsSpec(value []string) CopyAttr {
	return func(m optionalAttr) {
		m["debug_ops_spec"] = value
	}
}

// Copy a tensor from CPU-to-CPU or GPU-to-GPU.
//
// Performs CPU-to-CPU or GPU-to-GPU deep-copying of tensor, depending on the
// device on which the tensor is allocated.
// N.B.: If the all downstream attached debug ops are disabled given the current
// gRPC gating status, the output will simply forward the input tensor without
// deep-copying. See the documentation of Debug* ops for more details.
//
// Unlike the CopyHost Op, this op does not have HostMemory constraint on its
// input or output.
//
// Arguments:
//
//	input: Input tensor.
func Copy(scope *Scope, input tf.Output, optional ...CopyAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Copy",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// CopyHostAttr is an optional argument to CopyHost.
type CopyHostAttr func(optionalAttr)

// CopyHostTensorName sets the optional tensor_name attribute to value.
//
// value: The name of the input tensor.
// If not specified, defaults to ""
func CopyHostTensorName(value string) CopyHostAttr {
	return func(m optionalAttr) {
		m["tensor_name"] = value
	}
}

// CopyHostDebugOpsSpec sets the optional debug_ops_spec attribute to value.
//
// value: A list of debug op spec (op, url, gated_grpc) for attached debug
// ops. Each element of the list has the format
// <debug_op>;<grpc_url>;<gated_grpc>, wherein gated_grpc is boolean represented
// as 0/1. E.g., "DebugIdentity;grpc://foo:3333;1",
// "DebugIdentity;file:///tmp/tfdbg_1;0".
// If not specified, defaults to {}
func CopyHostDebugOpsSpec(value []string) CopyHostAttr {
	return func(m optionalAttr) {
		m["debug_ops_spec"] = value
	}
}

// Copy a tensor to host.
//
// Performs CPU-to-CPU deep-copying of tensor.
// N.B.: If the all downstream attached debug ops are disabled given the current
// gRPC gating status, the output will simply forward the input tensor without
// deep-copying. See the documentation of Debug* ops for more details.
//
// Unlike the Copy Op, this op has HostMemory constraint on its input or output.
//
// Arguments:
//
//	input: Input tensor.
func CopyHost(scope *Scope, input tf.Output, optional ...CopyHostAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CopyHost",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes cos of x element-wise.
//
//	Given an input tensor, this function computes cosine of every
//	element in the tensor. Input range is `(-inf, inf)` and
//	output range is `[-1,1]`. If input lies outside the boundary, `nan`
//	is returned.
//
//	```python
//	x = tf.constant([-float("inf"), -9, -0.5, 1, 1.2, 200, 10000, float("inf")])
//	tf.math.cos(x) ==> [nan -0.91113025 0.87758255 0.5403023 0.36235774 0.48718765 -0.95215535 nan]
//	```
func Cos(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Cos",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes hyperbolic cosine of x element-wise.
//
//	Given an input tensor, this function computes hyperbolic cosine of every
//	element in the tensor. Input range is `[-inf, inf]` and output range
//	is `[1, inf]`.
//
//	```python
//	x = tf.constant([-float("inf"), -9, -0.5, 1, 1.2, 2, 10, float("inf")])
//	tf.math.cosh(x) ==> [inf 4.0515420e+03 1.1276259e+00 1.5430807e+00 1.8106556e+00 3.7621956e+00 1.1013233e+04 inf]
//	```
func Cosh(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Cosh",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// CropAndResizeAttr is an optional argument to CropAndResize.
type CropAndResizeAttr func(optionalAttr)

// CropAndResizeMethod sets the optional method attribute to value.
//
// value: A string specifying the sampling method for resizing. It can be either
// `"bilinear"` or `"nearest"` and default to `"bilinear"`. Currently two sampling
// methods are supported: Bilinear and Nearest Neighbor.
// If not specified, defaults to "bilinear"
func CropAndResizeMethod(value string) CropAndResizeAttr {
	return func(m optionalAttr) {
		m["method"] = value
	}
}

// CropAndResizeExtrapolationValue sets the optional extrapolation_value attribute to value.
//
// value: Value used for extrapolation, when applicable.
// If not specified, defaults to 0
func CropAndResizeExtrapolationValue(value float32) CropAndResizeAttr {
	return func(m optionalAttr) {
		m["extrapolation_value"] = value
	}
}

// Extracts crops from the input image tensor and resizes them.
//
// Extracts crops from the input image tensor and resizes them using bilinear
// sampling or nearest neighbor sampling (possibly with aspect ratio change) to a
// common output size specified by `crop_size`. This is more general than the
// `crop_to_bounding_box` op which extracts a fixed size slice from the input image
// and does not allow resizing or aspect ratio change.
//
// Returns a tensor with `crops` from the input `image` at positions defined at the
// bounding box locations in `boxes`. The cropped boxes are all resized (with
// bilinear or nearest neighbor interpolation) to a fixed
// `size = [crop_height, crop_width]`. The result is a 4-D tensor
// `[num_boxes, crop_height, crop_width, depth]`. The resizing is corner aligned.
// In particular, if `boxes = [[0, 0, 1, 1]]`, the method will give identical
// results to using `tf.image.resize_bilinear()` or
// `tf.image.resize_nearest_neighbor()`(depends on the `method` argument) with
// `align_corners=True`.
//
// Arguments:
//
//	image: A 4-D tensor of shape `[batch, image_height, image_width, depth]`.
//
// Both `image_height` and `image_width` need to be positive.
//
//	boxes: A 2-D tensor of shape `[num_boxes, 4]`. The `i`-th row of the tensor
//
// specifies the coordinates of a box in the `box_ind[i]` image and is specified
// in normalized coordinates `[y1, x1, y2, x2]`. A normalized coordinate value of
// `y` is mapped to the image coordinate at `y * (image_height - 1)`, so as the
// `[0, 1]` interval of normalized image height is mapped to
// `[0, image_height - 1]` in image height coordinates. We do allow `y1` > `y2`, in
// which case the sampled crop is an up-down flipped version of the original
// image. The width dimension is treated similarly. Normalized coordinates
// outside the `[0, 1]` range are allowed, in which case we use
// `extrapolation_value` to extrapolate the input image values.
//
//	box_ind: A 1-D tensor of shape `[num_boxes]` with int32 values in `[0, batch)`.
//
// The value of `box_ind[i]` specifies the image that the `i`-th box refers to.
//
//	crop_size: A 1-D tensor of 2 elements, `size = [crop_height, crop_width]`. All
//
// cropped image patches are resized to this size. The aspect ratio of the image
// content is not preserved. Both `crop_height` and `crop_width` need to be
// positive.
//
// Returns A 4-D tensor of shape `[num_boxes, crop_height, crop_width, depth]`.
func CropAndResize(scope *Scope, image tf.Output, boxes tf.Output, box_ind tf.Output, crop_size tf.Output, optional ...CropAndResizeAttr) (crops tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CropAndResize",
		Input: []tf.Input{
			image, boxes, box_ind, crop_size,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// CropAndResizeGradBoxesAttr is an optional argument to CropAndResizeGradBoxes.
type CropAndResizeGradBoxesAttr func(optionalAttr)

// CropAndResizeGradBoxesMethod sets the optional method attribute to value.
//
// value: A string specifying the interpolation method. Only 'bilinear' is
// supported for now.
// If not specified, defaults to "bilinear"
func CropAndResizeGradBoxesMethod(value string) CropAndResizeGradBoxesAttr {
	return func(m optionalAttr) {
		m["method"] = value
	}
}

// Computes the gradient of the crop_and_resize op wrt the input boxes tensor.
//
// Arguments:
//
//	grads: A 4-D tensor of shape `[num_boxes, crop_height, crop_width, depth]`.
//	image: A 4-D tensor of shape `[batch, image_height, image_width, depth]`.
//
// Both `image_height` and `image_width` need to be positive.
//
//	boxes: A 2-D tensor of shape `[num_boxes, 4]`. The `i`-th row of the tensor
//
// specifies the coordinates of a box in the `box_ind[i]` image and is specified
// in normalized coordinates `[y1, x1, y2, x2]`. A normalized coordinate value of
// `y` is mapped to the image coordinate at `y * (image_height - 1)`, so as the
// `[0, 1]` interval of normalized image height is mapped to
// `[0, image_height - 1] in image height coordinates. We do allow y1 > y2, in
// which case the sampled crop is an up-down flipped version of the original
// image. The width dimension is treated similarly. Normalized coordinates
// outside the `[0, 1]` range are allowed, in which case we use
// `extrapolation_value` to extrapolate the input image values.
//
//	box_ind: A 1-D tensor of shape `[num_boxes]` with int32 values in `[0, batch)`.
//
// The value of `box_ind[i]` specifies the image that the `i`-th box refers to.
//
// Returns A 2-D tensor of shape `[num_boxes, 4]`.
func CropAndResizeGradBoxes(scope *Scope, grads tf.Output, image tf.Output, boxes tf.Output, box_ind tf.Output, optional ...CropAndResizeGradBoxesAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CropAndResizeGradBoxes",
		Input: []tf.Input{
			grads, image, boxes, box_ind,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// CropAndResizeGradImageAttr is an optional argument to CropAndResizeGradImage.
type CropAndResizeGradImageAttr func(optionalAttr)

// CropAndResizeGradImageMethod sets the optional method attribute to value.
//
// value: A string specifying the interpolation method. Only 'bilinear' is
// supported for now.
// If not specified, defaults to "bilinear"
func CropAndResizeGradImageMethod(value string) CropAndResizeGradImageAttr {
	return func(m optionalAttr) {
		m["method"] = value
	}
}

// Computes the gradient of the crop_and_resize op wrt the input image tensor.
//
// Arguments:
//
//	grads: A 4-D tensor of shape `[num_boxes, crop_height, crop_width, depth]`.
//	boxes: A 2-D tensor of shape `[num_boxes, 4]`. The `i`-th row of the tensor
//
// specifies the coordinates of a box in the `box_ind[i]` image and is specified
// in normalized coordinates `[y1, x1, y2, x2]`. A normalized coordinate value of
// `y` is mapped to the image coordinate at `y * (image_height - 1)`, so as the
// `[0, 1]` interval of normalized image height is mapped to
// `[0, image_height - 1] in image height coordinates. We do allow y1 > y2, in
// which case the sampled crop is an up-down flipped version of the original
// image. The width dimension is treated similarly. Normalized coordinates
// outside the `[0, 1]` range are allowed, in which case we use
// `extrapolation_value` to extrapolate the input image values.
//
//	box_ind: A 1-D tensor of shape `[num_boxes]` with int32 values in `[0, batch)`.
//
// The value of `box_ind[i]` specifies the image that the `i`-th box refers to.
//
//	image_size: A 1-D tensor with value `[batch, image_height, image_width, depth]`
//
// containing the original image size. Both `image_height` and `image_width` need
// to be positive.
//
// Returns A 4-D tensor of shape `[batch, image_height, image_width, depth]`.
func CropAndResizeGradImage(scope *Scope, grads tf.Output, boxes tf.Output, box_ind tf.Output, image_size tf.Output, T tf.DataType, optional ...CropAndResizeGradImageAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"T": T}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CropAndResizeGradImage",
		Input: []tf.Input{
			grads, boxes, box_ind, image_size,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Compute the pairwise cross product.
//
// `a` and `b` must be the same shape; they can either be simple 3-element vectors,
// or any shape where the innermost dimension is 3. In the latter case, each pair
// of corresponding 3-element vectors is cross-multiplied independently.
//
// Arguments:
//
//	a: A tensor containing 3-element vectors.
//	b: Another tensor, of same type and shape as `a`.
//
// Returns Pairwise cross product of the vectors in `a` and `b`.
func Cross(scope *Scope, a tf.Output, b tf.Output) (product tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Cross",
		Input: []tf.Input{
			a, b,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// An Op to sum inputs across replicated TPU instances.
//
// Each instance supplies its own input.
//
// For example, suppose there are 8 TPU instances: `[A, B, C, D, E, F, G, H]`.
// Passing group_assignment=`[[0,2,4,6],[1,3,5,7]]` sets `A, C, E, G` as group 0,
// and `B, D, F, H` as group 1. Thus we get the outputs:
// `[A+C+E+G, B+D+F+H, A+C+E+G, B+D+F+H, A+C+E+G, B+D+F+H, A+C+E+G, B+D+F+H]`.
//
// Arguments:
//
//	input: The local input to the sum.
//	group_assignment: An int32 tensor with shape
//
// [num_groups, num_replicas_per_group]. `group_assignment[i]` represents the
// replica ids in the ith subgroup.
//
// Returns The sum of all the distributed inputs.
func CrossReplicaSum(scope *Scope, input tf.Output, group_assignment tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "CrossReplicaSum",
		Input: []tf.Input{
			input, group_assignment,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// CudnnRNNAttr is an optional argument to CudnnRNN.
type CudnnRNNAttr func(optionalAttr)

// CudnnRNNRnnMode sets the optional rnn_mode attribute to value.
// If not specified, defaults to "lstm"
func CudnnRNNRnnMode(value string) CudnnRNNAttr {
	return func(m optionalAttr) {
		m["rnn_mode"] = value
	}
}

// CudnnRNNInputMode sets the optional input_mode attribute to value.
// If not specified, defaults to "linear_input"
func CudnnRNNInputMode(value string) CudnnRNNAttr {
	return func(m optionalAttr) {
		m["input_mode"] = value
	}
}

// CudnnRNNDirection sets the optional direction attribute to value.
// If not specified, defaults to "unidirectional"
func CudnnRNNDirection(value string) CudnnRNNAttr {
	return func(m optionalAttr) {
		m["direction"] = value
	}
}

// CudnnRNNDropout sets the optional dropout attribute to value.
// If not specified, defaults to 0
func CudnnRNNDropout(value float32) CudnnRNNAttr {
	return func(m optionalAttr) {
		m["dropout"] = value
	}
}

// CudnnRNNSeed sets the optional seed attribute to value.
// If not specified, defaults to 0
func CudnnRNNSeed(value int64) CudnnRNNAttr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// CudnnRNNSeed2 sets the optional seed2 attribute to value.
// If not specified, defaults to 0
func CudnnRNNSeed2(value int64) CudnnRNNAttr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// CudnnRNNIsTraining sets the optional is_training attribute to value.
// If not specified, defaults to true
func CudnnRNNIsTraining(value bool) CudnnRNNAttr {
	return func(m optionalAttr) {
		m["is_training"] = value
	}
}

// A RNN backed by cuDNN.
//
// Computes the RNN from the input and initial states, with respect to the params
// buffer.
//
// rnn_mode: Indicates the type of the RNN model.
// input_mode: Indicate whether there is a linear projection between the input and
//
//	the actual computation before the first layer. 'skip_input' is only allowed
//	when input_size == num_units; 'auto_select' implies 'skip_input' when
//	input_size == num_units; otherwise, it implies 'linear_input'.
//
// direction: Indicates whether a bidirectional model will be used. Should be
//
//	"unidirectional" or "bidirectional".
//
// dropout: Dropout probability. When set to 0., dropout is disabled.
// seed: The 1st part of a seed to initialize dropout.
// seed2: The 2nd part of a seed to initialize dropout.
// input: A 3-D tensor with the shape of [seq_length, batch_size, input_size].
// input_h: A 3-D tensor with the shape of [num_layer * dir, batch_size,
//
//	num_units].
//
// input_c: For LSTM, a 3-D tensor with the shape of
//
//	[num_layer * dir, batch, num_units]. For other models, it is ignored.
//
// params: A 1-D tensor that contains the weights and biases in an opaque layout.
//
//	The size must be created through CudnnRNNParamsSize, and initialized
//	separately. Note that they might not be compatible across different
//	generations. So it is a good idea to save and restore
//
// output: A 3-D tensor with the shape of [seq_length, batch_size,
//
//	dir * num_units].
//
// output_h: The same shape has input_h.
// output_c: The same shape as input_c for LSTM. An empty tensor for other models.
// is_training: Indicates whether this operation is used for inference or
//
//	training.
//
// reserve_space: An opaque tensor that can be used in backprop calculation. It
//
//	is only produced if is_training is false.
func CudnnRNN(scope *Scope, input tf.Output, input_h tf.Output, input_c tf.Output, params tf.Output, optional ...CudnnRNNAttr) (output tf.Output, output_h tf.Output, output_c tf.Output, reserve_space tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CudnnRNN",
		Input: []tf.Input{
			input, input_h, input_c, params,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3)
}

// CudnnRNNBackpropAttr is an optional argument to CudnnRNNBackprop.
type CudnnRNNBackpropAttr func(optionalAttr)

// CudnnRNNBackpropRnnMode sets the optional rnn_mode attribute to value.
// If not specified, defaults to "lstm"
func CudnnRNNBackpropRnnMode(value string) CudnnRNNBackpropAttr {
	return func(m optionalAttr) {
		m["rnn_mode"] = value
	}
}

// CudnnRNNBackpropInputMode sets the optional input_mode attribute to value.
// If not specified, defaults to "linear_input"
func CudnnRNNBackpropInputMode(value string) CudnnRNNBackpropAttr {
	return func(m optionalAttr) {
		m["input_mode"] = value
	}
}

// CudnnRNNBackpropDirection sets the optional direction attribute to value.
// If not specified, defaults to "unidirectional"
func CudnnRNNBackpropDirection(value string) CudnnRNNBackpropAttr {
	return func(m optionalAttr) {
		m["direction"] = value
	}
}

// CudnnRNNBackpropDropout sets the optional dropout attribute to value.
// If not specified, defaults to 0
func CudnnRNNBackpropDropout(value float32) CudnnRNNBackpropAttr {
	return func(m optionalAttr) {
		m["dropout"] = value
	}
}

// CudnnRNNBackpropSeed sets the optional seed attribute to value.
// If not specified, defaults to 0
func CudnnRNNBackpropSeed(value int64) CudnnRNNBackpropAttr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// CudnnRNNBackpropSeed2 sets the optional seed2 attribute to value.
// If not specified, defaults to 0
func CudnnRNNBackpropSeed2(value int64) CudnnRNNBackpropAttr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// Backprop step of CudnnRNN.
//
// Compute the backprop of both data and weights in a RNN.
//
// rnn_mode: Indicates the type of the RNN model.
// input_mode: Indicate whether there is a linear projection between the input and
//
//	the actual computation before the first layer. 'skip_input' is only allowed
//	when input_size == num_units; 'auto_select' implies 'skip_input' when
//	input_size == num_units; otherwise, it implies 'linear_input'.
//
// direction: Indicates whether a bidirectional model will be used. Should be
//
//	"unidirectional" or "bidirectional".
//
// dropout: Dropout probability. When set to 0., dropout is disabled.
// seed: The 1st part of a seed to initialize dropout.
// seed2: The 2nd part of a seed to initialize dropout.
// input: A 3-D tensor with the shape of [seq_length, batch_size, input_size].
// input_h: A 3-D tensor with the shape of [num_layer * dir, batch_size,
//
//	num_units].
//
// input_c: For LSTM, a 3-D tensor with the shape of
//
//	[num_layer * dir, batch, num_units]. For other models, it is ignored.
//
// params: A 1-D tensor that contains the weights and biases in an opaque layout.
//
//	The size must be created through CudnnRNNParamsSize, and initialized
//	separately. Note that they might not be compatible across different
//	generations. So it is a good idea to save and restore
//
// output: A 3-D tensor with the shape of [seq_length, batch_size,
//
//	dir * num_units].
//
// output_h: The same shape has input_h.
// output_c: The same shape as input_c for LSTM. An empty tensor for other models.
// output_backprop: A 3-D tensor with the same shape as output in the forward pass.
// output_h_backprop: A 3-D tensor with the same shape as output_h in the forward
//
//	pass.
//
// output_c_backprop: A 3-D tensor with the same shape as output_c in the forward
//
//	pass.
//
// reserve_space: The same reserve_space produced in for forward operation.
// input_backprop: The backprop to input in the forward pass. Has the same shape
//
//	as input.
//
// input_h_backprop: The backprop to input_h in the forward pass. Has the same
//
//	shape as input_h.
//
// input_c_backprop: The backprop to input_c in the forward pass. Has the same
//
//	shape as input_c.
//
// params_backprop: The backprop to the params buffer in the forward pass. Has the
//
//	same shape as params.
func CudnnRNNBackprop(scope *Scope, input tf.Output, input_h tf.Output, input_c tf.Output, params tf.Output, output tf.Output, output_h tf.Output, output_c tf.Output, output_backprop tf.Output, output_h_backprop tf.Output, output_c_backprop tf.Output, reserve_space tf.Output, optional ...CudnnRNNBackpropAttr) (input_backprop tf.Output, input_h_backprop tf.Output, input_c_backprop tf.Output, params_backprop tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CudnnRNNBackprop",
		Input: []tf.Input{
			input, input_h, input_c, params, output, output_h, output_c, output_backprop, output_h_backprop, output_c_backprop, reserve_space,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3)
}

// CudnnRNNBackpropV2Attr is an optional argument to CudnnRNNBackpropV2.
type CudnnRNNBackpropV2Attr func(optionalAttr)

// CudnnRNNBackpropV2RnnMode sets the optional rnn_mode attribute to value.
// If not specified, defaults to "lstm"
func CudnnRNNBackpropV2RnnMode(value string) CudnnRNNBackpropV2Attr {
	return func(m optionalAttr) {
		m["rnn_mode"] = value
	}
}

// CudnnRNNBackpropV2InputMode sets the optional input_mode attribute to value.
// If not specified, defaults to "linear_input"
func CudnnRNNBackpropV2InputMode(value string) CudnnRNNBackpropV2Attr {
	return func(m optionalAttr) {
		m["input_mode"] = value
	}
}

// CudnnRNNBackpropV2Direction sets the optional direction attribute to value.
// If not specified, defaults to "unidirectional"
func CudnnRNNBackpropV2Direction(value string) CudnnRNNBackpropV2Attr {
	return func(m optionalAttr) {
		m["direction"] = value
	}
}

// CudnnRNNBackpropV2Dropout sets the optional dropout attribute to value.
// If not specified, defaults to 0
func CudnnRNNBackpropV2Dropout(value float32) CudnnRNNBackpropV2Attr {
	return func(m optionalAttr) {
		m["dropout"] = value
	}
}

// CudnnRNNBackpropV2Seed sets the optional seed attribute to value.
// If not specified, defaults to 0
func CudnnRNNBackpropV2Seed(value int64) CudnnRNNBackpropV2Attr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// CudnnRNNBackpropV2Seed2 sets the optional seed2 attribute to value.
// If not specified, defaults to 0
func CudnnRNNBackpropV2Seed2(value int64) CudnnRNNBackpropV2Attr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// Backprop step of CudnnRNN.
//
// Compute the backprop of both data and weights in a RNN. Takes an extra
//
//	"host_reserved" inupt than CudnnRNNBackprop, which is used to determine RNN
//	cudnnRNNAlgo_t and cudnnMathType_t.
//
// rnn_mode: Indicates the type of the RNN model.
// input_mode: Indicates whether there is a linear projection between the input and
//
//	the actual computation before the first layer. 'skip_input' is only allowed
//	when input_size == num_units; 'auto_select' implies 'skip_input' when
//	input_size == num_units; otherwise, it implies 'linear_input'.
//
// direction: Indicates whether a bidirectional model will be used. Should be
//
//	"unidirectional" or "bidirectional".
//
// dropout: Dropout probability. When set to 0., dropout is disabled.
// seed: The 1st part of a seed to initialize dropout.
// seed2: The 2nd part of a seed to initialize dropout.
// input: A 3-D tensor with the shape of [seq_length, batch_size, input_size].
// input_h: A 3-D tensor with the shape of [num_layer * dir, batch_size,
//
//	num_units].
//
// input_c: For LSTM, a 3-D tensor with the shape of
//
//	[num_layer * dir, batch, num_units]. For other models, it is ignored.
//
// params: A 1-D tensor that contains the weights and biases in an opaque layout.
//
//	The size must be created through CudnnRNNParamsSize, and initialized
//	separately. Note that they might not be compatible across different
//	generations. So it is a good idea to save and restore
//
// output: A 3-D tensor with the shape of [seq_length, batch_size,
//
//	dir * num_units].
//
// output_h: The same shape has input_h.
// output_c: The same shape as input_c for LSTM. An empty tensor for other models.
// output_backprop: A 3-D tensor with the same shape as output in the forward pass.
// output_h_backprop: A 3-D tensor with the same shape as output_h in the forward
//
//	pass.
//
// output_c_backprop: A 3-D tensor with the same shape as output_c in the forward
//
//	pass.
//
// reserve_space: The same reserve_space produced in the forward operation.
// host_reserved: The same host_reserved produced in the forward operation.
// input_backprop: The backprop to input in the forward pass. Has the same shape
//
//	as input.
//
// input_h_backprop: The backprop to input_h in the forward pass. Has the same
//
//	shape as input_h.
//
// input_c_backprop: The backprop to input_c in the forward pass. Has the same
//
//	shape as input_c.
//
// params_backprop: The backprop to the params buffer in the forward pass. Has the
//
//	same shape as params.
func CudnnRNNBackpropV2(scope *Scope, input tf.Output, input_h tf.Output, input_c tf.Output, params tf.Output, output tf.Output, output_h tf.Output, output_c tf.Output, output_backprop tf.Output, output_h_backprop tf.Output, output_c_backprop tf.Output, reserve_space tf.Output, host_reserved tf.Output, optional ...CudnnRNNBackpropV2Attr) (input_backprop tf.Output, input_h_backprop tf.Output, input_c_backprop tf.Output, params_backprop tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CudnnRNNBackpropV2",
		Input: []tf.Input{
			input, input_h, input_c, params, output, output_h, output_c, output_backprop, output_h_backprop, output_c_backprop, reserve_space, host_reserved,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3)
}

// CudnnRNNBackpropV3Attr is an optional argument to CudnnRNNBackpropV3.
type CudnnRNNBackpropV3Attr func(optionalAttr)

// CudnnRNNBackpropV3RnnMode sets the optional rnn_mode attribute to value.
// If not specified, defaults to "lstm"
func CudnnRNNBackpropV3RnnMode(value string) CudnnRNNBackpropV3Attr {
	return func(m optionalAttr) {
		m["rnn_mode"] = value
	}
}

// CudnnRNNBackpropV3InputMode sets the optional input_mode attribute to value.
// If not specified, defaults to "linear_input"
func CudnnRNNBackpropV3InputMode(value string) CudnnRNNBackpropV3Attr {
	return func(m optionalAttr) {
		m["input_mode"] = value
	}
}

// CudnnRNNBackpropV3Direction sets the optional direction attribute to value.
// If not specified, defaults to "unidirectional"
func CudnnRNNBackpropV3Direction(value string) CudnnRNNBackpropV3Attr {
	return func(m optionalAttr) {
		m["direction"] = value
	}
}

// CudnnRNNBackpropV3Dropout sets the optional dropout attribute to value.
// If not specified, defaults to 0
func CudnnRNNBackpropV3Dropout(value float32) CudnnRNNBackpropV3Attr {
	return func(m optionalAttr) {
		m["dropout"] = value
	}
}

// CudnnRNNBackpropV3Seed sets the optional seed attribute to value.
// If not specified, defaults to 0
func CudnnRNNBackpropV3Seed(value int64) CudnnRNNBackpropV3Attr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// CudnnRNNBackpropV3Seed2 sets the optional seed2 attribute to value.
// If not specified, defaults to 0
func CudnnRNNBackpropV3Seed2(value int64) CudnnRNNBackpropV3Attr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// CudnnRNNBackpropV3NumProj sets the optional num_proj attribute to value.
// If not specified, defaults to 0
func CudnnRNNBackpropV3NumProj(value int64) CudnnRNNBackpropV3Attr {
	return func(m optionalAttr) {
		m["num_proj"] = value
	}
}

// CudnnRNNBackpropV3TimeMajor sets the optional time_major attribute to value.
// If not specified, defaults to true
func CudnnRNNBackpropV3TimeMajor(value bool) CudnnRNNBackpropV3Attr {
	return func(m optionalAttr) {
		m["time_major"] = value
	}
}

// Backprop step of CudnnRNNV3.
//
// Compute the backprop of both data and weights in a RNN. Takes an extra
//
//	"sequence_lengths" input than CudnnRNNBackprop.
//
// rnn_mode: Indicates the type of the RNN model.
// input_mode: Indicates whether there is a linear projection between the input and
//
//	the actual computation before the first layer. 'skip_input' is only allowed
//	when input_size == num_units; 'auto_select' implies 'skip_input' when
//	input_size == num_units; otherwise, it implies 'linear_input'.
//
// direction: Indicates whether a bidirectional model will be used. Should be
//
//	"unidirectional" or "bidirectional".
//
// dropout: Dropout probability. When set to 0., dropout is disabled.
// seed: The 1st part of a seed to initialize dropout.
// seed2: The 2nd part of a seed to initialize dropout.
// input: If time_major is true, this is a 3-D tensor with the shape of
//
//	[seq_length, batch_size, input_size]. If time_major is false, the shape is
//	[batch_size, seq_length, input_size].
//
// input_h: If time_major is true, this is a 3-D tensor with the shape of
//
//	[num_layer * dir, batch_size, num_units]. If time_major is false, the shape
//	is [batch_size, num_layer * dir, num_units].
//
// input_c: For LSTM, a 3-D tensor with the shape of
//
//	[num_layer * dir, batch, num_units]. For other models, it is ignored.
//
// params: A 1-D tensor that contains the weights and biases in an opaque layout.
//
//	The size must be created through CudnnRNNParamsSize, and initialized
//	separately. Note that they might not be compatible across different
//	generations. So it is a good idea to save and restore
//
// sequence_lengths: a vector of lengths of each input sequence.
// output: If time_major is true, this is a 3-D tensor with the shape of
//
//	[seq_length, batch_size, dir * num_units]. If time_major is false, the
//	shape is [batch_size, seq_length, dir * num_units].
//
// output_h: The same shape has input_h.
// output_c: The same shape as input_c for LSTM. An empty tensor for other models.
// output_backprop: A 3-D tensor with the same shape as output in the forward pass.
// output_h_backprop: A 3-D tensor with the same shape as output_h in the forward
//
//	pass.
//
// output_c_backprop: A 3-D tensor with the same shape as output_c in the forward
//
//	pass.
//
// time_major: Indicates whether the input/output format is time major or batch
//
//	major.
//
// reserve_space: The same reserve_space produced in the forward operation.
// input_backprop: The backprop to input in the forward pass. Has the same shape
//
//	as input.
//
// input_h_backprop: The backprop to input_h in the forward pass. Has the same
//
//	shape as input_h.
//
// input_c_backprop: The backprop to input_c in the forward pass. Has the same
//
//	shape as input_c.
//
// params_backprop: The backprop to the params buffer in the forward pass. Has the
//
//	same shape as params.
func CudnnRNNBackpropV3(scope *Scope, input tf.Output, input_h tf.Output, input_c tf.Output, params tf.Output, sequence_lengths tf.Output, output tf.Output, output_h tf.Output, output_c tf.Output, output_backprop tf.Output, output_h_backprop tf.Output, output_c_backprop tf.Output, reserve_space tf.Output, host_reserved tf.Output, optional ...CudnnRNNBackpropV3Attr) (input_backprop tf.Output, input_h_backprop tf.Output, input_c_backprop tf.Output, params_backprop tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CudnnRNNBackpropV3",
		Input: []tf.Input{
			input, input_h, input_c, params, sequence_lengths, output, output_h, output_c, output_backprop, output_h_backprop, output_c_backprop, reserve_space, host_reserved,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3)
}

// CudnnRNNCanonicalToParamsAttr is an optional argument to CudnnRNNCanonicalToParams.
type CudnnRNNCanonicalToParamsAttr func(optionalAttr)

// CudnnRNNCanonicalToParamsRnnMode sets the optional rnn_mode attribute to value.
// If not specified, defaults to "lstm"
func CudnnRNNCanonicalToParamsRnnMode(value string) CudnnRNNCanonicalToParamsAttr {
	return func(m optionalAttr) {
		m["rnn_mode"] = value
	}
}

// CudnnRNNCanonicalToParamsInputMode sets the optional input_mode attribute to value.
// If not specified, defaults to "linear_input"
func CudnnRNNCanonicalToParamsInputMode(value string) CudnnRNNCanonicalToParamsAttr {
	return func(m optionalAttr) {
		m["input_mode"] = value
	}
}

// CudnnRNNCanonicalToParamsDirection sets the optional direction attribute to value.
// If not specified, defaults to "unidirectional"
func CudnnRNNCanonicalToParamsDirection(value string) CudnnRNNCanonicalToParamsAttr {
	return func(m optionalAttr) {
		m["direction"] = value
	}
}

// CudnnRNNCanonicalToParamsDropout sets the optional dropout attribute to value.
// If not specified, defaults to 0
func CudnnRNNCanonicalToParamsDropout(value float32) CudnnRNNCanonicalToParamsAttr {
	return func(m optionalAttr) {
		m["dropout"] = value
	}
}

// CudnnRNNCanonicalToParamsSeed sets the optional seed attribute to value.
// If not specified, defaults to 0
func CudnnRNNCanonicalToParamsSeed(value int64) CudnnRNNCanonicalToParamsAttr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// CudnnRNNCanonicalToParamsSeed2 sets the optional seed2 attribute to value.
// If not specified, defaults to 0
func CudnnRNNCanonicalToParamsSeed2(value int64) CudnnRNNCanonicalToParamsAttr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// Converts CudnnRNN params from canonical form to usable form.
//
// Writes a set of weights into the opaque params buffer so they can be used in
// upcoming training or inferences.
//
// Note that the params buffer may not be compatible across different GPUs. So any
// save and restoration should be converted to and from the canonical weights and
// biases.
//
// num_layers: Specifies the number of layers in the RNN model.
// num_units: Specifies the size of the hidden state.
// input_size: Specifies the size of the input state.
// weights: the canonical form of weights that can be used for saving
//
//	and restoration. They are more likely to be compatible across different
//	generations.
//
// biases: the canonical form of biases that can be used for saving
//
//	and restoration. They are more likely to be compatible across different
//	generations.
//
// num_params: number of parameter sets for all layers.
//
//	Each layer may contain multiple parameter sets, with each set consisting of
//	a weight matrix and a bias vector.
//
// rnn_mode: Indicates the type of the RNN model.
// input_mode: Indicate whether there is a linear projection between the input and
//
//	The actual computation before the first layer. 'skip_input' is only allowed
//	when input_size == num_units; 'auto_select' implies 'skip_input' when
//	input_size == num_units; otherwise, it implies 'linear_input'.
//
// direction: Indicates whether a bidirectional model will be used.
//
//	dir = (direction == bidirectional) ? 2 : 1
//
// dropout: dropout probability. When set to 0., dropout is disabled.
// seed: the 1st part of a seed to initialize dropout.
// seed2: the 2nd part of a seed to initialize dropout.
func CudnnRNNCanonicalToParams(scope *Scope, num_layers tf.Output, num_units tf.Output, input_size tf.Output, weights []tf.Output, biases []tf.Output, optional ...CudnnRNNCanonicalToParamsAttr) (params tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CudnnRNNCanonicalToParams",
		Input: []tf.Input{
			num_layers, num_units, input_size, tf.OutputList(weights), tf.OutputList(biases),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// CudnnRNNCanonicalToParamsV2Attr is an optional argument to CudnnRNNCanonicalToParamsV2.
type CudnnRNNCanonicalToParamsV2Attr func(optionalAttr)

// CudnnRNNCanonicalToParamsV2RnnMode sets the optional rnn_mode attribute to value.
// If not specified, defaults to "lstm"
func CudnnRNNCanonicalToParamsV2RnnMode(value string) CudnnRNNCanonicalToParamsV2Attr {
	return func(m optionalAttr) {
		m["rnn_mode"] = value
	}
}

// CudnnRNNCanonicalToParamsV2InputMode sets the optional input_mode attribute to value.
// If not specified, defaults to "linear_input"
func CudnnRNNCanonicalToParamsV2InputMode(value string) CudnnRNNCanonicalToParamsV2Attr {
	return func(m optionalAttr) {
		m["input_mode"] = value
	}
}

// CudnnRNNCanonicalToParamsV2Direction sets the optional direction attribute to value.
// If not specified, defaults to "unidirectional"
func CudnnRNNCanonicalToParamsV2Direction(value string) CudnnRNNCanonicalToParamsV2Attr {
	return func(m optionalAttr) {
		m["direction"] = value
	}
}

// CudnnRNNCanonicalToParamsV2Dropout sets the optional dropout attribute to value.
// If not specified, defaults to 0
func CudnnRNNCanonicalToParamsV2Dropout(value float32) CudnnRNNCanonicalToParamsV2Attr {
	return func(m optionalAttr) {
		m["dropout"] = value
	}
}

// CudnnRNNCanonicalToParamsV2Seed sets the optional seed attribute to value.
// If not specified, defaults to 0
func CudnnRNNCanonicalToParamsV2Seed(value int64) CudnnRNNCanonicalToParamsV2Attr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// CudnnRNNCanonicalToParamsV2Seed2 sets the optional seed2 attribute to value.
// If not specified, defaults to 0
func CudnnRNNCanonicalToParamsV2Seed2(value int64) CudnnRNNCanonicalToParamsV2Attr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// CudnnRNNCanonicalToParamsV2NumProj sets the optional num_proj attribute to value.
// If not specified, defaults to 0
func CudnnRNNCanonicalToParamsV2NumProj(value int64) CudnnRNNCanonicalToParamsV2Attr {
	return func(m optionalAttr) {
		m["num_proj"] = value
	}
}

// Converts CudnnRNN params from canonical form to usable form. It supports the projection in LSTM.
//
// Writes a set of weights into the opaque params buffer so they can be used in
// upcoming training or inferences.
//
// Note that the params buffer may not be compatible across different GPUs. So any
// save and restoration should be converted to and from the canonical weights and
// biases.
//
// num_layers: Specifies the number of layers in the RNN model.
// num_units: Specifies the size of the hidden state.
// input_size: Specifies the size of the input state.
// weights: the canonical form of weights that can be used for saving
//
//	and restoration. They are more likely to be compatible across different
//	generations.
//
// biases: the canonical form of biases that can be used for saving
//
//	and restoration. They are more likely to be compatible across different
//	generations.
//
// num_params_weights: number of weight parameter matrix for all layers.
// num_params_biases: number of bias parameter vector for all layers.
// rnn_mode: Indicates the type of the RNN model.
// input_mode: Indicate whether there is a linear projection between the input and
//
//	The actual computation before the first layer. 'skip_input' is only allowed
//	when input_size == num_units; 'auto_select' implies 'skip_input' when
//	input_size == num_units; otherwise, it implies 'linear_input'.
//
// direction: Indicates whether a bidirectional model will be used.
//
//	dir = (direction == bidirectional) ? 2 : 1
//
// dropout: dropout probability. When set to 0., dropout is disabled.
// seed: the 1st part of a seed to initialize dropout.
// seed2: the 2nd part of a seed to initialize dropout.
// num_proj: The output dimensionality for the projection matrices. If None or 0,
//
//	no projection is performed.
func CudnnRNNCanonicalToParamsV2(scope *Scope, num_layers tf.Output, num_units tf.Output, input_size tf.Output, weights []tf.Output, biases []tf.Output, optional ...CudnnRNNCanonicalToParamsV2Attr) (params tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CudnnRNNCanonicalToParamsV2",
		Input: []tf.Input{
			num_layers, num_units, input_size, tf.OutputList(weights), tf.OutputList(biases),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// CudnnRNNParamsSizeAttr is an optional argument to CudnnRNNParamsSize.
type CudnnRNNParamsSizeAttr func(optionalAttr)

// CudnnRNNParamsSizeRnnMode sets the optional rnn_mode attribute to value.
// If not specified, defaults to "lstm"
func CudnnRNNParamsSizeRnnMode(value string) CudnnRNNParamsSizeAttr {
	return func(m optionalAttr) {
		m["rnn_mode"] = value
	}
}

// CudnnRNNParamsSizeInputMode sets the optional input_mode attribute to value.
// If not specified, defaults to "linear_input"
func CudnnRNNParamsSizeInputMode(value string) CudnnRNNParamsSizeAttr {
	return func(m optionalAttr) {
		m["input_mode"] = value
	}
}

// CudnnRNNParamsSizeDirection sets the optional direction attribute to value.
// If not specified, defaults to "unidirectional"
func CudnnRNNParamsSizeDirection(value string) CudnnRNNParamsSizeAttr {
	return func(m optionalAttr) {
		m["direction"] = value
	}
}

// CudnnRNNParamsSizeDropout sets the optional dropout attribute to value.
// If not specified, defaults to 0
func CudnnRNNParamsSizeDropout(value float32) CudnnRNNParamsSizeAttr {
	return func(m optionalAttr) {
		m["dropout"] = value
	}
}

// CudnnRNNParamsSizeSeed sets the optional seed attribute to value.
// If not specified, defaults to 0
func CudnnRNNParamsSizeSeed(value int64) CudnnRNNParamsSizeAttr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// CudnnRNNParamsSizeSeed2 sets the optional seed2 attribute to value.
// If not specified, defaults to 0
func CudnnRNNParamsSizeSeed2(value int64) CudnnRNNParamsSizeAttr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// CudnnRNNParamsSizeNumProj sets the optional num_proj attribute to value.
// If not specified, defaults to 0
func CudnnRNNParamsSizeNumProj(value int64) CudnnRNNParamsSizeAttr {
	return func(m optionalAttr) {
		m["num_proj"] = value
	}
}

// Computes size of weights that can be used by a Cudnn RNN model.
//
// Return the params size that can be used by the Cudnn RNN model. Subsequent
// weight allocation and initialization should use this size.
//
// num_layers: Specifies the number of layers in the RNN model.
// num_units: Specifies the size of the hidden state.
// input_size: Specifies the size of the input state.
// rnn_mode: Indicates the type of the RNN model.
// input_mode: Indicate whether there is a linear projection between the input and
//
//	The actual computation before the first layer. 'skip_input' is only allowed
//	when input_size == num_units; 'auto_select' implies 'skip_input' when
//	input_size == num_units; otherwise, it implies 'linear_input'.
//
// direction: Indicates whether a bidirectional model will be used.
//
//	dir = (direction == bidirectional) ? 2 : 1
//
// dropout: dropout probability. When set to 0., dropout is disabled.
// seed: the 1st part of a seed to initialize dropout.
// seed2: the 2nd part of a seed to initialize dropout.
// params_size: The size of the params buffer that should be allocated and
//
//	initialized for this RNN model. Note that this params buffer may not be
//	compatible across GPUs. Please use CudnnRNNParamsWeights and
//	CudnnRNNParamsBiases to save and restore them in a way that is compatible
//	across different runs.
func CudnnRNNParamsSize(scope *Scope, num_layers tf.Output, num_units tf.Output, input_size tf.Output, T tf.DataType, S tf.DataType, optional ...CudnnRNNParamsSizeAttr) (params_size tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"T": T, "S": S}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CudnnRNNParamsSize",
		Input: []tf.Input{
			num_layers, num_units, input_size,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// CudnnRNNParamsToCanonicalAttr is an optional argument to CudnnRNNParamsToCanonical.
type CudnnRNNParamsToCanonicalAttr func(optionalAttr)

// CudnnRNNParamsToCanonicalRnnMode sets the optional rnn_mode attribute to value.
// If not specified, defaults to "lstm"
func CudnnRNNParamsToCanonicalRnnMode(value string) CudnnRNNParamsToCanonicalAttr {
	return func(m optionalAttr) {
		m["rnn_mode"] = value
	}
}

// CudnnRNNParamsToCanonicalInputMode sets the optional input_mode attribute to value.
// If not specified, defaults to "linear_input"
func CudnnRNNParamsToCanonicalInputMode(value string) CudnnRNNParamsToCanonicalAttr {
	return func(m optionalAttr) {
		m["input_mode"] = value
	}
}

// CudnnRNNParamsToCanonicalDirection sets the optional direction attribute to value.
// If not specified, defaults to "unidirectional"
func CudnnRNNParamsToCanonicalDirection(value string) CudnnRNNParamsToCanonicalAttr {
	return func(m optionalAttr) {
		m["direction"] = value
	}
}

// CudnnRNNParamsToCanonicalDropout sets the optional dropout attribute to value.
// If not specified, defaults to 0
func CudnnRNNParamsToCanonicalDropout(value float32) CudnnRNNParamsToCanonicalAttr {
	return func(m optionalAttr) {
		m["dropout"] = value
	}
}

// CudnnRNNParamsToCanonicalSeed sets the optional seed attribute to value.
// If not specified, defaults to 0
func CudnnRNNParamsToCanonicalSeed(value int64) CudnnRNNParamsToCanonicalAttr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// CudnnRNNParamsToCanonicalSeed2 sets the optional seed2 attribute to value.
// If not specified, defaults to 0
func CudnnRNNParamsToCanonicalSeed2(value int64) CudnnRNNParamsToCanonicalAttr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// Retrieves CudnnRNN params in canonical form.
//
// Retrieves a set of weights from the opaque params buffer that can be saved and
// restored in a way compatible with future runs.
//
// Note that the params buffer may not be compatible across different GPUs. So any
// save and restoration should be converted to and from the canonical weights and
// biases.
//
// num_layers: Specifies the number of layers in the RNN model.
// num_units: Specifies the size of the hidden state.
// input_size: Specifies the size of the input state.
// num_params: number of parameter sets for all layers.
//
//	Each layer may contain multiple parameter sets, with each set consisting of
//	a weight matrix and a bias vector.
//
// weights: the canonical form of weights that can be used for saving
//
//	and restoration. They are more likely to be compatible across different
//	generations.
//
// biases: the canonical form of biases that can be used for saving
//
//	and restoration. They are more likely to be compatible across different
//	generations.
//
// rnn_mode: Indicates the type of the RNN model.
// input_mode: Indicate whether there is a linear projection between the input and
//
//	The actual computation before the first layer. 'skip_input' is only allowed
//	when input_size == num_units; 'auto_select' implies 'skip_input' when
//	input_size == num_units; otherwise, it implies 'linear_input'.
//
// direction: Indicates whether a bidirectional model will be used.
//
//	dir = (direction == bidirectional) ? 2 : 1
//
// dropout: dropout probability. When set to 0., dropout is disabled.
// seed: the 1st part of a seed to initialize dropout.
// seed2: the 2nd part of a seed to initialize dropout.
func CudnnRNNParamsToCanonical(scope *Scope, num_layers tf.Output, num_units tf.Output, input_size tf.Output, params tf.Output, num_params int64, optional ...CudnnRNNParamsToCanonicalAttr) (weights []tf.Output, biases []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_params": num_params}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CudnnRNNParamsToCanonical",
		Input: []tf.Input{
			num_layers, num_units, input_size, params,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if weights, idx, err = makeOutputList(op, idx, "weights"); err != nil {
		scope.UpdateErr("CudnnRNNParamsToCanonical", err)
		return
	}
	if biases, idx, err = makeOutputList(op, idx, "biases"); err != nil {
		scope.UpdateErr("CudnnRNNParamsToCanonical", err)
		return
	}
	return weights, biases
}

// CudnnRNNParamsToCanonicalV2Attr is an optional argument to CudnnRNNParamsToCanonicalV2.
type CudnnRNNParamsToCanonicalV2Attr func(optionalAttr)

// CudnnRNNParamsToCanonicalV2RnnMode sets the optional rnn_mode attribute to value.
// If not specified, defaults to "lstm"
func CudnnRNNParamsToCanonicalV2RnnMode(value string) CudnnRNNParamsToCanonicalV2Attr {
	return func(m optionalAttr) {
		m["rnn_mode"] = value
	}
}

// CudnnRNNParamsToCanonicalV2InputMode sets the optional input_mode attribute to value.
// If not specified, defaults to "linear_input"
func CudnnRNNParamsToCanonicalV2InputMode(value string) CudnnRNNParamsToCanonicalV2Attr {
	return func(m optionalAttr) {
		m["input_mode"] = value
	}
}

// CudnnRNNParamsToCanonicalV2Direction sets the optional direction attribute to value.
// If not specified, defaults to "unidirectional"
func CudnnRNNParamsToCanonicalV2Direction(value string) CudnnRNNParamsToCanonicalV2Attr {
	return func(m optionalAttr) {
		m["direction"] = value
	}
}

// CudnnRNNParamsToCanonicalV2Dropout sets the optional dropout attribute to value.
// If not specified, defaults to 0
func CudnnRNNParamsToCanonicalV2Dropout(value float32) CudnnRNNParamsToCanonicalV2Attr {
	return func(m optionalAttr) {
		m["dropout"] = value
	}
}

// CudnnRNNParamsToCanonicalV2Seed sets the optional seed attribute to value.
// If not specified, defaults to 0
func CudnnRNNParamsToCanonicalV2Seed(value int64) CudnnRNNParamsToCanonicalV2Attr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// CudnnRNNParamsToCanonicalV2Seed2 sets the optional seed2 attribute to value.
// If not specified, defaults to 0
func CudnnRNNParamsToCanonicalV2Seed2(value int64) CudnnRNNParamsToCanonicalV2Attr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// CudnnRNNParamsToCanonicalV2NumProj sets the optional num_proj attribute to value.
// If not specified, defaults to 0
func CudnnRNNParamsToCanonicalV2NumProj(value int64) CudnnRNNParamsToCanonicalV2Attr {
	return func(m optionalAttr) {
		m["num_proj"] = value
	}
}

// Retrieves CudnnRNN params in canonical form. It supports the projection in LSTM.
//
// Retrieves a set of weights from the opaque params buffer that can be saved and
// restored in a way compatible with future runs.
//
// Note that the params buffer may not be compatible across different GPUs. So any
// save and restoration should be converted to and from the canonical weights and
// biases.
//
// num_layers: Specifies the number of layers in the RNN model.
// num_units: Specifies the size of the hidden state.
// input_size: Specifies the size of the input state.
// num_params_weights: number of weight parameter matrix for all layers.
// num_params_biases: number of bias parameter vector for all layers.
// weights: the canonical form of weights that can be used for saving
//
//	and restoration. They are more likely to be compatible across different
//	generations.
//
// biases: the canonical form of biases that can be used for saving
//
//	and restoration. They are more likely to be compatible across different
//	generations.
//
// rnn_mode: Indicates the type of the RNN model.
// input_mode: Indicate whether there is a linear projection between the input and
//
//	The actual computation before the first layer. 'skip_input' is only allowed
//	when input_size == num_units; 'auto_select' implies 'skip_input' when
//	input_size == num_units; otherwise, it implies 'linear_input'.
//
// direction: Indicates whether a bidirectional model will be used.
//
//	dir = (direction == bidirectional) ? 2 : 1
//
// dropout: dropout probability. When set to 0., dropout is disabled.
// seed: the 1st part of a seed to initialize dropout.
// seed2: the 2nd part of a seed to initialize dropout.
// num_proj: The output dimensionality for the projection matrices. If None or 0,
//
//	no projection is performed.
func CudnnRNNParamsToCanonicalV2(scope *Scope, num_layers tf.Output, num_units tf.Output, input_size tf.Output, params tf.Output, num_params_weights int64, num_params_biases int64, optional ...CudnnRNNParamsToCanonicalV2Attr) (weights []tf.Output, biases []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_params_weights": num_params_weights, "num_params_biases": num_params_biases}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CudnnRNNParamsToCanonicalV2",
		Input: []tf.Input{
			num_layers, num_units, input_size, params,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if weights, idx, err = makeOutputList(op, idx, "weights"); err != nil {
		scope.UpdateErr("CudnnRNNParamsToCanonicalV2", err)
		return
	}
	if biases, idx, err = makeOutputList(op, idx, "biases"); err != nil {
		scope.UpdateErr("CudnnRNNParamsToCanonicalV2", err)
		return
	}
	return weights, biases
}

// CudnnRNNV2Attr is an optional argument to CudnnRNNV2.
type CudnnRNNV2Attr func(optionalAttr)

// CudnnRNNV2RnnMode sets the optional rnn_mode attribute to value.
// If not specified, defaults to "lstm"
func CudnnRNNV2RnnMode(value string) CudnnRNNV2Attr {
	return func(m optionalAttr) {
		m["rnn_mode"] = value
	}
}

// CudnnRNNV2InputMode sets the optional input_mode attribute to value.
// If not specified, defaults to "linear_input"
func CudnnRNNV2InputMode(value string) CudnnRNNV2Attr {
	return func(m optionalAttr) {
		m["input_mode"] = value
	}
}

// CudnnRNNV2Direction sets the optional direction attribute to value.
// If not specified, defaults to "unidirectional"
func CudnnRNNV2Direction(value string) CudnnRNNV2Attr {
	return func(m optionalAttr) {
		m["direction"] = value
	}
}

// CudnnRNNV2Dropout sets the optional dropout attribute to value.
// If not specified, defaults to 0
func CudnnRNNV2Dropout(value float32) CudnnRNNV2Attr {
	return func(m optionalAttr) {
		m["dropout"] = value
	}
}

// CudnnRNNV2Seed sets the optional seed attribute to value.
// If not specified, defaults to 0
func CudnnRNNV2Seed(value int64) CudnnRNNV2Attr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// CudnnRNNV2Seed2 sets the optional seed2 attribute to value.
// If not specified, defaults to 0
func CudnnRNNV2Seed2(value int64) CudnnRNNV2Attr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// CudnnRNNV2IsTraining sets the optional is_training attribute to value.
// If not specified, defaults to true
func CudnnRNNV2IsTraining(value bool) CudnnRNNV2Attr {
	return func(m optionalAttr) {
		m["is_training"] = value
	}
}

// A RNN backed by cuDNN.
//
// Computes the RNN from the input and initial states, with respect to the params
// buffer. Produces one extra output "host_reserved" than CudnnRNN.
//
// rnn_mode: Indicates the type of the RNN model.
// input_mode: Indicates whether there is a linear projection between the input and
//
//	the actual computation before the first layer. 'skip_input' is only allowed
//	when input_size == num_units; 'auto_select' implies 'skip_input' when
//	input_size == num_units; otherwise, it implies 'linear_input'.
//
// direction: Indicates whether a bidirectional model will be used. Should be
//
//	"unidirectional" or "bidirectional".
//
// dropout: Dropout probability. When set to 0., dropout is disabled.
// seed: The 1st part of a seed to initialize dropout.
// seed2: The 2nd part of a seed to initialize dropout.
// input: A 3-D tensor with the shape of [seq_length, batch_size, input_size].
// input_h: A 3-D tensor with the shape of [num_layer * dir, batch_size,
//
//	num_units].
//
// input_c: For LSTM, a 3-D tensor with the shape of
//
//	[num_layer * dir, batch, num_units]. For other models, it is ignored.
//
// params: A 1-D tensor that contains the weights and biases in an opaque layout.
//
//	The size must be created through CudnnRNNParamsSize, and initialized
//	separately. Note that they might not be compatible across different
//	generations. So it is a good idea to save and restore
//
// output: A 3-D tensor with the shape of [seq_length, batch_size,
//
//	dir * num_units].
//
// output_h: The same shape has input_h.
// output_c: The same shape as input_c for LSTM. An empty tensor for other models.
// is_training: Indicates whether this operation is used for inference or
//
//	training.
//
// reserve_space: An opaque tensor that can be used in backprop calculation. It
//
//	is only produced if is_training is true.
//
// host_reserved: An opaque tensor that can be used in backprop calculation. It is
//
//	only produced if is_training is true. It is output on host memory rather than
//	device memory.
func CudnnRNNV2(scope *Scope, input tf.Output, input_h tf.Output, input_c tf.Output, params tf.Output, optional ...CudnnRNNV2Attr) (output tf.Output, output_h tf.Output, output_c tf.Output, reserve_space tf.Output, host_reserved tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CudnnRNNV2",
		Input: []tf.Input{
			input, input_h, input_c, params,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3), op.Output(4)
}

// CudnnRNNV3Attr is an optional argument to CudnnRNNV3.
type CudnnRNNV3Attr func(optionalAttr)

// CudnnRNNV3RnnMode sets the optional rnn_mode attribute to value.
// If not specified, defaults to "lstm"
func CudnnRNNV3RnnMode(value string) CudnnRNNV3Attr {
	return func(m optionalAttr) {
		m["rnn_mode"] = value
	}
}

// CudnnRNNV3InputMode sets the optional input_mode attribute to value.
// If not specified, defaults to "linear_input"
func CudnnRNNV3InputMode(value string) CudnnRNNV3Attr {
	return func(m optionalAttr) {
		m["input_mode"] = value
	}
}

// CudnnRNNV3Direction sets the optional direction attribute to value.
// If not specified, defaults to "unidirectional"
func CudnnRNNV3Direction(value string) CudnnRNNV3Attr {
	return func(m optionalAttr) {
		m["direction"] = value
	}
}

// CudnnRNNV3Dropout sets the optional dropout attribute to value.
// If not specified, defaults to 0
func CudnnRNNV3Dropout(value float32) CudnnRNNV3Attr {
	return func(m optionalAttr) {
		m["dropout"] = value
	}
}

// CudnnRNNV3Seed sets the optional seed attribute to value.
// If not specified, defaults to 0
func CudnnRNNV3Seed(value int64) CudnnRNNV3Attr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// CudnnRNNV3Seed2 sets the optional seed2 attribute to value.
// If not specified, defaults to 0
func CudnnRNNV3Seed2(value int64) CudnnRNNV3Attr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// CudnnRNNV3NumProj sets the optional num_proj attribute to value.
// If not specified, defaults to 0
func CudnnRNNV3NumProj(value int64) CudnnRNNV3Attr {
	return func(m optionalAttr) {
		m["num_proj"] = value
	}
}

// CudnnRNNV3IsTraining sets the optional is_training attribute to value.
// If not specified, defaults to true
func CudnnRNNV3IsTraining(value bool) CudnnRNNV3Attr {
	return func(m optionalAttr) {
		m["is_training"] = value
	}
}

// CudnnRNNV3TimeMajor sets the optional time_major attribute to value.
// If not specified, defaults to true
func CudnnRNNV3TimeMajor(value bool) CudnnRNNV3Attr {
	return func(m optionalAttr) {
		m["time_major"] = value
	}
}

// A RNN backed by cuDNN.
//
// Computes the RNN from the input and initial states, with respect to the params
// buffer. Accepts one extra input "sequence_lengths" than CudnnRNN.
//
// rnn_mode: Indicates the type of the RNN model.
// input_mode: Indicates whether there is a linear projection between the input and
//
//	the actual computation before the first layer. 'skip_input' is only allowed
//	when input_size == num_units; 'auto_select' implies 'skip_input' when
//	input_size == num_units; otherwise, it implies 'linear_input'.
//
// direction: Indicates whether a bidirectional model will be used. Should be
//
//	"unidirectional" or "bidirectional".
//
// dropout: Dropout probability. When set to 0., dropout is disabled.
// seed: The 1st part of a seed to initialize dropout.
// seed2: The 2nd part of a seed to initialize dropout.
// input: If time_major is true, this is a 3-D tensor with the shape of
//
//	[seq_length, batch_size, input_size]. If time_major is false, the shape is
//	[batch_size, seq_length, input_size].
//
// input_h: If time_major is true, this is a 3-D tensor with the shape of
//
//	[num_layer * dir, batch_size, num_units]. If time_major is false, the shape
//	is [batch_size, num_layer * dir, num_units].
//
// input_c: For LSTM, a 3-D tensor with the shape of
//
//	[num_layer * dir, batch, num_units]. For other models, it is ignored.
//
// params: A 1-D tensor that contains the weights and biases in an opaque layout.
//
//	The size must be created through CudnnRNNParamsSize, and initialized
//	separately. Note that they might not be compatible across different
//	generations. So it is a good idea to save and restore
//
// sequence_lengths: a vector of lengths of each input sequence.
// output: If time_major is true, this is a 3-D tensor with the shape of
//
//	[seq_length, batch_size, dir * num_units]. If time_major is false, the
//	shape is [batch_size, seq_length, dir * num_units].
//
// output_h: The same shape has input_h.
// output_c: The same shape as input_c for LSTM. An empty tensor for other models.
// is_training: Indicates whether this operation is used for inference or
//
//	training.
//
// time_major: Indicates whether the input/output format is time major or batch
//
//	major.
//
// reserve_space: An opaque tensor that can be used in backprop calculation. It
//
//	is only produced if is_training is true.
func CudnnRNNV3(scope *Scope, input tf.Output, input_h tf.Output, input_c tf.Output, params tf.Output, sequence_lengths tf.Output, optional ...CudnnRNNV3Attr) (output tf.Output, output_h tf.Output, output_c tf.Output, reserve_space tf.Output, host_reserved tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CudnnRNNV3",
		Input: []tf.Input{
			input, input_h, input_c, params, sequence_lengths,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3), op.Output(4)
}

// CumprodAttr is an optional argument to Cumprod.
type CumprodAttr func(optionalAttr)

// CumprodExclusive sets the optional exclusive attribute to value.
//
// value: If `True`, perform exclusive cumprod.
// If not specified, defaults to false
func CumprodExclusive(value bool) CumprodAttr {
	return func(m optionalAttr) {
		m["exclusive"] = value
	}
}

// CumprodReverse sets the optional reverse attribute to value.
//
// value: A `bool` (default: False).
// If not specified, defaults to false
func CumprodReverse(value bool) CumprodAttr {
	return func(m optionalAttr) {
		m["reverse"] = value
	}
}

// Compute the cumulative product of the tensor `x` along `axis`.
//
// By default, this op performs an inclusive cumprod, which means that the first
// element of the input is identical to the first element of the output:
//
// ```python
// tf.cumprod([a, b, c])  # => [a, a * b, a * b * c]
// ```
//
// By setting the `exclusive` kwarg to `True`, an exclusive cumprod is
// performed instead:
//
// ```python
// tf.cumprod([a, b, c], exclusive=True)  # => [1, a, a * b]
// ```
//
// By setting the `reverse` kwarg to `True`, the cumprod is performed in the
// opposite direction:
//
// ```python
// tf.cumprod([a, b, c], reverse=True)  # => [a * b * c, b * c, c]
// ```
//
// This is more efficient than using separate `tf.reverse` ops.
//
// The `reverse` and `exclusive` kwargs can also be combined:
//
// ```python
// tf.cumprod([a, b, c], exclusive=True, reverse=True)  # => [b * c, c, 1]
// ```
//
// Arguments:
//
//	x: A `Tensor`. Must be one of the following types: `float32`, `float64`,
//
// `int64`, `int32`, `uint8`, `uint16`, `int16`, `int8`, `complex64`,
// `complex128`, `qint8`, `quint8`, `qint32`, `half`.
//
//	axis: A `Tensor` of type `int32` (default: 0). Must be in the range
//
// `[-rank(x), rank(x))`.
func Cumprod(scope *Scope, x tf.Output, axis tf.Output, optional ...CumprodAttr) (out tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Cumprod",
		Input: []tf.Input{
			x, axis,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// CumsumAttr is an optional argument to Cumsum.
type CumsumAttr func(optionalAttr)

// CumsumExclusive sets the optional exclusive attribute to value.
//
// value: If `True`, perform exclusive cumsum.
// If not specified, defaults to false
func CumsumExclusive(value bool) CumsumAttr {
	return func(m optionalAttr) {
		m["exclusive"] = value
	}
}

// CumsumReverse sets the optional reverse attribute to value.
//
// value: A `bool` (default: False).
// If not specified, defaults to false
func CumsumReverse(value bool) CumsumAttr {
	return func(m optionalAttr) {
		m["reverse"] = value
	}
}

// Compute the cumulative sum of the tensor `x` along `axis`.
//
// By default, this op performs an inclusive cumsum, which means that the first
// element of the input is identical to the first element of the output:
//
// ```python
// tf.cumsum([a, b, c])  # => [a, a + b, a + b + c]
// ```
//
// By setting the `exclusive` kwarg to `True`, an exclusive cumsum is
// performed instead:
//
// ```python
// tf.cumsum([a, b, c], exclusive=True)  # => [0, a, a + b]
// ```
//
// By setting the `reverse` kwarg to `True`, the cumsum is performed in the
// opposite direction:
//
// ```python
// tf.cumsum([a, b, c], reverse=True)  # => [a + b + c, b + c, c]
// ```
//
// This is more efficient than using separate `tf.reverse` ops.
//
// The `reverse` and `exclusive` kwargs can also be combined:
//
// ```python
// tf.cumsum([a, b, c], exclusive=True, reverse=True)  # => [b + c, c, 0]
// ```
//
// Arguments:
//
//	x: A `Tensor`. Must be one of the following types: `float32`, `float64`,
//
// `int64`, `int32`, `uint8`, `uint16`, `int16`, `int8`, `complex64`,
// `complex128`, `qint8`, `quint8`, `qint32`, `half`.
//
//	axis: A `Tensor` of type `int32` (default: 0). Must be in the range
//
// `[-rank(x), rank(x))`.
func Cumsum(scope *Scope, x tf.Output, axis tf.Output, optional ...CumsumAttr) (out tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Cumsum",
		Input: []tf.Input{
			x, axis,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// CumulativeLogsumexpAttr is an optional argument to CumulativeLogsumexp.
type CumulativeLogsumexpAttr func(optionalAttr)

// CumulativeLogsumexpExclusive sets the optional exclusive attribute to value.
//
// value: If `True`, perform exclusive cumulative log-sum-exp.
// If not specified, defaults to false
func CumulativeLogsumexpExclusive(value bool) CumulativeLogsumexpAttr {
	return func(m optionalAttr) {
		m["exclusive"] = value
	}
}

// CumulativeLogsumexpReverse sets the optional reverse attribute to value.
//
// value: A `bool` (default: False).
// If not specified, defaults to false
func CumulativeLogsumexpReverse(value bool) CumulativeLogsumexpAttr {
	return func(m optionalAttr) {
		m["reverse"] = value
	}
}

// Compute the cumulative product of the tensor `x` along `axis`.
//
// By default, this op performs an inclusive cumulative log-sum-exp,
// which means that the first
// element of the input is identical to the first element of the output:
// ```python
// tf.math.cumulative_logsumexp([a, b, c])  # => [a, log(exp(a) + exp(b)), log(exp(a) + exp(b) + exp(c))]
// ```
//
// By setting the `exclusive` kwarg to `True`, an exclusive cumulative log-sum-exp is
// performed instead:
// ```python
// tf.cumulative_logsumexp([a, b, c], exclusive=True)  # => [-inf, a, log(exp(a) * exp(b))]
// ```
// Note that the neutral element of the log-sum-exp operation is `-inf`,
// however, for performance reasons, the minimal value representable by the
// floating point type is used instead.
//
// By setting the `reverse` kwarg to `True`, the cumulative log-sum-exp is performed in the
// opposite direction.
//
// Arguments:
//
//	x: A `Tensor`. Must be one of the following types: `float16`, `float32`, `float64`.
//	axis: A `Tensor` of type `int32` (default: 0). Must be in the range
//
// `[-rank(x), rank(x))`.
func CumulativeLogsumexp(scope *Scope, x tf.Output, axis tf.Output, optional ...CumulativeLogsumexpAttr) (out tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CumulativeLogsumexp",
		Input: []tf.Input{
			x, axis,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// An op that informs a host of the global ids of all the of TPUs in the system.
//
// Arguments:
//
//	topology: A serialized tensorflow.tpu.TopologyProto that describes the TPU topology.
//
// Returns the created operation.
func DTensorSetGlobalTPUArray(scope *Scope, topology tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "DTensorSetGlobalTPUArray",
		Input: []tf.Input{
			topology,
		},
	}
	return scope.AddOperation(opspec)
}

// DataFormatDimMapAttr is an optional argument to DataFormatDimMap.
type DataFormatDimMapAttr func(optionalAttr)

// DataFormatDimMapSrcFormat sets the optional src_format attribute to value.
//
// value: source data format.
// If not specified, defaults to "NHWC"
func DataFormatDimMapSrcFormat(value string) DataFormatDimMapAttr {
	return func(m optionalAttr) {
		m["src_format"] = value
	}
}

// DataFormatDimMapDstFormat sets the optional dst_format attribute to value.
//
// value: destination data format.
// If not specified, defaults to "NCHW"
func DataFormatDimMapDstFormat(value string) DataFormatDimMapAttr {
	return func(m optionalAttr) {
		m["dst_format"] = value
	}
}

// Returns the dimension index in the destination data format given the one in
//
// the source data format.
//
// Arguments:
//
//	x: A Tensor with each element as a dimension index in source data format.
//
// Must be in the range [-4, 4).
//
// Returns A Tensor with each element as a dimension index in destination data format.
func DataFormatDimMap(scope *Scope, x tf.Output, optional ...DataFormatDimMapAttr) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DataFormatDimMap",
		Input: []tf.Input{
			x,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DataFormatVecPermuteAttr is an optional argument to DataFormatVecPermute.
type DataFormatVecPermuteAttr func(optionalAttr)

// DataFormatVecPermuteSrcFormat sets the optional src_format attribute to value.
//
// value: source data format.
// If not specified, defaults to "NHWC"
func DataFormatVecPermuteSrcFormat(value string) DataFormatVecPermuteAttr {
	return func(m optionalAttr) {
		m["src_format"] = value
	}
}

// DataFormatVecPermuteDstFormat sets the optional dst_format attribute to value.
//
// value: destination data format.
// If not specified, defaults to "NCHW"
func DataFormatVecPermuteDstFormat(value string) DataFormatVecPermuteAttr {
	return func(m optionalAttr) {
		m["dst_format"] = value
	}
}

// Permute input tensor from `src_format` to `dst_format`.
//
// Given source and destination format strings of length n=4 or 5, the input
// tensor must be a vector of size n or n-2, or a 2D tensor of shape
// (n, 2) or (n-2, 2).
//
// If the first dimension of the input tensor is n-2, it is assumed that
// non-spatial dimensions are omitted (i.e `N`, `C`).
//
// For example, with `src_format` of `NHWC`, `dst_format` of `NCHW`, and input:
// ```
// [1, 2, 3, 4]
// ```
// , the output will be:
// ```
// [1, 4, 2, 3]
// ```
// With `src_format` of `NDHWC`, `dst_format` of `NCDHW`, and input:
// ```
// [[1, 6], [2, 7], [3, 8], [4, 9], [5, 10]]
// ```
// , the output will be:
// ```
// [[1, 6], [5, 10], [2, 7], [3, 8], [4, 9]]
// ```
// With `src_format` of `NHWC`, `dst_format` of `NCHW`, and input:
// ```
// [1, 2]
// ```
// , the output will be:
// ```
// [1, 2]
// ```
//
// Arguments:
//
//	x: Tensor of rank 1 or 2 in source data format.
//
// Returns Tensor of rank 1 or 2 in destination data format.
func DataFormatVecPermute(scope *Scope, x tf.Output, optional ...DataFormatVecPermuteAttr) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DataFormatVecPermute",
		Input: []tf.Input{
			x,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DataServiceDatasetAttr is an optional argument to DataServiceDataset.
type DataServiceDatasetAttr func(optionalAttr)

// DataServiceDatasetTaskRefreshIntervalHintMs sets the optional task_refresh_interval_hint_ms attribute to value.
// If not specified, defaults to -1
func DataServiceDatasetTaskRefreshIntervalHintMs(value int64) DataServiceDatasetAttr {
	return func(m optionalAttr) {
		m["task_refresh_interval_hint_ms"] = value
	}
}

// DataServiceDatasetDataTransferProtocol sets the optional data_transfer_protocol attribute to value.
// If not specified, defaults to ""
func DataServiceDatasetDataTransferProtocol(value string) DataServiceDatasetAttr {
	return func(m optionalAttr) {
		m["data_transfer_protocol"] = value
	}
}

// DataServiceDatasetTargetWorkers sets the optional target_workers attribute to value.
// If not specified, defaults to "AUTO"
func DataServiceDatasetTargetWorkers(value string) DataServiceDatasetAttr {
	return func(m optionalAttr) {
		m["target_workers"] = value
	}
}

// DataServiceDatasetCrossTrainerCacheOptions sets the optional cross_trainer_cache_options attribute to value.
// If not specified, defaults to ""
func DataServiceDatasetCrossTrainerCacheOptions(value string) DataServiceDatasetAttr {
	return func(m optionalAttr) {
		m["cross_trainer_cache_options"] = value
	}
}

// Creates a dataset that reads data from the tf.data service.
func DataServiceDataset(scope *Scope, dataset_id tf.Output, processing_mode tf.Output, address tf.Output, protocol tf.Output, job_name tf.Output, max_outstanding_requests tf.Output, iteration_counter tf.Output, output_types []tf.DataType, output_shapes []tf.Shape, optional ...DataServiceDatasetAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DataServiceDataset",
		Input: []tf.Input{
			dataset_id, processing_mode, address, protocol, job_name, max_outstanding_requests, iteration_counter,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DataServiceDatasetV2Attr is an optional argument to DataServiceDatasetV2.
type DataServiceDatasetV2Attr func(optionalAttr)

// DataServiceDatasetV2TaskRefreshIntervalHintMs sets the optional task_refresh_interval_hint_ms attribute to value.
// If not specified, defaults to -1
func DataServiceDatasetV2TaskRefreshIntervalHintMs(value int64) DataServiceDatasetV2Attr {
	return func(m optionalAttr) {
		m["task_refresh_interval_hint_ms"] = value
	}
}

// DataServiceDatasetV2DataTransferProtocol sets the optional data_transfer_protocol attribute to value.
// If not specified, defaults to ""
func DataServiceDatasetV2DataTransferProtocol(value string) DataServiceDatasetV2Attr {
	return func(m optionalAttr) {
		m["data_transfer_protocol"] = value
	}
}

// DataServiceDatasetV2TargetWorkers sets the optional target_workers attribute to value.
// If not specified, defaults to "AUTO"
func DataServiceDatasetV2TargetWorkers(value string) DataServiceDatasetV2Attr {
	return func(m optionalAttr) {
		m["target_workers"] = value
	}
}

// DataServiceDatasetV2CrossTrainerCacheOptions sets the optional cross_trainer_cache_options attribute to value.
// If not specified, defaults to ""
func DataServiceDatasetV2CrossTrainerCacheOptions(value string) DataServiceDatasetV2Attr {
	return func(m optionalAttr) {
		m["cross_trainer_cache_options"] = value
	}
}

// Creates a dataset that reads data from the tf.data service.
func DataServiceDatasetV2(scope *Scope, dataset_id tf.Output, processing_mode tf.Output, address tf.Output, protocol tf.Output, job_name tf.Output, consumer_index tf.Output, num_consumers tf.Output, max_outstanding_requests tf.Output, iteration_counter tf.Output, output_types []tf.DataType, output_shapes []tf.Shape, optional ...DataServiceDatasetV2Attr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DataServiceDatasetV2",
		Input: []tf.Input{
			dataset_id, processing_mode, address, protocol, job_name, consumer_index, num_consumers, max_outstanding_requests, iteration_counter,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DatasetCardinalityAttr is an optional argument to DatasetCardinality.
type DatasetCardinalityAttr func(optionalAttr)

// DatasetCardinalityCardinalityOptions sets the optional cardinality_options attribute to value.
// If not specified, defaults to ""
func DatasetCardinalityCardinalityOptions(value string) DatasetCardinalityAttr {
	return func(m optionalAttr) {
		m["cardinality_options"] = value
	}
}

// Returns the cardinality of `input_dataset`.
//
// Returns the cardinality of `input_dataset`.
//
// Arguments:
//
//	input_dataset: A variant tensor representing the dataset to return cardinality for.
//
// Returns The cardinality of `input_dataset`. Named constants are used to represent
// infinite and unknown cardinality.
func DatasetCardinality(scope *Scope, input_dataset tf.Output, optional ...DatasetCardinalityAttr) (cardinality tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DatasetCardinality",
		Input: []tf.Input{
			input_dataset,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the fingerprint of `input_dataset`.
//
// Returns the fingerprint of `input_dataset`.
//
// Arguments:
//
//	input_dataset: A variant tensor representing the dataset to return fingerprint for.
//
// Returns The fingerprint of `input_dataset` in `uint64`
func DatasetFingerprint(scope *Scope, input_dataset tf.Output) (fingerprint tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "DatasetFingerprint",
		Input: []tf.Input{
			input_dataset,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates a dataset from the given `graph_def`.
//
// Creates a dataset from the provided `graph_def`.
//
// Arguments:
//
//	graph_def: The graph representation of the dataset (as serialized GraphDef).
//
// Returns A variant tensor representing the dataset.
func DatasetFromGraph(scope *Scope, graph_def tf.Output) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "DatasetFromGraph",
		Input: []tf.Input{
			graph_def,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DatasetToGraphAttr is an optional argument to DatasetToGraph.
type DatasetToGraphAttr func(optionalAttr)

// DatasetToGraphStatefulWhitelist sets the optional stateful_whitelist attribute to value.
// If not specified, defaults to {}
//
// REQUIRES: len(value) >= 0
func DatasetToGraphStatefulWhitelist(value []string) DatasetToGraphAttr {
	return func(m optionalAttr) {
		m["stateful_whitelist"] = value
	}
}

// DatasetToGraphAllowStateful sets the optional allow_stateful attribute to value.
// If not specified, defaults to false
func DatasetToGraphAllowStateful(value bool) DatasetToGraphAttr {
	return func(m optionalAttr) {
		m["allow_stateful"] = value
	}
}

// DatasetToGraphStripDeviceAssignment sets the optional strip_device_assignment attribute to value.
// If not specified, defaults to false
func DatasetToGraphStripDeviceAssignment(value bool) DatasetToGraphAttr {
	return func(m optionalAttr) {
		m["strip_device_assignment"] = value
	}
}

// Returns a serialized GraphDef representing `input_dataset`.
//
// Returns a graph representation for `input_dataset`.
//
// Arguments:
//
//	input_dataset: A variant tensor representing the dataset to return the graph representation for.
//
// Returns The graph representation of the dataset (as serialized GraphDef).
func DatasetToGraph(scope *Scope, input_dataset tf.Output, optional ...DatasetToGraphAttr) (graph tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DatasetToGraph",
		Input: []tf.Input{
			input_dataset,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DatasetToGraphV2Attr is an optional argument to DatasetToGraphV2.
type DatasetToGraphV2Attr func(optionalAttr)

// DatasetToGraphV2ExternalStatePolicy sets the optional external_state_policy attribute to value.
// If not specified, defaults to 0
func DatasetToGraphV2ExternalStatePolicy(value int64) DatasetToGraphV2Attr {
	return func(m optionalAttr) {
		m["external_state_policy"] = value
	}
}

// DatasetToGraphV2StripDeviceAssignment sets the optional strip_device_assignment attribute to value.
// If not specified, defaults to false
func DatasetToGraphV2StripDeviceAssignment(value bool) DatasetToGraphV2Attr {
	return func(m optionalAttr) {
		m["strip_device_assignment"] = value
	}
}

// Returns a serialized GraphDef representing `input_dataset`.
//
// Returns a graph representation for `input_dataset`.
//
// Arguments:
//
//	input_dataset: A variant tensor representing the dataset to return the graph representation for.
//
// Returns The graph representation of the dataset (as serialized GraphDef).
func DatasetToGraphV2(scope *Scope, input_dataset tf.Output, optional ...DatasetToGraphV2Attr) (graph tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DatasetToGraphV2",
		Input: []tf.Input{
			input_dataset,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DatasetToSingleElementAttr is an optional argument to DatasetToSingleElement.
type DatasetToSingleElementAttr func(optionalAttr)

// DatasetToSingleElementMetadata sets the optional metadata attribute to value.
// If not specified, defaults to ""
func DatasetToSingleElementMetadata(value string) DatasetToSingleElementAttr {
	return func(m optionalAttr) {
		m["metadata"] = value
	}
}

// Outputs the single element from the given dataset.
//
// Arguments:
//
//	dataset: A handle to a dataset that contains a single element.
//
// Returns The components of the single element of `input`.
func DatasetToSingleElement(scope *Scope, dataset tf.Output, output_types []tf.DataType, output_shapes []tf.Shape, optional ...DatasetToSingleElementAttr) (components []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DatasetToSingleElement",
		Input: []tf.Input{
			dataset,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if components, idx, err = makeOutputList(op, idx, "components"); err != nil {
		scope.UpdateErr("DatasetToSingleElement", err)
		return
	}
	return components
}

// Writes the given dataset to the given file using the TFRecord format.
//
// Arguments:
//
//	input_dataset: A variant tensor representing the dataset to write.
//	filename: A scalar string tensor representing the filename to use.
//	compression_type: A scalar string tensor containing either (i) the empty string (no
//
// compression), (ii) "ZLIB", or (iii) "GZIP".
//
// Returns the created operation.
func DatasetToTFRecord(scope *Scope, input_dataset tf.Output, filename tf.Output, compression_type tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "DatasetToTFRecord",
		Input: []tf.Input{
			input_dataset, filename, compression_type,
		},
	}
	return scope.AddOperation(opspec)
}

// Identity op for gradient debugging.
//
// This op is hidden from public in Python. It is used by TensorFlow Debugger to
// register gradient tensors for gradient debugging.
// This op operates on non-reference-type tensors.
func DebugGradientIdentity(scope *Scope, input tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "DebugGradientIdentity",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DebugIdentityAttr is an optional argument to DebugIdentity.
type DebugIdentityAttr func(optionalAttr)

// DebugIdentityDeviceName sets the optional device_name attribute to value.
//
// value: Name of the device on which the tensor resides.
// If not specified, defaults to ""
func DebugIdentityDeviceName(value string) DebugIdentityAttr {
	return func(m optionalAttr) {
		m["device_name"] = value
	}
}

// DebugIdentityTensorName sets the optional tensor_name attribute to value.
//
// value: Name of the input tensor.
// If not specified, defaults to ""
func DebugIdentityTensorName(value string) DebugIdentityAttr {
	return func(m optionalAttr) {
		m["tensor_name"] = value
	}
}

// DebugIdentityDebugUrls sets the optional debug_urls attribute to value.
//
// value: List of URLs to debug targets, e.g.,
//
//	file:///foo/tfdbg_dump, grpc:://localhost:11011
//
// If not specified, defaults to {}
func DebugIdentityDebugUrls(value []string) DebugIdentityAttr {
	return func(m optionalAttr) {
		m["debug_urls"] = value
	}
}

// DebugIdentityGatedGrpc sets the optional gated_grpc attribute to value.
//
// value: Whether this op will be gated. If any of the debug_urls of this
//
//	debug node is of the grpc:// scheme, when the value of this attribute is set
//	to True, the data will not actually be sent via the grpc stream unless this
//	debug op has been enabled at the debug_url. If all of the debug_urls of this
//	debug node are of the grpc:// scheme and the debug op is enabled at none of
//	them, the output will be an empty Tensor.
//
// If not specified, defaults to false
func DebugIdentityGatedGrpc(value bool) DebugIdentityAttr {
	return func(m optionalAttr) {
		m["gated_grpc"] = value
	}
}

// Provides an identity mapping of the non-Ref type input tensor for debugging.
//
// Provides an identity mapping of the non-Ref type input tensor for debugging.
//
// Arguments:
//
//	input: Input tensor, non-Reference type
func DebugIdentity(scope *Scope, input tf.Output, optional ...DebugIdentityAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DebugIdentity",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DebugIdentityV2Attr is an optional argument to DebugIdentityV2.
type DebugIdentityV2Attr func(optionalAttr)

// DebugIdentityV2TfdbgContextId sets the optional tfdbg_context_id attribute to value.
//
// value: A tfdbg-generated ID for the context that the op belongs to,
//
//	e.g., a concrete compiled tf.function.
//
// If not specified, defaults to ""
func DebugIdentityV2TfdbgContextId(value string) DebugIdentityV2Attr {
	return func(m optionalAttr) {
		m["tfdbg_context_id"] = value
	}
}

// DebugIdentityV2OpName sets the optional op_name attribute to value.
//
// value: Optional. Name of the op that the debug op is concerned with.
//
//	Used only for single-tensor trace.
//
// If not specified, defaults to ""
func DebugIdentityV2OpName(value string) DebugIdentityV2Attr {
	return func(m optionalAttr) {
		m["op_name"] = value
	}
}

// DebugIdentityV2OutputSlot sets the optional output_slot attribute to value.
//
// value: Optional. Output slot index of the tensor that the debug op
//
//	is concerned with. Used only for single-tensor trace.
//
// If not specified, defaults to -1
func DebugIdentityV2OutputSlot(value int64) DebugIdentityV2Attr {
	return func(m optionalAttr) {
		m["output_slot"] = value
	}
}

// DebugIdentityV2TensorDebugMode sets the optional tensor_debug_mode attribute to value.
//
// value: TensorDebugMode enum value. See debug_event.proto for details.
// If not specified, defaults to -1
func DebugIdentityV2TensorDebugMode(value int64) DebugIdentityV2Attr {
	return func(m optionalAttr) {
		m["tensor_debug_mode"] = value
	}
}

// DebugIdentityV2DebugUrls sets the optional debug_urls attribute to value.
//
// value: List of URLs to debug targets, e.g., file:///foo/tfdbg_dump.
// If not specified, defaults to {}
func DebugIdentityV2DebugUrls(value []string) DebugIdentityV2Attr {
	return func(m optionalAttr) {
		m["debug_urls"] = value
	}
}

// DebugIdentityV2CircularBufferSize sets the optional circular_buffer_size attribute to value.
// If not specified, defaults to 1000
func DebugIdentityV2CircularBufferSize(value int64) DebugIdentityV2Attr {
	return func(m optionalAttr) {
		m["circular_buffer_size"] = value
	}
}

// DebugIdentityV2TfdbgRunId sets the optional tfdbg_run_id attribute to value.
// If not specified, defaults to ""
func DebugIdentityV2TfdbgRunId(value string) DebugIdentityV2Attr {
	return func(m optionalAttr) {
		m["tfdbg_run_id"] = value
	}
}

// Debug Identity V2 Op.
//
// Provides an identity mapping from input to output, while writing the content of
// the input tensor by calling DebugEventsWriter.
//
// The semantics of the input tensor depends on tensor_debug_mode. In typical
// usage, the input tensor comes directly from the user computation only when
// graph_debug_mode is FULL_TENSOR (see protobuf/debug_event.proto for a
// list of all the possible values of graph_debug_mode). For the other debug modes,
// the input tensor should be produced by an additional op or subgraph that
// computes summary information about one or more tensors.
//
// Arguments:
//
//	input: Input tensor, non-Reference type
func DebugIdentityV2(scope *Scope, input tf.Output, optional ...DebugIdentityV2Attr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DebugIdentityV2",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DebugIdentityV3Attr is an optional argument to DebugIdentityV3.
type DebugIdentityV3Attr func(optionalAttr)

// DebugIdentityV3DeviceName sets the optional device_name attribute to value.
//
// value: Name of the device on which the tensor resides.
// If not specified, defaults to ""
func DebugIdentityV3DeviceName(value string) DebugIdentityV3Attr {
	return func(m optionalAttr) {
		m["device_name"] = value
	}
}

// DebugIdentityV3TensorName sets the optional tensor_name attribute to value.
//
// value: Name of the input tensor.
// If not specified, defaults to ""
func DebugIdentityV3TensorName(value string) DebugIdentityV3Attr {
	return func(m optionalAttr) {
		m["tensor_name"] = value
	}
}

// DebugIdentityV3IoOfNode sets the optional io_of_node attribute to value.
//
// value: Name of the node of which the tensor is an input or output.
// If not specified, defaults to ""
func DebugIdentityV3IoOfNode(value string) DebugIdentityV3Attr {
	return func(m optionalAttr) {
		m["io_of_node"] = value
	}
}

// DebugIdentityV3IsInput sets the optional is_input attribute to value.
//
// value: If true, the tensor is an input of the node; otherwise the output.
// If not specified, defaults to false
func DebugIdentityV3IsInput(value bool) DebugIdentityV3Attr {
	return func(m optionalAttr) {
		m["is_input"] = value
	}
}

// DebugIdentityV3IoIndex sets the optional io_index attribute to value.
//
// value: The index of which the tensor is an input or output of the node.
// If not specified, defaults to -1
func DebugIdentityV3IoIndex(value int64) DebugIdentityV3Attr {
	return func(m optionalAttr) {
		m["io_index"] = value
	}
}

// DebugIdentityV3DebugUrls sets the optional debug_urls attribute to value.
//
// value: List of URLs to debug targets, e.g.,
//
//	file:///foo/tfdbg_dump, grpc:://localhost:11011
//
// If not specified, defaults to {}
func DebugIdentityV3DebugUrls(value []string) DebugIdentityV3Attr {
	return func(m optionalAttr) {
		m["debug_urls"] = value
	}
}

// DebugIdentityV3GatedGrpc sets the optional gated_grpc attribute to value.
//
// value: Whether this op will be gated. If any of the debug_urls of this
//
//	debug node is of the grpc:// scheme, when the value of this attribute is set
//	to True, the data will not actually be sent via the grpc stream unless this
//	debug op has been enabled at the debug_url. If all of the debug_urls of this
//	debug node are of the grpc:// scheme and the debug op is enabled at none of
//	them, the output will be an empty Tensor.
//
// If not specified, defaults to false
func DebugIdentityV3GatedGrpc(value bool) DebugIdentityV3Attr {
	return func(m optionalAttr) {
		m["gated_grpc"] = value
	}
}

// Provides an identity mapping of the non-Ref type input tensor for debugging.
//
// Provides an identity mapping of the non-Ref type input tensor for debugging.
//
// Arguments:
//
//	input: Input tensor, non-Reference type
func DebugIdentityV3(scope *Scope, input tf.Output, optional ...DebugIdentityV3Attr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DebugIdentityV3",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DebugNanCountAttr is an optional argument to DebugNanCount.
type DebugNanCountAttr func(optionalAttr)

// DebugNanCountDeviceName sets the optional device_name attribute to value.
// If not specified, defaults to ""
func DebugNanCountDeviceName(value string) DebugNanCountAttr {
	return func(m optionalAttr) {
		m["device_name"] = value
	}
}

// DebugNanCountTensorName sets the optional tensor_name attribute to value.
//
// value: Name of the input tensor.
// If not specified, defaults to ""
func DebugNanCountTensorName(value string) DebugNanCountAttr {
	return func(m optionalAttr) {
		m["tensor_name"] = value
	}
}

// DebugNanCountDebugUrls sets the optional debug_urls attribute to value.
//
// value: List of URLs to debug targets, e.g.,
//
//	file:///foo/tfdbg_dump, grpc:://localhost:11011.
//
// If not specified, defaults to {}
func DebugNanCountDebugUrls(value []string) DebugNanCountAttr {
	return func(m optionalAttr) {
		m["debug_urls"] = value
	}
}

// DebugNanCountGatedGrpc sets the optional gated_grpc attribute to value.
//
// value:  Whether this op will be gated. If any of the debug_urls of this
//
//	debug node is of the grpc:// scheme, when the value of this attribute is set
//	to True, the data will not actually be sent via the grpc stream unless this
//	debug op has been enabled at the debug_url. If all of the debug_urls of this
//	debug node are of the grpc:// scheme and the debug op is enabled at none of
//	them, the output will be an empty Tensor.
//
// If not specified, defaults to false
func DebugNanCountGatedGrpc(value bool) DebugNanCountAttr {
	return func(m optionalAttr) {
		m["gated_grpc"] = value
	}
}

// Debug NaN Value Counter Op.
//
// Counts number of NaNs in the input tensor, for debugging.
//
// Arguments:
//
//	input: Input tensor, non-Reference type.
func DebugNanCount(scope *Scope, input tf.Output, optional ...DebugNanCountAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DebugNanCount",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DebugNumericSummaryAttr is an optional argument to DebugNumericSummary.
type DebugNumericSummaryAttr func(optionalAttr)

// DebugNumericSummaryDeviceName sets the optional device_name attribute to value.
// If not specified, defaults to ""
func DebugNumericSummaryDeviceName(value string) DebugNumericSummaryAttr {
	return func(m optionalAttr) {
		m["device_name"] = value
	}
}

// DebugNumericSummaryTensorName sets the optional tensor_name attribute to value.
//
// value: Name of the input tensor.
// If not specified, defaults to ""
func DebugNumericSummaryTensorName(value string) DebugNumericSummaryAttr {
	return func(m optionalAttr) {
		m["tensor_name"] = value
	}
}

// DebugNumericSummaryDebugUrls sets the optional debug_urls attribute to value.
//
// value: List of URLs to debug targets, e.g.,
//
//	file:///foo/tfdbg_dump, grpc:://localhost:11011.
//
// If not specified, defaults to {}
func DebugNumericSummaryDebugUrls(value []string) DebugNumericSummaryAttr {
	return func(m optionalAttr) {
		m["debug_urls"] = value
	}
}

// DebugNumericSummaryLowerBound sets the optional lower_bound attribute to value.
//
// value: (float) The lower bound <= which values will be included in the
//
//	generalized -inf count. Default: -inf.
//
// If not specified, defaults to -inf
func DebugNumericSummaryLowerBound(value float32) DebugNumericSummaryAttr {
	return func(m optionalAttr) {
		m["lower_bound"] = value
	}
}

// DebugNumericSummaryUpperBound sets the optional upper_bound attribute to value.
//
// value: (float) The upper bound >= which values will be included in the
//
//	generalized +inf count. Default: +inf.
//
// If not specified, defaults to inf
func DebugNumericSummaryUpperBound(value float32) DebugNumericSummaryAttr {
	return func(m optionalAttr) {
		m["upper_bound"] = value
	}
}

// DebugNumericSummaryMuteIfHealthy sets the optional mute_if_healthy attribute to value.
//
// value: (bool) Do not send data to the debug URLs unless at least one
//
//	of elements [2], [3] and [7] (i.e., the nan count and the generalized -inf and
//	inf counts) is non-zero.
//
// If not specified, defaults to false
func DebugNumericSummaryMuteIfHealthy(value bool) DebugNumericSummaryAttr {
	return func(m optionalAttr) {
		m["mute_if_healthy"] = value
	}
}

// DebugNumericSummaryGatedGrpc sets the optional gated_grpc attribute to value.
//
// value: Whether this op will be gated. If any of the debug_urls of this
//
//	debug node is of the grpc:// scheme, when the value of this attribute is set
//	to True, the data will not actually be sent via the grpc stream unless this
//	debug op has been enabled at the debug_url. If all of the debug_urls of this
//	debug node are of the grpc:// scheme and the debug op is enabled at none of
//	them, the output will be an empty Tensor.
//
// If not specified, defaults to false
func DebugNumericSummaryGatedGrpc(value bool) DebugNumericSummaryAttr {
	return func(m optionalAttr) {
		m["gated_grpc"] = value
	}
}

// Debug Numeric Summary Op.
//
// Provide a basic summary of numeric value types, range and distribution.
//
// output: A double tensor of shape [14 + nDimensions], where nDimensions is the
//
//	number of dimensions of the tensor's shape. The elements of output are:
//	[0]: is initialized (1.0) or not (0.0).
//	[1]: total number of elements
//	[2]: NaN element count
//	[3]: generalized -inf count: elements <= lower_bound. lower_bound is -inf by
//	  default.
//	[4]: negative element count (excluding -inf), if lower_bound is the default
//	  -inf. Otherwise, this is the count of elements > lower_bound and < 0.
//	[5]: zero element count
//	[6]: positive element count (excluding +inf), if upper_bound is the default
//	  +inf. Otherwise, this is the count of elements < upper_bound and > 0.
//	[7]: generalized +inf count, elements >= upper_bound. upper_bound is +inf by
//	  default.
//
// Output elements [1:8] are all zero, if the tensor is uninitialized.
//
//	[8]: minimum of all non-inf and non-NaN elements.
//	     If uninitialized or no such element exists: +inf.
//	[9]: maximum of all non-inf and non-NaN elements.
//	     If uninitialized or no such element exists: -inf.
//	[10]: mean of all non-inf and non-NaN elements.
//	      If uninitialized or no such element exists: NaN.
//	[11]: variance of all non-inf and non-NaN elements.
//	      If uninitialized or no such element exists: NaN.
//	[12]: Data type of the tensor encoded as an enum integer. See the DataType
//	      proto for more details.
//	[13]: Number of dimensions of the tensor (ndims).
//	[14+]: Sizes of the dimensions.
//
// Arguments:
//
//	input: Input tensor, non-Reference type.
func DebugNumericSummary(scope *Scope, input tf.Output, optional ...DebugNumericSummaryAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DebugNumericSummary",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DebugNumericSummaryV2Attr is an optional argument to DebugNumericSummaryV2.
type DebugNumericSummaryV2Attr func(optionalAttr)

// DebugNumericSummaryV2OutputDtype sets the optional output_dtype attribute to value.
//
// value: Optional. The type of the output. Can be float32 or float64 (default: float32).
// If not specified, defaults to DT_FLOAT
func DebugNumericSummaryV2OutputDtype(value tf.DataType) DebugNumericSummaryV2Attr {
	return func(m optionalAttr) {
		m["output_dtype"] = value
	}
}

// DebugNumericSummaryV2TensorDebugMode sets the optional tensor_debug_mode attribute to value.
//
// value: Tensor debug mode: the mode in which the input tensor is summarized
//
//	by the op. See the TensorDebugMode enum in
//	tensorflow/core/protobuf/debug_event.proto for details.
//
// Supported values:
//
//	2 (CURT_HEALTH): Output a float32/64 tensor of shape [2]. The 1st
//	element is the tensor_id, if provided, and -1 otherwise. The 2nd
//	element is a bit which is set to 1 if the input tensor has an
//	infinity or nan value, or zero otherwise.
//
//	3 (CONCISE_HEALTH): Output a float32/64 tensor of shape [5]. The 1st
//	element is the tensor_id, if provided, and -1 otherwise. The
//	remaining four slots are the total number of elements, -infs,
//	+infs, and nans in the input tensor respectively.
//
//	4 (FULL_HEALTH): Output a float32/64 tensor of shape [11]. The 1st
//	element is the tensor_id, if provided, and -1 otherwise. The 2nd
//	element is the device_id, if provided, and -1 otherwise. The 3rd
//	element holds the datatype value of the input tensor as according
//	to the enumerated type in tensorflow/core/framework/types.proto.
//	The remaining elements hold the total number of elements, -infs,
//	+infs, nans, negative finite numbers, zeros, and positive finite
//	numbers in the input tensor respectively.
//
//	5 (SHAPE): Output a float32/64 tensor of shape [10]. The 1st
//	element is the tensor_id, if provided, and -1 otherwise. The 2nd
//	element holds the datatype value of the input tensor as according
//	to the enumerated type in tensorflow/core/framework/types.proto.
//	The 3rd element holds the rank of the tensor. The 4th element holds
//	the number of elements within the tensor. Finally the remaining 6
//	elements hold the shape of the tensor. If the rank of the tensor
//	is lower than 6, the shape is right padded with zeros. If the rank
//	is greater than 6, the head of the shape is truncated.
//
//	6 (FULL_NUMERICS): Output a float32/64 tensor of shape [22]. The 1st
//	element is the tensor_id, if provided, and -1 otherwise. The 2nd
//	element is the device_id, if provided, and -1 otherwise. The 3rd
//	element holds the datatype value of the input tensor as according
//	to the enumerated type in tensorflow/core/framework/types.proto.
//	The 4th element holds the rank of the tensor. The 5th to 11th
//	elements hold the shape of the tensor. If the rank of the tensor
//	is lower than 6, the shape is right padded with zeros. If the rank
//	is greater than 6, the head of the shape is truncated. The 12th to
//	18th elements hold the number of elements, -infs, +infs, nans,
//	denormal floats, negative finite numbers, zeros, and positive
//	finite numbers in the input tensor respectively. The final four
//	elements hold the min value, max value, mean, and variance of the
//	input tensor.
//
//	8 (REDUCE_INF_NAN_THREE_SLOTS): Output a float32/64 tensor of shape
//	[3]. The 1st element is -inf if any elements of the input tensor
//	is -inf, or zero otherwise. The 2nd element is +inf if any elements
//	of the input tensor is +inf, or zero otherwise.  The 3rd element is
//	nan if any element of the input tensor is nan, or zero otherwise.
//
// If not specified, defaults to -1
func DebugNumericSummaryV2TensorDebugMode(value int64) DebugNumericSummaryV2Attr {
	return func(m optionalAttr) {
		m["tensor_debug_mode"] = value
	}
}

// DebugNumericSummaryV2TensorId sets the optional tensor_id attribute to value.
//
// value: Optional. An integer identifier for the tensor being summarized by this op.
// If not specified, defaults to -1
func DebugNumericSummaryV2TensorId(value int64) DebugNumericSummaryV2Attr {
	return func(m optionalAttr) {
		m["tensor_id"] = value
	}
}

// Debug Numeric Summary V2 Op.
//
// Computes a numeric summary of the input tensor. The shape of the output
// depends on the tensor_debug_mode attribute.
// This op is used internally by TensorFlow Debugger (tfdbg) v2.
//
// Arguments:
//
//	input: Input tensor, to be summarized by the op.
func DebugNumericSummaryV2(scope *Scope, input tf.Output, optional ...DebugNumericSummaryV2Attr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DebugNumericSummaryV2",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DecodeAndCropJpegAttr is an optional argument to DecodeAndCropJpeg.
type DecodeAndCropJpegAttr func(optionalAttr)

// DecodeAndCropJpegChannels sets the optional channels attribute to value.
//
// value: Number of color channels for the decoded image.
// If not specified, defaults to 0
func DecodeAndCropJpegChannels(value int64) DecodeAndCropJpegAttr {
	return func(m optionalAttr) {
		m["channels"] = value
	}
}

// DecodeAndCropJpegRatio sets the optional ratio attribute to value.
//
// value: Downscaling ratio.
// If not specified, defaults to 1
func DecodeAndCropJpegRatio(value int64) DecodeAndCropJpegAttr {
	return func(m optionalAttr) {
		m["ratio"] = value
	}
}

// DecodeAndCropJpegFancyUpscaling sets the optional fancy_upscaling attribute to value.
//
// value: If true use a slower but nicer upscaling of the
// chroma planes (yuv420/422 only).
// If not specified, defaults to true
func DecodeAndCropJpegFancyUpscaling(value bool) DecodeAndCropJpegAttr {
	return func(m optionalAttr) {
		m["fancy_upscaling"] = value
	}
}

// DecodeAndCropJpegTryRecoverTruncated sets the optional try_recover_truncated attribute to value.
//
// value: If true try to recover an image from truncated input.
// If not specified, defaults to false
func DecodeAndCropJpegTryRecoverTruncated(value bool) DecodeAndCropJpegAttr {
	return func(m optionalAttr) {
		m["try_recover_truncated"] = value
	}
}

// DecodeAndCropJpegAcceptableFraction sets the optional acceptable_fraction attribute to value.
//
// value: The minimum required fraction of lines before a truncated
// input is accepted.
// If not specified, defaults to 1
func DecodeAndCropJpegAcceptableFraction(value float32) DecodeAndCropJpegAttr {
	return func(m optionalAttr) {
		m["acceptable_fraction"] = value
	}
}

// DecodeAndCropJpegDctMethod sets the optional dct_method attribute to value.
//
// value: string specifying a hint about the algorithm used for
// decompression.  Defaults to "" which maps to a system-specific
// default.  Currently valid values are ["INTEGER_FAST",
// "INTEGER_ACCURATE"].  The hint may be ignored (e.g., the internal
// jpeg library changes to a version that does not have that specific
// option.)
// If not specified, defaults to ""
func DecodeAndCropJpegDctMethod(value string) DecodeAndCropJpegAttr {
	return func(m optionalAttr) {
		m["dct_method"] = value
	}
}

// Decode and Crop a JPEG-encoded image to a uint8 tensor.
//
// The attr `channels` indicates the desired number of color channels for the
// decoded image.
//
// Accepted values are:
//
// *   0: Use the number of channels in the JPEG-encoded image.
// *   1: output a grayscale image.
// *   3: output an RGB image.
//
// If needed, the JPEG-encoded image is transformed to match the requested number
// of color channels.
//
// The attr `ratio` allows downscaling the image by an integer factor during
// decoding.  Allowed values are: 1, 2, 4, and 8.  This is much faster than
// downscaling the image later.
//
// It is equivalent to a combination of decode and crop, but much faster by only
// decoding partial jpeg image.
//
// Arguments:
//
//	contents: 0-D.  The JPEG-encoded image.
//	crop_window: 1-D.  The crop window: [crop_y, crop_x, crop_height, crop_width].
//
// Returns 3-D with shape `[height, width, channels]`..
func DecodeAndCropJpeg(scope *Scope, contents tf.Output, crop_window tf.Output, optional ...DecodeAndCropJpegAttr) (image tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DecodeAndCropJpeg",
		Input: []tf.Input{
			contents, crop_window,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Decode web-safe base64-encoded strings.
//
// Input may or may not have padding at the end. See
// [EncodeBase64](https://www.tensorflow.org/api_docs/python/tf/io/encode_base64)
// for padding. Web-safe means that input must use - and _ instead of + and /.
//
// Arguments:
//
//	input: Base64 strings to decode.
//
// Returns Decoded strings.
func DecodeBase64(scope *Scope, input tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "DecodeBase64",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DecodeBmpAttr is an optional argument to DecodeBmp.
type DecodeBmpAttr func(optionalAttr)

// DecodeBmpChannels sets the optional channels attribute to value.
// If not specified, defaults to 0
func DecodeBmpChannels(value int64) DecodeBmpAttr {
	return func(m optionalAttr) {
		m["channels"] = value
	}
}

// Decode the first frame of a BMP-encoded image to a uint8 tensor.
//
// The attr `channels` indicates the desired number of color channels for the
// decoded image.
//
// Accepted values are:
//
// *   0: Use the number of channels in the BMP-encoded image.
// *   3: output an RGB image.
// *   4: output an RGBA image.
//
// Arguments:
//
//	contents: 0-D.  The BMP-encoded image.
//
// Returns 3-D with shape `[height, width, channels]`. RGB order
func DecodeBmp(scope *Scope, contents tf.Output, optional ...DecodeBmpAttr) (image tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DecodeBmp",
		Input: []tf.Input{
			contents,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DecodeCSVAttr is an optional argument to DecodeCSV.
type DecodeCSVAttr func(optionalAttr)

// DecodeCSVFieldDelim sets the optional field_delim attribute to value.
//
// value: char delimiter to separate fields in a record.
// If not specified, defaults to ","
func DecodeCSVFieldDelim(value string) DecodeCSVAttr {
	return func(m optionalAttr) {
		m["field_delim"] = value
	}
}

// DecodeCSVUseQuoteDelim sets the optional use_quote_delim attribute to value.
//
// value: If false, treats double quotation marks as regular
// characters inside of the string fields (ignoring RFC 4180, Section 2,
// Bullet 5).
// If not specified, defaults to true
func DecodeCSVUseQuoteDelim(value bool) DecodeCSVAttr {
	return func(m optionalAttr) {
		m["use_quote_delim"] = value
	}
}

// DecodeCSVNaValue sets the optional na_value attribute to value.
//
// value: Additional string to recognize as NA/NaN.
// If not specified, defaults to ""
func DecodeCSVNaValue(value string) DecodeCSVAttr {
	return func(m optionalAttr) {
		m["na_value"] = value
	}
}

// DecodeCSVSelectCols sets the optional select_cols attribute to value.
//
// value: Optional sorted list of column indices to select. If specified,
// only this subset of columns will be parsed and returned.
// It only works on `records` except for `record_defaults`.
// If not specified, defaults to {}
func DecodeCSVSelectCols(value []int64) DecodeCSVAttr {
	return func(m optionalAttr) {
		m["select_cols"] = value
	}
}

// Convert CSV records to tensors. Each column maps to one tensor.
//
// RFC 4180 format is expected for the CSV records.
// (https://tools.ietf.org/html/rfc4180)
// Note that we allow leading and trailing spaces with int or float field.
//
// Arguments:
//
//	records: Each string is a record/row in the csv and all records should have
//
// the same format.
//
//	record_defaults: One tensor per column of the input record, with either a
//
// scalar default value for that column or an empty vector if the column is
// required.
//
// Returns Each tensor will have the same shape as records.
func DecodeCSV(scope *Scope, records tf.Output, record_defaults []tf.Output, optional ...DecodeCSVAttr) (output []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DecodeCSV",
		Input: []tf.Input{
			records, tf.OutputList(record_defaults),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if output, idx, err = makeOutputList(op, idx, "output"); err != nil {
		scope.UpdateErr("DecodeCSV", err)
		return
	}
	return output
}

// DecodeCompressedAttr is an optional argument to DecodeCompressed.
type DecodeCompressedAttr func(optionalAttr)

// DecodeCompressedCompressionType sets the optional compression_type attribute to value.
//
// value: A scalar containing either (i) the empty string (no
// compression), (ii) "ZLIB", or (iii) "GZIP".
// If not specified, defaults to ""
func DecodeCompressedCompressionType(value string) DecodeCompressedAttr {
	return func(m optionalAttr) {
		m["compression_type"] = value
	}
}

// Decompress strings.
//
// This op decompresses each element of the `bytes` input `Tensor`, which
// is assumed to be compressed using the given `compression_type`.
//
// The `output` is a string `Tensor` of the same shape as `bytes`,
// each element containing the decompressed data from the corresponding
// element in `bytes`.
//
// Arguments:
//
//	bytes: A Tensor of string which is compressed.
//
// Returns A Tensor with the same shape as input `bytes`, uncompressed
// from bytes.
func DecodeCompressed(scope *Scope, bytes tf.Output, optional ...DecodeCompressedAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DecodeCompressed",
		Input: []tf.Input{
			bytes,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Decode the frame(s) of a GIF-encoded image to a uint8 tensor.
//
// GIF images with frame or transparency compression are not supported.
// On Linux and MacOS systems, convert animated GIFs from compressed to
// uncompressed by running:
//
//	convert $src.gif -coalesce $dst.gif
//
// This op also supports decoding JPEGs and PNGs, though it is cleaner to use
// `tf.io.decode_image`.
//
// Arguments:
//
//	contents: 0-D.  The GIF-encoded image.
//
// Returns 4-D with shape `[num_frames, height, width, 3]`. RGB channel order.
func DecodeGif(scope *Scope, contents tf.Output) (image tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "DecodeGif",
		Input: []tf.Input{
			contents,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DecodeImageAttr is an optional argument to DecodeImage.
type DecodeImageAttr func(optionalAttr)

// DecodeImageChannels sets the optional channels attribute to value.
//
// value: Number of color channels for the decoded image.
// If not specified, defaults to 0
func DecodeImageChannels(value int64) DecodeImageAttr {
	return func(m optionalAttr) {
		m["channels"] = value
	}
}

// DecodeImageDtype sets the optional dtype attribute to value.
//
// value: The desired DType of the returned Tensor.
// If not specified, defaults to DT_UINT8
func DecodeImageDtype(value tf.DataType) DecodeImageAttr {
	return func(m optionalAttr) {
		m["dtype"] = value
	}
}

// DecodeImageExpandAnimations sets the optional expand_animations attribute to value.
//
// value: Controls the output shape of the returned op. If True, the returned op
// will produce a 3-D tensor for PNG, JPEG, and BMP files; and a 4-D
// tensor for all GIFs and WebP images, whether animated or not. If,
// False, the returned op will produce a 3-D tensor for all file types
// and will truncate animated images to the first frame.
// If not specified, defaults to true
func DecodeImageExpandAnimations(value bool) DecodeImageAttr {
	return func(m optionalAttr) {
		m["expand_animations"] = value
	}
}

// Function for decode_bmp, decode_gif, decode_jpeg, decode_webp, and decode_png.
//
// Detects whether an image is a BMP, GIF, JPEG, WebP, or PNG, and performs the
// appropriate operation to convert the input bytes string into a Tensor of type
// dtype.
//
// *NOTE*: decode_gif and decode_webp return a 4-D
// array [num_frames, height, width, 3], as opposed to decode_bmp,
// decode_jpeg, and decode_png, which always return 3-D arrays [height,
// width, num_channels]. Make sure to take this into account when
// constructing your graph if you are intermixing animated files with
// BMP, JPEG, and/or PNG files. Alternately, set the expand_animations
// argument of this function to False, in which case the op will return
// 3-dimensional tensors and will truncate animations to the first frame.
//
// *NOTE*: If the first frame of an animated GIF does not occupy the entire
// canvas (maximum frame width x maximum frame height), then it fills the
// unoccupied areas (in the first frame) with zeros (black). For frames after the
// first frame that does not occupy the entire canvas, it uses the previous
// frame to fill the unoccupied areas.
//
// Arguments:
//
//	contents: 0-D. The encoded image bytes.
//
// Returns 3-D with shape `[height, width, channels]` or 4-D with shape
// `[frame, height, width, channels]`..
func DecodeImage(scope *Scope, contents tf.Output, optional ...DecodeImageAttr) (image tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DecodeImage",
		Input: []tf.Input{
			contents,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Convert JSON-encoded Example records to binary protocol buffer strings.
//
// Note: This is **not** a general purpose JSON parsing op.
//
// This op converts JSON-serialized
// `tf.train.Example` (created with `json_format.MessageToJson`, following the
// [standard JSON mapping](https://developers.google.com/protocol-buffers/docs/proto3#json))
// to a binary-serialized `tf.train.Example` (equivalent to
// `Example.SerializeToString()`) suitable for conversion to tensors with
// `tf.io.parse_example`.
//
// Arguments:
//
//	json_examples: Each string is a JSON object serialized according to the JSON
//
// mapping of the Example proto.
//
// Returns Each string is a binary Example protocol buffer corresponding
// to the respective element of `json_examples`.
func DecodeJSONExample(scope *Scope, json_examples tf.Output) (binary_examples tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "DecodeJSONExample",
		Input: []tf.Input{
			json_examples,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DecodeJpegAttr is an optional argument to DecodeJpeg.
type DecodeJpegAttr func(optionalAttr)

// DecodeJpegChannels sets the optional channels attribute to value.
//
// value: Number of color channels for the decoded image.
// If not specified, defaults to 0
func DecodeJpegChannels(value int64) DecodeJpegAttr {
	return func(m optionalAttr) {
		m["channels"] = value
	}
}

// DecodeJpegRatio sets the optional ratio attribute to value.
//
// value: Downscaling ratio.
// If not specified, defaults to 1
func DecodeJpegRatio(value int64) DecodeJpegAttr {
	return func(m optionalAttr) {
		m["ratio"] = value
	}
}

// DecodeJpegFancyUpscaling sets the optional fancy_upscaling attribute to value.
//
// value: If true use a slower but nicer upscaling of the
// chroma planes (yuv420/422 only).
// If not specified, defaults to true
func DecodeJpegFancyUpscaling(value bool) DecodeJpegAttr {
	return func(m optionalAttr) {
		m["fancy_upscaling"] = value
	}
}

// DecodeJpegTryRecoverTruncated sets the optional try_recover_truncated attribute to value.
//
// value: If true try to recover an image from truncated input.
// If not specified, defaults to false
func DecodeJpegTryRecoverTruncated(value bool) DecodeJpegAttr {
	return func(m optionalAttr) {
		m["try_recover_truncated"] = value
	}
}

// DecodeJpegAcceptableFraction sets the optional acceptable_fraction attribute to value.
//
// value: The minimum required fraction of lines before a truncated
// input is accepted.
// If not specified, defaults to 1
func DecodeJpegAcceptableFraction(value float32) DecodeJpegAttr {
	return func(m optionalAttr) {
		m["acceptable_fraction"] = value
	}
}

// DecodeJpegDctMethod sets the optional dct_method attribute to value.
//
// value: string specifying a hint about the algorithm used for
// decompression.  Defaults to "" which maps to a system-specific
// default.  Currently valid values are ["INTEGER_FAST",
// "INTEGER_ACCURATE"].  The hint may be ignored (e.g., the internal
// jpeg library changes to a version that does not have that specific
// option.)
// If not specified, defaults to ""
func DecodeJpegDctMethod(value string) DecodeJpegAttr {
	return func(m optionalAttr) {
		m["dct_method"] = value
	}
}

// Decode a JPEG-encoded image to a uint8 tensor.
//
// The attr `channels` indicates the desired number of color channels for the
// decoded image.
//
// Accepted values are:
//
// *   0: Use the number of channels in the JPEG-encoded image.
// *   1: output a grayscale image.
// *   3: output an RGB image.
//
// If needed, the JPEG-encoded image is transformed to match the requested number
// of color channels.
//
// The attr `ratio` allows downscaling the image by an integer factor during
// decoding.  Allowed values are: 1, 2, 4, and 8.  This is much faster than
// downscaling the image later.
//
// This op also supports decoding PNGs and non-animated GIFs since the interface is
// the same, though it is cleaner to use `tf.io.decode_image`.
//
// Arguments:
//
//	contents: 0-D.  The JPEG-encoded image.
//
// Returns 3-D with shape `[height, width, channels]`..
func DecodeJpeg(scope *Scope, contents tf.Output, optional ...DecodeJpegAttr) (image tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DecodeJpeg",
		Input: []tf.Input{
			contents,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DecodePaddedRawAttr is an optional argument to DecodePaddedRaw.
type DecodePaddedRawAttr func(optionalAttr)

// DecodePaddedRawLittleEndian sets the optional little_endian attribute to value.
//
// value: Whether the input `input_bytes` is in little-endian order. Ignored for
// `out_type` values that are stored in a single byte, like `uint8`
// If not specified, defaults to true
func DecodePaddedRawLittleEndian(value bool) DecodePaddedRawAttr {
	return func(m optionalAttr) {
		m["little_endian"] = value
	}
}

// Reinterpret the bytes of a string as a vector of numbers.
//
// Arguments:
//
//	input_bytes: Tensor of string to be decoded.
//	fixed_length: Length in bytes for each element of the decoded output. Must be a multiple
//
// of the size of the output type.
//
// Returns A Tensor with one more dimension than the input `bytes`. The added dimension
// will have size equal to the length of the elements of `bytes` divided by the
// number of bytes to represent `out_type`.
func DecodePaddedRaw(scope *Scope, input_bytes tf.Output, fixed_length tf.Output, out_type tf.DataType, optional ...DecodePaddedRawAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"out_type": out_type}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DecodePaddedRaw",
		Input: []tf.Input{
			input_bytes, fixed_length,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DecodePngAttr is an optional argument to DecodePng.
type DecodePngAttr func(optionalAttr)

// DecodePngChannels sets the optional channels attribute to value.
//
// value: Number of color channels for the decoded image.
// If not specified, defaults to 0
func DecodePngChannels(value int64) DecodePngAttr {
	return func(m optionalAttr) {
		m["channels"] = value
	}
}

// DecodePngDtype sets the optional dtype attribute to value.
// If not specified, defaults to DT_UINT8
func DecodePngDtype(value tf.DataType) DecodePngAttr {
	return func(m optionalAttr) {
		m["dtype"] = value
	}
}

// Decode a PNG-encoded image to a uint8 or uint16 tensor.
//
// The attr `channels` indicates the desired number of color channels for the
// decoded image.
//
// Accepted values are:
//
// *   0: Use the number of channels in the PNG-encoded image.
// *   1: output a grayscale image.
// *   3: output an RGB image.
// *   4: output an RGBA image.
//
// If needed, the PNG-encoded image is transformed to match the requested number
// of color channels.
//
// This op also supports decoding JPEGs and non-animated GIFs since the interface
// is the same, though it is cleaner to use `tf.io.decode_image`.
//
// Arguments:
//
//	contents: 0-D.  The PNG-encoded image.
//
// Returns 3-D with shape `[height, width, channels]`.
func DecodePng(scope *Scope, contents tf.Output, optional ...DecodePngAttr) (image tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DecodePng",
		Input: []tf.Input{
			contents,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DecodeProtoV2Attr is an optional argument to DecodeProtoV2.
type DecodeProtoV2Attr func(optionalAttr)

// DecodeProtoV2DescriptorSource sets the optional descriptor_source attribute to value.
//
// value: Either the special value `local://` or a path to a file containing
// a serialized `FileDescriptorSet`.
// If not specified, defaults to "local://"
func DecodeProtoV2DescriptorSource(value string) DecodeProtoV2Attr {
	return func(m optionalAttr) {
		m["descriptor_source"] = value
	}
}

// DecodeProtoV2MessageFormat sets the optional message_format attribute to value.
//
// value: Either `binary` or `text`.
// If not specified, defaults to "binary"
func DecodeProtoV2MessageFormat(value string) DecodeProtoV2Attr {
	return func(m optionalAttr) {
		m["message_format"] = value
	}
}

// DecodeProtoV2Sanitize sets the optional sanitize attribute to value.
//
// value: Whether to sanitize the result or not.
// If not specified, defaults to false
func DecodeProtoV2Sanitize(value bool) DecodeProtoV2Attr {
	return func(m optionalAttr) {
		m["sanitize"] = value
	}
}

// The op extracts fields from a serialized protocol buffers message into tensors.
//
// Note: This API is designed for orthogonality rather than human-friendliness. It
// can be used to parse input protos by hand, but it is intended for use in
// generated code.
//
// The `decode_proto` op extracts fields from a serialized protocol buffers
// message into tensors.  The fields in `field_names` are decoded and converted
// to the corresponding `output_types` if possible.
//
// A `message_type` name must be provided to give context for the field names.
// The actual message descriptor can be looked up either in the linked-in
// descriptor pool or a filename provided by the caller using the
// `descriptor_source` attribute.
//
// Each output tensor is a dense tensor. This means that it is padded to hold
// the largest number of repeated elements seen in the input minibatch. (The
// shape is also padded by one to prevent zero-sized dimensions). The actual
// repeat counts for each example in the minibatch can be found in the `sizes`
// output. In many cases the output of `decode_proto` is fed immediately into
// tf.squeeze if missing values are not a concern. When using tf.squeeze, always
// pass the squeeze dimension explicitly to avoid surprises.
//
// For the most part, the mapping between Proto field types and TensorFlow dtypes
// is straightforward. However, there are a few special cases:
//
// - A proto field that contains a submessage or group can only be converted
// to `DT_STRING` (the serialized submessage). This is to reduce the complexity
// of the API. The resulting string can be used as input to another instance of
// the decode_proto op.
//
// - TensorFlow lacks support for unsigned integers. The ops represent uint64
// types as a `DT_INT64` with the same twos-complement bit pattern (the obvious
// way). Unsigned int32 values can be represented exactly by specifying type
// `DT_INT64`, or using twos-complement if the caller specifies `DT_INT32` in
// the `output_types` attribute.
//
// - `map` fields are not directly decoded. They are treated as `repeated` fields,
// of the appropriate entry type. The proto-compiler defines entry types for each
// map field. The type-name is the field name, converted to "CamelCase" with
// "Entry" appended. The `tf.train.Features.FeatureEntry` message is an example of
// one of these implicit `Entry` types.
//
// - `enum` fields should be read as int32.
//
// Both binary and text proto serializations are supported, and can be
// chosen using the `format` attribute.
//
// The `descriptor_source` attribute selects the source of protocol
// descriptors to consult when looking up `message_type`. This may be:
//
// - An empty string  or "local://", in which case protocol descriptors are
// created for C++ (not Python) proto definitions linked to the binary.
//
// - A file, in which case protocol descriptors are created from the file,
// which is expected to contain a `FileDescriptorSet` serialized as a string.
// NOTE: You can build a `descriptor_source` file using the `--descriptor_set_out`
// and `--include_imports` options to the protocol compiler `protoc`.
//
// - A "bytes://<bytes>", in which protocol descriptors are created from `<bytes>`,
// which is expected to be a `FileDescriptorSet` serialized as a string.
//
// Arguments:
//
//	bytes: Tensor of serialized protos with shape `batch_shape`.
//	message_type: Name of the proto message type to decode.
//	field_names: List of strings containing proto field names. An extension field can be decoded
//
// by using its full name, e.g. EXT_PACKAGE.EXT_FIELD_NAME.
//
//	output_types: List of TF types to use for the respective field in field_names.
//
// Returns:
//
//	sizes: Tensor of int32 with shape `[batch_shape, len(field_names)]`.
//
// Each entry is the number of values found for the corresponding field.
// Optional fields may have 0 or 1 values.
//
//	values: List of tensors containing values for the corresponding field.
//
// `values[i]` has datatype `output_types[i]`
// and shape `[batch_shape, max(sizes[...,i])]`.
func DecodeProtoV2(scope *Scope, bytes tf.Output, message_type string, field_names []string, output_types []tf.DataType, optional ...DecodeProtoV2Attr) (sizes tf.Output, values []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"message_type": message_type, "field_names": field_names, "output_types": output_types}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DecodeProtoV2",
		Input: []tf.Input{
			bytes,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	sizes = op.Output(idx)
	if values, idx, err = makeOutputList(op, idx, "values"); err != nil {
		scope.UpdateErr("DecodeProtoV2", err)
		return
	}
	return sizes, values
}

// DecodeRawAttr is an optional argument to DecodeRaw.
type DecodeRawAttr func(optionalAttr)

// DecodeRawLittleEndian sets the optional little_endian attribute to value.
//
// value: Whether the input `bytes` are in little-endian order.
// Ignored for `out_type` values that are stored in a single byte like
// `uint8`.
// If not specified, defaults to true
func DecodeRawLittleEndian(value bool) DecodeRawAttr {
	return func(m optionalAttr) {
		m["little_endian"] = value
	}
}

// Reinterpret the bytes of a string as a vector of numbers.
//
// Arguments:
//
//	bytes: All the elements must have the same length.
//
// Returns A Tensor with one more dimension than the input `bytes`.  The
// added dimension will have size equal to the length of the elements
// of `bytes` divided by the number of bytes to represent `out_type`.
func DecodeRaw(scope *Scope, bytes tf.Output, out_type tf.DataType, optional ...DecodeRawAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"out_type": out_type}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DecodeRaw",
		Input: []tf.Input{
			bytes,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DecodeWavAttr is an optional argument to DecodeWav.
type DecodeWavAttr func(optionalAttr)

// DecodeWavDesiredChannels sets the optional desired_channels attribute to value.
//
// value: Number of sample channels wanted.
// If not specified, defaults to -1
func DecodeWavDesiredChannels(value int64) DecodeWavAttr {
	return func(m optionalAttr) {
		m["desired_channels"] = value
	}
}

// DecodeWavDesiredSamples sets the optional desired_samples attribute to value.
//
// value: Length of audio requested.
// If not specified, defaults to -1
func DecodeWavDesiredSamples(value int64) DecodeWavAttr {
	return func(m optionalAttr) {
		m["desired_samples"] = value
	}
}

// Decode a 16-bit PCM WAV file to a float tensor.
//
// The -32768 to 32767 signed 16-bit values will be scaled to -1.0 to 1.0 in float.
//
// When desired_channels is set, if the input contains fewer channels than this
// then the last channel will be duplicated to give the requested number, else if
// the input has more channels than requested then the additional channels will be
// ignored.
//
// If desired_samples is set, then the audio will be cropped or padded with zeroes
// to the requested length.
//
// The first output contains a Tensor with the content of the audio samples. The
// lowest dimension will be the number of channels, and the second will be the
// number of samples. For example, a ten-sample-long stereo WAV file should give an
// output shape of [10, 2].
//
// Arguments:
//
//	contents: The WAV-encoded audio, usually from a file.
//
// Returns:
//
//	audio: 2-D with shape `[length, channels]`.
//	sample_rate: Scalar holding the sample rate found in the WAV header.
func DecodeWav(scope *Scope, contents tf.Output, optional ...DecodeWavAttr) (audio tf.Output, sample_rate tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DecodeWav",
		Input: []tf.Input{
			contents,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// DecodeWebPAttr is an optional argument to DecodeWebP.
type DecodeWebPAttr func(optionalAttr)

// DecodeWebPChannels sets the optional channels attribute to value.
//
// value: Number of color channels for the decoded image.
// If not specified, defaults to 0
func DecodeWebPChannels(value int64) DecodeWebPAttr {
	return func(m optionalAttr) {
		m["channels"] = value
	}
}

// DecodeWebPDtype sets the optional dtype attribute to value.
// If not specified, defaults to DT_UINT8
func DecodeWebPDtype(value tf.DataType) DecodeWebPAttr {
	return func(m optionalAttr) {
		m["dtype"] = value
	}
}

// Decode a WebP-encoded image to a uint8 tensor.
//
// The attr `channels` indicates the desired number of color channels for the
// decoded image.
//
// Accepted values are:
//
// *   0: Use the number of channels in the WebP-encoded image.
// *   3: output an RGB image.
// *   4: output an RGBA image.
//
// The number of channels must currently match that of the underlying file.
// For WebP animations, only 4-channel RGBA is supported.
//
// Arguments:
//
//	contents: 0-D.  The WebP-encoded image.
//
// Returns 4-D with shape `[num_frames, height, width, channels]`.
func DecodeWebP(scope *Scope, contents tf.Output, optional ...DecodeWebPAttr) (image tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DecodeWebP",
		Input: []tf.Input{
			contents,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Makes a copy of `x`.
//
// Arguments:
//
//	x: The source tensor of type `T`.
//
// Returns     y: A `Tensor` of type `T`. A copy of `x`. Guaranteed that `y`
//
//	is not an alias of `x`.
func DeepCopy(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "DeepCopy",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// A container for an iterator resource.
//
// Arguments:
//
//	handle: A handle to the iterator to delete.
//	deleter: A variant deleter.
//
// Returns the created operation.
func DeleteIterator(scope *Scope, handle tf.Output, deleter tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "DeleteIterator",
		Input: []tf.Input{
			handle, deleter,
		},
	}
	return scope.AddOperation(opspec)
}

// A container for an iterator resource.
//
// Arguments:
//
//	multi_device_iterator: A handle to the multi device iterator to delete.
//	iterators: A list of iterator handles (unused). This is added so that automatic control dependencies get added during function tracing that ensure this op runs after all the dependent iterators are deleted.
//	deleter: A variant deleter.
//
// Returns the created operation.
func DeleteMultiDeviceIterator(scope *Scope, multi_device_iterator tf.Output, iterators []tf.Output, deleter tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "DeleteMultiDeviceIterator",
		Input: []tf.Input{
			multi_device_iterator, tf.OutputList(iterators), deleter,
		},
	}
	return scope.AddOperation(opspec)
}

// Delete the tensor specified by its handle in the session.
//
// Arguments:
//
//	handle: The handle for a tensor stored in the session state.
//
// Returns the created operation.
func DeleteSessionTensor(scope *Scope, handle tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "DeleteSessionTensor",
		Input: []tf.Input{
			handle,
		},
	}
	return scope.AddOperation(opspec)
}

// DenseBincountAttr is an optional argument to DenseBincount.
type DenseBincountAttr func(optionalAttr)

// DenseBincountBinaryOutput sets the optional binary_output attribute to value.
//
// value: Whether the kernel should count the appearance or number of occurrences.
// Will raise `UnimplementedError` when `binary_output` is specified to `True`
// and the size of `weights` is not 0.
// If not specified, defaults to false
func DenseBincountBinaryOutput(value bool) DenseBincountAttr {
	return func(m optionalAttr) {
		m["binary_output"] = value
	}
}

// Counts the number of occurrences of each value in an integer array.
//
// Outputs a vector with length `size` and the same dtype as `weights`. If
// `weights` are empty, then index `i` stores the number of times the value `i` is
// counted in `arr`. If `weights` are non-empty, then index `i` stores the sum of
// the value in `weights` at each index where the corresponding value in `arr` is
// `i`.
//
// Values in `arr` outside of the range [0, size) are ignored.
//
// Arguments:
//
//	input: 1D or 2D int `Tensor`.
//	size: non-negative int scalar `Tensor`.
//	weights: `Tensor` with the same shape as `arr`, or a length-0 `Tensor`,
//
// in which case it acts as all weights equal to 1.
// Not supported by the GPU implementation of Bincount.
//
// Returns 1D `Tensor` with length equal to `size` or 2D `Tensor` with [batch_size, `size`].
// The counts or summed weights for each value in the range [0, size).
func DenseBincount(scope *Scope, input tf.Output, size tf.Output, weights tf.Output, optional ...DenseBincountAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DenseBincount",
		Input: []tf.Input{
			input, size, weights,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DenseCountSparseOutputAttr is an optional argument to DenseCountSparseOutput.
type DenseCountSparseOutputAttr func(optionalAttr)

// DenseCountSparseOutputMinlength sets the optional minlength attribute to value.
//
// value: Minimum value to count. Can be set to -1 for no minimum.
// If not specified, defaults to -1
//
// REQUIRES: value >= -1
func DenseCountSparseOutputMinlength(value int64) DenseCountSparseOutputAttr {
	return func(m optionalAttr) {
		m["minlength"] = value
	}
}

// DenseCountSparseOutputMaxlength sets the optional maxlength attribute to value.
//
// value: Maximum value to count. Can be set to -1 for no maximum.
// If not specified, defaults to -1
//
// REQUIRES: value >= -1
func DenseCountSparseOutputMaxlength(value int64) DenseCountSparseOutputAttr {
	return func(m optionalAttr) {
		m["maxlength"] = value
	}
}

// Performs sparse-output bin counting for a tf.tensor input.
//
//	Counts the number of times each value occurs in the input.
//
// Arguments:
//
//	values: Tensor containing data to count.
//	weights: A Tensor of the same shape as indices containing per-index weight values. May
//
// also be the empty tensor if no weights are used.
//
//	binary_output: Whether to output the number of occurrences of each value or 1.
//
// Returns:
//
//	output_indices: Indices tensor for the resulting sparse tensor object.
//	output_values: Values tensor for the resulting sparse tensor object.
//	output_dense_shape: Shape tensor for the resulting sparse tensor object.
func DenseCountSparseOutput(scope *Scope, values tf.Output, weights tf.Output, binary_output bool, optional ...DenseCountSparseOutputAttr) (output_indices tf.Output, output_values tf.Output, output_dense_shape tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"binary_output": binary_output}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DenseCountSparseOutput",
		Input: []tf.Input{
			values, weights,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// Converts a dense tensor to a (possibly batched) CSRSparseMatrix.
//
// Arguments:
//
//	dense_input: A Dense tensor.
//	indices: Indices of nonzero elements.
//
// Returns A (possibly batched) CSRSparseMatrix.
func DenseToCSRSparseMatrix(scope *Scope, dense_input tf.Output, indices tf.Output) (sparse_output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "DenseToCSRSparseMatrix",
		Input: []tf.Input{
			dense_input, indices,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DenseToDenseSetOperationAttr is an optional argument to DenseToDenseSetOperation.
type DenseToDenseSetOperationAttr func(optionalAttr)

// DenseToDenseSetOperationValidateIndices sets the optional validate_indices attribute to value.
// If not specified, defaults to true
func DenseToDenseSetOperationValidateIndices(value bool) DenseToDenseSetOperationAttr {
	return func(m optionalAttr) {
		m["validate_indices"] = value
	}
}

// Applies set operation along last dimension of 2 `Tensor` inputs.
//
// See SetOperationOp::SetOperationFromContext for values of `set_operation`.
//
// Output `result` is a `SparseTensor` represented by `result_indices`,
// `result_values`, and `result_shape`. For `set1` and `set2` ranked `n`, this
// has rank `n` and the same 1st `n-1` dimensions as `set1` and `set2`. The `nth`
// dimension contains the result of `set_operation` applied to the corresponding
// `[0...n-1]` dimension of `set`.
//
// Arguments:
//
//	set1: `Tensor` with rank `n`. 1st `n-1` dimensions must be the same as `set2`.
//
// Dimension `n` contains values in a set, duplicates are allowed but ignored.
//
//	set2: `Tensor` with rank `n`. 1st `n-1` dimensions must be the same as `set1`.
//
// Dimension `n` contains values in a set, duplicates are allowed but ignored.
//
// Returns:
//
//	result_indices: 2D indices of a `SparseTensor`.
//	result_values: 1D values of a `SparseTensor`.
//	result_shape: 1D `Tensor` shape of a `SparseTensor`. `result_shape[0...n-1]` is
//
// the same as the 1st `n-1` dimensions of `set1` and `set2`, `result_shape[n]`
// is the max result set size across all `0...n-1` dimensions.
func DenseToDenseSetOperation(scope *Scope, set1 tf.Output, set2 tf.Output, set_operation string, optional ...DenseToDenseSetOperationAttr) (result_indices tf.Output, result_values tf.Output, result_shape tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"set_operation": set_operation}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DenseToDenseSetOperation",
		Input: []tf.Input{
			set1, set2,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// Creates a dataset that batches input elements into a SparseTensor.
//
// Arguments:
//
//	input_dataset: A handle to an input dataset. Must have a single component.
//	batch_size: A scalar representing the number of elements to accumulate in a
//
// batch.
//
//	row_shape: A vector representing the dense shape of each row in the produced
//
// SparseTensor. The shape may be partially specified, using `-1` to indicate
// that a particular dimension should use the maximum size of all batch elements.
func DenseToSparseBatchDataset(scope *Scope, input_dataset tf.Output, batch_size tf.Output, row_shape tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "DenseToSparseBatchDataset",
		Input: []tf.Input{
			input_dataset, batch_size, row_shape,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DenseToSparseSetOperationAttr is an optional argument to DenseToSparseSetOperation.
type DenseToSparseSetOperationAttr func(optionalAttr)

// DenseToSparseSetOperationValidateIndices sets the optional validate_indices attribute to value.
// If not specified, defaults to true
func DenseToSparseSetOperationValidateIndices(value bool) DenseToSparseSetOperationAttr {
	return func(m optionalAttr) {
		m["validate_indices"] = value
	}
}

// Applies set operation along last dimension of `Tensor` and `SparseTensor`.
//
// See SetOperationOp::SetOperationFromContext for values of `set_operation`.
//
// Input `set2` is a `SparseTensor` represented by `set2_indices`, `set2_values`,
// and `set2_shape`. For `set2` ranked `n`, 1st `n-1` dimensions must be the same
// as `set1`. Dimension `n` contains values in a set, duplicates are allowed but
// ignored.
//
// If `validate_indices` is `True`, this op validates the order and range of `set2`
// indices.
//
// Output `result` is a `SparseTensor` represented by `result_indices`,
// `result_values`, and `result_shape`. For `set1` and `set2` ranked `n`, this
// has rank `n` and the same 1st `n-1` dimensions as `set1` and `set2`. The `nth`
// dimension contains the result of `set_operation` applied to the corresponding
// `[0...n-1]` dimension of `set`.
//
// Arguments:
//
//	set1: `Tensor` with rank `n`. 1st `n-1` dimensions must be the same as `set2`.
//
// Dimension `n` contains values in a set, duplicates are allowed but ignored.
//
//	set2_indices: 2D `Tensor`, indices of a `SparseTensor`. Must be in row-major
//
// order.
//
//	set2_values: 1D `Tensor`, values of a `SparseTensor`. Must be in row-major
//
// order.
//
//	set2_shape: 1D `Tensor`, shape of a `SparseTensor`. `set2_shape[0...n-1]` must
//
// be the same as the 1st `n-1` dimensions of `set1`, `result_shape[n]` is the
// max set size across `n-1` dimensions.
//
// Returns:
//
//	result_indices: 2D indices of a `SparseTensor`.
//	result_values: 1D values of a `SparseTensor`.
//	result_shape: 1D `Tensor` shape of a `SparseTensor`. `result_shape[0...n-1]` is
//
// the same as the 1st `n-1` dimensions of `set1` and `set2`, `result_shape[n]`
// is the max result set size across all `0...n-1` dimensions.
func DenseToSparseSetOperation(scope *Scope, set1 tf.Output, set2_indices tf.Output, set2_values tf.Output, set2_shape tf.Output, set_operation string, optional ...DenseToSparseSetOperationAttr) (result_indices tf.Output, result_values tf.Output, result_shape tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"set_operation": set_operation}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DenseToSparseSetOperation",
		Input: []tf.Input{
			set1, set2_indices, set2_values, set2_shape,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// DepthToSpaceAttr is an optional argument to DepthToSpace.
type DepthToSpaceAttr func(optionalAttr)

// DepthToSpaceDataFormat sets the optional data_format attribute to value.
// If not specified, defaults to "NHWC"
func DepthToSpaceDataFormat(value string) DepthToSpaceAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// DepthToSpace for tensors of type T.
//
// Rearranges data from depth into blocks of spatial data.
// This is the reverse transformation of SpaceToDepth. More specifically,
// this op outputs a copy of the input tensor where values from the `depth`
// dimension are moved in spatial blocks to the `height` and `width` dimensions.
// The attr `block_size` indicates the input block size and how the data is moved.
//
//   - Chunks of data of size `block_size * block_size` from depth are rearranged
//     into non-overlapping blocks of size `block_size x block_size`
//   - The width of the output tensor is `input_depth * block_size`, whereas the
//     height is `input_height * block_size`.
//   - The Y, X coordinates within each block of the output image are determined
//     by the high order component of the input channel index.
//   - The depth of the input tensor must be divisible by
//     `block_size * block_size`.
//
// The `data_format` attr specifies the layout of the input and output tensors
// with the following options:
//
//	"NHWC": `[ batch, height, width, channels ]`
//	"NCHW": `[ batch, channels, height, width ]`
//	"NCHW_VECT_C":
//	    `qint8 [ batch, channels / 4, height, width, 4 ]`
//
// It is useful to consider the operation as transforming a 6-D Tensor.
// e.g. for data_format = NHWC,
//
//	Each element in the input tensor can be specified via 6 coordinates,
//	ordered by decreasing memory layout significance as:
//	n,iY,iX,bY,bX,oC  (where n=batch index, iX, iY means X or Y coordinates
//	                   within the input image, bX, bY means coordinates
//	                   within the output block, oC means output channels).
//	The output would be the input transposed to the following layout:
//	n,iY,bY,iX,bX,oC
//
// This operation is useful for resizing the activations between convolutions
// (but keeping all data), e.g. instead of pooling. It is also useful for training
// purely convolutional models.
//
// For example, given an input of shape `[1, 1, 1, 4]`, data_format = "NHWC" and
// block_size = 2:
//
// ```
// x = [[[[1, 2, 3, 4]]]]
//
// ```
//
// This operation will output a tensor of shape `[1, 2, 2, 1]`:
//
// ```
//
//	[[[[1], [2]],
//	  [[3], [4]]]]
//
// ```
//
// Here, the input has a batch of 1 and each batch element has shape `[1, 1, 4]`,
// the corresponding output will have 2x2 elements and will have a depth of
// 1 channel (1 = `4 / (block_size * block_size)`).
// The output element shape is `[2, 2, 1]`.
//
// For an input tensor with larger depth, here of shape `[1, 1, 1, 12]`, e.g.
//
// ```
// x = [[[[1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12]]]]
// ```
//
// This operation, for block size of 2, will return the following tensor of shape
// `[1, 2, 2, 3]`
//
// ```
//
//	[[[[1, 2, 3], [4, 5, 6]],
//	  [[7, 8, 9], [10, 11, 12]]]]
//
// ```
//
// Similarly, for the following input of shape `[1 2 2 4]`, and a block size of 2:
//
// ```
// x =  [[[[1, 2, 3, 4],
//
//	 [5, 6, 7, 8]],
//	[[9, 10, 11, 12],
//	 [13, 14, 15, 16]]]]
//
// ```
//
// the operator will return the following tensor of shape `[1 4 4 1]`:
//
// ```
// x = [[[ [1],   [2],  [5],  [6]],
//
//	[ [3],   [4],  [7],  [8]],
//	[ [9],  [10], [13],  [14]],
//	[ [11], [12], [15],  [16]]]]
//
// ```
//
// Arguments:
//
//	block_size: The size of the spatial block, same as in Space2Depth.
func DepthToSpace(scope *Scope, input tf.Output, block_size int64, optional ...DepthToSpaceAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"block_size": block_size}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DepthToSpace",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DepthwiseConv2dNativeAttr is an optional argument to DepthwiseConv2dNative.
type DepthwiseConv2dNativeAttr func(optionalAttr)

// DepthwiseConv2dNativeExplicitPaddings sets the optional explicit_paddings attribute to value.
// If not specified, defaults to {}
func DepthwiseConv2dNativeExplicitPaddings(value []int64) DepthwiseConv2dNativeAttr {
	return func(m optionalAttr) {
		m["explicit_paddings"] = value
	}
}

// DepthwiseConv2dNativeDataFormat sets the optional data_format attribute to value.
//
// value: Specify the data format of the input and output data. With the
// default format "NHWC", the data is stored in the order of:
//
//	[batch, height, width, channels].
//
// Alternatively, the format could be "NCHW", the data storage order of:
//
//	[batch, channels, height, width].
//
// If not specified, defaults to "NHWC"
func DepthwiseConv2dNativeDataFormat(value string) DepthwiseConv2dNativeAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// DepthwiseConv2dNativeDilations sets the optional dilations attribute to value.
//
// value: 1-D tensor of length 4.  The dilation factor for each dimension of
// `input`. If set to k > 1, there will be k-1 skipped cells between each filter
// element on that dimension. The dimension order is determined by the value of
// `data_format`, see above for details. Dilations in the batch and depth
// dimensions must be 1.
// If not specified, defaults to {i:1 i:1 i:1 i:1}
func DepthwiseConv2dNativeDilations(value []int64) DepthwiseConv2dNativeAttr {
	return func(m optionalAttr) {
		m["dilations"] = value
	}
}

// Computes a 2-D depthwise convolution given 4-D `input` and `filter` tensors.
//
// Given an input tensor of shape `[batch, in_height, in_width, in_channels]`
// and a filter / kernel tensor of shape
// `[filter_height, filter_width, in_channels, channel_multiplier]`, containing
// `in_channels` convolutional filters of depth 1, `depthwise_conv2d` applies
// a different filter to each input channel (expanding from 1 channel to
// `channel_multiplier` channels for each), then concatenates the results
// together. Thus, the output has `in_channels * channel_multiplier` channels.
//
// ```
// for k in 0..in_channels-1
//
//	for q in 0..channel_multiplier-1
//	  output[b, i, j, k * channel_multiplier + q] =
//	    sum_{di, dj} input[b, strides[1] * i + di, strides[2] * j + dj, k] *
//	                      filter[di, dj, k, q]
//
// ```
//
// Must have `strides[0] = strides[3] = 1`.  For the most common case of the same
// horizontal and vertices strides, `strides = [1, stride, stride, 1]`.
//
// Arguments:
//
//	strides: 1-D of length 4.  The stride of the sliding window for each dimension
//
// of `input`.
//
//	padding: The type of padding algorithm to use.
func DepthwiseConv2dNative(scope *Scope, input tf.Output, filter tf.Output, strides []int64, padding string, optional ...DepthwiseConv2dNativeAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DepthwiseConv2dNative",
		Input: []tf.Input{
			input, filter,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DepthwiseConv2dNativeBackpropFilterAttr is an optional argument to DepthwiseConv2dNativeBackpropFilter.
type DepthwiseConv2dNativeBackpropFilterAttr func(optionalAttr)

// DepthwiseConv2dNativeBackpropFilterExplicitPaddings sets the optional explicit_paddings attribute to value.
// If not specified, defaults to {}
func DepthwiseConv2dNativeBackpropFilterExplicitPaddings(value []int64) DepthwiseConv2dNativeBackpropFilterAttr {
	return func(m optionalAttr) {
		m["explicit_paddings"] = value
	}
}

// DepthwiseConv2dNativeBackpropFilterDataFormat sets the optional data_format attribute to value.
//
// value: Specify the data format of the input and output data. With the
// default format "NHWC", the data is stored in the order of:
//
//	[batch, height, width, channels].
//
// Alternatively, the format could be "NCHW", the data storage order of:
//
//	[batch, channels, height, width].
//
// If not specified, defaults to "NHWC"
func DepthwiseConv2dNativeBackpropFilterDataFormat(value string) DepthwiseConv2dNativeBackpropFilterAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// DepthwiseConv2dNativeBackpropFilterDilations sets the optional dilations attribute to value.
//
// value: 1-D tensor of length 4.  The dilation factor for each dimension of
// `input`. If set to k > 1, there will be k-1 skipped cells between each filter
// element on that dimension. The dimension order is determined by the value of
// `data_format`, see above for details. Dilations in the batch and depth
// dimensions must be 1.
// If not specified, defaults to {i:1 i:1 i:1 i:1}
func DepthwiseConv2dNativeBackpropFilterDilations(value []int64) DepthwiseConv2dNativeBackpropFilterAttr {
	return func(m optionalAttr) {
		m["dilations"] = value
	}
}

// Computes the gradients of depthwise convolution with respect to the filter.
//
// Arguments:
//
//	input: 4-D with shape based on `data_format`.  For example, if
//
// `data_format` is 'NHWC' then `input` is a 4-D `[batch, in_height,
// in_width, in_channels]` tensor.
//
//	filter_sizes: An integer vector representing the tensor shape of `filter`,
//
// where `filter` is a 4-D
// `[filter_height, filter_width, in_channels, depthwise_multiplier]` tensor.
//
//	out_backprop: 4-D with shape  based on `data_format`.
//
// For example, if `data_format` is 'NHWC' then
// out_backprop shape is `[batch, out_height, out_width, out_channels]`.
// Gradients w.r.t. the output of the convolution.
//
//	strides: The stride of the sliding window for each dimension of the input
//
// of the convolution.
//
//	padding: The type of padding algorithm to use.
//
// Returns 4-D with shape
// `[filter_height, filter_width, in_channels, out_channels]`.  Gradient w.r.t.
// the `filter` input of the convolution.
func DepthwiseConv2dNativeBackpropFilter(scope *Scope, input tf.Output, filter_sizes tf.Output, out_backprop tf.Output, strides []int64, padding string, optional ...DepthwiseConv2dNativeBackpropFilterAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DepthwiseConv2dNativeBackpropFilter",
		Input: []tf.Input{
			input, filter_sizes, out_backprop,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DepthwiseConv2dNativeBackpropInputAttr is an optional argument to DepthwiseConv2dNativeBackpropInput.
type DepthwiseConv2dNativeBackpropInputAttr func(optionalAttr)

// DepthwiseConv2dNativeBackpropInputExplicitPaddings sets the optional explicit_paddings attribute to value.
// If not specified, defaults to {}
func DepthwiseConv2dNativeBackpropInputExplicitPaddings(value []int64) DepthwiseConv2dNativeBackpropInputAttr {
	return func(m optionalAttr) {
		m["explicit_paddings"] = value
	}
}

// DepthwiseConv2dNativeBackpropInputDataFormat sets the optional data_format attribute to value.
//
// value: Specify the data format of the input and output data. With the
// default format "NHWC", the data is stored in the order of:
//
//	[batch, height, width, channels].
//
// Alternatively, the format could be "NCHW", the data storage order of:
//
//	[batch, channels, height, width].
//
// If not specified, defaults to "NHWC"
func DepthwiseConv2dNativeBackpropInputDataFormat(value string) DepthwiseConv2dNativeBackpropInputAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// DepthwiseConv2dNativeBackpropInputDilations sets the optional dilations attribute to value.
//
// value: 1-D tensor of length 4.  The dilation factor for each dimension of
// `input`. If set to k > 1, there will be k-1 skipped cells between each filter
// element on that dimension. The dimension order is determined by the value of
// `data_format`, see above for details. Dilations in the batch and depth
// dimensions must be 1.
// If not specified, defaults to {i:1 i:1 i:1 i:1}
func DepthwiseConv2dNativeBackpropInputDilations(value []int64) DepthwiseConv2dNativeBackpropInputAttr {
	return func(m optionalAttr) {
		m["dilations"] = value
	}
}

// Computes the gradients of depthwise convolution with respect to the input.
//
// Arguments:
//
//	input_sizes: An integer vector representing the shape of `input`, based
//
// on `data_format`.  For example, if `data_format` is 'NHWC' then
//
//	 `input` is a 4-D `[batch, height, width, channels]` tensor.
//		filter: 4-D with shape
//
// `[filter_height, filter_width, in_channels, depthwise_multiplier]`.
//
//	out_backprop: 4-D with shape  based on `data_format`.
//
// For example, if `data_format` is 'NHWC' then
// out_backprop shape is `[batch, out_height, out_width, out_channels]`.
// Gradients w.r.t. the output of the convolution.
//
//	strides: The stride of the sliding window for each dimension of the input
//
// of the convolution.
//
//	padding: The type of padding algorithm to use.
//
// Returns 4-D with shape according to `data_format`.  For example, if
// `data_format` is 'NHWC', output shape is `[batch, in_height,
// in_width, in_channels]`.  Gradient w.r.t. the input of the
// convolution.
func DepthwiseConv2dNativeBackpropInput(scope *Scope, input_sizes tf.Output, filter tf.Output, out_backprop tf.Output, strides []int64, padding string, optional ...DepthwiseConv2dNativeBackpropInputAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DepthwiseConv2dNativeBackpropInput",
		Input: []tf.Input{
			input_sizes, filter, out_backprop,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DequantizeAttr is an optional argument to Dequantize.
type DequantizeAttr func(optionalAttr)

// DequantizeMode sets the optional mode attribute to value.
// If not specified, defaults to "MIN_COMBINED"
func DequantizeMode(value string) DequantizeAttr {
	return func(m optionalAttr) {
		m["mode"] = value
	}
}

// DequantizeNarrowRange sets the optional narrow_range attribute to value.
// If not specified, defaults to false
func DequantizeNarrowRange(value bool) DequantizeAttr {
	return func(m optionalAttr) {
		m["narrow_range"] = value
	}
}

// DequantizeAxis sets the optional axis attribute to value.
// If not specified, defaults to -1
func DequantizeAxis(value int64) DequantizeAttr {
	return func(m optionalAttr) {
		m["axis"] = value
	}
}

// DequantizeDtype sets the optional dtype attribute to value.
//
// value: Type of the output tensor. Currently Dequantize supports float and bfloat16.
// If 'dtype' is 'bfloat16', it only supports 'MIN_COMBINED' mode.
// If not specified, defaults to DT_FLOAT
func DequantizeDtype(value tf.DataType) DequantizeAttr {
	return func(m optionalAttr) {
		m["dtype"] = value
	}
}

// Dequantize the 'input' tensor into a float or bfloat16 Tensor.
//
// [min_range, max_range] are scalar floats that specify the range for
// the output. The 'mode' attribute controls exactly which calculations are
// used to convert the float values to their quantized equivalents.
//
// In 'MIN_COMBINED' mode, each value of the tensor will undergo the following:
//
// ```
// if T == qint8: in[i] += (range(T) + 1)/ 2.0
// out[i] = min_range + (in[i]* (max_range - min_range) / range(T))
// ```
// here `range(T) = numeric_limits<T>::max() - numeric_limits<T>::min()`
//
// *MIN_COMBINED Mode Example*
//
// If the input comes from a QuantizedRelu6, the output type is
// quint8 (range of 0-255) but the possible range of QuantizedRelu6 is
// 0-6.  The min_range and max_range values are therefore 0.0 and 6.0.
// Dequantize on quint8 will take each value, cast to float, and multiply
// by 6 / 255.
// Note that if quantizedtype is qint8, the operation will additionally add
// each value by 128 prior to casting.
//
// If the mode is 'MIN_FIRST', then this approach is used:
//
// ```c++
// num_discrete_values = 1 << (# of bits in T)
// range_adjust = num_discrete_values / (num_discrete_values - 1)
// range = (range_max - range_min) * range_adjust
// range_scale = range / num_discrete_values
// const double offset_input = static_cast<double>(input) - lowest_quantized;
// result = range_min + ((input - numeric_limits<T>::min()) * range_scale)
// ```
//
// If the mode is `SCALED`, dequantization is performed by multiplying each
// input value by a scaling_factor. (Thus an input of 0 always maps to 0.0).
//
// The scaling_factor is determined from `min_range`, `max_range`, and
// `narrow_range` in a way that is compatible with `QuantizeAndDequantize{V2|V3}`
// and `QuantizeV2`, using the following algorithm:
//
// ```c++
//
//	const int min_expected_T = std::numeric_limits<T>::min() +
//	  (narrow_range ? 1 : 0);
//	const int max_expected_T = std::numeric_limits<T>::max();
//	const float max_expected_T = std::numeric_limits<float>::max();
//
//	const float scale_factor =
//	  (std::numeric_limits<T>::min() == 0) ? (max_range / max_expected_T)
//	                                       : std::max(min_range / min_expected_T,
//	                                                  max_range / max_expected_T);
//
// ```
//
// Arguments:
//
//	min_range: The minimum scalar value possibly produced for the input.
//	max_range: The maximum scalar value possibly produced for the input.
func Dequantize(scope *Scope, input tf.Output, min_range tf.Output, max_range tf.Output, optional ...DequantizeAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Dequantize",
		Input: []tf.Input{
			input, min_range, max_range,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Converts the given variant tensor to an iterator and stores it in the given resource.
//
// Arguments:
//
//	resource_handle: A handle to an iterator resource.
//	serialized: A variant tensor storing the state of the iterator contained in the
//
// resource.
//
// Returns the created operation.
func DeserializeIterator(scope *Scope, resource_handle tf.Output, serialized tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "DeserializeIterator",
		Input: []tf.Input{
			resource_handle, serialized,
		},
	}
	return scope.AddOperation(opspec)
}

// Deserialize and concatenate `SparseTensors` from a serialized minibatch.
//
// The input `serialized_sparse` must be a string matrix of shape `[N x 3]` where
// `N` is the minibatch size and the rows correspond to packed outputs of
// `SerializeSparse`.  The ranks of the original `SparseTensor` objects
// must all match.  When the final `SparseTensor` is created, it has rank one
// higher than the ranks of the incoming `SparseTensor` objects
// (they have been concatenated along a new row dimension).
//
// The output `SparseTensor` object's shape values for all dimensions but the
// first are the max across the input `SparseTensor` objects' shape values
// for the corresponding dimensions.  Its first shape value is `N`, the minibatch
// size.
//
// The input `SparseTensor` objects' indices are assumed ordered in
// standard lexicographic order.  If this is not the case, after this
// step run `SparseReorder` to restore index ordering.
//
// For example, if the serialized input is a `[2 x 3]` matrix representing two
// original `SparseTensor` objects:
//
//	index = [ 0]
//	        [10]
//	        [20]
//	values = [1, 2, 3]
//	shape = [50]
//
// and
//
//	index = [ 2]
//	        [10]
//	values = [4, 5]
//	shape = [30]
//
// then the final deserialized `SparseTensor` will be:
//
//	index = [0  0]
//	        [0 10]
//	        [0 20]
//	        [1  2]
//	        [1 10]
//	values = [1, 2, 3, 4, 5]
//	shape = [2 50]
//
// Arguments:
//
//	serialized_sparse: 2-D, The `N` serialized `SparseTensor` objects.
//
// Must have 3 columns.
//
//	dtype: The `dtype` of the serialized `SparseTensor` objects.
func DeserializeManySparse(scope *Scope, serialized_sparse tf.Output, dtype tf.DataType) (sparse_indices tf.Output, sparse_values tf.Output, sparse_shape tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtype": dtype}
	opspec := tf.OpSpec{
		Type: "DeserializeManySparse",
		Input: []tf.Input{
			serialized_sparse,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// Deserialize `SparseTensor` objects.
//
// The input `serialized_sparse` must have the shape `[?, ?, ..., ?, 3]` where
// the last dimension stores serialized `SparseTensor` objects and the other N
// dimensions (N >= 0) correspond to a batch. The ranks of the original
// `SparseTensor` objects must all match. When the final `SparseTensor` is
// created, its rank is the rank of the incoming `SparseTensor` objects plus N;
// the sparse tensors have been concatenated along new dimensions, one for each
// batch.
//
// The output `SparseTensor` object's shape values for the original dimensions
// are the max across the input `SparseTensor` objects' shape values for the
// corresponding dimensions. The new dimensions match the size of the batch.
//
// The input `SparseTensor` objects' indices are assumed ordered in
// standard lexicographic order.  If this is not the case, after this
// step run `SparseReorder` to restore index ordering.
//
// For example, if the serialized input is a `[2 x 3]` matrix representing two
// original `SparseTensor` objects:
//
//	index = [ 0]
//	        [10]
//	        [20]
//	values = [1, 2, 3]
//	shape = [50]
//
// and
//
//	index = [ 2]
//	        [10]
//	values = [4, 5]
//	shape = [30]
//
// then the final deserialized `SparseTensor` will be:
//
//	index = [0  0]
//	        [0 10]
//	        [0 20]
//	        [1  2]
//	        [1 10]
//	values = [1, 2, 3, 4, 5]
//	shape = [2 50]
//
// Arguments:
//
//	serialized_sparse: The serialized `SparseTensor` objects. The last dimension
//
// must have 3 columns.
//
//	dtype: The `dtype` of the serialized `SparseTensor` objects.
func DeserializeSparse(scope *Scope, serialized_sparse tf.Output, dtype tf.DataType) (sparse_indices tf.Output, sparse_values tf.Output, sparse_shape tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtype": dtype}
	opspec := tf.OpSpec{
		Type: "DeserializeSparse",
		Input: []tf.Input{
			serialized_sparse,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// DestroyResourceOpAttr is an optional argument to DestroyResourceOp.
type DestroyResourceOpAttr func(optionalAttr)

// DestroyResourceOpIgnoreLookupError sets the optional ignore_lookup_error attribute to value.
//
// value: whether to ignore the error when the resource
// doesn't exist.
// If not specified, defaults to true
func DestroyResourceOpIgnoreLookupError(value bool) DestroyResourceOpAttr {
	return func(m optionalAttr) {
		m["ignore_lookup_error"] = value
	}
}

// Deletes the resource specified by the handle.
//
// All subsequent operations using the resource will result in a NotFound
// error status.
//
// Arguments:
//
//	resource: handle to the resource to delete.
//
// Returns the created operation.
func DestroyResourceOp(scope *Scope, resource tf.Output, optional ...DestroyResourceOpAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DestroyResourceOp",
		Input: []tf.Input{
			resource,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// Return the index of device the op runs.
//
// Given a list of device names, this operation returns the index of the device
// this op runs. The length of the list is returned in two cases:
// (1) Device does not exist in the given device list.
// (2) It is in XLA compilation.
func DeviceIndex(scope *Scope, device_names []string) (index tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"device_names": device_names}
	opspec := tf.OpSpec{
		Type: "DeviceIndex",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns a diagonal tensor with a given diagonal values.
//
// Given a `diagonal`, this operation returns a tensor with the `diagonal` and
// everything else padded with zeros. The diagonal is computed as follows:
//
// Assume `diagonal` has dimensions [D1,..., Dk], then the output is a tensor of
// rank 2k with dimensions [D1,..., Dk, D1,..., Dk] where:
//
// `output[i1,..., ik, i1,..., ik] = diagonal[i1, ..., ik]` and 0 everywhere else.
//
// For example:
//
// ```
// # 'diagonal' is [1, 2, 3, 4]
// tf.diag(diagonal) ==> [[1, 0, 0, 0]
//
//	[0, 2, 0, 0]
//	[0, 0, 3, 0]
//	[0, 0, 0, 4]]
//
// ```
//
// Arguments:
//
//	diagonal: Rank k tensor where k is at most 1.
func Diag(scope *Scope, diagonal tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Diag",
		Input: []tf.Input{
			diagonal,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the diagonal part of the tensor.
//
// This operation returns a tensor with the `diagonal` part
// of the `input`. The `diagonal` part is computed as follows:
//
// Assume `input` has dimensions `[D1,..., Dk, D1,..., Dk]`, then the output is a
// tensor of rank `k` with dimensions `[D1,..., Dk]` where:
//
// `diagonal[i1,..., ik] = input[i1, ..., ik, i1,..., ik]`.
//
// For example:
//
// ```
// # 'input' is [[1, 0, 0, 0]
//
//	[0, 2, 0, 0]
//	[0, 0, 3, 0]
//	[0, 0, 0, 4]]
//
// tf.diag_part(input) ==> [1, 2, 3, 4]
// ```
//
// Arguments:
//
//	input: Rank k tensor where k is even and not zero.
//
// Returns The extracted diagonal.
func DiagPart(scope *Scope, input tf.Output) (diagonal tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "DiagPart",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes Psi, the derivative of Lgamma (the log of the absolute value of
//
// `Gamma(x)`), element-wise.
func Digamma(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Digamma",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the grayscale dilation of 4-D `input` and 3-D `filter` tensors.
//
// The `input` tensor has shape `[batch, in_height, in_width, depth]` and the
// `filter` tensor has shape `[filter_height, filter_width, depth]`, i.e., each
// input channel is processed independently of the others with its own structuring
// function. The `output` tensor has shape
// `[batch, out_height, out_width, depth]`. The spatial dimensions of the output
// tensor depend on the `padding` algorithm. We currently only support the default
// "NHWC" `data_format`.
//
// In detail, the grayscale morphological 2-D dilation is the max-sum correlation
// (for consistency with `conv2d`, we use unmirrored filters):
//
//	output[b, y, x, c] =
//	   max_{dy, dx} input[b,
//	                      strides[1] * y + rates[1] * dy,
//	                      strides[2] * x + rates[2] * dx,
//	                      c] +
//	                filter[dy, dx, c]
//
// Max-pooling is a special case when the filter has size equal to the pooling
// kernel size and contains all zeros.
//
// Note on duality: The dilation of `input` by the `filter` is equal to the
// negation of the erosion of `-input` by the reflected `filter`.
//
// Arguments:
//
//	input: 4-D with shape `[batch, in_height, in_width, depth]`.
//	filter: 3-D with shape `[filter_height, filter_width, depth]`.
//	strides: The stride of the sliding window for each dimension of the input
//
// tensor. Must be: `[1, stride_height, stride_width, 1]`.
//
//	rates: The input stride for atrous morphological dilation. Must be:
//
// `[1, rate_height, rate_width, 1]`.
//
//	padding: The type of padding algorithm to use.
//
// Returns 4-D with shape `[batch, out_height, out_width, depth]`.
func Dilation2D(scope *Scope, input tf.Output, filter tf.Output, strides []int64, rates []int64, padding string) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"strides": strides, "rates": rates, "padding": padding}
	opspec := tf.OpSpec{
		Type: "Dilation2D",
		Input: []tf.Input{
			input, filter,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the gradient of morphological 2-D dilation with respect to the filter.
//
// Arguments:
//
//	input: 4-D with shape `[batch, in_height, in_width, depth]`.
//	filter: 3-D with shape `[filter_height, filter_width, depth]`.
//	out_backprop: 4-D with shape `[batch, out_height, out_width, depth]`.
//	strides: 1-D of length 4. The stride of the sliding window for each dimension of
//
// the input tensor. Must be: `[1, stride_height, stride_width, 1]`.
//
//	rates: 1-D of length 4. The input stride for atrous morphological dilation.
//
// Must be: `[1, rate_height, rate_width, 1]`.
//
//	padding: The type of padding algorithm to use.
//
// Returns 3-D with shape `[filter_height, filter_width, depth]`.
func Dilation2DBackpropFilter(scope *Scope, input tf.Output, filter tf.Output, out_backprop tf.Output, strides []int64, rates []int64, padding string) (filter_backprop tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"strides": strides, "rates": rates, "padding": padding}
	opspec := tf.OpSpec{
		Type: "Dilation2DBackpropFilter",
		Input: []tf.Input{
			input, filter, out_backprop,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the gradient of morphological 2-D dilation with respect to the input.
//
// Arguments:
//
//	input: 4-D with shape `[batch, in_height, in_width, depth]`.
//	filter: 3-D with shape `[filter_height, filter_width, depth]`.
//	out_backprop: 4-D with shape `[batch, out_height, out_width, depth]`.
//	strides: 1-D of length 4. The stride of the sliding window for each dimension of
//
// the input tensor. Must be: `[1, stride_height, stride_width, 1]`.
//
//	rates: 1-D of length 4. The input stride for atrous morphological dilation.
//
// Must be: `[1, rate_height, rate_width, 1]`.
//
//	padding: The type of padding algorithm to use.
//
// Returns 4-D with shape `[batch, in_height, in_width, depth]`.
func Dilation2DBackpropInput(scope *Scope, input tf.Output, filter tf.Output, out_backprop tf.Output, strides []int64, rates []int64, padding string) (in_backprop tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"strides": strides, "rates": rates, "padding": padding}
	opspec := tf.OpSpec{
		Type: "Dilation2DBackpropInput",
		Input: []tf.Input{
			input, filter, out_backprop,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DirectedInterleaveDatasetAttr is an optional argument to DirectedInterleaveDataset.
type DirectedInterleaveDatasetAttr func(optionalAttr)

// DirectedInterleaveDatasetStopOnEmptyDataset sets the optional stop_on_empty_dataset attribute to value.
// If not specified, defaults to false
func DirectedInterleaveDatasetStopOnEmptyDataset(value bool) DirectedInterleaveDatasetAttr {
	return func(m optionalAttr) {
		m["stop_on_empty_dataset"] = value
	}
}

// A substitute for `InterleaveDataset` on a fixed list of `N` datasets.
//
// Arguments:
//
//	selector_input_dataset: A dataset of scalar `DT_INT64` elements that determines which of the
//
// `N` data inputs should produce the next output element.
//
//	data_input_datasets: `N` datasets with the same type that will be interleaved according to
//
// the values of `selector_input_dataset`.
func DirectedInterleaveDataset(scope *Scope, selector_input_dataset tf.Output, data_input_datasets []tf.Output, output_types []tf.DataType, output_shapes []tf.Shape, optional ...DirectedInterleaveDatasetAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DirectedInterleaveDataset",
		Input: []tf.Input{
			selector_input_dataset, tf.OutputList(data_input_datasets),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Turns off the copy-on-read mode.
//
// Turns off the copy-on-read mode of a resource variable. If the variable is not in copy-on-read mode, this op has no effect.
//
// Arguments:
//
//	resource: The resource handle of the resource variable.
//
// Returns the created operation.
func DisableCopyOnRead(scope *Scope, resource tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "DisableCopyOnRead",
		Input: []tf.Input{
			resource,
		},
	}
	return scope.AddOperation(opspec)
}

// Returns x / y element-wise.
//
// *NOTE*: `Div` supports broadcasting. More about broadcasting
// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
func Div(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Div",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns 0 if the denominator is zero.
//
// *NOTE*: `DivNoNan` supports broadcasting. More about broadcasting
// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
func DivNoNan(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "DivNoNan",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Draw bounding boxes on a batch of images.
//
// Outputs a copy of `images` but draws on top of the pixels zero or more bounding
// boxes specified by the locations in `boxes`. The coordinates of the each
// bounding box in `boxes` are encoded as `[y_min, x_min, y_max, x_max]`. The
// bounding box coordinates are floats in `[0.0, 1.0]` relative to the width and
// height of the underlying image.
//
// For example, if an image is 100 x 200 pixels (height x width) and the bounding
// box is `[0.1, 0.2, 0.5, 0.9]`, the upper-left and bottom-right coordinates of
// the bounding box will be `(40, 10)` to `(180, 50)` (in (x,y) coordinates).
//
// Parts of the bounding box may fall outside the image.
//
// Arguments:
//
//	images: 4-D with shape `[batch, height, width, depth]`. A batch of images.
//	boxes: 3-D with shape `[batch, num_bounding_boxes, 4]` containing bounding
//
// boxes.
//
// Returns 4-D with the same shape as `images`. The batch of input images with
// bounding boxes drawn on the images.
func DrawBoundingBoxes(scope *Scope, images tf.Output, boxes tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "DrawBoundingBoxes",
		Input: []tf.Input{
			images, boxes,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Draw bounding boxes on a batch of images.
//
// Outputs a copy of `images` but draws on top of the pixels zero or more bounding
// boxes specified by the locations in `boxes`. The coordinates of the each
// bounding box in `boxes` are encoded as `[y_min, x_min, y_max, x_max]`. The
// bounding box coordinates are floats in `[0.0, 1.0]` relative to the width and
// height of the underlying image.
//
// For example, if an image is 100 x 200 pixels (height x width) and the bounding
// box is `[0.1, 0.2, 0.5, 0.9]`, the upper-left and bottom-right coordinates of
// the bounding box will be `(40, 10)` to `(100, 50)` (in (x,y) coordinates).
//
// Parts of the bounding box may fall outside the image.
//
// Arguments:
//
//	images: 4-D with shape `[batch, height, width, depth]`. A batch of images.
//	boxes: 3-D with shape `[batch, num_bounding_boxes, 4]` containing bounding
//
// boxes.
//
//	colors: 2-D. A list of RGBA colors to cycle through for the boxes.
//
// Returns 4-D with the same shape as `images`. The batch of input images with
// bounding boxes drawn on the images.
func DrawBoundingBoxesV2(scope *Scope, images tf.Output, boxes tf.Output, colors tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "DrawBoundingBoxesV2",
		Input: []tf.Input{
			images, boxes, colors,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DynamicEnqueueTPUEmbeddingArbitraryTensorBatchAttr is an optional argument to DynamicEnqueueTPUEmbeddingArbitraryTensorBatch.
type DynamicEnqueueTPUEmbeddingArbitraryTensorBatchAttr func(optionalAttr)

// DynamicEnqueueTPUEmbeddingArbitraryTensorBatchCombiners sets the optional combiners attribute to value.
//
// value: A list of string scalars, one for each embedding table that specify
// how to normalize the embedding activations after weighted summation.
// Supported combiners are 'mean', 'sum', or 'sqrtn'. It is invalid to have
// the sum of the weights be 0 for 'mean' or the sum of the squared weights be
// 0 for 'sqrtn'. If combiners isn't passed, the default is to use 'sum' for
// all tables.
// If not specified, defaults to {}
func DynamicEnqueueTPUEmbeddingArbitraryTensorBatchCombiners(value []string) DynamicEnqueueTPUEmbeddingArbitraryTensorBatchAttr {
	return func(m optionalAttr) {
		m["combiners"] = value
	}
}

// Eases the porting of code that uses tf.nn.embedding_lookup_sparse().
//
// embedding_indices[i] and aggregation_weights[i] correspond
// to the ith feature.
//
// The tensors at corresponding positions in the three input lists (sample_indices,
// embedding_indices and aggregation_weights) must have the same shape, i.e. rank 1
// with dim_size() equal to the total number of lookups into the table described by
// the corresponding feature.
//
// Arguments:
//
//	sample_indices_or_row_splits: A list of rank 2 Tensors specifying the training example to which the
//
// corresponding embedding_indices and aggregation_weights values belong.
// If the size of its first dimension is 0, we assume each embedding_indices
// belongs to a different sample. Both int32 and int64 are allowed and will
// be converted to int32 internally.
//
// Or a list of rank 1 Tensors specifying the row splits for splitting
// embedding_indices and aggregation_weights into rows. It corresponds to
// ids.row_splits in embedding_lookup(), when ids is a RaggedTensor. When
// enqueuing N-D ragged tensor, only the last dimension is allowed to be ragged.
// the row splits is 1-D dense tensor. When empty, we assume a dense tensor is
// passed to the op Both int32 and int64 are allowed and will be converted to
// int32 internally.
//
//	embedding_indices: A list of rank 1 Tensors, indices into the embedding
//
// tables. Both int32 and int64 are allowed and will be converted to
// int32 internally.
//
//	aggregation_weights: A list of rank 1 Tensors containing per training
//
// example aggregation weights. Both float32 and float64 are allowed and will
// be converted to float32 internally.
//
//	mode_override: A string input that overrides the mode specified in the
//
// TPUEmbeddingConfiguration. Supported values are {'unspecified', 'inference',
// 'training', 'backward_pass_only'}. When set to 'unspecified', the mode set
// in TPUEmbeddingConfiguration is used, otherwise mode_override is used.
//
//	device_ordinal: The TPU device to use. Should be >= 0 and less than the number
//
// of TPU cores in the task on which the node is placed.
//
// Returns the created operation.
func DynamicEnqueueTPUEmbeddingArbitraryTensorBatch(scope *Scope, sample_indices_or_row_splits []tf.Output, embedding_indices []tf.Output, aggregation_weights []tf.Output, mode_override tf.Output, device_ordinal tf.Output, optional ...DynamicEnqueueTPUEmbeddingArbitraryTensorBatchAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DynamicEnqueueTPUEmbeddingArbitraryTensorBatch",
		Input: []tf.Input{
			tf.OutputList(sample_indices_or_row_splits), tf.OutputList(embedding_indices), tf.OutputList(aggregation_weights), mode_override, device_ordinal,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// Partitions `data` into `num_partitions` tensors using indices from `partitions`.
//
// For each index tuple `js` of size `partitions.ndim`, the slice `data[js, ...]`
// becomes part of `outputs[partitions[js]]`.  The slices with `partitions[js] = i`
// are placed in `outputs[i]` in lexicographic order of `js`, and the first
// dimension of `outputs[i]` is the number of entries in `partitions` equal to `i`.
// In detail,
//
// ```python
//
//	outputs[i].shape = [sum(partitions == i)] + data.shape[partitions.ndim:]
//
//	outputs[i] = pack([data[js, ...] for js if partitions[js] == i])
//
// ```
//
// `data.shape` must start with `partitions.shape`.
//
// For example:
//
// ```python
//
//	# Scalar partitions.
//	partitions = 1
//	num_partitions = 2
//	data = [10, 20]
//	outputs[0] = []  # Empty with shape [0, 2]
//	outputs[1] = [[10, 20]]
//
//	# Vector partitions.
//	partitions = [0, 0, 1, 1, 0]
//	num_partitions = 2
//	data = [10, 20, 30, 40, 50]
//	outputs[0] = [10, 20, 50]
//	outputs[1] = [30, 40]
//
// ```
//
// See `dynamic_stitch` for an example on how to merge partitions back.
//
// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
// <img style="width:100%" src="https://www.tensorflow.org/images/DynamicPartition.png" alt>
// </div>
//
// Raises:
//   - `InvalidArgumentError` in following cases:
//   - If partitions is not in range `[0, num_partiions)`
//   - If `partitions.shape` does not match prefix of `data.shape` argument.
//
// Arguments:
//
//	partitions: Any shape.  Indices in the range `[0, num_partitions)`.
//	num_partitions: The number of partitions to output.
func DynamicPartition(scope *Scope, data tf.Output, partitions tf.Output, num_partitions int64) (outputs []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_partitions": num_partitions}
	opspec := tf.OpSpec{
		Type: "DynamicPartition",
		Input: []tf.Input{
			data, partitions,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if outputs, idx, err = makeOutputList(op, idx, "outputs"); err != nil {
		scope.UpdateErr("DynamicPartition", err)
		return
	}
	return outputs
}

// Interleave the values from the `data` tensors into a single tensor.
//
// # Builds a merged tensor such that
//
// ```python
//
//	merged[indices[m][i, ..., j], ...] = data[m][i, ..., j, ...]
//
// ```
//
// For example, if each `indices[m]` is scalar or vector, we have
//
// ```python
//
//	# Scalar indices:
//	merged[indices[m], ...] = data[m][...]
//
//	# Vector indices:
//	merged[indices[m][i], ...] = data[m][i, ...]
//
// ```
//
// Each `data[i].shape` must start with the corresponding `indices[i].shape`,
// and the rest of `data[i].shape` must be constant w.r.t. `i`.  That is, we
// must have `data[i].shape = indices[i].shape + constant`.  In terms of this
// `constant`, the output shape is
//
//	merged.shape = [max(indices) + 1] + constant
//
// Values are merged in order, so if an index appears in both `indices[m][i]` and
// `indices[n][j]` for `(m,i) < (n,j)` the slice `data[n][j]` will appear in the
// merged result. If you do not need this guarantee, ParallelDynamicStitch might
// perform better on some devices.
//
// For example:
//
// ```python
//
//	indices[0] = 6
//	indices[1] = [4, 1]
//	indices[2] = [[5, 2], [0, 3]]
//	data[0] = [61, 62]
//	data[1] = [[41, 42], [11, 12]]
//	data[2] = [[[51, 52], [21, 22]], [[1, 2], [31, 32]]]
//	merged = [[1, 2], [11, 12], [21, 22], [31, 32], [41, 42],
//	          [51, 52], [61, 62]]
//
// ```
//
// This method can be used to merge partitions created by `dynamic_partition`
// as illustrated on the following example:
//
// ```python
//
//	# Apply function (increments x_i) on elements for which a certain condition
//	# apply (x_i != -1 in this example).
//	x=tf.constant([0.1, -1., 5.2, 4.3, -1., 7.4])
//	condition_mask=tf.not_equal(x,tf.constant(-1.))
//	partitioned_data = tf.dynamic_partition(
//	    x, tf.cast(condition_mask, tf.int32) , 2)
//	partitioned_data[1] = partitioned_data[1] + 1.0
//	condition_indices = tf.dynamic_partition(
//	    tf.range(tf.shape(x)[0]), tf.cast(condition_mask, tf.int32) , 2)
//	x = tf.dynamic_stitch(condition_indices, partitioned_data)
//	# Here x=[1.1, -1., 6.2, 5.3, -1, 8.4], the -1. values remain
//	# unchanged.
//
// ```
//
// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
// <img style="width:100%" src="https://www.tensorflow.org/images/DynamicStitch.png" alt>
// </div>
func DynamicStitch(scope *Scope, indices []tf.Output, data []tf.Output) (merged tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "DynamicStitch",
		Input: []tf.Input{
			tf.OutputList(indices), tf.OutputList(data),
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// EagerPyFuncAttr is an optional argument to EagerPyFunc.
type EagerPyFuncAttr func(optionalAttr)

// EagerPyFuncIsAsync sets the optional is_async attribute to value.
// If not specified, defaults to false
func EagerPyFuncIsAsync(value bool) EagerPyFuncAttr {
	return func(m optionalAttr) {
		m["is_async"] = value
	}
}

// Eagerly executes a python function to compute func(input)->output. The
//
// semantics of the input, output, and attributes are the same as those for
// PyFunc.
func EagerPyFunc(scope *Scope, input []tf.Output, token string, Tout []tf.DataType, optional ...EagerPyFuncAttr) (output []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"token": token, "Tout": Tout}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "EagerPyFunc",
		Input: []tf.Input{
			tf.OutputList(input),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if output, idx, err = makeOutputList(op, idx, "output"); err != nil {
		scope.UpdateErr("EagerPyFunc", err)
		return
	}
	return output
}

// EditDistanceAttr is an optional argument to EditDistance.
type EditDistanceAttr func(optionalAttr)

// EditDistanceNormalize sets the optional normalize attribute to value.
//
// value: boolean (if true, edit distances are normalized by length of truth).
//
// The output is:
// If not specified, defaults to true
func EditDistanceNormalize(value bool) EditDistanceAttr {
	return func(m optionalAttr) {
		m["normalize"] = value
	}
}

// Computes the (possibly normalized) Levenshtein Edit Distance.
//
// The inputs are variable-length sequences provided by SparseTensors
//
//	(hypothesis_indices, hypothesis_values, hypothesis_shape)
//
// and
//
//	(truth_indices, truth_values, truth_shape).
//
// The inputs are:
//
// Arguments:
//
//	hypothesis_indices: The indices of the hypothesis list SparseTensor.
//
// This is an N x R int64 matrix.
//
//	hypothesis_values: The values of the hypothesis list SparseTensor.
//
// This is an N-length vector.
//
//	hypothesis_shape: The shape of the hypothesis list SparseTensor.
//
// This is an R-length vector.
//
//	truth_indices: The indices of the truth list SparseTensor.
//
// This is an M x R int64 matrix.
//
//	truth_values: The values of the truth list SparseTensor.
//
// This is an M-length vector.
//
//	truth_shape: truth indices, vector.
//
// Returns A dense float tensor with rank R - 1.
//
// For the example input:
//
//	// hypothesis represents a 2x1 matrix with variable-length values:
//	//   (0,0) = ["a"]
//	//   (1,0) = ["b"]
//	hypothesis_indices = [[0, 0, 0],
//	                      [1, 0, 0]]
//	hypothesis_values = ["a", "b"]
//	hypothesis_shape = [2, 1, 1]
//
//	// truth represents a 2x2 matrix with variable-length values:
//	//   (0,0) = []
//	//   (0,1) = ["a"]
//	//   (1,0) = ["b", "c"]
//	//   (1,1) = ["a"]
//	truth_indices = [[0, 1, 0],
//	                 [1, 0, 0],
//	                 [1, 0, 1],
//	                 [1, 1, 0]]
//	truth_values = ["a", "b", "c", "a"]
//	truth_shape = [2, 2, 2]
//	normalize = true
//
// The output will be:
//
//	// output is a 2x2 matrix with edit distances normalized by truth lengths.
//	output = [[inf, 1.0],  // (0,0): no truth, (0,1): no hypothesis
//	          [0.5, 1.0]]  // (1,0): addition, (1,1): no hypothesis
func EditDistance(scope *Scope, hypothesis_indices tf.Output, hypothesis_values tf.Output, hypothesis_shape tf.Output, truth_indices tf.Output, truth_values tf.Output, truth_shape tf.Output, optional ...EditDistanceAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "EditDistance",
		Input: []tf.Input{
			hypothesis_indices, hypothesis_values, hypothesis_shape, truth_indices, truth_values, truth_shape,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// EigAttr is an optional argument to Eig.
type EigAttr func(optionalAttr)

// EigComputeV sets the optional compute_v attribute to value.
//
// value: If `True` then eigenvectors will be computed and returned in `v`.
// Otherwise, only the eigenvalues will be computed.
// If not specified, defaults to true
func EigComputeV(value bool) EigAttr {
	return func(m optionalAttr) {
		m["compute_v"] = value
	}
}

// Computes the eigen decomposition of one or more square matrices.
//
// Computes the eigenvalues and (optionally) right eigenvectors of each inner matrix in
// `input` such that `input[..., :, :] = v[..., :, :] * diag(e[..., :])`. The eigenvalues
// are sorted in non-decreasing order.
//
// ```python
// # a is a tensor.
// # e is a tensor of eigenvalues.
// # v is a tensor of eigenvectors.
// e, v = eig(a)
// e = eig(a, compute_v=False)
// ```
//
// Arguments:
//
//	input: `Tensor` input of shape `[N, N]`.
//
// Returns:
//
//	e: Eigenvalues. Shape is `[N]`.
//	v: Eigenvectors. Shape is `[N, N]`.
func Eig(scope *Scope, input tf.Output, Tout tf.DataType, optional ...EigAttr) (e tf.Output, v tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"Tout": Tout}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Eig",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Tensor contraction according to Einstein summation convention.
//
// Implements generalized Tensor contraction and reduction. Each input Tensor must
// have a corresponding input subscript appearing in the comma-separated left-hand
// side of the equation. The right-hand side of the equation consists of the
// output subscript. The input subscripts and the output subscript should consist
// of zero or more named axis labels and at most one ellipsis (`...`).
//
// The named axis labels may be any single character other than those having
// special meaning, namely `,.->`. The behavior of this Op is undefined if it
// receives an ill-formatted equation; since the validation is done at
// graph-building time, we omit format validation checks at runtime.
//
// Note: This Op is *not* intended to be called by the user; instead users should
// call `tf.einsum` directly. It is a hidden Op used by `tf.einsum`.
//
// Operations are applied to the input(s) according to the following rules:
//
//	(a) Generalized Diagonals: For input dimensions corresponding to axis labels
//	    appearing more than once in the same input subscript, we take the
//	    generalized (`k`-dimensional) diagonal.
//	    For example, in the equation `iii->i` with input shape `[3, 3, 3]`, the
//	    generalized diagonal would consist of `3` elements at indices `(0, 0, 0)`,
//	    `(1, 1, 1)` and `(2, 2, 2)` to create a Tensor of shape `[3]`.
//
//	(b) Reduction: Axes corresponding to labels appearing only in one input
//	    subscript but not in the output subscript are summed over prior to Tensor
//	    contraction.
//	    For example, in the equation `ab,bc->b`, the axis labels `a` and `c` are
//	    the reduction axis labels.
//
//	(c) Batch Dimensions: Axes corresponding to labels appearing in each of the
//	    input subscripts and also in the output subscript make up the batch
//	    dimensions in Tensor contraction. Unnamed axis labels corresponding to
//	    ellipsis (`...`) also correspond to batch dimensions.
//	    For example, for the equation denoting batch matrix multiplication,
//	    `bij,bjk->bik`, the axis label `b` corresponds to a batch dimension.
//
//	(d) Contraction: In case of binary einsum, axes corresponding to labels
//	    appearing in two different inputs (and not in the output) are contracted
//	    against each other.
//	    Considering the batch matrix multiplication equation again
//	    (`bij,bjk->bik`), the contracted axis label is `j`.
//
//	(e) Expand Diagonal: If the output subscripts contain repeated (explicit) axis
//	    labels, the opposite operation of (a) is applied. For example, in the
//	    equation `i->iii`, and input shape `[3]`, the output of shape `[3, 3, 3]`
//	    are all zeros, except for the (generalized) diagonal which is populated
//	    with values from the input.
//	    Note: This operation is not supported by `np.einsum` or `tf.einsum`; it is
//	    provided to enable computing the symbolic gradient of `tf.einsum`.
//
// The output subscripts must contain only labels appearing in at least one of the
// input subscripts. Furthermore, all dimensions mapping to the same axis label
// must be equal.
//
// Any of the input and output subscripts may contain at most a single ellipsis
// (`...`). These ellipsis are mapped against dimensions not corresponding to any
// named axis label. If two inputs contain ellipsis, then they are broadcasted
// according to standard NumPy broadcasting
// [rules](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html).
//
// The broadcasted dimensions are placed in the corresponding location of the
// ellipsis in the output subscript. If the broadcasted dimensions are non-empty
// and the output subscripts do not contain ellipsis, then an InvalidArgument error
// is raised.
//
// @compatibility(numpy)
// Similar to [`numpy.einsum`](https://docs.scipy.org/doc/numpy/reference/generated/numpy.einsum.html).
//
// Comparison with `numpy.einsum`:
//
//   - This Op only supports unary and binary forms of `numpy.einsum`.
//   - This Op does not support implicit form. (i.e. equations without `->`).
//   - This Op also supports repeated indices in the output subscript, which is not
//     supported by `numpy.einsum`.
//
// @end_compatibility
//
// Arguments:
//
//	inputs: List of 1 or 2 Tensors.
//	equation: String describing the Einstein Summation operation; in the format of np.einsum.
//
// Returns Output Tensor with shape depending upon `equation`.
func Einsum(scope *Scope, inputs []tf.Output, equation string) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"equation": equation}
	opspec := tf.OpSpec{
		Type: "Einsum",
		Input: []tf.Input{
			tf.OutputList(inputs),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the exponential linear function.
//
// The ELU function is defined as:
//
//   - $ e ^ x - 1 $ if $ x < 0 $
//   - $ x $ if $ x >= 0 $
//
// Examples:
//
// >>> tf.nn.elu(1.0)
// <tf.Tensor: shape=(), dtype=float32, numpy=1.0>
// >>> tf.nn.elu(0.0)
// <tf.Tensor: shape=(), dtype=float32, numpy=0.0>
// >>> tf.nn.elu(-1000.0)
// <tf.Tensor: shape=(), dtype=float32, numpy=-1.0>
//
// See [Fast and Accurate Deep Network Learning by Exponential Linear Units (ELUs)
// ](http://arxiv.org/abs/1511.07289)
func Elu(scope *Scope, features tf.Output) (activations tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Elu",
		Input: []tf.Input{
			features,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes gradients for the exponential linear (Elu) operation.
//
// Arguments:
//
//	gradients: The backpropagated gradients to the corresponding Elu operation.
//	outputs: The outputs of the corresponding Elu operation.
//
// Returns The gradients: `gradients * (outputs + 1)` if outputs < 0,
// `gradients` otherwise.
func EluGrad(scope *Scope, gradients tf.Output, outputs tf.Output) (backprops tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "EluGrad",
		Input: []tf.Input{
			gradients, outputs,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// EmptyAttr is an optional argument to Empty.
type EmptyAttr func(optionalAttr)

// EmptyInit sets the optional init attribute to value.
//
// value: If True, initialize the returned tensor with the default value of dtype.  Otherwise, the implementation is free not to initializethe tensor's content.
// If not specified, defaults to false
func EmptyInit(value bool) EmptyAttr {
	return func(m optionalAttr) {
		m["init"] = value
	}
}

// Creates a tensor with the given shape.
//
// This operation creates a tensor of `shape` and `dtype`.
//
// Arguments:
//
//	shape: 1-D. Represents the shape of the output tensor.
//
// Returns A `Tensor` of type `T`.
func Empty(scope *Scope, shape tf.Output, dtype tf.DataType, optional ...EmptyAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtype": dtype}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Empty",
		Input: []tf.Input{
			shape,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates and returns an empty tensor list.
//
// All list elements must be tensors of dtype element_dtype and shape compatible
// with element_shape.
//
// handle: an empty tensor list.
// element_dtype: the type of elements in the list.
// element_shape: a shape compatible with that of elements in the list.
func EmptyTensorList(scope *Scope, element_shape tf.Output, max_num_elements tf.Output, element_dtype tf.DataType) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"element_dtype": element_dtype}
	opspec := tf.OpSpec{
		Type: "EmptyTensorList",
		Input: []tf.Input{
			element_shape, max_num_elements,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates and returns an empty tensor map.
//
// handle: an empty tensor map
func EmptyTensorMap(scope *Scope) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "EmptyTensorMap",
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// EncodeBase64Attr is an optional argument to EncodeBase64.
type EncodeBase64Attr func(optionalAttr)

// EncodeBase64Pad sets the optional pad attribute to value.
//
// value: Bool whether padding is applied at the ends.
// If not specified, defaults to false
func EncodeBase64Pad(value bool) EncodeBase64Attr {
	return func(m optionalAttr) {
		m["pad"] = value
	}
}

// Encode strings into web-safe base64 format.
//
// Refer to [this article](https://en.wikipedia.org/wiki/Base64) for more information on
// base64 format. Base64 strings may have padding with '=' at the
// end so that the encoded has length multiple of 4. See Padding section of the
// link above.
//
// Web-safe means that the encoder uses - and _ instead of + and /.
//
// Arguments:
//
//	input: Strings to be encoded.
//
// Returns Input strings encoded in base64.
func EncodeBase64(scope *Scope, input tf.Output, optional ...EncodeBase64Attr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "EncodeBase64",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// EncodeJpegAttr is an optional argument to EncodeJpeg.
type EncodeJpegAttr func(optionalAttr)

// EncodeJpegFormat sets the optional format attribute to value.
//
// value: Per pixel image format.
// If not specified, defaults to ""
func EncodeJpegFormat(value string) EncodeJpegAttr {
	return func(m optionalAttr) {
		m["format"] = value
	}
}

// EncodeJpegQuality sets the optional quality attribute to value.
//
// value: Quality of the compression from 0 to 100 (higher is better and slower).
// If not specified, defaults to 95
func EncodeJpegQuality(value int64) EncodeJpegAttr {
	return func(m optionalAttr) {
		m["quality"] = value
	}
}

// EncodeJpegProgressive sets the optional progressive attribute to value.
//
// value: If True, create a JPEG that loads progressively (coarse to fine).
// If not specified, defaults to false
func EncodeJpegProgressive(value bool) EncodeJpegAttr {
	return func(m optionalAttr) {
		m["progressive"] = value
	}
}

// EncodeJpegOptimizeSize sets the optional optimize_size attribute to value.
//
// value: If True, spend CPU/RAM to reduce size with no quality change.
// If not specified, defaults to false
func EncodeJpegOptimizeSize(value bool) EncodeJpegAttr {
	return func(m optionalAttr) {
		m["optimize_size"] = value
	}
}

// EncodeJpegChromaDownsampling sets the optional chroma_downsampling attribute to value.
//
// value: See http://en.wikipedia.org/wiki/Chroma_subsampling.
// If not specified, defaults to true
func EncodeJpegChromaDownsampling(value bool) EncodeJpegAttr {
	return func(m optionalAttr) {
		m["chroma_downsampling"] = value
	}
}

// EncodeJpegDensityUnit sets the optional density_unit attribute to value.
//
// value: Unit used to specify `x_density` and `y_density`:
// pixels per inch (`'in'`) or centimeter (`'cm'`).
// If not specified, defaults to "in"
func EncodeJpegDensityUnit(value string) EncodeJpegAttr {
	return func(m optionalAttr) {
		m["density_unit"] = value
	}
}

// EncodeJpegXDensity sets the optional x_density attribute to value.
//
// value: Horizontal pixels per density unit.
// If not specified, defaults to 300
func EncodeJpegXDensity(value int64) EncodeJpegAttr {
	return func(m optionalAttr) {
		m["x_density"] = value
	}
}

// EncodeJpegYDensity sets the optional y_density attribute to value.
//
// value: Vertical pixels per density unit.
// If not specified, defaults to 300
func EncodeJpegYDensity(value int64) EncodeJpegAttr {
	return func(m optionalAttr) {
		m["y_density"] = value
	}
}

// EncodeJpegXmpMetadata sets the optional xmp_metadata attribute to value.
//
// value: If not empty, embed this XMP metadata in the image header.
// If not specified, defaults to ""
func EncodeJpegXmpMetadata(value string) EncodeJpegAttr {
	return func(m optionalAttr) {
		m["xmp_metadata"] = value
	}
}

// JPEG-encode an image.
//
// `image` is a 3-D uint8 Tensor of shape `[height, width, channels]`.
//
// The attr `format` can be used to override the color format of the encoded
// output.  Values can be:
//
//   - `”`: Use a default format based on the number of channels in the image.
//   - `grayscale`: Output a grayscale JPEG image.  The `channels` dimension
//     of `image` must be 1.
//   - `rgb`: Output an RGB JPEG image. The `channels` dimension
//     of `image` must be 3.
//
// If `format` is not specified or is the empty string, a default format is picked
// in function of the number of channels in `image`:
//
// *   1: Output a grayscale image.
// *   3: Output an RGB image.
//
// Arguments:
//
//	image: 3-D with shape `[height, width, channels]`.
//
// Returns 0-D. JPEG-encoded image.
func EncodeJpeg(scope *Scope, image tf.Output, optional ...EncodeJpegAttr) (contents tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "EncodeJpeg",
		Input: []tf.Input{
			image,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// JPEG encode input image with provided compression quality.
//
// `image` is a 3-D uint8 Tensor of shape `[height, width, channels]`.
// `quality` is an int32 jpeg compression quality value between 0 and 100.
//
// Arguments:
//
//	images: Images to adjust.  At least 3-D.
//	quality: An int quality to encode to.
//
// Returns 0-D. JPEG-encoded image.
func EncodeJpegVariableQuality(scope *Scope, images tf.Output, quality tf.Output) (contents tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "EncodeJpegVariableQuality",
		Input: []tf.Input{
			images, quality,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// EncodePngAttr is an optional argument to EncodePng.
type EncodePngAttr func(optionalAttr)

// EncodePngCompression sets the optional compression attribute to value.
//
// value: Compression level.
// If not specified, defaults to -1
func EncodePngCompression(value int64) EncodePngAttr {
	return func(m optionalAttr) {
		m["compression"] = value
	}
}

// PNG-encode an image.
//
// `image` is a 3-D uint8 or uint16 Tensor of shape `[height, width, channels]`
// where `channels` is:
//
// *   1: for grayscale.
// *   2: for grayscale + alpha.
// *   3: for RGB.
// *   4: for RGBA.
//
// The ZLIB compression level, `compression`, can be -1 for the PNG-encoder
// default or a value from 0 to 9.  9 is the highest compression level, generating
// the smallest output, but is slower.
//
// Arguments:
//
//	image: 3-D with shape `[height, width, channels]`.
//
// Returns 0-D. PNG-encoded image.
func EncodePng(scope *Scope, image tf.Output, optional ...EncodePngAttr) (contents tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "EncodePng",
		Input: []tf.Input{
			image,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// EncodeProtoAttr is an optional argument to EncodeProto.
type EncodeProtoAttr func(optionalAttr)

// EncodeProtoDescriptorSource sets the optional descriptor_source attribute to value.
// If not specified, defaults to "local://"
func EncodeProtoDescriptorSource(value string) EncodeProtoAttr {
	return func(m optionalAttr) {
		m["descriptor_source"] = value
	}
}

// The op serializes protobuf messages provided in the input tensors.
//
// The types of the tensors in `values` must match the schema for the fields
// specified in `field_names`. All the tensors in `values` must have a common
// shape prefix, *batch_shape*.
//
// The `sizes` tensor specifies repeat counts for each field.  The repeat count
// (last dimension) of a each tensor in `values` must be greater than or equal
// to corresponding repeat count in `sizes`.
//
// A `message_type` name must be provided to give context for the field names.
// The actual message descriptor can be looked up either in the linked-in
// descriptor pool or a filename provided by the caller using the
// `descriptor_source` attribute.
//
// For the most part, the mapping between Proto field types and TensorFlow dtypes
// is straightforward. However, there are a few special cases:
//
// - A proto field that contains a submessage or group can only be converted
// to `DT_STRING` (the serialized submessage). This is to reduce the complexity
// of the API. The resulting string can be used as input to another instance of
// the decode_proto op.
//
// - TensorFlow lacks support for unsigned integers. The ops represent uint64
// types as a `DT_INT64` with the same twos-complement bit pattern (the obvious
// way). Unsigned int32 values can be represented exactly by specifying type
// `DT_INT64`, or using twos-complement if the caller specifies `DT_INT32` in
// the `output_types` attribute.
//
// The `descriptor_source` attribute selects the source of protocol
// descriptors to consult when looking up `message_type`. This may be:
//
// - An empty string  or "local://", in which case protocol descriptors are
// created for C++ (not Python) proto definitions linked to the binary.
//
// - A file, in which case protocol descriptors are created from the file,
// which is expected to contain a `FileDescriptorSet` serialized as a string.
// NOTE: You can build a `descriptor_source` file using the `--descriptor_set_out`
// and `--include_imports` options to the protocol compiler `protoc`.
//
// - A "bytes://<bytes>", in which protocol descriptors are created from `<bytes>`,
// which is expected to be a `FileDescriptorSet` serialized as a string.
//
// Arguments:
//
//	sizes: Tensor of int32 with shape `[batch_shape, len(field_names)]`.
//	values: List of tensors containing values for the corresponding field.
//	field_names: List of strings containing proto field names.
//	message_type: Name of the proto message type to decode.
//
// Returns Tensor of serialized protos with shape `batch_shape`.
func EncodeProto(scope *Scope, sizes tf.Output, values []tf.Output, field_names []string, message_type string, optional ...EncodeProtoAttr) (bytes tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"field_names": field_names, "message_type": message_type}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "EncodeProto",
		Input: []tf.Input{
			sizes, tf.OutputList(values),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Encode audio data using the WAV file format.
//
// This operation will generate a string suitable to be saved out to create a .wav
// audio file. It will be encoded in the 16-bit PCM format. It takes in float
// values in the range -1.0f to 1.0f, and any outside that value will be clamped to
// that range.
//
// `audio` is a 2-D float Tensor of shape `[length, channels]`.
// `sample_rate` is a scalar Tensor holding the rate to use (e.g. 44100).
//
// Arguments:
//
//	audio: 2-D with shape `[length, channels]`.
//	sample_rate: Scalar containing the sample frequency.
//
// Returns 0-D. WAV-encoded file contents.
func EncodeWav(scope *Scope, audio tf.Output, sample_rate tf.Output) (contents tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "EncodeWav",
		Input: []tf.Input{
			audio, sample_rate,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// EnqueueTPUEmbeddingArbitraryTensorBatchAttr is an optional argument to EnqueueTPUEmbeddingArbitraryTensorBatch.
type EnqueueTPUEmbeddingArbitraryTensorBatchAttr func(optionalAttr)

// EnqueueTPUEmbeddingArbitraryTensorBatchDeviceOrdinal sets the optional device_ordinal attribute to value.
//
// value: The TPU device to use. Should be >= 0 and less than the number
// of TPU cores in the task on which the node is placed.
// If not specified, defaults to -1
func EnqueueTPUEmbeddingArbitraryTensorBatchDeviceOrdinal(value int64) EnqueueTPUEmbeddingArbitraryTensorBatchAttr {
	return func(m optionalAttr) {
		m["device_ordinal"] = value
	}
}

// EnqueueTPUEmbeddingArbitraryTensorBatchCombiners sets the optional combiners attribute to value.
//
// value: A list of string scalars, one for each embedding table that specify
// how to normalize the embedding activations after weighted summation.
// Supported combiners are 'mean', 'sum', or 'sqrtn'. It is invalid to have
// the sum of the weights be 0 for 'mean' or the sum of the squared weights be
// 0 for 'sqrtn'. If combiners isn't passed, the default is to use 'sum' for
// all tables.
// If not specified, defaults to {}
func EnqueueTPUEmbeddingArbitraryTensorBatchCombiners(value []string) EnqueueTPUEmbeddingArbitraryTensorBatchAttr {
	return func(m optionalAttr) {
		m["combiners"] = value
	}
}

// Eases the porting of code that uses tf.nn.embedding_lookup_sparse().
//
// embedding_indices[i] and aggregation_weights[i] correspond
// to the ith feature.
//
// The tensors at corresponding positions in the three input lists (sample_indices,
// embedding_indices and aggregation_weights) must have the same shape, i.e. rank 1
// with dim_size() equal to the total number of lookups into the table described by
// the corresponding feature.
//
// Arguments:
//
//	sample_indices_or_row_splits: A list of rank 2 Tensors specifying the training example to which the
//
// corresponding embedding_indices and aggregation_weights values belong.
// If the size of its first dimension is 0, we assume each embedding_indices
// belongs to a different sample. Both int32 and int64 are allowed and will
// be converted to int32 internally.
//
// Or a list of rank 1 Tensors specifying the row splits for splitting
// embedding_indices and aggregation_weights into rows. It corresponds to
// ids.row_splits in embedding_lookup(), when ids is a RaggedTensor. When
// enqueuing N-D ragged tensor, only the last dimension is allowed to be ragged.
// the row splits is 1-D dense tensor. When empty, we assume a dense tensor is
// passed to the op Both int32 and int64 are allowed and will be converted to
// int32 internally.
//
//	embedding_indices: A list of rank 1 Tensors, indices into the embedding
//
// tables. Both int32 and int64 are allowed and will be converted to
// int32 internally.
//
//	aggregation_weights: A list of rank 1 Tensors containing per training
//
// example aggregation weights. Both float32 and float64 are allowed and will
// be converted to float32 internally.
//
//	mode_override: A string input that overrides the mode specified in the
//
// TPUEmbeddingConfiguration. Supported values are {'unspecified', 'inference',
// 'training', 'backward_pass_only'}. When set to 'unspecified', the mode set
// in TPUEmbeddingConfiguration is used, otherwise mode_override is used.
//
// Returns the created operation.
func EnqueueTPUEmbeddingArbitraryTensorBatch(scope *Scope, sample_indices_or_row_splits []tf.Output, embedding_indices []tf.Output, aggregation_weights []tf.Output, mode_override tf.Output, optional ...EnqueueTPUEmbeddingArbitraryTensorBatchAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "EnqueueTPUEmbeddingArbitraryTensorBatch",
		Input: []tf.Input{
			tf.OutputList(sample_indices_or_row_splits), tf.OutputList(embedding_indices), tf.OutputList(aggregation_weights), mode_override,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// EnqueueTPUEmbeddingBatchAttr is an optional argument to EnqueueTPUEmbeddingBatch.
type EnqueueTPUEmbeddingBatchAttr func(optionalAttr)

// EnqueueTPUEmbeddingBatchDeviceOrdinal sets the optional device_ordinal attribute to value.
//
// value: The TPU device to use. This should be -1 when the Op
// is running on a TPU device, and >= 0 when the Op is running on the CPU
// device.
// If not specified, defaults to -1
func EnqueueTPUEmbeddingBatchDeviceOrdinal(value int64) EnqueueTPUEmbeddingBatchAttr {
	return func(m optionalAttr) {
		m["device_ordinal"] = value
	}
}

// EnqueueTPUEmbeddingBatchCombiners sets the optional combiners attribute to value.
//
// value: A list of string scalars, one for each embedding table that specify
// how to normalize the embedding activations after weighted summation.
// Supported combiners are 'mean', 'sum', or 'sqrtn'. It is invalid to have
// the sum of the weights be 0 for 'mean' or the sum of the squared weights be
// 0 for 'sqrtn'. If combiners isn't passed, the default is to use 'sum' for
// all tables.
// If not specified, defaults to {}
func EnqueueTPUEmbeddingBatchCombiners(value []string) EnqueueTPUEmbeddingBatchAttr {
	return func(m optionalAttr) {
		m["combiners"] = value
	}
}

// An op that enqueues a list of input batch tensors to TPUEmbedding.
//
// An op that enqueues a list of input batch tensors to TPUEmbedding.
//
// Arguments:
//
//	batch: A list of 1D tensors, one for each embedding table, containing the
//
// batch inputs encoded as dist_belief.SparseFeatures protos. If the weight
// field in the SparseFeatures proto is not populated for an ID, a weight of
// 1.0 is assumed.
//
//	mode_override: A string input that overrides the mode specified in the
//
// TPUEmbeddingConfiguration. Supported values are {'unspecified', 'inference',
// 'training', 'backward_pass_only'}. When set to 'unspecified', the mode set
// in TPUEmbeddingConfiguration is used, otherwise mode_override is used.
//
// Returns the created operation.
func EnqueueTPUEmbeddingBatch(scope *Scope, batch []tf.Output, mode_override tf.Output, optional ...EnqueueTPUEmbeddingBatchAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "EnqueueTPUEmbeddingBatch",
		Input: []tf.Input{
			tf.OutputList(batch), mode_override,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// EnqueueTPUEmbeddingIntegerBatchAttr is an optional argument to EnqueueTPUEmbeddingIntegerBatch.
type EnqueueTPUEmbeddingIntegerBatchAttr func(optionalAttr)

// EnqueueTPUEmbeddingIntegerBatchDeviceOrdinal sets the optional device_ordinal attribute to value.
//
// value: The TPU device to use. Should be >= 0 and less than the number
// of TPU cores in the task on which the node is placed.
// If not specified, defaults to -1
func EnqueueTPUEmbeddingIntegerBatchDeviceOrdinal(value int64) EnqueueTPUEmbeddingIntegerBatchAttr {
	return func(m optionalAttr) {
		m["device_ordinal"] = value
	}
}

// An op that enqueues a list of input batch tensors to TPUEmbedding.
//
// Arguments:
//
//	batch: A list of 1D tensors, one for each embedding table, containing the
//
// indices into the tables.
//
//	mode_override: A string input that overrides the mode specified in the
//
// TPUEmbeddingConfiguration. Supported values are {'unspecified', 'inference',
// 'training', 'backward_pass_only'}. When set to 'unspecified', the mode set
// in TPUEmbeddingConfiguration is used, otherwise mode_override is used.
//
// Returns the created operation.
func EnqueueTPUEmbeddingIntegerBatch(scope *Scope, batch []tf.Output, mode_override tf.Output, optional ...EnqueueTPUEmbeddingIntegerBatchAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "EnqueueTPUEmbeddingIntegerBatch",
		Input: []tf.Input{
			tf.OutputList(batch), mode_override,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// EnqueueTPUEmbeddingRaggedTensorBatchAttr is an optional argument to EnqueueTPUEmbeddingRaggedTensorBatch.
type EnqueueTPUEmbeddingRaggedTensorBatchAttr func(optionalAttr)

// EnqueueTPUEmbeddingRaggedTensorBatchDeviceOrdinal sets the optional device_ordinal attribute to value.
//
// value: The TPU device to use. Should be >= 0 and less than the number
// of TPU cores in the task on which the node is placed.
// If not specified, defaults to -1
func EnqueueTPUEmbeddingRaggedTensorBatchDeviceOrdinal(value int64) EnqueueTPUEmbeddingRaggedTensorBatchAttr {
	return func(m optionalAttr) {
		m["device_ordinal"] = value
	}
}

// EnqueueTPUEmbeddingRaggedTensorBatchCombiners sets the optional combiners attribute to value.
//
// value: A list of string scalars, one for each embedding table that specify
// how to normalize the embedding activations after weighted summation.
// Supported combiners are 'mean', 'sum', or 'sqrtn'. It is invalid to have
// the sum of the weights be 0 for 'mean' or the sum of the squared weights be
// 0 for 'sqrtn'. If combiners isn't passed, the default is to use 'sum' for
// all tables.
// If not specified, defaults to {}
func EnqueueTPUEmbeddingRaggedTensorBatchCombiners(value []string) EnqueueTPUEmbeddingRaggedTensorBatchAttr {
	return func(m optionalAttr) {
		m["combiners"] = value
	}
}

// EnqueueTPUEmbeddingRaggedTensorBatchMaxSequenceLengths sets the optional max_sequence_lengths attribute to value.
// If not specified, defaults to {}
func EnqueueTPUEmbeddingRaggedTensorBatchMaxSequenceLengths(value []int64) EnqueueTPUEmbeddingRaggedTensorBatchAttr {
	return func(m optionalAttr) {
		m["max_sequence_lengths"] = value
	}
}

// EnqueueTPUEmbeddingRaggedTensorBatchNumFeatures sets the optional num_features attribute to value.
// If not specified, defaults to {}
func EnqueueTPUEmbeddingRaggedTensorBatchNumFeatures(value []int64) EnqueueTPUEmbeddingRaggedTensorBatchAttr {
	return func(m optionalAttr) {
		m["num_features"] = value
	}
}

// Eases the porting of code that uses tf.nn.embedding_lookup().
//
// sample_splits[i], embedding_indices[i] and aggregation_weights[i] correspond
// to the ith feature. table_ids[i] indicates which embedding table to look up ith
// feature.
//
// The tensors at corresponding positions in two of the input lists,
// embedding_indices and aggregation_weights, must have the same shape, i.e. rank 1
// with dim_size() equal to the total number of lookups into the table described by
// the corresponding feature.
//
// Arguments:
//
//	sample_splits: A list of rank 1 Tensors specifying the break points for splitting
//
// embedding_indices and aggregation_weights into rows.
// It corresponds to ids.row_splits in embedding_lookup(), when ids is a
// RaggedTensor.
//
//	embedding_indices: A list of rank 1 Tensors, indices into the embedding tables.
//
// It corresponds to ids.values in embedding_lookup(), when ids is a RaggedTensor.
//
//	aggregation_weights: A list of rank 1 Tensors containing per training example
//
// aggregation weights. It corresponds to the values field of a RaggedTensor
// with the same row_splits as ids in embedding_lookup(), when ids is a
// RaggedTensor.
//
//	mode_override: A string input that overrides the mode specified in the
//
// TPUEmbeddingConfiguration. Supported values are {'unspecified', 'inference',
// 'training', 'backward_pass_only'}. When set to 'unspecified', the mode set
// in TPUEmbeddingConfiguration is used, otherwise mode_override is used.
//
//	table_ids: A list of integers specifying the identifier of the embedding table
//
// (offset of TableDescriptor in the TPUEmbeddingConfiguration) to lookup the
// corresponding input. The ith input is looked up using table_ids[i]. The size
// of the table_ids list must be equal to that of sample_indices,
// embedding_indices and aggregation_weights.
//
// Returns the created operation.
func EnqueueTPUEmbeddingRaggedTensorBatch(scope *Scope, sample_splits []tf.Output, embedding_indices []tf.Output, aggregation_weights []tf.Output, mode_override tf.Output, table_ids []int64, optional ...EnqueueTPUEmbeddingRaggedTensorBatchAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"table_ids": table_ids}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "EnqueueTPUEmbeddingRaggedTensorBatch",
		Input: []tf.Input{
			tf.OutputList(sample_splits), tf.OutputList(embedding_indices), tf.OutputList(aggregation_weights), mode_override,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// EnqueueTPUEmbeddingSparseBatchAttr is an optional argument to EnqueueTPUEmbeddingSparseBatch.
type EnqueueTPUEmbeddingSparseBatchAttr func(optionalAttr)

// EnqueueTPUEmbeddingSparseBatchDeviceOrdinal sets the optional device_ordinal attribute to value.
//
// value: The TPU device to use. Should be >= 0 and less than the number
// of TPU cores in the task on which the node is placed.
// If not specified, defaults to -1
func EnqueueTPUEmbeddingSparseBatchDeviceOrdinal(value int64) EnqueueTPUEmbeddingSparseBatchAttr {
	return func(m optionalAttr) {
		m["device_ordinal"] = value
	}
}

// EnqueueTPUEmbeddingSparseBatchCombiners sets the optional combiners attribute to value.
//
// value: A list of string scalars, one for each embedding table that specify
// how to normalize the embedding activations after weighted summation.
// Supported combiners are 'mean', 'sum', or 'sqrtn'. It is invalid to have
// the sum of the weights be 0 for 'mean' or the sum of the squared weights be
// 0 for 'sqrtn'. If combiners isn't passed, the default is to use 'sum' for
// all tables.
// If not specified, defaults to {}
func EnqueueTPUEmbeddingSparseBatchCombiners(value []string) EnqueueTPUEmbeddingSparseBatchAttr {
	return func(m optionalAttr) {
		m["combiners"] = value
	}
}

// An op that enqueues TPUEmbedding input indices from a SparseTensor.
//
// This Op eases the porting of code that uses embedding_lookup_sparse(),
// although some Python preprocessing of the SparseTensor arguments to
// embedding_lookup_sparse() is required to produce the arguments to this Op,
// since only a single EnqueueTPUEmbeddingSparseBatch Op is allowed per training
// step.
//
// The tensors at corresponding positions in the three input lists
// must have the same shape, i.e. rank 1 with dim_size() equal to the total
// number of lookups into the table described by the corresponding table_id.
//
// Arguments:
//
//	sample_indices: A list of rank 1 Tensors specifying the training example and
//
// feature to which the corresponding embedding_indices and aggregation_weights
// values belong. sample_indices[i] must equal b * nf + f, where nf is the
// number of features from the corresponding table, f is in [0, nf), and
// b is in [0, batch size).
//
//	embedding_indices: A list of rank 1 Tensors, indices into the embedding tables.
//	aggregation_weights: A list of rank 1 Tensors containing per sample -- i.e. per
//
// (training example, feature) -- aggregation weights.
//
//	mode_override: A string input that overrides the mode specified in the
//
// TPUEmbeddingConfiguration. Supported values are {'unspecified', 'inference',
// 'training', 'backward_pass_only'}. When set to 'unspecified', the mode set
// in TPUEmbeddingConfiguration is used, otherwise mode_override is used.
//
// Returns the created operation.
func EnqueueTPUEmbeddingSparseBatch(scope *Scope, sample_indices []tf.Output, embedding_indices []tf.Output, aggregation_weights []tf.Output, mode_override tf.Output, optional ...EnqueueTPUEmbeddingSparseBatchAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "EnqueueTPUEmbeddingSparseBatch",
		Input: []tf.Input{
			tf.OutputList(sample_indices), tf.OutputList(embedding_indices), tf.OutputList(aggregation_weights), mode_override,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// EnqueueTPUEmbeddingSparseTensorBatchAttr is an optional argument to EnqueueTPUEmbeddingSparseTensorBatch.
type EnqueueTPUEmbeddingSparseTensorBatchAttr func(optionalAttr)

// EnqueueTPUEmbeddingSparseTensorBatchDeviceOrdinal sets the optional device_ordinal attribute to value.
//
// value: The TPU device to use. Should be >= 0 and less than the number
// of TPU cores in the task on which the node is placed.
// If not specified, defaults to -1
func EnqueueTPUEmbeddingSparseTensorBatchDeviceOrdinal(value int64) EnqueueTPUEmbeddingSparseTensorBatchAttr {
	return func(m optionalAttr) {
		m["device_ordinal"] = value
	}
}

// EnqueueTPUEmbeddingSparseTensorBatchCombiners sets the optional combiners attribute to value.
//
// value: A list of string scalars, one for each embedding table that specify
// how to normalize the embedding activations after weighted summation.
// Supported combiners are 'mean', 'sum', or 'sqrtn'. It is invalid to have
// the sum of the weights be 0 for 'mean' or the sum of the squared weights be
// 0 for 'sqrtn'. If combiners isn't passed, the default is to use 'sum' for
// all tables.
// If not specified, defaults to {}
func EnqueueTPUEmbeddingSparseTensorBatchCombiners(value []string) EnqueueTPUEmbeddingSparseTensorBatchAttr {
	return func(m optionalAttr) {
		m["combiners"] = value
	}
}

// EnqueueTPUEmbeddingSparseTensorBatchMaxSequenceLengths sets the optional max_sequence_lengths attribute to value.
// If not specified, defaults to {}
func EnqueueTPUEmbeddingSparseTensorBatchMaxSequenceLengths(value []int64) EnqueueTPUEmbeddingSparseTensorBatchAttr {
	return func(m optionalAttr) {
		m["max_sequence_lengths"] = value
	}
}

// EnqueueTPUEmbeddingSparseTensorBatchNumFeatures sets the optional num_features attribute to value.
// If not specified, defaults to {}
func EnqueueTPUEmbeddingSparseTensorBatchNumFeatures(value []int64) EnqueueTPUEmbeddingSparseTensorBatchAttr {
	return func(m optionalAttr) {
		m["num_features"] = value
	}
}

// Eases the porting of code that uses tf.nn.embedding_lookup_sparse().
//
// sample_indices[i], embedding_indices[i] and aggregation_weights[i] correspond
// to the ith feature. table_ids[i] indicates which embedding table to look up ith
// feature.
//
// The tensors at corresponding positions in the three input lists (sample_indices,
// embedding_indices and aggregation_weights) must have the same shape, i.e. rank 1
// with dim_size() equal to the total number of lookups into the table described by
// the corresponding feature.
//
// Arguments:
//
//	sample_indices: A list of rank 1 Tensors specifying the training example to
//
// which the corresponding embedding_indices and aggregation_weights values
// belong. It corresponds to sp_ids.indices[:,0] in  embedding_lookup_sparse().
//
//	embedding_indices: A list of rank 1 Tensors, indices into the embedding tables.
//
// It corresponds to sp_ids.values in embedding_lookup_sparse().
//
//	aggregation_weights: A list of rank 1 Tensors containing per training example
//
// aggregation weights. It corresponds to sp_weights.values in
// embedding_lookup_sparse().
//
//	mode_override: A string input that overrides the mode specified in the
//
// TPUEmbeddingConfiguration. Supported values are {'unspecified', 'inference',
// 'training', 'backward_pass_only'}. When set to 'unspecified', the mode set
// in TPUEmbeddingConfiguration is used, otherwise mode_override is used.
//
//	table_ids: A list of integers specifying the identifier of the embedding table
//
// (offset of TableDescriptor in the TPUEmbeddingConfiguration) to lookup the
// corresponding input. The ith input is looked up using table_ids[i]. The size
// of the table_ids list must be equal to that of sample_indices,
// embedding_indices and aggregation_weights.
//
// Returns the created operation.
func EnqueueTPUEmbeddingSparseTensorBatch(scope *Scope, sample_indices []tf.Output, embedding_indices []tf.Output, aggregation_weights []tf.Output, mode_override tf.Output, table_ids []int64, optional ...EnqueueTPUEmbeddingSparseTensorBatchAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"table_ids": table_ids}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "EnqueueTPUEmbeddingSparseTensorBatch",
		Input: []tf.Input{
			tf.OutputList(sample_indices), tf.OutputList(embedding_indices), tf.OutputList(aggregation_weights), mode_override,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// Ensures that the tensor's shape matches the expected shape.
//
// Raises an error if the input tensor's shape does not match the specified shape.
// Returns the input tensor otherwise.
//
// Arguments:
//
//	input: A tensor, whose shape is to be validated.
//	shape: The expected (possibly partially specified) shape of the input tensor.
//
// Returns A tensor with the same shape and contents as the input tensor or value.
func EnsureShape(scope *Scope, input tf.Output, shape tf.Shape) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"shape": shape}
	opspec := tf.OpSpec{
		Type: "EnsureShape",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// EnterAttr is an optional argument to Enter.
type EnterAttr func(optionalAttr)

// EnterIsConstant sets the optional is_constant attribute to value.
//
// value: If true, the output is constant within the child frame.
// If not specified, defaults to false
func EnterIsConstant(value bool) EnterAttr {
	return func(m optionalAttr) {
		m["is_constant"] = value
	}
}

// EnterParallelIterations sets the optional parallel_iterations attribute to value.
//
// value: The number of iterations allowed to run in parallel.
// If not specified, defaults to 10
func EnterParallelIterations(value int64) EnterAttr {
	return func(m optionalAttr) {
		m["parallel_iterations"] = value
	}
}

// Creates or finds a child frame, and makes `data` available to the child frame.
//
// This op is used together with `Exit` to create loops in the graph.
// The unique `frame_name` is used by the `Executor` to identify frames. If
// `is_constant` is true, `output` is a constant in the child frame; otherwise
// it may be changed in the child frame. At most `parallel_iterations` iterations
// are run in parallel in the child frame.
//
// Arguments:
//
//	data: The tensor to be made available to the child frame.
//	frame_name: The name of the child frame.
//
// Returns The same tensor as `data`.
func Enter(scope *Scope, data tf.Output, frame_name string, optional ...EnterAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"frame_name": frame_name}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Enter",
		Input: []tf.Input{
			data,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// EqualAttr is an optional argument to Equal.
type EqualAttr func(optionalAttr)

// EqualIncompatibleShapeError sets the optional incompatible_shape_error attribute to value.
// If not specified, defaults to true
func EqualIncompatibleShapeError(value bool) EqualAttr {
	return func(m optionalAttr) {
		m["incompatible_shape_error"] = value
	}
}

// Returns the truth value of (x == y) element-wise.
//
// *NOTE*: `Equal` supports broadcasting. More about broadcasting
// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
//
// ```python
// x = tf.constant([2, 4])
// y = tf.constant(2)
// tf.math.equal(x, y) ==> array([True, False])
//
// x = tf.constant([2, 4])
// y = tf.constant([2, 4])
// tf.math.equal(x, y) ==> array([True,  True])
// ```
func Equal(scope *Scope, x tf.Output, y tf.Output, optional ...EqualAttr) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Equal",
		Input: []tf.Input{
			x, y,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the [Gauss error function](https://en.wikipedia.org/wiki/Error_function) of `x` element-wise. In statistics, for non-negative values of $x$, the error function has the following interpretation: for a random variable $Y$ that is normally distributed with mean 0 and variance $1/\sqrt{2}$, $erf(x)$ is the probability that $Y$ falls in the range $[−x, x]$.
func Erf(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Erf",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the complementary error function of `x` element-wise.
func Erfc(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Erfc",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// EuclideanNormAttr is an optional argument to EuclideanNorm.
type EuclideanNormAttr func(optionalAttr)

// EuclideanNormKeepDims sets the optional keep_dims attribute to value.
//
// value: If true, retain reduced dimensions with length 1.
// If not specified, defaults to false
func EuclideanNormKeepDims(value bool) EuclideanNormAttr {
	return func(m optionalAttr) {
		m["keep_dims"] = value
	}
}

// Computes the euclidean norm of elements across dimensions of a tensor.
//
// Reduces `input` along the dimensions given in `axis`. Unless
// `keep_dims` is true, the rank of the tensor is reduced by 1 for each entry in
// `axis`. If `keep_dims` is true, the reduced dimensions are
// retained with length 1.
//
// Arguments:
//
//	input: The tensor to reduce.
//	axis: The dimensions to reduce. Must be in the range
//
// `[-rank(input), rank(input))`.
//
// Returns The reduced tensor.
func EuclideanNorm(scope *Scope, input tf.Output, axis tf.Output, optional ...EuclideanNormAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "EuclideanNorm",
		Input: []tf.Input{
			input, axis,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// An op that executes the TPUEmbedding partitioner on the central configuration
//
// device and computes the HBM size (in bytes) required for TPUEmbedding operation.
//
// Arguments:
//
//	config: An TPUEmbeddingConfiguration proto serialized to a string,
//
// describing the desired TPUEmbedding configuration.
//
// Returns A string-encoded common configuration proto
// containing metadata about the TPUEmbedding partitioner output and
// the HBM size (in bytes) required for operation.
func ExecuteTPUEmbeddingPartitioner(scope *Scope, config string) (common_config tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"config": config}
	opspec := tf.OpSpec{
		Type: "ExecuteTPUEmbeddingPartitioner",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Exits the current frame to its parent frame.
//
// Exit makes its input `data` available to the parent frame.
//
// Arguments:
//
//	data: The tensor to be made available to the parent frame.
//
// Returns The same tensor as `data`.
func Exit(scope *Scope, data tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Exit",
		Input: []tf.Input{
			data,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes exponential of x element-wise.  \\(y = e^x\\).
//
//	This function computes the exponential of every element in the input tensor.
//	i.e. `exp(x)` or `e^(x)`, where `x` is the input tensor.
//	`e` denotes Euler's number and is approximately equal to 2.718281.
//	Output is positive for any real input.
//
//	```python
//	x = tf.constant(2.0)
//	tf.math.exp(x) ==> 7.389056
//
//	x = tf.constant([2.0, 8.0])
//	tf.math.exp(x) ==> array([7.389056, 2980.958], dtype=float32)
//	```
//
//	For complex numbers, the exponential value is calculated as follows:
//
//	```
//	e^(x+iy) = e^x * e^iy = e^x * (cos y + i sin y)
//	```
//
//	Let's consider complex number 1+1j as an example.
//	e^1 * (cos 1 + i sin 1) = 2.7182818284590 * (0.54030230586+0.8414709848j)
//
//	```python
//	x = tf.constant(1 + 1j)
//	tf.math.exp(x) ==> 1.4686939399158851+2.2873552871788423j
//	```
func Exp(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Exp",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Inserts a dimension of 1 into a tensor's shape.
//
// Given a tensor `input`, this operation inserts a dimension of 1 at the
// dimension index `axis` of `input`'s shape. The dimension index `axis` starts at
// zero; if you specify a negative number for `axis` it is counted backward from
// the end.
//
// This operation is useful if you want to add a batch dimension to a single
// element. For example, if you have a single image of shape `[height, width,
// channels]`, you can make it a batch of 1 image with `expand_dims(image, 0)`,
// which will make the shape `[1, height, width, channels]`.
//
// Other examples:
//
// ```
// # 't' is a tensor of shape [2]
// shape(expand_dims(t, 0)) ==> [1, 2]
// shape(expand_dims(t, 1)) ==> [2, 1]
// shape(expand_dims(t, -1)) ==> [2, 1]
//
// # 't2' is a tensor of shape [2, 3, 5]
// shape(expand_dims(t2, 0)) ==> [1, 2, 3, 5]
// shape(expand_dims(t2, 2)) ==> [2, 3, 1, 5]
// shape(expand_dims(t2, 3)) ==> [2, 3, 5, 1]
// ```
//
// This operation requires that:
//
// `-1-input.dims() <= dim <= input.dims()`
//
// This operation is related to `squeeze()`, which removes dimensions of
// size 1.
//
// Arguments:
//
//	axis: 0-D (scalar). Specifies the dimension index at which to
//
// expand the shape of `input`. Must be in the range
// `[-rank(input) - 1, rank(input)]`.
//
// Returns Contains the same data as `input`, but its shape has an additional
// dimension of size 1 added.
func ExpandDims(scope *Scope, input tf.Output, axis tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ExpandDims",
		Input: []tf.Input{
			input, axis,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ExperimentalAutoShardDatasetAttr is an optional argument to ExperimentalAutoShardDataset.
type ExperimentalAutoShardDatasetAttr func(optionalAttr)

// ExperimentalAutoShardDatasetAutoShardPolicy sets the optional auto_shard_policy attribute to value.
// If not specified, defaults to 0
func ExperimentalAutoShardDatasetAutoShardPolicy(value int64) ExperimentalAutoShardDatasetAttr {
	return func(m optionalAttr) {
		m["auto_shard_policy"] = value
	}
}

// Creates a dataset that shards the input dataset.
//
// Creates a dataset that shards the input dataset by num_workers, returning a
// sharded dataset for the index-th worker. This attempts to automatically shard
// a dataset by examining the Dataset graph and inserting a shard op before the
// inputs to a reader Dataset (e.g. CSVDataset, TFRecordDataset).
//
// This dataset will throw a NotFound error if we cannot shard the dataset
// automatically.
//
// Arguments:
//
//	input_dataset: A variant tensor representing the input dataset.
//	num_workers: A scalar representing the number of workers to distribute this dataset across.
//	index: A scalar representing the index of the current worker out of num_workers.
func ExperimentalAutoShardDataset(scope *Scope, input_dataset tf.Output, num_workers tf.Output, index tf.Output, output_types []tf.DataType, output_shapes []tf.Shape, optional ...ExperimentalAutoShardDatasetAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ExperimentalAutoShardDataset",
		Input: []tf.Input{
			input_dataset, num_workers, index,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Records the bytes size of each element of `input_dataset` in a StatsAggregator.
func ExperimentalBytesProducedStatsDataset(scope *Scope, input_dataset tf.Output, tag tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "ExperimentalBytesProducedStatsDataset",
		Input: []tf.Input{
			input_dataset, tag,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the cardinality of `input_dataset`.
//
// Returns the cardinality of `input_dataset`.
//
// Arguments:
//
//	input_dataset: A variant tensor representing the dataset to return cardinality for.
//
// Returns The cardinality of `input_dataset`. Named constants are used to represent
// infinite and unknown cardinality.
func ExperimentalDatasetCardinality(scope *Scope, input_dataset tf.Output) (cardinality tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ExperimentalDatasetCardinality",
		Input: []tf.Input{
			input_dataset,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Writes the given dataset to the given file using the TFRecord format.
//
// Arguments:
//
//	input_dataset: A variant tensor representing the dataset to write.
//	filename: A scalar string tensor representing the filename to use.
//	compression_type: A scalar string tensor containing either (i) the empty string (no
//
// compression), (ii) "ZLIB", or (iii) "GZIP".
//
// Returns the created operation.
func ExperimentalDatasetToTFRecord(scope *Scope, input_dataset tf.Output, filename tf.Output, compression_type tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ExperimentalDatasetToTFRecord",
		Input: []tf.Input{
			input_dataset, filename, compression_type,
		},
	}
	return scope.AddOperation(opspec)
}

// Creates a dataset that batches input elements into a SparseTensor.
//
// Arguments:
//
//	input_dataset: A handle to an input dataset. Must have a single component.
//	batch_size: A scalar representing the number of elements to accumulate in a
//
// batch.
//
//	row_shape: A vector representing the dense shape of each row in the produced
//
// SparseTensor. The shape may be partially specified, using `-1` to indicate
// that a particular dimension should use the maximum size of all batch elements.
func ExperimentalDenseToSparseBatchDataset(scope *Scope, input_dataset tf.Output, batch_size tf.Output, row_shape tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "ExperimentalDenseToSparseBatchDataset",
		Input: []tf.Input{
			input_dataset, batch_size, row_shape,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// A substitute for `InterleaveDataset` on a fixed list of `N` datasets.
//
// Arguments:
//
//	selector_input_dataset: A dataset of scalar `DT_INT64` elements that determines which of the
//
// `N` data inputs should produce the next output element.
//
//	data_input_datasets: `N` datasets with the same type that will be interleaved according to
//
// the values of `selector_input_dataset`.
func ExperimentalDirectedInterleaveDataset(scope *Scope, selector_input_dataset tf.Output, data_input_datasets []tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "ExperimentalDirectedInterleaveDataset",
		Input: []tf.Input{
			selector_input_dataset, tf.OutputList(data_input_datasets),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ExperimentalIgnoreErrorsDatasetAttr is an optional argument to ExperimentalIgnoreErrorsDataset.
type ExperimentalIgnoreErrorsDatasetAttr func(optionalAttr)

// ExperimentalIgnoreErrorsDatasetLogWarning sets the optional log_warning attribute to value.
// If not specified, defaults to false
func ExperimentalIgnoreErrorsDatasetLogWarning(value bool) ExperimentalIgnoreErrorsDatasetAttr {
	return func(m optionalAttr) {
		m["log_warning"] = value
	}
}

// Creates a dataset that contains the elements of `input_dataset` ignoring errors.
func ExperimentalIgnoreErrorsDataset(scope *Scope, input_dataset tf.Output, output_types []tf.DataType, output_shapes []tf.Shape, optional ...ExperimentalIgnoreErrorsDatasetAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ExperimentalIgnoreErrorsDataset",
		Input: []tf.Input{
			input_dataset,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the name of the device on which `resource` has been placed.
func ExperimentalIteratorGetDevice(scope *Scope, resource tf.Output) (device tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ExperimentalIteratorGetDevice",
		Input: []tf.Input{
			resource,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Records the latency of producing `input_dataset` elements in a StatsAggregator.
func ExperimentalLatencyStatsDataset(scope *Scope, input_dataset tf.Output, tag tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "ExperimentalLatencyStatsDataset",
		Input: []tf.Input{
			input_dataset, tag,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates a dataset that overrides the maximum intra-op parallelism.
//
// Arguments:
//
//	max_intra_op_parallelism: Identifies the maximum intra-op parallelism to use.
func ExperimentalMaxIntraOpParallelismDataset(scope *Scope, input_dataset tf.Output, max_intra_op_parallelism tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "ExperimentalMaxIntraOpParallelismDataset",
		Input: []tf.Input{
			input_dataset, max_intra_op_parallelism,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ExperimentalParseExampleDatasetAttr is an optional argument to ExperimentalParseExampleDataset.
type ExperimentalParseExampleDatasetAttr func(optionalAttr)

// ExperimentalParseExampleDatasetSloppy sets the optional sloppy attribute to value.
// If not specified, defaults to false
func ExperimentalParseExampleDatasetSloppy(value bool) ExperimentalParseExampleDatasetAttr {
	return func(m optionalAttr) {
		m["sloppy"] = value
	}
}

// Transforms `input_dataset` containing `Example` protos as vectors of DT_STRING into a dataset of `Tensor` or `SparseTensor` objects representing the parsed features.
//
// Arguments:
//
//	dense_defaults: A dict mapping string keys to `Tensor`s.
//
// The keys of the dict must match the dense_keys of the feature.
//
//	sparse_keys: A list of string keys in the examples features.
//
// The results for these keys will be returned as `SparseTensor` objects.
//
//	dense_keys: A list of Ndense string Tensors (scalars).
//
// The keys expected in the Examples features associated with dense values.
//
//	sparse_types: A list of `DTypes` of the same length as `sparse_keys`.
//
// Only `tf.float32` (`FloatList`), `tf.int64` (`Int64List`),
// and `tf.string` (`BytesList`) are supported.
//
//	dense_shapes: List of tuples with the same length as `dense_keys`.
//
// The shape of the data for each dense feature referenced by `dense_keys`.
// Required for any input tensors identified by `dense_keys`.  Must be
// either fully defined, or may contain an unknown first dimension.
// An unknown first dimension means the feature is treated as having
// a variable number of blocks, and the output shape along this dimension
// is considered unknown at graph build time.  Padding is applied for
// minibatch elements smaller than the maximum number of blocks for the
// given feature along this dimension.
//
//	output_types: The type list for the return values.
//	output_shapes: The list of shapes being produced.
func ExperimentalParseExampleDataset(scope *Scope, input_dataset tf.Output, num_parallel_calls tf.Output, dense_defaults []tf.Output, sparse_keys []string, dense_keys []string, sparse_types []tf.DataType, dense_shapes []tf.Shape, output_types []tf.DataType, output_shapes []tf.Shape, optional ...ExperimentalParseExampleDatasetAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"sparse_keys": sparse_keys, "dense_keys": dense_keys, "sparse_types": sparse_types, "dense_shapes": dense_shapes, "output_types": output_types, "output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ExperimentalParseExampleDataset",
		Input: []tf.Input{
			input_dataset, num_parallel_calls, tf.OutputList(dense_defaults),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates a dataset that uses a custom thread pool to compute `input_dataset`.
//
// Arguments:
//
//	num_threads: Identifies the number of threads to use for the private threadpool.
func ExperimentalPrivateThreadPoolDataset(scope *Scope, input_dataset tf.Output, num_threads tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "ExperimentalPrivateThreadPoolDataset",
		Input: []tf.Input{
			input_dataset, num_threads,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates a Dataset that returns pseudorandom numbers.
//
// Arguments:
//
//	seed: A scalar seed for the random number generator. If either seed or
//
// seed2 is set to be non-zero, the random number generator is seeded
// by the given seed.  Otherwise, a random seed is used.
//
//	seed2: A second scalar seed to avoid seed collision.
func ExperimentalRandomDataset(scope *Scope, seed tf.Output, seed2 tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "ExperimentalRandomDataset",
		Input: []tf.Input{
			seed, seed2,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ExperimentalRebatchDatasetAttr is an optional argument to ExperimentalRebatchDataset.
type ExperimentalRebatchDatasetAttr func(optionalAttr)

// ExperimentalRebatchDatasetUseFallback sets the optional use_fallback attribute to value.
// If not specified, defaults to true
func ExperimentalRebatchDatasetUseFallback(value bool) ExperimentalRebatchDatasetAttr {
	return func(m optionalAttr) {
		m["use_fallback"] = value
	}
}

// Creates a dataset that changes the batch size.
//
// Creates a dataset that changes the batch size of the dataset to current batch
// size // num_replicas.
//
// Arguments:
//
//	input_dataset: A variant tensor representing the input dataset.
//	num_replicas: A scalar representing the number of replicas to distribute this batch across. As
//
// a result of this transformation the current batch size would end up being
// divided  by this parameter.
func ExperimentalRebatchDataset(scope *Scope, input_dataset tf.Output, num_replicas tf.Output, output_types []tf.DataType, output_shapes []tf.Shape, optional ...ExperimentalRebatchDatasetAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ExperimentalRebatchDataset",
		Input: []tf.Input{
			input_dataset, num_replicas,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates a dataset that passes a sliding window over `input_dataset`.
//
// Arguments:
//
//	window_size: A scalar representing the number of elements in the
//
// sliding window.
//
//	window_shift: A scalar representing the steps moving the sliding window
//
// forward in one iteration. It must be positive.
//
//	window_stride: A scalar representing the stride of the input elements of the sliding window.
//
// It must be positive.
func ExperimentalSlidingWindowDataset(scope *Scope, input_dataset tf.Output, window_size tf.Output, window_shift tf.Output, window_stride tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "ExperimentalSlidingWindowDataset",
		Input: []tf.Input{
			input_dataset, window_size, window_shift, window_stride,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates a dataset that executes a SQL query and emits rows of the result set.
//
// Arguments:
//
//	driver_name: The database type. Currently, the only supported type is 'sqlite'.
//	data_source_name: A connection string to connect to the database.
//	query: A SQL query to execute.
func ExperimentalSqlDataset(scope *Scope, driver_name tf.Output, data_source_name tf.Output, query tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "ExperimentalSqlDataset",
		Input: []tf.Input{
			driver_name, data_source_name, query,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ExperimentalStatsAggregatorHandleAttr is an optional argument to ExperimentalStatsAggregatorHandle.
type ExperimentalStatsAggregatorHandleAttr func(optionalAttr)

// ExperimentalStatsAggregatorHandleContainer sets the optional container attribute to value.
// If not specified, defaults to ""
func ExperimentalStatsAggregatorHandleContainer(value string) ExperimentalStatsAggregatorHandleAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// ExperimentalStatsAggregatorHandleSharedName sets the optional shared_name attribute to value.
// If not specified, defaults to ""
func ExperimentalStatsAggregatorHandleSharedName(value string) ExperimentalStatsAggregatorHandleAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Creates a statistics manager resource.
func ExperimentalStatsAggregatorHandle(scope *Scope, optional ...ExperimentalStatsAggregatorHandleAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ExperimentalStatsAggregatorHandle",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Produces a summary of any statistics recorded by the given statistics manager.
func ExperimentalStatsAggregatorSummary(scope *Scope, iterator tf.Output) (summary tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ExperimentalStatsAggregatorSummary",
		Input: []tf.Input{
			iterator,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates a dataset that uses a custom thread pool to compute `input_dataset`.
//
// Arguments:
//
//	thread_pool: A resource produced by the ThreadPoolHandle op.
func ExperimentalThreadPoolDataset(scope *Scope, input_dataset tf.Output, thread_pool tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "ExperimentalThreadPoolDataset",
		Input: []tf.Input{
			input_dataset, thread_pool,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ExperimentalThreadPoolHandleAttr is an optional argument to ExperimentalThreadPoolHandle.
type ExperimentalThreadPoolHandleAttr func(optionalAttr)

// ExperimentalThreadPoolHandleMaxIntraOpParallelism sets the optional max_intra_op_parallelism attribute to value.
//
// value: The maximum degree of parallelism to use within operations that execute on this
// threadpool.
// If not specified, defaults to 1
func ExperimentalThreadPoolHandleMaxIntraOpParallelism(value int64) ExperimentalThreadPoolHandleAttr {
	return func(m optionalAttr) {
		m["max_intra_op_parallelism"] = value
	}
}

// ExperimentalThreadPoolHandleContainer sets the optional container attribute to value.
//
// value: The name of `container` should start with `'.'` or `letter` or `digit`,
// with ['-', '.', '/'] or `letter` or `digit` follows several times.
// If not specified, defaults to ""
func ExperimentalThreadPoolHandleContainer(value string) ExperimentalThreadPoolHandleAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// ExperimentalThreadPoolHandleSharedName sets the optional shared_name attribute to value.
// If not specified, defaults to ""
func ExperimentalThreadPoolHandleSharedName(value string) ExperimentalThreadPoolHandleAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Creates a dataset that uses a custom thread pool to compute `input_dataset`.
//
// Arguments:
//
//	num_threads: The number of threads in the thread pool.
//	display_name: A human-readable name for the threads that may be visible in some
//
// visualizations.
func ExperimentalThreadPoolHandle(scope *Scope, num_threads int64, display_name string, optional ...ExperimentalThreadPoolHandleAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_threads": num_threads, "display_name": display_name}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ExperimentalThreadPoolHandle",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// A dataset that splits the elements of its input into multiple elements.
func ExperimentalUnbatchDataset(scope *Scope, input_dataset tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "ExperimentalUnbatchDataset",
		Input: []tf.Input{
			input_dataset,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates a dataset that contains the unique elements of `input_dataset`.
func ExperimentalUniqueDataset(scope *Scope, input_dataset tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "ExperimentalUniqueDataset",
		Input: []tf.Input{
			input_dataset,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes `exp(x) - 1` element-wise.
//
//	i.e. `exp(x) - 1` or `e^(x) - 1`, where `x` is the input tensor.
//	`e` denotes Euler's number and is approximately equal to 2.718281.
//
//	```python
//	x = tf.constant(2.0)
//	tf.math.expm1(x) ==> 6.389056
//
//	x = tf.constant([2.0, 8.0])
//	tf.math.expm1(x) ==> array([6.389056, 2979.958], dtype=float32)
//
//	x = tf.constant(1 + 1j)
//	tf.math.expm1(x) ==> (0.46869393991588515+2.2873552871788423j)
//	```
func Expm1(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Expm1",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ExtractGlimpseAttr is an optional argument to ExtractGlimpse.
type ExtractGlimpseAttr func(optionalAttr)

// ExtractGlimpseCentered sets the optional centered attribute to value.
//
// value: indicates if the offset coordinates are centered relative to
// the image, in which case the (0, 0) offset is relative to the center
// of the input images. If false, the (0,0) offset corresponds to the
// upper left corner of the input images.
// If not specified, defaults to true
func ExtractGlimpseCentered(value bool) ExtractGlimpseAttr {
	return func(m optionalAttr) {
		m["centered"] = value
	}
}

// ExtractGlimpseNormalized sets the optional normalized attribute to value.
//
// value: indicates if the offset coordinates are normalized.
// If not specified, defaults to true
func ExtractGlimpseNormalized(value bool) ExtractGlimpseAttr {
	return func(m optionalAttr) {
		m["normalized"] = value
	}
}

// ExtractGlimpseUniformNoise sets the optional uniform_noise attribute to value.
//
// value: indicates if the noise should be generated using a
// uniform distribution or a Gaussian distribution.
// It should not be `True` when `noise` is not `uniform`.
// If not specified, defaults to true
func ExtractGlimpseUniformNoise(value bool) ExtractGlimpseAttr {
	return func(m optionalAttr) {
		m["uniform_noise"] = value
	}
}

// ExtractGlimpseNoise sets the optional noise attribute to value.
//
// value: indicates if the noise should `uniform`, `gaussian`, or
// `zero`. The default is `uniform` which means the noise type
// will be decided by `uniform_noise`.
// If not specified, defaults to "uniform"
func ExtractGlimpseNoise(value string) ExtractGlimpseAttr {
	return func(m optionalAttr) {
		m["noise"] = value
	}
}

// Extracts a glimpse from the input tensor.
//
// Returns a set of windows called glimpses extracted at location
// `offsets` from the input tensor. If the windows only partially
// overlaps the inputs, the non overlapping areas will be filled with
// random noise.
//
// The result is a 4-D tensor of shape `[batch_size, glimpse_height,
// glimpse_width, channels]`. The channels and batch dimensions are the
// same as that of the input tensor. The height and width of the output
// windows are specified in the `size` parameter.
//
// The argument `normalized` and `centered` controls how the windows are built:
//
//   - If the coordinates are normalized but not centered, 0.0 and 1.0
//     correspond to the minimum and maximum of each height and width
//     dimension.
//   - If the coordinates are both normalized and centered, they range from
//     -1.0 to 1.0. The coordinates (-1.0, -1.0) correspond to the upper
//     left corner, the lower right corner is located at (1.0, 1.0) and the
//     center is at (0, 0).
//   - If the coordinates are not normalized they are interpreted as
//     numbers of pixels.
//
// Arguments:
//
//	input: A 4-D float tensor of shape `[batch_size, height, width, channels]`.
//	size: A 1-D tensor of 2 elements containing the size of the glimpses
//
// to extract.  The glimpse height must be specified first, following
// by the glimpse width.
//
//	offsets: A 2-D integer tensor of shape `[batch_size, 2]` containing
//
// the y, x locations of the center of each window.
//
// Returns A tensor representing the glimpses `[batch_size,
// glimpse_height, glimpse_width, channels]`.
func ExtractGlimpse(scope *Scope, input tf.Output, size tf.Output, offsets tf.Output, optional ...ExtractGlimpseAttr) (glimpse tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ExtractGlimpse",
		Input: []tf.Input{
			input, size, offsets,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ExtractGlimpseV2Attr is an optional argument to ExtractGlimpseV2.
type ExtractGlimpseV2Attr func(optionalAttr)

// ExtractGlimpseV2Centered sets the optional centered attribute to value.
//
// value: indicates if the offset coordinates are centered relative to
// the image, in which case the (0, 0) offset is relative to the center
// of the input images. If false, the (0,0) offset corresponds to the
// upper left corner of the input images.
// If not specified, defaults to true
func ExtractGlimpseV2Centered(value bool) ExtractGlimpseV2Attr {
	return func(m optionalAttr) {
		m["centered"] = value
	}
}

// ExtractGlimpseV2Normalized sets the optional normalized attribute to value.
//
// value: indicates if the offset coordinates are normalized.
// If not specified, defaults to true
func ExtractGlimpseV2Normalized(value bool) ExtractGlimpseV2Attr {
	return func(m optionalAttr) {
		m["normalized"] = value
	}
}

// ExtractGlimpseV2UniformNoise sets the optional uniform_noise attribute to value.
//
// value: indicates if the noise should be generated using a
// uniform distribution or a Gaussian distribution.
// It should not be `True` when `noise` is not `uniform`.
// If not specified, defaults to true
func ExtractGlimpseV2UniformNoise(value bool) ExtractGlimpseV2Attr {
	return func(m optionalAttr) {
		m["uniform_noise"] = value
	}
}

// ExtractGlimpseV2Noise sets the optional noise attribute to value.
//
// value: indicates if the noise should `uniform`, `gaussian`, or
// `zero`. The default is `uniform` which means the noise type
// will be decided by `uniform_noise`.
// If not specified, defaults to "uniform"
func ExtractGlimpseV2Noise(value string) ExtractGlimpseV2Attr {
	return func(m optionalAttr) {
		m["noise"] = value
	}
}

// Extracts a glimpse from the input tensor.
//
// Returns a set of windows called glimpses extracted at location
// `offsets` from the input tensor. If the windows only partially
// overlaps the inputs, the non overlapping areas will be filled with
// random noise.
//
// The result is a 4-D tensor of shape `[batch_size, glimpse_height,
// glimpse_width, channels]`. The channels and batch dimensions are the
// same as that of the input tensor. The height and width of the output
// windows are specified in the `size` parameter.
//
// The argument `normalized` and `centered` controls how the windows are built:
//
//   - If the coordinates are normalized but not centered, 0.0 and 1.0
//     correspond to the minimum and maximum of each height and width
//     dimension.
//   - If the coordinates are both normalized and centered, they range from
//     -1.0 to 1.0. The coordinates (-1.0, -1.0) correspond to the upper
//     left corner, the lower right corner is located at (1.0, 1.0) and the
//     center is at (0, 0).
//   - If the coordinates are not normalized they are interpreted as
//     numbers of pixels.
//
// Arguments:
//
//	input: A 4-D float tensor of shape `[batch_size, height, width, channels]`.
//	size: A 1-D tensor of 2 elements containing the size of the glimpses
//
// to extract.  The glimpse height must be specified first, following
// by the glimpse width.
//
//	offsets: A 2-D integer tensor of shape `[batch_size, 2]` containing
//
// the y, x locations of the center of each window.
//
// Returns A tensor representing the glimpses `[batch_size,
// glimpse_height, glimpse_width, channels]`.
func ExtractGlimpseV2(scope *Scope, input tf.Output, size tf.Output, offsets tf.Output, optional ...ExtractGlimpseV2Attr) (glimpse tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ExtractGlimpseV2",
		Input: []tf.Input{
			input, size, offsets,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Extract `patches` from `images` and put them in the "depth" output dimension.
//
// Arguments:
//
//	images: 4-D Tensor with shape `[batch, in_rows, in_cols, depth]`.
//	ksizes: The size of the sliding window for each dimension of `images`.
//	strides: How far the centers of two consecutive patches are in
//
// the images. Must be: `[1, stride_rows, stride_cols, 1]`.
//
//	rates: Must be: `[1, rate_rows, rate_cols, 1]`. This is the
//
// input stride, specifying how far two consecutive patch samples are in the
// input. Equivalent to extracting patches with
// `patch_sizes_eff = patch_sizes + (patch_sizes - 1) * (rates - 1)`, followed by
// subsampling them spatially by a factor of `rates`. This is equivalent to
// `rate` in dilated (a.k.a. Atrous) convolutions.
//
//	padding: The type of padding algorithm to use.
//
// Returns 4-D Tensor with shape `[batch, out_rows, out_cols, ksize_rows *
// ksize_cols * depth]` containing image patches with size
// `ksize_rows x ksize_cols x depth` vectorized in the "depth" dimension. Note
// `out_rows` and `out_cols` are the dimensions of the output patches.
func ExtractImagePatches(scope *Scope, images tf.Output, ksizes []int64, strides []int64, rates []int64, padding string) (patches tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"ksizes": ksizes, "strides": strides, "rates": rates, "padding": padding}
	opspec := tf.OpSpec{
		Type: "ExtractImagePatches",
		Input: []tf.Input{
			images,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ExtractJpegShapeAttr is an optional argument to ExtractJpegShape.
type ExtractJpegShapeAttr func(optionalAttr)

// ExtractJpegShapeOutputType sets the optional output_type attribute to value.
//
// value: (Optional) The output type of the operation (int32 or int64).
// Defaults to int32.
// If not specified, defaults to DT_INT32
func ExtractJpegShapeOutputType(value tf.DataType) ExtractJpegShapeAttr {
	return func(m optionalAttr) {
		m["output_type"] = value
	}
}

// Extract the shape information of a JPEG-encoded image.
//
// This op only parses the image header, so it is much faster than DecodeJpeg.
//
// Arguments:
//
//	contents: 0-D. The JPEG-encoded image.
//
// Returns 1-D. The image shape with format [height, width, channels].
func ExtractJpegShape(scope *Scope, contents tf.Output, optional ...ExtractJpegShapeAttr) (image_shape tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ExtractJpegShape",
		Input: []tf.Input{
			contents,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Extract `patches` from `input` and put them in the `"depth"` output dimension. 3D extension of `extract_image_patches`.
//
// Arguments:
//
//	input: 5-D Tensor with shape `[batch, in_planes, in_rows, in_cols, depth]`.
//	ksizes: The size of the sliding window for each dimension of `input`.
//	strides: 1-D of length 5. How far the centers of two consecutive patches are in
//
// `input`. Must be: `[1, stride_planes, stride_rows, stride_cols, 1]`.
//
//	padding: The type of padding algorithm to use.
//
// The size-related attributes are specified as follows:
//
// ```python
// ksizes = [1, ksize_planes, ksize_rows, ksize_cols, 1]
// strides = [1, stride_planes, strides_rows, strides_cols, 1]
// ```
//
// Returns 5-D Tensor with shape `[batch, out_planes, out_rows, out_cols,
// ksize_planes * ksize_rows * ksize_cols * depth]` containing patches
// with size `ksize_planes x ksize_rows x ksize_cols x depth` vectorized
// in the "depth" dimension. Note `out_planes`, `out_rows` and `out_cols`
// are the dimensions of the output patches.
func ExtractVolumePatches(scope *Scope, input tf.Output, ksizes []int64, strides []int64, padding string) (patches tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"ksizes": ksizes, "strides": strides, "padding": padding}
	opspec := tf.OpSpec{
		Type: "ExtractVolumePatches",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Fast Fourier transform.
//
// Computes the 1-dimensional discrete Fourier transform over the inner-most
// dimension of `input`.
//
// Arguments:
//
//	input: A complex tensor.
//
// Returns A complex tensor of the same shape as `input`. The inner-most
//
//	dimension of `input` is replaced with its 1D Fourier transform.
//
// @compatibility(numpy)
// Equivalent to np.fft.fft
// @end_compatibility
func FFT(scope *Scope, input tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "FFT",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// 2D fast Fourier transform.
//
// Computes the 2-dimensional discrete Fourier transform over the inner-most
// 2 dimensions of `input`.
//
// Arguments:
//
//	input: A complex tensor.
//
// Returns A complex tensor of the same shape as `input`. The inner-most 2
//
//	dimensions of `input` are replaced with their 2D Fourier transform.
//
// @compatibility(numpy)
// Equivalent to np.fft.fft2
// @end_compatibility
func FFT2D(scope *Scope, input tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "FFT2D",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// 3D fast Fourier transform.
//
// Computes the 3-dimensional discrete Fourier transform over the inner-most 3
// dimensions of `input`.
//
// Arguments:
//
//	input: A complex tensor.
//
// Returns A complex tensor of the same shape as `input`. The inner-most 3
//
//	dimensions of `input` are replaced with their 3D Fourier transform.
//
// @compatibility(numpy)
// Equivalent to np.fft.fftn with 3 dimensions.
// @end_compatibility
func FFT3D(scope *Scope, input tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "FFT3D",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ND fast Fourier transform.
//
// Computes the n-dimensional discrete Fourier transform over
// designated dimensions of `input`. The designated dimensions of
// `input` are assumed to be the result of `FFTND`.
//
// If fft_length[i]<shape(input)[i], the input is cropped. If
// fft_length[i]>shape(input)[i], the input is padded with zeros. If fft_length
// is not given, the default shape(input) is used.
//
// Axes mean the dimensions to perform the transform on. Default is to perform on
// all axes.
//
// Arguments:
//
//	input: A complex tensor.
//	fft_length: An int32 tensor. The FFT length for each dimension.
//	axes: An int32 tensor with a same shape as fft_length. Axes to perform the transform.
//
// Returns A complex tensor of the same shape as `input`. The designated
// dimensions of `input` are replaced with their Fourier transforms.
//
// @compatibility(numpy)
// Equivalent to np.fft.fftn.
// @end_compatibility
func FFTND(scope *Scope, input tf.Output, fft_length tf.Output, axes tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "FFTND",
		Input: []tf.Input{
			input, fft_length, axes,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// FIFOQueueV2Attr is an optional argument to FIFOQueueV2.
type FIFOQueueV2Attr func(optionalAttr)

// FIFOQueueV2Shapes sets the optional shapes attribute to value.
//
// value: The shape of each component in a value. The length of this attr must
// be either 0 or the same as the length of component_types. If the length of
// this attr is 0, the shapes of queue elements are not constrained, and
// only one element may be dequeued at a time.
// If not specified, defaults to {}
//
// REQUIRES: len(value) >= 0
func FIFOQueueV2Shapes(value []tf.Shape) FIFOQueueV2Attr {
	return func(m optionalAttr) {
		m["shapes"] = value
	}
}

// FIFOQueueV2Capacity sets the optional capacity attribute to value.
//
// value: The upper bound on the number of elements in this queue.
// Negative numbers mean no limit.
// If not specified, defaults to -1
func FIFOQueueV2Capacity(value int64) FIFOQueueV2Attr {
	return func(m optionalAttr) {
		m["capacity"] = value
	}
}

// FIFOQueueV2Container sets the optional container attribute to value.
//
// value: If non-empty, this queue is placed in the given container.
// Otherwise, a default container is used.
// If not specified, defaults to ""
func FIFOQueueV2Container(value string) FIFOQueueV2Attr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// FIFOQueueV2SharedName sets the optional shared_name attribute to value.
//
// value: If non-empty, this queue will be shared under the given name
// across multiple sessions.
// If not specified, defaults to ""
func FIFOQueueV2SharedName(value string) FIFOQueueV2Attr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// A queue that produces elements in first-in first-out order.
//
// Arguments:
//
//	component_types: The type of each component in a value.
//
// Returns The handle to the queue.
func FIFOQueueV2(scope *Scope, component_types []tf.DataType, optional ...FIFOQueueV2Attr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"component_types": component_types}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FIFOQueueV2",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Output a fact about factorials.
func Fact(scope *Scope) (fact tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Fact",
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

//	This op is used as a placeholder in If branch functions. It doesn't provide a
//	valid output when run, so must either be removed (e.g. replaced with a
//	function input) or guaranteed not to be used (e.g. if mirroring an
//	intermediate output needed for the gradient computation of the other branch).
//
// Arguments:
//
//		dtype: The type of the output.
//		shape:     The purported shape of the output. This is only used for shape inference;
//	    the output will not necessarily have this shape. Can be a partial shape.
//
// Returns     \"Fake\" output value. This should not be consumed by another op.
func FakeParam(scope *Scope, dtype tf.DataType, shape tf.Shape) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtype": dtype, "shape": shape}
	opspec := tf.OpSpec{
		Type: "FakeParam",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// FakeQuantWithMinMaxArgsAttr is an optional argument to FakeQuantWithMinMaxArgs.
type FakeQuantWithMinMaxArgsAttr func(optionalAttr)

// FakeQuantWithMinMaxArgsMin sets the optional min attribute to value.
// If not specified, defaults to -6
func FakeQuantWithMinMaxArgsMin(value float32) FakeQuantWithMinMaxArgsAttr {
	return func(m optionalAttr) {
		m["min"] = value
	}
}

// FakeQuantWithMinMaxArgsMax sets the optional max attribute to value.
// If not specified, defaults to 6
func FakeQuantWithMinMaxArgsMax(value float32) FakeQuantWithMinMaxArgsAttr {
	return func(m optionalAttr) {
		m["max"] = value
	}
}

// FakeQuantWithMinMaxArgsNumBits sets the optional num_bits attribute to value.
// If not specified, defaults to 8
func FakeQuantWithMinMaxArgsNumBits(value int64) FakeQuantWithMinMaxArgsAttr {
	return func(m optionalAttr) {
		m["num_bits"] = value
	}
}

// FakeQuantWithMinMaxArgsNarrowRange sets the optional narrow_range attribute to value.
// If not specified, defaults to false
func FakeQuantWithMinMaxArgsNarrowRange(value bool) FakeQuantWithMinMaxArgsAttr {
	return func(m optionalAttr) {
		m["narrow_range"] = value
	}
}

// Fake-quantize the 'inputs' tensor, type float to 'outputs' tensor of same shape and type.
//
//	Quantization is called fake since the output is still in floating point.
//	The API converts inputs into values within the range [min and max] and returns
//	as output.
//
// # Attributes
//
// *   `[min; max]` define the clamping range for the `inputs` data.
// *   `inputs` values are quantized into the quantization range (
// `[0; 2^num_bits - 1]` when `narrow_range` is false and `[1; 2^num_bits - 1]`
// when it is true) and then de-quantized and output as floats in `[min; max]`
// interval.
// *   `num_bits` is the bitwidth of the quantization; between 2 and 16, inclusive.
//
// Before quantization, `min` and `max` values are adjusted with the following
// logic.
// It is suggested to have `min <= 0 <= max`. If `0` is not in the range of values,
// the behavior can be unexpected:
//
// *   If `0 < min < max`: `min_adj = 0` and `max_adj = max - min`.
// *   If `min < max < 0`: `min_adj = min - max` and `max_adj = 0`.
// *   If `min <= 0 <= max`: `scale = (max - min) / (2^num_bits - 1) `,
// `min_adj = scale * round(min / scale)` and `max_adj = max + min_adj - min`.
//
// # Examples
//
// ```python
//
// inp = tf.constant ([10.03, -10.23, 3])
// out = tf.quantization.fake_quant_with_min_max_args(inp, min=-5, max=5,
//
//	num_bits=16)
//
// print(out)
//
// #  Output:
// #  tf.Tensor([ 4.9999237 -5.0000763  3.0000763], shape=(3,), dtype=float32)
// ```
//
// Raises:
//   - InvalidArgumentError:
//   - If num_bits are outside of range [2, 16].
//   - If min >= max.
//   - ValueError: If `inputs` are of any other type than float32.
func FakeQuantWithMinMaxArgs(scope *Scope, inputs tf.Output, optional ...FakeQuantWithMinMaxArgsAttr) (outputs tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FakeQuantWithMinMaxArgs",
		Input: []tf.Input{
			inputs,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// FakeQuantWithMinMaxArgsGradientAttr is an optional argument to FakeQuantWithMinMaxArgsGradient.
type FakeQuantWithMinMaxArgsGradientAttr func(optionalAttr)

// FakeQuantWithMinMaxArgsGradientMin sets the optional min attribute to value.
// If not specified, defaults to -6
func FakeQuantWithMinMaxArgsGradientMin(value float32) FakeQuantWithMinMaxArgsGradientAttr {
	return func(m optionalAttr) {
		m["min"] = value
	}
}

// FakeQuantWithMinMaxArgsGradientMax sets the optional max attribute to value.
// If not specified, defaults to 6
func FakeQuantWithMinMaxArgsGradientMax(value float32) FakeQuantWithMinMaxArgsGradientAttr {
	return func(m optionalAttr) {
		m["max"] = value
	}
}

// FakeQuantWithMinMaxArgsGradientNumBits sets the optional num_bits attribute to value.
// If not specified, defaults to 8
func FakeQuantWithMinMaxArgsGradientNumBits(value int64) FakeQuantWithMinMaxArgsGradientAttr {
	return func(m optionalAttr) {
		m["num_bits"] = value
	}
}

// FakeQuantWithMinMaxArgsGradientNarrowRange sets the optional narrow_range attribute to value.
// If not specified, defaults to false
func FakeQuantWithMinMaxArgsGradientNarrowRange(value bool) FakeQuantWithMinMaxArgsGradientAttr {
	return func(m optionalAttr) {
		m["narrow_range"] = value
	}
}

// Compute gradients for a FakeQuantWithMinMaxArgs operation.
//
// Arguments:
//
//	gradients: Backpropagated gradients above the FakeQuantWithMinMaxArgs operation.
//	inputs: Values passed as inputs to the FakeQuantWithMinMaxArgs operation.
//
// Returns Backpropagated gradients below the FakeQuantWithMinMaxArgs operation:
// `gradients * (inputs >= min && inputs <= max)`.
//
// ```
// import tensorflow as tf
//
// # Define some sample data
// gradients = tf.random.uniform((2, 3), minval=-5.0, maxval=5.0, dtype=tf.float32)
// inputs = tf.random.uniform((2, 3), minval=-10.0, maxval=10.0, dtype=tf.float32)
//
// # Define quantization parameters (adjust as needed)
// min_val = -2.0
// max_val = 8.0
// num_bits = 4  # Number of bits for quantization
//
// # Calculate gradients for fake quantization with specified parameters
// output_gradients = tf.quantization.fake_quant_with_min_max_args_gradient(
//
//	gradients=gradients, inputs=inputs, min=min_val, max=max_val, num_bits=num_bits, narrow_range = False, name=None
//
// )
//
// # Print the original gradients and the gradients after the fake-quant operation
// print("Original Gradients:")
// print(gradients)
// print("\nGradients after Fake-Quantization:")
// print(output_gradients)
//
// ```
// #Original Gradients:
// #tf.Tensor(
// #[[ 1.242547    3.217492    3.568469  ]
// #[-0.55371046  0.23130894  2.608243  ]], shape=(2, 3), dtype=float32)
//
// #Gradients after Fake-Quantization:
// #tf.Tensor(
// #[[ 0.          3.217492    3.568469  ]
// # [-0.55371046  0.23130894  2.608243  ]], shape=(2, 3), dtype=float32)
func FakeQuantWithMinMaxArgsGradient(scope *Scope, gradients tf.Output, inputs tf.Output, optional ...FakeQuantWithMinMaxArgsGradientAttr) (backprops tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FakeQuantWithMinMaxArgsGradient",
		Input: []tf.Input{
			gradients, inputs,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// FakeQuantWithMinMaxVarsAttr is an optional argument to FakeQuantWithMinMaxVars.
type FakeQuantWithMinMaxVarsAttr func(optionalAttr)

// FakeQuantWithMinMaxVarsNumBits sets the optional num_bits attribute to value.
// If not specified, defaults to 8
func FakeQuantWithMinMaxVarsNumBits(value int64) FakeQuantWithMinMaxVarsAttr {
	return func(m optionalAttr) {
		m["num_bits"] = value
	}
}

// FakeQuantWithMinMaxVarsNarrowRange sets the optional narrow_range attribute to value.
// If not specified, defaults to false
func FakeQuantWithMinMaxVarsNarrowRange(value bool) FakeQuantWithMinMaxVarsAttr {
	return func(m optionalAttr) {
		m["narrow_range"] = value
	}
}

// Fake-quantize the 'inputs' tensor of type float via global float scalars
//
// Fake-quantize the `inputs` tensor of type float via global float scalars
// `min` and `max` to `outputs` tensor of same shape as `inputs`.
//
// # Attributes
//
// *   `[min; max]` define the clamping range for the `inputs` data.
// *   `inputs` values are quantized into the quantization range (
// `[0; 2^num_bits - 1]` when `narrow_range` is false and `[1; 2^num_bits - 1]`
// when it is true) and then de-quantized and output as floats in `[min; max]`
// interval.
// *   `num_bits` is the bitwidth of the quantization; between 2 and 16, inclusive.
//
// Before quantization, `min` and `max` values are adjusted with the following
// logic.
// It is suggested to have `min <= 0 <= max`. If `0` is not in the range of values,
// the behavior can be unexpected:
//
// *   If `0 < min < max`: `min_adj = 0` and `max_adj = max - min`.
// *   If `min < max < 0`: `min_adj = min - max` and `max_adj = 0`.
// *   If `min <= 0 <= max`: `scale = (max - min) / (2^num_bits - 1) `,
// `min_adj = scale * round(min / scale)` and `max_adj = max + min_adj - min`.
//
// This operation has a gradient and thus allows for training `min` and `max`
// values.
//
// >>> constant_input = tf.constant([[1.2, -0.3, 0.7], [2.1, 0.5, -1.0]], dtype=tf.float32)
// >>>
// >>> min_val = -0.5
// >>> max_val = 0.8
// >>> num_bits = 8
// >>> narrow_range = False #False:for the quantization range [0; 2^num_bits - 1]
// >>>
// >>> quantized_data = tf.quantization.fake_quant_with_min_max_vars(
// ...   inputs=constant_input, min=min_val, max=max_val, num_bits=num_bits, narrow_range=narrow_range
// ... )
// >>>
// >>> print("Input:\n", constant_input.numpy())
// Input:
// [[ 1.2 -0.3  0.7]
// [ 2.1  0.5 -1. ]]
// >>> print("Output:\n", quantized_data.numpy())
// Output:
// [[ 0.8003921 -0.3007843  0.6984313]
// [ 0.8003921  0.4996078 -0.4996078]]
func FakeQuantWithMinMaxVars(scope *Scope, inputs tf.Output, min tf.Output, max tf.Output, optional ...FakeQuantWithMinMaxVarsAttr) (outputs tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FakeQuantWithMinMaxVars",
		Input: []tf.Input{
			inputs, min, max,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// FakeQuantWithMinMaxVarsGradientAttr is an optional argument to FakeQuantWithMinMaxVarsGradient.
type FakeQuantWithMinMaxVarsGradientAttr func(optionalAttr)

// FakeQuantWithMinMaxVarsGradientNumBits sets the optional num_bits attribute to value.
//
// value: The bitwidth of the quantization; between 2 and 8, inclusive.
// If not specified, defaults to 8
func FakeQuantWithMinMaxVarsGradientNumBits(value int64) FakeQuantWithMinMaxVarsGradientAttr {
	return func(m optionalAttr) {
		m["num_bits"] = value
	}
}

// FakeQuantWithMinMaxVarsGradientNarrowRange sets the optional narrow_range attribute to value.
//
// value: Whether to quantize into 2^num_bits - 1 distinct values.
// If not specified, defaults to false
func FakeQuantWithMinMaxVarsGradientNarrowRange(value bool) FakeQuantWithMinMaxVarsGradientAttr {
	return func(m optionalAttr) {
		m["narrow_range"] = value
	}
}

// Compute gradients for a FakeQuantWithMinMaxVars operation.
//
// Arguments:
//
//	gradients: Backpropagated gradients above the FakeQuantWithMinMaxVars operation.
//	inputs: Values passed as inputs to the FakeQuantWithMinMaxVars operation.
//
// min, max: Quantization interval, scalar floats.
//
// Returns:
//
//	backprops_wrt_input: Backpropagated gradients w.r.t. inputs:
//
// `gradients * (inputs >= min && inputs <= max)`.
//
//	backprop_wrt_min: Backpropagated gradients w.r.t. min parameter:
//
// `sum(gradients * (inputs < min))`.
//
//	backprop_wrt_max: Backpropagated gradients w.r.t. max parameter:
//
// `sum(gradients * (inputs > max))`.
func FakeQuantWithMinMaxVarsGradient(scope *Scope, gradients tf.Output, inputs tf.Output, min tf.Output, max tf.Output, optional ...FakeQuantWithMinMaxVarsGradientAttr) (backprops_wrt_input tf.Output, backprop_wrt_min tf.Output, backprop_wrt_max tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FakeQuantWithMinMaxVarsGradient",
		Input: []tf.Input{
			gradients, inputs, min, max,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// FakeQuantWithMinMaxVarsPerChannelAttr is an optional argument to FakeQuantWithMinMaxVarsPerChannel.
type FakeQuantWithMinMaxVarsPerChannelAttr func(optionalAttr)

// FakeQuantWithMinMaxVarsPerChannelNumBits sets the optional num_bits attribute to value.
// If not specified, defaults to 8
func FakeQuantWithMinMaxVarsPerChannelNumBits(value int64) FakeQuantWithMinMaxVarsPerChannelAttr {
	return func(m optionalAttr) {
		m["num_bits"] = value
	}
}

// FakeQuantWithMinMaxVarsPerChannelNarrowRange sets the optional narrow_range attribute to value.
// If not specified, defaults to false
func FakeQuantWithMinMaxVarsPerChannelNarrowRange(value bool) FakeQuantWithMinMaxVarsPerChannelAttr {
	return func(m optionalAttr) {
		m["narrow_range"] = value
	}
}

// Fake-quantize the 'inputs' tensor of type float via per-channel floats
//
// Fake-quantize the `inputs` tensor of type float per-channel and one of the
// shapes: `[d]`, `[b, d]` `[b, h, w, d]` via per-channel floats `min` and `max`
// of shape `[d]` to `outputs` tensor of same shape as `inputs`.
//
// # Attributes
//
// *   `[min; max]` define the clamping range for the `inputs` data.
// *   `inputs` values are quantized into the quantization range (
// `[0; 2^num_bits - 1]` when `narrow_range` is false and `[1; 2^num_bits - 1]`
// when it is true) and then de-quantized and output as floats in `[min; max]`
// interval.
// *   `num_bits` is the bitwidth of the quantization; between 2 and 16, inclusive.
//
// Before quantization, `min` and `max` values are adjusted with the following
// logic.
// It is suggested to have `min <= 0 <= max`. If `0` is not in the range of values,
// the behavior can be unexpected:
//
// *   If `0 < min < max`: `min_adj = 0` and `max_adj = max - min`.
// *   If `min < max < 0`: `min_adj = min - max` and `max_adj = 0`.
// *   If `min <= 0 <= max`: `scale = (max - min) / (2^num_bits - 1) `,
// `min_adj = scale * round(min / scale)` and `max_adj = max + min_adj - min`.
//
// This operation has a gradient and thus allows for training `min` and `max`
// values.
func FakeQuantWithMinMaxVarsPerChannel(scope *Scope, inputs tf.Output, min tf.Output, max tf.Output, optional ...FakeQuantWithMinMaxVarsPerChannelAttr) (outputs tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FakeQuantWithMinMaxVarsPerChannel",
		Input: []tf.Input{
			inputs, min, max,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// FakeQuantWithMinMaxVarsPerChannelGradientAttr is an optional argument to FakeQuantWithMinMaxVarsPerChannelGradient.
type FakeQuantWithMinMaxVarsPerChannelGradientAttr func(optionalAttr)

// FakeQuantWithMinMaxVarsPerChannelGradientNumBits sets the optional num_bits attribute to value.
//
// value: The bitwidth of the quantization; between 2 and 16, inclusive.
// If not specified, defaults to 8
func FakeQuantWithMinMaxVarsPerChannelGradientNumBits(value int64) FakeQuantWithMinMaxVarsPerChannelGradientAttr {
	return func(m optionalAttr) {
		m["num_bits"] = value
	}
}

// FakeQuantWithMinMaxVarsPerChannelGradientNarrowRange sets the optional narrow_range attribute to value.
//
// value: Whether to quantize into 2^num_bits - 1 distinct values.
// If not specified, defaults to false
func FakeQuantWithMinMaxVarsPerChannelGradientNarrowRange(value bool) FakeQuantWithMinMaxVarsPerChannelGradientAttr {
	return func(m optionalAttr) {
		m["narrow_range"] = value
	}
}

// Compute gradients for a FakeQuantWithMinMaxVarsPerChannel operation.
//
// Arguments:
//
//	gradients: Backpropagated gradients above the FakeQuantWithMinMaxVars operation,
//
// shape one of: `[d]`, `[b, d]`,  `[b, h, w, d]`.
//
//		inputs: Values passed as inputs to the FakeQuantWithMinMaxVars operation, shape
//	  same as `gradients`.
//
// min, max: Quantization interval, floats of shape `[d]`.
//
// Returns:
//
//	backprops_wrt_input: Backpropagated gradients w.r.t. inputs, shape same as
//
// `inputs`:
//
//	  `gradients * (inputs >= min && inputs <= max)`.
//		backprop_wrt_min: Backpropagated gradients w.r.t. min parameter, shape `[d]`:
//
// `sum_per_d(gradients * (inputs < min))`.
//
//	backprop_wrt_max: Backpropagated gradients w.r.t. max parameter, shape `[d]`:
//
// `sum_per_d(gradients * (inputs > max))`.
func FakeQuantWithMinMaxVarsPerChannelGradient(scope *Scope, gradients tf.Output, inputs tf.Output, min tf.Output, max tf.Output, optional ...FakeQuantWithMinMaxVarsPerChannelGradientAttr) (backprops_wrt_input tf.Output, backprop_wrt_min tf.Output, backprop_wrt_max tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FakeQuantWithMinMaxVarsPerChannelGradient",
		Input: []tf.Input{
			gradients, inputs, min, max,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// Set configuration of the file system.
//
// Arguments:
//
//	scheme: File system scheme.
//	key: The name of the configuration option.
//	value: The value of the configuration option.
//
// Returns the created operation.
func FileSystemSetConfiguration(scope *Scope, scheme tf.Output, key tf.Output, value tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "FileSystemSetConfiguration",
		Input: []tf.Input{
			scheme, key, value,
		},
	}
	return scope.AddOperation(opspec)
}

// Creates a tensor filled with a scalar value.
//
// This operation creates a tensor of shape `dims` and fills it with `value`.
//
// For example:
//
// ```
// # Output tensor has shape [2, 3].
// fill([2, 3], 9) ==> [[9, 9, 9]
//
//	[9, 9, 9]]
//
// ```
//
// `tf.fill` differs from `tf.constant` in a few ways:
//
//   - `tf.fill` only supports scalar contents, whereas `tf.constant` supports
//     Tensor values.
//   - `tf.fill` creates an Op in the computation graph that constructs the actual
//     Tensor value at runtime. This is in contrast to `tf.constant` which embeds
//     the entire Tensor into the graph with a `Const` node.
//   - Because `tf.fill` evaluates at graph runtime, it supports dynamic shapes
//     based on other runtime Tensors, unlike `tf.constant`.
//
// Arguments:
//
//	dims: 1-D. Represents the shape of the output tensor.
//	value: 0-D (scalar). Value to fill the returned tensor.
//
// @compatibility(numpy)
// Equivalent to np.full
// @end_compatibility
func Fill(scope *Scope, dims tf.Output, value tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Fill",
		Input: []tf.Input{
			dims, value,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates a dataset containing elements of first component of `input_dataset` having true in the last component.
func FilterByLastComponentDataset(scope *Scope, input_dataset tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "FilterByLastComponentDataset",
		Input: []tf.Input{
			input_dataset,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// FinalizeDatasetAttr is an optional argument to FinalizeDataset.
type FinalizeDatasetAttr func(optionalAttr)

// FinalizeDatasetHasCapturedRef sets the optional has_captured_ref attribute to value.
// If not specified, defaults to false
func FinalizeDatasetHasCapturedRef(value bool) FinalizeDatasetAttr {
	return func(m optionalAttr) {
		m["has_captured_ref"] = value
	}
}

// Creates a dataset by applying `tf.data.Options` to `input_dataset`.
//
// Arguments:
//
//	input_dataset: A variant tensor representing the input dataset.
func FinalizeDataset(scope *Scope, input_dataset tf.Output, output_types []tf.DataType, output_shapes []tf.Shape, optional ...FinalizeDatasetAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FinalizeDataset",
		Input: []tf.Input{
			input_dataset,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// An op that finalizes the TPUEmbedding configuration.
//
// Arguments:
//
//	common_config: A string-encoded common configuration proto containing metadata
//
// about the TPUEmbedding partitioner output and the HBM size (in bytes) required
// for operation.
//
//	memory_config: A string-encoded memory config proto containing metadata about
//
// the memory allocations reserved for TPUEmbedding.
//
// Returns the created operation.
func FinalizeTPUEmbedding(scope *Scope, common_config tf.Output, memory_config tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "FinalizeTPUEmbedding",
		Input: []tf.Input{
			common_config, memory_config,
		},
	}
	return scope.AddOperation(opspec)
}

// An op that finalizes the TPUEmbedding configuration.
//
// Arguments:
//
//	common_config: A string-encoded common configuration proto containing metadata
//
// about the TPUEmbedding partitioner output and the HBM size (in bytes) required
// for operation.
//
//	memory_config: A string-encoded memory config proto containing metadata about
//
// the memory allocations reserved for TPUEmbedding.
//
// Returns:
//
//	embedding_partitions: A string-encoded embedding partitions proto describing how embedding tables are
//
// partitioned along their feature and ID.
//
//	hbm_buffers_config: A string-encoded HBM buffers config proto specifies where HBM buffers are
//
// located.
func FinalizeTPUEmbeddingV2(scope *Scope, common_config tf.Output, memory_config tf.Output) (embedding_partitions tf.Output, hbm_buffers_config tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "FinalizeTPUEmbeddingV2",
		Input: []tf.Input{
			common_config, memory_config,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Generates fingerprint values.
//
// Generates fingerprint values of `data`.
//
// Fingerprint op considers the first dimension of `data` as the batch dimension,
// and `output[i]` contains the fingerprint value generated from contents in
// `data[i, ...]` for all `i`.
//
// Fingerprint op writes fingerprint values as byte arrays. For example, the
// default method `farmhash64` generates a 64-bit fingerprint value at a time.
// This 8-byte value is written out as an `uint8` array of size 8, in little-endian
// order.
//
// For example, suppose that `data` has data type `DT_INT32` and shape (2, 3, 4),
// and that the fingerprint method is `farmhash64`. In this case, the output shape
// is (2, 8), where 2 is the batch dimension size of `data`, and 8 is the size of
// each fingerprint value in bytes. `output[0, :]` is generated from 12 integers in
// `data[0, :, :]` and similarly `output[1, :]` is generated from other 12 integers
// in `data[1, :, :]`.
//
// Note that this op fingerprints the raw underlying buffer, and it does not
// fingerprint Tensor's metadata such as data type and/or shape. For example, the
// fingerprint values are invariant under reshapes and bitcasts as long as the
// batch dimension remain the same:
//
// ```
// Fingerprint(data) == Fingerprint(Reshape(data, ...))
// Fingerprint(data) == Fingerprint(Bitcast(data, ...))
// ```
//
// For string data, one should expect `Fingerprint(data) !=
// Fingerprint(ReduceJoin(data))` in general.
//
// Arguments:
//
//	data: Must have rank 1 or higher.
//	method: Fingerprint method used by this op. Currently available method is
//
// `farmhash::fingerprint64`.
//
// Returns A two-dimensional `Tensor` of type `tf.uint8`. The first dimension equals to
// `data`'s first dimension, and the second dimension size depends on the
// fingerprint algorithm.
func Fingerprint(scope *Scope, data tf.Output, method tf.Output) (fingerprint tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Fingerprint",
		Input: []tf.Input{
			data, method,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// FixedLengthRecordDatasetAttr is an optional argument to FixedLengthRecordDataset.
type FixedLengthRecordDatasetAttr func(optionalAttr)

// FixedLengthRecordDatasetMetadata sets the optional metadata attribute to value.
// If not specified, defaults to ""
func FixedLengthRecordDatasetMetadata(value string) FixedLengthRecordDatasetAttr {
	return func(m optionalAttr) {
		m["metadata"] = value
	}
}

// Creates a dataset that emits the records from one or more binary files.
//
// Arguments:
//
//	filenames: A scalar or a vector containing the name(s) of the file(s) to be
//
// read.
//
//	header_bytes: A scalar representing the number of bytes to skip at the
//
// beginning of a file.
//
//	record_bytes: A scalar representing the number of bytes in each record.
//	footer_bytes: A scalar representing the number of bytes to skip at the end
//
// of a file.
//
//	buffer_size: A scalar representing the number of bytes to buffer. Must be > 0.
func FixedLengthRecordDataset(scope *Scope, filenames tf.Output, header_bytes tf.Output, record_bytes tf.Output, footer_bytes tf.Output, buffer_size tf.Output, optional ...FixedLengthRecordDatasetAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FixedLengthRecordDataset",
		Input: []tf.Input{
			filenames, header_bytes, record_bytes, footer_bytes, buffer_size,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// FixedLengthRecordReaderV2Attr is an optional argument to FixedLengthRecordReaderV2.
type FixedLengthRecordReaderV2Attr func(optionalAttr)

// FixedLengthRecordReaderV2HeaderBytes sets the optional header_bytes attribute to value.
//
// value: Number of bytes in the header, defaults to 0.
// If not specified, defaults to 0
func FixedLengthRecordReaderV2HeaderBytes(value int64) FixedLengthRecordReaderV2Attr {
	return func(m optionalAttr) {
		m["header_bytes"] = value
	}
}

// FixedLengthRecordReaderV2FooterBytes sets the optional footer_bytes attribute to value.
//
// value: Number of bytes in the footer, defaults to 0.
// If not specified, defaults to 0
func FixedLengthRecordReaderV2FooterBytes(value int64) FixedLengthRecordReaderV2Attr {
	return func(m optionalAttr) {
		m["footer_bytes"] = value
	}
}

// FixedLengthRecordReaderV2HopBytes sets the optional hop_bytes attribute to value.
//
// value: Number of bytes to hop before each read. Default of 0 means using
// record_bytes.
// If not specified, defaults to 0
func FixedLengthRecordReaderV2HopBytes(value int64) FixedLengthRecordReaderV2Attr {
	return func(m optionalAttr) {
		m["hop_bytes"] = value
	}
}

// FixedLengthRecordReaderV2Container sets the optional container attribute to value.
//
// value: If non-empty, this reader is placed in the given container.
// Otherwise, a default container is used.
// If not specified, defaults to ""
func FixedLengthRecordReaderV2Container(value string) FixedLengthRecordReaderV2Attr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// FixedLengthRecordReaderV2SharedName sets the optional shared_name attribute to value.
//
// value: If non-empty, this reader is named in the given bucket
// with this shared_name. Otherwise, the node name is used instead.
// If not specified, defaults to ""
func FixedLengthRecordReaderV2SharedName(value string) FixedLengthRecordReaderV2Attr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// FixedLengthRecordReaderV2Encoding sets the optional encoding attribute to value.
//
// value: The type of encoding for the file. Currently ZLIB and GZIP
// are supported. Defaults to none.
// If not specified, defaults to ""
func FixedLengthRecordReaderV2Encoding(value string) FixedLengthRecordReaderV2Attr {
	return func(m optionalAttr) {
		m["encoding"] = value
	}
}

// A Reader that outputs fixed-length records from a file.
//
// Arguments:
//
//	record_bytes: Number of bytes in the record.
//
// Returns The handle to reference the Reader.
func FixedLengthRecordReaderV2(scope *Scope, record_bytes int64, optional ...FixedLengthRecordReaderV2Attr) (reader_handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"record_bytes": record_bytes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FixedLengthRecordReaderV2",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// FixedUnigramCandidateSamplerAttr is an optional argument to FixedUnigramCandidateSampler.
type FixedUnigramCandidateSamplerAttr func(optionalAttr)

// FixedUnigramCandidateSamplerVocabFile sets the optional vocab_file attribute to value.
//
// value: Each valid line in this file (which should have a CSV-like format)
// corresponds to a valid word ID. IDs are in sequential order, starting from
// num_reserved_ids. The last entry in each line is expected to be a value
// corresponding to the count or relative probability. Exactly one of vocab_file
// and unigrams needs to be passed to this op.
// If not specified, defaults to ""
func FixedUnigramCandidateSamplerVocabFile(value string) FixedUnigramCandidateSamplerAttr {
	return func(m optionalAttr) {
		m["vocab_file"] = value
	}
}

// FixedUnigramCandidateSamplerDistortion sets the optional distortion attribute to value.
//
// value: The distortion is used to skew the unigram probability distribution.
// Each weight is first raised to the distortion's power before adding to the
// internal unigram distribution. As a result, distortion = 1.0 gives regular
// unigram sampling (as defined by the vocab file), and distortion = 0.0 gives
// a uniform distribution.
// If not specified, defaults to 1
func FixedUnigramCandidateSamplerDistortion(value float32) FixedUnigramCandidateSamplerAttr {
	return func(m optionalAttr) {
		m["distortion"] = value
	}
}

// FixedUnigramCandidateSamplerNumReservedIds sets the optional num_reserved_ids attribute to value.
//
// value: Optionally some reserved IDs can be added in the range [0,
// ..., num_reserved_ids) by the users. One use case is that a special unknown
// word token is used as ID 0. These IDs will have a sampling probability of 0.
// If not specified, defaults to 0
func FixedUnigramCandidateSamplerNumReservedIds(value int64) FixedUnigramCandidateSamplerAttr {
	return func(m optionalAttr) {
		m["num_reserved_ids"] = value
	}
}

// FixedUnigramCandidateSamplerNumShards sets the optional num_shards attribute to value.
//
// value: A sampler can be used to sample from a subset of the original range
// in order to speed up the whole computation through parallelism. This parameter
// (together with 'shard') indicates the number of partitions that are being
// used in the overall computation.
// If not specified, defaults to 1
//
// REQUIRES: value >= 1
func FixedUnigramCandidateSamplerNumShards(value int64) FixedUnigramCandidateSamplerAttr {
	return func(m optionalAttr) {
		m["num_shards"] = value
	}
}

// FixedUnigramCandidateSamplerShard sets the optional shard attribute to value.
//
// value: A sampler can be used to sample from a subset of the original range
// in order to speed up the whole computation through parallelism. This parameter
// (together with 'num_shards') indicates the particular partition number of a
// sampler op, when partitioning is being used.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func FixedUnigramCandidateSamplerShard(value int64) FixedUnigramCandidateSamplerAttr {
	return func(m optionalAttr) {
		m["shard"] = value
	}
}

// FixedUnigramCandidateSamplerUnigrams sets the optional unigrams attribute to value.
//
// value: A list of unigram counts or probabilities, one per ID in sequential
// order. Exactly one of vocab_file and unigrams should be passed to this op.
// If not specified, defaults to {}
func FixedUnigramCandidateSamplerUnigrams(value []float32) FixedUnigramCandidateSamplerAttr {
	return func(m optionalAttr) {
		m["unigrams"] = value
	}
}

// FixedUnigramCandidateSamplerSeed sets the optional seed attribute to value.
//
// value: If either seed or seed2 are set to be non-zero, the random number
// generator is seeded by the given seed.  Otherwise, it is seeded by a
// random seed.
// If not specified, defaults to 0
func FixedUnigramCandidateSamplerSeed(value int64) FixedUnigramCandidateSamplerAttr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// FixedUnigramCandidateSamplerSeed2 sets the optional seed2 attribute to value.
//
// value: An second seed to avoid seed collision.
// If not specified, defaults to 0
func FixedUnigramCandidateSamplerSeed2(value int64) FixedUnigramCandidateSamplerAttr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// Generates labels for candidate sampling with a learned unigram distribution.
//
// A unigram sampler could use a fixed unigram distribution read from a
// file or passed in as an in-memory array instead of building up the distribution
// from data on the fly. There is also an option to skew the distribution by
// applying a distortion power to the weights.
//
// The vocabulary file should be in CSV-like format, with the last field
// being the weight associated with the word.
//
// For each batch, this op picks a single set of sampled candidate labels.
//
// The advantages of sampling candidates per-batch are simplicity and the
// possibility of efficient dense matrix multiplication. The disadvantage is that
// the sampled candidates must be chosen independently of the context and of the
// true labels.
//
// Arguments:
//
//	true_classes: A batch_size * num_true matrix, in which each row contains the
//
// IDs of the num_true target_classes in the corresponding original label.
//
//	num_true: Number of true labels per context.
//	num_sampled: Number of candidates to randomly sample.
//	unique: If unique is true, we sample with rejection, so that all sampled
//
// candidates in a batch are unique. This requires some approximation to
// estimate the post-rejection sampling probabilities.
//
//	range_max: The sampler will sample integers from the interval [0, range_max).
//
// Returns:
//
//	sampled_candidates: A vector of length num_sampled, in which each element is
//
// the ID of a sampled candidate.
//
//	true_expected_count: A batch_size * num_true matrix, representing
//
// the number of times each candidate is expected to occur in a batch
// of sampled candidates. If unique=true, then this is a probability.
//
//	sampled_expected_count: A vector of length num_sampled, for each sampled
//
// candidate representing the number of times the candidate is expected
// to occur in a batch of sampled candidates.  If unique=true, then this is a
// probability.
func FixedUnigramCandidateSampler(scope *Scope, true_classes tf.Output, num_true int64, num_sampled int64, unique bool, range_max int64, optional ...FixedUnigramCandidateSamplerAttr) (sampled_candidates tf.Output, true_expected_count tf.Output, sampled_expected_count tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_true": num_true, "num_sampled": num_sampled, "unique": unique, "range_max": range_max}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FixedUnigramCandidateSampler",
		Input: []tf.Input{
			true_classes,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// Returns element-wise largest integer not greater than x.
func Floor(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Floor",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns x // y element-wise.
//
// *NOTE*: `FloorDiv` supports broadcasting. More about broadcasting
// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
func FloorDiv(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "FloorDiv",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns element-wise remainder of division.
//
// This follows Python semantics in that the
// result here is consistent with a flooring divide. E.g.
// `floor(x / y) * y + floormod(x, y) = x`, regardless of the signs of x and y.
//
// *NOTE*: `FloorMod` supports broadcasting. More about broadcasting
// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
func FloorMod(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "FloorMod",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// FractionalAvgPoolAttr is an optional argument to FractionalAvgPool.
type FractionalAvgPoolAttr func(optionalAttr)

// FractionalAvgPoolPseudoRandom sets the optional pseudo_random attribute to value.
//
// value: When set to True, generates the pooling sequence in a
// pseudorandom fashion, otherwise, in a random fashion. Check paper [Benjamin
// Graham, Fractional Max-Pooling](http://arxiv.org/abs/1412.6071) for
// difference between pseudorandom and random.
// If not specified, defaults to false
func FractionalAvgPoolPseudoRandom(value bool) FractionalAvgPoolAttr {
	return func(m optionalAttr) {
		m["pseudo_random"] = value
	}
}

// FractionalAvgPoolOverlapping sets the optional overlapping attribute to value.
//
// value: When set to True, it means when pooling, the values at the boundary
// of adjacent pooling cells are used by both cells. For example:
//
// `index  0  1  2  3  4`
//
// `value  20 5  16 3  7`
//
// If the pooling sequence is [0, 2, 4], then 16, at index 2 will be used twice.
// The result would be [41/3, 26/3] for fractional avg pooling.
// If not specified, defaults to false
func FractionalAvgPoolOverlapping(value bool) FractionalAvgPoolAttr {
	return func(m optionalAttr) {
		m["overlapping"] = value
	}
}

// FractionalAvgPoolDeterministic sets the optional deterministic attribute to value.
//
// value: When set to True, a fixed pooling region will be used when
// iterating over a FractionalAvgPool node in the computation graph. Mainly used
// in unit test to make FractionalAvgPool deterministic.
// If not specified, defaults to false
func FractionalAvgPoolDeterministic(value bool) FractionalAvgPoolAttr {
	return func(m optionalAttr) {
		m["deterministic"] = value
	}
}

// FractionalAvgPoolSeed sets the optional seed attribute to value.
//
// value: If either seed or seed2 are set to be non-zero, the random number
// generator is seeded by the given seed.  Otherwise, it is seeded by a
// random seed.
// If not specified, defaults to 0
func FractionalAvgPoolSeed(value int64) FractionalAvgPoolAttr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// FractionalAvgPoolSeed2 sets the optional seed2 attribute to value.
//
// value: An second seed to avoid seed collision.
// If not specified, defaults to 0
func FractionalAvgPoolSeed2(value int64) FractionalAvgPoolAttr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// Performs fractional average pooling on the input.
//
// Fractional average pooling is similar to Fractional max pooling in the pooling
// region generation step. The only difference is that after pooling regions are
// generated, a mean operation is performed instead of a max operation in each
// pooling region.
//
// Arguments:
//
//	value: 4-D with shape `[batch, height, width, channels]`.
//	pooling_ratio: Pooling ratio for each dimension of `value`, currently only
//
// supports row and col dimension and should be >= 1.0. For example, a valid
// pooling ratio looks like [1.0, 1.44, 1.73, 1.0]. The first and last elements
// must be 1.0 because we don't allow pooling on batch and channels
// dimensions. 1.44 and 1.73 are pooling ratio on height and width dimensions
// respectively.
//
// Returns:
//
//	output: output tensor after fractional avg pooling.
//	row_pooling_sequence: row pooling sequence, needed to calculate gradient.
//	col_pooling_sequence: column pooling sequence, needed to calculate gradient.
func FractionalAvgPool(scope *Scope, value tf.Output, pooling_ratio []float32, optional ...FractionalAvgPoolAttr) (output tf.Output, row_pooling_sequence tf.Output, col_pooling_sequence tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"pooling_ratio": pooling_ratio}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FractionalAvgPool",
		Input: []tf.Input{
			value,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// FractionalAvgPoolGradAttr is an optional argument to FractionalAvgPoolGrad.
type FractionalAvgPoolGradAttr func(optionalAttr)

// FractionalAvgPoolGradOverlapping sets the optional overlapping attribute to value.
//
// value: When set to True, it means when pooling, the values at the boundary
// of adjacent pooling cells are used by both cells. For example:
//
// `index  0  1  2  3  4`
//
// `value  20 5  16 3  7`
//
// If the pooling sequence is [0, 2, 4], then 16, at index 2 will be used twice.
// The result would be [41/3, 26/3] for fractional avg pooling.
// If not specified, defaults to false
func FractionalAvgPoolGradOverlapping(value bool) FractionalAvgPoolGradAttr {
	return func(m optionalAttr) {
		m["overlapping"] = value
	}
}

// Computes gradient of the FractionalAvgPool function.
//
// Unlike FractionalMaxPoolGrad, we don't need to find arg_max for
// FractionalAvgPoolGrad, we just need to evenly back-propagate each element of
// out_backprop to those indices that form the same pooling cell. Therefore, we
// just need to know the shape of original input tensor, instead of the whole
// tensor.
//
// Arguments:
//
//	orig_input_tensor_shape: Original input tensor shape for `fractional_avg_pool`
//	out_backprop: 4-D with shape `[batch, height, width, channels]`.  Gradients
//
// w.r.t. the output of `fractional_avg_pool`.
//
//	row_pooling_sequence: row pooling sequence, form pooling region with
//
// col_pooling_sequence.
//
//	col_pooling_sequence: column pooling sequence, form pooling region with
//
// row_pooling sequence.
//
// Returns 4-D.  Gradients w.r.t. the input of `fractional_avg_pool`.
func FractionalAvgPoolGrad(scope *Scope, orig_input_tensor_shape tf.Output, out_backprop tf.Output, row_pooling_sequence tf.Output, col_pooling_sequence tf.Output, optional ...FractionalAvgPoolGradAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FractionalAvgPoolGrad",
		Input: []tf.Input{
			orig_input_tensor_shape, out_backprop, row_pooling_sequence, col_pooling_sequence,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// FractionalMaxPoolAttr is an optional argument to FractionalMaxPool.
type FractionalMaxPoolAttr func(optionalAttr)

// FractionalMaxPoolPseudoRandom sets the optional pseudo_random attribute to value.
//
// value: When set to True, generates the pooling sequence in a
// pseudorandom fashion, otherwise, in a random fashion. Check paper [Benjamin
// Graham, Fractional Max-Pooling](http://arxiv.org/abs/1412.6071) for
// difference between pseudorandom and random.
// If not specified, defaults to false
func FractionalMaxPoolPseudoRandom(value bool) FractionalMaxPoolAttr {
	return func(m optionalAttr) {
		m["pseudo_random"] = value
	}
}

// FractionalMaxPoolOverlapping sets the optional overlapping attribute to value.
//
// value: When set to True, it means when pooling, the values at the boundary
// of adjacent pooling cells are used by both cells. For example:
//
// `index  0  1  2  3  4`
//
// `value  20 5  16 3  7`
//
// If the pooling sequence is [0, 2, 4], then 16, at index 2 will be used twice.
// The result would be [20, 16] for fractional max pooling.
// If not specified, defaults to false
func FractionalMaxPoolOverlapping(value bool) FractionalMaxPoolAttr {
	return func(m optionalAttr) {
		m["overlapping"] = value
	}
}

// FractionalMaxPoolDeterministic sets the optional deterministic attribute to value.
//
// value: When set to True, a fixed pooling region will be used when
// iterating over a FractionalMaxPool node in the computation graph. Mainly used
// in unit test to make FractionalMaxPool deterministic.
// If not specified, defaults to false
func FractionalMaxPoolDeterministic(value bool) FractionalMaxPoolAttr {
	return func(m optionalAttr) {
		m["deterministic"] = value
	}
}

// FractionalMaxPoolSeed sets the optional seed attribute to value.
//
// value: If either seed or seed2 are set to be non-zero, the random number
// generator is seeded by the given seed.  Otherwise, it is seeded by a
// random seed.
// If not specified, defaults to 0
func FractionalMaxPoolSeed(value int64) FractionalMaxPoolAttr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// FractionalMaxPoolSeed2 sets the optional seed2 attribute to value.
//
// value: An second seed to avoid seed collision.
// If not specified, defaults to 0
func FractionalMaxPoolSeed2(value int64) FractionalMaxPoolAttr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// Performs fractional max pooling on the input.
//
// Fractional max pooling is slightly different than regular max pooling.  In
// regular max pooling, you downsize an input set by taking the maximum value of
// smaller N x N subsections of the set (often 2x2), and try to reduce the set by
// a factor of N, where N is an integer.  Fractional max pooling, as you might
// expect from the word "fractional", means that the overall reduction ratio N
// does not have to be an integer.
//
// The sizes of the pooling regions are generated randomly but are fairly uniform.
// For example, let's look at the height dimension, and the constraints on the
// list of rows that will be pool boundaries.
//
// First we define the following:
//
// 1.  input_row_length : the number of rows from the input set
// 2.  output_row_length : which will be smaller than the input
// 3.  alpha = input_row_length / output_row_length : our reduction ratio
// 4.  K = floor(alpha)
// 5.  row_pooling_sequence : this is the result list of pool boundary rows
//
// Then, row_pooling_sequence should satisfy:
//
// 1.  a[0] = 0 : the first value of the sequence is 0
// 2.  a[end] = input_row_length : the last value of the sequence is the size
// 3.  K <= (a[i+1] - a[i]) <= K+1 : all intervals are K or K+1 size
// 4.  length(row_pooling_sequence) = output_row_length+1
//
// For more details on fractional max pooling, see this paper:
// [Benjamin Graham, Fractional Max-Pooling](http://arxiv.org/abs/1412.6071)
//
// Arguments:
//
//	value: 4-D with shape `[batch, height, width, channels]`.
//	pooling_ratio: Pooling ratio for each dimension of `value`, currently only
//
// supports row and col dimension and should be >= 1.0. For example, a valid
// pooling ratio looks like [1.0, 1.44, 1.73, 1.0]. The first and last elements
// must be 1.0 because we don't allow pooling on batch and channels
// dimensions. 1.44 and 1.73 are pooling ratio on height and width dimensions
// respectively.
//
// Returns:
//
//	output: output tensor after fractional max pooling.
//	row_pooling_sequence: row pooling sequence, needed to calculate gradient.
//	col_pooling_sequence: column pooling sequence, needed to calculate gradient.
func FractionalMaxPool(scope *Scope, value tf.Output, pooling_ratio []float32, optional ...FractionalMaxPoolAttr) (output tf.Output, row_pooling_sequence tf.Output, col_pooling_sequence tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"pooling_ratio": pooling_ratio}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FractionalMaxPool",
		Input: []tf.Input{
			value,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// FractionalMaxPoolGradAttr is an optional argument to FractionalMaxPoolGrad.
type FractionalMaxPoolGradAttr func(optionalAttr)

// FractionalMaxPoolGradOverlapping sets the optional overlapping attribute to value.
//
// value: When set to True, it means when pooling, the values at the boundary
// of adjacent pooling cells are used by both cells. For example:
//
// `index  0  1  2  3  4`
//
// `value  20 5  16 3  7`
//
// If the pooling sequence is [0, 2, 4], then 16, at index 2 will be used twice.
// The result would be [20, 16] for fractional max pooling.
// If not specified, defaults to false
func FractionalMaxPoolGradOverlapping(value bool) FractionalMaxPoolGradAttr {
	return func(m optionalAttr) {
		m["overlapping"] = value
	}
}

// Computes gradient of the FractionalMaxPool function.
//
// Arguments:
//
//	orig_input: Original input for `fractional_max_pool`
//	orig_output: Original output for `fractional_max_pool`
//	out_backprop: 4-D with shape `[batch, height, width, channels]`.  Gradients
//
// w.r.t. the output of `fractional_max_pool`.
//
//	row_pooling_sequence: row pooling sequence, form pooling region with
//
// col_pooling_sequence.
//
//	col_pooling_sequence: column pooling sequence, form pooling region with
//
// row_pooling sequence.
//
// Returns 4-D.  Gradients w.r.t. the input of `fractional_max_pool`.
func FractionalMaxPoolGrad(scope *Scope, orig_input tf.Output, orig_output tf.Output, out_backprop tf.Output, row_pooling_sequence tf.Output, col_pooling_sequence tf.Output, optional ...FractionalMaxPoolGradAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FractionalMaxPoolGrad",
		Input: []tf.Input{
			orig_input, orig_output, out_backprop, row_pooling_sequence, col_pooling_sequence,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// FusedBatchNormAttr is an optional argument to FusedBatchNorm.
type FusedBatchNormAttr func(optionalAttr)

// FusedBatchNormEpsilon sets the optional epsilon attribute to value.
//
// value: A small float number added to the variance of x.
// If not specified, defaults to 0.0001
func FusedBatchNormEpsilon(value float32) FusedBatchNormAttr {
	return func(m optionalAttr) {
		m["epsilon"] = value
	}
}

// FusedBatchNormExponentialAvgFactor sets the optional exponential_avg_factor attribute to value.
// If not specified, defaults to 1
func FusedBatchNormExponentialAvgFactor(value float32) FusedBatchNormAttr {
	return func(m optionalAttr) {
		m["exponential_avg_factor"] = value
	}
}

// FusedBatchNormDataFormat sets the optional data_format attribute to value.
//
// value: The data format for x and y. Either "NHWC" (default) or "NCHW".
// If not specified, defaults to "NHWC"
func FusedBatchNormDataFormat(value string) FusedBatchNormAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// FusedBatchNormIsTraining sets the optional is_training attribute to value.
//
// value: A bool value to indicate the operation is for training (default)
// or inference.
// If not specified, defaults to true
func FusedBatchNormIsTraining(value bool) FusedBatchNormAttr {
	return func(m optionalAttr) {
		m["is_training"] = value
	}
}

// Batch normalization.
//
// Note that the size of 4D Tensors are defined by either "NHWC" or "NCHW".
// The size of 1D Tensors matches the dimension C of the 4D Tensors.
//
// Arguments:
//
//	x: A 4D Tensor for input data.
//	scale: A 1D Tensor for scaling factor, to scale the normalized x.
//	offset: A 1D Tensor for offset, to shift to the normalized x.
//	mean: A 1D Tensor for population mean. Used for inference only;
//
// must be empty for training.
//
//	variance: A 1D Tensor for population variance. Used for inference only;
//
// must be empty for training.
//
// Returns:
//
//	y: A 4D Tensor for output data.
//	batch_mean: A 1D Tensor for the computed batch mean, to be used by TensorFlow
//
// to compute the running mean.
//
//	batch_variance: A 1D Tensor for the computed batch variance, to be used by
//
// TensorFlow to compute the running variance.
//
//	reserve_space_1: A 1D Tensor for the computed batch mean, to be reused
//
// in the gradient computation.
//
//	reserve_space_2: A 1D Tensor for the computed batch variance (inverted variance
//
// in the cuDNN case), to be reused in the gradient computation.
func FusedBatchNorm(scope *Scope, x tf.Output, scale tf.Output, offset tf.Output, mean tf.Output, variance tf.Output, optional ...FusedBatchNormAttr) (y tf.Output, batch_mean tf.Output, batch_variance tf.Output, reserve_space_1 tf.Output, reserve_space_2 tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FusedBatchNorm",
		Input: []tf.Input{
			x, scale, offset, mean, variance,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3), op.Output(4)
}

// FusedBatchNormGradAttr is an optional argument to FusedBatchNormGrad.
type FusedBatchNormGradAttr func(optionalAttr)

// FusedBatchNormGradEpsilon sets the optional epsilon attribute to value.
//
// value: A small float number added to the variance of x.
// If not specified, defaults to 0.0001
func FusedBatchNormGradEpsilon(value float32) FusedBatchNormGradAttr {
	return func(m optionalAttr) {
		m["epsilon"] = value
	}
}

// FusedBatchNormGradDataFormat sets the optional data_format attribute to value.
//
// value: The data format for y_backprop, x, x_backprop.
// Either "NHWC" (default) or "NCHW".
// If not specified, defaults to "NHWC"
func FusedBatchNormGradDataFormat(value string) FusedBatchNormGradAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// FusedBatchNormGradIsTraining sets the optional is_training attribute to value.
//
// value: A bool value to indicate the operation is for training (default)
// or inference.
// If not specified, defaults to true
func FusedBatchNormGradIsTraining(value bool) FusedBatchNormGradAttr {
	return func(m optionalAttr) {
		m["is_training"] = value
	}
}

// Gradient for batch normalization.
//
// Note that the size of 4D Tensors are defined by either "NHWC" or "NCHW".
// The size of 1D Tensors matches the dimension C of the 4D Tensors.
//
// Arguments:
//
//	y_backprop: A 4D Tensor for the gradient with respect to y.
//	x: A 4D Tensor for input data.
//	scale: A 1D Tensor for scaling factor, to scale the normalized x.
//	reserve_space_1: When is_training is True, a 1D Tensor for the computed batch
//
// mean to be reused in gradient computation. When is_training is
// False, a 1D Tensor for the population mean to be reused in both
// 1st and 2nd order gradient computation.
//
//	reserve_space_2: When is_training is True, a 1D Tensor for the computed batch
//
// variance (inverted variance in the cuDNN case) to be reused in
// gradient computation. When is_training is False, a 1D Tensor
// for the population variance to be reused in both 1st and 2nd
// order gradient computation.
//
// Returns:
//
//	x_backprop: A 4D Tensor for the gradient with respect to x.
//	scale_backprop: A 1D Tensor for the gradient with respect to scale.
//	offset_backprop: A 1D Tensor for the gradient with respect to offset.
//	reserve_space_3: Unused placeholder to match the mean input in FusedBatchNorm.
//	reserve_space_4: Unused placeholder to match the variance input
//
// in FusedBatchNorm.
func FusedBatchNormGrad(scope *Scope, y_backprop tf.Output, x tf.Output, scale tf.Output, reserve_space_1 tf.Output, reserve_space_2 tf.Output, optional ...FusedBatchNormGradAttr) (x_backprop tf.Output, scale_backprop tf.Output, offset_backprop tf.Output, reserve_space_3 tf.Output, reserve_space_4 tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FusedBatchNormGrad",
		Input: []tf.Input{
			y_backprop, x, scale, reserve_space_1, reserve_space_2,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3), op.Output(4)
}

// FusedBatchNormGradV2Attr is an optional argument to FusedBatchNormGradV2.
type FusedBatchNormGradV2Attr func(optionalAttr)

// FusedBatchNormGradV2Epsilon sets the optional epsilon attribute to value.
//
// value: A small float number added to the variance of x.
// If not specified, defaults to 0.0001
func FusedBatchNormGradV2Epsilon(value float32) FusedBatchNormGradV2Attr {
	return func(m optionalAttr) {
		m["epsilon"] = value
	}
}

// FusedBatchNormGradV2DataFormat sets the optional data_format attribute to value.
//
// value: The data format for y_backprop, x, x_backprop.
// Either "NHWC" (default) or "NCHW".
// If not specified, defaults to "NHWC"
func FusedBatchNormGradV2DataFormat(value string) FusedBatchNormGradV2Attr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// FusedBatchNormGradV2IsTraining sets the optional is_training attribute to value.
//
// value: A bool value to indicate the operation is for training (default)
// or inference.
// If not specified, defaults to true
func FusedBatchNormGradV2IsTraining(value bool) FusedBatchNormGradV2Attr {
	return func(m optionalAttr) {
		m["is_training"] = value
	}
}

// Gradient for batch normalization.
//
// Note that the size of 4D Tensors are defined by either "NHWC" or "NCHW".
// The size of 1D Tensors matches the dimension C of the 4D Tensors.
//
// Arguments:
//
//	y_backprop: A 4D Tensor for the gradient with respect to y.
//	x: A 4D Tensor for input data.
//	scale: A 1D Tensor for scaling factor, to scale the normalized x.
//	reserve_space_1: When is_training is True, a 1D Tensor for the computed batch
//
// mean to be reused in gradient computation. When is_training is
// False, a 1D Tensor for the population mean to be reused in both
// 1st and 2nd order gradient computation.
//
//	reserve_space_2: When is_training is True, a 1D Tensor for the computed batch
//
// variance (inverted variance in the cuDNN case) to be reused in
// gradient computation. When is_training is False, a 1D Tensor
// for the population variance to be reused in both 1st and 2nd
// order gradient computation.
//
// Returns:
//
//	x_backprop: A 4D Tensor for the gradient with respect to x.
//	scale_backprop: A 1D Tensor for the gradient with respect to scale.
//	offset_backprop: A 1D Tensor for the gradient with respect to offset.
//	reserve_space_3: Unused placeholder to match the mean input in FusedBatchNorm.
//	reserve_space_4: Unused placeholder to match the variance input
//
// in FusedBatchNorm.
func FusedBatchNormGradV2(scope *Scope, y_backprop tf.Output, x tf.Output, scale tf.Output, reserve_space_1 tf.Output, reserve_space_2 tf.Output, optional ...FusedBatchNormGradV2Attr) (x_backprop tf.Output, scale_backprop tf.Output, offset_backprop tf.Output, reserve_space_3 tf.Output, reserve_space_4 tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FusedBatchNormGradV2",
		Input: []tf.Input{
			y_backprop, x, scale, reserve_space_1, reserve_space_2,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3), op.Output(4)
}

// FusedBatchNormGradV3Attr is an optional argument to FusedBatchNormGradV3.
type FusedBatchNormGradV3Attr func(optionalAttr)

// FusedBatchNormGradV3Epsilon sets the optional epsilon attribute to value.
//
// value: A small float number added to the variance of x.
// If not specified, defaults to 0.0001
func FusedBatchNormGradV3Epsilon(value float32) FusedBatchNormGradV3Attr {
	return func(m optionalAttr) {
		m["epsilon"] = value
	}
}

// FusedBatchNormGradV3DataFormat sets the optional data_format attribute to value.
//
// value: The data format for y_backprop, x, x_backprop.
// Either "NHWC" (default) or "NCHW".
// If not specified, defaults to "NHWC"
func FusedBatchNormGradV3DataFormat(value string) FusedBatchNormGradV3Attr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// FusedBatchNormGradV3IsTraining sets the optional is_training attribute to value.
//
// value: A bool value to indicate the operation is for training (default)
// or inference.
// If not specified, defaults to true
func FusedBatchNormGradV3IsTraining(value bool) FusedBatchNormGradV3Attr {
	return func(m optionalAttr) {
		m["is_training"] = value
	}
}

// Gradient for batch normalization.
//
// Note that the size of 4D Tensors are defined by either "NHWC" or "NCHW".
// The size of 1D Tensors matches the dimension C of the 4D Tensors.
//
// Arguments:
//
//	y_backprop: A 4D Tensor for the gradient with respect to y.
//	x: A 4D Tensor for input data.
//	scale: A 1D Tensor for scaling factor, to scale the normalized x.
//	reserve_space_1: When is_training is True, a 1D Tensor for the computed batch
//
// mean to be reused in gradient computation. When is_training is
// False, a 1D Tensor for the population mean to be reused in both
// 1st and 2nd order gradient computation.
//
//	reserve_space_2: When is_training is True, a 1D Tensor for the computed batch
//
// variance (inverted variance in the cuDNN case) to be reused in
// gradient computation. When is_training is False, a 1D Tensor
// for the population variance to be reused in both 1st and 2nd
// order gradient computation.
//
//	reserve_space_3: When is_training is True, a 1D Tensor for some intermediate results to be reused
//
// in gradient computation. When is_training is False, a dummy empty Tensor will be
// created.
//
// Returns:
//
//	x_backprop: A 4D Tensor for the gradient with respect to x.
//	scale_backprop: A 1D Tensor for the gradient with respect to scale.
//	offset_backprop: A 1D Tensor for the gradient with respect to offset.
//	reserve_space_4: Unused placeholder to match the mean input in FusedBatchNorm.
//	reserve_space_5: Unused placeholder to match the variance input
//
// in FusedBatchNorm.
func FusedBatchNormGradV3(scope *Scope, y_backprop tf.Output, x tf.Output, scale tf.Output, reserve_space_1 tf.Output, reserve_space_2 tf.Output, reserve_space_3 tf.Output, optional ...FusedBatchNormGradV3Attr) (x_backprop tf.Output, scale_backprop tf.Output, offset_backprop tf.Output, reserve_space_4 tf.Output, reserve_space_5 tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FusedBatchNormGradV3",
		Input: []tf.Input{
			y_backprop, x, scale, reserve_space_1, reserve_space_2, reserve_space_3,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3), op.Output(4)
}

// FusedBatchNormV2Attr is an optional argument to FusedBatchNormV2.
type FusedBatchNormV2Attr func(optionalAttr)

// FusedBatchNormV2Epsilon sets the optional epsilon attribute to value.
//
// value: A small float number added to the variance of x.
// If not specified, defaults to 0.0001
func FusedBatchNormV2Epsilon(value float32) FusedBatchNormV2Attr {
	return func(m optionalAttr) {
		m["epsilon"] = value
	}
}

// FusedBatchNormV2ExponentialAvgFactor sets the optional exponential_avg_factor attribute to value.
// If not specified, defaults to 1
func FusedBatchNormV2ExponentialAvgFactor(value float32) FusedBatchNormV2Attr {
	return func(m optionalAttr) {
		m["exponential_avg_factor"] = value
	}
}

// FusedBatchNormV2DataFormat sets the optional data_format attribute to value.
//
// value: The data format for x and y. Either "NHWC" (default) or "NCHW".
// If not specified, defaults to "NHWC"
func FusedBatchNormV2DataFormat(value string) FusedBatchNormV2Attr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// FusedBatchNormV2IsTraining sets the optional is_training attribute to value.
//
// value: A bool value to indicate the operation is for training (default)
// or inference.
// If not specified, defaults to true
func FusedBatchNormV2IsTraining(value bool) FusedBatchNormV2Attr {
	return func(m optionalAttr) {
		m["is_training"] = value
	}
}

// Batch normalization.
//
// Note that the size of 4D Tensors are defined by either "NHWC" or "NCHW".
// The size of 1D Tensors matches the dimension C of the 4D Tensors.
//
// Arguments:
//
//	x: A 4D Tensor for input data.
//	scale: A 1D Tensor for scaling factor, to scale the normalized x.
//	offset: A 1D Tensor for offset, to shift to the normalized x.
//	mean: A 1D Tensor for population mean. Used for inference only;
//
// must be empty for training.
//
//	variance: A 1D Tensor for population variance. Used for inference only;
//
// must be empty for training.
//
// Returns:
//
//	y: A 4D Tensor for output data.
//	batch_mean: A 1D Tensor for the computed batch mean, to be used by TensorFlow
//
// to compute the running mean.
//
//	batch_variance: A 1D Tensor for the computed batch variance, to be used by
//
// TensorFlow to compute the running variance.
//
//	reserve_space_1: A 1D Tensor for the computed batch mean, to be reused
//
// in the gradient computation.
//
//	reserve_space_2: A 1D Tensor for the computed batch variance (inverted variance
//
// in the cuDNN case), to be reused in the gradient computation.
func FusedBatchNormV2(scope *Scope, x tf.Output, scale tf.Output, offset tf.Output, mean tf.Output, variance tf.Output, optional ...FusedBatchNormV2Attr) (y tf.Output, batch_mean tf.Output, batch_variance tf.Output, reserve_space_1 tf.Output, reserve_space_2 tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FusedBatchNormV2",
		Input: []tf.Input{
			x, scale, offset, mean, variance,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3), op.Output(4)
}

// FusedBatchNormV3Attr is an optional argument to FusedBatchNormV3.
type FusedBatchNormV3Attr func(optionalAttr)

// FusedBatchNormV3Epsilon sets the optional epsilon attribute to value.
//
// value: A small float number added to the variance of x.
// If not specified, defaults to 0.0001
func FusedBatchNormV3Epsilon(value float32) FusedBatchNormV3Attr {
	return func(m optionalAttr) {
		m["epsilon"] = value
	}
}

// FusedBatchNormV3ExponentialAvgFactor sets the optional exponential_avg_factor attribute to value.
// If not specified, defaults to 1
func FusedBatchNormV3ExponentialAvgFactor(value float32) FusedBatchNormV3Attr {
	return func(m optionalAttr) {
		m["exponential_avg_factor"] = value
	}
}

// FusedBatchNormV3DataFormat sets the optional data_format attribute to value.
//
// value: The data format for x and y. Either "NHWC" (default) or "NCHW".
// If not specified, defaults to "NHWC"
func FusedBatchNormV3DataFormat(value string) FusedBatchNormV3Attr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// FusedBatchNormV3IsTraining sets the optional is_training attribute to value.
//
// value: A bool value to indicate the operation is for training (default)
// or inference.
// If not specified, defaults to true
func FusedBatchNormV3IsTraining(value bool) FusedBatchNormV3Attr {
	return func(m optionalAttr) {
		m["is_training"] = value
	}
}

// Batch normalization.
//
// Note that the size of 4D Tensors are defined by either "NHWC" or "NCHW".
// The size of 1D Tensors matches the dimension C of the 4D Tensors.
//
// Arguments:
//
//	x: A 4D Tensor for input data.
//	scale: A 1D Tensor for scaling factor, to scale the normalized x.
//	offset: A 1D Tensor for offset, to shift to the normalized x.
//	mean: A 1D Tensor for population mean. Used for inference only;
//
// must be empty for training.
//
//	variance: A 1D Tensor for population variance. Used for inference only;
//
// must be empty for training.
//
// Returns:
//
//	y: A 4D Tensor for output data.
//	batch_mean: A 1D Tensor for the computed batch mean, to be used by TensorFlow
//
// to compute the running mean.
//
//	batch_variance: A 1D Tensor for the computed batch variance, to be used by
//
// TensorFlow to compute the running variance.
//
//	reserve_space_1: A 1D Tensor for the computed batch mean, to be reused
//
// in the gradient computation.
//
//	reserve_space_2: A 1D Tensor for the computed batch variance (inverted variance
//
// in the cuDNN case), to be reused in the gradient computation.
//
//	reserve_space_3: A 1D Tensor for some intermediate results, to be reused in the gradient
//
// computation for better efficiency.
func FusedBatchNormV3(scope *Scope, x tf.Output, scale tf.Output, offset tf.Output, mean tf.Output, variance tf.Output, optional ...FusedBatchNormV3Attr) (y tf.Output, batch_mean tf.Output, batch_variance tf.Output, reserve_space_1 tf.Output, reserve_space_2 tf.Output, reserve_space_3 tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FusedBatchNormV3",
		Input: []tf.Input{
			x, scale, offset, mean, variance,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3), op.Output(4), op.Output(5)
}

// Performs a padding as a preprocess during a convolution.
//
// Similar to FusedResizeAndPadConv2d, this op allows for an optimized
// implementation where the spatial padding transformation stage is fused with the
// im2col lookup, but in this case without the bilinear filtering required for
// resizing. Fusing the padding prevents the need to write out the intermediate
// results as whole tensors, reducing memory pressure, and we can get some latency
// gains by merging the transformation calculations.
// The data_format attribute for Conv2D isn't supported by this op, and 'NHWC'
// order is used instead.
// Internally this op uses a single per-graph scratch buffer, which means that it
// will block if multiple versions are being run in parallel. This is because this
// operator is primarily an optimization to minimize memory usage.
//
// Arguments:
//
//	input: 4-D with shape `[batch, in_height, in_width, in_channels]`.
//	paddings: A two-column matrix specifying the padding sizes. The number of
//
// rows must be the same as the rank of `input`.
//
//	filter: 4-D with shape
//
// `[filter_height, filter_width, in_channels, out_channels]`.
//
//	strides: 1-D of length 4.  The stride of the sliding window for each dimension
//
// of `input`. Must be in the same order as the dimension specified with format.
//
//	padding: The type of padding algorithm to use.
func FusedPadConv2D(scope *Scope, input tf.Output, paddings tf.Output, filter tf.Output, mode string, strides []int64, padding string) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"mode": mode, "strides": strides, "padding": padding}
	opspec := tf.OpSpec{
		Type: "FusedPadConv2D",
		Input: []tf.Input{
			input, paddings, filter,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// FusedResizeAndPadConv2DAttr is an optional argument to FusedResizeAndPadConv2D.
type FusedResizeAndPadConv2DAttr func(optionalAttr)

// FusedResizeAndPadConv2DResizeAlignCorners sets the optional resize_align_corners attribute to value.
//
// value: If true, the centers of the 4 corner pixels of the input and output tensors are
// aligned, preserving the values at the corner pixels. Defaults to false.
// If not specified, defaults to false
func FusedResizeAndPadConv2DResizeAlignCorners(value bool) FusedResizeAndPadConv2DAttr {
	return func(m optionalAttr) {
		m["resize_align_corners"] = value
	}
}

// Performs a resize and padding as a preprocess during a convolution.
//
// It's often possible to do spatial transformations more efficiently as part of
// the packing stage of a convolution, so this op allows for an optimized
// implementation where these stages are fused together. This prevents the need to
// write out the intermediate results as whole tensors, reducing memory pressure,
// and we can get some latency gains by merging the transformation calculations.
// The data_format attribute for Conv2D isn't supported by this op, and defaults to
// 'NHWC' order.
// Internally this op uses a single per-graph scratch buffer, which means that it
// will block if multiple versions are being run in parallel. This is because this
// operator is primarily an optimization to minimize memory usage.
//
// Arguments:
//
//	input: 4-D with shape `[batch, in_height, in_width, in_channels]`.
//	size: A 1-D int32 Tensor of 2 elements: `new_height, new_width`.  The
//
// new size for the images.
//
//	paddings: A two-column matrix specifying the padding sizes. The number of
//
// rows must be the same as the rank of `input`.
//
//	filter: 4-D with shape
//
// `[filter_height, filter_width, in_channels, out_channels]`.
//
//	strides: 1-D of length 4.  The stride of the sliding window for each dimension
//
// of `input`. Must be in the same order as the dimension specified with format.
//
//	padding: The type of padding algorithm to use.
func FusedResizeAndPadConv2D(scope *Scope, input tf.Output, size tf.Output, paddings tf.Output, filter tf.Output, mode string, strides []int64, padding string, optional ...FusedResizeAndPadConv2DAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"mode": mode, "strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FusedResizeAndPadConv2D",
		Input: []tf.Input{
			input, size, paddings, filter,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the GRU cell forward propagation for 1 time step.
//
// Args
//
//	x: Input to the GRU cell.
//	h_prev: State input from the previous GRU cell.
//	w_ru: Weight matrix for the reset and update gate.
//	w_c: Weight matrix for the cell connection gate.
//	b_ru: Bias vector for the reset and update gate.
//	b_c: Bias vector for the cell connection gate.
//
// Returns
//
//	r: Output of the reset gate.
//	u: Output of the update gate.
//	c: Output of the cell connection gate.
//	h: Current state of the GRU cell.
//
// Note on notation of the variables:
//
// Concatenation of a and b is represented by a_b
// Element-wise dot product of a and b is represented by ab
// Element-wise dot product is represented by \circ
// Matrix multiplication is represented by *
//
// Biases are initialized with :
// `b_ru` - constant_initializer(1.0)
// `b_c` - constant_initializer(0.0)
//
// This kernel op implements the following mathematical equations:
//
// ```
// x_h_prev = [x, h_prev]
//
// [r_bar u_bar] = x_h_prev * w_ru + b_ru
//
// r = sigmoid(r_bar)
// u = sigmoid(u_bar)
//
// h_prevr = h_prev \circ r
//
// x_h_prevr = [x h_prevr]
//
// c_bar = x_h_prevr * w_c + b_c
// c = tanh(c_bar)
//
// h = (1-u) \circ c + u \circ h_prev
// ```
func GRUBlockCell(scope *Scope, x tf.Output, h_prev tf.Output, w_ru tf.Output, w_c tf.Output, b_ru tf.Output, b_c tf.Output) (r tf.Output, u tf.Output, c tf.Output, h tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "GRUBlockCell",
		Input: []tf.Input{
			x, h_prev, w_ru, w_c, b_ru, b_c,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3)
}

// Computes the GRU cell back-propagation for 1 time step.
//
// Args
//
//	x: Input to the GRU cell.
//	h_prev: State input from the previous GRU cell.
//	w_ru: Weight matrix for the reset and update gate.
//	w_c: Weight matrix for the cell connection gate.
//	b_ru: Bias vector for the reset and update gate.
//	b_c: Bias vector for the cell connection gate.
//	r: Output of the reset gate.
//	u: Output of the update gate.
//	c: Output of the cell connection gate.
//	d_h: Gradients of the h_new wrt to objective function.
//
// Returns
//
//	d_x: Gradients of the x wrt to objective function.
//	d_h_prev: Gradients of the h wrt to objective function.
//	d_c_bar Gradients of the c_bar wrt to objective function.
//	d_r_bar_u_bar Gradients of the r_bar & u_bar wrt to objective function.
//
// This kernel op implements the following mathematical equations:
//
// Note on notation of the variables:
//
// Concatenation of a and b is represented by a_b
// Element-wise dot product of a and b is represented by ab
// Element-wise dot product is represented by \circ
// Matrix multiplication is represented by *
//
// Additional notes for clarity:
//
// `w_ru` can be segmented into 4 different matrices.
// ```
// w_ru = [w_r_x w_u_x
//
//	w_r_h_prev w_u_h_prev]
//
// ```
// Similarly, `w_c` can be segmented into 2 different matrices.
// ```
// w_c = [w_c_x w_c_h_prevr]
// ```
// Same goes for biases.
// ```
// b_ru = [b_ru_x b_ru_h]
// b_c = [b_c_x b_c_h]
// ```
// Another note on notation:
// ```
// d_x = d_x_component_1 + d_x_component_2
//
// where d_x_component_1 = d_r_bar * w_r_x^T + d_u_bar * w_r_x^T
// and d_x_component_2 = d_c_bar * w_c_x^T
//
// d_h_prev = d_h_prev_component_1 + d_h_prevr \circ r + d_h \circ u
// where d_h_prev_componenet_1 = d_r_bar * w_r_h_prev^T + d_u_bar * w_r_h_prev^T
// ```
//
// Mathematics behind the Gradients below:
// ```
// d_c_bar = d_h \circ (1-u) \circ (1-c \circ c)
// d_u_bar = d_h \circ (h-c) \circ u \circ (1-u)
//
// d_r_bar_u_bar = [d_r_bar d_u_bar]
//
// [d_x_component_1 d_h_prev_component_1] = d_r_bar_u_bar * w_ru^T
//
// [d_x_component_2 d_h_prevr] = d_c_bar * w_c^T
//
// d_x = d_x_component_1 + d_x_component_2
//
// d_h_prev = d_h_prev_component_1 + d_h_prevr \circ r + u
// ```
// Below calculation is performed in the python wrapper for the Gradients
// (not in the gradient kernel.)
// ```
// d_w_ru = x_h_prevr^T * d_c_bar
//
// d_w_c = x_h_prev^T * d_r_bar_u_bar
//
// d_b_ru = sum of d_r_bar_u_bar along axis = 0
//
// d_b_c = sum of d_c_bar along axis = 0
// ```
func GRUBlockCellGrad(scope *Scope, x tf.Output, h_prev tf.Output, w_ru tf.Output, w_c tf.Output, b_ru tf.Output, b_c tf.Output, r tf.Output, u tf.Output, c tf.Output, d_h tf.Output) (d_x tf.Output, d_h_prev tf.Output, d_c_bar tf.Output, d_r_bar_u_bar tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "GRUBlockCellGrad",
		Input: []tf.Input{
			x, h_prev, w_ru, w_c, b_ru, b_c, r, u, c, d_h,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3)
}

// GatherAttr is an optional argument to Gather.
type GatherAttr func(optionalAttr)

// GatherValidateIndices sets the optional validate_indices attribute to value.
// If not specified, defaults to true
func GatherValidateIndices(value bool) GatherAttr {
	return func(m optionalAttr) {
		m["validate_indices"] = value
	}
}

// Gather slices from `params` according to `indices`.
//
// `indices` must be an integer tensor of any dimension (usually 0-D or 1-D).
// Produces an output tensor with shape `indices.shape + params.shape[1:]` where:
//
// ```python
//
//	# Scalar indices
//	output[:, ..., :] = params[indices, :, ... :]
//
//	# Vector indices
//	output[i, :, ..., :] = params[indices[i], :, ... :]
//
//	# Higher rank indices
//	output[i, ..., j, :, ... :] = params[indices[i, ..., j], :, ..., :]
//
// ```
//
// If `indices` is a permutation and `len(indices) == params.shape[0]` then
// this operation will permute `params` accordingly.
//
// `validate_indices`: DEPRECATED. If this operation is assigned to CPU, values in
// `indices` are always validated to be within range. If assigned to GPU,
// out-of-bound indices result in safe but unspecified behavior, which may include
// raising an error.
//
// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
// <img style="width:100%" src="https://www.tensorflow.org/images/Gather.png" alt>
// </div>
func Gather(scope *Scope, params tf.Output, indices tf.Output, optional ...GatherAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Gather",
		Input: []tf.Input{
			params, indices,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// GatherNdAttr is an optional argument to GatherNd.
type GatherNdAttr func(optionalAttr)

// GatherNdBadIndicesPolicy sets the optional bad_indices_policy attribute to value.
// If not specified, defaults to ""
func GatherNdBadIndicesPolicy(value string) GatherNdAttr {
	return func(m optionalAttr) {
		m["bad_indices_policy"] = value
	}
}

// Gather slices from `params` into a Tensor with shape specified by `indices`.
//
// `indices` is a K-dimensional integer tensor, best thought of as a
// (K-1)-dimensional tensor of indices into `params`, where each element defines a
// slice of `params`:
//
//	output[\\(i_0, ..., i_{K-2}\\)] = params[indices[\\(i_0, ..., i_{K-2}\\)]]
//
// Whereas in `tf.gather` `indices` defines slices into the `axis`
// dimension of `params`, in `tf.gather_nd`, `indices` defines slices into the
// first `N` dimensions of `params`, where `N = indices.shape[-1]`.
//
// The last dimension of `indices` can be at most the rank of
// `params`:
//
//	indices.shape[-1] <= params.rank
//
// The last dimension of `indices` corresponds to elements
// (if `indices.shape[-1] == params.rank`) or slices
// (if `indices.shape[-1] < params.rank`) along dimension `indices.shape[-1]`
// of `params`.  The output tensor has shape
//
//	indices.shape[:-1] + params.shape[indices.shape[-1]:]
//
// If `indices` contains any out-of-bound indices, depending on
// `bad_indices_policy`, the op will either return an error or ignore the
// out-of-bound indices. `bad_indices_policy` can be one of the following values:
//  1. "" or "DEFAULT": raises on CPU and ignore on GPU. This is because
//     historically on CPU and GPU we handle errors in different ways, and for
//     backward compatibility we keep the default behavior.
//  2. "ERROR": raises error; GPU does not support this value.
//  3. "IGNORE": ignore error and set the corresponding output to 0;
//     supported on both CPU and GPU.
//
// Some examples below.
//
// Simple indexing into a matrix:
//
// ```python
//
//	indices = [[0, 0], [1, 1]]
//	params = [['a', 'b'], ['c', 'd']]
//	output = ['a', 'd']
//
// ```
//
// Slice indexing into a matrix:
//
// ```python
//
//	indices = [[1], [0]]
//	params = [['a', 'b'], ['c', 'd']]
//	output = [['c', 'd'], ['a', 'b']]
//
// ```
//
// Indexing into a 3-tensor:
//
// ```python
//
//	indices = [[1]]
//	params = [[['a0', 'b0'], ['c0', 'd0']],
//	          [['a1', 'b1'], ['c1', 'd1']]]
//	output = [[['a1', 'b1'], ['c1', 'd1']]]
//
//
//	indices = [[0, 1], [1, 0]]
//	params = [[['a0', 'b0'], ['c0', 'd0']],
//	          [['a1', 'b1'], ['c1', 'd1']]]
//	output = [['c0', 'd0'], ['a1', 'b1']]
//
//
//	indices = [[0, 0, 1], [1, 0, 1]]
//	params = [[['a0', 'b0'], ['c0', 'd0']],
//	          [['a1', 'b1'], ['c1', 'd1']]]
//	output = ['b0', 'b1']
//
// ```
//
// Batched indexing into a matrix:
//
// ```python
//
//	indices = [[[0, 0]], [[0, 1]]]
//	params = [['a', 'b'], ['c', 'd']]
//	output = [['a'], ['b']]
//
// ```
//
// Batched slice indexing into a matrix:
//
// ```python
//
//	indices = [[[1]], [[0]]]
//	params = [['a', 'b'], ['c', 'd']]
//	output = [[['c', 'd']], [['a', 'b']]]
//
// ```
//
// Batched indexing into a 3-tensor:
//
// ```python
//
//	indices = [[[1]], [[0]]]
//	params = [[['a0', 'b0'], ['c0', 'd0']],
//	          [['a1', 'b1'], ['c1', 'd1']]]
//	output = [[[['a1', 'b1'], ['c1', 'd1']]],
//	          [[['a0', 'b0'], ['c0', 'd0']]]]
//
//	indices = [[[0, 1], [1, 0]], [[0, 0], [1, 1]]]
//	params = [[['a0', 'b0'], ['c0', 'd0']],
//	          [['a1', 'b1'], ['c1', 'd1']]]
//	output = [[['c0', 'd0'], ['a1', 'b1']],
//	          [['a0', 'b0'], ['c1', 'd1']]]
//
//
//	indices = [[[0, 0, 1], [1, 0, 1]], [[0, 1, 1], [1, 1, 0]]]
//	params = [[['a0', 'b0'], ['c0', 'd0']],
//	          [['a1', 'b1'], ['c1', 'd1']]]
//	output = [['b0', 'b1'], ['d0', 'c1']]
//
// ```
//
// See also `tf.gather` and `tf.batch_gather`.
//
// Arguments:
//
//	params: The tensor from which to gather values.
//	indices: Index tensor.
//
// Returns Values from `params` gathered from indices given by `indices`, with
// shape `indices.shape[:-1] + params.shape[indices.shape[-1]:]`.
func GatherNd(scope *Scope, params tf.Output, indices tf.Output, optional ...GatherNdAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "GatherNd",
		Input: []tf.Input{
			params, indices,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// GatherV2Attr is an optional argument to GatherV2.
type GatherV2Attr func(optionalAttr)

// GatherV2BatchDims sets the optional batch_dims attribute to value.
// If not specified, defaults to 0
func GatherV2BatchDims(value int64) GatherV2Attr {
	return func(m optionalAttr) {
		m["batch_dims"] = value
	}
}

// Gather slices from `params` axis `axis` according to `indices`.
//
// `indices` must be an integer tensor of any dimension (usually 0-D or 1-D).
// Produces an output tensor with shape `params.shape[:axis] +
// indices.shape[batch_dims:] + params.shape[axis + 1:]` where:
//
// ```python
//
//	# Scalar indices (output is rank(params) - 1).
//	output[a_0, ..., a_n, b_0, ..., b_n] =
//	  params[a_0, ..., a_n, indices, b_0, ..., b_n]
//
//	# Vector indices (output is rank(params)).
//	output[a_0, ..., a_n, i, b_0, ..., b_n] =
//	  params[a_0, ..., a_n, indices[i], b_0, ..., b_n]
//
//	# Higher rank indices (output is rank(params) + rank(indices) - 1).
//	output[a_0, ..., a_n, i, ..., j, b_0, ... b_n] =
//	  params[a_0, ..., a_n, indices[i, ..., j], b_0, ..., b_n]
//
// ```
//
// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
// <img style="width:100%" src="https://www.tensorflow.org/images/Gather.png" alt>
// </div>
//
// Note that on CPU, if an out of bound index is found, an error is returned.
// On GPU, if an out of bound index is found, a 0 is stored in the
// corresponding output value.
//
// Note that on TPU, if any dimension of `params` is of size 0 then the output will
// be the expected shape filled with zeros. On CPU and GPU an error will be
// returned.
//
// See also `tf.batch_gather` and `tf.gather_nd`.
//
// Arguments:
//
//	params: The tensor from which to gather values. Must be at least rank
//
// `axis + 1`.
//
//	indices: Index tensor. Must be in range `[0, params.shape[axis])`.
//	axis: The axis in `params` to gather `indices` from. Defaults to the first
//
// dimension. Supports negative indexes.
//
// Returns Values from `params` gathered from indices given by `indices`, with
// shape `params.shape[:axis] + indices.shape + params.shape[axis + 1:]`.
func GatherV2(scope *Scope, params tf.Output, indices tf.Output, axis tf.Output, optional ...GatherV2Attr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "GatherV2",
		Input: []tf.Input{
			params, indices, axis,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// GenerateBoundingBoxProposalsAttr is an optional argument to GenerateBoundingBoxProposals.
type GenerateBoundingBoxProposalsAttr func(optionalAttr)

// GenerateBoundingBoxProposalsPostNmsTopn sets the optional post_nms_topn attribute to value.
//
// value: An integer. Maximum number of rois in the output.
// If not specified, defaults to 300
func GenerateBoundingBoxProposalsPostNmsTopn(value int64) GenerateBoundingBoxProposalsAttr {
	return func(m optionalAttr) {
		m["post_nms_topn"] = value
	}
}

// This op produces Region of Interests from given bounding boxes(bbox_deltas) encoded wrt anchors according to eq.2 in arXiv:1506.01497
//
//	The op selects top `pre_nms_topn` scoring boxes, decodes them with respect to anchors,
//	applies non-maximal suppression on overlapping boxes with higher than
//	`nms_threshold` intersection-over-union (iou) value, discarding boxes where shorter
//	side is less than `min_size`.
//	Inputs:
//	`scores`: A 4D tensor of shape [Batch, Height, Width, Num Anchors] containing the scores per anchor at given position
//	`bbox_deltas`: is a tensor of shape [Batch, Height, Width, 4 x Num Anchors] boxes encoded to each anchor
//	`anchors`: A 1D tensor of shape [4 x Num Anchors], representing the anchors.
//	Outputs:
//	`rois`: output RoIs, a 3D tensor of shape [Batch, post_nms_topn, 4], padded by 0 if less than post_nms_topn candidates found.
//	`roi_probabilities`: probability scores of each roi in 'rois', a 2D tensor of shape [Batch,post_nms_topn], padded with 0 if needed, sorted by scores.
//
// Arguments:
//
//	scores: A 4-D float tensor of shape `[num_images, height, width, num_achors]` containing scores of the boxes for given anchors, can be unsorted.
//	bbox_deltas: A 4-D float tensor of shape `[num_images, height, width, 4 x num_anchors]`. encoding boxes with respec to each anchor.
//
// Coordinates are given in the form [dy, dx, dh, dw].
//
//	image_info: A 2-D float tensor of shape `[num_images, 5]` containing image information Height, Width, Scale.
//	anchors: A 2-D float tensor of shape `[num_anchors, 4]` describing the anchor boxes. Boxes are formatted in the form [y1, x1, y2, x2].
//	nms_threshold: A scalar float tensor for non-maximal-suppression threshold.
//	pre_nms_topn: A scalar int tensor for the number of top scoring boxes to be used as input.
//	min_size: A scalar float tensor. Any box that has a smaller size than min_size will be discarded.
//
// Returns:
//
//	rois: A 3-D float tensor of shape `[num_images,post_nms_topn,4]` representing the selected
//
// region of interest boxes. Sorted in descending order in scores.
//
//	roi_probabilities: A 2-D float tensor of shape `[num_images, post_nms_topn]` representing the score of the
//
// region of interest box in `rois` tensor at the same index.
func GenerateBoundingBoxProposals(scope *Scope, scores tf.Output, bbox_deltas tf.Output, image_info tf.Output, anchors tf.Output, nms_threshold tf.Output, pre_nms_topn tf.Output, min_size tf.Output, optional ...GenerateBoundingBoxProposalsAttr) (rois tf.Output, roi_probabilities tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "GenerateBoundingBoxProposals",
		Input: []tf.Input{
			scores, bbox_deltas, image_info, anchors, nms_threshold, pre_nms_topn, min_size,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// GenerateVocabRemappingAttr is an optional argument to GenerateVocabRemapping.
type GenerateVocabRemappingAttr func(optionalAttr)

// GenerateVocabRemappingOldVocabSize sets the optional old_vocab_size attribute to value.
//
// value: Number of entries in the old vocab file to consider.  If -1,
// use the entire old vocabulary.
// If not specified, defaults to -1
//
// REQUIRES: value >= -1
func GenerateVocabRemappingOldVocabSize(value int64) GenerateVocabRemappingAttr {
	return func(m optionalAttr) {
		m["old_vocab_size"] = value
	}
}

// Given a path to new and old vocabulary files, returns a remapping Tensor of
//
// length `num_new_vocab`, where `remapping[i]` contains the row number in the old
// vocabulary that corresponds to row `i` in the new vocabulary (starting at line
// `new_vocab_offset` and up to `num_new_vocab` entities), or `-1` if entry `i`
// in the new vocabulary is not in the old vocabulary.  The old vocabulary is
// constrained to the first `old_vocab_size` entries if `old_vocab_size` is not the
// default value of -1.
//
// `num_vocab_offset` enables
// use in the partitioned variable case, and should generally be set through
// examining partitioning info.  The format of the files should be a text file,
// with each line containing a single entity within the vocabulary.
//
// For example, with `new_vocab_file` a text file containing each of the following
// elements on a single line: `[f0, f1, f2, f3]`, old_vocab_file = [f1, f0, f3],
// `num_new_vocab = 3, new_vocab_offset = 1`, the returned remapping would be
// `[0, -1, 2]`.
//
// The op also returns a count of how many entries in the new vocabulary
// were present in the old vocabulary, which is used to calculate the number of
// values to initialize in a weight matrix remapping
//
// This functionality can be used to remap both row vocabularies (typically,
// features) and column vocabularies (typically, classes) from TensorFlow
// checkpoints.  Note that the partitioning logic relies on contiguous vocabularies
// corresponding to div-partitioned variables.  Moreover, the underlying remapping
// uses an IndexTable (as opposed to an inexact CuckooTable), so client code should
// use the corresponding index_table_from_file() as the FeatureColumn framework
// does (as opposed to tf.feature_to_id(), which uses a CuckooTable).
//
// Arguments:
//
//	new_vocab_file: Path to the new vocab file.
//	old_vocab_file: Path to the old vocab file.
//	new_vocab_offset: How many entries into the new vocab file to start reading.
//	num_new_vocab: Number of entries in the new vocab file to remap.
//
// Returns:
//
//	remapping: A Tensor of length num_new_vocab where the element at index i
//
// is equal to the old ID that maps to the new ID i.  This element is -1 for any
// new ID that is not found in the old vocabulary.
//
//	num_present: Number of new vocab entries found in old vocab.
func GenerateVocabRemapping(scope *Scope, new_vocab_file tf.Output, old_vocab_file tf.Output, new_vocab_offset int64, num_new_vocab int64, optional ...GenerateVocabRemappingAttr) (remapping tf.Output, num_present tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"new_vocab_offset": new_vocab_offset, "num_new_vocab": num_new_vocab}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "GenerateVocabRemapping",
		Input: []tf.Input{
			new_vocab_file, old_vocab_file,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Gets the element at the specified index in a dataset.
func GetElementAtIndex(scope *Scope, dataset tf.Output, index tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (components []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "GetElementAtIndex",
		Input: []tf.Input{
			dataset, index,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if components, idx, err = makeOutputList(op, idx, "components"); err != nil {
		scope.UpdateErr("GetElementAtIndex", err)
		return
	}
	return components
}

// Returns the `tf.data.Options` attached to `input_dataset`.
//
// Arguments:
//
//	input_dataset: A variant tensor representing the input dataset.
func GetOptions(scope *Scope, input_dataset tf.Output) (serialized_options tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "GetOptions",
		Input: []tf.Input{
			input_dataset,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Store the input tensor in the state of the current session.
//
// Arguments:
//
//	value: The tensor to be stored.
//
// Returns The handle for the tensor stored in the session state, represented
// as a string.
func GetSessionHandle(scope *Scope, value tf.Output) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "GetSessionHandle",
		Input: []tf.Input{
			value,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Store the input tensor in the state of the current session.
//
// Arguments:
//
//	value: The tensor to be stored.
//
// Returns The handle for the tensor stored in the session state, represented
// as a ResourceHandle object.
func GetSessionHandleV2(scope *Scope, value tf.Output) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "GetSessionHandleV2",
		Input: []tf.Input{
			value,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Get the value of the tensor specified by its handle.
//
// Arguments:
//
//	handle: The handle for a tensor stored in the session state.
//	dtype: The type of the output value.
//
// Returns The tensor for the given handle.
func GetSessionTensor(scope *Scope, handle tf.Output, dtype tf.DataType) (value tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtype": dtype}
	opspec := tf.OpSpec{
		Type: "GetSessionTensor",
		Input: []tf.Input{
			handle,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// An op returns the TPU task ID from TPU topology.
//
// This op is to return the TPU task ID from TPU topology.
//
// Returns The TPU task ID from TPU topology.
func GetTpuTaskId(scope *Scope) (tpu_task_id tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "GetTpuTaskId",
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the truth value of (x > y) element-wise.
//
// *NOTE*: `Greater` supports broadcasting. More about broadcasting
// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
//
// Example:
//
// ```python
// x = tf.constant([5, 4, 6])
// y = tf.constant([5, 2, 5])
// tf.math.greater(x, y) ==> [False, True, True]
//
// x = tf.constant([5, 4, 6])
// y = tf.constant([5])
// tf.math.greater(x, y) ==> [False, False, True]
// ```
func Greater(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Greater",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the truth value of (x >= y) element-wise.
//
// *NOTE*: `GreaterEqual` supports broadcasting. More about broadcasting
// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
//
// Example:
//
// ```python
// x = tf.constant([5, 4, 6, 7])
// y = tf.constant([5, 2, 5, 10])
// tf.math.greater_equal(x, y) ==> [True, True, True, False]
//
// x = tf.constant([5, 4, 6, 7])
// y = tf.constant([5])
// tf.math.greater_equal(x, y) ==> [True, False, True, True]
// ```
func GreaterEqual(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "GreaterEqual",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Gives a guarantee to the TF runtime that the input tensor is a constant.
//
// The runtime is then free to make optimizations based on this.
//
// Only accepts value typed tensors as inputs and rejects resource variable handles
// as input.
//
// Returns the input tensor without modification.
func GuaranteeConst(scope *Scope, input tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "GuaranteeConst",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Convert one or more images from HSV to RGB.
//
// Outputs a tensor of the same shape as the `images` tensor, containing the RGB
// value of the pixels. The output is only well defined if the value in `images`
// are in `[0,1]`.
//
// See `rgb_to_hsv` for a description of the HSV encoding.
//
// Arguments:
//
//	images: 1-D or higher rank. HSV data to convert. Last dimension must be size 3.
//
// Returns `images` converted to RGB.
func HSVToRGB(scope *Scope, images tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "HSVToRGB",
		Input: []tf.Input{
			images,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// HashTableV2Attr is an optional argument to HashTableV2.
type HashTableV2Attr func(optionalAttr)

// HashTableV2Container sets the optional container attribute to value.
//
// value: If non-empty, this table is placed in the given container.
// Otherwise, a default container is used.
// If not specified, defaults to ""
func HashTableV2Container(value string) HashTableV2Attr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// HashTableV2SharedName sets the optional shared_name attribute to value.
//
// value: If non-empty, this table is shared under the given name across
// multiple sessions.
// If not specified, defaults to ""
func HashTableV2SharedName(value string) HashTableV2Attr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// HashTableV2UseNodeNameSharing sets the optional use_node_name_sharing attribute to value.
//
// value: If true and shared_name is empty, the table is shared
// using the node name.
// If not specified, defaults to false
func HashTableV2UseNodeNameSharing(value bool) HashTableV2Attr {
	return func(m optionalAttr) {
		m["use_node_name_sharing"] = value
	}
}

// Creates a non-initialized hash table.
//
// This op creates a hash table, specifying the type of its keys and values.
// Before using the table you will have to initialize it.  After initialization the
// table will be immutable.
//
// Arguments:
//
//	key_dtype: Type of the table keys.
//	value_dtype: Type of the table values.
//
// Returns Handle to a table.
func HashTableV2(scope *Scope, key_dtype tf.DataType, value_dtype tf.DataType, optional ...HashTableV2Attr) (table_handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"key_dtype": key_dtype, "value_dtype": value_dtype}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "HashTableV2",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// HistogramFixedWidthAttr is an optional argument to HistogramFixedWidth.
type HistogramFixedWidthAttr func(optionalAttr)

// HistogramFixedWidthDtype sets the optional dtype attribute to value.
// If not specified, defaults to DT_INT32
func HistogramFixedWidthDtype(value tf.DataType) HistogramFixedWidthAttr {
	return func(m optionalAttr) {
		m["dtype"] = value
	}
}

// Return histogram of values.
//
// Given the tensor `values`, this operation returns a rank 1 histogram counting
// the number of entries in `values` that fall into every bin.  The bins are
// equal width and determined by the arguments `value_range` and `nbins`.
//
// ```python
// # Bins will be:  (-inf, 1), [1, 2), [2, 3), [3, 4), [4, inf)
// nbins = 5
// value_range = [0.0, 5.0]
// new_values = [-1.0, 0.0, 1.5, 2.0, 5.0, 15]
//
// with tf.get_default_session() as sess:
//
//	hist = tf.histogram_fixed_width(new_values, value_range, nbins=5)
//	variables.global_variables_initializer().run()
//	sess.run(hist) => [2, 1, 1, 0, 2]
//
// ```
//
// Arguments:
//
//	values: Numeric `Tensor`.
//	value_range: Shape [2] `Tensor` of same `dtype` as `values`.
//
// values <= value_range[0] will be mapped to hist[0],
// values >= value_range[1] will be mapped to hist[-1].
//
//	nbins: Scalar `int32 Tensor`.  Number of histogram bins.
//
// Returns A 1-D `Tensor` holding histogram of values.
func HistogramFixedWidth(scope *Scope, values tf.Output, value_range tf.Output, nbins tf.Output, optional ...HistogramFixedWidthAttr) (out tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "HistogramFixedWidth",
		Input: []tf.Input{
			values, value_range, nbins,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Outputs a `Summary` protocol buffer with a histogram.
//
// The generated
// [`Summary`](https://www.tensorflow.org/code/tensorflow/core/framework/summary.proto)
// has one summary value containing a histogram for `values`.
//
// This op reports an `InvalidArgument` error if any value is not finite.
//
// Arguments:
//
//	tag: Scalar.  Tag to use for the `Summary.Value`.
//	values: Any shape. Values to use to build the histogram.
//
// Returns Scalar. Serialized `Summary` protocol buffer.
func HistogramSummary(scope *Scope, tag tf.Output, values tf.Output) (summary tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "HistogramSummary",
		Input: []tf.Input{
			tag, values,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns a constant tensor on the host. Only for writing C++ tests.
//
// Arguments:
//
//	value: Attr `value` is the tensor to return.
func HostConst(scope *Scope, value tf.Tensor, dtype tf.DataType) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"value": value, "dtype": dtype}
	opspec := tf.OpSpec{
		Type: "HostConst",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Inverse fast Fourier transform.
//
// Computes the inverse 1-dimensional discrete Fourier transform over the
// inner-most dimension of `input`.
//
// Arguments:
//
//	input: A complex tensor.
//
// Returns A complex tensor of the same shape as `input`. The inner-most
//
//	dimension of `input` is replaced with its inverse 1D Fourier transform.
//
// @compatibility(numpy)
// Equivalent to np.fft.ifft
// @end_compatibility
func IFFT(scope *Scope, input tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "IFFT",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Inverse 2D fast Fourier transform.
//
// Computes the inverse 2-dimensional discrete Fourier transform over the
// inner-most 2 dimensions of `input`.
//
// Arguments:
//
//	input: A complex tensor.
//
// Returns A complex tensor of the same shape as `input`. The inner-most 2
//
//	dimensions of `input` are replaced with their inverse 2D Fourier transform.
//
// @compatibility(numpy)
// Equivalent to np.fft.ifft2
// @end_compatibility
func IFFT2D(scope *Scope, input tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "IFFT2D",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Inverse 3D fast Fourier transform.
//
// Computes the inverse 3-dimensional discrete Fourier transform over the
// inner-most 3 dimensions of `input`.
//
// Arguments:
//
//	input: A complex tensor.
//
// Returns A complex tensor of the same shape as `input`. The inner-most 3
//
//	dimensions of `input` are replaced with their inverse 3D Fourier transform.
//
// @compatibility(numpy)
// Equivalent to np.fft.ifftn with 3 dimensions.
// @end_compatibility
func IFFT3D(scope *Scope, input tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "IFFT3D",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ND inverse fast Fourier transform.
//
// Computes the n-dimensional inverse discrete Fourier transform over designated
// dimensions of `input`. The designated dimensions of `input` are assumed to be
// the result of `IFFTND`.
//
// If fft_length[i]<shape(input)[i], the input is cropped. If
// fft_length[i]>shape(input)[i], the input is padded with zeros. If fft_length
// is not given, the default shape(input) is used.
//
// Axes mean the dimensions to perform the transform on. Default is to perform on
// all axes.
//
// Arguments:
//
//	input: A complex tensor.
//	fft_length: An int32 tensor. The FFT length for each dimension.
//	axes: An int32 tensor with a same shape as fft_length. Axes to perform the transform.
//
// Returns A complex tensor of the same shape as `input`. The designated dimensions of
// `input` are replaced with their inverse Fourier
// transforms.
//
// @compatibility(numpy)
// Equivalent to np.fft.fftn.
// @end_compatibility
func IFFTND(scope *Scope, input tf.Output, fft_length tf.Output, axes tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "IFFTND",
		Input: []tf.Input{
			input, fft_length, axes,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// IRFFTAttr is an optional argument to IRFFT.
type IRFFTAttr func(optionalAttr)

// IRFFTTreal sets the optional Treal attribute to value.
// If not specified, defaults to DT_FLOAT
func IRFFTTreal(value tf.DataType) IRFFTAttr {
	return func(m optionalAttr) {
		m["Treal"] = value
	}
}

// Inverse real-valued fast Fourier transform.
//
// Computes the inverse 1-dimensional discrete Fourier transform of a real-valued
// signal over the inner-most dimension of `input`.
//
// The inner-most dimension of `input` is assumed to be the result of `RFFT`: the
// `fft_length / 2 + 1` unique components of the DFT of a real-valued signal. If
// `fft_length` is not provided, it is computed from the size of the inner-most
// dimension of `input` (`fft_length = 2 * (inner - 1)`). If the FFT length used to
// compute `input` is odd, it should be provided since it cannot be inferred
// properly.
//
// Along the axis `IRFFT` is computed on, if `fft_length / 2 + 1` is smaller
// than the corresponding dimension of `input`, the dimension is cropped. If it is
// larger, the dimension is padded with zeros.
//
// Arguments:
//
//	input: A complex tensor.
//	fft_length: An int32 tensor of shape [1]. The FFT length.
//
// Returns A float32 tensor of the same rank as `input`. The inner-most
//
//	dimension of `input` is replaced with the `fft_length` samples of its inverse
//	1D Fourier transform.
//
// @compatibility(numpy)
// Equivalent to np.fft.irfft
// @end_compatibility
func IRFFT(scope *Scope, input tf.Output, fft_length tf.Output, optional ...IRFFTAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "IRFFT",
		Input: []tf.Input{
			input, fft_length,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// IRFFT2DAttr is an optional argument to IRFFT2D.
type IRFFT2DAttr func(optionalAttr)

// IRFFT2DTreal sets the optional Treal attribute to value.
// If not specified, defaults to DT_FLOAT
func IRFFT2DTreal(value tf.DataType) IRFFT2DAttr {
	return func(m optionalAttr) {
		m["Treal"] = value
	}
}

// Inverse 2D real-valued fast Fourier transform.
//
// Computes the inverse 2-dimensional discrete Fourier transform of a real-valued
// signal over the inner-most 2 dimensions of `input`.
//
// The inner-most 2 dimensions of `input` are assumed to be the result of `RFFT2D`:
// The inner-most dimension contains the `fft_length / 2 + 1` unique components of
// the DFT of a real-valued signal. If `fft_length` is not provided, it is computed
// from the size of the inner-most 2 dimensions of `input`. If the FFT length used
// to compute `input` is odd, it should be provided since it cannot be inferred
// properly.
//
// Along each axis `IRFFT2D` is computed on, if `fft_length` (or
// `fft_length / 2 + 1` for the inner-most dimension) is smaller than the
// corresponding dimension of `input`, the dimension is cropped. If it is larger,
// the dimension is padded with zeros.
//
// Arguments:
//
//	input: A complex tensor.
//	fft_length: An int32 tensor of shape [2]. The FFT length for each dimension.
//
// Returns A float32 tensor of the same rank as `input`. The inner-most 2
//
//	dimensions of `input` are replaced with the `fft_length` samples of their
//	inverse 2D Fourier transform.
//
// @compatibility(numpy)
// Equivalent to np.fft.irfft2
// @end_compatibility
func IRFFT2D(scope *Scope, input tf.Output, fft_length tf.Output, optional ...IRFFT2DAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "IRFFT2D",
		Input: []tf.Input{
			input, fft_length,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// IRFFT3DAttr is an optional argument to IRFFT3D.
type IRFFT3DAttr func(optionalAttr)

// IRFFT3DTreal sets the optional Treal attribute to value.
// If not specified, defaults to DT_FLOAT
func IRFFT3DTreal(value tf.DataType) IRFFT3DAttr {
	return func(m optionalAttr) {
		m["Treal"] = value
	}
}

// Inverse 3D real-valued fast Fourier transform.
//
// Computes the inverse 3-dimensional discrete Fourier transform of a real-valued
// signal over the inner-most 3 dimensions of `input`.
//
// The inner-most 3 dimensions of `input` are assumed to be the result of `RFFT3D`:
// The inner-most dimension contains the `fft_length / 2 + 1` unique components of
// the DFT of a real-valued signal. If `fft_length` is not provided, it is computed
// from the size of the inner-most 3 dimensions of `input`. If the FFT length used
// to compute `input` is odd, it should be provided since it cannot be inferred
// properly.
//
// Along each axis `IRFFT3D` is computed on, if `fft_length` (or
// `fft_length / 2 + 1` for the inner-most dimension) is smaller than the
// corresponding dimension of `input`, the dimension is cropped. If it is larger,
// the dimension is padded with zeros.
//
// Arguments:
//
//	input: A complex tensor.
//	fft_length: An int32 tensor of shape [3]. The FFT length for each dimension.
//
// Returns A float32 tensor of the same rank as `input`. The inner-most 3
//
//	dimensions of `input` are replaced with the `fft_length` samples of their
//	inverse 3D real Fourier transform.
//
// @compatibility(numpy)
// Equivalent to np.irfftn with 3 dimensions.
// @end_compatibility
func IRFFT3D(scope *Scope, input tf.Output, fft_length tf.Output, optional ...IRFFT3DAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "IRFFT3D",
		Input: []tf.Input{
			input, fft_length,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// IRFFTNDAttr is an optional argument to IRFFTND.
type IRFFTNDAttr func(optionalAttr)

// IRFFTNDTreal sets the optional Treal attribute to value.
// If not specified, defaults to DT_FLOAT
func IRFFTNDTreal(value tf.DataType) IRFFTNDAttr {
	return func(m optionalAttr) {
		m["Treal"] = value
	}
}

// ND inverse real fast Fourier transform.
//
// Computes the n-dimensional inverse real discrete Fourier transform over
// designated dimensions of `input`. The designated dimensions of `input` are
// assumed to be the result of `IRFFTND`. The inner-most dimension contains the
// `fft_length / 2 + 1` unique components of the DFT of a real-valued signal.
//
// If fft_length[i]<shape(input)[i], the input is cropped. If
// fft_length[i]>shape(input)[i], the input is padded with zeros. If fft_length
// is not given, the default shape(input) is used.
//
// Axes mean the dimensions to perform the transform on. Default is to perform on
// all axes.
//
// Arguments:
//
//	input: A complex tensor.
//	fft_length: An int32 tensor. The FFT length for each dimension.
//	axes: An int32 tensor with a same shape as fft_length. Axes to perform the transform.
//
// Returns A complex tensor of the same shape as `input`. The designated dimensions of
// `input` are replaced with their inverse real Fourier transforms.
//
// @compatibility(numpy)
// Equivalent to np.fft.irfftn.
// @end_compatibility
func IRFFTND(scope *Scope, input tf.Output, fft_length tf.Output, axes tf.Output, optional ...IRFFTNDAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "IRFFTND",
		Input: []tf.Input{
			input, fft_length, axes,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Return a tensor with the same shape and contents as the input tensor or value.
func Identity(scope *Scope, input tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Identity",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns a list of tensors with the same shapes and contents as the input
//
// tensors.
//
// This op can be used to override the gradient for complicated functions. For
// example, suppose y = f(x) and we wish to apply a custom function g for backprop
// such that dx = g(dy). In Python,
//
// ```python
// with tf.get_default_graph().gradient_override_map(
//
//	  {'IdentityN': 'OverrideGradientWithG'}):
//	y, _ = identity_n([f(x), x])
//
// @tf.RegisterGradient('OverrideGradientWithG')
// def ApplyG(op, dy, _):
//
//	return [None, g(dy)]  # Do not backprop to f(x).
//
// ```
func IdentityN(scope *Scope, input []tf.Output) (output []tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "IdentityN",
		Input: []tf.Input{
			tf.OutputList(input),
		},
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if output, idx, err = makeOutputList(op, idx, "output"); err != nil {
		scope.UpdateErr("IdentityN", err)
		return
	}
	return output
}

// IdentityReaderV2Attr is an optional argument to IdentityReaderV2.
type IdentityReaderV2Attr func(optionalAttr)

// IdentityReaderV2Container sets the optional container attribute to value.
//
// value: If non-empty, this reader is placed in the given container.
// Otherwise, a default container is used.
// If not specified, defaults to ""
func IdentityReaderV2Container(value string) IdentityReaderV2Attr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// IdentityReaderV2SharedName sets the optional shared_name attribute to value.
//
// value: If non-empty, this reader is named in the given bucket
// with this shared_name. Otherwise, the node name is used instead.
// If not specified, defaults to ""
func IdentityReaderV2SharedName(value string) IdentityReaderV2Attr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// A Reader that outputs the queued work as both the key and value.
//
// To use, enqueue strings in a Queue.  ReaderRead will take the front
// work string and output (work, work).
//
// Returns The handle to reference the Reader.
func IdentityReaderV2(scope *Scope, optional ...IdentityReaderV2Attr) (reader_handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "IdentityReaderV2",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Compute the lower regularized incomplete Gamma function `P(a, x)`.
//
// The lower regularized incomplete Gamma function is defined as:
//
// \\(P(a, x) = gamma(a, x) / Gamma(a) = 1 - Q(a, x)\\)
//
// where
//
// \\(gamma(a, x) = \int_{0}^{x} t^{a-1} exp(-t) dt\\)
//
// is the lower incomplete Gamma function.
//
// Note, above `Q(a, x)` (`Igammac`) is the upper regularized complete
// Gamma function.
func Igamma(scope *Scope, a tf.Output, x tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Igamma",
		Input: []tf.Input{
			a, x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the gradient of `igamma(a, x)` wrt `a`.
func IgammaGradA(scope *Scope, a tf.Output, x tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "IgammaGradA",
		Input: []tf.Input{
			a, x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Compute the upper regularized incomplete Gamma function `Q(a, x)`.
//
// The upper regularized incomplete Gamma function is defined as:
//
// \\(Q(a, x) = Gamma(a, x) / Gamma(a) = 1 - P(a, x)\\)
//
// where
//
// \\(Gamma(a, x) = \int_{x}^{\infty} t^{a-1} exp(-t) dt\\)
//
// is the upper incomplete Gamma function.
//
// Note, above `P(a, x)` (`Igamma`) is the lower regularized complete
// Gamma function.
func Igammac(scope *Scope, a tf.Output, x tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Igammac",
		Input: []tf.Input{
			a, x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// IgnoreErrorsDatasetAttr is an optional argument to IgnoreErrorsDataset.
type IgnoreErrorsDatasetAttr func(optionalAttr)

// IgnoreErrorsDatasetLogWarning sets the optional log_warning attribute to value.
// If not specified, defaults to false
func IgnoreErrorsDatasetLogWarning(value bool) IgnoreErrorsDatasetAttr {
	return func(m optionalAttr) {
		m["log_warning"] = value
	}
}

// Creates a dataset that contains the elements of `input_dataset` ignoring errors.
func IgnoreErrorsDataset(scope *Scope, input_dataset tf.Output, output_types []tf.DataType, output_shapes []tf.Shape, optional ...IgnoreErrorsDatasetAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "IgnoreErrorsDataset",
		Input: []tf.Input{
			input_dataset,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ImagAttr is an optional argument to Imag.
type ImagAttr func(optionalAttr)

// ImagTout sets the optional Tout attribute to value.
//
// value: Need to be `tf.float32` when the type of `x` is `tf.complex64`.
// Need to be `tf.float64` when the type of `x` is `tf.complex128`.
// If not specified, defaults to DT_FLOAT
func ImagTout(value tf.DataType) ImagAttr {
	return func(m optionalAttr) {
		m["Tout"] = value
	}
}

// Returns the imaginary part of a complex number.
//
// Given a tensor `input` of complex numbers, this operation returns a tensor of
// type `float` that is the imaginary part of each element in `input`. All
// elements in `input` must be complex numbers of the form \\(a + bj\\), where *a*
// is the real part and *b* is the imaginary part returned by this operation.
//
// For example:
//
// ```
// # tensor 'input' is [-2.25 + 4.75j, 3.25 + 5.75j]
// tf.imag(input) ==> [4.75, 5.75]
// ```
func Imag(scope *Scope, input tf.Output, optional ...ImagAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Imag",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ImageProjectiveTransformV2Attr is an optional argument to ImageProjectiveTransformV2.
type ImageProjectiveTransformV2Attr func(optionalAttr)

// ImageProjectiveTransformV2FillMode sets the optional fill_mode attribute to value.
//
// value: Fill mode, "REFLECT", "WRAP", or "CONSTANT".
// If not specified, defaults to "CONSTANT"
func ImageProjectiveTransformV2FillMode(value string) ImageProjectiveTransformV2Attr {
	return func(m optionalAttr) {
		m["fill_mode"] = value
	}
}

// Applies the given transform to each of the images.
//
// If one row of `transforms` is `[a0, a1, a2, b0, b1, b2, c0, c1]`, then it maps
// the *output* point `(x, y)` to a transformed *input* point
// `(x', y') = ((a0 x + a1 y + a2) / k, (b0 x + b1 y + b2) / k)`, where
// `k = c0 x + c1 y + 1`. If the transformed point lays outside of the input
// image, the output pixel is set to 0.
//
// Arguments:
//
//	images: 4-D with shape `[batch, height, width, channels]`.
//	transforms: 2-D Tensor, `[batch, 8]` or `[1, 8]` matrix, where each row corresponds to a 3 x 3
//
// projective transformation matrix, with the last entry assumed to be 1. If there
// is one row, the same transformation will be applied to all images.
//
//	output_shape: 1-D Tensor [new_height, new_width].
//	interpolation: Interpolation method, "NEAREST" or "BILINEAR".
//
// Returns 4-D with shape
// `[batch, new_height, new_width, channels]`.
func ImageProjectiveTransformV2(scope *Scope, images tf.Output, transforms tf.Output, output_shape tf.Output, interpolation string, optional ...ImageProjectiveTransformV2Attr) (transformed_images tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"interpolation": interpolation}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ImageProjectiveTransformV2",
		Input: []tf.Input{
			images, transforms, output_shape,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ImageProjectiveTransformV3Attr is an optional argument to ImageProjectiveTransformV3.
type ImageProjectiveTransformV3Attr func(optionalAttr)

// ImageProjectiveTransformV3FillMode sets the optional fill_mode attribute to value.
//
// value: Fill mode, "REFLECT", "WRAP", "CONSTANT", or "NEAREST".
// If not specified, defaults to "CONSTANT"
func ImageProjectiveTransformV3FillMode(value string) ImageProjectiveTransformV3Attr {
	return func(m optionalAttr) {
		m["fill_mode"] = value
	}
}

// Applies the given transform to each of the images.
//
// If one row of `transforms` is `[a0, a1, a2, b0, b1, b2, c0, c1]`, then it maps
// the *output* point `(x, y)` to a transformed *input* point
// `(x', y') = ((a0 x + a1 y + a2) / k, (b0 x + b1 y + b2) / k)`, where
// `k = c0 x + c1 y + 1`. If the transformed point lays outside of the input
// image, the output pixel is set to fill_value.
//
// Arguments:
//
//	images: 4-D with shape `[batch, height, width, channels]`.
//	transforms: 2-D Tensor, `[batch, 8]` or `[1, 8]` matrix, where each row corresponds to a 3 x 3
//
// projective transformation matrix, with the last entry assumed to be 1. If there
// is one row, the same transformation will be applied to all images.
//
//	output_shape: 1-D Tensor [new_height, new_width].
//	fill_value: float, the value to be filled when fill_mode is constant".
//	interpolation: Interpolation method, "NEAREST" or "BILINEAR".
//
// Returns 4-D with shape
// `[batch, new_height, new_width, channels]`.
func ImageProjectiveTransformV3(scope *Scope, images tf.Output, transforms tf.Output, output_shape tf.Output, fill_value tf.Output, interpolation string, optional ...ImageProjectiveTransformV3Attr) (transformed_images tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"interpolation": interpolation}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ImageProjectiveTransformV3",
		Input: []tf.Input{
			images, transforms, output_shape, fill_value,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ImageSummaryAttr is an optional argument to ImageSummary.
type ImageSummaryAttr func(optionalAttr)

// ImageSummaryMaxImages sets the optional max_images attribute to value.
//
// value: Max number of batch elements to generate images for.
// If not specified, defaults to 3
//
// REQUIRES: value >= 1
func ImageSummaryMaxImages(value int64) ImageSummaryAttr {
	return func(m optionalAttr) {
		m["max_images"] = value
	}
}

// ImageSummaryBadColor sets the optional bad_color attribute to value.
//
// value: Color to use for pixels with non-finite values.
// If not specified, defaults to {dtype:DT_UINT8 tensor_shape:{dim:{size:4}} int_val:255 int_val:0 int_val:0 int_val:255}
func ImageSummaryBadColor(value tf.Tensor) ImageSummaryAttr {
	return func(m optionalAttr) {
		m["bad_color"] = value
	}
}

// Outputs a `Summary` protocol buffer with images.
//
// The summary has up to `max_images` summary values containing images. The
// images are built from `tensor` which must be 4-D with shape `[batch_size,
// height, width, channels]` and where `channels` can be:
//
// *  1: `tensor` is interpreted as Grayscale.
// *  3: `tensor` is interpreted as RGB.
// *  4: `tensor` is interpreted as RGBA.
//
// The images have the same number of channels as the input tensor. For float
// input, the values are normalized one image at a time to fit in the range
// `[0, 255]`.  `uint8` values are unchanged.  The op uses two different
// normalization algorithms:
//
//   - If the input values are all positive, they are rescaled so the largest one
//     is 255.
//
//   - If any input value is negative, the values are shifted so input value 0.0
//     is at 127.  They are then rescaled so that either the smallest value is 0,
//     or the largest one is 255.
//
// The `tag` argument is a scalar `Tensor` of type `string`.  It is used to
// build the `tag` of the summary values:
//
//   - If `max_images` is 1, the summary value tag is '*tag*/image'.
//   - If `max_images` is greater than 1, the summary value tags are
//     generated sequentially as '*tag*/image/0', '*tag*/image/1', etc.
//
// The `bad_color` argument is the color to use in the generated images for
// non-finite input values.  It is a `uint8` 1-D tensor of length `channels`.
// Each element must be in the range `[0, 255]` (It represents the value of a
// pixel in the output image).  Non-finite values in the input tensor are
// replaced by this tensor in the output image.  The default value is the color
// red.
//
// Arguments:
//
//	tag: Scalar. Used to build the `tag` attribute of the summary values.
//	tensor: 4-D of shape `[batch_size, height, width, channels]` where
//
// `channels` is 1, 3, or 4.
//
// Returns Scalar. Serialized `Summary` protocol buffer.
func ImageSummary(scope *Scope, tag tf.Output, tensor tf.Output, optional ...ImageSummaryAttr) (summary tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ImageSummary",
		Input: []tf.Input{
			tag, tensor,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns immutable tensor from memory region.
//
// The current implementation memmaps the tensor from a file.
//
// Arguments:
//
//	dtype: Type of the returned tensor.
//	shape: Shape of the returned tensor.
//	memory_region_name: Name of readonly memory region used by the tensor, see
//
// NewReadOnlyMemoryRegionFromFile in tensorflow::Env.
func ImmutableConst(scope *Scope, dtype tf.DataType, shape tf.Shape, memory_region_name string) (tensor tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtype": dtype, "shape": shape, "memory_region_name": memory_region_name}
	opspec := tf.OpSpec{
		Type: "ImmutableConst",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Says whether the targets are in the top `K` predictions.
//
// This outputs a `batch_size` bool array, an entry `out[i]` is `true` if the
// prediction for the target class is among the top `k` predictions among
// all predictions for example `i`. Note that the behavior of `InTopK` differs
// from the `TopK` op in its handling of ties; if multiple classes have the
// same prediction value and straddle the top-`k` boundary, all of those
// classes are considered to be in the top `k`.
//
// More formally, let
//
//	\\(predictions_i\\) be the predictions for all classes for example `i`,
//	\\(targets_i\\) be the target class for example `i`,
//	\\(out_i\\) be the output for example `i`,
//
// $$out_i = predictions_{i, targets_i} \in TopKIncludingTies(predictions_i)$$
//
// Arguments:
//
//	predictions: A `batch_size` x `classes` tensor.
//	targets: A `batch_size` vector of class ids.
//	k: Number of top elements to look at for computing precision.
//
// Returns Computed Precision at `k` as a `bool Tensor`.
func InTopK(scope *Scope, predictions tf.Output, targets tf.Output, k int64) (precision tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"k": k}
	opspec := tf.OpSpec{
		Type: "InTopK",
		Input: []tf.Input{
			predictions, targets,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Says whether the targets are in the top `K` predictions.
//
// This outputs a `batch_size` bool array, an entry `out[i]` is `true` if the
// prediction for the target class is among the top `k` predictions among
// all predictions for example `i`. Note that the behavior of `InTopK` differs
// from the `TopK` op in its handling of ties; if multiple classes have the
// same prediction value and straddle the top-`k` boundary, all of those
// classes are considered to be in the top `k`.
//
// More formally, let
//
//	\\(predictions_i\\) be the predictions for all classes for example `i`,
//	\\(targets_i\\) be the target class for example `i`,
//	\\(out_i\\) be the output for example `i`,
//
// $$out_i = predictions_{i, targets_i} \in TopKIncludingTies(predictions_i)$$
//
// Arguments:
//
//	predictions: A `batch_size` x `classes` tensor.
//	targets: A `batch_size` vector of class ids.
//	k: Number of top elements to look at for computing precision.
//
// Returns Computed precision at `k` as a `bool Tensor`.
func InTopKV2(scope *Scope, predictions tf.Output, targets tf.Output, k tf.Output) (precision tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "InTopKV2",
		Input: []tf.Input{
			predictions, targets, k,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// A placeholder op for a value that will be fed into the computation.
//
// Arguments:
//
//	dtype: The type of elements in the tensor.
//	shape: The shape of the tensor.
//
// Returns A tensor that will be provided using the infeed mechanism.
func InfeedDequeue(scope *Scope, dtype tf.DataType, shape tf.Shape) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtype": dtype, "shape": shape}
	opspec := tf.OpSpec{
		Type: "InfeedDequeue",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Fetches multiple values from infeed as an XLA tuple.
//
// Arguments:
//
//	dtypes: The element types of each element in `outputs`.
//	shapes: The shapes of each tensor in `outputs`.
//
// Returns A list of tensors that will be provided using the infeed mechanism.
func InfeedDequeueTuple(scope *Scope, dtypes []tf.DataType, shapes []tf.Shape) (outputs []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtypes": dtypes, "shapes": shapes}
	opspec := tf.OpSpec{
		Type: "InfeedDequeueTuple",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if outputs, idx, err = makeOutputList(op, idx, "outputs"); err != nil {
		scope.UpdateErr("InfeedDequeueTuple", err)
		return
	}
	return outputs
}

// InfeedEnqueueAttr is an optional argument to InfeedEnqueue.
type InfeedEnqueueAttr func(optionalAttr)

// InfeedEnqueueShape sets the optional shape attribute to value.
//
// value: The shape of the tensor.
// If not specified, defaults to {}
func InfeedEnqueueShape(value tf.Shape) InfeedEnqueueAttr {
	return func(m optionalAttr) {
		m["shape"] = value
	}
}

// InfeedEnqueueLayout sets the optional layout attribute to value.
//
// value: A vector holding the requested layout in minor-to-major sequence.
// If a layout attribute is passed, but its values are all -1, the layout will
// be computed by the infeed operation.
// If not specified, defaults to {}
func InfeedEnqueueLayout(value []int64) InfeedEnqueueAttr {
	return func(m optionalAttr) {
		m["layout"] = value
	}
}

// InfeedEnqueueDeviceOrdinal sets the optional device_ordinal attribute to value.
//
// value: The TPU device to use. This should be -1 when the Op
// is running on a TPU device, and >= 0 when the Op is running on the CPU
// device.
// If not specified, defaults to -1
func InfeedEnqueueDeviceOrdinal(value int64) InfeedEnqueueAttr {
	return func(m optionalAttr) {
		m["device_ordinal"] = value
	}
}

// An op which feeds a single Tensor value into the computation.
//
// Arguments:
//
//	input: A tensor that will be provided using the infeed mechanism.
//
// Returns the created operation.
func InfeedEnqueue(scope *Scope, input tf.Output, optional ...InfeedEnqueueAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "InfeedEnqueue",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// InfeedEnqueuePrelinearizedBufferAttr is an optional argument to InfeedEnqueuePrelinearizedBuffer.
type InfeedEnqueuePrelinearizedBufferAttr func(optionalAttr)

// InfeedEnqueuePrelinearizedBufferDeviceOrdinal sets the optional device_ordinal attribute to value.
//
// value: The TPU device to use. This should be -1 when the Op is running on a TPU device
// and = 0 when the Op is running on the CPU device.
// If not specified, defaults to -1
func InfeedEnqueuePrelinearizedBufferDeviceOrdinal(value int64) InfeedEnqueuePrelinearizedBufferAttr {
	return func(m optionalAttr) {
		m["device_ordinal"] = value
	}
}

// An op which enqueues prelinearized buffer into TPU infeed.
//
// Arguments:
//
//	input: A variant tensor representing linearized output.
//
// Returns the created operation.
func InfeedEnqueuePrelinearizedBuffer(scope *Scope, input tf.Output, optional ...InfeedEnqueuePrelinearizedBufferAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "InfeedEnqueuePrelinearizedBuffer",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// InfeedEnqueueTupleAttr is an optional argument to InfeedEnqueueTuple.
type InfeedEnqueueTupleAttr func(optionalAttr)

// InfeedEnqueueTupleLayouts sets the optional layouts attribute to value.
//
// value: A vector holding the requested layout in minor-to-major sequence for
// all the tuple shapes, in the order the shapes appear in the "shapes" input.
// The layout elements for a sub-shape can be set to -1, in which case the
// corresponding layout will be computed by the infeed operation.
// If not specified, defaults to {}
func InfeedEnqueueTupleLayouts(value []int64) InfeedEnqueueTupleAttr {
	return func(m optionalAttr) {
		m["layouts"] = value
	}
}

// InfeedEnqueueTupleDeviceOrdinal sets the optional device_ordinal attribute to value.
//
// value: The TPU device to use. This should be -1 when the Op
// is running on a TPU device, and >= 0 when the Op is running on the CPU
// device.
// If not specified, defaults to -1
func InfeedEnqueueTupleDeviceOrdinal(value int64) InfeedEnqueueTupleAttr {
	return func(m optionalAttr) {
		m["device_ordinal"] = value
	}
}

// Feeds multiple Tensor values into the computation as an XLA tuple.
//
// Arguments:
//
//	inputs: A list of tensors that will be provided using the infeed mechanism.
//	shapes: The shapes of each tensor in `inputs`.
//
// Returns the created operation.
func InfeedEnqueueTuple(scope *Scope, inputs []tf.Output, shapes []tf.Shape, optional ...InfeedEnqueueTupleAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"shapes": shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "InfeedEnqueueTuple",
		Input: []tf.Input{
			tf.OutputList(inputs),
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// InitializeTableFromTextFileV2Attr is an optional argument to InitializeTableFromTextFileV2.
type InitializeTableFromTextFileV2Attr func(optionalAttr)

// InitializeTableFromTextFileV2VocabSize sets the optional vocab_size attribute to value.
//
// value: Number of elements of the file, use -1 if unknown.
// If not specified, defaults to -1
//
// REQUIRES: value >= -1
func InitializeTableFromTextFileV2VocabSize(value int64) InitializeTableFromTextFileV2Attr {
	return func(m optionalAttr) {
		m["vocab_size"] = value
	}
}

// InitializeTableFromTextFileV2Delimiter sets the optional delimiter attribute to value.
//
// value: Delimiter to separate fields in a line.
// If not specified, defaults to "\t"
func InitializeTableFromTextFileV2Delimiter(value string) InitializeTableFromTextFileV2Attr {
	return func(m optionalAttr) {
		m["delimiter"] = value
	}
}

// InitializeTableFromTextFileV2Offset sets the optional offset attribute to value.
// If not specified, defaults to 0
func InitializeTableFromTextFileV2Offset(value int64) InitializeTableFromTextFileV2Attr {
	return func(m optionalAttr) {
		m["offset"] = value
	}
}

// Initializes a table from a text file.
//
// It inserts one key-value pair into the table for each line of the file.
// The key and value is extracted from the whole line content, elements from the
// split line based on `delimiter` or the line number (starting from zero).
// Where to extract the key and value from a line is specified by `key_index` and
// `value_index`.
//
//   - A value of -1 means use the line number(starting from zero), expects `int64`.
//   - A value of -2 means use the whole line content, expects `string`.
//   - A value >= 0 means use the index (starting at zero) of the split line based
//     on `delimiter`.
//
// Arguments:
//
//	table_handle: Handle to a table which will be initialized.
//	filename: Filename of a vocabulary text file.
//	key_index: Column index in a line to get the table `key` values from.
//	value_index: Column index that represents information of a line to get the table
//
// `value` values from.
//
// Returns the created operation.
func InitializeTableFromTextFileV2(scope *Scope, table_handle tf.Output, filename tf.Output, key_index int64, value_index int64, optional ...InitializeTableFromTextFileV2Attr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"key_index": key_index, "value_index": value_index}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "InitializeTableFromTextFileV2",
		Input: []tf.Input{
			table_handle, filename,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// Table initializer that takes two tensors for keys and values respectively.
//
// Arguments:
//
//	table_handle: Handle to a table which will be initialized.
//	keys: Keys of type Tkey.
//	values: Values of type Tval.
//
// Returns the created operation.
func InitializeTableV2(scope *Scope, table_handle tf.Output, keys tf.Output, values tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "InitializeTableV2",
		Input: []tf.Input{
			table_handle, keys, values,
		},
	}
	return scope.AddOperation(opspec)
}

// Adds v into specified rows of x.
//
//	Computes y = x; y[i, :] += v; return y.
//
// Arguments:
//
//	x: A `Tensor` of type T.
//	i: A vector. Indices into the left-most dimension of `x`.
//	v: A `Tensor` of type T. Same dimension sizes as x except the first dimension, which must be the same as i's size.
//
// Returns A `Tensor` of type T. An alias of `x`. The content of `y` is undefined if there are duplicates in `i`.
func InplaceAdd(scope *Scope, x tf.Output, i tf.Output, v tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "InplaceAdd",
		Input: []tf.Input{
			x, i, v,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

//	Subtracts `v` into specified rows of `x`.
//
//	Computes y = x; y[i, :] -= v; return y.
//
// Arguments:
//
//	x: A `Tensor` of type T.
//	i: A vector. Indices into the left-most dimension of `x`.
//	v: A `Tensor` of type T. Same dimension sizes as x except the first dimension, which must be the same as i's size.
//
// Returns A `Tensor` of type T. An alias of `x`. The content of `y` is undefined if there are duplicates in `i`.
func InplaceSub(scope *Scope, x tf.Output, i tf.Output, v tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "InplaceSub",
		Input: []tf.Input{
			x, i, v,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Updates specified rows 'i' with values 'v'.
//
// Computes `x[i, :] = v; return x`.
//
// Originally this function is mutative however for compilation we make this
// operation create / operate on a copy of `x`.
//
// Arguments:
//
//	x: A tensor of type `T`.
//	i: A vector. Indices into the left-most dimension of `x`.
//	v: A `Tensor` of type T. Same dimension sizes as x except the first dimension, which must be the same as i's size.
//
// Returns A `Tensor` of type T. An alias of `x`. The content of `y` is undefined if there are duplicates in `i`.
func InplaceUpdate(scope *Scope, x tf.Output, i tf.Output, v tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "InplaceUpdate",
		Input: []tf.Input{
			x, i, v,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the reciprocal of x element-wise.
//
// I.e., \\(y = 1 / x\\).
func Inv(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Inv",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the gradient for the inverse of `x` wrt its input.
//
// Specifically, `grad = -dy * y*y`, where `y = 1/x`, and `dy`
// is the corresponding input gradient.
func InvGrad(scope *Scope, y tf.Output, dy tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "InvGrad",
		Input: []tf.Input{
			y, dy,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Invert (flip) each bit of supported types; for example, type `uint8` value 01010101 becomes 10101010.
//
// Flip each bit of supported types.  For example, type `int8` (decimal 2) binary 00000010 becomes (decimal -3) binary 11111101.
// This operation is performed on each element of the tensor argument `x`.
//
// Example:
// ```python
// import tensorflow as tf
// from tensorflow.python.ops import bitwise_ops
//
// # flip 2 (00000010) to -3 (11111101)
// tf.assert_equal(-3, bitwise_ops.invert(2))
//
// dtype_list = [dtypes.int8, dtypes.int16, dtypes.int32, dtypes.int64,
//
//	dtypes.uint8, dtypes.uint16, dtypes.uint32, dtypes.uint64]
//
// inputs = [0, 5, 3, 14]
// for dtype in dtype_list:
//
//	# Because of issues with negative numbers, let's test this indirectly.
//	# 1. invert(a) and a = 0
//	# 2. invert(a) or a = invert(0)
//	input_tensor = tf.constant([0, 5, 3, 14], dtype=dtype)
//	not_a_and_a, not_a_or_a, not_0 = [bitwise_ops.bitwise_and(
//	                                    input_tensor, bitwise_ops.invert(input_tensor)),
//	                                  bitwise_ops.bitwise_or(
//	                                    input_tensor, bitwise_ops.invert(input_tensor)),
//	                                  bitwise_ops.invert(
//	                                    tf.constant(0, dtype=dtype))]
//
//	expected = tf.constant([0, 0, 0, 0], dtype=tf.float32)
//	tf.assert_equal(tf.cast(not_a_and_a, tf.float32), expected)
//
//	expected = tf.cast([not_0] * 4, tf.float32)
//	tf.assert_equal(tf.cast(not_a_or_a, tf.float32), expected)
//
//	# For unsigned dtypes let's also check the result directly.
//	if dtype.is_unsigned:
//	  inverted = bitwise_ops.invert(input_tensor)
//	  expected = tf.constant([dtype.max - x for x in inputs], dtype=tf.float32)
//	  tf.assert_equal(tf.cast(inverted, tf.float32), tf.cast(expected, tf.float32))
//
// ```
func Invert(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Invert",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the inverse permutation of a tensor.
//
// This operation computes the inverse of an index permutation. It takes a 1-D
// integer tensor `x`, which represents the indices of a zero-based array, and
// swaps each value with its index position. In other words, for an output tensor
// `y` and an input tensor `x`, this operation computes the following:
//
// `y[x[i]] = i for i in [0, 1, ..., len(x) - 1]`
//
// The values must include 0. There can be no duplicate values or negative values.
//
// For example:
//
// ```
// # tensor `x` is [3, 4, 0, 2, 1]
// invert_permutation(x) ==> [2, 4, 3, 0, 1]
// ```
//
// Arguments:
//
//	x: 1-D.
//
// Returns 1-D.
func InvertPermutation(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "InvertPermutation",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Checks whether a tree ensemble has been initialized.
//
// Arguments:
//
//	tree_ensemble_handle: Handle to the tree ensemble resource.
//
// Returns output boolean on whether it is initialized or not.
func IsBoostedTreesEnsembleInitialized(scope *Scope, tree_ensemble_handle tf.Output) (is_initialized tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "IsBoostedTreesEnsembleInitialized",
		Input: []tf.Input{
			tree_ensemble_handle,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Checks whether a quantile stream has been initialized.
//
// An Op that checks if quantile stream resource is initialized.
//
// Arguments:
//
//	quantile_stream_resource_handle: resource; The reference to quantile stream resource handle.
//
// Returns bool; True if the resource is initialized, False otherwise.
func IsBoostedTreesQuantileStreamResourceInitialized(scope *Scope, quantile_stream_resource_handle tf.Output) (is_initialized tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "IsBoostedTreesQuantileStreamResourceInitialized",
		Input: []tf.Input{
			quantile_stream_resource_handle,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns which elements of x are finite.
//
// @compatibility(numpy)
// Equivalent to np.isfinite
// @end_compatibility
//
// Example:
//
// ```python
// x = tf.constant([5.0, 4.8, 6.8, np.inf, np.nan])
// tf.math.is_finite(x) ==> [True, True, True, False, False]
// ```
func IsFinite(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "IsFinite",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns which elements of x are Inf.
//
// @compatibility(numpy)
// Equivalent to np.isinf
// @end_compatibility
//
// Example:
//
// ```python
// x = tf.constant([5.0, np.inf, 6.8, np.inf])
// tf.math.is_inf(x) ==> [False, True, False, True]
// ```
func IsInf(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "IsInf",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns which elements of x are NaN.
//
// @compatibility(numpy)
// Equivalent to np.isnan
// @end_compatibility
//
// Example:
//
// ```python
// x = tf.constant([5.0, np.nan, 6.8, np.nan, np.inf])
// tf.math.is_nan(x) ==> [False, True, False, True, False]
// ```
func IsNan(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "IsNan",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// IsTPUEmbeddingInitializedAttr is an optional argument to IsTPUEmbeddingInitialized.
type IsTPUEmbeddingInitializedAttr func(optionalAttr)

// IsTPUEmbeddingInitializedConfig sets the optional config attribute to value.
// If not specified, defaults to ""
func IsTPUEmbeddingInitializedConfig(value string) IsTPUEmbeddingInitializedAttr {
	return func(m optionalAttr) {
		m["config"] = value
	}
}

// Whether TPU Embedding is initialized in a distributed TPU system.
func IsTPUEmbeddingInitialized(scope *Scope, optional ...IsTPUEmbeddingInitializedAttr) (is_tpu_embedding_initialized tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "IsTPUEmbeddingInitialized",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// IsotonicRegressionAttr is an optional argument to IsotonicRegression.
type IsotonicRegressionAttr func(optionalAttr)

// IsotonicRegressionOutputDtype sets the optional output_dtype attribute to value.
//
// value: Dtype of the output tensor.
//
// Note on supported input-output type combinations:
// * For floating-point types, the output has the same dtype as the input.
// * For 8-bit and 16-bit integer inputs, the output is a 32-bit float.
// * For 32-bit and 64-bit integer inputs, the output is a 64-bit float.
//
// Using unsupported dtype pairs (for example, input=float64 with output=float32)
// will result in a "Could not find device for node" error.
// If not specified, defaults to DT_FLOAT
func IsotonicRegressionOutputDtype(value tf.DataType) IsotonicRegressionAttr {
	return func(m optionalAttr) {
		m["output_dtype"] = value
	}
}

// Solves a batch of isotonic regression problems.
//
// Arguments:
//
//	input: A (batch_size, dim)-tensor holding a batch of inputs.
//
// Returns:
//
//	output: A (batch_size, dim)-tensor holding the per-batch element solutions.
//	segments: An int32 (batch_size, dim)-tensor with the segments.
func IsotonicRegression(scope *Scope, input tf.Output, optional ...IsotonicRegressionAttr) (output tf.Output, segments tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "IsotonicRegression",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// A container for an iterator resource.
//
// Returns A handle to the iterator that can be passed to a "MakeIterator"
// or "IteratorGetNext" op.
func Iterator(scope *Scope, shared_name string, container string, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"shared_name": shared_name, "container": container, "output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "Iterator",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// IteratorFromStringHandleAttr is an optional argument to IteratorFromStringHandle.
type IteratorFromStringHandleAttr func(optionalAttr)

// IteratorFromStringHandleOutputTypes sets the optional output_types attribute to value.
//
// value: If specified, defines the type of each tuple component in an
// element produced by the resulting iterator.
// If not specified, defaults to {}
//
// REQUIRES: len(value) >= 0
func IteratorFromStringHandleOutputTypes(value []tf.DataType) IteratorFromStringHandleAttr {
	return func(m optionalAttr) {
		m["output_types"] = value
	}
}

// IteratorFromStringHandleOutputShapes sets the optional output_shapes attribute to value.
//
// value: If specified, defines the shape of each tuple component in an
// element produced by the resulting iterator.
// If not specified, defaults to {}
//
// REQUIRES: len(value) >= 0
func IteratorFromStringHandleOutputShapes(value []tf.Shape) IteratorFromStringHandleAttr {
	return func(m optionalAttr) {
		m["output_shapes"] = value
	}
}

// Converts the given string representing a handle to an iterator to a resource.
//
// Arguments:
//
//	string_handle: A string representation of the given handle.
//
// Returns A handle to an iterator resource.
func IteratorFromStringHandle(scope *Scope, string_handle tf.Output, optional ...IteratorFromStringHandleAttr) (resource_handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "IteratorFromStringHandle",
		Input: []tf.Input{
			string_handle,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the name of the device on which `resource` has been placed.
func IteratorGetDevice(scope *Scope, resource tf.Output) (device tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "IteratorGetDevice",
		Input: []tf.Input{
			resource,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the serialized model proto of an iterator resource.
//
// Returns the serialized model proto of an iterator resource.
//
// Arguments:
//
//	iterator: An resource from an dataset iterator.
//
// Returns A serialized model proto.
func IteratorGetModelProto(scope *Scope, iterator tf.Output) (model_proto tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "IteratorGetModelProto",
		Input: []tf.Input{
			iterator,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Gets the next output from the given iterator .
func IteratorGetNext(scope *Scope, iterator tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (components []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "IteratorGetNext",
		Input: []tf.Input{
			iterator,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if components, idx, err = makeOutputList(op, idx, "components"); err != nil {
		scope.UpdateErr("IteratorGetNext", err)
		return
	}
	return components
}

// Gets the next output from the given iterator as an Optional variant.
func IteratorGetNextAsOptional(scope *Scope, iterator tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (optional tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "IteratorGetNextAsOptional",
		Input: []tf.Input{
			iterator,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Gets the next output from the given iterator.
//
// This operation is a synchronous version IteratorGetNext. It should only be used
// in situations where the iterator does not block the calling thread, or where
// the calling thread is not a member of the thread pool used to execute parallel
// operations (e.g. in eager mode).
func IteratorGetNextSync(scope *Scope, iterator tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (components []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "IteratorGetNextSync",
		Input: []tf.Input{
			iterator,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if components, idx, err = makeOutputList(op, idx, "components"); err != nil {
		scope.UpdateErr("IteratorGetNextSync", err)
		return
	}
	return components
}

// Converts the given `resource_handle` representing an iterator to a string.
//
// Arguments:
//
//	resource_handle: A handle to an iterator resource.
//
// Returns A string representation of the given handle.
func IteratorToStringHandle(scope *Scope, resource_handle tf.Output) (string_handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "IteratorToStringHandle",
		Input: []tf.Input{
			resource_handle,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the index of a data point that should be added to the seed set.
//
// Entries in distances are assumed to be squared distances of candidate points to
// the already sampled centers in the seed set. The op constructs one Markov chain
// of the k-MC^2 algorithm and returns the index of one candidate point to be added
// as an additional cluster center.
//
// Arguments:
//
//	distances: Vector with squared distances to the closest previously sampled cluster center
//
// for each candidate point.
//
//	seed: Scalar. Seed for initializing the random number generator.
//
// Returns Scalar with the index of the sampled point.
func KMC2ChainInitialization(scope *Scope, distances tf.Output, seed tf.Output) (index tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "KMC2ChainInitialization",
		Input: []tf.Input{
			distances, seed,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Selects num_to_sample rows of input using the KMeans++ criterion.
//
// Rows of points are assumed to be input points. One row is selected at random.
// Subsequent rows are sampled with probability proportional to the squared L2
// distance from the nearest row selected thus far till num_to_sample rows have
// been sampled.
//
// Arguments:
//
//	points: Matrix of shape (n, d). Rows are assumed to be input points.
//	num_to_sample: Scalar. The number of rows to sample. This value must not be larger than n.
//	seed: Scalar. Seed for initializing the random number generator.
//	num_retries_per_sample: Scalar. For each row that is sampled, this parameter
//
// specifies the number of additional points to draw from the current
// distribution before selecting the best. If a negative value is specified, a
// heuristic is used to sample O(log(num_to_sample)) additional points.
//
// Returns Matrix of shape (num_to_sample, d). The sampled rows.
func KmeansPlusPlusInitialization(scope *Scope, points tf.Output, num_to_sample tf.Output, seed tf.Output, num_retries_per_sample tf.Output) (samples tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "KmeansPlusPlusInitialization",
		Input: []tf.Input{
			points, num_to_sample, seed, num_retries_per_sample,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the Kth order statistic of a data set. The current
//
// implementation uses a binary search requiring exactly 32 passes over
// the input data. The running time is linear with respect to input
// size. The median-of-medians algorithm is probably faster, but is
// difficult to implement efficiently in XLA. The implementation imposes
// a total ordering on floats. The ordering is consistent with the usual
// partial order.  Positive NaNs are greater than positive
// infinity. Negative NaNs are less than negative infinity. NaNs with
// distinct payloads are treated as distinct. Subnormal numbers are
// preserved (not flushed to zero). Positive infinity is greater than all
// numbers. Negative infinity is less than all numbers. Positive is
// greater than negative zero. There are less than k values greater than
// the kth order statistic. There are at least k values greater than or
// equal to the Kth order statistic. The semantics are not the same as
// top_k_unique.
func KthOrderStatistic(scope *Scope, input tf.Output, k int64) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"k": k}
	opspec := tf.OpSpec{
		Type: "KthOrderStatistic",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// L2 Loss.
//
// Computes half the L2 norm of a tensor without the `sqrt`:
//
//	output = sum(t ** 2) / 2
//
// Arguments:
//
//	t: Typically 2-D, but may have any dimensions.
//
// Returns 0-D.
func L2Loss(scope *Scope, t tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "L2Loss",
		Input: []tf.Input{
			t,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates a dataset that emits the key-value pairs in one or more LMDB files.
//
// The Lightning Memory-Mapped Database Manager, or LMDB, is an embedded binary
// key-value database. This dataset can read the contents of LMDB database files,
// the names of which generally have the `.mdb` suffix.
//
// Each output element consists of a key-value pair represented as a pair of
// scalar string `Tensor`s, where the first `Tensor` contains the key and the
// second `Tensor` contains the value.
//
// LMDB uses different file formats on big- and little-endian machines.
// `LMDBDataset` can only read files in the format of the host machine.
//
// Arguments:
//
//	filenames: A scalar or a vector containing the name(s) of the binary file(s) to be
//
// read.
func LMDBDataset(scope *Scope, filenames tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "LMDBDataset",
		Input: []tf.Input{
			filenames,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// LRNAttr is an optional argument to LRN.
type LRNAttr func(optionalAttr)

// LRNDepthRadius sets the optional depth_radius attribute to value.
//
// value: 0-D.  Half-width of the 1-D normalization window.
// If not specified, defaults to 5
func LRNDepthRadius(value int64) LRNAttr {
	return func(m optionalAttr) {
		m["depth_radius"] = value
	}
}

// LRNBias sets the optional bias attribute to value.
//
// value: An offset (usually positive to avoid dividing by 0).
// If not specified, defaults to 1
func LRNBias(value float32) LRNAttr {
	return func(m optionalAttr) {
		m["bias"] = value
	}
}

// LRNAlpha sets the optional alpha attribute to value.
//
// value: A scale factor, usually positive.
// If not specified, defaults to 1
func LRNAlpha(value float32) LRNAttr {
	return func(m optionalAttr) {
		m["alpha"] = value
	}
}

// LRNBeta sets the optional beta attribute to value.
//
// value: An exponent.
// If not specified, defaults to 0.5
func LRNBeta(value float32) LRNAttr {
	return func(m optionalAttr) {
		m["beta"] = value
	}
}

// Local Response Normalization.
//
// The 4-D `input` tensor is treated as a 3-D array of 1-D vectors (along the last
// dimension), and each vector is normalized independently.  Within a given vector,
// each component is divided by the weighted, squared sum of inputs within
// `depth_radius`.  In detail,
//
//	sqr_sum[a, b, c, d] =
//	    sum(input[a, b, c, d - depth_radius : d + depth_radius + 1] ** 2)
//	output = input / (bias + alpha * sqr_sum) ** beta
//
// For details, see [Krizhevsky et al., ImageNet classification with deep
// convolutional neural networks (NIPS 2012)](http://papers.nips.cc/paper/4824-imagenet-classification-with-deep-convolutional-neural-networks).
//
// Arguments:
//
//	input: 4-D.
func LRN(scope *Scope, input tf.Output, optional ...LRNAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LRN",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// LRNGradAttr is an optional argument to LRNGrad.
type LRNGradAttr func(optionalAttr)

// LRNGradDepthRadius sets the optional depth_radius attribute to value.
//
// value: A depth radius.
// If not specified, defaults to 5
func LRNGradDepthRadius(value int64) LRNGradAttr {
	return func(m optionalAttr) {
		m["depth_radius"] = value
	}
}

// LRNGradBias sets the optional bias attribute to value.
//
// value: An offset (usually > 0 to avoid dividing by 0).
// If not specified, defaults to 1
func LRNGradBias(value float32) LRNGradAttr {
	return func(m optionalAttr) {
		m["bias"] = value
	}
}

// LRNGradAlpha sets the optional alpha attribute to value.
//
// value: A scale factor, usually positive.
// If not specified, defaults to 1
func LRNGradAlpha(value float32) LRNGradAttr {
	return func(m optionalAttr) {
		m["alpha"] = value
	}
}

// LRNGradBeta sets the optional beta attribute to value.
//
// value: An exponent.
// If not specified, defaults to 0.5
func LRNGradBeta(value float32) LRNGradAttr {
	return func(m optionalAttr) {
		m["beta"] = value
	}
}

// Gradients for Local Response Normalization.
//
// Arguments:
//
//	input_grads: 4-D with shape `[batch, height, width, channels]`.
//	input_image: 4-D with shape `[batch, height, width, channels]`.
//	output_image: 4-D with shape `[batch, height, width, channels]`.
//
// Returns The gradients for LRN.
func LRNGrad(scope *Scope, input_grads tf.Output, input_image tf.Output, output_image tf.Output, optional ...LRNGradAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LRNGrad",
		Input: []tf.Input{
			input_grads, input_image, output_image,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// LSTMBlockCellAttr is an optional argument to LSTMBlockCell.
type LSTMBlockCellAttr func(optionalAttr)

// LSTMBlockCellForgetBias sets the optional forget_bias attribute to value.
//
// value: The forget gate bias.
// If not specified, defaults to 1
func LSTMBlockCellForgetBias(value float32) LSTMBlockCellAttr {
	return func(m optionalAttr) {
		m["forget_bias"] = value
	}
}

// LSTMBlockCellCellClip sets the optional cell_clip attribute to value.
//
// value: Value to clip the 'cs' value to.
// If not specified, defaults to 3
func LSTMBlockCellCellClip(value float32) LSTMBlockCellAttr {
	return func(m optionalAttr) {
		m["cell_clip"] = value
	}
}

// LSTMBlockCellUsePeephole sets the optional use_peephole attribute to value.
//
// value: Whether to use peephole weights.
// If not specified, defaults to false
func LSTMBlockCellUsePeephole(value bool) LSTMBlockCellAttr {
	return func(m optionalAttr) {
		m["use_peephole"] = value
	}
}

// Computes the LSTM cell forward propagation for 1 time step.
//
// This implementation uses 1 weight matrix and 1 bias vector, and there's an
// optional peephole connection.
//
// This kernel op implements the following mathematical equations:
//
// ```python
// xh = [x, h_prev]
// [i, f, ci, o] = xh * w + b
// f = f + forget_bias
//
// if not use_peephole:
//
//	wci = wcf = wco = 0
//
// i = sigmoid(cs_prev * wci + i)
// f = sigmoid(cs_prev * wcf + f)
// ci = tanh(ci)
//
// cs = ci .* i + cs_prev .* f
// cs = clip(cs, cell_clip)
//
// o = sigmoid(cs * wco + o)
// co = tanh(cs)
// h = co .* o
// ```
//
// Arguments:
//
//	x: The input to the LSTM cell, shape (batch_size, num_inputs).
//	cs_prev: Value of the cell state at previous time step.
//	h_prev: Output of the previous cell at previous time step.
//	w: The weight matrix.
//	wci: The weight matrix for input gate peephole connection.
//	wcf: The weight matrix for forget gate peephole connection.
//	wco: The weight matrix for output gate peephole connection.
//	b: The bias vector.
//
// Returns:
//
//	i: The input gate.
//	cs: The cell state before the tanh.
//	f: The forget gate.
//	o: The output gate.
//	ci: The cell input.
//	co: The cell after the tanh.
//	h: The output h vector.
func LSTMBlockCell(scope *Scope, x tf.Output, cs_prev tf.Output, h_prev tf.Output, w tf.Output, wci tf.Output, wcf tf.Output, wco tf.Output, b tf.Output, optional ...LSTMBlockCellAttr) (i tf.Output, cs tf.Output, f tf.Output, o tf.Output, ci tf.Output, co tf.Output, h tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LSTMBlockCell",
		Input: []tf.Input{
			x, cs_prev, h_prev, w, wci, wcf, wco, b,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3), op.Output(4), op.Output(5), op.Output(6)
}

// Computes the LSTM cell backward propagation for 1 timestep.
//
// This implementation is to be used in conjunction of LSTMBlockCell.
//
// Arguments:
//
//	x: The input to the LSTM cell, shape (batch_size, num_inputs).
//	cs_prev: The previous cell state.
//	h_prev: The previous h state.
//	w: The weight matrix.
//	wci: The weight matrix for input gate peephole connection.
//	wcf: The weight matrix for forget gate peephole connection.
//	wco: The weight matrix for output gate peephole connection.
//	b: The bias vector.
//	i: The input gate.
//	cs: The cell state before the tanh.
//	f: The forget gate.
//	o: The output gate.
//	ci: The cell input.
//	co: The cell after the tanh.
//	cs_grad: The current gradient of cs.
//	h_grad: The gradient of h vector.
//	use_peephole: Whether the cell uses peephole connections.
//
// Returns:
//
//	cs_prev_grad: The gradient of cs to be back-propped.
//	dicfo: The derivative wrt to [i, cs, f, o].
//	wci_grad: The gradient for wci to be back-propped.
//	wcf_grad: The gradient for wcf to be back-propped.
//	wco_grad: The gradient for wco to be back-propped.
func LSTMBlockCellGrad(scope *Scope, x tf.Output, cs_prev tf.Output, h_prev tf.Output, w tf.Output, wci tf.Output, wcf tf.Output, wco tf.Output, b tf.Output, i tf.Output, cs tf.Output, f tf.Output, o tf.Output, ci tf.Output, co tf.Output, cs_grad tf.Output, h_grad tf.Output, use_peephole bool) (cs_prev_grad tf.Output, dicfo tf.Output, wci_grad tf.Output, wcf_grad tf.Output, wco_grad tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"use_peephole": use_peephole}
	opspec := tf.OpSpec{
		Type: "LSTMBlockCellGrad",
		Input: []tf.Input{
			x, cs_prev, h_prev, w, wci, wcf, wco, b, i, cs, f, o, ci, co, cs_grad, h_grad,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3), op.Output(4)
}

// Records the latency of producing `input_dataset` elements in a StatsAggregator.
func LatencyStatsDataset(scope *Scope, input_dataset tf.Output, tag tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "LatencyStatsDataset",
		Input: []tf.Input{
			input_dataset, tag,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// LeakyReluAttr is an optional argument to LeakyRelu.
type LeakyReluAttr func(optionalAttr)

// LeakyReluAlpha sets the optional alpha attribute to value.
// If not specified, defaults to 0.2
func LeakyReluAlpha(value float32) LeakyReluAttr {
	return func(m optionalAttr) {
		m["alpha"] = value
	}
}

// Computes rectified linear: `max(features, features * alpha)`.
func LeakyRelu(scope *Scope, features tf.Output, optional ...LeakyReluAttr) (activations tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LeakyRelu",
		Input: []tf.Input{
			features,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// LeakyReluGradAttr is an optional argument to LeakyReluGrad.
type LeakyReluGradAttr func(optionalAttr)

// LeakyReluGradAlpha sets the optional alpha attribute to value.
// If not specified, defaults to 0.2
func LeakyReluGradAlpha(value float32) LeakyReluGradAttr {
	return func(m optionalAttr) {
		m["alpha"] = value
	}
}

// Computes rectified linear gradients for a LeakyRelu operation.
//
// Arguments:
//
//	gradients: The backpropagated gradients to the corresponding LeakyRelu operation.
//	features: The features passed as input to the corresponding LeakyRelu operation,
//
// OR the outputs of that operation (both work equivalently).
//
// Returns `gradients * (features > 0) + alpha * gradients * (features <= 0)`.
func LeakyReluGrad(scope *Scope, gradients tf.Output, features tf.Output, optional ...LeakyReluGradAttr) (backprops tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LeakyReluGrad",
		Input: []tf.Input{
			gradients, features,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// LearnedUnigramCandidateSamplerAttr is an optional argument to LearnedUnigramCandidateSampler.
type LearnedUnigramCandidateSamplerAttr func(optionalAttr)

// LearnedUnigramCandidateSamplerSeed sets the optional seed attribute to value.
//
// value: If either seed or seed2 are set to be non-zero, the random number
// generator is seeded by the given seed.  Otherwise, it is seeded by a
// random seed.
// If not specified, defaults to 0
func LearnedUnigramCandidateSamplerSeed(value int64) LearnedUnigramCandidateSamplerAttr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// LearnedUnigramCandidateSamplerSeed2 sets the optional seed2 attribute to value.
//
// value: An second seed to avoid seed collision.
// If not specified, defaults to 0
func LearnedUnigramCandidateSamplerSeed2(value int64) LearnedUnigramCandidateSamplerAttr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// Generates labels for candidate sampling with a learned unigram distribution.
//
// See explanations of candidate sampling and the data formats at
// go/candidate-sampling.
//
// For each batch, this op picks a single set of sampled candidate labels.
//
// The advantages of sampling candidates per-batch are simplicity and the
// possibility of efficient dense matrix multiplication. The disadvantage is that
// the sampled candidates must be chosen independently of the context and of the
// true labels.
//
// Arguments:
//
//	true_classes: A batch_size * num_true matrix, in which each row contains the
//
// IDs of the num_true target_classes in the corresponding original label.
//
//	num_true: Number of true labels per context.
//	num_sampled: Number of candidates to randomly sample.
//	unique: If unique is true, we sample with rejection, so that all sampled
//
// candidates in a batch are unique. This requires some approximation to
// estimate the post-rejection sampling probabilities.
//
//	range_max: The sampler will sample integers from the interval [0, range_max).
//
// Returns:
//
//	sampled_candidates: A vector of length num_sampled, in which each element is
//
// the ID of a sampled candidate.
//
//	true_expected_count: A batch_size * num_true matrix, representing
//
// the number of times each candidate is expected to occur in a batch
// of sampled candidates. If unique=true, then this is a probability.
//
//	sampled_expected_count: A vector of length num_sampled, for each sampled
//
// candidate representing the number of times the candidate is expected
// to occur in a batch of sampled candidates.  If unique=true, then this is a
// probability.
func LearnedUnigramCandidateSampler(scope *Scope, true_classes tf.Output, num_true int64, num_sampled int64, unique bool, range_max int64, optional ...LearnedUnigramCandidateSamplerAttr) (sampled_candidates tf.Output, true_expected_count tf.Output, sampled_expected_count tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_true": num_true, "num_sampled": num_sampled, "unique": unique, "range_max": range_max}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LearnedUnigramCandidateSampler",
		Input: []tf.Input{
			true_classes,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// Elementwise computes the bitwise left-shift of `x` and `y`.
//
// If `y` is negative, or greater than or equal to the width of `x` in bits the
// result is implementation defined.
//
// Example:
//
// ```python
// import tensorflow as tf
// from tensorflow.python.ops import bitwise_ops
// import numpy as np
// dtype_list = [tf.int8, tf.int16, tf.int32, tf.int64]
//
// for dtype in dtype_list:
//
//	lhs = tf.constant([-1, -5, -3, -14], dtype=dtype)
//	rhs = tf.constant([5, 0, 7, 11], dtype=dtype)
//
//	left_shift_result = bitwise_ops.left_shift(lhs, rhs)
//
//	print(left_shift_result)
//
// # This will print:
// # tf.Tensor([ -32   -5 -128    0], shape=(4,), dtype=int8)
// # tf.Tensor([   -32     -5   -384 -28672], shape=(4,), dtype=int16)
// # tf.Tensor([   -32     -5   -384 -28672], shape=(4,), dtype=int32)
// # tf.Tensor([   -32     -5   -384 -28672], shape=(4,), dtype=int64)
//
// lhs = np.array([-2, 64, 101, 32], dtype=np.int8)
// rhs = np.array([-1, -5, -3, -14], dtype=np.int8)
// bitwise_ops.left_shift(lhs, rhs)
// # <tf.Tensor: shape=(4,), dtype=int8, numpy=array([ -2,  64, 101,  32], dtype=int8)>
// ```
func LeftShift(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "LeftShift",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the truth value of (x < y) element-wise.
//
// *NOTE*: `Less` supports broadcasting. More about broadcasting
// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
//
// Example:
//
// ```python
// x = tf.constant([5, 4, 6])
// y = tf.constant([5])
// tf.math.less(x, y) ==> [False, True, False]
//
// x = tf.constant([5, 4, 6])
// y = tf.constant([5, 6, 7])
// tf.math.less(x, y) ==> [False, True, True]
// ```
func Less(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Less",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the truth value of (x <= y) element-wise.
//
// *NOTE*: `LessEqual` supports broadcasting. More about broadcasting
// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
//
// Example:
//
// ```python
// x = tf.constant([5, 4, 6])
// y = tf.constant([5])
// tf.math.less_equal(x, y) ==> [True, True, False]
//
// x = tf.constant([5, 4, 6])
// y = tf.constant([5, 6, 6])
// tf.math.less_equal(x, y) ==> [True, True, True]
// ```
func LessEqual(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "LessEqual",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the log of the absolute value of `Gamma(x)` element-wise.
//
//	For positive numbers, this function computes log((input - 1)!) for every element in the tensor.
//	`lgamma(5) = log((5-1)!) = log(4!) = log(24) = 3.1780539`
//
// Example:
//
// ```python
// x = tf.constant([0, 0.5, 1, 4.5, -4, -5.6])
// tf.math.lgamma(x) ==> [inf, 0.5723649, 0., 2.4537368, inf, -4.6477685]
// ```
func Lgamma(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Lgamma",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Generates values in an interval.
//
// A sequence of `num` evenly-spaced values are generated beginning at `start`.
// If `num > 1`, the values in the sequence increase by
// `(stop - start) / (num - 1)`, so that the last one is exactly `stop`.
//
// For example:
//
// ```
// tf.linspace(10.0, 12.0, 3, name="linspace") => [ 10.0  11.0  12.0]
// ```
//
// Arguments:
//
//	start: 0-D tensor. First entry in the range.
//	stop: 0-D tensor. Last entry in the range.
//	num: 0-D tensor. Number of values to generate.
//
// Returns 1-D. The generated values.
func LinSpace(scope *Scope, start tf.Output, stop tf.Output, num tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "LinSpace",
		Input: []tf.Input{
			start, stop, num,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ListDatasetAttr is an optional argument to ListDataset.
type ListDatasetAttr func(optionalAttr)

// ListDatasetMetadata sets the optional metadata attribute to value.
// If not specified, defaults to ""
func ListDatasetMetadata(value string) ListDatasetAttr {
	return func(m optionalAttr) {
		m["metadata"] = value
	}
}

// Creates a dataset that emits each of `tensors` once.
func ListDataset(scope *Scope, tensors []tf.Output, output_types []tf.DataType, output_shapes []tf.Shape, optional ...ListDatasetAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ListDataset",
		Input: []tf.Input{
			tf.OutputList(tensors),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ListDiffAttr is an optional argument to ListDiff.
type ListDiffAttr func(optionalAttr)

// ListDiffOutIdx sets the optional out_idx attribute to value.
// If not specified, defaults to DT_INT32
func ListDiffOutIdx(value tf.DataType) ListDiffAttr {
	return func(m optionalAttr) {
		m["out_idx"] = value
	}
}

// Computes the difference between two lists of numbers or strings.
//
// Given a list `x` and a list `y`, this operation returns a list `out` that
// represents all values that are in `x` but not in `y`. The returned list `out`
// is sorted in the same order that the numbers appear in `x` (duplicates are
// preserved). This operation also returns a list `idx` that represents the
// position of each `out` element in `x`. In other words:
//
// `out[i] = x[idx[i]] for i in [0, 1, ..., len(out) - 1]`
//
// For example, given this input:
//
// ```
// x = [1, 2, 3, 4, 5, 6]
// y = [1, 3, 5]
// ```
//
// This operation would return:
//
// ```
// out ==> [2, 4, 6]
// idx ==> [1, 3, 5]
// ```
//
// Arguments:
//
//	x: 1-D. Values to keep.
//	y: 1-D. Values to remove.
//
// Returns:
//
//	out: 1-D. Values present in `x` but not in `y`.
//	idx: 1-D. Positions of `x` values preserved in `out`.
func ListDiff(scope *Scope, x tf.Output, y tf.Output, optional ...ListDiffAttr) (out tf.Output, idx tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ListDiff",
		Input: []tf.Input{
			x, y,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// An op that loads optimization parameters into embedding memory.
//
// An op that loads optimization parameters into embedding memory. Must be
// preceded by a ConfigureTPUEmbeddingHost op that sets up the correct embedding
// table configuration. For example, this op is used to install parameters that are
// loaded from a checkpoint before a training loop is executed.  For Adagrad,
// auxiliary1 should be the accumulators. For SGD, all of the auxiliary* values
// should be empty. For FTRL, auxiliary1 should be the accumulators and auxiliary2
// should be the linear terms. For ADAM, auxiliary1 should be the momenta and
// auxiliary2 should be the velocities.
//
// Arguments:
//
//	parameters: A list of tensors, one for each embedding table,
//
// containing the initial embedding table parameters to use in embedding
// lookups.
//
//	auxiliary1: A list of tensors, one for each embedding table, containing the
//
// initial values of the first auxiliary optimization parameter to use in embedding
// training loop updates. The shape of each entry is ignored (and thus can be
// empty) for those tables whose optimization algorithms do not have at least one
// auxiliary parameter.
//
//	auxiliary2: A list of tensors, one for each embedding table, containing the
//
// initial values of the second auxiliary optimization parameter to use in
// embedding training loop updates. The shape of each entry is ignored (and thus
// can be empty) for those tables whose optimization algorithms do not have at
// least two auxiliary
//
//	auxiliary3: A list of tensors, one for each embedding table, containing the
//
// initial values of the third auxiliary optimization parameter to use in embedding
// training loop updates. The shape of each entry is ignored (and thus can be
// empty) for those tables whose optimization algorithms do not have three
// auxiliary parameters.
//
//	auxiliary4: A list of tensors, one for each embedding table, containing the
//
// initial values of the second auxiliary optimization parameter to use in
// embedding training loop updates. The shape of each entry is ignored (and thus
// can be empty) for those tables whose optimization algorithms do not have at
// least four auxiliary
//
//	auxiliary5: A list of tensors, one for each embedding table, containing the
//
// initial values of the third auxiliary optimization parameter to use in embedding
// training loop updates. The shape of each entry is ignored (and thus can be
// empty) for those tables whose optimization algorithms do not have five
// auxiliary parameters.
//
//	auxiliary6: A list of tensors, one for each embedding table, containing the
//
// initial values of the second auxiliary optimization parameter to use in
// embedding training loop updates. The shape of each entry is ignored (and thus
// can be empty) for those tables whose optimization algorithms do not have at
// least six auxiliary
//
//	auxiliary7: A list of tensors, one for each embedding table, containing the
//
// initial values of the third auxiliary optimization parameter to use in embedding
// training loop updates. The shape of each entry is ignored (and thus can be
// empty) for those tables whose optimization algorithms do not have sevan
// auxiliary parameters.
//
//	config: An TPUEmbeddingConfiguration proto describing the
//
// table parameters being loaded, serialized to a string.
//
//	num_shards: Number of shards into which the embedding tables are divided.
//	shard_id: Identifier of shard for this operation.
//
// Returns the created operation.
func LoadAllTPUEmbeddingParameters(scope *Scope, parameters []tf.Output, auxiliary1 []tf.Output, auxiliary2 []tf.Output, auxiliary3 []tf.Output, auxiliary4 []tf.Output, auxiliary5 []tf.Output, auxiliary6 []tf.Output, auxiliary7 []tf.Output, config string, num_shards int64, shard_id int64) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"config": config, "num_shards": num_shards, "shard_id": shard_id}
	opspec := tf.OpSpec{
		Type: "LoadAllTPUEmbeddingParameters",
		Input: []tf.Input{
			tf.OutputList(parameters), tf.OutputList(auxiliary1), tf.OutputList(auxiliary2), tf.OutputList(auxiliary3), tf.OutputList(auxiliary4), tf.OutputList(auxiliary5), tf.OutputList(auxiliary6), tf.OutputList(auxiliary7),
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// LoadAndRemapMatrixAttr is an optional argument to LoadAndRemapMatrix.
type LoadAndRemapMatrixAttr func(optionalAttr)

// LoadAndRemapMatrixMaxRowsInMemory sets the optional max_rows_in_memory attribute to value.
//
// value: The maximum number of rows to load from the checkpoint at
// once. If less than or equal to 0, the entire matrix will be loaded into
// memory. Setting this arg trades increased disk reads for lower memory usage.
// If not specified, defaults to -1
func LoadAndRemapMatrixMaxRowsInMemory(value int64) LoadAndRemapMatrixAttr {
	return func(m optionalAttr) {
		m["max_rows_in_memory"] = value
	}
}

// Loads a 2-D (matrix) `Tensor` with name `old_tensor_name` from the checkpoint
//
// at `ckpt_path` and potentially reorders its rows and columns using the
// specified remappings.
//
// Most users should use one of the wrapper initializers (such as
// `tf.contrib.framework.load_and_remap_matrix_initializer`) instead of this
// function directly.
//
// The remappings are 1-D tensors with the following properties:
//
//   - `row_remapping` must have exactly `num_rows` entries. Row `i` of the output
//     matrix will be initialized from the row corresponding to index
//     `row_remapping[i]` in the old `Tensor` from the checkpoint.
//   - `col_remapping` must have either 0 entries (indicating that no column
//     reordering is needed) or `num_cols` entries. If specified, column `j` of the
//     output matrix will be initialized from the column corresponding to index
//     `col_remapping[j]` in the old `Tensor` from the checkpoint.
//   - A value of -1 in either of the remappings signifies a "missing" entry. In that
//     case, values from the `initializing_values` tensor will be used to fill that
//     missing row or column. If `row_remapping` has `r` missing entries and
//     `col_remapping` has `c` missing entries, then the following condition must be
//     true:
//
// `(r * num_cols) + (c * num_rows) - (r * c) == len(initializing_values)`
//
// The remapping tensors can be generated using the GenerateVocabRemapping op.
//
// As an example, with row_remapping = [1, 0, -1], col_remapping = [0, 2, -1],
// initializing_values = [0.5, -0.5, 0.25, -0.25, 42], and w(i, j) representing
// the value from row i, column j of the old tensor in the checkpoint, the output
// matrix will look like the following:
//
// [[w(1, 0),  w(1, 2),  0.5],
//
//	[w(0, 0),  w(0, 2), -0.5],
//	[0.25,    -0.25,      42]]
//
// Arguments:
//
//	ckpt_path: Path to the TensorFlow checkpoint (version 2, `TensorBundle`) from
//
// which the old matrix `Tensor` will be loaded.
//
//	old_tensor_name: Name of the 2-D `Tensor` to load from checkpoint.
//	row_remapping: An int `Tensor` of row remappings (generally created by
//
// `generate_vocab_remapping`).  Even if no row remapping is needed, this must
// still be an index-valued Tensor (e.g. [0, 1, 2, ...]), or a shifted
// index-valued `Tensor` (e.g. [8, 9, 10, ...], for partitioned `Variables`).
//
//	col_remapping: An int `Tensor` of column remappings (generally created by
//
// `generate_vocab_remapping`).  May be a size-0 `Tensor` if only row remapping
// is to be done (e.g. column ordering is the same).
//
//	initializing_values: A float `Tensor` containing  values to fill in for cells
//
// in the output matrix that are not loaded from the checkpoint. Length must be
// exactly the same as the number of missing / new cells.
//
//	num_rows: Number of rows (length of the 1st dimension) in the output matrix.
//	num_cols: Number of columns (length of the 2nd dimension) in the output matrix.
//
// Returns Output matrix containing existing values loaded from the
// checkpoint, and with any missing values filled in from initializing_values.
func LoadAndRemapMatrix(scope *Scope, ckpt_path tf.Output, old_tensor_name tf.Output, row_remapping tf.Output, col_remapping tf.Output, initializing_values tf.Output, num_rows int64, num_cols int64, optional ...LoadAndRemapMatrixAttr) (output_matrix tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_rows": num_rows, "num_cols": num_cols}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LoadAndRemapMatrix",
		Input: []tf.Input{
			ckpt_path, old_tensor_name, row_remapping, col_remapping, initializing_values,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// LoadTPUEmbeddingADAMParametersAttr is an optional argument to LoadTPUEmbeddingADAMParameters.
type LoadTPUEmbeddingADAMParametersAttr func(optionalAttr)

// LoadTPUEmbeddingADAMParametersTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
func LoadTPUEmbeddingADAMParametersTableId(value int64) LoadTPUEmbeddingADAMParametersAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// LoadTPUEmbeddingADAMParametersTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingADAMParametersTableName(value string) LoadTPUEmbeddingADAMParametersAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// LoadTPUEmbeddingADAMParametersConfig sets the optional config attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingADAMParametersConfig(value string) LoadTPUEmbeddingADAMParametersAttr {
	return func(m optionalAttr) {
		m["config"] = value
	}
}

// Load ADAM embedding parameters.
//
// An op that loads optimization parameters into HBM for embedding. Must be
// preceded by a ConfigureTPUEmbeddingHost op that sets up the correct
// embedding table configuration. For example, this op is used to install
// parameters that are loaded from a checkpoint before a training loop is
// executed.
//
// Arguments:
//
//	parameters: Value of parameters used in the ADAM optimization algorithm.
//	momenta: Value of momenta used in the ADAM optimization algorithm.
//	velocities: Value of velocities used in the ADAM optimization algorithm.
//
// Returns the created operation.
func LoadTPUEmbeddingADAMParameters(scope *Scope, parameters tf.Output, momenta tf.Output, velocities tf.Output, num_shards int64, shard_id int64, optional ...LoadTPUEmbeddingADAMParametersAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LoadTPUEmbeddingADAMParameters",
		Input: []tf.Input{
			parameters, momenta, velocities,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// LoadTPUEmbeddingAdadeltaParametersAttr is an optional argument to LoadTPUEmbeddingAdadeltaParameters.
type LoadTPUEmbeddingAdadeltaParametersAttr func(optionalAttr)

// LoadTPUEmbeddingAdadeltaParametersTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
func LoadTPUEmbeddingAdadeltaParametersTableId(value int64) LoadTPUEmbeddingAdadeltaParametersAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// LoadTPUEmbeddingAdadeltaParametersTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingAdadeltaParametersTableName(value string) LoadTPUEmbeddingAdadeltaParametersAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// LoadTPUEmbeddingAdadeltaParametersConfig sets the optional config attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingAdadeltaParametersConfig(value string) LoadTPUEmbeddingAdadeltaParametersAttr {
	return func(m optionalAttr) {
		m["config"] = value
	}
}

// Load Adadelta embedding parameters.
//
// An op that loads optimization parameters into HBM for embedding. Must be
// preceded by a ConfigureTPUEmbeddingHost op that sets up the correct
// embedding table configuration. For example, this op is used to install
// parameters that are loaded from a checkpoint before a training loop is
// executed.
//
// Arguments:
//
//	parameters: Value of parameters used in the Adadelta optimization algorithm.
//	accumulators: Value of accumulators used in the Adadelta optimization algorithm.
//	updates: Value of updates used in the Adadelta optimization algorithm.
//
// Returns the created operation.
func LoadTPUEmbeddingAdadeltaParameters(scope *Scope, parameters tf.Output, accumulators tf.Output, updates tf.Output, num_shards int64, shard_id int64, optional ...LoadTPUEmbeddingAdadeltaParametersAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LoadTPUEmbeddingAdadeltaParameters",
		Input: []tf.Input{
			parameters, accumulators, updates,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// LoadTPUEmbeddingAdagradMomentumParametersAttr is an optional argument to LoadTPUEmbeddingAdagradMomentumParameters.
type LoadTPUEmbeddingAdagradMomentumParametersAttr func(optionalAttr)

// LoadTPUEmbeddingAdagradMomentumParametersTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
func LoadTPUEmbeddingAdagradMomentumParametersTableId(value int64) LoadTPUEmbeddingAdagradMomentumParametersAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// LoadTPUEmbeddingAdagradMomentumParametersTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingAdagradMomentumParametersTableName(value string) LoadTPUEmbeddingAdagradMomentumParametersAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// LoadTPUEmbeddingAdagradMomentumParametersConfig sets the optional config attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingAdagradMomentumParametersConfig(value string) LoadTPUEmbeddingAdagradMomentumParametersAttr {
	return func(m optionalAttr) {
		m["config"] = value
	}
}

// Load Adagrad Momentum embedding parameters.
//
// An op that loads optimization parameters into HBM for embedding. Must be
// preceded by a ConfigureTPUEmbeddingHost op that sets up the correct
// embedding table configuration. For example, this op is used to install
// parameters that are loaded from a checkpoint before a training loop is
// executed.
//
// Arguments:
//
//	parameters: Value of parameters used in the Adagrad Momentum optimization algorithm.
//	accumulators: Value of accumulators used in the Adagrad Momentum optimization algorithm.
//	momenta: Value of momenta used in the Adagrad Momentum optimization algorithm.
//
// Returns the created operation.
func LoadTPUEmbeddingAdagradMomentumParameters(scope *Scope, parameters tf.Output, accumulators tf.Output, momenta tf.Output, num_shards int64, shard_id int64, optional ...LoadTPUEmbeddingAdagradMomentumParametersAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LoadTPUEmbeddingAdagradMomentumParameters",
		Input: []tf.Input{
			parameters, accumulators, momenta,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// LoadTPUEmbeddingAdagradParametersAttr is an optional argument to LoadTPUEmbeddingAdagradParameters.
type LoadTPUEmbeddingAdagradParametersAttr func(optionalAttr)

// LoadTPUEmbeddingAdagradParametersTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
func LoadTPUEmbeddingAdagradParametersTableId(value int64) LoadTPUEmbeddingAdagradParametersAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// LoadTPUEmbeddingAdagradParametersTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingAdagradParametersTableName(value string) LoadTPUEmbeddingAdagradParametersAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// LoadTPUEmbeddingAdagradParametersConfig sets the optional config attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingAdagradParametersConfig(value string) LoadTPUEmbeddingAdagradParametersAttr {
	return func(m optionalAttr) {
		m["config"] = value
	}
}

// Load Adagrad embedding parameters.
//
// An op that loads optimization parameters into HBM for embedding. Must be
// preceded by a ConfigureTPUEmbeddingHost op that sets up the correct
// embedding table configuration. For example, this op is used to install
// parameters that are loaded from a checkpoint before a training loop is
// executed.
//
// Arguments:
//
//	parameters: Value of parameters used in the Adagrad optimization algorithm.
//	accumulators: Value of accumulators used in the Adagrad optimization algorithm.
//
// Returns the created operation.
func LoadTPUEmbeddingAdagradParameters(scope *Scope, parameters tf.Output, accumulators tf.Output, num_shards int64, shard_id int64, optional ...LoadTPUEmbeddingAdagradParametersAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LoadTPUEmbeddingAdagradParameters",
		Input: []tf.Input{
			parameters, accumulators,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// LoadTPUEmbeddingCenteredRMSPropParametersAttr is an optional argument to LoadTPUEmbeddingCenteredRMSPropParameters.
type LoadTPUEmbeddingCenteredRMSPropParametersAttr func(optionalAttr)

// LoadTPUEmbeddingCenteredRMSPropParametersTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
func LoadTPUEmbeddingCenteredRMSPropParametersTableId(value int64) LoadTPUEmbeddingCenteredRMSPropParametersAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// LoadTPUEmbeddingCenteredRMSPropParametersTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingCenteredRMSPropParametersTableName(value string) LoadTPUEmbeddingCenteredRMSPropParametersAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// LoadTPUEmbeddingCenteredRMSPropParametersConfig sets the optional config attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingCenteredRMSPropParametersConfig(value string) LoadTPUEmbeddingCenteredRMSPropParametersAttr {
	return func(m optionalAttr) {
		m["config"] = value
	}
}

// Load centered RMSProp embedding parameters.
//
// An op that loads optimization parameters into HBM for embedding. Must be
// preceded by a ConfigureTPUEmbeddingHost op that sets up the correct
// embedding table configuration. For example, this op is used to install
// parameters that are loaded from a checkpoint before a training loop is
// executed.
//
// Arguments:
//
//	parameters: Value of parameters used in the centered RMSProp optimization algorithm.
//	ms: Value of ms used in the centered RMSProp optimization algorithm.
//	mom: Value of mom used in the centered RMSProp optimization algorithm.
//	mg: Value of mg used in the centered RMSProp optimization algorithm.
//
// Returns the created operation.
func LoadTPUEmbeddingCenteredRMSPropParameters(scope *Scope, parameters tf.Output, ms tf.Output, mom tf.Output, mg tf.Output, num_shards int64, shard_id int64, optional ...LoadTPUEmbeddingCenteredRMSPropParametersAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LoadTPUEmbeddingCenteredRMSPropParameters",
		Input: []tf.Input{
			parameters, ms, mom, mg,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// LoadTPUEmbeddingFTRLParametersAttr is an optional argument to LoadTPUEmbeddingFTRLParameters.
type LoadTPUEmbeddingFTRLParametersAttr func(optionalAttr)

// LoadTPUEmbeddingFTRLParametersTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
func LoadTPUEmbeddingFTRLParametersTableId(value int64) LoadTPUEmbeddingFTRLParametersAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// LoadTPUEmbeddingFTRLParametersTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingFTRLParametersTableName(value string) LoadTPUEmbeddingFTRLParametersAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// LoadTPUEmbeddingFTRLParametersConfig sets the optional config attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingFTRLParametersConfig(value string) LoadTPUEmbeddingFTRLParametersAttr {
	return func(m optionalAttr) {
		m["config"] = value
	}
}

// Load FTRL embedding parameters.
//
// An op that loads optimization parameters into HBM for embedding. Must be
// preceded by a ConfigureTPUEmbeddingHost op that sets up the correct
// embedding table configuration. For example, this op is used to install
// parameters that are loaded from a checkpoint before a training loop is
// executed.
//
// Arguments:
//
//	parameters: Value of parameters used in the FTRL optimization algorithm.
//	accumulators: Value of accumulators used in the FTRL optimization algorithm.
//	linears: Value of linears used in the FTRL optimization algorithm.
//
// Returns the created operation.
func LoadTPUEmbeddingFTRLParameters(scope *Scope, parameters tf.Output, accumulators tf.Output, linears tf.Output, num_shards int64, shard_id int64, optional ...LoadTPUEmbeddingFTRLParametersAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LoadTPUEmbeddingFTRLParameters",
		Input: []tf.Input{
			parameters, accumulators, linears,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// LoadTPUEmbeddingFrequencyEstimatorParametersAttr is an optional argument to LoadTPUEmbeddingFrequencyEstimatorParameters.
type LoadTPUEmbeddingFrequencyEstimatorParametersAttr func(optionalAttr)

// LoadTPUEmbeddingFrequencyEstimatorParametersTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
func LoadTPUEmbeddingFrequencyEstimatorParametersTableId(value int64) LoadTPUEmbeddingFrequencyEstimatorParametersAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// LoadTPUEmbeddingFrequencyEstimatorParametersTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingFrequencyEstimatorParametersTableName(value string) LoadTPUEmbeddingFrequencyEstimatorParametersAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// LoadTPUEmbeddingFrequencyEstimatorParametersConfig sets the optional config attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingFrequencyEstimatorParametersConfig(value string) LoadTPUEmbeddingFrequencyEstimatorParametersAttr {
	return func(m optionalAttr) {
		m["config"] = value
	}
}

// Load frequency estimator embedding parameters.
//
// An op that loads optimization parameters into HBM for embedding. Must be
// preceded by a ConfigureTPUEmbeddingHost op that sets up the correct
// embedding table configuration. For example, this op is used to install
// parameters that are loaded from a checkpoint before a training loop is
// executed.
//
// Arguments:
//
//	parameters: Value of parameters used in the frequency estimator optimization algorithm.
//	last_hit_step: Value of last_hit_step used in the frequency estimator optimization algorithm.
//
// Returns the created operation.
func LoadTPUEmbeddingFrequencyEstimatorParameters(scope *Scope, parameters tf.Output, last_hit_step tf.Output, num_shards int64, shard_id int64, optional ...LoadTPUEmbeddingFrequencyEstimatorParametersAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LoadTPUEmbeddingFrequencyEstimatorParameters",
		Input: []tf.Input{
			parameters, last_hit_step,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// LoadTPUEmbeddingMDLAdagradLightParametersAttr is an optional argument to LoadTPUEmbeddingMDLAdagradLightParameters.
type LoadTPUEmbeddingMDLAdagradLightParametersAttr func(optionalAttr)

// LoadTPUEmbeddingMDLAdagradLightParametersTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
func LoadTPUEmbeddingMDLAdagradLightParametersTableId(value int64) LoadTPUEmbeddingMDLAdagradLightParametersAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// LoadTPUEmbeddingMDLAdagradLightParametersTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingMDLAdagradLightParametersTableName(value string) LoadTPUEmbeddingMDLAdagradLightParametersAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// LoadTPUEmbeddingMDLAdagradLightParametersConfig sets the optional config attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingMDLAdagradLightParametersConfig(value string) LoadTPUEmbeddingMDLAdagradLightParametersAttr {
	return func(m optionalAttr) {
		m["config"] = value
	}
}

// Load MDL Adagrad Light embedding parameters.
//
// An op that loads optimization parameters into HBM for embedding. Must be
// preceded by a ConfigureTPUEmbeddingHost op that sets up the correct
// embedding table configuration. For example, this op is used to install
// parameters that are loaded from a checkpoint before a training loop is
// executed.
//
// Arguments:
//
//	parameters: Value of parameters used in the MDL Adagrad Light optimization algorithm.
//	accumulators: Value of accumulators used in the MDL Adagrad Light optimization algorithm.
//	weights: Value of weights used in the MDL Adagrad Light optimization algorithm.
//	benefits: Value of benefits used in the MDL Adagrad Light optimization algorithm.
//
// Returns the created operation.
func LoadTPUEmbeddingMDLAdagradLightParameters(scope *Scope, parameters tf.Output, accumulators tf.Output, weights tf.Output, benefits tf.Output, num_shards int64, shard_id int64, optional ...LoadTPUEmbeddingMDLAdagradLightParametersAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LoadTPUEmbeddingMDLAdagradLightParameters",
		Input: []tf.Input{
			parameters, accumulators, weights, benefits,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// LoadTPUEmbeddingMomentumParametersAttr is an optional argument to LoadTPUEmbeddingMomentumParameters.
type LoadTPUEmbeddingMomentumParametersAttr func(optionalAttr)

// LoadTPUEmbeddingMomentumParametersTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
func LoadTPUEmbeddingMomentumParametersTableId(value int64) LoadTPUEmbeddingMomentumParametersAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// LoadTPUEmbeddingMomentumParametersTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingMomentumParametersTableName(value string) LoadTPUEmbeddingMomentumParametersAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// LoadTPUEmbeddingMomentumParametersConfig sets the optional config attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingMomentumParametersConfig(value string) LoadTPUEmbeddingMomentumParametersAttr {
	return func(m optionalAttr) {
		m["config"] = value
	}
}

// Load Momentum embedding parameters.
//
// An op that loads optimization parameters into HBM for embedding. Must be
// preceded by a ConfigureTPUEmbeddingHost op that sets up the correct
// embedding table configuration. For example, this op is used to install
// parameters that are loaded from a checkpoint before a training loop is
// executed.
//
// Arguments:
//
//	parameters: Value of parameters used in the Momentum optimization algorithm.
//	momenta: Value of momenta used in the Momentum optimization algorithm.
//
// Returns the created operation.
func LoadTPUEmbeddingMomentumParameters(scope *Scope, parameters tf.Output, momenta tf.Output, num_shards int64, shard_id int64, optional ...LoadTPUEmbeddingMomentumParametersAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LoadTPUEmbeddingMomentumParameters",
		Input: []tf.Input{
			parameters, momenta,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// LoadTPUEmbeddingProximalAdagradParametersAttr is an optional argument to LoadTPUEmbeddingProximalAdagradParameters.
type LoadTPUEmbeddingProximalAdagradParametersAttr func(optionalAttr)

// LoadTPUEmbeddingProximalAdagradParametersTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
func LoadTPUEmbeddingProximalAdagradParametersTableId(value int64) LoadTPUEmbeddingProximalAdagradParametersAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// LoadTPUEmbeddingProximalAdagradParametersTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingProximalAdagradParametersTableName(value string) LoadTPUEmbeddingProximalAdagradParametersAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// LoadTPUEmbeddingProximalAdagradParametersConfig sets the optional config attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingProximalAdagradParametersConfig(value string) LoadTPUEmbeddingProximalAdagradParametersAttr {
	return func(m optionalAttr) {
		m["config"] = value
	}
}

// Load proximal Adagrad embedding parameters.
//
// An op that loads optimization parameters into HBM for embedding. Must be
// preceded by a ConfigureTPUEmbeddingHost op that sets up the correct
// embedding table configuration. For example, this op is used to install
// parameters that are loaded from a checkpoint before a training loop is
// executed.
//
// Arguments:
//
//	parameters: Value of parameters used in the proximal Adagrad optimization algorithm.
//	accumulators: Value of accumulators used in the proximal Adagrad optimization algorithm.
//
// Returns the created operation.
func LoadTPUEmbeddingProximalAdagradParameters(scope *Scope, parameters tf.Output, accumulators tf.Output, num_shards int64, shard_id int64, optional ...LoadTPUEmbeddingProximalAdagradParametersAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LoadTPUEmbeddingProximalAdagradParameters",
		Input: []tf.Input{
			parameters, accumulators,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// LoadTPUEmbeddingRMSPropParametersAttr is an optional argument to LoadTPUEmbeddingRMSPropParameters.
type LoadTPUEmbeddingRMSPropParametersAttr func(optionalAttr)

// LoadTPUEmbeddingRMSPropParametersTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
func LoadTPUEmbeddingRMSPropParametersTableId(value int64) LoadTPUEmbeddingRMSPropParametersAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// LoadTPUEmbeddingRMSPropParametersTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingRMSPropParametersTableName(value string) LoadTPUEmbeddingRMSPropParametersAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// LoadTPUEmbeddingRMSPropParametersConfig sets the optional config attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingRMSPropParametersConfig(value string) LoadTPUEmbeddingRMSPropParametersAttr {
	return func(m optionalAttr) {
		m["config"] = value
	}
}

// Load RMSProp embedding parameters.
//
// An op that loads optimization parameters into HBM for embedding. Must be
// preceded by a ConfigureTPUEmbeddingHost op that sets up the correct
// embedding table configuration. For example, this op is used to install
// parameters that are loaded from a checkpoint before a training loop is
// executed.
//
// Arguments:
//
//	parameters: Value of parameters used in the RMSProp optimization algorithm.
//	ms: Value of ms used in the RMSProp optimization algorithm.
//	mom: Value of mom used in the RMSProp optimization algorithm.
//
// Returns the created operation.
func LoadTPUEmbeddingRMSPropParameters(scope *Scope, parameters tf.Output, ms tf.Output, mom tf.Output, num_shards int64, shard_id int64, optional ...LoadTPUEmbeddingRMSPropParametersAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LoadTPUEmbeddingRMSPropParameters",
		Input: []tf.Input{
			parameters, ms, mom,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// LoadTPUEmbeddingStochasticGradientDescentParametersAttr is an optional argument to LoadTPUEmbeddingStochasticGradientDescentParameters.
type LoadTPUEmbeddingStochasticGradientDescentParametersAttr func(optionalAttr)

// LoadTPUEmbeddingStochasticGradientDescentParametersTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
func LoadTPUEmbeddingStochasticGradientDescentParametersTableId(value int64) LoadTPUEmbeddingStochasticGradientDescentParametersAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// LoadTPUEmbeddingStochasticGradientDescentParametersTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingStochasticGradientDescentParametersTableName(value string) LoadTPUEmbeddingStochasticGradientDescentParametersAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// LoadTPUEmbeddingStochasticGradientDescentParametersConfig sets the optional config attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingStochasticGradientDescentParametersConfig(value string) LoadTPUEmbeddingStochasticGradientDescentParametersAttr {
	return func(m optionalAttr) {
		m["config"] = value
	}
}

// Load SGD embedding parameters.
//
// An op that loads optimization parameters into HBM for embedding. Must be
// preceded by a ConfigureTPUEmbeddingHost op that sets up the correct
// embedding table configuration. For example, this op is used to install
// parameters that are loaded from a checkpoint before a training loop is
// executed.
//
// Arguments:
//
//	parameters: Value of parameters used in the stochastic gradient descent optimization algorithm.
//
// Returns the created operation.
func LoadTPUEmbeddingStochasticGradientDescentParameters(scope *Scope, parameters tf.Output, num_shards int64, shard_id int64, optional ...LoadTPUEmbeddingStochasticGradientDescentParametersAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LoadTPUEmbeddingStochasticGradientDescentParameters",
		Input: []tf.Input{
			parameters,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// Computes natural logarithm of x element-wise.
//
// I.e., \\(y = \log_e x\\).
//
// Example:
//
// ```python
// x = tf.constant([0, 0.5, 1, 5])
// tf.math.log(x) ==> [-inf, -0.6931472,  0. ,  1.609438]
// ```
func Log(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Log",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes natural logarithm of (1 + x) element-wise.
//
// I.e., \\(y = \log_e (1 + x)\\).
//
// Example:
//
// ```python
// x = tf.constant([0, 0.5, 1, 5])
// tf.math.log1p(x) ==> [0., 0.4054651, 0.6931472, 1.7917595]
// ```
func Log1p(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Log1p",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the sign and the log of the absolute value of the determinant of
//
// one or more square matrices.
//
// The input is a tensor of shape `[N, M, M]` whose inner-most 2 dimensions
// form square matrices. The outputs are two tensors containing the signs and
// absolute values of the log determinants for all N input submatrices
// `[..., :, :]` such that `determinant = sign*exp(log_abs_determinant)`.
// The `log_abs_determinant` is computed as `det(P)*sum(log(diag(LU)))` where `LU`
// is the `LU` decomposition of the input and `P` is the corresponding
// permutation matrix.
//
// Arguments:
//
//	input: Shape is `[N, M, M]`.
//
// Returns:
//
//	sign: The signs of the log determinants of the inputs. Shape is `[N]`.
//	log_abs_determinant: The logs of the absolute values of the determinants
//
// of the N input matrices.  Shape is `[N]`.
func LogMatrixDeterminant(scope *Scope, input tf.Output) (sign tf.Output, log_abs_determinant tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "LogMatrixDeterminant",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Computes log softmax activations.
//
// For each batch `i` and class `j` we have
//
//	logsoftmax[i, j] = logits[i, j] - log(sum(exp(logits[i])))
//
// Arguments:
//
//	logits: 2-D with shape `[batch_size, num_classes]`.
//
// Returns Same shape as `logits`.
func LogSoftmax(scope *Scope, logits tf.Output) (logsoftmax tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "LogSoftmax",
		Input: []tf.Input{
			logits,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// LogUniformCandidateSamplerAttr is an optional argument to LogUniformCandidateSampler.
type LogUniformCandidateSamplerAttr func(optionalAttr)

// LogUniformCandidateSamplerSeed sets the optional seed attribute to value.
//
// value: If either seed or seed2 are set to be non-zero, the random number
// generator is seeded by the given seed.  Otherwise, it is seeded by a
// random seed.
// If not specified, defaults to 0
func LogUniformCandidateSamplerSeed(value int64) LogUniformCandidateSamplerAttr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// LogUniformCandidateSamplerSeed2 sets the optional seed2 attribute to value.
//
// value: An second seed to avoid seed collision.
// If not specified, defaults to 0
func LogUniformCandidateSamplerSeed2(value int64) LogUniformCandidateSamplerAttr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// Generates labels for candidate sampling with a log-uniform distribution.
//
// See explanations of candidate sampling and the data formats at
// go/candidate-sampling.
//
// For each batch, this op picks a single set of sampled candidate labels.
//
// The advantages of sampling candidates per-batch are simplicity and the
// possibility of efficient dense matrix multiplication. The disadvantage is that
// the sampled candidates must be chosen independently of the context and of the
// true labels.
//
// Arguments:
//
//	true_classes: A batch_size * num_true matrix, in which each row contains the
//
// IDs of the num_true target_classes in the corresponding original label.
//
//	num_true: Number of true labels per context.
//	num_sampled: Number of candidates to randomly sample.
//	unique: If unique is true, we sample with rejection, so that all sampled
//
// candidates in a batch are unique. This requires some approximation to
// estimate the post-rejection sampling probabilities.
//
//	range_max: The sampler will sample integers from the interval [0, range_max).
//
// Returns:
//
//	sampled_candidates: A vector of length num_sampled, in which each element is
//
// the ID of a sampled candidate.
//
//	true_expected_count: A batch_size * num_true matrix, representing
//
// the number of times each candidate is expected to occur in a batch
// of sampled candidates. If unique=true, then this is a probability.
//
//	sampled_expected_count: A vector of length num_sampled, for each sampled
//
// candidate representing the number of times the candidate is expected
// to occur in a batch of sampled candidates.  If unique=true, then this is a
// probability.
func LogUniformCandidateSampler(scope *Scope, true_classes tf.Output, num_true int64, num_sampled int64, unique bool, range_max int64, optional ...LogUniformCandidateSamplerAttr) (sampled_candidates tf.Output, true_expected_count tf.Output, sampled_expected_count tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_true": num_true, "num_sampled": num_sampled, "unique": unique, "range_max": range_max}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LogUniformCandidateSampler",
		Input: []tf.Input{
			true_classes,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// Returns the truth value of x AND y element-wise.
//
// *NOTE*: `LogicalAnd` supports broadcasting. More about broadcasting
// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
func LogicalAnd(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "LogicalAnd",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the truth value of `NOT x` element-wise.
//
// Arguments:
//
//	x: A `Tensor` of type `bool`.
//
// Returns A `Tensor` of type `bool` with the same shape as `x`. The logical negation of `x`.
func LogicalNot(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "LogicalNot",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the truth value of x OR y element-wise.
//
// *NOTE*: `LogicalOr` supports broadcasting. More about broadcasting
// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
func LogicalOr(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "LogicalOr",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Outputs all keys and values in the table.
//
// Arguments:
//
//	table_handle: Handle to the table.
//
// Returns:
//
//	keys: Vector of all keys present in the table.
//	values: Tensor of all values in the table. Indexed in parallel with `keys`.
func LookupTableExportV2(scope *Scope, table_handle tf.Output, Tkeys tf.DataType, Tvalues tf.DataType) (keys tf.Output, values tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"Tkeys": Tkeys, "Tvalues": Tvalues}
	opspec := tf.OpSpec{
		Type: "LookupTableExportV2",
		Input: []tf.Input{
			table_handle,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Looks up keys in a table, outputs the corresponding values.
//
// The tensor `keys` must of the same type as the keys of the table.
// The output `values` is of the type of the table values.
//
// The scalar `default_value` is the value output for keys not present in the
// table. It must also be of the same type as the table values.
//
// Arguments:
//
//	table_handle: Handle to the table.
//	keys: Any shape.  Keys to look up.
//
// Returns Same shape as `keys`.  Values found in the table, or `default_values`
// for missing keys.
func LookupTableFindV2(scope *Scope, table_handle tf.Output, keys tf.Output, default_value tf.Output) (values tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "LookupTableFindV2",
		Input: []tf.Input{
			table_handle, keys, default_value,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Replaces the contents of the table with the specified keys and values.
//
// The tensor `keys` must be of the same type as the keys of the table.
// The tensor `values` must be of the type of the table values.
//
// Arguments:
//
//	table_handle: Handle to the table.
//	keys: Any shape.  Keys to look up.
//	values: Values to associate with keys.
//
// Returns the created operation.
func LookupTableImportV2(scope *Scope, table_handle tf.Output, keys tf.Output, values tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "LookupTableImportV2",
		Input: []tf.Input{
			table_handle, keys, values,
		},
	}
	return scope.AddOperation(opspec)
}

// Updates the table to associates keys with values.
//
// The tensor `keys` must be of the same type as the keys of the table.
// The tensor `values` must be of the type of the table values.
//
// Arguments:
//
//	table_handle: Handle to the table.
//	keys: Any shape.  Keys to look up.
//	values: Values to associate with keys.
//
// Returns the created operation.
func LookupTableInsertV2(scope *Scope, table_handle tf.Output, keys tf.Output, values tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "LookupTableInsertV2",
		Input: []tf.Input{
			table_handle, keys, values,
		},
	}
	return scope.AddOperation(opspec)
}

// Removes keys and its associated values from a table.
//
// The tensor `keys` must of the same type as the keys of the table. Keys not
// already in the table are silently ignored.
//
// Arguments:
//
//	table_handle: Handle to the table.
//	keys: Any shape.  Keys of the elements to remove.
//
// Returns the created operation.
func LookupTableRemoveV2(scope *Scope, table_handle tf.Output, keys tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "LookupTableRemoveV2",
		Input: []tf.Input{
			table_handle, keys,
		},
	}
	return scope.AddOperation(opspec)
}

// Computes the number of elements in the given table.
//
// Arguments:
//
//	table_handle: Handle to the table.
//
// Returns Scalar that contains number of elements in the table.
func LookupTableSizeV2(scope *Scope, table_handle tf.Output) (size tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "LookupTableSizeV2",
		Input: []tf.Input{
			table_handle,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Forwards the input to the output.
//
// This operator represents the loop termination condition used by the
// "pivot" switches of a loop.
//
// Arguments:
//
//	input: A boolean scalar, representing the branch predicate of the Switch op.
//
// Returns The same tensor as `input`.
func LoopCond(scope *Scope, input tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "LoopCond",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// LowerBoundAttr is an optional argument to LowerBound.
type LowerBoundAttr func(optionalAttr)

// LowerBoundOutType sets the optional out_type attribute to value.
// If not specified, defaults to DT_INT32
func LowerBoundOutType(value tf.DataType) LowerBoundAttr {
	return func(m optionalAttr) {
		m["out_type"] = value
	}
}

// Applies lower_bound(sorted_search_values, values) along each row.
//
// Each set of rows with the same index in (sorted_inputs, values) is treated
// independently.  The resulting row is the equivalent of calling
// `np.searchsorted(sorted_inputs, values, side='left')`.
//
// The result is not a global index to the entire
// `Tensor`, but rather just the index in the last dimension.
//
// A 2-D example:
//
//	sorted_sequence = [[0, 3, 9, 9, 10],
//	                   [1, 2, 3, 4, 5]]
//	values = [[2, 4, 9],
//	          [0, 2, 6]]
//
//	result = LowerBound(sorted_sequence, values)
//
//	result == [[1, 2, 2],
//	           [0, 1, 5]]
//
// Arguments:
//
//	sorted_inputs: 2-D Tensor where each row is ordered.
//	values: 2-D Tensor with the same numbers of rows as `sorted_search_values`. Contains
//
// the values that will be searched for in `sorted_search_values`.
//
// Returns A `Tensor` with the same shape as `values`.  It contains the first scalar index
// into the last dimension where values can be inserted without changing the
// ordered property.
func LowerBound(scope *Scope, sorted_inputs tf.Output, values tf.Output, optional ...LowerBoundAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LowerBound",
		Input: []tf.Input{
			sorted_inputs, values,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// LuAttr is an optional argument to Lu.
type LuAttr func(optionalAttr)

// LuOutputIdxType sets the optional output_idx_type attribute to value.
// If not specified, defaults to DT_INT32
func LuOutputIdxType(value tf.DataType) LuAttr {
	return func(m optionalAttr) {
		m["output_idx_type"] = value
	}
}

// Computes the LU decomposition of one or more square matrices.
//
// The input is a tensor of shape `[..., M, M]` whose inner-most 2 dimensions
// form square matrices.
//
// The input has to be invertible.
//
// The output consists of two tensors LU and P containing the LU decomposition
// of all input submatrices `[..., :, :]`. LU encodes the lower triangular and
// upper triangular factors.
//
// For each input submatrix of shape `[M, M]`, L is a lower triangular matrix of
// shape `[M, M]` with unit diagonal whose entries correspond to the strictly lower
// triangular part of LU. U is a upper triangular matrix of shape `[M, M]` whose
// entries correspond to the upper triangular part, including the diagonal, of LU.
//
// P represents a permutation matrix encoded as a list of indices each between `0`
// and `M-1`, inclusive. If P_mat denotes the permutation matrix corresponding to
// P, then the L, U and P satisfies P_mat * input = L * U.
//
// Arguments:
//
//	input: A tensor of shape `[..., M, M]` whose inner-most 2 dimensions form matrices of
//
// size `[M, M]`.
//
// Returns:
//
//	lu: A tensor of shape `[..., M, M]` whose strictly lower triangular part denotes the
//
// lower triangular factor `L` with unit diagonal, and whose upper triangular part
// denotes the upper triangular factor `U`.
//
//	p: Permutation of the rows encoded as a list of indices in `0..M-1`. Shape is
//
// `[..., M]`.
// @compatibility(scipy)
// Similar to `scipy.linalg.lu`, except the triangular factors `L` and `U` are
// packed into a single tensor, the permutation is applied to `input` instead of
// the right hand side and the permutation `P` is returned as a list of indices
// instead of a permutation matrix.
// @end_compatibility
func Lu(scope *Scope, input tf.Output, optional ...LuAttr) (lu tf.Output, p tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Lu",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Makes a new iterator from the given `dataset` and stores it in `iterator`.
//
// This operation may be executed multiple times. Each execution will reset the
// iterator in `iterator` to the first element of `dataset`.
//
// Returns the created operation.
func MakeIterator(scope *Scope, dataset tf.Output, iterator tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "MakeIterator",
		Input: []tf.Input{
			dataset, iterator,
		},
	}
	return scope.AddOperation(opspec)
}

// Make all elements in the non-Batch dimension unique, but \"close\" to
//
// their initial value. Never returns a sub-normal number. Never returns
// zero. The sign of each input element is always identical to the sign
// of the corresponding output element. Behavior for infinite elements is
// undefined. Behavior for subnormal elements is undefined.
func MakeUnique(scope *Scope, input tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "MakeUnique",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MapClearAttr is an optional argument to MapClear.
type MapClearAttr func(optionalAttr)

// MapClearCapacity sets the optional capacity attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func MapClearCapacity(value int64) MapClearAttr {
	return func(m optionalAttr) {
		m["capacity"] = value
	}
}

// MapClearMemoryLimit sets the optional memory_limit attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func MapClearMemoryLimit(value int64) MapClearAttr {
	return func(m optionalAttr) {
		m["memory_limit"] = value
	}
}

// MapClearContainer sets the optional container attribute to value.
// If not specified, defaults to ""
func MapClearContainer(value string) MapClearAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// MapClearSharedName sets the optional shared_name attribute to value.
// If not specified, defaults to ""
func MapClearSharedName(value string) MapClearAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Op removes all elements in the underlying container.
//
// Returns the created operation.
func MapClear(scope *Scope, dtypes []tf.DataType, optional ...MapClearAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtypes": dtypes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MapClear",

		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// MapIncompleteSizeAttr is an optional argument to MapIncompleteSize.
type MapIncompleteSizeAttr func(optionalAttr)

// MapIncompleteSizeCapacity sets the optional capacity attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func MapIncompleteSizeCapacity(value int64) MapIncompleteSizeAttr {
	return func(m optionalAttr) {
		m["capacity"] = value
	}
}

// MapIncompleteSizeMemoryLimit sets the optional memory_limit attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func MapIncompleteSizeMemoryLimit(value int64) MapIncompleteSizeAttr {
	return func(m optionalAttr) {
		m["memory_limit"] = value
	}
}

// MapIncompleteSizeContainer sets the optional container attribute to value.
// If not specified, defaults to ""
func MapIncompleteSizeContainer(value string) MapIncompleteSizeAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// MapIncompleteSizeSharedName sets the optional shared_name attribute to value.
// If not specified, defaults to ""
func MapIncompleteSizeSharedName(value string) MapIncompleteSizeAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Op returns the number of incomplete elements in the underlying container.
func MapIncompleteSize(scope *Scope, dtypes []tf.DataType, optional ...MapIncompleteSizeAttr) (size tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtypes": dtypes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MapIncompleteSize",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MapPeekAttr is an optional argument to MapPeek.
type MapPeekAttr func(optionalAttr)

// MapPeekCapacity sets the optional capacity attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func MapPeekCapacity(value int64) MapPeekAttr {
	return func(m optionalAttr) {
		m["capacity"] = value
	}
}

// MapPeekMemoryLimit sets the optional memory_limit attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func MapPeekMemoryLimit(value int64) MapPeekAttr {
	return func(m optionalAttr) {
		m["memory_limit"] = value
	}
}

// MapPeekContainer sets the optional container attribute to value.
// If not specified, defaults to ""
func MapPeekContainer(value string) MapPeekAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// MapPeekSharedName sets the optional shared_name attribute to value.
// If not specified, defaults to ""
func MapPeekSharedName(value string) MapPeekAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Op peeks at the values at the specified key.  If the
//
// underlying container does not contain this key
// this op will block until it does.
func MapPeek(scope *Scope, key tf.Output, indices tf.Output, dtypes []tf.DataType, optional ...MapPeekAttr) (values []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtypes": dtypes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MapPeek",
		Input: []tf.Input{
			key, indices,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if values, idx, err = makeOutputList(op, idx, "values"); err != nil {
		scope.UpdateErr("MapPeek", err)
		return
	}
	return values
}

// MapSizeAttr is an optional argument to MapSize.
type MapSizeAttr func(optionalAttr)

// MapSizeCapacity sets the optional capacity attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func MapSizeCapacity(value int64) MapSizeAttr {
	return func(m optionalAttr) {
		m["capacity"] = value
	}
}

// MapSizeMemoryLimit sets the optional memory_limit attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func MapSizeMemoryLimit(value int64) MapSizeAttr {
	return func(m optionalAttr) {
		m["memory_limit"] = value
	}
}

// MapSizeContainer sets the optional container attribute to value.
// If not specified, defaults to ""
func MapSizeContainer(value string) MapSizeAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// MapSizeSharedName sets the optional shared_name attribute to value.
// If not specified, defaults to ""
func MapSizeSharedName(value string) MapSizeAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Op returns the number of elements in the underlying container.
func MapSize(scope *Scope, dtypes []tf.DataType, optional ...MapSizeAttr) (size tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtypes": dtypes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MapSize",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MapStageAttr is an optional argument to MapStage.
type MapStageAttr func(optionalAttr)

// MapStageCapacity sets the optional capacity attribute to value.
//
// value: Maximum number of elements in the Staging Area. If > 0, inserts
// on the container will block when the capacity is reached.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func MapStageCapacity(value int64) MapStageAttr {
	return func(m optionalAttr) {
		m["capacity"] = value
	}
}

// MapStageMemoryLimit sets the optional memory_limit attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func MapStageMemoryLimit(value int64) MapStageAttr {
	return func(m optionalAttr) {
		m["memory_limit"] = value
	}
}

// MapStageContainer sets the optional container attribute to value.
//
// value: If non-empty, this queue is placed in the given container. Otherwise,
// a default container is used.
// If not specified, defaults to ""
func MapStageContainer(value string) MapStageAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// MapStageSharedName sets the optional shared_name attribute to value.
//
// value: It is necessary to match this name to the matching Unstage Op.
// If not specified, defaults to ""
func MapStageSharedName(value string) MapStageAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Stage (key, values) in the underlying container which behaves like a hashtable.
//
// Arguments:
//
//	key: int64
//
//	values: a list of tensors
//
// dtypes A list of data types that inserted values should adhere to.
//
// Returns the created operation.
func MapStage(scope *Scope, key tf.Output, indices tf.Output, values []tf.Output, dtypes []tf.DataType, optional ...MapStageAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtypes": dtypes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MapStage",
		Input: []tf.Input{
			key, indices, tf.OutputList(values),
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// MapUnstageAttr is an optional argument to MapUnstage.
type MapUnstageAttr func(optionalAttr)

// MapUnstageCapacity sets the optional capacity attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func MapUnstageCapacity(value int64) MapUnstageAttr {
	return func(m optionalAttr) {
		m["capacity"] = value
	}
}

// MapUnstageMemoryLimit sets the optional memory_limit attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func MapUnstageMemoryLimit(value int64) MapUnstageAttr {
	return func(m optionalAttr) {
		m["memory_limit"] = value
	}
}

// MapUnstageContainer sets the optional container attribute to value.
// If not specified, defaults to ""
func MapUnstageContainer(value string) MapUnstageAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// MapUnstageSharedName sets the optional shared_name attribute to value.
// If not specified, defaults to ""
func MapUnstageSharedName(value string) MapUnstageAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Op removes and returns the values associated with the key
//
// from the underlying container.   If the underlying container
// does not contain this key, the op will block until it does.
func MapUnstage(scope *Scope, key tf.Output, indices tf.Output, dtypes []tf.DataType, optional ...MapUnstageAttr) (values []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtypes": dtypes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MapUnstage",
		Input: []tf.Input{
			key, indices,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if values, idx, err = makeOutputList(op, idx, "values"); err != nil {
		scope.UpdateErr("MapUnstage", err)
		return
	}
	return values
}

// MapUnstageNoKeyAttr is an optional argument to MapUnstageNoKey.
type MapUnstageNoKeyAttr func(optionalAttr)

// MapUnstageNoKeyCapacity sets the optional capacity attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func MapUnstageNoKeyCapacity(value int64) MapUnstageNoKeyAttr {
	return func(m optionalAttr) {
		m["capacity"] = value
	}
}

// MapUnstageNoKeyMemoryLimit sets the optional memory_limit attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func MapUnstageNoKeyMemoryLimit(value int64) MapUnstageNoKeyAttr {
	return func(m optionalAttr) {
		m["memory_limit"] = value
	}
}

// MapUnstageNoKeyContainer sets the optional container attribute to value.
// If not specified, defaults to ""
func MapUnstageNoKeyContainer(value string) MapUnstageNoKeyAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// MapUnstageNoKeySharedName sets the optional shared_name attribute to value.
// If not specified, defaults to ""
func MapUnstageNoKeySharedName(value string) MapUnstageNoKeyAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Op removes and returns a random (key, value)
//
// from the underlying container.   If the underlying container
// does not contain elements, the op will block until it does.
func MapUnstageNoKey(scope *Scope, indices tf.Output, dtypes []tf.DataType, optional ...MapUnstageNoKeyAttr) (key tf.Output, values []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtypes": dtypes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MapUnstageNoKey",
		Input: []tf.Input{
			indices,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	key = op.Output(idx)
	if values, idx, err = makeOutputList(op, idx, "values"); err != nil {
		scope.UpdateErr("MapUnstageNoKey", err)
		return
	}
	return key, values
}

// MatMulAttr is an optional argument to MatMul.
type MatMulAttr func(optionalAttr)

// MatMulTransposeA sets the optional transpose_a attribute to value.
//
// value: If true, "a" is transposed before multiplication.
// If not specified, defaults to false
func MatMulTransposeA(value bool) MatMulAttr {
	return func(m optionalAttr) {
		m["transpose_a"] = value
	}
}

// MatMulTransposeB sets the optional transpose_b attribute to value.
//
// value: If true, "b" is transposed before multiplication.
// If not specified, defaults to false
func MatMulTransposeB(value bool) MatMulAttr {
	return func(m optionalAttr) {
		m["transpose_b"] = value
	}
}

// MatMulGradA sets the optional grad_a attribute to value.
// If not specified, defaults to false
func MatMulGradA(value bool) MatMulAttr {
	return func(m optionalAttr) {
		m["grad_a"] = value
	}
}

// MatMulGradB sets the optional grad_b attribute to value.
// If not specified, defaults to false
func MatMulGradB(value bool) MatMulAttr {
	return func(m optionalAttr) {
		m["grad_b"] = value
	}
}

// Multiply the matrix "a" by the matrix "b".
//
// The inputs must be two-dimensional matrices and the inner dimension of
// "a" (after being transposed if transpose_a is true) must match the
// outer dimension of "b" (after being transposed if transposed_b is
// true).
//
// *Note*: The default kernel implementation for MatMul on GPUs uses
// cublas.
func MatMul(scope *Scope, a tf.Output, b tf.Output, optional ...MatMulAttr) (product tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MatMul",
		Input: []tf.Input{
			a, b,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the set of files matching one or more glob patterns.
//
// Note that this routine only supports wildcard characters in the
// basename portion of the pattern, not in the directory portion.
// Note also that the order of filenames returned is deterministic.
//
// Arguments:
//
//	pattern: Shell wildcard pattern(s). Scalar or vector of type string.
//
// Returns A vector of matching filenames.
func MatchingFiles(scope *Scope, pattern tf.Output) (filenames tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "MatchingFiles",
		Input: []tf.Input{
			pattern,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Copy a tensor setting everything outside a central band in each innermost matrix to zero.
//
// The `band` part is computed as follows:
// Assume `input` has `k` dimensions `[I, J, K, ..., M, N]`, then the output is a
// tensor with the same shape where
//
// `band[i, j, k, ..., m, n] = in_band(m, n) * input[i, j, k, ..., m, n]`.
//
// # The indicator function
//
// `in_band(m, n) = (num_lower < 0 || (m-n) <= num_lower)) &&
//
//	(num_upper < 0 || (n-m) <= num_upper)`.
//
// For example:
//
// ```
// # if 'input' is [[ 0,  1,  2, 3]
// #                [-1,  0,  1, 2]
// #                [-2, -1,  0, 1]
// #                [-3, -2, -1, 0]],
//
// tf.linalg.band_part(input, 1, -1) ==> [[ 0,  1,  2, 3]
//
//	[-1,  0,  1, 2]
//	[ 0, -1,  0, 1]
//	[ 0,  0, -1, 0]],
//
// tf.linalg.band_part(input, 2, 1) ==> [[ 0,  1,  0, 0]
//
//	[-1,  0,  1, 0]
//	[-2, -1,  0, 1]
//	[ 0, -2, -1, 0]]
//
// ```
//
// Useful special cases:
//
// ```
//
//	tf.linalg.band_part(input, 0, -1) ==> Upper triangular part.
//	tf.linalg.band_part(input, -1, 0) ==> Lower triangular part.
//	tf.linalg.band_part(input, 0, 0) ==> Diagonal.
//
// ```
//
// Arguments:
//
//	input: Rank `k` tensor.
//	num_lower: 0-D tensor. Number of subdiagonals to keep. If negative, keep entire
//
// lower triangle.
//
//	num_upper: 0-D tensor. Number of superdiagonals to keep. If negative, keep
//
// entire upper triangle.
//
// Returns Rank `k` tensor of the same shape as input. The extracted banded tensor.
func MatrixBandPart(scope *Scope, input tf.Output, num_lower tf.Output, num_upper tf.Output) (band tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "MatrixBandPart",
		Input: []tf.Input{
			input, num_lower, num_upper,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the determinant of one or more square matrices.
//
// The input is a tensor of shape `[..., M, M]` whose inner-most 2 dimensions
// form square matrices. The output is a tensor containing the determinants
// for all input submatrices `[..., :, :]`.
//
// Arguments:
//
//	input: Shape is `[..., M, M]`.
//
// Returns Shape is `[...]`.
func MatrixDeterminant(scope *Scope, input tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "MatrixDeterminant",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns a batched diagonal tensor with a given batched diagonal values.
//
// Given a `diagonal`, this operation returns a tensor with the `diagonal` and
// everything else padded with zeros. The diagonal is computed as follows:
//
// Assume `diagonal` has `k` dimensions `[I, J, K, ..., N]`, then the output is a
// tensor of rank `k+1` with dimensions [I, J, K, ..., N, N]` where:
//
// `output[i, j, k, ..., m, n] = 1{m=n} * diagonal[i, j, k, ..., n]`.
//
// For example:
//
// ```
// # 'diagonal' is [[1, 2, 3, 4], [5, 6, 7, 8]]
//
// and diagonal.shape = (2, 4)
//
// tf.matrix_diag(diagonal) ==> [[[1, 0, 0, 0]
//
//	 [0, 2, 0, 0]
//	 [0, 0, 3, 0]
//	 [0, 0, 0, 4]],
//	[[5, 0, 0, 0]
//	 [0, 6, 0, 0]
//	 [0, 0, 7, 0]
//	 [0, 0, 0, 8]]]
//
// which has shape (2, 4, 4)
// ```
//
// Arguments:
//
//	diagonal: Rank `k`, where `k >= 1`.
//
// Returns Rank `k+1`, with `output.shape = diagonal.shape + [diagonal.shape[-1]]`.
func MatrixDiag(scope *Scope, diagonal tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "MatrixDiag",
		Input: []tf.Input{
			diagonal,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the batched diagonal part of a batched tensor.
//
// This operation returns a tensor with the `diagonal` part
// of the batched `input`. The `diagonal` part is computed as follows:
//
// Assume `input` has `k` dimensions `[I, J, K, ..., M, N]`, then the output is a
// tensor of rank `k - 1` with dimensions `[I, J, K, ..., min(M, N)]` where:
//
// `diagonal[i, j, k, ..., n] = input[i, j, k, ..., n, n]`.
//
// The input must be at least a matrix.
//
// For example:
//
// ```
// # 'input' is [[[1, 0, 0, 0]
//
//	 [0, 2, 0, 0]
//	 [0, 0, 3, 0]
//	 [0, 0, 0, 4]],
//	[[5, 0, 0, 0]
//	 [0, 6, 0, 0]
//	 [0, 0, 7, 0]
//	 [0, 0, 0, 8]]]
//
// and input.shape = (2, 4, 4)
//
// tf.matrix_diag_part(input) ==> [[1, 2, 3, 4], [5, 6, 7, 8]]
//
// which has shape (2, 4)
// ```
//
// Arguments:
//
//	input: Rank `k` tensor where `k >= 2`.
//
// Returns The extracted diagonal(s) having shape
// `diagonal.shape = input.shape[:-2] + [min(input.shape[-2:])]`.
func MatrixDiagPart(scope *Scope, input tf.Output) (diagonal tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "MatrixDiagPart",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the batched diagonal part of a batched tensor.
//
// Returns a tensor with the `k[0]`-th to `k[1]`-th diagonals of the batched
// `input`.
//
// Assume `input` has `r` dimensions `[I, J, ..., L, M, N]`.
// Let `max_diag_len` be the maximum length among all diagonals to be extracted,
// `max_diag_len = min(M + min(k[1], 0), N + min(-k[0], 0))`
// Let `num_diags` be the number of diagonals to extract,
// `num_diags = k[1] - k[0] + 1`.
//
// If `num_diags == 1`, the output tensor is of rank `r - 1` with shape
// `[I, J, ..., L, max_diag_len]` and values:
//
// ```
// diagonal[i, j, ..., l, n]
//
//	= input[i, j, ..., l, n+y, n+x] ; if 0 <= n+y < M and 0 <= n+x < N,
//	  padding_value                 ; otherwise.
//
// ```
// where `y = max(-k[1], 0)`, `x = max(k[1], 0)`.
//
// Otherwise, the output tensor has rank `r` with dimensions
// `[I, J, ..., L, num_diags, max_diag_len]` with values:
//
// ```
// diagonal[i, j, ..., l, m, n]
//
//	= input[i, j, ..., l, n+y, n+x] ; if 0 <= n+y < M and 0 <= n+x < N,
//	  padding_value                 ; otherwise.
//
// ```
// where `d = k[1] - m`, `y = max(-d, 0)`, and `x = max(d, 0)`.
//
// The input must be at least a matrix.
//
// For example:
//
// ```
// input = np.array([[[1, 2, 3, 4],  # Input shape: (2, 3, 4)
//
//	 [5, 6, 7, 8],
//	 [9, 8, 7, 6]],
//	[[5, 4, 3, 2],
//	 [1, 2, 3, 4],
//	 [5, 6, 7, 8]]])
//
// # A main diagonal from each batch.
// tf.matrix_diag_part(input) ==> [[1, 6, 7],  # Output shape: (2, 3)
//
//	[5, 2, 7]]
//
// # A superdiagonal from each batch.
// tf.matrix_diag_part(input, k = 1)
//
//	==> [[2, 7, 6],  # Output shape: (2, 3)
//	     [4, 3, 8]]
//
// # A tridiagonal band from each batch.
// tf.matrix_diag_part(input, k = (-1, 1))
//
//	==> [[[2, 7, 6],  # Output shape: (2, 3, 3)
//	      [1, 6, 7],
//	      [5, 8, 0]],
//	     [[4, 3, 8],
//	      [5, 2, 7],
//	      [1, 6, 0]]]
//
// # Padding value = 9
// tf.matrix_diag_part(input, k = (1, 3), padding_value = 9)
//
//	==> [[[4, 9, 9],  # Output shape: (2, 3, 3)
//	      [3, 8, 9],
//	      [2, 7, 6]],
//	     [[2, 9, 9],
//	      [3, 4, 9],
//	      [4, 3, 8]]]
//
// ```
//
// Arguments:
//
//	input: Rank `r` tensor where `r >= 2`.
//	k: Diagonal offset(s). Positive value means superdiagonal, 0 refers to the main
//
// diagonal, and negative value means subdiagonals. `k` can be a single integer
// (for a single diagonal) or a pair of integers specifying the low and high ends
// of a matrix band. `k[0]` must not be larger than `k[1]`.
//
//	padding_value: The value to fill the area outside the specified diagonal band with.
//
// Default is 0.
//
// Returns The extracted diagonal(s).
func MatrixDiagPartV2(scope *Scope, input tf.Output, k tf.Output, padding_value tf.Output) (diagonal tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "MatrixDiagPartV2",
		Input: []tf.Input{
			input, k, padding_value,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MatrixDiagPartV3Attr is an optional argument to MatrixDiagPartV3.
type MatrixDiagPartV3Attr func(optionalAttr)

// MatrixDiagPartV3Align sets the optional align attribute to value.
//
// value: Some diagonals are shorter than `max_diag_len` and need to be padded. `align` is
// a string specifying how superdiagonals and subdiagonals should be aligned,
// respectively. There are four possible alignments: "RIGHT_LEFT" (default),
// "LEFT_RIGHT", "LEFT_LEFT", and "RIGHT_RIGHT". "RIGHT_LEFT" aligns superdiagonals
// to the right (left-pads the row) and subdiagonals to the left (right-pads the
// row). It is the packing format LAPACK uses. cuSPARSE uses "LEFT_RIGHT", which is
// the opposite alignment.
// If not specified, defaults to "RIGHT_LEFT"
func MatrixDiagPartV3Align(value string) MatrixDiagPartV3Attr {
	return func(m optionalAttr) {
		m["align"] = value
	}
}

// Returns the batched diagonal part of a batched tensor.
//
// Returns a tensor with the `k[0]`-th to `k[1]`-th diagonals of the batched
// `input`.
//
// Assume `input` has `r` dimensions `[I, J, ..., L, M, N]`.
// Let `max_diag_len` be the maximum length among all diagonals to be extracted,
// `max_diag_len = min(M + min(k[1], 0), N + min(-k[0], 0))`
// Let `num_diags` be the number of diagonals to extract,
// `num_diags = k[1] - k[0] + 1`.
//
// If `num_diags == 1`, the output tensor is of rank `r - 1` with shape
// `[I, J, ..., L, max_diag_len]` and values:
//
// ```
// diagonal[i, j, ..., l, n]
//
//	= input[i, j, ..., l, n+y, n+x] ; if 0 <= n+y < M and 0 <= n+x < N,
//	  padding_value                 ; otherwise.
//
// ```
// where `y = max(-k[1], 0)`, `x = max(k[1], 0)`.
//
// Otherwise, the output tensor has rank `r` with dimensions
// `[I, J, ..., L, num_diags, max_diag_len]` with values:
//
// ```
// diagonal[i, j, ..., l, m, n]
//
//	= input[i, j, ..., l, n+y, n+x] ; if 0 <= n+y < M and 0 <= n+x < N,
//	  padding_value                 ; otherwise.
//
// ```
// where `d = k[1] - m`, `y = max(-d, 0) - offset`, and `x = max(d, 0) - offset`.
//
// `offset` is zero except when the alignment of the diagonal is to the right.
// ```
// offset = max_diag_len - diag_len(d) ; if (`align` in {RIGHT_LEFT, RIGHT_RIGHT}
//
//	                                  and `d >= 0`) or
//	                                (`align` in {LEFT_RIGHT, RIGHT_RIGHT}
//	                                  and `d <= 0`)
//	0                          ; otherwise
//
// ```
// where `diag_len(d) = min(cols - max(d, 0), rows + min(d, 0))`.
//
// The input must be at least a matrix.
//
// For example:
//
// ```
// input = np.array([[[1, 2, 3, 4],  # Input shape: (2, 3, 4)
//
//	 [5, 6, 7, 8],
//	 [9, 8, 7, 6]],
//	[[5, 4, 3, 2],
//	 [1, 2, 3, 4],
//	 [5, 6, 7, 8]]])
//
// # A main diagonal from each batch.
// tf.matrix_diag_part(input) ==> [[1, 6, 7],  # Output shape: (2, 3)
//
//	[5, 2, 7]]
//
// # A superdiagonal from each batch.
// tf.matrix_diag_part(input, k = 1)
//
//	==> [[2, 7, 6],  # Output shape: (2, 3)
//	     [4, 3, 8]]
//
// # A band from each batch.
// tf.matrix_diag_part(input, k = (-1, 2))
//
//	==> [[[0, 3, 8],  # Output shape: (2, 4, 3)
//	      [2, 7, 6],
//	      [1, 6, 7],
//	      [5, 8, 0]],
//	     [[0, 3, 4],
//	      [4, 3, 8],
//	      [5, 2, 7],
//	      [1, 6, 0]]]
//
// # LEFT_RIGHT alignment.
// tf.matrix_diag_part(input, k = (-1, 2), align="LEFT_RIGHT")
//
//	==> [[[3, 8, 0],  # Output shape: (2, 4, 3)
//	      [2, 7, 6],
//	      [1, 6, 7],
//	      [0, 5, 8]],
//	     [[3, 4, 0],
//	      [4, 3, 8],
//	      [5, 2, 7],
//	      [0, 1, 6]]]
//
// # max_diag_len can be shorter than the main diagonal.
// tf.matrix_diag_part(input, k = (-2, -1))
//
//	==> [[[5, 8],
//	      [9, 0]],
//	     [[1, 6],
//	      [5, 0]]]
//
// # padding_value = 9
// tf.matrix_diag_part(input, k = (1, 3), padding_value = 9)
//
//	==> [[[9, 9, 4],  # Output shape: (2, 3, 3)
//	      [9, 3, 8],
//	      [2, 7, 6]],
//	     [[9, 9, 2],
//	      [9, 3, 4],
//	      [4, 3, 8]]]
//
// ```
//
// Arguments:
//
//	input: Rank `r` tensor where `r >= 2`.
//	k: Diagonal offset(s). Positive value means superdiagonal, 0 refers to the main
//
// diagonal, and negative value means subdiagonals. `k` can be a single integer
// (for a single diagonal) or a pair of integers specifying the low and high ends
// of a matrix band. `k[0]` must not be larger than `k[1]`.
//
//	padding_value: The value to fill the area outside the specified diagonal band with.
//
// Default is 0.
//
// Returns The extracted diagonal(s).
func MatrixDiagPartV3(scope *Scope, input tf.Output, k tf.Output, padding_value tf.Output, optional ...MatrixDiagPartV3Attr) (diagonal tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MatrixDiagPartV3",
		Input: []tf.Input{
			input, k, padding_value,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns a batched diagonal tensor with given batched diagonal values.
//
// Returns a tensor with the contents in `diagonal` as `k[0]`-th to `k[1]`-th
// diagonals of a matrix, with everything else padded with `padding`. `num_rows`
// and `num_cols` specify the dimension of the innermost matrix of the output. If
// both are not specified, the op assumes the innermost matrix is square and infers
// its size from `k` and the innermost dimension of `diagonal`. If only one of them
// is specified, the op assumes the unspecified value is the smallest possible
// based on other criteria.
//
// Let `diagonal` have `r` dimensions `[I, J, ..., L, M, N]`. The output tensor has
// rank `r+1` with shape `[I, J, ..., L, M, num_rows, num_cols]` when only one
// diagonal is given (`k` is an integer or `k[0] == k[1]`). Otherwise, it has rank
// `r` with shape `[I, J, ..., L, num_rows, num_cols]`.
//
// The second innermost dimension of `diagonal` has double meaning.
// When `k` is scalar or `k[0] == k[1]`, `M` is part of the batch size
// [I, J, ..., M], and the output tensor is:
//
// ```
// output[i, j, ..., l, m, n]
//
//	= diagonal[i, j, ..., l, n-max(d_upper, 0)] ; if n - m == d_upper
//	  padding_value                             ; otherwise
//
// ```
//
// Otherwise, `M` is treated as the number of diagonals for the matrix in the
// same batch (`M = k[1]-k[0]+1`), and the output tensor is:
//
// ```
// output[i, j, ..., l, m, n]
//
//	= diagonal[i, j, ..., l, diag_index, index_in_diag] ; if k[0] <= d <= k[1]
//	  padding_value                                     ; otherwise
//
// ```
// where `d = n - m`, `diag_index = k[1] - d`, and `index_in_diag = n - max(d, 0)`.
//
// For example:
//
// ```
// # The main diagonal.
// diagonal = np.array([[1, 2, 3, 4],            # Input shape: (2, 4)
//
//	[5, 6, 7, 8]])
//
// tf.matrix_diag(diagonal) ==> [[[1, 0, 0, 0],  # Output shape: (2, 4, 4)
//
//	 [0, 2, 0, 0],
//	 [0, 0, 3, 0],
//	 [0, 0, 0, 4]],
//	[[5, 0, 0, 0],
//	 [0, 6, 0, 0],
//	 [0, 0, 7, 0],
//	 [0, 0, 0, 8]]]
//
// # A superdiagonal (per batch).
// diagonal = np.array([[1, 2, 3],  # Input shape: (2, 3)
//
//	[4, 5, 6]])
//
// tf.matrix_diag(diagonal, k = 1)
//
//	==> [[[0, 1, 0, 0],  # Output shape: (2, 4, 4)
//	      [0, 0, 2, 0],
//	      [0, 0, 0, 3],
//	      [0, 0, 0, 0]],
//	     [[0, 4, 0, 0],
//	      [0, 0, 5, 0],
//	      [0, 0, 0, 6],
//	      [0, 0, 0, 0]]]
//
// # A band of diagonals.
// diagonals = np.array([[[1, 2, 3],  # Input shape: (2, 2, 3)
//
//	 [4, 5, 0]],
//	[[6, 7, 9],
//	 [9, 1, 0]]])
//
// tf.matrix_diag(diagonals, k = (-1, 0))
//
//	==> [[[1, 0, 0],  # Output shape: (2, 3, 3)
//	      [4, 2, 0],
//	      [0, 5, 3]],
//	     [[6, 0, 0],
//	      [9, 7, 0],
//	      [0, 1, 9]]]
//
// # Rectangular matrix.
// diagonal = np.array([1, 2])  # Input shape: (2)
// tf.matrix_diag(diagonal, k = -1, num_rows = 3, num_cols = 4)
//
//	==> [[0, 0, 0, 0],  # Output shape: (3, 4)
//	     [1, 0, 0, 0],
//	     [0, 2, 0, 0]]
//
// # Rectangular matrix with inferred num_cols and padding_value = 9.
// tf.matrix_diag(diagonal, k = -1, num_rows = 3, padding_value = 9)
//
//	==> [[9, 9],  # Output shape: (3, 2)
//	     [1, 9],
//	     [9, 2]]
//
// ```
//
// Arguments:
//
//	diagonal: Rank `r`, where `r >= 1`
//	k: Diagonal offset(s). Positive value means superdiagonal, 0 refers to the main
//
// diagonal, and negative value means subdiagonals. `k` can be a single integer
// (for a single diagonal) or a pair of integers specifying the low and high ends
// of a matrix band. `k[0]` must not be larger than `k[1]`.
//
//	num_rows: The number of rows of the output matrix. If it is not provided, the op assumes
//
// the output matrix is a square matrix and infers the matrix size from k and the
// innermost dimension of `diagonal`.
//
//	num_cols: The number of columns of the output matrix. If it is not provided, the op
//
// assumes the output matrix is a square matrix and infers the matrix size from
// k and the innermost dimension of `diagonal`.
//
//	padding_value: The number to fill the area outside the specified diagonal band with.
//
// Default is 0.
//
// Returns Has rank `r+1` when `k` is an integer or `k[0] == k[1]`, rank `r` otherwise.
func MatrixDiagV2(scope *Scope, diagonal tf.Output, k tf.Output, num_rows tf.Output, num_cols tf.Output, padding_value tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "MatrixDiagV2",
		Input: []tf.Input{
			diagonal, k, num_rows, num_cols, padding_value,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MatrixDiagV3Attr is an optional argument to MatrixDiagV3.
type MatrixDiagV3Attr func(optionalAttr)

// MatrixDiagV3Align sets the optional align attribute to value.
//
// value: Some diagonals are shorter than `max_diag_len` and need to be padded. `align` is
// a string specifying how superdiagonals and subdiagonals should be aligned,
// respectively. There are four possible alignments: "RIGHT_LEFT" (default),
// "LEFT_RIGHT", "LEFT_LEFT", and "RIGHT_RIGHT". "RIGHT_LEFT" aligns superdiagonals
// to the right (left-pads the row) and subdiagonals to the left (right-pads the
// row). It is the packing format LAPACK uses. cuSPARSE uses "LEFT_RIGHT", which is
// the opposite alignment.
// If not specified, defaults to "RIGHT_LEFT"
func MatrixDiagV3Align(value string) MatrixDiagV3Attr {
	return func(m optionalAttr) {
		m["align"] = value
	}
}

// Returns a batched diagonal tensor with given batched diagonal values.
//
// Returns a tensor with the contents in `diagonal` as `k[0]`-th to `k[1]`-th
// diagonals of a matrix, with everything else padded with `padding`. `num_rows`
// and `num_cols` specify the dimension of the innermost matrix of the output. If
// both are not specified, the op assumes the innermost matrix is square and infers
// its size from `k` and the innermost dimension of `diagonal`. If only one of them
// is specified, the op assumes the unspecified value is the smallest possible
// based on other criteria.
//
// Let `diagonal` have `r` dimensions `[I, J, ..., L, M, N]`. The output tensor has
// rank `r+1` with shape `[I, J, ..., L, M, num_rows, num_cols]` when only one
// diagonal is given (`k` is an integer or `k[0] == k[1]`). Otherwise, it has rank
// `r` with shape `[I, J, ..., L, num_rows, num_cols]`.
//
// The second innermost dimension of `diagonal` has double meaning.
// When `k` is scalar or `k[0] == k[1]`, `M` is part of the batch size
// [I, J, ..., M], and the output tensor is:
//
// ```
// output[i, j, ..., l, m, n]
//
//	= diagonal[i, j, ..., l, n-max(d_upper, 0)] ; if n - m == d_upper
//	  padding_value                             ; otherwise
//
// ```
//
// Otherwise, `M` is treated as the number of diagonals for the matrix in the
// same batch (`M = k[1]-k[0]+1`), and the output tensor is:
//
// ```
// output[i, j, ..., l, m, n]
//
//	= diagonal[i, j, ..., l, diag_index, index_in_diag] ; if k[0] <= d <= k[1]
//	  padding_value                                     ; otherwise
//
// ```
// where `d = n - m`, `diag_index = [k] - d`, and
// `index_in_diag = n - max(d, 0) + offset`.
//
// `offset` is zero except when the alignment of the diagonal is to the right.
// ```
// offset = max_diag_len - diag_len(d) ; if (`align` in {RIGHT_LEFT, RIGHT_RIGHT}
//
//	                                  and `d >= 0`) or
//	                                (`align` in {LEFT_RIGHT, RIGHT_RIGHT}
//	                                  and `d <= 0`)
//	0                          ; otherwise
//
// ```
// where `diag_len(d) = min(cols - max(d, 0), rows + min(d, 0))`.
//
// For example:
//
// ```
// # The main diagonal.
// diagonal = np.array([[1, 2, 3, 4],            # Input shape: (2, 4)
//
//	[5, 6, 7, 8]])
//
// tf.matrix_diag(diagonal) ==> [[[1, 0, 0, 0],  # Output shape: (2, 4, 4)
//
//	 [0, 2, 0, 0],
//	 [0, 0, 3, 0],
//	 [0, 0, 0, 4]],
//	[[5, 0, 0, 0],
//	 [0, 6, 0, 0],
//	 [0, 0, 7, 0],
//	 [0, 0, 0, 8]]]
//
// # A superdiagonal (per batch).
// diagonal = np.array([[1, 2, 3],  # Input shape: (2, 3)
//
//	[4, 5, 6]])
//
// tf.matrix_diag(diagonal, k = 1)
//
//	==> [[[0, 1, 0, 0],  # Output shape: (2, 4, 4)
//	      [0, 0, 2, 0],
//	      [0, 0, 0, 3],
//	      [0, 0, 0, 0]],
//	     [[0, 4, 0, 0],
//	      [0, 0, 5, 0],
//	      [0, 0, 0, 6],
//	      [0, 0, 0, 0]]]
//
// # A tridiagonal band (per batch).
// diagonals = np.array([[[0, 8, 9],  # Input shape: (2, 2, 3)
//
//	 [1, 2, 3],
//	 [4, 5, 0]],
//	[[0, 2, 3],
//	 [6, 7, 9],
//	 [9, 1, 0]]])
//
// tf.matrix_diag(diagonals, k = (-1, 1))
//
//	==> [[[1, 8, 0],  # Output shape: (2, 3, 3)
//	      [4, 2, 9],
//	      [0, 5, 3]],
//	     [[6, 2, 0],
//	      [9, 7, 3],
//	      [0, 1, 9]]]
//
// # LEFT_RIGHT alignment.
// diagonals = np.array([[[8, 9, 0],  # Input shape: (2, 2, 3)
//
//	 [1, 2, 3],
//	 [0, 4, 5]],
//	[[2, 3, 0],
//	 [6, 7, 9],
//	 [0, 9, 1]]])
//
// tf.matrix_diag(diagonals, k = (-1, 1), align="LEFT_RIGHT")
//
//	==> [[[1, 8, 0],  # Output shape: (2, 3, 3)
//	      [4, 2, 9],
//	      [0, 5, 3]],
//	     [[6, 2, 0],
//	      [9, 7, 3],
//	      [0, 1, 9]]]
//
// # Rectangular matrix.
// diagonal = np.array([1, 2])  # Input shape: (2)
// tf.matrix_diag(diagonal, k = -1, num_rows = 3, num_cols = 4)
//
//	==> [[0, 0, 0, 0],  # Output shape: (3, 4)
//	     [1, 0, 0, 0],
//	     [0, 2, 0, 0]]
//
// # Rectangular matrix with inferred num_cols and padding_value = 9.
// tf.matrix_diag(diagonal, k = -1, num_rows = 3, padding_value = 9)
//
//	==> [[9, 9],  # Output shape: (3, 2)
//	     [1, 9],
//	     [9, 2]]
//
// ```
//
// Arguments:
//
//	diagonal: Rank `r`, where `r >= 1`
//	k: Diagonal offset(s). Positive value means superdiagonal, 0 refers to the main
//
// diagonal, and negative value means subdiagonals. `k` can be a single integer
// (for a single diagonal) or a pair of integers specifying the low and high ends
// of a matrix band. `k[0]` must not be larger than `k[1]`.
//
//	num_rows: The number of rows of the output matrix. If it is not provided, the op assumes
//
// the output matrix is a square matrix and infers the matrix size from k and the
// innermost dimension of `diagonal`.
//
//	num_cols: The number of columns of the output matrix. If it is not provided, the op
//
// assumes the output matrix is a square matrix and infers the matrix size from
// k and the innermost dimension of `diagonal`.
//
//	padding_value: The number to fill the area outside the specified diagonal band with.
//
// Default is 0.
//
// Returns Has rank `r+1` when `k` is an integer or `k[0] == k[1]`, rank `r` otherwise.
func MatrixDiagV3(scope *Scope, diagonal tf.Output, k tf.Output, num_rows tf.Output, num_cols tf.Output, padding_value tf.Output, optional ...MatrixDiagV3Attr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MatrixDiagV3",
		Input: []tf.Input{
			diagonal, k, num_rows, num_cols, padding_value,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Deprecated, use python implementation tf.linalg.matrix_exponential.
//
// DEPRECATED at GraphDef version 27: Use Python implementation tf.linalg.matrix_exponential instead.
func MatrixExponential(scope *Scope, input tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "MatrixExponential",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MatrixInverseAttr is an optional argument to MatrixInverse.
type MatrixInverseAttr func(optionalAttr)

// MatrixInverseAdjoint sets the optional adjoint attribute to value.
// If not specified, defaults to false
func MatrixInverseAdjoint(value bool) MatrixInverseAttr {
	return func(m optionalAttr) {
		m["adjoint"] = value
	}
}

// Computes the inverse of one or more square invertible matrices or their adjoints (conjugate transposes).
//
// The input is a tensor of shape `[..., M, M]` whose inner-most 2 dimensions
// form square matrices. The output is a tensor of the same shape as the input
// containing the inverse for all input submatrices `[..., :, :]`.
//
// The op uses LU decomposition with partial pivoting to compute the inverses.
//
// If a matrix is not invertible there is no guarantee what the op does. It
// may detect the condition and raise an exception or it may simply return a
// garbage result.
//
// Arguments:
//
//	input: Shape is `[..., M, M]`.
//
// Returns Shape is `[..., M, M]`.
//
// @compatibility(numpy)
// Equivalent to np.linalg.inv
// @end_compatibility
func MatrixInverse(scope *Scope, input tf.Output, optional ...MatrixInverseAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MatrixInverse",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the matrix logarithm of one or more square matrices:
//
// \\(log(exp(A)) = A\\)
//
// This op is only defined for complex matrices. If A is positive-definite and
// real, then casting to a complex matrix, taking the logarithm and casting back
// to a real matrix will give the correct result.
//
// This function computes the matrix logarithm using the Schur-Parlett algorithm.
// Details of the algorithm can be found in Section 11.6.2 of:
// Nicholas J. Higham, Functions of Matrices: Theory and Computation, SIAM 2008.
// ISBN 978-0-898716-46-7.
//
// The input is a tensor of shape `[..., M, M]` whose inner-most 2 dimensions
// form square matrices. The output is a tensor of the same shape as the input
// containing the exponential for all input submatrices `[..., :, :]`.
//
// Arguments:
//
//	input: Shape is `[..., M, M]`.
//
// Returns Shape is `[..., M, M]`.
//
// @compatibility(scipy)
// Equivalent to scipy.linalg.logm
// @end_compatibility
func MatrixLogarithm(scope *Scope, input tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "MatrixLogarithm",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns a batched matrix tensor with new batched diagonal values.
//
// Given `input` and `diagonal`, this operation returns a tensor with the
// same shape and values as `input`, except for the main diagonal of the
// innermost matrices.  These will be overwritten by the values in `diagonal`.
//
// The output is computed as follows:
//
// Assume `input` has `k+1` dimensions `[I, J, K, ..., M, N]` and `diagonal` has
// `k` dimensions `[I, J, K, ..., min(M, N)]`.  Then the output is a
// tensor of rank `k+1` with dimensions `[I, J, K, ..., M, N]` where:
//
//   - `output[i, j, k, ..., m, n] = diagonal[i, j, k, ..., n]` for `m == n`.
//   - `output[i, j, k, ..., m, n] = input[i, j, k, ..., m, n]` for `m != n`.
//
// Arguments:
//
//	input: Rank `k+1`, where `k >= 1`.
//	diagonal: Rank `k`, where `k >= 1`.
//
// Returns Rank `k+1`, with `output.shape = input.shape`.
func MatrixSetDiag(scope *Scope, input tf.Output, diagonal tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "MatrixSetDiag",
		Input: []tf.Input{
			input, diagonal,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns a batched matrix tensor with new batched diagonal values.
//
// Given `input` and `diagonal`, this operation returns a tensor with the
// same shape and values as `input`, except for the specified diagonals of the
// innermost matrices. These will be overwritten by the values in `diagonal`.
//
// `input` has `r+1` dimensions `[I, J, ..., L, M, N]`. When `k` is scalar or
// `k[0] == k[1]`, `diagonal` has `r` dimensions `[I, J, ..., L, max_diag_len]`.
// Otherwise, it has `r+1` dimensions `[I, J, ..., L, num_diags, max_diag_len]`.
// `num_diags` is the number of diagonals, `num_diags = k[1] - k[0] + 1`.
// `max_diag_len` is the longest diagonal in the range `[k[0], k[1]]`,
// `max_diag_len = min(M + min(k[1], 0), N + min(-k[0], 0))`
//
// The output is a tensor of rank `k+1` with dimensions `[I, J, ..., L, M, N]`.
// If `k` is scalar or `k[0] == k[1]`:
//
// ```
// output[i, j, ..., l, m, n]
//
//	= diagonal[i, j, ..., l, n-max(k[1], 0)] ; if n - m == k[1]
//	  input[i, j, ..., l, m, n]              ; otherwise
//
// ```
//
// Otherwise,
//
// ```
// output[i, j, ..., l, m, n]
//
//	= diagonal[i, j, ..., l, diag_index, index_in_diag] ; if k[0] <= d <= k[1]
//	  input[i, j, ..., l, m, n]                         ; otherwise
//
// ```
// where `d = n - m`, `diag_index = k[1] - d`, and `index_in_diag = n - max(d, 0)`.
//
// For example:
//
// ```
// # The main diagonal.
// input = np.array([[[7, 7, 7, 7],              # Input shape: (2, 3, 4)
//
//	 [7, 7, 7, 7],
//	 [7, 7, 7, 7]],
//	[[7, 7, 7, 7],
//	 [7, 7, 7, 7],
//	 [7, 7, 7, 7]]])
//
// diagonal = np.array([[1, 2, 3],               # Diagonal shape: (2, 3)
//
//	[4, 5, 6]])
//
// tf.matrix_set_diag(diagonal) ==> [[[1, 7, 7, 7],  # Output shape: (2, 3, 4)
//
//	 [7, 2, 7, 7],
//	 [7, 7, 3, 7]],
//	[[4, 7, 7, 7],
//	 [7, 5, 7, 7],
//	 [7, 7, 6, 7]]]
//
// # A superdiagonal (per batch).
// tf.matrix_set_diag(diagonal, k = 1)
//
//	==> [[[7, 1, 7, 7],  # Output shape: (2, 3, 4)
//	      [7, 7, 2, 7],
//	      [7, 7, 7, 3]],
//	     [[7, 4, 7, 7],
//	      [7, 7, 5, 7],
//	      [7, 7, 7, 6]]]
//
// # A band of diagonals.
// diagonals = np.array([[[1, 2, 3],  # Diagonal shape: (2, 2, 3)
//
//	 [4, 5, 0]],
//	[[6, 1, 2],
//	 [3, 4, 0]]])
//
// tf.matrix_set_diag(diagonals, k = (-1, 0))
//
//	==> [[[1, 7, 7, 7],  # Output shape: (2, 3, 4)
//	      [4, 2, 7, 7],
//	      [0, 5, 3, 7]],
//	     [[6, 7, 7, 7],
//	      [3, 1, 7, 7],
//	      [7, 4, 2, 7]]]
//
// ```
//
// Arguments:
//
//	input: Rank `r+1`, where `r >= 1`.
//	diagonal: Rank `r` when `k` is an integer or `k[0] == k[1]`. Otherwise, it has rank `r+1`.
//
// `k >= 1`.
//
//	k: Diagonal offset(s). Positive value means superdiagonal, 0 refers to the main
//
// diagonal, and negative value means subdiagonals. `k` can be a single integer
// (for a single diagonal) or a pair of integers specifying the low and high ends
// of a matrix band. `k[0]` must not be larger than `k[1]`.
//
// Returns Rank `r+1`, with `output.shape = input.shape`.
func MatrixSetDiagV2(scope *Scope, input tf.Output, diagonal tf.Output, k tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "MatrixSetDiagV2",
		Input: []tf.Input{
			input, diagonal, k,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MatrixSetDiagV3Attr is an optional argument to MatrixSetDiagV3.
type MatrixSetDiagV3Attr func(optionalAttr)

// MatrixSetDiagV3Align sets the optional align attribute to value.
//
// value: Some diagonals are shorter than `max_diag_len` and need to be padded. `align` is
// a string specifying how superdiagonals and subdiagonals should be aligned,
// respectively. There are four possible alignments: "RIGHT_LEFT" (default),
// "LEFT_RIGHT", "LEFT_LEFT", and "RIGHT_RIGHT". "RIGHT_LEFT" aligns superdiagonals
// to the right (left-pads the row) and subdiagonals to the left (right-pads the
// row). It is the packing format LAPACK uses. cuSPARSE uses "LEFT_RIGHT", which is
// the opposite alignment.
// If not specified, defaults to "RIGHT_LEFT"
func MatrixSetDiagV3Align(value string) MatrixSetDiagV3Attr {
	return func(m optionalAttr) {
		m["align"] = value
	}
}

// Returns a batched matrix tensor with new batched diagonal values.
//
// Given `input` and `diagonal`, this operation returns a tensor with the
// same shape and values as `input`, except for the specified diagonals of the
// innermost matrices. These will be overwritten by the values in `diagonal`.
//
// `input` has `r+1` dimensions `[I, J, ..., L, M, N]`. When `k` is scalar or
// `k[0] == k[1]`, `diagonal` has `r` dimensions `[I, J, ..., L, max_diag_len]`.
// Otherwise, it has `r+1` dimensions `[I, J, ..., L, num_diags, max_diag_len]`.
// `num_diags` is the number of diagonals, `num_diags = k[1] - k[0] + 1`.
// `max_diag_len` is the longest diagonal in the range `[k[0], k[1]]`,
// `max_diag_len = min(M + min(k[1], 0), N + min(-k[0], 0))`
//
// The output is a tensor of rank `k+1` with dimensions `[I, J, ..., L, M, N]`.
// If `k` is scalar or `k[0] == k[1]`:
//
// ```
// output[i, j, ..., l, m, n]
//
//	= diagonal[i, j, ..., l, n-max(k[1], 0)] ; if n - m == k[1]
//	  input[i, j, ..., l, m, n]              ; otherwise
//
// ```
//
// Otherwise,
//
// ```
// output[i, j, ..., l, m, n]
//
//	= diagonal[i, j, ..., l, diag_index, index_in_diag] ; if k[0] <= d <= k[1]
//	  input[i, j, ..., l, m, n]                         ; otherwise
//
// ```
// where `d = n - m`, `diag_index = k[1] - d`, and
// `index_in_diag = n - max(d, 0) + offset`.
//
// `offset` is zero except when the alignment of the diagonal is to the right.
// ```
// offset = max_diag_len - diag_len(d) ; if (`align` in {RIGHT_LEFT, RIGHT_RIGHT}
//
//	                                  and `d >= 0`) or
//	                                (`align` in {LEFT_RIGHT, RIGHT_RIGHT}
//	                                  and `d <= 0`)
//	0                          ; otherwise
//
// ```
// where `diag_len(d) = min(cols - max(d, 0), rows + min(d, 0))`.
//
// For example:
//
// ```
// # The main diagonal.
// input = np.array([[[7, 7, 7, 7],              # Input shape: (2, 3, 4)
//
//	 [7, 7, 7, 7],
//	 [7, 7, 7, 7]],
//	[[7, 7, 7, 7],
//	 [7, 7, 7, 7],
//	 [7, 7, 7, 7]]])
//
// diagonal = np.array([[1, 2, 3],               # Diagonal shape: (2, 3)
//
//	[4, 5, 6]])
//
// tf.matrix_set_diag(input, diagonal)
//
//	==> [[[1, 7, 7, 7],  # Output shape: (2, 3, 4)
//	      [7, 2, 7, 7],
//	      [7, 7, 3, 7]],
//	     [[4, 7, 7, 7],
//	      [7, 5, 7, 7],
//	      [7, 7, 6, 7]]]
//
// # A superdiagonal (per batch).
// tf.matrix_set_diag(input, diagonal, k = 1)
//
//	==> [[[7, 1, 7, 7],  # Output shape: (2, 3, 4)
//	      [7, 7, 2, 7],
//	      [7, 7, 7, 3]],
//	     [[7, 4, 7, 7],
//	      [7, 7, 5, 7],
//	      [7, 7, 7, 6]]]
//
// # A band of diagonals.
// diagonals = np.array([[[0, 9, 1],  # Diagonal shape: (2, 4, 3)
//
//	 [6, 5, 8],
//	 [1, 2, 3],
//	 [4, 5, 0]],
//	[[0, 1, 2],
//	 [5, 6, 4],
//	 [6, 1, 2],
//	 [3, 4, 0]]])
//
// tf.matrix_set_diag(input, diagonals, k = (-1, 2))
//
//	==> [[[1, 6, 9, 7],  # Output shape: (2, 3, 4)
//	      [4, 2, 5, 1],
//	      [7, 5, 3, 8]],
//	     [[6, 5, 1, 7],
//	      [3, 1, 6, 2],
//	      [7, 4, 2, 4]]]
//
// # LEFT_RIGHT alignment.
// diagonals = np.array([[[9, 1, 0],  # Diagonal shape: (2, 4, 3)
//
//	 [6, 5, 8],
//	 [1, 2, 3],
//	 [0, 4, 5]],
//	[[1, 2, 0],
//	 [5, 6, 4],
//	 [6, 1, 2],
//	 [0, 3, 4]]])
//
// tf.matrix_set_diag(input, diagonals, k = (-1, 2), align="LEFT_RIGHT")
//
//	==> [[[1, 6, 9, 7],  # Output shape: (2, 3, 4)
//	      [4, 2, 5, 1],
//	      [7, 5, 3, 8]],
//	     [[6, 5, 1, 7],
//	      [3, 1, 6, 2],
//	      [7, 4, 2, 4]]]
//
// ```
//
// Arguments:
//
//	input: Rank `r+1`, where `r >= 1`.
//	diagonal: Rank `r` when `k` is an integer or `k[0] == k[1]`. Otherwise, it has rank `r+1`.
//
// `k >= 1`.
//
//	k: Diagonal offset(s). Positive value means superdiagonal, 0 refers to the main
//
// diagonal, and negative value means subdiagonals. `k` can be a single integer
// (for a single diagonal) or a pair of integers specifying the low and high ends
// of a matrix band. `k[0]` must not be larger than `k[1]`.
//
// Returns Rank `r+1`, with `output.shape = input.shape`.
func MatrixSetDiagV3(scope *Scope, input tf.Output, diagonal tf.Output, k tf.Output, optional ...MatrixSetDiagV3Attr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MatrixSetDiagV3",
		Input: []tf.Input{
			input, diagonal, k,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MatrixSolveAttr is an optional argument to MatrixSolve.
type MatrixSolveAttr func(optionalAttr)

// MatrixSolveAdjoint sets the optional adjoint attribute to value.
//
// value: Boolean indicating whether to solve with `matrix` or its (block-wise)
// adjoint.
// If not specified, defaults to false
func MatrixSolveAdjoint(value bool) MatrixSolveAttr {
	return func(m optionalAttr) {
		m["adjoint"] = value
	}
}

// Solves systems of linear equations.
//
// `Matrix` is a tensor of shape `[..., M, M]` whose inner-most 2 dimensions
// form square matrices. `Rhs` is a tensor of shape `[..., M, K]`. The `output` is
// a tensor shape `[..., M, K]`.  If `adjoint` is `False` then each output matrix
// satisfies `matrix[..., :, :] * output[..., :, :] = rhs[..., :, :]`.
// If `adjoint` is `True` then each output matrix satisfies
// `adjoint(matrix[..., :, :]) * output[..., :, :] = rhs[..., :, :]`.
//
// Arguments:
//
//	matrix: Shape is `[..., M, M]`.
//	rhs: Shape is `[..., M, K]`.
//
// Returns Shape is `[..., M, K]`.
func MatrixSolve(scope *Scope, matrix tf.Output, rhs tf.Output, optional ...MatrixSolveAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MatrixSolve",
		Input: []tf.Input{
			matrix, rhs,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MatrixSolveLsAttr is an optional argument to MatrixSolveLs.
type MatrixSolveLsAttr func(optionalAttr)

// MatrixSolveLsFast sets the optional fast attribute to value.
// If not specified, defaults to true
func MatrixSolveLsFast(value bool) MatrixSolveLsAttr {
	return func(m optionalAttr) {
		m["fast"] = value
	}
}

// Solves one or more linear least-squares problems.
//
// `matrix` is a tensor of shape `[..., M, N]` whose inner-most 2 dimensions
// form real or complex matrices of size `[M, N]`. `Rhs` is a tensor of the same
// type as `matrix` and shape `[..., M, K]`.
// The output is a tensor shape `[..., N, K]` where each output matrix solves
// each of the equations
// `matrix[..., :, :]` * `output[..., :, :]` = `rhs[..., :, :]`
// in the least squares sense.
//
// We use the following notation for (complex) matrix and right-hand sides
// in the batch:
//
// `matrix`=\\(A \in \mathbb{C}^{m \times n}\\),
// `rhs`=\\(B  \in \mathbb{C}^{m \times k}\\),
// `output`=\\(X  \in \mathbb{C}^{n \times k}\\),
// `l2_regularizer`=\\(\lambda \in \mathbb{R}\\).
//
// If `fast` is `True`, then the solution is computed by solving the normal
// equations using Cholesky decomposition. Specifically, if \\(m \ge n\\) then
// \\(X = (A^H A + \lambda I)^{-1} A^H B\\), which solves the least-squares
// problem \\(X = \mathrm{argmin}_{Z \in \Re^{n \times k} } ||A Z - B||_F^2 + \lambda ||Z||_F^2\\).
// If \\(m \lt n\\) then `output` is computed as
// \\(X = A^H (A A^H + \lambda I)^{-1} B\\), which (for \\(\lambda = 0\\)) is the
// minimum-norm solution to the under-determined linear system, i.e.
// \\(X = \mathrm{argmin}_{Z \in \mathbb{C}^{n \times k} } ||Z||_F^2 \\),
// subject to \\(A Z = B\\). Notice that the fast path is only numerically stable
// when \\(A\\) is numerically full rank and has a condition number
// \\(\mathrm{cond}(A) \lt \frac{1}{\sqrt{\epsilon_{mach} } }\\) or \\(\lambda\\) is
// sufficiently large.
//
// If `fast` is `False` an algorithm based on the numerically robust complete
// orthogonal decomposition is used. This computes the minimum-norm
// least-squares solution, even when \\(A\\) is rank deficient. This path is
// typically 6-7 times slower than the fast path. If `fast` is `False` then
// `l2_regularizer` is ignored.
//
// Arguments:
//
//	matrix: Shape is `[..., M, N]`.
//	rhs: Shape is `[..., M, K]`.
//	l2_regularizer: Scalar tensor.
//
// @compatibility(numpy)
// Equivalent to np.linalg.lstsq
// @end_compatibility
//
// Returns Shape is `[..., N, K]`.
func MatrixSolveLs(scope *Scope, matrix tf.Output, rhs tf.Output, l2_regularizer tf.Output, optional ...MatrixSolveLsAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MatrixSolveLs",
		Input: []tf.Input{
			matrix, rhs, l2_regularizer,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the matrix square root of one or more square matrices:
//
// matmul(sqrtm(A), sqrtm(A)) = A
//
// The input matrix should be invertible. If the input matrix is real, it should
// have no eigenvalues which are real and negative (pairs of complex conjugate
// eigenvalues are allowed).
//
// The matrix square root is computed by first reducing the matrix to
// quasi-triangular form with the real Schur decomposition. The square root
// of the quasi-triangular matrix is then computed directly. Details of
// the algorithm can be found in: Nicholas J. Higham, "Computing real
// square roots of a real matrix", Linear Algebra Appl., 1987.
//
// The input is a tensor of shape `[..., M, M]` whose inner-most 2 dimensions
// form square matrices. The output is a tensor of the same shape as the input
// containing the matrix square root for all input submatrices `[..., :, :]`.
//
// Arguments:
//
//	input: Shape is `[..., M, M]`.
//
// Returns Shape is `[..., M, M]`.
//
// @compatibility(scipy)
// Equivalent to scipy.linalg.sqrtm
// @end_compatibility
func MatrixSquareRoot(scope *Scope, input tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "MatrixSquareRoot",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MatrixTriangularSolveAttr is an optional argument to MatrixTriangularSolve.
type MatrixTriangularSolveAttr func(optionalAttr)

// MatrixTriangularSolveLower sets the optional lower attribute to value.
//
// value: Boolean indicating whether the innermost matrices in `matrix` are
// lower or upper triangular.
// If not specified, defaults to true
func MatrixTriangularSolveLower(value bool) MatrixTriangularSolveAttr {
	return func(m optionalAttr) {
		m["lower"] = value
	}
}

// MatrixTriangularSolveAdjoint sets the optional adjoint attribute to value.
//
// value: Boolean indicating whether to solve with `matrix` or its (block-wise)
//
//	adjoint.
//
// @compatibility(numpy)
// Equivalent to scipy.linalg.solve_triangular
// @end_compatibility
// If not specified, defaults to false
func MatrixTriangularSolveAdjoint(value bool) MatrixTriangularSolveAttr {
	return func(m optionalAttr) {
		m["adjoint"] = value
	}
}

// Solves systems of linear equations with upper or lower triangular matrices by backsubstitution.
//
// `matrix` is a tensor of shape `[..., M, M]` whose inner-most 2 dimensions form
// square matrices. If `lower` is `True` then the strictly upper triangular part
// of each inner-most matrix is assumed to be zero and not accessed.
// If `lower` is False then the strictly lower triangular part of each inner-most
// matrix is assumed to be zero and not accessed.
// `rhs` is a tensor of shape `[..., M, N]`.
//
// The output is a tensor of shape `[..., M, N]`. If `adjoint` is
// `True` then the innermost matrices in `output` satisfy matrix equations
// `matrix[..., :, :] * output[..., :, :] = rhs[..., :, :]`.
// If `adjoint` is `False` then the strictly then the  innermost matrices in
// `output` satisfy matrix equations
// `adjoint(matrix[..., i, k]) * output[..., k, j] = rhs[..., i, j]`.
//
// Note, the batch shapes for the inputs only need to broadcast.
//
// Example:
// ```python
//
// a = tf.constant([[3,  0,  0,  0],
//
//	[2,  1,  0,  0],
//	[1,  0,  1,  0],
//	[1,  1,  1,  1]], dtype=tf.float32)
//
// b = tf.constant([[4],
//
//	[2],
//	[4],
//	[2]], dtype=tf.float32)
//
// x = tf.linalg.triangular_solve(a, b, lower=True)
// x
// # <tf.Tensor: shape=(4, 1), dtype=float32, numpy=
// # array([[ 1.3333334 ],
// #        [-0.66666675],
// #        [ 2.6666665 ],
// #        [-1.3333331 ]], dtype=float32)>
//
// # in python3 one can use `a@x`
// tf.matmul(a, x)
// # <tf.Tensor: shape=(4, 1), dtype=float32, numpy=
// # array([[4.       ],
// #        [2.       ],
// #        [4.       ],
// #        [1.9999999]], dtype=float32)>
// ```
//
// Arguments:
//
//	matrix: Shape is `[..., M, M]`.
//	rhs: Shape is `[..., M, K]`.
//
// Returns Shape is `[..., M, K]`.
func MatrixTriangularSolve(scope *Scope, matrix tf.Output, rhs tf.Output, optional ...MatrixTriangularSolveAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MatrixTriangularSolve",
		Input: []tf.Input{
			matrix, rhs,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MaxAttr is an optional argument to Max.
type MaxAttr func(optionalAttr)

// MaxKeepDims sets the optional keep_dims attribute to value.
//
// value: If true, retain reduced dimensions with length 1.
// If not specified, defaults to false
func MaxKeepDims(value bool) MaxAttr {
	return func(m optionalAttr) {
		m["keep_dims"] = value
	}
}

// Computes the maximum of elements across dimensions of a tensor.
//
// Reduces `input` along the dimensions given in `axis`. Unless
// `keep_dims` is true, the rank of the tensor is reduced by 1 for each entry in
// `axis`. If `keep_dims` is true, the reduced dimensions are
// retained with length 1.
//
// Arguments:
//
//	input: The tensor to reduce.
//	axis: The dimensions to reduce. Must be in the range
//
// `[-rank(input), rank(input))`.
//
// Returns The reduced tensor.
func Max(scope *Scope, input tf.Output, axis tf.Output, optional ...MaxAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Max",
		Input: []tf.Input{
			input, axis,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates a dataset that overrides the maximum intra-op parallelism.
//
// Arguments:
//
//	max_intra_op_parallelism: Identifies the maximum intra-op parallelism to use.
func MaxIntraOpParallelismDataset(scope *Scope, input_dataset tf.Output, max_intra_op_parallelism tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "MaxIntraOpParallelismDataset",
		Input: []tf.Input{
			input_dataset, max_intra_op_parallelism,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MaxPoolAttr is an optional argument to MaxPool.
type MaxPoolAttr func(optionalAttr)

// MaxPoolExplicitPaddings sets the optional explicit_paddings attribute to value.
// If not specified, defaults to {}
func MaxPoolExplicitPaddings(value []int64) MaxPoolAttr {
	return func(m optionalAttr) {
		m["explicit_paddings"] = value
	}
}

// MaxPoolDataFormat sets the optional data_format attribute to value.
//
// value: Specify the data format of the input and output data. With the
// default format "NHWC", the data is stored in the order of:
//
//	[batch, in_height, in_width, in_channels].
//
// Alternatively, the format could be "NCHW", the data storage order of:
//
//	[batch, in_channels, in_height, in_width].
//
// If not specified, defaults to "NHWC"
func MaxPoolDataFormat(value string) MaxPoolAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Performs max pooling on the input.
//
// Arguments:
//
//	input: 4-D input to pool over.
//	ksize: The size of the window for each dimension of the input tensor.
//	strides: The stride of the sliding window for each dimension of the
//
// input tensor.
//
//	padding: The type of padding algorithm to use.
//
// Returns The max pooled output tensor.
func MaxPool(scope *Scope, input tf.Output, ksize []int64, strides []int64, padding string, optional ...MaxPoolAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"ksize": ksize, "strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MaxPool",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MaxPool3DAttr is an optional argument to MaxPool3D.
type MaxPool3DAttr func(optionalAttr)

// MaxPool3DDataFormat sets the optional data_format attribute to value.
//
// value: The data format of the input and output data. With the
// default format "NDHWC", the data is stored in the order of:
//
//	[batch, in_depth, in_height, in_width, in_channels].
//
// Alternatively, the format could be "NCDHW", the data storage order is:
//
//	[batch, in_channels, in_depth, in_height, in_width].
//
// If not specified, defaults to "NDHWC"
func MaxPool3DDataFormat(value string) MaxPool3DAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Performs 3D max pooling on the input.
//
// Arguments:
//
//	input: Shape `[batch, depth, rows, cols, channels]` tensor to pool over.
//	ksize: 1-D tensor of length 5. The size of the window for each dimension of
//
// the input tensor. Must have `ksize[0] = ksize[4] = 1`.
//
//	strides: 1-D tensor of length 5. The stride of the sliding window for each
//
// dimension of `input`. Must have `strides[0] = strides[4] = 1`.
//
//	padding: The type of padding algorithm to use.
//
// Returns The max pooled output tensor.
func MaxPool3D(scope *Scope, input tf.Output, ksize []int64, strides []int64, padding string, optional ...MaxPool3DAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"ksize": ksize, "strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MaxPool3D",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MaxPool3DGradAttr is an optional argument to MaxPool3DGrad.
type MaxPool3DGradAttr func(optionalAttr)

// MaxPool3DGradDataFormat sets the optional data_format attribute to value.
//
// value: The data format of the input and output data. With the
// default format "NDHWC", the data is stored in the order of:
//
//	[batch, in_depth, in_height, in_width, in_channels].
//
// Alternatively, the format could be "NCDHW", the data storage order is:
//
//	[batch, in_channels, in_depth, in_height, in_width].
//
// If not specified, defaults to "NDHWC"
func MaxPool3DGradDataFormat(value string) MaxPool3DGradAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Computes gradients of 3D max pooling function.
//
// Arguments:
//
//	orig_input: The original input tensor.
//	orig_output: The original output tensor.
//	grad: Output backprop of shape `[batch, depth, rows, cols, channels]`.
//	ksize: 1-D tensor of length 5. The size of the window for each dimension of
//
// the input tensor. Must have `ksize[0] = ksize[4] = 1`.
//
//	strides: 1-D tensor of length 5. The stride of the sliding window for each
//
// dimension of `input`. Must have `strides[0] = strides[4] = 1`.
//
//	padding: The type of padding algorithm to use.
func MaxPool3DGrad(scope *Scope, orig_input tf.Output, orig_output tf.Output, grad tf.Output, ksize []int64, strides []int64, padding string, optional ...MaxPool3DGradAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"ksize": ksize, "strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MaxPool3DGrad",
		Input: []tf.Input{
			orig_input, orig_output, grad,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MaxPool3DGradGradAttr is an optional argument to MaxPool3DGradGrad.
type MaxPool3DGradGradAttr func(optionalAttr)

// MaxPool3DGradGradDataFormat sets the optional data_format attribute to value.
//
// value: The data format of the input and output data. With the
// default format "NDHWC", the data is stored in the order of:
//
//	[batch, in_depth, in_height, in_width, in_channels].
//
// Alternatively, the format could be "NCDHW", the data storage order is:
//
//	[batch, in_channels, in_depth, in_height, in_width].
//
// If not specified, defaults to "NDHWC"
func MaxPool3DGradGradDataFormat(value string) MaxPool3DGradGradAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Computes second-order gradients of the maxpooling function.
//
// Arguments:
//
//	orig_input: The original input tensor.
//	orig_output: The original output tensor.
//	grad: Output backprop of shape `[batch, depth, rows, cols, channels]`.
//	ksize: 1-D tensor of length 5. The size of the window for each dimension of
//
// the input tensor. Must have `ksize[0] = ksize[4] = 1`.
//
//	strides: 1-D tensor of length 5. The stride of the sliding window for each
//
// dimension of `input`. Must have `strides[0] = strides[4] = 1`.
//
//	padding: The type of padding algorithm to use.
//
// Returns Gradients of gradients w.r.t. the input to `max_pool`.
func MaxPool3DGradGrad(scope *Scope, orig_input tf.Output, orig_output tf.Output, grad tf.Output, ksize []int64, strides []int64, padding string, optional ...MaxPool3DGradGradAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"ksize": ksize, "strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MaxPool3DGradGrad",
		Input: []tf.Input{
			orig_input, orig_output, grad,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MaxPoolGradAttr is an optional argument to MaxPoolGrad.
type MaxPoolGradAttr func(optionalAttr)

// MaxPoolGradExplicitPaddings sets the optional explicit_paddings attribute to value.
// If not specified, defaults to {}
func MaxPoolGradExplicitPaddings(value []int64) MaxPoolGradAttr {
	return func(m optionalAttr) {
		m["explicit_paddings"] = value
	}
}

// MaxPoolGradDataFormat sets the optional data_format attribute to value.
//
// value: Specify the data format of the input and output data. With the
// default format "NHWC", the data is stored in the order of:
//
//	[batch, in_height, in_width, in_channels].
//
// Alternatively, the format could be "NCHW", the data storage order of:
//
//	[batch, in_channels, in_height, in_width].
//
// If not specified, defaults to "NHWC"
func MaxPoolGradDataFormat(value string) MaxPoolGradAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Computes gradients of the maxpooling function.
//
// Arguments:
//
//	orig_input: The original input tensor.
//	orig_output: The original output tensor.
//	grad: 4-D.  Gradients w.r.t. the output of `max_pool`.
//	ksize: The size of the window for each dimension of the input tensor.
//	strides: The stride of the sliding window for each dimension of the
//
// input tensor.
//
//	padding: The type of padding algorithm to use.
//
// Returns Gradients w.r.t. the input to `max_pool`.
func MaxPoolGrad(scope *Scope, orig_input tf.Output, orig_output tf.Output, grad tf.Output, ksize []int64, strides []int64, padding string, optional ...MaxPoolGradAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"ksize": ksize, "strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MaxPoolGrad",
		Input: []tf.Input{
			orig_input, orig_output, grad,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MaxPoolGradGradAttr is an optional argument to MaxPoolGradGrad.
type MaxPoolGradGradAttr func(optionalAttr)

// MaxPoolGradGradDataFormat sets the optional data_format attribute to value.
//
// value: Specify the data format of the input and output data. With the
// default format "NHWC", the data is stored in the order of:
//
//	[batch, in_height, in_width, in_channels].
//
// Alternatively, the format could be "NCHW", the data storage order of:
//
//	[batch, in_channels, in_height, in_width].
//
// If not specified, defaults to "NHWC"
func MaxPoolGradGradDataFormat(value string) MaxPoolGradGradAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Computes second-order gradients of the maxpooling function.
//
// Arguments:
//
//	orig_input: The original input tensor.
//	orig_output: The original output tensor.
//	grad: 4-D.  Gradients of gradients w.r.t. the input of `max_pool`.
//	ksize: The size of the window for each dimension of the input tensor.
//	strides: The stride of the sliding window for each dimension of the
//
// input tensor.
//
//	padding: The type of padding algorithm to use.
//
// Returns Gradients of gradients w.r.t. the input to `max_pool`.
func MaxPoolGradGrad(scope *Scope, orig_input tf.Output, orig_output tf.Output, grad tf.Output, ksize []int64, strides []int64, padding string, optional ...MaxPoolGradGradAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"ksize": ksize, "strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MaxPoolGradGrad",
		Input: []tf.Input{
			orig_input, orig_output, grad,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MaxPoolGradGradV2Attr is an optional argument to MaxPoolGradGradV2.
type MaxPoolGradGradV2Attr func(optionalAttr)

// MaxPoolGradGradV2DataFormat sets the optional data_format attribute to value.
//
// value: Specify the data format of the input and output data. With the
// default format "NHWC", the data is stored in the order of:
//
//	[batch, in_height, in_width, in_channels].
//
// Alternatively, the format could be "NCHW", the data storage order of:
//
//	[batch, in_channels, in_height, in_width].
//
// If not specified, defaults to "NHWC"
func MaxPoolGradGradV2DataFormat(value string) MaxPoolGradGradV2Attr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Computes second-order gradients of the maxpooling function.
//
// Arguments:
//
//	orig_input: The original input tensor.
//	orig_output: The original output tensor.
//	grad: 4-D.  Gradients of gradients w.r.t. the input of `max_pool`.
//	ksize: The size of the window for each dimension of the input tensor.
//	strides: The stride of the sliding window for each dimension of the
//
// input tensor.
//
//	padding: The type of padding algorithm to use.
//
// Returns Gradients of gradients w.r.t. the input to `max_pool`.
func MaxPoolGradGradV2(scope *Scope, orig_input tf.Output, orig_output tf.Output, grad tf.Output, ksize tf.Output, strides tf.Output, padding string, optional ...MaxPoolGradGradV2Attr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MaxPoolGradGradV2",
		Input: []tf.Input{
			orig_input, orig_output, grad, ksize, strides,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MaxPoolGradGradWithArgmaxAttr is an optional argument to MaxPoolGradGradWithArgmax.
type MaxPoolGradGradWithArgmaxAttr func(optionalAttr)

// MaxPoolGradGradWithArgmaxIncludeBatchInIndex sets the optional include_batch_in_index attribute to value.
//
// value: Whether to include batch dimension in flattened index of `argmax`.
// If not specified, defaults to false
func MaxPoolGradGradWithArgmaxIncludeBatchInIndex(value bool) MaxPoolGradGradWithArgmaxAttr {
	return func(m optionalAttr) {
		m["include_batch_in_index"] = value
	}
}

// Computes second-order gradients of the maxpooling function.
//
// Arguments:
//
//	input: The original input.
//	grad: 4-D with shape `[batch, height, width, channels]`.  Gradients w.r.t. the
//
// input of `max_pool`.
//
//	argmax: The indices of the maximum values chosen for each output of `max_pool`.
//	ksize: The size of the window for each dimension of the input tensor.
//	strides: The stride of the sliding window for each dimension of the
//
// input tensor.
//
//	padding: The type of padding algorithm to use.
//
// Returns Gradients of gradients w.r.t. the input of `max_pool`.
func MaxPoolGradGradWithArgmax(scope *Scope, input tf.Output, grad tf.Output, argmax tf.Output, ksize []int64, strides []int64, padding string, optional ...MaxPoolGradGradWithArgmaxAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"ksize": ksize, "strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MaxPoolGradGradWithArgmax",
		Input: []tf.Input{
			input, grad, argmax,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MaxPoolGradV2Attr is an optional argument to MaxPoolGradV2.
type MaxPoolGradV2Attr func(optionalAttr)

// MaxPoolGradV2DataFormat sets the optional data_format attribute to value.
//
// value: Specify the data format of the input and output data. With the
// default format "NHWC", the data is stored in the order of:
//
//	[batch, in_height, in_width, in_channels].
//
// Alternatively, the format could be "NCHW", the data storage order of:
//
//	[batch, in_channels, in_height, in_width].
//
// If not specified, defaults to "NHWC"
func MaxPoolGradV2DataFormat(value string) MaxPoolGradV2Attr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Computes gradients of the maxpooling function.
//
// Arguments:
//
//	orig_input: The original input tensor.
//	orig_output: The original output tensor.
//	grad: 4-D.  Gradients w.r.t. the output of `max_pool`.
//	ksize: The size of the window for each dimension of the input tensor.
//	strides: The stride of the sliding window for each dimension of the
//
// input tensor.
//
//	padding: The type of padding algorithm to use.
//
// Returns Gradients w.r.t. the input to `max_pool`.
func MaxPoolGradV2(scope *Scope, orig_input tf.Output, orig_output tf.Output, grad tf.Output, ksize tf.Output, strides tf.Output, padding string, optional ...MaxPoolGradV2Attr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MaxPoolGradV2",
		Input: []tf.Input{
			orig_input, orig_output, grad, ksize, strides,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MaxPoolGradWithArgmaxAttr is an optional argument to MaxPoolGradWithArgmax.
type MaxPoolGradWithArgmaxAttr func(optionalAttr)

// MaxPoolGradWithArgmaxIncludeBatchInIndex sets the optional include_batch_in_index attribute to value.
//
// value: Whether to include batch dimension in flattened index of `argmax`.
// If not specified, defaults to false
func MaxPoolGradWithArgmaxIncludeBatchInIndex(value bool) MaxPoolGradWithArgmaxAttr {
	return func(m optionalAttr) {
		m["include_batch_in_index"] = value
	}
}

// Computes gradients of the maxpooling function.
//
// Arguments:
//
//	input: The original input.
//	grad: 4-D with shape `[batch, height, width, channels]`.  Gradients w.r.t. the
//
// output of `max_pool`.
//
//	argmax: The indices of the maximum values chosen for each output of `max_pool`.
//	ksize: The size of the window for each dimension of the input tensor.
//	strides: The stride of the sliding window for each dimension of the
//
// input tensor.
//
//	padding: The type of padding algorithm to use.
//
// Returns Gradients w.r.t. the input of `max_pool`.
func MaxPoolGradWithArgmax(scope *Scope, input tf.Output, grad tf.Output, argmax tf.Output, ksize []int64, strides []int64, padding string, optional ...MaxPoolGradWithArgmaxAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"ksize": ksize, "strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MaxPoolGradWithArgmax",
		Input: []tf.Input{
			input, grad, argmax,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MaxPoolV2Attr is an optional argument to MaxPoolV2.
type MaxPoolV2Attr func(optionalAttr)

// MaxPoolV2DataFormat sets the optional data_format attribute to value.
//
// value: Specify the data format of the input and output data. With the
// default format "NHWC", the data is stored in the order of:
//
//	[batch, in_height, in_width, in_channels].
//
// Alternatively, the format could be "NCHW", the data storage order of:
//
//	[batch, in_channels, in_height, in_width].
//
// If not specified, defaults to "NHWC"
func MaxPoolV2DataFormat(value string) MaxPoolV2Attr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Performs max pooling on the input.
//
// Arguments:
//
//	input: 4-D input to pool over.
//	ksize: The size of the window for each dimension of the input tensor.
//	strides: The stride of the sliding window for each dimension of the
//
// input tensor.
//
//	padding: The type of padding algorithm to use.
//
// Returns The max pooled output tensor.
func MaxPoolV2(scope *Scope, input tf.Output, ksize tf.Output, strides tf.Output, padding string, optional ...MaxPoolV2Attr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MaxPoolV2",
		Input: []tf.Input{
			input, ksize, strides,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MaxPoolWithArgmaxAttr is an optional argument to MaxPoolWithArgmax.
type MaxPoolWithArgmaxAttr func(optionalAttr)

// MaxPoolWithArgmaxTargmax sets the optional Targmax attribute to value.
// If not specified, defaults to DT_INT64
func MaxPoolWithArgmaxTargmax(value tf.DataType) MaxPoolWithArgmaxAttr {
	return func(m optionalAttr) {
		m["Targmax"] = value
	}
}

// MaxPoolWithArgmaxIncludeBatchInIndex sets the optional include_batch_in_index attribute to value.
//
// value: Whether to include batch dimension in flattened index of `argmax`.
// If not specified, defaults to false
func MaxPoolWithArgmaxIncludeBatchInIndex(value bool) MaxPoolWithArgmaxAttr {
	return func(m optionalAttr) {
		m["include_batch_in_index"] = value
	}
}

// Performs max pooling on the input and outputs both max values and indices.
//
// The indices in `argmax` are flattened, so that a maximum value at position
// `[b, y, x, c]` becomes flattened index:
// `(y * width + x) * channels + c` if `include_batch_in_index` is False;
// `((b * height + y) * width + x) * channels + c` if `include_batch_in_index` is True.
//
// The indices returned are always in `[0, height) x [0, width)` before flattening,
// even if padding is involved and the mathematically correct answer is outside
// (either negative or too large).  This is a bug, but fixing it is difficult to do
// in a safe backwards compatible way, especially due to flattening.
//
// Arguments:
//
//	input: 4-D with shape `[batch, height, width, channels]`.  Input to pool over.
//	ksize: The size of the window for each dimension of the input tensor.
//	strides: The stride of the sliding window for each dimension of the
//
// input tensor.
//
//	padding: The type of padding algorithm to use.
//
// Returns:
//
//	output: The max pooled output tensor.
//	argmax: 4-D.  The flattened indices of the max values chosen for each output.
func MaxPoolWithArgmax(scope *Scope, input tf.Output, ksize []int64, strides []int64, padding string, optional ...MaxPoolWithArgmaxAttr) (output tf.Output, argmax tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"ksize": ksize, "strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MaxPoolWithArgmax",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Returns the max of x and y (i.e. x > y ? x : y) element-wise.
//
// *NOTE*: `Maximum` supports broadcasting. More about broadcasting
// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
func Maximum(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Maximum",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MeanAttr is an optional argument to Mean.
type MeanAttr func(optionalAttr)

// MeanKeepDims sets the optional keep_dims attribute to value.
//
// value: If true, retain reduced dimensions with length 1.
// If not specified, defaults to false
func MeanKeepDims(value bool) MeanAttr {
	return func(m optionalAttr) {
		m["keep_dims"] = value
	}
}

// Computes the mean of elements across dimensions of a tensor.
//
// Reduces `input` along the dimensions given in `axis`. Unless
// `keep_dims` is true, the rank of the tensor is reduced by 1 for each entry in
// `axis`. If `keep_dims` is true, the reduced dimensions are
// retained with length 1.
//
// Arguments:
//
//	input: The tensor to reduce.
//	axis: The dimensions to reduce. Must be in the range
//
// `[-rank(input), rank(input))`.
//
// Returns The reduced tensor.
func Mean(scope *Scope, input tf.Output, axis tf.Output, optional ...MeanAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Mean",
		Input: []tf.Input{
			input, axis,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Forwards the value of an available tensor from `inputs` to `output`.
//
// `Merge` waits for at least one of the tensors in `inputs` to become available.
// It is usually combined with `Switch` to implement branching.
//
// `Merge` forwards the first tensor to become available to `output`, and sets
// `value_index` to its index in `inputs`.
//
// Arguments:
//
//	inputs: The input tensors, exactly one of which will become available.
//
// Returns:
//
//	output: Will be set to the available input tensor.
//	value_index: The index of the chosen input tensor in `inputs`.
func Merge(scope *Scope, inputs []tf.Output) (output tf.Output, value_index tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Merge",
		Input: []tf.Input{
			tf.OutputList(inputs),
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// MergeDedupDataAttr is an optional argument to MergeDedupData.
type MergeDedupDataAttr func(optionalAttr)

// MergeDedupDataConfig sets the optional config attribute to value.
// If not specified, defaults to ""
func MergeDedupDataConfig(value string) MergeDedupDataAttr {
	return func(m optionalAttr) {
		m["config"] = value
	}
}

// An op merges elements of integer and float tensors into deduplication data as
// XLA tuple.
//
// This op merges outputs of SplitDedupDataOp, which gives two 1-D tensors, integer
// and floating point. With respect to tuple_mask, this op merges values of these
// two tensors into an XLA tuple, which should be as same as input to
// SplitDedupDataOp.
//
// Arguments:
//
//	integer_tensor: A 1-D integer tensor, includes integer elements of deduplication data tuple.
//	float_tensor: A 1-D float tensor, includes float elements of deduplication data tuple.
//	tuple_mask: A serialized TensorProto string of output tuple mask. This mask is a 2-D tensor,
//
// with first column as tuple element type, and second column as span of this type.
// For example, an output tuple of (1, 2, 0.1, 3), its mask is [[0, 2], [1, 1], [0,
// 1]]. We expect only two types of elements: integer(0) and float(1).
//
// Returns An XLA tuple merging integer and float elements as deduplication data tuple.
func MergeDedupData(scope *Scope, integer_tensor tf.Output, float_tensor tf.Output, tuple_mask string, optional ...MergeDedupDataAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"tuple_mask": tuple_mask}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MergeDedupData",
		Input: []tf.Input{
			integer_tensor, float_tensor,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Merges summaries.
//
// This op creates a
// [`Summary`](https://www.tensorflow.org/code/tensorflow/core/framework/summary.proto)
// protocol buffer that contains the union of all the values in the input
// summaries.
//
// When the Op is run, it reports an `InvalidArgument` error if multiple values
// in the summaries to merge use the same tag.
//
// Arguments:
//
//	inputs: Can be of any shape.  Each must contain serialized `Summary` protocol
//
// buffers.
//
// Returns Scalar. Serialized `Summary` protocol buffer.
func MergeSummary(scope *Scope, inputs []tf.Output) (summary tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "MergeSummary",
		Input: []tf.Input{
			tf.OutputList(inputs),
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MergeV2CheckpointsAttr is an optional argument to MergeV2Checkpoints.
type MergeV2CheckpointsAttr func(optionalAttr)

// MergeV2CheckpointsDeleteOldDirs sets the optional delete_old_dirs attribute to value.
//
// value: see above.
// If not specified, defaults to true
func MergeV2CheckpointsDeleteOldDirs(value bool) MergeV2CheckpointsAttr {
	return func(m optionalAttr) {
		m["delete_old_dirs"] = value
	}
}

// MergeV2CheckpointsAllowMissingFiles sets the optional allow_missing_files attribute to value.
//
// value: see above.
// If not specified, defaults to false
func MergeV2CheckpointsAllowMissingFiles(value bool) MergeV2CheckpointsAttr {
	return func(m optionalAttr) {
		m["allow_missing_files"] = value
	}
}

// V2 format specific: merges the metadata files of sharded checkpoints.  The
//
// result is one logical checkpoint, with one physical metadata file and renamed
// data files.
//
// Intended for "grouping" multiple checkpoints in a sharded checkpoint setup.
//
// If delete_old_dirs is true, attempts to delete recursively the dirname of each
// path in the input checkpoint_prefixes.  This is useful when those paths are non
// user-facing temporary locations.
//
// If allow_missing_files is true, merges the checkpoint prefixes as long as
// at least one file exists. Otherwise, if no files exist, an error will be thrown.
// The default value for allow_missing_files is false.
//
// Arguments:
//
//	checkpoint_prefixes: prefixes of V2 checkpoints to merge.
//	destination_prefix: scalar.  The desired final prefix.  Allowed to be the same
//
// as one of the checkpoint_prefixes.
//
// Returns the created operation.
func MergeV2Checkpoints(scope *Scope, checkpoint_prefixes tf.Output, destination_prefix tf.Output, optional ...MergeV2CheckpointsAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MergeV2Checkpoints",
		Input: []tf.Input{
			checkpoint_prefixes, destination_prefix,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// MfccAttr is an optional argument to Mfcc.
type MfccAttr func(optionalAttr)

// MfccUpperFrequencyLimit sets the optional upper_frequency_limit attribute to value.
//
// value: The highest frequency to use when calculating the
// ceptstrum.
// If not specified, defaults to 4000
func MfccUpperFrequencyLimit(value float32) MfccAttr {
	return func(m optionalAttr) {
		m["upper_frequency_limit"] = value
	}
}

// MfccLowerFrequencyLimit sets the optional lower_frequency_limit attribute to value.
//
// value: The lowest frequency to use when calculating the
// ceptstrum.
// If not specified, defaults to 20
func MfccLowerFrequencyLimit(value float32) MfccAttr {
	return func(m optionalAttr) {
		m["lower_frequency_limit"] = value
	}
}

// MfccFilterbankChannelCount sets the optional filterbank_channel_count attribute to value.
//
// value: Resolution of the Mel bank used internally.
// If not specified, defaults to 40
func MfccFilterbankChannelCount(value int64) MfccAttr {
	return func(m optionalAttr) {
		m["filterbank_channel_count"] = value
	}
}

// MfccDctCoefficientCount sets the optional dct_coefficient_count attribute to value.
//
// value: How many output channels to produce per time slice.
// If not specified, defaults to 13
func MfccDctCoefficientCount(value int64) MfccAttr {
	return func(m optionalAttr) {
		m["dct_coefficient_count"] = value
	}
}

// Transforms a spectrogram into a form that's useful for speech recognition.
//
// Mel Frequency Cepstral Coefficients are a way of representing audio data that's
// been effective as an input feature for machine learning. They are created by
// taking the spectrum of a spectrogram (a 'cepstrum'), and discarding some of the
// higher frequencies that are less significant to the human ear. They have a long
// history in the speech recognition world, and https://en.wikipedia.org/wiki/Mel-frequency_cepstrum
// is a good resource to learn more.
//
// Arguments:
//
//	spectrogram: Typically produced by the Spectrogram op, with magnitude_squared
//
// set to true.
//
//	sample_rate: How many samples per second the source audio used.
func Mfcc(scope *Scope, spectrogram tf.Output, sample_rate tf.Output, optional ...MfccAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Mfcc",
		Input: []tf.Input{
			spectrogram, sample_rate,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MinAttr is an optional argument to Min.
type MinAttr func(optionalAttr)

// MinKeepDims sets the optional keep_dims attribute to value.
//
// value: If true, retain reduced dimensions with length 1.
// If not specified, defaults to false
func MinKeepDims(value bool) MinAttr {
	return func(m optionalAttr) {
		m["keep_dims"] = value
	}
}

// Computes the minimum of elements across dimensions of a tensor.
//
// Reduces `input` along the dimensions given in `axis`. Unless
// `keep_dims` is true, the rank of the tensor is reduced by 1 for each entry in
// `axis`. If `keep_dims` is true, the reduced dimensions are
// retained with length 1.
//
// Arguments:
//
//	input: The tensor to reduce.
//	axis: The dimensions to reduce. Must be in the range
//
// `[-rank(input), rank(input))`.
//
// Returns The reduced tensor.
func Min(scope *Scope, input tf.Output, axis tf.Output, optional ...MinAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Min",
		Input: []tf.Input{
			input, axis,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the min of x and y (i.e. x < y ? x : y) element-wise.
//
// *NOTE*: `Minimum` supports broadcasting. More about broadcasting
// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
func Minimum(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Minimum",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Pads a tensor with mirrored values.
//
// This operation pads a `input` with mirrored values according to the `paddings`
// you specify. `paddings` is an integer tensor with shape `[n, 2]`, where n is
// the rank of `input`. For each dimension D of `input`, `paddings[D, 0]` indicates
// how many values to add before the contents of `input` in that dimension, and
// `paddings[D, 1]` indicates how many values to add after the contents of `input`
// in that dimension. Both `paddings[D, 0]` and `paddings[D, 1]` must be no greater
// than `input.dim_size(D)` (or `input.dim_size(D) - 1`) if `copy_border` is true
// (if false, respectively).
//
// The padded size of each dimension D of the output is:
//
// `paddings(D, 0) + input.dim_size(D) + paddings(D, 1)`
//
// For example:
//
// ```
// # 't' is [[1, 2, 3], [4, 5, 6]].
// # 'paddings' is [[1, 1]], [2, 2]].
// # 'mode' is SYMMETRIC.
// # rank of 't' is 2.
// pad(t, paddings) ==> [[2, 1, 1, 2, 3, 3, 2]
//
//	[2, 1, 1, 2, 3, 3, 2]
//	[5, 4, 4, 5, 6, 6, 5]
//	[5, 4, 4, 5, 6, 6, 5]]
//
// ```
//
// Arguments:
//
//	input: The input tensor to be padded.
//	paddings: A two-column matrix specifying the padding sizes. The number of
//
// rows must be the same as the rank of `input`.
//
//	mode: Either `REFLECT` or `SYMMETRIC`. In reflect mode the padded regions
//
// do not include the borders, while in symmetric mode the padded regions
// do include the borders. For example, if `input` is `[1, 2, 3]` and `paddings`
// is `[0, 2]`, then the output is `[1, 2, 3, 2, 1]` in reflect mode, and
// it is `[1, 2, 3, 3, 2]` in symmetric mode.
//
// Returns The padded tensor.
func MirrorPad(scope *Scope, input tf.Output, paddings tf.Output, mode string) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"mode": mode}
	opspec := tf.OpSpec{
		Type: "MirrorPad",
		Input: []tf.Input{
			input, paddings,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Gradient op for `MirrorPad` op. This op folds a mirror-padded tensor.
//
// This operation folds the padded areas of `input` by `MirrorPad` according to the
// `paddings` you specify. `paddings` must be the same as `paddings` argument
// given to the corresponding `MirrorPad` op.
//
// The folded size of each dimension D of the output is:
//
// `input.dim_size(D) - paddings(D, 0) - paddings(D, 1)`
//
// For example:
//
// ```
// # 't' is [[1, 2, 3], [4, 5, 6], [7, 8, 9]].
// # 'paddings' is [[0, 1]], [0, 1]].
// # 'mode' is SYMMETRIC.
// # rank of 't' is 2.
// pad(t, paddings) ==> [[ 1,  5]
//
//	[11, 28]]
//
// ```
//
// Arguments:
//
//	input: The input tensor to be folded.
//	paddings: A two-column matrix specifying the padding sizes. The number of
//
// rows must be the same as the rank of `input`.
//
//	mode: The mode used in the `MirrorPad` op.
//
// Returns The folded tensor.
func MirrorPadGrad(scope *Scope, input tf.Output, paddings tf.Output, mode string) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"mode": mode}
	opspec := tf.OpSpec{
		Type: "MirrorPadGrad",
		Input: []tf.Input{
			input, paddings,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Wraps an arbitrary MLIR computation expressed as a module with a main() function.
//
// This operation does not have an associated kernel and is not intended to be
// executed in a regular TensorFlow session. Instead it is intended to be used for
// testing or for special case where a user intends to pass custom MLIR computation
// through a TensorFlow graph with the intent of having custom tooling processing
// it downstream (when targeting a different environment, like TensorFlow lite for
// example).
// The MLIR module is expected to have a main() function that will be used as an
// entry point. The inputs to the operations will be passed as argument to the
// main() function and the returned values of the main function mapped to the
// outputs.
// Example usage:
//
// ```
// import tensorflow as tf
// from tensorflow.compiler.mlir.tensorflow.gen_mlir_passthrough_op import mlir_passthrough_op
//
// mlir_module = ”'python
//
//	func @main(%arg0 : tensor<10xf32>, %arg1 : tensor<10xf32>) -> tensor<10x10xf32> {
//	   %add = "magic.op"(%arg0, %arg1) : (tensor<10xf32>, tensor<10xf32>) -> tensor<10x10xf32>
//	   return %ret : tensor<10x10xf32>
//	}
//
// ”'
//
// @tf.function
// def foo(x, y):
//
//	return mlir_passthrough_op([x, y], mlir_module, Toutputs=[tf.float32])
//
// graph_def = foo.get_concrete_function(tf.TensorSpec([10], tf.float32), tf.TensorSpec([10], tf.float32)).graph.as_graph_def()
// ```
func MlirPassthroughOp(scope *Scope, inputs []tf.Output, mlir_module string, Toutputs []tf.DataType) (outputs []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"mlir_module": mlir_module, "Toutputs": Toutputs}
	opspec := tf.OpSpec{
		Type: "MlirPassthroughOp",
		Input: []tf.Input{
			tf.OutputList(inputs),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if outputs, idx, err = makeOutputList(op, idx, "outputs"); err != nil {
		scope.UpdateErr("MlirPassthroughOp", err)
		return
	}
	return outputs
}

// Returns element-wise remainder of division. This emulates C semantics in that
//
// the result here is consistent with a truncating divide. E.g.
// `tf.truncatediv(x, y) * y + truncate_mod(x, y) = x`.
//
// *NOTE*: `Mod` supports broadcasting. More about broadcasting
// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
func Mod(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Mod",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ModelDatasetAttr is an optional argument to ModelDataset.
type ModelDatasetAttr func(optionalAttr)

// ModelDatasetAlgorithm sets the optional algorithm attribute to value.
// If not specified, defaults to 0
func ModelDatasetAlgorithm(value int64) ModelDatasetAttr {
	return func(m optionalAttr) {
		m["algorithm"] = value
	}
}

// ModelDatasetCpuBudget sets the optional cpu_budget attribute to value.
// If not specified, defaults to 0
func ModelDatasetCpuBudget(value int64) ModelDatasetAttr {
	return func(m optionalAttr) {
		m["cpu_budget"] = value
	}
}

// ModelDatasetRamBudget sets the optional ram_budget attribute to value.
// If not specified, defaults to 0
func ModelDatasetRamBudget(value int64) ModelDatasetAttr {
	return func(m optionalAttr) {
		m["ram_budget"] = value
	}
}

// Identity transformation that models performance.
//
// Identity transformation that models performance.
//
// Arguments:
//
//	input_dataset: A variant tensor representing the input dataset.
func ModelDataset(scope *Scope, input_dataset tf.Output, output_types []tf.DataType, output_shapes []tf.Shape, optional ...ModelDatasetAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ModelDataset",
		Input: []tf.Input{
			input_dataset,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns x * y element-wise.
//
// *NOTE*: `Multiply` supports broadcasting. More about broadcasting
// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
func Mul(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Mul",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns x * y element-wise. Returns zero if y is zero, even if x if infinite or NaN.
//
// *NOTE*: `MulNoNan` supports broadcasting. More about broadcasting
// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
func MulNoNan(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "MulNoNan",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates a MultiDeviceIterator resource.
//
// Arguments:
//
//	devices: A list of devices the iterator works across.
//	shared_name: If non-empty, this resource will be shared under the given name
//
// across multiple sessions.
//
//	container: If non-empty, this resource is placed in the given container.
//
// Otherwise, a default container is used.
//
//	output_types: The type list for the return values.
//	output_shapes: The list of shapes being produced.
//
// Returns Handle to the resource created.
func MultiDeviceIterator(scope *Scope, devices []string, shared_name string, container string, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"devices": devices, "shared_name": shared_name, "container": container, "output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "MultiDeviceIterator",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MultiDeviceIteratorFromStringHandleAttr is an optional argument to MultiDeviceIteratorFromStringHandle.
type MultiDeviceIteratorFromStringHandleAttr func(optionalAttr)

// MultiDeviceIteratorFromStringHandleOutputTypes sets the optional output_types attribute to value.
//
// value: The type list for the return values.
// If not specified, defaults to {}
//
// REQUIRES: len(value) >= 0
func MultiDeviceIteratorFromStringHandleOutputTypes(value []tf.DataType) MultiDeviceIteratorFromStringHandleAttr {
	return func(m optionalAttr) {
		m["output_types"] = value
	}
}

// MultiDeviceIteratorFromStringHandleOutputShapes sets the optional output_shapes attribute to value.
//
// value: The list of shapes being produced.
// If not specified, defaults to {}
//
// REQUIRES: len(value) >= 0
func MultiDeviceIteratorFromStringHandleOutputShapes(value []tf.Shape) MultiDeviceIteratorFromStringHandleAttr {
	return func(m optionalAttr) {
		m["output_shapes"] = value
	}
}

// Generates a MultiDeviceIterator resource from its provided string handle.
//
// Arguments:
//
//	string_handle: String representing the resource.
//
// Returns A MultiDeviceIterator resource.
func MultiDeviceIteratorFromStringHandle(scope *Scope, string_handle tf.Output, optional ...MultiDeviceIteratorFromStringHandleAttr) (multi_device_iterator tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MultiDeviceIteratorFromStringHandle",
		Input: []tf.Input{
			string_handle,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Gets next element for the provided shard number.
//
// Arguments:
//
//	multi_device_iterator: A MultiDeviceIterator resource.
//	shard_num: Integer representing which shard to fetch data for.
//	incarnation_id: Which incarnation of the MultiDeviceIterator is running.
//	output_types: The type list for the return values.
//	output_shapes: The list of shapes being produced.
//
// Returns Result of the get_next on the dataset.
func MultiDeviceIteratorGetNextFromShard(scope *Scope, multi_device_iterator tf.Output, shard_num tf.Output, incarnation_id tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (components []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "MultiDeviceIteratorGetNextFromShard",
		Input: []tf.Input{
			multi_device_iterator, shard_num, incarnation_id,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if components, idx, err = makeOutputList(op, idx, "components"); err != nil {
		scope.UpdateErr("MultiDeviceIteratorGetNextFromShard", err)
		return
	}
	return components
}

// Initializes the multi device iterator with the given dataset.
//
// Arguments:
//
//	dataset: Dataset to be iterated upon.
//	multi_device_iterator: A MultiDeviceIteratorResource.
//	max_buffer_size: The maximum size of the host side per device buffer to keep.
//
// Returns An int64 indicating which incarnation of the MultiDeviceIterator
// is running.
func MultiDeviceIteratorInit(scope *Scope, dataset tf.Output, multi_device_iterator tf.Output, max_buffer_size tf.Output) (incarnation_id tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "MultiDeviceIteratorInit",
		Input: []tf.Input{
			dataset, multi_device_iterator, max_buffer_size,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Produces a string handle for the given MultiDeviceIterator.
//
// Arguments:
//
//	multi_device_iterator: A MultiDeviceIterator resource.
//
// Returns A string representing the resource.
func MultiDeviceIteratorToStringHandle(scope *Scope, multi_device_iterator tf.Output) (string_handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "MultiDeviceIteratorToStringHandle",
		Input: []tf.Input{
			multi_device_iterator,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MultinomialAttr is an optional argument to Multinomial.
type MultinomialAttr func(optionalAttr)

// MultinomialSeed sets the optional seed attribute to value.
//
// value: If either seed or seed2 is set to be non-zero, the internal random number
// generator is seeded by the given seed.  Otherwise, a random seed is used.
// If not specified, defaults to 0
func MultinomialSeed(value int64) MultinomialAttr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// MultinomialSeed2 sets the optional seed2 attribute to value.
//
// value: A second seed to avoid seed collision.
// If not specified, defaults to 0
func MultinomialSeed2(value int64) MultinomialAttr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// MultinomialOutputDtype sets the optional output_dtype attribute to value.
// If not specified, defaults to DT_INT64
func MultinomialOutputDtype(value tf.DataType) MultinomialAttr {
	return func(m optionalAttr) {
		m["output_dtype"] = value
	}
}

// Draws samples from a multinomial distribution.
//
// Arguments:
//
//	logits: 2-D Tensor with shape `[batch_size, num_classes]`.  Each slice `[i, :]`
//
// represents the unnormalized log probabilities for all classes.
//
//	num_samples: 0-D.  Number of independent samples to draw for each row slice.
//
// Returns 2-D Tensor with shape `[batch_size, num_samples]`.  Each slice `[i, :]`
// contains the drawn class labels with range `[0, num_classes)`.
func Multinomial(scope *Scope, logits tf.Output, num_samples tf.Output, optional ...MultinomialAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Multinomial",
		Input: []tf.Input{
			logits, num_samples,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MutableDenseHashTableV2Attr is an optional argument to MutableDenseHashTableV2.
type MutableDenseHashTableV2Attr func(optionalAttr)

// MutableDenseHashTableV2Container sets the optional container attribute to value.
//
// value: If non-empty, this table is placed in the given container.
// Otherwise, a default container is used.
// If not specified, defaults to ""
func MutableDenseHashTableV2Container(value string) MutableDenseHashTableV2Attr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// MutableDenseHashTableV2SharedName sets the optional shared_name attribute to value.
//
// value: If non-empty, this table is shared under the given name across
// multiple sessions.
// If not specified, defaults to ""
func MutableDenseHashTableV2SharedName(value string) MutableDenseHashTableV2Attr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// MutableDenseHashTableV2UseNodeNameSharing sets the optional use_node_name_sharing attribute to value.
// If not specified, defaults to false
func MutableDenseHashTableV2UseNodeNameSharing(value bool) MutableDenseHashTableV2Attr {
	return func(m optionalAttr) {
		m["use_node_name_sharing"] = value
	}
}

// MutableDenseHashTableV2ValueShape sets the optional value_shape attribute to value.
//
// value: The shape of each value.
// If not specified, defaults to {}
func MutableDenseHashTableV2ValueShape(value tf.Shape) MutableDenseHashTableV2Attr {
	return func(m optionalAttr) {
		m["value_shape"] = value
	}
}

// MutableDenseHashTableV2InitialNumBuckets sets the optional initial_num_buckets attribute to value.
//
// value: The initial number of hash table buckets. Must be a power
// to 2.
// If not specified, defaults to 131072
func MutableDenseHashTableV2InitialNumBuckets(value int64) MutableDenseHashTableV2Attr {
	return func(m optionalAttr) {
		m["initial_num_buckets"] = value
	}
}

// MutableDenseHashTableV2MaxLoadFactor sets the optional max_load_factor attribute to value.
//
// value: The maximum ratio between number of entries and number of
// buckets before growing the table. Must be between 0 and 1.
// If not specified, defaults to 0.8
func MutableDenseHashTableV2MaxLoadFactor(value float32) MutableDenseHashTableV2Attr {
	return func(m optionalAttr) {
		m["max_load_factor"] = value
	}
}

// Creates an empty hash table that uses tensors as the backing store.
//
// It uses "open addressing" with quadratic reprobing to resolve
// collisions.
//
// This op creates a mutable hash table, specifying the type of its keys and
// values. Each value must be a scalar. Data can be inserted into the table using
// the insert operations. It does not support the initialization operation.
//
// Arguments:
//
//	empty_key: The key used to represent empty key buckets internally. Must not
//
// be used in insert or lookup operations.
//
//	value_dtype: Type of the table values.
//
// Returns Handle to a table.
func MutableDenseHashTableV2(scope *Scope, empty_key tf.Output, deleted_key tf.Output, value_dtype tf.DataType, optional ...MutableDenseHashTableV2Attr) (table_handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"value_dtype": value_dtype}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MutableDenseHashTableV2",
		Input: []tf.Input{
			empty_key, deleted_key,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MutableHashTableOfTensorsV2Attr is an optional argument to MutableHashTableOfTensorsV2.
type MutableHashTableOfTensorsV2Attr func(optionalAttr)

// MutableHashTableOfTensorsV2Container sets the optional container attribute to value.
//
// value: If non-empty, this table is placed in the given container.
// Otherwise, a default container is used.
// If not specified, defaults to ""
func MutableHashTableOfTensorsV2Container(value string) MutableHashTableOfTensorsV2Attr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// MutableHashTableOfTensorsV2SharedName sets the optional shared_name attribute to value.
//
// value: If non-empty, this table is shared under the given name across
// multiple sessions.
// If not specified, defaults to ""
func MutableHashTableOfTensorsV2SharedName(value string) MutableHashTableOfTensorsV2Attr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// MutableHashTableOfTensorsV2UseNodeNameSharing sets the optional use_node_name_sharing attribute to value.
// If not specified, defaults to false
func MutableHashTableOfTensorsV2UseNodeNameSharing(value bool) MutableHashTableOfTensorsV2Attr {
	return func(m optionalAttr) {
		m["use_node_name_sharing"] = value
	}
}

// MutableHashTableOfTensorsV2ValueShape sets the optional value_shape attribute to value.
// If not specified, defaults to {}
func MutableHashTableOfTensorsV2ValueShape(value tf.Shape) MutableHashTableOfTensorsV2Attr {
	return func(m optionalAttr) {
		m["value_shape"] = value
	}
}

// Creates an empty hash table.
//
// This op creates a mutable hash table, specifying the type of its keys and
// values. Each value must be a vector. Data can be inserted into the table using
// the insert operations. It does not support the initialization operation.
//
// Arguments:
//
//	key_dtype: Type of the table keys.
//	value_dtype: Type of the table values.
//
// Returns Handle to a table.
func MutableHashTableOfTensorsV2(scope *Scope, key_dtype tf.DataType, value_dtype tf.DataType, optional ...MutableHashTableOfTensorsV2Attr) (table_handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"key_dtype": key_dtype, "value_dtype": value_dtype}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MutableHashTableOfTensorsV2",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MutableHashTableV2Attr is an optional argument to MutableHashTableV2.
type MutableHashTableV2Attr func(optionalAttr)

// MutableHashTableV2Container sets the optional container attribute to value.
//
// value: If non-empty, this table is placed in the given container.
// Otherwise, a default container is used.
// If not specified, defaults to ""
func MutableHashTableV2Container(value string) MutableHashTableV2Attr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// MutableHashTableV2SharedName sets the optional shared_name attribute to value.
//
// value: If non-empty, this table is shared under the given name across
// multiple sessions.
// If not specified, defaults to ""
func MutableHashTableV2SharedName(value string) MutableHashTableV2Attr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// MutableHashTableV2UseNodeNameSharing sets the optional use_node_name_sharing attribute to value.
//
// value: If true and shared_name is empty, the table is shared
// using the node name.
// If not specified, defaults to false
func MutableHashTableV2UseNodeNameSharing(value bool) MutableHashTableV2Attr {
	return func(m optionalAttr) {
		m["use_node_name_sharing"] = value
	}
}

// Creates an empty hash table.
//
// This op creates a mutable hash table, specifying the type of its keys and
// values. Each value must be a scalar. Data can be inserted into the table using
// the insert operations. It does not support the initialization operation.
//
// Arguments:
//
//	key_dtype: Type of the table keys.
//	value_dtype: Type of the table values.
//
// Returns Handle to a table.
func MutableHashTableV2(scope *Scope, key_dtype tf.DataType, value_dtype tf.DataType, optional ...MutableHashTableV2Attr) (table_handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"key_dtype": key_dtype, "value_dtype": value_dtype}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MutableHashTableV2",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Locks a mutex resource.  The output is the lock.  So long as the lock tensor
//
// is alive, any other request to use `MutexLock` with this mutex will wait.
//
// This is particularly useful for creating a critical section when used in
// conjunction with `MutexLockIdentity`:
//
// ```python
//
// mutex = mutex_v2(
//
//	shared_name=handle_name, container=container, name=name)
//
// def execute_in_critical_section(fn, *args, **kwargs):
//
//	lock = gen_resource_variable_ops.mutex_lock(mutex)
//
//	with ops.control_dependencies([lock]):
//	  r = fn(*args, **kwargs)
//
//	with ops.control_dependencies(nest.flatten(r)):
//	  with ops.colocate_with(mutex):
//	    ensure_lock_exists = mutex_lock_identity(lock)
//
//	  # Make sure that if any element of r is accessed, all of
//	  # them are executed together.
//	  r = nest.map_structure(tf.identity, r)
//
//	with ops.control_dependencies([ensure_lock_exists]):
//	  return nest.map_structure(tf.identity, r)
//
// ```
//
// While `fn` is running in the critical section, no other functions which wish to
// use this critical section may run.
//
// Often the use case is that two executions of the same graph, in parallel,
// wish to run `fn`; and we wish to ensure that only one of them executes
// at a time.  This is especially important if `fn` modifies one or more
// variables at a time.
//
// It is also useful if two separate functions must share a resource, but we
// wish to ensure the usage is exclusive.
//
// Arguments:
//
//	mutex: The mutex resource to lock.
//
// Returns A tensor that keeps a shared pointer to a lock on the mutex;
// when the Tensor is destroyed, the use count on the shared pointer is decreased
// by 1.  When it reaches 0, the lock is released.
func MutexLock(scope *Scope, mutex tf.Output) (mutex_lock tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "MutexLock",
		Input: []tf.Input{
			mutex,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MutexV2Attr is an optional argument to MutexV2.
type MutexV2Attr func(optionalAttr)

// MutexV2Container sets the optional container attribute to value.
//
// value: If non-empty, this variable is placed in the given container.
// Otherwise, a default container is used.
// If not specified, defaults to ""
func MutexV2Container(value string) MutexV2Attr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// MutexV2SharedName sets the optional shared_name attribute to value.
//
// value: If non-empty, this variable is named in the given bucket
// with this shared_name. Otherwise, the node name is used instead.
// If not specified, defaults to ""
func MutexV2SharedName(value string) MutexV2Attr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Creates a Mutex resource that can be locked by `MutexLock`.
//
// Returns The mutex resource.
func MutexV2(scope *Scope, optional ...MutexV2Attr) (resource tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MutexV2",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Outputs a tensor containing the reduction across all input tensors.
//
// Outputs a tensor containing the reduction across all input tensors passed to ops
// within the same `shared_name.
//
// The graph should be constructed so if one op runs with shared_name value `c`,
// then `num_devices` ops will run with shared_name value `c`.  Failure to do so
// will cause the graph execution to fail to complete.
//
// input: the input to the reduction
// data: the value of the reduction across all `num_devices` devices.
// reduction: the reduction operation to perform.
// num_devices: The number of devices participating in this reduction.
// shared_name: Identifier that shared between ops of the same reduction.
func NcclAllReduce(scope *Scope, input tf.Output, reduction string, num_devices int64, shared_name string) (data tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"reduction": reduction, "num_devices": num_devices, "shared_name": shared_name}
	opspec := tf.OpSpec{
		Type: "NcclAllReduce",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Sends `input` to all devices that are connected to the output.
//
// Sends `input` to all devices that are connected to the output.
//
// The graph should be constructed so that all ops connected to the output have a
// valid device assignment, and the op itself is assigned one of these devices.
//
// input: The input to the broadcast.
// output: The same as input.
// shape: The shape of the input tensor.
func NcclBroadcast(scope *Scope, input tf.Output, shape tf.Shape) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"shape": shape}
	opspec := tf.OpSpec{
		Type: "NcclBroadcast",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Reduces `input` from `num_devices` using `reduction` to a single device.
//
// Reduces `input` from `num_devices` using `reduction` to a single device.
//
// The graph should be constructed so that all inputs have a valid device
// assignment, and the op itself is assigned one of these devices.
//
// input: The input to the reduction.
// data: the value of the reduction across all `num_devices` devices.
// reduction: the reduction operation to perform.
func NcclReduce(scope *Scope, input []tf.Output, reduction string) (data tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"reduction": reduction}
	opspec := tf.OpSpec{
		Type: "NcclReduce",
		Input: []tf.Input{
			tf.OutputList(input),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Selects the k nearest centers for each point.
//
// Rows of points are assumed to be input points. Rows of centers are assumed to be
// the list of candidate centers. For each point, the k centers that have least L2
// distance to it are computed.
//
// Arguments:
//
//	points: Matrix of shape (n, d). Rows are assumed to be input points.
//	centers: Matrix of shape (m, d). Rows are assumed to be centers.
//	k: Number of nearest centers to return for each point. If k is larger than m, then
//
// only m centers are returned.
//
// Returns:
//
//	nearest_center_indices: Matrix of shape (n, min(m, k)). Each row contains the indices of the centers
//
// closest to the corresponding point, ordered by increasing distance.
//
//	nearest_center_distances: Matrix of shape (n, min(m, k)). Each row contains the squared L2 distance to the
//
// corresponding center in nearest_center_indices.
func NearestNeighbors(scope *Scope, points tf.Output, centers tf.Output, k tf.Output) (nearest_center_indices tf.Output, nearest_center_distances tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "NearestNeighbors",
		Input: []tf.Input{
			points, centers, k,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Computes numerical negative value element-wise.
//
// I.e., \\(y = -x\\).
func Neg(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Neg",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the next representable value of `x1` in the direction of `x2`, element-wise.
//
// This operation returns the same result as the C++ std::nextafter function.
//
// It can also return a subnormal number.
//
// @compatibility(cpp)
// Equivalent to C++ std::nextafter function.
// @end_compatibility
func NextAfter(scope *Scope, x1 tf.Output, x2 tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "NextAfter",
		Input: []tf.Input{
			x1, x2,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Makes its input available to the next iteration.
//
// Arguments:
//
//	data: The tensor to be made available to the next iteration.
//
// Returns The same tensor as `data`.
func NextIteration(scope *Scope, data tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "NextIteration",
		Input: []tf.Input{
			data,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Does nothing. Only useful as a placeholder for control edges.
//
// Returns the created operation.
func NoOp(scope *Scope) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "NoOp",
	}
	return scope.AddOperation(opspec)
}

// NonDeterministicIntsAttr is an optional argument to NonDeterministicInts.
type NonDeterministicIntsAttr func(optionalAttr)

// NonDeterministicIntsDtype sets the optional dtype attribute to value.
//
// value: The type of the output.
// If not specified, defaults to DT_INT64
func NonDeterministicIntsDtype(value tf.DataType) NonDeterministicIntsAttr {
	return func(m optionalAttr) {
		m["dtype"] = value
	}
}

// Non-deterministically generates some integers.
//
// This op may use some OS-provided source of non-determinism (e.g. an RNG), so each execution will give different results.
//
// Arguments:
//
//	shape: The shape of the output tensor.
//
// Returns Non-deterministic integer values with specified shape.
func NonDeterministicInts(scope *Scope, shape tf.Output, optional ...NonDeterministicIntsAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "NonDeterministicInts",
		Input: []tf.Input{
			shape,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// NonMaxSuppressionAttr is an optional argument to NonMaxSuppression.
type NonMaxSuppressionAttr func(optionalAttr)

// NonMaxSuppressionIouThreshold sets the optional iou_threshold attribute to value.
//
// value: A float representing the threshold for deciding whether boxes
// overlap too much with respect to IOU.
// If not specified, defaults to 0.5
func NonMaxSuppressionIouThreshold(value float32) NonMaxSuppressionAttr {
	return func(m optionalAttr) {
		m["iou_threshold"] = value
	}
}

// Greedily selects a subset of bounding boxes in descending order of score,
//
// pruning away boxes that have high intersection-over-union (IOU) overlap
// with previously selected boxes.  Bounding boxes are supplied as
// [y1, x1, y2, x2], where (y1, x1) and (y2, x2) are the coordinates of any
// diagonal pair of box corners and the coordinates can be provided as normalized
// (i.e., lying in the interval [0, 1]) or absolute.  Note that this algorithm
// is agnostic to where the origin is in the coordinate system.  Note that this
// algorithm is invariant to orthogonal transformations and translations
// of the coordinate system; thus translating or reflections of the coordinate
// system result in the same boxes being selected by the algorithm.
// The output of this operation is a set of integers indexing into the input
// collection of bounding boxes representing the selected boxes.  The bounding
// box coordinates corresponding to the selected indices can then be obtained
// using the `tf.gather operation`.  For example:
//
//	selected_indices = tf.image.non_max_suppression(
//	    boxes, scores, max_output_size, iou_threshold)
//	selected_boxes = tf.gather(boxes, selected_indices)
//
// Arguments:
//
//	boxes: A 2-D float tensor of shape `[num_boxes, 4]`.
//	scores: A 1-D float tensor of shape `[num_boxes]` representing a single
//
// score corresponding to each box (each row of boxes).
//
//	max_output_size: A scalar integer tensor representing the maximum number of
//
// boxes to be selected by non max suppression.
//
// Returns A 1-D integer tensor of shape `[M]` representing the selected
// indices from the boxes tensor, where `M <= max_output_size`.
func NonMaxSuppression(scope *Scope, boxes tf.Output, scores tf.Output, max_output_size tf.Output, optional ...NonMaxSuppressionAttr) (selected_indices tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "NonMaxSuppression",
		Input: []tf.Input{
			boxes, scores, max_output_size,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Greedily selects a subset of bounding boxes in descending order of score,
//
// pruning away boxes that have high intersection-over-union (IOU) overlap
// with previously selected boxes.  Bounding boxes are supplied as
// [y1, x1, y2, x2], where (y1, x1) and (y2, x2) are the coordinates of any
// diagonal pair of box corners and the coordinates can be provided as normalized
// (i.e., lying in the interval [0, 1]) or absolute.  Note that this algorithm
// is agnostic to where the origin is in the coordinate system.  Note that this
// algorithm is invariant to orthogonal transformations and translations
// of the coordinate system; thus translating or reflections of the coordinate
// system result in the same boxes being selected by the algorithm.
//
// The output of this operation is a set of integers indexing into the input
// collection of bounding boxes representing the selected boxes.  The bounding
// box coordinates corresponding to the selected indices can then be obtained
// using the `tf.gather operation`.  For example:
//
//	selected_indices = tf.image.non_max_suppression_v2(
//	    boxes, scores, max_output_size, iou_threshold)
//	selected_boxes = tf.gather(boxes, selected_indices)
//
// Arguments:
//
//	boxes: A 2-D float tensor of shape `[num_boxes, 4]`.
//	scores: A 1-D float tensor of shape `[num_boxes]` representing a single
//
// score corresponding to each box (each row of boxes).
//
//	max_output_size: A scalar integer tensor representing the maximum number of
//
// boxes to be selected by non max suppression.
//
//	iou_threshold: A 0-D float tensor representing the threshold for deciding whether
//
// boxes overlap too much with respect to IOU.
//
// Returns A 1-D integer tensor of shape `[M]` representing the selected
// indices from the boxes tensor, where `M <= max_output_size`.
func NonMaxSuppressionV2(scope *Scope, boxes tf.Output, scores tf.Output, max_output_size tf.Output, iou_threshold tf.Output) (selected_indices tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "NonMaxSuppressionV2",
		Input: []tf.Input{
			boxes, scores, max_output_size, iou_threshold,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Greedily selects a subset of bounding boxes in descending order of score,
//
// pruning away boxes that have high intersection-over-union (IOU) overlap
// with previously selected boxes.  Bounding boxes with score less than
// `score_threshold` are removed.  Bounding boxes are supplied as
// [y1, x1, y2, x2], where (y1, x1) and (y2, x2) are the coordinates of any
// diagonal pair of box corners and the coordinates can be provided as normalized
// (i.e., lying in the interval [0, 1]) or absolute.  Note that this algorithm
// is agnostic to where the origin is in the coordinate system and more
// generally is invariant to orthogonal transformations and translations
// of the coordinate system; thus translating or reflections of the coordinate
// system result in the same boxes being selected by the algorithm.
// The output of this operation is a set of integers indexing into the input
// collection of bounding boxes representing the selected boxes.  The bounding
// box coordinates corresponding to the selected indices can then be obtained
// using the `tf.gather operation`.  For example:
//
//	selected_indices = tf.image.non_max_suppression_v2(
//	    boxes, scores, max_output_size, iou_threshold, score_threshold)
//	selected_boxes = tf.gather(boxes, selected_indices)
//
// Arguments:
//
//	boxes: A 2-D float tensor of shape `[num_boxes, 4]`.
//	scores: A 1-D float tensor of shape `[num_boxes]` representing a single
//
// score corresponding to each box (each row of boxes).
//
//	max_output_size: A scalar integer tensor representing the maximum number of
//
// boxes to be selected by non max suppression.
//
//	iou_threshold: A 0-D float tensor representing the threshold for deciding whether
//
// boxes overlap too much with respect to IOU.
//
//	score_threshold: A 0-D float tensor representing the threshold for deciding when to remove
//
// boxes based on score.
//
// Returns A 1-D integer tensor of shape `[M]` representing the selected
// indices from the boxes tensor, where `M <= max_output_size`.
func NonMaxSuppressionV3(scope *Scope, boxes tf.Output, scores tf.Output, max_output_size tf.Output, iou_threshold tf.Output, score_threshold tf.Output) (selected_indices tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "NonMaxSuppressionV3",
		Input: []tf.Input{
			boxes, scores, max_output_size, iou_threshold, score_threshold,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// NonMaxSuppressionV4Attr is an optional argument to NonMaxSuppressionV4.
type NonMaxSuppressionV4Attr func(optionalAttr)

// NonMaxSuppressionV4PadToMaxOutputSize sets the optional pad_to_max_output_size attribute to value.
//
// value: If true, the output `selected_indices` is padded to be of length
// `max_output_size`. Defaults to false.
// If not specified, defaults to false
func NonMaxSuppressionV4PadToMaxOutputSize(value bool) NonMaxSuppressionV4Attr {
	return func(m optionalAttr) {
		m["pad_to_max_output_size"] = value
	}
}

// Greedily selects a subset of bounding boxes in descending order of score,
//
// pruning away boxes that have high intersection-over-union (IOU) overlap
// with previously selected boxes.  Bounding boxes with score less than
// `score_threshold` are removed.  Bounding boxes are supplied as
// [y1, x1, y2, x2], where (y1, x1) and (y2, x2) are the coordinates of any
// diagonal pair of box corners and the coordinates can be provided as normalized
// (i.e., lying in the interval [0, 1]) or absolute.  Note that this algorithm
// is agnostic to where the origin is in the coordinate system and more
// generally is invariant to orthogonal transformations and translations
// of the coordinate system; thus translating or reflections of the coordinate
// system result in the same boxes being selected by the algorithm.
// The output of this operation is a set of integers indexing into the input
// collection of bounding boxes representing the selected boxes.  The bounding
// box coordinates corresponding to the selected indices can then be obtained
// using the `tf.gather operation`.  For example:
//
//	selected_indices = tf.image.non_max_suppression_v2(
//	    boxes, scores, max_output_size, iou_threshold, score_threshold)
//	selected_boxes = tf.gather(boxes, selected_indices)
//
// Arguments:
//
//	boxes: A 2-D float tensor of shape `[num_boxes, 4]`.
//	scores: A 1-D float tensor of shape `[num_boxes]` representing a single
//
// score corresponding to each box (each row of boxes).
//
//	max_output_size: A scalar integer tensor representing the maximum number of
//
// boxes to be selected by non max suppression.
//
//	iou_threshold: A 0-D float tensor representing the threshold for deciding whether
//
// boxes overlap too much with respect to IOU.
//
//	score_threshold: A 0-D float tensor representing the threshold for deciding when to remove
//
// boxes based on score.
//
// Returns:
//
//	selected_indices: A 1-D integer tensor of shape `[M]` representing the selected
//
// indices from the boxes tensor, where `M <= max_output_size`.
//
//	valid_outputs: A 0-D integer tensor representing the number of valid elements in
//
// `selected_indices`, with the valid elements appearing first.
func NonMaxSuppressionV4(scope *Scope, boxes tf.Output, scores tf.Output, max_output_size tf.Output, iou_threshold tf.Output, score_threshold tf.Output, optional ...NonMaxSuppressionV4Attr) (selected_indices tf.Output, valid_outputs tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "NonMaxSuppressionV4",
		Input: []tf.Input{
			boxes, scores, max_output_size, iou_threshold, score_threshold,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// NonMaxSuppressionV5Attr is an optional argument to NonMaxSuppressionV5.
type NonMaxSuppressionV5Attr func(optionalAttr)

// NonMaxSuppressionV5PadToMaxOutputSize sets the optional pad_to_max_output_size attribute to value.
//
// value: If true, the output `selected_indices` is padded to be of length
// `max_output_size`. Defaults to false.
// If not specified, defaults to false
func NonMaxSuppressionV5PadToMaxOutputSize(value bool) NonMaxSuppressionV5Attr {
	return func(m optionalAttr) {
		m["pad_to_max_output_size"] = value
	}
}

// Greedily selects a subset of bounding boxes in descending order of score,
//
// pruning away boxes that have high intersection-over-union (IOU) overlap
// with previously selected boxes.  Bounding boxes with score less than
// `score_threshold` are removed.  Bounding boxes are supplied as
// [y1, x1, y2, x2], where (y1, x1) and (y2, x2) are the coordinates of any
// diagonal pair of box corners and the coordinates can be provided as normalized
// (i.e., lying in the interval [0, 1]) or absolute.  Note that this algorithm
// is agnostic to where the origin is in the coordinate system and more
// generally is invariant to orthogonal transformations and translations
// of the coordinate system; thus translating or reflections of the coordinate
// system result in the same boxes being selected by the algorithm.
// The output of this operation is a set of integers indexing into the input
// collection of bounding boxes representing the selected boxes.  The bounding
// box coordinates corresponding to the selected indices can then be obtained
// using the `tf.gather operation`.  For example:
//
//	selected_indices = tf.image.non_max_suppression_v2(
//	    boxes, scores, max_output_size, iou_threshold, score_threshold)
//	selected_boxes = tf.gather(boxes, selected_indices)
//
// This op also supports a Soft-NMS (with Gaussian weighting) mode (c.f.
// Bodla et al, https://arxiv.org/abs/1704.04503) where boxes reduce the score
// of other overlapping boxes instead of directly causing them to be pruned.
// To enable this Soft-NMS mode, set the `soft_nms_sigma` parameter to be
// larger than 0.
//
// Arguments:
//
//	boxes: A 2-D float tensor of shape `[num_boxes, 4]`.
//	scores: A 1-D float tensor of shape `[num_boxes]` representing a single
//
// score corresponding to each box (each row of boxes).
//
//	max_output_size: A scalar integer tensor representing the maximum number of
//
// boxes to be selected by non max suppression.
//
//	iou_threshold: A 0-D float tensor representing the threshold for deciding whether
//
// boxes overlap too much with respect to IOU.
//
//	score_threshold: A 0-D float tensor representing the threshold for deciding when to remove
//
// boxes based on score.
//
//	soft_nms_sigma: A 0-D float tensor representing the sigma parameter for Soft NMS; see Bodla et
//
// al (c.f. https://arxiv.org/abs/1704.04503).  When `soft_nms_sigma=0.0` (which
// is default), we fall back to standard (hard) NMS.
//
// Returns:
//
//	selected_indices: A 1-D integer tensor of shape `[M]` representing the selected
//
// indices from the boxes tensor, where `M <= max_output_size`.
//
//	selected_scores: A 1-D float tensor of shape `[M]` representing the corresponding
//
// scores for each selected box, where `M <= max_output_size`.  Scores only differ
// from corresponding input scores when using Soft NMS (i.e. when
// `soft_nms_sigma>0`)
//
//	valid_outputs: A 0-D integer tensor representing the number of valid elements in
//
// `selected_indices`, with the valid elements appearing first.
func NonMaxSuppressionV5(scope *Scope, boxes tf.Output, scores tf.Output, max_output_size tf.Output, iou_threshold tf.Output, score_threshold tf.Output, soft_nms_sigma tf.Output, optional ...NonMaxSuppressionV5Attr) (selected_indices tf.Output, selected_scores tf.Output, valid_outputs tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "NonMaxSuppressionV5",
		Input: []tf.Input{
			boxes, scores, max_output_size, iou_threshold, score_threshold, soft_nms_sigma,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// Greedily selects a subset of bounding boxes in descending order of score,
//
// pruning away boxes that have high overlaps
// with previously selected boxes.  Bounding boxes with score less than
// `score_threshold` are removed. N-by-n overlap values are supplied as square matrix,
// which allows for defining a custom overlap criterium (eg. intersection over union,
// intersection over area, etc.).
//
// The output of this operation is a set of integers indexing into the input
// collection of bounding boxes representing the selected boxes.  The bounding
// box coordinates corresponding to the selected indices can then be obtained
// using the `tf.gather operation`.  For example:
//
//	selected_indices = tf.image.non_max_suppression_with_overlaps(
//	    overlaps, scores, max_output_size, overlap_threshold, score_threshold)
//	selected_boxes = tf.gather(boxes, selected_indices)
//
// Arguments:
//
//	overlaps: A 2-D float tensor of shape `[num_boxes, num_boxes]` representing
//
// the n-by-n box overlap values.
//
//	scores: A 1-D float tensor of shape `[num_boxes]` representing a single
//
// score corresponding to each box (each row of boxes).
//
//	max_output_size: A scalar integer tensor representing the maximum number of
//
// boxes to be selected by non max suppression.
//
//	overlap_threshold: A 0-D float tensor representing the threshold for deciding whether
//
// boxes overlap too.
//
//	score_threshold: A 0-D float tensor representing the threshold for deciding when to remove
//
// boxes based on score.
//
// Returns A 1-D integer tensor of shape `[M]` representing the selected
// indices from the boxes tensor, where `M <= max_output_size`.
func NonMaxSuppressionWithOverlaps(scope *Scope, overlaps tf.Output, scores tf.Output, max_output_size tf.Output, overlap_threshold tf.Output, score_threshold tf.Output) (selected_indices tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "NonMaxSuppressionWithOverlaps",
		Input: []tf.Input{
			overlaps, scores, max_output_size, overlap_threshold, score_threshold,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// NotEqualAttr is an optional argument to NotEqual.
type NotEqualAttr func(optionalAttr)

// NotEqualIncompatibleShapeError sets the optional incompatible_shape_error attribute to value.
// If not specified, defaults to true
func NotEqualIncompatibleShapeError(value bool) NotEqualAttr {
	return func(m optionalAttr) {
		m["incompatible_shape_error"] = value
	}
}

// Returns the truth value of (x != y) element-wise.
//
// *NOTE*: `NotEqual` supports broadcasting. More about broadcasting
// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
func NotEqual(scope *Scope, x tf.Output, y tf.Output, optional ...NotEqualAttr) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "NotEqual",
		Input: []tf.Input{
			x, y,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// NthElementAttr is an optional argument to NthElement.
type NthElementAttr func(optionalAttr)

// NthElementReverse sets the optional reverse attribute to value.
//
// value: When set to True, find the nth-largest value in the vector and vice
// versa.
// If not specified, defaults to false
func NthElementReverse(value bool) NthElementAttr {
	return func(m optionalAttr) {
		m["reverse"] = value
	}
}

// Finds values of the `n`-th order statistic for the last dimension.
//
// If the input is a vector (rank-1), finds the entries which is the nth-smallest
// value in the vector and outputs their values as scalar tensor.
//
// For matrices (resp. higher rank input), computes the entries which is the
// nth-smallest value in each row (resp. vector along the last dimension). Thus,
//
//	values.shape = input.shape[:-1]
//
// Arguments:
//
//	input: 1-D or higher with last dimension at least `n+1`.
//	n: 0-D. Position of sorted vector to select along the last dimension (along
//
// each row for matrices). Valid range of n is `[0, input.shape[:-1])`
//
// Returns The `n`-th order statistic along each last dimensional slice.
func NthElement(scope *Scope, input tf.Output, n tf.Output, optional ...NthElementAttr) (values tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "NthElement",
		Input: []tf.Input{
			input, n,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// OneHotAttr is an optional argument to OneHot.
type OneHotAttr func(optionalAttr)

// OneHotAxis sets the optional axis attribute to value.
//
// value: The axis to fill (default: -1, a new inner-most axis).
// If not specified, defaults to -1
func OneHotAxis(value int64) OneHotAttr {
	return func(m optionalAttr) {
		m["axis"] = value
	}
}

// Returns a one-hot tensor.
//
// The locations represented by indices in `indices` take value `on_value`,
// while all other locations take value `off_value`.
//
// If the input `indices` is rank `N`, the output will have rank `N+1`,
// The new axis is created at dimension `axis` (default: the new axis is
// appended at the end).
//
// If `indices` is a scalar the output shape will be a vector of length `depth`.
//
// If `indices` is a vector of length `features`, the output shape will be:
// ```
//
//	features x depth if axis == -1
//	depth x features if axis == 0
//
// ```
//
// If `indices` is a matrix (batch) with shape `[batch, features]`,
// the output shape will be:
// ```
//
//	batch x features x depth if axis == -1
//	batch x depth x features if axis == 1
//	depth x batch x features if axis == 0
//
// ```
//
// Examples
// =========
//
// Suppose that
// ```
//
//	indices = [0, 2, -1, 1]
//	depth = 3
//	on_value = 5.0
//	off_value = 0.0
//	axis = -1
//
// ```
//
// Then output is `[4 x 3]`:
// ```
// output =
//
//	[5.0 0.0 0.0]  // one_hot(0)
//	[0.0 0.0 5.0]  // one_hot(2)
//	[0.0 0.0 0.0]  // one_hot(-1)
//	[0.0 5.0 0.0]  // one_hot(1)
//
// ```
//
// Suppose that
// ```
//
//	indices = [0, 2, -1, 1]
//	depth = 3
//	on_value = 0.0
//	off_value = 3.0
//	axis = 0
//
// ```
//
// Then output is `[3 x 4]`:
// ```
// output =
//
//	[0.0 3.0 3.0 3.0]
//	[3.0 3.0 3.0 0.0]
//	[3.0 3.0 3.0 3.0]
//	[3.0 0.0 3.0 3.0]
//
// //  ^                one_hot(0)
// //      ^            one_hot(2)
// //          ^        one_hot(-1)
// //              ^    one_hot(1)
// ```
//
// Suppose that
// ```
//
//	indices = [[0, 2], [1, -1]]
//	depth = 3
//	on_value = 1.0
//	off_value = 0.0
//	axis = -1
//
// ```
//
// Then output is `[2 x 2 x 3]`:
// ```
// output =
//
//	[
//	  [1.0, 0.0, 0.0]  // one_hot(0)
//	  [0.0, 0.0, 1.0]  // one_hot(2)
//	][
//	  [0.0, 1.0, 0.0]  // one_hot(1)
//	  [0.0, 0.0, 0.0]  // one_hot(-1)
//	]
//
// ```
//
// Arguments:
//
//	indices: A tensor of indices.
//	depth: A scalar defining the depth of the one hot dimension.
//	on_value: A scalar defining the value to fill in output when `indices[j] = i`.
//	off_value: A scalar defining the value to fill in output when `indices[j] != i`.
//
// Returns The one-hot tensor.
func OneHot(scope *Scope, indices tf.Output, depth tf.Output, on_value tf.Output, off_value tf.Output, optional ...OneHotAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "OneHot",
		Input: []tf.Input{
			indices, depth, on_value, off_value,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns a tensor of ones with the same shape and type as x.
//
// Arguments:
//
//	x: a tensor of type T.
//
// Returns a tensor of the same shape and type as x but filled with ones.
func OnesLike(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "OnesLike",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// OptimizeDatasetAttr is an optional argument to OptimizeDataset.
type OptimizeDatasetAttr func(optionalAttr)

// OptimizeDatasetOptimizationConfigs sets the optional optimization_configs attribute to value.
// If not specified, defaults to {}
func OptimizeDatasetOptimizationConfigs(value []string) OptimizeDatasetAttr {
	return func(m optionalAttr) {
		m["optimization_configs"] = value
	}
}

// Creates a dataset by applying optimizations to `input_dataset`.
//
// Creates a dataset by applying optimizations to `input_dataset`.
//
// Arguments:
//
//	input_dataset: A variant tensor representing the input dataset.
//	optimizations: A `tf.string` vector `tf.Tensor` identifying optimizations to use.
func OptimizeDataset(scope *Scope, input_dataset tf.Output, optimizations tf.Output, output_types []tf.DataType, output_shapes []tf.Shape, optional ...OptimizeDatasetAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "OptimizeDataset",
		Input: []tf.Input{
			input_dataset, optimizations,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// OptimizeDatasetV2Attr is an optional argument to OptimizeDatasetV2.
type OptimizeDatasetV2Attr func(optionalAttr)

// OptimizeDatasetV2OptimizationConfigs sets the optional optimization_configs attribute to value.
// If not specified, defaults to {}
func OptimizeDatasetV2OptimizationConfigs(value []string) OptimizeDatasetV2Attr {
	return func(m optionalAttr) {
		m["optimization_configs"] = value
	}
}

// Creates a dataset by applying related optimizations to `input_dataset`.
//
// Creates a dataset by applying related optimizations to `input_dataset`.
//
// Arguments:
//
//	input_dataset: A variant tensor representing the input dataset.
//	optimizations_enabled: A `tf.string` vector `tf.Tensor` identifying user enabled optimizations.
//	optimizations_disabled: A `tf.string` vector `tf.Tensor` identifying user disabled optimizations.
//	optimizations_default: A `tf.string` vector `tf.Tensor` identifying optimizations by default.
func OptimizeDatasetV2(scope *Scope, input_dataset tf.Output, optimizations_enabled tf.Output, optimizations_disabled tf.Output, optimizations_default tf.Output, output_types []tf.DataType, output_shapes []tf.Shape, optional ...OptimizeDatasetV2Attr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "OptimizeDatasetV2",
		Input: []tf.Input{
			input_dataset, optimizations_enabled, optimizations_disabled, optimizations_default,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Constructs an Optional variant from a tuple of tensors.
func OptionalFromValue(scope *Scope, components []tf.Output) (optional tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "OptionalFromValue",
		Input: []tf.Input{
			tf.OutputList(components),
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the value stored in an Optional variant or raises an error if none exists.
func OptionalGetValue(scope *Scope, optional tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (components []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "OptionalGetValue",
		Input: []tf.Input{
			optional,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if components, idx, err = makeOutputList(op, idx, "components"); err != nil {
		scope.UpdateErr("OptionalGetValue", err)
		return
	}
	return components
}

// Returns true if and only if the given Optional variant has a value.
func OptionalHasValue(scope *Scope, optional tf.Output) (has_value tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "OptionalHasValue",
		Input: []tf.Input{
			optional,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates an Optional variant with no value.
func OptionalNone(scope *Scope) (optional tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "OptionalNone",
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// OptionsDatasetAttr is an optional argument to OptionsDataset.
type OptionsDatasetAttr func(optionalAttr)

// OptionsDatasetMetadata sets the optional metadata attribute to value.
// If not specified, defaults to ""
func OptionsDatasetMetadata(value string) OptionsDatasetAttr {
	return func(m optionalAttr) {
		m["metadata"] = value
	}
}

// Creates a dataset by attaching tf.data.Options to `input_dataset`.
//
// Arguments:
//
//	input_dataset: A variant tensor representing the input dataset.
//	serialized_options: A `tf.string` scalar `tf.Tensor` of serialized `tf.data.Options` protocol buffer.
func OptionsDataset(scope *Scope, input_dataset tf.Output, serialized_options string, output_types []tf.DataType, output_shapes []tf.Shape, optional ...OptionsDatasetAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"serialized_options": serialized_options, "output_types": output_types, "output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "OptionsDataset",
		Input: []tf.Input{
			input_dataset,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// OrderedMapClearAttr is an optional argument to OrderedMapClear.
type OrderedMapClearAttr func(optionalAttr)

// OrderedMapClearCapacity sets the optional capacity attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func OrderedMapClearCapacity(value int64) OrderedMapClearAttr {
	return func(m optionalAttr) {
		m["capacity"] = value
	}
}

// OrderedMapClearMemoryLimit sets the optional memory_limit attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func OrderedMapClearMemoryLimit(value int64) OrderedMapClearAttr {
	return func(m optionalAttr) {
		m["memory_limit"] = value
	}
}

// OrderedMapClearContainer sets the optional container attribute to value.
// If not specified, defaults to ""
func OrderedMapClearContainer(value string) OrderedMapClearAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// OrderedMapClearSharedName sets the optional shared_name attribute to value.
// If not specified, defaults to ""
func OrderedMapClearSharedName(value string) OrderedMapClearAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Op removes all elements in the underlying container.
//
// Returns the created operation.
func OrderedMapClear(scope *Scope, dtypes []tf.DataType, optional ...OrderedMapClearAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtypes": dtypes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "OrderedMapClear",

		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// OrderedMapIncompleteSizeAttr is an optional argument to OrderedMapIncompleteSize.
type OrderedMapIncompleteSizeAttr func(optionalAttr)

// OrderedMapIncompleteSizeCapacity sets the optional capacity attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func OrderedMapIncompleteSizeCapacity(value int64) OrderedMapIncompleteSizeAttr {
	return func(m optionalAttr) {
		m["capacity"] = value
	}
}

// OrderedMapIncompleteSizeMemoryLimit sets the optional memory_limit attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func OrderedMapIncompleteSizeMemoryLimit(value int64) OrderedMapIncompleteSizeAttr {
	return func(m optionalAttr) {
		m["memory_limit"] = value
	}
}

// OrderedMapIncompleteSizeContainer sets the optional container attribute to value.
// If not specified, defaults to ""
func OrderedMapIncompleteSizeContainer(value string) OrderedMapIncompleteSizeAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// OrderedMapIncompleteSizeSharedName sets the optional shared_name attribute to value.
// If not specified, defaults to ""
func OrderedMapIncompleteSizeSharedName(value string) OrderedMapIncompleteSizeAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Op returns the number of incomplete elements in the underlying container.
func OrderedMapIncompleteSize(scope *Scope, dtypes []tf.DataType, optional ...OrderedMapIncompleteSizeAttr) (size tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtypes": dtypes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "OrderedMapIncompleteSize",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// OrderedMapPeekAttr is an optional argument to OrderedMapPeek.
type OrderedMapPeekAttr func(optionalAttr)

// OrderedMapPeekCapacity sets the optional capacity attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func OrderedMapPeekCapacity(value int64) OrderedMapPeekAttr {
	return func(m optionalAttr) {
		m["capacity"] = value
	}
}

// OrderedMapPeekMemoryLimit sets the optional memory_limit attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func OrderedMapPeekMemoryLimit(value int64) OrderedMapPeekAttr {
	return func(m optionalAttr) {
		m["memory_limit"] = value
	}
}

// OrderedMapPeekContainer sets the optional container attribute to value.
// If not specified, defaults to ""
func OrderedMapPeekContainer(value string) OrderedMapPeekAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// OrderedMapPeekSharedName sets the optional shared_name attribute to value.
// If not specified, defaults to ""
func OrderedMapPeekSharedName(value string) OrderedMapPeekAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Op peeks at the values at the specified key.  If the
//
// underlying container does not contain this key
// this op will block until it does.   This Op is optimized for
// performance.
func OrderedMapPeek(scope *Scope, key tf.Output, indices tf.Output, dtypes []tf.DataType, optional ...OrderedMapPeekAttr) (values []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtypes": dtypes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "OrderedMapPeek",
		Input: []tf.Input{
			key, indices,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if values, idx, err = makeOutputList(op, idx, "values"); err != nil {
		scope.UpdateErr("OrderedMapPeek", err)
		return
	}
	return values
}

// OrderedMapSizeAttr is an optional argument to OrderedMapSize.
type OrderedMapSizeAttr func(optionalAttr)

// OrderedMapSizeCapacity sets the optional capacity attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func OrderedMapSizeCapacity(value int64) OrderedMapSizeAttr {
	return func(m optionalAttr) {
		m["capacity"] = value
	}
}

// OrderedMapSizeMemoryLimit sets the optional memory_limit attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func OrderedMapSizeMemoryLimit(value int64) OrderedMapSizeAttr {
	return func(m optionalAttr) {
		m["memory_limit"] = value
	}
}

// OrderedMapSizeContainer sets the optional container attribute to value.
// If not specified, defaults to ""
func OrderedMapSizeContainer(value string) OrderedMapSizeAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// OrderedMapSizeSharedName sets the optional shared_name attribute to value.
// If not specified, defaults to ""
func OrderedMapSizeSharedName(value string) OrderedMapSizeAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Op returns the number of elements in the underlying container.
func OrderedMapSize(scope *Scope, dtypes []tf.DataType, optional ...OrderedMapSizeAttr) (size tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtypes": dtypes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "OrderedMapSize",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// OrderedMapStageAttr is an optional argument to OrderedMapStage.
type OrderedMapStageAttr func(optionalAttr)

// OrderedMapStageCapacity sets the optional capacity attribute to value.
//
// value: Maximum number of elements in the Staging Area. If > 0, inserts
// on the container will block when the capacity is reached.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func OrderedMapStageCapacity(value int64) OrderedMapStageAttr {
	return func(m optionalAttr) {
		m["capacity"] = value
	}
}

// OrderedMapStageMemoryLimit sets the optional memory_limit attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func OrderedMapStageMemoryLimit(value int64) OrderedMapStageAttr {
	return func(m optionalAttr) {
		m["memory_limit"] = value
	}
}

// OrderedMapStageContainer sets the optional container attribute to value.
//
// value: If non-empty, this queue is placed in the given container. Otherwise,
// a default container is used.
// If not specified, defaults to ""
func OrderedMapStageContainer(value string) OrderedMapStageAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// OrderedMapStageSharedName sets the optional shared_name attribute to value.
//
// value: It is necessary to match this name to the matching Unstage Op.
// If not specified, defaults to ""
func OrderedMapStageSharedName(value string) OrderedMapStageAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Stage (key, values) in the underlying container which behaves like a ordered
//
// associative container.   Elements are ordered by key.
//
// Arguments:
//
//	key: int64
//
//	values: a list of tensors
//
// dtypes A list of data types that inserted values should adhere to.
//
// Returns the created operation.
func OrderedMapStage(scope *Scope, key tf.Output, indices tf.Output, values []tf.Output, dtypes []tf.DataType, optional ...OrderedMapStageAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtypes": dtypes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "OrderedMapStage",
		Input: []tf.Input{
			key, indices, tf.OutputList(values),
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// OrderedMapUnstageAttr is an optional argument to OrderedMapUnstage.
type OrderedMapUnstageAttr func(optionalAttr)

// OrderedMapUnstageCapacity sets the optional capacity attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func OrderedMapUnstageCapacity(value int64) OrderedMapUnstageAttr {
	return func(m optionalAttr) {
		m["capacity"] = value
	}
}

// OrderedMapUnstageMemoryLimit sets the optional memory_limit attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func OrderedMapUnstageMemoryLimit(value int64) OrderedMapUnstageAttr {
	return func(m optionalAttr) {
		m["memory_limit"] = value
	}
}

// OrderedMapUnstageContainer sets the optional container attribute to value.
// If not specified, defaults to ""
func OrderedMapUnstageContainer(value string) OrderedMapUnstageAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// OrderedMapUnstageSharedName sets the optional shared_name attribute to value.
// If not specified, defaults to ""
func OrderedMapUnstageSharedName(value string) OrderedMapUnstageAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Op removes and returns the values associated with the key
//
// from the underlying container.   If the underlying container
// does not contain this key, the op will block until it does.
func OrderedMapUnstage(scope *Scope, key tf.Output, indices tf.Output, dtypes []tf.DataType, optional ...OrderedMapUnstageAttr) (values []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtypes": dtypes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "OrderedMapUnstage",
		Input: []tf.Input{
			key, indices,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if values, idx, err = makeOutputList(op, idx, "values"); err != nil {
		scope.UpdateErr("OrderedMapUnstage", err)
		return
	}
	return values
}

// OrderedMapUnstageNoKeyAttr is an optional argument to OrderedMapUnstageNoKey.
type OrderedMapUnstageNoKeyAttr func(optionalAttr)

// OrderedMapUnstageNoKeyCapacity sets the optional capacity attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func OrderedMapUnstageNoKeyCapacity(value int64) OrderedMapUnstageNoKeyAttr {
	return func(m optionalAttr) {
		m["capacity"] = value
	}
}

// OrderedMapUnstageNoKeyMemoryLimit sets the optional memory_limit attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func OrderedMapUnstageNoKeyMemoryLimit(value int64) OrderedMapUnstageNoKeyAttr {
	return func(m optionalAttr) {
		m["memory_limit"] = value
	}
}

// OrderedMapUnstageNoKeyContainer sets the optional container attribute to value.
// If not specified, defaults to ""
func OrderedMapUnstageNoKeyContainer(value string) OrderedMapUnstageNoKeyAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// OrderedMapUnstageNoKeySharedName sets the optional shared_name attribute to value.
// If not specified, defaults to ""
func OrderedMapUnstageNoKeySharedName(value string) OrderedMapUnstageNoKeyAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Op removes and returns the (key, value) element with the smallest
//
// key from the underlying container.   If the underlying container
// does not contain elements, the op will block until it does.
func OrderedMapUnstageNoKey(scope *Scope, indices tf.Output, dtypes []tf.DataType, optional ...OrderedMapUnstageNoKeyAttr) (key tf.Output, values []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtypes": dtypes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "OrderedMapUnstageNoKey",
		Input: []tf.Input{
			indices,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	key = op.Output(idx)
	if values, idx, err = makeOutputList(op, idx, "values"); err != nil {
		scope.UpdateErr("OrderedMapUnstageNoKey", err)
		return
	}
	return key, values
}

// OutfeedDequeueAttr is an optional argument to OutfeedDequeue.
type OutfeedDequeueAttr func(optionalAttr)

// OutfeedDequeueDeviceOrdinal sets the optional device_ordinal attribute to value.
//
// value: The TPU device to use. This should be -1 when the Op
// is running on a TPU device, and >= 0 when the Op is running on the CPU
// device.
// If not specified, defaults to -1
func OutfeedDequeueDeviceOrdinal(value int64) OutfeedDequeueAttr {
	return func(m optionalAttr) {
		m["device_ordinal"] = value
	}
}

// Retrieves a single tensor from the computation outfeed.
//
// This operation will block indefinitely until data is available.
//
// Arguments:
//
//	dtype: The type of elements in the tensor.
//	shape: The shape of the tensor.
//
// Returns A tensor that will be read from the device outfeed.
func OutfeedDequeue(scope *Scope, dtype tf.DataType, shape tf.Shape, optional ...OutfeedDequeueAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtype": dtype, "shape": shape}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "OutfeedDequeue",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// OutfeedDequeueTupleAttr is an optional argument to OutfeedDequeueTuple.
type OutfeedDequeueTupleAttr func(optionalAttr)

// OutfeedDequeueTupleDeviceOrdinal sets the optional device_ordinal attribute to value.
//
// value: The TPU device to use. This should be -1 when the Op
// is running on a TPU device, and >= 0 when the Op is running on the CPU
// device.
// If not specified, defaults to -1
func OutfeedDequeueTupleDeviceOrdinal(value int64) OutfeedDequeueTupleAttr {
	return func(m optionalAttr) {
		m["device_ordinal"] = value
	}
}

// Retrieve multiple values from the computation outfeed.
//
// This operation will block indefinitely until data is available. Output `i`
// corresponds to XLA tuple element `i`.
//
// Arguments:
//
//	dtypes: The element types of each element in `outputs`.
//	shapes: The shapes of each tensor in `outputs`.
//
// Returns A list of tensors that will be read from the outfeed.
func OutfeedDequeueTuple(scope *Scope, dtypes []tf.DataType, shapes []tf.Shape, optional ...OutfeedDequeueTupleAttr) (outputs []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtypes": dtypes, "shapes": shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "OutfeedDequeueTuple",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if outputs, idx, err = makeOutputList(op, idx, "outputs"); err != nil {
		scope.UpdateErr("OutfeedDequeueTuple", err)
		return
	}
	return outputs
}

// Retrieve multiple values from the computation outfeed. Device ordinal is a
// tensor allowing dynamic outfeed.
//
// This operation will block indefinitely until data is available. Output `i`
// corresponds to XLA tuple element `i`.
//
// Arguments:
//
//	device_ordinal: An int scalar tensor, representing the TPU device to use. This should be -1 when
//
// the Op is running on a TPU device, and >= 0 when the Op is running on the CPU
// device.
//
//	dtypes: The element types of each element in `outputs`.
//	shapes: The shapes of each tensor in `outputs`.
//
// Returns A list of tensors that will be read from the outfeed.
func OutfeedDequeueTupleV2(scope *Scope, device_ordinal tf.Output, dtypes []tf.DataType, shapes []tf.Shape) (outputs []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtypes": dtypes, "shapes": shapes}
	opspec := tf.OpSpec{
		Type: "OutfeedDequeueTupleV2",
		Input: []tf.Input{
			device_ordinal,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if outputs, idx, err = makeOutputList(op, idx, "outputs"); err != nil {
		scope.UpdateErr("OutfeedDequeueTupleV2", err)
		return
	}
	return outputs
}

// Retrieves a single tensor from the computation outfeed. Device ordinal is a
// tensor allowing dynamic outfeed.
//
// This operation will block indefinitely until data is available.
//
// Arguments:
//
//	device_ordinal: An int scalar tensor, representing the TPU device to use. This should be -1 when
//
// the Op is running on a TPU device, and >= 0 when the Op is running on the CPU
// device.
//
//	dtype: The type of elements in the tensor.
//	shape: The shape of the tensor.
//
// Returns A tensor that will be read from the device outfeed.
func OutfeedDequeueV2(scope *Scope, device_ordinal tf.Output, dtype tf.DataType, shape tf.Shape) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtype": dtype, "shape": shape}
	opspec := tf.OpSpec{
		Type: "OutfeedDequeueV2",
		Input: []tf.Input{
			device_ordinal,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Enqueue a Tensor on the computation outfeed.
//
// Arguments:
//
//	input: A tensor that will be inserted into the outfeed queue.
//
// Returns the created operation.
func OutfeedEnqueue(scope *Scope, input tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "OutfeedEnqueue",
		Input: []tf.Input{
			input,
		},
	}
	return scope.AddOperation(opspec)
}

// Enqueue multiple Tensor values on the computation outfeed.
//
// Arguments:
//
//	inputs: A list of tensors that will be inserted into the outfeed queue as an
//
// XLA tuple.
//
// Returns the created operation.
func OutfeedEnqueueTuple(scope *Scope, inputs []tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "OutfeedEnqueueTuple",
		Input: []tf.Input{
			tf.OutputList(inputs),
		},
	}
	return scope.AddOperation(opspec)
}

// PackAttr is an optional argument to Pack.
type PackAttr func(optionalAttr)

// PackAxis sets the optional axis attribute to value.
//
// value: Dimension along which to pack.  Negative values wrap around, so the
// valid range is `[-(R+1), R+1)`.
// If not specified, defaults to 0
func PackAxis(value int64) PackAttr {
	return func(m optionalAttr) {
		m["axis"] = value
	}
}

// Packs a list of `N` rank-`R` tensors into one rank-`(R+1)` tensor.
//
// Packs the `N` tensors in `values` into a tensor with rank one higher than each
// tensor in `values`, by packing them along the `axis` dimension.
// Given a list of tensors of shape `(A, B, C)`;
//
// if `axis == 0` then the `output` tensor will have the shape `(N, A, B, C)`.
// if `axis == 1` then the `output` tensor will have the shape `(A, N, B, C)`.
// Etc.
//
// For example:
//
// ```
// # 'x' is [1, 4]
// # 'y' is [2, 5]
// # 'z' is [3, 6]
// pack([x, y, z]) => [[1, 4], [2, 5], [3, 6]]  # Pack along first dim.
// pack([x, y, z], axis=1) => [[1, 2, 3], [4, 5, 6]]
// ```
//
// This is the opposite of `unpack`.
//
// Arguments:
//
//	values: Must be of same shape and type.
//
// Returns The packed tensor.
func Pack(scope *Scope, values []tf.Output, optional ...PackAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Pack",
		Input: []tf.Input{
			tf.OutputList(values),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Pads a tensor with zeros.
//
// This operation pads a `input` with zeros according to the `paddings` you
// specify. `paddings` is an integer tensor with shape `[Dn, 2]`, where n is the
// rank of `input`. For each dimension D of `input`, `paddings[D, 0]` indicates
// how many zeros to add before the contents of `input` in that dimension, and
// `paddings[D, 1]` indicates how many zeros to add after the contents of `input`
// in that dimension.
//
// The padded size of each dimension D of the output is:
//
// `paddings(D, 0) + input.dim_size(D) + paddings(D, 1)`
//
// For example:
//
// ```
// # 't' is [[1, 1], [2, 2]]
// # 'paddings' is [[1, 1], [2, 2]]
// # rank of 't' is 2
// pad(t, paddings) ==> [[0, 0, 0, 0, 0, 0]
//
//	[0, 0, 1, 1, 0, 0]
//	[0, 0, 2, 2, 0, 0]
//	[0, 0, 0, 0, 0, 0]]
//
// ```
func Pad(scope *Scope, input tf.Output, paddings tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Pad",
		Input: []tf.Input{
			input, paddings,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Pads a tensor.
//
// This operation pads `input` according to the `paddings` and `constant_values`
// you specify. `paddings` is an integer tensor with shape `[Dn, 2]`, where n is
// the rank of `input`. For each dimension D of `input`, `paddings[D, 0]` indicates
// how many padding values to add before the contents of `input` in that dimension,
// and `paddings[D, 1]` indicates how many padding values to add after the contents
// of `input` in that dimension. `constant_values` is a scalar tensor of the same
// type as `input` that indicates the value to use for padding `input`.
//
// The padded size of each dimension D of the output is:
//
// `paddings(D, 0) + input.dim_size(D) + paddings(D, 1)`
//
// For example:
//
// ```
// # 't' is [[1, 1], [2, 2]]
// # 'paddings' is [[1, 1], [2, 2]]
// # 'constant_values' is 0
// # rank of 't' is 2
// pad(t, paddings) ==> [[0, 0, 0, 0, 0, 0]
//
//	[0, 0, 1, 1, 0, 0]
//	[0, 0, 2, 2, 0, 0]
//	[0, 0, 0, 0, 0, 0]]
//
// ```
func PadV2(scope *Scope, input tf.Output, paddings tf.Output, constant_values tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "PadV2",
		Input: []tf.Input{
			input, paddings, constant_values,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// PaddedBatchDatasetAttr is an optional argument to PaddedBatchDataset.
type PaddedBatchDatasetAttr func(optionalAttr)

// PaddedBatchDatasetMetadata sets the optional metadata attribute to value.
// If not specified, defaults to ""
func PaddedBatchDatasetMetadata(value string) PaddedBatchDatasetAttr {
	return func(m optionalAttr) {
		m["metadata"] = value
	}
}

// Creates a dataset that batches and pads `batch_size` elements from the input.
//
// Arguments:
//
//	batch_size: A scalar representing the number of elements to accumulate in a
//
// batch.
//
//	padded_shapes: A list of int64 tensors representing the desired padded shapes
//
// of the corresponding output components. These shapes may be partially
// specified, using `-1` to indicate that a particular dimension should be
// padded to the maximum size of all batch elements.
//
//	padding_values: A list of scalars containing the padding value to use for
//
// each of the outputs.
func PaddedBatchDataset(scope *Scope, input_dataset tf.Output, batch_size tf.Output, padded_shapes []tf.Output, padding_values []tf.Output, output_shapes []tf.Shape, optional ...PaddedBatchDatasetAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "PaddedBatchDataset",
		Input: []tf.Input{
			input_dataset, batch_size, tf.OutputList(padded_shapes), tf.OutputList(padding_values),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// PaddedBatchDatasetV2Attr is an optional argument to PaddedBatchDatasetV2.
type PaddedBatchDatasetV2Attr func(optionalAttr)

// PaddedBatchDatasetV2ParallelCopy sets the optional parallel_copy attribute to value.
// If not specified, defaults to false
func PaddedBatchDatasetV2ParallelCopy(value bool) PaddedBatchDatasetV2Attr {
	return func(m optionalAttr) {
		m["parallel_copy"] = value
	}
}

// PaddedBatchDatasetV2Metadata sets the optional metadata attribute to value.
// If not specified, defaults to ""
func PaddedBatchDatasetV2Metadata(value string) PaddedBatchDatasetV2Attr {
	return func(m optionalAttr) {
		m["metadata"] = value
	}
}

// Creates a dataset that batches and pads `batch_size` elements from the input.
//
// Arguments:
//
//	batch_size: A scalar representing the number of elements to accumulate in a
//
// batch.
//
//	padded_shapes: A list of int64 tensors representing the desired padded shapes
//
// of the corresponding output components. These shapes may be partially
// specified, using `-1` to indicate that a particular dimension should be
// padded to the maximum size of all batch elements.
//
//	padding_values: A list of scalars containing the padding value to use for
//
// each of the outputs.
//
//	drop_remainder: A scalar representing whether the last batch should be dropped in case its size
//
// is smaller than desired.
func PaddedBatchDatasetV2(scope *Scope, input_dataset tf.Output, batch_size tf.Output, padded_shapes []tf.Output, padding_values []tf.Output, drop_remainder tf.Output, output_shapes []tf.Shape, optional ...PaddedBatchDatasetV2Attr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "PaddedBatchDatasetV2",
		Input: []tf.Input{
			input_dataset, batch_size, tf.OutputList(padded_shapes), tf.OutputList(padding_values), drop_remainder,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// PaddingFIFOQueueV2Attr is an optional argument to PaddingFIFOQueueV2.
type PaddingFIFOQueueV2Attr func(optionalAttr)

// PaddingFIFOQueueV2Shapes sets the optional shapes attribute to value.
//
// value: The shape of each component in a value. The length of this attr must
// be either 0 or the same as the length of component_types.
// Shapes of fixed rank but variable size are allowed by setting
// any shape dimension to -1.  In this case, the inputs' shape may vary along
// the given dimension, and DequeueMany will pad the given dimension with
// zeros up to the maximum shape of all elements in the given batch.
// If the length of this attr is 0, different queue elements may have
// different ranks and shapes, but only one element may be dequeued at a time.
// If not specified, defaults to {}
//
// REQUIRES: len(value) >= 0
func PaddingFIFOQueueV2Shapes(value []tf.Shape) PaddingFIFOQueueV2Attr {
	return func(m optionalAttr) {
		m["shapes"] = value
	}
}

// PaddingFIFOQueueV2Capacity sets the optional capacity attribute to value.
//
// value: The upper bound on the number of elements in this queue.
// Negative numbers mean no limit.
// If not specified, defaults to -1
func PaddingFIFOQueueV2Capacity(value int64) PaddingFIFOQueueV2Attr {
	return func(m optionalAttr) {
		m["capacity"] = value
	}
}

// PaddingFIFOQueueV2Container sets the optional container attribute to value.
//
// value: If non-empty, this queue is placed in the giv