/* Copyright 2020 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
==============================================================================*/
// automatically generated by the FlatBuffers compiler, do not modify


#ifndef FLATBUFFERS_GENERATED_SERIALIZATIONBASE_TFLITE_GPU_DATA_H_
#define FLATBUFFERS_GENERATED_SERIALIZATIONBASE_TFLITE_GPU_DATA_H_

#include "flatbuffers/flatbuffers.h"

// Ensure the included flatbuffers.h is the same version as when this file was
// generated, otherwise it may not be compatible.
static_assert(FLATBUFFERS_VERSION_MAJOR == 25 &&
              FLATBUFFERS_VERSION_MINOR == 9 &&
              FLATBUFFERS_VERSION_REVISION == 23,
             "Non-compatible flatbuffers version included");

namespace tflite {
namespace gpu {
namespace data {

struct Int4;
struct Int4Builder;

struct Int3;
struct Int3Builder;

struct Int2;
struct Int2Builder;

struct StateVariable;
struct StateVariableBuilder;

struct GPUObjectDescriptor;
struct GPUObjectDescriptorBuilder;

struct IntValue;
struct IntValueBuilder;

struct FloatValue;
struct FloatValueBuilder;

struct HalfValue;
struct HalfValueBuilder;

struct BufferDescriptor;
struct BufferDescriptorBuilder;

struct BHWDC;
struct BHWDCBuilder;

struct TensorDescriptor;
struct TensorDescriptorBuilder;

struct BufferDescriptorMapValue;
struct BufferDescriptorMapValueBuilder;

struct TensorDescriptorMapValue;
struct TensorDescriptorMapValueBuilder;

struct Arguments;
struct ArgumentsBuilder;

struct OperationDef;
struct OperationDefBuilder;

struct CompilerOption;
struct CompilerOptionBuilder;

struct GPUOperation;
struct GPUOperationBuilder;

enum class AccessType : int8_t {
  READ = 0,
  WRITE = 1,
  READ_WRITE = 2,
  MIN = READ,
  MAX = READ_WRITE
};

inline const AccessType (&EnumValuesAccessType())[3] {
  static const AccessType values[] = {
    AccessType::READ,
    AccessType::WRITE,
    AccessType::READ_WRITE
  };
  return values;
}

inline const char * const *EnumNamesAccessType() {
  static const char * const names[4] = {
    "READ",
    "WRITE",
    "READ_WRITE",
    nullptr
  };
  return names;
}

inline const char *EnumNameAccessType(AccessType e) {
  if (::flatbuffers::IsOutRange(e, AccessType::READ, AccessType::READ_WRITE)) return "";
  const size_t index = static_cast<size_t>(e);
  return EnumNamesAccessType()[index];
}

enum class DataType : int8_t {
  UNKNOWN = 0,
  FLOAT16 = 1,
  FLOAT32 = 2,
  FLOAT64 = 3,
  UINT8 = 4,
  INT8 = 5,
  UINT16 = 6,
  INT16 = 7,
  UINT32 = 8,
  INT32 = 9,
  UINT64 = 10,
  INT64 = 11,
  BOOL = 12,
  MIN = UNKNOWN,
  MAX = BOOL
};

inline const DataType (&EnumValuesDataType())[13] {
  static const DataType values[] = {
    DataType::UNKNOWN,
    DataType::FLOAT16,
    DataType::FLOAT32,
    DataType::FLOAT64,
    DataType::UINT8,
    DataType::INT8,
    DataType::UINT16,
    DataType::INT16,
    DataType::UINT32,
    DataType::INT32,
    DataType::UINT64,
    DataType::INT64,
    DataType::BOOL
  };
  return values;
}

inline const char * const *EnumNamesDataType() {
  static const char * const names[14] = {
    "UNKNOWN",
    "FLOAT16",
    "FLOAT32",
    "FLOAT64",
    "UINT8",
    "INT8",
    "UINT16",
    "INT16",
    "UINT32",
    "INT32",
    "UINT64",
    "INT64",
    "BOOL",
    nullptr
  };
  return names;
}

inline const char *EnumNameDataType(DataType e) {
  if (::flatbuffers::IsOutRange(e, DataType::UNKNOWN, DataType::BOOL)) return "";
  const size_t index = static_cast<size_t>(e);
  return EnumNamesDataType()[index];
}

enum class MemoryType : int8_t {
  GLOBAL = 0,
  CONSTANT = 1,
  LOCAL = 2,
  MIN = GLOBAL,
  MAX = LOCAL
};

inline const MemoryType (&EnumValuesMemoryType())[3] {
  static const MemoryType values[] = {
    MemoryType::GLOBAL,
    MemoryType::CONSTANT,
    MemoryType::LOCAL
  };
  return values;
}

inline const char * const *EnumNamesMemoryType() {
  static const char * const names[4] = {
    "GLOBAL",
    "CONSTANT",
    "LOCAL",
    nullptr
  };
  return names;
}

inline const char *EnumNameMemoryType(MemoryType e) {
  if (::flatbuffers::IsOutRange(e, MemoryType::GLOBAL, MemoryType::LOCAL)) return "";
  const size_t index = static_cast<size_t>(e);
  return EnumNamesMemoryType()[index];
}

enum class TensorStorageType : int8_t {
  UNKNOWN = 0,
  BUFFER = 1,
  IMAGE_BUFFER = 2,
  TEXTURE_2D = 3,
  TEXTURE_3D = 4,
  TEXTURE_ARRAY = 5,
  SINGLE_TEXTURE_2D = 6,
  MIN = UNKNOWN,
  MAX = SINGLE_TEXTURE_2D
};

inline const TensorStorageType (&EnumValuesTensorStorageType())[7] {
  static const TensorStorageType values[] = {
    TensorStorageType::UNKNOWN,
    TensorStorageType::BUFFER,
    TensorStorageType::IMAGE_BUFFER,
    TensorStorageType::TEXTURE_2D,
    TensorStorageType::TEXTURE_3D,
    TensorStorageType::TEXTURE_ARRAY,
    TensorStorageType::SINGLE_TEXTURE_2D
  };
  return values;
}

inline const char * const *EnumNamesTensorStorageType() {
  static const char * const names[8] = {
    "UNKNOWN",
    "BUFFER",
    "IMAGE_BUFFER",
    "TEXTURE_2D",
    "TEXTURE_3D",
    "TEXTURE_ARRAY",
    "SINGLE_TEXTURE_2D",
    nullptr
  };
  return names;
}

inline const char *EnumNameTensorStorageType(TensorStorageType e) {
  if (::flatbuffers::IsOutRange(e, TensorStorageType::UNKNOWN, TensorStorageType::SINGLE_TEXTURE_2D)) return "";
  const size_t index = static_cast<size_t>(e);
  return EnumNamesTensorStorageType()[index];
}

enum class Layout : int8_t {
  UNKNOWN = 0,
  HWC = 1,
  BHWC = 2,
  HWDC = 3,
  BHWDC = 4,
  LINEAR = 5,
  HW = 6,
  MIN = UNKNOWN,
  MAX = HW
};

inline const Layout (&EnumValuesLayout())[7] {
  static const Layout values[] = {
    Layout::UNKNOWN,
    Layout::HWC,
    Layout::BHWC,
    Layout::HWDC,
    Layout::BHWDC,
    Layout::LINEAR,
    Layout::HW
  };
  return values;
}

inline const char * const *EnumNamesLayout() {
  static const char * const names[8] = {
    "UNKNOWN",
    "HWC",
    "BHWC",
    "HWDC",
    "BHWDC",
    "LINEAR",
    "HW",
    nullptr
  };
  return names;
}

inline const char *EnumNameLayout(Layout e) {
  if (::flatbuffers::IsOutRange(e, Layout::UNKNOWN, Layout::HW)) return "";
  const size_t index = static_cast<size_t>(e);
  return EnumNamesLayout()[index];
}

enum class CalculationsPrecision : int8_t {
  F32 = 0,
  F32_F16 = 1,
  F16 = 2,
  MIN = F32,
  MAX = F16
};

inline const CalculationsPrecision (&EnumValuesCalculationsPrecision())[3] {
  static const CalculationsPrecision values[] = {
    CalculationsPrecision::F32,
    CalculationsPrecision::F32_F16,
    CalculationsPrecision::F16
  };
  return values;
}

inline const char * const *EnumNamesCalculationsPrecision() {
  static const char * const names[4] = {
    "F32",
    "F32_F16",
    "F16",
    nullptr
  };
  return names;
}

inline const char *EnumNameCalculationsPrecision(CalculationsPrecision e) {
  if (::flatbuffers::IsOutRange(e, CalculationsPrecision::F32, CalculationsPrecision::F16)) return "";
  const size_t index = static_cast<size_t>(e);
  return EnumNamesCalculationsPrecision()[index];
}

enum class TensorToGrid : int8_t {
  CUSTOM = 0,
  WB_TO_X_HD_TO_Y_S_TO_Z = 1,
  WB_TO_X_HD_TO_Y_Z_IS_1 = 2,
  WB_TO_X_H_TO_Y_D_TO_Z = 3,
  B_TO_X_Y_IS_1_Z_IS_1 = 4,
  MIN = CUSTOM,
  MAX = B_TO_X_Y_IS_1_Z_IS_1
};

inline const TensorToGrid (&EnumValuesTensorToGrid())[5] {
  static const TensorToGrid values[] = {
    TensorToGrid::CUSTOM,
    TensorToGrid::WB_TO_X_HD_TO_Y_S_TO_Z,
    TensorToGrid::WB_TO_X_HD_TO_Y_Z_IS_1,
    TensorToGrid::WB_TO_X_H_TO_Y_D_TO_Z,
    TensorToGrid::B_TO_X_Y_IS_1_Z_IS_1
  };
  return values;
}

inline const char * const *EnumNamesTensorToGrid() {
  static const char * const names[6] = {
    "CUSTOM",
    "WB_TO_X_HD_TO_Y_S_TO_Z",
    "WB_TO_X_HD_TO_Y_Z_IS_1",
    "WB_TO_X_H_TO_Y_D_TO_Z",
    "B_TO_X_Y_IS_1_Z_IS_1",
    nullptr
  };
  return names;
}

inline const char *EnumNameTensorToGrid(TensorToGrid e) {
  if (::flatbuffers::IsOutRange(e, TensorToGrid::CUSTOM, TensorToGrid::B_TO_X_Y_IS_1_Z_IS_1)) return "";
  const size_t index = static_cast<size_t>(e);
  return EnumNamesTensorToGrid()[index];
}

enum class CompilerOptions : int8_t {
  ADRENO_FULL_SIMD_LINE = 0,
  ADRENO_MORE_WAVES = 1,
  CL_FAST_RELAXED_MATH = 2,
  CL_OPT_DISABLE = 3,
  CL_2_0 = 4,
  CL_3_0 = 5,
  CL_REGISTER_ALLOCATION_64 = 6,
  MIN = ADRENO_FULL_SIMD_LINE,
  MAX = CL_REGISTER_ALLOCATION_64
};

inline const CompilerOptions (&EnumValuesCompilerOptions())[7] {
  static const CompilerOptions values[] = {
    CompilerOptions::ADRENO_FULL_SIMD_LINE,
    CompilerOptions::ADRENO_MORE_WAVES,
    CompilerOptions::CL_FAST_RELAXED_MATH,
    CompilerOptions::CL_OPT_DISABLE,
    CompilerOptions::CL_2_0,
    CompilerOptions::CL_3_0,
    CompilerOptions::CL_REGISTER_ALLOCATION_64
  };
  return values;
}

inline const char * const *EnumNamesCompilerOptions() {
  static const char * const names[8] = {
    "ADRENO_FULL_SIMD_LINE",
    "ADRENO_MORE_WAVES",
    "CL_FAST_RELAXED_MATH",
    "CL_OPT_DISABLE",
    "CL_2_0",
    "CL_3_0",
    "CL_REGISTER_ALLOCATION_64",
    nullptr
  };
  return names;
}

inline const char *EnumNameCompilerOptions(CompilerOptions e) {
  if (::flatbuffers::IsOutRange(e, CompilerOptions::MIN, CompilerOptions::MAX)) return "";
  const size_t index = static_cast<size_t>(e);
  return EnumNamesCompilerOptions()[index];
}

struct Int4 FLATBUFFERS_FINAL_CLASS : private ::flatbuffers::Table {
  typedef Int4Builder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_X = 4,
    VT_Y = 6,
    VT_Z = 8,
    VT_W = 10
  };
  int32_t x() const {
    return GetField<int32_t>(VT_X, 0);
  }
  int32_t y() const {
    return GetField<int32_t>(VT_Y, 0);
  }
  int32_t z() const {
    return GetField<int32_t>(VT_Z, 0);
  }
  int32_t w() const {
    return GetField<int32_t>(VT_W, 0);
  }
  bool Verify(::flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyField<int32_t>(verifier, VT_X, 4) &&
           VerifyField<int32_t>(verifier, VT_Y, 4) &&
           VerifyField<int32_t>(verifier, VT_Z, 4) &&
           VerifyField<int32_t>(verifier, VT_W, 4) &&
           verifier.EndTable();
  }
};

struct Int4Builder {
  typedef Int4 Table;
  ::flatbuffers::FlatBufferBuilder &fbb_;
  ::flatbuffers::uoffset_t start_;
  void add_x(int32_t x) {
    fbb_.AddElement<int32_t>(Int4::VT_X, x, 0);
  }
  void add_y(int32_t y) {
    fbb_.AddElement<int32_t>(Int4::VT_Y, y, 0);
  }
  void add_z(int32_t z) {
    fbb_.AddElement<int32_t>(Int4::VT_Z, z, 0);
  }
  void add_w(int32_t w) {
    fbb_.AddElement<int32_t>(Int4::VT_W, w, 0);
  }
  explicit Int4Builder(::flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  ::flatbuffers::Offset<Int4> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = ::flatbuffers::Offset<Int4>(end);
    return o;
  }
};

inline ::flatbuffers::Offset<Int4> CreateInt4(
    ::flatbuffers::FlatBufferBuilder &_fbb,
    int32_t x = 0,
    int32_t y = 0,
    int32_t z = 0,
    int32_t w = 0) {
  Int4Builder builder_(_fbb);
  builder_.add_w(w);
  builder_.add_z(z);
  builder_.add_y(y);
  builder_.add_x(x);
  return builder_.Finish();
}

struct Int3 FLATBUFFERS_FINAL_CLASS : private ::flatbuffers::Table {
  typedef Int3Builder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_X = 4,
    VT_Y = 6,
    VT_Z = 8
  };
  int32_t x() const {
    return GetField<int32_t>(VT_X, 0);
  }
  int32_t y() const {
    return GetField<int32_t>(VT_Y, 0);
  }
  int32_t z() const {
    return GetField<int32_t>(VT_Z, 0);
  }
  bool Verify(::flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyField<int32_t>(verifier, VT_X, 4) &&
           VerifyField<int32_t>(verifier, VT_Y, 4) &&
           VerifyField<int32_t>(verifier, VT_Z, 4) &&
           verifier.EndTable();
  }
};

struct Int3Builder {
  typedef Int3 Table;
  ::flatbuffers::FlatBufferBuilder &fbb_;
  ::flatbuffers::uoffset_t start_;
  void add_x(int32_t x) {
    fbb_.AddElement<int32_t>(Int3::VT_X, x, 0);
  }
  void add_y(int32_t y) {
    fbb_.AddElement<int32_t>(Int3::VT_Y, y, 0);
  }
  void add_z(int32_t z) {
    fbb_.AddElement<int32_t>(Int3::VT_Z, z, 0);
  }
  explicit Int3Builder(::flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  ::flatbuffers::Offset<Int3> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = ::flatbuffers::Offset<Int3>(end);
    return o;
  }
};

inline ::flatbuffers::Offset<Int3> CreateInt3(
    ::flatbuffers::FlatBufferBuilder &_fbb,
    int32_t x = 0,
    int32_t y = 0,
    int32_t z = 0) {
  Int3Builder builder_(_fbb);
  builder_.add_z(z);
  builder_.add_y(y);
  builder_.add_x(x);
  return builder_.Finish();
}

struct Int2 FLATBUFFERS_FINAL_CLASS : private ::flatbuffers::Table {
  typedef Int2Builder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_X = 4,
    VT_Y = 6
  };
  int32_t x() const {
    return GetField<int32_t>(VT_X, 0);
  }
  int32_t y() const {
    return GetField<int32_t>(VT_Y, 0);
  }
  bool Verify(::flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyField<int32_t>(verifier, VT_X, 4) &&
           VerifyField<int32_t>(verifier, VT_Y, 4) &&
           verifier.EndTable();
  }
};

struct Int2Builder {
  typedef Int2 Table;
  ::flatbuffers::FlatBufferBuilder &fbb_;
  ::flatbuffers::uoffset_t start_;
  void add_x(int32_t x) {
    fbb_.AddElement<int32_t>(Int2::VT_X, x, 0);
  }
  void add_y(int32_t y) {
    fbb_.AddElement<int32_t>(Int2::VT_Y, y, 0);
  }
  explicit Int2Builder(::flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  ::flatbuffers::Offset<Int2> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = ::flatbuffers::Offset<Int2>(end);
    return o;
  }
};

inline ::flatbuffers::Offset<Int2> CreateInt2(
    ::flatbuffers::FlatBufferBuilder &_fbb,
    int32_t x = 0,
    int32_t y = 0) {
  Int2Builder builder_(_fbb);
  builder_.add_y(y);
  builder_.add_x(x);
  return builder_.Finish();
}

struct StateVariable FLATBUFFERS_FINAL_CLASS : private ::flatbuffers::Table {
  typedef StateVariableBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_KEY = 4,
    VT_VALUE = 6
  };
  const ::flatbuffers::String *key() const {
    return GetPointer<const ::flatbuffers::String *>(VT_KEY);
  }
  const ::flatbuffers::String *value() const {
    return GetPointer<const ::flatbuffers::String *>(VT_VALUE);
  }
  bool Verify(::flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyOffset(verifier, VT_KEY) &&
           verifier.VerifyString(key()) &&
           VerifyOffset(verifier, VT_VALUE) &&
           verifier.VerifyString(value()) &&
           verifier.EndTable();
  }
};

struct StateVariableBuilder {
  typedef StateVariable Table;
  ::flatbuffers::FlatBufferBuilder &fbb_;
  ::flatbuffers::uoffset_t start_;
  void add_key(::flatbuffers::Offset<::flatbuffers::String> key) {
    fbb_.AddOffset(StateVariable::VT_KEY, key);
  }
  void add_value(::flatbuffers::Offset<::flatbuffers::String> value) {
    fbb_.AddOffset(StateVariable::VT_VALUE, value);
  }
  explicit StateVariableBuilder(::flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  ::flatbuffers::Offset<StateVariable> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = ::flatbuffers::Offset<StateVariable>(end);
    return o;
  }
};

inline ::flatbuffers::Offset<StateVariable> CreateStateVariable(
    ::flatbuffers::FlatBufferBuilder &_fbb,
    ::flatbuffers::Offset<::flatbuffers::String> key = 0,
    ::flatbuffers::Offset<::flatbuffers::String> value = 0) {
  StateVariableBuilder builder_(_fbb);
  builder_.add_value(value);
  builder_.add_key(key);
  return builder_.Finish();
}

inline ::flatbuffers::Offset<StateVariable> CreateStateVariableDirect(
    ::flatbuffers::FlatBufferBuilder &_fbb,
    const char *key = nullptr,
    const char *value = nullptr) {
  auto key__ = key ? _fbb.CreateString(key) : 0;
  auto value__ = value ? _fbb.CreateString(value) : 0;
  return tflite::gpu::data::CreateStateVariable(
      _fbb,
      key__,
      value__);
}

struct GPUObjectDescriptor FLATBUFFERS_FINAL_CLASS : private ::flatbuffers::Table {
  typedef GPUObjectDescriptorBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_STATE_VARS = 4,
    VT_ACCESS_TYPE = 6
  };
  const ::flatbuffers::Vector<::flatbuffers::Offset<tflite::gpu::data::StateVariable>> *state_vars() const {
    return GetPointer<const ::flatbuffers::Vector<::flatbuffers::Offset<tflite::gpu::data::StateVariable>> *>(VT_STATE_VARS);
  }
  tflite::gpu::data::AccessType access_type() const {
    return static_cast<tflite::gpu::data::AccessType>(GetField<int8_t>(VT_ACCESS_TYPE, 0));
  }
  bool Verify(::flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyOffset(verifier, VT_STATE_VARS) &&
           verifier.VerifyVector(state_vars()) &&
           verifier.VerifyVectorOfTables(state_vars()) &&
           VerifyField<int8_t>(verifier, VT_ACCESS_TYPE, 1) &&
           verifier.EndTable();
  }
};

struct GPUObjectDescriptorBuilder {
  typedef GPUObjectDescriptor Table;
  ::flatbuffers::FlatBufferBuilder &fbb_;
  ::flatbuffers::uoffset_t start_;
  void add_state_vars(::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<tflite::gpu::data::StateVariable>>> state_vars) {
    fbb_.AddOffset(GPUObjectDescriptor::VT_STATE_VARS, state_vars);
  }
  void add_access_type(tflite::gpu::data::AccessType access_type) {
    fbb_.AddElement<int8_t>(GPUObjectDescriptor::VT_ACCESS_TYPE, static_cast<int8_t>(access_type), 0);
  }
  explicit GPUObjectDescriptorBuilder(::flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  ::flatbuffers::Offset<GPUObjectDescriptor> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = ::flatbuffers::Offset<GPUObjectDescriptor>(end);
    return o;
  }
};

inline ::flatbuffers::Offset<GPUObjectDescriptor> CreateGPUObjectDescriptor(
    ::flatbuffers::FlatBufferBuilder &_fbb,
    ::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<tflite::gpu::data::StateVariable>>> state_vars = 0,
    tflite::gpu::data::AccessType access_type = tflite::gpu::data::AccessType::READ) {
  GPUObjectDescriptorBuilder builder_(_fbb);
  builder_.add_state_vars(state_vars);
  builder_.add_access_type(access_type);
  return builder_.Finish();
}

inline ::flatbuffers::Offset<GPUObjectDescriptor> CreateGPUObjectDescriptorDirect(
    ::flatbuffers::FlatBufferBuilder &_fbb,
    const std::vector<::flatbuffers::Offset<tflite::gpu::data::StateVariable>> *state_vars = nullptr,
    tflite::gpu::data::AccessType access_type = tflite::gpu::data::AccessType::READ) {
  auto state_vars__ = state_vars ? _fbb.CreateVector<::flatbuffers::Offset<tflite::gpu::data::StateVariable>>(*state_vars) : 0;
  return tflite::gpu::data::CreateGPUObjectDescriptor(
      _fbb,
      state_vars__,
      access_type);
}

struct IntValue FLATBUFFERS_FINAL_CLASS : private ::flatbuffers::Table {
  typedef IntValueBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_NAME = 4,
    VT_VALUE = 6,
    VT_ACTIVE = 8
  };
  const ::flatbuffers::String *name() const {
    return GetPointer<const ::flatbuffers::String *>(VT_NAME);
  }
  int32_t value() const {
    return GetField<int32_t>(VT_VALUE, 0);
  }
  bool active() const {
    return GetField<uint8_t>(VT_ACTIVE, 0) != 0;
  }
  bool Verify(::flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyOffset(verifier, VT_NAME) &&
           verifier.VerifyString(name()) &&
           VerifyField<int32_t>(verifier, VT_VALUE, 4) &&
           VerifyField<uint8_t>(verifier, VT_ACTIVE, 1) &&
           verifier.EndTable();
  }
};

struct IntValueBuilder {
  typedef IntValue Table;
  ::flatbuffers::FlatBufferBuilder &fbb_;
  ::flatbuffers::uoffset_t start_;
  void add_name(::flatbuffers::Offset<::flatbuffers::String> name) {
    fbb_.AddOffset(IntValue::VT_NAME, name);
  }
  void add_value(int32_t value) {
    fbb_.AddElement<int32_t>(IntValue::VT_VALUE, value, 0);
  }
  void add_active(bool active) {
    fbb_.AddElement<uint8_t>(IntValue::VT_ACTIVE, static_cast<uint8_t>(active), 0);
  }
  explicit IntValueBuilder(::flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  ::flatbuffers::Offset<IntValue> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = ::flatbuffers::Offset<IntValue>(end);
    return o;
  }
};

inline ::flatbuffers::Offset<IntValue> CreateIntValue(
    ::flatbuffers::FlatBufferBuilder &_fbb,
    ::flatbuffers::Offset<::flatbuffers::String> name = 0,
    int32_t value = 0,
    bool active = false) {
  IntValueBuilder builder_(_fbb);
  builder_.add_value(value);
  builder_.add_name(name);
  builder_.add_active(active);
  return builder_.Finish();
}

inline ::flatbuffers::Offset<IntValue> CreateIntValueDirect(
    ::flatbuffers::FlatBufferBuilder &_fbb,
    const char *name = nullptr,
    int32_t value = 0,
    bool active = false) {
  auto name__ = name ? _fbb.CreateString(name) : 0;
  return tflite::gpu::data::CreateIntValue(
      _fbb,
      name__,
      value,
      active);
}

struct FloatValue FLATBUFFERS_FINAL_CLASS : private ::flatbuffers::Table {
  typedef FloatValueBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_NAME = 4,
    VT_VALUE = 6,
    VT_ACTIVE = 8
  };
  const ::flatbuffers::String *name() const {
    return GetPointer<const ::flatbuffers::String *>(VT_NAME);
  }
  float value() const {
    return GetField<float>(VT_VALUE, 0.0f);
  }
  bool active() const {
    return GetField<uint8_t>(VT_ACTIVE, 0) != 0;
  }
  bool Verify(::flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyOffset(verifier, VT_NAME) &&
           verifier.VerifyString(name()) &&
           VerifyField<float>(verifier, VT_VALUE, 4) &&
           VerifyField<uint8_t>(verifier, VT_ACTIVE, 1) &&
           verifier.EndTable();
  }
};

struct FloatValueBuilder {
  typedef FloatValue Table;
  ::flatbuffers::FlatBufferBuilder &fbb_;
  ::flatbuffers::uoffset_t start_;
  void add_name(::flatbuffers::Offset<::flatbuffers::String> name) {
    fbb_.AddOffset(FloatValue::VT_NAME, name);
  }
  void add_value(float value) {
    fbb_.AddElement<float>(FloatValue::VT_VALUE, value, 0.0f);
  }
  void add_active(bool active) {
    fbb_.AddElement<uint8_t>(FloatValue::VT_ACTIVE, static_cast<uint8_t>(active), 0);
  }
  explicit FloatValueBuilder(::flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  ::flatbuffers::Offset<FloatValue> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = ::flatbuffers::Offset<FloatValue>(end);
    return o;
  }
};

inline ::flatbuffers::Offset<FloatValue> CreateFloatValue(
    ::flatbuffers::FlatBufferBuilder &_fbb,
    ::flatbuffers::Offset<::flatbuffers::String> name = 0,
    float value = 0.0f,
    bool active = false) {
  FloatValueBuilder builder_(_fbb);
  builder_.add_value(value);
  builder_.add_name(name);
  builder_.add_active(active);
  return builder_.Finish();
}

inline ::flatbuffers::Offset<FloatValue> CreateFloatValueDirect(
    ::flatbuffers::FlatBufferBuilder &_fbb,
    const char *name = nullptr,
    float value = 0.0f,
    bool active = false) {
  auto name__ = name ? _fbb.CreateString(name) : 0;
  return tflite::gpu::data::CreateFloatValue(
      _fbb,
      name__,
      value,
      active);
}

struct HalfValue FLATBUFFERS_FINAL_CLASS : private ::flatbuffers::Table {
  typedef HalfValueBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_NAME = 4,
    VT_VALUE = 6,
    VT_ACTIVE = 8
  };
  const ::flatbuffers::String *name() const {
    return GetPointer<const ::flatbuffers::String *>(VT_NAME);
  }
  float value() const {
    return GetField<float>(VT_VALUE, 0.0f);
  }
  bool active() const {
    return GetField<uint8_t>(VT_ACTIVE, 0) != 0;
  }
  bool Verify(::flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyOffset(verifier, VT_NAME) &&
           verifier.VerifyString(name()) &&
           VerifyField<float>(verifier, VT_VALUE, 4) &&
           VerifyField<uint8_t>(verifier, VT_ACTIVE, 1) &&
           verifier.EndTable();
  }
};

struct HalfValueBuilder {
  typedef HalfValue Table;
  ::flatbuffers::FlatBufferBuilder &fbb_;
  ::flatbuffers::uoffset_t start_;
  void add_name(::flatbuffers::Offset<::flatbuffers::String> name) {
    fbb_.AddOffset(HalfValue::VT_NAME, name);
  }
  void add_value(float value) {
    fbb_.AddElement<float>(HalfValue::VT_VALUE, value, 0.0f);
  }
  void add_active(bool active) {
    fbb_.AddElement<uint8_t>(HalfValue::VT_ACTIVE, static_cast<uint8_t>(active), 0);
  }
  explicit HalfValueBuilder(::flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  ::flatbuffers::Offset<HalfValue> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = ::flatbuffers::Offset<HalfValue>(end);
    return o;
  }
};

inline ::flatbuffers::Offset<HalfValue> CreateHalfValue(
    ::flatbuffers::FlatBufferBuilder &_fbb,
    ::flatbuffers::Offset<::flatbuffers::String> name = 0,
    float value = 0.0f,
    bool active = false) {
  HalfValueBuilder builder_(_fbb);
  builder_.add_value(value);
  builder_.add_name(name);
  builder_.add_active(active);
  return builder_.Finish();
}

inline ::flatbuffers::Offset<HalfValue> CreateHalfValueDirect(
    ::flatbuffers::FlatBufferBuilder &_fbb,
    const char *name = nullptr,
    float value = 0.0f,
    bool active = false) {
  auto name__ = name ? _fbb.CreateString(name) : 0;
  return tflite::gpu::data::CreateHalfValue(
      _fbb,
      name__,
      value,
      active);
}

struct BufferDescriptor FLATBUFFERS_FINAL_CLASS : private ::flatbuffers::Table {
  typedef BufferDescriptorBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_BASE_OBJ = 4,
    VT_ELEMENT_TYPE = 6,
    VT_ELEMENT_SIZE = 8,
    VT_MEMORY_TYPE = 10,
    VT_ATTRIBUTES = 12,
    VT_SIZE = 14,
    VT_DATA = 16
  };
  const tflite::gpu::data::GPUObjectDescriptor *base_obj() const {
    return GetPointer<const tflite::gpu::data::GPUObjectDescriptor *>(VT_BASE_OBJ);
  }
  tflite::gpu::data::DataType element_type() const {
    return static_cast<tflite::gpu::data::DataType>(GetField<int8_t>(VT_ELEMENT_TYPE, 0));
  }
  int32_t element_size() const {
    return GetField<int32_t>(VT_ELEMENT_SIZE, 0);
  }
  tflite::gpu::data::MemoryType memory_type() const {
    return static_cast<tflite::gpu::data::MemoryType>(GetField<int8_t>(VT_MEMORY_TYPE, 0));
  }
  const ::flatbuffers::Vector<::flatbuffers::Offset<::flatbuffers::String>> *attributes() const {
    return GetPointer<const ::flatbuffers::Vector<::flatbuffers::Offset<::flatbuffers::String>> *>(VT_ATTRIBUTES);
  }
  int32_t size() const {
    return GetField<int32_t>(VT_SIZE, 0);
  }
  const ::flatbuffers::Vector<uint8_t> *data() const {
    return GetPointer<const ::flatbuffers::Vector<uint8_t> *>(VT_DATA);
  }
  bool Verify(::flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyOffset(verifier, VT_BASE_OBJ) &&
           verifier.VerifyTable(base_obj()) &&
           VerifyField<int8_t>(verifier, VT_ELEMENT_TYPE, 1) &&
           VerifyField<int32_t>(verifier, VT_ELEMENT_SIZE, 4) &&
           VerifyField<int8_t>(verifier, VT_MEMORY_TYPE, 1) &&
           VerifyOffset(verifier, VT_ATTRIBUTES) &&
           verifier.VerifyVector(attributes()) &&
           verifier.VerifyVectorOfStrings(attributes()) &&
           VerifyField<int32_t>(verifier, VT_SIZE, 4) &&
           VerifyOffset(verifier, VT_DATA) &&
           verifier.VerifyVector(data()) &&
           verifier.EndTable();
  }
};

struct BufferDescriptorBuilder {
  typedef BufferDescriptor Table;
  ::flatbuffers::FlatBufferBuilder &fbb_;
  ::flatbuffers::uoffset_t start_;
  void add_base_obj(::flatbuffers::Offset<tflite::gpu::data::GPUObjectDescriptor> base_obj) {
    fbb_.AddOffset(BufferDescriptor::VT_BASE_OBJ, base_obj);
  }
  void add_element_type(tflite::gpu::data::DataType element_type) {
    fbb_.AddElement<int8_t>(BufferDescriptor::VT_ELEMENT_TYPE, static_cast<int8_t>(element_type), 0);
  }
  void add_element_size(int32_t element_size) {
    fbb_.AddElement<int32_t>(BufferDescriptor::VT_ELEMENT_SIZE, element_size, 0);
  }
  void add_memory_type(tflite::gpu::data::MemoryType memory_type) {
    fbb_.AddElement<int8_t>(BufferDescriptor::VT_MEMORY_TYPE, static_cast<int8_t>(memory_type), 0);
  }
  void add_attributes(::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<::flatbuffers::String>>> attributes) {
    fbb_.AddOffset(BufferDescriptor::VT_ATTRIBUTES, attributes);
  }
  void add_size(int32_t size) {
    fbb_.AddElement<int32_t>(BufferDescriptor::VT_SIZE, size, 0);
  }
  void add_data(::flatbuffers::Offset<::flatbuffers::Vector<uint8_t>> data) {
    fbb_.AddOffset(BufferDescriptor::VT_DATA, data);
  }
  explicit BufferDescriptorBuilder(::flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  ::flatbuffers::Offset<BufferDescriptor> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = ::flatbuffers::Offset<BufferDescriptor>(end);
    return o;
  }
};

inline ::flatbuffers::Offset<BufferDescriptor> CreateBufferDescriptor(
    ::flatbuffers::FlatBufferBuilder &_fbb,
    ::flatbuffers::Offset<tflite::gpu::data::GPUObjectDescriptor> base_obj = 0,
    tflite::gpu::data::DataType element_type = tflite::gpu::data::DataType::UNKNOWN,
    int32_t element_size = 0,
    tflite::gpu::data::MemoryType memory_type = tflite::gpu::data::MemoryType::GLOBAL,
    ::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<::flatbuffers::String>>> attributes = 0,
    int32_t size = 0,
    ::flatbuffers::Offset<::flatbuffers::Vector<uint8_t>> data = 0) {
  BufferDescriptorBuilder builder_(_fbb);
  builder_.add_data(data);
  builder_.add_size(size);
  builder_.add_attributes(attributes);
  builder_.add_element_size(element_size);
  builder_.add_base_obj(base_obj);
  builder_.add_memory_type(memory_type);
  builder_.add_element_type(element_type);
  return builder_.Finish();
}

inline ::flatbuffers::Offset<BufferDescriptor> CreateBufferDescriptorDirect(
    ::flatbuffers::FlatBufferBuilder &_fbb,
    ::flatbuffers::Offset<tflite::gpu::data::GPUObjectDescriptor> base_obj = 0,
    tflite::gpu::data::DataType element_type = tflite::gpu::data::DataType::UNKNOWN,
    int32_t element_size = 0,
    tflite::gpu::data::MemoryType memory_type = tflite::gpu::data::MemoryType::GLOBAL,
    const std::vector<::flatbuffers::Offset<::flatbuffers::String>> *attributes = nullptr,
    int32_t size = 0,
    const std::vector<uint8_t> *data = nullptr) {
  auto attributes__ = attributes ? _fbb.CreateVector<::flatbuffers::Offset<::flatbuffers::String>>(*attributes) : 0;
  auto data__ = data ? _fbb.CreateVector<uint8_t>(*data) : 0;
  return tflite::gpu::data::CreateBufferDescriptor(
      _fbb,
      base_obj,
      element_type,
      element_size,
      memory_type,
      attributes__,
      size,
      data__);
}

struct BHWDC FLATBUFFERS_FINAL_CLASS : private ::flatbuffers::Table {
  typedef BHWDCBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_B = 4,
    VT_H = 6,
    VT_W = 8,
    VT_D = 10,
    VT_C = 12
  };
  int32_t b() const {
    return GetField<int32_t>(VT_B, 0);
  }
  int32_t h() const {
    return GetField<int32_t>(VT_H, 0);
  }
  int32_t w() const {
    return GetField<int32_t>(VT_W, 0);
  }
  int32_t d() const {
    return GetField<int32_t>(VT_D, 0);
  }
  int32_t c() const {
    return GetField<int32_t>(VT_C, 0);
  }
  bool Verify(::flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyField<int32_t>(verifier, VT_B, 4) &&
           VerifyField<int32_t>(verifier, VT_H, 4) &&
           VerifyField<int32_t>(verifier, VT_W, 4) &&
           VerifyField<int32_t>(verifier, VT_D, 4) &&
           VerifyField<int32_t>(verifier, VT_C, 4) &&
           verifier.EndTable();
  }
};

struct BHWDCBuilder {
  typedef BHWDC Table;
  ::flatbuffers::FlatBufferBuilder &fbb_;
  ::flatbuffers::uoffset_t start_;
  void add_b(int32_t b) {
    fbb_.AddElement<int32_t>(BHWDC::VT_B, b, 0);
  }
  void add_h(int32_t h) {
    fbb_.AddElement<int32_t>(BHWDC::VT_H, h, 0);
  }
  void add_w(int32_t w) {
    fbb_.AddElement<int32_t>(BHWDC::VT_W, w, 0);
  }
  void add_d(int32_t d) {
    fbb_.AddElement<int32_t>(BHWDC::VT_D, d, 0);
  }
  void add_c(int32_t c) {
    fbb_.AddElement<int32_t>(BHWDC::VT_C, c, 0);
  }
  explicit BHWDCBuilder(::flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  ::flatbuffers::Offset<BHWDC> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = ::flatbuffers::Offset<BHWDC>(end);
    return o;
  }
};

inline ::flatbuffers::Offset<BHWDC> CreateBHWDC(
    ::flatbuffers::FlatBufferBuilder &_fbb,
    int32_t b = 0,
    int32_t h = 0,
    int32_t w = 0,
    int32_t d = 0,
    int32_t c = 0) {
  BHWDCBuilder builder_(_fbb);
  builder_.add_c(c);
  builder_.add_d(d);
  builder_.add_w(w);
  builder_.add_h(h);
  builder_.add_b(b);
  return builder_.Finish();
}

struct TensorDescriptor FLATBUFFERS_FINAL_CLASS : private ::flatbuffers::Table {
  typedef TensorDescriptorBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_BASE_OBJ = 4,
    VT_DATA_TYPE = 6,
    VT_STORAGE_TYPE = 8,
    VT_LAYOUT = 10,
    VT_SHAPE = 12,
    VT_DATA = 14,
    VT_USE_BUFFER_FOR_WRITE_ONLY_2D_TEXTURE = 16,
    VT_USE_BUFFER_FOR_WRITE_ONLY_IMAGE_BUFFER = 18
  };
  const tflite::gpu::data::GPUObjectDescriptor *base_obj() const {
    return GetPointer<const tflite::gpu::data::GPUObjectDescriptor *>(VT_BASE_OBJ);
  }
  tflite::gpu::data::DataType data_type() const {
    return static_cast<tflite::gpu::data::DataType>(GetField<int8_t>(VT_DATA_TYPE, 0));
  }
  tflite::gpu::data::TensorStorageType storage_type() const {
    return static_cast<tflite::gpu::data::TensorStorageType>(GetField<int8_t>(VT_STORAGE_TYPE, 0));
  }
  tflite::gpu::data::Layout layout() const {
    return static_cast<tflite::gpu::data::Layout>(GetField<int8_t>(VT_LAYOUT, 0));
  }
  const tflite::gpu::data::BHWDC *shape() const {
    return GetPointer<const tflite::gpu::data::BHWDC *>(VT_SHAPE);
  }
  const ::flatbuffers::Vector<uint8_t> *data() const {
    return GetPointer<const ::flatbuffers::Vector<uint8_t> *>(VT_DATA);
  }
  bool use_buffer_for_write_only_2d_texture() const {
    return GetField<uint8_t>(VT_USE_BUFFER_FOR_WRITE_ONLY_2D_TEXTURE, 0) != 0;
  }
  bool use_buffer_for_write_only_image_buffer() const {
    return GetField<uint8_t>(VT_USE_BUFFER_FOR_WRITE_ONLY_IMAGE_BUFFER, 0) != 0;
  }
  bool Verify(::flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyOffset(verifier, VT_BASE_OBJ) &&
           verifier.VerifyTable(base_obj()) &&
           VerifyField<int8_t>(verifier, VT_DATA_TYPE, 1) &&
           VerifyField<int8_t>(verifier, VT_STORAGE_TYPE, 1) &&
           VerifyField<int8_t>(verifier, VT_LAYOUT, 1) &&
           VerifyOffset(verifier, VT_SHAPE) &&
           verifier.VerifyTable(shape()) &&
           VerifyOffset(verifier, VT_DATA) &&
           verifier.VerifyVector(data()) &&
           VerifyField<uint8_t>(verifier, VT_USE_BUFFER_FOR_WRITE_ONLY_2D_TEXTURE, 1) &&
           VerifyField<uint8_t>(verifier, VT_USE_BUFFER_FOR_WRITE_ONLY_IMAGE_BUFFER, 1) &&
           verifier.EndTable();
  }
};

struct TensorDescriptorBuilder {
  typedef TensorDescriptor Table;
  ::flatbuffers::FlatBufferBuilder &fbb_;
  ::flatbuffers::uoffset_t start_;
  void add_base_obj(::flatbuffers::Offset<tflite::gpu::data::GPUObjectDescriptor> base_obj) {
    fbb_.AddOffset(TensorDescriptor::VT_BASE_OBJ, base_obj);
  }
  void add_data_type(tflite::gpu::data::DataType data_type) {
    fbb_.AddElement<int8_t>(TensorDescriptor::VT_DATA_TYPE, static_cast<int8_t>(data_type), 0);
  }
  void add_storage_type(tflite::gpu::data::TensorStorageType storage_type) {
    fbb_.AddElement<int8_t>(TensorDescriptor::VT_STORAGE_TYPE, static_cast<int8_t>(storage_type), 0);
  }
  void add_layout(tflite::gpu::data::Layout layout) {
    fbb_.AddElement<int8_t>(TensorDescriptor::VT_LAYOUT, static_cast<int8_t>(layout), 0);
  }
  void add_shape(::flatbuffers::Offset<tflite::gpu::data::BHWDC> shape) {
    fbb_.AddOffset(TensorDescriptor::VT_SHAPE, shape);
  }
  void add_data(::flatbuffers::Offset<::flatbuffers::Vector<uint8_t>> data) {
    fbb_.AddOffset(TensorDescriptor::VT_DATA, data);
  }
  void add_use_buffer_for_write_only_2d_texture(bool use_buffer_for_write_only_2d_texture) {
    fbb_.AddElement<uint8_t>(TensorDescriptor::VT_USE_BUFFER_FOR_WRITE_ONLY_2D_TEXTURE, static_cast<uint8_t>(use_buffer_for_write_only_2d_texture), 0);
  }
  void add_use_buffer_for_write_only_image_buffer(bool use_buffer_for_write_only_image_buffer) {
    fbb_.AddElement<uint8_t>(TensorDescriptor::VT_USE_BUFFER_FOR_WRITE_ONLY_IMAGE_BUFFER, static_cast<uint8_t>(use_buffer_for_write_only_image_buffer), 0);
  }
  explicit TensorDescriptorBuilder(::flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  ::flatbuffers::Offset<TensorDescriptor> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = ::flatbuffers::Offset<TensorDescriptor>(end);
    return o;
  }
};

inline ::flatbuffers::Offset<TensorDescriptor> CreateTensorDescriptor(
    ::flatbuffers::FlatBufferBuilder &_fbb,
    ::flatbuffers::Offset<tflite::gpu::data::GPUObjectDescriptor> base_obj = 0,
    tflite::gpu::data::DataType data_type = tflite::gpu::data::DataType::UNKNOWN,
    tflite::gpu::data::TensorStorageType storage_type = tflite::gpu::data::TensorStorageType::UNKNOWN,
    tflite::gpu::data::Layout layout = tflite::gpu::data::Layout::UNKNOWN,
    ::flatbuffers::Offset<tflite::gpu::data::BHWDC> shape = 0,
    ::flatbuffers::Offset<::flatbuffers::Vector<uint8_t>> data = 0,
    bool use_buffer_for_write_only_2d_texture = false,
    bool use_buffer_for_write_only_image_buffer = false) {
  TensorDescriptorBuilder builder_(_fbb);
  builder_.add_data(data);
  builder_.add_shape(shape);
  builder_.add_base_obj(base_obj);
  builder_.add_use_buffer_for_write_only_image_buffer(use_buffer_for_write_only_image_buffer);
  builder_.add_use_buffer_for_write_only_2d_texture(use_buffer_for_write_only_2d_texture);
  builder_.add_layout(layout);
  builder_.add_storage_type(storage_type);
  builder_.add_data_type(data_type);
  return builder_.Finish();
}

inline ::flatbuffers::Offset<TensorDescriptor> CreateTensorDescriptorDirect(
    ::flatbuffers::FlatBufferBuilder &_fbb,
    ::flatbuffers::Offset<tflite::gpu::data::GPUObjectDescriptor> base_obj = 0,
    tflite::gpu::data::DataType data_type = tflite::gpu::data::DataType::UNKNOWN,
    tflite::gpu::data::TensorStorageType storage_type = tflite::gpu::data::TensorStorageType::UNKNOWN,
    tflite::gpu::data::Layout layout = tflite::gpu::data::Layout::UNKNOWN,
    ::flatbuffers::Offset<tflite::gpu::data::BHWDC> shape = 0,
    const std::vector<uint8_t> *data = nullptr,
    bool use_buffer_for_write_only_2d_texture = false,
    bool use_buffer_for_write_only_image_buffer = false) {
  auto data__ = data ? _fbb.CreateVector<uint8_t>(*data) : 0;
  return tflite::gpu::data::CreateTensorDescriptor(
      _fbb,
      base_obj,
      data_type,
      storage_type,
      layout,
      shape,
      data__,
      use_buffer_for_write_only_2d_texture,
      use_buffer_for_write_only_image_buffer);
}

struct BufferDescriptorMapValue FLATBUFFERS_FINAL_CLASS : private ::flatbuffers::Table {
  typedef BufferDescriptorMapValueBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_KEY = 4,
    VT_VALUE = 6
  };
  const ::flatbuffers::String *key() const {
    return GetPointer<const ::flatbuffers::String *>(VT_KEY);
  }
  const tflite::gpu::data::BufferDescriptor *value() const {
    return GetPointer<const tflite::gpu::data::BufferDescriptor *>(VT_VALUE);
  }
  bool Verify(::flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyOffset(verifier, VT_KEY) &&
           verifier.VerifyString(key()) &&
           VerifyOffset(verifier, VT_VALUE) &&
           verifier.VerifyTable(value()) &&
           verifier.EndTable();
  }
};

struct BufferDescriptorMapValueBuilder {
  typedef BufferDescriptorMapValue Table;
  ::flatbuffers::FlatBufferBuilder &fbb_;
  ::flatbuffers::uoffset_t start_;
  void add_key(::flatbuffers::Offset<::flatbuffers::String> key) {
    fbb_.AddOffset(BufferDescriptorMapValue::VT_KEY, key);
  }
  void add_value(::flatbuffers::Offset<tflite::gpu::data::BufferDescriptor> value) {
    fbb_.AddOffset(BufferDescriptorMapValue::VT_VALUE, value);
  }
  explicit BufferDescriptorMapValueBuilder(::flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  ::flatbuffers::Offset<BufferDescriptorMapValue> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = ::flatbuffers::Offset<BufferDescriptorMapValue>(end);
    return o;
  }
};

inline ::flatbuffers::Offset<BufferDescriptorMapValue> CreateBufferDescriptorMapValue(
    ::flatbuffers::FlatBufferBuilder &_fbb,
    ::flatbuffers::Offset<::flatbuffers::String> key = 0,
    ::flatbuffers::Offset<tflite::gpu::data::BufferDescriptor> value = 0) {
  BufferDescriptorMapValueBuilder builder_(_fbb);
  builder_.add_value(value);
  builder_.add_key(key);
  return builder_.Finish();
}

inline ::flatbuffers::Offset<BufferDescriptorMapValue> CreateBufferDescriptorMapValueDirect(
    ::flatbuffers::FlatBufferBuilder &_fbb,
    const char *key = nullptr,
    ::flatbuffers::Offset<tflite::gpu::data::BufferDescriptor> value = 0) {
  auto key__ = key ? _fbb.CreateString(key) : 0;
  return tflite::gpu::data::CreateBufferDescriptorMapValue(
      _fbb,
      key__,
      value);
}

struct TensorDescriptorMapValue FLATBUFFERS_FINAL_CLASS : private ::flatbuffers::Table {
  typedef TensorDescriptorMapValueBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_KEY = 4,
    VT_VALUE = 6
  };
  const ::flatbuffers::String *key() const {
    return GetPointer<const ::flatbuffers::String *>(VT_KEY);
  }
  const tflite::gpu::data::TensorDescriptor *value() const {
    return GetPointer<const tflite::gpu::data::TensorDescriptor *>(VT_VALUE);
  }
  bool Verify(::flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyOffset(verifier, VT_KEY) &&
           verifier.VerifyString(key()) &&
           VerifyOffset(verifier, VT_VALUE) &&
           verifier.VerifyTable(value()) &&
           verifier.EndTable();
  }
};

struct TensorDescriptorMapValueBuilder {
  typedef TensorDescriptorMapValue Table;
  ::flatbuffers::FlatBufferBuilder &fbb_;
  ::flatbuffers::uoffset_t start_;
  void add_key(::flatbuffers::Offset<::flatbuffers::String> key) {
    fbb_.AddOffset(TensorDescriptorMapValue::VT_KEY, key);
  }
  void add_value(::flatbuffers::Offset<tflite::gpu::data::TensorDescriptor> value) {
    fbb_.AddOffset(TensorDescriptorMapValue::VT_VALUE, value);
  }
  explicit TensorDescriptorMapValueBuilder(::flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  ::flatbuffers::Offset<TensorDescriptorMapValue> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = ::flatbuffers::Offset<TensorDescriptorMapValue>(end);
    return o;
  }
};

inline ::flatbuffers::Offset<TensorDescriptorMapValue> CreateTensorDescriptorMapValue(
    ::flatbuffers::FlatBufferBuilder &_fbb,
    ::flatbuffers::Offset<::flatbuffers::String> key = 0,
    ::flatbuffers::Offset<tflite::gpu::data::TensorDescriptor> value = 0) {
  TensorDescriptorMapValueBuilder builder_(_fbb);
  builder_.add_value(value);
  builder_.add_key(key);
  return builder_.Finish();
}

inline ::flatbuffers::Offset<TensorDescriptorMapValue> CreateTensorDescriptorMapValueDirect(
    ::flatbuffers::FlatBufferBuilder &_fbb,
    const char *key = nullptr,
    ::flatbuffers::Offset<tflite::gpu::data::TensorDescriptor> value = 0) {
  auto key__ = key ? _fbb.CreateString(key) : 0;
  return tflite::gpu::data::CreateTensorDescriptorMapValue(
      _fbb,
      key__,
      value);
}

struct Arguments FLATBUFFERS_FINAL_CLASS : private ::flatbuffers::Table {
  typedef ArgumentsBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_INT_VALUES = 4,
    VT_FLOAT_VALUES = 6,
    VT_HALF_VALUES = 8,
    VT_BUFFER_REFS = 10,
    VT_TENSOR_REFS = 12,
    VT_BUFFER_OBJECTS = 14,
    VT_TENSOR_OBJECTS = 16
  };
  const ::flatbuffers::Vector<::flatbuffers::Offset<tflite::gpu::data::IntValue>> *int_values() const {
    return GetPointer<const ::flatbuffers::Vector<::flatbuffers::Offset<tflite::gpu::data::IntValue>> *>(VT_INT_VALUES);
  }
  const ::flatbuffers::Vector<::flatbuffers::Offset<tflite::gpu::data::FloatValue>> *float_values() const {
    return GetPointer<const ::flatbuffers::Vector<::flatbuffers::Offset<tflite::gpu::data::FloatValue>> *>(VT_FLOAT_VALUES);
  }
  const ::flatbuffers::Vector<::flatbuffers::Offset<tflite::gpu::data::HalfValue>> *half_values() const {
    return GetPointer<const ::flatbuffers::Vector<::flatbuffers::Offset<tflite::gpu::data::HalfValue>> *>(VT_HALF_VALUES);
  }
  const ::flatbuffers::Vector<::flatbuffers::Offset<tflite::gpu::data::BufferDescriptorMapValue>> *buffer_refs() const {
    return GetPointer<const ::flatbuffers::Vector<::flatbuffers::Offset<tflite::gpu::data::BufferDescriptorMapValue>> *>(VT_BUFFER_REFS);
  }
  const ::flatbuffers::Vector<::flatbuffers::Offset<tflite::gpu::data::TensorDescriptorMapValue>> *tensor_refs() const {
    return GetPointer<const ::flatbuffers::Vector<::flatbuffers::Offset<tflite::gpu::data::TensorDescriptorMapValue>> *>(VT_TENSOR_REFS);
  }
  const ::flatbuffers::Vector<::flatbuffers::Offset<tflite::gpu::data::BufferDescriptorMapValue>> *buffer_objects() const {
    return GetPointer<const ::flatbuffers::Vector<::flatbuffers::Offset<tflite::gpu::data::BufferDescriptorMapValue>> *>(VT_BUFFER_OBJECTS);
  }
  const ::flatbuffers::Vector<::flatbuffers::Offset<tflite::gpu::data::TensorDescriptorMapValue>> *tensor_objects() const {
    return GetPointer<const ::flatbuffers::Vector<::flatbuffers::Offset<tflite::gpu::data::TensorDescriptorMapValue>> *>(VT_TENSOR_OBJECTS);
  }
  bool Verify(::flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyOffset(verifier, VT_INT_VALUES) &&
           verifier.VerifyVector(int_values()) &&
           verifier.VerifyVectorOfTables(int_values()) &&
           VerifyOffset(verifier, VT_FLOAT_VALUES) &&
           verifier.VerifyVector(float_values()) &&
           verifier.VerifyVectorOfTables(float_values()) &&
           VerifyOffset(verifier, VT_HALF_VALUES) &&
           verifier.VerifyVector(half_values()) &&
           verifier.VerifyVectorOfTables(half_values()) &&
           VerifyOffset(verifier, VT_BUFFER_REFS) &&
           verifier.VerifyVector(buffer_refs()) &&
           verifier.VerifyVectorOfTables(buffer_refs()) &&
           VerifyOffset(verifier, VT_TENSOR_REFS) &&
           verifier.VerifyVector(tensor_refs()) &&
           verifier.VerifyVectorOfTables(tensor_refs()) &&
           VerifyOffset(verifier, VT_BUFFER_OBJECTS) &&
           verifier.VerifyVector(buffer_objects()) &&
           verifier.VerifyVectorOfTables(buffer_objects()) &&
           VerifyOffset(verifier, VT_TENSOR_OBJECTS) &&
           verifier.VerifyVector(tensor_objects()) &&
           verifier.VerifyVectorOfTables(tensor_objects()) &&
           verifier.EndTable();
  }
};

struct ArgumentsBuilder {
  typedef Arguments Table;
  ::flatbuffers::FlatBufferBuilder &fbb_;
  ::flatbuffers::uoffset_t start_;
  void add_int_values(::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<tflite::gpu::data::IntValue>>> int_values) {
    fbb_.AddOffset(Arguments::VT_INT_VALUES, int_values);
  }
  void add_float_values(::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<tflite::gpu::data::FloatValue>>> float_values) {
    fbb_.AddOffset(Arguments::VT_FLOAT_VALUES, float_values);
  }
  void add_half_values(::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<tflite::gpu::data::HalfValue>>> half_values) {
    fbb_.AddOffset(Arguments::VT_HALF_VALUES, half_values);
  }
  void add_buffer_refs(::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<tflite::gpu::data::BufferDescriptorMapValue>>> buffer_refs) {
    fbb_.AddOffset(Arguments::VT_BUFFER_REFS, buffer_refs);
  }
  void add_tensor_refs(::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<tflite::gpu::data::TensorDescriptorMapValue>>> tensor_refs) {
    fbb_.AddOffset(Arguments::VT_TENSOR_REFS, tensor_refs);
  }
  void add_buffer_objects(::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<tflite::gpu::data::BufferDescriptorMapValue>>> buffer_objects) {
    fbb_.AddOffset(Arguments::VT_BUFFER_OBJECTS, buffer_objects);
  }
  void add_tensor_objects(::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<tflite::gpu::data::TensorDescriptorMapValue>>> tensor_objects) {
    fbb_.AddOffset(Arguments::VT_TENSOR_OBJECTS, tensor_objects);
  }
  explicit ArgumentsBuilder(::flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  ::flatbuffers::Offset<Arguments> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = ::flatbuffers::Offset<Arguments>(end);
    return o;
  }
};

inline ::flatbuffers::Offset<Arguments> CreateArguments(
    ::flatbuffers::FlatBufferBuilder &_fbb,
    ::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<tflite::gpu::data::IntValue>>> int_values = 0,
    ::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<tflite::gpu::data::FloatValue>>> float_values = 0,
    ::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<tflite::gpu::data::HalfValue>>> half_values = 0,
    ::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<tflite::gpu::data::BufferDescriptorMapValue>>> buffer_refs = 0,
    ::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<tflite::gpu::data::TensorDescriptorMapValue>>> tensor_refs = 0,
    ::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<tflite::gpu::data::BufferDescriptorMapValue>>> buffer_objects = 0,
    ::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<tflite::gpu::data::TensorDescriptorMapValue>>> tensor_objects = 0) {
  ArgumentsBuilder builder_(_fbb);
  builder_.add_tensor_objects(tensor_objects);
  builder_.add_buffer_objects(buffer_objects);
  builder_.add_tensor_refs(tensor_refs);
  builder_.add_buffer_refs(buffer_refs);
  builder_.add_half_values(half_values);
  builder_.add_float_values(float_values);
  builder_.add_int_values(int_values);
  return builder_.Finish();
}

inline ::flatbuffers::Offset<Arguments> CreateArgumentsDirect(
    ::flatbuffers::FlatBufferBuilder &_fbb,
    const std::vector<::flatbuffers::Offset<tflite::gpu::data::IntValue>> *int_values = nullptr,
    const std::vector<::flatbuffers::Offset<tflite::gpu::data::FloatValue>> *float_values = nullptr,
    const std::vector<::flatbuffers::Offset<tflite::gpu::data::HalfValue>> *half_values = nullptr,
    const std::vector<::flatbuffers::Offset<tflite::gpu::data::BufferDescriptorMapValue>> *buffer_refs = nullptr,
    const std::vector<::flatbuffers::Offset<tflite::gpu::data::TensorDescriptorMapValue>> *tensor_refs = nullptr,
    const std::vector<::flatbuffers::Offset<tflite::gpu::data::BufferDescriptorMapValue>> *buffer_objects = nullptr,
    const std::vector<::flatbuffers::Offset<tflite::gpu::data::TensorDescriptorMapValue>> *tensor_objects = nullptr) {
  auto int_values__ = int_values ? _fbb.CreateVector<::flatbuffers::Offset<tflite::gpu::data::IntValue>>(*int_values) : 0;
  auto float_values__ = float_values ? _fbb.CreateVector<::flatbuffers::Offset<tflite::gpu::data::FloatValue>>(*float_values) : 0;
  auto half_values__ = half_values ? _fbb.CreateVector<::flatbuffers::Offset<tflite::gpu::data::HalfValue>>(*half_values) : 0;
  auto buffer_refs__ = buffer_refs ? _fbb.CreateVector<::flatbuffers::Offset<tflite::gpu::data::BufferDescriptorMapValue>>(*buffer_refs) : 0;
  auto tensor_refs__ = tensor_refs ? _fbb.CreateVector<::flatbuffers::Offset<tflite::gpu::data::TensorDescriptorMapValue>>(*tensor_refs) : 0;
  auto buffer_objects__ = buffer_objects ? _fbb.CreateVector<::flatbuffers::Offset<tflite::gpu::data::BufferDescriptorMapValue>>(*buffer_objects) : 0;
  auto tensor_objects__ = tensor_objects ? _fbb.CreateVector<::flatbuffers::Offset<tflite::gpu::data::TensorDescriptorMapValue>>(*tensor_objects) : 0;
  return tflite::gpu::data::CreateArguments(
      _fbb,
      int_values__,
      float_values__,
      half_values__,
      buffer_refs__,
      tensor_refs__,
      buffer_objects__,
      tensor_objects__);
}

struct OperationDef FLATBUFFERS_FINAL_CLASS : private ::flatbuffers::Table {
  typedef OperationDefBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_PRECISION = 4,
    VT_SRC_TENSORS = 6,
    VT_DST_TENSORS = 8
  };
  tflite::gpu::data::CalculationsPrecision precision() const {
    return static_cast<tflite::gpu::data::CalculationsPrecision>(GetField<int8_t>(VT_PRECISION, 0));
  }
  const ::flatbuffers::Vector<::flatbuffers::Offset<tflite::gpu::data::TensorDescriptor>> *src_tensors() const {
    return GetPointer<const ::flatbuffers::Vector<::flatbuffers::Offset<tflite::gpu::data::TensorDescriptor>> *>(VT_SRC_TENSORS);
  }
  const ::flatbuffers::Vector<::flatbuffers::Offset<tflite::gpu::data::TensorDescriptor>> *dst_tensors() const {
    return GetPointer<const ::flatbuffers::Vector<::flatbuffers::Offset<tflite::gpu::data::TensorDescriptor>> *>(VT_DST_TENSORS);
  }
  bool Verify(::flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyField<int8_t>(verifier, VT_PRECISION, 1) &&
           VerifyOffset(verifier, VT_SRC_TENSORS) &&
           verifier.VerifyVector(src_tensors()) &&
           verifier.VerifyVectorOfTables(src_tensors()) &&
           VerifyOffset(verifier, VT_DST_TENSORS) &&
           verifier.VerifyVector(dst_tensors()) &&
           verifier.VerifyVectorOfTables(dst_tensors()) &&
           verifier.EndTable();
  }
};

struct OperationDefBuilder {
  typedef OperationDef Table;
  ::flatbuffers::FlatBufferBuilder &fbb_;
  ::flatbuffers::uoffset_t start_;
  void add_precision(tflite::gpu::data::CalculationsPrecision precision) {
    fbb_.AddElement<int8_t>(OperationDef::VT_PRECISION, static_cast<int8_t>(precision), 0);
  }
  void add_src_tensors(::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<tflite::gpu::data::TensorDescriptor>>> src_tensors) {
    fbb_.AddOffset(OperationDef::VT_SRC_TENSORS, src_tensors);
  }
  void add_dst_tensors(::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<tflite::gpu::data::TensorDescriptor>>> dst_tensors) {
    fbb_.AddOffset(OperationDef::VT_DST_TENSORS, dst_tensors);
  }
  explicit OperationDefBuilder(::flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  ::flatbuffers::Offset<OperationDef> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = ::flatbuffers::Offset<OperationDef>(end);
    return o;
  }
};

inline ::flatbuffers::Offset<OperationDef> CreateOperationDef(
    ::flatbuffers::FlatBufferBuilder &_fbb,
    tflite::gpu::data::CalculationsPrecision precision = tflite::gpu::data::CalculationsPrecision::F32,
    ::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<tflite::gpu::data::TensorDescriptor>>> src_tensors = 0,
    ::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<tflite::gpu::data::TensorDescriptor>>> dst_tensors = 0) {
  OperationDefBuilder builder_(_fbb);
  builder_.add_dst_tensors(dst_tensors);
  builder_.add_src_tensors(src_tensors);
  builder_.add_precision(precision);
  return builder_.Finish();
}

inline ::flatbuffers::Offset<OperationDef> CreateOperationDefDirect(
    ::flatbuffers::FlatBufferBuilder &_fbb,
    tflite::gpu::data::CalculationsPrecision precision = tflite::gpu::data::CalculationsPrecision::F32,
    const std::vector<::flatbuffers::Offset<tflite::gpu::data::TensorDescriptor>> *src_tensors = nullptr,
    const std::vector<::flatbuffers::Offset<tflite::gpu::data::TensorDescriptor>> *dst_tensors = nullptr) {
  auto src_tensors__ = src_tensors ? _fbb.CreateVector<::flatbuffers::Offset<tflite::gpu::data::TensorDescriptor>>(*src_tensors) : 0;
  auto dst_tensors__ = dst_tensors ? _fbb.CreateVector<::flatbuffers::Offset<tflite::gpu::data::TensorDescriptor>>(*dst_tensors) : 0;
  return tflite::gpu::data::CreateOperationDef(
      _fbb,
      precision,
      src_tensors__,
      dst_tensors__);
}

struct CompilerOption FLATBUFFERS_FINAL_CLASS : private ::flatbuffers::Table {
  typedef CompilerOptionBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_OPTION = 4
  };
  tflite::gpu::data::CompilerOptions option() const {
    return static_cast<tflite::gpu::data::CompilerOptions>(GetField<int8_t>(VT_OPTION, 0));
  }
  bool Verify(::flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyField<int8_t>(verifier, VT_OPTION, 1) &&
           verifier.EndTable();
  }
};

struct CompilerOptionBuilder {
  typedef CompilerOption Table;
  ::flatbuffers::FlatBufferBuilder &fbb_;
  ::flatbuffers::uoffset_t start_;
  void add_option(tflite::gpu::data::CompilerOptions option) {
    fbb_.AddElement<int8_t>(CompilerOption::VT_OPTION, static_cast<int8_t>(option), 0);
  }
  explicit CompilerOptionBuilder(::flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  ::flatbuffers::Offset<CompilerOption> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = ::flatbuffers::Offset<CompilerOption>(end);
    return o;
  }
};

inline ::flatbuffers::Offset<CompilerOption> CreateCompilerOption(
    ::flatbuffers::FlatBufferBuilder &_fbb,
    tflite::gpu::data::CompilerOptions option = tflite::gpu::data::CompilerOptions::ADRENO_FULL_SIMD_LINE) {
  CompilerOptionBuilder builder_(_fbb);
  builder_.add_option(option);
  return builder_.Finish();
}

struct GPUOperation FLATBUFFERS_FINAL_CLASS : private ::flatbuffers::Table {
  typedef GPUOperationBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_ARGUMENTS = 4,
    VT_CODE = 6,
    VT_WORK_GROUP_SIZE = 8,
    VT_COMPILER_OPTIONS = 10,
    VT_TENSOR_TO_GRID = 12,
    VT_FLOPS = 14,
    VT_DEFINITION = 16,
    VT_GRID_DIMENSION = 18,
    VT_WORK_GROUP_LAUNCH_ORDER = 20,
    VT_GRID_SIZE = 22,
    VT_SRC_TENSORS_NAMES = 24,
    VT_DST_TENSORS_NAMES = 26,
    VT_WORK_GROUPS_COUNT = 28
  };
  const tflite::gpu::data::Arguments *arguments() const {
    return GetPointer<const tflite::gpu::data::Arguments *>(VT_ARGUMENTS);
  }
  const ::flatbuffers::String *code() const {
    return GetPointer<const ::flatbuffers::String *>(VT_CODE);
  }
  const tflite::gpu::data::Int3 *work_group_size() const {
    return GetPointer<const tflite::gpu::data::Int3 *>(VT_WORK_GROUP_SIZE);
  }
  const ::flatbuffers::Vector<::flatbuffers::Offset<tflite::gpu::data::CompilerOption>> *compiler_options() const {
    return GetPointer<const ::flatbuffers::Vector<::flatbuffers::Offset<tflite::gpu::data::CompilerOption>> *>(VT_COMPILER_OPTIONS);
  }
  tflite::gpu::data::TensorToGrid tensor_to_grid() const {
    return static_cast<tflite::gpu::data::TensorToGrid>(GetField<int8_t>(VT_TENSOR_TO_GRID, 0));
  }
  uint64_t flops() const {
    return GetField<uint64_t>(VT_FLOPS, 0);
  }
  const tflite::gpu::data::OperationDef *definition() const {
    return GetPointer<const tflite::gpu::data::OperationDef *>(VT_DEFINITION);
  }
  int32_t grid_dimension() const {
    return GetField<int32_t>(VT_GRID_DIMENSION, 0);
  }
  const tflite::gpu::data::Int3 *work_group_launch_order() const {
    return GetPointer<const tflite::gpu::data::Int3 *>(VT_WORK_GROUP_LAUNCH_ORDER);
  }
  const tflite::gpu::data::Int3 *grid_size() const {
    return GetPointer<const tflite::gpu::data::Int3 *>(VT_GRID_SIZE);
  }
  const ::flatbuffers::Vector<::flatbuffers::Offset<::flatbuffers::String>> *src_tensors_names() const {
    return GetPointer<const ::flatbuffers::Vector<::flatbuffers::Offset<::flatbuffers::String>> *>(VT_SRC_TENSORS_NAMES);
  }
  const ::flatbuffers::Vector<::flatbuffers::Offset<::flatbuffers::String>> *dst_tensors_names() const {
    return GetPointer<const ::flatbuffers::Vector<::flatbuffers::Offset<::flatbuffers::String>> *>(VT_DST_TENSORS_NAMES);
  }
  const tflite::gpu::data::Int3 *work_groups_count() const {
    return GetPointer<const tflite::gpu::data::Int3 *>(VT_WORK_GROUPS_COUNT);
  }
  bool Verify(::flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyOffset(verifier, VT_ARGUMENTS) &&
           verifier.VerifyTable(arguments()) &&
           VerifyOffset(verifier, VT_CODE) &&
           verifier.VerifyString(code()) &&
           VerifyOffset(verifier, VT_WORK_GROUP_SIZE) &&
           verifier.VerifyTable(work_group_size()) &&
           VerifyOffset(verifier, VT_COMPILER_OPTIONS) &&
           verifier.VerifyVector(compiler_options()) &&
           verifier.VerifyVectorOfTables(compiler_options()) &&
           VerifyField<int8_t>(verifier, VT_TENSOR_TO_GRID, 1) &&
           VerifyField<uint64_t>(verifier, VT_FLOPS, 8) &&
           VerifyOffset(verifier, VT_DEFINITION) &&
           verifier.VerifyTable(definition()) &&
           VerifyField<int32_t>(verifier, VT_GRID_DIMENSION, 4) &&
           VerifyOffset(verifier, VT_WORK_GROUP_LAUNCH_ORDER) &&
           verifier.VerifyTable(work_group_launch_order()) &&
           VerifyOffset(verifier, VT_GRID_SIZE) &&
           verifier.VerifyTable(grid_size()) &&
           VerifyOffset(verifier, VT_SRC_TENSORS_NAMES) &&
           verifier.VerifyVector(src_tensors_names()) &&
           verifier.VerifyVectorOfStrings(src_tensors_names()) &&
           VerifyOffset(verifier, VT_DST_TENSORS_NAMES) &&
           verifier.VerifyVector(dst_tensors_names()) &&
           verifier.VerifyVectorOfStrings(dst_tensors_names()) &&
           VerifyOffset(verifier, VT_WORK_GROUPS_COUNT) &&
           verifier.VerifyTable(work_groups_count()) &&
           verifier.EndTable();
  }
};

struct GPUOperationBuilder {
  typedef GPUOperation Table;
  ::flatbuffers::FlatBufferBuilder &fbb_;
  ::flatbuffers::uoffset_t start_;
  void add_arguments(::flatbuffers::Offset<tflite::gpu::data::Arguments> arguments) {
    fbb_.AddOffset(GPUOperation::VT_ARGUMENTS, arguments);
  }
  void add_code(::flatbuffers::Offset<::flatbuffers::String> code) {
    fbb_.AddOffset(GPUOperation::VT_CODE, code);
  }
  void add_work_group_size(::flatbuffers::Offset<tflite::gpu::data::Int3> work_group_size) {
    fbb_.AddOffset(GPUOperation::VT_WORK_GROUP_SIZE, work_group_size);
  }
  void add_compiler_options(::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<tflite::gpu::data::CompilerOption>>> compiler_options) {
    fbb_.AddOffset(GPUOperation::VT_COMPILER_OPTIONS, compiler_options);
  }
  void add_tensor_to_grid(tflite::gpu::data::TensorToGrid tensor_to_grid) {
    fbb_.AddElement<int8_t>(GPUOperation::VT_TENSOR_TO_GRID, static_cast<int8_t>(tensor_to_grid), 0);
  }
  void add_flops(uint64_t flops) {
    fbb_.AddElement<uint64_t>(GPUOperation::VT_FLOPS, flops, 0);
  }
  void add_definition(::flatbuffers::Offset<tflite::gpu::data::OperationDef> definition) {
    fbb_.AddOffset(GPUOperation::VT_DEFINITION, definition);
  }
  void add_grid_dimension(int32_t grid_dimension) {
    fbb_.AddElement<int32_t>(GPUOperation::VT_GRID_DIMENSION, grid_dimension, 0);
  }
  void add_work_group_launch_order(::flatbuffers::Offset<tflite::gpu::data::Int3> work_group_launch_order) {
    fbb_.AddOffset(GPUOperation::VT_WORK_GROUP_LAUNCH_ORDER, work_group_launch_order);
  }
  void add_grid_size(::flatbuffers::Offset<tflite::gpu::data::Int3> grid_size) {
    fbb_.AddOffset(GPUOperation::VT_GRID_SIZE, grid_size);
  }
  void add_src_tensors_names(::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<::flatbuffers::String>>> src_tensors_names) {
    fbb_.AddOffset(GPUOperation::VT_SRC_TENSORS_NAMES, src_tensors_names);
  }
  void add_dst_tensors_names(::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<::flatbuffers::String>>> dst_tensors_names) {
    fbb_.AddOffset(GPUOperation::VT_DST_TENSORS_NAMES, dst_tensors_names);
  }
  void add_work_groups_count(::flatbuffers::Offset<tflite::gpu::data::Int3> work_groups_count) {
    fbb_.AddOffset(GPUOperation::VT_WORK_GROUPS_COUNT, work_groups_count);
  }
  explicit GPUOperationBuilder(::flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  ::flatbuffers::Offset<GPUOperation> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = ::flatbuffers::Offset<GPUOperation>(end);
    return o;
  }
};

inline ::flatbuffers::Offset<GPUOperation> CreateGPUOperation(
    ::flatbuffers::FlatBufferBuilder &_fbb,
    ::flatbuffers::Offset<tflite::gpu::data::Arguments> arguments = 0,
    ::flatbuffers::Offset<::flatbuffers::String> code = 0,
    ::flatbuffers::Offset<tflite::gpu::data::Int3> work_group_size = 0,
    ::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<tflite::gpu::data::CompilerOption>>> compiler_options = 0,
    tflite::gpu::data::TensorToGrid tensor_to_grid = tflite::gpu::data::TensorToGrid::CUSTOM,
    uint64_t flops = 0,
    ::flatbuffers::Offset<tflite::gpu::data::OperationDef> definition = 0,
    int32_t grid_dimension = 0,
    ::flatbuffers::Offset<tflite::gpu::data::Int3> work_group_launch_order = 0,
    ::flatbuffers::Offset<tflite::gpu::data::Int3> grid_size = 0,
    ::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<::flatbuffers::String>>> src_tensors_names = 0,
    ::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<::flatbuffers::String>>> dst_tensors_names = 0,
    ::flatbuffers::Offset<tflite::gpu::data::Int3> work_groups_count = 0) {
  GPUOperationBuilder builder_(_fbb);
  builder_.add_flops(flops);
  builder_.add_work_groups_count(work_groups_count);
  builder_.add_dst_tensors_names(dst_tensors_names);
  builder_.add_src_tensors_names(src_tensors_names);
  builder_.add_grid_size(grid_size);
  builder_.add_work_group_launch_order(work_group_launch_order);
  builder_.add_grid_dimension(grid_dimension);
  builder_.add_definition(definition);
  builder_.add_compiler_options(compiler_options);
  builder_.add_work_group_size(work_group_size);
  builder_.add_code(code);
  builder_.add_arguments(arguments);
  builder_.add_tensor_to_grid(tensor_to_grid);
  return builder_.Finish();
}

inline ::flatbuffers::Offset<GPUOperation> CreateGPUOperationDirect(
    ::flatbuffers::FlatBufferBuilder &_fbb,
    ::flatbuffers::Offset<tflite::gpu::data::Arguments> arguments = 0,
    const char *code = nullptr,
    ::flatbuffers::Offset<tflite::gpu::data::Int3> work_group_size = 0,
    const std::vector<::flatbuffers::Offset<tflite::gpu::data::CompilerOption>> *compiler_options = nullptr,
    tflite::gpu::data::TensorToGrid tensor_to_grid = tflite::gpu::data::TensorToGrid::CUSTOM,
    uint64_t flops = 0,
    ::flatbuffers::Offset<tflite::gpu::data::OperationDef> definition = 0,
    int32_t grid_dimension = 0,
    ::flatbuffers::Offset<tflite::gpu::data::Int3> work_group_launch_order = 0,
    ::flatbuffers::Offset<tflite::gpu::data::Int3> grid_size = 0,
    const std::vector<::flatbuffers::Offset<::flatbuffers::String>> *src_tensors_names = nullptr,
    const std::vector<::flatbuffers::Offset<::flatbuffers::String>> *dst_tensors_names = nullptr,
    ::flatbuffers::Offset<tflite::gpu::data::Int3> work_groups_count = 0) {
  auto code__ = code ? _fbb.CreateString(code) : 0;
  auto compiler_options__ = compiler_options ? _fbb.CreateVector<::flatbuffers::Offset<tflite::gpu::data::CompilerOption>>(*compiler_options) : 0;
  auto src_tensors_names__ = src_tensors_names ? _fbb.CreateVector<::flatbuffers::Offset<::flatbuffers::String>>(*src_tensors_names) : 0;
  auto dst_tensors_names__ = dst_tensors_names ? _fbb.CreateVector<::flatbuffers::Offset<::flatbuffers::String>>(*dst_tensors_names) : 0;
  return tflite::gpu::data::CreateGPUOperation(
      _fbb,
      arguments,
      code__,
      work_group_size,
      compiler_options__,
      tensor_to_grid,
      flops,
      definition,
      grid_dimension,
      work_group_launch_order,
      grid_size,
      src_tensors_names__,
      dst_tensors_names__,
      work_groups_count);
}

}  // namespace data
}  // namespace gpu
}  // namespace tflite

#endif  // FLATBUFFERS_GENERATED_SERIALIZATIONBASE_TFLITE_GPU_DATA_H_
