page_type: reference
description: TensorFlow Lite Task Library Vision APIs.

<link rel="stylesheet" href="/site-assets/css/style.css">

<!-- DO NOT EDIT! Automatically generated file. -->


<div itemscope itemtype="http://developers.google.com/ReferenceObject">
<meta itemprop="name" content="tflite_support.task.vision" />
<meta itemprop="path" content="Stable" />
</div>

# Module: tflite_support.task.vision

<!-- Insert buttons and diff -->

<table class="tfo-notebook-buttons tfo-api nocontent" align="left">
<td>
  <a target="_blank" href="https://github.com/tensorflow/tflite-support/blob/v0.4.4/tensorflow_lite_support/python/task/vision/__init__.py">
    <img src="https://www.tensorflow.org/images/GitHub-Mark-32px.png" />
    View source on GitHub
  </a>
</td>
</table>



TensorFlow Lite Task Library Vision APIs.


This module provides interface to run TensorFlow Lite computer vision models.

## Classes

[`class ImageClassifier`](../../tflite_support/task/vision/ImageClassifier): Class that performs classification on images.

[`class ImageClassifierOptions`](../../tflite_support/task/vision/ImageClassifierOptions): Options for the image classifier task.

[`class ImageEmbedder`](../../tflite_support/task/vision/ImageEmbedder): Class that performs dense feature vector extraction on images.

[`class ImageEmbedderOptions`](../../tflite_support/task/vision/ImageEmbedderOptions): Options for the image embedder task.

[`class ImageSearcher`](../../tflite_support/task/vision/ImageSearcher): Class to performs image search.

[`class ImageSearcherOptions`](../../tflite_support/task/vision/ImageSearcherOptions): Options for the image search task.

[`class ImageSegmenter`](../../tflite_support/task/vision/ImageSegmenter): Class that performs segmentation on images.

[`class ImageSegmenterOptions`](../../tflite_support/task/vision/ImageSegmenterOptions): Options for the image segmenter task.

[`class ObjectDetector`](../../tflite_support/task/vision/ObjectDetector): Class that performs object detection on images.

[`class ObjectDetectorOptions`](../../tflite_support/task/vision/ObjectDetectorOptions): Options for the object detector task.

[`class TensorImage`](../../tflite_support/task/vision/TensorImage): Wrapper class for the Image object.
