"""Module extension for third party dependencies."""

load("//third_party/benchmark:workspace.bzl", benchmark = "repo")
load("//third_party/cpuinfo:workspace.bzl", cpuinfo = "repo")
load("//third_party/cudnn_frontend:workspace.bzl", cudnn_frontend = "repo")
load("//third_party/dlpack:workspace.bzl", dlpack = "repo")
load("//third_party/ducc:workspace.bzl", ducc = "repo")
load("//third_party/eigen3:workspace.bzl", eigen3 = "repo")
load("//third_party/farmhash:workspace.bzl", farmhash = "repo")
load("//third_party/fmt:workspace.bzl", fmt = "repo")
load("//third_party/FP16:workspace.bzl", FP16 = "repo")
load("//third_party/fxdiv:workspace.bzl", fxdiv = "repo")
load("//third_party/gemmlowp:workspace.bzl", gemmlowp = "repo")
load("//third_party/gloo:workspace.bzl", gloo = "repo")
load("//third_party/highwayhash:workspace.bzl", highwayhash = "repo")
load("//third_party/hwloc:workspace.bzl", hwloc = "repo")
load("//third_party/implib_so:workspace.bzl", implib_so = "repo")
load("//third_party/llvm:workspace.bzl", llvm = "repo")
load("//third_party/llvm_openmp:workspace.bzl", llvm_openmp = "repo")
load("//third_party/mkl_dnn:workspace.bzl", onednn = "repo")
load("//third_party/mpitrampoline:workspace.bzl", mpitrampoline = "repo")
load("//third_party/nanobind:workspace.bzl", nanobind = "repo")
load("//third_party/nasm:workspace.bzl", nasm = "repo")
load("//third_party/nvshmem:workspace.bzl", nvshmem = "repo")
load("//third_party/pthreadpool:workspace.bzl", pthreadpool = "repo")
load("//third_party/py/ml_dtypes:workspace.bzl", ml_dtypes = "repo")
load("//third_party/raft:workspace.bzl", raft = "repo")
load("//third_party/rapids_logger:workspace.bzl", rapids_logger = "repo")
load("//third_party/rmm:workspace.bzl", rmm = "repo")
load("//third_party/robin_map:workspace.bzl", robin_map = "repo")
load("//third_party/rocm_device_libs:workspace.bzl", rocm_device_libs = "repo")
load("//third_party/shardy:workspace.bzl", shardy = "repo")
load("//third_party/slinky:workspace.bzl", slinky = "repo")
load("//third_party/spdlog:workspace.bzl", spdlog = "repo")
load("//third_party/stablehlo:workspace.bzl", stablehlo = "repo")
load("//third_party/tensorrt:workspace.bzl", tensorrt = "repo")
load("//third_party/triton:workspace.bzl", triton = "repo")
load("//third_party/uv:workspace.bzl", uv = "repo")
load("//third_party/xnnpack:workspace.bzl", xnnpack = "repo")

def _third_party_ext_impl(mctx):  # @unused
    benchmark()
    cpuinfo()
    cudnn_frontend()
    dlpack()
    ducc()
    eigen3()
    farmhash()
    fmt()
    FP16()
    fxdiv()
    gemmlowp()
    gloo()
    highwayhash()
    hwloc()
    implib_so()
    llvm_openmp()
    llvm(name = "llvm-raw")
    ml_dtypes()
    mpitrampoline()
    nanobind()
    nasm()
    nvshmem()
    onednn()
    pthreadpool()
    raft()
    rapids_logger()
    rmm()
    robin_map()
    rocm_device_libs()
    shardy()
    slinky()
    spdlog()
    stablehlo()
    tensorrt()
    triton()
    uv()
    xnnpack()

third_party_ext = module_extension(
    implementation = _third_party_ext_impl,
)
