/* Copyright 2025 The OpenXLA Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
==============================================================================*/

#ifndef XLA_BACKENDS_GPU_CODEGEN_TRITON_LOWERING_UTIL_H_
#define XLA_BACKENDS_GPU_CODEGEN_TRITON_LOWERING_UTIL_H_

#include <vector>

#include "absl/status/statusor.h"
#include "llvm/IR/Metadata.h"
#include "llvm/IR/Module.h"
#include "mlir/Dialect/LLVMIR/LLVMDialect.h"
#include "mlir/IR/BuiltinOps.h"
#include "xla/stream_executor/gpu/tma_metadata.h"
#include "xla/stream_executor/launch_dim.h"

namespace xla::gpu::triton {

// Extracts thread dimensions from Triton module attributes.
absl::StatusOr<stream_executor::ThreadDim> ExtractThreadDims(
    mlir::ModuleOp triton_module, mlir::LLVM::LLVMFuncOp func_op);

// Extracts TMA metadata information from LLVM generated by the Triton
// compilation. The underlying map will be empty if TMA is not used.
absl::StatusOr<stream_executor::gpu::TmaMetadata> ExtractTmaMetadata(
    mlir::LLVM::LLVMFuncOp func_op);

// Extracts NVVM annotations from the Triton module.
std::vector<llvm::Metadata*> ExtractNvvmAnnotations(
    llvm::Module* ll_triton_module);

}  // namespace xla::gpu::triton

#endif  // XLA_BACKENDS_GPU_CODEGEN_TRITON_LOWERING_UTIL_H_
