/* Copyright 2026 The OpenXLA Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
==============================================================================*/

#include "xla/backends/gpu/runtime/command.h"

#include <string>

namespace xla::gpu {

std::string CommandTypeString(CommandType type) {
  switch (type) {
#define CASE_CMD_STRING(enum_name, cmd_name, ...) \
  case CommandType::enum_name:                    \
    return cmd_name;
    XLA_GPU_COMMAND_LIST(CASE_CMD_STRING)
#undef CASE_CMD_STRING
  }
}

bool IsCollectiveCommand(CommandType type) {
  switch (type) {
    case CommandType::kAllGatherCmd:
    case CommandType::kAllReduceCmd:
    case CommandType::kAllToAllCmd:
    case CommandType::kReduceScatterCmd:
    case CommandType::kCollectiveBroadcastCmd:
    case CommandType::kCollectivePermuteCmd:
      return true;
    default:
      return false;
  }
}

}  // namespace xla::gpu
