/* Copyright 2025 The OpenXLA Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
==============================================================================*/

#include "xla/codegen/emitters/transforms/lower_to_llvm_cpu.h"

#include <memory>

#include "mlir/Dialect/Func/IR/FuncOps.h"  // IWYU pragma: keep, needed by lower_to_llvm_cpu.h.inc.
#include "mlir/Pass/Pass.h"
#include "mlir/Support/LLVM.h"
#include "xla/codegen/emitters/transforms/lower_to_llvm_common.h"

namespace xla {
namespace emitters {
namespace {

#define GEN_PASS_DEF_LOWERTOLLVMCPUPASS
#include "xla/codegen/emitters/transforms/lower_to_llvm_cpu.h.inc"

class LowerToLLVMCPUPass
    : public impl::LowerToLLVMCPUPassBase<LowerToLLVMCPUPass> {
 public:
  void runOnOperation() override {
    if (mlir::failed(LowerToLLVM(getOperation()))) {
      signalPassFailure();
    }
  }
};

}  // namespace

std::unique_ptr<::mlir::Pass> CreateLowerToLLVMCPUPass() {
  return std::make_unique<LowerToLLVMCPUPass>();
}

}  // namespace emitters
}  // namespace xla
