// NOTE: Assertions have been autogenerated by hlo/tools/generate_hlo_test_checks.py
// RUN: xla-translate --stablehlo-to-hlo-text -split-input-file %s | FileCheck %s
// RUN: mlir-hlo-opt --stablehlo-legalize-to-hlo=convert-xla-supported-stablehlo=false -split-input-file %s | FileCheck %s --check-prefix CHECK-DIRECT

// CHECK-LABEL: HloModule main, entry_computation_layout={(s64[])->s64[]}

// CHECK:       %[[$region_0_2:[^ ]+]]
// CHECK-NEXT:  %[[Arg__3:[^ ]+]] = s64[] parameter(0)
// CHECK-NEXT:  ROOT %[[add_4:[^ ]+]] = s64[] add(%[[Arg__3]], %[[Arg__3]]), metadata=

// CHECK:       %[[$region_1_5:[^ ]+]]
// CHECK-NEXT:  %[[Arg__6:[^ ]+]] = s64[] parameter(0)
// CHECK-NEXT:  ROOT %[[constant_7:[^ ]+]] = pred[] constant(false)

// CHECK:       ENTRY %[[$main_9:[^ ]+]]
// CHECK-NEXT:  %[[Arg_0_1:[^ ]+]] = s64[] parameter(0)
// CHECK-NEXT:  ROOT %[[while_8:[^ ]+]] = s64[] while(%[[Arg_0_1]]), condition=%[[$region_1_5]], body=%[[$region_0_2]], metadata=

module {
  func.func @main(%arg0: tensor<i64>) -> tensor<i64> {
  %0 = stablehlo.while(%iterArg = %arg0) : tensor<i64>
  cond {
  %c = stablehlo.constant dense<false> : tensor<i1>
  stablehlo.return %c : tensor<i1>
  } do {
  %1 = stablehlo.add %iterArg, %iterArg : tensor<i64>
  stablehlo.return %1 : tensor<i64>
  }
  return %0 : tensor<i64>
  }
}
// CHECK-DIRECT: stablehlo.while

// -----

// CHECK-LABEL: HloModule main, entry_computation_layout={(f32[])->f32[]}

// CHECK:       %[[$region_0_6:[^ ]+]]
// CHECK-NEXT:  %[[arg_tuple_7:[^ ]+]] = (s32[], s32[], f32[], f32[]) parameter(0)
// CHECK-NEXT:  %[[get_tuple_element_8:[^ ]+]] = s32[] get-tuple-element(%[[arg_tuple_7]]), index=0
// CHECK-NEXT:  %[[get_tuple_element_9:[^ ]+]] = s32[] get-tuple-element(%[[arg_tuple_7]]), index=1
// CHECK-NEXT:  %[[get_tuple_element_10:[^ ]+]] = f32[] get-tuple-element(%[[arg_tuple_7]]), index=2
// CHECK-NEXT:  %[[get_tuple_element_11:[^ ]+]] = f32[] get-tuple-element(%[[arg_tuple_7]]), index=3
// CHECK-NEXT:  %[[add_12:[^ ]+]] = f32[] add(%[[get_tuple_element_10]], %[[get_tuple_element_11]]), metadata=
// CHECK-NEXT:  ROOT %[[tuple_13:[^ ]+]] = (s32[], s32[], f32[], f32[]) tuple(%[[get_tuple_element_8]], %[[get_tuple_element_9]], %[[get_tuple_element_10]], %[[add_12]])

// CHECK:       %[[$region_1_14:[^ ]+]]
// CHECK-NEXT:  %[[arg_tuple_15:[^ ]+]] = (s32[], s32[], f32[], f32[]) parameter(0)
// CHECK-NEXT:  %[[get_tuple_element_18:[^ ]+]] = f32[] get-tuple-element(%[[arg_tuple_15]]), index=2
// CHECK-NEXT:  %[[get_tuple_element_19:[^ ]+]] = f32[] get-tuple-element(%[[arg_tuple_15]]), index=3
// CHECK-NEXT:  %[[constant_20:[^ ]+]] = s32[] constant(0)
// CHECK-NEXT:  %[[get_tuple_element_16:[^ ]+]] = s32[] get-tuple-element(%[[arg_tuple_15]]), index=0
// CHECK-NEXT:  %[[get_tuple_element_17:[^ ]+]] = s32[] get-tuple-element(%[[arg_tuple_15]]), index=1
// CHECK-NEXT:  ROOT %[[compare_21:[^ ]+]] = pred[] compare(%[[get_tuple_element_16]], %[[get_tuple_element_17]]), direction=LT, metadata=

// CHECK:       ENTRY %[[$main_27:[^ ]+]]
// CHECK-NEXT:  %[[constant_2:[^ ]+]] = s32[] constant(0)
// CHECK-NEXT:  %[[constant_3:[^ ]+]] = s32[] constant(100)
// CHECK-NEXT:  %[[constant_4:[^ ]+]] = f32[] constant(1)
// CHECK-NEXT:  %[[Arg_0_1:[^ ]+]] = f32[] parameter(0)
// CHECK-NEXT:  %[[tuple_5:[^ ]+]] = (s32[], s32[], f32[], f32[]) tuple(%[[constant_2]], %[[constant_3]], %[[constant_4]], %[[Arg_0_1]]), metadata=
// CHECK-NEXT:  %[[while_22:[^ ]+]] = (s32[], s32[], f32[], f32[]) while(%[[tuple_5]]), condition=%[[$region_1_14]], body=%[[$region_0_6]], metadata=
// CHECK-NEXT:  %[[get_tuple_element_23:[^ ]+]] = s32[] get-tuple-element(%[[while_22]]), index=0, metadata=
// CHECK-NEXT:  %[[get_tuple_element_24:[^ ]+]] = s32[] get-tuple-element(%[[while_22]]), index=1, metadata=
// CHECK-NEXT:  %[[get_tuple_element_25:[^ ]+]] = f32[] get-tuple-element(%[[while_22]]), index=2, metadata=
// CHECK-NEXT:  ROOT %[[get_tuple_element_26:[^ ]+]] = f32[] get-tuple-element(%[[while_22]]), index=3, metadata=

module {
  func.func @main(%arg0: tensor<f32>) -> tensor<f32> {
  %c = stablehlo.constant dense<0> : tensor<i32>
  %c_0 = stablehlo.constant dense<100> : tensor<i32>
  %cst = stablehlo.constant dense<1.000000e+00> : tensor<f32>
  %0:4 = stablehlo.while(%iterArg = %c, %iterArg_1 = %c_0, %iterArg_2 = %cst, %iterArg_3 = %arg0) : tensor<i32>, tensor<i32>, tensor<f32>, tensor<f32>
  cond {
  %c_4 = stablehlo.constant dense<0> : tensor<i32>
  %1 = stablehlo.compare  LT, %iterArg, %iterArg_1 : (tensor<i32>, tensor<i32>) -> tensor<i1>
  stablehlo.return %1 : tensor<i1>
  } do {
  %1 = stablehlo.add %iterArg_2, %iterArg_3 : tensor<f32>
  stablehlo.return %iterArg, %iterArg_1, %iterArg_2, %1 : tensor<i32>, tensor<i32>, tensor<f32>, tensor<f32>
  }
  return %0#3 : tensor<f32>
  }
}
// CHECK-DIRECT: stablehlo.while

// -----

// CHECK-LABEL: HloModule main, entry_computation_layout={(f32[3]{0})->f32[3]{0}}

// CHECK:       %[[$region_0_7:[^ ]+]]
// CHECK-NEXT:  %[[arg_tuple_8:[^ ]+]] = (s32[1], s32[2], f32[1], f32[3]) parameter(0)
// CHECK-NEXT:  %[[get_tuple_element_9:[^ ]+]] = s32[1] get-tuple-element(%[[arg_tuple_8]]), index=0
// CHECK-NEXT:  %[[get_tuple_element_10:[^ ]+]] = s32[2] get-tuple-element(%[[arg_tuple_8]]), index=1
// CHECK-NEXT:  %[[get_tuple_element_11:[^ ]+]] = f32[1] get-tuple-element(%[[arg_tuple_8]]), index=2
// CHECK-NEXT:  %[[get_tuple_element_12:[^ ]+]] = f32[3] get-tuple-element(%[[arg_tuple_8]]), index=3
// CHECK-NEXT:  %[[broadcast_13:[^ ]+]] = f32[1] broadcast(%[[get_tuple_element_11]]), dimensions={0}, metadata=
// CHECK-NEXT:  %[[reshape_14:[^ ]+]] = f32[] reshape(%[[broadcast_13]]), metadata=
// CHECK-NEXT:  %[[broadcast_15:[^ ]+]] = f32[3] broadcast(%[[reshape_14]]), dimensions={}, metadata=
// CHECK-NEXT:  %[[add_16:[^ ]+]] = f32[3] add(%[[get_tuple_element_12]], %[[broadcast_15]]), metadata=
// CHECK-NEXT:  ROOT %[[tuple_17:[^ ]+]] = (s32[1], s32[2], f32[1], f32[3]) tuple(%[[get_tuple_element_9]], %[[get_tuple_element_10]], %[[get_tuple_element_11]], %[[add_16]])

// CHECK:       %[[$region_2_18:[^ ]+]]
// CHECK-NEXT:  %[[Arg_0_19:[^ ]+]] = s32[] parameter(0)
// CHECK-NEXT:  %[[Arg_1_20:[^ ]+]] = s32[] parameter(1)
// CHECK-NEXT:  ROOT %[[add_21:[^ ]+]] = s32[] add(%[[Arg_0_19]], %[[Arg_1_20]]), metadata=

// CHECK:       %[[$region_3_22:[^ ]+]]
// CHECK-NEXT:  %[[Arg_0_23:[^ ]+]] = s32[] parameter(0)
// CHECK-NEXT:  %[[Arg_1_24:[^ ]+]] = s32[] parameter(1)
// CHECK-NEXT:  ROOT %[[add_25:[^ ]+]] = s32[] add(%[[Arg_0_23]], %[[Arg_1_24]]), metadata=

// CHECK:       %[[$region_1_26:[^ ]+]]
// CHECK-NEXT:  %[[arg_tuple_27:[^ ]+]] = (s32[1], s32[2], f32[1], f32[3]) parameter(0)
// CHECK-NEXT:  %[[get_tuple_element_30:[^ ]+]] = f32[1] get-tuple-element(%[[arg_tuple_27]]), index=2
// CHECK-NEXT:  %[[get_tuple_element_31:[^ ]+]] = f32[3] get-tuple-element(%[[arg_tuple_27]]), index=3
// CHECK-NEXT:  %[[get_tuple_element_28:[^ ]+]] = s32[1] get-tuple-element(%[[arg_tuple_27]]), index=0
// CHECK-NEXT:  %[[constant_32:[^ ]+]] = s32[] constant(0)
// CHECK-NEXT:  %[[reduce_33:[^ ]+]] = s32[] reduce(%[[get_tuple_element_28]], %[[constant_32]]), dimensions={0}, to_apply=%[[$region_2_18]], metadata=
// CHECK-NEXT:  %[[get_tuple_element_29:[^ ]+]] = s32[2] get-tuple-element(%[[arg_tuple_27]]), index=1
// CHECK-NEXT:  %[[reduce_34:[^ ]+]] = s32[] reduce(%[[get_tuple_element_29]], %[[constant_32]]), dimensions={0}, to_apply=%[[$region_3_22]], metadata=
// CHECK-NEXT:  ROOT %[[compare_35:[^ ]+]] = pred[] compare(%[[reduce_33]], %[[reduce_34]]), direction=LT, metadata=

// CHECK:       ENTRY %[[$main_41:[^ ]+]]
// CHECK-NEXT:  %[[constant_2:[^ ]+]] = s32[1] constant({0})
// CHECK-NEXT:  %[[constant_3:[^ ]+]] = s32[] constant(100)
// CHECK-NEXT:  %[[broadcast_4:[^ ]+]] = s32[2] broadcast(%[[constant_3]]), dimensions={}
// CHECK-NEXT:  %[[constant_5:[^ ]+]] = f32[1] constant({1})
// CHECK-NEXT:  %[[Arg_0_1:[^ ]+]] = f32[3] parameter(0)
// CHECK-NEXT:  %[[tuple_6:[^ ]+]] = (s32[1], s32[2], f32[1], f32[3]) tuple(%[[constant_2]], %[[broadcast_4]], %[[constant_5]], %[[Arg_0_1]]), metadata=
// CHECK-NEXT:  %[[while_36:[^ ]+]] = (s32[1], s32[2], f32[1], f32[3]) while(%[[tuple_6]]), condition=%[[$region_1_26]], body=%[[$region_0_7]], metadata=
// CHECK-NEXT:  %[[get_tuple_element_37:[^ ]+]] = s32[1] get-tuple-element(%[[while_36]]), index=0, metadata=
// CHECK-NEXT:  %[[get_tuple_element_38:[^ ]+]] = s32[2] get-tuple-element(%[[while_36]]), index=1, metadata=
// CHECK-NEXT:  %[[get_tuple_element_39:[^ ]+]] = f32[1] get-tuple-element(%[[while_36]]), index=2, metadata=
// CHECK-NEXT:  ROOT %[[get_tuple_element_40:[^ ]+]] = f32[3] get-tuple-element(%[[while_36]]), index=3, metadata=

module {
  func.func @main(%arg0: tensor<3xf32>) -> tensor<3xf32> {
  %c = stablehlo.constant dense<0> : tensor<1xi32>
  %c_0 = stablehlo.constant dense<100> : tensor<2xi32>
  %cst = stablehlo.constant dense<1.000000e+00> : tensor<1xf32>
  %0:4 = stablehlo.while(%iterArg = %c, %iterArg_1 = %c_0, %iterArg_2 = %cst, %iterArg_3 = %arg0) : tensor<1xi32>, tensor<2xi32>, tensor<1xf32>, tensor<3xf32>
  cond {
  %c_4 = stablehlo.constant dense<0> : tensor<i32>
  %1 = stablehlo.reduce(%iterArg init: %c_4) applies stablehlo.add across dimensions = [0] : (tensor<1xi32>, tensor<i32>) -> tensor<i32>
  %2 = stablehlo.reduce(%iterArg_1 init: %c_4) applies stablehlo.add across dimensions = [0] : (tensor<2xi32>, tensor<i32>) -> tensor<i32>
  %3 = stablehlo.compare  LT, %1, %2 : (tensor<i32>, tensor<i32>) -> tensor<i1>
  stablehlo.return %3 : tensor<i1>
  } do {
  %1 = stablehlo.broadcast_in_dim %iterArg_2, dims = [0] : (tensor<1xf32>) -> tensor<3xf32>
  %2 = stablehlo.add %iterArg_3, %1 : tensor<3xf32>
  stablehlo.return %iterArg, %iterArg_1, %iterArg_2, %2 : tensor<1xi32>, tensor<2xi32>, tensor<1xf32>, tensor<3xf32>
  }
  return %0#3 : tensor<3xf32>
  }
}
// CHECK-DIRECT: stablehlo.while

// -----

// CHECK-LABEL: HloModule main, entry_computation_layout={((s32[], (s32[], (s32[]))))->(s32[], (s32[], (s32[])))}

// CHECK:       %[[$region_0_8:[^ ]+]]
// CHECK-NEXT:  %[[arg_tuple_9:[^ ]+]] = (s32[], s32[], s32[]) parameter(0)
// CHECK-NEXT:  %[[get_tuple_element_10:[^ ]+]] = s32[] get-tuple-element(%[[arg_tuple_9]]), index=0
// CHECK-NEXT:  %[[get_tuple_element_11:[^ ]+]] = s32[] get-tuple-element(%[[arg_tuple_9]]), index=1
// CHECK-NEXT:  %[[add_13:[^ ]+]] = s32[] add(%[[get_tuple_element_10]], %[[get_tuple_element_11]]), metadata=
// CHECK-NEXT:  %[[get_tuple_element_12:[^ ]+]] = s32[] get-tuple-element(%[[arg_tuple_9]]), index=2
// CHECK-NEXT:  ROOT %[[tuple_14:[^ ]+]] = (s32[], s32[], s32[]) tuple(%[[add_13]], %[[get_tuple_element_11]], %[[get_tuple_element_12]])

// CHECK:       %[[$region_1_15:[^ ]+]]
// CHECK-NEXT:  %[[arg_tuple_16:[^ ]+]] = (s32[], s32[], s32[]) parameter(0)
// CHECK-NEXT:  %[[get_tuple_element_18:[^ ]+]] = s32[] get-tuple-element(%[[arg_tuple_16]]), index=1
// CHECK-NEXT:  %[[get_tuple_element_17:[^ ]+]] = s32[] get-tuple-element(%[[arg_tuple_16]]), index=0
// CHECK-NEXT:  %[[get_tuple_element_19:[^ ]+]] = s32[] get-tuple-element(%[[arg_tuple_16]]), index=2
// CHECK-NEXT:  ROOT %[[compare_20:[^ ]+]] = pred[] compare(%[[get_tuple_element_17]], %[[get_tuple_element_19]]), direction=LT, metadata=

// CHECK:       ENTRY %[[$main_28:[^ ]+]]
// CHECK-NEXT:  %[[Arg_0_1:[^ ]+]] = (s32[], (s32[], (s32[]))) parameter(0)
// CHECK-NEXT:  %[[get_tuple_element_2:[^ ]+]] = s32[] get-tuple-element(%[[Arg_0_1]]), index=0, metadata=
// CHECK-NEXT:  %[[get_tuple_element_3:[^ ]+]] = (s32[], (s32[])) get-tuple-element(%[[Arg_0_1]]), index=1, metadata=
// CHECK-NEXT:  %[[get_tuple_element_4:[^ ]+]] = s32[] get-tuple-element(%[[get_tuple_element_3]]), index=0, metadata=
// CHECK-NEXT:  %[[get_tuple_element_5:[^ ]+]] = (s32[]) get-tuple-element(%[[get_tuple_element_3]]), index=1, metadata=
// CHECK-NEXT:  %[[get_tuple_element_6:[^ ]+]] = s32[] get-tuple-element(%[[get_tuple_element_5]]), index=0, metadata=
// CHECK-NEXT:  %[[tuple_7:[^ ]+]] = (s32[], s32[], s32[]) tuple(%[[get_tuple_element_2]], %[[get_tuple_element_4]], %[[get_tuple_element_6]]), metadata=
// CHECK-NEXT:  %[[while_21:[^ ]+]] = (s32[], s32[], s32[]) while(%[[tuple_7]]), condition=%[[$region_1_15]], body=%[[$region_0_8]], metadata=
// CHECK-NEXT:  %[[get_tuple_element_22:[^ ]+]] = s32[] get-tuple-element(%[[while_21]]), index=0, metadata=
// CHECK-NEXT:  %[[get_tuple_element_23:[^ ]+]] = s32[] get-tuple-element(%[[while_21]]), index=1, metadata=
// CHECK-NEXT:  %[[get_tuple_element_24:[^ ]+]] = s32[] get-tuple-element(%[[while_21]]), index=2, metadata=
// CHECK-NEXT:  %[[tuple_25:[^ ]+]] = (s32[]) tuple(%[[get_tuple_element_24]]), metadata=
// CHECK-NEXT:  %[[tuple_26:[^ ]+]] = (s32[], (s32[])) tuple(%[[get_tuple_element_23]], %[[tuple_25]]), metadata=
// CHECK-NEXT:  ROOT %[[tuple_27:[^ ]+]] = (s32[], (s32[], (s32[]))) tuple(%[[get_tuple_element_22]], %[[tuple_26]]), metadata=

module {
  func.func @main(%arg0: tuple<tensor<i32>, tuple<tensor<i32>, tuple<tensor<i32>>>>) -> tuple<tensor<i32>, tuple<tensor<i32>, tuple<tensor<i32>>>> {
  %0 = stablehlo.get_tuple_element %arg0[0] : (tuple<tensor<i32>, tuple<tensor<i32>, tuple<tensor<i32>>>>) -> tensor<i32>
  %1 = stablehlo.get_tuple_element %arg0[1] : (tuple<tensor<i32>, tuple<tensor<i32>, tuple<tensor<i32>>>>) -> tuple<tensor<i32>, tuple<tensor<i32>>>
  %2 = stablehlo.get_tuple_element %1[0] : (tuple<tensor<i32>, tuple<tensor<i32>>>) -> tensor<i32>
  %3 = stablehlo.get_tuple_element %1[1] : (tuple<tensor<i32>, tuple<tensor<i32>>>) -> tuple<tensor<i32>>
  %4 = stablehlo.get_tuple_element %3[0] : (tuple<tensor<i32>>) -> tensor<i32>
  %5:3 = stablehlo.while(%iterArg = %0, %iterArg_0 = %2, %iterArg_1 = %4) : tensor<i32>, tensor<i32>, tensor<i32>
  cond {
  %9 = stablehlo.compare  LT, %iterArg, %iterArg_1 : (tensor<i32>, tensor<i32>) -> tensor<i1>
  stablehlo.return %9 : tensor<i1>
  } do {
  %9 = stablehlo.add %iterArg, %iterArg_0 : tensor<i32>
  stablehlo.return %9, %iterArg_0, %iterArg_1 : tensor<i32>, tensor<i32>, tensor<i32>
  }
  %6 = stablehlo.tuple %5#2 : tuple<tensor<i32>>
  %7 = stablehlo.tuple %5#1, %6 : tuple<tensor<i32>, tuple<tensor<i32>>>
  %8 = stablehlo.tuple %5#0, %7 {xla_shape = "(s32[], (s32[], (s32[])))"} : tuple<tensor<i32>, tuple<tensor<i32>, tuple<tensor<i32>>>>
  return %8 : tuple<tensor<i32>, tuple<tensor<i32>, tuple<tensor<i32>>>>
  }
}
// CHECK-DIRECT: stablehlo.while

// -----

// CHECK-LABEL: HloModule main, entry_computation_layout={(f32[3,3]{1,0})->f32[3,3]{1,0}}

// CHECK:       %[[$region_0_3:[^ ]+]]
// CHECK-NEXT:  %[[constant_5:[^ ]+]] = pred[] constant(false)
// CHECK-NEXT:  %[[constant_6:[^ ]+]] = f32[] constant(2)
// CHECK-NEXT:  %[[Arg__4:[^ ]+]] = f32[3,3] parameter(0)
// CHECK-NEXT:  %[[constant_7:[^ ]+]] = f32[] constant(2)
// CHECK-NEXT:  %[[broadcast_8:[^ ]+]] = f32[3,3] broadcast(%[[constant_7]]), dimensions={}
// CHECK-NEXT:  ROOT %[[add_9:[^ ]+]] = f32[3,3] add(%[[Arg__4]], %[[broadcast_8]]), metadata=

// CHECK:       %[[$region_2_10:[^ ]+]]
// CHECK-NEXT:  %[[constant_13:[^ ]+]] = pred[] constant(false)
// CHECK-NEXT:  %[[Arg_0_11:[^ ]+]] = f32[] parameter(0)
// CHECK-NEXT:  %[[Arg_1_12:[^ ]+]] = f32[] parameter(1)
// CHECK-NEXT:  ROOT %[[add_14:[^ ]+]] = f32[] add(%[[Arg_0_11]], %[[Arg_1_12]]), metadata=

// CHECK:       %[[$region_1_15:[^ ]+]]
// CHECK-NEXT:  %[[constant_17:[^ ]+]] = pred[] constant(false)
// CHECK-NEXT:  %[[Arg__16:[^ ]+]] = f32[3,3] parameter(0)
// CHECK-NEXT:  %[[constant_18:[^ ]+]] = f32[] constant(0)
// CHECK-NEXT:  %[[reduce_19:[^ ]+]] = f32[] reduce(%[[Arg__16]], %[[constant_18]]), dimensions={0,1}, to_apply=%[[$region_2_10]], metadata=
// CHECK-NEXT:  %[[constant_20:[^ ]+]] = f32[] constant(100)
// CHECK-NEXT:  ROOT %[[compare_21:[^ ]+]] = pred[] compare(%[[reduce_19]], %[[constant_20]]), direction=LT, metadata=

// CHECK:       ENTRY %[[$main_23:[^ ]+]]
// CHECK-NEXT:  %[[constant_2:[^ ]+]] = pred[] constant(false)
// CHECK-NEXT:  %[[Arg_0_1:[^ ]+]] = f32[3,3] parameter(0)
// CHECK-NEXT:  ROOT %[[while_22:[^ ]+]] = f32[3,3] while(%[[Arg_0_1]]), condition=%[[$region_1_15]], body=%[[$region_0_3]], metadata=

module {
  func.func @main(%arg0: tensor<3x3xf32>) -> tensor<3x3xf32> {
  %c = stablehlo.constant dense<false> : tensor<i1>
  %0 = stablehlo.while(%iterArg = %arg0) : tensor<3x3xf32>
  cond {
  %c_0 = stablehlo.constant dense<false> : tensor<i1>
  %cst = stablehlo.constant dense<0.000000e+00> : tensor<f32>
  %1 = stablehlo.reduce(%iterArg init: %cst) across dimensions = [0, 1] : (tensor<3x3xf32>, tensor<f32>) -> tensor<f32>
  reducer(%arg1: tensor<f32>, %arg2: tensor<f32>)  {
  %c_2 = stablehlo.constant dense<false> : tensor<i1>
  %3 = stablehlo.add %arg1, %arg2 : tensor<f32>
  stablehlo.return %3 : tensor<f32>
  }
  %cst_1 = stablehlo.constant dense<1.000000e+02> : tensor<f32>
  %2 = stablehlo.compare  LT, %1, %cst_1 : (tensor<f32>, tensor<f32>) -> tensor<i1>
  stablehlo.return %2 : tensor<i1>
  } do {
  %c_0 = stablehlo.constant dense<false> : tensor<i1>
  %cst = stablehlo.constant dense<2.000000e+00> : tensor<f32>
  %cst_1 = stablehlo.constant dense<2.000000e+00> : tensor<3x3xf32>
  %1 = stablehlo.add %iterArg, %cst_1 : tensor<3x3xf32>
  stablehlo.return %1 : tensor<3x3xf32>
  }
  return %0 : tensor<3x3xf32>
  }
}
// CHECK-DIRECT: stablehlo.while

// -----

// CHECK-LABEL: HloModule main, entry_computation_layout={(s32[])->s32[]}

// CHECK:       %[[$region_0_4:[^ ]+]]
// CHECK-NEXT:  %[[arg_tuple_5:[^ ]+]] = (s32[], s32[]) parameter(0)
// CHECK-NEXT:  %[[get_tuple_element_6:[^ ]+]] = s32[] get-tuple-element(%[[arg_tuple_5]]), index=0
// CHECK-NEXT:  %[[get_tuple_element_7:[^ ]+]] = s32[] get-tuple-element(%[[arg_tuple_5]]), index=1
// CHECK-NEXT:  %[[tuple_8:[^ ]+]] = (s32[], s32[]) tuple(%[[get_tuple_element_6]], %[[get_tuple_element_7]]), metadata=
// CHECK-NEXT:  %[[custom_call_9:[^ ]+]] = (s32[], s32[]) custom-call(%[[get_tuple_element_6]], %[[tuple_8]]), custom_call_target="foo", metadata=
// CHECK-NEXT:  %[[get_tuple_element_10:[^ ]+]] = s32[] get-tuple-element(%[[custom_call_9]]), index=0, metadata=
// CHECK-NEXT:  %[[get_tuple_element_11:[^ ]+]] = s32[] get-tuple-element(%[[custom_call_9]]), index=1, metadata=
// CHECK-NEXT:  ROOT %[[tuple_12:[^ ]+]] = (s32[], s32[]) tuple(%[[get_tuple_element_10]], %[[get_tuple_element_11]])

// CHECK:       %[[$region_1_13:[^ ]+]]
// CHECK-NEXT:  %[[arg_tuple_14:[^ ]+]] = (s32[], s32[]) parameter(0)
// CHECK-NEXT:  %[[get_tuple_element_15:[^ ]+]] = s32[] get-tuple-element(%[[arg_tuple_14]]), index=0
// CHECK-NEXT:  %[[get_tuple_element_16:[^ ]+]] = s32[] get-tuple-element(%[[arg_tuple_14]]), index=1
// CHECK-NEXT:  ROOT %[[compare_17:[^ ]+]] = pred[] compare(%[[get_tuple_element_15]], %[[get_tuple_element_16]]), direction=LT, metadata=

// CHECK:       ENTRY %[[$main_21:[^ ]+]]
// CHECK-NEXT:  %[[constant_2:[^ ]+]] = s32[] constant(0)
// CHECK-NEXT:  %[[Arg_0_1:[^ ]+]] = s32[] parameter(0)
// CHECK-NEXT:  %[[tuple_3:[^ ]+]] = (s32[], s32[]) tuple(%[[constant_2]], %[[Arg_0_1]]), metadata=
// CHECK-NEXT:  %[[while_18:[^ ]+]] = (s32[], s32[]) while(%[[tuple_3]]), condition=%[[$region_1_13]], body=%[[$region_0_4]], metadata=
// CHECK-NEXT:  ROOT %[[get_tuple_element_19:[^ ]+]] = s32[] get-tuple-element(%[[while_18]]), index=0, metadata=
// CHECK-NEXT:  %[[get_tuple_element_20:[^ ]+]] = s32[] get-tuple-element(%[[while_18]]), index=1, metadata=

module {
  func.func @main(%arg0: tensor<i32>) -> tensor<i32> {
  %c = stablehlo.constant dense<0> : tensor<i32>
  %0:2 = stablehlo.while(%iterArg = %c, %iterArg_0 = %arg0) : tensor<i32>, tensor<i32>
  cond {
  %1 = stablehlo.compare  LT, %iterArg, %iterArg_0 : (tensor<i32>, tensor<i32>) -> tensor<i1>
  stablehlo.return %1 : tensor<i1>
  } do {
  %1 = stablehlo.tuple %iterArg, %iterArg_0 : tuple<tensor<i32>, tensor<i32>>
  %2 = stablehlo.custom_call @foo(%iterArg, %1) {backend_config = "bar", xla_shape = "(s32[], s32[])"} : (tensor<i32>, tuple<tensor<i32>, tensor<i32>>) -> tuple<tensor<i32>, tensor<i32>>
  %3 = stablehlo.get_tuple_element %2[0] : (tuple<tensor<i32>, tensor<i32>>) -> tensor<i32>
  %4 = stablehlo.get_tuple_element %2[1] : (tuple<tensor<i32>, tensor<i32>>) -> tensor<i32>
  stablehlo.return %3, %4 : tensor<i32>, tensor<i32>
  }
  return %0#0 : tensor<i32>
  }
}
// CHECK-DIRECT: stablehlo.while
