/* Copyright 2025 The OpenXLA Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
==============================================================================*/

#ifndef XLA_PJRT_PLUGIN_TESTING_TESTING_CPP_PJRT_H_
#define XLA_PJRT_PLUGIN_TESTING_TESTING_CPP_PJRT_H_

#include <memory>

#include "xla/pjrt/pjrt_client.h"

namespace testing {

// Minimal fake PjRtClient for testing using the PJRT C API to test extensions.
// This is not a full backend. It's a lightweight test dependency that can be
// more convenient for testing than a real backend (e.g. CPU).
std::unique_ptr<xla::PjRtClient> CreateTestingPjrtClient();

}  // namespace testing

#endif  // XLA_PJRT_PLUGIN_TESTING_TESTING_CPP_PJRT_H_
