/* Copyright 2024 The OpenXLA Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
==============================================================================*/

#ifndef XLA_SERVICE_GPU_MODEL_SOL_GPU_COST_MODEL_STATS_COLLECTION_H_
#define XLA_SERVICE_GPU_MODEL_SOL_GPU_COST_MODEL_STATS_COLLECTION_H_

#include "absl/container/flat_hash_set.h"
#include "absl/status/statusor.h"
#include "absl/strings/string_view.h"
#include "mlir/IR/MLIRContext.h"
#include "xla/hlo/ir/hlo_module.h"
#include "xla/hlo/pass/hlo_pass_interface.h"
#include "xla/service/hlo_verifier.h"
#include "xla/stream_executor/device_description.h"

namespace xla::gpu {

class SolGpuCostModelStatsCollection : public HloModulePass {
 public:
  explicit SolGpuCostModelStatsCollection(
      const se::DeviceDescription& device_description,
      ShapeSizeFn shape_size_in_bytes_fn, int pointer_size,
      mlir::MLIRContext* mlir_context)
      : device_info_(device_description),
        shape_size_in_bytes_fn_(shape_size_in_bytes_fn),
        pointer_size_(pointer_size),
        mlir_context_(mlir_context) {}

  absl::string_view name() const override {
    return "sol-gpu-cost-model-stats-collection";
  }

 protected:
  absl::StatusOr<bool> RunImpl(
      HloModule* module,
      const absl::flat_hash_set<absl::string_view>& execution_threads) override;

 private:
  se::DeviceDescription device_info_;
  ShapeSizeFn shape_size_in_bytes_fn_;
  int pointer_size_;
  mlir::MLIRContext* mlir_context_;
};

}  // namespace xla::gpu

#endif  // XLA_SERVICE_GPU_MODEL_SOL_GPU_COST_MODEL_STATS_COLLECTION_H_
