/* Copyright 2025 The OpenXLA Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
==============================================================================*/

#ifndef XLA_STREAM_EXECUTOR_TENSOR_MAP_H_
#define XLA_STREAM_EXECUTOR_TENSOR_MAP_H_

#include <cstddef>

namespace stream_executor {

// TensorMap is a wrapper around a 128 bytes of storage. It is used to pass TMA
// descriptors to the kernel.
struct TensorMap {
  alignas(64) std::byte storage[128];
};

}  // namespace stream_executor

#endif  // XLA_STREAM_EXECUTOR_TENSOR_MAP_H_
