/* Copyright 2024 The OpenXLA Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
==============================================================================*/

/*
  This file is generated using xla/tests/generate_complex_unary_op_samples.py.
  Do not edit!
 */

#include <cmath>
#include <complex>
#include <limits>
#include <tuple>
#include <vector>

#ifndef XLA_TESTS_COMPLEX_UNARY_OP_SAMPLES_H_
#define XLA_TESTS_COMPLEX_UNARY_OP_SAMPLES_H_

namespace complex_unary_op_samples {
// NOLINTBEGIN(whitespace/line_length)

template <class>
constexpr bool dependent_false = false;

template <typename T, int default_dps_deficiency = 0>
struct Log1p {
  typedef std::complex<T> InputType;
  typedef std::complex<T> OutputType;
  typedef T FloatType;
  using TableType = std::vector<std::tuple<InputType, OutputType, FloatType>>;
  static constexpr int dps_deficiency = default_dps_deficiency;
  const TableType get() {
    if constexpr (std::is_same_v<T, float>) {
      const T pi = 3.1415927f;
      const T pi_4 = 0.7853982f;
      const T pi_2 = 1.5707964f;
      const T pi3_4 = 2.3561945f;
      const T zero = 0.0f;
      const T inf = std::numeric_limits<T>::infinity();
#ifdef __aarch64__
      const T min = std::nextafter(std::numeric_limits<T>::min(), T(1));
#else
      const T min = std::numeric_limits<T>::min();
#endif
      const T max = std::numeric_limits<T>::max();
      const TableType table{
          // clang-format off
          // Ignore max 80 character line width style requirement for
          // (i) the readability
          // (ii) the consistency with the local conventions
        /* 0 */ { { -inf, -inf }, { inf, -pi3_4 }, 1.e+00f },
        /* 1 */ { { -max, -inf }, { inf, -pi_2 }, 1.e+00f },
        /* 2 */ { { -6.1409603e+25f, -inf }, { inf, -pi_2 }, 1.e+00f },
        /* 3 */ { { -1.1082383e+13f, -inf }, { inf, -pi_2 }, 1.e+00f },
        /* 4 */ { { -2.e+00f, -inf }, { inf, -pi_2 }, 1.e+00f },
        /* 5 */ { { -3.6093321e-13f, -inf }, { inf, -pi_2 }, 1.e+00f },
        /* 6 */ { { -6.5136393e-26f, -inf }, { inf, -pi_2 }, 1.e+00f },
        /* 7 */ { { -min, -inf }, { inf, -pi_2 }, 1.e+00f },
        /* 8 */ { { zero, -inf }, { inf, -pi_2 }, 1.e+00f },
        /* 9 */ { { min, -inf }, { inf, -pi_2 }, 1.e+00f },
        /* 10 */ { { 6.5136393e-26f, -inf }, { inf, -pi_2 }, 1.e+00f },
        /* 11 */ { { 3.6093321e-13f, -inf }, { inf, -pi_2 }, 1.e+00f },
        /* 12 */ { { 2.e+00f, -inf }, { inf, -pi_2 }, 1.e+00f },
        /* 13 */ { { 1.1082383e+13f, -inf }, { inf, -pi_2 }, 1.e+00f },
        /* 14 */ { { 6.1409603e+25f, -inf }, { inf, -pi_2 }, 1.e+00f },
        /* 15 */ { { max, -inf }, { inf, -pi_2 }, 1.e+00f },
        /* 16 */ { { inf, -inf }, { inf, -pi_4 }, 1.e+00f },
        /* 17 */ { { -inf, -max }, { inf, -pi }, 1.e+00f },
        /* 18 */ { { -max, -max }, { 8.9069412e+01f, -pi3_4 }, 7.8125e-03f },
        /* 19 */ { { -6.1409603e+25f, -max }, { 8.8722839e+01f, -pi_2 }, 7.8125e-03f },
        /* 20 */ { { -1.1082383e+13f, -max }, { 8.8722839e+01f, -pi_2 }, 7.8125e-03f },
        /* 21 */ { { -2.e+00f, -max }, { 8.8722839e+01f, -pi_2 }, 7.8125e-03f },
        /* 22 */ { { -3.6093321e-13f, -max }, { 8.8722839e+01f, -pi_2 }, 7.8125e-03f },
        /* 23 */ { { -6.5136393e-26f, -max }, { 8.8722839e+01f, -pi_2 }, 7.8125e-03f },
        /* 24 */ { { -min, -max }, { 8.8722839e+01f, -pi_2 }, 7.8125e-03f },
        /* 25 */ { { zero, -max }, { 8.8722839e+01f, -pi_2 }, 7.8125e-03f },
        /* 26 */ { { min, -max }, { 8.8722839e+01f, -pi_2 }, 7.8125e-03f },
        /* 27 */ { { 6.5136393e-26f, -max }, { 8.8722839e+01f, -pi_2 }, 7.8125e-03f },
        /* 28 */ { { 3.6093321e-13f, -max }, { 8.8722839e+01f, -pi_2 }, 7.8125e-03f },
        /* 29 */ { { 2.e+00f, -max }, { 8.8722839e+01f, -pi_2 }, 7.8125e-03f },
        /* 30 */ { { 1.1082383e+13f, -max }, { 8.8722839e+01f, -pi_2 }, 7.8125e-03f },
        /* 31 */ { { 6.1409603e+25f, -max }, { 8.8722839e+01f, -pi_2 }, 7.8125e-03f },
        /* 32 */ { { max, -max }, { 8.9069412e+01f, -pi_4 }, 7.8125e-03f },
        /* 33 */ { { inf, -max }, { inf, zero }, 1.e+00f },
        /* 34 */ { { -inf, -6.1409603e+25f }, { inf, -pi }, 1.e+00f },
        /* 35 */ { { -max, -6.1409603e+25f }, { 8.8722839e+01f, -pi }, 7.8125e-03f },
        /* 36 */ { { -6.1409603e+25f, -6.1409603e+25f }, { 5.9726181e+01f, -pi3_4 }, 1.5625e-02f },
        /* 37 */ { { -1.1082383e+13f, -6.1409603e+25f }, { 5.9379608e+01f, -pi_2 }, 1.5625e-02f },
        /* 38 */ { { -2.e+00f, -6.1409603e+25f }, { 5.9379608e+01f, -pi_2 }, 1.5625e-02f },
        /* 39 */ { { -3.6093321e-13f, -6.1409603e+25f }, { 5.9379608e+01f, -pi_2 }, 1.5625e-02f },
        /* 40 */ { { -6.5136393e-26f, -6.1409603e+25f }, { 5.9379608e+01f, -pi_2 }, 1.5625e-02f },
        /* 41 */ { { -min, -6.1409603e+25f }, { 5.9379608e+01f, -pi_2 }, 1.5625e-02f },
        /* 42 */ { { zero, -6.1409603e+25f }, { 5.9379608e+01f, -pi_2 }, 1.5625e-02f },
        /* 43 */ { { min, -6.1409603e+25f }, { 5.9379608e+01f, -pi_2 }, 1.5625e-02f },
        /* 44 */ { { 6.5136393e-26f, -6.1409603e+25f }, { 5.9379608e+01f, -pi_2 }, 1.5625e-02f },
        /* 45 */ { { 3.6093321e-13f, -6.1409603e+25f }, { 5.9379608e+01f, -pi_2 }, 1.5625e-02f },
        /* 46 */ { { 2.e+00f, -6.1409603e+25f }, { 5.9379608e+01f, -pi_2 }, 1.5625e-02f },
        /* 47 */ { { 1.1082383e+13f, -6.1409603e+25f }, { 5.9379608e+01f, -pi_2 }, 1.5625e-02f },
        /* 48 */ { { 6.1409603e+25f, -6.1409603e+25f }, { 5.9726181e+01f, -pi_4 }, 1.5625e-02f },
        /* 49 */ { { max, -6.1409603e+25f }, { 8.8722839e+01f, -1.8046662e-13f }, 7.8125e-03f },
        /* 50 */ { { inf, -6.1409603e+25f }, { inf, zero }, 1.e+00f },
        /* 51 */ { { -inf, -1.1082383e+13f }, { inf, -pi }, 1.e+00f },
        /* 52 */ { { -max, -1.1082383e+13f }, { 8.8722839e+01f, -pi }, 7.8125e-03f },
        /* 53 */ { { -6.1409603e+25f, -1.1082383e+13f }, { 5.9379608e+01f, -pi }, 1.5625e-02f },
        /* 54 */ { { -1.1082383e+13f, -1.1082383e+13f }, { 3.0382952e+01f, -pi3_4 }, 3.125e-02f },
        /* 55 */ { { -2.e+00f, -1.1082383e+13f }, { 3.0036377e+01f, -pi_2 }, 3.125e-02f },
        /* 56 */ { { -3.6093321e-13f, -1.1082383e+13f }, { 3.0036377e+01f, -pi_2 }, 3.125e-02f },
        /* 57 */ { { -6.5136393e-26f, -1.1082383e+13f }, { 3.0036377e+01f, -pi_2 }, 3.125e-02f },
        /* 58 */ { { -min, -1.1082383e+13f }, { 3.0036377e+01f, -pi_2 }, 3.125e-02f },
        /* 59 */ { { zero, -1.1082383e+13f }, { 3.0036377e+01f, -pi_2 }, 3.125e-02f },
        /* 60 */ { { min, -1.1082383e+13f }, { 3.0036377e+01f, -pi_2 }, 3.125e-02f },
        /* 61 */ { { 6.5136393e-26f, -1.1082383e+13f }, { 3.0036377e+01f, -pi_2 }, 3.125e-02f },
        /* 62 */ { { 3.6093321e-13f, -1.1082383e+13f }, { 3.0036377e+01f, -pi_2 }, 3.125e-02f },
        /* 63 */ { { 2.e+00f, -1.1082383e+13f }, { 3.0036377e+01f, -pi_2 }, 3.125e-02f },
        /* 64 */ { { 1.1082383e+13f, -1.1082383e+13f }, { 3.0382952e+01f, -pi_4 }, 3.125e-02f },
        /* 65 */ { { 6.1409603e+25f, -1.1082383e+13f }, { 5.9379608e+01f, -1.8046662e-13f }, 1.5625e-02f },
        /* 66 */ { { max, -1.1082383e+13f }, { 8.8722839e+01f, -3.25682e-26f }, 7.8125e-03f },
        /* 67 */ { { inf, -1.1082383e+13f }, { inf, zero }, 1.e+00f },
        /* 68 */ { { -inf, -2.e+00f }, { inf, -pi }, 1.e+00f },
        /* 69 */ { { -max, -2.e+00f }, { 8.8722839e+01f, -pi }, 7.8125e-03f },
        /* 70 */ { { -6.1409603e+25f, -2.e+00f }, { 5.9379608e+01f, -pi }, 1.5625e-02f },
        /* 71 */ { { -1.1082383e+13f, -2.e+00f }, { 3.0036377e+01f, -pi }, 3.125e-02f },
        /* 72 */ { { -2.e+00f, -2.e+00f }, { 8.0471897e-01f, -2.0344439e+00f }, 2.5e-01f },
        /* 73 */ { { -3.6093321e-13f, -2.e+00f }, { 8.0471897e-01f, -1.1071488e+00f }, 5.e-01f },
        /* 74 */ { { -6.5136393e-26f, -2.e+00f }, { 8.0471897e-01f, -1.1071488e+00f }, 5.e-01f },
        /* 75 */ { { -min, -2.e+00f }, { 8.0471897e-01f, -1.1071488e+00f }, 5.e-01f },
        /* 76 */ { { zero, -2.e+00f }, { 8.0471897e-01f, -1.1071488e+00f }, 5.e-01f },
        /* 77 */ { { min, -2.e+00f }, { 8.0471897e-01f, -1.1071488e+00f }, 5.e-01f },
        /* 78 */ { { 6.5136393e-26f, -2.e+00f }, { 8.0471897e-01f, -1.1071488e+00f }, 5.e-01f },
        /* 79 */ { { 3.6093321e-13f, -2.e+00f }, { 8.0471897e-01f, -1.1071488e+00f }, 5.e-01f },
        /* 80 */ { { 2.e+00f, -2.e+00f }, { 1.2824746e+00f, -5.8800262e-01f }, 5.e-01f },
        /* 81 */ { { 1.1082383e+13f, -2.e+00f }, { 3.0036377e+01f, -1.804666e-13f }, 3.125e-02f },
        /* 82 */ { { 6.1409603e+25f, -2.e+00f }, { 5.9379608e+01f, -3.2568196e-26f }, 1.5625e-02f },
        /* 83 */ { { max, -2.e+00f }, { 8.8722839e+01f, -5.8774718e-39f }, 7.8125e-03f },
        /* 84 */ { { inf, -2.e+00f }, { inf, zero }, 1.e+00f },
        /* 85 */ { { -inf, -3.6093321e-13f }, { inf, -pi }, 1.e+00f },
        /* 86 */ { { -max, -3.6093321e-13f }, { 8.8722839e+01f, -pi }, 7.8125e-03f },
        /* 87 */ { { -6.1409603e+25f, -3.6093321e-13f }, { 5.9379608e+01f, -pi }, 1.5625e-02f },
        /* 88 */ { { -1.1082383e+13f, -3.6093321e-13f }, { 3.0036377e+01f, -pi }, 3.125e-02f },
        /* 89 */ { { -2.e+00f, -3.6093321e-13f }, { 6.5136393e-26f, -pi }, 2.5e-01f },
        /* 90 */ { { -3.6093321e-13f, -3.6093321e-13f }, { -3.6093321e-13f, -3.6093321e-13f }, 1.0995116e+12f },
        /* 91 */ { { -6.5136393e-26f, -3.6093321e-13f }, { -2.8437115e-33f, -3.6093321e-13f }, 2.1990233e+12f },
        /* 92 */ { { -min, -3.6093321e-13f }, { 6.5136393e-26f, -3.6093321e-13f }, 2.1990233e+12f },
        /* 93 */ { { zero, -3.6093321e-13f }, { 6.5136393e-26f, -3.6093321e-13f }, 2.1990233e+12f },
        /* 94 */ { { min, -3.6093321e-13f }, { 6.5136393e-26f, -3.6093321e-13f }, 2.1990233e+12f },
        /* 95 */ { { 6.5136393e-26f, -3.6093321e-13f }, { 1.3027279e-25f, -3.6093321e-13f }, 2.1990233e+12f },
        /* 96 */ { { 3.6093321e-13f, -3.6093321e-13f }, { 3.6093321e-13f, -3.6093321e-13f }, 1.0995116e+12f },
        /* 97 */ { { 2.e+00f, -3.6093321e-13f }, { 1.0986123e+00f, -1.2031107e-13f }, 5.e-01f },
        /* 98 */ { { 1.1082383e+13f, -3.6093321e-13f }, { 3.0036377e+01f, -3.2568193e-26f }, 3.125e-02f },
        /* 99 */ { { 6.1409603e+25f, -3.6093321e-13f }, { 5.9379608e+01f, -5.8774718e-39f }, 1.5625e-02f },
        /* 100 */ { { max, -3.6093321e-13f }, { 8.8722839e+01f, zero }, 7.8125e-03f },
        /* 101 */ { { inf, -3.6093321e-13f }, { inf, zero }, 1.e+00f },
        /* 102 */ { { -inf, -6.5136393e-26f }, { inf, -pi }, 1.e+00f },
        /* 103 */ { { -max, -6.5136393e-26f }, { 8.8722839e+01f, -pi }, 7.8125e-03f },
        /* 104 */ { { -6.1409603e+25f, -6.5136393e-26f }, { 5.9379608e+01f, -pi }, 1.5625e-02f },
        /* 105 */ { { -1.1082383e+13f, -6.5136393e-26f }, { 3.0036377e+01f, -pi }, 3.125e-02f },
        /* 106 */ { { -2.e+00f, -6.5136393e-26f }, { zero, -pi }, 2.5e-01f },
        /* 107 */ { { -3.6093321e-13f, -6.5136393e-26f }, { -3.6093321e-13f, -6.5136393e-26f }, 2.1990233e+12f },
        /* 108 */ { { -6.5136393e-26f, -6.5136393e-26f }, { -6.5136393e-26f, -6.5136393e-26f }, 9.6714066e+24f },
        /* 109 */ { { -min, -6.5136393e-26f }, { -min, -6.5136393e-26f }, 9.6714066e+24f },
        /* 110 */ { { zero, -6.5136393e-26f }, { zero, -6.5136393e-26f }, 9.6714066e+24f },
        /* 111 */ { { min, -6.5136393e-26f }, { min, -6.5136393e-26f }, 9.6714066e+24f },
        /* 112 */ { { 6.5136393e-26f, -6.5136393e-26f }, { 6.5136393e-26f, -6.5136393e-26f }, 9.6714066e+24f },
        /* 113 */ { { 3.6093321e-13f, -6.5136393e-26f }, { 3.6093321e-13f, -6.5136393e-26f }, 2.1990233e+12f },
        /* 114 */ { { 2.e+00f, -6.5136393e-26f }, { 1.0986123e+00f, -2.1712131e-26f }, 5.e-01f },
        /* 115 */ { { 1.1082383e+13f, -6.5136393e-26f }, { 3.0036377e+01f, -5.8774718e-39f }, 3.125e-02f },
        /* 116 */ { { 6.1409603e+25f, -6.5136393e-26f }, { 5.9379608e+01f, zero }, 1.5625e-02f },
        /* 117 */ { { max, -6.5136393e-26f }, { 8.8722839e+01f, zero }, 7.8125e-03f },
        /* 118 */ { { inf, -6.5136393e-26f }, { inf, zero }, 1.e+00f },
        /* 119 */ { { -inf, -min }, { inf, -pi }, 1.e+00f },
        /* 120 */ { { -max, -min }, { 8.8722839e+01f, -pi }, 7.8125e-03f },
        /* 121 */ { { -6.1409603e+25f, -min }, { 5.9379608e+01f, -pi }, 1.5625e-02f },
        /* 122 */ { { -1.1082383e+13f, -min }, { 3.0036377e+01f, -pi }, 3.125e-02f },
        /* 123 */ { { -2.e+00f, -min }, { zero, -pi }, 2.5e-01f },
        /* 124 */ { { -3.6093321e-13f, -min }, { -3.6093321e-13f, -min }, 2.1990233e+12f },
        /* 125 */ { { -6.5136393e-26f, -min }, { -6.5136393e-26f, -min }, 9.6714066e+24f },
        /* 126 */ { { -min, -min }, { -min, -min }, 4.2535296e+37f },
        /* 127 */ { { zero, -min }, { zero, -min }, 4.2535296e+37f },
        /* 128 */ { { min, -min }, { min, -min }, 4.2535296e+37f },
        /* 129 */ { { 6.5136393e-26f, -min }, { 6.5136393e-26f, -min }, 9.6714066e+24f },
        /* 130 */ { { 3.6093321e-13f, -min }, { 3.6093321e-13f, -min }, 2.1990233e+12f },
        /* 131 */ { { 2.e+00f, -min }, { 1.0986123e+00f, zero }, 5.e-01f },
        /* 132 */ { { 1.1082383e+13f, -min }, { 3.0036377e+01f, zero }, 3.125e-02f },
        /* 133 */ { { 6.1409603e+25f, -min }, { 5.9379608e+01f, zero }, 1.5625e-02f },
        /* 134 */ { { max, -min }, { 8.8722839e+01f, zero }, 7.8125e-03f },
        /* 135 */ { { inf, -min }, { inf, zero }, 1.e+00f },
        /* 136 */ { { -inf, zero }, { inf, pi }, 1.e+00f },
        /* 137 */ { { -max, zero }, { 8.8722839e+01f, pi }, 7.8125e-03f },
        /* 138 */ { { -6.1409603e+25f, zero }, { 5.9379608e+01f, pi }, 1.5625e-02f },
        /* 139 */ { { -1.1082383e+13f, zero }, { 3.0036377e+01f, pi }, 3.125e-02f },
        /* 140 */ { { -2.e+00f, zero }, { zero, pi }, 2.5e-01f },
        /* 141 */ { { -3.6093321e-13f, zero }, { -3.6093321e-13f, zero }, 2.1990233e+12f },
        /* 142 */ { { -6.5136393e-26f, zero }, { -6.5136393e-26f, zero }, 9.6714066e+24f },
        /* 143 */ { { -min, zero }, { -min, zero }, 4.2535296e+37f },
        /* 144 */ { { zero, zero }, { zero, zero }, 1.e+00f },
        /* 145 */ { { min, zero }, { min, zero }, 4.2535296e+37f },
        /* 146 */ { { 6.5136393e-26f, zero }, { 6.5136393e-26f, zero }, 9.6714066e+24f },
        /* 147 */ { { 3.6093321e-13f, zero }, { 3.6093321e-13f, zero }, 2.1990233e+12f },
        /* 148 */ { { 2.e+00f, zero }, { 1.0986123e+00f, zero }, 5.e-01f },
        /* 149 */ { { 1.1082383e+13f, zero }, { 3.0036377e+01f, zero }, 3.125e-02f },
        /* 150 */ { { 6.1409603e+25f, zero }, { 5.9379608e+01f, zero }, 1.5625e-02f },
        /* 151 */ { { max, zero }, { 8.8722839e+01f, zero }, 7.8125e-03f },
        /* 152 */ { { inf, zero }, { inf, zero }, 1.e+00f },
        /* 153 */ { { -inf, min }, { inf, pi }, 1.e+00f },
        /* 154 */ { { -max, min }, { 8.8722839e+01f, pi }, 7.8125e-03f },
        /* 155 */ { { -6.1409603e+25f, min }, { 5.9379608e+01f, pi }, 1.5625e-02f },
        /* 156 */ { { -1.1082383e+13f, min }, { 3.0036377e+01f, pi }, 3.125e-02f },
        /* 157 */ { { -2.e+00f, min }, { zero, pi }, 2.5e-01f },
        /* 158 */ { { -3.6093321e-13f, min }, { -3.6093321e-13f, min }, 2.1990233e+12f },
        /* 159 */ { { -6.5136393e-26f, min }, { -6.5136393e-26f, min }, 9.6714066e+24f },
        /* 160 */ { { -min, min }, { -min, min }, 4.2535296e+37f },
        /* 161 */ { { zero, min }, { zero, min }, 4.2535296e+37f },
        /* 162 */ { { min, min }, { min, min }, 4.2535296e+37f },
        /* 163 */ { { 6.5136393e-26f, min }, { 6.5136393e-26f, min }, 9.6714066e+24f },
        /* 164 */ { { 3.6093321e-13f, min }, { 3.6093321e-13f, min }, 2.1990233e+12f },
        /* 165 */ { { 2.e+00f, min }, { 1.0986123e+00f, zero }, 5.e-01f },
        /* 166 */ { { 1.1082383e+13f, min }, { 3.0036377e+01f, zero }, 3.125e-02f },
        /* 167 */ { { 6.1409603e+25f, min }, { 5.9379608e+01f, zero }, 1.5625e-02f },
        /* 168 */ { { max, min }, { 8.8722839e+01f, zero }, 7.8125e-03f },
        /* 169 */ { { inf, min }, { inf, zero }, 1.e+00f },
        /* 170 */ { { -inf, 6.5136393e-26f }, { inf, pi }, 1.e+00f },
        /* 171 */ { { -max, 6.5136393e-26f }, { 8.8722839e+01f, pi }, 7.8125e-03f },
        /* 172 */ { { -6.1409603e+25f, 6.5136393e-26f }, { 5.9379608e+01f, pi }, 1.5625e-02f },
        /* 173 */ { { -1.1082383e+13f, 6.5136393e-26f }, { 3.0036377e+01f, pi }, 3.125e-02f },
        /* 174 */ { { -2.e+00f, 6.5136393e-26f }, { zero, pi }, 2.5e-01f },
        /* 175 */ { { -3.6093321e-13f, 6.5136393e-26f }, { -3.6093321e-13f, 6.5136393e-26f }, 2.1990233e+12f },
        /* 176 */ { { -6.5136393e-26f, 6.5136393e-26f }, { -6.5136393e-26f, 6.5136393e-26f }, 9.6714066e+24f },
        /* 177 */ { { -min, 6.5136393e-26f }, { -min, 6.5136393e-26f }, 9.6714066e+24f },
        /* 178 */ { { zero, 6.5136393e-26f }, { zero, 6.5136393e-26f }, 9.6714066e+24f },
        /* 179 */ { { min, 6.5136393e-26f }, { min, 6.5136393e-26f }, 9.6714066e+24f },
        /* 180 */ { { 6.5136393e-26f, 6.5136393e-26f }, { 6.5136393e-26f, 6.5136393e-26f }, 9.6714066e+24f },
        /* 181 */ { { 3.6093321e-13f, 6.5136393e-26f }, { 3.6093321e-13f, 6.5136393e-26f }, 2.1990233e+12f },
        /* 182 */ { { 2.e+00f, 6.5136393e-26f }, { 1.0986123e+00f, 2.1712131e-26f }, 5.e-01f },
        /* 183 */ { { 1.1082383e+13f, 6.5136393e-26f }, { 3.0036377e+01f, 5.8774718e-39f }, 3.125e-02f },
        /* 184 */ { { 6.1409603e+25f, 6.5136393e-26f }, { 5.9379608e+01f, zero }, 1.5625e-02f },
        /* 185 */ { { max, 6.5136393e-26f }, { 8.8722839e+01f, zero }, 7.8125e-03f },
        /* 186 */ { { inf, 6.5136393e-26f }, { inf, zero }, 1.e+00f },
        /* 187 */ { { -inf, 3.6093321e-13f }, { inf, pi }, 1.e+00f },
        /* 188 */ { { -max, 3.6093321e-13f }, { 8.8722839e+01f, pi }, 7.8125e-03f },
        /* 189 */ { { -6.1409603e+25f, 3.6093321e-13f }, { 5.9379608e+01f, pi }, 1.5625e-02f },
        /* 190 */ { { -1.1082383e+13f, 3.6093321e-13f }, { 3.0036377e+01f, pi }, 3.125e-02f },
        /* 191 */ { { -2.e+00f, 3.6093321e-13f }, { 6.5136393e-26f, pi }, 2.5e-01f },
        /* 192 */ { { -3.6093321e-13f, 3.6093321e-13f }, { -3.6093321e-13f, 3.6093321e-13f }, 1.0995116e+12f },
        /* 193 */ { { -6.5136393e-26f, 3.6093321e-13f }, { -2.8437115e-33f, 3.6093321e-13f }, 2.1990233e+12f },
        /* 194 */ { { -min, 3.6093321e-13f }, { 6.5136393e-26f, 3.6093321e-13f }, 2.1990233e+12f },
        /* 195 */ { { zero, 3.6093321e-13f }, { 6.5136393e-26f, 3.6093321e-13f }, 2.1990233e+12f },
        /* 196 */ { { min, 3.6093321e-13f }, { 6.5136393e-26f, 3.6093321e-13f }, 2.1990233e+12f },
        /* 197 */ { { 6.5136393e-26f, 3.6093321e-13f }, { 1.3027279e-25f, 3.6093321e-13f }, 2.1990233e+12f },
        /* 198 */ { { 3.6093321e-13f, 3.6093321e-13f }, { 3.6093321e-13f, 3.6093321e-13f }, 1.0995116e+12f },
        /* 199 */ { { 2.e+00f, 3.6093321e-13f }, { 1.0986123e+00f, 1.2031107e-13f }, 5.e-01f },
        /* 200 */ { { 1.1082383e+13f, 3.6093321e-13f }, { 3.0036377e+01f, 3.2568193e-26f }, 3.125e-02f },
        /* 201 */ { { 6.1409603e+25f, 3.6093321e-13f }, { 5.9379608e+01f, 5.8774718e-39f }, 1.5625e-02f },
        /* 202 */ { { max, 3.6093321e-13f }, { 8.8722839e+01f, zero }, 7.8125e-03f },
        /* 203 */ { { inf, 3.6093321e-13f }, { inf, zero }, 1.e+00f },
        /* 204 */ { { -inf, 2.e+00f }, { inf, pi }, 1.e+00f },
        /* 205 */ { { -max, 2.e+00f }, { 8.8722839e+01f, pi }, 7.8125e-03f },
        /* 206 */ { { -6.1409603e+25f, 2.e+00f }, { 5.9379608e+01f, pi }, 1.5625e-02f },
        /* 207 */ { { -1.1082383e+13f, 2.e+00f }, { 3.0036377e+01f, pi }, 3.125e-02f },
        /* 208 */ { { -2.e+00f, 2.e+00f }, { 8.0471897e-01f, 2.0344439e+00f }, 2.5e-01f },
        /* 209 */ { { -3.6093321e-13f, 2.e+00f }, { 8.0471897e-01f, 1.1071488e+00f }, 5.e-01f },
        /* 210 */ { { -6.5136393e-26f, 2.e+00f }, { 8.0471897e-01f, 1.1071488e+00f }, 5.e-01f },
        /* 211 */ { { -min, 2.e+00f }, { 8.0471897e-01f, 1.1071488e+00f }, 5.e-01f },
        /* 212 */ { { zero, 2.e+00f }, { 8.0471897e-01f, 1.1071488e+00f }, 5.e-01f },
        /* 213 */ { { min, 2.e+00f }, { 8.0471897e-01f, 1.1071488e+00f }, 5.e-01f },
        /* 214 */ { { 6.5136393e-26f, 2.e+00f }, { 8.0471897e-01f, 1.1071488e+00f }, 5.e-01f },
        /* 215 */ { { 3.6093321e-13f, 2.e+00f }, { 8.0471897e-01f, 1.1071488e+00f }, 5.e-01f },
        /* 216 */ { { 2.e+00f, 2.e+00f }, { 1.2824746e+00f, 5.8800262e-01f }, 5.e-01f },
        /* 217 */ { { 1.1082383e+13f, 2.e+00f }, { 3.0036377e+01f, 1.804666e-13f }, 3.125e-02f },
        /* 218 */ { { 6.1409603e+25f, 2.e+00f }, { 5.9379608e+01f, 3.2568196e-26f }, 1.5625e-02f },
        /* 219 */ { { max, 2.e+00f }, { 8.8722839e+01f, 5.8774718e-39f }, 7.8125e-03f },
        /* 220 */ { { inf, 2.e+00f }, { inf, zero }, 1.e+00f },
        /* 221 */ { { -inf, 1.1082383e+13f }, { inf, pi }, 1.e+00f },
        /* 222 */ { { -max, 1.1082383e+13f }, { 8.8722839e+01f, pi }, 7.8125e-03f },
        /* 223 */ { { -6.1409603e+25f, 1.1082383e+13f }, { 5.9379608e+01f, pi }, 1.5625e-02f },
        /* 224 */ { { -1.1082383e+13f, 1.1082383e+13f }, { 3.0382952e+01f, pi3_4 }, 3.125e-02f },
        /* 225 */ { { -2.e+00f, 1.1082383e+13f }, { 3.0036377e+01f, pi_2 }, 3.125e-02f },
        /* 226 */ { { -3.6093321e-13f, 1.1082383e+13f }, { 3.0036377e+01f, pi_2 }, 3.125e-02f },
        /* 227 */ { { -6.5136393e-26f, 1.1082383e+13f }, { 3.0036377e+01f, pi_2 }, 3.125e-02f },
        /* 228 */ { { -min, 1.1082383e+13f }, { 3.0036377e+01f, pi_2 }, 3.125e-02f },
        /* 229 */ { { zero, 1.1082383e+13f }, { 3.0036377e+01f, pi_2 }, 3.125e-02f },
        /* 230 */ { { min, 1.1082383e+13f }, { 3.0036377e+01f, pi_2 }, 3.125e-02f },
        /* 231 */ { { 6.5136393e-26f, 1.1082383e+13f }, { 3.0036377e+01f, pi_2 }, 3.125e-02f },
        /* 232 */ { { 3.6093321e-13f, 1.1082383e+13f }, { 3.0036377e+01f, pi_2 }, 3.125e-02f },
        /* 233 */ { { 2.e+00f, 1.1082383e+13f }, { 3.0036377e+01f, pi_2 }, 3.125e-02f },
        /* 234 */ { { 1.1082383e+13f, 1.1082383e+13f }, { 3.0382952e+01f, pi_4 }, 3.125e-02f },
        /* 235 */ { { 6.1409603e+25f, 1.1082383e+13f }, { 5.9379608e+01f, 1.8046662e-13f }, 1.5625e-02f },
        /* 236 */ { { max, 1.1082383e+13f }, { 8.8722839e+01f, 3.25682e-26f }, 7.8125e-03f },
        /* 237 */ { { inf, 1.1082383e+13f }, { inf, zero }, 1.e+00f },
        /* 238 */ { { -inf, 6.1409603e+25f }, { inf, pi }, 1.e+00f },
        /* 239 */ { { -max, 6.1409603e+25f }, { 8.8722839e+01f, pi }, 7.8125e-03f },
        /* 240 */ { { -6.1409603e+25f, 6.1409603e+25f }, { 5.9726181e+01f, pi3_4 }, 1.5625e-02f },
        /* 241 */ { { -1.1082383e+13f, 6.1409603e+25f }, { 5.9379608e+01f, pi_2 }, 1.5625e-02f },
        /* 242 */ { { -2.e+00f, 6.1409603e+25f }, { 5.9379608e+01f, pi_2 }, 1.5625e-02f },
        /* 243 */ { { -3.6093321e-13f, 6.1409603e+25f }, { 5.9379608e+01f, pi_2 }, 1.5625e-02f },
        /* 244 */ { { -6.5136393e-26f, 6.1409603e+25f }, { 5.9379608e+01f, pi_2 }, 1.5625e-02f },
        /* 245 */ { { -min, 6.1409603e+25f }, { 5.9379608e+01f, pi_2 }, 1.5625e-02f },
        /* 246 */ { { zero, 6.1409603e+25f }, { 5.9379608e+01f, pi_2 }, 1.5625e-02f },
        /* 247 */ { { min, 6.1409603e+25f }, { 5.9379608e+01f, pi_2 }, 1.5625e-02f },
        /* 248 */ { { 6.5136393e-26f, 6.1409603e+25f }, { 5.9379608e+01f, pi_2 }, 1.5625e-02f },
        /* 249 */ { { 3.6093321e-13f, 6.1409603e+25f }, { 5.9379608e+01f, pi_2 }, 1.5625e-02f },
        /* 250 */ { { 2.e+00f, 6.1409603e+25f }, { 5.9379608e+01f, pi_2 }, 1.5625e-02f },
        /* 251 */ { { 1.1082383e+13f, 6.1409603e+25f }, { 5.9379608e+01f, pi_2 }, 1.5625e-02f },
        /* 252 */ { { 6.1409603e+25f, 6.1409603e+25f }, { 5.9726181e+01f, pi_4 }, 1.5625e-02f },
        /* 253 */ { { max, 6.1409603e+25f }, { 8.8722839e+01f, 1.8046662e-13f }, 7.8125e-03f },
        /* 254 */ { { inf, 6.1409603e+25f }, { inf, zero }, 1.e+00f },
        /* 255 */ { { -inf, max }, { inf, pi }, 1.e+00f },
        /* 256 */ { { -max, max }, { 8.9069412e+01f, pi3_4 }, 7.8125e-03f },
        /* 257 */ { { -6.1409603e+25f, max }, { 8.8722839e+01f, pi_2 }, 7.8125e-03f },
        /* 258 */ { { -1.1082383e+13f, max }, { 8.8722839e+01f, pi_2 }, 7.8125e-03f },
        /* 259 */ { { -2.e+00f, max }, { 8.8722839e+01f, pi_2 }, 7.8125e-03f },
        /* 260 */ { { -3.6093321e-13f, max }, { 8.8722839e+01f, pi_2 }, 7.8125e-03f },
        /* 261 */ { { -6.5136393e-26f, max }, { 8.8722839e+01f, pi_2 }, 7.8125e-03f },
        /* 262 */ { { -min, max }, { 8.8722839e+01f, pi_2 }, 7.8125e-03f },
        /* 263 */ { { zero, max }, { 8.8722839e+01f, pi_2 }, 7.8125e-03f },
        /* 264 */ { { min, max }, { 8.8722839e+01f, pi_2 }, 7.8125e-03f },
        /* 265 */ { { 6.5136393e-26f, max }, { 8.8722839e+01f, pi_2 }, 7.8125e-03f },
        /* 266 */ { { 3.6093321e-13f, max }, { 8.8722839e+01f, pi_2 }, 7.8125e-03f },
        /* 267 */ { { 2.e+00f, max }, { 8.8722839e+01f, pi_2 }, 7.8125e-03f },
        /* 268 */ { { 1.1082383e+13f, max }, { 8.8722839e+01f, pi_2 }, 7.8125e-03f },
        /* 269 */ { { 6.1409603e+25f, max }, { 8.8722839e+01f, pi_2 }, 7.8125e-03f },
        /* 270 */ { { max, max }, { 8.9069412e+01f, pi_4 }, 7.8125e-03f },
        /* 271 */ { { inf, max }, { inf, zero }, 1.e+00f },
        /* 272 */ { { -inf, inf }, { inf, pi3_4 }, 1.e+00f },
        /* 273 */ { { -max, inf }, { inf, pi_2 }, 1.e+00f },
        /* 274 */ { { -6.1409603e+25f, inf }, { inf, pi_2 }, 1.e+00f },
        /* 275 */ { { -1.1082383e+13f, inf }, { inf, pi_2 }, 1.e+00f },
        /* 276 */ { { -2.e+00f, inf }, { inf, pi_2 }, 1.e+00f },
        /* 277 */ { { -3.6093321e-13f, inf }, { inf, pi_2 }, 1.e+00f },
        /* 278 */ { { -6.5136393e-26f, inf }, { inf, pi_2 }, 1.e+00f },
        /* 279 */ { { -min, inf }, { inf, pi_2 }, 1.e+00f },
        /* 280 */ { { zero, inf }, { inf, pi_2 }, 1.e+00f },
        /* 281 */ { { min, inf }, { inf, pi_2 }, 1.e+00f },
        /* 282 */ { { 6.5136393e-26f, inf }, { inf, pi_2 }, 1.e+00f },
        /* 283 */ { { 3.6093321e-13f, inf }, { inf, pi_2 }, 1.e+00f },
        /* 284 */ { { 2.e+00f, inf }, { inf, pi_2 }, 1.e+00f },
        /* 285 */ { { 1.1082383e+13f, inf }, { inf, pi_2 }, 1.e+00f },
        /* 286 */ { { 6.1409603e+25f, inf }, { inf, pi_2 }, 1.e+00f },
        /* 287 */ { { max, inf }, { inf, pi_2 }, 1.e+00f },
        /* 288 */ { { inf, inf }, { inf, pi_4 }, 1.e+00f }
          // clang-format on
      };
      return table;
    } else if constexpr (std::is_same_v<T, double>) {
      const T pi = 3.141592653589793;
      const T pi_4 = 0.7853981633974483;
      const T pi_2 = 1.5707963267948966;
      const T pi3_4 = 2.356194490192345;
      const T zero = 0.0;
      const T inf = std::numeric_limits<T>::infinity();
#ifdef __aarch64__
      const T min = std::nextafter(std::numeric_limits<T>::min(), T(1));
#else
      const T min = std::numeric_limits<T>::min();
#endif
      const T max = std::numeric_limits<T>::max();
      const TableType table{
          // clang-format off
          // Ignore max 80 character line width style requirement for
          // (i) the readability
          // (ii) the consistency with the local conventions
        /* 0 */ { { -inf, -inf }, { inf, -pi3_4 }, 1.e+00 },
        /* 1 */ { { -max, -inf }, { inf, -pi_2 }, 1.e+00 },
        /* 2 */ { { -4.0131652080900752e+205, -inf }, { inf, -pi_2 }, 1.e+00 },
        /* 3 */ { { -8.9589789687104559e+102, -inf }, { inf, -pi_2 }, 1.e+00 },
        /* 4 */ { { -1.9999999999998694e+00, -inf }, { inf, -pi_2 }, 1.e+00 },
        /* 5 */ { { -4.4647944971961829e-103, -inf }, { inf, -pi_2 }, 1.e+00 },
        /* 6 */ { { -9.9671949510973086e-206, -inf }, { inf, -pi_2 }, 1.e+00 },
        /* 7 */ { { -min, -inf }, { inf, -pi_2 }, 1.e+00 },
        /* 8 */ { { zero, -inf }, { inf, -pi_2 }, 1.e+00 },
        /* 9 */ { { min, -inf }, { inf, -pi_2 }, 1.e+00 },
        /* 10 */ { { 9.9671949510973086e-206, -inf }, { inf, -pi_2 }, 1.e+00 },
        /* 11 */ { { 4.4647944971961829e-103, -inf }, { inf, -pi_2 }, 1.e+00 },
        /* 12 */ { { 1.9999999999998694e+00, -inf }, { inf, -pi_2 }, 1.e+00 },
        /* 13 */ { { 8.9589789687104559e+102, -inf }, { inf, -pi_2 }, 1.e+00 },
        /* 14 */ { { 4.0131652080900752e+205, -inf }, { inf, -pi_2 }, 1.e+00 },
        /* 15 */ { { max, -inf }, { inf, -pi_2 }, 1.e+00 },
        /* 16 */ { { inf, -inf }, { inf, -pi_4 }, 1.e+00 },
        /* 17 */ { { -inf, -max }, { inf, -pi }, 1.e+00 },
        /* 18 */ { { -max, -max }, { 7.1012928648366392e+02, -pi3_4 }, 9.765625e-04 },
        /* 19 */ { { -4.0131652080900752e+205, -max }, { 7.0978271289338397e+02, -pi_2 }, 9.765625e-04 },
        /* 20 */ { { -8.9589789687104559e+102, -max }, { 7.0978271289338397e+02, -pi_2 }, 9.765625e-04 },
        /* 21 */ { { -1.9999999999998694e+00, -max }, { 7.0978271289338397e+02, -pi_2 }, 9.765625e-04 },
        /* 22 */ { { -4.4647944971961829e-103, -max }, { 7.0978271289338397e+02, -pi_2 }, 9.765625e-04 },
        /* 23 */ { { -9.9671949510973086e-206, -max }, { 7.0978271289338397e+02, -pi_2 }, 9.765625e-04 },
        /* 24 */ { { -min, -max }, { 7.0978271289338397e+02, -pi_2 }, 9.765625e-04 },
        /* 25 */ { { zero, -max }, { 7.0978271289338397e+02, -pi_2 }, 9.765625e-04 },
        /* 26 */ { { min, -max }, { 7.0978271289338397e+02, -pi_2 }, 9.765625e-04 },
        /* 27 */ { { 9.9671949510973086e-206, -max }, { 7.0978271289338397e+02, -pi_2 }, 9.765625e-04 },
        /* 28 */ { { 4.4647944971961829e-103, -max }, { 7.0978271289338397e+02, -pi_2 }, 9.765625e-04 },
        /* 29 */ { { 1.9999999999998694e+00, -max }, { 7.0978271289338397e+02, -pi_2 }, 9.765625e-04 },
        /* 30 */ { { 8.9589789687104559e+102, -max }, { 7.0978271289338397e+02, -pi_2 }, 9.765625e-04 },
        /* 31 */ { { 4.0131652080900752e+205, -max }, { 7.0978271289338397e+02, -pi_2 }, 9.765625e-04 },
        /* 32 */ { { max, -max }, { 7.1012928648366392e+02, -pi_4 }, 9.765625e-04 },
        /* 33 */ { { inf, -max }, { inf, zero }, 1.e+00 },
        /* 34 */ { { -inf, -4.0131652080900752e+205 }, { inf, -pi }, 1.e+00 },
        /* 35 */ { { -max, -4.0131652080900752e+205 }, { 7.0978271289338397e+02, -pi }, 9.765625e-04 },
        /* 36 */ { { -4.0131652080900752e+205, -4.0131652080900752e+205 }, { 4.737660979127225e+02, -pi3_4 }, 1.953125e-03 },
        /* 37 */ { { -8.9589789687104559e+102, -4.0131652080900752e+205 }, { 4.7341952432244256e+02, -pi_2 }, 1.953125e-03 },
        /* 38 */ { { -1.9999999999998694e+00, -4.0131652080900752e+205 }, { 4.7341952432244256e+02, -pi_2 }, 1.953125e-03 },
        /* 39 */ { { -4.4647944971961829e-103, -4.0131652080900752e+205 }, { 4.7341952432244256e+02, -pi_2 }, 1.953125e-03 },
        /* 40 */ { { -9.9671949510973086e-206, -4.0131652080900752e+205 }, { 4.7341952432244256e+02, -pi_2 }, 1.953125e-03 },
        /* 41 */ { { -min, -4.0131652080900752e+205 }, { 4.7341952432244256e+02, -pi_2 }, 1.953125e-03 },
        /* 42 */ { { zero, -4.0131652080900752e+205 }, { 4.7341952432244256e+02, -pi_2 }, 1.953125e-03 },
        /* 43 */ { { min, -4.0131652080900752e+205 }, { 4.7341952432244256e+02, -pi_2 }, 1.953125e-03 },
        /* 44 */ { { 9.9671949510973086e-206, -4.0131652080900752e+205 }, { 4.7341952432244256e+02, -pi_2 }, 1.953125e-03 },
        /* 45 */ { { 4.4647944971961829e-103, -4.0131652080900752e+205 }, { 4.7341952432244256e+02, -pi_2 }, 1.953125e-03 },
        /* 46 */ { { 1.9999999999998694e+00, -4.0131652080900752e+205 }, { 4.7341952432244256e+02, -pi_2 }, 1.953125e-03 },
        /* 47 */ { { 8.9589789687104559e+102, -4.0131652080900752e+205 }, { 4.7341952432244256e+02, -pi_2 }, 1.953125e-03 },
        /* 48 */ { { 4.0131652080900752e+205, -4.0131652080900752e+205 }, { 4.737660979127225e+02, -pi_4 }, 1.953125e-03 },
        /* 49 */ { { max, -4.0131652080900752e+205 }, { 7.0978271289338397e+02, -2.2323972485979601e-103 }, 9.765625e-04 },
        /* 50 */ { { inf, -4.0131652080900752e+205 }, { inf, zero }, 1.e+00 },
        /* 51 */ { { -inf, -8.9589789687104559e+102 }, { inf, -pi }, 1.e+00 },
        /* 52 */ { { -max, -8.9589789687104559e+102 }, { 7.0978271289338397e+02, -pi }, 9.765625e-04 },
        /* 53 */ { { -4.0131652080900752e+205, -8.9589789687104559e+102 }, { 4.7341952432244256e+02, -pi }, 1.953125e-03 },
        /* 54 */ { { -8.9589789687104559e+102, -8.9589789687104559e+102 }, { 2.374029093417812e+02, -pi3_4 }, 3.90625e-03 },
        /* 55 */ { { -1.9999999999998694e+00, -8.9589789687104559e+102 }, { 2.3705633575150122e+02, -pi_2 }, 3.90625e-03 },
        /* 56 */ { { -4.4647944971961829e-103, -8.9589789687104559e+102 }, { 2.3705633575150122e+02, -pi_2 }, 3.90625e-03 },
        /* 57 */ { { -9.9671949510973086e-206, -8.9589789687104559e+102 }, { 2.3705633575150122e+02, -pi_2 }, 3.90625e-03 },
        /* 58 */ { { -min, -8.9589789687104559e+102 }, { 2.3705633575150122e+02, -pi_2 }, 3.90625e-03 },
        /* 59 */ { { zero, -8.9589789687104559e+102 }, { 2.3705633575150122e+02, -pi_2 }, 3.90625e-03 },
        /* 60 */ { { min, -8.9589789687104559e+102 }, { 2.3705633575150122e+02, -pi_2 }, 3.90625e-03 },
        /* 61 */ { { 9.9671949510973086e-206, -8.9589789687104559e+102 }, { 2.3705633575150122e+02, -pi_2 }, 3.90625e-03 },
        /* 62 */ { { 4.4647944971961829e-103, -8.9589789687104559e+102 }, { 2.3705633575150122e+02, -pi_2 }, 3.90625e-03 },
        /* 63 */ { { 1.9999999999998694e+00, -8.9589789687104559e+102 }, { 2.3705633575150122e+02, -pi_2 }, 3.90625e-03 },
        /* 64 */ { { 8.9589789687104559e+102, -8.9589789687104559e+102 }, { 2.374029093417812e+02, -pi_4 }, 3.90625e-03 },
        /* 65 */ { { 4.0131652080900752e+205, -8.9589789687104559e+102 }, { 4.7341952432244256e+02, -2.2323972485982374e-103 }, 1.953125e-03 },
        /* 66 */ { { max, -8.9589789687104559e+102 }, { 7.0978271289338397e+02, -4.9835974755483611e-206 }, 9.765625e-04 },
        /* 67 */ { { inf, -8.9589789687104559e+102 }, { inf, zero }, 1.e+00 },
        /* 68 */ { { -inf, -1.9999999999998694e+00 }, { inf, -pi }, 1.e+00 },
        /* 69 */ { { -max, -1.9999999999998694e+00 }, { 7.0978271289338397e+02, -pi }, 9.765625e-04 },
        /* 70 */ { { -4.0131652080900752e+205, -1.9999999999998694e+00 }, { 4.7341952432244256e+02, -pi }, 1.953125e-03 },
        /* 71 */ { { -8.9589789687104559e+102, -1.9999999999998694e+00 }, { 2.3705633575150122e+02, -pi }, 3.90625e-03 },
        /* 72 */ { { -1.9999999999998694e+00, -1.9999999999998694e+00 }, { 8.0471895621697187e-01, -2.0344439357956765e+00 }, 2.5e-01 },
        /* 73 */ { { -4.4647944971961829e-103, -1.9999999999998694e+00 }, { 8.0471895621699796e-01, -1.1071487177940644e+00 }, 5.e-01 },
        /* 74 */ { { -9.9671949510973086e-206, -1.9999999999998694e+00 }, { 8.0471895621699796e-01, -1.1071487177940644e+00 }, 5.e-01 },
        /* 75 */ { { -min, -1.9999999999998694e+00 }, { 8.0471895621699796e-01, -1.1071487177940644e+00 }, 5.e-01 },
        /* 76 */ { { zero, -1.9999999999998694e+00 }, { 8.0471895621699796e-01, -1.1071487177940644e+00 }, 5.e-01 },
        /* 77 */ { { min, -1.9999999999998694e+00 }, { 8.0471895621699796e-01, -1.1071487177940644e+00 }, 5.e-01 },
        /* 78 */ { { 9.9671949510973086e-206, -1.9999999999998694e+00 }, { 8.0471895621699796e-01, -1.1071487177940644e+00 }, 5.e-01 },
        /* 79 */ { { 4.4647944971961829e-103, -1.9999999999998694e+00 }, { 8.0471895621699796e-01, -1.1071487177940644e+00 }, 5.e-01 },
        /* 80 */ { { 1.9999999999998694e+00, -1.9999999999998694e+00 }, { 1.2824746787307182e+00, -5.8800260354755751e-01 }, 5.e-01 },
        /* 81 */ { { 8.9589789687104559e+102, -1.9999999999998694e+00 }, { 2.3705633575150122e+02, -2.2323972485982374e-103 }, 3.90625e-03 },
        /* 82 */ { { 4.0131652080900752e+205, -1.9999999999998694e+00 }, { 4.7341952432244256e+02, -4.9835974755489796e-206 }, 1.953125e-03 },
        /* 83 */ { { max, -1.9999999999998694e+00 }, { 7.0978271289338397e+02, zero }, 9.765625e-04 },
        /* 84 */ { { inf, -1.9999999999998694e+00 }, { inf, zero }, 1.e+00 },
        /* 85 */ { { -inf, -4.4647944971961829e-103 }, { inf, -pi }, 1.e+00 },
        /* 86 */ { { -max, -4.4647944971961829e-103 }, { 7.0978271289338397e+02, -pi }, 9.765625e-04 },
        /* 87 */ { { -4.0131652080900752e+205, -4.4647944971961829e-103 }, { 4.7341952432244256e+02, -pi }, 1.953125e-03 },
        /* 88 */ { { -8.9589789687104559e+102, -4.4647944971961829e-103 }, { 2.3705633575150122e+02, -pi }, 3.90625e-03 },
        /* 89 */ { { -1.9999999999998694e+00, -4.4647944971961829e-103 }, { -1.3056222769592694e-13, -pi }, 2.5e-01 },
        /* 90 */ { { -4.4647944971961829e-103, -4.4647944971961829e-103 }, { -4.4647944971961829e-103, -4.4647944971961829e-103 }, 1.1198723710889021e+102 },
        /* 91 */ { { -9.9671949510973086e-206, -4.4647944971961829e-103 }, { -6.5066958834738373e-219, -4.4647944971961829e-103 }, 2.2397447421778042e+102 },
        /* 92 */ { { -min, -4.4647944971961829e-103 }, { 9.9671949510966579e-206, -4.4647944971961829e-103 }, 2.2397447421778042e+102 },
        /* 93 */ { { zero, -4.4647944971961829e-103 }, { 9.9671949510966579e-206, -4.4647944971961829e-103 }, 2.2397447421778042e+102 },
        /* 94 */ { { min, -4.4647944971961829e-103 }, { 9.9671949510966579e-206, -4.4647944971961829e-103 }, 2.2397447421778042e+102 },
        /* 95 */ { { 9.9671949510973086e-206, -4.4647944971961829e-103 }, { 1.9934389902193967e-205, -4.4647944971961829e-103 }, 2.2397447421778042e+102 },
        /* 96 */ { { 4.4647944971961829e-103, -4.4647944971961829e-103 }, { 4.4647944971961829e-103, -4.4647944971961829e-103 }, 1.1198723710889021e+102 },
        /* 97 */ { { 1.9999999999998694e+00, -4.4647944971961829e-103 }, { 1.0986122886680663e+00, -1.4882648323987925e-103 }, 5.e-01 },
        /* 98 */ { { 8.9589789687104559e+102, -4.4647944971961829e-103 }, { 2.3705633575150122e+02, -4.9835974755489796e-206 }, 3.90625e-03 },
        /* 99 */ { { 4.0131652080900752e+205, -4.4647944971961829e-103 }, { 4.7341952432244256e+02, -1.1125369292536664e-308 }, 1.953125e-03 },
        /* 100 */ { { max, -4.4647944971961829e-103 }, { 7.0978271289338397e+02, zero }, 9.765625e-04 },
        /* 101 */ { { inf, -4.4647944971961829e-103 }, { inf, zero }, 1.e+00 },
        /* 102 */ { { -inf, -9.9671949510973086e-206 }, { inf, -pi }, 1.e+00 },
        /* 103 */ { { -max, -9.9671949510973086e-206 }, { 7.0978271289338397e+02, -pi }, 9.765625e-04 },
        /* 104 */ { { -4.0131652080900752e+205, -9.9671949510973086e-206 }, { 4.7341952432244256e+02, -pi }, 1.953125e-03 },
        /* 105 */ { { -8.9589789687104559e+102, -9.9671949510973086e-206 }, { 2.3705633575150122e+02, -pi }, 3.90625e-03 },
        /* 106 */ { { -1.9999999999998694e+00, -9.9671949510973086e-206 }, { -1.3056222769592694e-13, -pi }, 2.5e-01 },
        /* 107 */ { { -4.4647944971961829e-103, -9.9671949510973086e-206 }, { -4.4647944971961829e-103, -9.9671949510973086e-206 }, 2.2397447421778042e+102 },
        /* 108 */ { { -9.9671949510973086e-206, -9.9671949510973086e-206 }, { -9.9671949510973086e-206, -9.9671949510973086e-206 }, 5.0164565101131187e+204 },
        /* 109 */ { { -min, -9.9671949510973086e-206 }, { -min, -9.9671949510973086e-206 }, 1.0032913020226237e+205 },
        /* 110 */ { { zero, -9.9671949510973086e-206 }, { zero, -9.9671949510973086e-206 }, 1.0032913020226237e+205 },
        /* 111 */ { { min, -9.9671949510973086e-206 }, { min, -9.9671949510973086e-206 }, 1.0032913020226237e+205 },
        /* 112 */ { { 9.9671949510973086e-206, -9.9671949510973086e-206 }, { 9.9671949510973086e-206, -9.9671949510973086e-206 }, 5.0164565101131187e+204 },
        /* 113 */ { { 4.4647944971961829e-103, -9.9671949510973086e-206 }, { 4.4647944971961829e-103, -9.9671949510973086e-206 }, 2.2397447421778042e+102 },
        /* 114 */ { { 1.9999999999998694e+00, -9.9671949510973086e-206 }, { 1.0986122886680663e+00, -3.322398317032581e-206 }, 5.e-01 },
        /* 115 */ { { 8.9589789687104559e+102, -9.9671949510973086e-206 }, { 2.3705633575150122e+02, -1.1125369292536664e-308 }, 3.90625e-03 },
        /* 116 */ { { 4.0131652080900752e+205, -9.9671949510973086e-206 }, { 4.7341952432244256e+02, zero }, 1.953125e-03 },
        /* 117 */ { { max, -9.9671949510973086e-206 }, { 7.0978271289338397e+02, zero }, 9.765625e-04 },
        /* 118 */ { { inf, -9.9671949510973086e-206 }, { inf, zero }, 1.e+00 },
        /* 119 */ { { -inf, -min }, { inf, -pi }, 1.e+00 },
        /* 120 */ { { -max, -min }, { 7.0978271289338397e+02, -pi }, 9.765625e-04 },
        /* 121 */ { { -4.0131652080900752e+205, -min }, { 4.7341952432244256e+02, -pi }, 1.953125e-03 },
        /* 122 */ { { -8.9589789687104559e+102, -min }, { 2.3705633575150122e+02, -pi }, 3.90625e-03 },
        /* 123 */ { { -1.9999999999998694e+00, -min }, { -1.3056222769592694e-13, -pi }, 2.5e-01 },
        /* 124 */ { { -4.4647944971961829e-103, -min }, { -4.4647944971961829e-103, -min }, 2.2397447421778042e+102 },
        /* 125 */ { { -9.9671949510973086e-206, -min }, { -9.9671949510973086e-206, -min }, 1.0032913020226237e+205 },
        /* 126 */ { { -min, -min }, { -min, -min }, 2.2471164185778949e+307 },
        /* 127 */ { { zero, -min }, { zero, -min }, 2.2471164185778949e+307 },
        /* 128 */ { { min, -min }, { min, -min }, 2.2471164185778949e+307 },
        /* 129 */ { { 9.9671949510973086e-206, -min }, { 9.9671949510973086e-206, -min }, 1.0032913020226237e+205 },
        /* 130 */ { { 4.4647944971961829e-103, -min }, { 4.4647944971961829e-103, -min }, 2.2397447421778042e+102 },
        /* 131 */ { { 1.9999999999998694e+00, -min }, { 1.0986122886680663e+00, zero }, 5.e-01 },
        /* 132 */ { { 8.9589789687104559e+102, -min }, { 2.3705633575150122e+02, zero }, 3.90625e-03 },
        /* 133 */ { { 4.0131652080900752e+205, -min }, { 4.7341952432244256e+02, zero }, 1.953125e-03 },
        /* 134 */ { { max, -min }, { 7.0978271289338397e+02, zero }, 9.765625e-04 },
        /* 135 */ { { inf, -min }, { inf, zero }, 1.e+00 },
        /* 136 */ { { -inf, zero }, { inf, pi }, 1.e+00 },
        /* 137 */ { { -max, zero }, { 7.0978271289338397e+02, pi }, 9.765625e-04 },
        /* 138 */ { { -4.0131652080900752e+205, zero }, { 4.7341952432244256e+02, pi }, 1.953125e-03 },
        /* 139 */ { { -8.9589789687104559e+102, zero }, { 2.3705633575150122e+02, pi }, 3.90625e-03 },
        /* 140 */ { { -1.9999999999998694e+00, zero }, { -1.3056222769592694e-13, pi }, 2.5e-01 },
        /* 141 */ { { -4.4647944971961829e-103, zero }, { -4.4647944971961829e-103, zero }, 2.2397447421778042e+102 },
        /* 142 */ { { -9.9671949510973086e-206, zero }, { -9.9671949510973086e-206, zero }, 1.0032913020226237e+205 },
        /* 143 */ { { -min, zero }, { -min, zero }, 2.2471164185778949e+307 },
        /* 144 */ { { zero, zero }, { zero, zero }, 1.e+00 },
        /* 145 */ { { min, zero }, { min, zero }, 2.2471164185778949e+307 },
        /* 146 */ { { 9.9671949510973086e-206, zero }, { 9.9671949510973086e-206, zero }, 1.0032913020226237e+205 },
        /* 147 */ { { 4.4647944971961829e-103, zero }, { 4.4647944971961829e-103, zero }, 2.2397447421778042e+102 },
        /* 148 */ { { 1.9999999999998694e+00, zero }, { 1.0986122886680663e+00, zero }, 5.e-01 },
        /* 149 */ { { 8.9589789687104559e+102, zero }, { 2.3705633575150122e+02, zero }, 3.90625e-03 },
        /* 150 */ { { 4.0131652080900752e+205, zero }, { 4.7341952432244256e+02, zero }, 1.953125e-03 },
        /* 151 */ { { max, zero }, { 7.0978271289338397e+02, zero }, 9.765625e-04 },
        /* 152 */ { { inf, zero }, { inf, zero }, 1.e+00 },
        /* 153 */ { { -inf, min }, { inf, pi }, 1.e+00 },
        /* 154 */ { { -max, min }, { 7.0978271289338397e+02, pi }, 9.765625e-04 },
        /* 155 */ { { -4.0131652080900752e+205, min }, { 4.7341952432244256e+02, pi }, 1.953125e-03 },
        /* 156 */ { { -8.9589789687104559e+102, min }, { 2.3705633575150122e+02, pi }, 3.90625e-03 },
        /* 157 */ { { -1.9999999999998694e+00, min }, { -1.3056222769592694e-13, pi }, 2.5e-01 },
        /* 158 */ { { -4.4647944971961829e-103, min }, { -4.4647944971961829e-103, min }, 2.2397447421778042e+102 },
        /* 159 */ { { -9.9671949510973086e-206, min }, { -9.9671949510973086e-206, min }, 1.0032913020226237e+205 },
        /* 160 */ { { -min, min }, { -min, min }, 2.2471164185778949e+307 },
        /* 161 */ { { zero, min }, { zero, min }, 2.2471164185778949e+307 },
        /* 162 */ { { min, min }, { min, min }, 2.2471164185778949e+307 },
        /* 163 */ { { 9.9671949510973086e-206, min }, { 9.9671949510973086e-206, min }, 1.0032913020226237e+205 },
        /* 164 */ { { 4.4647944971961829e-103, min }, { 4.4647944971961829e-103, min }, 2.2397447421778042e+102 },
        /* 165 */ { { 1.9999999999998694e+00, min }, { 1.0986122886680663e+00, zero }, 5.e-01 },
        /* 166 */ { { 8.9589789687104559e+102, min }, { 2.3705633575150122e+02, zero }, 3.90625e-03 },
        /* 167 */ { { 4.0131652080900752e+205, min }, { 4.7341952432244256e+02, zero }, 1.953125e-03 },
        /* 168 */ { { max, min }, { 7.0978271289338397e+02, zero }, 9.765625e-04 },
        /* 169 */ { { inf, min }, { inf, zero }, 1.e+00 },
        /* 170 */ { { -inf, 9.9671949510973086e-206 }, { inf, pi }, 1.e+00 },
        /* 171 */ { { -max, 9.9671949510973086e-206 }, { 7.0978271289338397e+02, pi }, 9.765625e-04 },
        /* 172 */ { { -4.0131652080900752e+205, 9.9671949510973086e-206 }, { 4.7341952432244256e+02, pi }, 1.953125e-03 },
        /* 173 */ { { -8.9589789687104559e+102, 9.9671949510973086e-206 }, { 2.3705633575150122e+02, pi }, 3.90625e-03 },
        /* 174 */ { { -1.9999999999998694e+00, 9.9671949510973086e-206 }, { -1.3056222769592694e-13, pi }, 2.5e-01 },
        /* 175 */ { { -4.4647944971961829e-103, 9.9671949510973086e-206 }, { -4.4647944971961829e-103, 9.9671949510973086e-206 }, 2.2397447421778042e+102 },
        /* 176 */ { { -9.9671949510973086e-206, 9.9671949510973086e-206 }, { -9.9671949510973086e-206, 9.9671949510973086e-206 }, 5.0164565101131187e+204 },
        /* 177 */ { { -min, 9.9671949510973086e-206 }, { -min, 9.9671949510973086e-206 }, 1.0032913020226237e+205 },
        /* 178 */ { { zero, 9.9671949510973086e-206 }, { zero, 9.9671949510973086e-206 }, 1.0032913020226237e+205 },
        /* 179 */ { { min, 9.9671949510973086e-206 }, { min, 9.9671949510973086e-206 }, 1.0032913020226237e+205 },
        /* 180 */ { { 9.9671949510973086e-206, 9.9671949510973086e-206 }, { 9.9671949510973086e-206, 9.9671949510973086e-206 }, 5.0164565101131187e+204 },
        /* 181 */ { { 4.4647944971961829e-103, 9.9671949510973086e-206 }, { 4.4647944971961829e-103, 9.9671949510973086e-206 }, 2.2397447421778042e+102 },
        /* 182 */ { { 1.9999999999998694e+00, 9.9671949510973086e-206 }, { 1.0986122886680663e+00, 3.322398317032581e-206 }, 5.e-01 },
        /* 183 */ { { 8.9589789687104559e+102, 9.9671949510973086e-206 }, { 2.3705633575150122e+02, 1.1125369292536664e-308 }, 3.90625e-03 },
        /* 184 */ { { 4.0131652080900752e+205, 9.9671949510973086e-206 }, { 4.7341952432244256e+02, zero }, 1.953125e-03 },
        /* 185 */ { { max, 9.9671949510973086e-206 }, { 7.0978271289338397e+02, zero }, 9.765625e-04 },
        /* 186 */ { { inf, 9.9671949510973086e-206 }, { inf, zero }, 1.e+00 },
        /* 187 */ { { -inf, 4.4647944971961829e-103 }, { inf, pi }, 1.e+00 },
        /* 188 */ { { -max, 4.4647944971961829e-103 }, { 7.0978271289338397e+02, pi }, 9.765625e-04 },
        /* 189 */ { { -4.0131652080900752e+205, 4.4647944971961829e-103 }, { 4.7341952432244256e+02, pi }, 1.953125e-03 },
        /* 190 */ { { -8.9589789687104559e+102, 4.4647944971961829e-103 }, { 2.3705633575150122e+02, pi }, 3.90625e-03 },
        /* 191 */ { { -1.9999999999998694e+00, 4.4647944971961829e-103 }, { -1.3056222769592694e-13, pi }, 2.5e-01 },
        /* 192 */ { { -4.4647944971961829e-103, 4.4647944971961829e-103 }, { -4.4647944971961829e-103, 4.4647944971961829e-103 }, 1.1198723710889021e+102 },
        /* 193 */ { { -9.9671949510973086e-206, 4.4647944971961829e-103 }, { -6.5066958834738373e-219, 4.4647944971961829e-103 }, 2.2397447421778042e+102 },
        /* 194 */ { { -min, 4.4647944971961829e-103 }, { 9.9671949510966579e-206, 4.4647944971961829e-103 }, 2.2397447421778042e+102 },
        /* 195 */ { { zero, 4.4647944971961829e-103 }, { 9.9671949510966579e-206, 4.4647944971961829e-103 }, 2.2397447421778042e+102 },
        /* 196 */ { { min, 4.4647944971961829e-103 }, { 9.9671949510966579e-206, 4.4647944971961829e-103 }, 2.2397447421778042e+102 },
        /* 197 */ { { 9.9671949510973086e-206, 4.4647944971961829e-103 }, { 1.9934389902193967e-205, 4.4647944971961829e-103 }, 2.2397447421778042e+102 },
        /* 198 */ { { 4.4647944971961829e-103, 4.4647944971961829e-103 }, { 4.4647944971961829e-103, 4.4647944971961829e-103 }, 1.1198723710889021e+102 },
        /* 199 */ { { 1.9999999999998694e+00, 4.4647944971961829e-103 }, { 1.0986122886680663e+00, 1.4882648323987925e-103 }, 5.e-01 },
        /* 200 */ { { 8.9589789687104559e+102, 4.4647944971961829e-103 }, { 2.3705633575150122e+02, 4.9835974755489796e-206 }, 3.90625e-03 },
        /* 201 */ { { 4.0131652080900752e+205, 4.4647944971961829e-103 }, { 4.7341952432244256e+02, 1.1125369292536664e-308 }, 1.953125e-03 },
        /* 202 */ { { max, 4.4647944971961829e-103 }, { 7.0978271289338397e+02, zero }, 9.765625e-04 },
        /* 203 */ { { inf, 4.4647944971961829e-103 }, { inf, zero }, 1.e+00 },
        /* 204 */ { { -inf, 1.9999999999998694e+00 }, { inf, pi }, 1.e+00 },
        /* 205 */ { { -max, 1.9999999999998694e+00 }, { 7.0978271289338397e+02, pi }, 9.765625e-04 },
        /* 206 */ { { -4.0131652080900752e+205, 1.9999999999998694e+00 }, { 4.7341952432244256e+02, pi }, 1.953125e-03 },
        /* 207 */ { { -8.9589789687104559e+102, 1.9999999999998694e+00 }, { 2.3705633575150122e+02, pi }, 3.90625e-03 },
        /* 208 */ { { -1.9999999999998694e+00, 1.9999999999998694e+00 }, { 8.0471895621697187e-01, 2.0344439357956765e+00 }, 2.5e-01 },
        /* 209 */ { { -4.4647944971961829e-103, 1.9999999999998694e+00 }, { 8.0471895621699796e-01, 1.1071487177940644e+00 }, 5.e-01 },
        /* 210 */ { { -9.9671949510973086e-206, 1.9999999999998694e+00 }, { 8.0471895621699796e-01, 1.1071487177940644e+00 }, 5.e-01 },
        /* 211 */ { { -min, 1.9999999999998694e+00 }, { 8.0471895621699796e-01, 1.1071487177940644e+00 }, 5.e-01 },
        /* 212 */ { { zero, 1.9999999999998694e+00 }, { 8.0471895621699796e-01, 1.1071487177940644e+00 }, 5.e-01 },
        /* 213 */ { { min, 1.9999999999998694e+00 }, { 8.0471895621699796e-01, 1.1071487177940644e+00 }, 5.e-01 },
        /* 214 */ { { 9.9671949510973086e-206, 1.9999999999998694e+00 }, { 8.0471895621699796e-01, 1.1071487177940644e+00 }, 5.e-01 },
        /* 215 */ { { 4.4647944971961829e-103, 1.9999999999998694e+00 }, { 8.0471895621699796e-01, 1.1071487177940644e+00 }, 5.e-01 },
        /* 216 */ { { 1.9999999999998694e+00, 1.9999999999998694e+00 }, { 1.2824746787307182e+00, 5.8800260354755751e-01 }, 5.e-01 },
        /* 217 */ { { 8.9589789687104559e+102, 1.9999999999998694e+00 }, { 2.3705633575150122e+02, 2.2323972485982374e-103 }, 3.90625e-03 },
        /* 218 */ { { 4.0131652080900752e+205, 1.9999999999998694e+00 }, { 4.7341952432244256e+02, 4.9835974755489796e-206 }, 1.953125e-03 },
        /* 219 */ { { max, 1.9999999999998694e+00 }, { 7.0978271289338397e+02, zero }, 9.765625e-04 },
        /* 220 */ { { inf, 1.9999999999998694e+00 }, { inf, zero }, 1.e+00 },
        /* 221 */ { { -inf, 8.9589789687104559e+102 }, { inf, pi }, 1.e+00 },
        /* 222 */ { { -max, 8.9589789687104559e+102 }, { 7.0978271289338397e+02, pi }, 9.765625e-04 },
        /* 223 */ { { -4.0131652080900752e+205, 8.9589789687104559e+102 }, { 4.7341952432244256e+02, pi }, 1.953125e-03 },
        /* 224 */ { { -8.9589789687104559e+102, 8.9589789687104559e+102 }, { 2.374029093417812e+02, pi3_4 }, 3.90625e-03 },
        /* 225 */ { { -1.9999999999998694e+00, 8.9589789687104559e+102 }, { 2.3705633575150122e+02, pi_2 }, 3.90625e-03 },
        /* 226 */ { { -4.4647944971961829e-103, 8.9589789687104559e+102 }, { 2.3705633575150122e+02, pi_2 }, 3.90625e-03 },
        /* 227 */ { { -9.9671949510973086e-206, 8.9589789687104559e+102 }, { 2.3705633575150122e+02, pi_2 }, 3.90625e-03 },
        /* 228 */ { { -min, 8.9589789687104559e+102 }, { 2.3705633575150122e+02, pi_2 }, 3.90625e-03 },
        /* 229 */ { { zero, 8.9589789687104559e+102 }, { 2.3705633575150122e+02, pi_2 }, 3.90625e-03 },
        /* 230 */ { { min, 8.9589789687104559e+102 }, { 2.3705633575150122e+02, pi_2 }, 3.90625e-03 },
        /* 231 */ { { 9.9671949510973086e-206, 8.9589789687104559e+102 }, { 2.3705633575150122e+02, pi_2 }, 3.90625e-03 },
        /* 232 */ { { 4.4647944971961829e-103, 8.9589789687104559e+102 }, { 2.3705633575150122e+02, pi_2 }, 3.90625e-03 },
        /* 233 */ { { 1.9999999999998694e+00, 8.9589789687104559e+102 }, { 2.3705633575150122e+02, pi_2 }, 3.90625e-03 },
        /* 234 */ { { 8.9589789687104559e+102, 8.9589789687104559e+102 }, { 2.374029093417812e+02, pi_4 }, 3.90625e-03 },
        /* 235 */ { { 4.0131652080900752e+205, 8.9589789687104559e+102 }, { 4.7341952432244256e+02, 2.2323972485982374e-103 }, 1.953125e-03 },
        /* 236 */ { { max, 8.9589789687104559e+102 }, { 7.0978271289338397e+02, 4.9835974755483611e-206 }, 9.765625e-04 },
        /* 237 */ { { inf, 8.9589789687104559e+102 }, { inf, zero }, 1.e+00 },
        /* 238 */ { { -inf, 4.0131652080900752e+205 }, { inf, pi }, 1.e+00 },
        /* 239 */ { { -max, 4.0131652080900752e+205 }, { 7.0978271289338397e+02, pi }, 9.765625e-04 },
        /* 240 */ { { -4.0131652080900752e+205, 4.0131652080900752e+205 }, { 4.737660979127225e+02, pi3_4 }, 1.953125e-03 },
        /* 241 */ { { -8.9589789687104559e+102, 4.0131652080900752e+205 }, { 4.7341952432244256e+02, pi_2 }, 1.953125e-03 },
        /* 242 */ { { -1.9999999999998694e+00, 4.0131652080900752e+205 }, { 4.7341952432244256e+02, pi_2 }, 1.953125e-03 },
        /* 243 */ { { -4.4647944971961829e-103, 4.0131652080900752e+205 }, { 4.7341952432244256e+02, pi_2 }, 1.953125e-03 },
        /* 244 */ { { -9.9671949510973086e-206, 4.0131652080900752e+205 }, { 4.7341952432244256e+02, pi_2 }, 1.953125e-03 },
        /* 245 */ { { -min, 4.0131652080900752e+205 }, { 4.7341952432244256e+02, pi_2 }, 1.953125e-03 },
        /* 246 */ { { zero, 4.0131652080900752e+205 }, { 4.7341952432244256e+02, pi_2 }, 1.953125e-03 },
        /* 247 */ { { min, 4.0131652080900752e+205 }, { 4.7341952432244256e+02, pi_2 }, 1.953125e-03 },
        /* 248 */ { { 9.9671949510973086e-206, 4.0131652080900752e+205 }, { 4.7341952432244256e+02, pi_2 }, 1.953125e-03 },
        /* 249 */ { { 4.4647944971961829e-103, 4.0131652080900752e+205 }, { 4.7341952432244256e+02, pi_2 }, 1.953125e-03 },
        /* 250 */ { { 1.9999999999998694e+00, 4.0131652080900752e+205 }, { 4.7341952432244256e+02, pi_2 }, 1.953125e-03 },
        /* 251 */ { { 8.9589789687104559e+102, 4.0131652080900752e+205 }, { 4.7341952432244256e+02, pi_2 }, 1.953125e-03 },
        /* 252 */ { { 4.0131652080900752e+205, 4.0131652080900752e+205 }, { 4.737660979127225e+02, pi_4 }, 1.953125e-03 },
        /* 253 */ { { max, 4.0131652080900752e+205 }, { 7.0978271289338397e+02, 2.2323972485979601e-103 }, 9.765625e-04 },
        /* 254 */ { { inf, 4.0131652080900752e+205 }, { inf, zero }, 1.e+00 },
        /* 255 */ { { -inf, max }, { inf, pi }, 1.e+00 },
        /* 256 */ { { -max, max }, { 7.1012928648366392e+02, pi3_4 }, 9.765625e-04 },
        /* 257 */ { { -4.0131652080900752e+205, max }, { 7.0978271289338397e+02, pi_2 }, 9.765625e-04 },
        /* 258 */ { { -8.9589789687104559e+102, max }, { 7.0978271289338397e+02, pi_2 }, 9.765625e-04 },
        /* 259 */ { { -1.9999999999998694e+00, max }, { 7.0978271289338397e+02, pi_2 }, 9.765625e-04 },
        /* 260 */ { { -4.4647944971961829e-103, max }, { 7.0978271289338397e+02, pi_2 }, 9.765625e-04 },
        /* 261 */ { { -9.9671949510973086e-206, max }, { 7.0978271289338397e+02, pi_2 }, 9.765625e-04 },
        /* 262 */ { { -min, max }, { 7.0978271289338397e+02, pi_2 }, 9.765625e-04 },
        /* 263 */ { { zero, max }, { 7.0978271289338397e+02, pi_2 }, 9.765625e-04 },
        /* 264 */ { { min, max }, { 7.0978271289338397e+02, pi_2 }, 9.765625e-04 },
        /* 265 */ { { 9.9671949510973086e-206, max }, { 7.0978271289338397e+02, pi_2 }, 9.765625e-04 },
        /* 266 */ { { 4.4647944971961829e-103, max }, { 7.0978271289338397e+02, pi_2 }, 9.765625e-04 },
        /* 267 */ { { 1.9999999999998694e+00, max }, { 7.0978271289338397e+02, pi_2 }, 9.765625e-04 },
        /* 268 */ { { 8.9589789687104559e+102, max }, { 7.0978271289338397e+02, pi_2 }, 9.765625e-04 },
        /* 269 */ { { 4.0131652080900752e+205, max }, { 7.0978271289338397e+02, pi_2 }, 9.765625e-04 },
        /* 270 */ { { max, max }, { 7.1012928648366392e+02, pi_4 }, 9.765625e-04 },
        /* 271 */ { { inf, max }, { inf, zero }, 1.e+00 },
        /* 272 */ { { -inf, inf }, { inf, pi3_4 }, 1.e+00 },
        /* 273 */ { { -max, inf }, { inf, pi_2 }, 1.e+00 },
        /* 274 */ { { -4.0131652080900752e+205, inf }, { inf, pi_2 }, 1.e+00 },
        /* 275 */ { { -8.9589789687104559e+102, inf }, { inf, pi_2 }, 1.e+00 },
        /* 276 */ { { -1.9999999999998694e+00, inf }, { inf, pi_2 }, 1.e+00 },
        /* 277 */ { { -4.4647944971961829e-103, inf }, { inf, pi_2 }, 1.e+00 },
        /* 278 */ { { -9.9671949510973086e-206, inf }, { inf, pi_2 }, 1.e+00 },
        /* 279 */ { { -min, inf }, { inf, pi_2 }, 1.e+00 },
        /* 280 */ { { zero, inf }, { inf, pi_2 }, 1.e+00 },
        /* 281 */ { { min, inf }, { inf, pi_2 }, 1.e+00 },
        /* 282 */ { { 9.9671949510973086e-206, inf }, { inf, pi_2 }, 1.e+00 },
        /* 283 */ { { 4.4647944971961829e-103, inf }, { inf, pi_2 }, 1.e+00 },
        /* 284 */ { { 1.9999999999998694e+00, inf }, { inf, pi_2 }, 1.e+00 },
        /* 285 */ { { 8.9589789687104559e+102, inf }, { inf, pi_2 }, 1.e+00 },
        /* 286 */ { { 4.0131652080900752e+205, inf }, { inf, pi_2 }, 1.e+00 },
        /* 287 */ { { max, inf }, { inf, pi_2 }, 1.e+00 },
        /* 288 */ { { inf, inf }, { inf, pi_4 }, 1.e+00 }
          // clang-format on
      };
      return table;
    } else {
      static_assert(dependent_false<T>); /* unreachable */
    }
  }
};

template <typename T, int default_dps_deficiency = 0>
struct Tan {
  typedef std::complex<T> InputType;
  typedef std::complex<T> OutputType;
  typedef T FloatType;
  using TableType = std::vector<std::tuple<InputType, OutputType, FloatType>>;
  static constexpr int dps_deficiency = default_dps_deficiency;
  const TableType get() {
    if constexpr (std::is_same_v<T, float>) {
      const T nan = std::nanf("");
      const T zero = 0.0f;
      const T inf = std::numeric_limits<T>::infinity();
#ifdef __aarch64__
      const T min = std::nextafter(std::numeric_limits<T>::min(), T(1));
#else
      const T min = std::numeric_limits<T>::min();
#endif
      const T max = std::numeric_limits<T>::max();
      const TableType table{
          // clang-format off
          // Ignore max 80 character line width style requirement for
          // (i) the readability
          // (ii) the consistency with the local conventions
        /* 0 */ { { -inf, -inf }, { zero, -1.e+00f }, 5.e-01f },
        /* 1 */ { { -max, -inf }, { zero, -1.e+00f }, 5.e-01f },
        /* 2 */ { { -6.1409603e+25f, -inf }, { zero, -1.e+00f }, 5.e-01f },
        /* 3 */ { { -1.1082383e+13f, -inf }, { zero, -1.e+00f }, 5.e-01f },
        /* 4 */ { { -2.e+00f, -inf }, { zero, -1.e+00f }, 5.e-01f },
        /* 5 */ { { -3.6093321e-13f, -inf }, { zero, -1.e+00f }, 5.e-01f },
        /* 6 */ { { -6.5136393e-26f, -inf }, { zero, -1.e+00f }, 5.e-01f },
        /* 7 */ { { -min, -inf }, { zero, -1.e+00f }, 5.e-01f },
        /* 8 */ { { zero, -inf }, { zero, -1.e+00f }, 5.e-01f },
        /* 9 */ { { min, -inf }, { zero, -1.e+00f }, 5.e-01f },
        /* 10 */ { { 6.5136393e-26f, -inf }, { zero, -1.e+00f }, 5.e-01f },
        /* 11 */ { { 3.6093321e-13f, -inf }, { zero, -1.e+00f }, 5.e-01f },
        /* 12 */ { { 2.e+00f, -inf }, { zero, -1.e+00f }, 5.e-01f },
        /* 13 */ { { 1.1082383e+13f, -inf }, { zero, -1.e+00f }, 5.e-01f },
        /* 14 */ { { 6.1409603e+25f, -inf }, { zero, -1.e+00f }, 5.e-01f },
        /* 15 */ { { max, -inf }, { zero, -1.e+00f }, 5.e-01f },
        /* 16 */ { { inf, -inf }, { zero, -1.e+00f }, 5.e-01f },
        /* 17 */ { { -inf, -max }, { nan, nan }, 1.e+00f },
        /* 18 */ { { -max, -max }, { zero, -1.e+00f }, 5.e-01f },
        /* 19 */ { { -6.1409603e+25f, -max }, { zero, -1.e+00f }, 5.e-01f },
        /* 20 */ { { -1.1082383e+13f, -max }, { zero, -1.e+00f }, 5.e-01f },
        /* 21 */ { { -2.e+00f, -max }, { zero, -1.e+00f }, 5.e-01f },
        /* 22 */ { { -3.6093321e-13f, -max }, { zero, -1.e+00f }, 5.e-01f },
        /* 23 */ { { -6.5136393e-26f, -max }, { zero, -1.e+00f }, 5.e-01f },
        /* 24 */ { { -min, -max }, { zero, -1.e+00f }, 5.e-01f },
        /* 25 */ { { zero, -max }, { zero, -1.e+00f }, 5.e-01f },
        /* 26 */ { { min, -max }, { zero, -1.e+00f }, 5.e-01f },
        /* 27 */ { { 6.5136393e-26f, -max }, { zero, -1.e+00f }, 5.e-01f },
        /* 28 */ { { 3.6093321e-13f, -max }, { zero, -1.e+00f }, 5.e-01f },
        /* 29 */ { { 2.e+00f, -max }, { zero, -1.e+00f }, 5.e-01f },
        /* 30 */ { { 1.1082383e+13f, -max }, { zero, -1.e+00f }, 5.e-01f },
        /* 31 */ { { 6.1409603e+25f, -max }, { zero, -1.e+00f }, 5.e-01f },
        /* 32 */ { { max, -max }, { zero, -1.e+00f }, 5.e-01f },
        /* 33 */ { { inf, -max }, { nan, nan }, 1.e+00f },
        /* 34 */ { { -inf, -6.1409603e+25f }, { nan, nan }, 1.e+00f },
        /* 35 */ { { -max, -6.1409603e+25f }, { zero, -1.e+00f }, 5.e-01f },
        /* 36 */ { { -6.1409603e+25f, -6.1409603e+25f }, { zero, -1.e+00f }, 5.e-01f },
        /* 37 */ { { -1.1082383e+13f, -6.1409603e+25f }, { zero, -1.e+00f }, 5.e-01f },
        /* 38 */ { { -2.e+00f, -6.1409603e+25f }, { zero, -1.e+00f }, 5.e-01f },
        /* 39 */ { { -3.6093321e-13f, -6.1409603e+25f }, { zero, -1.e+00f }, 5.e-01f },
        /* 40 */ { { -6.5136393e-26f, -6.1409603e+25f }, { zero, -1.e+00f }, 5.e-01f },
        /* 41 */ { { -min, -6.1409603e+25f }, { zero, -1.e+00f }, 5.e-01f },
        /* 42 */ { { zero, -6.1409603e+25f }, { zero, -1.e+00f }, 5.e-01f },
        /* 43 */ { { min, -6.1409603e+25f }, { zero, -1.e+00f }, 5.e-01f },
        /* 44 */ { { 6.5136393e-26f, -6.1409603e+25f }, { zero, -1.e+00f }, 5.e-01f },
        /* 45 */ { { 3.6093321e-13f, -6.1409603e+25f }, { zero, -1.e+00f }, 5.e-01f },
        /* 46 */ { { 2.e+00f, -6.1409603e+25f }, { zero, -1.e+00f }, 5.e-01f },
        /* 47 */ { { 1.1082383e+13f, -6.1409603e+25f }, { zero, -1.e+00f }, 5.e-01f },
        /* 48 */ { { 6.1409603e+25f, -6.1409603e+25f }, { zero, -1.e+00f }, 5.e-01f },
        /* 49 */ { { max, -6.1409603e+25f }, { zero, -1.e+00f }, 5.e-01f },
        /* 50 */ { { inf, -6.1409603e+25f }, { nan, nan }, 1.e+00f },
        /* 51 */ { { -inf, -1.1082383e+13f }, { nan, nan }, 1.e+00f },
        /* 52 */ { { -max, -1.1082383e+13f }, { zero, -1.e+00f }, 5.e-01f },
        /* 53 */ { { -6.1409603e+25f, -1.1082383e+13f }, { zero, -1.e+00f }, 5.e-01f },
        /* 54 */ { { -1.1082383e+13f, -1.1082383e+13f }, { zero, -1.e+00f }, 5.e-01f },
        /* 55 */ { { -2.e+00f, -1.1082383e+13f }, { zero, -1.e+00f }, 5.e-01f },
        /* 56 */ { { -3.6093321e-13f, -1.1082383e+13f }, { zero, -1.e+00f }, 5.e-01f },
        /* 57 */ { { -6.5136393e-26f, -1.1082383e+13f }, { zero, -1.e+00f }, 5.e-01f },
        /* 58 */ { { -min, -1.1082383e+13f }, { zero, -1.e+00f }, 5.e-01f },
        /* 59 */ { { zero, -1.1082383e+13f }, { zero, -1.e+00f }, 5.e-01f },
        /* 60 */ { { min, -1.1082383e+13f }, { zero, -1.e+00f }, 5.e-01f },
        /* 61 */ { { 6.5136393e-26f, -1.1082383e+13f }, { zero, -1.e+00f }, 5.e-01f },
        /* 62 */ { { 3.6093321e-13f, -1.1082383e+13f }, { zero, -1.e+00f }, 5.e-01f },
        /* 63 */ { { 2.e+00f, -1.1082383e+13f }, { zero, -1.e+00f }, 5.e-01f },
        /* 64 */ { { 1.1082383e+13f, -1.1082383e+13f }, { zero, -1.e+00f }, 5.e-01f },
        /* 65 */ { { 6.1409603e+25f, -1.1082383e+13f }, { zero, -1.e+00f }, 5.e-01f },
        /* 66 */ { { max, -1.1082383e+13f }, { zero, -1.e+00f }, 5.e-01f },
        /* 67 */ { { inf, -1.1082383e+13f }, { nan, nan }, 1.e+00f },
        /* 68 */ { { -inf, -2.e+00f }, { nan, nan }, 1.e+00f },
        /* 69 */ { { -max, -2.e+00f }, { 3.2068815e-02f, -9.8294145e-01f }, 1.e+00f },
        /* 70 */ { { -6.1409603e+25f, -2.e+00f }, { 5.3751757e-03f, -1.0369183e+00f }, 5.e-01f },
        /* 71 */ { { -1.1082383e+13f, -2.e+00f }, { -3.4068439e-02f, -9.8717695e-01f }, 1.e+00f },
        /* 72 */ { { -2.e+00f, -2.e+00f }, { 2.8392954e-02f, -1.0238355e+00f }, 5.e-01f },
        /* 73 */ { { -3.6093321e-13f, -2.e+00f }, { -2.5500228e-14f, -9.6402758e-01f }, 1.e+00f },
        /* 74 */ { { -6.5136393e-26f, -2.e+00f }, { -4.6019399e-27f, -9.6402758e-01f }, 1.e+00f },
        /* 75 */ { { -min, -2.e+00f }, { zero, -9.6402758e-01f }, 1.e+00f },
        /* 76 */ { { zero, -2.e+00f }, { zero, -9.6402758e-01f }, 1.e+00f },
        /* 77 */ { { min, -2.e+00f }, { zero, -9.6402758e-01f }, 1.e+00f },
        /* 78 */ { { 6.5136393e-26f, -2.e+00f }, { 4.6019399e-27f, -9.6402758e-01f }, 1.e+00f },
        /* 79 */ { { 3.6093321e-13f, -2.e+00f }, { 2.5500228e-14f, -9.6402758e-01f }, 1.e+00f },
        /* 80 */ { { 2.e+00f, -2.e+00f }, { -2.8392954e-02f, -1.0238355e+00f }, 5.e-01f },
        /* 81 */ { { 1.1082383e+13f, -2.e+00f }, { 3.4068439e-02f, -9.8717695e-01f }, 1.e+00f },
        /* 82 */ { { 6.1409603e+25f, -2.e+00f }, { -5.3751757e-03f, -1.0369183e+00f }, 5.e-01f },
        /* 83 */ { { max, -2.e+00f }, { -3.2068815e-02f, -9.8294145e-01f }, 1.e+00f },
        /* 84 */ { { inf, -2.e+00f }, { nan, nan }, 1.e+00f },
        /* 85 */ { { -inf, -3.6093321e-13f }, { nan, nan }, 1.e+00f },
        /* 86 */ { { -max, -3.6093321e-13f }, { 6.1179793e-01f, -4.9602932e-13f }, 1.e+00f },
        /* 87 */ { { -6.1409603e+25f, -3.6093321e-13f }, { 1.406664e+01f, -7.1778909e-11f }, 6.25e-02f },
        /* 88 */ { { -1.1082383e+13f, -3.6093321e-13f }, { -7.0485216e-01f, -5.4025084e-13f }, 1.e+00f },
        /* 89 */ { { -2.e+00f, -3.6093321e-13f }, { 2.1850398e+00f, -2.0841725e-12f }, 2.5e-01f },
        /* 90 */ { { -3.6093321e-13f, -3.6093321e-13f }, { -3.6093321e-13f, -3.6093321e-13f }, 1.0995116e+12f },
        /* 91 */ { { -6.5136393e-26f, -3.6093321e-13f }, { -6.5136393e-26f, -3.6093321e-13f }, 2.1990233e+12f },
        /* 92 */ { { -min, -3.6093321e-13f }, { -min, -3.6093321e-13f }, 2.1990233e+12f },
        /* 93 */ { { zero, -3.6093321e-13f }, { zero, -3.6093321e-13f }, 2.1990233e+12f },
        /* 94 */ { { min, -3.6093321e-13f }, { min, -3.6093321e-13f }, 2.1990233e+12f },
        /* 95 */ { { 6.5136393e-26f, -3.6093321e-13f }, { 6.5136393e-26f, -3.6093321e-13f }, 2.1990233e+12f },
        /* 96 */ { { 3.6093321e-13f, -3.6093321e-13f }, { 3.6093321e-13f, -3.6093321e-13f }, 1.0995116e+12f },
        /* 97 */ { { 2.e+00f, -3.6093321e-13f }, { -2.1850398e+00f, -2.0841725e-12f }, 2.5e-01f },
        /* 98 */ { { 1.1082383e+13f, -3.6093321e-13f }, { 7.0485216e-01f, -5.4025084e-13f }, 1.e+00f },
        /* 99 */ { { 6.1409603e+25f, -3.6093321e-13f }, { -1.406664e+01f, -7.1778909e-11f }, 6.25e-02f },
        /* 100 */ { { max, -3.6093321e-13f }, { -6.1179793e-01f, -4.9602932e-13f }, 1.e+00f },
        /* 101 */ { { inf, -3.6093321e-13f }, { nan, nan }, 1.e+00f },
        /* 102 */ { { -inf, -6.5136393e-26f }, { nan, nan }, 1.e+00f },
        /* 103 */ { { -max, -6.5136393e-26f }, { 6.1179793e-01f, -8.9516731e-26f }, 1.e+00f },
        /* 104 */ { { -6.1409603e+25f, -6.5136393e-26f }, { 1.406664e+01f, -1.2953697e-23f }, 6.25e-02f },
        /* 105 */ { { -1.1082383e+13f, -6.5136393e-26f }, { -7.0485216e-01f, -9.7497236e-26f }, 1.e+00f },
        /* 106 */ { { -2.e+00f, -6.5136393e-26f }, { 2.1850398e+00f, -3.7612353e-25f }, 2.5e-01f },
        /* 107 */ { { -3.6093321e-13f, -6.5136393e-26f }, { -3.6093321e-13f, -6.5136393e-26f }, 2.1990233e+12f },
        /* 108 */ { { -6.5136393e-26f, -6.5136393e-26f }, { -6.5136393e-26f, -6.5136393e-26f }, 9.6714066e+24f },
        /* 109 */ { { -min, -6.5136393e-26f }, { -min, -6.5136393e-26f }, 9.6714066e+24f },
        /* 110 */ { { zero, -6.5136393e-26f }, { zero, -6.5136393e-26f }, 9.6714066e+24f },
        /* 111 */ { { min, -6.5136393e-26f }, { min, -6.5136393e-26f }, 9.6714066e+24f },
        /* 112 */ { { 6.5136393e-26f, -6.5136393e-26f }, { 6.5136393e-26f, -6.5136393e-26f }, 9.6714066e+24f },
        /* 113 */ { { 3.6093321e-13f, -6.5136393e-26f }, { 3.6093321e-13f, -6.5136393e-26f }, 2.1990233e+12f },
        /* 114 */ { { 2.e+00f, -6.5136393e-26f }, { -2.1850398e+00f, -3.7612353e-25f }, 2.5e-01f },
        /* 115 */ { { 1.1082383e+13f, -6.5136393e-26f }, { 7.0485216e-01f, -9.7497236e-26f }, 1.e+00f },
        /* 116 */ { { 6.1409603e+25f, -6.5136393e-26f }, { -1.406664e+01f, -1.2953697e-23f }, 6.25e-02f },
        /* 117 */ { { max, -6.5136393e-26f }, { -6.1179793e-01f, -8.9516731e-26f }, 1.e+00f },
        /* 118 */ { { inf, -6.5136393e-26f }, { nan, nan }, 1.e+00f },
        /* 119 */ { { -inf, -min }, { nan, nan }, 1.e+00f },
        /* 120 */ { { -max, -min }, { 6.1179793e-01f, -1.6154781e-38f }, 1.e+00f },
        /* 121 */ { { -6.1409603e+25f, -min }, { 1.406664e+01f, -2.3377097e-36f }, 6.25e-02f },
        /* 122 */ { { -1.1082383e+13f, -min }, { -7.0485216e-01f, -1.7594995e-38f }, 1.e+00f },
        /* 123 */ { { -2.e+00f, -min }, { 2.1850398e+00f, -6.7877737e-38f }, 2.5e-01f },
        /* 124 */ { { -3.6093321e-13f, -min }, { -3.6093321e-13f, -min }, 2.1990233e+12f },
        /* 125 */ { { -6.5136393e-26f, -min }, { -6.5136393e-26f, -min }, 9.6714066e+24f },
        /* 126 */ { { -min, -min }, { -min, -min }, 4.2535296e+37f },
        /* 127 */ { { zero, -min }, { zero, -min }, 4.2535296e+37f },
        /* 128 */ { { min, -min }, { min, -min }, 4.2535296e+37f },
        /* 129 */ { { 6.5136393e-26f, -min }, { 6.5136393e-26f, -min }, 9.6714066e+24f },
        /* 130 */ { { 3.6093321e-13f, -min }, { 3.6093321e-13f, -min }, 2.1990233e+12f },
        /* 131 */ { { 2.e+00f, -min }, { -2.1850398e+00f, -6.7877737e-38f }, 2.5e-01f },
        /* 132 */ { { 1.1082383e+13f, -min }, { 7.0485216e-01f, -1.7594995e-38f }, 1.e+00f },
        /* 133 */ { { 6.1409603e+25f, -min }, { -1.406664e+01f, -2.3377097e-36f }, 6.25e-02f },
        /* 134 */ { { max, -min }, { -6.1179793e-01f, -1.6154781e-38f }, 1.e+00f },
        /* 135 */ { { inf, -min }, { nan, nan }, 1.e+00f },
        /* 136 */ { { -inf, zero }, { nan, nan }, 1.e+00f },
        /* 137 */ { { -max, zero }, { 6.1179793e-01f, zero }, 1.e+00f },
        /* 138 */ { { -6.1409603e+25f, zero }, { 1.406664e+01f, zero }, 6.25e-02f },
        /* 139 */ { { -1.1082383e+13f, zero }, { -7.0485216e-01f, zero }, 1.e+00f },
        /* 140 */ { { -2.e+00f, zero }, { 2.1850398e+00f, zero }, 2.5e-01f },
        /* 141 */ { { -3.6093321e-13f, zero }, { -3.6093321e-13f, zero }, 2.1990233e+12f },
        /* 142 */ { { -6.5136393e-26f, zero }, { -6.5136393e-26f, zero }, 9.6714066e+24f },
        /* 143 */ { { -min, zero }, { -min, zero }, 4.2535296e+37f },
        /* 144 */ { { zero, zero }, { zero, zero }, 1.e+00f },
        /* 145 */ { { min, zero }, { min, zero }, 4.2535296e+37f },
        /* 146 */ { { 6.5136393e-26f, zero }, { 6.5136393e-26f, zero }, 9.6714066e+24f },
        /* 147 */ { { 3.6093321e-13f, zero }, { 3.6093321e-13f, zero }, 2.1990233e+12f },
        /* 148 */ { { 2.e+00f, zero }, { -2.1850398e+00f, zero }, 2.5e-01f },
        /* 149 */ { { 1.1082383e+13f, zero }, { 7.0485216e-01f, zero }, 1.e+00f },
        /* 150 */ { { 6.1409603e+25f, zero }, { -1.406664e+01f, zero }, 6.25e-02f },
        /* 151 */ { { max, zero }, { -6.1179793e-01f, zero }, 1.e+00f },
        /* 152 */ { { inf, zero }, { nan, nan }, 1.e+00f },
        /* 153 */ { { -inf, min }, { nan, nan }, 1.e+00f },
        /* 154 */ { { -max, min }, { 6.1179793e-01f, 1.6154781e-38f }, 1.e+00f },
        /* 155 */ { { -6.1409603e+25f, min }, { 1.406664e+01f, 2.3377097e-36f }, 6.25e-02f },
        /* 156 */ { { -1.1082383e+13f, min }, { -7.0485216e-01f, 1.7594995e-38f }, 1.e+00f },
        /* 157 */ { { -2.e+00f, min }, { 2.1850398e+00f, 6.7877737e-38f }, 2.5e-01f },
        /* 158 */ { { -3.6093321e-13f, min }, { -3.6093321e-13f, min }, 2.1990233e+12f },
        /* 159 */ { { -6.5136393e-26f, min }, { -6.5136393e-26f, min }, 9.6714066e+24f },
        /* 160 */ { { -min, min }, { -min, min }, 4.2535296e+37f },
        /* 161 */ { { zero, min }, { zero, min }, 4.2535296e+37f },
        /* 162 */ { { min, min }, { min, min }, 4.2535296e+37f },
        /* 163 */ { { 6.5136393e-26f, min }, { 6.5136393e-26f, min }, 9.6714066e+24f },
        /* 164 */ { { 3.6093321e-13f, min }, { 3.6093321e-13f, min }, 2.1990233e+12f },
        /* 165 */ { { 2.e+00f, min }, { -2.1850398e+00f, 6.7877737e-38f }, 2.5e-01f },
        /* 166 */ { { 1.1082383e+13f, min }, { 7.0485216e-01f, 1.7594995e-38f }, 1.e+00f },
        /* 167 */ { { 6.1409603e+25f, min }, { -1.406664e+01f, 2.3377097e-36f }, 6.25e-02f },
        /* 168 */ { { max, min }, { -6.1179793e-01f, 1.6154781e-38f }, 1.e+00f },
        /* 169 */ { { inf, min }, { nan, nan }, 1.e+00f },
        /* 170 */ { { -inf, 6.5136393e-26f }, { nan, nan }, 1.e+00f },
        /* 171 */ { { -max, 6.5136393e-26f }, { 6.1179793e-01f, 8.9516731e-26f }, 1.e+00f },
        /* 172 */ { { -6.1409603e+25f, 6.5136393e-26f }, { 1.406664e+01f, 1.2953697e-23f }, 6.25e-02f },
        /* 173 */ { { -1.1082383e+13f, 6.5136393e-26f }, { -7.0485216e-01f, 9.7497236e-26f }, 1.e+00f },
        /* 174 */ { { -2.e+00f, 6.5136393e-26f }, { 2.1850398e+00f, 3.7612353e-25f }, 2.5e-01f },
        /* 175 */ { { -3.6093321e-13f, 6.5136393e-26f }, { -3.6093321e-13f, 6.5136393e-26f }, 2.1990233e+12f },
        /* 176 */ { { -6.5136393e-26f, 6.5136393e-26f }, { -6.5136393e-26f, 6.5136393e-26f }, 9.6714066e+24f },
        /* 177 */ { { -min, 6.5136393e-26f }, { -min, 6.5136393e-26f }, 9.6714066e+24f },
        /* 178 */ { { zero, 6.5136393e-26f }, { zero, 6.5136393e-26f }, 9.6714066e+24f },
        /* 179 */ { { min, 6.5136393e-26f }, { min, 6.5136393e-26f }, 9.6714066e+24f },
        /* 180 */ { { 6.5136393e-26f, 6.5136393e-26f }, { 6.5136393e-26f, 6.5136393e-26f }, 9.6714066e+24f },
        /* 181 */ { { 3.6093321e-13f, 6.5136393e-26f }, { 3.6093321e-13f, 6.5136393e-26f }, 2.1990233e+12f },
        /* 182 */ { { 2.e+00f, 6.5136393e-26f }, { -2.1850398e+00f, 3.7612353e-25f }, 2.5e-01f },
        /* 183 */ { { 1.1082383e+13f, 6.5136393e-26f }, { 7.0485216e-01f, 9.7497236e-26f }, 1.e+00f },
        /* 184 */ { { 6.1409603e+25f, 6.5136393e-26f }, { -1.406664e+01f, 1.2953697e-23f }, 6.25e-02f },
        /* 185 */ { { max, 6.5136393e-26f }, { -6.1179793e-01f, 8.9516731e-26f }, 1.e+00f },
        /* 186 */ { { inf, 6.5136393e-26f }, { nan, nan }, 1.e+00f },
        /* 187 */ { { -inf, 3.6093321e-13f }, { nan, nan }, 1.e+00f },
        /* 188 */ { { -max, 3.6093321e-13f }, { 6.1179793e-01f, 4.9602932e-13f }, 1.e+00f },
        /* 189 */ { { -6.1409603e+25f, 3.6093321e-13f }, { 1.406664e+01f, 7.1778909e-11f }, 6.25e-02f },
        /* 190 */ { { -1.1082383e+13f, 3.6093321e-13f }, { -7.0485216e-01f, 5.4025084e-13f }, 1.e+00f },
        /* 191 */ { { -2.e+00f, 3.6093321e-13f }, { 2.1850398e+00f, 2.0841725e-12f }, 2.5e-01f },
        /* 192 */ { { -3.6093321e-13f, 3.6093321e-13f }, { -3.6093321e-13f, 3.6093321e-13f }, 1.0995116e+12f },
        /* 193 */ { { -6.5136393e-26f, 3.6093321e-13f }, { -6.5136393e-26f, 3.6093321e-13f }, 2.1990233e+12f },
        /* 194 */ { { -min, 3.6093321e-13f }, { -min, 3.6093321e-13f }, 2.1990233e+12f },
        /* 195 */ { { zero, 3.6093321e-13f }, { zero, 3.6093321e-13f }, 2.1990233e+12f },
        /* 196 */ { { min, 3.6093321e-13f }, { min, 3.6093321e-13f }, 2.1990233e+12f },
        /* 197 */ { { 6.5136393e-26f, 3.6093321e-13f }, { 6.5136393e-26f, 3.6093321e-13f }, 2.1990233e+12f },
        /* 198 */ { { 3.6093321e-13f, 3.6093321e-13f }, { 3.6093321e-13f, 3.6093321e-13f }, 1.0995116e+12f },
        /* 199 */ { { 2.e+00f, 3.6093321e-13f }, { -2.1850398e+00f, 2.0841725e-12f }, 2.5e-01f },
        /* 200 */ { { 1.1082383e+13f, 3.6093321e-13f }, { 7.0485216e-01f, 5.4025084e-13f }, 1.e+00f },
        /* 201 */ { { 6.1409603e+25f, 3.6093321e-13f }, { -1.406664e+01f, 7.1778909e-11f }, 6.25e-02f },
        /* 202 */ { { max, 3.6093321e-13f }, { -6.1179793e-01f, 4.9602932e-13f }, 1.e+00f },
        /* 203 */ { { inf, 3.6093321e-13f }, { nan, nan }, 1.e+00f },
        /* 204 */ { { -inf, 2.e+00f }, { nan, nan }, 1.e+00f },
        /* 205 */ { { -max, 2.e+00f }, { 3.2068815e-02f, 9.8294145e-01f }, 1.e+00f },
        /* 206 */ { { -6.1409603e+25f, 2.e+00f }, { 5.3751757e-03f, 1.0369183e+00f }, 5.e-01f },
        /* 207 */ { { -1.1082383e+13f, 2.e+00f }, { -3.4068439e-02f, 9.8717695e-01f }, 1.e+00f },
        /* 208 */ { { -2.e+00f, 2.e+00f }, { 2.8392954e-02f, 1.0238355e+00f }, 5.e-01f },
        /* 209 */ { { -3.6093321e-13f, 2.e+00f }, { -2.5500228e-14f, 9.6402758e-01f }, 1.e+00f },
        /* 210 */ { { -6.5136393e-26f, 2.e+00f }, { -4.6019399e-27f, 9.6402758e-01f }, 1.e+00f },
        /* 211 */ { { -min, 2.e+00f }, { zero, 9.6402758e-01f }, 1.e+00f },
        /* 212 */ { { zero, 2.e+00f }, { zero, 9.6402758e-01f }, 1.e+00f },
        /* 213 */ { { min, 2.e+00f }, { zero, 9.6402758e-01f }, 1.e+00f },
        /* 214 */ { { 6.5136393e-26f, 2.e+00f }, { 4.6019399e-27f, 9.6402758e-01f }, 1.e+00f },
        /* 215 */ { { 3.6093321e-13f, 2.e+00f }, { 2.5500228e-14f, 9.6402758e-01f }, 1.e+00f },
        /* 216 */ { { 2.e+00f, 2.e+00f }, { -2.8392954e-02f, 1.0238355e+00f }, 5.e-01f },
        /* 217 */ { { 1.1082383e+13f, 2.e+00f }, { 3.4068439e-02f, 9.8717695e-01f }, 1.e+00f },
        /* 218 */ { { 6.1409603e+25f, 2.e+00f }, { -5.3751757e-03f, 1.0369183e+00f }, 5.e-01f },
        /* 219 */ { { max, 2.e+00f }, { -3.2068815e-02f, 9.8294145e-01f }, 1.e+00f },
        /* 220 */ { { inf, 2.e+00f }, { nan, nan }, 1.e+00f },
        /* 221 */ { { -inf, 1.1082383e+13f }, { nan, nan }, 1.e+00f },
        /* 222 */ { { -max, 1.1082383e+13f }, { zero, 1.e+00f }, 5.e-01f },
        /* 223 */ { { -6.1409603e+25f, 1.1082383e+13f }, { zero, 1.e+00f }, 5.e-01f },
        /* 224 */ { { -1.1082383e+13f, 1.1082383e+13f }, { zero, 1.e+00f }, 5.e-01f },
        /* 225 */ { { -2.e+00f, 1.1082383e+13f }, { zero, 1.e+00f }, 5.e-01f },
        /* 226 */ { { -3.6093321e-13f, 1.1082383e+13f }, { zero, 1.e+00f }, 5.e-01f },
        /* 227 */ { { -6.5136393e-26f, 1.1082383e+13f }, { zero, 1.e+00f }, 5.e-01f },
        /* 228 */ { { -min, 1.1082383e+13f }, { zero, 1.e+00f }, 5.e-01f },
        /* 229 */ { { zero, 1.1082383e+13f }, { zero, 1.e+00f }, 5.e-01f },
        /* 230 */ { { min, 1.1082383e+13f }, { zero, 1.e+00f }, 5.e-01f },
        /* 231 */ { { 6.5136393e-26f, 1.1082383e+13f }, { zero, 1.e+00f }, 5.e-01f },
        /* 232 */ { { 3.6093321e-13f, 1.1082383e+13f }, { zero, 1.e+00f }, 5.e-01f },
        /* 233 */ { { 2.e+00f, 1.1082383e+13f }, { zero, 1.e+00f }, 5.e-01f },
        /* 234 */ { { 1.1082383e+13f, 1.1082383e+13f }, { zero, 1.e+00f }, 5.e-01f },
        /* 235 */ { { 6.1409603e+25f, 1.1082383e+13f }, { zero, 1.e+00f }, 5.e-01f },
        /* 236 */ { { max, 1.1082383e+13f }, { zero, 1.e+00f }, 5.e-01f },
        /* 237 */ { { inf, 1.1082383e+13f }, { nan, nan }, 1.e+00f },
        /* 238 */ { { -inf, 6.1409603e+25f }, { nan, nan }, 1.e+00f },
        /* 239 */ { { -max, 6.1409603e+25f }, { zero, 1.e+00f }, 5.e-01f },
        /* 240 */ { { -6.1409603e+25f, 6.1409603e+25f }, { zero, 1.e+00f }, 5.e-01f },
        /* 241 */ { { -1.1082383e+13f, 6.1409603e+25f }, { zero, 1.e+00f }, 5.e-01f },
        /* 242 */ { { -2.e+00f, 6.1409603e+25f }, { zero, 1.e+00f }, 5.e-01f },
        /* 243 */ { { -3.6093321e-13f, 6.1409603e+25f }, { zero, 1.e+00f }, 5.e-01f },
        /* 244 */ { { -6.5136393e-26f, 6.1409603e+25f }, { zero, 1.e+00f }, 5.e-01f },
        /* 245 */ { { -min, 6.1409603e+25f }, { zero, 1.e+00f }, 5.e-01f },
        /* 246 */ { { zero, 6.1409603e+25f }, { zero, 1.e+00f }, 5.e-01f },
        /* 247 */ { { min, 6.1409603e+25f }, { zero, 1.e+00f }, 5.e-01f },
        /* 248 */ { { 6.5136393e-26f, 6.1409603e+25f }, { zero, 1.e+00f }, 5.e-01f },
        /* 249 */ { { 3.6093321e-13f, 6.1409603e+25f }, { zero, 1.e+00f }, 5.e-01f },
        /* 250 */ { { 2.e+00f, 6.1409603e+25f }, { zero, 1.e+00f }, 5.e-01f },
        /* 251 */ { { 1.1082383e+13f, 6.1409603e+25f }, { zero, 1.e+00f }, 5.e-01f },
        /* 252 */ { { 6.1409603e+25f, 6.1409603e+25f }, { zero, 1.e+00f }, 5.e-01f },
        /* 253 */ { { max, 6.1409603e+25f }, { zero, 1.e+00f }, 5.e-01f },
        /* 254 */ { { inf, 6.1409603e+25f }, { nan, nan }, 1.e+00f },
        /* 255 */ { { -inf, max }, { nan, nan }, 1.e+00f },
        /* 256 */ { { -max, max }, { zero, 1.e+00f }, 5.e-01f },
        /* 257 */ { { -6.1409603e+25f, max }, { zero, 1.e+00f }, 5.e-01f },
        /* 258 */ { { -1.1082383e+13f, max }, { zero, 1.e+00f }, 5.e-01f },
        /* 259 */ { { -2.e+00f, max }, { zero, 1.e+00f }, 5.e-01f },
        /* 260 */ { { -3.6093321e-13f, max }, { zero, 1.e+00f }, 5.e-01f },
        /* 261 */ { { -6.5136393e-26f, max }, { zero, 1.e+00f }, 5.e-01f },
        /* 262 */ { { -min, max }, { zero, 1.e+00f }, 5.e-01f },
        /* 263 */ { { zero, max }, { zero, 1.e+00f }, 5.e-01f },
        /* 264 */ { { min, max }, { zero, 1.e+00f }, 5.e-01f },
        /* 265 */ { { 6.5136393e-26f, max }, { zero, 1.e+00f }, 5.e-01f },
        /* 266 */ { { 3.6093321e-13f, max }, { zero, 1.e+00f }, 5.e-01f },
        /* 267 */ { { 2.e+00f, max }, { zero, 1.e+00f }, 5.e-01f },
        /* 268 */ { { 1.1082383e+13f, max }, { zero, 1.e+00f }, 5.e-01f },
        /* 269 */ { { 6.1409603e+25f, max }, { zero, 1.e+00f }, 5.e-01f },
        /* 270 */ { { max, max }, { zero, 1.e+00f }, 5.e-01f },
        /* 271 */ { { inf, max }, { nan, nan }, 1.e+00f },
        /* 272 */ { { -inf, inf }, { zero, 1.e+00f }, 5.e-01f },
        /* 273 */ { { -max, inf }, { zero, 1.e+00f }, 5.e-01f },
        /* 274 */ { { -6.1409603e+25f, inf }, { zero, 1.e+00f }, 5.e-01f },
        /* 275 */ { { -1.1082383e+13f, inf }, { zero, 1.e+00f }, 5.e-01f },
        /* 276 */ { { -2.e+00f, inf }, { zero, 1.e+00f }, 5.e-01f },
        /* 277 */ { { -3.6093321e-13f, inf }, { zero, 1.e+00f }, 5.e-01f },
        /* 278 */ { { -6.5136393e-26f, inf }, { zero, 1.e+00f }, 5.e-01f },
        /* 279 */ { { -min, inf }, { zero, 1.e+00f }, 5.e-01f },
        /* 280 */ { { zero, inf }, { zero, 1.e+00f }, 5.e-01f },
        /* 281 */ { { min, inf }, { zero, 1.e+00f }, 5.e-01f },
        /* 282 */ { { 6.5136393e-26f, inf }, { zero, 1.e+00f }, 5.e-01f },
        /* 283 */ { { 3.6093321e-13f, inf }, { zero, 1.e+00f }, 5.e-01f },
        /* 284 */ { { 2.e+00f, inf }, { zero, 1.e+00f }, 5.e-01f },
        /* 285 */ { { 1.1082383e+13f, inf }, { zero, 1.e+00f }, 5.e-01f },
        /* 286 */ { { 6.1409603e+25f, inf }, { zero, 1.e+00f }, 5.e-01f },
        /* 287 */ { { max, inf }, { zero, 1.e+00f }, 5.e-01f },
        /* 288 */ { { inf, inf }, { zero, 1.e+00f }, 5.e-01f }
          // clang-format on
      };
      return table;
    } else if constexpr (std::is_same_v<T, double>) {
      const T nan = std::nan("");
      const T zero = 0.0;
      const T inf = std::numeric_limits<T>::infinity();
#ifdef __aarch64__
      const T min = std::nextafter(std::numeric_limits<T>::min(), T(1));
#else
      const T min = std::numeric_limits<T>::min();
#endif
      const T max = std::numeric_limits<T>::max();
      const TableType table{
          // clang-format off
          // Ignore max 80 character line width style requirement for
          // (i) the readability
          // (ii) the consistency with the local conventions
        /* 0 */ { { -inf, -inf }, { zero, -1.e+00 }, 5.e-01 },
        /* 1 */ { { -max, -inf }, { zero, -1.e+00 }, 5.e-01 },
        /* 2 */ { { -4.0131652080900752e+205, -inf }, { zero, -1.e+00 }, 5.e-01 },
        /* 3 */ { { -8.9589789687104559e+102, -inf }, { zero, -1.e+00 }, 5.e-01 },
        /* 4 */ { { -1.9999999999998694e+00, -inf }, { zero, -1.e+00 }, 5.e-01 },
        /* 5 */ { { -4.4647944971961829e-103, -inf }, { zero, -1.e+00 }, 5.e-01 },
        /* 6 */ { { -9.9671949510973086e-206, -inf }, { zero, -1.e+00 }, 5.e-01 },
        /* 7 */ { { -min, -inf }, { zero, -1.e+00 }, 5.e-01 },
        /* 8 */ { { zero, -inf }, { zero, -1.e+00 }, 5.e-01 },
        /* 9 */ { { min, -inf }, { zero, -1.e+00 }, 5.e-01 },
        /* 10 */ { { 9.9671949510973086e-206, -inf }, { zero, -1.e+00 }, 5.e-01 },
        /* 11 */ { { 4.4647944971961829e-103, -inf }, { zero, -1.e+00 }, 5.e-01 },
        /* 12 */ { { 1.9999999999998694e+00, -inf }, { zero, -1.e+00 }, 5.e-01 },
        /* 13 */ { { 8.9589789687104559e+102, -inf }, { zero, -1.e+00 }, 5.e-01 },
        /* 14 */ { { 4.0131652080900752e+205, -inf }, { zero, -1.e+00 }, 5.e-01 },
        /* 15 */ { { max, -inf }, { zero, -1.e+00 }, 5.e-01 },
        /* 16 */ { { inf, -inf }, { zero, -1.e+00 }, 5.e-01 },
        /* 17 */ { { -inf, -max }, { nan, nan }, 1.e+00 },
        /* 18 */ { { -max, -max }, { zero, -1.e+00 }, 5.e-01 },
        /* 19 */ { { -4.0131652080900752e+205, -max }, { zero, -1.e+00 }, 5.e-01 },
        /* 20 */ { { -8.9589789687104559e+102, -max }, { zero, -1.e+00 }, 5.e-01 },
        /* 21 */ { { -1.9999999999998694e+00, -max }, { zero, -1.e+00 }, 5.e-01 },
        /* 22 */ { { -4.4647944971961829e-103, -max }, { zero, -1.e+00 }, 5.e-01 },
        /* 23 */ { { -9.9671949510973086e-206, -max }, { zero, -1.e+00 }, 5.e-01 },
        /* 24 */ { { -min, -max }, { zero, -1.e+00 }, 5.e-01 },
        /* 25 */ { { zero, -max }, { zero, -1.e+00 }, 5.e-01 },
        /* 26 */ { { min, -max }, { zero, -1.e+00 }, 5.e-01 },
        /* 27 */ { { 9.9671949510973086e-206, -max }, { zero, -1.e+00 }, 5.e-01 },
        /* 28 */ { { 4.4647944971961829e-103, -max }, { zero, -1.e+00 }, 5.e-01 },
        /* 29 */ { { 1.9999999999998694e+00, -max }, { zero, -1.e+00 }, 5.e-01 },
        /* 30 */ { { 8.9589789687104559e+102, -max }, { zero, -1.e+00 }, 5.e-01 },
        /* 31 */ { { 4.0131652080900752e+205, -max }, { zero, -1.e+00 }, 5.e-01 },
        /* 32 */ { { max, -max }, { zero, -1.e+00 }, 5.e-01 },
        /* 33 */ { { inf, -max }, { nan, nan }, 1.e+00 },
        /* 34 */ { { -inf, -4.0131652080900752e+205 }, { nan, nan }, 1.e+00 },
        /* 35 */ { { -max, -4.0131652080900752e+205 }, { zero, -1.e+00 }, 5.e-01 },
        /* 36 */ { { -4.0131652080900752e+205, -4.0131652080900752e+205 }, { zero, -1.e+00 }, 5.e-01 },
        /* 37 */ { { -8.9589789687104559e+102, -4.0131652080900752e+205 }, { zero, -1.e+00 }, 5.e-01 },
        /* 38 */ { { -1.9999999999998694e+00, -4.0131652080900752e+205 }, { zero, -1.e+00 }, 5.e-01 },
        /* 39 */ { { -4.4647944971961829e-103, -4.0131652080900752e+205 }, { zero, -1.e+00 }, 5.e-01 },
        /* 40 */ { { -9.9671949510973086e-206, -4.0131652080900752e+205 }, { zero, -1.e+00 }, 5.e-01 },
        /* 41 */ { { -min, -4.0131652080900752e+205 }, { zero, -1.e+00 }, 5.e-01 },
        /* 42 */ { { zero, -4.0131652080900752e+205 }, { zero, -1.e+00 }, 5.e-01 },
        /* 43 */ { { min, -4.0131652080900752e+205 }, { zero, -1.e+00 }, 5.e-01 },
        /* 44 */ { { 9.9671949510973086e-206, -4.0131652080900752e+205 }, { zero, -1.e+00 }, 5.e-01 },
        /* 45 */ { { 4.4647944971961829e-103, -4.0131652080900752e+205 }, { zero, -1.e+00 }, 5.e-01 },
        /* 46 */ { { 1.9999999999998694e+00, -4.0131652080900752e+205 }, { zero, -1.e+00 }, 5.e-01 },
        /* 47 */ { { 8.9589789687104559e+102, -4.0131652080900752e+205 }, { zero, -1.e+00 }, 5.e-01 },
        /* 48 */ { { 4.0131652080900752e+205, -4.0131652080900752e+205 }, { zero, -1.e+00 }, 5.e-01 },
        /* 49 */ { { max, -4.0131652080900752e+205 }, { zero, -1.e+00 }, 5.e-01 },
        /* 50 */ { { inf, -4.0131652080900752e+205 }, { nan, nan }, 1.e+00 },
        /* 51 */ { { -inf, -8.9589789687104559e+102 }, { nan, nan }, 1.e+00 },
        /* 52 */ { { -max, -8.9589789687104559e+102 }, { zero, -1.e+00 }, 5.e-01 },
        /* 53 */ { { -4.0131652080900752e+205, -8.9589789687104559e+102 }, { zero, -1.e+00 }, 5.e-01 },
        /* 54 */ { { -8.9589789687104559e+102, -8.9589789687104559e+102 }, { zero, -1.e+00 }, 5.e-01 },
        /* 55 */ { { -1.9999999999998694e+00, -8.9589789687104559e+102 }, { zero, -1.e+00 }, 5.e-01 },
        /* 56 */ { { -4.4647944971961829e-103, -8.9589789687104559e+102 }, { zero, -1.e+00 }, 5.e-01 },
        /* 57 */ { { -9.9671949510973086e-206, -8.9589789687104559e+102 }, { zero, -1.e+00 }, 5.e-01 },
        /* 58 */ { { -min, -8.9589789687104559e+102 }, { zero, -1.e+00 }, 5.e-01 },
        /* 59 */ { { zero, -8.9589789687104559e+102 }, { zero, -1.e+00 }, 5.e-01 },
        /* 60 */ { { min, -8.9589789687104559e+102 }, { zero, -1.e+00 }, 5.e-01 },
        /* 61 */ { { 9.9671949510973086e-206, -8.9589789687104559e+102 }, { zero, -1.e+00 }, 5.e-01 },
        /* 62 */ { { 4.4647944971961829e-103, -8.9589789687104559e+102 }, { zero, -1.e+00 }, 5.e-01 },
        /* 63 */ { { 1.9999999999998694e+00, -8.9589789687104559e+102 }, { zero, -1.e+00 }, 5.e-01 },
        /* 64 */ { { 8.9589789687104559e+102, -8.9589789687104559e+102 }, { zero, -1.e+00 }, 5.e-01 },
        /* 65 */ { { 4.0131652080900752e+205, -8.9589789687104559e+102 }, { zero, -1.e+00 }, 5.e-01 },
        /* 66 */ { { max, -8.9589789687104559e+102 }, { zero, -1.e+00 }, 5.e-01 },
        /* 67 */ { { inf, -8.9589789687104559e+102 }, { nan, nan }, 1.e+00 },
        /* 68 */ { { -inf, -1.9999999999998694e+00 }, { nan, nan }, 1.e+00 },
        /* 69 */ { { -max, -1.9999999999998694e+00 }, { 3.5056249287033966e-04, -9.6402925699855813e-01 }, 1.e+00 },
        /* 70 */ { { -4.0131652080900752e+205, -1.9999999999998694e+00 }, { 2.7597961351536058e-02, -1.02477724455786e+00 }, 5.e-01 },
        /* 71 */ { { -8.9589789687104559e+102, -1.9999999999998694e+00 }, { 3.6482534190112638e-02, -1.0041027601252124e+00 }, 5.e-01 },
        /* 72 */ { { -1.9999999999998694e+00, -1.9999999999998694e+00 }, { 2.8392952868233685e-02, -1.0238355945704865e+00 }, 5.e-01 },
        /* 73 */ { { -4.4647944971961829e-103, -1.9999999999998694e+00 }, { -3.1544141402685944e-104, -9.6402758007580769e-01 }, 1.e+00 },
        /* 74 */ { { -9.9671949510973086e-206, -1.9999999999998694e+00 }, { -7.0419054476749839e-207, -9.6402758007580769e-01 }, 1.e+00 },
        /* 75 */ { { -min, -1.9999999999998694e+00 }, { zero, -9.6402758007580769e-01 }, 1.e+00 },
        /* 76 */ { { zero, -1.9999999999998694e+00 }, { zero, -9.6402758007580769e-01 }, 1.e+00 },
        /* 77 */ { { min, -1.9999999999998694e+00 }, { zero, -9.6402758007580769e-01 }, 1.e+00 },
        /* 78 */ { { 9.9671949510973086e-206, -1.9999999999998694e+00 }, { 7.0419054476749839e-207, -9.6402758007580769e-01 }, 1.e+00 },
        /* 79 */ { { 4.4647944971961829e-103, -1.9999999999998694e+00 }, { 3.1544141402685944e-104, -9.6402758007580769e-01 }, 1.e+00 },
        /* 80 */ { { 1.9999999999998694e+00, -1.9999999999998694e+00 }, { -2.8392952868233685e-02, -1.0238355945704865e+00 }, 5.e-01 },
        /* 81 */ { { 8.9589789687104559e+102, -1.9999999999998694e+00 }, { -3.6482534190112638e-02, -1.0041027601252124e+00 }, 5.e-01 },
        /* 82 */ { { 4.0131652080900752e+205, -1.9999999999998694e+00 }, { -2.7597961351536058e-02, -1.02477724455786e+00 }, 5.e-01 },
        /* 83 */ { { max, -1.9999999999998694e+00 }, { -3.5056249287033966e-04, -9.6402925699855813e-01 }, 1.e+00 },
        /* 84 */ { { inf, -1.9999999999998694e+00 }, { nan, nan }, 1.e+00 },
        /* 85 */ { { -inf, -4.4647944971961829e-103 }, { nan, nan }, 1.e+00 },
        /* 86 */ { { -max, -4.4647944971961829e-103 }, { 4.9620158744448951e-03, -4.4649044275872426e-103 }, 1.28e+02 },
        /* 87 */ { { -4.0131652080900752e+205, -4.4647944971961829e-103 }, { 2.2833759509915996e+00, -2.7743365645875101e-102 }, 2.5e-01 },
        /* 88 */ { { -8.9589789687104559e+102, -4.4647944971961829e-103 }, { 1.1394650926503123e+00, -1.0261797490073182e-102 }, 5.e-01 },
        /* 89 */ { { -1.9999999999998694e+00, -4.4647944971961829e-103 }, { 2.185039863262273e+00, -2.5781505790835082e-102 }, 2.5e-01 },
        /* 90 */ { { -4.4647944971961829e-103, -4.4647944971961829e-103 }, { -4.4647944971961829e-103, -4.4647944971961829e-103 }, 1.1198723710889021e+102 },
        /* 91 */ { { -9.9671949510973086e-206, -4.4647944971961829e-103 }, { -9.9671949510973086e-206, -4.4647944971961829e-103 }, 2.2397447421778042e+102 },
        /* 92 */ { { -min, -4.4647944971961829e-103 }, { -min, -4.4647944971961829e-103 }, 2.2397447421778042e+102 },
        /* 93 */ { { zero, -4.4647944971961829e-103 }, { zero, -4.4647944971961829e-103 }, 2.2397447421778042e+102 },
        /* 94 */ { { min, -4.4647944971961829e-103 }, { min, -4.4647944971961829e-103 }, 2.2397447421778042e+102 },
        /* 95 */ { { 9.9671949510973086e-206, -4.4647944971961829e-103 }, { 9.9671949510973086e-206, -4.4647944971961829e-103 }, 2.2397447421778042e+102 },
        /* 96 */ { { 4.4647944971961829e-103, -4.4647944971961829e-103 }, { 4.4647944971961829e-103, -4.4647944971961829e-103 }, 1.1198723710889021e+102 },
        /* 97 */ { { 1.9999999999998694e+00, -4.4647944971961829e-103 }, { -2.185039863262273e+00, -2.5781505790835082e-102 }, 2.5e-01 },
        /* 98 */ { { 8.9589789687104559e+102, -4.4647944971961829e-103 }, { -1.1394650926503123e+00, -1.0261797490073182e-102 }, 5.e-01 },
        /* 99 */ { { 4.0131652080900752e+205, -4.4647944971961829e-103 }, { -2.2833759509915996e+00, -2.7743365645875101e-102 }, 2.5e-01 },
        /* 100 */ { { max, -4.4647944971961829e-103 }, { -4.9620158744448951e-03, -4.4649044275872426e-103 }, 1.28e+02 },
        /* 101 */ { { inf, -4.4647944971961829e-103 }, { nan, nan }, 1.e+00 },
        /* 102 */ { { -inf, -9.9671949510973086e-206 }, { nan, nan }, 1.e+00 },
        /* 103 */ { { -max, -9.9671949510973086e-206 }, { 4.9620158744448951e-03, -9.9674403593998487e-206 }, 1.28e+02 },
        /* 104 */ { { -4.0131652080900752e+205, -9.9671949510973086e-206 }, { 2.2833759509915996e+00, -6.1934213134706426e-205 }, 2.5e-01 },
        /* 105 */ { { -8.9589789687104559e+102, -9.9671949510973086e-206 }, { 1.1394650926503123e+00, -2.2908408482511669e-205 }, 5.e-01 },
        /* 106 */ { { -1.9999999999998694e+00, -9.9671949510973086e-206 }, { 2.185039863262273e+00, -5.7554562592179759e-205 }, 2.5e-01 },
        /* 107 */ { { -4.4647944971961829e-103, -9.9671949510973086e-206 }, { -4.4647944971961829e-103, -9.9671949510973086e-206 }, 2.2397447421778042e+102 },
        /* 108 */ { { -9.9671949510973086e-206, -9.9671949510973086e-206 }, { -9.9671949510973086e-206, -9.9671949510973086e-206 }, 5.0164565101131187e+204 },
        /* 109 */ { { -min, -9.9671949510973086e-206 }, { -min, -9.9671949510973086e-206 }, 1.0032913020226237e+205 },
        /* 110 */ { { zero, -9.9671949510973086e-206 }, { zero, -9.9671949510973086e-206 }, 1.0032913020226237e+205 },
        /* 111 */ { { min, -9.9671949510973086e-206 }, { min, -9.9671949510973086e-206 }, 1.0032913020226237e+205 },
        /* 112 */ { { 9.9671949510973086e-206, -9.9671949510973086e-206 }, { 9.9671949510973086e-206, -9.9671949510973086e-206 }, 5.0164565101131187e+204 },
        /* 113 */ { { 4.4647944971961829e-103, -9.9671949510973086e-206 }, { 4.4647944971961829e-103, -9.9671949510973086e-206 }, 2.2397447421778042e+102 },
        /* 114 */ { { 1.9999999999998694e+00, -9.9671949510973086e-206 }, { -2.185039863262273e+00, -5.7554562592179759e-205 }, 2.5e-01 },
        /* 115 */ { { 8.9589789687104559e+102, -9.9671949510973086e-206 }, { -1.1394650926503123e+00, -2.2908408482511669e-205 }, 5.e-01 },
        /* 116 */ { { 4.0131652080900752e+205, -9.9671949510973086e-206 }, { -2.2833759509915996e+00, -6.1934213134706426e-205 }, 2.5e-01 },
        /* 117 */ { { max, -9.9671949510973086e-206 }, { -4.9620158744448951e-03, -9.9674403593998487e-206 }, 1.28e+02 },
        /* 118 */ { { inf, -9.9671949510973086e-206 }, { nan, nan }, 1.e+00 },
        /* 119 */ { { -inf, -min }, { nan, nan }, 1.e+00 },
        /* 120 */ { { -max, -min }, { 4.9620158744448951e-03, -2.2251286433891388e-308 }, 1.28e+02 },
        /* 121 */ { { -4.0131652080900752e+205, -min }, { 2.2833759509915996e+00, -1.3826176699601631e-307 }, 2.5e-01 },
        /* 122 */ { { -8.9589789687104559e+102, -min }, { 1.1394650926503123e+00, -5.1140668066123887e-308 }, 5.e-01 },
        /* 123 */ { { -1.9999999999998694e+00, -min }, { 2.185039863262273e+00, -1.2848464717505794e-307 }, 2.5e-01 },
        /* 124 */ { { -4.4647944971961829e-103, -min }, { -4.4647944971961829e-103, -min }, 2.2397447421778042e+102 },
        /* 125 */ { { -9.9671949510973086e-206, -min }, { -9.9671949510973086e-206, -min }, 1.0032913020226237e+205 },
        /* 126 */ { { -min, -min }, { -min, -min }, 2.2471164185778949e+307 },
        /* 127 */ { { zero, -min }, { zero, -min }, 2.2471164185778949e+307 },
        /* 128 */ { { min, -min }, { min, -min }, 2.2471164185778949e+307 },
        /* 129 */ { { 9.9671949510973086e-206, -min }, { 9.9671949510973086e-206, -min }, 1.0032913020226237e+205 },
        /* 130 */ { { 4.4647944971961829e-103, -min }, { 4.4647944971961829e-103, -min }, 2.2397447421778042e+102 },
        /* 131 */ { { 1.9999999999998694e+00, -min }, { -2.185039863262273e+00, -1.2848464717505794e-307 }, 2.5e-01 },
        /* 132 */ { { 8.9589789687104559e+102, -min }, { -1.1394650926503123e+00, -5.1140668066123887e-308 }, 5.e-01 },
        /* 133 */ { { 4.0131652080900752e+205, -min }, { -2.2833759509915996e+00, -1.3826176699601631e-307 }, 2.5e-01 },
        /* 134 */ { { max, -min }, { -4.9620158744448951e-03, -2.2251286433891388e-308 }, 1.28e+02 },
        /* 135 */ { { inf, -min }, { nan, nan }, 1.e+00 },
        /* 136 */ { { -inf, zero }, { nan, nan }, 1.e+00 },
        /* 137 */ { { -max, zero }, { 4.9620158744448951e-03, zero }, 1.28e+02 },
        /* 138 */ { { -4.0131652080900752e+205, zero }, { 2.2833759509915996e+00, zero }, 2.5e-01 },
        /* 139 */ { { -8.9589789687104559e+102, zero }, { 1.1394650926503123e+00, zero }, 5.e-01 },
        /* 140 */ { { -1.9999999999998694e+00, zero }, { 2.185039863262273e+00, zero }, 2.5e-01 },
        /* 141 */ { { -4.4647944971961829e-103, zero }, { -4.4647944971961829e-103, zero }, 2.2397447421778042e+102 },
        /* 142 */ { { -9.9671949510973086e-206, zero }, { -9.9671949510973086e-206, zero }, 1.0032913020226237e+205 },
        /* 143 */ { { -min, zero }, { -min, zero }, 2.2471164185778949e+307 },
        /* 144 */ { { zero, zero }, { zero, zero }, 1.e+00 },
        /* 145 */ { { min, zero }, { min, zero }, 2.2471164185778949e+307 },
        /* 146 */ { { 9.9671949510973086e-206, zero }, { 9.9671949510973086e-206, zero }, 1.0032913020226237e+205 },
        /* 147 */ { { 4.4647944971961829e-103, zero }, { 4.4647944971961829e-103, zero }, 2.2397447421778042e+102 },
        /* 148 */ { { 1.9999999999998694e+00, zero }, { -2.185039863262273e+00, zero }, 2.5e-01 },
        /* 149 */ { { 8.9589789687104559e+102, zero }, { -1.1394650926503123e+00, zero }, 5.e-01 },
        /* 150 */ { { 4.0131652080900752e+205, zero }, { -2.2833759509915996e+00, zero }, 2.5e-01 },
        /* 151 */ { { max, zero }, { -4.9620158744448951e-03, zero }, 1.28e+02 },
        /* 152 */ { { inf, zero }, { nan, nan }, 1.e+00 },
        /* 153 */ { { -inf, min }, { nan, nan }, 1.e+00 },
        /* 154 */ { { -max, min }, { 4.9620158744448951e-03, 2.2251286433891388e-308 }, 1.28e+02 },
        /* 155 */ { { -4.0131652080900752e+205, min }, { 2.2833759509915996e+00, 1.3826176699601631e-307 }, 2.5e-01 },
        /* 156 */ { { -8.9589789687104559e+102, min }, { 1.1394650926503123e+00, 5.1140668066123887e-308 }, 5.e-01 },
        /* 157 */ { { -1.9999999999998694e+00, min }, { 2.185039863262273e+00, 1.2848464717505794e-307 }, 2.5e-01 },
        /* 158 */ { { -4.4647944971961829e-103, min }, { -4.4647944971961829e-103, min }, 2.2397447421778042e+102 },
        /* 159 */ { { -9.9671949510973086e-206, min }, { -9.9671949510973086e-206, min }, 1.0032913020226237e+205 },
        /* 160 */ { { -min, min }, { -min, min }, 2.2471164185778949e+307 },
        /* 161 */ { { zero, min }, { zero, min }, 2.2471164185778949e+307 },
        /* 162 */ { { min, min }, { min, min }, 2.2471164185778949e+307 },
        /* 163 */ { { 9.9671949510973086e-206, min }, { 9.9671949510973086e-206, min }, 1.0032913020226237e+205 },
        /* 164 */ { { 4.4647944971961829e-103, min }, { 4.4647944971961829e-103, min }, 2.2397447421778042e+102 },
        /* 165 */ { { 1.9999999999998694e+00, min }, { -2.185039863262273e+00, 1.2848464717505794e-307 }, 2.5e-01 },
        /* 166 */ { { 8.9589789687104559e+102, min }, { -1.1394650926503123e+00, 5.1140668066123887e-308 }, 5.e-01 },
        /* 167 */ { { 4.0131652080900752e+205, min }, { -2.2833759509915996e+00, 1.3826176699601631e-307 }, 2.5e-01 },
        /* 168 */ { { max, min }, { -4.9620158744448951e-03, 2.2251286433891388e-308 }, 1.28e+02 },
        /* 169 */ { { inf, min }, { nan, nan }, 1.e+00 },
        /* 170 */ { { -inf, 9.9671949510973086e-206 }, { nan, nan }, 1.e+00 },
        /* 171 */ { { -max, 9.9671949510973086e-206 }, { 4.9620158744448951e-03, 9.9674403593998487e-206 }, 1.28e+02 },
        /* 172 */ { { -4.0131652080900752e+205, 9.9671949510973086e-206 }, { 2.2833759509915996e+00, 6.1934213134706426e-205 }, 2.5e-01 },
        /* 173 */ { { -8.9589789687104559e+102, 9.9671949510973086e-206 }, { 1.1394650926503123e+00, 2.2908408482511669e-205 }, 5.e-01 },
        /* 174 */ { { -1.9999999999998694e+00, 9.9671949510973086e-206 }, { 2.185039863262273e+00, 5.7554562592179759e-205 }, 2.5e-01 },
        /* 175 */ { { -4.4647944971961829e-103, 9.9671949510973086e-206 }, { -4.4647944971961829e-103, 9.9671949510973086e-206 }, 2.2397447421778042e+102 },
        /* 176 */ { { -9.9671949510973086e-206, 9.9671949510973086e-206 }, { -9.9671949510973086e-206, 9.9671949510973086e-206 }, 5.0164565101131187e+204 },
        /* 177 */ { { -min, 9.9671949510973086e-206 }, { -min, 9.9671949510973086e-206 }, 1.0032913020226237e+205 },
        /* 178 */ { { zero, 9.9671949510973086e-206 }, { zero, 9.9671949510973086e-206 }, 1.0032913020226237e+205 },
        /* 179 */ { { min, 9.9671949510973086e-206 }, { min, 9.9671949510973086e-206 }, 1.0032913020226237e+205 },
        /* 180 */ { { 9.9671949510973086e-206, 9.9671949510973086e-206 }, { 9.9671949510973086e-206, 9.9671949510973086e-206 }, 5.0164565101131187e+204 },
        /* 181 */ { { 4.4647944971961829e-103, 9.9671949510973086e-206 }, { 4.4647944971961829e-103, 9.9671949510973086e-206 }, 2.2397447421778042e+102 },
        /* 182 */ { { 1.9999999999998694e+00, 9.9671949510973086e-206 }, { -2.185039863262273e+00, 5.7554562592179759e-205 }, 2.5e-01 },
        /* 183 */ { { 8.9589789687104559e+102, 9.9671949510973086e-206 }, { -1.1394650926503123e+00, 2.2908408482511669e-205 }, 5.e-01 },
        /* 184 */ { { 4.0131652080900752e+205, 9.9671949510973086e-206 }, { -2.2833759509915996e+00, 6.1934213134706426e-205 }, 2.5e-01 },
        /* 185 */ { { max, 9.9671949510973086e-206 }, { -4.9620158744448951e-03, 9.9674403593998487e-206 }, 1.28e+02 },
        /* 186 */ { { inf, 9.9671949510973086e-206 }, { nan, nan }, 1.e+00 },
        /* 187 */ { { -inf, 4.4647944971961829e-103 }, { nan, nan }, 1.e+00 },
        /* 188 */ { { -max, 4.4647944971961829e-103 }, { 4.9620158744448951e-03, 4.4649044275872426e-103 }, 1.28e+02 },
        /* 189 */ { { -4.0131652080900752e+205, 4.4647944971961829e-103 }, { 2.2833759509915996e+00, 2.7743365645875101e-102 }, 2.5e-01 },
        /* 190 */ { { -8.9589789687104559e+102, 4.4647944971961829e-103 }, { 1.1394650926503123e+00, 1.0261797490073182e-102 }, 5.e-01 },
        /* 191 */ { { -1.9999999999998694e+00, 4.4647944971961829e-103 }, { 2.185039863262273e+00, 2.5781505790835082e-102 }, 2.5e-01 },
        /* 192 */ { { -4.4647944971961829e-103, 4.4647944971961829e-103 }, { -4.4647944971961829e-103, 4.4647944971961829e-103 }, 1.1198723710889021e+102 },
        /* 193 */ { { -9.9671949510973086e-206, 4.4647944971961829e-103 }, { -9.9671949510973086e-206, 4.4647944971961829e-103 }, 2.2397447421778042e+102 },
        /* 194 */ { { -min, 4.4647944971961829e-103 }, { -min, 4.4647944971961829e-103 }, 2.2397447421778042e+102 },
        /* 195 */ { { zero, 4.4647944971961829e-103 }, { zero, 4.4647944971961829e-103 }, 2.2397447421778042e+102 },
        /* 196 */ { { min, 4.4647944971961829e-103 }, { min, 4.4647944971961829e-103 }, 2.2397447421778042e+102 },
        /* 197 */ { { 9.9671949510973086e-206, 4.4647944971961829e-103 }, { 9.9671949510973086e-206, 4.4647944971961829e-103 }, 2.2397447421778042e+102 },
        /* 198 */ { { 4.4647944971961829e-103, 4.4647944971961829e-103 }, { 4.4647944971961829e-103, 4.4647944971961829e-103 }, 1.1198723710889021e+102 },
        /* 199 */ { { 1.9999999999998694e+00, 4.4647944971961829e-103 }, { -2.185039863262273e+00, 2.5781505790835082e-102 }, 2.5e-01 },
        /* 200 */ { { 8.9589789687104559e+102, 4.4647944971961829e-103 }, { -1.1394650926503123e+00, 1.0261797490073182e-102 }, 5.e-01 },
        /* 201 */ { { 4.0131652080900752e+205, 4.4647944971961829e-103 }, { -2.2833759509915996e+00, 2.7743365645875101e-102 }, 2.5e-01 },
        /* 202 */ { { max, 4.4647944971961829e-103 }, { -4.9620158744448951e-03, 4.4649044275872426e-103 }, 1.28e+02 },
        /* 203 */ { { inf, 4.4647944971961829e-103 }, { nan, nan }, 1.e+00 },
        /* 204 */ { { -inf, 1.9999999999998694e+00 }, { nan, nan }, 1.e+00 },
        /* 205 */ { { -max, 1.9999999999998694e+00 }, { 3.5056249287033966e-04, 9.6402925699855813e-01 }, 1.e+00 },
        /* 206 */ { { -4.0131652080900752e+205, 1.9999999999998694e+00 }, { 2.7597961351536058e-02, 1.02477724455786e+00 }, 5.e-01 },
        /* 207 */ { { -8.9589789687104559e+102, 1.9999999999998694e+00 }, { 3.6482534190112638e-02, 1.0041027601252124e+00 }, 5.e-01 },
        /* 208 */ { { -1.9999999999998694e+00, 1.9999999999998694e+00 }, { 2.8392952868233685e-02, 1.0238355945704865e+00 }, 5.e-01 },
        /* 209 */ { { -4.4647944971961829e-103, 1.9999999999998694e+00 }, { -3.1544141402685944e-104, 9.6402758007580769e-01 }, 1.e+00 },
        /* 210 */ { { -9.9671949510973086e-206, 1.9999999999998694e+00 }, { -7.0419054476749839e-207, 9.6402758007580769e-01 }, 1.e+00 },
        /* 211 */ { { -min, 1.9999999999998694e+00 }, { zero, 9.6402758007580769e-01 }, 1.e+00 },
        /* 212 */ { { zero, 1.9999999999998694e+00 }, { zero, 9.6402758007580769e-01 }, 1.e+00 },
        /* 213 */ { { min, 1.9999999999998694e+00 }, { zero, 9.6402758007580769e-01 }, 1.e+00 },
        /* 214 */ { { 9.9671949510973086e-206, 1.9999999999998694e+00 }, { 7.0419054476749839e-207, 9.6402758007580769e-01 }, 1.e+00 },
        /* 215 */ { { 4.4647944971961829e-103, 1.9999999999998694e+00 }, { 3.1544141402685944e-104, 9.6402758007580769e-01 }, 1.e+00 },
        /* 216 */ { { 1.9999999999998694e+00, 1.9999999999998694e+00 }, { -2.8392952868233685e-02, 1.0238355945704865e+00 }, 5.e-01 },
        /* 217 */ { { 8.9589789687104559e+102, 1.9999999999998694e+00 }, { -3.6482534190112638e-02, 1.0041027601252124e+00 }, 5.e-01 },
        /* 218 */ { { 4.0131652080900752e+205, 1.9999999999998694e+00 }, { -2.7597961351536058e-02, 1.02477724455786e+00 }, 5.e-01 },
        /* 219 */ { { max, 1.9999999999998694e+00 }, { -3.5056249287033966e-04, 9.6402925699855813e-01 }, 1.e+00 },
        /* 220 */ { { inf, 1.9999999999998694e+00 }, { nan, nan }, 1.e+00 },
        /* 221 */ { { -inf, 8.9589789687104559e+102 }, { nan, nan }, 1.e+00 },
        /* 222 */ { { -max, 8.9589789687104559e+102 }, { zero, 1.e+00 }, 5.e-01 },
        /* 223 */ { { -4.0131652080900752e+205, 8.9589789687104559e+102 }, { zero, 1.e+00 }, 5.e-01 },
        /* 224 */ { { -8.9589789687104559e+102, 8.9589789687104559e+102 }, { zero, 1.e+00 }, 5.e-01 },
        /* 225 */ { { -1.9999999999998694e+00, 8.9589789687104559e+102 }, { zero, 1.e+00 }, 5.e-01 },
        /* 226 */ { { -4.4647944971961829e-103, 8.9589789687104559e+102 }, { zero, 1.e+00 }, 5.e-01 },
        /* 227 */ { { -9.9671949510973086e-206, 8.9589789687104559e+102 }, { zero, 1.e+00 }, 5.e-01 },
        /* 228 */ { { -min, 8.9589789687104559e+102 }, { zero, 1.e+00 }, 5.e-01 },
        /* 229 */ { { zero, 8.9589789687104559e+102 }, { zero, 1.e+00 }, 5.e-01 },
        /* 230 */ { { min, 8.9589789687104559e+102 }, { zero, 1.e+00 }, 5.e-01 },
        /* 231 */ { { 9.9671949510973086e-206, 8.9589789687104559e+102 }, { zero, 1.e+00 }, 5.e-01 },
        /* 232 */ { { 4.4647944971961829e-103, 8.9589789687104559e+102 }, { zero, 1.e+00 }, 5.e-01 },
        /* 233 */ { { 1.9999999999998694e+00, 8.9589789687104559e+102 }, { zero, 1.e+00 }, 5.e-01 },
        /* 234 */ { { 8.9589789687104559e+102, 8.9589789687104559e+102 }, { zero, 1.e+00 }, 5.e-01 },
        /* 235 */ { { 4.0131652080900752e+205, 8.9589789687104559e+102 }, { zero, 1.e+00 }, 5.e-01 },
        /* 236 */ { { max, 8.9589789687104559e+102 }, { zero, 1.e+00 }, 5.e-01 },
        /* 237 */ { { inf, 8.9589789687104559e+102 }, { nan, nan }, 1.e+00 },
        /* 238 */ { { -inf, 4.0131652080900752e+205 }, { nan, nan }, 1.e+00 },
        /* 239 */ { { -max, 4.0131652080900752e+205 }, { zero, 1.e+00 }, 5.e-01 },
        /* 240 */ { { -4.0131652080900752e+205, 4.0131652080900752e+205 }, { zero, 1.e+00 }, 5.e-01 },
        /* 241 */ { { -8.9589789687104559e+102, 4.0131652080900752e+205 }, { zero, 1.e+00 }, 5.e-01 },
        /* 242 */ { { -1.9999999999998694e+00, 4.0131652080900752e+205 }, { zero, 1.e+00 }, 5.e-01 },
        /* 243 */ { { -4.4647944971961829e-103, 4.0131652080900752e+205 }, { zero, 1.e+00 }, 5.e-01 },
        /* 244 */ { { -9.9671949510973086e-206, 4.0131652080900752e+205 }, { zero, 1.e+00 }, 5.e-01 },
        /* 245 */ { { -min, 4.0131652080900752e+205 }, { zero, 1.e+00 }, 5.e-01 },
        /* 246 */ { { zero, 4.0131652080900752e+205 }, { zero, 1.e+00 }, 5.e-01 },
        /* 247 */ { { min, 4.0131652080900752e+205 }, { zero, 1.e+00 }, 5.e-01 },
        /* 248 */ { { 9.9671949510973086e-206, 4.0131652080900752e+205 }, { zero, 1.e+00 }, 5.e-01 },
        /* 249 */ { { 4.4647944971961829e-103, 4.0131652080900752e+205 }, { zero, 1.e+00 }, 5.e-01 },
        /* 250 */ { { 1.9999999999998694e+00, 4.0131652080900752e+205 }, { zero, 1.e+00 }, 5.e-01 },
        /* 251 */ { { 8.9589789687104559e+102, 4.0131652080900752e+205 }, { zero, 1.e+00 }, 5.e-01 },
        /* 252 */ { { 4.0131652080900752e+205, 4.0131652080900752e+205 }, { zero, 1.e+00 }, 5.e-01 },
        /* 253 */ { { max, 4.0131652080900752e+205 }, { zero, 1.e+00 }, 5.e-01 },
        /* 254 */ { { inf, 4.0131652080900752e+205 }, { nan, nan }, 1.e+00 },
        /* 255 */ { { -inf, max }, { nan, nan }, 1.e+00 },
        /* 256 */ { { -max, max }, { zero, 1.e+00 }, 5.e-01 },
        /* 257 */ { { -4.0131652080900752e+205, max }, { zero, 1.e+00 }, 5.e-01 },
        /* 258 */ { { -8.9589789687104559e+102, max }, { zero, 1.e+00 }, 5.e-01 },
        /* 259 */ { { -1.9999999999998694e+00, max }, { zero, 1.e+00 }, 5.e-01 },
        /* 260 */ { { -4.4647944971961829e-103, max }, { zero, 1.e+00 }, 5.e-01 },
        /* 261 */ { { -9.9671949510973086e-206, max }, { zero, 1.e+00 }, 5.e-01 },
        /* 262 */ { { -min, max }, { zero, 1.e+00 }, 5.e-01 },
        /* 263 */ { { zero, max }, { zero, 1.e+00 }, 5.e-01 },
        /* 264 */ { { min, max }, { zero, 1.e+00 }, 5.e-01 },
        /* 265 */ { { 9.9671949510973086e-206, max }, { zero, 1.e+00 }, 5.e-01 },
        /* 266 */ { { 4.4647944971961829e-103, max }, { zero, 1.e+00 }, 5.e-01 },
        /* 267 */ { { 1.9999999999998694e+00, max }, { zero, 1.e+00 }, 5.e-01 },
        /* 268 */ { { 8.9589789687104559e+102, max }, { zero, 1.e+00 }, 5.e-01 },
        /* 269 */ { { 4.0131652080900752e+205, max }, { zero, 1.e+00 }, 5.e-01 },
        /* 270 */ { { max, max }, { zero, 1.e+00 }, 5.e-01 },
        /* 271 */ { { inf, max }, { nan, nan }, 1.e+00 },
        /* 272 */ { { -inf, inf }, { zero, 1.e+00 }, 5.e-01 },
        /* 273 */ { { -max, inf }, { zero, 1.e+00 }, 5.e-01 },
        /* 274 */ { { -4.0131652080900752e+205, inf }, { zero, 1.e+00 }, 5.e-01 },
        /* 275 */ { { -8.9589789687104559e+102, inf }, { zero, 1.e+00 }, 5.e-01 },
        /* 276 */ { { -1.9999999999998694e+00, inf }, { zero, 1.e+00 }, 5.e-01 },
        /* 277 */ { { -4.4647944971961829e-103, inf }, { zero, 1.e+00 }, 5.e-01 },
        /* 278 */ { { -9.9671949510973086e-206, inf }, { zero, 1.e+00 }, 5.e-01 },
        /* 279 */ { { -min, inf }, { zero, 1.e+00 }, 5.e-01 },
        /* 280 */ { { zero, inf }, { zero, 1.e+00 }, 5.e-01 },
        /* 281 */ { { min, inf }, { zero, 1.e+00 }, 5.e-01 },
        /* 282 */ { { 9.9671949510973086e-206, inf }, { zero, 1.e+00 }, 5.e-01 },
        /* 283 */ { { 4.4647944971961829e-103, inf }, { zero, 1.e+00 }, 5.e-01 },
        /* 284 */ { { 1.9999999999998694e+00, inf }, { zero, 1.e+00 }, 5.e-01 },
        /* 285 */ { { 8.9589789687104559e+102, inf }, { zero, 1.e+00 }, 5.e-01 },
        /* 286 */ { { 4.0131652080900752e+205, inf }, { zero, 1.e+00 }, 5.e-01 },
        /* 287 */ { { max, inf }, { zero, 1.e+00 }, 5.e-01 },
        /* 288 */ { { inf, inf }, { zero, 1.e+00 }, 5.e-01 }  // clang-format on
      };
      return table;
    } else {
      static_assert(dependent_false<T>); /* unreachable */
    }
  }
};

template <typename T, int default_dps_deficiency = 0>
struct Asin {
  typedef std::complex<T> InputType;
  typedef std::complex<T> OutputType;
  typedef T FloatType;
  using TableType = std::vector<std::tuple<InputType, OutputType, FloatType>>;
  static constexpr int dps_deficiency = default_dps_deficiency;
  const TableType get() {
    if constexpr (std::is_same_v<T, float>) {
      const T pi_4 = 0.7853982f;
      const T pi_2 = 1.5707964f;
      const T zero = 0.0f;
      const T inf = std::numeric_limits<T>::infinity();
#ifdef __aarch64__
      const T min = std::nextafter(std::numeric_limits<T>::min(), T(1));
#else
      const T min = std::numeric_limits<T>::min();
#endif
      const T max = std::numeric_limits<T>::max();
      const TableType table{
          // clang-format off
          // Ignore max 80 character line width style requirement for
          // (i) the readability
          // (ii) the consistency with the local conventions
        /* 0 */ { { -inf, -inf }, { -pi_4, -inf }, 1.e+00f },
        /* 1 */ { { -max, -inf }, { zero, -inf }, 1.e+00f },
        /* 2 */ { { -6.1409603e+25f, -inf }, { zero, -inf }, 1.e+00f },
        /* 3 */ { { -1.1082383e+13f, -inf }, { zero, -inf }, 1.e+00f },
        /* 4 */ { { -2.e+00f, -inf }, { zero, -inf }, 1.e+00f },
        /* 5 */ { { -3.6093321e-13f, -inf }, { zero, -inf }, 1.e+00f },
        /* 6 */ { { -6.5136393e-26f, -inf }, { zero, -inf }, 1.e+00f },
        /* 7 */ { { -min, -inf }, { zero, -inf }, 1.e+00f },
        /* 8 */ { { zero, -inf }, { zero, -inf }, 1.e+00f },
        /* 9 */ { { min, -inf }, { zero, -inf }, 1.e+00f },
        /* 10 */ { { 6.5136393e-26f, -inf }, { zero, -inf }, 1.e+00f },
        /* 11 */ { { 3.6093321e-13f, -inf }, { zero, -inf }, 1.e+00f },
        /* 12 */ { { 2.e+00f, -inf }, { zero, -inf }, 1.e+00f },
        /* 13 */ { { 1.1082383e+13f, -inf }, { zero, -inf }, 1.e+00f },
        /* 14 */ { { 6.1409603e+25f, -inf }, { zero, -inf }, 1.e+00f },
        /* 15 */ { { max, -inf }, { zero, -inf }, 1.e+00f },
        /* 16 */ { { inf, -inf }, { pi_4, -inf }, 1.e+00f },
        /* 17 */ { { -inf, -max }, { -pi_2, -inf }, 1.e+00f },
        /* 18 */ { { -max, -max }, { -pi_4, -8.9762558e+01f }, 7.8125e-03f },
        /* 19 */ { { -6.1409603e+25f, -max }, { -1.8046662e-13f, -8.9415985e+01f }, 7.8125e-03f },
        /* 20 */ { { -1.1082383e+13f, -max }, { -3.25682e-26f, -8.9415985e+01f }, 7.8125e-03f },
        /* 21 */ { { -2.e+00f, -max }, { -5.8774718e-39f, -8.9415985e+01f }, 7.8125e-03f },
        /* 22 */ { { -3.6093321e-13f, -max }, { zero, -8.9415985e+01f }, 7.8125e-03f },
        /* 23 */ { { -6.5136393e-26f, -max }, { zero, -8.9415985e+01f }, 7.8125e-03f },
        /* 24 */ { { -min, -max }, { zero, -8.9415985e+01f }, 7.8125e-03f },
        /* 25 */ { { zero, -max }, { zero, -8.9415985e+01f }, 7.8125e-03f },
        /* 26 */ { { min, -max }, { zero, -8.9415985e+01f }, 7.8125e-03f },
        /* 27 */ { { 6.5136393e-26f, -max }, { zero, -8.9415985e+01f }, 7.8125e-03f },
        /* 28 */ { { 3.6093321e-13f, -max }, { zero, -8.9415985e+01f }, 7.8125e-03f },
        /* 29 */ { { 2.e+00f, -max }, { 5.8774718e-39f, -8.9415985e+01f }, 7.8125e-03f },
        /* 30 */ { { 1.1082383e+13f, -max }, { 3.25682e-26f, -8.9415985e+01f }, 7.8125e-03f },
        /* 31 */ { { 6.1409603e+25f, -max }, { 1.8046662e-13f, -8.9415985e+01f }, 7.8125e-03f },
        /* 32 */ { { max, -max }, { pi_4, -8.9762558e+01f }, 7.8125e-03f },
        /* 33 */ { { inf, -max }, { pi_2, -inf }, 1.e+00f },
        /* 34 */ { { -inf, -6.1409603e+25f }, { -pi_2, -inf }, 1.e+00f },
        /* 35 */ { { -max, -6.1409603e+25f }, { -pi_2, -8.9415985e+01f }, 7.8125e-03f },
        /* 36 */ { { -6.1409603e+25f, -6.1409603e+25f }, { -pi_4, -6.0419331e+01f }, 1.5625e-02f },
        /* 37 */ { { -1.1082383e+13f, -6.1409603e+25f }, { -1.8046662e-13f, -6.0072754e+01f }, 1.5625e-02f },
        /* 38 */ { { -2.e+00f, -6.1409603e+25f }, { -3.2568196e-26f, -6.0072754e+01f }, 1.5625e-02f },
        /* 39 */ { { -3.6093321e-13f, -6.1409603e+25f }, { -5.8774718e-39f, -6.0072754e+01f }, 1.5625e-02f },
        /* 40 */ { { -6.5136393e-26f, -6.1409603e+25f }, { zero, -6.0072754e+01f }, 1.5625e-02f },
        /* 41 */ { { -min, -6.1409603e+25f }, { zero, -6.0072754e+01f }, 1.5625e-02f },
        /* 42 */ { { zero, -6.1409603e+25f }, { zero, -6.0072754e+01f }, 1.5625e-02f },
        /* 43 */ { { min, -6.1409603e+25f }, { zero, -6.0072754e+01f }, 1.5625e-02f },
        /* 44 */ { { 6.5136393e-26f, -6.1409603e+25f }, { zero, -6.0072754e+01f }, 1.5625e-02f },
        /* 45 */ { { 3.6093321e-13f, -6.1409603e+25f }, { 5.8774718e-39f, -6.0072754e+01f }, 1.5625e-02f },
        /* 46 */ { { 2.e+00f, -6.1409603e+25f }, { 3.2568196e-26f, -6.0072754e+01f }, 1.5625e-02f },
        /* 47 */ { { 1.1082383e+13f, -6.1409603e+25f }, { 1.8046662e-13f, -6.0072754e+01f }, 1.5625e-02f },
        /* 48 */ { { 6.1409603e+25f, -6.1409603e+25f }, { pi_4, -6.0419331e+01f }, 1.5625e-02f },
        /* 49 */ { { max, -6.1409603e+25f }, { pi_2, -8.9415985e+01f }, 7.8125e-03f },
        /* 50 */ { { inf, -6.1409603e+25f }, { pi_2, -inf }, 1.e+00f },
        /* 51 */ { { -inf, -1.1082383e+13f }, { -pi_2, -inf }, 1.e+00f },
        /* 52 */ { { -max, -1.1082383e+13f }, { -pi_2, -8.9415985e+01f }, 7.8125e-03f },
        /* 53 */ { { -6.1409603e+25f, -1.1082383e+13f }, { -pi_2, -6.0072754e+01f }, 1.5625e-02f },
        /* 54 */ { { -1.1082383e+13f, -1.1082383e+13f }, { -pi_4, -3.1076099e+01f }, 3.125e-02f },
        /* 55 */ { { -2.e+00f, -1.1082383e+13f }, { -1.804666e-13f, -3.0729525e+01f }, 3.125e-02f },
        /* 56 */ { { -3.6093321e-13f, -1.1082383e+13f }, { -3.2568193e-26f, -3.0729525e+01f }, 3.125e-02f },
        /* 57 */ { { -6.5136393e-26f, -1.1082383e+13f }, { -5.8774718e-39f, -3.0729525e+01f }, 3.125e-02f },
        /* 58 */ { { -min, -1.1082383e+13f }, { zero, -3.0729525e+01f }, 3.125e-02f },
        /* 59 */ { { zero, -1.1082383e+13f }, { zero, -3.0729525e+01f }, 3.125e-02f },
        /* 60 */ { { min, -1.1082383e+13f }, { zero, -3.0729525e+01f }, 3.125e-02f },
        /* 61 */ { { 6.5136393e-26f, -1.1082383e+13f }, { 5.8774718e-39f, -3.0729525e+01f }, 3.125e-02f },
        /* 62 */ { { 3.6093321e-13f, -1.1082383e+13f }, { 3.2568193e-26f, -3.0729525e+01f }, 3.125e-02f },
        /* 63 */ { { 2.e+00f, -1.1082383e+13f }, { 1.804666e-13f, -3.0729525e+01f }, 3.125e-02f },
        /* 64 */ { { 1.1082383e+13f, -1.1082383e+13f }, { pi_4, -3.1076099e+01f }, 3.125e-02f },
        /* 65 */ { { 6.1409603e+25f, -1.1082383e+13f }, { pi_2, -6.0072754e+01f }, 1.5625e-02f },
        /* 66 */ { { max, -1.1082383e+13f }, { pi_2, -8.9415985e+01f }, 7.8125e-03f },
        /* 67 */ { { inf, -1.1082383e+13f }, { pi_2, -inf }, 1.e+00f },
        /* 68 */ { { -inf, -2.e+00f }, { -pi_2, -inf }, 1.e+00f },
        /* 69 */ { { -max, -2.e+00f }, { -pi_2, -8.9415985e+01f }, 7.8125e-03f },
        /* 70 */ { { -6.1409603e+25f, -2.e+00f }, { -pi_2, -6.0072754e+01f }, 1.5625e-02f },
        /* 71 */ { { -1.1082383e+13f, -2.e+00f }, { -pi_2, -3.0729525e+01f }, 3.125e-02f },
        /* 72 */ { { -2.e+00f, -2.e+00f }, { -7.5424916e-01f, -1.7343246e+00f }, 5.e-01f },
        /* 73 */ { { -3.6093321e-13f, -2.e+00f }, { -1.6141424e-13f, -1.4436355e+00f }, 5.e-01f },
        /* 74 */ { { -6.5136393e-26f, -2.e+00f }, { -2.9129881e-26f, -1.4436355e+00f }, 5.e-01f },
        /* 75 */ { { -min, -2.e+00f }, { zero, -1.4436355e+00f }, 5.e-01f },
        /* 76 */ { { zero, -2.e+00f }, { zero, -1.4436355e+00f }, 5.e-01f },
        /* 77 */ { { min, -2.e+00f }, { zero, -1.4436355e+00f }, 5.e-01f },
        /* 78 */ { { 6.5136393e-26f, -2.e+00f }, { 2.9129881e-26f, -1.4436355e+00f }, 5.e-01f },
        /* 79 */ { { 3.6093321e-13f, -2.e+00f }, { 1.6141424e-13f, -1.4436355e+00f }, 5.e-01f },
        /* 80 */ { { 2.e+00f, -2.e+00f }, { 7.5424916e-01f, -1.7343246e+00f }, 5.e-01f },
        /* 81 */ { { 1.1082383e+13f, -2.e+00f }, { pi_2, -3.0729525e+01f }, 3.125e-02f },
        /* 82 */ { { 6.1409603e+25f, -2.e+00f }, { pi_2, -6.0072754e+01f }, 1.5625e-02f },
        /* 83 */ { { max, -2.e+00f }, { pi_2, -8.9415985e+01f }, 7.8125e-03f },
        /* 84 */ { { inf, -2.e+00f }, { pi_2, -inf }, 1.e+00f },
        /* 85 */ { { -inf, -3.6093321e-13f }, { -pi_2, -inf }, 1.e+00f },
        /* 86 */ { { -max, -3.6093321e-13f }, { -pi_2, -8.9415985e+01f }, 7.8125e-03f },
        /* 87 */ { { -6.1409603e+25f, -3.6093321e-13f }, { -pi_2, -6.0072754e+01f }, 1.5625e-02f },
        /* 88 */ { { -1.1082383e+13f, -3.6093321e-13f }, { -pi_2, -3.0729525e+01f }, 3.125e-02f },
        /* 89 */ { { -2.e+00f, -3.6093321e-13f }, { -pi_2, -1.316958e+00f }, 2.5e-01f },
        /* 90 */ { { -3.6093321e-13f, -3.6093321e-13f }, { -3.6093321e-13f, -3.6093321e-13f }, 1.0995116e+12f },
        /* 91 */ { { -6.5136393e-26f, -3.6093321e-13f }, { -6.5136393e-26f, -3.6093321e-13f }, 2.1990233e+12f },
        /* 92 */ { { -min, -3.6093321e-13f }, { -min, -3.6093321e-13f }, 2.1990233e+12f },
        /* 93 */ { { zero, -3.6093321e-13f }, { zero, -3.6093321e-13f }, 2.1990233e+12f },
        /* 94 */ { { min, -3.6093321e-13f }, { min, -3.6093321e-13f }, 2.1990233e+12f },
        /* 95 */ { { 6.5136393e-26f, -3.6093321e-13f }, { 6.5136393e-26f, -3.6093321e-13f }, 2.1990233e+12f },
        /* 96 */ { { 3.6093321e-13f, -3.6093321e-13f }, { 3.6093321e-13f, -3.6093321e-13f }, 1.0995116e+12f },
        /* 97 */ { { 2.e+00f, -3.6093321e-13f }, { pi_2, -1.316958e+00f }, 2.5e-01f },
        /* 98 */ { { 1.1082383e+13f, -3.6093321e-13f }, { pi_2, -3.0729525e+01f }, 3.125e-02f },
        /* 99 */ { { 6.1409603e+25f, -3.6093321e-13f }, { pi_2, -6.0072754e+01f }, 1.5625e-02f },
        /* 100 */ { { max, -3.6093321e-13f }, { pi_2, -8.9415985e+01f }, 7.8125e-03f },
        /* 101 */ { { inf, -3.6093321e-13f }, { pi_2, -inf }, 1.e+00f },
        /* 102 */ { { -inf, -6.5136393e-26f }, { -pi_2, -inf }, 1.e+00f },
        /* 103 */ { { -max, -6.5136393e-26f }, { -pi_2, -8.9415985e+01f }, 7.8125e-03f },
        /* 104 */ { { -6.1409603e+25f, -6.5136393e-26f }, { -pi_2, -6.0072754e+01f }, 1.5625e-02f },
        /* 105 */ { { -1.1082383e+13f, -6.5136393e-26f }, { -pi_2, -3.0729525e+01f }, 3.125e-02f },
        /* 106 */ { { -2.e+00f, -6.5136393e-26f }, { -pi_2, -1.316958e+00f }, 2.5e-01f },
        /* 107 */ { { -3.6093321e-13f, -6.5136393e-26f }, { -3.6093321e-13f, -6.5136393e-26f }, 2.1990233e+12f },
        /* 108 */ { { -6.5136393e-26f, -6.5136393e-26f }, { -6.5136393e-26f, -6.5136393e-26f }, 9.6714066e+24f },
        /* 109 */ { { -min, -6.5136393e-26f }, { -min, -6.5136393e-26f }, 9.6714066e+24f },
        /* 110 */ { { zero, -6.5136393e-26f }, { zero, -6.5136393e-26f }, 9.6714066e+24f },
        /* 111 */ { { min, -6.5136393e-26f }, { min, -6.5136393e-26f }, 9.6714066e+24f },
        /* 112 */ { { 6.5136393e-26f, -6.5136393e-26f }, { 6.5136393e-26f, -6.5136393e-26f }, 9.6714066e+24f },
        /* 113 */ { { 3.6093321e-13f, -6.5136393e-26f }, { 3.6093321e-13f, -6.5136393e-26f }, 2.1990233e+12f },
        /* 114 */ { { 2.e+00f, -6.5136393e-26f }, { pi_2, -1.316958e+00f }, 2.5e-01f },
        /* 115 */ { { 1.1082383e+13f, -6.5136393e-26f }, { pi_2, -3.0729525e+01f }, 3.125e-02f },
        /* 116 */ { { 6.1409603e+25f, -6.5136393e-26f }, { pi_2, -6.0072754e+01f }, 1.5625e-02f },
        /* 117 */ { { max, -6.5136393e-26f }, { pi_2, -8.9415985e+01f }, 7.8125e-03f },
        /* 118 */ { { inf, -6.5136393e-26f }, { pi_2, -inf }, 1.e+00f },
        /* 119 */ { { -inf, -min }, { -pi_2, -inf }, 1.e+00f },
        /* 120 */ { { -max, -min }, { -pi_2, -8.9415985e+01f }, 7.8125e-03f },
        /* 121 */ { { -6.1409603e+25f, -min }, { -pi_2, -6.0072754e+01f }, 1.5625e-02f },
        /* 122 */ { { -1.1082383e+13f, -min }, { -pi_2, -3.0729525e+01f }, 3.125e-02f },
        /* 123 */ { { -2.e+00f, -min }, { -pi_2, -1.316958e+00f }, 2.5e-01f },
        /* 124 */ { { -3.6093321e-13f, -min }, { -3.6093321e-13f, -min }, 2.1990233e+12f },
        /* 125 */ { { -6.5136393e-26f, -min }, { -6.5136393e-26f, -min }, 9.6714066e+24f },
        /* 126 */ { { -min, -min }, { -min, -min }, 4.2535296e+37f },
        /* 127 */ { { zero, -min }, { zero, -min }, 4.2535296e+37f },
        /* 128 */ { { min, -min }, { min, -min }, 4.2535296e+37f },
        /* 129 */ { { 6.5136393e-26f, -min }, { 6.5136393e-26f, -min }, 9.6714066e+24f },
        /* 130 */ { { 3.6093321e-13f, -min }, { 3.6093321e-13f, -min }, 2.1990233e+12f },
        /* 131 */ { { 2.e+00f, -min }, { pi_2, -1.316958e+00f }, 2.5e-01f },
        /* 132 */ { { 1.1082383e+13f, -min }, { pi_2, -3.0729525e+01f }, 3.125e-02f },
        /* 133 */ { { 6.1409603e+25f, -min }, { pi_2, -6.0072754e+01f }, 1.5625e-02f },
        /* 134 */ { { max, -min }, { pi_2, -8.9415985e+01f }, 7.8125e-03f },
        /* 135 */ { { inf, -min }, { pi_2, -inf }, 1.e+00f },
        /* 136 */ { { -inf, zero }, { -pi_2, inf }, 1.e+00f },
        /* 137 */ { { -max, zero }, { -pi_2, 8.9415985e+01f }, 7.8125e-03f },
        /* 138 */ { { -6.1409603e+25f, zero }, { -pi_2, 6.0072754e+01f }, 1.5625e-02f },
        /* 139 */ { { -1.1082383e+13f, zero }, { -pi_2, 3.0729525e+01f }, 3.125e-02f },
        /* 140 */ { { -2.e+00f, zero }, { -pi_2, 1.316958e+00f }, 2.5e-01f },
        /* 141 */ { { -3.6093321e-13f, zero }, { -3.6093321e-13f, zero }, 2.1990233e+12f },
        /* 142 */ { { -6.5136393e-26f, zero }, { -6.5136393e-26f, zero }, 9.6714066e+24f },
        /* 143 */ { { -min, zero }, { -min, zero }, 4.2535296e+37f },
        /* 144 */ { { zero, zero }, { zero, zero }, 1.e+00f },
        /* 145 */ { { min, zero }, { min, zero }, 4.2535296e+37f },
        /* 146 */ { { 6.5136393e-26f, zero }, { 6.5136393e-26f, zero }, 9.6714066e+24f },
        /* 147 */ { { 3.6093321e-13f, zero }, { 3.6093321e-13f, zero }, 2.1990233e+12f },
        /* 148 */ { { 2.e+00f, zero }, { pi_2, 1.316958e+00f }, 2.5e-01f },
        /* 149 */ { { 1.1082383e+13f, zero }, { pi_2, 3.0729525e+01f }, 3.125e-02f },
        /* 150 */ { { 6.1409603e+25f, zero }, { pi_2, 6.0072754e+01f }, 1.5625e-02f },
        /* 151 */ { { max, zero }, { pi_2, 8.9415985e+01f }, 7.8125e-03f },
        /* 152 */ { { inf, zero }, { pi_2, inf }, 1.e+00f },
        /* 153 */ { { -inf, min }, { -pi_2, inf }, 1.e+00f },
        /* 154 */ { { -max, min }, { -pi_2, 8.9415985e+01f }, 7.8125e-03f },
        /* 155 */ { { -6.1409603e+25f, min }, { -pi_2, 6.0072754e+01f }, 1.5625e-02f },
        /* 156 */ { { -1.1082383e+13f, min }, { -pi_2, 3.0729525e+01f }, 3.125e-02f },
        /* 157 */ { { -2.e+00f, min }, { -pi_2, 1.316958e+00f }, 2.5e-01f },
        /* 158 */ { { -3.6093321e-13f, min }, { -3.6093321e-13f, min }, 2.1990233e+12f },
        /* 159 */ { { -6.5136393e-26f, min }, { -6.5136393e-26f, min }, 9.6714066e+24f },
        /* 160 */ { { -min, min }, { -min, min }, 4.2535296e+37f },
        /* 161 */ { { zero, min }, { zero, min }, 4.2535296e+37f },
        /* 162 */ { { min, min }, { min, min }, 4.2535296e+37f },
        /* 163 */ { { 6.5136393e-26f, min }, { 6.5136393e-26f, min }, 9.6714066e+24f },
        /* 164 */ { { 3.6093321e-13f, min }, { 3.6093321e-13f, min }, 2.1990233e+12f },
        /* 165 */ { { 2.e+00f, min }, { pi_2, 1.316958e+00f }, 2.5e-01f },
        /* 166 */ { { 1.1082383e+13f, min }, { pi_2, 3.0729525e+01f }, 3.125e-02f },
        /* 167 */ { { 6.1409603e+25f, min }, { pi_2, 6.0072754e+01f }, 1.5625e-02f },
        /* 168 */ { { max, min }, { pi_2, 8.9415985e+01f }, 7.8125e-03f },
        /* 169 */ { { inf, min }, { pi_2, inf }, 1.e+00f },
        /* 170 */ { { -inf, 6.5136393e-26f }, { -pi_2, inf }, 1.e+00f },
        /* 171 */ { { -max, 6.5136393e-26f }, { -pi_2, 8.9415985e+01f }, 7.8125e-03f },
        /* 172 */ { { -6.1409603e+25f, 6.5136393e-26f }, { -pi_2, 6.0072754e+01f }, 1.5625e-02f },
        /* 173 */ { { -1.1082383e+13f, 6.5136393e-26f }, { -pi_2, 3.0729525e+01f }, 3.125e-02f },
        /* 174 */ { { -2.e+00f, 6.5136393e-26f }, { -pi_2, 1.316958e+00f }, 2.5e-01f },
        /* 175 */ { { -3.6093321e-13f, 6.5136393e-26f }, { -3.6093321e-13f, 6.5136393e-26f }, 2.1990233e+12f },
        /* 176 */ { { -6.5136393e-26f, 6.5136393e-26f }, { -6.5136393e-26f, 6.5136393e-26f }, 9.6714066e+24f },
        /* 177 */ { { -min, 6.5136393e-26f }, { -min, 6.5136393e-26f }, 9.6714066e+24f },
        /* 178 */ { { zero, 6.5136393e-26f }, { zero, 6.5136393e-26f }, 9.6714066e+24f },
        /* 179 */ { { min, 6.5136393e-26f }, { min, 6.5136393e-26f }, 9.6714066e+24f },
        /* 180 */ { { 6.5136393e-26f, 6.5136393e-26f }, { 6.5136393e-26f, 6.5136393e-26f }, 9.6714066e+24f },
        /* 181 */ { { 3.6093321e-13f, 6.5136393e-26f }, { 3.6093321e-13f, 6.5136393e-26f }, 2.1990233e+12f },
        /* 182 */ { { 2.e+00f, 6.5136393e-26f }, { pi_2, 1.316958e+00f }, 2.5e-01f },
        /* 183 */ { { 1.1082383e+13f, 6.5136393e-26f }, { pi_2, 3.0729525e+01f }, 3.125e-02f },
        /* 184 */ { { 6.1409603e+25f, 6.5136393e-26f }, { pi_2, 6.0072754e+01f }, 1.5625e-02f },
        /* 185 */ { { max, 6.5136393e-26f }, { pi_2, 8.9415985e+01f }, 7.8125e-03f },
        /* 186 */ { { inf, 6.5136393e-26f }, { pi_2, inf }, 1.e+00f },
        /* 187 */ { { -inf, 3.6093321e-13f }, { -pi_2, inf }, 1.e+00f },
        /* 188 */ { { -max, 3.6093321e-13f }, { -pi_2, 8.9415985e+01f }, 7.8125e-03f },
        /* 189 */ { { -6.1409603e+25f, 3.6093321e-13f }, { -pi_2, 6.0072754e+01f }, 1.5625e-02f },
        /* 190 */ { { -1.1082383e+13f, 3.6093321e-13f }, { -pi_2, 3.0729525e+01f }, 3.125e-02f },
        /* 191 */ { { -2.e+00f, 3.6093321e-13f }, { -pi_2, 1.316958e+00f }, 2.5e-01f },
        /* 192 */ { { -3.6093321e-13f, 3.6093321e-13f }, { -3.6093321e-13f, 3.6093321e-13f }, 1.0995116e+12f },
        /* 193 */ { { -6.5136393e-26f, 3.6093321e-13f }, { -6.5136393e-26f, 3.6093321e-13f }, 2.1990233e+12f },
        /* 194 */ { { -min, 3.6093321e-13f }, { -min, 3.6093321e-13f }, 2.1990233e+12f },
        /* 195 */ { { zero, 3.6093321e-13f }, { zero, 3.6093321e-13f }, 2.1990233e+12f },
        /* 196 */ { { min, 3.6093321e-13f }, { min, 3.6093321e-13f }, 2.1990233e+12f },
        /* 197 */ { { 6.5136393e-26f, 3.6093321e-13f }, { 6.5136393e-26f, 3.6093321e-13f }, 2.1990233e+12f },
        /* 198 */ { { 3.6093321e-13f, 3.6093321e-13f }, { 3.6093321e-13f, 3.6093321e-13f }, 1.0995116e+12f },
        /* 199 */ { { 2.e+00f, 3.6093321e-13f }, { pi_2, 1.316958e+00f }, 2.5e-01f },
        /* 200 */ { { 1.1082383e+13f, 3.6093321e-13f }, { pi_2, 3.0729525e+01f }, 3.125e-02f },
        /* 201 */ { { 6.1409603e+25f, 3.6093321e-13f }, { pi_2, 6.0072754e+01f }, 1.5625e-02f },
        /* 202 */ { { max, 3.6093321e-13f }, { pi_2, 8.9415985e+01f }, 7.8125e-03f },
        /* 203 */ { { inf, 3.6093321e-13f }, { pi_2, inf }, 1.e+00f },
        /* 204 */ { { -inf, 2.e+00f }, { -pi_2, inf }, 1.e+00f },
        /* 205 */ { { -max, 2.e+00f }, { -pi_2, 8.9415985e+01f }, 7.8125e-03f },
        /* 206 */ { { -6.1409603e+25f, 2.e+00f }, { -pi_2, 6.0072754e+01f }, 1.5625e-02f },
        /* 207 */ { { -1.1082383e+13f, 2.e+00f }, { -pi_2, 3.0729525e+01f }, 3.125e-02f },
        /* 208 */ { { -2.e+00f, 2.e+00f }, { -7.5424916e-01f, 1.7343246e+00f }, 5.e-01f },
        /* 209 */ { { -3.6093321e-13f, 2.e+00f }, { -1.6141424e-13f, 1.4436355e+00f }, 5.e-01f },
        /* 210 */ { { -6.5136393e-26f, 2.e+00f }, { -2.9129881e-26f, 1.4436355e+00f }, 5.e-01f },
        /* 211 */ { { -min, 2.e+00f }, { zero, 1.4436355e+00f }, 5.e-01f },
        /* 212 */ { { zero, 2.e+00f }, { zero, 1.4436355e+00f }, 5.e-01f },
        /* 213 */ { { min, 2.e+00f }, { zero, 1.4436355e+00f }, 5.e-01f },
        /* 214 */ { { 6.5136393e-26f, 2.e+00f }, { 2.9129881e-26f, 1.4436355e+00f }, 5.e-01f },
        /* 215 */ { { 3.6093321e-13f, 2.e+00f }, { 1.6141424e-13f, 1.4436355e+00f }, 5.e-01f },
        /* 216 */ { { 2.e+00f, 2.e+00f }, { 7.5424916e-01f, 1.7343246e+00f }, 5.e-01f },
        /* 217 */ { { 1.1082383e+13f, 2.e+00f }, { pi_2, 3.0729525e+01f }, 3.125e-02f },
        /* 218 */ { { 6.1409603e+25f, 2.e+00f }, { pi_2, 6.0072754e+01f }, 1.5625e-02f },
        /* 219 */ { { max, 2.e+00f }, { pi_2, 8.9415985e+01f }, 7.8125e-03f },
        /* 220 */ { { inf, 2.e+00f }, { pi_2, inf }, 1.e+00f },
        /* 221 */ { { -inf, 1.1082383e+13f }, { -pi_2, inf }, 1.e+00f },
        /* 222 */ { { -max, 1.1082383e+13f }, { -pi_2, 8.9415985e+01f }, 7.8125e-03f },
        /* 223 */ { { -6.1409603e+25f, 1.1082383e+13f }, { -pi_2, 6.0072754e+01f }, 1.5625e-02f },
        /* 224 */ { { -1.1082383e+13f, 1.1082383e+13f }, { -pi_4, 3.1076099e+01f }, 3.125e-02f },
        /* 225 */ { { -2.e+00f, 1.1082383e+13f }, { -1.804666e-13f, 3.0729525e+01f }, 3.125e-02f },
        /* 226 */ { { -3.6093321e-13f, 1.1082383e+13f }, { -3.2568193e-26f, 3.0729525e+01f }, 3.125e-02f },
        /* 227 */ { { -6.5136393e-26f, 1.1082383e+13f }, { -5.8774718e-39f, 3.0729525e+01f }, 3.125e-02f },
        /* 228 */ { { -min, 1.1082383e+13f }, { zero, 3.0729525e+01f }, 3.125e-02f },
        /* 229 */ { { zero, 1.1082383e+13f }, { zero, 3.0729525e+01f }, 3.125e-02f },
        /* 230 */ { { min, 1.1082383e+13f }, { zero, 3.0729525e+01f }, 3.125e-02f },
        /* 231 */ { { 6.5136393e-26f, 1.1082383e+13f }, { 5.8774718e-39f, 3.0729525e+01f }, 3.125e-02f },
        /* 232 */ { { 3.6093321e-13f, 1.1082383e+13f }, { 3.2568193e-26f, 3.0729525e+01f }, 3.125e-02f },
        /* 233 */ { { 2.e+00f, 1.1082383e+13f }, { 1.804666e-13f, 3.0729525e+01f }, 3.125e-02f },
        /* 234 */ { { 1.1082383e+13f, 1.1082383e+13f }, { pi_4, 3.1076099e+01f }, 3.125e-02f },
        /* 235 */ { { 6.1409603e+25f, 1.1082383e+13f }, { pi_2, 6.0072754e+01f }, 1.5625e-02f },
        /* 236 */ { { max, 1.1082383e+13f }, { pi_2, 8.9415985e+01f }, 7.8125e-03f },
        /* 237 */ { { inf, 1.1082383e+13f }, { pi_2, inf }, 1.e+00f },
        /* 238 */ { { -inf, 6.1409603e+25f }, { -pi_2, inf }, 1.e+00f },
        /* 239 */ { { -max, 6.1409603e+25f }, { -pi_2, 8.9415985e+01f }, 7.8125e-03f },
        /* 240 */ { { -6.1409603e+25f, 6.1409603e+25f }, { -pi_4, 6.0419331e+01f }, 1.5625e-02f },
        /* 241 */ { { -1.1082383e+13f, 6.1409603e+25f }, { -1.8046662e-13f, 6.0072754e+01f }, 1.5625e-02f },
        /* 242 */ { { -2.e+00f, 6.1409603e+25f }, { -3.2568196e-26f, 6.0072754e+01f }, 1.5625e-02f },
        /* 243 */ { { -3.6093321e-13f, 6.1409603e+25f }, { -5.8774718e-39f, 6.0072754e+01f }, 1.5625e-02f },
        /* 244 */ { { -6.5136393e-26f, 6.1409603e+25f }, { zero, 6.0072754e+01f }, 1.5625e-02f },
        /* 245 */ { { -min, 6.1409603e+25f }, { zero, 6.0072754e+01f }, 1.5625e-02f },
        /* 246 */ { { zero, 6.1409603e+25f }, { zero, 6.0072754e+01f }, 1.5625e-02f },
        /* 247 */ { { min, 6.1409603e+25f }, { zero, 6.0072754e+01f }, 1.5625e-02f },
        /* 248 */ { { 6.5136393e-26f, 6.1409603e+25f }, { zero, 6.0072754e+01f }, 1.5625e-02f },
        /* 249 */ { { 3.6093321e-13f, 6.1409603e+25f }, { 5.8774718e-39f, 6.0072754e+01f }, 1.5625e-02f },
        /* 250 */ { { 2.e+00f, 6.1409603e+25f }, { 3.2568196e-26f, 6.0072754e+01f }, 1.5625e-02f },
        /* 251 */ { { 1.1082383e+13f, 6.1409603e+25f }, { 1.8046662e-13f, 6.0072754e+01f }, 1.5625e-02f },
        /* 252 */ { { 6.1409603e+25f, 6.1409603e+25f }, { pi_4, 6.0419331e+01f }, 1.5625e-02f },
        /* 253 */ { { max, 6.1409603e+25f }, { pi_2, 8.9415985e+01f }, 7.8125e-03f },
        /* 254 */ { { inf, 6.1409603e+25f }, { pi_2, inf }, 1.e+00f },
        /* 255 */ { { -inf, max }, { -pi_2, inf }, 1.e+00f },
        /* 256 */ { { -max, max }, { -pi_4, 8.9762558e+01f }, 7.8125e-03f },
        /* 257 */ { { -6.1409603e+25f, max }, { -1.8046662e-13f, 8.9415985e+01f }, 7.8125e-03f },
        /* 258 */ { { -1.1082383e+13f, max }, { -3.25682e-26f, 8.9415985e+01f }, 7.8125e-03f },
        /* 259 */ { { -2.e+00f, max }, { -5.8774718e-39f, 8.9415985e+01f }, 7.8125e-03f },
        /* 260 */ { { -3.6093321e-13f, max }, { zero, 8.9415985e+01f }, 7.8125e-03f },
        /* 261 */ { { -6.5136393e-26f, max }, { zero, 8.9415985e+01f }, 7.8125e-03f },
        /* 262 */ { { -min, max }, { zero, 8.9415985e+01f }, 7.8125e-03f },
        /* 263 */ { { zero, max }, { zero, 8.9415985e+01f }, 7.8125e-03f },
        /* 264 */ { { min, max }, { zero, 8.9415985e+01f }, 7.8125e-03f },
        /* 265 */ { { 6.5136393e-26f, max }, { zero, 8.9415985e+01f }, 7.8125e-03f },
        /* 266 */ { { 3.6093321e-13f, max }, { zero, 8.9415985e+01f }, 7.8125e-03f },
        /* 267 */ { { 2.e+00f, max }, { 5.8774718e-39f, 8.9415985e+01f }, 7.8125e-03f },
        /* 268 */ { { 1.1082383e+13f, max }, { 3.25682e-26f, 8.9415985e+01f }, 7.8125e-03f },
        /* 269 */ { { 6.1409603e+25f, max }, { 1.8046662e-13f, 8.9415985e+01f }, 7.8125e-03f },
        /* 270 */ { { max, max }, { pi_4, 8.9762558e+01f }, 7.8125e-03f },
        /* 271 */ { { inf, max }, { pi_2, inf }, 1.e+00f },
        /* 272 */ { { -inf, inf }, { -pi_4, inf }, 1.e+00f },
        /* 273 */ { { -max, inf }, { zero, inf }, 1.e+00f },
        /* 274 */ { { -6.1409603e+25f, inf }, { zero, inf }, 1.e+00f },
        /* 275 */ { { -1.1082383e+13f, inf }, { zero, inf }, 1.e+00f },
        /* 276 */ { { -2.e+00f, inf }, { zero, inf }, 1.e+00f },
        /* 277 */ { { -3.6093321e-13f, inf }, { zero, inf }, 1.e+00f },
        /* 278 */ { { -6.5136393e-26f, inf }, { zero, inf }, 1.e+00f },
        /* 279 */ { { -min, inf }, { zero, inf }, 1.e+00f },
        /* 280 */ { { zero, inf }, { zero, inf }, 1.e+00f },
        /* 281 */ { { min, inf }, { zero, inf }, 1.e+00f },
        /* 282 */ { { 6.5136393e-26f, inf }, { zero, inf }, 1.e+00f },
        /* 283 */ { { 3.6093321e-13f, inf }, { zero, inf }, 1.e+00f },
        /* 284 */ { { 2.e+00f, inf }, { zero, inf }, 1.e+00f },
        /* 285 */ { { 1.1082383e+13f, inf }, { zero, inf }, 1.e+00f },
        /* 286 */ { { 6.1409603e+25f, inf }, { zero, inf }, 1.e+00f },
        /* 287 */ { { max, inf }, { zero, inf }, 1.e+00f },
        /* 288 */ { { inf, inf }, { pi_4, inf }, 1.e+00f }
          // clang-format on
      };
      return table;
    } else if constexpr (std::is_same_v<T, double>) {
      const T pi_4 = 0.7853981633974483;
      const T pi_2 = 1.5707963267948966;
      const T zero = 0.0;
      const T inf = std::numeric_limits<T>::infinity();
#ifdef __aarch64__
      const T min = std::nextafter(std::numeric_limits<T>::min(), T(1));
#else
      const T min = std::numeric_limits<T>::min();
#endif
      const T max = std::numeric_limits<T>::max();
      const TableType table{
          // clang-format off
          // Ignore max 80 character line width style requirement for
          // (i) the readability
          // (ii) the consistency with the local conventions
        /* 0 */ { { -inf, -inf }, { -pi_4, -inf }, 1.e+00 },
        /* 1 */ { { -max, -inf }, { zero, -inf }, 1.e+00 },
        /* 2 */ { { -4.0131652080900752e+205, -inf }, { zero, -inf }, 1.e+00 },
        /* 3 */ { { -8.9589789687104559e+102, -inf }, { zero, -inf }, 1.e+00 },
        /* 4 */ { { -1.9999999999998694e+00, -inf }, { zero, -inf }, 1.e+00 },
        /* 5 */ { { -4.4647944971961829e-103, -inf }, { zero, -inf }, 1.e+00 },
        /* 6 */ { { -9.9671949510973086e-206, -inf }, { zero, -inf }, 1.e+00 },
        /* 7 */ { { -min, -inf }, { zero, -inf }, 1.e+00 },
        /* 8 */ { { zero, -inf }, { zero, -inf }, 1.e+00 },
        /* 9 */ { { min, -inf }, { zero, -inf }, 1.e+00 },
        /* 10 */ { { 9.9671949510973086e-206, -inf }, { zero, -inf }, 1.e+00 },
        /* 11 */ { { 4.4647944971961829e-103, -inf }, { zero, -inf }, 1.e+00 },
        /* 12 */ { { 1.9999999999998694e+00, -inf }, { zero, -inf }, 1.e+00 },
        /* 13 */ { { 8.9589789687104559e+102, -inf }, { zero, -inf }, 1.e+00 },
        /* 14 */ { { 4.0131652080900752e+205, -inf }, { zero, -inf }, 1.e+00 },
        /* 15 */ { { max, -inf }, { zero, -inf }, 1.e+00 },
        /* 16 */ { { inf, -inf }, { pi_4, -inf }, 1.e+00 },
        /* 17 */ { { -inf, -max }, { -pi_2, -inf }, 1.e+00 },
        /* 18 */ { { -max, -max }, { -pi_4, -7.1082243366422392e+02 }, 9.765625e-04 },
        /* 19 */ { { -4.0131652080900752e+205, -max }, { -2.2323972485979601e-103, -7.1047586007394398e+02 }, 9.765625e-04 },
        /* 20 */ { { -8.9589789687104559e+102, -max }, { -4.9835974755483611e-206, -7.1047586007394398e+02 }, 9.765625e-04 },
        /* 21 */ { { -1.9999999999998694e+00, -max }, { zero, -7.1047586007394398e+02 }, 9.765625e-04 },
        /* 22 */ { { -4.4647944971961829e-103, -max }, { zero, -7.1047586007394398e+02 }, 9.765625e-04 },
        /* 23 */ { { -9.9671949510973086e-206, -max }, { zero, -7.1047586007394398e+02 }, 9.765625e-04 },
        /* 24 */ { { -min, -max }, { zero, -7.1047586007394398e+02 }, 9.765625e-04 },
        /* 25 */ { { zero, -max }, { zero, -7.1047586007394398e+02 }, 9.765625e-04 },
        /* 26 */ { { min, -max }, { zero, -7.1047586007394398e+02 }, 9.765625e-04 },
        /* 27 */ { { 9.9671949510973086e-206, -max }, { zero, -7.1047586007394398e+02 }, 9.765625e-04 },
        /* 28 */ { { 4.4647944971961829e-103, -max }, { zero, -7.1047586007394398e+02 }, 9.765625e-04 },
        /* 29 */ { { 1.9999999999998694e+00, -max }, { zero, -7.1047586007394398e+02 }, 9.765625e-04 },
        /* 30 */ { { 8.9589789687104559e+102, -max }, { 4.9835974755483611e-206, -7.1047586007394398e+02 }, 9.765625e-04 },
        /* 31 */ { { 4.0131652080900752e+205, -max }, { 2.2323972485979601e-103, -7.1047586007394398e+02 }, 9.765625e-04 },
        /* 32 */ { { max, -max }, { pi_4, -7.1082243366422392e+02 }, 9.765625e-04 },
        /* 33 */ { { inf, -max }, { pi_2, -inf }, 1.e+00 },
        /* 34 */ { { -inf, -4.0131652080900752e+205 }, { -pi_2, -inf }, 1.e+00 },
        /* 35 */ { { -max, -4.0131652080900752e+205 }, { -pi_2, -7.1047586007394398e+02 }, 9.765625e-04 },
        /* 36 */ { { -4.0131652080900752e+205, -4.0131652080900752e+205 }, { -pi_4, -4.7445924509328245e+02 }, 1.953125e-03 },
        /* 37 */ { { -8.9589789687104559e+102, -4.0131652080900752e+205 }, { -2.2323972485982374e-103, -4.741126715030025e+02 }, 1.953125e-03 },
        /* 38 */ { { -1.9999999999998694e+00, -4.0131652080900752e+205 }, { -4.9835974755489796e-206, -4.741126715030025e+02 }, 1.953125e-03 },
        /* 39 */ { { -4.4647944971961829e-103, -4.0131652080900752e+205 }, { -1.1125369292536664e-308, -4.741126715030025e+02 }, 1.953125e-03 },
        /* 40 */ { { -9.9671949510973086e-206, -4.0131652080900752e+205 }, { zero, -4.741126715030025e+02 }, 1.953125e-03 },
        /* 41 */ { { -min, -4.0131652080900752e+205 }, { zero, -4.741126715030025e+02 }, 1.953125e-03 },
        /* 42 */ { { zero, -4.0131652080900752e+205 }, { zero, -4.741126715030025e+02 }, 1.953125e-03 },
        /* 43 */ { { min, -4.0131652080900752e+205 }, { zero, -4.741126715030025e+02 }, 1.953125e-03 },
        /* 44 */ { { 9.9671949510973086e-206, -4.0131652080900752e+205 }, { zero, -4.741126715030025e+02 }, 1.953125e-03 },
        /* 45 */ { { 4.4647944971961829e-103, -4.0131652080900752e+205 }, { 1.1125369292536664e-308, -4.741126715030025e+02 }, 1.953125e-03 },
        /* 46 */ { { 1.9999999999998694e+00, -4.0131652080900752e+205 }, { 4.9835974755489796e-206, -4.741126715030025e+02 }, 1.953125e-03 },
        /* 47 */ { { 8.9589789687104559e+102, -4.0131652080900752e+205 }, { 2.2323972485982374e-103, -4.741126715030025e+02 }, 1.953125e-03 },
        /* 48 */ { { 4.0131652080900752e+205, -4.0131652080900752e+205 }, { pi_4, -4.7445924509328245e+02 }, 1.953125e-03 },
        /* 49 */ { { max, -4.0131652080900752e+205 }, { pi_2, -7.1047586007394398e+02 }, 9.765625e-04 },
        /* 50 */ { { inf, -4.0131652080900752e+205 }, { pi_2, -inf }, 1.e+00 },
        /* 51 */ { { -inf, -8.9589789687104559e+102 }, { -pi_2, -inf }, 1.e+00 },
        /* 52 */ { { -max, -8.9589789687104559e+102 }, { -pi_2, -7.1047586007394398e+02 }, 9.765625e-04 },
        /* 53 */ { { -4.0131652080900752e+205, -8.9589789687104559e+102 }, { -pi_2, -4.741126715030025e+02 }, 1.953125e-03 },
        /* 54 */ { { -8.9589789687104559e+102, -8.9589789687104559e+102 }, { -pi_4, -2.3809605652234112e+02 }, 3.90625e-03 },
        /* 55 */ { { -1.9999999999998694e+00, -8.9589789687104559e+102 }, { -2.2323972485982374e-103, -2.3774948293206117e+02 }, 3.90625e-03 },
        /* 56 */ { { -4.4647944971961829e-103, -8.9589789687104559e+102 }, { -4.9835974755489796e-206, -2.3774948293206117e+02 }, 3.90625e-03 },
        /* 57 */ { { -9.9671949510973086e-206, -8.9589789687104559e+102 }, { -1.1125369292536664e-308, -2.3774948293206117e+02 }, 3.90625e-03 },
        /* 58 */ { { -min, -8.9589789687104559e+102 }, { zero, -2.3774948293206117e+02 }, 3.90625e-03 },
        /* 59 */ { { zero, -8.9589789687104559e+102 }, { zero, -2.3774948293206117e+02 }, 3.90625e-03 },
        /* 60 */ { { min, -8.9589789687104559e+102 }, { zero, -2.3774948293206117e+02 }, 3.90625e-03 },
        /* 61 */ { { 9.9671949510973086e-206, -8.9589789687104559e+102 }, { 1.1125369292536664e-308, -2.3774948293206117e+02 }, 3.90625e-03 },
        /* 62 */ { { 4.4647944971961829e-103, -8.9589789687104559e+102 }, { 4.9835974755489796e-206, -2.3774948293206117e+02 }, 3.90625e-03 },
        /* 63 */ { { 1.9999999999998694e+00, -8.9589789687104559e+102 }, { 2.2323972485982374e-103, -2.3774948293206117e+02 }, 3.90625e-03 },
        /* 64 */ { { 8.9589789687104559e+102, -8.9589789687104559e+102 }, { pi_4, -2.3809605652234112e+02 }, 3.90625e-03 },
        /* 65 */ { { 4.0131652080900752e+205, -8.9589789687104559e+102 }, { pi_2, -4.741126715030025e+02 }, 1.953125e-03 },
        /* 66 */ { { max, -8.9589789687104559e+102 }, { pi_2, -7.1047586007394398e+02 }, 9.765625e-04 },
        /* 67 */ { { inf, -8.9589789687104559e+102 }, { pi_2, -inf }, 1.e+00 },
        /* 68 */ { { -inf, -1.9999999999998694e+00 }, { -pi_2, -inf }, 1.e+00 },
        /* 69 */ { { -max, -1.9999999999998694e+00 }, { -pi_2, -7.1047586007394398e+02 }, 9.765625e-04 },
        /* 70 */ { { -4.0131652080900752e+205, -1.9999999999998694e+00 }, { -pi_2, -4.741126715030025e+02 }, 1.953125e-03 },
        /* 71 */ { { -8.9589789687104559e+102, -1.9999999999998694e+00 }, { -pi_2, -2.3774948293206117e+02 }, 3.90625e-03 },
        /* 72 */ { { -1.9999999999998694e+00, -1.9999999999998694e+00 }, { -7.5424914469804205e-01, -1.7343245214879015e+00 }, 5.e-01 },
        /* 73 */ { { -4.4647944971961829e-103, -1.9999999999998694e+00 }, { -1.996716800259636e-103, -1.4436354751787519e+00 }, 5.e-01 },
        /* 74 */ { { -9.9671949510973086e-206, -1.9999999999998694e+00 }, { -4.4574650911294878e-206, -1.4436354751787519e+00 }, 5.e-01 },
        /* 75 */ { { -min, -1.9999999999998694e+00 }, { zero, -1.4436354751787519e+00 }, 5.e-01 },
        /* 76 */ { { zero, -1.9999999999998694e+00 }, { zero, -1.4436354751787519e+00 }, 5.e-01 },
        /* 77 */ { { min, -1.9999999999998694e+00 }, { zero, -1.4436354751787519e+00 }, 5.e-01 },
        /* 78 */ { { 9.9671949510973086e-206, -1.9999999999998694e+00 }, { 4.4574650911294878e-206, -1.4436354751787519e+00 }, 5.e-01 },
        /* 79 */ { { 4.4647944971961829e-103, -1.9999999999998694e+00 }, { 1.996716800259636e-103, -1.4436354751787519e+00 }, 5.e-01 },
        /* 80 */ { { 1.9999999999998694e+00, -1.9999999999998694e+00 }, { 7.5424914469804205e-01, -1.7343245214879015e+00 }, 5.e-01 },
        /* 81 */ { { 8.9589789687104559e+102, -1.9999999999998694e+00 }, { pi_2, -2.3774948293206117e+02 }, 3.90625e-03 },
        /* 82 */ { { 4.0131652080900752e+205, -1.9999999999998694e+00 }, { pi_2, -4.741126715030025e+02 }, 1.953125e-03 },
        /* 83 */ { { max, -1.9999999999998694e+00 }, { pi_2, -7.1047586007394398e+02 }, 9.765625e-04 },
        /* 84 */ { { inf, -1.9999999999998694e+00 }, { pi_2, -inf }, 1.e+00 },
        /* 85 */ { { -inf, -4.4647944971961829e-103 }, { -pi_2, -inf }, 1.e+00 },
        /* 86 */ { { -max, -4.4647944971961829e-103 }, { -pi_2, -7.1047586007394398e+02 }, 9.765625e-04 },
        /* 87 */ { { -4.0131652080900752e+205, -4.4647944971961829e-103 }, { -pi_2, -4.741126715030025e+02 }, 1.953125e-03 },
        /* 88 */ { { -8.9589789687104559e+102, -4.4647944971961829e-103 }, { -pi_2, -2.3774948293206117e+02 }, 3.90625e-03 },
        /* 89 */ { { -1.9999999999998694e+00, -4.4647944971961829e-103 }, { -pi_2, -1.3169578969247413e+00 }, 2.5e-01 },
        /* 90 */ { { -4.4647944971961829e-103, -4.4647944971961829e-103 }, { -4.4647944971961829e-103, -4.4647944971961829e-103 }, 1.1198723710889021e+102 },
        /* 91 */ { { -9.9671949510973086e-206, -4.4647944971961829e-103 }, { -9.9671949510973086e-206, -4.4647944971961829e-103 }, 2.2397447421778042e+102 },
        /* 92 */ { { -min, -4.4647944971961829e-103 }, { -min, -4.4647944971961829e-103 }, 2.2397447421778042e+102 },
        /* 93 */ { { zero, -4.4647944971961829e-103 }, { zero, -4.4647944971961829e-103 }, 2.2397447421778042e+102 },
        /* 94 */ { { min, -4.4647944971961829e-103 }, { min, -4.4647944971961829e-103 }, 2.2397447421778042e+102 },
        /* 95 */ { { 9.9671949510973086e-206, -4.4647944971961829e-103 }, { 9.9671949510973086e-206, -4.4647944971961829e-103 }, 2.2397447421778042e+102 },
        /* 96 */ { { 4.4647944971961829e-103, -4.4647944971961829e-103 }, { 4.4647944971961829e-103, -4.4647944971961829e-103 }, 1.1198723710889021e+102 },
        /* 97 */ { { 1.9999999999998694e+00, -4.4647944971961829e-103 }, { pi_2, -1.3169578969247413e+00 }, 2.5e-01 },
        /* 98 */ { { 8.9589789687104559e+102, -4.4647944971961829e-103 }, { pi_2, -2.3774948293206117e+02 }, 3.90625e-03 },
        /* 99 */ { { 4.0131652080900752e+205, -4.4647944971961829e-103 }, { pi_2, -4.741126715030025e+02 }, 1.953125e-03 },
        /* 100 */ { { max, -4.4647944971961829e-103 }, { pi_2, -7.1047586007394398e+02 }, 9.765625e-04 },
        /* 101 */ { { inf, -4.4647944971961829e-103 }, { pi_2, -inf }, 1.e+00 },
        /* 102 */ { { -inf, -9.9671949510973086e-206 }, { -pi_2, -inf }, 1.e+00 },
        /* 103 */ { { -max, -9.9671949510973086e-206 }, { -pi_2, -7.1047586007394398e+02 }, 9.765625e-04 },
        /* 104 */ { { -4.0131652080900752e+205, -9.9671949510973086e-206 }, { -pi_2, -4.741126715030025e+02 }, 1.953125e-03 },
        /* 105 */ { { -8.9589789687104559e+102, -9.9671949510973086e-206 }, { -pi_2, -2.3774948293206117e+02 }, 3.90625e-03 },
        /* 106 */ { { -1.9999999999998694e+00, -9.9671949510973086e-206 }, { -pi_2, -1.3169578969247413e+00 }, 2.5e-01 },
        /* 107 */ { { -4.4647944971961829e-103, -9.9671949510973086e-206 }, { -4.4647944971961829e-103, -9.9671949510973086e-206 }, 2.2397447421778042e+102 },
        /* 108 */ { { -9.9671949510973086e-206, -9.9671949510973086e-206 }, { -9.9671949510973086e-206, -9.9671949510973086e-206 }, 5.0164565101131187e+204 },
        /* 109 */ { { -min, -9.9671949510973086e-206 }, { -min, -9.9671949510973086e-206 }, 1.0032913020226237e+205 },
        /* 110 */ { { zero, -9.9671949510973086e-206 }, { zero, -9.9671949510973086e-206 }, 1.0032913020226237e+205 },
        /* 111 */ { { min, -9.9671949510973086e-206 }, { min, -9.9671949510973086e-206 }, 1.0032913020226237e+205 },
        /* 112 */ { { 9.9671949510973086e-206, -9.9671949510973086e-206 }, { 9.9671949510973086e-206, -9.9671949510973086e-206 }, 5.0164565101131187e+204 },
        /* 113 */ { { 4.4647944971961829e-103, -9.9671949510973086e-206 }, { 4.4647944971961829e-103, -9.9671949510973086e-206 }, 2.2397447421778042e+102 },
        /* 114 */ { { 1.9999999999998694e+00, -9.9671949510973086e-206 }, { pi_2, -1.3169578969247413e+00 }, 2.5e-01 },
        /* 115 */ { { 8.9589789687104559e+102, -9.9671949510973086e-206 }, { pi_2, -2.3774948293206117e+02 }, 3.90625e-03 },
        /* 116 */ { { 4.0131652080900752e+205, -9.9671949510973086e-206 }, { pi_2, -4.741126715030025e+02 }, 1.953125e-03 },
        /* 117 */ { { max, -9.9671949510973086e-206 }, { pi_2, -7.1047586007394398e+02 }, 9.765625e-04 },
        /* 118 */ { { inf, -9.9671949510973086e-206 }, { pi_2, -inf }, 1.e+00 },
        /* 119 */ { { -inf, -min }, { -pi_2, -inf }, 1.e+00 },
        /* 120 */ { { -max, -min }, { -pi_2, -7.1047586007394398e+02 }, 9.765625e-04 },
        /* 121 */ { { -4.0131652080900752e+205, -min }, { -pi_2, -4.741126715030025e+02 }, 1.953125e-03 },
        /* 122 */ { { -8.9589789687104559e+102, -min }, { -pi_2, -2.3774948293206117e+02 }, 3.90625e-03 },
        /* 123 */ { { -1.9999999999998694e+00, -min }, { -pi_2, -1.3169578969247413e+00 }, 2.5e-01 },
        /* 124 */ { { -4.4647944971961829e-103, -min }, { -4.4647944971961829e-103, -min }, 2.2397447421778042e+102 },
        /* 125 */ { { -9.9671949510973086e-206, -min }, { -9.9671949510973086e-206, -min }, 1.0032913020226237e+205 },
        /* 126 */ { { -min, -min }, { -min, -min }, 2.2471164185778949e+307 },
        /* 127 */ { { zero, -min }, { zero, -min }, 2.2471164185778949e+307 },
        /* 128 */ { { min, -min }, { min, -min }, 2.2471164185778949e+307 },
        /* 129 */ { { 9.9671949510973086e-206, -min }, { 9.9671949510973086e-206, -min }, 1.0032913020226237e+205 },
        /* 130 */ { { 4.4647944971961829e-103, -min }, { 4.4647944971961829e-103, -min }, 2.2397447421778042e+102 },
        /* 131 */ { { 1.9999999999998694e+00, -min }, { pi_2, -1.3169578969247413e+00 }, 2.5e-01 },
        /* 132 */ { { 8.9589789687104559e+102, -min }, { pi_2, -2.3774948293206117e+02 }, 3.90625e-03 },
        /* 133 */ { { 4.0131652080900752e+205, -min }, { pi_2, -4.741126715030025e+02 }, 1.953125e-03 },
        /* 134 */ { { max, -min }, { pi_2, -7.1047586007394398e+02 }, 9.765625e-04 },
        /* 135 */ { { inf, -min }, { pi_2, -inf }, 1.e+00 },
        /* 136 */ { { -inf, zero }, { -pi_2, inf }, 1.e+00 },
        /* 137 */ { { -max, zero }, { -pi_2, 7.1047586007394398e+02 }, 9.765625e-04 },
        /* 138 */ { { -4.0131652080900752e+205, zero }, { -pi_2, 4.741126715030025e+02 }, 1.953125e-03 },
        /* 139 */ { { -8.9589789687104559e+102, zero }, { -pi_2, 2.3774948293206117e+02 }, 3.90625e-03 },
        /* 140 */ { { -1.9999999999998694e+00, zero }, { -pi_2, 1.3169578969247413e+00 }, 2.5e-01 },
        /* 141 */ { { -4.4647944971961829e-103, zero }, { -4.4647944971961829e-103, zero }, 2.2397447421778042e+102 },
        /* 142 */ { { -9.9671949510973086e-206, zero }, { -9.9671949510973086e-206, zero }, 1.0032913020226237e+205 },
        /* 143 */ { { -min, zero }, { -min, zero }, 2.2471164185778949e+307 },
        /* 144 */ { { zero, zero }, { zero, zero }, 1.e+00 },
        /* 145 */ { { min, zero }, { min, zero }, 2.2471164185778949e+307 },
        /* 146 */ { { 9.9671949510973086e-206, zero }, { 9.9671949510973086e-206, zero }, 1.0032913020226237e+205 },
        /* 147 */ { { 4.4647944971961829e-103, zero }, { 4.4647944971961829e-103, zero }, 2.2397447421778042e+102 },
        /* 148 */ { { 1.9999999999998694e+00, zero }, { pi_2, 1.3169578969247413e+00 }, 2.5e-01 },
        /* 149 */ { { 8.9589789687104559e+102, zero }, { pi_2, 2.3774948293206117e+02 }, 3.90625e-03 },
        /* 150 */ { { 4.0131652080900752e+205, zero }, { pi_2, 4.741126715030025e+02 }, 1.953125e-03 },
        /* 151 */ { { max, zero }, { pi_2, 7.1047586007394398e+02 }, 9.765625e-04 },
        /* 152 */ { { inf, zero }, { pi_2, inf }, 1.e+00 },
        /* 153 */ { { -inf, min }, { -pi_2, inf }, 1.e+00 },
        /* 154 */ { { -max, min }, { -pi_2, 7.1047586007394398e+02 }, 9.765625e-04 },
        /* 155 */ { { -4.0131652080900752e+205, min }, { -pi_2, 4.741126715030025e+02 }, 1.953125e-03 },
        /* 156 */ { { -8.9589789687104559e+102, min }, { -pi_2, 2.3774948293206117e+02 }, 3.90625e-03 },
        /* 157 */ { { -1.9999999999998694e+00, min }, { -pi_2, 1.3169578969247413e+00 }, 2.5e-01 },
        /* 158 */ { { -4.4647944971961829e-103, min }, { -4.4647944971961829e-103, min }, 2.2397447421778042e+102 },
        /* 159 */ { { -9.9671949510973086e-206, min }, { -9.9671949510973086e-206, min }, 1.0032913020226237e+205 },
        /* 160 */ { { -min, min }, { -min, min }, 2.2471164185778949e+307 },
        /* 161 */ { { zero, min }, { zero, min }, 2.2471164185778949e+307 },
        /* 162 */ { { min, min }, { min, min }, 2.2471164185778949e+307 },
        /* 163 */ { { 9.9671949510973086e-206, min }, { 9.9671949510973086e-206, min }, 1.0032913020226237e+205 },
        /* 164 */ { { 4.4647944971961829e-103, min }, { 4.4647944971961829e-103, min }, 2.2397447421778042e+102 },
        /* 165 */ { { 1.9999999999998694e+00, min }, { pi_2, 1.3169578969247413e+00 }, 2.5e-01 },
        /* 166 */ { { 8.9589789687104559e+102, min }, { pi_2, 2.3774948293206117e+02 }, 3.90625e-03 },
        /* 167 */ { { 4.0131652080900752e+205, min }, { pi_2, 4.741126715030025e+02 }, 1.953125e-03 },
        /* 168 */ { { max, min }, { pi_2, 7.1047586007394398e+02 }, 9.765625e-04 },
        /* 169 */ { { inf, min }, { pi_2, inf }, 1.e+00 },
        /* 170 */ { { -inf, 9.9671949510973086e-206 }, { -pi_2, inf }, 1.e+00 },
        /* 171 */ { { -max, 9.9671949510973086e-206 }, { -pi_2, 7.1047586007394398e+02 }, 9.765625e-04 },
        /* 172 */ { { -4.0131652080900752e+205, 9.9671949510973086e-206 }, { -pi_2, 4.741126715030025e+02 }, 1.953125e-03 },
        /* 173 */ { { -8.9589789687104559e+102, 9.9671949510973086e-206 }, { -pi_2, 2.3774948293206117e+02 }, 3.90625e-03 },
        /* 174 */ { { -1.9999999999998694e+00, 9.9671949510973086e-206 }, { -pi_2, 1.3169578969247413e+00 }, 2.5e-01 },
        /* 175 */ { { -4.4647944971961829e-103, 9.9671949510973086e-206 }, { -4.4647944971961829e-103, 9.9671949510973086e-206 }, 2.2397447421778042e+102 },
        /* 176 */ { { -9.9671949510973086e-206, 9.9671949510973086e-206 }, { -9.9671949510973086e-206, 9.9671949510973086e-206 }, 5.0164565101131187e+204 },
        /* 177 */ { { -min, 9.9671949510973086e-206 }, { -min, 9.9671949510973086e-206 }, 1.0032913020226237e+205 },
        /* 178 */ { { zero, 9.9671949510973086e-206 }, { zero, 9.9671949510973086e-206 }, 1.0032913020226237e+205 },
        /* 179 */ { { min, 9.9671949510973086e-206 }, { min, 9.9671949510973086e-206 }, 1.0032913020226237e+205 },
        /* 180 */ { { 9.9671949510973086e-206, 9.9671949510973086e-206 }, { 9.9671949510973086e-206, 9.9671949510973086e-206 }, 5.0164565101131187e+204 },
        /* 181 */ { { 4.4647944971961829e-103, 9.9671949510973086e-206 }, { 4.4647944971961829e-103, 9.9671949510973086e-206 }, 2.2397447421778042e+102 },
        /* 182 */ { { 1.9999999999998694e+00, 9.9671949510973086e-206 }, { pi_2, 1.3169578969247413e+00 }, 2.5e-01 },
        /* 183 */ { { 8.9589789687104559e+102, 9.9671949510973086e-206 }, { pi_2, 2.3774948293206117e+02 }, 3.90625e-03 },
        /* 184 */ { { 4.0131652080900752e+205, 9.9671949510973086e-206 }, { pi_2, 4.741126715030025e+02 }, 1.953125e-03 },
        /* 185 */ { { max, 9.9671949510973086e-206 }, { pi_2, 7.1047586007394398e+02 }, 9.765625e-04 },
        /* 186 */ { { inf, 9.9671949510973086e-206 }, { pi_2, inf }, 1.e+00 },
        /* 187 */ { { -inf, 4.4647944971961829e-103 }, { -pi_2, inf }, 1.e+00 },
        /* 188 */ { { -max, 4.4647944971961829e-103 }, { -pi_2, 7.1047586007394398e+02 }, 9.765625e-04 },
        /* 189 */ { { -4.0131652080900752e+205, 4.4647944971961829e-103 }, { -pi_2, 4.741126715030025e+02 }, 1.953125e-03 },
        /* 190 */ { { -8.9589789687104559e+102, 4.4647944971961829e-103 }, { -pi_2, 2.3774948293206117e+02 }, 3.90625e-03 },
        /* 191 */ { { -1.9999999999998694e+00, 4.4647944971961829e-103 }, { -pi_2, 1.3169578969247413e+00 }, 2.5e-01 },
        /* 192 */ { { -4.4647944971961829e-103, 4.4647944971961829e-103 }, { -4.4647944971961829e-103, 4.4647944971961829e-103 }, 1.1198723710889021e+102 },
        /* 193 */ { { -9.9671949510973086e-206, 4.4647944971961829e-103 }, { -9.9671949510973086e-206, 4.4647944971961829e-103 }, 2.2397447421778042e+102 },
        /* 194 */ { { -min, 4.4647944971961829e-103 }, { -min, 4.4647944971961829e-103 }, 2.2397447421778042e+102 },
        /* 195 */ { { zero, 4.4647944971961829e-103 }, { zero, 4.4647944971961829e-103 }, 2.2397447421778042e+102 },
        /* 196 */ { { min, 4.4647944971961829e-103 }, { min, 4.4647944971961829e-103 }, 2.2397447421778042e+102 },
        /* 197 */ { { 9.9671949510973086e-206, 4.4647944971961829e-103 }, { 9.9671949510973086e-206, 4.4647944971961829e-103 }, 2.2397447421778042e+102 },
        /* 198 */ { { 4.4647944971961829e-103, 4.4647944971961829e-103 }, { 4.4647944971961829e-103, 4.4647944971961829e-103 }, 1.1198723710889021e+102 },
        /* 199 */ { { 1.9999999999998694e+00, 4.4647944971961829e-103 }, { pi_2, 1.3169578969247413e+00 }, 2.5e-01 },
        /* 200 */ { { 8.9589789687104559e+102, 4.4647944971961829e-103 }, { pi_2, 2.3774948293206117e+02 }, 3.90625e-03 },
        /* 201 */ { { 4.0131652080900752e+205, 4.4647944971961829e-103 }, { pi_2, 4.741126715030025e+02 }, 1.953125e-03 },
        /* 202 */ { { max, 4.4647944971961829e-103 }, { pi_2, 7.1047586007394398e+02 }, 9.765625e-04 },
        /* 203 */ { { inf, 4.4647944971961829e-103 }, { pi_2, inf }, 1.e+00 },
        /* 204 */ { { -inf, 1.9999999999998694e+00 }, { -pi_2, inf }, 1.e+00 },
        /* 205 */ { { -max, 1.9999999999998694e+00 }, { -pi_2, 7.1047586007394398e+02 }, 9.765625e-04 },
        /* 206 */ { { -4.0131652080900752e+205, 1.9999999999998694e+00 }, { -pi_2, 4.741126715030025e+02 }, 1.953125e-03 },
        /* 207 */ { { -8.9589789687104559e+102, 1.9999999999998694e+00 }, { -pi_2, 2.3774948293206117e+02 }, 3.90625e-03 },
        /* 208 */ { { -1.9999999999998694e+00, 1.9999999999998694e+00 }, { -7.5424914469804205e-01, 1.7343245214879015e+00 }, 5.e-01 },
        /* 209 */ { { -4.4647944971961829e-103, 1.9999999999998694e+00 }, { -1.996716800259636e-103, 1.4436354751787519e+00 }, 5.e-01 },
        /* 210 */ { { -9.9671949510973086e-206, 1.9999999999998694e+00 }, { -4.4574650911294878e-206, 1.4436354751787519e+00 }, 5.e-01 },
        /* 211 */ { { -min, 1.9999999999998694e+00 }, { zero, 1.4436354751787519e+00 }, 5.e-01 },
        /* 212 */ { { zero, 1.9999999999998694e+00 }, { zero, 1.4436354751787519e+00 }, 5.e-01 },
        /* 213 */ { { min, 1.9999999999998694e+00 }, { zero, 1.4436354751787519e+00 }, 5.e-01 },
        /* 214 */ { { 9.9671949510973086e-206, 1.9999999999998694e+00 }, { 4.4574650911294878e-206, 1.4436354751787519e+00 }, 5.e-01 },
        /* 215 */ { { 4.4647944971961829e-103, 1.9999999999998694e+00 }, { 1.996716800259636e-103, 1.4436354751787519e+00 }, 5.e-01 },
        /* 216 */ { { 1.9999999999998694e+00, 1.9999999999998694e+00 }, { 7.5424914469804205e-01, 1.7343245214879015e+00 }, 5.e-01 },
        /* 217 */ { { 8.9589789687104559e+102, 1.9999999999998694e+00 }, { pi_2, 2.3774948293206117e+02 }, 3.90625e-03 },
        /* 218 */ { { 4.0131652080900752e+205, 1.9999999999998694e+00 }, { pi_2, 4.741126715030025e+02 }, 1.953125e-03 },
        /* 219 */ { { max, 1.9999999999998694e+00 }, { pi_2, 7.1047586007394398e+02 }, 9.765625e-04 },
        /* 220 */ { { inf, 1.9999999999998694e+00 }, { pi_2, inf }, 1.e+00 },
        /* 221 */ { { -inf, 8.9589789687104559e+102 }, { -pi_2, inf }, 1.e+00 },
        /* 222 */ { { -max, 8.9589789687104559e+102 }, { -pi_2, 7.1047586007394398e+02 }, 9.765625e-04 },
        /* 223 */ { { -4.0131652080900752e+205, 8.9589789687104559e+102 }, { -pi_2, 4.741126715030025e+02 }, 1.953125e-03 },
        /* 224 */ { { -8.9589789687104559e+102, 8.9589789687104559e+102 }, { -pi_4, 2.3809605652234112e+02 }, 3.90625e-03 },
        /* 225 */ { { -1.9999999999998694e+00, 8.9589789687104559e+102 }, { -2.2323972485982374e-103, 2.3774948293206117e+02 }, 3.90625e-03 },
        /* 226 */ { { -4.4647944971961829e-103, 8.9589789687104559e+102 }, { -4.9835974755489796e-206, 2.3774948293206117e+02 }, 3.90625e-03 },
        /* 227 */ { { -9.9671949510973086e-206, 8.9589789687104559e+102 }, { -1.1125369292536664e-308, 2.3774948293206117e+02 }, 3.90625e-03 },
        /* 228 */ { { -min, 8.9589789687104559e+102 }, { zero, 2.3774948293206117e+02 }, 3.90625e-03 },
        /* 229 */ { { zero, 8.9589789687104559e+102 }, { zero, 2.3774948293206117e+02 }, 3.90625e-03 },
        /* 230 */ { { min, 8.9589789687104559e+102 }, { zero, 2.3774948293206117e+02 }, 3.90625e-03 },
        /* 231 */ { { 9.9671949510973086e-206, 8.9589789687104559e+102 }, { 1.1125369292536664e-308, 2.3774948293206117e+02 }, 3.90625e-03 },
        /* 232 */ { { 4.4647944971961829e-103, 8.9589789687104559e+102 }, { 4.9835974755489796e-206, 2.3774948293206117e+02 }, 3.90625e-03 },
        /* 233 */ { { 1.9999999999998694e+00, 8.9589789687104559e+102 }, { 2.2323972485982374e-103, 2.3774948293206117e+02 }, 3.90625e-03 },
        /* 234 */ { { 8.9589789687104559e+102, 8.9589789687104559e+102 }, { pi_4, 2.3809605652234112e+02 }, 3.90625e-03 },
        /* 235 */ { { 4.0131652080900752e+205, 8.9589789687104559e+102 }, { pi_2, 4.741126715030025e+02 }, 1.953125e-03 },
        /* 236 */ { { max, 8.9589789687104559e+102 }, { pi_2, 7.1047586007394398e+02 }, 9.765625e-04 },
        /* 237 */ { { inf, 8.9589789687104559e+102 }, { pi_2, inf }, 1.e+00 },
        /* 238 */ { { -inf, 4.0131652080900752e+205 }, { -pi_2, inf }, 1.e+00 },
        /* 239 */ { { -max, 4.0131652080900752e+205 }, { -pi_2, 7.1047586007394398e+02 }, 9.765625e-04 },
        /* 240 */ { { -4.0131652080900752e+205, 4.0131652080900752e+205 }, { -pi_4, 4.7445924509328245e+02 }, 1.953125e-03 },
        /* 241 */ { { -8.9589789687104559e+102, 4.0131652080900752e+205 }, { -2.2323972485982374e-103, 4.741126715030025e+02 }, 1.953125e-03 },
        /* 242 */ { { -1.9999999999998694e+00, 4.0131652080900752e+205 }, { -4.9835974755489796e-206, 4.741126715030025e+02 }, 1.953125e-03 },
        /* 243 */ { { -4.4647944971961829e-103, 4.0131652080900752e+205 }, { -1.1125369292536664e-308, 4.741126715030025e+02 }, 1.953125e-03 },
        /* 244 */ { { -9.9671949510973086e-206, 4.0131652080900752e+205 }, { zero, 4.741126715030025e+02 }, 1.953125e-03 },
        /* 245 */ { { -min, 4.0131652080900752e+205 }, { zero, 4.741126715030025e+02 }, 1.953125e-03 },
        /* 246 */ { { zero, 4.0131652080900752e+205 }, { zero, 4.741126715030025e+02 }, 1.953125e-03 },
        /* 247 */ { { min, 4.0131652080900752e+205 }, { zero, 4.741126715030025e+02 }, 1.953125e-03 },
        /* 248 */ { { 9.9671949510973086e-206, 4.0131652080900752e+205 }, { zero, 4.741126715030025e+02 }, 1.953125e-03 },
        /* 249 */ { { 4.4647944971961829e-103, 4.0131652080900752e+205 }, { 1.1125369292536664e-308, 4.741126715030025e+02 }, 1.953125e-03 },
        /* 250 */ { { 1.9999999999998694e+00, 4.0131652080900752e+205 }, { 4.9835974755489796e-206, 4.741126715030025e+02 }, 1.953125e-03 },
        /* 251 */ { { 8.9589789687104559e+102, 4.0131652080900752e+205 }, { 2.2323972485982374e-103, 4.741126715030025e+02 }, 1.953125e-03 },
        /* 252 */ { { 4.0131652080900752e+205, 4.0131652080900752e+205 }, { pi_4, 4.7445924509328245e+02 }, 1.953125e-03 },
        /* 253 */ { { max, 4.0131652080900752e+205 }, { pi_2, 7.1047586007394398e+02 }, 9.765625e-04 },
        /* 254 */ { { inf, 4.0131652080900752e+205 }, { pi_2, inf }, 1.e+00 },
        /* 255 */ { { -inf, max }, { -pi_2, inf }, 1.e+00 },
        /* 256 */ { { -max, max }, { -pi_4, 7.1082243366422392e+02 }, 9.765625e-04 },
        /* 257 */ { { -4.0131652080900752e+205, max }, { -2.2323972485979601e-103, 7.1047586007394398e+02 }, 9.765625e-04 },
        /* 258 */ { { -8.9589789687104559e+102, max }, { -4.9835974755483611e-206, 7.1047586007394398e+02 }, 9.765625e-04 },
        /* 259 */ { { -1.9999999999998694e+00, max }, { zero, 7.1047586007394398e+02 }, 9.765625e-04 },
        /* 260 */ { { -4.4647944971961829e-103, max }, { zero, 7.1047586007394398e+02 }, 9.765625e-04 },
        /* 261 */ { { -9.9671949510973086e-206, max }, { zero, 7.1047586007394398e+02 }, 9.765625e-04 },
        /* 262 */ { { -min, max }, { zero, 7.1047586007394398e+02 }, 9.765625e-04 },
        /* 263 */ { { zero, max }, { zero, 7.1047586007394398e+02 }, 9.765625e-04 },
        /* 264 */ { { min, max }, { zero, 7.1047586007394398e+02 }, 9.765625e-04 },
        /* 265 */ { { 9.9671949510973086e-206, max }, { zero, 7.1047586007394398e+02 }, 9.765625e-04 },
        /* 266 */ { { 4.4647944971961829e-103, max }, { zero, 7.1047586007394398e+02 }, 9.765625e-04 },
        /* 267 */ { { 1.9999999999998694e+00, max }, { zero, 7.1047586007394398e+02 }, 9.765625e-04 },
        /* 268 */ { { 8.9589789687104559e+102, max }, { 4.9835974755483611e-206, 7.1047586007394398e+02 }, 9.765625e-04 },
        /* 269 */ { { 4.0131652080900752e+205, max }, { 2.2323972485979601e-103, 7.1047586007394398e+02 }, 9.765625e-04 },
        /* 270 */ { { max, max }, { pi_4, 7.1082243366422392e+02 }, 9.765625e-04 },
        /* 271 */ { { inf, max }, { pi_2, inf }, 1.e+00 },
        /* 272 */ { { -inf, inf }, { -pi_4, inf }, 1.e+00 },
        /* 273 */ { { -max, inf }, { zero, inf }, 1.e+00 },
        /* 274 */ { { -4.0131652080900752e+205, inf }, { zero, inf }, 1.e+00 },
        /* 275 */ { { -8.9589789687104559e+102, inf }, { zero, inf }, 1.e+00 },
        /* 276 */ { { -1.9999999999998694e+00, inf }, { zero, inf }, 1.e+00 },
        /* 277 */ { { -4.4647944971961829e-103, inf }, { zero, inf }, 1.e+00 },
        /* 278 */ { { -9.9671949510973086e-206, inf }, { zero, inf }, 1.e+00 },
        /* 279 */ { { -min, inf }, { zero, inf }, 1.e+00 },
        /* 280 */ { { zero, inf }, { zero, inf }, 1.e+00 },
        /* 281 */ { { min, inf }, { zero, inf }, 1.e+00 },
        /* 282 */ { { 9.9671949510973086e-206, inf }, { zero, inf }, 1.e+00 },
        /* 283 */ { { 4.4647944971961829e-103, inf }, { zero, inf }, 1.e+00 },
        /* 284 */ { { 1.9999999999998694e+00, inf }, { zero, inf }, 1.e+00 },
        /* 285 */ { { 8.9589789687104559e+102, inf }, { zero, inf }, 1.e+00 },
        /* 286 */ { { 4.0131652080900752e+205, inf }, { zero, inf }, 1.e+00 },
        /* 287 */ { { max, inf }, { zero, inf }, 1.e+00 },
        /* 288 */ { { inf, inf }, { pi_4, inf }, 1.e+00 }
          // clang-format on
      };
      return table;
    } else {
      static_assert(dependent_false<T>); /* unreachable */
    }
  }
};

template <typename T, int default_dps_deficiency = 0>
struct Asinh {
  typedef std::complex<T> InputType;
  typedef std::complex<T> OutputType;
  typedef T FloatType;
  using TableType = std::vector<std::tuple<InputType, OutputType, FloatType>>;
  static constexpr int dps_deficiency = default_dps_deficiency;
  const TableType get() {
    if constexpr (std::is_same_v<T, float>) {
      const T pi_4 = 0.7853982f;
      const T pi_2 = 1.5707964f;
      const T zero = 0.0f;
      const T inf = std::numeric_limits<T>::infinity();
#ifdef __aarch64__
      const T min = std::nextafter(std::numeric_limits<T>::min(), T(1));
#else
      const T min = std::numeric_limits<T>::min();
#endif
      const T max = std::numeric_limits<T>::max();
      const TableType table{
          // clang-format off
          // Ignore max 80 character line width style requirement for
          // (i) the readability
          // (ii) the consistency with the local conventions
        /* 0 */ { { -inf, -inf }, { -inf, -pi_4 }, 1.e+00f },
        /* 1 */ { { -max, -inf }, { -inf, -pi_2 }, 1.e+00f },
        /* 2 */ { { -6.1409603e+25f, -inf }, { -inf, -pi_2 }, 1.e+00f },
        /* 3 */ { { -1.1082383e+13f, -inf }, { -inf, -pi_2 }, 1.e+00f },
        /* 4 */ { { -2.e+00f, -inf }, { -inf, -pi_2 }, 1.e+00f },
        /* 5 */ { { -3.6093321e-13f, -inf }, { -inf, -pi_2 }, 1.e+00f },
        /* 6 */ { { -6.5136393e-26f, -inf }, { -inf, -pi_2 }, 1.e+00f },
        /* 7 */ { { -min, -inf }, { -inf, -pi_2 }, 1.e+00f },
        /* 8 */ { { zero, -inf }, { inf, -pi_2 }, 1.e+00f },
        /* 9 */ { { min, -inf }, { inf, -pi_2 }, 1.e+00f },
        /* 10 */ { { 6.5136393e-26f, -inf }, { inf, -pi_2 }, 1.e+00f },
        /* 11 */ { { 3.6093321e-13f, -inf }, { inf, -pi_2 }, 1.e+00f },
        /* 12 */ { { 2.e+00f, -inf }, { inf, -pi_2 }, 1.e+00f },
        /* 13 */ { { 1.1082383e+13f, -inf }, { inf, -pi_2 }, 1.e+00f },
        /* 14 */ { { 6.1409603e+25f, -inf }, { inf, -pi_2 }, 1.e+00f },
        /* 15 */ { { max, -inf }, { inf, -pi_2 }, 1.e+00f },
        /* 16 */ { { inf, -inf }, { inf, -pi_4 }, 1.e+00f },
        /* 17 */ { { -inf, -max }, { -inf, zero }, 1.e+00f },
        /* 18 */ { { -max, -max }, { -8.9762558e+01f, -pi_4 }, 7.8125e-03f },
        /* 19 */ { { -6.1409603e+25f, -max }, { -8.9415985e+01f, -pi_2 }, 7.8125e-03f },
        /* 20 */ { { -1.1082383e+13f, -max }, { -8.9415985e+01f, -pi_2 }, 7.8125e-03f },
        /* 21 */ { { -2.e+00f, -max }, { -8.9415985e+01f, -pi_2 }, 7.8125e-03f },
        /* 22 */ { { -3.6093321e-13f, -max }, { -8.9415985e+01f, -pi_2 }, 7.8125e-03f },
        /* 23 */ { { -6.5136393e-26f, -max }, { -8.9415985e+01f, -pi_2 }, 7.8125e-03f },
        /* 24 */ { { -min, -max }, { -8.9415985e+01f, -pi_2 }, 7.8125e-03f },
        /* 25 */ { { zero, -max }, { 8.9415985e+01f, -pi_2 }, 7.8125e-03f },
        /* 26 */ { { min, -max }, { 8.9415985e+01f, -pi_2 }, 7.8125e-03f },
        /* 27 */ { { 6.5136393e-26f, -max }, { 8.9415985e+01f, -pi_2 }, 7.8125e-03f },
        /* 28 */ { { 3.6093321e-13f, -max }, { 8.9415985e+01f, -pi_2 }, 7.8125e-03f },
        /* 29 */ { { 2.e+00f, -max }, { 8.9415985e+01f, -pi_2 }, 7.8125e-03f },
        /* 30 */ { { 1.1082383e+13f, -max }, { 8.9415985e+01f, -pi_2 }, 7.8125e-03f },
        /* 31 */ { { 6.1409603e+25f, -max }, { 8.9415985e+01f, -pi_2 }, 7.8125e-03f },
        /* 32 */ { { max, -max }, { 8.9762558e+01f, -pi_4 }, 7.8125e-03f },
        /* 33 */ { { inf, -max }, { inf, zero }, 1.e+00f },
        /* 34 */ { { -inf, -6.1409603e+25f }, { -inf, zero }, 1.e+00f },
        /* 35 */ { { -max, -6.1409603e+25f }, { -8.9415985e+01f, -1.8046662e-13f }, 7.8125e-03f },
        /* 36 */ { { -6.1409603e+25f, -6.1409603e+25f }, { -6.0419331e+01f, -pi_4 }, 1.5625e-02f },
        /* 37 */ { { -1.1082383e+13f, -6.1409603e+25f }, { -6.0072754e+01f, -pi_2 }, 1.5625e-02f },
        /* 38 */ { { -2.e+00f, -6.1409603e+25f }, { -6.0072754e+01f, -pi_2 }, 1.5625e-02f },
        /* 39 */ { { -3.6093321e-13f, -6.1409603e+25f }, { -6.0072754e+01f, -pi_2 }, 1.5625e-02f },
        /* 40 */ { { -6.5136393e-26f, -6.1409603e+25f }, { -6.0072754e+01f, -pi_2 }, 1.5625e-02f },
        /* 41 */ { { -min, -6.1409603e+25f }, { -6.0072754e+01f, -pi_2 }, 1.5625e-02f },
        /* 42 */ { { zero, -6.1409603e+25f }, { 6.0072754e+01f, -pi_2 }, 1.5625e-02f },
        /* 43 */ { { min, -6.1409603e+25f }, { 6.0072754e+01f, -pi_2 }, 1.5625e-02f },
        /* 44 */ { { 6.5136393e-26f, -6.1409603e+25f }, { 6.0072754e+01f, -pi_2 }, 1.5625e-02f },
        /* 45 */ { { 3.6093321e-13f, -6.1409603e+25f }, { 6.0072754e+01f, -pi_2 }, 1.5625e-02f },
        /* 46 */ { { 2.e+00f, -6.1409603e+25f }, { 6.0072754e+01f, -pi_2 }, 1.5625e-02f },
        /* 47 */ { { 1.1082383e+13f, -6.1409603e+25f }, { 6.0072754e+01f, -pi_2 }, 1.5625e-02f },
        /* 48 */ { { 6.1409603e+25f, -6.1409603e+25f }, { 6.0419331e+01f, -pi_4 }, 1.5625e-02f },
        /* 49 */ { { max, -6.1409603e+25f }, { 8.9415985e+01f, -1.8046662e-13f }, 7.8125e-03f },
        /* 50 */ { { inf, -6.1409603e+25f }, { inf, zero }, 1.e+00f },
        /* 51 */ { { -inf, -1.1082383e+13f }, { -inf, zero }, 1.e+00f },
        /* 52 */ { { -max, -1.1082383e+13f }, { -8.9415985e+01f, -3.25682e-26f }, 7.8125e-03f },
        /* 53 */ { { -6.1409603e+25f, -1.1082383e+13f }, { -6.0072754e+01f, -1.8046662e-13f }, 1.5625e-02f },
        /* 54 */ { { -1.1082383e+13f, -1.1082383e+13f }, { -3.1076099e+01f, -pi_4 }, 3.125e-02f },
        /* 55 */ { { -2.e+00f, -1.1082383e+13f }, { -3.0729525e+01f, -pi_2 }, 3.125e-02f },
        /* 56 */ { { -3.6093321e-13f, -1.1082383e+13f }, { -3.0729525e+01f, -pi_2 }, 3.125e-02f },
        /* 57 */ { { -6.5136393e-26f, -1.1082383e+13f }, { -3.0729525e+01f, -pi_2 }, 3.125e-02f },
        /* 58 */ { { -min, -1.1082383e+13f }, { -3.0729525e+01f, -pi_2 }, 3.125e-02f },
        /* 59 */ { { zero, -1.1082383e+13f }, { 3.0729525e+01f, -pi_2 }, 3.125e-02f },
        /* 60 */ { { min, -1.1082383e+13f }, { 3.0729525e+01f, -pi_2 }, 3.125e-02f },
        /* 61 */ { { 6.5136393e-26f, -1.1082383e+13f }, { 3.0729525e+01f, -pi_2 }, 3.125e-02f },
        /* 62 */ { { 3.6093321e-13f, -1.1082383e+13f }, { 3.0729525e+01f, -pi_2 }, 3.125e-02f },
        /* 63 */ { { 2.e+00f, -1.1082383e+13f }, { 3.0729525e+01f, -pi_2 }, 3.125e-02f },
        /* 64 */ { { 1.1082383e+13f, -1.1082383e+13f }, { 3.1076099e+01f, -pi_4 }, 3.125e-02f },
        /* 65 */ { { 6.1409603e+25f, -1.1082383e+13f }, { 6.0072754e+01f, -1.8046662e-13f }, 1.5625e-02f },
        /* 66 */ { { max, -1.1082383e+13f }, { 8.9415985e+01f, -3.25682e-26f }, 7.8125e-03f },
        /* 67 */ { { inf, -1.1082383e+13f }, { inf, zero }, 1.e+00f },
        /* 68 */ { { -inf, -2.e+00f }, { -inf, zero }, 1.e+00f },
        /* 69 */ { { -max, -2.e+00f }, { -8.9415985e+01f, -5.8774718e-39f }, 7.8125e-03f },
        /* 70 */ { { -6.1409603e+25f, -2.e+00f }, { -6.0072754e+01f, -3.2568196e-26f }, 1.5625e-02f },
        /* 71 */ { { -1.1082383e+13f, -2.e+00f }, { -3.0729525e+01f, -1.804666e-13f }, 3.125e-02f },
        /* 72 */ { { -2.e+00f, -2.e+00f }, { -1.7343246e+00f, -7.5424916e-01f }, 5.e-01f },
        /* 73 */ { { -3.6093321e-13f, -2.e+00f }, { -1.316958e+00f, -pi_2 }, 2.5e-01f },
        /* 74 */ { { -6.5136393e-26f, -2.e+00f }, { -1.316958e+00f, -pi_2 }, 2.5e-01f },
        /* 75 */ { { -min, -2.e+00f }, { -1.316958e+00f, -pi_2 }, 2.5e-01f },
        /* 76 */ { { zero, -2.e+00f }, { 1.316958e+00f, -pi_2 }, 2.5e-01f },
        /* 77 */ { { min, -2.e+00f }, { 1.316958e+00f, -pi_2 }, 2.5e-01f },
        /* 78 */ { { 6.5136393e-26f, -2.e+00f }, { 1.316958e+00f, -pi_2 }, 2.5e-01f },
        /* 79 */ { { 3.6093321e-13f, -2.e+00f }, { 1.316958e+00f, -pi_2 }, 2.5e-01f },
        /* 80 */ { { 2.e+00f, -2.e+00f }, { 1.7343246e+00f, -7.5424916e-01f }, 5.e-01f },
        /* 81 */ { { 1.1082383e+13f, -2.e+00f }, { 3.0729525e+01f, -1.804666e-13f }, 3.125e-02f },
        /* 82 */ { { 6.1409603e+25f, -2.e+00f }, { 6.0072754e+01f, -3.2568196e-26f }, 1.5625e-02f },
        /* 83 */ { { max, -2.e+00f }, { 8.9415985e+01f, -5.8774718e-39f }, 7.8125e-03f },
        /* 84 */ { { inf, -2.e+00f }, { inf, zero }, 1.e+00f },
        /* 85 */ { { -inf, -3.6093321e-13f }, { -inf, zero }, 1.e+00f },
        /* 86 */ { { -max, -3.6093321e-13f }, { -8.9415985e+01f, zero }, 7.8125e-03f },
        /* 87 */ { { -6.1409603e+25f, -3.6093321e-13f }, { -6.0072754e+01f, -5.8774718e-39f }, 1.5625e-02f },
        /* 88 */ { { -1.1082383e+13f, -3.6093321e-13f }, { -3.0729525e+01f, -3.2568193e-26f }, 3.125e-02f },
        /* 89 */ { { -2.e+00f, -3.6093321e-13f }, { -1.4436355e+00f, -1.6141424e-13f }, 5.e-01f },
        /* 90 */ { { -3.6093321e-13f, -3.6093321e-13f }, { -3.6093321e-13f, -3.6093321e-13f }, 1.0995116e+12f },
        /* 91 */ { { -6.5136393e-26f, -3.6093321e-13f }, { -6.5136393e-26f, -3.6093321e-13f }, 2.1990233e+12f },
        /* 92 */ { { -min, -3.6093321e-13f }, { -min, -3.6093321e-13f }, 2.1990233e+12f },
        /* 93 */ { { zero, -3.6093321e-13f }, { zero, -3.6093321e-13f }, 2.1990233e+12f },
        /* 94 */ { { min, -3.6093321e-13f }, { min, -3.6093321e-13f }, 2.1990233e+12f },
        /* 95 */ { { 6.5136393e-26f, -3.6093321e-13f }, { 6.5136393e-26f, -3.6093321e-13f }, 2.1990233e+12f },
        /* 96 */ { { 3.6093321e-13f, -3.6093321e-13f }, { 3.6093321e-13f, -3.6093321e-13f }, 1.0995116e+12f },
        /* 97 */ { { 2.e+00f, -3.6093321e-13f }, { 1.4436355e+00f, -1.6141424e-13f }, 5.e-01f },
        /* 98 */ { { 1.1082383e+13f, -3.6093321e-13f }, { 3.0729525e+01f, -3.2568193e-26f }, 3.125e-02f },
        /* 99 */ { { 6.1409603e+25f, -3.6093321e-13f }, { 6.0072754e+01f, -5.8774718e-39f }, 1.5625e-02f },
        /* 100 */ { { max, -3.6093321e-13f }, { 8.9415985e+01f, zero }, 7.8125e-03f },
        /* 101 */ { { inf, -3.6093321e-13f }, { inf, zero }, 1.e+00f },
        /* 102 */ { { -inf, -6.5136393e-26f }, { -inf, zero }, 1.e+00f },
        /* 103 */ { { -max, -6.5136393e-26f }, { -8.9415985e+01f, zero }, 7.8125e-03f },
        /* 104 */ { { -6.1409603e+25f, -6.5136393e-26f }, { -6.0072754e+01f, zero }, 1.5625e-02f },
        /* 105 */ { { -1.1082383e+13f, -6.5136393e-26f }, { -3.0729525e+01f, -5.8774718e-39f }, 3.125e-02f },
        /* 106 */ { { -2.e+00f, -6.5136393e-26f }, { -1.4436355e+00f, -2.9129881e-26f }, 5.e-01f },
        /* 107 */ { { -3.6093321e-13f, -6.5136393e-26f }, { -3.6093321e-13f, -6.5136393e-26f }, 2.1990233e+12f },
        /* 108 */ { { -6.5136393e-26f, -6.5136393e-26f }, { -6.5136393e-26f, -6.5136393e-26f }, 9.6714066e+24f },
        /* 109 */ { { -min, -6.5136393e-26f }, { -min, -6.5136393e-26f }, 9.6714066e+24f },
        /* 110 */ { { zero, -6.5136393e-26f }, { zero, -6.5136393e-26f }, 9.6714066e+24f },
        /* 111 */ { { min, -6.5136393e-26f }, { min, -6.5136393e-26f }, 9.6714066e+24f },
        /* 112 */ { { 6.5136393e-26f, -6.5136393e-26f }, { 6.5136393e-26f, -6.5136393e-26f }, 9.6714066e+24f },
        /* 113 */ { { 3.6093321e-13f, -6.5136393e-26f }, { 3.6093321e-13f, -6.5136393e-26f }, 2.1990233e+12f },
        /* 114 */ { { 2.e+00f, -6.5136393e-26f }, { 1.4436355e+00f, -2.9129881e-26f }, 5.e-01f },
        /* 115 */ { { 1.1082383e+13f, -6.5136393e-26f }, { 3.0729525e+01f, -5.8774718e-39f }, 3.125e-02f },
        /* 116 */ { { 6.1409603e+25f, -6.5136393e-26f }, { 6.0072754e+01f, zero }, 1.5625e-02f },
        /* 117 */ { { max, -6.5136393e-26f }, { 8.9415985e+01f, zero }, 7.8125e-03f },
        /* 118 */ { { inf, -6.5136393e-26f }, { inf, zero }, 1.e+00f },
        /* 119 */ { { -inf, -min }, { -inf, zero }, 1.e+00f },
        /* 120 */ { { -max, -min }, { -8.9415985e+01f, zero }, 7.8125e-03f },
        /* 121 */ { { -6.1409603e+25f, -min }, { -6.0072754e+01f, zero }, 1.5625e-02f },
        /* 122 */ { { -1.1082383e+13f, -min }, { -3.0729525e+01f, zero }, 3.125e-02f },
        /* 123 */ { { -2.e+00f, -min }, { -1.4436355e+00f, zero }, 5.e-01f },
        /* 124 */ { { -3.6093321e-13f, -min }, { -3.6093321e-13f, -min }, 2.1990233e+12f },
        /* 125 */ { { -6.5136393e-26f, -min }, { -6.5136393e-26f, -min }, 9.6714066e+24f },
        /* 126 */ { { -min, -min }, { -min, -min }, 4.2535296e+37f },
        /* 127 */ { { zero, -min }, { zero, -min }, 4.2535296e+37f },
        /* 128 */ { { min, -min }, { min, -min }, 4.2535296e+37f },
        /* 129 */ { { 6.5136393e-26f, -min }, { 6.5136393e-26f, -min }, 9.6714066e+24f },
        /* 130 */ { { 3.6093321e-13f, -min }, { 3.6093321e-13f, -min }, 2.1990233e+12f },
        /* 131 */ { { 2.e+00f, -min }, { 1.4436355e+00f, zero }, 5.e-01f },
        /* 132 */ { { 1.1082383e+13f, -min }, { 3.0729525e+01f, zero }, 3.125e-02f },
        /* 133 */ { { 6.1409603e+25f, -min }, { 6.0072754e+01f, zero }, 1.5625e-02f },
        /* 134 */ { { max, -min }, { 8.9415985e+01f, zero }, 7.8125e-03f },
        /* 135 */ { { inf, -min }, { inf, zero }, 1.e+00f },
        /* 136 */ { { -inf, zero }, { -inf, zero }, 1.e+00f },
        /* 137 */ { { -max, zero }, { -8.9415985e+01f, zero }, 7.8125e-03f },
        /* 138 */ { { -6.1409603e+25f, zero }, { -6.0072754e+01f, zero }, 1.5625e-02f },
        /* 139 */ { { -1.1082383e+13f, zero }, { -3.0729525e+01f, zero }, 3.125e-02f },
        /* 140 */ { { -2.e+00f, zero }, { -1.4436355e+00f, zero }, 5.e-01f },
        /* 141 */ { { -3.6093321e-13f, zero }, { -3.6093321e-13f, zero }, 2.1990233e+12f },
        /* 142 */ { { -6.5136393e-26f, zero }, { -6.5136393e-26f, zero }, 9.6714066e+24f },
        /* 143 */ { { -min, zero }, { -min, zero }, 4.2535296e+37f },
        /* 144 */ { { zero, zero }, { zero, zero }, 1.e+00f },
        /* 145 */ { { min, zero }, { min, zero }, 4.2535296e+37f },
        /* 146 */ { { 6.5136393e-26f, zero }, { 6.5136393e-26f, zero }, 9.6714066e+24f },
        /* 147 */ { { 3.6093321e-13f, zero }, { 3.6093321e-13f, zero }, 2.1990233e+12f },
        /* 148 */ { { 2.e+00f, zero }, { 1.4436355e+00f, zero }, 5.e-01f },
        /* 149 */ { { 1.1082383e+13f, zero }, { 3.0729525e+01f, zero }, 3.125e-02f },
        /* 150 */ { { 6.1409603e+25f, zero }, { 6.0072754e+01f, zero }, 1.5625e-02f },
        /* 151 */ { { max, zero }, { 8.9415985e+01f, zero }, 7.8125e-03f },
        /* 152 */ { { inf, zero }, { inf, zero }, 1.e+00f },
        /* 153 */ { { -inf, min }, { -inf, zero }, 1.e+00f },
        /* 154 */ { { -max, min }, { -8.9415985e+01f, zero }, 7.8125e-03f },
        /* 155 */ { { -6.1409603e+25f, min }, { -6.0072754e+01f, zero }, 1.5625e-02f },
        /* 156 */ { { -1.1082383e+13f, min }, { -3.0729525e+01f, zero }, 3.125e-02f },
        /* 157 */ { { -2.e+00f, min }, { -1.4436355e+00f, zero }, 5.e-01f },
        /* 158 */ { { -3.6093321e-13f, min }, { -3.6093321e-13f, min }, 2.1990233e+12f },
        /* 159 */ { { -6.5136393e-26f, min }, { -6.5136393e-26f, min }, 9.6714066e+24f },
        /* 160 */ { { -min, min }, { -min, min }, 4.2535296e+37f },
        /* 161 */ { { zero, min }, { zero, min }, 4.2535296e+37f },
        /* 162 */ { { min, min }, { min, min }, 4.2535296e+37f },
        /* 163 */ { { 6.5136393e-26f, min }, { 6.5136393e-26f, min }, 9.6714066e+24f },
        /* 164 */ { { 3.6093321e-13f, min }, { 3.6093321e-13f, min }, 2.1990233e+12f },
        /* 165 */ { { 2.e+00f, min }, { 1.4436355e+00f, zero }, 5.e-01f },
        /* 166 */ { { 1.1082383e+13f, min }, { 3.0729525e+01f, zero }, 3.125e-02f },
        /* 167 */ { { 6.1409603e+25f, min }, { 6.0072754e+01f, zero }, 1.5625e-02f },
        /* 168 */ { { max, min }, { 8.9415985e+01f, zero }, 7.8125e-03f },
        /* 169 */ { { inf, min }, { inf, zero }, 1.e+00f },
        /* 170 */ { { -inf, 6.5136393e-26f }, { -inf, zero }, 1.e+00f },
        /* 171 */ { { -max, 6.5136393e-26f }, { -8.9415985e+01f, zero }, 7.8125e-03f },
        /* 172 */ { { -6.1409603e+25f, 6.5136393e-26f }, { -6.0072754e+01f, zero }, 1.5625e-02f },
        /* 173 */ { { -1.1082383e+13f, 6.5136393e-26f }, { -3.0729525e+01f, 5.8774718e-39f }, 3.125e-02f },
        /* 174 */ { { -2.e+00f, 6.5136393e-26f }, { -1.4436355e+00f, 2.9129881e-26f }, 5.e-01f },
        /* 175 */ { { -3.6093321e-13f, 6.5136393e-26f }, { -3.6093321e-13f, 6.5136393e-26f }, 2.1990233e+12f },
        /* 176 */ { { -6.5136393e-26f, 6.5136393e-26f }, { -6.5136393e-26f, 6.5136393e-26f }, 9.6714066e+24f },
        /* 177 */ { { -min, 6.5136393e-26f }, { -min, 6.5136393e-26f }, 9.6714066e+24f },
        /* 178 */ { { zero, 6.5136393e-26f }, { zero, 6.5136393e-26f }, 9.6714066e+24f },
        /* 179 */ { { min, 6.5136393e-26f }, { min, 6.5136393e-26f }, 9.6714066e+24f },
        /* 180 */ { { 6.5136393e-26f, 6.5136393e-26f }, { 6.5136393e-26f, 6.5136393e-26f }, 9.6714066e+24f },
        /* 181 */ { { 3.6093321e-13f, 6.5136393e-26f }, { 3.6093321e-13f, 6.5136393e-26f }, 2.1990233e+12f },
        /* 182 */ { { 2.e+00f, 6.5136393e-26f }, { 1.4436355e+00f, 2.9129881e-26f }, 5.e-01f },
        /* 183 */ { { 1.1082383e+13f, 6.5136393e-26f }, { 3.0729525e+01f, 5.8774718e-39f }, 3.125e-02f },
        /* 184 */ { { 6.1409603e+25f, 6.5136393e-26f }, { 6.0072754e+01f, zero }, 1.5625e-02f },
        /* 185 */ { { max, 6.5136393e-26f }, { 8.9415985e+01f, zero }, 7.8125e-03f },
        /* 186 */ { { inf, 6.5136393e-26f }, { inf, zero }, 1.e+00f },
        /* 187 */ { { -inf, 3.6093321e-13f }, { -inf, zero }, 1.e+00f },
        /* 188 */ { { -max, 3.6093321e-13f }, { -8.9415985e+01f, zero }, 7.8125e-03f },
        /* 189 */ { { -6.1409603e+25f, 3.6093321e-13f }, { -6.0072754e+01f, 5.8774718e-39f }, 1.5625e-02f },
        /* 190 */ { { -1.1082383e+13f, 3.6093321e-13f }, { -3.0729525e+01f, 3.2568193e-26f }, 3.125e-02f },
        /* 191 */ { { -2.e+00f, 3.6093321e-13f }, { -1.4436355e+00f, 1.6141424e-13f }, 5.e-01f },
        /* 192 */ { { -3.6093321e-13f, 3.6093321e-13f }, { -3.6093321e-13f, 3.6093321e-13f }, 1.0995116e+12f },
        /* 193 */ { { -6.5136393e-26f, 3.6093321e-13f }, { -6.5136393e-26f, 3.6093321e-13f }, 2.1990233e+12f },
        /* 194 */ { { -min, 3.6093321e-13f }, { -min, 3.6093321e-13f }, 2.1990233e+12f },
        /* 195 */ { { zero, 3.6093321e-13f }, { zero, 3.6093321e-13f }, 2.1990233e+12f },
        /* 196 */ { { min, 3.6093321e-13f }, { min, 3.6093321e-13f }, 2.1990233e+12f },
        /* 197 */ { { 6.5136393e-26f, 3.6093321e-13f }, { 6.5136393e-26f, 3.6093321e-13f }, 2.1990233e+12f },
        /* 198 */ { { 3.6093321e-13f, 3.6093321e-13f }, { 3.6093321e-13f, 3.6093321e-13f }, 1.0995116e+12f },
        /* 199 */ { { 2.e+00f, 3.6093321e-13f }, { 1.4436355e+00f, 1.6141424e-13f }, 5.e-01f },
        /* 200 */ { { 1.1082383e+13f, 3.6093321e-13f }, { 3.0729525e+01f, 3.2568193e-26f }, 3.125e-02f },
        /* 201 */ { { 6.1409603e+25f, 3.6093321e-13f }, { 6.0072754e+01f, 5.8774718e-39f }, 1.5625e-02f },
        /* 202 */ { { max, 3.6093321e-13f }, { 8.9415985e+01f, zero }, 7.8125e-03f },
        /* 203 */ { { inf, 3.6093321e-13f }, { inf, zero }, 1.e+00f },
        /* 204 */ { { -inf, 2.e+00f }, { -inf, zero }, 1.e+00f },
        /* 205 */ { { -max, 2.e+00f }, { -8.9415985e+01f, 5.8774718e-39f }, 7.8125e-03f },
        /* 206 */ { { -6.1409603e+25f, 2.e+00f }, { -6.0072754e+01f, 3.2568196e-26f }, 1.5625e-02f },
        /* 207 */ { { -1.1082383e+13f, 2.e+00f }, { -3.0729525e+01f, 1.804666e-13f }, 3.125e-02f },
        /* 208 */ { { -2.e+00f, 2.e+00f }, { -1.7343246e+00f, 7.5424916e-01f }, 5.e-01f },
        /* 209 */ { { -3.6093321e-13f, 2.e+00f }, { -1.316958e+00f, pi_2 }, 2.5e-01f },
        /* 210 */ { { -6.5136393e-26f, 2.e+00f }, { -1.316958e+00f, pi_2 }, 2.5e-01f },
        /* 211 */ { { -min, 2.e+00f }, { -1.316958e+00f, pi_2 }, 2.5e-01f },
        /* 212 */ { { zero, 2.e+00f }, { 1.316958e+00f, pi_2 }, 2.5e-01f },
        /* 213 */ { { min, 2.e+00f }, { 1.316958e+00f, pi_2 }, 2.5e-01f },
        /* 214 */ { { 6.5136393e-26f, 2.e+00f }, { 1.316958e+00f, pi_2 }, 2.5e-01f },
        /* 215 */ { { 3.6093321e-13f, 2.e+00f }, { 1.316958e+00f, pi_2 }, 2.5e-01f },
        /* 216 */ { { 2.e+00f, 2.e+00f }, { 1.7343246e+00f, 7.5424916e-01f }, 5.e-01f },
        /* 217 */ { { 1.1082383e+13f, 2.e+00f }, { 3.0729525e+01f, 1.804666e-13f }, 3.125e-02f },
        /* 218 */ { { 6.1409603e+25f, 2.e+00f }, { 6.0072754e+01f, 3.2568196e-26f }, 1.5625e-02f },
        /* 219 */ { { max, 2.e+00f }, { 8.9415985e+01f, 5.8774718e-39f }, 7.8125e-03f },
        /* 220 */ { { inf, 2.e+00f }, { inf, zero }, 1.e+00f },
        /* 221 */ { { -inf, 1.1082383e+13f }, { -inf, zero }, 1.e+00f },
        /* 222 */ { { -max, 1.1082383e+13f }, { -8.9415985e+01f, 3.25682e-26f }, 7.8125e-03f },
        /* 223 */ { { -6.1409603e+25f, 1.1082383e+13f }, { -6.0072754e+01f, 1.8046662e-13f }, 1.5625e-02f },
        /* 224 */ { { -1.1082383e+13f, 1.1082383e+13f }, { -3.1076099e+01f, pi_4 }, 3.125e-02f },
        /* 225 */ { { -2.e+00f, 1.1082383e+13f }, { -3.0729525e+01f, pi_2 }, 3.125e-02f },
        /* 226 */ { { -3.6093321e-13f, 1.1082383e+13f }, { -3.0729525e+01f, pi_2 }, 3.125e-02f },
        /* 227 */ { { -6.5136393e-26f, 1.1082383e+13f }, { -3.0729525e+01f, pi_2 }, 3.125e-02f },
        /* 228 */ { { -min, 1.1082383e+13f }, { -3.0729525e+01f, pi_2 }, 3.125e-02f },
        /* 229 */ { { zero, 1.1082383e+13f }, { 3.0729525e+01f, pi_2 }, 3.125e-02f },
        /* 230 */ { { min, 1.1082383e+13f }, { 3.0729525e+01f, pi_2 }, 3.125e-02f },
        /* 231 */ { { 6.5136393e-26f, 1.1082383e+13f }, { 3.0729525e+01f, pi_2 }, 3.125e-02f },
        /* 232 */ { { 3.6093321e-13f, 1.1082383e+13f }, { 3.0729525e+01f, pi_2 }, 3.125e-02f },
        /* 233 */ { { 2.e+00f, 1.1082383e+13f }, { 3.0729525e+01f, pi_2 }, 3.125e-02f },
        /* 234 */ { { 1.1082383e+13f, 1.1082383e+13f }, { 3.1076099e+01f, pi_4 }, 3.125e-02f },
        /* 235 */ { { 6.1409603e+25f, 1.1082383e+13f }, { 6.0072754e+01f, 1.8046662e-13f }, 1.5625e-02f },
        /* 236 */ { { max, 1.1082383e+13f }, { 8.9415985e+01f, 3.25682e-26f }, 7.8125e-03f },
        /* 237 */ { { inf, 1.1082383e+13f }, { inf, zero }, 1.e+00f },
        /* 238 */ { { -inf, 6.1409603e+25f }, { -inf, zero }, 1.e+00f },
        /* 239 */ { { -max, 6.1409603e+25f }, { -8.9415985e+01f, 1.8046662e-13f }, 7.8125e-03f },
        /* 240 */ { { -6.1409603e+25f, 6.1409603e+25f }, { -6.0419331e+01f, pi_4 }, 1.5625e-02f },
        /* 241 */ { { -1.1082383e+13f, 6.1409603e+25f }, { -6.0072754e+01f, pi_2 }, 1.5625e-02f },
        /* 242 */ { { -2.e+00f, 6.1409603e+25f }, { -6.0072754e+01f, pi_2 }, 1.5625e-02f },
        /* 243 */ { { -3.6093321e-13f, 6.1409603e+25f }, { -6.0072754e+01f, pi_2 }, 1.5625e-02f },
        /* 244 */ { { -6.5136393e-26f, 6.1409603e+25f }, { -6.0072754e+01f, pi_2 }, 1.5625e-02f },
        /* 245 */ { { -min, 6.1409603e+25f }, { -6.0072754e+01f, pi_2 }, 1.5625e-02f },
        /* 246 */ { { zero, 6.1409603e+25f }, { 6.0072754e+01f, pi_2 }, 1.5625e-02f },
        /* 247 */ { { min, 6.1409603e+25f }, { 6.0072754e+01f, pi_2 }, 1.5625e-02f },
        /* 248 */ { { 6.5136393e-26f, 6.1409603e+25f }, { 6.0072754e+01f, pi_2 }, 1.5625e-02f },
        /* 249 */ { { 3.6093321e-13f, 6.1409603e+25f }, { 6.0072754e+01f, pi_2 }, 1.5625e-02f },
        /* 250 */ { { 2.e+00f, 6.1409603e+25f }, { 6.0072754e+01f, pi_2 }, 1.5625e-02f },
        /* 251 */ { { 1.1082383e+13f, 6.1409603e+25f }, { 6.0072754e+01f, pi_2 }, 1.5625e-02f },
        /* 252 */ { { 6.1409603e+25f, 6.1409603e+25f }, { 6.0419331e+01f, pi_4 }, 1.5625e-02f },
        /* 253 */ { { max, 6.1409603e+25f }, { 8.9415985e+01f, 1.8046662e-13f }, 7.8125e-03f },
        /* 254 */ { { inf, 6.1409603e+25f }, { inf, zero }, 1.e+00f },
        /* 255 */ { { -inf, max }, { -inf, zero }, 1.e+00f },
        /* 256 */ { { -max, max }, { -8.9762558e+01f, pi_4 }, 7.8125e-03f },
        /* 257 */ { { -6.1409603e+25f, max }, { -8.9415985e+01f, pi_2 }, 7.8125e-03f },
        /* 258 */ { { -1.1082383e+13f, max }, { -8.9415985e+01f, pi_2 }, 7.8125e-03f },
        /* 259 */ { { -2.e+00f, max }, { -8.9415985e+01f, pi_2 }, 7.8125e-03f },
        /* 260 */ { { -3.6093321e-13f, max }, { -8.9415985e+01f, pi_2 }, 7.8125e-03f },
        /* 261 */ { { -6.5136393e-26f, max }, { -8.9415985e+01f, pi_2 }, 7.8125e-03f },
        /* 262 */ { { -min, max }, { -8.9415985e+01f, pi_2 }, 7.8125e-03f },
        /* 263 */ { { zero, max }, { 8.9415985e+01f, pi_2 }, 7.8125e-03f },
        /* 264 */ { { min, max }, { 8.9415985e+01f, pi_2 }, 7.8125e-03f },
        /* 265 */ { { 6.5136393e-26f, max }, { 8.9415985e+01f, pi_2 }, 7.8125e-03f },
        /* 266 */ { { 3.6093321e-13f, max }, { 8.9415985e+01f, pi_2 }, 7.8125e-03f },
        /* 267 */ { { 2.e+00f, max }, { 8.9415985e+01f, pi_2 }, 7.8125e-03f },
        /* 268 */ { { 1.1082383e+13f, max }, { 8.9415985e+01f, pi_2 }, 7.8125e-03f },
        /* 269 */ { { 6.1409603e+25f, max }, { 8.9415985e+01f, pi_2 }, 7.8125e-03f },
        /* 270 */ { { max, max }, { 8.9762558e+01f, pi_4 }, 7.8125e-03f },
        /* 271 */ { { inf, max }, { inf, zero }, 1.e+00f },
        /* 272 */ { { -inf, inf }, { -inf, pi_4 }, 1.e+00f },
        /* 273 */ { { -max, inf }, { -inf, pi_2 }, 1.e+00f },
        /* 274 */ { { -6.1409603e+25f, inf }, { -inf, pi_2 }, 1.e+00f },
        /* 275 */ { { -1.1082383e+13f, inf }, { -inf, pi_2 }, 1.e+00f },
        /* 276 */ { { -2.e+00f, inf }, { -inf, pi_2 }, 1.e+00f },
        /* 277 */ { { -3.6093321e-13f, inf }, { -inf, pi_2 }, 1.e+00f },
        /* 278 */ { { -6.5136393e-26f, inf }, { -inf, pi_2 }, 1.e+00f },
        /* 279 */ { { -min, inf }, { -inf, pi_2 }, 1.e+00f },
        /* 280 */ { { zero, inf }, { inf, pi_2 }, 1.e+00f },
        /* 281 */ { { min, inf }, { inf, pi_2 }, 1.e+00f },
        /* 282 */ { { 6.5136393e-26f, inf }, { inf, pi_2 }, 1.e+00f },
        /* 283 */ { { 3.6093321e-13f, inf }, { inf, pi_2 }, 1.e+00f },
        /* 284 */ { { 2.e+00f, inf }, { inf, pi_2 }, 1.e+00f },
        /* 285 */ { { 1.1082383e+13f, inf }, { inf, pi_2 }, 1.e+00f },
        /* 286 */ { { 6.1409603e+25f, inf }, { inf, pi_2 }, 1.e+00f },
        /* 287 */ { { max, inf }, { inf, pi_2 }, 1.e+00f },
        /* 288 */ { { inf, inf }, { inf, pi_4 }, 1.e+00f }
          // clang-format on
      };
      return table;
    } else if constexpr (std::is_same_v<T, double>) {
      const T pi_4 = 0.7853981633974483;
      const T pi_2 = 1.5707963267948966;
      const T zero = 0.0;
      const T inf = std::numeric_limits<T>::infinity();
#ifdef __aarch64__
      const T min = std::nextafter(std::numeric_limits<T>::min(), T(1));
#else
      const T min = std::numeric_limits<T>::min();
#endif
      const T max = std::numeric_limits<T>::max();
      const TableType table{
          // clang-format off
          // Ignore max 80 character line width style requirement for
          // (i) the readability
          // (ii) the consistency with the local conventions
        /* 0 */ { { -inf, -inf }, { -inf, -pi_4 }, 1.e+00 },
        /* 1 */ { { -max, -inf }, { -inf, -pi_2 }, 1.e+00 },
        /* 2 */ { { -4.0131652080900752e+205, -inf }, { -inf, -pi_2 }, 1.e+00 },
        /* 3 */ { { -8.9589789687104559e+102, -inf }, { -inf, -pi_2 }, 1.e+00 },
        /* 4 */ { { -1.9999999999998694e+00, -inf }, { -inf, -pi_2 }, 1.e+00 },
        /* 5 */ { { -4.4647944971961829e-103, -inf }, { -inf, -pi_2 }, 1.e+00 },
        /* 6 */ { { -9.9671949510973086e-206, -inf }, { -inf, -pi_2 }, 1.e+00 },
        /* 7 */ { { -min, -inf }, { -inf, -pi_2 }, 1.e+00 },
        /* 8 */ { { zero, -inf }, { inf, -pi_2 }, 1.e+00 },
        /* 9 */ { { min, -inf }, { inf, -pi_2 }, 1.e+00 },
        /* 10 */ { { 9.9671949510973086e-206, -inf }, { inf, -pi_2 }, 1.e+00 },
        /* 11 */ { { 4.4647944971961829e-103, -inf }, { inf, -pi_2 }, 1.e+00 },
        /* 12 */ { { 1.9999999999998694e+00, -inf }, { inf, -pi_2 }, 1.e+00 },
        /* 13 */ { { 8.9589789687104559e+102, -inf }, { inf, -pi_2 }, 1.e+00 },
        /* 14 */ { { 4.0131652080900752e+205, -inf }, { inf, -pi_2 }, 1.e+00 },
        /* 15 */ { { max, -inf }, { inf, -pi_2 }, 1.e+00 },
        /* 16 */ { { inf, -inf }, { inf, -pi_4 }, 1.e+00 },
        /* 17 */ { { -inf, -max }, { -inf, zero }, 1.e+00 },
        /* 18 */ { { -max, -max }, { -7.1082243366422392e+02, -pi_4 }, 9.765625e-04 },
        /* 19 */ { { -4.0131652080900752e+205, -max }, { -7.1047586007394398e+02, -pi_2 }, 9.765625e-04 },
        /* 20 */ { { -8.9589789687104559e+102, -max }, { -7.1047586007394398e+02, -pi_2 }, 9.765625e-04 },
        /* 21 */ { { -1.9999999999998694e+00, -max }, { -7.1047586007394398e+02, -pi_2 }, 9.765625e-04 },
        /* 22 */ { { -4.4647944971961829e-103, -max }, { -7.1047586007394398e+02, -pi_2 }, 9.765625e-04 },
        /* 23 */ { { -9.9671949510973086e-206, -max }, { -7.1047586007394398e+02, -pi_2 }, 9.765625e-04 },
        /* 24 */ { { -min, -max }, { -7.1047586007394398e+02, -pi_2 }, 9.765625e-04 },
        /* 25 */ { { zero, -max }, { 7.1047586007394398e+02, -pi_2 }, 9.765625e-04 },
        /* 26 */ { { min, -max }, { 7.1047586007394398e+02, -pi_2 }, 9.765625e-04 },
        /* 27 */ { { 9.9671949510973086e-206, -max }, { 7.1047586007394398e+02, -pi_2 }, 9.765625e-04 },
        /* 28 */ { { 4.4647944971961829e-103, -max }, { 7.1047586007394398e+02, -pi_2 }, 9.765625e-04 },
        /* 29 */ { { 1.9999999999998694e+00, -max }, { 7.1047586007394398e+02, -pi_2 }, 9.765625e-04 },
        /* 30 */ { { 8.9589789687104559e+102, -max }, { 7.1047586007394398e+02, -pi_2 }, 9.765625e-04 },
        /* 31 */ { { 4.0131652080900752e+205, -max }, { 7.1047586007394398e+02, -pi_2 }, 9.765625e-04 },
        /* 32 */ { { max, -max }, { 7.1082243366422392e+02, -pi_4 }, 9.765625e-04 },
        /* 33 */ { { inf, -max }, { inf, zero }, 1.e+00 },
        /* 34 */ { { -inf, -4.0131652080900752e+205 }, { -inf, zero }, 1.e+00 },
        /* 35 */ { { -max, -4.0131652080900752e+205 }, { -7.1047586007394398e+02, -2.2323972485979601e-103 }, 9.765625e-04 },
        /* 36 */ { { -4.0131652080900752e+205, -4.0131652080900752e+205 }, { -4.7445924509328245e+02, -pi_4 }, 1.953125e-03 },
        /* 37 */ { { -8.9589789687104559e+102, -4.0131652080900752e+205 }, { -4.741126715030025e+02, -pi_2 }, 1.953125e-03 },
        /* 38 */ { { -1.9999999999998694e+00, -4.0131652080900752e+205 }, { -4.741126715030025e+02, -pi_2 }, 1.953125e-03 },
        /* 39 */ { { -4.4647944971961829e-103, -4.0131652080900752e+205 }, { -4.741126715030025e+02, -pi_2 }, 1.953125e-03 },
        /* 40 */ { { -9.9671949510973086e-206, -4.0131652080900752e+205 }, { -4.741126715030025e+02, -pi_2 }, 1.953125e-03 },
        /* 41 */ { { -min, -4.0131652080900752e+205 }, { -4.741126715030025e+02, -pi_2 }, 1.953125e-03 },
        /* 42 */ { { zero, -4.0131652080900752e+205 }, { 4.741126715030025e+02, -pi_2 }, 1.953125e-03 },
        /* 43 */ { { min, -4.0131652080900752e+205 }, { 4.741126715030025e+02, -pi_2 }, 1.953125e-03 },
        /* 44 */ { { 9.9671949510973086e-206, -4.0131652080900752e+205 }, { 4.741126715030025e+02, -pi_2 }, 1.953125e-03 },
        /* 45 */ { { 4.4647944971961829e-103, -4.0131652080900752e+205 }, { 4.741126715030025e+02, -pi_2 }, 1.953125e-03 },
        /* 46 */ { { 1.9999999999998694e+00, -4.0131652080900752e+205 }, { 4.741126715030025e+02, -pi_2 }, 1.953125e-03 },
        /* 47 */ { { 8.9589789687104559e+102, -4.0131652080900752e+205 }, { 4.741126715030025e+02, -pi_2 }, 1.953125e-03 },
        /* 48 */ { { 4.0131652080900752e+205, -4.0131652080900752e+205 }, { 4.7445924509328245e+02, -pi_4 }, 1.953125e-03 },
        /* 49 */ { { max, -4.0131652080900752e+205 }, { 7.1047586007394398e+02, -2.2323972485979601e-103 }, 9.765625e-04 },
        /* 50 */ { { inf, -4.0131652080900752e+205 }, { inf, zero }, 1.e+00 },
        /* 51 */ { { -inf, -8.9589789687104559e+102 }, { -inf, zero }, 1.e+00 },
        /* 52 */ { { -max, -8.9589789687104559e+102 }, { -7.1047586007394398e+02, -4.9835974755483611e-206 }, 9.765625e-04 },
        /* 53 */ { { -4.0131652080900752e+205, -8.9589789687104559e+102 }, { -4.741126715030025e+02, -2.2323972485982374e-103 }, 1.953125e-03 },
        /* 54 */ { { -8.9589789687104559e+102, -8.9589789687104559e+102 }, { -2.3809605652234112e+02, -pi_4 }, 3.90625e-03 },
        /* 55 */ { { -1.9999999999998694e+00, -8.9589789687104559e+102 }, { -2.3774948293206117e+02, -pi_2 }, 3.90625e-03 },
        /* 56 */ { { -4.4647944971961829e-103, -8.9589789687104559e+102 }, { -2.3774948293206117e+02, -pi_2 }, 3.90625e-03 },
        /* 57 */ { { -9.9671949510973086e-206, -8.9589789687104559e+102 }, { -2.3774948293206117e+02, -pi_2 }, 3.90625e-03 },
        /* 58 */ { { -min, -8.9589789687104559e+102 }, { -2.3774948293206117e+02, -pi_2 }, 3.90625e-03 },
        /* 59 */ { { zero, -8.9589789687104559e+102 }, { 2.3774948293206117e+02, -pi_2 }, 3.90625e-03 },
        /* 60 */ { { min, -8.9589789687104559e+102 }, { 2.3774948293206117e+02, -pi_2 }, 3.90625e-03 },
        /* 61 */ { { 9.9671949510973086e-206, -8.9589789687104559e+102 }, { 2.3774948293206117e+02, -pi_2 }, 3.90625e-03 },
        /* 62 */ { { 4.4647944971961829e-103, -8.9589789687104559e+102 }, { 2.3774948293206117e+02, -pi_2 }, 3.90625e-03 },
        /* 63 */ { { 1.9999999999998694e+00, -8.9589789687104559e+102 }, { 2.3774948293206117e+02, -pi_2 }, 3.90625e-03 },
        /* 64 */ { { 8.9589789687104559e+102, -8.9589789687104559e+102 }, { 2.3809605652234112e+02, -pi_4 }, 3.90625e-03 },
        /* 65 */ { { 4.0131652080900752e+205, -8.9589789687104559e+102 }, { 4.741126715030025e+02, -2.2323972485982374e-103 }, 1.953125e-03 },
        /* 66 */ { { max, -8.9589789687104559e+102 }, { 7.1047586007394398e+02, -4.9835974755483611e-206 }, 9.765625e-04 },
        /* 67 */ { { inf, -8.9589789687104559e+102 }, { inf, zero }, 1.e+00 },
        /* 68 */ { { -inf, -1.9999999999998694e+00 }, { -inf, zero }, 1.e+00 },
        /* 69 */ { { -max, -1.9999999999998694e+00 }, { -7.1047586007394398e+02, zero }, 9.765625e-04 },
        /* 70 */ { { -4.0131652080900752e+205, -1.9999999999998694e+00 }, { -4.741126715030025e+02, -4.9835974755489796e-206 }, 1.953125e-03 },
        /* 71 */ { { -8.9589789687104559e+102, -1.9999999999998694e+00 }, { -2.3774948293206117e+02, -2.2323972485982374e-103 }, 3.90625e-03 },
        /* 72 */ { { -1.9999999999998694e+00, -1.9999999999998694e+00 }, { -1.7343245214879015e+00, -7.5424914469804205e-01 }, 5.e-01 },
        /* 73 */ { { -4.4647944971961829e-103, -1.9999999999998694e+00 }, { -1.3169578969247413e+00, -pi_2 }, 2.5e-01 },
        /* 74 */ { { -9.9671949510973086e-206, -1.9999999999998694e+00 }, { -1.3169578969247413e+00, -pi_2 }, 2.5e-01 },
        /* 75 */ { { -min, -1.9999999999998694e+00 }, { -1.3169578969247413e+00, -pi_2 }, 2.5e-01 },
        /* 76 */ { { zero, -1.9999999999998694e+00 }, { 1.3169578969247413e+00, -pi_2 }, 2.5e-01 },
        /* 77 */ { { min, -1.9999999999998694e+00 }, { 1.3169578969247413e+00, -pi_2 }, 2.5e-01 },
        /* 78 */ { { 9.9671949510973086e-206, -1.9999999999998694e+00 }, { 1.3169578969247413e+00, -pi_2 }, 2.5e-01 },
        /* 79 */ { { 4.4647944971961829e-103, -1.9999999999998694e+00 }, { 1.3169578969247413e+00, -pi_2 }, 2.5e-01 },
        /* 80 */ { { 1.9999999999998694e+00, -1.9999999999998694e+00 }, { 1.7343245214879015e+00, -7.5424914469804205e-01 }, 5.e-01 },
        /* 81 */ { { 8.9589789687104559e+102, -1.9999999999998694e+00 }, { 2.3774948293206117e+02, -2.2323972485982374e-103 }, 3.90625e-03 },
        /* 82 */ { { 4.0131652080900752e+205, -1.9999999999998694e+00 }, { 4.741126715030025e+02, -4.9835974755489796e-206 }, 1.953125e-03 },
        /* 83 */ { { max, -1.9999999999998694e+00 }, { 7.1047586007394398e+02, zero }, 9.765625e-04 },
        /* 84 */ { { inf, -1.9999999999998694e+00 }, { inf, zero }, 1.e+00 },
        /* 85 */ { { -inf, -4.4647944971961829e-103 }, { -inf, zero }, 1.e+00 },
        /* 86 */ { { -max, -4.4647944971961829e-103 }, { -7.1047586007394398e+02, zero }, 9.765625e-04 },
        /* 87 */ { { -4.0131652080900752e+205, -4.4647944971961829e-103 }, { -4.741126715030025e+02, -1.1125369292536664e-308 }, 1.953125e-03 },
        /* 88 */ { { -8.9589789687104559e+102, -4.4647944971961829e-103 }, { -2.3774948293206117e+02, -4.9835974755489796e-206 }, 3.90625e-03 },
        /* 89 */ { { -1.9999999999998694e+00, -4.4647944971961829e-103 }, { -1.4436354751787519e+00, -1.996716800259636e-103 }, 5.e-01 },
        /* 90 */ { { -4.4647944971961829e-103, -4.4647944971961829e-103 }, { -4.4647944971961829e-103, -4.4647944971961829e-103 }, 1.1198723710889021e+102 },
        /* 91 */ { { -9.9671949510973086e-206, -4.4647944971961829e-103 }, { -9.9671949510973086e-206, -4.4647944971961829e-103 }, 2.2397447421778042e+102 },
        /* 92 */ { { -min, -4.4647944971961829e-103 }, { -min, -4.4647944971961829e-103 }, 2.2397447421778042e+102 },
        /* 93 */ { { zero, -4.4647944971961829e-103 }, { zero, -4.4647944971961829e-103 }, 2.2397447421778042e+102 },
        /* 94 */ { { min, -4.4647944971961829e-103 }, { min, -4.4647944971961829e-103 }, 2.2397447421778042e+102 },
        /* 95 */ { { 9.9671949510973086e-206, -4.4647944971961829e-103 }, { 9.9671949510973086e-206, -4.4647944971961829e-103 }, 2.2397447421778042e+102 },
        /* 96 */ { { 4.4647944971961829e-103, -4.4647944971961829e-103 }, { 4.4647944971961829e-103, -4.4647944971961829e-103 }, 1.1198723710889021e+102 },
        /* 97 */ { { 1.9999999999998694e+00, -4.4647944971961829e-103 }, { 1.4436354751787519e+00, -1.996716800259636e-103 }, 5.e-01 },
        /* 98 */ { { 8.9589789687104559e+102, -4.4647944971961829e-103 }, { 2.3774948293206117e+02, -4.9835974755489796e-206 }, 3.90625e-03 },
        /* 99 */ { { 4.0131652080900752e+205, -4.4647944971961829e-103 }, { 4.741126715030025e+02, -1.1125369292536664e-308 }, 1.953125e-03 },
        /* 100 */ { { max, -4.4647944971961829e-103 }, { 7.1047586007394398e+02, zero }, 9.765625e-04 },
        /* 101 */ { { inf, -4.4647944971961829e-103 }, { inf, zero }, 1.e+00 },
        /* 102 */ { { -inf, -9.9671949510973086e-206 }, { -inf, zero }, 1.e+00 },
        /* 103 */ { { -max, -9.9671949510973086e-206 }, { -7.1047586007394398e+02, zero }, 9.765625e-04 },
        /* 104 */ { { -4.0131652080900752e+205, -9.9671949510973086e-206 }, { -4.741126715030025e+02, zero }, 1.953125e-03 },
        /* 105 */ { { -8.9589789687104559e+102, -9.9671949510973086e-206 }, { -2.3774948293206117e+02, -1.1125369292536664e-308 }, 3.90625e-03 },
        /* 106 */ { { -1.9999999999998694e+00, -9.9671949510973086e-206 }, { -1.4436354751787519e+00, -4.4574650911294878e-206 }, 5.e-01 },
        /* 107 */ { { -4.4647944971961829e-103, -9.9671949510973086e-206 }, { -4.4647944971961829e-103, -9.9671949510973086e-206 }, 2.2397447421778042e+102 },
        /* 108 */ { { -9.9671949510973086e-206, -9.9671949510973086e-206 }, { -9.9671949510973086e-206, -9.9671949510973086e-206 }, 5.0164565101131187e+204 },
        /* 109 */ { { -min, -9.9671949510973086e-206 }, { -min, -9.9671949510973086e-206 }, 1.0032913020226237e+205 },
        /* 110 */ { { zero, -9.9671949510973086e-206 }, { zero, -9.9671949510973086e-206 }, 1.0032913020226237e+205 },
        /* 111 */ { { min, -9.9671949510973086e-206 }, { min, -9.9671949510973086e-206 }, 1.0032913020226237e+205 },
        /* 112 */ { { 9.9671949510973086e-206, -9.9671949510973086e-206 }, { 9.9671949510973086e-206, -9.9671949510973086e-206 }, 5.0164565101131187e+204 },
        /* 113 */ { { 4.4647944971961829e-103, -9.9671949510973086e-206 }, { 4.4647944971961829e-103, -9.9671949510973086e-206 }, 2.2397447421778042e+102 },
        /* 114 */ { { 1.9999999999998694e+00, -9.9671949510973086e-206 }, { 1.4436354751787519e+00, -4.4574650911294878e-206 }, 5.e-01 },
        /* 115 */ { { 8.9589789687104559e+102, -9.9671949510973086e-206 }, { 2.3774948293206117e+02, -1.1125369292536664e-308 }, 3.90625e-03 },
        /* 116 */ { { 4.0131652080900752e+205, -9.9671949510973086e-206 }, { 4.741126715030025e+02, zero }, 1.953125e-03 },
        /* 117 */ { { max, -9.9671949510973086e-206 }, { 7.1047586007394398e+02, zero }, 9.765625e-04 },
        /* 118 */ { { inf, -9.9671949510973086e-206 }, { inf, zero }, 1.e+00 },
        /* 119 */ { { -inf, -min }, { -inf, zero }, 1.e+00 },
        /* 120 */ { { -max, -min }, { -7.1047586007394398e+02, zero }, 9.765625e-04 },
        /* 121 */ { { -4.0131652080900752e+205, -min }, { -4.741126715030025e+02, zero }, 1.953125e-03 },
        /* 122 */ { { -8.9589789687104559e+102, -min }, { -2.3774948293206117e+02, zero }, 3.90625e-03 },
        /* 123 */ { { -1.9999999999998694e+00, -min }, { -1.4436354751787519e+00, zero }, 5.e-01 },
        /* 124 */ { { -4.4647944971961829e-103, -min }, { -4.4647944971961829e-103, -min }, 2.2397447421778042e+102 },
        /* 125 */ { { -9.9671949510973086e-206, -min }, { -9.9671949510973086e-206, -min }, 1.0032913020226237e+205 },
        /* 126 */ { { -min, -min }, { -min, -min }, 2.2471164185778949e+307 },
        /* 127 */ { { zero, -min }, { zero, -min }, 2.2471164185778949e+307 },
        /* 128 */ { { min, -min }, { min, -min }, 2.2471164185778949e+307 },
        /* 129 */ { { 9.9671949510973086e-206, -min }, { 9.9671949510973086e-206, -min }, 1.0032913020226237e+205 },
        /* 130 */ { { 4.4647944971961829e-103, -min }, { 4.4647944971961829e-103, -min }, 2.2397447421778042e+102 },
        /* 131 */ { { 1.9999999999998694e+00, -min }, { 1.4436354751787519e+00, zero }, 5.e-01 },
        /* 132 */ { { 8.9589789687104559e+102, -min }, { 2.3774948293206117e+02, zero }, 3.90625e-03 },
        /* 133 */ { { 4.0131652080900752e+205, -min }, { 4.741126715030025e+02, zero }, 1.953125e-03 },
        /* 134 */ { { max, -min }, { 7.1047586007394398e+02, zero }, 9.765625e-04 },
        /* 135 */ { { inf, -min }, { inf, zero }, 1.e+00 },
        /* 136 */ { { -inf, zero }, { -inf, zero }, 1.e+00 },
        /* 137 */ { { -max, zero }, { -7.1047586007394398e+02, zero }, 9.765625e-04 },
        /* 138 */ { { -4.0131652080900752e+205, zero }, { -4.741126715030025e+02, zero }, 1.953125e-03 },
        /* 139 */ { { -8.9589789687104559e+102, zero }, { -2.3774948293206117e+02, zero }, 3.90625e-03 },
        /* 140 */ { { -1.9999999999998694e+00, zero }, { -1.4436354751787519e+00, zero }, 5.e-01 },
        /* 141 */ { { -4.4647944971961829e-103, zero }, { -4.4647944971961829e-103, zero }, 2.2397447421778042e+102 },
        /* 142 */ { { -9.9671949510973086e-206, zero }, { -9.9671949510973086e-206, zero }, 1.0032913020226237e+205 },
        /* 143 */ { { -min, zero }, { -min, zero }, 2.2471164185778949e+307 },
        /* 144 */ { { zero, zero }, { zero, zero }, 1.e+00 },
        /* 145 */ { { min, zero }, { min, zero }, 2.2471164185778949e+307 },
        /* 146 */ { { 9.9671949510973086e-206, zero }, { 9.9671949510973086e-206, zero }, 1.0032913020226237e+205 },
        /* 147 */ { { 4.4647944971961829e-103, zero }, { 4.4647944971961829e-103, zero }, 2.2397447421778042e+102 },
        /* 148 */ { { 1.9999999999998694e+00, zero }, { 1.4436354751787519e+00, zero }, 5.e-01 },
        /* 149 */ { { 8.9589789687104559e+102, zero }, { 2.3774948293206117e+02, zero }, 3.90625e-03 },
        /* 150 */ { { 4.0131652080900752e+205, zero }, { 4.741126715030025e+02, zero }, 1.953125e-03 },
        /* 151 */ { { max, zero }, { 7.1047586007394398e+02, zero }, 9.765625e-04 },
        /* 152 */ { { inf, zero }, { inf, zero }, 1.e+00 },
        /* 153 */ { { -inf, min }, { -inf, zero }, 1.e+00 },
        /* 154 */ { { -max, min }, { -7.1047586007394398e+02, zero }, 9.765625e-04 },
        /* 155 */ { { -4.0131652080900752e+205, min }, { -4.741126715030025e+02, zero }, 1.953125e-03 },
        /* 156 */ { { -8.9589789687104559e+102, min }, { -2.3774948293206117e+02, zero }, 3.90625e-03 },
        /* 157 */ { { -1.9999999999998694e+00, min }, { -1.4436354751787519e+00, zero }, 5.e-01 },
        /* 158 */ { { -4.4647944971961829e-103, min }, { -4.4647944971961829e-103, min }, 2.2397447421778042e+102 },
        /* 159 */ { { -9.9671949510973086e-206, min }, { -9.9671949510973086e-206, min }, 1.0032913020226237e+205 },
        /* 160 */ { { -min, min }, { -min, min }, 2.2471164185778949e+307 },
        /* 161 */ { { zero, min }, { zero, min }, 2.2471164185778949e+307 },
        /* 162 */ { { min, min }, { min, min }, 2.2471164185778949e+307 },
        /* 163 */ { { 9.9671949510973086e-206, min }, { 9.9671949510973086e-206, min }, 1.0032913020226237e+205 },
        /* 164 */ { { 4.4647944971961829e-103, min }, { 4.4647944971961829e-103, min }, 2.2397447421778042e+102 },
        /* 165 */ { { 1.9999999999998694e+00, min }, { 1.4436354751787519e+00, zero }, 5.e-01 },
        /* 166 */ { { 8.9589789687104559e+102, min }, { 2.3774948293206117e+02, zero }, 3.90625e-03 },
        /* 167 */ { { 4.0131652080900752e+205, min }, { 4.741126715030025e+02, zero }, 1.953125e-03 },
        /* 168 */ { { max, min }, { 7.1047586007394398e+02, zero }, 9.765625e-04 },
        /* 169 */ { { inf, min }, { inf, zero }, 1.e+00 },
        /* 170 */ { { -inf, 9.9671949510973086e-206 }, { -inf, zero }, 1.e+00 },
        /* 171 */ { { -max, 9.9671949510973086e-206 }, { -7.1047586007394398e+02, zero }, 9.765625e-04 },
        /* 172 */ { { -4.0131652080900752e+205, 9.9671949510973086e-206 }, { -4.741126715030025e+02, zero }, 1.953125e-03 },
        /* 173 */ { { -8.9589789687104559e+102, 9.9671949510973086e-206 }, { -2.3774948293206117e+02, 1.1125369292536664e-308 }, 3.90625e-03 },
        /* 174 */ { { -1.9999999999998694e+00, 9.9671949510973086e-206 }, { -1.4436354751787519e+00, 4.4574650911294878e-206 }, 5.e-01 },
        /* 175 */ { { -4.4647944971961829e-103, 9.9671949510973086e-206 }, { -4.4647944971961829e-103, 9.9671949510973086e-206 }, 2.2397447421778042e+102 },
        /* 176 */ { { -9.9671949510973086e-206, 9.9671949510973086e-206 }, { -9.9671949510973086e-206, 9.9671949510973086e-206 }, 5.0164565101131187e+204 },
        /* 177 */ { { -min, 9.9671949510973086e-206 }, { -min, 9.9671949510973086e-206 }, 1.0032913020226237e+205 },
        /* 178 */ { { zero, 9.9671949510973086e-206 }, { zero, 9.9671949510973086e-206 }, 1.0032913020226237e+205 },
        /* 179 */ { { min, 9.9671949510973086e-206 }, { min, 9.9671949510973086e-206 }, 1.0032913020226237e+205 },
        /* 180 */ { { 9.9671949510973086e-206, 9.9671949510973086e-206 }, { 9.9671949510973086e-206, 9.9671949510973086e-206 }, 5.0164565101131187e+204 },
        /* 181 */ { { 4.4647944971961829e-103, 9.9671949510973086e-206 }, { 4.4647944971961829e-103, 9.9671949510973086e-206 }, 2.2397447421778042e+102 },
        /* 182 */ { { 1.9999999999998694e+00, 9.9671949510973086e-206 }, { 1.4436354751787519e+00, 4.4574650911294878e-206 }, 5.e-01 },
        /* 183 */ { { 8.9589789687104559e+102, 9.9671949510973086e-206 }, { 2.3774948293206117e+02, 1.1125369292536664e-308 }, 3.90625e-03 },
        /* 184 */ { { 4.0131652080900752e+205, 9.9671949510973086e-206 }, { 4.741126715030025e+02, zero }, 1.953125e-03 },
        /* 185 */ { { max, 9.9671949510973086e-206 }, { 7.1047586007394398e+02, zero }, 9.765625e-04 },
        /* 186 */ { { inf, 9.9671949510973086e-206 }, { inf, zero }, 1.e+00 },
        /* 187 */ { { -inf, 4.4647944971961829e-103 }, { -inf, zero }, 1.e+00 },
        /* 188 */ { { -max, 4.4647944971961829e-103 }, { -7.1047586007394398e+02, zero }, 9.765625e-04 },
        /* 189 */ { { -4.0131652080900752e+205, 4.4647944971961829e-103 }, { -4.741126715030025e+02, 1.1125369292536664e-308 }, 1.953125e-03 },
        /* 190 */ { { -8.9589789687104559e+102, 4.4647944971961829e-103 }, { -2.3774948293206117e+02, 4.9835974755489796e-206 }, 3.90625e-03 },
        /* 191 */ { { -1.9999999999998694e+00, 4.4647944971961829e-103 }, { -1.4436354751787519e+00, 1.996716800259636e-103 }, 5.e-01 },
        /* 192 */ { { -4.4647944971961829e-103, 4.4647944971961829e-103 }, { -4.4647944971961829e-103, 4.4647944971961829e-103 }, 1.1198723710889021e+102 },
        /* 193 */ { { -9.9671949510973086e-206, 4.4647944971961829e-103 }, { -9.9671949510973086e-206, 4.4647944971961829e-103 }, 2.2397447421778042e+102 },
        /* 194 */ { { -min, 4.4647944971961829e-103 }, { -min, 4.4647944971961829e-103 }, 2.2397447421778042e+102 },
        /* 195 */ { { zero, 4.4647944971961829e-103 }, { zero, 4.4647944971961829e-103 }, 2.2397447421778042e+102 },
        /* 196 */ { { min, 4.4647944971961829e-103 }, { min, 4.4647944971961829e-103 }, 2.2397447421778042e+102 },
        /* 197 */ { { 9.9671949510973086e-206, 4.4647944971961829e-103 }, { 9.9671949510973086e-206, 4.4647944971961829e-103 }, 2.2397447421778042e+102 },
        /* 198 */ { { 4.4647944971961829e-103, 4.4647944971961829e-103 }, { 4.4647944971961829e-103, 4.4647944971961829e-103 }, 1.1198723710889021e+102 },
        /* 199 */ { { 1.9999999999998694e+00, 4.4647944971961829e-103 }, { 1.4436354751787519e+00, 1.996716800259636e-103 }, 5.e-01 },
        /* 200 */ { { 8.9589789687104559e+102, 4.4647944971961829e-103 }, { 2.3774948293206117e+02, 4.9835974755489796e-206 }, 3.90625e-03 },
        /* 201 */ { { 4.0131652080900752e+205, 4.4647944971961829e-103 }, { 4.741126715030025e+02, 1.1125369292536664e-308 }, 1.953125e-03 },
        /* 202 */ { { max, 4.4647944971961829e-103 }, { 7.1047586007394398e+02, zero }, 9.765625e-04 },
        /* 203 */ { { inf, 4.4647944971961829e-103 }, { inf, zero }, 1.e+00 },
        /* 204 */ { { -inf, 1.9999999999998694e+00 }, { -inf, zero }, 1.e+00 },
        /* 205 */ { { -max, 1.9999999999998694e+00 }, { -7.1047586007394398e+02, zero }, 9.765625e-04 },
        /* 206 */ { { -4.0131652080900752e+205, 1.9999999999998694e+00 }, { -4.741126715030025e+02, 4.9835974755489796e-206 }, 1.953125e-03 },
        /* 207 */ { { -8.9589789687104559e+102, 1.9999999999998694e+00 }, { -2.3774948293206117e+02, 2.2323972485982374e-103 }, 3.90625e-03 },
        /* 208 */ { { -1.9999999999998694e+00, 1.9999999999998694e+00 }, { -1.7343245214879015e+00, 7.5424914469804205e-01 }, 5.e-01 },
        /* 209 */ { { -4.4647944971961829e-103, 1.9999999999998694e+00 }, { -1.3169578969247413e+00, pi_2 }, 2.5e-01 },
        /* 210 */ { { -9.9671949510973086e-206, 1.9999999999998694e+00 }, { -1.3169578969247413e+00, pi_2 }, 2.5e-01 },
        /* 211 */ { { -min, 1.9999999999998694e+00 }, { -1.3169578969247413e+00, pi_2 }, 2.5e-01 },
        /* 212 */ { { zero, 1.9999999999998694e+00 }, { 1.3169578969247413e+00, pi_2 }, 2.5e-01 },
        /* 213 */ { { min, 1.9999999999998694e+00 }, { 1.3169578969247413e+00, pi_2 }, 2.5e-01 },
        /* 214 */ { { 9.9671949510973086e-206, 1.9999999999998694e+00 }, { 1.3169578969247413e+00, pi_2 }, 2.5e-01 },
        /* 215 */ { { 4.4647944971961829e-103, 1.9999999999998694e+00 }, { 1.3169578969247413e+00, pi_2 }, 2.5e-01 },
        /* 216 */ { { 1.9999999999998694e+00, 1.9999999999998694e+00 }, { 1.7343245214879015e+00, 7.5424914469804205e-01 }, 5.e-01 },
        /* 217 */ { { 8.9589789687104559e+102, 1.9999999999998694e+00 }, { 2.3774948293206117e+02, 2.2323972485982374e-103 }, 3.90625e-03 },
        /* 218 */ { { 4.0131652080900752e+205, 1.9999999999998694e+00 }, { 4.741126715030025e+02, 4.9835974755489796e-206 }, 1.953125e-03 },
        /* 219 */ { { max, 1.9999999999998694e+00 }, { 7.1047586007394398e+02, zero }, 9.765625e-04 },
        /* 220 */ { { inf, 1.9999999999998694e+00 }, { inf, zero }, 1.e+00 },
        /* 221 */ { { -inf, 8.9589789687104559e+102 }, { -inf, zero }, 1.e+00 },
        /* 222 */ { { -max, 8.9589789687104559e+102 }, { -7.1047586007394398e+02, 4.9835974755483611e-206 }, 9.765625e-04 },
        /* 223 */ { { -4.0131652080900752e+205, 8.9589789687104559e+102 }, { -4.741126715030025e+02, 2.2323972485982374e-103 }, 1.953125e-03 },
        /* 224 */ { { -8.9589789687104559e+102, 8.9589789687104559e+102 }, { -2.3809605652234112e+02, pi_4 }, 3.90625e-03 },
        /* 225 */ { { -1.9999999999998694e+00, 8.9589789687104559e+102 }, { -2.3774948293206117e+02, pi_2 }, 3.90625e-03 },
        /* 226 */ { { -4.4647944971961829e-103, 8.9589789687104559e+102 }, { -2.3774948293206117e+02, pi_2 }, 3.90625e-03 },
        /* 227 */ { { -9.9671949510973086e-206, 8.9589789687104559e+102 }, { -2.3774948293206117e+02, pi_2 }, 3.90625e-03 },
        /* 228 */ { { -min, 8.9589789687104559e+102 }, { -2.3774948293206117e+02, pi_2 }, 3.90625e-03 },
        /* 229 */ { { zero, 8.9589789687104559e+102 }, { 2.3774948293206117e+02, pi_2 }, 3.90625e-03 },
        /* 230 */ { { min, 8.9589789687104559e+102 }, { 2.3774948293206117e+02, pi_2 }, 3.90625e-03 },
        /* 231 */ { { 9.9671949510973086e-206, 8.9589789687104559e+102 }, { 2.3774948293206117e+02, pi_2 }, 3.90625e-03 },
        /* 232 */ { { 4.4647944971961829e-103, 8.9589789687104559e+102 }, { 2.3774948293206117e+02, pi_2 }, 3.90625e-03 },
        /* 233 */ { { 1.9999999999998694e+00, 8.9589789687104559e+102 }, { 2.3774948293206117e+02, pi_2 }, 3.90625e-03 },
        /* 234 */ { { 8.9589789687104559e+102, 8.9589789687104559e+102 }, { 2.3809605652234112e+02, pi_4 }, 3.90625e-03 },
        /* 235 */ { { 4.0131652080900752e+205, 8.9589789687104559e+102 }, { 4.741126715030025e+02, 2.2323972485982374e-103 }, 1.953125e-03 },
        /* 236 */ { { max, 8.9589789687104559e+102 }, { 7.1047586007394398e+02, 4.9835974755483611e-206 }, 9.765625e-04 },
        /* 237 */ { { inf, 8.9589789687104559e+102 }, { inf, zero }, 1.e+00 },
        /* 238 */ { { -inf, 4.0131652080900752e+205 }, { -inf, zero }, 1.e+00 },
        /* 239 */ { { -max, 4.0131652080900752e+205 }, { -7.1047586007394398e+02, 2.2323972485979601e-103 }, 9.765625e-04 },
        /* 240 */ { { -4.0131652080900752e+205, 4.0131652080900752e+205 }, { -4.7445924509328245e+02, pi_4 }, 1.953125e-03 },
        /* 241 */ { { -8.9589789687104559e+102, 4.0131652080900752e+205 }, { -4.741126715030025e+02, pi_2 }, 1.953125e-03 },
        /* 242 */ { { -1.9999999999998694e+00, 4.0131652080900752e+205 }, { -4.741126715030025e+02, pi_2 }, 1.953125e-03 },
        /* 243 */ { { -4.4647944971961829e-103, 4.0131652080900752e+205 }, { -4.741126715030025e+02, pi_2 }, 1.953125e-03 },
        /* 244 */ { { -9.9671949510973086e-206, 4.0131652080900752e+205 }, { -4.741126715030025e+02, pi_2 }, 1.953125e-03 },
        /* 245 */ { { -min, 4.0131652080900752e+205 }, { -4.741126715030025e+02, pi_2 }, 1.953125e-03 },
        /* 246 */ { { zero, 4.0131652080900752e+205 }, { 4.741126715030025e+02, pi_2 }, 1.953125e-03 },
        /* 247 */ { { min, 4.0131652080900752e+205 }, { 4.741126715030025e+02, pi_2 }, 1.953125e-03 },
        /* 248 */ { { 9.9671949510973086e-206, 4.0131652080900752e+205 }, { 4.741126715030025e+02, pi_2 }, 1.953125e-03 },
        /* 249 */ { { 4.4647944971961829e-103, 4.0131652080900752e+205 }, { 4.741126715030025e+02, pi_2 }, 1.953125e-03 },
        /* 250 */ { { 1.9999999999998694e+00, 4.0131652080900752e+205 }, { 4.741126715030025e+02, pi_2 }, 1.953125e-03 },
        /* 251 */ { { 8.9589789687104559e+102, 4.0131652080900752e+205 }, { 4.741126715030025e+02, pi_2 }, 1.953125e-03 },
        /* 252 */ { { 4.0131652080900752e+205, 4.0131652080900752e+205 }, { 4.7445924509328245e+02, pi_4 }, 1.953125e-03 },
        /* 253 */ { { max, 4.0131652080900752e+205 }, { 7.1047586007394398e+02, 2.2323972485979601e-103 }, 9.765625e-04 },
        /* 254 */ { { inf, 4.0131652080900752e+205 }, { inf, zero }, 1.e+00 },
        /* 255 */ { { -inf, max }, { -inf, zero }, 1.e+00 },
        /* 256 */ { { -max, max }, { -7.1082243366422392e+02, pi_4 }, 9.765625e-04 },
        /* 257 */ { { -4.0131652080900752e+205, max }, { -7.1047586007394398e+02, pi_2 }, 9.765625e-04 },
        /* 258 */ { { -8.9589789687104559e+102, max }, { -7.1047586007394398e+02, pi_2 }, 9.765625e-04 },
        /* 259 */ { { -1.9999999999998694e+00, max }, { -7.1047586007394398e+02, pi_2 }, 9.765625e-04 },
        /* 260 */ { { -4.4647944971961829e-103, max }, { -7.1047586007394398e+02, pi_2 }, 9.765625e-04 },
        /* 261 */ { { -9.9671949510973086e-206, max }, { -7.1047586007394398e+02, pi_2 }, 9.765625e-04 },
        /* 262 */ { { -min, max }, { -7.1047586007394398e+02, pi_2 }, 9.765625e-04 },
        /* 263 */ { { zero, max }, { 7.1047586007394398e+02, pi_2 }, 9.765625e-04 },
        /* 264 */ { { min, max }, { 7.1047586007394398e+02, pi_2 }, 9.765625e-04 },
        /* 265 */ { { 9.9671949510973086e-206, max }, { 7.1047586007394398e+02, pi_2 }, 9.765625e-04 },
        /* 266 */ { { 4.4647944971961829e-103, max }, { 7.1047586007394398e+02, pi_2 }, 9.765625e-04 },
        /* 267 */ { { 1.9999999999998694e+00, max }, { 7.1047586007394398e+02, pi_2 }, 9.765625e-04 },
        /* 268 */ { { 8.9589789687104559e+102, max }, { 7.1047586007394398e+02, pi_2 }, 9.765625e-04 },
        /* 269 */ { { 4.0131652080900752e+205, max }, { 7.1047586007394398e+02, pi_2 }, 9.765625e-04 },
        /* 270 */ { { max, max }, { 7.1082243366422392e+02, pi_4 }, 9.765625e-04 },
        /* 271 */ { { inf, max }, { inf, zero }, 1.e+00 },
        /* 272 */ { { -inf, inf }, { -inf, pi_4 }, 1.e+00 },
        /* 273 */ { { -max, inf }, { -inf, pi_2 }, 1.e+00 },
        /* 274 */ { { -4.0131652080900752e+205, inf }, { -inf, pi_2 }, 1.e+00 },
        /* 275 */ { { -8.9589789687104559e+102, inf }, { -inf, pi_2 }, 1.e+00 },
        /* 276 */ { { -1.9999999999998694e+00, inf }, { -inf, pi_2 }, 1.e+00 },
        /* 277 */ { { -4.4647944971961829e-103, inf }, { -inf, pi_2 }, 1.e+00 },
        /* 278 */ { { -9.9671949510973086e-206, inf }, { -inf, pi_2 }, 1.e+00 },
        /* 279 */ { { -min, inf }, { -inf, pi_2 }, 1.e+00 },
        /* 280 */ { { zero, inf }, { inf, pi_2 }, 1.e+00 },
        /* 281 */ { { min, inf }, { inf, pi_2 }, 1.e+00 },
        /* 282 */ { { 9.9671949510973086e-206, inf }, { inf, pi_2 }, 1.e+00 },
        /* 283 */ { { 4.4647944971961829e-103, inf }, { inf, pi_2 }, 1.e+00 },
        /* 284 */ { { 1.9999999999998694e+00, inf }, { inf, pi_2 }, 1.e+00 },
        /* 285 */ { { 8.9589789687104559e+102, inf }, { inf, pi_2 }, 1.e+00 },
        /* 286 */ { { 4.0131652080900752e+205, inf }, { inf, pi_2 }, 1.e+00 },
        /* 287 */ { { max, inf }, { inf, pi_2 }, 1.e+00 },
        /* 288 */ { { inf, inf }, { inf, pi_4 }, 1.e+00 }
          // clang-format on
      };
      return table;
    } else {
      static_assert(dependent_false<T>); /* unreachable */
    }
  }
};

template <typename T, int default_dps_deficiency = 0>
struct Exp {
  typedef std::complex<T> InputType;
  typedef std::complex<T> OutputType;
  typedef T FloatType;
  using TableType = std::vector<std::tuple<InputType, OutputType, FloatType>>;
  static constexpr int dps_deficiency = default_dps_deficiency;
  const TableType get() {
    if constexpr (std::is_same_v<T, float>) {
      const T nan = std::nanf("");
      const T zero = 0.0f;
      const T inf = std::numeric_limits<T>::infinity();
#ifdef __aarch64__
      const T min = std::nextafter(std::numeric_limits<T>::min(), T(1));
#else
      const T min = std::numeric_limits<T>::min();
#endif
      const T max = std::numeric_limits<T>::max();
      const TableType table{
          // clang-format off
          // Ignore max 80 character line width style requirement for
          // (i) the readability
          // (ii) the consistency with the local conventions
        /* 0 */ { { -inf, -inf }, { nan, nan }, 1.e+00f },
        /* 1 */ { { -max, -inf }, { nan, nan }, 1.e+00f },
        /* 2 */ { { -6.1409603e+25f, -inf }, { nan, nan }, 1.e+00f },
        /* 3 */ { { -1.1082383e+13f, -inf }, { nan, nan }, 1.e+00f },
        /* 4 */ { { -2.e+00f, -inf }, { nan, nan }, 1.e+00f },
        /* 5 */ { { -3.6093321e-13f, -inf }, { nan, nan }, 1.e+00f },
        /* 6 */ { { -6.5136393e-26f, -inf }, { nan, nan }, 1.e+00f },
        /* 7 */ { { -min, -inf }, { nan, nan }, 1.e+00f },
        /* 8 */ { { zero, -inf }, { nan, nan }, 1.e+00f },
        /* 9 */ { { min, -inf }, { nan, nan }, 1.e+00f },
        /* 10 */ { { 6.5136393e-26f, -inf }, { nan, nan }, 1.e+00f },
        /* 11 */ { { 3.6093321e-13f, -inf }, { nan, nan }, 1.e+00f },
        /* 12 */ { { 2.e+00f, -inf }, { nan, nan }, 1.e+00f },
        /* 13 */ { { 1.1082383e+13f, -inf }, { nan, nan }, 1.e+00f },
        /* 14 */ { { 6.1409603e+25f, -inf }, { nan, nan }, 1.e+00f },
        /* 15 */ { { max, -inf }, { nan, nan }, 1.e+00f },
        /* 16 */ { { inf, -inf }, { nan, nan }, 1.e+00f },
        /* 17 */ { { -inf, -max }, { zero, zero }, 1.e+00f },
        /* 18 */ { { -max, -max }, { zero, zero }, 1.e+00f },
        /* 19 */ { { -6.1409603e+25f, -max }, { zero, zero }, 1.e+00f },
        /* 20 */ { { -1.1082383e+13f, -max }, { zero, zero }, 1.e+00f },
        /* 21 */ { { -2.e+00f, -max }, { 1.1544384e-01f, 7.0628308e-02f }, 4.e+00f },
        /* 22 */ { { -3.6093321e-13f, -max }, { 8.5302103e-01f, 5.2187651e-01f }, 5.e-01f },
        /* 23 */ { { -6.5136393e-26f, -max }, { 8.5302103e-01f, 5.2187651e-01f }, 5.e-01f },
        /* 24 */ { { -min, -max }, { 8.5302103e-01f, 5.2187651e-01f }, 5.e-01f },
        /* 25 */ { { zero, -max }, { 8.5302103e-01f, 5.2187651e-01f }, 5.e-01f },
        /* 26 */ { { min, -max }, { 8.5302103e-01f, 5.2187651e-01f }, 5.e-01f },
        /* 27 */ { { 6.5136393e-26f, -max }, { 8.5302103e-01f, 5.2187651e-01f }, 5.e-01f },
        /* 28 */ { { 3.6093321e-13f, -max }, { 8.5302103e-01f, 5.2187651e-01f }, 5.e-01f },
        /* 29 */ { { 2.e+00f, -max }, { 6.3030205e+00f, 3.8561749e+00f }, 1.25e-01f },
        /* 30 */ { { 1.1082383e+13f, -max }, { inf, inf }, 1.e+00f },
        /* 31 */ { { 6.1409603e+25f, -max }, { inf, inf }, 1.e+00f },
        /* 32 */ { { max, -max }, { inf, inf }, 1.e+00f },
        /* 33 */ { { inf, -max }, { inf, inf }, 1.e+00f },
        /* 34 */ { { -inf, -6.1409603e+25f }, { zero, zero }, 1.e+00f },
        /* 35 */ { { -max, -6.1409603e+25f }, { zero, zero }, 1.e+00f },
        /* 36 */ { { -6.1409603e+25f, -6.1409603e+25f }, { zero, zero }, 1.e+00f },
        /* 37 */ { { -1.1082383e+13f, -6.1409603e+25f }, { zero, zero }, 1.e+00f },
        /* 38 */ { { -2.e+00f, -6.1409603e+25f }, { 9.5967902e-03f, 1.349946e-01f }, 4.e+00f },
        /* 39 */ { { -3.6093321e-13f, -6.1409603e+25f }, { 7.0911221e-02f, 9.9748266e-01f }, 5.e-01f },
        /* 40 */ { { -6.5136393e-26f, -6.1409603e+25f }, { 7.0911221e-02f, 9.9748266e-01f }, 5.e-01f },
        /* 41 */ { { -min, -6.1409603e+25f }, { 7.0911221e-02f, 9.9748266e-01f }, 5.e-01f },
        /* 42 */ { { zero, -6.1409603e+25f }, { 7.0911221e-02f, 9.9748266e-01f }, 5.e-01f },
        /* 43 */ { { min, -6.1409603e+25f }, { 7.0911221e-02f, 9.9748266e-01f }, 5.e-01f },
        /* 44 */ { { 6.5136393e-26f, -6.1409603e+25f }, { 7.0911221e-02f, 9.9748266e-01f }, 5.e-01f },
        /* 45 */ { { 3.6093321e-13f, -6.1409603e+25f }, { 7.0911221e-02f, 9.9748266e-01f }, 5.e-01f },
        /* 46 */ { { 2.e+00f, -6.1409603e+25f }, { 5.2396703e-01f, 7.3704553e+00f }, 1.25e-01f },
        /* 47 */ { { 1.1082383e+13f, -6.1409603e+25f }, { inf, inf }, 1.e+00f },
        /* 48 */ { { 6.1409603e+25f, -6.1409603e+25f }, { inf, inf }, 1.e+00f },
        /* 49 */ { { max, -6.1409603e+25f }, { inf, inf }, 1.e+00f },
        /* 50 */ { { inf, -6.1409603e+25f }, { inf, inf }, 1.e+00f },
        /* 51 */ { { -inf, -1.1082383e+13f }, { zero, zero }, 1.e+00f },
        /* 52 */ { { -max, -1.1082383e+13f }, { zero, zero }, 1.e+00f },
        /* 53 */ { { -6.1409603e+25f, -1.1082383e+13f }, { zero, zero }, 1.e+00f },
        /* 54 */ { { -1.1082383e+13f, -1.1082383e+13f }, { zero, zero }, 1.e+00f },
        /* 55 */ { { -2.e+00f, -1.1082383e+13f }, { 1.1061824e-01f, -7.7969506e-02f }, 4.e+00f },
        /* 56 */ { { -3.6093321e-13f, -1.1082383e+13f }, { 8.1736439e-01f, -5.7612109e-01f }, 5.e-01f },
        /* 57 */ { { -6.5136393e-26f, -1.1082383e+13f }, { 8.1736439e-01f, -5.7612109e-01f }, 5.e-01f },
        /* 58 */ { { -min, -1.1082383e+13f }, { 8.1736439e-01f, -5.7612109e-01f }, 5.e-01f },
        /* 59 */ { { zero, -1.1082383e+13f }, { 8.1736439e-01f, -5.7612109e-01f }, 5.e-01f },
        /* 60 */ { { min, -1.1082383e+13f }, { 8.1736439e-01f, -5.7612109e-01f }, 5.e-01f },
        /* 61 */ { { 6.5136393e-26f, -1.1082383e+13f }, { 8.1736439e-01f, -5.7612109e-01f }, 5.e-01f },
        /* 62 */ { { 3.6093321e-13f, -1.1082383e+13f }, { 8.1736439e-01f, -5.7612109e-01f }, 5.e-01f },
        /* 63 */ { { 2.e+00f, -1.1082383e+13f }, { 6.0395513e+00f, -4.2569909e+00f }, 1.25e-01f },
        /* 64 */ { { 1.1082383e+13f, -1.1082383e+13f }, { inf, -inf }, 1.e+00f },
        /* 65 */ { { 6.1409603e+25f, -1.1082383e+13f }, { inf, -inf }, 1.e+00f },
        /* 66 */ { { max, -1.1082383e+13f }, { inf, -inf }, 1.e+00f },
        /* 67 */ { { inf, -1.1082383e+13f }, { inf, -inf }, 1.e+00f },
        /* 68 */ { { -inf, -2.e+00f }, { zero, zero }, 1.e+00f },
        /* 69 */ { { -max, -2.e+00f }, { zero, zero }, 1.e+00f },
        /* 70 */ { { -6.1409603e+25f, -2.e+00f }, { zero, zero }, 1.e+00f },
        /* 71 */ { { -1.1082383e+13f, -2.e+00f }, { zero, zero }, 1.e+00f },
        /* 72 */ { { -2.e+00f, -2.e+00f }, { -5.6319349e-02f, -1.2306003e-01f }, 4.e+00f },
        /* 73 */ { { -3.6093321e-13f, -2.e+00f }, { -4.1614684e-01f, -9.0929741e-01f }, 5.e-01f },
        /* 74 */ { { -6.5136393e-26f, -2.e+00f }, { -4.1614684e-01f, -9.0929741e-01f }, 5.e-01f },
        /* 75 */ { { -min, -2.e+00f }, { -4.1614684e-01f, -9.0929741e-01f }, 5.e-01f },
        /* 76 */ { { zero, -2.e+00f }, { -4.1614684e-01f, -9.0929741e-01f }, 5.e-01f },
        /* 77 */ { { min, -2.e+00f }, { -4.1614684e-01f, -9.0929741e-01f }, 5.e-01f },
        /* 78 */ { { 6.5136393e-26f, -2.e+00f }, { -4.1614684e-01f, -9.0929741e-01f }, 5.e-01f },
        /* 79 */ { { 3.6093321e-13f, -2.e+00f }, { -4.1614684e-01f, -9.0929741e-01f }, 5.e-01f },
        /* 80 */ { { 2.e+00f, -2.e+00f }, { -3.0749323e+00f, -6.7188497e+00f }, 1.25e-01f },
        /* 81 */ { { 1.1082383e+13f, -2.e+00f }, { -inf, -inf }, 1.e+00f },
        /* 82 */ { { 6.1409603e+25f, -2.e+00f }, { -inf, -inf }, 1.e+00f },
        /* 83 */ { { max, -2.e+00f }, { -inf, -inf }, 1.e+00f },
        /* 84 */ { { inf, -2.e+00f }, { -inf, -inf }, 1.e+00f },
        /* 85 */ { { -inf, -3.6093321e-13f }, { zero, zero }, 1.e+00f },
        /* 86 */ { { -max, -3.6093321e-13f }, { zero, zero }, 1.e+00f },
        /* 87 */ { { -6.1409603e+25f, -3.6093321e-13f }, { zero, zero }, 1.e+00f },
        /* 88 */ { { -1.1082383e+13f, -3.6093321e-13f }, { zero, zero }, 1.e+00f },
        /* 89 */ { { -2.e+00f, -3.6093321e-13f }, { 1.3533528e-01f, -4.8846998e-14f }, 4.e+00f },
        /* 90 */ { { -3.6093321e-13f, -3.6093321e-13f }, { 1.e+00f, -3.6093321e-13f }, 5.e-01f },
        /* 91 */ { { -6.5136393e-26f, -3.6093321e-13f }, { 1.e+00f, -3.6093321e-13f }, 5.e-01f },
        /* 92 */ { { -min, -3.6093321e-13f }, { 1.e+00f, -3.6093321e-13f }, 5.e-01f },
        /* 93 */ { { zero, -3.6093321e-13f }, { 1.e+00f, -3.6093321e-13f }, 5.e-01f },
        /* 94 */ { { min, -3.6093321e-13f }, { 1.e+00f, -3.6093321e-13f }, 5.e-01f },
        /* 95 */ { { 6.5136393e-26f, -3.6093321e-13f }, { 1.e+00f, -3.6093321e-13f }, 5.e-01f },
        /* 96 */ { { 3.6093321e-13f, -3.6093321e-13f }, { 1.e+00f, -3.6093321e-13f }, 5.e-01f },
        /* 97 */ { { 2.e+00f, -3.6093321e-13f }, { 7.3890562e+00f, -2.6669556e-12f }, 1.25e-01f },
        /* 98 */ { { 1.1082383e+13f, -3.6093321e-13f }, { inf, -inf }, 1.e+00f },
        /* 99 */ { { 6.1409603e+25f, -3.6093321e-13f }, { inf, -inf }, 1.e+00f },
        /* 100 */ { { max, -3.6093321e-13f }, { inf, -inf }, 1.e+00f },
        /* 101 */ { { inf, -3.6093321e-13f }, { inf, -inf }, 1.e+00f },
        /* 102 */ { { -inf, -6.5136393e-26f }, { zero, zero }, 1.e+00f },
        /* 103 */ { { -max, -6.5136393e-26f }, { zero, zero }, 1.e+00f },
        /* 104 */ { { -6.1409603e+25f, -6.5136393e-26f }, { zero, zero }, 1.e+00f },
        /* 105 */ { { -1.1082383e+13f, -6.5136393e-26f }, { zero, zero }, 1.e+00f },
        /* 106 */ { { -2.e+00f, -6.5136393e-26f }, { 1.3533528e-01f, -8.8152525e-27f }, 4.e+00f },
        /* 107 */ { { -3.6093321e-13f, -6.5136393e-26f }, { 1.e+00f, -6.5136393e-26f }, 5.e-01f },
        /* 108 */ { { -6.5136393e-26f, -6.5136393e-26f }, { 1.e+00f, -6.5136393e-26f }, 5.e-01f },
        /* 109 */ { { -min, -6.5136393e-26f }, { 1.e+00f, -6.5136393e-26f }, 5.e-01f },
        /* 110 */ { { zero, -6.5136393e-26f }, { 1.e+00f, -6.5136393e-26f }, 5.e-01f },
        /* 111 */ { { min, -6.5136393e-26f }, { 1.e+00f, -6.5136393e-26f }, 5.e-01f },
        /* 112 */ { { 6.5136393e-26f, -6.5136393e-26f }, { 1.e+00f, -6.5136393e-26f }, 5.e-01f },
        /* 113 */ { { 3.6093321e-13f, -6.5136393e-26f }, { 1.e+00f, -6.5136393e-26f }, 5.e-01f },
        /* 114 */ { { 2.e+00f, -6.5136393e-26f }, { 7.3890562e+00f, -4.8129646e-25f }, 1.25e-01f },
        /* 115 */ { { 1.1082383e+13f, -6.5136393e-26f }, { inf, -inf }, 1.e+00f },
        /* 116 */ { { 6.1409603e+25f, -6.5136393e-26f }, { inf, -inf }, 1.e+00f },
        /* 117 */ { { max, -6.5136393e-26f }, { inf, -inf }, 1.e+00f },
        /* 118 */ { { inf, -6.5136393e-26f }, { inf, -inf }, 1.e+00f },
        /* 119 */ { { -inf, -min }, { zero, zero }, 1.e+00f },
        /* 120 */ { { -max, -min }, { zero, zero }, 1.e+00f },
        /* 121 */ { { -6.1409603e+25f, -min }, { zero, zero }, 1.e+00f },
        /* 122 */ { { -1.1082383e+13f, -min }, { zero, zero }, 1.e+00f },
        /* 123 */ { { -2.e+00f, -min }, { 1.3533528e-01f, zero }, 4.e+00f },
        /* 124 */ { { -3.6093321e-13f, -min }, { 1.e+00f, -min }, 5.e-01f },
        /* 125 */ { { -6.5136393e-26f, -min }, { 1.e+00f, -min }, 5.e-01f },
        /* 126 */ { { -min, -min }, { 1.e+00f, -min }, 5.e-01f },
        /* 127 */ { { zero, -min }, { 1.e+00f, -min }, 5.e-01f },
        /* 128 */ { { min, -min }, { 1.e+00f, -min }, 5.e-01f },
        /* 129 */ { { 6.5136393e-26f, -min }, { 1.e+00f, -min }, 5.e-01f },
        /* 130 */ { { 3.6093321e-13f, -min }, { 1.e+00f, -min }, 5.e-01f },
        /* 131 */ { { 2.e+00f, -min }, { 7.3890562e+00f, -8.6857938e-38f }, 1.25e-01f },
        /* 132 */ { { 1.1082383e+13f, -min }, { inf, -inf }, 1.e+00f },
        /* 133 */ { { 6.1409603e+25f, -min }, { inf, -inf }, 1.e+00f },
        /* 134 */ { { max, -min }, { inf, -inf }, 1.e+00f },
        /* 135 */ { { inf, -min }, { inf, -inf }, 1.e+00f },
        /* 136 */ { { -inf, zero }, { zero, zero }, 1.e+00f },
        /* 137 */ { { -max, zero }, { zero, zero }, 1.e+00f },
        /* 138 */ { { -6.1409603e+25f, zero }, { zero, zero }, 1.e+00f },
        /* 139 */ { { -1.1082383e+13f, zero }, { zero, zero }, 1.e+00f },
        /* 140 */ { { -2.e+00f, zero }, { 1.3533528e-01f, zero }, 4.e+00f },
        /* 141 */ { { -3.6093321e-13f, zero }, { 1.e+00f, zero }, 5.e-01f },
        /* 142 */ { { -6.5136393e-26f, zero }, { 1.e+00f, zero }, 5.e-01f },
        /* 143 */ { { -min, zero }, { 1.e+00f, zero }, 5.e-01f },
        /* 144 */ { { zero, zero }, { 1.e+00f, zero }, 5.e-01f },
        /* 145 */ { { min, zero }, { 1.e+00f, zero }, 5.e-01f },
        /* 146 */ { { 6.5136393e-26f, zero }, { 1.e+00f, zero }, 5.e-01f },
        /* 147 */ { { 3.6093321e-13f, zero }, { 1.e+00f, zero }, 5.e-01f },
        /* 148 */ { { 2.e+00f, zero }, { 7.3890562e+00f, zero }, 1.25e-01f },
        /* 149 */ { { 1.1082383e+13f, zero }, { inf, zero }, 1.e+00f },
        /* 150 */ { { 6.1409603e+25f, zero }, { inf, zero }, 1.e+00f },
        /* 151 */ { { max, zero }, { inf, zero }, 1.e+00f },
        /* 152 */ { { inf, zero }, { inf, zero }, 1.e+00f },
        /* 153 */ { { -inf, min }, { zero, zero }, 1.e+00f },
        /* 154 */ { { -max, min }, { zero, zero }, 1.e+00f },
        /* 155 */ { { -6.1409603e+25f, min }, { zero, zero }, 1.e+00f },
        /* 156 */ { { -1.1082383e+13f, min }, { zero, zero }, 1.e+00f },
        /* 157 */ { { -2.e+00f, min }, { 1.3533528e-01f, zero }, 4.e+00f },
        /* 158 */ { { -3.6093321e-13f, min }, { 1.e+00f, min }, 5.e-01f },
        /* 159 */ { { -6.5136393e-26f, min }, { 1.e+00f, min }, 5.e-01f },
        /* 160 */ { { -min, min }, { 1.e+00f, min }, 5.e-01f },
        /* 161 */ { { zero, min }, { 1.e+00f, min }, 5.e-01f },
        /* 162 */ { { min, min }, { 1.e+00f, min }, 5.e-01f },
        /* 163 */ { { 6.5136393e-26f, min }, { 1.e+00f, min }, 5.e-01f },
        /* 164 */ { { 3.6093321e-13f, min }, { 1.e+00f, min }, 5.e-01f },
        /* 165 */ { { 2.e+00f, min }, { 7.3890562e+00f, 8.6857938e-38f }, 1.25e-01f },
        /* 166 */ { { 1.1082383e+13f, min }, { inf, inf }, 1.e+00f },
        /* 167 */ { { 6.1409603e+25f, min }, { inf, inf }, 1.e+00f },
        /* 168 */ { { max, min }, { inf, inf }, 1.e+00f },
        /* 169 */ { { inf, min }, { inf, inf }, 1.e+00f },
        /* 170 */ { { -inf, 6.5136393e-26f }, { zero, zero }, 1.e+00f },
        /* 171 */ { { -max, 6.5136393e-26f }, { zero, zero }, 1.e+00f },
        /* 172 */ { { -6.1409603e+25f, 6.5136393e-26f }, { zero, zero }, 1.e+00f },
        /* 173 */ { { -1.1082383e+13f, 6.5136393e-26f }, { zero, zero }, 1.e+00f },
        /* 174 */ { { -2.e+00f, 6.5136393e-26f }, { 1.3533528e-01f, 8.8152525e-27f }, 4.e+00f },
        /* 175 */ { { -3.6093321e-13f, 6.5136393e-26f }, { 1.e+00f, 6.5136393e-26f }, 5.e-01f },
        /* 176 */ { { -6.5136393e-26f, 6.5136393e-26f }, { 1.e+00f, 6.5136393e-26f }, 5.e-01f },
        /* 177 */ { { -min, 6.5136393e-26f }, { 1.e+00f, 6.5136393e-26f }, 5.e-01f },
        /* 178 */ { { zero, 6.5136393e-26f }, { 1.e+00f, 6.5136393e-26f }, 5.e-01f },
        /* 179 */ { { min, 6.5136393e-26f }, { 1.e+00f, 6.5136393e-26f }, 5.e-01f },
        /* 180 */ { { 6.5136393e-26f, 6.5136393e-26f }, { 1.e+00f, 6.5136393e-26f }, 5.e-01f },
        /* 181 */ { { 3.6093321e-13f, 6.5136393e-26f }, { 1.e+00f, 6.5136393e-26f }, 5.e-01f },
        /* 182 */ { { 2.e+00f, 6.5136393e-26f }, { 7.3890562e+00f, 4.8129646e-25f }, 1.25e-01f },
        /* 183 */ { { 1.1082383e+13f, 6.5136393e-26f }, { inf, inf }, 1.e+00f },
        /* 184 */ { { 6.1409603e+25f, 6.5136393e-26f }, { inf, inf }, 1.e+00f },
        /* 185 */ { { max, 6.5136393e-26f }, { inf, inf }, 1.e+00f },
        /* 186 */ { { inf, 6.5136393e-26f }, { inf, inf }, 1.e+00f },
        /* 187 */ { { -inf, 3.6093321e-13f }, { zero, zero }, 1.e+00f },
        /* 188 */ { { -max, 3.6093321e-13f }, { zero, zero }, 1.e+00f },
        /* 189 */ { { -6.1409603e+25f, 3.6093321e-13f }, { zero, zero }, 1.e+00f },
        /* 190 */ { { -1.1082383e+13f, 3.6093321e-13f }, { zero, zero }, 1.e+00f },
        /* 191 */ { { -2.e+00f, 3.6093321e-13f }, { 1.3533528e-01f, 4.8846998e-14f }, 4.e+00f },
        /* 192 */ { { -3.6093321e-13f, 3.6093321e-13f }, { 1.e+00f, 3.6093321e-13f }, 5.e-01f },
        /* 193 */ { { -6.5136393e-26f, 3.6093321e-13f }, { 1.e+00f, 3.6093321e-13f }, 5.e-01f },
        /* 194 */ { { -min, 3.6093321e-13f }, { 1.e+00f, 3.6093321e-13f }, 5.e-01f },
        /* 195 */ { { zero, 3.6093321e-13f }, { 1.e+00f, 3.6093321e-13f }, 5.e-01f },
        /* 196 */ { { min, 3.6093321e-13f }, { 1.e+00f, 3.6093321e-13f }, 5.e-01f },
        /* 197 */ { { 6.5136393e-26f, 3.6093321e-13f }, { 1.e+00f, 3.6093321e-13f }, 5.e-01f },
        /* 198 */ { { 3.6093321e-13f, 3.6093321e-13f }, { 1.e+00f, 3.6093321e-13f }, 5.e-01f },
        /* 199 */ { { 2.e+00f, 3.6093321e-13f }, { 7.3890562e+00f, 2.6669556e-12f }, 1.25e-01f },
        /* 200 */ { { 1.1082383e+13f, 3.6093321e-13f }, { inf, inf }, 1.e+00f },
        /* 201 */ { { 6.1409603e+25f, 3.6093321e-13f }, { inf, inf }, 1.e+00f },
        /* 202 */ { { max, 3.6093321e-13f }, { inf, inf }, 1.e+00f },
        /* 203 */ { { inf, 3.6093321e-13f }, { inf, inf }, 1.e+00f },
        /* 204 */ { { -inf, 2.e+00f }, { zero, zero }, 1.e+00f },
        /* 205 */ { { -max, 2.e+00f }, { zero, zero }, 1.e+00f },
        /* 206 */ { { -6.1409603e+25f, 2.e+00f }, { zero, zero }, 1.e+00f },
        /* 207 */ { { -1.1082383e+13f, 2.e+00f }, { zero, zero }, 1.e+00f },
        /* 208 */ { { -2.e+00f, 2.e+00f }, { -5.6319349e-02f, 1.2306003e-01f }, 4.e+00f },
        /* 209 */ { { -3.6093321e-13f, 2.e+00f }, { -4.1614684e-01f, 9.0929741e-01f }, 5.e-01f },
        /* 210 */ { { -6.5136393e-26f, 2.e+00f }, { -4.1614684e-01f, 9.0929741e-01f }, 5.e-01f },
        /* 211 */ { { -min, 2.e+00f }, { -4.1614684e-01f, 9.0929741e-01f }, 5.e-01f },
        /* 212 */ { { zero, 2.e+00f }, { -4.1614684e-01f, 9.0929741e-01f }, 5.e-01f },
        /* 213 */ { { min, 2.e+00f }, { -4.1614684e-01f, 9.0929741e-01f }, 5.e-01f },
        /* 214 */ { { 6.5136393e-26f, 2.e+00f }, { -4.1614684e-01f, 9.0929741e-01f }, 5.e-01f },
        /* 215 */ { { 3.6093321e-13f, 2.e+00f }, { -4.1614684e-01f, 9.0929741e-01f }, 5.e-01f },
        /* 216 */ { { 2.e+00f, 2.e+00f }, { -3.0749323e+00f, 6.7188497e+00f }, 1.25e-01f },
        /* 217 */ { { 1.1082383e+13f, 2.e+00f }, { -inf, inf }, 1.e+00f },
        /* 218 */ { { 6.1409603e+25f, 2.e+00f }, { -inf, inf }, 1.e+00f },
        /* 219 */ { { max, 2.e+00f }, { -inf, inf }, 1.e+00f },
        /* 220 */ { { inf, 2.e+00f }, { -inf, inf }, 1.e+00f },
        /* 221 */ { { -inf, 1.1082383e+13f }, { zero, zero }, 1.e+00f },
        /* 222 */ { { -max, 1.1082383e+13f }, { zero, zero }, 1.e+00f },
        /* 223 */ { { -6.1409603e+25f, 1.1082383e+13f }, { zero, zero }, 1.e+00f },
        /* 224 */ { { -1.1082383e+13f, 1.1082383e+13f }, { zero, zero }, 1.e+00f },
        /* 225 */ { { -2.e+00f, 1.1082383e+13f }, { 1.1061824e-01f, 7.7969506e-02f }, 4.e+00f },
        /* 226 */ { { -3.6093321e-13f, 1.1082383e+13f }, { 8.1736439e-01f, 5.7612109e-01f }, 5.e-01f },
        /* 227 */ { { -6.5136393e-26f, 1.1082383e+13f }, { 8.1736439e-01f, 5.7612109e-01f }, 5.e-01f },
        /* 228 */ { { -min, 1.1082383e+13f }, { 8.1736439e-01f, 5.7612109e-01f }, 5.e-01f },
        /* 229 */ { { zero, 1.1082383e+13f }, { 8.1736439e-01f, 5.7612109e-01f }, 5.e-01f },
        /* 230 */ { { min, 1.1082383e+13f }, { 8.1736439e-01f, 5.7612109e-01f }, 5.e-01f },
        /* 231 */ { { 6.5136393e-26f, 1.1082383e+13f }, { 8.1736439e-01f, 5.7612109e-01f }, 5.e-01f },
        /* 232 */ { { 3.6093321e-13f, 1.1082383e+13f }, { 8.1736439e-01f, 5.7612109e-01f }, 5.e-01f },
        /* 233 */ { { 2.e+00f, 1.1082383e+13f }, { 6.0395513e+00f, 4.2569909e+00f }, 1.25e-01f },
        /* 234 */ { { 1.1082383e+13f, 1.1082383e+13f }, { inf, inf }, 1.e+00f },
        /* 235 */ { { 6.1409603e+25f, 1.1082383e+13f }, { inf, inf }, 1.e+00f },
        /* 236 */ { { max, 1.1082383e+13f }, { inf, inf }, 1.e+00f },
        /* 237 */ { { inf, 1.1082383e+13f }, { inf, inf }, 1.e+00f },
        /* 238 */ { { -inf, 6.1409603e+25f }, { zero, zero }, 1.e+00f },
        /* 239 */ { { -max, 6.1409603e+25f }, { zero, zero }, 1.e+00f },
        /* 240 */ { { -6.1409603e+25f, 6.1409603e+25f }, { zero, zero }, 1.e+00f },
        /* 241 */ { { -1.1082383e+13f, 6.1409603e+25f }, { zero, zero }, 1.e+00f },
        /* 242 */ { { -2.e+00f, 6.1409603e+25f }, { 9.5967902e-03f, -1.349946e-01f }, 4.e+00f },
        /* 243 */ { { -3.6093321e-13f, 6.1409603e+25f }, { 7.0911221e-02f, -9.9748266e-01f }, 5.e-01f },
        /* 244 */ { { -6.5136393e-26f, 6.1409603e+25f }, { 7.0911221e-02f, -9.9748266e-01f }, 5.e-01f },
        /* 245 */ { { -min, 6.1409603e+25f }, { 7.0911221e-02f, -9.9748266e-01f }, 5.e-01f },
        /* 246 */ { { zero, 6.1409603e+25f }, { 7.0911221e-02f, -9.9748266e-01f }, 5.e-01f },
        /* 247 */ { { min, 6.1409603e+25f }, { 7.0911221e-02f, -9.9748266e-01f }, 5.e-01f },
        /* 248 */ { { 6.5136393e-26f, 6.1409603e+25f }, { 7.0911221e-02f, -9.9748266e-01f }, 5.e-01f },
        /* 249 */ { { 3.6093321e-13f, 6.1409603e+25f }, { 7.0911221e-02f, -9.9748266e-01f }, 5.e-01f },
        /* 250 */ { { 2.e+00f, 6.1409603e+25f }, { 5.2396703e-01f, -7.3704553e+00f }, 1.25e-01f },
        /* 251 */ { { 1.1082383e+13f, 6.1409603e+25f }, { inf, -inf }, 1.e+00f },
        /* 252 */ { { 6.1409603e+25f, 6.1409603e+25f }, { inf, -inf }, 1.e+00f },
        /* 253 */ { { max, 6.1409603e+25f }, { inf, -inf }, 1.e+00f },
        /* 254 */ { { inf, 6.1409603e+25f }, { inf, -inf }, 1.e+00f },
        /* 255 */ { { -inf, max }, { zero, zero }, 1.e+00f },
        /* 256 */ { { -max, max }, { zero, zero }, 1.e+00f },
        /* 257 */ { { -6.1409603e+25f, max }, { zero, zero }, 1.e+00f },
        /* 258 */ { { -1.1082383e+13f, max }, { zero, zero }, 1.e+00f },
        /* 259 */ { { -2.e+00f, max }, { 1.1544384e-01f, -7.0628308e-02f }, 4.e+00f },
        /* 260 */ { { -3.6093321e-13f, max }, { 8.5302103e-01f, -5.2187651e-01f }, 5.e-01f },
        /* 261 */ { { -6.5136393e-26f, max }, { 8.5302103e-01f, -5.2187651e-01f }, 5.e-01f },
        /* 262 */ { { -min, max }, { 8.5302103e-01f, -5.2187651e-01f }, 5.e-01f },
        /* 263 */ { { zero, max }, { 8.5302103e-01f, -5.2187651e-01f }, 5.e-01f },
        /* 264 */ { { min, max }, { 8.5302103e-01f, -5.2187651e-01f }, 5.e-01f },
        /* 265 */ { { 6.5136393e-26f, max }, { 8.5302103e-01f, -5.2187651e-01f }, 5.e-01f },
        /* 266 */ { { 3.6093321e-13f, max }, { 8.5302103e-01f, -5.2187651e-01f }, 5.e-01f },
        /* 267 */ { { 2.e+00f, max }, { 6.3030205e+00f, -3.8561749e+00f }, 1.25e-01f },
        /* 268 */ { { 1.1082383e+13f, max }, { inf, -inf }, 1.e+00f },
        /* 269 */ { { 6.1409603e+25f, max }, { inf, -inf }, 1.e+00f },
        /* 270 */ { { max, max }, { inf, -inf }, 1.e+00f },
        /* 271 */ { { inf, max }, { inf, -inf }, 1.e+00f },
        /* 272 */ { { -inf, inf }, { nan, nan }, 1.e+00f },
        /* 273 */ { { -max, inf }, { nan, nan }, 1.e+00f },
        /* 274 */ { { -6.1409603e+25f, inf }, { nan, nan }, 1.e+00f },
        /* 275 */ { { -1.1082383e+13f, inf }, { nan, nan }, 1.e+00f },
        /* 276 */ { { -2.e+00f, inf }, { nan, nan }, 1.e+00f },
        /* 277 */ { { -3.6093321e-13f, inf }, { nan, nan }, 1.e+00f },
        /* 278 */ { { -6.5136393e-26f, inf }, { nan, nan }, 1.e+00f },
        /* 279 */ { { -min, inf }, { nan, nan }, 1.e+00f },
        /* 280 */ { { zero, inf }, { nan, nan }, 1.e+00f },
        /* 281 */ { { min, inf }, { nan, nan }, 1.e+00f },
        /* 282 */ { { 6.5136393e-26f, inf }, { nan, nan }, 1.e+00f },
        /* 283 */ { { 3.6093321e-13f, inf }, { nan, nan }, 1.e+00f },
        /* 284 */ { { 2.e+00f, inf }, { nan, nan }, 1.e+00f },
        /* 285 */ { { 1.1082383e+13f, inf }, { nan, nan }, 1.e+00f },
        /* 286 */ { { 6.1409603e+25f, inf }, { nan, nan }, 1.e+00f },
        /* 287 */ { { max, inf }, { nan, nan }, 1.e+00f },
        /* 288 */ { { inf, inf }, { nan, nan }, 1.e+00f }  // clang-format on
      };
      return table;
    } else if constexpr (std::is_same_v<T, double>) {
      const T nan = std::nan("");
      const T zero = 0.0;
      const T inf = std::numeric_limits<T>::infinity();
#ifdef __aarch64__
      const T min = std::nextafter(std::numeric_limits<T>::min(), T(1));
#else
      const T min = std::numeric_limits<T>::min();
#endif
      const T max = std::numeric_limits<T>::max();
      const TableType table{
          // clang-format off
          // Ignore max 80 character line width style requirement for
          // (i) the readability
          // (ii) the consistency with the local conventions
        /* 0 */ { { -inf, -inf }, { nan, nan }, 1.e+00 },
        /* 1 */ { { -max, -inf }, { nan, nan }, 1.e+00 },
        /* 2 */ { { -4.0131652080900752e+205, -inf }, { nan, nan }, 1.e+00 },
        /* 3 */ { { -8.9589789687104559e+102, -inf }, { nan, nan }, 1.e+00 },
        /* 4 */ { { -1.9999999999998694e+00, -inf }, { nan, nan }, 1.e+00 },
        /* 5 */ { { -4.4647944971961829e-103, -inf }, { nan, nan }, 1.e+00 },
        /* 6 */ { { -9.9671949510973086e-206, -inf }, { nan, nan }, 1.e+00 },
        /* 7 */ { { -min, -inf }, { nan, nan }, 1.e+00 },
        /* 8 */ { { zero, -inf }, { nan, nan }, 1.e+00 },
        /* 9 */ { { min, -inf }, { nan, nan }, 1.e+00 },
        /* 10 */ { { 9.9671949510973086e-206, -inf }, { nan, nan }, 1.e+00 },
        /* 11 */ { { 4.4647944971961829e-103, -inf }, { nan, nan }, 1.e+00 },
        /* 12 */ { { 1.9999999999998694e+00, -inf }, { nan, nan }, 1.e+00 },
        /* 13 */ { { 8.9589789687104559e+102, -inf }, { nan, nan }, 1.e+00 },
        /* 14 */ { { 4.0131652080900752e+205, -inf }, { nan, nan }, 1.e+00 },
        /* 15 */ { { max, -inf }, { nan, nan }, 1.e+00 },
        /* 16 */ { { inf, -inf }, { nan, nan }, 1.e+00 },
        /* 17 */ { { -inf, -max }, { zero, zero }, 1.e+00 },
        /* 18 */ { { -max, -max }, { zero, zero }, 1.e+00 },
        /* 19 */ { { -4.0131652080900752e+205, -max }, { zero, zero }, 1.e+00 },
        /* 20 */ { { -8.9589789687104559e+102, -max }, { zero, zero }, 1.e+00 },
        /* 21 */ { { -1.9999999999998694e+00, -max }, { -1.3533361718168704e-01, -6.7152755680157945e-04 }, 4.e+00 },
        /* 22 */ { { -4.4647944971961829e-103, -max }, { -9.9998768942655991e-01, -4.961954789184062e-03 }, 5.e-01 },
        /* 23 */ { { -9.9671949510973086e-206, -max }, { -9.9998768942655991e-01, -4.961954789184062e-03 }, 5.e-01 },
        /* 24 */ { { -min, -max }, { -9.9998768942655991e-01, -4.961954789184062e-03 }, 5.e-01 },
        /* 25 */ { { zero, -max }, { -9.9998768942655991e-01, -4.961954789184062e-03 }, 5.e-01 },
        /* 26 */ { { min, -max }, { -9.9998768942655991e-01, -4.961954789184062e-03 }, 5.e-01 },
        /* 27 */ { { 9.9671949510973086e-206, -max }, { -9.9998768942655991e-01, -4.961954789184062e-03 }, 5.e-01 },
        /* 28 */ { { 4.4647944971961829e-103, -max }, { -9.9998768942655991e-01, -4.961954789184062e-03 }, 5.e-01 },
        /* 29 */ { { 1.9999999999998694e+00, -max }, { -7.3889651354119268e+00, -3.6664162297633855e-02 }, 1.25e-01 },
        /* 30 */ { { 8.9589789687104559e+102, -max }, { -inf, -inf }, 1.e+00 },
        /* 31 */ { { 4.0131652080900752e+205, -max }, { -inf, -inf }, 1.e+00 },
        /* 32 */ { { max, -max }, { -inf, -inf }, 1.e+00 },
        /* 33 */ { { inf, -max }, { -inf, -inf }, 1.e+00 },
        /* 34 */ { { -inf, -4.0131652080900752e+205 }, { zero, zero }, 1.e+00 },
        /* 35 */ { { -max, -4.0131652080900752e+205 }, { zero, zero }, 1.e+00 },
        /* 36 */ { { -4.0131652080900752e+205, -4.0131652080900752e+205 }, { zero, zero }, 1.e+00 },
        /* 37 */ { { -8.9589789687104559e+102, -4.0131652080900752e+205 }, { zero, zero }, 1.e+00 },
        /* 38 */ { { -1.9999999999998694e+00, -4.0131652080900752e+205 }, { 5.4291544962016755e-02, 1.2396800810844819e-01 }, 4.e+00 },
        /* 39 */ { { -4.4647944971961829e-103, -4.0131652080900752e+205 }, { 4.0116327142190517e-01, 9.1600656638589384e-01 }, 5.e-01 },
        /* 40 */ { { -9.9671949510973086e-206, -4.0131652080900752e+205 }, { 4.0116327142190517e-01, 9.1600656638589384e-01 }, 5.e-01 },
        /* 41 */ { { -min, -4.0131652080900752e+205 }, { 4.0116327142190517e-01, 9.1600656638589384e-01 }, 5.e-01 },
        /* 42 */ { { zero, -4.0131652080900752e+205 }, { 4.0116327142190517e-01, 9.1600656638589384e-01 }, 5.e-01 },
        /* 43 */ { { min, -4.0131652080900752e+205 }, { 4.0116327142190517e-01, 9.1600656638589384e-01 }, 5.e-01 },
        /* 44 */ { { 9.9671949510973086e-206, -4.0131652080900752e+205 }, { 4.0116327142190517e-01, 9.1600656638589384e-01 }, 5.e-01 },
        /* 45 */ { { 4.4647944971961829e-103, -4.0131652080900752e+205 }, { 4.0116327142190517e-01, 9.1600656638589384e-01 }, 5.e-01 },
        /* 46 */ { { 1.9999999999998694e+00, -4.0131652080900752e+205 }, { 2.964217917366613e+00, 6.7684239060133287e+00 }, 1.25e-01 },
        /* 47 */ { { 8.9589789687104559e+102, -4.0131652080900752e+205 }, { inf, inf }, 1.e+00 },
        /* 48 */ { { 4.0131652080900752e+205, -4.0131652080900752e+205 }, { inf, inf }, 1.e+00 },
        /* 49 */ { { max, -4.0131652080900752e+205 }, { inf, inf }, 1.e+00 },
        /* 50 */ { { inf, -4.0131652080900752e+205 }, { inf, inf }, 1.e+00 },
        /* 51 */ { { -inf, -8.9589789687104559e+102 }, { zero, zero }, 1.e+00 },
        /* 52 */ { { -max, -8.9589789687104559e+102 }, { zero, zero }, 1.e+00 },
        /* 53 */ { { -4.0131652080900752e+205, -8.9589789687104559e+102 }, { zero, zero }, 1.e+00 },
        /* 54 */ { { -8.9589789687104559e+102, -8.9589789687104559e+102 }, { zero, zero }, 1.e+00 },
        /* 55 */ { { -1.9999999999998694e+00, -8.9589789687104559e+102 }, { 8.9268873295850301e-02, 1.0171876498084505e-01 }, 4.e+00 },
        /* 56 */ { { -4.4647944971961829e-103, -8.9589789687104559e+102 }, { 6.5961271267128396e-01, 7.5160566075730839e-01 }, 5.e-01 },
        /* 57 */ { { -9.9671949510973086e-206, -8.9589789687104559e+102 }, { 6.5961271267128396e-01, 7.5160566075730839e-01 }, 5.e-01 },
        /* 58 */ { { -min, -8.9589789687104559e+102 }, { 6.5961271267128396e-01, 7.5160566075730839e-01 }, 5.e-01 },
        /* 59 */ { { zero, -8.9589789687104559e+102 }, { 6.5961271267128396e-01, 7.5160566075730839e-01 }, 5.e-01 },
        /* 60 */ { { min, -8.9589789687104559e+102 }, { 6.5961271267128396e-01, 7.5160566075730839e-01 }, 5.e-01 },
        /* 61 */ { { 9.9671949510973086e-206, -8.9589789687104559e+102 }, { 6.5961271267128396e-01, 7.5160566075730839e-01 }, 5.e-01 },
        /* 62 */ { { 4.4647944971961829e-103, -8.9589789687104559e+102 }, { 6.5961271267128396e-01, 7.5160566075730839e-01 }, 5.e-01 },
        /* 63 */ { { 1.9999999999998694e+00, -8.9589789687104559e+102 }, { 4.8739153374953057e+00, 5.5536563916088655e+00 }, 1.25e-01 },
        /* 64 */ { { 8.9589789687104559e+102, -8.9589789687104559e+102 }, { inf, inf }, 1.e+00 },
        /* 65 */ { { 4.0131652080900752e+205, -8.9589789687104559e+102 }, { inf, inf }, 1.e+00 },
        /* 66 */ { { max, -8.9589789687104559e+102 }, { inf, inf }, 1.e+00 },
        /* 67 */ { { inf, -8.9589789687104559e+102 }, { inf, inf }, 1.e+00 },
        /* 68 */ { { -inf, -1.9999999999998694e+00 }, { zero, zero }, 1.e+00 },
        /* 69 */ { { -max, -1.9999999999998694e+00 }, { zero, zero }, 1.e+00 },
        /* 70 */ { { -4.0131652080900752e+205, -1.9999999999998694e+00 }, { zero, zero }, 1.e+00 },
        /* 71 */ { { -8.9589789687104559e+102, -1.9999999999998694e+00 }, { zero, zero }, 1.e+00 },
        /* 72 */ { { -1.9999999999998694e+00, -1.9999999999998694e+00 }, { -5.6319349992119169e-02, -1.2306002480580015e-01 }, 4.e+00 },
        /* 73 */ { { -4.4647944971961829e-103, -1.9999999999998694e+00 }, { -4.1614683654702367e-01, -9.09297426825736e-01 }, 5.e-01 },
        /* 74 */ { { -9.9671949510973086e-206, -1.9999999999998694e+00 }, { -4.1614683654702367e-01, -9.09297426825736e-01 }, 5.e-01 },
        /* 75 */ { { -min, -1.9999999999998694e+00 }, { -4.1614683654702367e-01, -9.09297426825736e-01 }, 5.e-01 },
        /* 76 */ { { zero, -1.9999999999998694e+00 }, { -4.1614683654702367e-01, -9.09297426825736e-01 }, 5.e-01 },
        /* 77 */ { { min, -1.9999999999998694e+00 }, { -4.1614683654702367e-01, -9.09297426825736e-01 }, 5.e-01 },
        /* 78 */ { { 9.9671949510973086e-206, -1.9999999999998694e+00 }, { -4.1614683654702367e-01, -9.09297426825736e-01 }, 5.e-01 },
        /* 79 */ { { 4.4647944971961829e-103, -1.9999999999998694e+00 }, { -4.1614683654702367e-01, -9.09297426825736e-01 }, 5.e-01 },
        /* 80 */ { { 1.9999999999998694e+00, -1.9999999999998694e+00 }, { -3.0749323206380801e+00, -6.7188496974277738e+00 }, 1.25e-01 },
        /* 81 */ { { 8.9589789687104559e+102, -1.9999999999998694e+00 }, { -inf, -inf }, 1.e+00 },
        /* 82 */ { { 4.0131652080900752e+205, -1.9999999999998694e+00 }, { -inf, -inf }, 1.e+00 },
        /* 83 */ { { max, -1.9999999999998694e+00 }, { -inf, -inf }, 1.e+00 },
        /* 84 */ { { inf, -1.9999999999998694e+00 }, { -inf, -inf }, 1.e+00 },
        /* 85 */ { { -inf, -4.4647944971961829e-103 }, { zero, zero }, 1.e+00 },
        /* 86 */ { { -max, -4.4647944971961829e-103 }, { zero, zero }, 1.e+00 },
        /* 87 */ { { -4.0131652080900752e+205, -4.4647944971961829e-103 }, { zero, zero }, 1.e+00 },
        /* 88 */ { { -8.9589789687104559e+102, -4.4647944971961829e-103 }, { zero, zero }, 1.e+00 },
        /* 89 */ { { -1.9999999999998694e+00, -4.4647944971961829e-103 }, { 1.3533528323663035e-01, -6.0424422787139409e-104 }, 4.e+00 },
        /* 90 */ { { -4.4647944971961829e-103, -4.4647944971961829e-103 }, { 1.e+00, -4.4647944971961829e-103 }, 5.e-01 },
        /* 91 */ { { -9.9671949510973086e-206, -4.4647944971961829e-103 }, { 1.e+00, -4.4647944971961829e-103 }, 5.e-01 },
        /* 92 */ { { -min, -4.4647944971961829e-103 }, { 1.e+00, -4.4647944971961829e-103 }, 5.e-01 },
        /* 93 */ { { zero, -4.4647944971961829e-103 }, { 1.e+00, -4.4647944971961829e-103 }, 5.e-01 },
        /* 94 */ { { min, -4.4647944971961829e-103 }, { 1.e+00, -4.4647944971961829e-103 }, 5.e-01 },
        /* 95 */ { { 9.9671949510973086e-206, -4.4647944971961829e-103 }, { 1.e+00, -4.4647944971961829e-103 }, 5.e-01 },
        /* 96 */ { { 4.4647944971961829e-103, -4.4647944971961829e-103 }, { 1.e+00, -4.4647944971961829e-103 }, 5.e-01 },
        /* 97 */ { { 1.9999999999998694e+00, -4.4647944971961829e-103 }, { 7.3890560989296858e+00, -3.2990617009975154e-102 }, 1.25e-01 },
        /* 98 */ { { 8.9589789687104559e+102, -4.4647944971961829e-103 }, { inf, -inf }, 1.e+00 },
        /* 99 */ { { 4.0131652080900752e+205, -4.4647944971961829e-103 }, { inf, -inf }, 1.e+00 },
        /* 100 */ { { max, -4.4647944971961829e-103 }, { inf, -inf }, 1.e+00 },
        /* 101 */ { { inf, -4.4647944971961829e-103 }, { inf, -inf }, 1.e+00 },
        /* 102 */ { { -inf, -9.9671949510973086e-206 }, { zero, zero }, 1.e+00 },
        /* 103 */ { { -max, -9.9671949510973086e-206 }, { zero, zero }, 1.e+00 },
        /* 104 */ { { -4.0131652080900752e+205, -9.9671949510973086e-206 }, { zero, zero }, 1.e+00 },
        /* 105 */ { { -8.9589789687104559e+102, -9.9671949510973086e-206 }, { zero, zero }, 1.e+00 },
        /* 106 */ { { -1.9999999999998694e+00, -9.9671949510973086e-206 }, { 1.3533528323663035e-01, -1.3489131517814665e-206 }, 4.e+00 },
        /* 107 */ { { -4.4647944971961829e-103, -9.9671949510973086e-206 }, { 1.e+00, -9.9671949510973086e-206 }, 5.e-01 },
        /* 108 */ { { -9.9671949510973086e-206, -9.9671949510973086e-206 }, { 1.e+00, -9.9671949510973086e-206 }, 5.e-01 },
        /* 109 */ { { -min, -9.9671949510973086e-206 }, { 1.e+00, -9.9671949510973086e-206 }, 5.e-01 },
        /* 110 */ { { zero, -9.9671949510973086e-206 }, { 1.e+00, -9.9671949510973086e-206 }, 5.e-01 },
        /* 111 */ { { min, -9.9671949510973086e-206 }, { 1.e+00, -9.9671949510973086e-206 }, 5.e-01 },
        /* 112 */ { { 9.9671949510973086e-206, -9.9671949510973086e-206 }, { 1.e+00, -9.9671949510973086e-206 }, 5.e-01 },
        /* 113 */ { { 4.4647944971961829e-103, -9.9671949510973086e-206 }, { 1.e+00, -9.9671949510973086e-206 }, 5.e-01 },
        /* 114 */ { { 1.9999999999998694e+00, -9.9671949510973086e-206 }, { 7.3890560989296858e+00, -7.3648162642626732e-205 }, 1.25e-01 },
        /* 115 */ { { 8.9589789687104559e+102, -9.9671949510973086e-206 }, { inf, -inf }, 1.e+00 },
        /* 116 */ { { 4.0131652080900752e+205, -9.9671949510973086e-206 }, { inf, -inf }, 1.e+00 },
        /* 117 */ { { max, -9.9671949510973086e-206 }, { inf, -inf }, 1.e+00 },
        /* 118 */ { { inf, -9.9671949510973086e-206 }, { inf, -inf }, 1.e+00 },
        /* 119 */ { { -inf, -min }, { zero, zero }, 1.e+00 },
        /* 120 */ { { -max, -min }, { zero, zero }, 1.e+00 },
        /* 121 */ { { -4.0131652080900752e+205, -min }, { zero, zero }, 1.e+00 },
        /* 122 */ { { -8.9589789687104559e+102, -min }, { zero, zero }, 1.e+00 },
        /* 123 */ { { -1.9999999999998694e+00, -min }, { 1.3533528323663035e-01, zero }, 4.e+00 },
        /* 124 */ { { -4.4647944971961829e-103, -min }, { 1.e+00, -min }, 5.e-01 },
        /* 125 */ { { -9.9671949510973086e-206, -min }, { 1.e+00, -min }, 5.e-01 },
        /* 126 */ { { -min, -min }, { 1.e+00, -min }, 5.e-01 },
        /* 127 */ { { zero, -min }, { 1.e+00, -min }, 5.e-01 },
        /* 128 */ { { min, -min }, { 1.e+00, -min }, 5.e-01 },
        /* 129 */ { { 9.9671949510973086e-206, -min }, { 1.e+00, -min }, 5.e-01 },
        /* 130 */ { { 4.4647944971961829e-103, -min }, { 1.e+00, -min }, 5.e-01 },
        /* 131 */ { { 1.9999999999998694e+00, -min }, { 7.3890560989296858e+00, -1.6441195564771645e-307 }, 1.25e-01 },
        /* 132 */ { { 8.9589789687104559e+102, -min }, { inf, -inf }, 1.e+00 },
        /* 133 */ { { 4.0131652080900752e+205, -min }, { inf, -inf }, 1.e+00 },
        /* 134 */ { { max, -min }, { inf, -inf }, 1.e+00 },
        /* 135 */ { { inf, -min }, { inf, -inf }, 1.e+00 },
        /* 136 */ { { -inf, zero }, { zero, zero }, 1.e+00 },
        /* 137 */ { { -max, zero }, { zero, zero }, 1.e+00 },
        /* 138 */ { { -4.0131652080900752e+205, zero }, { zero, zero }, 1.e+00 },
        /* 139 */ { { -8.9589789687104559e+102, zero }, { zero, zero }, 1.e+00 },
        /* 140 */ { { -1.9999999999998694e+00, zero }, { 1.3533528323663035e-01, zero }, 4.e+00 },
        /* 141 */ { { -4.4647944971961829e-103, zero }, { 1.e+00, zero }, 5.e-01 },
        /* 142 */ { { -9.9671949510973086e-206, zero }, { 1.e+00, zero }, 5.e-01 },
        /* 143 */ { { -min, zero }, { 1.e+00, zero }, 5.e-01 },
        /* 144 */ { { zero, zero }, { 1.e+00, zero }, 5.e-01 },
        /* 145 */ { { min, zero }, { 1.e+00, zero }, 5.e-01 },
        /* 146 */ { { 9.9671949510973086e-206, zero }, { 1.e+00, zero }, 5.e-01 },
        /* 147 */ { { 4.4647944971961829e-103, zero }, { 1.e+00, zero }, 5.e-01 },
        /* 148 */ { { 1.9999999999998694e+00, zero }, { 7.3890560989296858e+00, zero }, 1.25e-01 },
        /* 149 */ { { 8.9589789687104559e+102, zero }, { inf, zero }, 1.e+00 },
        /* 150 */ { { 4.0131652080900752e+205, zero }, { inf, zero }, 1.e+00 },
        /* 151 */ { { max, zero }, { inf, zero }, 1.e+00 },
        /* 152 */ { { inf, zero }, { inf, zero }, 1.e+00 },
        /* 153 */ { { -inf, min }, { zero, zero }, 1.e+00 },
        /* 154 */ { { -max, min }, { zero, zero }, 1.e+00 },
        /* 155 */ { { -4.0131652080900752e+205, min }, { zero, zero }, 1.e+00 },
        /* 156 */ { { -8.9589789687104559e+102, min }, { zero, zero }, 1.e+00 },
        /* 157 */ { { -1.9999999999998694e+00, min }, { 1.3533528323663035e-01, zero }, 4.e+00 },
        /* 158 */ { { -4.4647944971961829e-103, min }, { 1.e+00, min }, 5.e-01 },
        /* 159 */ { { -9.9671949510973086e-206, min }, { 1.e+00, min }, 5.e-01 },
        /* 160 */ { { -min, min }, { 1.e+00, min }, 5.e-01 },
        /* 161 */ { { zero, min }, { 1.e+00, min }, 5.e-01 },
        /* 162 */ { { min, min }, { 1.e+00, min }, 5.e-01 },
        /* 163 */ { { 9.9671949510973086e-206, min }, { 1.e+00, min }, 5.e-01 },
        /* 164 */ { { 4.4647944971961829e-103, min }, { 1.e+00, min }, 5.e-01 },
        /* 165 */ { { 1.9999999999998694e+00, min }, { 7.3890560989296858e+00, 1.6441195564771645e-307 }, 1.25e-01 },
        /* 166 */ { { 8.9589789687104559e+102, min }, { inf, inf }, 1.e+00 },
        /* 167 */ { { 4.0131652080900752e+205, min }, { inf, inf }, 1.e+00 },
        /* 168 */ { { max, min }, { inf, inf }, 1.e+00 },
        /* 169 */ { { inf, min }, { inf, inf }, 1.e+00 },
        /* 170 */ { { -inf, 9.9671949510973086e-206 }, { zero, zero }, 1.e+00 },
        /* 171 */ { { -max, 9.9671949510973086e-206 }, { zero, zero }, 1.e+00 },
        /* 172 */ { { -4.0131652080900752e+205, 9.9671949510973086e-206 }, { zero, zero }, 1.e+00 },
        /* 173 */ { { -8.9589789687104559e+102, 9.9671949510973086e-206 }, { zero, zero }, 1.e+00 },
        /* 174 */ { { -1.9999999999998694e+00, 9.9671949510973086e-206 }, { 1.3533528323663035e-01, 1.3489131517814665e-206 }, 4.e+00 },
        /* 175 */ { { -4.4647944971961829e-103, 9.9671949510973086e-206 }, { 1.e+00, 9.9671949510973086e-206 }, 5.e-01 },
        /* 176 */ { { -9.9671949510973086e-206, 9.9671949510973086e-206 }, { 1.e+00, 9.9671949510973086e-206 }, 5.e-01 },
        /* 177 */ { { -min, 9.9671949510973086e-206 }, { 1.e+00, 9.9671949510973086e-206 }, 5.e-01 },
        /* 178 */ { { zero, 9.9671949510973086e-206 }, { 1.e+00, 9.9671949510973086e-206 }, 5.e-01 },
        /* 179 */ { { min, 9.9671949510973086e-206 }, { 1.e+00, 9.9671949510973086e-206 }, 5.e-01 },
        /* 180 */ { { 9.9671949510973086e-206, 9.9671949510973086e-206 }, { 1.e+00, 9.9671949510973086e-206 }, 5.e-01 },
        /* 181 */ { { 4.4647944971961829e-103, 9.9671949510973086e-206 }, { 1.e+00, 9.9671949510973086e-206 }, 5.e-01 },
        /* 182 */ { { 1.9999999999998694e+00, 9.9671949510973086e-206 }, { 7.3890560989296858e+00, 7.3648162642626732e-205 }, 1.25e-01 },
        /* 183 */ { { 8.9589789687104559e+102, 9.9671949510973086e-206 }, { inf, inf }, 1.e+00 },
        /* 184 */ { { 4.0131652080900752e+205, 9.9671949510973086e-206 }, { inf, inf }, 1.e+00 },
        /* 185 */ { { max, 9.9671949510973086e-206 }, { inf, inf }, 1.e+00 },
        /* 186 */ { { inf, 9.9671949510973086e-206 }, { inf, inf }, 1.e+00 },
        /* 187 */ { { -inf, 4.4647944971961829e-103 }, { zero, zero }, 1.e+00 },
        /* 188 */ { { -max, 4.4647944971961829e-103 }, { zero, zero }, 1.e+00 },
        /* 189 */ { { -4.0131652080900752e+205, 4.4647944971961829e-103 }, { zero, zero }, 1.e+00 },
        /* 190 */ { { -8.9589789687104559e+102, 4.4647944971961829e-103 }, { zero, zero }, 1.e+00 },
        /* 191 */ { { -1.9999999999998694e+00, 4.4647944971961829e-103 }, { 1.3533528323663035e-01, 6.0424422787139409e-104 }, 4.e+00 },
        /* 192 */ { { -4.4647944971961829e-103, 4.4647944971961829e-103 }, { 1.e+00, 4.4647944971961829e-103 }, 5.e-01 },
        /* 193 */ { { -9.9671949510973086e-206, 4.4647944971961829e-103 }, { 1.e+00, 4.4647944971961829e-103 }, 5.e-01 },
        /* 194 */ { { -min, 4.4647944971961829e-103 }, { 1.e+00, 4.4647944971961829e-103 }, 5.e-01 },
        /* 195 */ { { zero, 4.4647944971961829e-103 }, { 1.e+00, 4.4647944971961829e-103 }, 5.e-01 },
        /* 196 */ { { min, 4.4647944971961829e-103 }, { 1.e+00, 4.4647944971961829e-103 }, 5.e-01 },
        /* 197 */ { { 9.9671949510973086e-206, 4.4647944971961829e-103 }, { 1.e+00, 4.4647944971961829e-103 }, 5.e-01 },
        /* 198 */ { { 4.4647944971961829e-103, 4.4647944971961829e-103 }, { 1.e+00, 4.4647944971961829e-103 }, 5.e-01 },
        /* 199 */ { { 1.9999999999998694e+00, 4.4647944971961829e-103 }, { 7.3890560989296858e+00, 3.2990617009975154e-102 }, 1.25e-01 },
        /* 200 */ { { 8.9589789687104559e+102, 4.4647944971961829e-103 }, { inf, inf }, 1.e+00 },
        /* 201 */ { { 4.0131652080900752e+205, 4.4647944971961829e-103 }, { inf, inf }, 1.e+00 },
        /* 202 */ { { max, 4.4647944971961829e-103 }, { inf, inf }, 1.e+00 },
        /* 203 */ { { inf, 4.4647944971961829e-103 }, { inf, inf }, 1.e+00 },
        /* 204 */ { { -inf, 1.9999999999998694e+00 }, { zero, zero }, 1.e+00 },
        /* 205 */ { { -max, 1.9999999999998694e+00 }, { zero, zero }, 1.e+00 },
        /* 206 */ { { -4.0131652080900752e+205, 1.9999999999998694e+00 }, { zero, zero }, 1.e+00 },
        /* 207 */ { { -8.9589789687104559e+102, 1.9999999999998694e+00 }, { zero, zero }, 1.e+00 },
        /* 208 */ { { -1.9999999999998694e+00, 1.9999999999998694e+00 }, { -5.6319349992119169e-02, 1.2306002480580015e-01 }, 4.e+00 },
        /* 209 */ { { -4.4647944971961829e-103, 1.9999999999998694e+00 }, { -4.1614683654702367e-01, 9.09297426825736e-01 }, 5.e-01 },
        /* 210 */ { { -9.9671949510973086e-206, 1.9999999999998694e+00 }, { -4.1614683654702367e-01, 9.09297426825736e-01 }, 5.e-01 },
        /* 211 */ { { -min, 1.9999999999998694e+00 }, { -4.1614683654702367e-01, 9.09297426825736e-01 }, 5.e-01 },
        /* 212 */ { { zero, 1.9999999999998694e+00 }, { -4.1614683654702367e-01, 9.09297426825736e-01 }, 5.e-01 },
        /* 213 */ { { min, 1.9999999999998694e+00 }, { -4.1614683654702367e-01, 9.09297426825736e-01 }, 5.e-01 },
        /* 214 */ { { 9.9671949510973086e-206, 1.9999999999998694e+00 }, { -4.1614683654702367e-01, 9.09297426825736e-01 }, 5.e-01 },
        /* 215 */ { { 4.4647944971961829e-103, 1.9999999999998694e+00 }, { -4.1614683654702367e-01, 9.09297426825736e-01 }, 5.e-01 },
        /* 216 */ { { 1.9999999999998694e+00, 1.9999999999998694e+00 }, { -3.0749323206380801e+00, 6.7188496974277738e+00 }, 1.25e-01 },
        /* 217 */ { { 8.9589789687104559e+102, 1.9999999999998694e+00 }, { -inf, inf }, 1.e+00 },
        /* 218 */ { { 4.0131652080900752e+205, 1.9999999999998694e+00 }, { -inf, inf }, 1.e+00 },
        /* 219 */ { { max, 1.9999999999998694e+00 }, { -inf, inf }, 1.e+00 },
        /* 220 */ { { inf, 1.9999999999998694e+00 }, { -inf, inf }, 1.e+00 },
        /* 221 */ { { -inf, 8.9589789687104559e+102 }, { zero, zero }, 1.e+00 },
        /* 222 */ { { -max, 8.9589789687104559e+102 }, { zero, zero }, 1.e+00 },
        /* 223 */ { { -4.0131652080900752e+205, 8.9589789687104559e+102 }, { zero, zero }, 1.e+00 },
        /* 224 */ { { -8.9589789687104559e+102, 8.9589789687104559e+102 }, { zero, zero }, 1.e+00 },
        /* 225 */ { { -1.9999999999998694e+00, 8.9589789687104559e+102 }, { 8.9268873295850301e-02, -1.0171876498084505e-01 }, 4.e+00 },
        /* 226 */ { { -4.4647944971961829e-103, 8.9589789687104559e+102 }, { 6.5961271267128396e-01, -7.5160566075730839e-01 }, 5.e-01 },
        /* 227 */ { { -9.9671949510973086e-206, 8.9589789687104559e+102 }, { 6.5961271267128396e-01, -7.5160566075730839e-01 }, 5.e-01 },
        /* 228 */ { { -min, 8.9589789687104559e+102 }, { 6.5961271267128396e-01, -7.5160566075730839e-01 }, 5.e-01 },
        /* 229 */ { { zero, 8.9589789687104559e+102 }, { 6.5961271267128396e-01, -7.5160566075730839e-01 }, 5.e-01 },
        /* 230 */ { { min, 8.9589789687104559e+102 }, { 6.5961271267128396e-01, -7.5160566075730839e-01 }, 5.e-01 },
        /* 231 */ { { 9.9671949510973086e-206, 8.9589789687104559e+102 }, { 6.5961271267128396e-01, -7.5160566075730839e-01 }, 5.e-01 },
        /* 232 */ { { 4.4647944971961829e-103, 8.9589789687104559e+102 }, { 6.5961271267128396e-01, -7.5160566075730839e-01 }, 5.e-01 },
        /* 233 */ { { 1.9999999999998694e+00, 8.9589789687104559e+102 }, { 4.8739153374953057e+00, -5.5536563916088655e+00 }, 1.25e-01 },
        /* 234 */ { { 8.9589789687104559e+102, 8.9589789687104559e+102 }, { inf, -inf }, 1.e+00 },
        /* 235 */ { { 4.0131652080900752e+205, 8.9589789687104559e+102 }, { inf, -inf }, 1.e+00 },
        /* 236 */ { { max, 8.9589789687104559e+102 }, { inf, -inf }, 1.e+00 },
        /* 237 */ { { inf, 8.9589789687104559e+102 }, { inf, -inf }, 1.e+00 },
        /* 238 */ { { -inf, 4.0131652080900752e+205 }, { zero, zero }, 1.e+00 },
        /* 239 */ { { -max, 4.0131652080900752e+205 }, { zero, zero }, 1.e+00 },
        /* 240 */ { { -4.0131652080900752e+205, 4.0131652080900752e+205 }, { zero, zero }, 1.e+00 },
        /* 241 */ { { -8.9589789687104559e+102, 4.0131652080900752e+205 }, { zero, zero }, 1.e+00 },
        /* 242 */ { { -1.9999999999998694e+00, 4.0131652080900752e+205 }, { 5.4291544962016755e-02, -1.2396800810844819e-01 }, 4.e+00 },
        /* 243 */ { { -4.4647944971961829e-103, 4.0131652080900752e+205 }, { 4.0116327142190517e-01, -9.1600656638589384e-01 }, 5.e-01 },
        /* 244 */ { { -9.9671949510973086e-206, 4.0131652080900752e+205 }, { 4.0116327142190517e-01, -9.1600656638589384e-01 }, 5.e-01 },
        /* 245 */ { { -min, 4.0131652080900752e+205 }, { 4.0116327142190517e-01, -9.1600656638589384e-01 }, 5.e-01 },
        /* 246 */ { { zero, 4.0131652080900752e+205 }, { 4.0116327142190517e-01, -9.1600656638589384e-01 }, 5.e-01 },
        /* 247 */ { { min, 4.0131652080900752e+205 }, { 4.0116327142190517e-01, -9.1600656638589384e-01 }, 5.e-01 },
        /* 248 */ { { 9.9671949510973086e-206, 4.0131652080900752e+205 }, { 4.0116327142190517e-01, -9.1600656638589384e-01 }, 5.e-01 },
        /* 249 */ { { 4.4647944971961829e-103, 4.0131652080900752e+205 }, { 4.0116327142190517e-01, -9.1600656638589384e-01 }, 5.e-01 },
        /* 250 */ { { 1.9999999999998694e+00, 4.0131652080900752e+205 }, { 2.964217917366613e+00, -6.7684239060133287e+00 }, 1.25e-01 },
        /* 251 */ { { 8.9589789687104559e+102, 4.0131652080900752e+205 }, { inf, -inf }, 1.e+00 },
        /* 252 */ { { 4.0131652080900752e+205, 4.0131652080900752e+205 }, { inf, -inf }, 1.e+00 },
        /* 253 */ { { max, 4.0131652080900752e+205 }, { inf, -inf }, 1.e+00 },
        /* 254 */ { { inf, 4.0131652080900752e+205 }, { inf, -inf }, 1.e+00 },
        /* 255 */ { { -inf, max }, { zero, zero }, 1.e+00 },
        /* 256 */ { { -max, max }, { zero, zero }, 1.e+00 },
        /* 257 */ { { -4.0131652080900752e+205, max }, { zero, zero }, 1.e+00 },
        /* 258 */ { { -8.9589789687104559e+102, max }, { zero, zero }, 1.e+00 },
        /* 259 */ { { -1.9999999999998694e+00, max }, { -1.3533361718168704e-01, 6.7152755680157945e-04 }, 4.e+00 },
        /* 260 */ { { -4.4647944971961829e-103, max }, { -9.9998768942655991e-01, 4.961954789184062e-03 }, 5.e-01 },
        /* 261 */ { { -9.9671949510973086e-206, max }, { -9.9998768942655991e-01, 4.961954789184062e-03 }, 5.e-01 },
        /* 262 */ { { -min, max }, { -9.9998768942655991e-01, 4.961954789184062e-03 }, 5.e-01 },
        /* 263 */ { { zero, max }, { -9.9998768942655991e-01, 4.961954789184062e-03 }, 5.e-01 },
        /* 264 */ { { min, max }, { -9.9998768942655991e-01, 4.961954789184062e-03 }, 5.e-01 },
        /* 265 */ { { 9.9671949510973086e-206, max }, { -9.9998768942655991e-01, 4.961954789184062e-03 }, 5.e-01 },
        /* 266 */ { { 4.4647944971961829e-103, max }, { -9.9998768942655991e-01, 4.961954789184062e-03 }, 5.e-01 },
        /* 267 */ { { 1.9999999999998694e+00, max }, { -7.3889651354119268e+00, 3.6664162297633855e-02 }, 1.25e-01 },
        /* 268 */ { { 8.9589789687104559e+102, max }, { -inf, inf }, 1.e+00 },
        /* 269 */ { { 4.0131652080900752e+205, max }, { -inf, inf }, 1.e+00 },
        /* 270 */ { { max, max }, { -inf, inf }, 1.e+00 },
        /* 271 */ { { inf, max }, { -inf, inf }, 1.e+00 },
        /* 272 */ { { -inf, inf }, { nan, nan }, 1.e+00 },
        /* 273 */ { { -max, inf }, { nan, nan }, 1.e+00 },
        /* 274 */ { { -4.0131652080900752e+205, inf }, { nan, nan }, 1.e+00 },
        /* 275 */ { { -8.9589789687104559e+102, inf }, { nan, nan }, 1.e+00 },
        /* 276 */ { { -1.9999999999998694e+00, inf }, { nan, nan }, 1.e+00 },
        /* 277 */ { { -4.4647944971961829e-103, inf }, { nan, nan }, 1.e+00 },
        /* 278 */ { { -9.9671949510973086e-206, inf }, { nan, nan }, 1.e+00 },
        /* 279 */ { { -min, inf }, { nan, nan }, 1.e+00 },
        /* 280 */ { { zero, inf }, { nan, nan }, 1.e+00 },
        /* 281 */ { { min, inf }, { nan, nan }, 1.e+00 },
        /* 282 */ { { 9.9671949510973086e-206, inf }, { nan, nan }, 1.e+00 },
        /* 283 */ { { 4.4647944971961829e-103, inf }, { nan, nan }, 1.e+00 },
        /* 284 */ { { 1.9999999999998694e+00, inf }, { nan, nan }, 1.e+00 },
        /* 285 */ { { 8.9589789687104559e+102, inf }, { nan, nan }, 1.e+00 },
        /* 286 */ { { 4.0131652080900752e+205, inf }, { nan, nan }, 1.e+00 },
        /* 287 */ { { max, inf }, { nan, nan }, 1.e+00 },
        /* 288 */ { { inf, inf }, { nan, nan }, 1.e+00 }  // clang-format on
      };
      return table;
    } else {
      static_assert(dependent_false<T>); /* unreachable */
    }
  }
};

// NOLINTEND(whitespace/line_length)
}  // namespace complex_unary_op_samples

#endif  // XLA_TESTS_COMPLEX_UNARY_OP_SAMPLES_H_
