/* Copyright 2026 The OpenXLA Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
==============================================================================*/

#ifndef XLA_TSL_UTIL_FILE_TOC_H_
#define XLA_TSL_UTIL_FILE_TOC_H_

// This file defines the structure of the table-of-contents elements
// produced by cc_embed_data rules. Its canonical definition is
// xla/tsl/util/file_toc.h, but a copy of it appears in each file generated by
// //xla/tsl/util:filewrapper.
//
// For information on how to use this class and API guarantees made by
// cc_embed_data rules, see //xla/tsl/util/cc_embed_data.bzl.

#include <stddef.h>

struct FileToc {
  const char* name;
  const char* data;
  size_t size;
  unsigned char md5digest[16];
};

#endif  // XLA_TSL_UTIL_FILE_TOC_H_
