## Contributing

So, you want to add a library to this list? Amazing, I'd love it! Here's how to progress:

1. Verify that the library fits the rules of this list:
  1. Size is under 2Kb-ish, min + gzip, with all deps, except for special categories.
  2. For tree-shakable libraries, the size of a useful subset must be under 2Kb-ish.
  3. Second-level libraries only allowed for React, Vue, Angular, svelte. The size of the framework is excluded from the size limit.
  4. Useful client-side — no node.js exclusive libraries and dev / build tooling.
  5. 100+ GitHub stars _or_ 500+ weekly npm installs for the last 4 weeks.
  6. The library _must_ contain _some_ JS.
2. Check if the library is not already in [WIP.](./WIP.md)
3. Open README.md in [GitHub editor](https://github.com/thoughtspile/awesome-tiny-js/edit/main/README.md) or by clicking the _pencil_ icon [on top of the file](https://github.com/thoughtspile/awesome-tiny-js/blob/main/README.md)
4. Add the proposed library in [GitHub flavord markdown](https://help.github.com/articles/github-flavored-markdown/)
5. Say what you're adding, and click "Propose changes"

Looking forward to your submissions!
