# Contribution Guidelines
Before submitting a pull request, please:

- Search previous suggestions before making a new one, as yours may be a duplicate.
- Make sure the list is useful before submitting. That implies it has enough content and every item has a succinct description.
- Make an individual pull request for each suggestion.
- Use [title-casing](http://titlecapitalization.com) (AP style).
- Use the following format: `[Item Name](URL)`
- Link additions should be added to the bottom of the relevant category.
- New categories or improvements to the existing categorization are welcome.
- Check your spelling and grammar.
- Make sure your text editor is set to remove trailing whitespace.
- The pull request and commit should have a useful title.
- The body of your commit message should contain a link to the repository.
- Check that it is not already in the list.
- Make sure that it is not an outdated resource that is no longer useful.
- It does not link to an illegal source.
- Finally, please remember that every link and contribution no matter how small it is, is highly appreciated and encouraged as it helps gather all the resources in one place.

These guidelines were adapted from [here](https://github.com/kiloreux/awesome-robotics/blob/master/CONTRIBUTING.md).
