<p align="center">
  <a href="https://github.com/tobiasbueschel/awesome-pokemon/">
    <img alt="Awesome Pokémon" src="logo.png" width="700">
  </a>
</p>

<div align="center">

<p align="center">
  A curated list of awesome <a href="http://www.pokemon.com/">Pokémon</a> & <a href="http://www.pokemongo.com/">Pokémon GO</a> resources, tools and more.
</p>

<p align="center">
  <a href="https://github.com/sindresorhus/awesome"><img alt="Awesome Badge" src="https://awesome.re/badge-flat.svg"></a>
  <a href="https://github.com/tobiasbueschel/awesome-pokemon/pulls"><img alt="Pull Requests Welcome" src="https://img.shields.io/badge/PRs-welcome-brightgreen.svg?style=flat-square"></a>
</p>

<p>
<i>Looking for contributors. Submit a pull request if you have something to add :) </i><br>  
Please check the <a href="https://github.com/tobiasbueschel/awesome-pokemon/blob/master/contributing.md">contribution guidelines</a> for info on formatting and writing pull requests.
</p>

</div>


## Contents
- [Development Projects](#development-projects)
    - [APIs](#apis)
    - [Apps](#apps)
    - [Bots](#bots)
    - [Miscellaneous](#miscellaneous)
- [Resources & Others](#resources--others)
    - [Communities](#communities)
    - [Official](#official)
    - [Maps](#maps)
    - [Tips & Tricks](#tips--tricks)
    - [Wiki](#wiki)
    - [Others](#others)

## Development Projects
#### APIs
- [PokeAPI](https://github.com/PokeAPI/pokeapi/) - A RESTful API for Pokémon (http://pokeapi.co/).
- [pgoapi](https://github.com/tejado/pgoapi) - Pokémon GO API lib/demo.
- [pokemon-API](https://github.com/Purukitto/pokemon-api) - Beginner friendly API endpoint that returns Pokémon Data in JSON format (https://app.pokemon-api.xyz).
- [Pokemon-GO-node-api](https://github.com/Armax/Pokemon-GO-node-api) - Pokémon GO API Node.js library.
- [Pokemon-Go-Rocket-API](https://github.com/FeroxRev/Pokemon-Go-Rocket-API) - Client API library for Pokémon GO in C#.
- [Pokemon GO Java API](https://github.com/Grover-c13/PokeGOAPI-Java) - Pokémon GO API for Java.
- [Pokemon Name API](https://github.com/sindresorhus/pokemon) - Get a list of Pokémon names in JSON.
- [PokemonGO-Pokedex](https://github.com/Biuni/PokemonGO-Pokedex) - Pokédex of Pokémon GO in JSON.
- [PokeTypes](https://github.com/fbosch/poke-types) - Get Pokémon types, weaknesses and strengths.
- [TCGdex](https://github.com/tcgdex/cards-database) - Multi languages Pokémon TCG API.
- [Kotlin-Pokedex](https://github.com/mrcsxsiq/Kotlin-Pokedex) - Pokedex app built with Kotlin.
- [graphql-pokemon](https://github.com/lucasbento/graphql-pokemon) - Get information of a Pokémon with GraphQL.

#### Apps
- [Pokemon-Showdown](https://github.com/Zarel/Pokemon-Showdown) - Pokémon battle simulator.
- [iPokeMon](https://github.com/Kjuly/iPokeMon) - Pokémon like game on iOS with Location Based Service.
- [pokemon-online](https://github.com/po-devs/pokemon-online) - Online Pokémon Battle Simulator.
- [Shuffle-Move](https://github.com/Loreinator/Shuffle-Move) - A program to identify and display the best next move for the game Pokémon Shuffle.
- [pokecry](https://github.com/fent/pokecry) - Guess Pokémon from their cry.
- [Pokedex](https://github.com/skydoves/Pokedex) - Android Pokedex using Dagger, Hilt, Motion, Coroutines, Flow, and Jetpack.
- [Who's That Pokémon?](https://github.com/serena2341/whos-that-pokemon) - Guess Pokémon from their silhouette.

#### Bots
- [Pokemon Go Bot](https://github.com/Hrithikd/Pokemon-Go-Bot-Working-Hack-API) - Pokémon GO bot that farms for Pokestops and Pokémon.
- [slack-pokemon](https://github.com/rvinluan/slack-pokemon) - A bot for having Pokémon battles in Slack.
- [PokeSlack](https://github.com/timwah/pokeslack) - Alerts you of nearby Pokémon.
- [TwitchPlaysPokemon](https://github.com/sunshinekitty/TwitchPlaysPokemon) - A bot mimicking Twitch Plays Pokémon.
- [PokemonGo-Bot](https://github.com/PokemonGoF/PokemonGo-Bot) - The Pokémon GO bot script, baking with community.
- [Poketrainer](https://github.com/j-e-k/poketrainer) - A fast and feature filled bot in Python.
- [PokeBot](https://github.com/akbaryahya/PokeBot) - The automated Pokémon speedrunning machine.
- [PokemonGoBot](https://github.com/jabbink/PokemonGoBot) - Bot that plays Pokémon GO.
- [Bot Builder for PokemonGoBot](https://github.com/shilch/pogobot-builder) - Simply build your Pokémon GO bot.
- [PokeBuddy](https://github.com/finndev/PokeBuddy) - A Pokémon GO bot.

#### Miscellaneous
- [alfred-pokedex](https://github.com/vutran/alfred-pokedex) - Alfred 3 workflow to lookup information about Pokémon.
- [hyper-pokemon](https://github.com/hyper-pokemon/hyper-pokemon) - Wondrous, tailor-made Pokémon themes for your Hyper terminal.
- [Pokemon-Go-Controller](https://github.com/kahopoon/Pokemon-Go-Controller) - Play Pokémon GO safely or at unavailable area.
- [pokecrystal](https://github.com/pret/pokecrystal) - Disassembly of Pokémon Crystal.
- [x-pokemon](https://github.com/passy/x-pokemon) - A web component to display Pokémon.
- [pokered](https://github.com/pret/pokered) - Disassembly of Pokémon Red/Blue.
- [pokemon-reverse-engineering-tools](https://github.com/pret/pokemon-reverse-engineering-tools) - Tools for compiling and disassembling Pokémon Red and Pokémon Crystal.
- [pokemon-go-mitm-node](https://github.com/rastapasta/pokemon-go-mitm-node) - Pokémon GO MITM Proxy.
- [PokeMMO](https://github.com/maierfelix/PokeMMO) - WebGL Pokémon MMO Engine with Realtime Editor.
- [pogo-optimizer](https://github.com/justinleewells/pogo-optimizer) - Shows you the IVs and information necessary to determine which Pokémon get ground into candy.
- [PoGoTools](https://github.com/nelsyeung/PoGoTools) - A set of CLI tools for getting IVs, transferring Pokémon, evolving Pokémon, and trashing items.
- [slack-pokemon-emoji](https://github.com/fraserxu/slack-pokemon-emoji) - A tool to upload all the Pokémon to Slack emoji.
- [slack-emoji-pokemon](https://github.com/Templarian/slack-emoji-pokemon) - A list of Pokémon emojis for Slack.
- [PokemonGO-IV-Renamer](https://github.com/Boren/PokemonGO-IV-Renamer) - Automatically renames your Pokémon to their IV stats.
- [pokemongo-genymotion](https://github.com/jlobos/pokemongo-genymotion) - Play Pokémon GO from your Genymotion device.
- [pokemongo-game-master](https://github.com/BrunnerLivio/pokemongo-game-master) - Collection of Pokémon GO Game Master versions.
- [Pokemon-Terminal](https://github.com/LazoCoder/Pokemon-Terminal) - Pokémon terminal themes for iTerm2.
- [pokemon-cli](https://github.com/sindresorhus/pokemon-cli) - CLI to get Pokémon names.
- [pokesprite](https://github.com/msikma/pokesprite) - Database of Pokémon sprites from the core series games, including custom shiny versions.
- [PokéPalettes](https://github.com/BarryMode/pokepalettes) - 16-bit palettes that represent Pokémon (based on the models from Pokémon GO).
- [PokemonRedExperiments](https://github.com/PWhiddy/PokemonRedExperiments) - Playing Pokémon Red with Reinforcement Learning.

## Resources & Others
#### Communities
- [/r/pokemongo](https://www.reddit.com/r/pokemongo/) - Pokémon GO Subreddit.
- [/r/pokemongodev](https://www.reddit.com/r/pokemongodev) - Reverse engineering game/API.
- [/r/thesilphroad](https://www.reddit.com/r/thesilphroad) - Very indepth game discussion and such.
- [RazerGo](https://go.razerzone.com/) - Localized Pokémon GO chat.
- [PokeDates](https://www.projectfixup.com/pokedates/) - The first-ever Pokémon GO dating service.
- [The PokéCommunity](https://www.pokecommunity.com/index.php) - A dedicated forum to everything Pokémon.
- [Pokémon GO Raiders Discord](https://www.pogoraiders.gg/discord) - A Discord community for raid hosting and joining with discussions about Pokémon GO.

#### Official

| Pokémon                                                  |           Pokémon GO          |            Niantic                      |
| :------------------------------------------------------  | :---------------------------- | :-------------------------------------- |
| [Website](http://www.pokemon.com/) | [Website](http://www.pokemongo.com/) | [Website](https://www.nianticlabs.com/) |
| [YouTube](https://www.youtube.com/user/pokemon) | [YouTube](https://www.youtube.com/channel/UCA698bls2pjQyiqP9N-iaeg) | [YouTube](https://www.youtube.com/channel/UCJZnyHeWyS_5abW0qnFNHMg) |
| [Twitter](https://twitter.com/pokemon) | [Twitter](https://twitter.com/PokemonGoApp) | [Twitter](https://twitter.com/NianticLabs) |
| [Facebook](https://www.facebook.com/Pokemon/) | [Facebook](https://www.facebook.com/PokemonGO/) | [Facebook](https://www.facebook.com/nianticlabs) |
| [Instagram](https://www.instagram.com/pokemon/?hl=en) | [Instagram](https://www.instagram.com/pokemongoapp/?hl=en) | [Instagram](https://www.instagram.com/nianticlabs/?hl=en) |
| [TikTok](https://www.tiktok.com/@pokemonofficial?lang=en) | [TikTok](https://www.tiktok.com/@pokemongo?lang=en) | [TikTok](https://www.tiktok.com/@niantic?lang=en) |

#### Maps
- [PokemonGo-Map](https://github.com/AHAAAAAAA/PokemonGo-Map) - Live visualization of all the Pokémon in your area and more.
- [PokemonGo-DesktopMap](https://github.com/mchristopher/PokemonGo-DesktopMap) - Electron app for Pokémon GO that shows Pokémon nearby.
- [pokelocater](https://github.com/emeth-/pokelocater) - Display Pokémon nearby your location on a map.
- [Pokemap](https://github.com/omkarmoghe/Pokemap) - A native Android client to map the Pokémon around you.
- [Poke Vision](https://pokevision.com/) - Find Pokémon by location.
- [iPokeGo](https://github.com/istornz/iPokeGo) - A native iOS client to map the Pokémon around you.

#### Tips & Tricks
- [TechCrunch](https://techcrunch.com/gallery/pokemon-go-tips/) - 13 ways to be better at Pokémon GO.
- [Imore](http://www.imore.com/Pokemon-go-tips-tricks-cheats) - Pokémon GO: 21 tips, tricks, and cheats to be the best trainer in the world.
- [Mashable](http://mashable.com/2016/07/08/how-to-play-pokemon-go/#7iz7HhcepPqi) - How to be the best, least annoying, Pokémon GO trainer.
- [Heavy](http://heavy.com/games/2016/07/pokemon-go-cheats-tips-tricks-guide-walkthrough-gps-spoof-fake-pikachu-starter-get-coins-throw-candy-incense-footsteps-pokestops-driving-lucky-eggs/) - Pokémon GO: 10 Cheats, Tip & Tricks You Need to Know.

#### Wiki
- [Pokedex](https://github.com/veekun/pokedex) - More than you ever wanted to know about Pokémon.
- [Pokedex.org](https://github.com/nolanlawson/pokedex.org) - Offline-capable Pokédex web site https://pokedex.org.
- [Pokemon GO Wiki Guide by IGN](http://www.ign.com/wikis/pokemon-go)
- [Pokémon GO Wiki](https://pkmngowiki.com/)
- [Pokémon GO Wikipedia](https://en.wikipedia.org/wiki/Pok%C3%A9mon_Go)
- [GamePress](https://pokemongo.gamepress.gg/)
- [Pokémon Go Info](https://pokemon.gameinfo.io/)

#### Others
- [Silphroad](https://thesilphroad.com/research) - Pokémon GO tools & reference charts.
- [Server Status](http://www.mmoserverstatus.com/pokemon_go) - Shows you if Pokémon GO is down.
- [Egg Statistics](https://app.cmmcd.com/) - Pokémon GO Egg Reporter.
- [Poke Assistant](https://pokeassistant.com/) - Collection of calculators for Pokémon GO.
- [Calcy IV](https://play.google.com/store/apps/details?id=tesmath.calcy) - One-tap stats and level calculation on Pokémon GO (Android).
- [InfoSpreadsheet](https://docs.google.com/spreadsheets/d/1iJcE12v14GA8V8EO4M1-dPxBFT2kFhR6bUXvj03a4kM/) - Datamined info about Pokémon GO species with IV calculations.
- [InfoSpreadsheet#2](https://docs.google.com/spreadsheets/d/1hcFo7-UGWx1k1u1BHOvDhq8foPeRr7YbX2jLjjJK0Qw/) - Pokémon GO species data with their movesets.
- [PVPoke](https://pvpoke.com/) - A PVP ranking and moveset for Pokémon GO.
- [Pokémon GO Calender](https://pokemoncalendar.com/) - Pokémon GO calender events with Google Calendar and timezones support.
- [Poke Genie](http://www.pokegenie.net/) - A free raid hosting and joining app for [iOS](https://apps.apple.com/us/app/poke-genie-remote-raid-iv-pvp/id1143920524) & [Android](https://play.google.com/store/apps/details?id=com.cjin.pokegenie.standard) with PVP functionalities.

## License
[![CC0](http://mirrors.creativecommons.org/presskit/buttons/88x31/svg/cc-zero.svg)](https://creativecommons.org/publicdomain/zero/1.0/)

To the extent possible under law, [Tobias Bueschel](http://github.com/tobiasbueschel) has waived all copyright and related or neighboring rights to this work.
