# Cognita Contribution Guidelines

Welcome to the Cognita community! We're thrilled that you're interested in contributing to the Cognita project. Cognita is a collaborative open-source project, and we believe that everyone has something unique to contribute. Below you'll find our guidelines which aim to make contributing to Cognita a respectful and pleasant experience for everyone.

## 🌟 Community and Open Source

Open source is at the heart of Cognita. We appreciate feedback, ideas, and enhancements from the community. Whether you're looking to fix a bug, add a new feature, or simply improve the documentation, your contribution is important to us.

## 📚 Before You Begin

Before contributing, please take a moment to read through the [README](./README.md) as it provides a comprehensive understanding of the project and are essential reading to ensure that we're all on the same page.

## 🐛 Reporting Issues

If you've identified a bug or have an idea for an enhancement, please begin by creating an Issue. Here's how:

-   Check the Issue tracker to ensure the bug or enhancement hasn't already been reported.
-   Clearly describe the issue including steps to reproduce when it is a bug.
-   Include as much relevant information as possible.

## 💡 Ideas and Feedback

We welcome all ideas and feedback. If you're not ready to open an Issue or if you're just looking for a place to discuss ideas, head over to our [GitHub Discussions](https://github.com/truefoundry/docs-qa-playground/discussions).


## 📝 Pull Requests

If you're ready to contribute code or documentation, please submit a Pull Request (PR) to the dev branch. Here's the process:

-   Fork the repository and create your branch from `main`.
-   Ensure that your code adheres to the existing code style. Use [Black](https://github.com/psf/black) for formatting Python code.
-   If you're adding a new feature, consider writing unit tests and documenting the feature.
-   Make sure your code lints (mypy compatibility is optional but encouraged).
-   Include a clear description of your changes in the PR.
-   Link to the Issue in your PR description.

### 🧪 Tests and Formatting

To maintain the quality of the codebase, we ask that all contributors:

-   Create and run unit tests to ensure that nothing is broken.
-   Use [Black](https://github.com/psf/black) to format your code before submitting.

### 🔄 Pull Request Process

-   PRs are reviewed on a regular basis.
-   Engage in the conversation and make requested updates to your PR if needed.
-   Once approved, your PR will be merged into the main branch by a maintainer.

## 🗨️ Stay Connected

We encourage you to participate in discussions. Stay connected, share ideas, and get to know fellow contributors.

Your contributions not only help improve the project but also the wider community of users and developers.

Happy contributing!
