<div align="center" style="margin: 12px">
  <a href="https://en.wikipedia.org/wiki/Digital_product_design">
    <img src="./images/apd-icon.png" width="140">
  </a>
</div>

# Awesome Product Design [![Awesome](https://awesome.re/badge-flat2.svg)](https://awesome.re)

> A collection of bookmarks, resources, articles for product designers.

[Digital product design](https://en.wikipedia.org/wiki/Digital_product_design) is an iterative design process to solve a functional problem with a formal solution. A digital product designer identifies a real problem, offers the best possible solution, and launch it to a market that is showing demand for that particular solution.

Feel free to [add something interesting](contributing.md) by pull request.

## Contents
- [Research](#research)
- [UX](#ux)
- [UI](#ui)
- [Visual](#visual)
- [Prototype](#prototype)
- [Accessibility](#accessibility)
- [Writing](#writing)
- [Data](#data)
- [IoT](#iot)

## Research
#### Methods
###### Decision Making
- [Untools](https://untools.co) - Thinking tools and frameworks to help you solve problems, make decisions and understand systems.
###### Research Plan
- [Smashing Magazine](https://www.smashingmagazine.com/2012/01/ux-research-plan-stakeholders-love/) - The UX Research Plan That Stakeholders Love.
- [NN Group](https://www.nngroup.com/articles/pm-research-plan/) - Project Management for User Research: The Plan.
- [Interaction Design](https://www.interaction-design.org/literature/article/a-one-page-user-research-plan) - One Page User Research Plan.
- [Branding5](https://www.branding5.com/) - Make a brand positioning as a basis for your designs.
###### User Interview
- [NN Group](https://www.nngroup.com/articles/interviewing-users/) - Despite many weaknesses, interviews are a valuable method for exploratory user research.
- [UXDesign.cc](https://uxdesign.cc/how-to-get-the-most-out-of-user-interviews-c5d0cd4499b5) - How to Get the Most Out of User Interviews.
###### Stakeholder Interviews
- [Boxes and Arrows](https://boxesandarrows.com/a-stakeholder-interview-checklist/) - Cheat Sheet For Interviewing Stakeholders.
- [UX Apprentice](https://www.uxapprentice.com/resources/stakeholder-interview-template/) - Stakeholder Interview Template.
- [Interaction Design](https://www.interaction-design.org/literature/article/preparing-for-ux-stakeholder-interviews) - Preparing for UX Stakeholder Interviews.
###### Research Synthesis
- [UX Movement](https://uxmovement.com/thinking/how-to-turn-user-research-into-usable-data/) - How to Turn User Research into Usable Data.
- [SlideShare](https://www.slideshare.net/HJKwon3/design-research-synthesis) - Design Research Synthesis.
- [Medium](https://medium.com/product-labs/using-trello-for-user-research-synthesis-fb1abdfc7c4b) - Using Trello for User Research Synthesis.
- [Tuts+](https://webdesign.tutsplus.com/tutorials/how-to-prepare-and-use-an-affinity-diagram--cms-28388) - How to Prepare and Use an Affinity Diagram.
- [Medium](https://medium.com/learning-ux/affinity-diagrams-tips-and-tricks-6225e8c1f0df) - Affinity Diagrams: Tips and Tricks.
###### Competitive Analysis
- [Xtensio](https://xtensio.com/how-to-create-a-competitive-analysis/) - How To: Create A Competitive Analysis.
- [Hootsuite](https://blog.hootsuite.com/the-ultimate-competitive-analysis-template/) - Competitive Analysis Template To Help You Outsmart The Competition.
###### Job to be Done
- [Intercom](https://blog.intercom.com/using-job-stories-design-features-ui-ux/) - Designing features using Job Stories.
- [JTBD](https://jtbd.info/replacing-the-user-story-with-the-job-story-af7cdee10c27) - Replacing The User Story With The Job Story.
###### Personas
- [Usability.Gov](https://www.usability.gov/how-to-and-tools/methods/personas.html) - The purpose of personas is to create reliable and realistic representations of your key audience.
- [UX Mag](https://uxmag.com/articles/personas-the-foundation-of-a-great-user-experience) - Personas: The Foundation of a Great User Experience.
- [Tuts+](https://webdesign.tutsplus.com/articles/defining-and-applying-personas-to-ux-design--webdesign-7561) - Defining And Applying Personas to UX Design.
###### Empathy Map
- [UX Pin](https://www.uxpin.com/studio/blog/the-practical-guide-to-empathy-maps-creating-a-10-minute-persona/) - The Practical Guide to Empathy Maps: 10-Minute User Personas.
- [Boagworld](https://boagworld.com/usability/adapting-empathy-maps-for-ux-design/) - Adapting empathy maps for UX design.
###### Storyboard
- [UX Magazine](https://uxmag.com/articles/storyboarding-in-the-software-design-process) - Storyboarding in the Software Design Process.
- [Medium](https://uxplanet.org/storyboarding-in-ux-design-b9d2e18e5fab) - Storyboarding in UX Design.
- [NN Group](https://www.nngroup.com/articles/customer-journey-mapping/) - When and How to Create Customer Journey Maps.
- [UX Lady](https://www.ux-lady.com/experience-maps-user-journey-and-more-exp-map-layout/) - Experience maps, user journeys and more.
- [Smashing Magazine](https://www.smashingmagazine.com/2015/01/all-about-customer-journey-mapping/) - All You Need To Know About Customer Journey Mapping.
- [Medium](https://medium.com/@wnialloconnor/how-to-build-an-experience-map-5e55b7ee4f32) - How to build an experience map.
#### Articles
- [Smashing Magazine](https://www.smashingmagazine.com/2013/04/rainbow-spreadsheet-collaborative-ux-research-tool/) - The Rainbow Spreadsheet: A Collaborative Lean UX Research Tool.
- [Coglode](https://coglode.com/) - Bite-size behavioral research analysis.
#### Testing
- [User Testing](https://www.usertesting.com/) - Unlock customer insights and increase your revenue.
- [Optimal Workshop](https://www.optimalworkshop.com/) - User Research Platform that helps you and your team make design decisions with confidence.
- [Measure Success](https://www.sitepoint.com/how-do-you-measure-the-success-or-failure-of-your-ux-design/) - How Do You Measure the Success (or Failure) - of Your UX Design?.
- [Lookback](https://lookback.io/) - Simple, powerful user research.
- [Full Story](https://www.fullstory.com/) - What do you want to know about your customer experience?.
- [Desinion](https://www.desinion.com/) - Make smart and informed design decisions for your company, or your client's company.
- [Survey Monkey](https://www.surveymonkey.com/) - Turn instincts into insights.
- [Etnio](https://ethn.io/) - Intercept Real People for User Research.

## UX
#### Guidelines
- [The UX Bookmark](https://www.theuxbookmark.com/) - Collection of the best UX websites from across the globe.
- [Gov.Uk](https://www.gov.uk/service-manual/) - Helping government teams create and run great digital services.
- [Methods 18F](https://methods.18f.gov/) - Collection of tools to bring human-centered design into your project.
- [Guides 18F](https://guides.18f.gov/) - 18F Guides is the repository for best practices across our teams.
- [Usability.Gov](https://www.usability.gov/) - Improving the User Experience.
- [Medial Lab Amsterdam](https://medialabamsterdam.com/toolkit/) - Design method toolkit.
- [Design Kit IDEO](https://www.designkit.org/methods) - Step-by-step guide to unleashing your creativity.
- [Gamestorming](https://gamestorming.com/) - Gamestorming is a set of co-creation tools used by innovators around the world.
#### Articles
- [UX Magazine](https://uxmag.com/) - UX Magazine is a free community resource exploring all facets of experience design.
- [UX Booth](https://www.uxbooth.com/) - The UX Booth is a publication by and for the user experience community.
- [UX Mastery](https://uxmastery.com/) - We help user experience professionals get started and get better.
- [UX Myths](https://uxmyths.com/) - Build your product based on evidence, not false beliefs.
- [A List Apart](https://alistapart.com/) - List Apart explores the design, development, and meaning of web content.
- [52 Weeks of UX](https://52weeksofux.com/) - Discourse on the process of designing for real people.
- [UX Pin](https://www.uxpin.com/studio/) - Guides, articles and ebooks that explore all facets of UX Design.
- [The IxD Library](https://theixdlibrary.com/) - Collection of materials related to Interaction Design.
- [LukeW](https://www.lukew.com/ff) - Publications on the critical details and big picture behind digital product design.
- [NN Group](https://www.nngroup.com/articles/) - Evidence-Based User Experience Research, Training, and Consulting.
- [Information Design](https://www.informationdesign.org/) - InfoDesign Hand-picked since 1997.
- [Intercom](https://blog.intercom.com/) - Design, Customer Success, & Startup Blog.
- [UXDesign.cc](https://uxdesign.cc/) - User Experience, Usability, Product Design. Follow the UXDesign.cc.
- [UX Reactions](https://uxreactions.com/) - Fun stuff.
#### Tools
- [UX Recipe](https://uxrecipe.github.io/) - This project is a personal manifesto against the objectification of the term "UX".
- [UX Checklist](https://uxchecklist.github.io/) - UX Project Checklist.
- [UX Stackexchange](https://ux.stackexchange.com/) - UX Stack Exchange is a question and answer site.

## UI
#### Guidelines
- [Ant Design](https://ant.design) - An UI design language for enterprise applications.
- [iOS Guidelines](https://developer.apple.com/design/) - Get in-depth information and UI resources for designing great apps that integrate seamlessly with Apple platforms.
- [Google Material](https://material.io/) - Material Design is a unified system that combines theory, resources, and tools for crafting digital experiences.
- [Google Design](https://design.google.com/) - Google Design is a cooperative effort led by a group of designers, writers, and developers at Google.
- [Facebook Design](https://facebook.design/) - Collection of articles, videos, and resources made by designers at Facebook.
- [UsTwo](https://ustwo.com/blog/the-ustwo-pixel-perfect-precision-handbook-3/) - Pixel Perfect Precision Handbook 3.
#### Inspiration
- [Pttrns](https://pttrns.com/) - The mother of all design resources.
- [Call To Idea](https://www.calltoidea.com/) - Light up your imagination!.
- [Android Niceties](https://androidniceties.tumblr.com/) - Aiming to provide inspiration and insight into Android UI conventions.
- [Lovely UI](https://www.lovelyui.com/) - Collection of mobile UI elements.
- [Brian Lovin](https://www.brianlovin.com/) - Visual exploration of the best products.
- [Sloppy UI](https://sloppyui.tumblr.com/) - It's all about intellectual honesty, not trolling.
#### Tools
- [Pattern Lab](https://patternlab.io/) - Create atomic design systems with Pattern Lab.
- [Huge](https://hugeinc.github.io/styleguide/index.html) - Tool to make creating and maintaining styleguides easy.
- [Figma Bootstrap 5 UI Kit](https://themeselection.com/products/free-figma-bootstrap-ui-kit/) - UI Kit comprising 300+ organized Bootstrap 5 components built with atomic design system & auto layout. 
- [Sketch Bootstrap 5 UI Kit](https://themeselection.com/products/free-sketch-bootstrap-ui-kit/) - UI Kit comprising 300+ organized Bootstrap 5 components built with atomic design system & smart layout.

## Visual
#### Resources
- [Design Principles FTW](https://www.designprinciplesftw.com/) - The biggest collection of Design Principles on the Internet.
- [Awesome Design Systems](https://github.com/alexpate/awesome-design-systems) - Curated list of design systems, patterns libraries, and everything in between.
- [Awesome Sketch](https://github.com/diessica/awesome-sketch) - Curated list of awesome Sketch videos, articles, plugins, whatever, for designers, developers, or neither.
#### Icons
- [Icon Finder](https://www.iconfinder.com/) - Search through 1,739,045 icons or browse 42,226 icon sets.
- [We Love Icon Font](https://weloveiconfonts.com/) - This is a free & open source icon fonts hosting service.
- [The Noun Project](https://thenounproject.com/) - Icons for everything.
- [Iconmonstr](https://iconmonstr.com/) - Discover 3847+ free simple icons in 263 collections.
#### Font Foundries
- [Open Foundry](https://open-foundry.com/) - New platform for open-source fonts in a noise-free environment.
- [Use & Modify](https://usemodify.com/) - Provide a contemporary set of fonts distributed under libre or open source licences, hand picked by a typography and free culture lover.
- [Font Fabric](https://www.fontfabric.com/) - Fontfabric is an independent type foundry.
- [Font Squirrel](https://www.fontsquirrel.com/) - Free Font Utopia.
- [Play Type](https://playtype.com/) - Browse through our selection of more than a hundred fonts and nearly 500 different font weights.
#### Typography
- [NN Group](https://www.nngroup.com/articles/typography-terms-ux/) - Typography Terms Cheat Sheet.
#### Colors
- [Coolors](https://coolors.co/) - The super fast color schemes generator!.
- [Colour Lovers](https://www.colourlovers.com/) - Creative community.
- [Color Hunt](https://colorhunt.co/) - Color Hunt is a social platform for everyone who love colors.
- [Atmos](https://atmos.style/) - Everything you need to create color palettes
- [Branition Colors](https://branition.com/colors) - Hand-curated collection of color palettes best fitted for branding.

#### Stock Images
- [Unsplash](https://unsplash.com/) - Free (do whatever you want) - high-resolution photos.
- [StockSnap](https://stocksnap.io/) - Hundreds of high resolution images added weekly.
- [Pixbay](https://pixabay.com/) - Free images and videos you can use anywhere.
- [Jay Mantry](https://jaymantri.com/) - Free pics (CC0).
- [Get Refe](https://getrefe.tumblr.com/) - Royalty-free, high-quality, Real Life photos.
- [ISO Republic](https://isorepublic.com/) - ISO Republic provides free stock photos for creative professionals.
- [All The Free Stock](https://allthefreestock.com/) - Get all the Free Stock Images, Videos, Music and Icons in one location.
- [Pexels](https://www.pexels.com) - Free stock images in a range of styles including filtered, natural, and commercial.
- [unDraw](https://undraw.co) - Open-source illustrations for every project you can imagine and create.
#### Stock Videos
- [Vimeo](https://vimeo.com/channels/freestockfootage/) - Royalty Free Stock Video for Free Personal, Corporate or Commercial Use.
#### Tools
- [Polarr](https://photoeditor.polarr.co/) - Photo Editor.
- [Licecap](https://www.cockos.com/licecap/) - Simple animated screen captures.
- [Hand Brake](https://handbrake.fr/) - HandBrake is a tool for converting video from nearly any format to a selection of modern, widely supported codecs.

## Prototype
#### Articles
- [The 12 Principles](https://the12principles.tumblr.com/) - The 12 basic principles of animation were developed by the ‘old men’ of Walt Disney Studios.
- [Hoverstat](https://hoverstat.es/) - The home of alternative digital design.
- [Microinteractions](https://microinteractions.com/) - Designing with Details.
- [Motion UI Design](https://github.com/fliptheweb/motion-ui-design) - Resources for inspiration, lists of software, libraries and other stuff related to Motion UI design, animations and transitions.
#### Softwares
- [Pop](https://marvelapp.com/pop/) - POP helps you transform your pen and paper ideas into an interactive iPhone or Android prototype.
- [Invision](https://www.invisionapp.com/) - The world's leading prototyping, collaboration & workflow platform.
- [Marvel](https://marvelapp.com/) - Simple design, prototyping and collaboration.
- [Flinto](https://www.flinto.com/) - Flinto lets designers quickly make interactive prototypes of their mobile, desktop, or web apps.
- [Origami Studio](https://origami.design/) - Explore, iterate, and test your ideas.
- [Framer](https://framer.com/) - All-in-one design workflow.
- [Proto](https://proto.io/) - Create fully-interactive high-fidelity prototypes that look and work exactly like your app should. No coding required.
- [ProtoPie](https://www.protopie.io) - ProtoPie is the easiest prototyping tool to build advanced, highly interactive prototypes.

#### Tools
- [Lottie](https://airbnb.design/lottie/) - Easily add high-quality animation to any native app.
- [Keynotopia](https://keynotopia.com/) - Keynotopia transforms Keynote and PowerPoint into the best rapid prototyping tools for creating mobile, web and desktop UI mockups.

## Accessibility
#### Articles
- [Gov.Uk](https://www.gov.uk/service-manual/helping-people-to-use-your-service/making-your-service-accessible-an-introduction) - Making your service accessible: an introduction.
- [Smashing Magazine](https://www.smashingmagazine.com/2014/10/color-contrast-tips-and-tools-for-accessibility/) - Color Contrast And Why You Should Rethink It.
- [Medium](https://medium.com/@GarronEngstrom/accessibility-101-56f87f3d726e) - Accessibility for designers. Mind your RGBs.
- [Web Credible](https://www.webcredible.com/blog/visual-design-and-colour-accessibility/) - Visual design and color accessibility.
- [A List Apart](https://alistapart.com/blog/post/easy-color-contrast-testing) - Easy Color Contrast Testing.
#### Tools
- [WAVE](https://wave.webaim.org/) - Web Accessibility Evaluation Tool.
- [Contrast Ratio](https://6220119.github.io/contrast-ratio/#/black-on-white) - A tool to calculate the contrast ratio between any two valid CSS colors.
- [Snook](https://snook.ca/technical/colour_contrast/colour.html#fg=515A5F,bg=FFFFFF) - Colour Contrast Check.

## Writing
- [Google trends](https://trends.google.com/trends/) - Stories trending now.
- [Google Ngram](https://books.google.com/ngrams/) - Enter phrases into the Google Books Ngram Viewer, it displays a graph showing how those phrases have occurred in a corpus of books.
- [Hemingway](https://www.hemingwayapp.com/) - Hemingway App makes your writing bold and clear.
- [Readable](https://readable.io/) - You have 7 seconds to grab someone's attention. Readable.io helps you cut out the noise.
- [The Writer](https://www.thewriter.com/what-we-think/readability-checker/) - How readable is your writing?.
- [Taskade](https://www.taskade.com/) - Collaborative editor and outliner.

## Data
- [London Datastore](https://data.london.gov.uk/) - The London Datastore is a free and open data-sharing portal.
- [YouGov](https://yougov.com/) - We believe in the power of participation.
- [Data.Gov](https://data.gov.uk/) - Find data published by government departments and agencies, public bodies and local authorities.
- [The Tate Collection](https://github.com/tategallery/collection) - Here we present the metadata for around 70,000 artworks.
- [NASA](https://open.nasa.gov/open-data/) - We're Setting Data, Code and APIs free.
