---
title: Component - Layer
order: 5
description: Use the Layer component in Django Unfold as an abstract wrapper to inject variables from component classes into templates, enabling seamless data flow between Python logic and template rendering.
---

# Layer component

The layer component functions as an abstract wrapper that encapsulates other components within the Unfold system. Its primary purpose is to provide a mechanism for injecting variables that are generated by component classes, enabling seamless data flow from your Python logic to the template rendering layer.

```python
# admin.py

from unfold.components import register_component, BaseComponent


@register_component
class SomeComponent(BaseComponent):
    def get_context_data(self, **kwargs):
        context = super().get_context_data(**kwargs)
        context.update({
            "some_variable": [
                {
                    "title": "Example A",
                },
                {
                    "title": "Example B",
                }
            ]
        })
        return context
```

```html
{% load unfold %}

{% component "unfold/components/layer.html" with component_class="SomeComponent" %}
    {% for item in some_variable %}
        {{ item.title }}
    {% endfor %}
{% endcomponent %}
```
