<!--- Provide a general summary of your changes in the Title above -->
<!--- If you're unsure about anything in this checklist, don't hesitate to create a PR and ask. I'm happy to help! -->
<!---
Please make sure you've trimmed any trailing or leading .zsh, .zshplugin,
.oh-my-zsh, .omz or similar language from the visible portion of the links in your entry.

Basically zsh-foo or foo.zshplugin should have foo as the visible part of the link.

This keeps entries from clumping in the O and Z portions of the list and
also makes the links look prettier.
-->
# Description

<!--- Describe your changes in detail, ideally [linking](example.com) to the project/resource in this description. -->

## Type of changes

<!--- What types of changes does your submission introduce? Put an `x` in all the boxes that apply: -->

- [ ] Add/remove/update a link to an external resource like a blog post
- [ ] Add/remove/update a link to a framework
- [ ] Add/remove/update a link to a plugin
- [ ] Add/remove/update a link to a tab completion
- [ ] Add/remove/update a link to a theme
- [ ] Add/remove/update a link to a utility
- [ ] Text cleanups/typo fixes

## Copyright Assignment

- [ ] This document is covered by the [BSD License](https://github.com/unixorn/awesome-zsh-plugins/blob/master/LICENSE), and I agree to contribute this PR under the terms of the license. This is for the list submission, not for the project(s) you're adding, I don't care what license the plugins have as long as they have something.

## Checklist

<!---
Go over all the following points, and put an `x` in all the boxes that apply.

You only need to check the box for completions/plugins/themes if you added something in those categories
-->

- [ ] I have read the [CONTRIBUTING](https://github.com/unixorn/awesome-zsh-plugins/blob/main/Contributing.md) document.
- [ ] All new and existing tests passed.
- [ ] I have confirmed that the link(s) in my PR is valid.
- [ ] I have signed off my commits. You can use `git commit --amend --no-edit --signoff` to amend an existing commit, and you can find more details about signing off commits on the [DCO GitHub action page](https://probot.github.io/apps/dco/).
- [ ] My entries are single lines and are in the appropriate (plugins, themes, or completions) section, and in alphabetical order in their section.
- [ ] The completion/plugin/theme has a plugin file in the repository that conforms to the [ZSH Plugin Standard](https://zdharma-continuum.github.io/Zsh-100-Commits-Club/Zsh-Plugin-Standard.html) - TLDR, there's a plugin file with a `.plugin.zsh`, `.zsh` or `.sh` suffix, it is not just bare instructions to be added to `.zshrc`
- [ ] Any added completions have a readme and a license file in their repository.
- [ ] Any added frameworks have a readme and a license file in their repository.
- [ ] Any added plugins have a readme and a license file in their repository.
- [ ] Any added themes have a screenshot, a readme, and a license file in their repository.
- [ ] Any added utilities have a readme and a license file in their repository.
- [ ] I have stripped any leading and/or trailing **zsh-**, **zsh-plugin** and/or **oh-my-zsh-** substrings from the link's displayed name. This makes it easier to find plugins/themes/completions by name by preventing big clusters in the **O** and **Z** sections of the list.
