<!-- Click "Preview" to read this message; then delete it. -->

## Thanks for contributing to Altair! 🎉

Please follow these guidelines:

### 1. **PR Description**
   - Briefly describe the changes and their purpose. For help, check this [guide](https://medium.com/@greenberg/writing-pull-requests-your-coworkers-might-enjoy-reading-9d0307e93da3).

### 2. **Tests & Docs**
   - Include unit tests and update documentation for new features.

### 3. **Commit Message**
   - Use [semantic commit messages](https://www.conventionalcommits.org/), e.g., `"feat: Add embed_options to charts"`.
   - Add `!` for breaking changes (e.g., `"fix!: Raise error when embed_options is None"`).

### 4. **PR Title Types**
   - **feat**: New feature
   - **fix**: Bug fix
   - **docs**: Documentation changes
   - **style**: Code style changes (no functionality change)
   - **refactor**: Code restructuring
   - **perf**: Performance improvements
   - **test**: Add or fix tests
   - **build**: Changes to build system or dependencies
   - **ci**: CI configuration changes
   - **chore**: Miscellaneous tasks
   - **revert**: Reverts a commit
