"""
Filled Step Chart
-----------------
This example shows Google's stock price over time as a step chart with its area filled in and its line emphasized.
"""
# category: line charts
import altair as alt
from altair.datasets import data

source = data.stocks()

alt.Chart(source).mark_area(
    color="lightblue",
    interpolate='step-after',
    line=True
).encode(
    x='date',
    y='price'
).transform_filter(alt.datum.symbol == 'GOOG')
