"""
Error Bars with Standard Deviation
----------------------------------
This example shows how to show error bars with standard deviation using crop yields data of different
in the years of 1930s.
"""
# category: uncertainties and trends
import altair as alt
from altair.datasets import data

source = data.barley()

error_bars = alt.Chart(source).mark_errorbar(extent='stdev').encode(
  x=alt.X('yield').scale(zero=False),
  y=alt.Y('variety')
)

points = alt.Chart(source).mark_point(filled=True, color='black').encode(
  x=alt.X('mean(yield)'),
  y=alt.Y('variety'),
)

error_bars + points
