"""
Line Chart with Custom Legend
-----------------------------
This example uses the argmax aggregation function in order to create a custom
legend for a line chart.
"""
# category: line charts
import altair as alt
from altair.datasets import data


source = data.stocks()

base = alt.Chart(source).encode(
    alt.Color("symbol").legend(None)
).transform_filter(
    "datum.symbol !== 'IBM'"
).properties(
    width=500
)

line = base.mark_line().encode(x="date", y="price")


last_price = base.mark_circle().encode(
    alt.X("last_date['date']:T"),
    alt.Y("last_date['price']:Q")
).transform_aggregate(
    last_date="argmax(date)",
    groupby=["symbol"]
)

company_name = last_price.mark_text(align="left", dx=4).encode(text="symbol")

chart = (line + last_price + company_name).encode(
    x=alt.X().title("date"),
    y=alt.Y().title("price")
)

chart
