"""
Multi-Line Highlight
====================
This multi-line chart uses an invisible Voronoi tessellation to handle pointerover to
identify the nearest point and then highlight the line on which the point falls.
It is adapted from the Vega-Lite example found at
https://bl.ocks.org/amitkaps/fe4238e716db53930b2f1a70d3401701
"""
# category: interactive charts
import altair as alt
from altair.datasets import data

source = data.stocks()

highlight = alt.selection_point(on='pointerover', fields=['symbol'], nearest=True)

base = alt.Chart(source).encode(
    x='date:T',
    y='price:Q',
    color='symbol:N'
)

points = base.mark_circle().encode(
    opacity=alt.value(0)
).add_params(
    highlight
).properties(
    width=600
)

lines = base.mark_line().encode(
    size=alt.when(~highlight).then(alt.value(1)).otherwise(alt.value(3))
)

points + lines
