# Contributing Guidelines

To submit a package to this list, please do the following:

1.  Find a link to the package you consider is awesome. Use the link from [marketplace.visualstudio.com](https://marketplace.visualstudio.com/) instead of a link from its GitHub repository.
2.  Find the appropriate place for your package. If it belongs to a certain section, put it there. If it doesn't belong to a specific category, you should put it in the `uncategorized` section. Make sure to put your package in the alphabetical order.
3.  If possible, find a `.gif` animation that displays the functionality of the package.

Submit your package in the specific form:

```gfm
#### [Title of the package](https://marketplace.visualstudio.com/items?itemName=NAME)
> A short description of what this package does and why is it awesome.

![title of the package](link to the .gif file that explains its functionality)
```

**Submitting a theme**

1.  Submit a link to [vscodethemes](https://vscodethemes.com) if applicable, otherwise use the [marketplace](https://marketplace.visualstudio.com/) link.
2.  Add your theme in alphabetical order.
3.  Only one theme per publisher (you may change a featured theme).
4.  Submit a similar-style screenshot. You may use [this sketch file](./themes/screenshots/awesome-vscode.sketch) with [this template](./themes/theme-template.js) to help (**tip**: line up vscode with the canvas).

Failure to comply to these contributing guidelines will result in your pull request being rejected.

Thank you for your suggestions!
