# Contribution Guidelines

Please ensure your pull request adheres to the following guidelines:

- Search previous suggestions before making a new one, as yours may be a duplicate.
- **Make an individual pull request for each suggestion.**
- Use the following format: `[PACKAGE](LINK) - DESCRIPTION.`
- New categories, or improvements to the existing categorization are welcome.
- Keep descriptions short and simple, but descriptive.
- Don't include iOS versions or Swift versions in the description.
- Emojis should be used with care in descriptions, we already had some problems with emoji render in GitHub.
- End all descriptions with a full stop/period.
- Check your spelling and grammar.
- Make sure that your suggestion is positioned is **alphabetical** order
- Make sure your text editor is set to remove trailing whitespace.
- Make sure your project is elegible before open a pull request.

#### Deleting

Typical reasons for deleting project:

- Doesn't build in the current Xcode
- No updates / no longer works
- Deprecated
- Lacks license
- Archived projects

#### Projects are ineligible if:

- Projects without tests.
- Lack recent commit
- Have lower than 50 stargazers in Github
- README or code comments aren't written in English
- README is not clear
- Does not support the most common package managers (spm, cocoapods, carthage...)

### Projects that can be rejected:

- Paid products
- Have only one contributor
- Projects with exact same functionalities as other projects that are already in AwesomeiOS
- Projects with few functionalities

Your contributions are always welcome! Thank you for your suggestions! :smiley:
