# Contributing Guide

1. Make sure you put things in the right category!
2. Always add your items to the end of a list. To be fair, the order is first-come-first-serve.
3. If you think something belongs in the wrong category, or think there needs to be a new category, feel free to edit things too.

## Projects using Vuejs

Make sure you put things in the right category. There are two main categories:
- Open Source
- Apps/Websites

### Open source

Open Source section gives the possibility for developers to contribute and be a part of an opensource project using their knowledge of Vue.
You should put your project in this category if the following conditions are true:
- The description for the link should not contain links to the author and third-party resources - this should be in the documentation (README)
- The documentation (README) contains a description of the project, illustration of the project with a demo or screenshots and a CONTRIBUTING section.
- The documentation is in English.
- The project is active and maintained.
- The project accepts contributions.
- Not a commercial product.

The link provided should be the link of the github repository, not the demo.
If you consider your project finished, and it does not need any contributions, consider the apps/website category.

### Apps/Websites

Apps/Websites gives the opportunity to showcase the awesome things we can build with vuejs.
You should put your app/website in this category if the following conditions are true:
- The website is available without errors or ssl certificate problems, and load in a reasonable amount of time.
- The website is using vuejs intensively. It should detect vue with [vue-devtools](https://github.com/vuejs/vue-devtools).
- If you cannot detect vue with `vue-devtools` due to work at non public pages (e.g. for enterprise website), you can send Pull Request with screenshot that detected it.
- The website is original and not too simple. For that reason, blogs and simple landing pages are rejected.

#### Commercial products
Commercial products will only be included when you could reasonably check out how Vue was used (i.e. A headless CMS which uses Vue for the Admin/editor Area and offers a free tier). If the greater part of a product could only be used after payment the entry will be seen as an advertisement instead of a community contribution. If you're interested in advertisement open an issue first so we can work towards an agreement.
