### `General`
> ✏️ Mark the necessary items without changing the structure of the PR template.

- [ ] Pull request template structure not broken

### `Type`

> ℹ️  What types of changes does your code introduce?

> 👉 _Put an `x` in the boxes that apply_

- [ ] Fix
- [ ] Feature 

### `Checklist`

> ℹ️  Check all checkboxes - this will indicate that you have done everything in accordance with the rules in [CONTRIBUTING](https://github.com/vuejs/awesome-vue/blob/master/.github/contributing.md).

> 👉  _Put an `x` in the boxes that apply._

- [ ] Title as described
- [ ] Make sure you put things in the right category!
- [ ] Always add your items to the end of a list

#### `Open Source`

- [ ] Link description does not contain a link to an author / third-party resource
- [ ] The documentation (README) contains a description of the project, illustration of the project with a demo or screenshots and a CONTRIBUTING section
- [ ] The documentation is in English.
- [ ] The project is active and maintained.
- [ ] The project accepts contributions.
- [ ] Not a commercial product

#### `Apps/Websites`

- [ ] The website is available without errors or ssl certificate problems, and load in a reasonable amount of time.
- [ ] The website is using vuejs intensively. It should detect vue with [vue-devtools](https://github.com/vuejs/vue-devtools).
  > If you cannot detect vue with `vue-devtools` due to work at non public pages (e.g. for enterprise website), you can send Pull Request with screenshot that detected it.
- [ ] The website is original and not too simple. For that reason, blogs and simple landing pages are rejected.
- [ ] A commercial product using Vue, provided that guests could reasonably check out how Vue was used (i.e. A headless CMS which uses Vue for the Admin/editor Area and offers a free tier).
