# Contributing

Thank you for your interest in improving Wagtail! There are many ways to contribute - see the [Contributing](https://docs.wagtail.org/en/latest/contributing/index.html) documentation for some suggestions.

## Working on an issue

👉 If an issue isn’t being worked on by anyone, go for it! **No need to ask "please assign me this issue".** Feel free to leave a comment outlining your plans so that other people know you're working on it.

If you're new to contributing to open source, we recommend you read the [Your first contribution guide](https://docs.wagtail.org/en/latest/contributing/first_contribution_guide.html). You might like to start by checking issues with the [good first issue](https://github.com/wagtail/wagtail/labels/good%20first%20issue) label.

Please review the [contributing guidelines](https://docs.wagtail.org/en/latest/contributing/index.html) for details of [setting up a development environment](https://docs.wagtail.org/en/latest/contributing/developing.html) and other coding guidelines. In summary:

- **Purely AI-generated contributions are not welcome.** If you have made use of AI assistance, please disclose this in your pull request description, and detail the steps you have taken to verify that the code is correct. See the guidelines for [use of generative AI](https://docs.wagtail.org/en/latest/contributing/general_guidelines.html#use-of-generative-ai).
- Include unit tests to cover any new or changed behavior, and check that all existing tests still pass. See [Testing](https://docs.wagtail.org/en/latest/contributing/developing.html#testing).
- For new user-facing or developer-facing features, the documentation should be updated. See [Compiling the documentation](https://docs.wagtail.org/en/latest/contributing/developing.html#compiling-the-documentation) and [Documentation guidelines](https://docs.wagtail.org/en/latest/contributing/documentation_guidelines.html).
- Ensure that your code follows Wagtail's [linting and formatting](https://docs.wagtail.org/en/latest/contributing/developing.html#linting-and-formatting) standards.
- For front-end changes, mention which browsers (or other assistive technologies) you have tested against. See [Browser and device support](https://docs.wagtail.org/en/latest/contributing/ui_guidelines.html#browser-and-device-support).
- For changes that affect Wagtail's appearance or behavior, please include screenshots in the pull request description.

## Reporting bugs and feature requests

To report bugs or make feature requests, use our [issue tracker](https://github.com/wagtail/wagtail/issues). If you'd like to discuss an idea before requesting it, use the [Wagtail Slack](https://github.com/wagtail/wagtail/wiki/Slack) or [Discussions](https://github.com/wagtail/wagtail/discussions).

If your bug report is a security issue, **do not** report it with an issue. Please read our guide to [reporting security issues](https://docs.wagtail.org/en/latest/contributing/security.html).

Please don't use the issue tracker for support queries - use [the 'wagtail' tag on Stack Overflow](https://stackoverflow.com/questions/tagged/wagtail) (preferred) or the [#support channel](https://github.com/wagtail/wagtail/wiki/Slack#support) on the [Wagtail Slack](https://github.com/wagtail/wagtail/wiki/Slack).


## Translations

Please submit any new or improved translations through [Transifex](https://explore.transifex.com/torchbox/wagtail/) rather than through pull requests - see [Translations](https://docs.wagtail.org/en/latest/contributing/translations.html).
