<!-- NOTE: This file is rendered both by Sphinx via `include` and by TypeDoc. -->
<!-- Only use plain Markdown without Sphinx-specific syntax. -->

<!-- INTRO:START -->

# JavaScript components

Wagtail's JavaScript components are documented using [TypeDoc](https://typedoc.org). This documentation is automatically generated from the source code and provides detailed information about the available components, their methods, and properties. At this stage, the documentation is not exhaustive and may include internal APIs that are not accessible by external code. We are working on improving the code and documentation to make it more comprehensive and user-friendly in the future.

<!-- INTRO:END -->

<!-- STABILITY:START -->

We provide documentation for these components without making them subject to the same stability guarantees outlined in our deprecation policy. This means a component's API may change in a minor release without going through the deprecation process. If you use these components in your own code, please ensure that you have a testing process in place to catch any breaking changes with each Wagtail upgrade.

<!-- STABILITY:END -->

<!-- The rest will be rendered by TypeDoc. -->

For more details, see our [deprecation policy](../../../releases/release_process.html#deprecation-policy).

[Return to Wagtail's UI components documentation.](../index.html)
