# Third-party tutorials

```{warning}
The following list is a collection of tutorials and development notes
from third-party developers. Some of the older links may not apply to
the latest Wagtail versions.
```

-   [HTMX and Wagtail CMS quickstart guide](https://jackwhitworth.com/blog/htmx-and-wagtail-cms-quickstart/) (28 August 2025)
-   [PostgreSQL Tutorial: Install Wagtail and connect it to your service using OVHcloud](https://support.us.ovhcloud.com/hc/en-us/articles/21458794389139-PostgreSQL-Tutorial-Install-Wagtail-and-connect-it-to-your-service) (17 July 2025)
-   [Efficient parent/child page querying in Wagtail](https://jackwhitworth.com/blog/efficient-wagtail-page-querying/) (17 July 2025)
-   [Writing a Minimal Wagtail, Poetry & Node Dockerfile](https://jackwhitworth.com/blog/writing-a-minimal-wagtail-poetry-node-dockerfile/) (8 April 2025)
-   [Master Wagtail CMS and Tailwind CSS to build a beautiful blog (video)](https://www.youtube.com/watch?v=ML2e_HVfgEA) (23 March 2025)
-   [Practical tips to Streamline Your Wagtail CMS Development](https://profil-software.com/blog/development/5-tips-to-streamline-your-wagtail-cms-development/) (2 March 2025)
-   [Create a blog in Django with Wagtail (video series)](https://youtube.com/playlist?list=PL5E1F5cTSTtTpsD-0guoh6gdIpLQrYtR-&si=ZYMK7TGMuRy1FkWm) (20 January 2025)
-   [Finding (StreamField) Blocks Across a Wagtail Site](https://code.informatikamihelac.com/en/finding-blocks-across-a-wagtail-site/) (6 December 2024)
-   [Blog Site with Django + Wagtail CMS - Beginner Friendly Guide (video)](https://www.youtube.com/watch?v=xzdPGUDBslk) (25 November 2024)
-   [Setting up Wagtail on Docker with PostgreSQL](https://dev.to/hari_shanmugam/wagtail-on-docker-2dfb) (24 November 2024)
-   [Importing and Synchronizing Pages with Wagtail and Wagtail Localize](https://code-on.be/en/blog/how-to-import-your-existing-translated-content-with-wagtail-localize/) (20 November 2024)
-   [How to Build No-Code Modal Components for Wagtail CMS Content Editors](https://blog.adonissimo.com/how-to-build-no-code-modal-components-for-wagtail-cms-content-editors) (17 November 2024)
-   [How to Set Up GDPR-Compliant Analytics in Wagtail CMS: Cookie Consent with Clarity and Google Analytics](https://blog.adonissimo.com/how-to-set-up-gdpr-compliant-analytics-in-wagtail-cms-cookie-consent-with-clarity-and-google-analytics) (10 November 2024)
-   [Adding Wagtail to a Django project to support content](https://medium.com/@zalun/base-6-wagtail-cms-for-the-content-f60d8ec7ac9e) (29 September 2024)
-   [How to programmatically create a page translation](https://dev.to/k4ml/wagtail-programmatically-create-page-translation-2814) (30 September 2024)
-   [A simple block pattern for Wagtail CMS](https://lincolnloop.com/insights/simple-block-pattern-wagtail-cms/) (29 August 2024)
-   [Django and Wagtail site building comparison tutorial video](https://www.youtube.com/watch?v=qodE7XyWCVw) (9 July 2024)
-   [An introduction to Wagtail tutorial](https://medium.com/@dogung51290/wagtail-cms-tutorial-5bd39e08ad44) (17 June 2024)
-   [Unleashing the Power of Custom Wagtail Models](https://www.linkedin.com/pulse/unleashing-power-custom-wagtail-models-kgothatso-phooko-70tcf) (9 June 2024)
-   [Deploying Wagtail on Divio](https://docs.divio.com/en/latest/introduction/wagtail/) (~June 2024)
-   [How to Deploy Wagtail To AWS EC2 and Digital Ocean](https://appliku.com/post/how-deploy-wagtail-aws-ec2-and-digital-ocean/) (12 May 2024)
-   [Upgrading Wagtail (from 2.5 to 6.0)](https://learnwagtail.com/blog/category/upgrading-wagtail/) (18 April 2024)
-   [Using Wagtail Form Templates in Software Development Projects](https://devcodef1.com/news/1211030/wagtail-form-templates-in-sd-projects) (9 April 2024)
-   [Build an Intuitive Link StructBlock in Wagtail: Simplifying Link Management for Content Editors](https://enzedonline.com/en/tech-blog/build-an-intuitive-link-structblock-in-wagtail-simplifying-link-management-for-content-editors/) (9 March 2024)
-   [Improving Wagtail Richtext Block Revision Diffing](https://onexception.dev/news/1166572/wagtail-richtext-block-revision-diffing) (6 March 2024)
-   [Wagtail StreamField - Propagating the `required` Attribute on Nested Blocks](https://enzedonline.com/en/tech-blog/wagtail-streamfields-propagating-the-required-attribute-on-nested-blocks/) (20 February 2024)
-   [An overview of a Wagtail website stack](https://learnwagtail.com/blog/a-peek-inside-our-tech-stack/) (15 February 2024)
-   [Efficient Cascading Choices in Wagtail Admin: A Smart Chooser Panel Solution](https://enzedonline.com/en/tech-blog/efficient-cascading-choices-in-wagtail-admin-a-smart-chooser-panel-solution/) (27 January 2024)
-   [How to add an edit link to `wagtail-autocomplete` items](https://dev.to/ordigital/how-to-add-edit-link-in-wagtail-autocomplete-4kg1) (30 January 2024)
-   [Deploying Django/Wagtail on Ubuntu with Gunicorn and Nginx](https://serverguy.dev/web-server/deploying-django-wagtail-on-ubuntu-with-gunicorn-and-nginx/) (24 January 2024)
-   [Programmatically Creating a Wagtail page with StreamField](https://usercomp.com/news/1080620/create-wagtail-page-programmatically) (19 December 2023)
-   [Adding reCAPTCHA V3 to Wagtail's Form Builder Pages](https://enzedonline.com/en/tech-blog/protecting-your-django-forms-implementing-google-recaptcha-v3-for-enhanced-security/) (19 December 2023)
-   [Guide for managing a complex multi-tenancy setup with Wagtail](https://cynthiakiser.com/blog/2023/11/01/multitenancy-with-wagtail.html) (1 November 2023)
-   [Wagtail tutorial video series, getting started through to e-commerce integration with PayPal](https://www.youtube.com/playlist?list=PLl5rkhS-ZxnePQpI2Ty63hpAvfUTrqdt1) (1 November 2023)
-   [Integrating Next.js and Wagtail: Building a Headless, Content-Driven Website](https://blog.traleor.com/headless-nextjs-wagtail/) (21 October 2023)
-   [Wagtail tutorial video series, building a blog](https://www.youtube.com/playlist?list=PLeLGN29skXLpaaSZXRkIMzNAOCPyemCve) (1 October 2023)
-   [Deploy Wagtail CMS to PythonAnywhere using git push to a bare repo](https://www.nickmoreton.co.uk/articles/deploy-wagtail-cms-to-pythonanywhere/) (27 September 2023)
-   [Building a custom Django command to check all admin pages are loading correctly in Wagtail](https://www.nickmoreton.co.uk/articles/wagtail-response-checker/) (1 September 2023)
-   [Integrating ChatGPT with Wagtail for efficient content generation](https://octave.nz/post/integrating-chatgpt-with-wagtail-for-efficient-content-generation-and-content-management) (15 August 2023)
-   [Creating Wagtail StreamField StructBlocks with a Customised Editor Interface](https://enzedonline.com/en/tech-blog/how-to-create-wagtail-streamfield-structblocks-with-a-customised-editor-interface/) (9 July 2023)
-   [Wagtail on Cloud Run](https://codelabs.developers.google.com/codelabs/cloud-run-wagtail/#0) (26 June 2023)
-   [How to create a custom Wagtail CMS page type?](https://itcertifications.medium.com/how-to-create-a-custom-wagtail-cms-page-type-7bf72aff8413) (29 June 2023)
-   [ Create Stylish Wagtail Pages with Tailwind CSS ](https://www.accordbox.com/blog/create-stylish-wagtail-pages-with-tailwind-css/) (15 June 2023)
-   [Backup and Restore a Wagtail CMS website](https://experiencednovice.dev/blog/wagtail-backup-and-restore/) (26 May 2023)
-   [A guide for updating Wagtail CMS](https://experiencednovice.dev/blog/updating-wagtailcms/) (22 May 2023)
-   [Creating Custom Choosers with Viewsets](https://enzedonline.com/en/tech-blog/wagtail-creating-custom-choosers-with-viewsets/) (18 April 2023)
-   [Build a Website Without Any Coding with Traleor (& Wagtail) in Just 10 Minutes (video)](https://www.youtube.com/watch?v=IQY0dzo2Wzg) (19 March 2023)
-   [Getting Started with Wagtail: A Beginner’s Installation Guide (Windows)](https://medium.com/@dencomac/getting-started-with-wagtail-a-beginners-installation-guide-a5671da1eccc) (9 March 2023)
-   [Introduction to Stimulus in Wagtail for contributors (video)](https://youtu.be/5WS7B8R0x0U) (28 February 2023)
-   [How to pick a good Wagtail package](https://wagtail.org/blog/pick-out-packages/) (1 February 2023)
-   [Dockerized Wagtail 4 + NuxtJS 3 + Graphene 3 + Vuetify 3 (with template)](https://dev.to/ordigital/dockerized-wagtail-4-nuxtjs-3-graphene-3-vuetify-3-1n8m) (26 January 2023)
-   [Wagtail: Extending the Draftail Editor Part 4 - Custom Lists](https://enzedonline.com/en/tech-blog/wagtail-extending-the-draftail-editor-part-4-custom-lists/) (29 December 2022)
-   [Making Wagtail pages more SEO friendly with Wagtail Metadata](https://enzedonline.com/en/tech-blog/making-wagtail-pages-more-seo-friendly-with-wagtail-metadata/) (24 December 2022)
-   [Configuring a Dynamic Sitemap on Wagtail](https://enzedonline.com/en/tech-blog/configuring-a-dynamic-sitemap-on-wagtail/) (22 December 2022)
-   [Deploying Wagtail to Google's Cloud Run](https://codelabs.developers.google.com/codelabs/cloud-run-wagtail) (7 December 2022)
-   [Tutorial: Build a Wagtail blog in 20 minutes](https://codewithstein.com/django-wagtail-cms-building-a-blog-in-20-minutes/) (5 December 2022)
-   [Headless Wagtail and Next.js preview mode](https://medium.com/@yaroslavdraha/headless-wagtail-and-next-js-preview-mode-f6f29c944830) (25 November 2022)
-   [A Step-by-Step Guide on Installing the Wagtail Codebase on a Local Machine for Contribution (video)](https://www.youtube.com/watch?v=XAjQ4XN0qLs) (19 November 2022)
-   [How we created the new Wagtail.org](https://wagtail.org/blog/how-we-created-the-new-wagtailorg/) (16 November 2022)
-   [Build a Blog With Wagtail CMS (4.0.0) Released](https://www.accordbox.com/blog/build-blog-with-wagtail-cms-400-released/) (7 November 2022)
-   [Create a custom Wagtail Image filter for Thumbnails with Preserved Edges](https://enzedonline.com/en/tech-blog/create-image-thumbnails-with-preserved-edges-using-python-image-library/) (4 November 2022)
-   [Static-Dynamic Content With In-Memory SQLite using Wagtail](https://aeracode.org/2022/11/03/static-dynamic-in-memory-sqlite/) (3 November 2022)
-   [A Step-by-Step Guide for Manually Setting up Bakery Demo with Wagtail](https://juliet.hashnode.dev/a-step-by-step-guide-for-manually-setting-up-bakery-demo-with-wagtail) (18 November 2022)
-   [Integrating Sa11y accessibility checker into a Wagtail website (video)](https://www.youtube.com/watch?v=NEQVoFEHjJk) (26 October 2022)
-   [Wagtail: Extending the Draftail Editor Part 3 - Dynamic Text](https://enzedonline.com/en/tech-blog/wagtail-extending-the-draftail-editor-part-3-dynamic-text/) (21 October 2022)
-   [What's this? A new website? - Explainer for building a new website with Wagtail](https://theorangeone.net/posts/whats-this-a-new-website/) (10 October 2022)
-   [Guide to integrate Wagtail CRX with a Snipcart storefront](https://github.com/justicepelteir/wagtail_crx_snipcart_storefront) (9 October 2022)
-   [Adding featured events to the HomePage with Wagtail 4.0 (video)](https://www.youtube.com/watch?v=opQ_ktAXplo) (6 October 2022)
-   [Wagtail: Extending the Draftail Editor Part 2 - Block Styles](https://enzedonline.com/en/tech-blog/wagtail-extending-the-draftail-editor-part-2-block-styles/) (5 October 2022)
-   [Wagtail: Extending the Draftail Editor Part 1 - Inline Styles](https://enzedonline.com/en/tech-blog/wagtail-extending-the-draftail-editor-part-1-inline-styles/) (5 October 2022)
-   [Creating an interactive event budgeting tool within Wagtail](https://dev.to/lb/creating-an-interactive-event-budgeting-tool-within-wagtail-53b3) (4 October 2022)
-   [Configuring Rich Text Blocks for Your Wagtail Site](https://enzedonline.com/en/tech-blog/configuring-rich-text-blocks-for-your-wagtail-site/) (26 September 2022)
-   [Deploy Django Wagtail to Render](https://stackingtabs.medium.com/deploy-django-wagtail-to-render-7d33c4b09bf9) (23 September 2022)
-   [Using a migration to apply permissions to Wagtail snippets](https://sixfeetup.com/blog/a-look-at-using-wagtail-snippets-with-django) (7 September 2022)
-   [Deploying a Wagtail site to Fly.io - Part 1 of 5](https://usher.dev/posts/wagtail-on-flyio/part-1/) (30 August 2022)
-   [Django Wagtail CMS | Building A Blog In 20 Minutes (video)](https://www.youtube.com/watch?v=mbUFWkZAm8w) (12 August 2022)
-   [Hosting a Wagtail site on Digital Ocean with CapRover](https://medium.com/@Gidsey/hosting-a-wagtail-site-on-digital-ocean-with-caprover-e71306e8d053) (21 July 2022)
-   [Add Heading Blocks with Bookmarks in Wagtail](https://enzedonline.com/en/tech-blog/how-to-add-heading-blocks-with-bookmarks-in-wagtail/) (5 July 2022)
-   [Import files into Wagtail](https://cynthiakiser.com/blog/2022/07/02/import-files-into-wagtail.html) (2 July 2022)
-   [Adding MapBox Blocks to Wagtail Stream Fields](https://enzedonline.com/en/tech-blog/adding-mapbox-blocks-to-wagtail-stream-fields/) (19 June 2022)
-   [5 Tips to Streamline Your Wagtail CMS Development](https://profil-software.com/blog/development/5-tips-to-streamline-your-wagtail-cms-development/) (14 June 2022)
-   [Wagtail 3 Upgrade: Per Site Features](https://cynthiakiser.com/blog/2022/06/02/wagtail-3-upgrade-part-2.html) (2 June 2022)
-   [Wagtail 3 Upgrade: Per User FieldPanel Permissions](https://cynthiakiser.com/blog/2022/06/01/wagtail-3-upgrade-part-1.html) (1 June 2022)
-   [Upgrading to Wagtail 3.0](https://enzedonline.com/en/tech-blog/upgrading-to-wagtail-3-0/) (3 May 2022)
-   [Django for E-Commerce: A Developers Guide (with Wagtail CMS Tutorial) - Updated](https://snipcart.com/blog/django-ecommerce-tutorial-wagtail-cms) (21 March 2022)
-   [How to install Wagtail on Ubuntu 20.04|22.04](https://nextgentips.com/2022/03/01/how-to-install-wagtail-on-ubuntu-20-0422-04/) (1 March 2022)
-   [Building a blog with Wagtail (tutorial part 1 of 2)](https://paulgrajewski.medium.com/wagtail-blog-part-1-ad0df1c59f4) (27 February 2022); [part 2 of 2](https://paulgrajewski.medium.com/wagtail-blog-part-2-3fe698e38983) (6 March 2022)
-   [Creating a schematic editor within Wagtail CMS with StimulusJS](https://dev.to/lb/creating-a-schematic-editor-within-the-wagtail-cms-with-stimulusjs-n5j) (20 February 2022)
-   [Adding Placeholder Text to Wagtail Forms](https://www.coderedcorp.com/blog/adding-placeholder-text-to-wagtail-forms/) (11 February 2022)
-   [Deploying a Wagtail 2.16 website to Heroku](https://dev.to/kalobtaulien/deploying-a-wagtail-216-website-to-heroku-1iki) (9 February 2022)
-   [Build an E-Commerce Site with Wagtail CMS, Bootstrap & Django Framework](https://dev.to/paulwababu/build-an-e-commerce-site-with-wagtail-cms-bootstrap-django-framework-4jdb) (7 February 2022)
-   [Complex Custom Field Pagination in Django (Wagtail)](https://rentfree.media/posts/wagtail/pagination/django/2022-02-03-hacking-the-django-paginator.html) (3 February 2022)
-   [How to Connect Wagtail and React](https://stackingtabs.medium.com/how-to-connect-wagtail-and-react-7f6d1adf230) (31 January 2022)
-   [Wagtail: Dynamically Adding Admin Menu Items](https://cynthiakiser.com/blog/2022/01/25/dynamically-adding-menu-items-in-the-wagtail-admin.html) (25 January 2022)
-   [Headless Wagtail, what are the pain points? (with solutions)](https://tommasoamici.com/blog/headless-wagtail-what-are-the-pain-points) (24 January 2022)
-   [A collection of UIKit components that can be used as a Wagtail StreamField block](https://pythonawesome.com/a-collection-of-uikit-components-that-can-be-used-as-a-wagtail-streamfield-block/) (14 January 2022)
-   [Introduction to Wagtail CMS](https://blog.reallyroxanna.codes/introduction-to-wagtail-cms) (1 January 2022)
-   [How to make Wagtail project have good coding style](https://www.accordbox.com/blog/how-to-make-wagtail-project-have-good-coding-style/) (18 December 2021)
-   [Wagtail: The Django newcomer - German](https://cmsstash.de/cms-reviews/wagtail) (13 December 2021)
-   [Create a Developer Portfolio with Wagtail Part 10: Dynamic Site Settings](https://engineertodeveloper.com/wagtail-dynamic-site-settings/) (3 December 2021)
-   [Dockerize Wagtail CMS for your development environment](https://jortdevreeze.com/en/blog/dockerize-wagtail-cms-for-your-development-environment/) (29 November 2021)
-   [How To Add an Email Newsletter to Wagtail](https://engineertodeveloper.com/how-to-add-an-email-newsletter-to-wagtail/) (25 November 2021)
-   [Dealing with UNIQUE Fields on a Multi-lingual Site](https://enzedonline.com/en/tech-blog/dealing-with-unique-fields-on-a-multi-lingual-site/) (6 November 2021)
-   [General Wagtail Tips & Ticks](https://github.com/spapas/wagtail-faq) (26 October 2021)
-   [Branching workflows in Wagtail](https://github.com/engineervix/wagtail-branching-workflows) (12 October 2021)
-   [Wagtail is the best python CMS in our galaxy - Russian](https://habr.com/ru/post/582898/) (12 October 2021)
-   [Adding Tasks with a Checklist to Wagtail Workflows](https://dev.to/lb/adding-tasks-with-a-checklist-to-wagtail-workflows-29b8) (22 September 2021)
-   [How to create a Zen (Focused) mode for the Wagtail CMS admin](https://dev.to/lb/how-to-create-a-zen-focused-mode-for-the-wagtail-cms-admin-3ipk) (5 September 2021)
-   [Deploying Wagtail on Divio](https://docs.divio.com/en/latest/introduction/wagtail/) (~September 2021)
-   [How to Install Wagtail on Shared Hosting without Root (CPanel)](https://chemicloud.com/kb/article/install-wagtail-without-root-access/) (26 August 2021)
-   [Django for E-Commerce: A Developers Guide (with Wagtail CMS Tutorial)](https://dev.to/realguillaume/django-for-e-commerce-a-developers-guide-with-wagtail-cms-tutorial-57on) (26 August 2021)
-   [How to create a Kanban (Trello style) view of your ModelAdmin data in Wagtail](https://dev.to/lb/how-to-create-a-kanban-trello-style-view-of-your-modeladmin-data-in-wagtail-20eg) (20 August 2021)
-   [eBook: The Definitive Guide to Next.js and Wagtail](https://www.accordbox.com/blog/ebook-the-definitive-guide-to-nextjs-and-wagtail/) (19 August 2021)
-   [How to build an interactive guide for users in the Wagtail CMS admin](https://dev.to/lb/how-to-build-an-interactive-guide-for-users-in-the-wagtail-cms-admin-2dcp) (19 August 2021)
-   [Add Custom User Model (with custom fields like phone no, profile picture) to django or wagtail sites](https://medium.com/@altaf008bd/wagtail-add-custom-fields-including-image-to-custom-user-model-1c976ddbc24) (16 August 2021)
-   [File size limits in Nginx and animated GIF support](https://www.meagenvoss.com/blog/random-wagtail-thing-i-learned-file-size-limits-in-nginx-and-animated-gif-support/) (14 August 2021)
-   [Deploying Wagtail site on Digital Ocean](https://www.craftplustech.com/blog/deploying-wagtail-site-on-digital-ocean/) (11 August 2021)
-   [Multi-language Wagtail websites with XLIFF](https://www.fourdigits.nl/blog/multi-language-wagtail-websites-with-xliff/) (21 June 2021)
-   [Add & Configure Mail in Django (or Wagtail) using Sendgrid](https://mpettersson.com/blog/how-to-add-and-configure-a-mail-service-in-django-or-wagtail/) (28 May 2021)
-   [Advanced Django Development: How to build a professional CMS for any business? (3 part tutorial)](https://medium.com/engineerx/advanced-django-development-how-to-build-a-professional-cms-for-any-business-part-1-9859cb5b4d24) (2 April 2021)
-   [Matomo Analytics with WagtailCMS](https://experiencednovice.dev/blog/matomo-analytics-with-wagtailcms/) (31 March 2021)
-   [Dockerizing a Wagtail App](https://www.accordbox.com/blog/dockerizing-wagtail-app/) (16 March 2021)
-   [Deploying Wagtail on CentOS8 with MariaDB/Nginx/Gunicorn](https://experiencednovice.dev/blog/deploying-wagtail-on-centos8/) (7 March 2021)
-   [How to add a List of Related Fields to a Page](https://learningtofly.dev/blog/wagtail-how-to-add-a-list-of-related-fields-to-a-page) (6 March 2021)
-   [Wagtail - `get_absolute_url`, without domain](https://kuttler.eu/code/wagtail-get_absolute_url-without-domain/) (3 March 2021)
-   [How To Alternate Blocks in Your Django & Wagtail Templates](https://www.coderedcorp.com/blog/how-to-alternate-blocks-in-your-templates/) (19 February 2021)
-   [Build a Blog With Wagtail CMS (second version)](https://www.accordbox.com/blog/build-blog-wagtail-cms-second-version-available/) (13 January 2021)
-   [Migrate your Wagtail Website from wagtailtrans to the new wagtail-localize](https://www.cnc.io/en/blog/wagtailtrans-to-wagtail-localize-migration) (10 January 2021)
-   [How to Use the Wagtail CMS for Django: An Overview](https://steelkiwi.com/blog/how-to-use-the-wagtail-cms-for-django-an-overview/) (21 December 2020)
-   [Wagtail `modeladmin` and a dynamic panels list](https://kuttler.eu/code/wagtail-modeladmin-and-dynamic-panels-list/) (14 December 2020)
-   [Install and Deploy Wagtail CMS on pythonanywhere.com](https://www.theinsidetrade.com/blog/install-and-deploy-wagtail-cms-pythonanywherecom/) (14 December 2020)
-   [Overriding the admin CSS in Wagtail](https://www.yellowduck.be/posts/overriding-the-admin-css-in-wagtail/) (4 December 2020)
-   [Migrating your Wagtail site to a different database engine](https://www.yellowduck.be/posts/migrating-your-wagtail-site-to-a-different-database-engine/) (3 December 2020)
-   [Wagtail for Django Devs: Create a Developer Portfolio](https://dev.to/brian101co/wagtail-for-django-devs-create-a-developer-portfolio-5e75) (30 November 2020)
-   [Create a Developer Portfolio with Wagtail Tutorial Series](https://engineertodeveloper.com/category/wagtail/) (11 November 2020)
-   [Wagtail Instagram New oEmbed API](https://www.codista.com/en/blog/wagtail-instagram-new-oembed-api/) (5 November 2020)
-   [Image upload in Wagtail forms](https://dev.to/lb/image-uploads-in-wagtail-forms-39pl) (21 October 2020)
-   [Adding a timeline of your Wagtail Posts](https://spapas.github.io/2020/09/18/wagtail-add-posts-timeline/) (18 September 2020)
-   [How to create amazing SSR website with Wagtail 2 + Vue 3](https://dev.to/robert197/how-to-create-amazing-ssr-website-with-wagtail-2-vue-3-463j) (1 September 2020)
-   [Migrate Wagtail Application Database from SQLite to PostgreSQL](https://medium.com/@ochieng.grace/migrate-wagtail-application-database-from-sqlite-to-postgresql-32f705f2f5f4) (5 June 2020)
-   [How to Build Scalable Websites with Wagtail and Nuxt](https://devs-group.medium.com/why-our-websites-stay-ahead-c608e3f4bea4) (14 May 2020)
-   [Wagtail multi-language and internationalization](https://dev.to/codista_/wagtail-multi-language-and-internationalization-2gkf) (8 April 2020)
-   [Wagtail SEO Guide](https://www.accordbox.com/blog/wagtail-seo-guide/) (30 March 2020)
-   [Adding a latest-changes list to your Wagtail site](https://spapas.github.io/2020/03/27/wagtail-add-latest-changes/) (27 March 2020)
-   [How to support multi-language in Wagtail CMS](https://www.accordbox.com/blog/how-support-multi-language-wagtail-cms/) (22 February 2020)
-   [Deploying my Wagtail blog to Digital Ocean](https://rosederwelt.com/deploying-my-wagtail-blog-digital-ocean-pt-1/) Part 1 of a 2 part series (29 January 2020)
-   [How to Create and Manage Menus of Wagtail application](https://www.accordbox.com/blog/wagtail-tutorial-12-how-create-and-manage-menus-wagtail-application/) - An updated overview of implementing menus (22 February 2020)
-   [Adding a React component in Wagtail Admin](https://dev.to/lb/adding-a-react-component-in-wagtail-admin-3e) - Shows how to render an interactive timeline of published Pages (30 December 2019)
-   [Wagtail API - how to customise the detail URL](https://dev.to/wagtail/wagtail-api-how-to-customize-the-detail-url-2j3l) (19 December 2020)
-   [How to Add Django Models to the Wagtail Admin](https://dev.to/revsys/how-to-add-django-models-to-the-wagtail-admin-1mdi) (27 August 2019)
-   [How do I Wagtail](https://foundation.mozilla.org/en/docs/how-do-i-wagtail/) - An Editor\'s Guide for Mozilla\'s usage of Wagtail (25 April 2019)
-   [Learn Wagtail](https://learnwagtail.com/) - Regular video tutorials about all aspects of Wagtail (1 March 2019)
-   [How to add buttons to ModelAdmin Index View in Wagtail CMS](https://timonweb.com/tutorials/how-to-add-buttons-to-modeladmin-index-view-in-wagtail-cms/) (23 January 2019)
-   [Wagtail Tutorial Series](https://www.accordbox.com/blog/wagtail-tutorials/) (20 January 2019)
-   [How to Deploy Wagtail to Google App Engine PaaS (Video)](https://www.youtube.com/watch?v=uD9PTag2-PQ) (28 December 2018)
-   [How To Prevent Users From Creating Pages by Page Type](https://timonweb.com/tutorials/prevent-users-from-creating-certain-page-types-in-wagtail-cms/) (25 October 2018)
-   [How to Deploy Wagtail to Jelastic PaaS](https://jelastic.com/blog/deploy-wagtail-python-cms/) (11 October 2018)
-   [Basic Introduction to Setting Up Wagtail](https://medium.com/nonstopio/wagtail-an-open-source-cms-cec6b93706da) (15 August 2018)
-   [E-Commerce for Django developers (with Wagtail shop tutorial)](https://snipcart.com/blog/django-ecommerce-tutorial-wagtail-cms) (5 July 2018)
-   [Supporting StreamFields, Snippets and Images in a Wagtail GraphQL API](https://wagtail.org/blog/graphql-with-streamfield/) (14 June 2018)
-   [Wagtail and GraphQL](https://jossingram.wordpress.com/2018/04/19/wagtail-and-graphql/) (19 April 2018)
-   [Wagtail and Azure storage blob containers](https://jossingram.wordpress.com/2017/11/29/wagtail-and-azure-storage-blob-containers/) (29 November 2017)
-   [Building TwilioQuest with Twilio Sync, Django \[incl. Wagtail\], and Vue.js](https://www.twilio.com/en-us/blog/building-twilioquest-with-twilio-sync-django-and-vue-js-html) (6 November 2017)
-   [Upgrading from Wagtail 1.0 to Wagtail 1.11](https://www.caktusgroup.com/blog/2017/07/19/upgrading-wagtail/) (19 July 2017)
-   [Wagtail-Multilingual: a simple project to demonstrate how multilingual is implemented](https://github.com/cristovao-alves/Wagtail-Multilingual) (31 January 2017)
-   [Wagtail: 2 Steps for Adding Pages Outside of the CMS](https://www.caktusgroup.com/blog/2016/02/15/wagtail-2-steps-adding-pages-outside-cms/) (15 February 2016)
-   [Deploying Wagtail to Heroku](https://wagtail.org/blog/deploying-wagtail-heroku/) (15 July 2015)
-   [Adding a Twitter Widget for Wagtail's new StreamField](https://jossingram.wordpress.com/2015/04/02/adding-a-twitter-widget-for-wagtails-new-streamfield/) (2 April 2015)
-   [Working With Wagtail: Menus](https://learnwagtail.com/tutorials/how-to-create-a-custom-wagtail-menu-system/) (22 January 2015)
-   [Upgrading Wagtail to use Django 1.7 locally using vagrant](https://jossingram.wordpress.com/2014/12/10/upgrading-wagtail-to-use-django-1-7-locally-using-vagrant/) (10 December 2014)
-   [Wagtail redirect page. Can link to page, URL and document](https://gist.github.com/alej0varas/e7e334643ceab6e65744) (24 September 2014)
-   [Outputting JSON for a model with properties and db fields in Wagtail/Django](https://jossingram.wordpress.com/2014/09/24/outputing-json-for-a-model-with-properties-and-db-fields-in-wagtaildjango/) (24 September 2014)
-   [Bi-lingual website using Wagtail CMS](https://jossingram.wordpress.com/2014/09/17/bi-lingual-website-using-wagtail-cms/) (17 September 2014)
-   [Wagtail CMS -- Lesser known features](https://jossingram.wordpress.com/2014/09/12/wagtail-cms-lesser-known-features/) (12 September 2014)
-   [Wagtail notes: stateful on/off hallo.js plugins](https://www.coactivate.org/projects/ejucovy/blog/2014/08/09/wagtail-notes-stateful-onoff-hallojs-plugins/) (9 August 2014)
-   [Add some blockquote buttons to Wagtail CMS' WYSIWYG Editor](https://jossingram.wordpress.com/2014/07/24/add-some-blockquote-buttons-to-wagtail-cms-wysiwyg-editor/) (24 July 2014)
-   [Adding Bread Crumbs to the front end in Wagtail CMS](https://jossingram.wordpress.com/2014/07/01/adding-bread-crumbs-to-the-front-end-in-wagtail-cms/) (1 July 2014)
-   [Extending hallo.js using Wagtail hooks](https://gist.github.com/jeffrey-hearn/502d0914fa4a930f08ac) (9 July 2014)
-   [Wagtail notes: custom tabs per page type](https://www.coactivate.org/projects/ejucovy/blog/2014/05/10/wagtail-notes-custom-tabs-per-page-type/) (10 May 2014)
-   [Wagtail notes: managing redirects as pages](https://www.thirdbearsolutions.com/blog/managing-wagtail-redirects-pages/) (10 May 2014)
-   [Wagtail notes: dynamic templates per page](https://www.thirdbearsolutions.com/blog/letting-editors-choose-template-wagtail-page/) (10 May 2014)
-   [Wagtail notes: type-constrained PageChooserPanel](https://python.hotexamples.com/examples/wagtail.wagtailadmin.edit_handlers/PageChooserPanel/-/python-pagechooserpanel-class-examples.html) (9 May 2014)

You can also find more resources from the community on [Awesome Wagtail](https://github.com/springload/awesome-wagtail).

## Tip

We are working on a collection of Wagtail tutorials and best practices.
Please share your Wagtail HOWTOs, development notes, or site launches in the [Wagtail Slack workspace](https://github.com/wagtail/wagtail/wiki/Slack) in #watercooler, or feel free to reach out directly via [email](mailto:hello@wagtail.org).
