#
# Wagtail documentation build configuration file, created by
# sphinx-quickstart on Tue Jan 14 17:38:55 2014.
#
# This file is execfile()d with the current directory set to its
# containing dir.
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

import os
import sys
from datetime import datetime

import django
import sphinx_wagtail_theme
from sphinx.builders.html import StandaloneHTMLBuilder

from wagtail import VERSION, __version__

# use png images as fallback, required to build pdf
StandaloneHTMLBuilder.supported_image_types = ["image/gif", "image/png"]

# on_rtd is whether we are on readthedocs.org, this line of code grabbed from docs.readthedocs.org
on_rtd = os.environ.get("READTHEDOCS", None) == "True"

# Relative path to the root of the documentation, used for linking to the
# Typedoc-generated sub-docs. RTD allows optional language and version.
base_path = ""
if rtd_lang := os.environ.get("READTHEDOCS_LANGUAGE", ""):
    base_path += f"/{rtd_lang}"
if rtd_version := os.environ.get("READTHEDOCS_VERSION", ""):
    base_path += f"/{rtd_version}"

html_theme = "sphinx_wagtail_theme"
html_theme_path = [sphinx_wagtail_theme.get_html_theme_path()]

html_theme_options = {
    "project_name": "Wagtail Documentation",
    "github_url": "https://github.com/wagtail/wagtail/blob/main/docs/",
}

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
sys.path.insert(0, os.path.abspath(".."))

# Autodoc may need to import some models modules which require django settings
# be configured
os.environ["DJANGO_SETTINGS_MODULE"] = "wagtail.test.settings"
django.setup()

# Use SQLite3 database engine so it doesn't attempt to use psycopg2 on RTD
os.environ["DATABASE_ENGINE"] = "django.db.backends.sqlite3"

# -- General configuration ------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
# needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    "sphinx.ext.autodoc",
    "sphinx.ext.intersphinx",
    "sphinx_copybutton",
    "myst_parser",
    "sphinx_wagtail_theme",
    "sphinx_llm.txt",
]

autodoc_type_aliases = {
    "File": "django.core.files.File",
}

# Silence warnings that are not due to missing references:
nitpick_ignore = [
    # Sphinx currently cannot resolve type hint names, warns "target not found":
    ("py:class", "wagtail.images.models.Filter"),
    ("py:class", "wagtail.url_routing.RouteResult"),
    ("py:class", "wagtail.blocks.base.Block"),
    ("py:class", "wagtail.blocks.field_block.BaseChoiceBlock"),
    ("py:class", "wagtail.blocks.field_block.ChooserBlock"),
    # Warnings due factors other than type hints:
    ("py:class", "wagtail.documents.views.chooser.BaseDocumentChooserBlock"),
    ("py:class", "wagtail.blocks.struct_block.BaseStructBlock"),
    ("py:class", "wagtail.blocks.stream_block.BaseStreamBlock"),
]

# We have .txt and .ico files in the static directory that trigger unknown mime
# type warnings when building the epub and are ignored by the builder. For the
# table markup files, they are already rendered in the output. Other files are
# not relevant to the epub. Suppress the warnings so we don't have to explicitly
# list the files in `epub_exclude_files`.
suppress_warnings = [
    "epub.unknown_project_files",
]

if not on_rtd:
    extensions.append("sphinxcontrib.spelling")

# Add any paths that contain templates here, relative to this directory.
templates_path = ["_templates"]

# The suffix of source filenames.
source_suffix = ".rst"

# The encoding of source files.
# source_encoding = 'utf-8-sig'

# The master toctree document.
master_doc = "index"

# General information about the project.
project = "Wagtail Documentation"
copyright = f"{datetime.now().year}, Wagtail core team and contributors. BSD license"

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.

# The short X.Y version.
version = f"{VERSION[0]}.{VERSION[1]}"
# The full version, including alpha/beta/rc tags.
release = __version__

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
# language = None

# There are two options for replacing |today|: either, you set today to some
# non-false value, then it is used:
# today = ''
# Else, today_fmt is used as the format for a strftime call.
# today_fmt = '%B %d, %Y'

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
exclude_patterns = ["_build", "README.md"]

# The reST default role (used for this markup: `text`) to use for all
# documents.
# default_role = None

# If true, '()' will be appended to :func: etc. cross-reference text.
# add_function_parentheses = True

# If true, the current module name will be prepended to all description
# unit titles (such as .. function::).
# add_module_names = True

# If true, sectionauthor and moduleauthor directives will be shown in the
# output. They are ignored by default.
# show_authors = False

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = None

# A list of ignored prefixes for module index sorting.
# modindex_common_prefix = []

# If true, keep warnings as "system message" paragraphs in the built documents.
# keep_warnings = False

# splhinxcontrib.spelling settings

spelling_lang = "en_GB"
spelling_word_list_filename = "spelling_wordlist.txt"

# sphinx.ext.intersphinx settings
intersphinx_mapping = {
    "django": (
        "https://docs.djangoproject.com/en/stable/",
        "https://docs.djangoproject.com/en/stable/_objects/",
    ),
    "python": (
        "https://docs.python.org/3/",
        None,
    ),
    "treebeard": (
        "https://django-treebeard.readthedocs.io/en/stable/",
        None,
    ),
    "sphinx": (
        "https://www.sphinx-doc.org/en/master/",
        None,
    ),
    "myst": (
        "https://myst-parser.readthedocs.io/en/stable/",
        None,
    ),
}

myst_url_schemes = {
    "https": None,
    "http": None,
    "mailto": None,
    "client": {
        "url": "%s/reference/ui/client/{{path}}.html#{{fragment}}" % base_path,
        "title": "{{path}}",
        "classes": ["pre"],
    },
    "controller": {
        "url": (
            "%s/reference/ui/client/classes/controllers_{{path}}.{{path}}.html#{{fragment}}"
            % base_path
        ),
        "title": "{{path}}",
        "classes": ["pre"],
    },
}

myst_enable_extensions = [
    # To support the `.external` link modifier. See:
    # https://myst-parser.readthedocs.io/en/latest/syntax/cross-referencing.html#customising-external-url-resolution
    # https://myst-parser.readthedocs.io/en/latest/syntax/optional.html#syntax-attributes-inline
    "attrs_inline",
]

# -- Options for HTML output ----------------------------------------------

# Theme options are theme-specific and customise the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
# html_theme_options = {}

# The name for this set of Sphinx documents.  If None, it defaults to
# "<project> v<release> documentation".
# html_title = None

# A shorter title for the navigation bar.  Default is the same as html_title.
# html_short_title = None

# The name of an image file (relative to this directory) to place at the top
# of the sidebar.
# html_logo = 'logo.png'

# The name of an image file (within the static path) to use as favicon of the
# docs.  This file should be a Windows icon file (.ico) being 16x16 or 32x32
# pixels large.
html_favicon = "favicon.ico"

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ["_static"]

# Add any extra paths that contain custom files (such as robots.txt or
# .htaccess) here, relative to this directory. These files are copied
# directly to the root of the documentation.
html_extra_path = ["public"]

# If not '', a 'Last updated on:' timestamp is inserted at every page bottom,
# using the given strftime format.
# html_last_updated_fmt = '%b %d, %Y'

# If true, SmartyPants will be used to convert quotes and dashes to
# typographically correct entities.
# html_use_smartypants = True

# Custom sidebar templates, maps document names to template names.
# html_sidebars = {}

# Additional templates that should be rendered to pages, maps page names to
# template names.
# html_additional_pages = {}

# If false, no module index is generated.
# html_domain_indices = True

# If false, no index is generated.
# Since we are implementing search with Algolia DocSearch, we do not need Sphinx to
# generate its own index. It might not hurt to keep the Sphinx index, but it
# could potentially speed up the build process.
html_use_index = False

# If true, the index is split into individual pages for each letter.
# html_split_index = False

# If true, links to the reST sources are added to the pages.
# html_show_sourcelink = True

# If true, "Created using Sphinx" is shown in the HTML footer. Default is True.
# html_show_sphinx = True

# If true, "(C) Copyright ..." is shown in the HTML footer. Default is True.
# html_show_copyright = True

# If true, an OpenSearch description file will be output, and all pages will
# contain a <link> tag referring to it.  The value of this option must be the
# base URL from which the finished HTML is served.
# html_use_opensearch = ''

# This is the file name suffix for HTML files (for example ".xhtml").
# html_file_suffix = None

# Output file base name for HTML help builder.
htmlhelp_basename = "Wagtaildoc"

# -- Options for LaTeX output ---------------------------------------------

# Xelatex engine is required to include unicode characters in the doc
latex_engine = "xelatex"

latex_elements = {
    # The paper size ('letterpaper' or 'a4paper').
    # 'papersize': 'letterpaper',
    # The font size ('10pt', '11pt' or '12pt').
    # 'pointsize': '10pt',
    # Additional stuff for the LaTeX preamble.
    # 'preamble': '',
}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title,
#  author, documentclass [howto, manual, or own class]).
latex_documents = [
    (
        "index",
        "Wagtail.tex",
        "Wagtail Documentation",
        "Wagtail core team and contributors",
        "manual",
    ),
]

# The name of an image file (relative to this directory) to place at the top of
# the title page.
# latex_logo = None

# For "manual" documents, if this is true, then toplevel headings are parts,
# not chapters.
# latex_use_parts = False

# If true, show page references after internal links.
# latex_show_pagerefs = False

# If true, show URL addresses after external links.
# latex_show_urls = False

# Documents to append as an appendix to all manuals.
# latex_appendices = []

# If false, no module index is generated.
# latex_domain_indices = True

# -- Options for manual page output ---------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [
    (
        "index",
        "wagtail",
        "Wagtail Documentation",
        ["Wagtail core team and contributors"],
        1,
    )
]

# If true, show URL addresses after external links.
# man_show_urls = False

# -- Options for Texinfo output -------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    (
        "index",
        "Wagtail",
        "Wagtail Documentation",
        "Wagtail core team and contributors",
        "Wagtail",
        "An open source content management system built on Django.",
        "Miscellaneous",
    ),
]

# Documents to append as an appendix to all manuals.
# texinfo_appendices = []

# If false, no module index is generated.
# texinfo_domain_indices = True

# How to display URL addresses: 'footnote', 'no', or 'inline'.
# texinfo_show_urls = 'footnote'

# If true, do not generate a @detailmenu in the "Top" node's menu.
# texinfo_no_detailmenu = False

# -- Options for Epub output ---------------------------------------------------

# Bibliographic Dublin Core info.
epub_title = project
epub_author = "Wagtail core team and contributors"
epub_publisher = "Wagtail"
epub_copyright = copyright


def setup(app):
    app.add_js_file("js/banner.js")

    # Django-specific roles, from
    # https://github.com/django/django/blob/main/docs/_ext/djangodocs.py:
    app.add_crossref_type(
        directivename="setting",
        rolename="setting",
        indextemplate="pair: %s; setting",
    )
    app.add_crossref_type(
        directivename="templatetag",
        rolename="ttag",
        indextemplate="pair: %s; template tag",
    )
    app.add_crossref_type(
        directivename="templatefilter",
        rolename="tfilter",
        indextemplate="pair: %s; template filter",
    )
    app.add_crossref_type(
        directivename="fieldlookup",
        rolename="lookup",
        indextemplate="pair: %s; field lookup type",
    )

    # Stop Sphinx from looking in the wrong place for HttpRequest when resolving
    # type annotations - see https://github.com/wagtail/wagtail/pull/12777
    from django.http import HttpRequest

    HttpRequest.__module__ = "django.http"
