```{eval-rst}
:hidetoc: 1
```

# Getting started

```{toctree}
---
maxdepth: 1
---
tutorial
quick_install
demo_site
integrating_into_django
the_zen_of_wagtail
```

Wagtail is an open-source content management system (CMS) that's built on [Django](https://www.djangoproject.com/), a popular Python web framework. It has gained popularity among developers and content editors for its powerful features and intuitive interface, providing a streamlined editing experience. Wagtail offers a comprehensive toolkit for content creation and management, including a rich text editor with formatting options, image and document management, version control, workflows, and content scheduling.

Developers appreciate Wagtail's highly customizable and modular architecture, which includes built-in support for Django's app structure. This allows them to easily create and integrate custom functionality, making Wagtail suitable for projects of any size. Wagtail excels in handling complex content structures, offering features like hierarchical page organization, robust search capabilities, and content localization.

Wagtail stands out as the preferred choice for tens of thousands of organizations globally, including renowned names like Google, the National Aeronautics and Space Administration (NASA), and the British National Health Service (NHS). It has proven scalability and is capable of handling high volumes of traffic from millions of visitors every month. What sets Wagtail apart is its ability to extend beyond traditional content management, providing seamless integration with data tools and rich data visualizations.

For more information about Wagtail and the guiding principles for building websites with it, read [The Zen of Wagtail](the_zen_of_wagtail).
