(ui_components)=

# UI components

This document provides a reference for Wagtail's user interface (UI) components, which are used to build the features within the CMS. A demonstration of these components are available through the [Styleguide app](styleguide) and the [pattern library](pattern_library).

````{note}
```{include} ../../../client/README.md
:start-after: <!-- STABILITY:START -->
:end-before: <!-- STABILITY:END -->
```
````

## Fragment

```{eval-rst}
.. autofunction:: wagtail.admin.templatetags.wagtailadmin_tags.fragment
```

## Dialog

```{eval-rst}
.. class:: wagtail.admin.templatetags.wagtailadmin_tags.DialogNode
   :no-contents-entry:
```

A dialog to display information in a modal dialog. It is powered by the [`DialogController`](controller:DialogController) (`w-dialog`). To create a dialog, you can use the `{% dialog %}` and `{% enddialog %}` template tags.

```html+django
{% dialog icon_name="globe" title="Dialog with critical error" id="my-dialog" subtitle="This is a testing subtitle" message_status="critical" message_heading="There was an issue with the thing" message_description="This is a subtext for the message" %}
    <p>This dialog message was generated by passing message_status=critical as well as message_heading and message_description to the dialog template tag</p>
{% enddialog %}
```

Required arguments for the `{% dialog %}` tag:

- `id`: The ID of the dialog, to be used by the [`{% dialog_toggle %}`](dialog_toggle) tag.
- `title`: The title of the dialog.

Optional arguments for the `{% dialog %}` tag:

- `dialog_root_selector`: The CSS selector for the dialog root element, defaults to `body`. Useful when you want to render the dialog in a specific part of the DOM, such as within a `<form>` element.
- `icon_name`: The name of the icon to display in the dialog header.
- `subtitle`: The subtitle of the dialog.
- `theme`: The theme of the dialog, either empty or `floating`.
- `classname`: CSS classes for styling the dialog.

The content of the dialog can be any Django template code written between the `{% dialog %}` and `{% enddialog %}` tags.

The dialog can also display a status message at the top, such as an error or a warning. The following optional arguments can be used to render the message:

- `message_status`: The status level of the message, which can be one of: `info`, `warning`, `critical`, `success`.
- `message_heading`: The heading of the message.
- `message_description`: The description of the message.

### Dialog toggle

```{eval-rst}
.. function:: wagtail.admin.templatetags.wagtailadmin_tags.dialog_toggle
   :no-contents-entry:
```

A button component that opens a dialog with the specified ID. To create a button that opens a dialog, you can use the `{% dialog_toggle %}` template tag.

```html+django
{% dialog_toggle classname='button' dialog_id='my-dialog' text='Dialog with error' %}
```

Arguments for the `{% dialog_toggle %}` tag:

- `dialog_id`: The ID of the dialog to open.
- `text`: The text to display on the button.
- `classname` (optional): CSS classes for styling the button.

## Dropdown

```{eval-rst}
.. class:: wagtail.admin.templatetags.wagtailadmin_tags.DropdownNode
   :no-contents-entry:
```

A dropdown menu to display a list of actions or options. It is powered by the [`DropdownController`](controller:DropdownController) (`w-dropdown`). To create a dropdown, you can use the `{% dropdown %}` and `{% enddropdown %}` template tags.

```html+django
{% dropdown toggle_icon="dots-horizontal" toggle_aria_label="Actions" %}
    <a href="/admin/pages/2/move/">{% icon name="arrow-right-full" %} Move</a>
    <a href="/admin/pages/2/copy/">{% icon name="copy" %} Copy</a>
    <a href="/admin/pages/2/delete/">{% icon name="bin" %} Delete</a>
    <a href="/admin/pages/2/unpublish/">{% icon name="download" %} Unpublish</a>
{% enddropdown %}
```

The dropdown's contents must be `a` and `button` elements only.

Arguments for the `{% dropdown %}` tag:

- `toggle_icon`: Name of the icon to display on the toggle button.
- `toggle_label`: Visible label for the toggle button, displayed before the icon.
- `toggle_suffix`: Visible content for the toggle button, displayed after the icon.
- `toggle_aria_label`: `aria-label` for the toggle button.
- `toggle_describedby`: `aria-describedby` for the toggle button.
- `toggle_classname`: CSS classes for styling the toggle button.
- `toggle_tooltip_offset`: The offset value for the dropdown, in similar format to the offset of [Tooltip](ui_tooltip).
- `toggle_tippy_offset`: The offset value for the dropdown toggle's [Tooltip](ui_tooltip).
- `hide_on_click`: Whether or not the dropdown should hide when clicking inside its content.
- `keep_mounted` Whether or not the dropdown should keep its DOM node mounted when hidden.
- `classname`: CSS classes for styling the dropdown.
- `attrs`: HTML attributes to add to the dropdown element.

All of the above arguments are optional, but either `toggle_label` or a combination of `toggle_icon` and `toggle_aria_label` must be provided to ensure the dropdown toggle is accessible.

### Button with dropdown

```{eval-rst}
.. class:: wagtail.admin.templatetags.wagtailadmin_tags.DropdownButtonNode
   :no-contents-entry:
```

A button with a dropdown menu next to it. This is a specialized version of the [dropdown](DropdownNode) component. To create a button with dropdown, you need to combine a rendered button HTML fragment with the `{% dropdown_button %}` and `{% enddropdown_button %}` template tags.

```html+django
{% load wagtailadmin_tags %}
{% fragment as button %}
    <button type="button" class="button">Main button</button>
{% endfragment %}
{% dropdown_button button=button toggle_icon="arrow-up" %}
    <button type="submit" class="button">First item</button>
    <a class="button" href="#">Second item</a>
{% enddropdown_button %}
```

The dropdown's contents must be `a` and `button` elements only.

Arguments for the `{% dropdown_button %}` tag:

- `button`: The main button HTML fragment.
- `toggle_icon`: Name of the icon to display on the toggle button. Defaults to `arrow-down`.
- `toggle_classname`: CSS classes for styling the toggle button.
- `keep_mounted`: Whether or not the dropdown should keep its DOM node mounted when hidden.
- `classname`: CSS classes for styling the element that wraps the button and dropdown.

Only the `button` argument is required, the rest are optional.

(ui_tooltip)=

## Tooltip

A tooltip that can be attached to an HTML element to display additional information on hover or focus. It is powered by the [`TooltipController`](controller:TooltipController) (`w-tooltip`). To add a tooltip, attach the `w-tooltip` controller to an element and specify the properties using data attributes.

```html
<button
    type="button"
    data-controller="w-tooltip"
    data-w-tooltip-content-value="More detail here"
    data-w-tooltip-offset-value="[10, 15]"
    data-w-tooltip-placement-value="top"
>
  A button with a tooltip
</button>
```

If you need the tooltip to display rich content, you can use an HTML element as the content target with a `data-w-tooltip-target="content"` attribute inside the `w-tooltip` element:

```html
<button
    type="button"
    data-controller="w-tooltip"
    data-w-tooltip-offset-value="[10, 15]"
    data-w-tooltip-placement-value="top"
>
  <template data-w-tooltip-target="content">
    More <strong>detail</strong> here
  </template>
  A button with a tooltip
</button>
```

Available value attributes for `w-tooltip`:

- `data-w-tooltip-content-value`: The content of the tooltip. Optional if a content target is used instead.
- `data-w-tooltip-offset-value` (optional): The offset of the tooltip from the element, specified as an array of two numbers (`[skidding, distance]`). Defaults to `[0, 10]`.
- `data-w-tooltip-placement-value` (optional): The placement of the tooltip relative to the element. Possible values are `top`, `top-start`, `top-end`, `right`, `right-start`, `right-end`, `bottom`, `bottom-start`, `bottom-end`, `left`, `left-start`, `left-end`. Defaults to `bottom`.
