# Wagtail 2.16.2 release notes

_April 11, 2022_

```{contents}
---
local:
depth: 1
---
```

## What's new

### Bug fixes

 * Update django-treebeard dependency to 4.5.1 or above (Serafeim Papastefanos)
 * Fix permission error when sorting pages having page type restrictions (Thijs Kramer)
 * Allow bulk publishing of pages without revisions (Andy Chosak)
 * Ensure that all descendant pages are logged when deleting a page, not just immediate children (Jake Howard)
 * Refactor `FormPagesListView` in wagtail.contrib.forms to avoid undefined `locale` variable when subclassing (Dan Braghis)
 * Ensure page copy in Wagtail admin doesn't ignore `exclude_fields_in_copy` (John-Scott Atlakson)
 * Generate new translation keys for translatable `Orderable`s when page is copied without being published (Kalob Taulien, Dan Braghis)
 * Ignore `GenericRelation` when copying pages (John-Scott Atlakson)
 * Ensure 'next' links from image / document listings do not redirect back to partial AJAX view (Matt Westcott)
 * Skip creation of automatic redirects when page cannot be routed (Matt Westcott)
 * Prevent JS errors on locale switcher in page chooser (Matt Westcott)

## Upgrade considerations

### Jinja2 compatibility

Developers using Jinja2 templating should note that the template tags in this release (and earlier releases in the 2.15.x and 2.16.x series) are compatible with Jinja2 2.11.x and 3.0.x. Jinja2 2.11.x is unmaintained and requires `markupsafe` to be pinned to version `<2.1` to work; Jinja2 3.1.x has breaking changes and is not compatible. We therefore recommend that you use Jinja2 3.0.x, or 2.11.x with fully pinned dependencies.
