# Wagtail 2.16 release notes

_February 7, 2022_

```{contents}
---
local:
depth: 1
---
```

## What's new

### Django 4.0 support

This release adds support for Django 4.0.

### Slim sidebar

As part of a [wider redesign](https://github.com/wagtail/wagtail/discussions/7739) of Wagtail’s administration interface, we have replaced the sidebar with a slim, keyboard-friendly version. This re-implementation comes with significant accessibility improvements for keyboard and screen reader users, and will enable us to make navigation between views much snappier in the future. Please have a look at [upgrade considerations](2.16_upgrade_considerations) for more details on differences with the previous version.

### Automatic redirect creation

Wagtail projects using the `wagtail.contrib.redirects` app now benefit from 'automatic redirect creation' - which creates redirects for pages and their descedants whenever a URL-impacting change is made; such as a slug being changed, or a page being moved to a different part of the tree.

This feature should be beneficial to most 'standard' Wagtail projects and, in most cases, will have only a minor impact on responsiveness when making such changes. However, if you find this feature is not a good fit for your project, you can disabled it by adding the following to your project settings:

```python
WAGTAILREDIRECTS_AUTO_CREATE = False
```

Thank you to [The National Archives](https://www.nationalarchives.gov.uk) for kindly sponsoring this feature.

### Other features

 * Added persistent IDs for ListBlock items, allowing commenting and improvements to revision comparisons (Matt Westcott, Tidiane Dia, with sponsorship from [NHS](https://www.nhs.uk/))
 * Added Aging Pages report (Tidiane Dia)
 * Add more SketchFab oEmbed patterns for models (Tom Usher)
 * Added `page_slug_changed` signal for Pages (Andy Babic)
 * Add collapse option to `StreamField`, `StreamBlock`, and `ListBlock` which will load all sub-blocks initially collapsed (Matt Westcott)
 * Private pages can now be fetched over the API (Nabil Khalil)
 * Added `alias_of` field to the pages API (Dmitrii Faiazov)
 * Add support for Azure CDN and Front Door front-end cache invalidation (Tomasz Knapik)
 * Fixed `default_app_config` deprecations for Django >= 3.2 (Tibor Leupold)
 * Removed WOFF fonts
 * Improved styling of workflow timeline modal view (Tidiane Dia)
 * Add secondary actions menu in edit page headers (Tidiane Dia)
 * Add system check for missing core Page fields in `search_fields` (LB (Ben Johnston))
 * Improve CircleCI frontend & backend build caches, add automated browser accessibility test suite in CircleCI (Thibaud Colas)
 * Add a 'remember me' checkbox to the admin sign in form, if unticked (default) the auth session will expire if the browser is closed (Michael Karamuth, Jake Howard)
 * When returning to image or document listing views after editing, filters (collection or tag) are now remembered (Tidiane Dia)
 * Improve the visibility of field error messages, in Windows high-contrast mode and out (Jason Attwood)
 * Improve implementations of visually-hidden text in explorer and main menu toggle (Martin Coote)
 * Add locale labels to page listings (Dan Braghis)
 * Add locale labels to page reports (Dan Braghis)
 * Change release check domain to releases.wagtail.org (Jake Howard)
 * Add the user who submitted a page for moderation to the "Awaiting your review" homepage summary panel (Tidiane Dia)
 * When moving pages, default to the current parent section (Tidiane Dia)
 * Add borders to TypedTableBlock to help visualize rows and columns (Scott Cranfill)
 * Set default submit button label on generic create views to 'Create' instead of 'Save' (Matt Westcott)
 * Improve display of image listing for long image titles (Krzysztof Jeziorny)
 * Use SVG icons in admin home page site summary items (Jérôme Lebleu)
 * Ensure site summary items wrap on smaller devices on the admin home page (Jérôme Lebleu)
 * Rework Workflow task chooser modal to align with other chooser modals, using consistent pagination and leveraging class based views (Matt Westcott)
 * Implemented a locale switcher on the forms listing page in the admin (Dan Braghis)
 * Implemented a locale switcher on the page chooser modal (Dan Braghis)
 * Implemented the `wagtail_site` template tag for Jinja2 (Vladimir Tananko)
 * Change webmaster to website administrator in the admin (Naomi Morduch Toubman)
 * Added documentation for creating custom submenus in the admin menu (Sævar Öfjörð Magnússon)
 * Choice blocks in StreamField now show label rather than value when collapsed (Jérôme Lebleu)
 * Added documentation to clarify configuration of user-uploaded files (Cynthia Kiser)
 * Change security contact address to security@wagtail.org (Jake Howard)

### Bug fixes

 * Accessibility fixes for Windows high contrast mode; Dashboard icons color and contrast, help/error/warning blocks for fields and general content, side comment buttons within the page editor, dropdown buttons (Sakshi Uppoor, Shariq Jamil, LB (Ben Johnston), Jason Attwood)
 * Rename additional 'spin' CSS animations to avoid clashes with other libraries (Kevin Gutiérrez)
 * Pages are refreshed from database on create before passing to hooks. Page aliases get correct `first_published_date` and `last_published_date` (Dan Braghis)
 * Additional login form fields from `WAGTAILADMIN_USER_LOGIN_FORM` are now rendered correctly (Michael Karamuth)
 * Fix icon only button styling issue on small devices where height would not be set correctly (Vu Pham)
 * Add padding to the Draftail editor to ensure `ol` items are not cut off (Khanh Hoang)
 * Prevent opening choosers multiple times for Image, Page, Document, Snippet (LB (Ben Johnston))
 * Ensure subsequent changes to styles files are picked up by Gulp watch (Jason Attwood)
 * Ensure that programmatic page moves are correctly logged as 'move' and not 'reorder' in some cases (Andy Babic)


(2.16_upgrade_considerations)=

## Upgrade considerations

### Removed support for Django 3.0 and 3.1

Django 3.0 and 3.1 are no longer supported as of this release; please upgrade to Django 3.2 or above before upgrading Wagtail.

### Removed support for Python 3.6

Python 3.6 is no longer supported as of this release; please upgrade to Python 3.7 or above before upgrading Wagtail.

### StreamField ListBlock now returns `ListValue` rather than a list instance

The data type returned as the value of a ListBlock is now a custom class, `ListValue`, rather than a Python `list` object. This change allows it to provide a `bound_blocks` property that exposes the list items as [`BoundBlock` objects](../advanced_topics/boundblocks_and_values) rather than plain values. `ListValue` objects are mutable sequences that behave similarly to lists, and so all code that iterates over them, accesses individual elements, or manipulates them should continue to work. However, code that specifically expects a `list` object (e.g. using `isinstance` or testing for equality against a list) may need to be updated. For example, a unit test that tests the value of a `ListBlock` as follows:

```python
    self.assertEqual(page.body[0].value, ['hello', 'goodbye'])
```

should be rewritten as:

```python
    self.assertEqual(list(page.body[0].value), ['hello', 'goodbye'])
```

### Change to `set` method on tag fields

This release upgrades the [django-taggit](https://django-taggit.readthedocs.io/en/latest/) library to 2.x, which introduces one breaking change: the `TaggableManager.set` method now accepts a list of tags as a single argument, rather than a variable number of arguments. Code such as `page.tags.set('red', 'blue')` should be updated to `page.tags.set(['red', 'blue'])`.

### `wagtail.admin.views.generic.DeleteView` follows Django 4.0 conventions

The internal (undocumented) class-based view `wagtail.admin.views.generic.DeleteView` has been updated to align with [Django 4.0's `DeleteView` implementation](https://docs.djangoproject.com/en/stable/releases/4.0/#deleteview-changes), which uses `FormMixin` to handle POST requests. Any custom deletion logic in `delete()` handlers should be moved to `form_valid()`.

### Renamed admin/expanding-formset.js

`admin/expanding_formset.js` has been renamed to `admin/expanding-formset.js` as part of frontend code clean up work. Check for any customized admin views that are extending expanding formsets, or have overridden template and copied the previous file name used in an import as these may need updating.

### Deprecated sidebar capabilities

The new sidebar largely supports the same customizations as its predecessor, with a few exceptions:

- Top-level menu items should now always provide an `icon_name`, so they can be visually distinguished when the sidebar is collapsed.
- `MenuItem` and its sub-classes no longer supports customizing arbitrary HTML attributes.
- `MenuItem` can no longer be sub-classed to customize its HTML output or load additional JavaScript

For sites relying on those capabilities, we provide a `WAGTAIL_SLIM_SIDEBAR = False` setting to switch back to the legacy sidebar. The legacy sidebar and this setting will be removed in Wagtail 2.18.
