# Wagtail 4.1 (LTS) release notes

_November 1, 2022_

```{contents}
---
local:
depth: 1
---
```

Wagtail 4.1 is designated a Long Term Support (LTS) release. Long Term Support releases will continue to receive maintenance updates as necessary to address security and data-loss related issues, up until the next LTS release (typically a period of 12 months).

## What's new

### "What's New" dashboard banner and "Help" menu

To help with onboarding new users, Wagtail now displays a banner on the dashboard, pointing users to our Editor Guide. The sidebar also contains a new "Help" menu item with a prominent indicator to call attention to the new content: a "What’s new" page showcasing new features, and a link to the Editor Guide.

Users can dismiss the new banner and the sidebar items’ indicators by interacting with the corresponding UI element. We store the state in the user’s profile so we only call attention to the content once.

To turn off the new banner, set [`WAGTAIL_ENABLE_WHATS_NEW_BANNER`](wagtail_enable_whats_new_banner) to `False` in your settings. The new menu items can be removed and customized with the following hooks:

- [`register_help_menu_item`](register_help_menu_item) – to add new items to the "Help" menu
- [`construct_help_menu`](construct_help_menu) – to change or remove existing items from the "Help" menu
- [`construct_main_menu`](construct_main_menu) – to remove the new "Help" menu altogether

### Page editor minimap

When navigating long page editing interfaces, it can be tedious to pinpoint a specific section, or find all validation errors. To help with those tasks, the page editor now has a new "minimap" side panel, with a table of contents of all sections on the form. Clicking a section’s label scrolls straight to this part of the page, and an indicator bar represents which sections are currently visible on the page. When validation errors are present, each section shows a count of the number of errors. This feature was implemented by Thibaud Colas based on a prototype by LB (Ben) Johnston.

### New UI for scheduled publishing

Scheduled publishing settings can now be found within the Status side panel of the page editing view. This change aims to improve clarity over who can set schedules, and when they take effect. This feature was developed by Sage Abdullah.

### Customizable snippet admin views

The `register_snippet` function now accepts a `SnippetViewSet` class, allowing various aspects of the snippet's admin views to be customized. See [](wagtailsnippets_custom_admin_views). This feature was developed by Sage Abdullah.

### Scheduled publishing for snippets

Snippet models that inherit from `DraftStateMixin` can now be assigned go-live and expiry dates. This feature was developed by Sage Abdullah.

### Object usage reporting

Images, documents and snippets now provide a usage report, listing the places where references to those objects appear. This report is powered by a new `ReferenceIndex` model which records cross-references between objects whenever those objects to save; this allows it to work more efficiently than the old report available through the `WAGTAIL_USAGE_COUNT_ENABLED` setting, as well as handling references within StreamField and rich text fields.

Note that on first upgrading to Wagtail 4.1, you will need to run the `rebuild_references_index` management command to populate the references table and ensure that reference counts are displayed accurately. By default, references are tracked for all models in the project, including ones not managed through Wagtail - to disable this for specific models, see [](managing_the_reference_index).

This feature was developed by Karl Hobley and Matt Westcott.

### Documentation improvements

There are multiple improvements to the documentation theme this release, here are some highlights.

* Code snippets now have a quick copy to clipboard button (Mohammad Areeb)
* Improve the dark mode theme adoption, avoid flashing the wrong theme on first load, reduce the need for scrollbars in page TOC, link underline fixes in Safari (LB (Ben) Johnston, Kartik Kankurte)
* Better accessibility support with a skip to content link (LB (Ben) Johnston)

### Other features

 * Formalised support for Python 3.11 (Matt Westcott)
 * Add basic keyboard control and screen reader support for page listing re-ordering (Paarth Agarwal, Thomas van der Hoeven)
 * Add `PageQuerySet.private` method as an alias of `not_public` (Mehrdad Moradizadeh)
 * Most images in the admin will now only load once they are visible on screen (Jake Howard)
 * Allow setting default attributes on image tags [](adding_default_attributes_to_images) (Jake Howard)
 * Optimise the performance of the Wagtail userbar to remove duplicated queries, improving page loads when viewing live pages while signed in (Jake Howard)
 * Remove legacy styling classes for buttons and refactor button styles to be more maintainable (Paarth Agarwal, LB (Ben Johnston))
 * Add button variations to the pattern library (Paarth Agarwal)
 * Provide a more accessible page title where the unique information is shown first and the CMS name is shown last (Mehrdad Moradizadeh)
 * Pull out behavior from `AbstractFormField` to `FormMixin` and `AbstractEmailForm` to `EmailFormMixin` to allow use with subclasses of `Page` [](form_builder_mixins) (Mehrdad Moradizadeh, Kurt Wall)
 * Add a `docs.wagtail.org/.well-known/security.txt` so that the security policy is available as per the specification on [https://securitytxt.org/](https://securitytxt.org/) (Jake Howard)
 * Add unit tests for the `classnames` Wagtail admin template tag (Mehrdad Moradizadeh)
 * Show an inverse locked indicator when the page has been locked by the current user in reports and dashboard listings (Vaibhav Shukla, LB (Ben Johnston))
 * Add clarity to the development documentation that `admonition` should not be used and titles for `note` are not supported, including clean up of some existing incorrect usage (LB (Ben Johnston))
 * Unify the styling of delete/destructive button styles across the admin interface (Paarth Agarwal)
 * Adopt new designs and unify the styling styles for `.button-secondary` buttons across the admin interface (Paarth Agarwal)
 * Refine designs for disabled buttons throughout the admin interface (Paarth Agarwal)
 * Update expanding formset add buttons to use `button` not link for behaviour and remove support for disabled as a class (LB (Ben) Johnston)
 * Add robust unit testing for authentication scenarios across the user management admin pages (Mehrdad Moradizadeh)
 * Avoid assuming an integer PK named 'id' on multiple upload views (Matt Westcott)
 * Add a toggle to collapse/expand all page panels at once (Helen Chapman)
 * Improve the GitHub Workflows (CI) security (Alex (sashashura))
 * Use `search` type input in documentation search (LB (Ben) Johnston)
 * Render `help_text` when set on `FieldPanel`, `MultiFieldPanel`, `FieldRowPanel`, and other panel APIs where it previously worked without official support (Matt Westcott)
 * Consolidate usage of Excel libraries to a single library `openpyxl`, removing usage of `XlsxWriter`, `tablib`, `xlrd` and `xlwt` (Jaap Roes)
 * Adopt generic class based views for the create User create view, User edit view, user delete view and Users index listing / search results (Mehrdad Moradizadeh)
 * Add `button-secondary bicolor` variants to the pattern library and styleguide (Adinapunyo Banerjee)
 * Add better support for non-integer / non-`id` primary keys into Wagtail's generic views, including for custom Snippets and User models (Mehrdad Moradizadeh)
 * Upgrade jQuery UI to version 1.13.2 (LB (Ben) Johnston)
 * Update pattern library background & text examples (Albina Starykova)
 * Switch StreamField blocks to use a `<section>` element so screen reader users can bypass them more easily (Thibaud Colas)
 * Add anchor links to StreamField blocks so users can navigate straight to a given block (Thibaud Colas)
 * Support "Ctrl + f" in-page search within collapsed StreamField blocks (Thibaud Colas)
 * Remember the last opened side panel in the page editor, activating it on page load (Sage Abdullah)
 * Ensure that the [`update_index`](update_index) command can run without console output if called with `--verbosity 0` (Ben Sturmfels, Oliver Parker)
 * Improve side panels’ resizing in page editor and listings (Steven Steinwand)
 * Adjust breadcrumb text alignment and size in page listings & page editor (Steven Steinwand)
 * Improvements to getting started tutorial aimed at developers who are very new to Python and have no Django experience (Damilola Oladele)
 * The `image_url` template tag, when using the serve view to redirect rather than serve directly, will now use temporary redirects with a cache header instead of permanent redirects (Jake Howard)
 * Add new test assertions to `WagtailPageTestCase` - `assertPageIsRoutable`, `assertPageIsRenderable`, `assertPageIsEditable`, `assertPageIsPreviewable` (Andy Babic)
 * Add documentation to the performance section about how to better create image URLs when not used directly on the page (Jake Howard)
 * Add ability to provide a required `permission` to `PanelGroup`, used by `TabbedInterface`, `ObjectList`, `FieldRowPanel` and `MultiFieldPanel` (Oliver Parker)
 * Update documentation screenshots of the admin interface to align with changes in this release (Thibaud Colas)

### Bug fixes

 * Prevent `PageQuerySet.not_public` from returning all pages when no page restrictions exist (Mehrdad Moradizadeh)
 * Ensure that duplicate block ids are unique when duplicating stream blocks in the page editor (Joshua Munn)
 * Revise color usage so that privacy & locked indicators can be seen in Windows High Contrast mode (LB (Ben Johnston))
 * Ensure that disabled buttons have a consistent presentation on hover to indicate no interaction is available (Paarth Agarwal)
 * Update the 'Locked pages' report menu title so that it is consistent with other pages reports and its own title on viewing (Nicholas Johnson)
 * Support `formfield_callback` handling on `ModelForm.Meta` for future Django 4.2 release (Matt Westcott)
 * Ensure that `ModelAdmin` correctly supports filters in combination with subsequent searches without clearing the applied filters (Stefan Hammer)
 * Add missing translated values to site settings' headers plus models presented in listings and audit report filtering labels (Stefan Hammer)
 * Remove `capitalize()` calls to avoid issues with other languages or incorrectly presented model names for reporting and parts of site settings (Stefan Hammer)
 * Add back rendering of `help_text` for InlinePanel (Matt Westcott)
 * Ensure `for_user` argument is passed to the form class when previewing pages (Matt Westcott)
 * Ensure the capitalization of the `timesince_simple` tag is consistently added in the template based on usage in context (Stefan Hammer)
 * Add missing translation usage for the `timesince_last_update` and ensure the translated labels can be easier to work with in Transifex (Stefan Hammer)
 * Add additional checks for duplicate form field `clean_name` values in the Form Builder validation and increase performance of checks (Dan Bentley)
 * Use correct color for labels of radio and checkbox fields (Steven Steinwand)
 * Adjust spacing of fields’ error messages and position in tables (Steven Steinwand)
 * Update dead or redirected links throughout the documentation (LB (Ben) Johnston)
 * Use different icons for workflow timeline component, so the steps can be distinguished with other means than color (Sam Moran)
 * Use the correct custom font for the Wagtail userbar (Umar Farouk Yunusa)
 * StreamField blocks are now collapsible with the keyboard (Thibaud Colas)
 * StreamField block headings now have a label for screen reader users (Thibaud Colas)
 * Display the "*" required field indicator for StreamField blocks (Thibaud Colas)
 * Resolve inconsistency in action button positions in InlinePanel (Thibaud Colas)
 * Use h3 elements with a counter in InlinePanel so screen reader users can navigate by heading (Thibaud Colas)
 * Ensure that buttons on custom chooser widgets are correctly shown on hover (Thibaud Colas)
 * Add missing asterisk to title field placeholder (Seremba Patrick, Stefan Hammer)
 * Avoid creating an extra rich text block when inserting a new block at the end of the content (Matt Westcott)
 * Removed the extra dot in the Wagtail version shown within the admin settings menu item (Loveth Omokaro)
 * Fully remove the obsolete `wagtailsearch_editorspick` table that prevents flushing the database (Matt Westcott)
 * Update latest version message on Dashboard to accept dev build version format used on nlightly builds (Sam Moran)
 * Ensure `ChooserBlock.extract_references` uses the model class, not the model string (Alex Tomkins)
 * Regression in field width for authentication pages (log in / password reset) (Chisom Okeoma)
 * Ensure the new minimap correctly pluralizes error counts for `aria-label`s (Matt Westcott)

## Upgrade considerations

### `rebuild_references_index` management command

After upgrading, you will need to run `./manage.py rebuild_references_index` to populate the references table and ensure that usage counts for images, documents and snippets are displayed accurately. By default, references are tracked for all models in the project, including ones not managed through Wagtail - to disable this for specific models, see [](managing_the_reference_index).

### Recommend `WagtailPageTestCase` in place of `WagtailPageTests`

* `WagtailPageTestCase` is the base testing class and is now recommended over using `WagtailPageTests` [](testing_reference).
* `WagtailPageTests` will continue to work and does log in the user on test `setUp` but may be deprecated in the future.

```python
# class MyPageTests(WagtailPageTests): # old
class MyPageTests(WagtailPageTestCase): # new
    def setUp(self):
        # WagtailPageTestCase will not log in during setUp - so add if needed
        super().setUp()
        self.login()

    def test_can_create_a_page(self):
      # ...
```

### Button styling class changes

The `button-secondary` class is no longer compatible with either the `.serious` or `.no` classes, this partially worked previously but is no longer officially supported.

When adding custom buttons using the `ModelAdmin` `ButtonHelper` class, custom buttons will no longer include the `button-secondary` class by default in index listings.

If using the hook `register_user_listing_buttons` to register buttons along with the undocumented `UserListingButton` class, the `button-secondary` class will no longer be included by default.

Avoid using `disabled` as a class on `button` elements, instead use the [`disabled` attribute](https://developer.mozilla.org/en-US/docs/Web/HTML/Attributes/disabled) as support for this as a class may be removed in a future version of Wagtail and is not accessible.

If using custom `expanding-formset` the add button will no longer support the `disabled` class but instead must require the `disabled` attribute to be set.

The following button classes have been removed, none of which were being used within the admin but may have been used by custom code or packages:

* `button-neutral`
* `button-strokeonhover`
* `hover-no`
* `unbutton`
* `yes`

### Dropped support for importing `.xls` Spreadsheet files into Redirects

* `.xls` legacy Microsoft Excel 97-2003 spreadsheets will no longer be supported for importing into the contrib Redirects listing.
* `.xlsx`, `.csv`, `.tsv` formats are still supported.
