# Wagtail 5.0.2 release notes

_June 21, 2023_

```{contents}
---
local:
depth: 1
---
```

## What's new

### New features

 * Added [](title_field_panel) to support title / slug field synchronization (LB (Ben) Johnston)

### Bug fixes

 * Prevent JS error when reverting the spinner on a submit button after a validation error (LB (Ben) Johnston)
 * Prevent crash when comparing page revisions that include `MultipleChooserPanel` (Matt Westcott)
 * Ensure that title and slug continue syncing after entering non-URL-safe characters (LB (Ben) Johnston)
 * Ensure that title and slug are synced on keypress, not just on blur (LB (Ben) Johnston)
 * Add a more visible active state for side panel toggle buttons (Thibaud Colas)
 * Use custom dark theme colors for revision comparisons (Thibaud Colas)

## Upgrade considerations

### Use of `TitleFieldPanel` for the page title field

This release introduces a new [](title_field_panel) class, which is used by default for the page title field and provides the mechanism for synchronizing the slug field with the title. Before Wagtail 5.0, this happened automatically on any field named 'title'.

If you have used `FieldPanel("title")` directly in a panel definition (rather than extending `Page.content_panels` as standard), and wish to restore the previous behavior of auto-populating the slug, you will need to change this to `TitleFieldPanel("title")`. For example:

```python
from wagtail.admin.panels import FieldPanel, MultiFieldPanel

    # ...
    content_panels = [
        MultiFieldPanel([
            FieldPanel("title"),
            FieldPanel("subtitle"),
        ]),
    ]
```

should become:

```python
from wagtail.admin.panels import FieldPanel, MultiFieldPanel, TitleFieldPanel

    # ...
    content_panels = [
        MultiFieldPanel([
            TitleFieldPanel("title"),
            FieldPanel("subtitle"),
        ]),
    ]
```
