# Wagtail 5.1.2 release notes

_September 25, 2023_

```{contents}
---
local:
depth: 1
---
```

## What's new

### Bug fixes

 * Avoid use of `ignore_conflicts` when creating extra permissions for snippets, for SQL Server compatibility (Sage Abdullah)
 * Ensure sequence on `wagtailsearchpromotions_query` table is correctly set after migrating data (Jake Howard)
 * Change spreadsheet export headings to match listing view column headings (Christer Jensen, Sage Abdullah)
 * Fix numbers, booleans, and `None` from being exported as strings (Christer Jensen)
 * Restore fallback on full-word search for snippet choosers and generic index views (Matt Westcott)
 * Restore compatibility with pre-7.15 versions of the Elasticsearch Python library, allowing use of Opensearch (Matt Westcott)
 * Fix error when pickling BaseSiteSetting instances (Matt Westcott)
 * For Python 3.13 support - upgrade Willow to v1.6.2, replace `imghdr` with Willow's built-in MIME type detection (Jake Howard)

## Upgrade considerations

### Search within chooser interfaces requires `AutocompleteField` for full functionality

In Wagtail 4.2, the search bar within snippet chooser interfaces (and custom choosers created via `ChooserViewSet`) returned results for partial word matches - for example, a search for "wagt" would return results containing "Wagtail" - if this was supported by the search backend in use, and at least one `AutocompleteField` was present in the model's `search_fields` definition. Otherwise, it would fall back to only matching on complete words. In Wagtail 5.0, this fallback behavior was removed, and consequently a model with no `AutocompleteField`s in place would return no results.

As of Wagtail 5.1.2, the fallback behavior has been restored. Nevertheless, it is strongly recommended that you add `AutocompleteField` to your models' `search_fields` definitions, to ensure that users can receive search results continuously as they type. For example:

```python
from wagtail.search import index
# ... other imports

@register_snippet
class MySnippet(index.Indexed, models.Model):
     search_fields = [
         index.SearchField("name"),
         index.AutocompleteField("name"),
     ]
```
