# Wagtail 5.2.6 release notes

_July 11, 2024_

```{contents}
---
local:
depth: 1
---
```

## What's new

### CVE-2024-39317: Regular expression denial-of-service via search query parsing

This release addresses a denial-of-service vulnerability in Wagtail. A bug in Wagtail's [`parse_query_string`](wagtailsearch_query_string_parsing) would result in it taking a long time to process suitably crafted inputs. When used to parse sufficiently long strings of characters without a space, `parse_query_string` would take an unexpectedly large amount of time to process, resulting in a denial of service.

In an initial Wagtail installation, the vulnerability can be exploited by any Wagtail admin user. It cannot be exploited by end users. If your Wagtail site has a custom search implementation which uses parse_query_string, it may be exploitable by other users (e.g. unauthenticated users).

Many thanks to Jake Howard for reporting and fixing this issue. For further details, please see [the CVE-2024-39317 security advisory](https://github.com/wagtail/wagtail/security/advisories/GHSA-jmp3-39vp-fwg8).

### Bug fixes

 * Fix image preview when Willow optimizers are enabled (Alex Tomkins)


### Maintenance

 * Remove django-pattern-library upper bound in testing dependencies (Sage Abdullah)
