# Wagtail 6.3 (LTS) release notes

_November 1, 2024_

```{contents}
---
local:
depth: 1
---
```

Wagtail 6.3 is designated a Long Term Support (LTS) release. Long Term Support releases will continue to receive maintenance updates as necessary to address security and data-loss related issues, up until the next LTS release (typically a period of 12 months).

## What's new

### Python 3.13 support

This release adds formal support for Python 3.13.

### Django 5.1 support

This release adds formal support for Django 5.1.

### `ImageBlock` with alt text support

This release introduces a new block type [`ImageBlock`](streamfield_imageblock), which improves upon `ImageChooserBlock` by allowing editors to specify alt text tailored to the context in which the image is used. This is the new recommended block type for all images that are not purely decorative, and existing instances of `ImageChooserBlock` can be directly replaced with `ImageBlock` (with no data migration or template changes required) to benefit from contextual alt text. This feature was developed by Chiemezuo Akujobi as part of the Google Summer of Code program with mentoring support from Storm Heg, Saptak Sengupta, Thibaud Colas and Matt Westcott.

### Incremental dashboard enhancements

The Wagtail dashboard design evolves towards providing more information and navigation features. Mobile support is much improved. Upgrade banners are now dismissible.

This feature was developed by Albina Starykova and Sage Abdullah, based on designs by Ben Enright.

### Enhanced contrast admin theme

CMS users can now control the level of contrast of UI elements in the admin interface.
This new customization is designed for partially sighted users, complementing existing support for a dark theme and Windows Contrast Themes.
The new "More contrast" theming can be enabled in account preferences, or will otherwise be derived from operating system preferences.

This feature was designed thanks to feedback from our blind and partially sighted users, and was developed by Albina Starykova based on design input from Victoria Ottah.

### Universal design

This release follows through with "universal listings" user experience and design consistency improvements earlier in 2024, with the following features.

 * All create/edit admin forms now use a sticky submit button, for consistency and to speed up edits
 * Secondary form actions such as "Delete" are now in the header actions menu, for consistency and to make the actions more easily reachable for keyboard users
 * Documents and Images views now use universal listings styles
 * Page type usage, workflow usage, and workflow history views views also use universal listings styles
 * The forms pages listing now supports search and filtering

These features were developed by Sage Abdullah.

### HEIC / HEIF image upload support

The `WAGTAILIMAGES_EXTENSIONS` setting now accepts the `heic` extension, which allows users to upload and use HEIC / HEIF images in Wagtail. These images are automatically converted to JPEG format when rendered. For more details, see [](heic_heif_images).

This feature was developed by Matt Westcott.

### Custom preview sizes support

You can now customize the preview device sizes available in the live preview panel by overriding {attr}`~wagtail.models.PreviewableMixin.preview_sizes`. The default size can also be set by overriding {attr}`~wagtail.models.PreviewableMixin.default_preview_size`.

This feature was developed by Bart Cieliński, alexkiro, and Sage Abdullah.

### Other features

 * Formalize support for MariaDB (Sage Abdullah, Daniel Black)
 * Redirect to the last viewed listing page after deleting form submissions (Matthias Brück)
 * Provide `getTextLabel` method on date / time StreamField blocks (Vaughn Dickson)
 * Purge frontend cache when modifying redirects (Jake Howard)
 * Add search and filters to form pages listing (Sage Abdullah)
 * Deprecate the `WAGTAIL_AUTO_UPDATE_PREVIEW` setting, use `WAGTAIL_AUTO_UPDATE_PREVIEW_INTERVAL = 0` instead (Sage Abdullah)
 * Consistently use `capfirst` for title-casing model verbose names (Sébastien Corbin)
 * Fire `copy_for_translation_done` signal when copying translatable models as well as pages (Coen van der Kamp)
 * Add support for an image `description` field across all images, to better support accessible image descriptions (Chiemezuo Akujobi)
 * Prompt the user about unsaved changes when editing snippets (Sage Abdullah)
 * Add support for specifying different preview modes to the "View draft" URL for pages (Robin Varghese)
 * Implement new designs for the footer actions dropdown with more contrast and larger text (Sage Abdullah)
 * `StaticBlock` now renders nothing by default when no template is specified (Sævar Öfjörð Magnússon)
 * Allow setting page privacy rules when a restriction already exists on an ancestor page (Bojan Mihelac)
 * Automatically create links when pasting content that contain URLs into a rich text input (Thibaud Colas)
 * Add Uyghur language support

### Bug fixes

 * Prevent page type business rules from blocking reordering of pages (Andy Babic, Sage Abdullah)
 * Improve layout of object permissions table (Sage Abdullah)
 * Fix typo in aria-label attribute of page explorer navigation link (Sébastien Corbin)
 * Reinstate transparency indicator on image chooser widgets (Sébastien Corbin)
 * Remove table headers that have no text (Matt Westcott)
 * Fix broken link to user search (Shlomo Markowitz)
 * Ensure that JS slugify function strips Unicode characters disallowed by Django slug validation (Atif Khan)
 * Do not show notices about root / unroutable pages when searching or filtering in the page explorer (Matt Westcott)
 * Resolve contrast issue for page deletion warning (Sanjeev Holla S)
 * Make sure content metrics falls back to body element only when intended (Sage Abdullah)
 * Remove wrongly-added filters from redirects index (Matt Westcott)
 * Prevent popular tags filter from generating overly complex queries when not filtering (Matt Westcott)
 * Fix content path links in usage view to scroll to the correct element (Sage Abdullah)
 * Always show the minimap toggle button (Albina Starykova)
 * Ensure invalid submissions are marked as dirty edits on load to trigger UI and browser warnings for unsaved changes, restoring previous behavior from Wagtail 5.2 (Sage Abdullah)
 * Update polldaddy oEmbed provider to use the crowdsignal URL (Matthew Scouten)
 * Remove polleverywhere oEmbed provider as it this application longer supports oEmbed (Matthew Scouten)
 * Ensure that dropdown button toggles show with a border in high contrast mode (Ishwari8104, LB (Ben) Johnston)
 * Update email notification header to the new logo design (rahulsamant37)
 * Change `file_size` field on document model to avoid artificial 2Gb limit (Gabriel Getzie)
 * Ensure that `TypedTableBlock` uses the correct API representations of child blocks (Matt Westcott)
 * Footer action buttons now include their `media` definitions (Sage Abdullah)
 * Improve the text contrast of the bulk actions "Select all" button (Sage Abdullah)
 * Fix error on workflow settings view with multiple snippet types assigned to the same workflow on Postgres (Sage Abdullah)
 * Prevent history view from breaking if a log entry's revision is missing (Matt Westcott)
 * Prevent long filenames from breaking layout on document chooser listings (Frank Yiu, Shaurya Panchal)
 * Fix datetime fields overflowing its parent wrapper in listing filters (Rohit Singh)
 * Prevent multiple URLs from being combined into one when pasting links into a rich text input (Thibaud Colas)
 * Improve layout of report listing tables (Sage Abdullah)
 * Fix regression from creation of `AbstractGroupApprovalTask` to ensure `can_handle` checks for the abstract class correctly (Sumana Sree Angajala)

### Documentation

 * Upgrade Sphinx to 7.3 (Matt Westcott)
 * Upgrade sphinx-wagtail-theme to v6.4.0, with a new search integration and Read the Docs Addons bug fixes (Thibaud Colas)
 * Document how to [customize date/time format settings](wagtail_date_time_formats) (Vince Salvino)
 * Create a new documentation section for [deployment](deployment_guide) and move `fly.io` deployment from the tutorial to this section (Vince Salvino)
 * Clarify process for [UserViewSet customization](custom_userviewset) (Sage Abdullah)
 * Correct [`WAGTAIL_WORKFLOW_REQUIRE_REAPPROVAL_ON_EDIT`](workflow_settings) documentation to state that it defaults to `False` (Matt Westcott)
 * Add an example of customizing a default accessibility check in the [Authoring accessible content](authoring_accessible_content) section (Cynthia Kiser)
 * Demonstrate access protection with `TokenAuthentication` in the [Wagtail API v2 Configuration Guide](/advanced_topics/api/v2/configuration) (Krzysztof Jeziorny)
 * Replace X links with Mastodon in the README (Alex Morega)
 * Re-enable building offline formats in online documentation (Read the docs) for EPUB/PDF/HTML downloads (Joel William, Sage Abdullah)
 * Resolve multiple output errors in the documentation ePub format (Sage Abdullah)
 * Update social media examples to use LinkedIn, Reddit, Facebook (Ayaan Qadri)

### Maintenance

 * Removed support for Python 3.8 (Matt Westcott)
 * Drop `pytz` dependency in favour of `zoneinfo.available_timezones` (Sage Abdullah)
 * Relax `django-taggit` dependency to allow 6.0 (Matt Westcott)
 * Improve page listing performance (Sage Abdullah)
 * Phase out usage of `SECRET_KEY` in version and icon hashes (Jake Howard)
 * Audit all use of localized and non-localized numbers in templates (Matt Westcott)
 * Refactor StreamField `get_prep_value` for closer alignment with JSONField (Sage Abdullah)
 * Move search implementation logic from generic `IndexView` to `BaseListingView` (Sage Abdullah)
 * Upgrade Puppeteer integration tests for reliability (Matt Westcott)
 * Restore ability to use `.in_bulk()` on specific querysets under Django 5.2a0 (Sage Abdullah)
 * Add generated `test-media` to .gitignore (Shlomo Markowitz)
 * Improve `debounce` util's return type for better TypeScript usage (Sage Abdullah)
 * Ensure the side panel's show event is dispatched after any hide events (Sage Abdullah)
 * Migrate preview-panel JavaScript to Stimulus & TypeScript, add full unit testing (Sage Abdullah)
 * Move `wagtailConfig` values from inline scripts to the `wagtail_config` template tag (LB (Ben) Johnston, Sage Abdullah)
 * Deprecate the `{% locales %}` and `{% js_translation_strings %}` template tags (LB (Ben) Johnston, Sage Abdullah)
 * Adopt the modern best practice for `beforeunload` usage in `UnsavedController` to trigger a leave page warning when edits have been made (Shubham Mukati, Sage Abdullah)
 * Ensure multi-line comments are cleaned from custom icons in addition to just single line comments (Jake Howard)
 * Deprecate `window.wagtailConfig.BULK_ACTION_ITEM_TYPE` usage in JavaScript to reduce reliance on inline scripts (LB (Ben) Johnston)
 * Remove `window.fileupload_opts` usage in JavaScript, use data attributes on fields instead to reduce reliance on inline scripts (LB (Ben) Johnston)
 * Remove `image_format_name_to_content_type` helper function that duplicates Willow functionality (Matt Westcott)
 * Improve code reuse for footer actions markup across generic views (Sage Abdullah)
 * Deprecate internal `DeleteMenuItem` API for footer actions (Sage Abdullah)
 * Update Pillow dependency to allow 11.x (Storm Heg)

## Upgrade considerations - deprecation of old functionality

### Removed support for Python 3.8

Python 3.8 is no longer supported as of this release; please upgrade to Python 3.9 or above before upgrading Wagtail.

### Deprecation of the `WAGTAIL_AUTO_UPDATE_PREVIEW` setting

The `WAGTAIL_AUTO_UPDATE_PREVIEW` setting has been deprecated and will be removed in a future release.

To disable the automatic preview update feature, set [`WAGTAIL_AUTO_UPDATE_PREVIEW_INTERVAL = 0`](wagtail_auto_update_preview_interval) in your Django settings instead.

## Upgrade considerations - changes to undocumented internals

### Deprecation of `window.wagtailConfig.BULK_ACTION_ITEM_TYPE`

As part of migrating away from inline scripts, the undocumented use of `window.wagtailConfig.BULK_ACTION_ITEM_TYPE` as a global has been deprecated and will be removed in a future release.

**Old**

```html+django
{% block extra_js %}
    {{ block.super }}
    <script>
        window.wagtailConfig.BULK_ACTION_ITEM_TYPE = 'SOME_ITEM';
    </script>
{% endblock %}
```

**New**

Update usage of the `wagtailadmin/bulk_actions/footer.html` template include to declare the `item_type`.

```html+django
{% block bulk_actions %}
    {% include 'wagtailadmin/bulk_actions/footer.html' ... item_type="SOME_ITEM" %}
{% endblock %}
```

```{note}
Custom item types for bulk actions are not officially supported yet and this approach is likely to get further changes in the future.
```

### Deprecation of the `{% locales %}` template tag

The undocumented `locales` template tag will be removed in a future release.

If access to JSON locales within JavaScript is needed, use `window.wagtailConfig.LOCALES` instead.

### Deprecation of the `{% js_translation_strings %}` template tag

The undocumented `js_translation_strings` template tag will be removed in a future release.

If access to JSON translation strings within JavaScript is needed, use `window.wagtailConfig.STRINGS` instead.

### `UpgradeNotificationPanel` is no longer removable with `construct_homepage_panels` hook

The upgrade notification panel can still be removed with the [`WAGTAIL_ENABLE_UPDATE_CHECK = False`](update_notifications) setting.

### `SiteSummaryPanel` is no longer removable with `construct_homepage_panels` hook

The summary items can still be removed with the [`construct_homepage_summary_items`](construct_homepage_summary_items) hook.

### Deprecation of `DeleteMenuItem`

The undocumented `DeleteMenuItem` API will be removed in a future release.

The delete option is now provided via `EditView.get_header_more_buttons()`, though this is still an internal-only API.
