# Wagtail 7.1.2 release notes

_October 23, 2025_

```{contents}
---
local:
depth: 1
---
```

## What's new

### Bug fixes

 * Allow `label_format` to be set to an empty string to hide the block summary label (Sage Abdullah)
 * Better support userbar loading on multi-site through site hosts (Sage Abdullah)
 * Prevent error on custom generic create and edit views without a header icon (Sage Abdullah)
 * Use the correct origin when computing content metrics via cross-origin communications (Sage Abdullah)

### Documentation

 * Link to django-treebeard's `Node.move()` in `Page.move()` documentation (Baptiste Mispelon)

## Upgrade considerations - changes affecting all projects

### Changes to `label_format` behavior in `StructBlock`

In Wagtail 7.1, the `label_format` option for `StructBlock` has been changed to always show the block's original `label` when the block is collapsed, with the `label_format` string shown after it as a summary instead of replacing the `label`. This means that if you had previously set `label_format` to include (or be the same as) the `label`, you would likely want to remove the original `label`'s text from the `label_format` string.

If you wish to hide the summary label entirely (similar to setting `label_format = label` in Wagtail < 7.1), you can set `label_format` to the empty string `""`. This was not possible in Wagtail 7.1, but is now supported as of this release.
