# Wagtail 7.2.1 release notes

_November 26, 2025_

```{contents}
---
local:
depth: 1
---
```

## What's new

### Bug fixes

 * Allow userbar in page previews to render without needing to configure site record (Sage Abdullah)
 * Disable usage count ordering when searching on documents and images listing views, to prevent unsupported search query (Sage Abdullah)
 * Do not replace existing document or image title when uploading a new file (Sage Abdullah)
 * Use a more efficient query for fetching usage counts on image and document listings when not ordering by usage count (Sage Abdullah)
 * Add composite indexes to improve reference index performance (Sage Abdullah)

### Maintenance

* Remove use of `_WAGTAILSEARCH_FORCE_AUTO_UPDATE` in search tests (Matt Westcott)

## Upgrade considerations

### Addition of composite indexes to `ReferenceIndex` table

This release includes a migration to add composite indexes to the `wagtailcore_referenceindex` table on the fields `base_content_type` and `object_id`, and on `to_content_type` and `to_object_id`. If you have already created these indexes manually on your database, you should skip this migration by passing the option `--fake` to the `migrate` management command.

Running this migration may hang if there are existing long-running queries in progress on the table. If so, you are advised to stop and restart the database service before rerunning the migration.
