# Verba Contribution Guidelines

Welcome to the Verba community! We're thrilled that you're interested in contributing to the Verba project. Verba is a collaborative open-source project, and we believe that everyone has something unique to contribute. Below you'll find our guidelines which aim to make contributing to Verba a respectful and pleasant experience for everyone.

## 🌟 Community and Open Source

Open source is at the heart of Verba. We appreciate feedback, ideas, and enhancements from the community. Whether you're looking to fix a bug, add a new feature, or simply improve the documentation, your contribution is important to us.

## 📚 Before You Begin

Before contributing, please take a moment to read through the [README](https://github.com/weaviate/Verba/README.md) and the [Technical Documentation](https://github.com/weaviate/Verba/TECHNICAL.md). These documents provide a comprehensive understanding of the project and are essential reading to ensure that we're all on the same page. Please note that the technical documentation is a work in progress and will be updated as we progress.

## 🐛 Reporting Issues

If you've identified a bug or have an idea for an enhancement, please begin by creating an Issue. Here's how:

- Check the Issue tracker to ensure the bug or enhancement hasn't already been reported.
- Clearly describe the issue including steps to reproduce when it is a bug.
- Include as much relevant information as possible.

## 💡 Ideas and Feedback

We welcome all ideas and feedback. If you're not ready to open an Issue or if you're just looking for a place to discuss ideas, head over to our [GitHub Discussions](https://github.com/weaviate/Verba/discussions) or the [Weaviate Support Page](https://forum.weaviate.io/).

## 🧪 Testing

We use [pytest](https://docs.pytest.org) for testing. Please note that the tests are WIP and some are missing. We still encourage you to run the tests and add more tests as you see fit.

To run the tests, use the following command:

```bash
pytest goldenverba/tests
```

## 📝 Pull Requests

If you're ready to contribute code or documentation, please submit a Pull Request (PR) to the dev branch. Here's the process:

- Fork the repository and create your branch from `main`.
- Ensure that your code adheres to the existing code style. Use [Black](https://github.com/psf/black) for formatting Python code.
- If you're adding a new feature, consider writing unit tests and documenting the feature.
- Verify that your changes pass existing unit tests
- Make sure your code lints (mypy compatibility is optional but encouraged).
- Include a clear description of your changes in the PR.
- Link to the Issue in your PR description.

### 🔄 Pull Request Process

- PRs are reviewed on a regular basis.
- Engage in the conversation and make requested updates to your PR if needed.
- Once approved, your PR will be merged into the main branch by a maintainer.

## 🗨️ Stay Connected

We encourage you to join our community channels. Stay connected, share ideas, and get to know fellow contributors.

Thank you for being a part of Verba. Your contributions not only help improve the project but also the wider community of users and developers.

Happy contributing!
