//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by mockery v2.53.5. DO NOT EDIT.

package db_users

import (
	authentication "github.com/weaviate/weaviate/usecases/auth/authentication"
	apikey "github.com/weaviate/weaviate/usecases/auth/authentication/apikey"

	authorization "github.com/weaviate/weaviate/usecases/auth/authorization"

	mock "github.com/stretchr/testify/mock"

	time "time"
)

// MockDbUserAndRolesGetter is an autogenerated mock type for the DbUserAndRolesGetter type
type MockDbUserAndRolesGetter struct {
	mock.Mock
}

type MockDbUserAndRolesGetter_Expecter struct {
	mock *mock.Mock
}

func (_m *MockDbUserAndRolesGetter) EXPECT() *MockDbUserAndRolesGetter_Expecter {
	return &MockDbUserAndRolesGetter_Expecter{mock: &_m.Mock}
}

// ActivateUser provides a mock function with given fields: userId
func (_m *MockDbUserAndRolesGetter) ActivateUser(userId string) error {
	ret := _m.Called(userId)

	if len(ret) == 0 {
		panic("no return value specified for ActivateUser")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(string) error); ok {
		r0 = rf(userId)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// MockDbUserAndRolesGetter_ActivateUser_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ActivateUser'
type MockDbUserAndRolesGetter_ActivateUser_Call struct {
	*mock.Call
}

// ActivateUser is a helper method to define mock.On call
//   - userId string
func (_e *MockDbUserAndRolesGetter_Expecter) ActivateUser(userId interface{}) *MockDbUserAndRolesGetter_ActivateUser_Call {
	return &MockDbUserAndRolesGetter_ActivateUser_Call{Call: _e.mock.On("ActivateUser", userId)}
}

func (_c *MockDbUserAndRolesGetter_ActivateUser_Call) Run(run func(userId string)) *MockDbUserAndRolesGetter_ActivateUser_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(string))
	})
	return _c
}

func (_c *MockDbUserAndRolesGetter_ActivateUser_Call) Return(_a0 error) *MockDbUserAndRolesGetter_ActivateUser_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockDbUserAndRolesGetter_ActivateUser_Call) RunAndReturn(run func(string) error) *MockDbUserAndRolesGetter_ActivateUser_Call {
	_c.Call.Return(run)
	return _c
}

// CheckUserIdentifierExists provides a mock function with given fields: userIdentifier
func (_m *MockDbUserAndRolesGetter) CheckUserIdentifierExists(userIdentifier string) (bool, error) {
	ret := _m.Called(userIdentifier)

	if len(ret) == 0 {
		panic("no return value specified for CheckUserIdentifierExists")
	}

	var r0 bool
	var r1 error
	if rf, ok := ret.Get(0).(func(string) (bool, error)); ok {
		return rf(userIdentifier)
	}
	if rf, ok := ret.Get(0).(func(string) bool); ok {
		r0 = rf(userIdentifier)
	} else {
		r0 = ret.Get(0).(bool)
	}

	if rf, ok := ret.Get(1).(func(string) error); ok {
		r1 = rf(userIdentifier)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// MockDbUserAndRolesGetter_CheckUserIdentifierExists_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'CheckUserIdentifierExists'
type MockDbUserAndRolesGetter_CheckUserIdentifierExists_Call struct {
	*mock.Call
}

// CheckUserIdentifierExists is a helper method to define mock.On call
//   - userIdentifier string
func (_e *MockDbUserAndRolesGetter_Expecter) CheckUserIdentifierExists(userIdentifier interface{}) *MockDbUserAndRolesGetter_CheckUserIdentifierExists_Call {
	return &MockDbUserAndRolesGetter_CheckUserIdentifierExists_Call{Call: _e.mock.On("CheckUserIdentifierExists", userIdentifier)}
}

func (_c *MockDbUserAndRolesGetter_CheckUserIdentifierExists_Call) Run(run func(userIdentifier string)) *MockDbUserAndRolesGetter_CheckUserIdentifierExists_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(string))
	})
	return _c
}

func (_c *MockDbUserAndRolesGetter_CheckUserIdentifierExists_Call) Return(_a0 bool, _a1 error) *MockDbUserAndRolesGetter_CheckUserIdentifierExists_Call {
	_c.Call.Return(_a0, _a1)
	return _c
}

func (_c *MockDbUserAndRolesGetter_CheckUserIdentifierExists_Call) RunAndReturn(run func(string) (bool, error)) *MockDbUserAndRolesGetter_CheckUserIdentifierExists_Call {
	_c.Call.Return(run)
	return _c
}

// CreateUser provides a mock function with given fields: userId, secureHash, userIdentifier, apiKeyFirstLetters, createdAt
func (_m *MockDbUserAndRolesGetter) CreateUser(userId string, secureHash string, userIdentifier string, apiKeyFirstLetters string, createdAt time.Time) error {
	ret := _m.Called(userId, secureHash, userIdentifier, apiKeyFirstLetters, createdAt)

	if len(ret) == 0 {
		panic("no return value specified for CreateUser")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(string, string, string, string, time.Time) error); ok {
		r0 = rf(userId, secureHash, userIdentifier, apiKeyFirstLetters, createdAt)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// MockDbUserAndRolesGetter_CreateUser_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'CreateUser'
type MockDbUserAndRolesGetter_CreateUser_Call struct {
	*mock.Call
}

// CreateUser is a helper method to define mock.On call
//   - userId string
//   - secureHash string
//   - userIdentifier string
//   - apiKeyFirstLetters string
//   - createdAt time.Time
func (_e *MockDbUserAndRolesGetter_Expecter) CreateUser(userId interface{}, secureHash interface{}, userIdentifier interface{}, apiKeyFirstLetters interface{}, createdAt interface{}) *MockDbUserAndRolesGetter_CreateUser_Call {
	return &MockDbUserAndRolesGetter_CreateUser_Call{Call: _e.mock.On("CreateUser", userId, secureHash, userIdentifier, apiKeyFirstLetters, createdAt)}
}

func (_c *MockDbUserAndRolesGetter_CreateUser_Call) Run(run func(userId string, secureHash string, userIdentifier string, apiKeyFirstLetters string, createdAt time.Time)) *MockDbUserAndRolesGetter_CreateUser_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(string), args[1].(string), args[2].(string), args[3].(string), args[4].(time.Time))
	})
	return _c
}

func (_c *MockDbUserAndRolesGetter_CreateUser_Call) Return(_a0 error) *MockDbUserAndRolesGetter_CreateUser_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockDbUserAndRolesGetter_CreateUser_Call) RunAndReturn(run func(string, string, string, string, time.Time) error) *MockDbUserAndRolesGetter_CreateUser_Call {
	_c.Call.Return(run)
	return _c
}

// CreateUserWithKey provides a mock function with given fields: userId, apiKeyFirstLetters, weakHash, createdAt
func (_m *MockDbUserAndRolesGetter) CreateUserWithKey(userId string, apiKeyFirstLetters string, weakHash [32]byte, createdAt time.Time) error {
	ret := _m.Called(userId, apiKeyFirstLetters, weakHash, createdAt)

	if len(ret) == 0 {
		panic("no return value specified for CreateUserWithKey")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(string, string, [32]byte, time.Time) error); ok {
		r0 = rf(userId, apiKeyFirstLetters, weakHash, createdAt)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// MockDbUserAndRolesGetter_CreateUserWithKey_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'CreateUserWithKey'
type MockDbUserAndRolesGetter_CreateUserWithKey_Call struct {
	*mock.Call
}

// CreateUserWithKey is a helper method to define mock.On call
//   - userId string
//   - apiKeyFirstLetters string
//   - weakHash [32]byte
//   - createdAt time.Time
func (_e *MockDbUserAndRolesGetter_Expecter) CreateUserWithKey(userId interface{}, apiKeyFirstLetters interface{}, weakHash interface{}, createdAt interface{}) *MockDbUserAndRolesGetter_CreateUserWithKey_Call {
	return &MockDbUserAndRolesGetter_CreateUserWithKey_Call{Call: _e.mock.On("CreateUserWithKey", userId, apiKeyFirstLetters, weakHash, createdAt)}
}

func (_c *MockDbUserAndRolesGetter_CreateUserWithKey_Call) Run(run func(userId string, apiKeyFirstLetters string, weakHash [32]byte, createdAt time.Time)) *MockDbUserAndRolesGetter_CreateUserWithKey_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(string), args[1].(string), args[2].([32]byte), args[3].(time.Time))
	})
	return _c
}

func (_c *MockDbUserAndRolesGetter_CreateUserWithKey_Call) Return(_a0 error) *MockDbUserAndRolesGetter_CreateUserWithKey_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockDbUserAndRolesGetter_CreateUserWithKey_Call) RunAndReturn(run func(string, string, [32]byte, time.Time) error) *MockDbUserAndRolesGetter_CreateUserWithKey_Call {
	_c.Call.Return(run)
	return _c
}

// DeactivateUser provides a mock function with given fields: userId, revokeKey
func (_m *MockDbUserAndRolesGetter) DeactivateUser(userId string, revokeKey bool) error {
	ret := _m.Called(userId, revokeKey)

	if len(ret) == 0 {
		panic("no return value specified for DeactivateUser")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(string, bool) error); ok {
		r0 = rf(userId, revokeKey)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// MockDbUserAndRolesGetter_DeactivateUser_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'DeactivateUser'
type MockDbUserAndRolesGetter_DeactivateUser_Call struct {
	*mock.Call
}

// DeactivateUser is a helper method to define mock.On call
//   - userId string
//   - revokeKey bool
func (_e *MockDbUserAndRolesGetter_Expecter) DeactivateUser(userId interface{}, revokeKey interface{}) *MockDbUserAndRolesGetter_DeactivateUser_Call {
	return &MockDbUserAndRolesGetter_DeactivateUser_Call{Call: _e.mock.On("DeactivateUser", userId, revokeKey)}
}

func (_c *MockDbUserAndRolesGetter_DeactivateUser_Call) Run(run func(userId string, revokeKey bool)) *MockDbUserAndRolesGetter_DeactivateUser_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(string), args[1].(bool))
	})
	return _c
}

func (_c *MockDbUserAndRolesGetter_DeactivateUser_Call) Return(_a0 error) *MockDbUserAndRolesGetter_DeactivateUser_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockDbUserAndRolesGetter_DeactivateUser_Call) RunAndReturn(run func(string, bool) error) *MockDbUserAndRolesGetter_DeactivateUser_Call {
	_c.Call.Return(run)
	return _c
}

// DeleteUser provides a mock function with given fields: userId
func (_m *MockDbUserAndRolesGetter) DeleteUser(userId string) error {
	ret := _m.Called(userId)

	if len(ret) == 0 {
		panic("no return value specified for DeleteUser")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(string) error); ok {
		r0 = rf(userId)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// MockDbUserAndRolesGetter_DeleteUser_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'DeleteUser'
type MockDbUserAndRolesGetter_DeleteUser_Call struct {
	*mock.Call
}

// DeleteUser is a helper method to define mock.On call
//   - userId string
func (_e *MockDbUserAndRolesGetter_Expecter) DeleteUser(userId interface{}) *MockDbUserAndRolesGetter_DeleteUser_Call {
	return &MockDbUserAndRolesGetter_DeleteUser_Call{Call: _e.mock.On("DeleteUser", userId)}
}

func (_c *MockDbUserAndRolesGetter_DeleteUser_Call) Run(run func(userId string)) *MockDbUserAndRolesGetter_DeleteUser_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(string))
	})
	return _c
}

func (_c *MockDbUserAndRolesGetter_DeleteUser_Call) Return(_a0 error) *MockDbUserAndRolesGetter_DeleteUser_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockDbUserAndRolesGetter_DeleteUser_Call) RunAndReturn(run func(string) error) *MockDbUserAndRolesGetter_DeleteUser_Call {
	_c.Call.Return(run)
	return _c
}

// GetRolesForUserOrGroup provides a mock function with given fields: user, authTyoes, isGroup
func (_m *MockDbUserAndRolesGetter) GetRolesForUserOrGroup(user string, authTyoes authentication.AuthType, isGroup bool) (map[string][]authorization.Policy, error) {
	ret := _m.Called(user, authTyoes, isGroup)

	if len(ret) == 0 {
		panic("no return value specified for GetRolesForUserOrGroup")
	}

	var r0 map[string][]authorization.Policy
	var r1 error
	if rf, ok := ret.Get(0).(func(string, authentication.AuthType, bool) (map[string][]authorization.Policy, error)); ok {
		return rf(user, authTyoes, isGroup)
	}
	if rf, ok := ret.Get(0).(func(string, authentication.AuthType, bool) map[string][]authorization.Policy); ok {
		r0 = rf(user, authTyoes, isGroup)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(map[string][]authorization.Policy)
		}
	}

	if rf, ok := ret.Get(1).(func(string, authentication.AuthType, bool) error); ok {
		r1 = rf(user, authTyoes, isGroup)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// MockDbUserAndRolesGetter_GetRolesForUserOrGroup_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetRolesForUserOrGroup'
type MockDbUserAndRolesGetter_GetRolesForUserOrGroup_Call struct {
	*mock.Call
}

// GetRolesForUserOrGroup is a helper method to define mock.On call
//   - user string
//   - authTyoes authentication.AuthType
//   - isGroup bool
func (_e *MockDbUserAndRolesGetter_Expecter) GetRolesForUserOrGroup(user interface{}, authTyoes interface{}, isGroup interface{}) *MockDbUserAndRolesGetter_GetRolesForUserOrGroup_Call {
	return &MockDbUserAndRolesGetter_GetRolesForUserOrGroup_Call{Call: _e.mock.On("GetRolesForUserOrGroup", user, authTyoes, isGroup)}
}

func (_c *MockDbUserAndRolesGetter_GetRolesForUserOrGroup_Call) Run(run func(user string, authTyoes authentication.AuthType, isGroup bool)) *MockDbUserAndRolesGetter_GetRolesForUserOrGroup_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(string), args[1].(authentication.AuthType), args[2].(bool))
	})
	return _c
}

func (_c *MockDbUserAndRolesGetter_GetRolesForUserOrGroup_Call) Return(_a0 map[string][]authorization.Policy, _a1 error) *MockDbUserAndRolesGetter_GetRolesForUserOrGroup_Call {
	_c.Call.Return(_a0, _a1)
	return _c
}

func (_c *MockDbUserAndRolesGetter_GetRolesForUserOrGroup_Call) RunAndReturn(run func(string, authentication.AuthType, bool) (map[string][]authorization.Policy, error)) *MockDbUserAndRolesGetter_GetRolesForUserOrGroup_Call {
	_c.Call.Return(run)
	return _c
}

// GetUsers provides a mock function with given fields: userIds
func (_m *MockDbUserAndRolesGetter) GetUsers(userIds ...string) (map[string]*apikey.User, error) {
	_va := make([]interface{}, len(userIds))
	for _i := range userIds {
		_va[_i] = userIds[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	if len(ret) == 0 {
		panic("no return value specified for GetUsers")
	}

	var r0 map[string]*apikey.User
	var r1 error
	if rf, ok := ret.Get(0).(func(...string) (map[string]*apikey.User, error)); ok {
		return rf(userIds...)
	}
	if rf, ok := ret.Get(0).(func(...string) map[string]*apikey.User); ok {
		r0 = rf(userIds...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(map[string]*apikey.User)
		}
	}

	if rf, ok := ret.Get(1).(func(...string) error); ok {
		r1 = rf(userIds...)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// MockDbUserAndRolesGetter_GetUsers_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetUsers'
type MockDbUserAndRolesGetter_GetUsers_Call struct {
	*mock.Call
}

// GetUsers is a helper method to define mock.On call
//   - userIds ...string
func (_e *MockDbUserAndRolesGetter_Expecter) GetUsers(userIds ...interface{}) *MockDbUserAndRolesGetter_GetUsers_Call {
	return &MockDbUserAndRolesGetter_GetUsers_Call{Call: _e.mock.On("GetUsers",
		append([]interface{}{}, userIds...)...)}
}

func (_c *MockDbUserAndRolesGetter_GetUsers_Call) Run(run func(userIds ...string)) *MockDbUserAndRolesGetter_GetUsers_Call {
	_c.Call.Run(func(args mock.Arguments) {
		variadicArgs := make([]string, len(args)-0)
		for i, a := range args[0:] {
			if a != nil {
				variadicArgs[i] = a.(string)
			}
		}
		run(variadicArgs...)
	})
	return _c
}

func (_c *MockDbUserAndRolesGetter_GetUsers_Call) Return(_a0 map[string]*apikey.User, _a1 error) *MockDbUserAndRolesGetter_GetUsers_Call {
	_c.Call.Return(_a0, _a1)
	return _c
}

func (_c *MockDbUserAndRolesGetter_GetUsers_Call) RunAndReturn(run func(...string) (map[string]*apikey.User, error)) *MockDbUserAndRolesGetter_GetUsers_Call {
	_c.Call.Return(run)
	return _c
}

// RevokeRolesForUser provides a mock function with given fields: userName, roles
func (_m *MockDbUserAndRolesGetter) RevokeRolesForUser(userName string, roles ...string) error {
	_va := make([]interface{}, len(roles))
	for _i := range roles {
		_va[_i] = roles[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, userName)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	if len(ret) == 0 {
		panic("no return value specified for RevokeRolesForUser")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(string, ...string) error); ok {
		r0 = rf(userName, roles...)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// MockDbUserAndRolesGetter_RevokeRolesForUser_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'RevokeRolesForUser'
type MockDbUserAndRolesGetter_RevokeRolesForUser_Call struct {
	*mock.Call
}

// RevokeRolesForUser is a helper method to define mock.On call
//   - userName string
//   - roles ...string
func (_e *MockDbUserAndRolesGetter_Expecter) RevokeRolesForUser(userName interface{}, roles ...interface{}) *MockDbUserAndRolesGetter_RevokeRolesForUser_Call {
	return &MockDbUserAndRolesGetter_RevokeRolesForUser_Call{Call: _e.mock.On("RevokeRolesForUser",
		append([]interface{}{userName}, roles...)...)}
}

func (_c *MockDbUserAndRolesGetter_RevokeRolesForUser_Call) Run(run func(userName string, roles ...string)) *MockDbUserAndRolesGetter_RevokeRolesForUser_Call {
	_c.Call.Run(func(args mock.Arguments) {
		variadicArgs := make([]string, len(args)-1)
		for i, a := range args[1:] {
			if a != nil {
				variadicArgs[i] = a.(string)
			}
		}
		run(args[0].(string), variadicArgs...)
	})
	return _c
}

func (_c *MockDbUserAndRolesGetter_RevokeRolesForUser_Call) Return(_a0 error) *MockDbUserAndRolesGetter_RevokeRolesForUser_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockDbUserAndRolesGetter_RevokeRolesForUser_Call) RunAndReturn(run func(string, ...string) error) *MockDbUserAndRolesGetter_RevokeRolesForUser_Call {
	_c.Call.Return(run)
	return _c
}

// RotateKey provides a mock function with given fields: userId, apiKeyFirstLetters, secureHash, oldIdentifier, newIdentifier
func (_m *MockDbUserAndRolesGetter) RotateKey(userId string, apiKeyFirstLetters string, secureHash string, oldIdentifier string, newIdentifier string) error {
	ret := _m.Called(userId, apiKeyFirstLetters, secureHash, oldIdentifier, newIdentifier)

	if len(ret) == 0 {
		panic("no return value specified for RotateKey")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(string, string, string, string, string) error); ok {
		r0 = rf(userId, apiKeyFirstLetters, secureHash, oldIdentifier, newIdentifier)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// MockDbUserAndRolesGetter_RotateKey_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'RotateKey'
type MockDbUserAndRolesGetter_RotateKey_Call struct {
	*mock.Call
}

// RotateKey is a helper method to define mock.On call
//   - userId string
//   - apiKeyFirstLetters string
//   - secureHash string
//   - oldIdentifier string
//   - newIdentifier string
func (_e *MockDbUserAndRolesGetter_Expecter) RotateKey(userId interface{}, apiKeyFirstLetters interface{}, secureHash interface{}, oldIdentifier interface{}, newIdentifier interface{}) *MockDbUserAndRolesGetter_RotateKey_Call {
	return &MockDbUserAndRolesGetter_RotateKey_Call{Call: _e.mock.On("RotateKey", userId, apiKeyFirstLetters, secureHash, oldIdentifier, newIdentifier)}
}

func (_c *MockDbUserAndRolesGetter_RotateKey_Call) Run(run func(userId string, apiKeyFirstLetters string, secureHash string, oldIdentifier string, newIdentifier string)) *MockDbUserAndRolesGetter_RotateKey_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(string), args[1].(string), args[2].(string), args[3].(string), args[4].(string))
	})
	return _c
}

func (_c *MockDbUserAndRolesGetter_RotateKey_Call) Return(_a0 error) *MockDbUserAndRolesGetter_RotateKey_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockDbUserAndRolesGetter_RotateKey_Call) RunAndReturn(run func(string, string, string, string, string) error) *MockDbUserAndRolesGetter_RotateKey_Call {
	_c.Call.Return(run)
	return _c
}

// NewMockDbUserAndRolesGetter creates a new instance of MockDbUserAndRolesGetter. It also registers a testing interface on the mock and a cleanup function to assert the mocks expectations.
// The first argument is typically a *testing.T value.
func NewMockDbUserAndRolesGetter(t interface {
	mock.TestingT
	Cleanup(func())
}) *MockDbUserAndRolesGetter {
	mock := &MockDbUserAndRolesGetter{}
	mock.Mock.Test(t)

	t.Cleanup(func() { mock.AssertExpectations(t) })

	return mock
}
