//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package rest

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
)

var (
	// SwaggerJSON embedded version of the swagger document used at generation time
	SwaggerJSON json.RawMessage
	// FlatSwaggerJSON embedded flattened version of the swagger document used at generation time
	FlatSwaggerJSON json.RawMessage
)

func init() {
	SwaggerJSON = json.RawMessage([]byte(`{
  "consumes": [
    "application/yaml",
    "application/json"
  ],
  "produces": [
    "application/json"
  ],
  "schemes": [
    "https"
  ],
  "swagger": "2.0",
  "info": {
    "description": "# Introduction\u003cbr/\u003e Weaviate is an open source, AI-native vector database that helps developers create intuitive and reliable AI-powered applications. \u003cbr/\u003e ### Base Path \u003cbr/\u003eThe base path for the Weaviate server is structured as ` + "`" + `[YOUR-WEAVIATE-HOST]:[PORT]/v1` + "`" + `. As an example, if you wish to access the ` + "`" + `schema` + "`" + ` endpoint on a local instance, you would navigate to ` + "`" + `http://localhost:8080/v1/schema` + "`" + `. Ensure you replace ` + "`" + `[YOUR-WEAVIATE-HOST]` + "`" + ` and ` + "`" + `[PORT]` + "`" + ` with your actual server host and port number respectively. \u003cbr/\u003e ### Questions? \u003cbr/\u003eIf you have any comments or questions, please feel free to reach out to us at the community forum [https://forum.weaviate.io/](https://forum.weaviate.io/). \u003cbr/\u003e### Issues? \u003cbr/\u003eIf you find a bug or want to file a feature request, please open an issue on our GitHub repository for [Weaviate](https://github.com/weaviate/weaviate). \u003cbr/\u003e### Need more documentation? \u003cbr/\u003eFor a quickstart, code examples, concepts and more, please visit our [documentation page](https://docs.weaviate.io/weaviate).",
    "title": "Weaviate REST API",
    "contact": {
      "name": "Weaviate",
      "url": "https://github.com/weaviate",
      "email": "hello@weaviate.io"
    },
    "version": "1.36.0-dev"
  },
  "basePath": "/v1",
  "paths": {
    "/": {
      "get": {
        "description": "Get links to other endpoints to help discover the REST API.",
        "summary": "List available endpoints",
        "operationId": "weaviate.root",
        "responses": {
          "200": {
            "description": "Weaviate is alive and ready.",
            "schema": {
              "type": "object",
              "properties": {
                "links": {
                  "type": "array",
                  "items": {
                    "$ref": "#/definitions/Link"
                  }
                }
              }
            }
          }
        }
      }
    },
    "/.well-known/live": {
      "get": {
        "description": "Indicates if the Weaviate instance is running and responsive to basic HTTP requests. Primarily used for health checks, such as Kubernetes liveness probes.",
        "summary": "Check application liveness",
        "operationId": "weaviate.wellknown.liveness",
        "responses": {
          "200": {
            "description": "The application is alive and responding to HTTP requests."
          }
        }
      }
    },
    "/.well-known/openid-configuration": {
      "get": {
        "description": "Provides OpenID Connect (OIDC) discovery information if OIDC authentication is configured for Weaviate. Returns details like the token issuer URL, client ID, and required scopes.",
        "tags": [
          "well-known",
          "oidc",
          "discovery"
        ],
        "summary": "Get OIDC configuration",
        "responses": {
          "200": {
            "description": "OIDC configuration details returned successfully.",
            "schema": {
              "type": "object",
              "properties": {
                "clientId": {
                  "description": "The OAuth Client ID configured for Weaviate.",
                  "type": "string"
                },
                "href": {
                  "description": "The OIDC issuer URL to redirect to for authentication.",
                  "type": "string"
                },
                "scopes": {
                  "description": "The required OAuth scopes for authentication.",
                  "type": "array",
                  "items": {
                    "type": "string"
                  },
                  "x-omitempty": true
                }
              }
            }
          },
          "404": {
            "description": "OIDC provider is not configured for this Weaviate instance."
          },
          "500": {
            "description": "An internal server error occurred while retrieving OIDC configuration. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false
      }
    },
    "/.well-known/ready": {
      "get": {
        "description": "Indicates if the Weaviate instance has completed its startup routines and is prepared to accept user traffic (data import, queries, etc.). Used for readiness checks, such as Kubernetes readiness probes.",
        "summary": "Check application readiness",
        "operationId": "weaviate.wellknown.readiness",
        "responses": {
          "200": {
            "description": "The application is ready to serve traffic."
          },
          "503": {
            "description": "The application is not ready to serve traffic. Traffic should be directed to other available replicas if applicable."
          }
        }
      }
    },
    "/aliases": {
      "get": {
        "description": "Retrieve a list of all aliases in the system. Results can be filtered by specifying a collection (class) name to get aliases for a specific collection only.",
        "tags": [
          "schema"
        ],
        "summary": "List aliases",
        "operationId": "aliases.get",
        "parameters": [
          {
            "type": "string",
            "description": "Optional filter to retrieve aliases for a specific collection (class) only. If not provided, returns all aliases.",
            "name": "class",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Successfully retrieved the list of aliases",
            "schema": {
              "$ref": "#/definitions/AliasResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid collection (class) parameter provided",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        }
      },
      "post": {
        "description": "Create a new alias mapping between an alias name and a collection (class). The alias acts as an alternative name for accessing the collection.",
        "tags": [
          "schema"
        ],
        "summary": "Create a new alias",
        "operationId": "aliases.create",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/Alias"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Successfully created a new alias for the specified collection (class)",
            "schema": {
              "$ref": "#/definitions/Alias"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid create alias request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        }
      }
    },
    "/aliases/{aliasName}": {
      "get": {
        "description": "Retrieve details about a specific alias by its name, including which collection (class) it points to.",
        "tags": [
          "schema"
        ],
        "summary": "Get an alias",
        "operationId": "aliases.get.alias",
        "parameters": [
          {
            "type": "string",
            "name": "aliasName",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Successfully retrieved the alias details.",
            "schema": {
              "$ref": "#/definitions/Alias"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Not Found - Alias does not exist",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid alias name provided.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        }
      },
      "put": {
        "description": "Update an existing alias to point to a different collection (class). This allows you to redirect an alias from one collection to another without changing the alias name.",
        "tags": [
          "schema"
        ],
        "summary": "Update an alias",
        "operationId": "aliases.update",
        "parameters": [
          {
            "type": "string",
            "name": "aliasName",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "type": "object",
              "properties": {
                "class": {
                  "description": "The new collection (class) that the alias should point to.",
                  "type": "string"
                }
              }
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Successfully updated the alias to point to the new collection (class).",
            "schema": {
              "$ref": "#/definitions/Alias"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Not Found - Alias does not exist",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid update alias request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        }
      },
      "delete": {
        "description": "Remove an existing alias from the system. This will delete the alias mapping but will not affect the underlying collection (class).",
        "tags": [
          "schema"
        ],
        "summary": "Delete an alias",
        "operationId": "aliases.delete",
        "parameters": [
          {
            "type": "string",
            "name": "aliasName",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "Successfully deleted the alias."
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Not Found - Alias does not exist",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid delete alias request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        }
      }
    },
    "/authz/groups/{groupType}": {
      "get": {
        "description": "Retrieves a list of all available group names for a specified group type (` + "`" + `oidc` + "`" + ` or ` + "`" + `db` + "`" + `).",
        "tags": [
          "authz"
        ],
        "summary": "List all groups of a specific type",
        "operationId": "getGroups",
        "parameters": [
          {
            "enum": [
              "oidc"
            ],
            "type": "string",
            "description": "The type of group to retrieve.",
            "name": "groupType",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A list of group names for the specified type.",
            "schema": {
              "type": "array",
              "items": {
                "type": "string"
              }
            }
          },
          "400": {
            "description": "Bad request",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.authz.get.groups"
        ]
      }
    },
    "/authz/groups/{id}/assign": {
      "post": {
        "description": "Assign roles to the specified group.",
        "tags": [
          "authz"
        ],
        "summary": "Assign a role to a group",
        "operationId": "assignRoleToGroup",
        "parameters": [
          {
            "type": "string",
            "description": "The name of the group.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "type": "object",
              "properties": {
                "groupType": {
                  "$ref": "#/definitions/GroupType"
                },
                "roles": {
                  "description": "The roles to assign to the specified group.",
                  "type": "array",
                  "items": {
                    "type": "string"
                  }
                }
              }
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Roles assigned successfully."
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Role or group not found."
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.authz.assign.role"
        ]
      }
    },
    "/authz/groups/{id}/revoke": {
      "post": {
        "description": "Revoke roles from the specified group.",
        "tags": [
          "authz"
        ],
        "summary": "Revoke a role from a group",
        "operationId": "revokeRoleFromGroup",
        "parameters": [
          {
            "type": "string",
            "description": "The name of the group.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "type": "object",
              "properties": {
                "groupType": {
                  "$ref": "#/definitions/GroupType"
                },
                "roles": {
                  "description": "The roles to revoke from the specified group.",
                  "type": "array",
                  "items": {
                    "type": "string"
                  }
                }
              }
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Roles revoked successfully."
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Role or group not found."
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.authz.revoke.role.group"
        ]
      }
    },
    "/authz/groups/{id}/roles/{groupType}": {
      "get": {
        "description": "Retrieves a list of all roles assigned to a specific group. The group must be identified by both its name (` + "`" + `id` + "`" + `) and its type (` + "`" + `db` + "`" + ` or ` + "`" + `oidc` + "`" + `).",
        "tags": [
          "authz"
        ],
        "summary": "Get roles assigned to a specific group",
        "operationId": "getRolesForGroup",
        "parameters": [
          {
            "type": "string",
            "description": "The unique name of the group.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "enum": [
              "oidc"
            ],
            "type": "string",
            "description": "The type of the group.",
            "name": "groupType",
            "in": "path",
            "required": true
          },
          {
            "type": "boolean",
            "default": false,
            "description": "If true, the response will include the full role definitions with all associated permissions. If false, only role names are returned.",
            "name": "includeFullRoles",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "A list of roles assigned to the specified group.",
            "schema": {
              "$ref": "#/definitions/RolesListResponse"
            }
          },
          "400": {
            "description": "Bad request",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "The specified group was not found."
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.authz.get.groups.roles"
        ]
      }
    },
    "/authz/roles": {
      "get": {
        "description": "Get all roles and their assigned permissions.",
        "tags": [
          "authz"
        ],
        "summary": "Get all roles",
        "operationId": "getRoles",
        "responses": {
          "200": {
            "description": "Successful response.",
            "schema": {
              "$ref": "#/definitions/RolesListResponse"
            }
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.authz.get.roles"
        ]
      },
      "post": {
        "description": "Create a new role with the specified permissions.",
        "tags": [
          "authz"
        ],
        "summary": "Create new role",
        "operationId": "createRole",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/Role"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Role created successfully."
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "409": {
            "description": "Role already exists.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.authz.create.role"
        ]
      }
    },
    "/authz/roles/{id}": {
      "get": {
        "description": "Fetch a role by its name.",
        "tags": [
          "authz"
        ],
        "summary": "Get a role",
        "operationId": "getRole",
        "parameters": [
          {
            "type": "string",
            "description": "The name of the role.",
            "name": "id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Successful response.",
            "schema": {
              "$ref": "#/definitions/Role"
            }
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "No role found."
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.authz.get.role"
        ]
      },
      "delete": {
        "description": "Deleting a role will remove it from the system, and revoke the associated permissions from all users who had this role.",
        "tags": [
          "authz"
        ],
        "summary": "Delete a role",
        "operationId": "deleteRole",
        "parameters": [
          {
            "type": "string",
            "description": "The name of the role.",
            "name": "id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "Successfully deleted."
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.authz.delete.role"
        ]
      }
    },
    "/authz/roles/{id}/add-permissions": {
      "post": {
        "description": "Add new permissions to an existing role without affecting current permissions.",
        "tags": [
          "authz"
        ],
        "summary": "Add permissions to a role",
        "operationId": "addPermissions",
        "parameters": [
          {
            "type": "string",
            "description": "The name (ID) of the role being modified.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "type": "object",
              "required": [
                "name",
                "permissions"
              ],
              "properties": {
                "permissions": {
                  "description": "Permissions to be added to the role.",
                  "type": "array",
                  "items": {
                    "$ref": "#/definitions/Permission"
                  }
                }
              }
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Permissions added successfully."
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "No role found."
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.authz.add.role.permissions"
        ]
      }
    },
    "/authz/roles/{id}/group-assignments": {
      "get": {
        "description": "Retrieves a list of all groups that have been assigned a specific role, identified by its name.",
        "tags": [
          "authz"
        ],
        "summary": "Get groups that have a specific role assigned",
        "operationId": "getGroupsForRole",
        "parameters": [
          {
            "type": "string",
            "description": "The unique name of the role.",
            "name": "id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Successfully retrieved the list of groups that have the role assigned.",
            "schema": {
              "type": "array",
              "items": {
                "type": "object",
                "required": [
                  "name",
                  "groupType"
                ],
                "properties": {
                  "groupId": {
                    "type": "string"
                  },
                  "groupType": {
                    "$ref": "#/definitions/GroupType"
                  }
                }
              }
            }
          },
          "400": {
            "description": "Bad request",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "The specified role was not found."
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.authz.get.roles.groups"
        ]
      }
    },
    "/authz/roles/{id}/has-permission": {
      "post": {
        "description": "Check whether a role has the specified permissions.",
        "tags": [
          "authz"
        ],
        "summary": "Check whether a role possesses a permission",
        "operationId": "hasPermission",
        "parameters": [
          {
            "type": "string",
            "description": "The name of the role.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "description": "The permissions to be checked.",
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/Permission"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Permission check was successful.",
            "schema": {
              "type": "boolean"
            }
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.authz.has.role.permission"
        ]
      }
    },
    "/authz/roles/{id}/remove-permissions": {
      "post": {
        "description": "Permissions can be revoked from a specified role. Removing all permissions from a role will delete the role itself.",
        "tags": [
          "authz"
        ],
        "summary": "Remove permissions from a role",
        "operationId": "removePermissions",
        "parameters": [
          {
            "type": "string",
            "description": "The name of the role being modified.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "type": "object",
              "required": [
                "permissions"
              ],
              "properties": {
                "permissions": {
                  "description": "Permissions to remove from the role.",
                  "type": "array",
                  "items": {
                    "$ref": "#/definitions/Permission"
                  }
                }
              }
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Permissions removed successfully."
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "No role found."
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.authz.remove.role.permissions"
        ]
      }
    },
    "/authz/roles/{id}/user-assignments": {
      "get": {
        "description": "Fetch a list of users which have the specified role.",
        "tags": [
          "authz"
        ],
        "summary": "Get users assigned to a role",
        "operationId": "getUsersForRole",
        "parameters": [
          {
            "type": "string",
            "description": "The name (ID) of the role.",
            "name": "id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Users assigned to this role.",
            "schema": {
              "type": "array",
              "items": {
                "type": "object",
                "required": [
                  "name",
                  "userType"
                ],
                "properties": {
                  "userId": {
                    "type": "string"
                  },
                  "userType": {
                    "$ref": "#/definitions/UserTypeOutput"
                  }
                }
              }
            }
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "No role found."
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.authz.get.roles.users"
        ]
      }
    },
    "/authz/roles/{id}/users": {
      "get": {
        "description": "Get all the users (` + "`" + `db` + "`" + ` + ` + "`" + `oidc` + "`" + `) who have been assigned a specific role. Deprecated, will be removed when v1.29 is not supported anymore.",
        "tags": [
          "authz"
        ],
        "summary": "Get users assigned to a role",
        "operationId": "getUsersForRoleDeprecated",
        "deprecated": true,
        "parameters": [
          {
            "type": "string",
            "description": "The name of the role.",
            "name": "id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Users assigned to this role.",
            "schema": {
              "type": "array",
              "items": {
                "type": "string"
              }
            }
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "No role found."
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.authz.get.roles.users"
        ]
      }
    },
    "/authz/users/{id}/assign": {
      "post": {
        "description": "Assign one or more roles to a user. Users can have multiple roles.",
        "tags": [
          "authz"
        ],
        "summary": "Assign a role to a user",
        "operationId": "assignRoleToUser",
        "parameters": [
          {
            "type": "string",
            "description": "The name of the user.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "type": "object",
              "properties": {
                "roles": {
                  "description": "The roles that are assigned to the specified user.",
                  "type": "array",
                  "items": {
                    "type": "string"
                  }
                },
                "userType": {
                  "$ref": "#/definitions/UserTypeInput"
                }
              }
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Role assigned successfully."
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Specified role or user not found.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.authz.assign.role.user"
        ]
      }
    },
    "/authz/users/{id}/revoke": {
      "post": {
        "description": "Remove one or more roles from a user.",
        "tags": [
          "authz"
        ],
        "summary": "Revoke a role from a user",
        "operationId": "revokeRoleFromUser",
        "parameters": [
          {
            "type": "string",
            "description": "The name of the user.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "type": "object",
              "properties": {
                "roles": {
                  "description": "The roles to revoke from the specified user.",
                  "type": "array",
                  "items": {
                    "type": "string"
                  }
                },
                "userType": {
                  "$ref": "#/definitions/UserTypeInput"
                }
              }
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Roles revoked successfully."
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Specified role or user not found.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.authz.revoke.role.user"
        ]
      }
    },
    "/authz/users/{id}/roles": {
      "get": {
        "description": "Retrieve the roles assigned to a specific user (` + "`" + `db` + "`" + ` + ` + "`" + `oidc` + "`" + `). Deprecated, will be removed when 1.29 is not supported anymore",
        "tags": [
          "authz"
        ],
        "summary": "Get roles assigned to a user",
        "operationId": "getRolesForUserDeprecated",
        "deprecated": true,
        "parameters": [
          {
            "type": "string",
            "description": "The name of the user.",
            "name": "id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Roles assigned to the user.",
            "schema": {
              "$ref": "#/definitions/RolesListResponse"
            }
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "No roles found for specified user."
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.authz.get.users.roles"
        ]
      }
    },
    "/authz/users/{id}/roles/{userType}": {
      "get": {
        "description": "Get all the roles for a specific user (` + "`" + `db` + "`" + ` or ` + "`" + `oidc` + "`" + `).",
        "tags": [
          "authz"
        ],
        "summary": "Get roles assigned to a user",
        "operationId": "getRolesForUser",
        "parameters": [
          {
            "type": "string",
            "description": "The name of the user.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "enum": [
              "oidc",
              "db"
            ],
            "type": "string",
            "description": "The type of the user.",
            "name": "userType",
            "in": "path",
            "required": true
          },
          {
            "type": "boolean",
            "default": false,
            "description": "Whether to include detailed role information like its assigned permissions.",
            "name": "includeFullRoles",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Roles assigned to the user.",
            "schema": {
              "$ref": "#/definitions/RolesListResponse"
            }
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "No roles found for specified user."
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.authz.get.users.roles"
        ]
      }
    },
    "/backups/{backend}": {
      "get": {
        "description": "List all created backups IDs, Status",
        "tags": [
          "backups"
        ],
        "summary": "List all created backups",
        "operationId": "backups.list",
        "parameters": [
          {
            "type": "string",
            "description": "Specifies the backend storage system to list backups from (e.g., ` + "`" + `filesystem` + "`" + `, ` + "`" + `gcs` + "`" + `, ` + "`" + `s3` + "`" + `, ` + "`" + `azure` + "`" + `).",
            "name": "backend",
            "in": "path",
            "required": true
          },
          {
            "enum": [
              "asc",
              "desc"
            ],
            "type": "string",
            "default": "desc",
            "description": "Order of returned list of backups based on creation time. (asc or desc)",
            "name": "order",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Successfully retrieved the list of backups in progress.",
            "schema": {
              "$ref": "#/definitions/BackupListResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid request to list backups.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An internal server error occurred while listing backups. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.local.backup"
        ]
      },
      "post": {
        "description": "Initiates the creation of a backup for specified collections on a designated backend storage.\u003cbr/\u003e\u003cbr/\u003eNotes:\u003cbr/\u003e- Backups are compressed using gzip by default.\u003cbr/\u003e- Weaviate remains operational during the backup process.",
        "tags": [
          "backups"
        ],
        "summary": "Create a backup",
        "operationId": "backups.create",
        "parameters": [
          {
            "type": "string",
            "description": "Specifies the backend storage system where the backup will be stored (e.g., ` + "`" + `filesystem` + "`" + `, ` + "`" + `gcs` + "`" + `, ` + "`" + `s3` + "`" + `, ` + "`" + `azure` + "`" + `).",
            "name": "backend",
            "in": "path",
            "required": true
          },
          {
            "description": "Details of the backup request, including the backup ID and collections to include or exclude.",
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/BackupCreateRequest"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Backup creation process initiated successfully. Check the status endpoint for progress.",
            "schema": {
              "$ref": "#/definitions/BackupCreateResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid backup creation request. Check the request body and backend configuration.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An internal server error occurred during backup initiation. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.local.backup"
        ]
      }
    },
    "/backups/{backend}/{id}": {
      "get": {
        "description": "Checks the status of a specific backup creation process identified by its ID on the specified backend.\u003cbr/\u003e\u003cbr/\u003eClient libraries often provide a 'wait for completion' feature that polls this endpoint automatically. Use this endpoint for manual status checks or if 'wait for completion' is disabled.",
        "tags": [
          "backups"
        ],
        "summary": "Get backup creation status",
        "operationId": "backups.create.status",
        "parameters": [
          {
            "type": "string",
            "description": "Specifies the backend storage system where the backup resides (e.g., ` + "`" + `filesystem` + "`" + `, ` + "`" + `gcs` + "`" + `, ` + "`" + `s3` + "`" + `, ` + "`" + `azure` + "`" + `).",
            "name": "backend",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "The unique identifier of the backup. Must be URL-safe and compatible with filesystem paths (only lowercase, numbers, underscore, minus characters allowed).",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Optional: Specifies the bucket, container, or volume name if required by the backend.",
            "name": "bucket",
            "in": "query"
          },
          {
            "type": "string",
            "description": "Optional: Specifies the path within the bucket/container/volume if the backup is not at the root.",
            "name": "path",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Successfully retrieved the status of the backup creation process.",
            "schema": {
              "$ref": "#/definitions/BackupCreateStatusResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Backup not found on the specified backend with the given ID.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid request to check backup creation status.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An internal server error occurred while checking backup status. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.local.backup"
        ]
      },
      "delete": {
        "description": "Cancels an ongoing backup operation identified by its ID.",
        "tags": [
          "backups"
        ],
        "summary": "Cancel a backup",
        "operationId": "backups.cancel",
        "parameters": [
          {
            "type": "string",
            "description": "Specifies the backend storage system where the backup resides (e.g., ` + "`" + `filesystem` + "`" + `, ` + "`" + `gcs` + "`" + `, ` + "`" + `s3` + "`" + `, ` + "`" + `azure` + "`" + `).",
            "name": "backend",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "The unique identifier of the backup to cancel. Must be URL-safe and compatible with filesystem paths (only lowercase, numbers, underscore, minus characters allowed).",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Optional: Specifies the bucket, container, or volume name if required by the backend.",
            "name": "bucket",
            "in": "query"
          },
          {
            "type": "string",
            "description": "Optional: Specifies the path within the bucket/container/volume if the backup is not at the root.",
            "name": "path",
            "in": "query"
          }
        ],
        "responses": {
          "204": {
            "description": "Backup canceled successfully."
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid backup cancellation request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An internal server error occurred during backup cancellation. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.local.backup"
        ]
      }
    },
    "/backups/{backend}/{id}/restore": {
      "get": {
        "description": "Checks the status of a specific backup restoration process identified by the backup ID on the specified backend.\u003cbr/\u003e\u003cbr/\u003eClient libraries often provide a 'wait for completion' feature that polls this endpoint automatically. Use this endpoint for manual status checks or if 'wait for completion' is disabled.",
        "tags": [
          "backups"
        ],
        "summary": "Get backup restoration status",
        "operationId": "backups.restore.status",
        "parameters": [
          {
            "type": "string",
            "description": "Specifies the backend storage system where the backup resides (e.g., ` + "`" + `filesystem` + "`" + `, ` + "`" + `gcs` + "`" + `, ` + "`" + `s3` + "`" + `, ` + "`" + `azure` + "`" + `).",
            "name": "backend",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "The unique identifier of the backup being restored. Must be URL-safe and compatible with filesystem paths (only lowercase, numbers, underscore, minus characters allowed).",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Optional: Specifies the bucket, container, or volume name if required by the backend.",
            "name": "bucket",
            "in": "query"
          },
          {
            "type": "string",
            "description": "Optional: Specifies the path within the bucket.",
            "name": "path",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Successfully retrieved the status of the backup restoration process.",
            "schema": {
              "$ref": "#/definitions/BackupRestoreStatusResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Backup not found on the specified backend with the given ID.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An internal server error occurred while checking restore status. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.local.backup"
        ]
      },
      "post": {
        "description": "Initiates the restoration of collections from a specified backup located on a designated backend.\u003cbr/\u003e\u003cbr/\u003eRequirements:\u003cbr/\u003e- Target cluster must have the same number of nodes as the source cluster where the backup was created.\u003cbr/\u003e- Collections included in the restore must not already exist on the target cluster.\u003cbr/\u003e- Node names must match between the backup and the target cluster.",
        "tags": [
          "backups"
        ],
        "summary": "Restore from a backup",
        "operationId": "backups.restore",
        "parameters": [
          {
            "type": "string",
            "description": "Specifies the backend storage system where the backup resides (e.g., ` + "`" + `filesystem` + "`" + `, ` + "`" + `gcs` + "`" + `, ` + "`" + `s3` + "`" + `, ` + "`" + `azure` + "`" + `).",
            "name": "backend",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "The unique identifier of the backup to restore from. Must be URL-safe and compatible with filesystem paths (only lowercase, numbers, underscore, minus characters allowed).",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "description": "Details of the restore request, including collections to include or exclude and node mapping if necessary.",
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/BackupRestoreRequest"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Backup restoration process initiated successfully. Check the status endpoint for progress.",
            "schema": {
              "$ref": "#/definitions/BackupRestoreResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Backup not found on the specified backend with the given ID.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid backup restoration request. Check requirements and request body.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An internal server error occurred during restore initiation. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.local.backup"
        ]
      }
    },
    "/batch/objects": {
      "post": {
        "description": "Registers multiple data objects in a single request for efficiency. Metadata and schema values for each object are validated.\u003cbr/\u003e\u003cbr/\u003e**Note (idempotence)**:\u003cbr/\u003eThis operation is idempotent based on the object UUIDs provided. If an object with a given UUID already exists, it will be overwritten (similar to a PUT operation for that specific object within the batch).",
        "tags": [
          "batch",
          "objects"
        ],
        "summary": "Create objects in batch",
        "operationId": "batch.objects.create",
        "parameters": [
          {
            "description": "The request body containing the objects to be created.",
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "type": "object",
              "properties": {
                "fields": {
                  "description": "Controls which fields are returned in the response for each object. Default is ` + "`" + `ALL` + "`" + `.",
                  "type": "array",
                  "items": {
                    "type": "string",
                    "default": "ALL",
                    "enum": [
                      "ALL",
                      "class",
                      "schema",
                      "id",
                      "creationTimeUnix"
                    ]
                  }
                },
                "objects": {
                  "description": "Array of objects to be created.",
                  "type": "array",
                  "items": {
                    "$ref": "#/definitions/Object"
                  }
                }
              }
            }
          },
          {
            "$ref": "#/parameters/CommonConsistencyLevelParameterQuery"
          }
        ],
        "responses": {
          "200": {
            "description": "Request processed successfully. Individual object statuses are provided in the response body.",
            "schema": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/ObjectsGetResponse"
              }
            }
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request. Ensure the collection exists and the object properties are valid.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error occurred while trying to fulfill the request. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.add"
        ]
      },
      "delete": {
        "description": "Removes multiple data objects based on a filter specified in the request body.\u003cbr/\u003e\u003cbr/\u003eDeletion occurs based on the filter criteria provided in the ` + "`" + `where` + "`" + ` clause. There is a configurable limit (default 10,000, set via ` + "`" + `QUERY_MAXIMUM_RESULTS` + "`" + `) on how many objects can be deleted in a single batch request to prevent excessive resource usage. Objects are deleted in the order they match the filter. To delete more objects than the limit allows, repeat the request until no more matching objects are found.",
        "tags": [
          "batch",
          "objects"
        ],
        "summary": "Delete objects in batch",
        "operationId": "batch.objects.delete",
        "parameters": [
          {
            "description": "The request body containing the match filter and output configuration.",
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/BatchDelete"
            }
          },
          {
            "$ref": "#/parameters/CommonConsistencyLevelParameterQuery"
          },
          {
            "$ref": "#/parameters/CommonTenantParameterQuery"
          }
        ],
        "responses": {
          "200": {
            "description": "Request processed successfully. See response body for matching objects and deletion results.",
            "schema": {
              "$ref": "#/definitions/BatchDeleteResponse"
            }
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid data provided. Please check the values in your request (e.g., invalid filter).",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error occurred while trying to fulfill the request. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.manipulate"
        ]
      }
    },
    "/batch/references": {
      "post": {
        "description": "Batch create cross-references between collection items in bulk.",
        "tags": [
          "batch",
          "references"
        ],
        "summary": "Create cross-references in bulk",
        "operationId": "batch.references.create",
        "parameters": [
          {
            "description": "A list of references to be batched. The ideal size depends on the used database connector. Please see the documentation of the used connector for help.",
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/BatchReference"
              }
            }
          },
          {
            "$ref": "#/parameters/CommonConsistencyLevelParameterQuery"
          }
        ],
        "responses": {
          "200": {
            "description": "Request Successful. Warning: A successful request does not guarantee that every batched reference was successfully created. Inspect the response body to see which references succeeded and which failed.",
            "schema": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/BatchReferenceResponse"
              }
            }
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request. Ensure the collection exists and the object properties are valid.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.add"
        ]
      }
    },
    "/classifications/": {
      "post": {
        "description": "Initiates a background classification task based on the provided parameters. Use the GET /classifications/{id} endpoint to monitor the status and retrieve results.",
        "tags": [
          "classifications"
        ],
        "summary": "Start a classification",
        "operationId": "classifications.post",
        "parameters": [
          {
            "description": "Configuration parameters for the classification task, including type, target properties, and training data references.",
            "name": "params",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/Classification"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Classification task successfully initiated. The response body contains the classification details including its ID.",
            "schema": {
              "$ref": "#/definitions/Classification"
            }
          },
          "400": {
            "description": "Invalid request body or parameters.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An internal server error occurred while starting the classification task. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.classifications.post"
        ]
      }
    },
    "/classifications/{id}": {
      "get": {
        "description": "Retrieves the status, metadata, and results (if completed) of a classification task identified by its unique ID.",
        "tags": [
          "classifications"
        ],
        "summary": "Get classification status",
        "operationId": "classifications.get",
        "parameters": [
          {
            "type": "string",
            "description": "The unique identifier (UUID) of the classification task.",
            "name": "id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Successfully retrieved the classification details.",
            "schema": {
              "$ref": "#/definitions/Classification"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Classification with the given ID not found."
          },
          "500": {
            "description": "An internal server error occurred while retrieving the classification status. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.classifications.get"
        ]
      }
    },
    "/cluster/statistics": {
      "get": {
        "description": "Provides statistics about the internal Raft consensus protocol state for the Weaviate cluster.",
        "tags": [
          "cluster"
        ],
        "summary": "Get cluster statistics",
        "operationId": "cluster.get.statistics",
        "responses": {
          "200": {
            "description": "Successfully retrieved Raft cluster statistics.",
            "schema": {
              "$ref": "#/definitions/ClusterStatisticsResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid request for cluster statistics.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An internal server error occurred while retrieving cluster statistics. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.cluster.statistics.get"
        ]
      }
    },
    "/graphql": {
      "post": {
        "description": "Executes a single GraphQL query provided in the request body. Use this endpoint for all Weaviate data queries and exploration.",
        "tags": [
          "graphql"
        ],
        "summary": "Perform a GraphQL query",
        "operationId": "graphql.post",
        "parameters": [
          {
            "description": "The GraphQL query to execute, including the query string and optional variables.",
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/GraphQLQuery"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Query executed successfully. The response body contains the query result.",
            "schema": {
              "$ref": "#/definitions/GraphQLResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An internal server error occurred during query execution. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.query",
          "weaviate.local.query.meta",
          "weaviate.network.query",
          "weaviate.network.query.meta"
        ]
      }
    },
    "/graphql/batch": {
      "post": {
        "description": "Executes multiple GraphQL queries provided in the request body as an array. Allows performing several queries in a single network request for efficiency.",
        "tags": [
          "graphql"
        ],
        "summary": "Perform batched GraphQL queries",
        "operationId": "graphql.batch",
        "parameters": [
          {
            "description": "An array containing multiple GraphQL query objects to execute in batch.",
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/GraphQLQueries"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Batch request processed successfully. The response body contains an array of results corresponding to the input queries.",
            "schema": {
              "$ref": "#/definitions/GraphQLResponses"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An internal server error occurred during batch query execution. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.query",
          "weaviate.local.query.meta",
          "weaviate.network.query",
          "weaviate.network.query.meta"
        ]
      }
    },
    "/meta": {
      "get": {
        "description": "Provides meta-information about the running Weaviate instance, including its version, loaded modules, and network hostname. This information can be useful for monitoring, compatibility checks, or inter-instance communication.",
        "tags": [
          "meta"
        ],
        "summary": "Get instance metadata",
        "operationId": "meta.get",
        "responses": {
          "200": {
            "description": "Successfully retrieved meta information.",
            "schema": {
              "$ref": "#/definitions/Meta"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An internal server error occurred while retrieving meta information. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.query.meta"
        ]
      }
    },
    "/nodes": {
      "get": {
        "description": "Retrieves status information about all nodes in the cluster. Use the ` + "`" + `output` + "`" + ` query parameter to control the level of detail.",
        "tags": [
          "nodes"
        ],
        "summary": "Get node status",
        "operationId": "nodes.get",
        "parameters": [
          {
            "$ref": "#/parameters/CommonOutputVerbosityParameterQuery"
          }
        ],
        "responses": {
          "200": {
            "description": "Successfully retrieved the status for all nodes.",
            "schema": {
              "$ref": "#/definitions/NodesStatusResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Not Found.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid request for node status.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An internal server error occurred while retrieving node status. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.nodes.status.get"
        ]
      }
    },
    "/nodes/{className}": {
      "get": {
        "description": "Retrieves status information only for the nodes that host shards for the specified collection (` + "`" + `className` + "`" + `). Use the ` + "`" + `output` + "`" + ` query parameter to control the level of detail.",
        "tags": [
          "nodes"
        ],
        "summary": "Get node status by collection",
        "operationId": "nodes.get.class",
        "parameters": [
          {
            "type": "string",
            "description": "The name of the collection (class) for which to retrieve node status.",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "shardName",
            "in": "query"
          },
          {
            "$ref": "#/parameters/CommonOutputVerbosityParameterQuery"
          }
        ],
        "responses": {
          "200": {
            "description": "Successfully retrieved the status for nodes relevant to the specified collection.",
            "schema": {
              "$ref": "#/definitions/NodesStatusResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Not Found.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid request for node status.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An internal server error occurred while retrieving node status for the collection. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.nodes.status.get.class"
        ]
      }
    },
    "/objects": {
      "get": {
        "description": "Retrieves a list of data objects. By default, objects are returned in reverse order of creation. Requires a collection name (` + "`" + `class` + "`" + `) parameter to specify which collection's objects to list, otherwise, returns an empty list.",
        "tags": [
          "objects"
        ],
        "summary": "List objects",
        "operationId": "objects.list",
        "parameters": [
          {
            "$ref": "#/parameters/CommonAfterParameterQuery"
          },
          {
            "$ref": "#/parameters/CommonOffsetParameterQuery"
          },
          {
            "$ref": "#/parameters/CommonLimitParameterQuery"
          },
          {
            "$ref": "#/parameters/CommonIncludeParameterQuery"
          },
          {
            "$ref": "#/parameters/CommonSortParameterQuery"
          },
          {
            "$ref": "#/parameters/CommonOrderParameterQuery"
          },
          {
            "$ref": "#/parameters/CommonClassParameterQuery"
          },
          {
            "$ref": "#/parameters/CommonTenantParameterQuery"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful response containing the list of objects. If the collection name (` + "`" + `class` + "`" + `) is not provided, the response will not include any objects.",
            "schema": {
              "$ref": "#/definitions/ObjectsListResponse"
            }
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Successful query result but no matching objects were found."
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request. Ensure the specified collection exists.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error occurred while trying to fulfill the request. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.query"
        ]
      },
      "post": {
        "description": "Creates a new data object. The object's metadata and schema values are validated before creation.\u003cbr/\u003e\u003cbr/\u003e**Note (batch import)**:\u003cbr/\u003eIf you plan on importing a large number of objects, using the ` + "`" + `/batch/objects` + "`" + ` endpoint is significantly more efficient than sending multiple single requests.\u003cbr/\u003e\u003cbr/\u003e**Note (idempotence)**:\u003cbr/\u003eThis operation (POST) fails if an object with the provided ID already exists. To update an existing object, use the PUT or PATCH methods.",
        "tags": [
          "objects"
        ],
        "summary": "Create an object",
        "operationId": "objects.create",
        "parameters": [
          {
            "description": "The object to be created.",
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/Object"
            }
          },
          {
            "$ref": "#/parameters/CommonConsistencyLevelParameterQuery"
          }
        ],
        "responses": {
          "200": {
            "description": "Object created successfully.",
            "schema": {
              "$ref": "#/definitions/Object"
            }
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request. Ensure the collection exists and the object properties are valid.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error occurred while trying to fulfill the request. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.add"
        ]
      }
    },
    "/objects/validate": {
      "post": {
        "description": "Checks if a data object's structure conforms to the specified collection schema and metadata rules without actually storing the object.\u003cbr/\u003e\u003cbr/\u003eA successful validation returns a 200 OK status code with no body. If validation fails, an error response with details is returned.",
        "tags": [
          "objects"
        ],
        "summary": "Validate an object",
        "operationId": "objects.validate",
        "parameters": [
          {
            "description": "The object definition to validate.",
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/Object"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Object is valid according to the schema."
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Request body is well-formed but the object is invalid according to the schema.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error occurred while trying to fulfill the request. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.query.meta"
        ]
      }
    },
    "/objects/{className}/{id}": {
      "get": {
        "description": "Get a data object based on its collection name (` + "`" + `className` + "`" + `) and UUID (` + "`" + `id` + "`" + `).",
        "tags": [
          "objects"
        ],
        "summary": "Get an object",
        "operationId": "objects.class.get",
        "parameters": [
          {
            "type": "string",
            "description": "Name of the collection (class) the object belongs to.",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "Unique UUID of the object to be retrieved.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/CommonIncludeParameterQuery"
          },
          {
            "$ref": "#/parameters/CommonConsistencyLevelParameterQuery"
          },
          {
            "$ref": "#/parameters/CommonNodeNameParameterQuery"
          },
          {
            "$ref": "#/parameters/CommonTenantParameterQuery"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful response containing the object.",
            "schema": {
              "$ref": "#/definitions/Object"
            }
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Object not found."
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error occurred while trying to fulfill the request. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.query"
        ]
      },
      "put": {
        "description": "Replaces properties of an existing data object. The object is identified by its collection name (` + "`" + `className` + "`" + `) and UUID (` + "`" + `id` + "`" + `). The request body must contain the complete object definition with the new property values.",
        "tags": [
          "objects"
        ],
        "summary": "Replace an object",
        "operationId": "objects.class.put",
        "parameters": [
          {
            "type": "string",
            "description": "Name of the collection (class) the object belongs to.",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "Unique UUID of the object to be replaced.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "description": "The object definition to replace the existing object with.",
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/Object"
            }
          },
          {
            "$ref": "#/parameters/CommonConsistencyLevelParameterQuery"
          }
        ],
        "responses": {
          "200": {
            "description": "Object replaced successfully.",
            "schema": {
              "$ref": "#/definitions/Object"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Object not found."
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request. Ensure the collection exists and the object properties are valid.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error occurred while trying to fulfill the request. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.manipulate"
        ]
      },
      "delete": {
        "description": "Removes a data object from a specific collection, identified by its collection name (` + "`" + `className` + "`" + `) and UUID (` + "`" + `id` + "`" + `).\u003cbr/\u003e\u003cbr/\u003e**Note on deleting references (legacy format):**\u003cbr/\u003eFor backward compatibility with older beacon formats (lacking a collection name), deleting a reference requires the beacon in the request to exactly match the stored format. Beacons always use ` + "`" + `localhost` + "`" + ` as the host, indicating the target is within the same Weaviate instance.",
        "tags": [
          "objects"
        ],
        "summary": "Delete an object",
        "operationId": "objects.class.delete",
        "parameters": [
          {
            "type": "string",
            "description": "Name of the collection (class) the object belongs to.",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "Unique UUID of the object to be deleted.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/CommonConsistencyLevelParameterQuery"
          },
          {
            "$ref": "#/parameters/CommonTenantParameterQuery"
          }
        ],
        "responses": {
          "204": {
            "description": "Object deleted successfully."
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Object not found."
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error occurred while trying to fulfill the request. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": true,
        "x-available-in-websocket": true,
        "x-serviceIds": [
          "weaviate.local.manipulate"
        ]
      },
      "head": {
        "description": "Verifies the existence of a specific data object within a collection (class), identified by its collection name (` + "`" + `className` + "`" + `) and UUID (` + "`" + `id` + "`" + `), without returning the object itself.\u003cbr/\u003e\u003cbr/\u003eThis is faster than a GET request as it avoids retrieving and processing object data. Existence is confirmed by a 204 No Content status code, while non-existence results in a 404 Not Found.",
        "tags": [
          "objects"
        ],
        "summary": "Check if an object exists",
        "operationId": "objects.class.head",
        "parameters": [
          {
            "type": "string",
            "description": "Name of the collection (class) the object belongs to.",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "Unique UUID of the object to check.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/CommonConsistencyLevelParameterQuery"
          },
          {
            "$ref": "#/parameters/CommonTenantParameterQuery"
          }
        ],
        "responses": {
          "204": {
            "description": "Object exists."
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Object does not exist."
          },
          "422": {
            "description": "Invalid data provided. Please check the values in your request (e.g., invalid UUID format).",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error occurred while trying to fulfill the request. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": true,
        "x-available-in-websocket": true,
        "x-serviceIds": [
          "weaviate.local.manipulate"
        ]
      },
      "patch": {
        "description": "Updates specific properties of an existing data object using JSON merge patch semantics (RFC 7396). The object is identified by its collection name (` + "`" + `className` + "`" + `) and UUID (` + "`" + `id` + "`" + `). Only the fields provided in the request body are modified. Metadata and schema values are validated, and the object's ` + "`" + `lastUpdateTimeUnix` + "`" + ` is updated.",
        "tags": [
          "objects"
        ],
        "summary": "Patch an object",
        "operationId": "objects.class.patch",
        "parameters": [
          {
            "type": "string",
            "description": "Name of the collection (class) the object belongs to.",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "Unique UUID of the object to be patched.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "description": "RFC 7396-style JSON merge patch object containing the fields to update.",
            "name": "body",
            "in": "body",
            "schema": {
              "$ref": "#/definitions/Object"
            }
          },
          {
            "$ref": "#/parameters/CommonConsistencyLevelParameterQuery"
          }
        ],
        "responses": {
          "204": {
            "description": "Object patched successfully."
          },
          "400": {
            "description": "Malformed patch request body.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Object not found."
          },
          "422": {
            "description": "The patch object is valid JSON but is unprocessable for other reasons (e.g., invalid schema).",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error occurred while trying to fulfill the request. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.manipulate"
        ]
      }
    },
    "/objects/{className}/{id}/references/{propertyName}": {
      "put": {
        "description": "Replaces all existing references for a specific reference property (` + "`" + `propertyName` + "`" + `) on a source data object. The source object is identified by its collection name (` + "`" + `className` + "`" + `) and UUID (` + "`" + `id` + "`" + `). The new set of references is provided in the request body.",
        "tags": [
          "objects"
        ],
        "summary": "Replace object references",
        "operationId": "objects.class.references.put",
        "parameters": [
          {
            "type": "string",
            "description": "Name of the collection (class) the source object belongs to.",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "Unique UUID of the source object.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Unique name of the reference property of the source object.",
            "name": "propertyName",
            "in": "path",
            "required": true
          },
          {
            "description": "The new list of references.",
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/MultipleRef"
            }
          },
          {
            "$ref": "#/parameters/CommonConsistencyLevelParameterQuery"
          },
          {
            "$ref": "#/parameters/CommonTenantParameterQuery"
          }
        ],
        "responses": {
          "200": {
            "description": "References replaced successfully."
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Source object not found."
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request. Ensure the property exists and is a reference type.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error occurred while trying to fulfill the request. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.manipulate"
        ]
      },
      "post": {
        "description": "Adds a new reference to a reference property (` + "`" + `propertyName` + "`" + `) on a source data object. The source object is identified by its collection name (` + "`" + `className` + "`" + `) and UUID (` + "`" + `id` + "`" + `). The reference to add is specified in the request body.",
        "tags": [
          "objects"
        ],
        "summary": "Add an object reference",
        "operationId": "objects.class.references.create",
        "parameters": [
          {
            "type": "string",
            "description": "Name of the collection (class) the source object belongs to.",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "Unique UUID of the source object.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Unique name of the reference property of the source object.",
            "name": "propertyName",
            "in": "path",
            "required": true
          },
          {
            "description": "The reference to add.",
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/SingleRef"
            }
          },
          {
            "$ref": "#/parameters/CommonConsistencyLevelParameterQuery"
          },
          {
            "$ref": "#/parameters/CommonTenantParameterQuery"
          }
        ],
        "responses": {
          "200": {
            "description": "Reference added successfully."
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Source object not found."
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request. Ensure the property exists and is a reference type.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error occurred while trying to fulfill the request. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.manipulate"
        ]
      },
      "delete": {
        "description": "Removes a specific reference from a reference property (` + "`" + `propertyName` + "`" + `) of a source data object. The source object is identified by its collection name (` + "`" + `className` + "`" + `) and UUID (` + "`" + `id` + "`" + `). The reference to remove is specified in the request body.",
        "tags": [
          "objects"
        ],
        "summary": "Delete an object reference",
        "operationId": "objects.class.references.delete",
        "parameters": [
          {
            "type": "string",
            "description": "Name of the collection (class) the source object belongs to.",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "Unique UUID of the source object.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Unique name of the reference property of the source object.",
            "name": "propertyName",
            "in": "path",
            "required": true
          },
          {
            "description": "The reference to remove.",
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/SingleRef"
            }
          },
          {
            "$ref": "#/parameters/CommonConsistencyLevelParameterQuery"
          },
          {
            "$ref": "#/parameters/CommonTenantParameterQuery"
          }
        ],
        "responses": {
          "204": {
            "description": "Reference deleted successfully."
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Object or reference not found.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request. Ensure the property exists and is a reference type.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error occurred while trying to fulfill the request. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.manipulate"
        ]
      }
    },
    "/objects/{id}": {
      "get": {
        "description": "Get a specific object based on its UUID. Also available as Websocket bus. \u003cbr/\u003e\u003cbr/\u003e**Note**: This endpoint is deprecated and will be removed in a future version. Use the ` + "`" + `/objects/{className}/{id}` + "`" + ` endpoint instead.",
        "tags": [
          "objects"
        ],
        "summary": "Get an object",
        "operationId": "objects.get",
        "deprecated": true,
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "Unique UUID of the object to be retrieved.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/CommonIncludeParameterQuery"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful response containing the object.",
            "schema": {
              "$ref": "#/definitions/Object"
            }
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Object not found."
          },
          "500": {
            "description": "An error occurred while trying to fulfill the request. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.query"
        ]
      },
      "put": {
        "description": "Updates an object based on its UUID. Given meta-data and schema values are validated. ` + "`" + `lastUpdateTimeUnix` + "`" + ` is set to the time this function is called. \u003cbr/\u003e\u003cbr/\u003e**Note**: This endpoint is deprecated and will be removed in a future version. Use the ` + "`" + `/objects/{className}/{id}` + "`" + ` endpoint instead.",
        "tags": [
          "objects"
        ],
        "summary": "Update an object",
        "operationId": "objects.update",
        "deprecated": true,
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "Unique UUID of the object to be replaced.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "description": "The object definition to replace the existing object with.",
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/Object"
            }
          },
          {
            "$ref": "#/parameters/CommonConsistencyLevelParameterQuery"
          }
        ],
        "responses": {
          "200": {
            "description": "Object replaced successfully.",
            "schema": {
              "$ref": "#/definitions/Object"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Object not found."
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request. Ensure the collection exists and the object properties are valid.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error occurred while trying to fulfill the request. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.manipulate"
        ]
      },
      "delete": {
        "description": "Deletes an object from the database based on its UUID. \u003cbr/\u003e\u003cbr/\u003e**Note**: This endpoint is deprecated and will be removed in a future version. Use the ` + "`" + `/objects/{className}/{id}` + "`" + ` endpoint instead.",
        "tags": [
          "objects"
        ],
        "summary": "Delete an object",
        "operationId": "objects.delete",
        "deprecated": true,
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "Unique UUID of the object to be deleted.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/CommonConsistencyLevelParameterQuery"
          },
          {
            "$ref": "#/parameters/CommonTenantParameterQuery"
          }
        ],
        "responses": {
          "204": {
            "description": "Object deleted successfully."
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Object not found."
          },
          "500": {
            "description": "An error occurred while trying to fulfill the request. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": true,
        "x-available-in-websocket": true,
        "x-serviceIds": [
          "weaviate.local.manipulate"
        ]
      },
      "head": {
        "description": "Checks if an object exists in the system based on its UUID. \u003cbr/\u003e\u003cbr/\u003e**Note**: This endpoint is deprecated and will be removed in a future version. Use the ` + "`" + `/objects/{className}/{id}` + "`" + ` endpoint instead.",
        "tags": [
          "objects"
        ],
        "summary": "Check if an object exists",
        "operationId": "objects.head",
        "deprecated": true,
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "Unique UUID of the object to check.",
            "name": "id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "Object exists."
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Object does not exist."
          },
          "500": {
            "description": "An error occurred while trying to fulfill the request. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": true,
        "x-available-in-websocket": true,
        "x-serviceIds": [
          "weaviate.objects.check"
        ]
      },
      "patch": {
        "description": "Update an object based on its UUID (using patch semantics). This method supports json-merge style patch semantics (RFC 7396). Provided meta-data and schema values are validated. ` + "`" + `lastUpdateTimeUnix` + "`" + ` is set to the time this function is called. \u003cbr/\u003e\u003cbr/\u003e**Note**: This endpoint is deprecated and will be removed in a future version. Use the ` + "`" + `/objects/{className}/{id}` + "`" + ` endpoint instead.",
        "tags": [
          "objects"
        ],
        "summary": "Patch an object",
        "operationId": "objects.patch",
        "deprecated": true,
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "Unique UUID of the object to be patched.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "description": "RFC 7396-style JSON merge patch object containing the fields to update.",
            "name": "body",
            "in": "body",
            "schema": {
              "$ref": "#/definitions/Object"
            }
          },
          {
            "$ref": "#/parameters/CommonConsistencyLevelParameterQuery"
          }
        ],
        "responses": {
          "204": {
            "description": "Object patched successfully."
          },
          "400": {
            "description": "Malformed patch request body."
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Object not found."
          },
          "422": {
            "description": "The patch object is valid JSON but is unprocessable for other reasons (e.g., invalid schema).",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error occurred while trying to fulfill the request. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.manipulate"
        ]
      }
    },
    "/objects/{id}/references/{propertyName}": {
      "put": {
        "description": "Replace all references in cross-reference property of an object. \u003cbr/\u003e\u003cbr/\u003e**Note**: This endpoint is deprecated and will be removed in a future version. Use the ` + "`" + `/objects/{className}/{id}/references/{propertyName}` + "`" + ` endpoint instead.",
        "tags": [
          "objects"
        ],
        "summary": "Replace object references",
        "operationId": "objects.references.update",
        "deprecated": true,
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "Unique UUID of the source object.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Unique name of the reference property of the source object.",
            "name": "propertyName",
            "in": "path",
            "required": true
          },
          {
            "description": "The new list of references.",
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/MultipleRef"
            }
          },
          {
            "$ref": "#/parameters/CommonTenantParameterQuery"
          }
        ],
        "responses": {
          "200": {
            "description": "References replaced successfully."
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request. Ensure the property exists and is a reference type.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error occurred while trying to fulfill the request. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.manipulate"
        ]
      },
      "post": {
        "description": "Add a reference to a specific property of a data object. \u003cbr/\u003e\u003cbr/\u003e**Note**: This endpoint is deprecated and will be removed in a future version. Use the ` + "`" + `/objects/{className}/{id}/references/{propertyName}` + "`" + ` endpoint instead.",
        "tags": [
          "objects"
        ],
        "summary": "Add an object reference",
        "operationId": "objects.references.create",
        "deprecated": true,
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "Unique UUID of the source object.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Unique name of the reference property of the source object.",
            "name": "propertyName",
            "in": "path",
            "required": true
          },
          {
            "description": "The reference to add.",
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/SingleRef"
            }
          },
          {
            "$ref": "#/parameters/CommonTenantParameterQuery"
          }
        ],
        "responses": {
          "200": {
            "description": "Reference added successfully."
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request. Ensure the property exists and is a reference type.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error occurred while trying to fulfill the request. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.manipulate"
        ]
      },
      "delete": {
        "description": "Delete the single reference that is given in the body from the list of references that this property has. \u003cbr/\u003e\u003cbr/\u003e**Note**: This endpoint is deprecated and will be removed in a future version. Use the ` + "`" + `/objects/{className}/{id}/references/{propertyName}` + "`" + ` endpoint instead.",
        "tags": [
          "objects"
        ],
        "summary": "Delete an object reference",
        "operationId": "objects.references.delete",
        "deprecated": true,
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "Unique UUID of the source object.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Unique name of the reference property of the source object.",
            "name": "propertyName",
            "in": "path",
            "required": true
          },
          {
            "description": "The reference to remove.",
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/SingleRef"
            }
          },
          {
            "$ref": "#/parameters/CommonTenantParameterQuery"
          }
        ],
        "responses": {
          "204": {
            "description": "Reference deleted successfully."
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Object or reference not found.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error occurred while trying to fulfill the request. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.manipulate"
        ]
      }
    },
    "/replication/replicate": {
      "post": {
        "description": "Begins an asynchronous operation to move or copy a specific shard replica from its current node to a designated target node. The operation involves copying data, synchronizing, and potentially decommissioning the source replica.",
        "tags": [
          "replication"
        ],
        "summary": "Initiate a replica movement",
        "operationId": "replicate",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/ReplicationReplicateReplicaRequest"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Replication operation registered successfully. ID of the operation is returned.",
            "schema": {
              "$ref": "#/definitions/ReplicationReplicateReplicaResponse"
            }
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "501": {
            "description": "Replica movement operations are disabled.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.replication.replicate"
        ]
      },
      "delete": {
        "description": "Schedules all replication operations for deletion across all collections, shards, and nodes.",
        "tags": [
          "replication"
        ],
        "summary": "Delete all replication operations",
        "operationId": "deleteAllReplications",
        "responses": {
          "204": {
            "description": "Replication operation registered successfully"
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "501": {
            "description": "Replica movement operations are disabled.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.replication.deleteAllReplications"
        ]
      }
    },
    "/replication/replicate/force-delete": {
      "post": {
        "description": "USE AT OWN RISK! Synchronously force delete operations from the FSM. This will not perform any checks on which state the operation is in so may lead to data corruption or loss. It is recommended to first scale the number of replication engine workers to 0 before calling this endpoint to ensure no operations are in-flight.",
        "tags": [
          "replication"
        ],
        "summary": "Force delete replication operations",
        "operationId": "forceDeleteReplications",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "schema": {
              "$ref": "#/definitions/ReplicationReplicateForceDeleteRequest"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Replication operations force deleted successfully.",
            "schema": {
              "$ref": "#/definitions/ReplicationReplicateForceDeleteResponse"
            }
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.replication.forceDeleteReplications"
        ]
      }
    },
    "/replication/replicate/list": {
      "get": {
        "description": "Retrieves a list of currently registered replication operations, optionally filtered by collection, shard, or node ID.",
        "tags": [
          "replication"
        ],
        "summary": "List replication operations",
        "operationId": "listReplication",
        "parameters": [
          {
            "type": "string",
            "description": "The name of the target node to get details for.",
            "name": "targetNode",
            "in": "query"
          },
          {
            "type": "string",
            "description": "The name of the collection to get details for.",
            "name": "collection",
            "in": "query"
          },
          {
            "type": "string",
            "description": "The shard to get details for.",
            "name": "shard",
            "in": "query"
          },
          {
            "type": "boolean",
            "description": "Whether to include the history of the replication operation.",
            "name": "includeHistory",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "The details of the replication operations.",
            "schema": {
              "type": "array",
              "items": {
                "type": "object",
                "$ref": "#/definitions/ReplicationReplicateDetailsReplicaResponse"
              }
            }
          },
          "400": {
            "description": "Bad request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "501": {
            "description": "Replica movement operations are disabled.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.replication.replicate.details"
        ]
      }
    },
    "/replication/replicate/{id}": {
      "get": {
        "description": "Fetches the current status and detailed information for a specific replication operation, identified by its unique ID. Optionally includes historical data of the operation's progress if requested.",
        "tags": [
          "replication"
        ],
        "summary": "Retrieve a replication operation",
        "operationId": "replicationDetails",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The ID of the replication operation to get details for.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "type": "boolean",
            "description": "Whether to include the history of the replication operation.",
            "name": "includeHistory",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "The details of the replication operation.",
            "schema": {
              "$ref": "#/definitions/ReplicationReplicateDetailsReplicaResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Shard replica operation not found."
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "501": {
            "description": "Replica movement operations are disabled.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.replication.replicate.details"
        ]
      },
      "delete": {
        "description": "Removes a specific replication operation. If the operation is currently active, it will be cancelled and its resources cleaned up before the operation is deleted.",
        "tags": [
          "replication"
        ],
        "summary": "Delete a replication operation",
        "operationId": "deleteReplication",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The ID of the replication operation to delete.",
            "name": "id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "Successfully deleted."
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Shard replica operation not found."
          },
          "409": {
            "description": "The operation is not in a deletable state, e.g. it is a MOVE op in the DEHYDRATING state.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "501": {
            "description": "Replica movement operations are disabled.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.replication.replicate.delete"
        ]
      }
    },
    "/replication/replicate/{id}/cancel": {
      "post": {
        "description": "Requests the cancellation of an active replication operation identified by its ID. The operation will be stopped, but its record will remain in the ` + "`" + `CANCELLED` + "`" + ` state (can't be resumed) and will not be automatically deleted.",
        "tags": [
          "replication"
        ],
        "summary": "Cancel a replication operation",
        "operationId": "cancelReplication",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The ID of the replication operation to cancel.",
            "name": "id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "Successfully cancelled."
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Shard replica operation not found."
          },
          "409": {
            "description": "The operation is not in a cancellable state, e.g. it is READY or is a MOVE op in the DEHYDRATING state.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "501": {
            "description": "Replica movement operations are disabled.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.replication.replicate.cancel"
        ]
      }
    },
    "/replication/scale": {
      "get": {
        "description": "Computes and returns a replication scale plan for a given collection and desired replication factor. The plan includes, for each shard, a list of nodes to be added and a list of nodes to be removed.",
        "produces": [
          "application/json"
        ],
        "tags": [
          "replication"
        ],
        "summary": "Get replication scale plan",
        "operationId": "getReplicationScalePlan",
        "parameters": [
          {
            "type": "string",
            "description": "The collection name to get the scaling plan for.",
            "name": "collection",
            "in": "query",
            "required": true
          },
          {
            "minimum": 1,
            "type": "integer",
            "description": "The desired replication factor to scale to. Must be a positive integer greater than zero.",
            "name": "replicationFactor",
            "in": "query",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Replication scale plan showing node additions and removals per shard.",
            "schema": {
              "$ref": "#/definitions/ReplicationScalePlan"
            }
          },
          "400": {
            "description": "Bad request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Collection not found.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "501": {
            "description": "Replica movement operations are disabled.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.replication.scale.get"
        ]
      },
      "post": {
        "description": "Apply a replication scaling plan that specifies nodes to add or remove per shard for a given collection.",
        "consumes": [
          "application/json"
        ],
        "produces": [
          "application/json"
        ],
        "tags": [
          "replication"
        ],
        "summary": "Apply replication scaling plan",
        "operationId": "applyReplicationScalePlan",
        "parameters": [
          {
            "description": "The replication scaling plan specifying the collection and its shard-level replica adjustments.",
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/ReplicationScalePlan"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "List of replication shard copy operation IDs initiated for the scale operation",
            "schema": {
              "$ref": "#/definitions/ReplicationScaleApplyResponse"
            }
          },
          "400": {
            "description": "Bad request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Collection not found.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "501": {
            "description": "Replica movement operations are disabled.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.replication.scale.post"
        ]
      }
    },
    "/replication/sharding-state": {
      "get": {
        "description": "Fetches the current sharding state, including replica locations and statuses, for all collections or a specified collection. If a shard name is provided along with a collection, the state for that specific shard is returned.",
        "tags": [
          "replication"
        ],
        "summary": "Get sharding state",
        "operationId": "getCollectionShardingState",
        "parameters": [
          {
            "type": "string",
            "description": "The collection name to get the sharding state for.",
            "name": "collection",
            "in": "query"
          },
          {
            "type": "string",
            "description": "The shard to get the sharding state for.",
            "name": "shard",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Successfully retrieved sharding state.",
            "schema": {
              "$ref": "#/definitions/ReplicationShardingStateResponse"
            }
          },
          "400": {
            "description": "Bad request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Collection or shard not found.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "501": {
            "description": "Replica movement operations are disabled.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.replication.shardingstate.collection.get"
        ]
      }
    },
    "/schema": {
      "get": {
        "description": "Retrieves the definitions of all collections (classes) currently in the database schema.",
        "tags": [
          "schema"
        ],
        "summary": "Get all collection definitions",
        "operationId": "schema.dump",
        "parameters": [
          {
            "type": "boolean",
            "default": true,
            "description": "If true, the request is proxied to the cluster leader to ensure strong schema consistency. Default is true.",
            "name": "consistency",
            "in": "header"
          }
        ],
        "responses": {
          "200": {
            "description": "Successfully retrieved the database schema.",
            "schema": {
              "$ref": "#/definitions/Schema"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error occurred while retrieving the schema. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.local.query.meta"
        ]
      },
      "post": {
        "description": "Defines and creates a new collection (class).\u003cbr/\u003e\u003cbr/\u003eIf [` + "`" + `AutoSchema` + "`" + `](https://docs.weaviate.io/weaviate/config-refs/collections#auto-schema) is enabled (not recommended for production), Weaviate might attempt to infer schema from data during import. Manual definition via this endpoint provides explicit control.",
        "tags": [
          "schema"
        ],
        "summary": "Create a new collection",
        "operationId": "schema.objects.create",
        "parameters": [
          {
            "description": "The definition of the collection (class) to create.",
            "name": "objectClass",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/Class"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Collection created successfully and its definition returned.",
            "schema": {
              "$ref": "#/definitions/Class"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid collection definition provided. Check the definition structure and properties.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error occurred during collection creation. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.local.add.meta"
        ]
      }
    },
    "/schema/{className}": {
      "get": {
        "description": "Retrieve the definition of a specific collection (` + "`" + `className` + "`" + `), including its properties, configuration, and vectorizer settings.",
        "tags": [
          "schema"
        ],
        "summary": "Get a single collection",
        "operationId": "schema.objects.get",
        "parameters": [
          {
            "type": "string",
            "description": "The name of the collection (class) to retrieve.",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "type": "boolean",
            "default": true,
            "description": "If true, the request is proxied to the cluster leader to ensure strong schema consistency. Default is true.",
            "name": "consistency",
            "in": "header"
          }
        ],
        "responses": {
          "200": {
            "description": "Successfully retrieved the collection definition.",
            "schema": {
              "$ref": "#/definitions/Class"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Collection not found."
          },
          "500": {
            "description": "An error occurred while retrieving the collection definition. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.local.get.meta"
        ]
      },
      "put": {
        "description": "Updates the configuration settings of an existing collection (` + "`" + `className` + "`" + `) based on the provided definition. Note: This operation modifies mutable settings specified in the request body. It does not add properties (use ` + "`" + `POST /schema/{className}/properties` + "`" + ` for that) or change the collection name.",
        "tags": [
          "schema"
        ],
        "summary": "Update collection definition",
        "operationId": "schema.objects.update",
        "parameters": [
          {
            "type": "string",
            "description": "The name of the collection (class) to update.",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "description": "The updated collection definition containing the settings to modify.",
            "name": "objectClass",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/Class"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Collection settings updated successfully.",
            "schema": {
              "$ref": "#/definitions/Class"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Collection not found.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid update attempt.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error occurred while updating the collection. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.local.manipulate.meta"
        ]
      },
      "delete": {
        "description": "Removes a collection definition from the schema. WARNING: This action permanently deletes all data objects stored within the collection.",
        "tags": [
          "schema"
        ],
        "summary": "Delete a collection (and all associated data)",
        "operationId": "schema.objects.delete",
        "parameters": [
          {
            "type": "string",
            "description": "The name of the collection (class) to delete.",
            "name": "className",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Collection deleted successfully."
          },
          "400": {
            "description": "Could not delete the collection. See the error response for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error occurred during collection deletion. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.local.manipulate.meta"
        ]
      }
    },
    "/schema/{className}/properties": {
      "post": {
        "description": "Adds a new property definition to an existing collection (` + "`" + `className` + "`" + `) definition.",
        "tags": [
          "schema"
        ],
        "summary": "Add a property to a collection",
        "operationId": "schema.objects.properties.add",
        "parameters": [
          {
            "type": "string",
            "description": "The name of the collection (class) to add the property to.",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "description": "The definition of the property to add.",
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/Property"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Property added successfully and its definition returned.",
            "schema": {
              "$ref": "#/definitions/Property"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid property definition provided.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error occurred while adding the property. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.local.manipulate.meta"
        ]
      }
    },
    "/schema/{className}/shards": {
      "get": {
        "description": "Retrieves the status of all shards associated with the specified collection (` + "`" + `className` + "`" + `). For multi-tenant collections, use the ` + "`" + `tenant` + "`" + ` query parameter to retrieve status for a specific tenant's shards.",
        "tags": [
          "schema"
        ],
        "summary": "Get the shards status of a collection",
        "operationId": "schema.objects.shards.get",
        "parameters": [
          {
            "type": "string",
            "description": "The name of the collection (class) whose shards to query.",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "The name of the tenant for which to retrieve shard statuses (only applicable for multi-tenant collections).",
            "name": "tenant",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Shard statuses retrieved successfully.",
            "schema": {
              "$ref": "#/definitions/ShardStatusList"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Collection not found.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error occurred while retrieving shard statuses. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.local.get.meta"
        ]
      }
    },
    "/schema/{className}/shards/{shardName}": {
      "put": {
        "description": "Updates the status of a specific shard within a collection (e.g., sets it to ` + "`" + `READY` + "`" + ` or ` + "`" + `READONLY` + "`" + `). This is typically used after resolving an underlying issue (like disk space) that caused a shard to become non-operational. There is also a convenience function in each client to set the status of all shards of a collection.",
        "tags": [
          "schema"
        ],
        "summary": "Update a shard status",
        "operationId": "schema.objects.shards.update",
        "parameters": [
          {
            "type": "string",
            "description": "The name of the collection (class) containing the shard.",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "The name of the shard to update.",
            "name": "shardName",
            "in": "path",
            "required": true
          },
          {
            "description": "The shard status object containing the desired new status.",
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/ShardStatus"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Shard status updated successfully.",
            "schema": {
              "$ref": "#/definitions/ShardStatus"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Collection or shard not found.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid update attempt",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error occurred while updating the shard status. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.local.manipulate.meta"
        ]
      }
    },
    "/schema/{className}/tenants": {
      "get": {
        "description": "Retrieves a list of all tenants currently associated with the specified collection.",
        "tags": [
          "schema"
        ],
        "summary": "Get the list of tenants",
        "operationId": "tenants.get",
        "parameters": [
          {
            "type": "string",
            "description": "The name of the collection (class) whose tenants to list.",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "type": "boolean",
            "default": true,
            "description": "If true, the request is proxied to the cluster leader to ensure strong schema consistency. Default is true.",
            "name": "consistency",
            "in": "header"
          }
        ],
        "responses": {
          "200": {
            "description": "Successfully retrieved tenants.",
            "schema": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/Tenant"
              }
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error occurred while listing tenants. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        }
      },
      "put": {
        "description": "Updates the activity status (e.g., ` + "`" + `ACTIVE` + "`" + `, ` + "`" + `INACTIVE` + "`" + `, etc.) of one or more specified tenants within a collection (` + "`" + `className` + "`" + `).",
        "tags": [
          "schema"
        ],
        "summary": "Update a tenant",
        "operationId": "tenants.update",
        "parameters": [
          {
            "type": "string",
            "description": "The name of the collection (class) containing the tenants.",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "description": "An array of tenant objects specifying the tenants to update and their desired new status.",
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/Tenant"
              }
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Tenant statuses updated successfully.",
            "schema": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/Tenant"
              }
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid update request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error occurred while updating tenants. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        }
      },
      "post": {
        "description": "Creates one or more new tenants for a specified collection (` + "`" + `className` + "`" + `). Multi-tenancy must be enabled for the collection via its definition.",
        "tags": [
          "schema"
        ],
        "summary": "Create a new tenant",
        "operationId": "tenants.create",
        "parameters": [
          {
            "type": "string",
            "description": "The name of the multi-tenant enabled collection (class).",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "description": "An array of tenant objects to create.",
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/Tenant"
              }
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Tenants created successfully.",
            "schema": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/Tenant"
              }
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error occurred while creating tenants. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        }
      },
      "delete": {
        "description": "Deletes one or more specified tenants from a collection (` + "`" + `className` + "`" + `). WARNING: This action permanently deletes all data associated with the specified tenants.",
        "tags": [
          "schema"
        ],
        "summary": "Delete tenants",
        "operationId": "tenants.delete",
        "parameters": [
          {
            "type": "string",
            "description": "The name of the collection (class) from which to delete tenants.",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "description": "An array of tenant names to delete.",
            "name": "tenants",
            "in": "body",
            "required": true,
            "schema": {
              "type": "array",
              "items": {
                "description": "Name of a tenant to delete.",
                "type": "string"
              }
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Tenants deleted successfully."
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error occurred while deleting tenants. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        }
      }
    },
    "/schema/{className}/tenants/{tenantName}": {
      "get": {
        "description": "Retrieves details about a specific tenant within the given collection (` + "`" + `className` + "`" + `), such as its current activity status.",
        "tags": [
          "schema"
        ],
        "summary": "Get a specific tenant",
        "operationId": "tenants.get.one",
        "parameters": [
          {
            "type": "string",
            "description": "The name of the collection (class) containing the tenant.",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "The name of the tenant to retrieve.",
            "name": "tenantName",
            "in": "path",
            "required": true
          },
          {
            "type": "boolean",
            "default": true,
            "description": "If true, the request is proxied to the cluster leader to ensure strong schema consistency. Default is true.",
            "name": "consistency",
            "in": "header"
          }
        ],
        "responses": {
          "200": {
            "description": "Successfully retrieved tenant details.",
            "schema": {
              "$ref": "#/definitions/Tenant"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Tenant or collection not found."
          },
          "422": {
            "description": "Invalid request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error occurred while retrieving the tenant. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        }
      },
      "head": {
        "description": "Checks for the existence of a specific tenant within the given collection (` + "`" + `className` + "`" + `).",
        "tags": [
          "schema"
        ],
        "summary": "Check if a tenant exists",
        "operationId": "tenant.exists",
        "parameters": [
          {
            "type": "string",
            "description": "The name of the collection (class) to check within.",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "The name of the tenant to check for.",
            "name": "tenantName",
            "in": "path",
            "required": true
          },
          {
            "type": "boolean",
            "default": true,
            "description": "If true, the request is proxied to the cluster leader to ensure strong schema consistency. Default is true.",
            "name": "consistency",
            "in": "header"
          }
        ],
        "responses": {
          "200": {
            "description": "The tenant exists in the specified collection."
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Tenant or collection not found."
          },
          "422": {
            "description": "Invalid request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error occurred during the check. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        }
      }
    },
    "/tasks": {
      "get": {
        "tags": [
          "distributedTasks"
        ],
        "summary": "Lists all distributed tasks in the cluster",
        "operationId": "distributedTasks.get",
        "responses": {
          "200": {
            "description": "Distributed tasks successfully returned.",
            "schema": {
              "$ref": "#/definitions/DistributedTasks"
            }
          },
          "403": {
            "description": "Unauthorized or invalid credentials.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An internal server error occurred while retrieving distributed tasks. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.distributedTasks.get"
        ]
      }
    },
    "/users/db": {
      "get": {
        "description": "Retrieves a list of all database (` + "`" + `db` + "`" + ` user type) users with their roles and status information.",
        "tags": [
          "users"
        ],
        "summary": "List all users",
        "operationId": "listAllUsers",
        "parameters": [
          {
            "type": "boolean",
            "default": false,
            "description": "Whether to include the last time the users were utilized.",
            "name": "includeLastUsedTime",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Info about the users.",
            "schema": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/DBUserInfo"
              }
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.users.db.list_all"
        ]
      }
    },
    "/users/db/{user_id}": {
      "get": {
        "description": "Retrieve detailed information about a specific database user (` + "`" + `db` + "`" + ` user type), including their roles, status, and type.",
        "tags": [
          "users"
        ],
        "summary": "Get user info",
        "operationId": "getUserInfo",
        "parameters": [
          {
            "type": "string",
            "description": "The name of the user.",
            "name": "user_id",
            "in": "path",
            "required": true
          },
          {
            "type": "boolean",
            "default": false,
            "description": "Whether to include the last used time of the given user",
            "name": "includeLastUsedTime",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Info about the user.",
            "schema": {
              "$ref": "#/definitions/DBUserInfo"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "User not found."
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.users.db.get"
        ]
      },
      "post": {
        "description": "Create a new database (` + "`" + `db` + "`" + ` user type) user with the specified name. Returns an API key for the newly created user.",
        "tags": [
          "users"
        ],
        "summary": "Create a new user",
        "operationId": "createUser",
        "parameters": [
          {
            "type": "string",
            "description": "The name of the user.",
            "name": "user_id",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "schema": {
              "type": "object",
              "properties": {
                "createTime": {
                  "description": "EXPERIMENTAL, DONT USE. THIS WILL BE REMOVED AGAIN. - set the given time as creation time",
                  "type": "string",
                  "format": "date-time"
                },
                "import": {
                  "description": "EXPERIMENTAL, DONT USE. THIS WILL BE REMOVED AGAIN. - import api key from static user",
                  "type": "boolean",
                  "default": false
                }
              }
            }
          }
        ],
        "responses": {
          "201": {
            "description": "User created successfully and API key returned.",
            "schema": {
              "$ref": "#/definitions/UserApiKey"
            }
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "User not found.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "409": {
            "description": "A user with the specified name already exists.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.users.db.create"
        ]
      },
      "delete": {
        "description": "Delete a database user. You can't delete your current user.",
        "tags": [
          "users"
        ],
        "summary": "Delete a user",
        "operationId": "deleteUser",
        "parameters": [
          {
            "type": "string",
            "description": "The name of the user.",
            "name": "user_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "Successfully deleted."
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "User not found."
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.users.db.delete"
        ]
      }
    },
    "/users/db/{user_id}/activate": {
      "post": {
        "description": "Activate a deactivated database user (` + "`" + `db` + "`" + ` user type).",
        "tags": [
          "users"
        ],
        "summary": "Activate a user",
        "operationId": "activateUser",
        "parameters": [
          {
            "type": "string",
            "description": "The name of the user.",
            "name": "user_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "User successfully activated."
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "User not found."
          },
          "409": {
            "description": "User already activated."
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.users.db.activateUser"
        ]
      }
    },
    "/users/db/{user_id}/deactivate": {
      "post": {
        "description": "Deactivate a database user (` + "`" + `db` + "`" + ` user type).",
        "tags": [
          "users"
        ],
        "summary": "Deactivate a user",
        "operationId": "deactivateUser",
        "parameters": [
          {
            "type": "string",
            "description": "The name of the user.",
            "name": "user_id",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "schema": {
              "type": "object",
              "properties": {
                "revoke_key": {
                  "description": "Whether the API key should be revoked when deactivating the user.",
                  "type": "boolean",
                  "default": false
                }
              }
            }
          }
        ],
        "responses": {
          "200": {
            "description": "User successfully deactivated."
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "User not found."
          },
          "409": {
            "description": "User already deactivated."
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.users.db.deactivateUser"
        ]
      }
    },
    "/users/db/{user_id}/rotate-key": {
      "post": {
        "description": "Revoke the current API key for the specified database user (` + "`" + `db` + "`" + ` user type) and generate a new one.",
        "tags": [
          "users"
        ],
        "summary": "Rotate API key of a user",
        "operationId": "rotateUserApiKey",
        "parameters": [
          {
            "type": "string",
            "description": "The name of the user.",
            "name": "user_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "API key successfully updated.",
            "schema": {
              "$ref": "#/definitions/UserApiKey"
            }
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "User not found."
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.users.db.rotateApiKey"
        ]
      }
    },
    "/users/own-info": {
      "get": {
        "description": "Get information about the currently authenticated user, including username and assigned roles.",
        "tags": [
          "users"
        ],
        "summary": "Get current user info",
        "operationId": "getOwnInfo",
        "responses": {
          "200": {
            "description": "Info about the user.",
            "schema": {
              "$ref": "#/definitions/UserOwnInfo"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "501": {
            "description": "Replica movement operations are disabled.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.users.get.own-info"
        ]
      }
    }
  },
  "definitions": {
    "AdditionalProperties": {
      "description": "(Response only) Additional meta information about a single object.",
      "type": "object",
      "additionalProperties": {
        "type": "object"
      }
    },
    "Alias": {
      "description": "Represents the mapping between an alias name and a collection. An alias provides an alternative name for accessing a collection.",
      "type": "object",
      "properties": {
        "alias": {
          "description": "The unique name of the alias that serves as an alternative identifier for the collection.",
          "type": "string"
        },
        "class": {
          "description": "The name of the collection (class) to which this alias is mapped.",
          "type": "string"
        }
      }
    },
    "AliasResponse": {
      "description": "Response object containing a list of alias mappings.",
      "type": "object",
      "properties": {
        "aliases": {
          "description": "Array of alias objects, each containing an alias-to-collection mapping.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/Alias"
          }
        }
      }
    },
    "AsyncReplicationStatus": {
      "description": "The status of the async replication.",
      "properties": {
        "objectsPropagated": {
          "description": "The number of objects propagated in the most recent iteration.",
          "type": "number",
          "format": "uint64"
        },
        "startDiffTimeUnixMillis": {
          "description": "The start time of the most recent iteration.",
          "type": "number",
          "format": "int64"
        },
        "targetNode": {
          "description": "The target node of the replication, if set, otherwise empty.",
          "type": "string"
        }
      }
    },
    "BM25Config": {
      "description": "Tuning parameters for the BM25 algorithm.",
      "type": "object",
      "properties": {
        "b": {
          "description": "Calibrates term-weight scaling based on the document length (default: 0.75).",
          "type": "number",
          "format": "float"
        },
        "k1": {
          "description": "Calibrates term-weight scaling based on the term frequency within a document (default: 1.2).",
          "type": "number",
          "format": "float"
        }
      }
    },
    "BackupConfig": {
      "description": "Backup custom configuration.",
      "type": "object",
      "properties": {
        "Bucket": {
          "description": "Name of the bucket, container, volume, etc.",
          "type": "string"
        },
        "CPUPercentage": {
          "description": "Desired CPU core utilization ranging from 1%-80%",
          "type": "integer",
          "default": 50,
          "maximum": 80,
          "minimum": 1,
          "x-nullable": false
        },
        "ChunkSize": {
          "description": "Deprecated, has no effect.",
          "type": "integer",
          "x-deprecated": true,
          "x-nullable": false
        },
        "CompressionLevel": {
          "description": "compression level used by compression algorithm",
          "type": "string",
          "default": "DefaultCompression",
          "enum": [
            "DefaultCompression",
            "BestSpeed",
            "BestCompression",
            "ZstdDefaultCompression",
            "ZstdBestSpeed",
            "ZstdBestCompression",
            "NoCompression"
          ],
          "x-nullable": false
        },
        "Endpoint": {
          "description": "Name of the endpoint, e.g. s3.amazonaws.com.",
          "type": "string"
        },
        "Path": {
          "description": "Path or key within the bucket.",
          "type": "string"
        }
      }
    },
    "BackupCreateRequest": {
      "description": "Request body for creating a backup for a set of collections.",
      "properties": {
        "config": {
          "description": "Custom configuration for the backup creation process",
          "type": "object",
          "$ref": "#/definitions/BackupConfig"
        },
        "exclude": {
          "description": "List of collections to exclude from the backup creation process. If not set, all collections are included. Cannot be used together with ` + "`" + `include` + "`" + `.",
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "id": {
          "description": "The ID of the backup (required). Must be URL-safe and work as a filesystem path, only lowercase, numbers, underscore, minus characters allowed.",
          "type": "string"
        },
        "include": {
          "description": "List of collections to include in the backup creation process. If not set, all collections are included. Cannot be used together with ` + "`" + `exclude` + "`" + `.",
          "type": "array",
          "items": {
            "type": "string"
          }
        }
      }
    },
    "BackupCreateResponse": {
      "description": "The definition of a backup create response body",
      "properties": {
        "backend": {
          "description": "Backup backend name e.g. filesystem, gcs, s3.",
          "type": "string"
        },
        "bucket": {
          "description": "Name of the bucket, container, volume, etc",
          "type": "string"
        },
        "classes": {
          "description": "The list of collections (classes) for which the backup creation process was started.",
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "error": {
          "description": "error message if creation failed",
          "type": "string"
        },
        "id": {
          "description": "The ID of the backup. Must be URL-safe and work as a filesystem path, only lowercase, numbers, underscore, minus characters allowed.",
          "type": "string"
        },
        "path": {
          "description": "Path within bucket of backup",
          "type": "string"
        },
        "status": {
          "description": "phase of backup creation process",
          "type": "string",
          "default": "STARTED",
          "enum": [
            "STARTED",
            "TRANSFERRING",
            "TRANSFERRED",
            "SUCCESS",
            "FAILED",
            "CANCELED"
          ]
        }
      }
    },
    "BackupCreateStatusResponse": {
      "description": "The definition of a backup create metadata",
      "properties": {
        "backend": {
          "description": "Backup backend name e.g. filesystem, gcs, s3.",
          "type": "string"
        },
        "completedAt": {
          "description": "Timestamp when the backup process completed (successfully or with failure)",
          "type": "string",
          "format": "date-time"
        },
        "error": {
          "description": "error message if creation failed",
          "type": "string"
        },
        "id": {
          "description": "The ID of the backup. Must be URL-safe and work as a filesystem path, only lowercase, numbers, underscore, minus characters allowed.",
          "type": "string"
        },
        "path": {
          "description": "Destination path of backup files valid for the selected backend.",
          "type": "string"
        },
        "size": {
          "description": "Size of the backup in Gibs",
          "type": "number",
          "format": "float64"
        },
        "startedAt": {
          "description": "Timestamp when the backup process started",
          "type": "string",
          "format": "date-time"
        },
        "status": {
          "description": "phase of backup creation process",
          "type": "string",
          "default": "STARTED",
          "enum": [
            "STARTED",
            "TRANSFERRING",
            "TRANSFERRED",
            "SUCCESS",
            "FAILED",
            "CANCELED"
          ]
        }
      }
    },
    "BackupListResponse": {
      "description": "The definition of a backup create response body.",
      "type": "array",
      "items": {
        "type": "object",
        "properties": {
          "classes": {
            "description": "The list of collections (classes) for which the backup process was started.",
            "type": "array",
            "items": {
              "type": "string"
            }
          },
          "completedAt": {
            "description": "Timestamp when the backup process completed (successfully or with failure)",
            "type": "string",
            "format": "date-time"
          },
          "id": {
            "description": "The ID of the backup. Must be URL-safe and work as a filesystem path, only lowercase, numbers, underscore, minus characters allowed.",
            "type": "string"
          },
          "size": {
            "description": "Size of the backup in Gibs",
            "type": "number",
            "format": "float64"
          },
          "startedAt": {
            "description": "Timestamp when the backup process started",
            "type": "string",
            "format": "date-time"
          },
          "status": {
            "description": "Status of backup process.",
            "type": "string",
            "enum": [
              "STARTED",
              "TRANSFERRING",
              "TRANSFERRED",
              "SUCCESS",
              "FAILED",
              "CANCELED"
            ]
          }
        }
      }
    },
    "BackupRestoreRequest": {
      "description": "Request body for restoring a backup for a set of collections (classes).",
      "properties": {
        "config": {
          "description": "Custom configuration for the backup restoration process.",
          "type": "object",
          "$ref": "#/definitions/RestoreConfig"
        },
        "exclude": {
          "description": "List of collections (classes) to exclude from the backup restoration process.",
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "include": {
          "description": "List of collections (classes) to include in the backup restoration process.",
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "node_mapping": {
          "description": "Allows overriding the node names stored in the backup with different ones. Useful when restoring backups to a different environment.",
          "type": "object",
          "additionalProperties": {
            "type": "string"
          }
        },
        "overwriteAlias": {
          "description": "Allows ovewriting the collection alias if there is a conflict",
          "type": "boolean"
        }
      }
    },
    "BackupRestoreResponse": {
      "description": "The definition of a backup restore response body.",
      "properties": {
        "backend": {
          "description": "Backup backend name e.g. filesystem, gcs, s3.",
          "type": "string"
        },
        "classes": {
          "description": "The list of collections (classes) for which the backup restoration process was started.",
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "error": {
          "description": "Error message if backup restoration failed.",
          "type": "string"
        },
        "id": {
          "description": "The ID of the backup. Must be URL-safe and work as a filesystem path, only lowercase, numbers, underscore, minus characters allowed.",
          "type": "string"
        },
        "path": {
          "description": "Destination path of backup files valid for the selected backend.",
          "type": "string"
        },
        "status": {
          "description": "Phase of backup restoration process.",
          "type": "string",
          "default": "STARTED",
          "enum": [
            "STARTED",
            "TRANSFERRING",
            "TRANSFERRED",
            "SUCCESS",
            "FAILED",
            "CANCELED"
          ]
        }
      }
    },
    "BackupRestoreStatusResponse": {
      "description": "The definition of a backup restore metadata.",
      "properties": {
        "backend": {
          "description": "Backup backend name e.g. filesystem, gcs, s3.",
          "type": "string"
        },
        "error": {
          "description": "Error message if backup restoration failed.",
          "type": "string"
        },
        "id": {
          "description": "The ID of the backup. Must be URL-safe and work as a filesystem path, only lowercase, numbers, underscore, minus characters allowed.",
          "type": "string"
        },
        "path": {
          "description": "Destination path of backup files valid for the selected backup backend, contains bucket and path.",
          "type": "string"
        },
        "status": {
          "description": "Phase of backup restoration process.",
          "type": "string",
          "default": "STARTED",
          "enum": [
            "STARTED",
            "TRANSFERRING",
            "TRANSFERRED",
            "SUCCESS",
            "FAILED",
            "CANCELED"
          ]
        }
      }
    },
    "BatchDelete": {
      "type": "object",
      "properties": {
        "deletionTimeUnixMilli": {
          "description": "Timestamp of deletion in milliseconds since epoch UTC.",
          "type": "integer",
          "format": "int64",
          "x-nullable": true
        },
        "dryRun": {
          "description": "If true, the call will show which objects would be matched using the specified filter without deleting any objects. \u003cbr/\u003e\u003cbr/\u003eDepending on the configured verbosity, you will either receive a count of affected objects, or a list of IDs.",
          "type": "boolean",
          "default": false
        },
        "match": {
          "description": "Outlines how to find the objects to be deleted.",
          "type": "object",
          "properties": {
            "class": {
              "description": "The name of the collection (class) from which to delete objects.",
              "type": "string",
              "example": "City"
            },
            "where": {
              "description": "Filter to limit the objects to be deleted.",
              "type": "object",
              "$ref": "#/definitions/WhereFilter"
            }
          }
        },
        "output": {
          "description": "Controls the verbosity of the output, possible values are: ` + "`" + `minimal` + "`" + `, ` + "`" + `verbose` + "`" + `. Defaults to ` + "`" + `minimal` + "`" + `.",
          "type": "string",
          "default": "minimal"
        }
      }
    },
    "BatchDeleteResponse": {
      "description": "Delete Objects response.",
      "type": "object",
      "properties": {
        "deletionTimeUnixMilli": {
          "description": "Timestamp of deletion in milliseconds since epoch UTC.",
          "type": "integer",
          "format": "int64",
          "x-nullable": true
        },
        "dryRun": {
          "description": "If true, objects will not be deleted yet, but merely listed. Defaults to false.",
          "type": "boolean",
          "default": false
        },
        "match": {
          "description": "Outlines how to find the objects to be deleted.",
          "type": "object",
          "properties": {
            "class": {
              "description": "The name of the collection (class) from which to delete objects.",
              "type": "string",
              "example": "City"
            },
            "where": {
              "description": "Filter to limit the objects to be deleted.",
              "type": "object",
              "$ref": "#/definitions/WhereFilter"
            }
          }
        },
        "output": {
          "description": "Controls the verbosity of the output, possible values are: ` + "`" + `minimal` + "`" + `, ` + "`" + `verbose` + "`" + `. Defaults to ` + "`" + `minimal` + "`" + `.",
          "type": "string",
          "default": "minimal"
        },
        "results": {
          "type": "object",
          "properties": {
            "failed": {
              "description": "How many objects should have been deleted but could not be deleted.",
              "type": "number",
              "format": "int64",
              "x-omitempty": false
            },
            "limit": {
              "description": "The most amount of objects that can be deleted in a single query, equals [` + "`" + `QUERY_MAXIMUM_RESULTS` + "`" + `](https://docs.weaviate.io/deploy/configuration/env-vars#QUERY_MAXIMUM_RESULTS).",
              "type": "number",
              "format": "int64",
              "x-omitempty": false
            },
            "matches": {
              "description": "How many objects were matched by the filter.",
              "type": "number",
              "format": "int64",
              "x-omitempty": false
            },
            "objects": {
              "description": "With output set to ` + "`" + `minimal` + "`" + ` only objects with error occurred will the be described. Successfully deleted objects would be omitted. Output set to ` + "`" + `verbose` + "`" + ` will list all of the objects with their respective statuses.",
              "type": "array",
              "items": {
                "description": "Results for this specific Object.",
                "format": "object",
                "properties": {
                  "errors": {
                    "$ref": "#/definitions/ErrorResponse"
                  },
                  "id": {
                    "description": "The UUID of the object.",
                    "type": "string",
                    "format": "uuid"
                  },
                  "status": {
                    "type": "string",
                    "default": "SUCCESS",
                    "enum": [
                      "SUCCESS",
                      "DRYRUN",
                      "FAILED"
                    ]
                  }
                }
              }
            },
            "successful": {
              "description": "How many objects were successfully deleted in this round.",
              "type": "number",
              "format": "int64",
              "x-omitempty": false
            }
          }
        }
      }
    },
    "BatchReference": {
      "properties": {
        "from": {
          "description": "Long-form beacon-style URI to identify the source of the cross-reference, including the property name. Should be in the form of ` + "`" + `weaviate://localhost/objects/\u003cuuid\u003e/\u003cclassName\u003e/\u003cpropertyName\u003e` + "`" + `, where ` + "`" + `\u003cclassName\u003e` + "`" + ` and ` + "`" + `\u003cpropertyName\u003e` + "`" + ` must represent the cross-reference property of the source class to be used.",
          "type": "string",
          "format": "uri",
          "example": "weaviate://localhost/Zoo/a5d09582-4239-4702-81c9-92a6e0122bb4/hasAnimals"
        },
        "tenant": {
          "description": "Name of the reference tenant.",
          "type": "string"
        },
        "to": {
          "description": "Short-form URI to point to the cross-reference. Should be in the form of ` + "`" + `weaviate://localhost/\u003cuuid\u003e` + "`" + ` for the example of a local cross-reference to an object.",
          "type": "string",
          "format": "uri",
          "example": "weaviate://localhost/97525810-a9a5-4eb0-858a-71449aeb007f"
        }
      }
    },
    "BatchReferenceResponse": {
      "type": "object",
      "allOf": [
        {
          "$ref": "#/definitions/BatchReference"
        },
        {
          "properties": {
            "result": {
              "description": "Results for this specific reference.",
              "format": "object",
              "properties": {
                "errors": {
                  "$ref": "#/definitions/ErrorResponse"
                },
                "status": {
                  "type": "string",
                  "default": "SUCCESS",
                  "enum": [
                    "SUCCESS",
                    "FAILED"
                  ]
                }
              }
            }
          }
        }
      ]
    },
    "BatchStats": {
      "description": "The summary of a nodes batch queue congestion status.",
      "properties": {
        "queueLength": {
          "description": "How many objects are currently in the batch queue.",
          "type": "number",
          "format": "int",
          "x-nullable": true,
          "x-omitempty": true
        },
        "ratePerSecond": {
          "description": "How many objects are approximately processed from the batch queue per second.",
          "type": "number",
          "format": "int",
          "x-omitempty": false
        }
      }
    },
    "C11yExtension": {
      "description": "A resource describing an extension to the contextinoary, containing both the identifier and the definition of the extension",
      "properties": {
        "concept": {
          "description": "The new concept you want to extend. Must be an all-lowercase single word, or a space delimited compound word. Examples: 'foobarium', 'my custom concept'",
          "type": "string",
          "example": "foobarium"
        },
        "definition": {
          "description": "A list of space-delimited words or a sentence describing what the custom concept is about. Avoid using the custom concept itself. An Example definition for the custom concept 'foobarium': would be 'a naturally occurring element which can only be seen by programmers'",
          "type": "string"
        },
        "weight": {
          "description": "Weight of the definition of the new concept where 1='override existing definition entirely' and 0='ignore custom definition'. Note that if the custom concept is not present in the contextionary yet, the weight cannot be less than 1.",
          "type": "number",
          "format": "float"
        }
      }
    },
    "C11yNearestNeighbors": {
      "description": "C11y function to show the nearest neighbors to a word.",
      "type": "array",
      "items": {
        "type": "object",
        "properties": {
          "distance": {
            "type": "number",
            "format": "float"
          },
          "word": {
            "type": "string"
          }
        }
      }
    },
    "C11yVector": {
      "description": "A vector representation of the object in the Contextionary. If provided at object creation, this wil take precedence over any vectorizer setting.",
      "type": "array",
      "items": {
        "type": "number",
        "format": "float"
      }
    },
    "C11yVectorBasedQuestion": {
      "description": "Receive question based on array of collection names (classes), properties and values.",
      "type": "array",
      "items": {
        "type": "object",
        "properties": {
          "classProps": {
            "description": "Vectorized properties.",
            "type": "array",
            "maxItems": 300,
            "minItems": 300,
            "items": {
              "type": "object",
              "properties": {
                "propsVectors": {
                  "type": "array",
                  "items": {
                    "type": "number",
                    "format": "float"
                  }
                },
                "value": {
                  "description": "String with valuename.",
                  "type": "string"
                }
              }
            }
          },
          "classVectors": {
            "description": "Vectorized collection (class) name.",
            "type": "array",
            "maxItems": 300,
            "minItems": 300,
            "items": {
              "type": "number",
              "format": "float"
            }
          }
        }
      }
    },
    "C11yWordsResponse": {
      "description": "An array of available words and contexts.",
      "properties": {
        "concatenatedWord": {
          "description": "Weighted results for all words",
          "type": "object",
          "properties": {
            "concatenatedNearestNeighbors": {
              "$ref": "#/definitions/C11yNearestNeighbors"
            },
            "concatenatedVector": {
              "$ref": "#/definitions/C11yVector"
            },
            "concatenatedWord": {
              "type": "string"
            },
            "singleWords": {
              "type": "array",
              "items": {
                "format": "string"
              }
            }
          }
        },
        "individualWords": {
          "description": "Weighted results for per individual word",
          "type": "array",
          "items": {
            "type": "object",
            "properties": {
              "info": {
                "type": "object",
                "properties": {
                  "nearestNeighbors": {
                    "$ref": "#/definitions/C11yNearestNeighbors"
                  },
                  "vector": {
                    "$ref": "#/definitions/C11yVector"
                  }
                }
              },
              "present": {
                "type": "boolean"
              },
              "word": {
                "type": "string"
              }
            }
          }
        }
      }
    },
    "Class": {
      "type": "object",
      "properties": {
        "class": {
          "description": "Name of the collection (formerly 'class') (required). Multiple words should be concatenated in CamelCase, e.g. ` + "`" + `ArticleAuthor` + "`" + `.",
          "type": "string"
        },
        "description": {
          "description": "Description of the collection for metadata purposes.",
          "type": "string"
        },
        "invertedIndexConfig": {
          "$ref": "#/definitions/InvertedIndexConfig"
        },
        "moduleConfig": {
          "description": "Configuration specific to modules in a collection context.",
          "type": "object"
        },
        "multiTenancyConfig": {
          "$ref": "#/definitions/MultiTenancyConfig"
        },
        "objectTtlConfig": {
          "$ref": "#/definitions/ObjectTtlConfig"
        },
        "properties": {
          "description": "Define properties of the collection.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/Property"
          }
        },
        "replicationConfig": {
          "$ref": "#/definitions/ReplicationConfig"
        },
        "shardingConfig": {
          "description": "Manage how the index should be sharded and distributed in the cluster",
          "type": "object"
        },
        "vectorConfig": {
          "description": "Configure named vectors. Either use this field or ` + "`" + `vectorizer` + "`" + `, ` + "`" + `vectorIndexType` + "`" + `, and ` + "`" + `vectorIndexConfig` + "`" + ` fields. Available from ` + "`" + `v1.24.0` + "`" + `.",
          "type": "object",
          "additionalProperties": {
            "$ref": "#/definitions/VectorConfig"
          }
        },
        "vectorIndexConfig": {
          "description": "Vector-index config, that is specific to the type of index selected in vectorIndexType",
          "type": "object"
        },
        "vectorIndexType": {
          "description": "Name of the vector index type to use for the collection (e.g. ` + "`" + `hnsw` + "`" + ` or ` + "`" + `flat` + "`" + `).",
          "type": "string"
        },
        "vectorizer": {
          "description": "Specify how the vectors for this collection should be determined. The options are either ` + "`" + `none` + "`" + ` - this means you have to import a vector with each object yourself - or the name of a module that provides vectorization capabilities, such as ` + "`" + `text2vec-weaviate` + "`" + `. If left empty, it will use the globally configured default ([` + "`" + `DEFAULT_VECTORIZER_MODULE` + "`" + `](https://docs.weaviate.io/deploy/configuration/env-vars)) which can itself either be ` + "`" + `none` + "`" + ` or a specific module.",
          "type": "string"
        }
      }
    },
    "Classification": {
      "description": "Manage classifications, trigger them and view status of past classifications.",
      "type": "object",
      "properties": {
        "basedOnProperties": {
          "description": "Base the text-based classification on these fields (of type text).",
          "type": "array",
          "items": {
            "type": "string"
          },
          "example": [
            "description"
          ]
        },
        "class": {
          "description": "The name of the collection (class) which is used in this classification.",
          "type": "string",
          "example": "City"
        },
        "classifyProperties": {
          "description": "Which ref-property to set as part of the classification.",
          "type": "array",
          "items": {
            "type": "string"
          },
          "example": [
            "inCountry"
          ]
        },
        "error": {
          "description": "Error message if status == failed.",
          "type": "string",
          "default": "",
          "example": "classify xzy: something went wrong"
        },
        "filters": {
          "type": "object",
          "properties": {
            "sourceWhere": {
              "description": "Limit the objects to be classified.",
              "type": "object",
              "$ref": "#/definitions/WhereFilter"
            },
            "targetWhere": {
              "description": "Limit the possible sources when using an algorithm which doesn't really on training data, e.g. 'contextual'. When using an algorithm with a training set, such as 'knn', limit the training set instead.",
              "type": "object",
              "$ref": "#/definitions/WhereFilter"
            },
            "trainingSetWhere": {
              "description": "Limit the training objects to be considered during the classification. Can only be used on types with explicit training sets, such as 'knn'.",
              "type": "object",
              "$ref": "#/definitions/WhereFilter"
            }
          }
        },
        "id": {
          "description": "ID to uniquely identify this classification run.",
          "type": "string",
          "format": "uuid",
          "example": "ee722219-b8ec-4db1-8f8d-5150bb1a9e0c"
        },
        "meta": {
          "description": "Additional meta information about the classification.",
          "type": "object",
          "$ref": "#/definitions/ClassificationMeta"
        },
        "settings": {
          "description": "Classification-type specific settings.",
          "type": "object"
        },
        "status": {
          "description": "Status of this classification.",
          "type": "string",
          "enum": [
            "running",
            "completed",
            "failed"
          ],
          "example": "running"
        },
        "type": {
          "description": "Which algorithm to use for classifications.",
          "type": "string"
        }
      }
    },
    "ClassificationMeta": {
      "description": "Additional information to a specific classification.",
      "type": "object",
      "properties": {
        "completed": {
          "description": "Time when this classification finished.",
          "type": "string",
          "format": "date-time",
          "example": "2017-07-21T17:32:28Z"
        },
        "count": {
          "description": "Number of objects which were taken into consideration for classification.",
          "type": "integer",
          "example": 147
        },
        "countFailed": {
          "description": "Number of objects which could not be classified - see error message for details.",
          "type": "integer",
          "example": 7
        },
        "countSucceeded": {
          "description": "Number of objects successfully classified.",
          "type": "integer",
          "example": 140
        },
        "started": {
          "description": "Time when this classification was started.",
          "type": "string",
          "format": "date-time",
          "example": "2017-07-21T17:32:28Z"
        }
      }
    },
    "ClusterStatisticsResponse": {
      "description": "The cluster statistics of all of the Weaviate nodes",
      "type": "object",
      "properties": {
        "statistics": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/Statistics"
          }
        },
        "synchronized": {
          "type": "boolean",
          "x-omitempty": false
        }
      }
    },
    "DBUserInfo": {
      "type": "object",
      "required": [
        "userId",
        "dbUserType",
        "roles",
        "active"
      ],
      "properties": {
        "active": {
          "description": "Activity status of the returned user.",
          "type": "boolean"
        },
        "apiKeyFirstLetters": {
          "description": "First 3 letters of the associated API key.",
          "type": [
            "string",
            "null"
          ],
          "maxLength": 3
        },
        "createdAt": {
          "description": "Date and time in ISO 8601 format: YYYY-MM-DDTHH:MM:SSZ.",
          "type": [
            "string",
            "null"
          ],
          "format": "date-time"
        },
        "dbUserType": {
          "description": "Type of the returned user.",
          "type": "string",
          "enum": [
            "db_user",
            "db_env_user"
          ]
        },
        "lastUsedAt": {
          "description": "Date and time in ISO 8601 format: YYYY-MM-DDTHH:MM:SSZ.",
          "type": [
            "string",
            "null"
          ],
          "format": "date-time"
        },
        "roles": {
          "description": "The roles associated with the user.",
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "userId": {
          "description": "The name (ID) of the user.",
          "type": "string"
        }
      }
    },
    "Deprecation": {
      "type": "object",
      "properties": {
        "apiType": {
          "description": "Describes which API is affected, usually one of: REST, GraphQL and gRPC.",
          "type": "string"
        },
        "id": {
          "description": "The id that uniquely identifies this particular deprecation (mostly used internally).",
          "type": "string"
        },
        "locations": {
          "description": "The locations within the specified API affected by this deprecation.",
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "mitigation": {
          "description": "User-required object to not be affected by the (planned) removal.",
          "type": "string"
        },
        "msg": {
          "description": "What this deprecation is about.",
          "type": "string"
        },
        "plannedRemovalVersion": {
          "description": "A best-effort guess of which upcoming version will remove the feature entirely.",
          "type": "string"
        },
        "removedIn": {
          "description": "If the feature has already been removed, it was removed in this version.",
          "type": "string",
          "x-nullable": true
        },
        "removedTime": {
          "description": "If the feature has already been removed, it was removed at this timestamp.",
          "type": "string",
          "format": "date-time",
          "x-nullable": true
        },
        "sinceTime": {
          "description": "The deprecation was introduced at this timestamp.",
          "type": "string",
          "format": "date-time"
        },
        "sinceVersion": {
          "description": "The deprecation was introduced in this version.",
          "type": "string"
        },
        "status": {
          "description": "Whether the problematic API functionality is deprecated (planned to be removed) or already removed.",
          "type": "string"
        }
      }
    },
    "DistributedTask": {
      "description": "Distributed task metadata.",
      "type": "object",
      "properties": {
        "error": {
          "description": "The high level reason why the task failed.",
          "type": "string",
          "x-omitempty": true
        },
        "finishedAt": {
          "description": "The time when the task was finished.",
          "type": "string",
          "format": "date-time"
        },
        "finishedNodes": {
          "description": "The nodes that finished the task.",
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "id": {
          "description": "The ID of the task.",
          "type": "string"
        },
        "payload": {
          "description": "The payload of the task.",
          "type": "object"
        },
        "startedAt": {
          "description": "The time when the task was created.",
          "type": "string",
          "format": "date-time"
        },
        "status": {
          "description": "The status of the task.",
          "type": "string"
        },
        "version": {
          "description": "The version of the task.",
          "type": "integer"
        }
      }
    },
    "DistributedTasks": {
      "description": "Active distributed tasks by namespace.",
      "type": "object",
      "additionalProperties": {
        "type": "array",
        "items": {
          "$ref": "#/definitions/DistributedTask"
        }
      }
    },
    "ErrorResponse": {
      "description": "An error response returned by Weaviate endpoints.",
      "type": "object",
      "properties": {
        "error": {
          "type": "array",
          "items": {
            "type": "object",
            "properties": {
              "message": {
                "type": "string"
              }
            }
          }
        }
      }
    },
    "GeoCoordinates": {
      "properties": {
        "latitude": {
          "description": "The latitude of the point on earth in decimal form.",
          "type": "number",
          "format": "float",
          "x-nullable": true
        },
        "longitude": {
          "description": "The longitude of the point on earth in decimal form.",
          "type": "number",
          "format": "float",
          "x-nullable": true
        }
      }
    },
    "GraphQLError": {
      "description": "An error response caused by a GraphQL query.",
      "properties": {
        "locations": {
          "type": "array",
          "items": {
            "type": "object",
            "properties": {
              "column": {
                "type": "integer",
                "format": "int64"
              },
              "line": {
                "type": "integer",
                "format": "int64"
              }
            }
          }
        },
        "message": {
          "type": "string"
        },
        "path": {
          "type": "array",
          "items": {
            "type": "string"
          }
        }
      }
    },
    "GraphQLQueries": {
      "description": "A list of GraphQL queries.",
      "type": "array",
      "items": {
        "$ref": "#/definitions/GraphQLQuery"
      }
    },
    "GraphQLQuery": {
      "description": "GraphQL query based on: http://facebook.github.io/graphql/.",
      "type": "object",
      "properties": {
        "operationName": {
          "description": "The name of the operation if multiple exist in the query.",
          "type": "string"
        },
        "query": {
          "description": "Query based on GraphQL syntax.",
          "type": "string"
        },
        "variables": {
          "description": "Additional variables for the query.",
          "type": "object"
        }
      }
    },
    "GraphQLResponse": {
      "description": "GraphQL based response: http://facebook.github.io/graphql/.",
      "properties": {
        "data": {
          "description": "GraphQL data object.",
          "type": "object",
          "additionalProperties": {
            "$ref": "#/definitions/JsonObject"
          }
        },
        "errors": {
          "description": "Array with errors.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/GraphQLError"
          },
          "x-omitempty": true
        }
      }
    },
    "GraphQLResponses": {
      "description": "A list of GraphQL responses.",
      "type": "array",
      "items": {
        "$ref": "#/definitions/GraphQLResponse"
      }
    },
    "GroupType": {
      "description": "If the group contains OIDC or database users.",
      "type": "string",
      "enum": [
        "oidc"
      ]
    },
    "InvertedIndexConfig": {
      "description": "Configure the inverted index built into Weaviate. See [Reference: Inverted index](https://docs.weaviate.io/weaviate/config-refs/indexing/inverted-index#inverted-index-parameters) for details.",
      "type": "object",
      "properties": {
        "bm25": {
          "$ref": "#/definitions/BM25Config"
        },
        "cleanupIntervalSeconds": {
          "description": "Asynchronous index clean up happens every n seconds (default: 60).",
          "type": "number",
          "format": "int"
        },
        "indexNullState": {
          "description": "Index each object with the null state (default: ` + "`" + `false` + "`" + `).",
          "type": "boolean"
        },
        "indexPropertyLength": {
          "description": "Index length of properties (default: ` + "`" + `false` + "`" + `).",
          "type": "boolean"
        },
        "indexTimestamps": {
          "description": "Index each object by its internal timestamps (default: ` + "`" + `false` + "`" + `).",
          "type": "boolean"
        },
        "stopwords": {
          "$ref": "#/definitions/StopwordConfig"
        },
        "tokenizerUserDict": {
          "description": "User-defined dictionary for tokenization.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/TokenizerUserDictConfig"
          },
          "x-omitempty": true
        },
        "usingBlockMaxWAND": {
          "description": "Using BlockMax WAND for query execution (default: ` + "`" + `false` + "`" + `, will be ` + "`" + `true` + "`" + ` for new collections created after 1.30).",
          "type": "boolean"
        }
      }
    },
    "JsonObject": {
      "description": "JSON object value.",
      "type": "object"
    },
    "Link": {
      "type": "object",
      "properties": {
        "documentationHref": {
          "description": "Weaviate documentation about this resource group.",
          "type": "string"
        },
        "href": {
          "description": "Target of the link.",
          "type": "string"
        },
        "name": {
          "description": "Human readable name of the resource group.",
          "type": "string"
        },
        "rel": {
          "description": "Relationship if both resources are related, e.g. 'next', 'previous', 'parent', etc.",
          "type": "string"
        }
      }
    },
    "Meta": {
      "description": "Contains meta information of the current Weaviate instance.",
      "type": "object",
      "properties": {
        "grpcMaxMessageSize": {
          "description": "Max message size for GRPC connection in bytes.",
          "type": "integer"
        },
        "hostname": {
          "description": "The url of the host.",
          "type": "string",
          "format": "url"
        },
        "modules": {
          "description": "Module-specific meta information.",
          "type": "object"
        },
        "version": {
          "description": "The Weaviate server version.",
          "type": "string"
        }
      }
    },
    "MultiTenancyConfig": {
      "description": "Configuration related to multi-tenancy within a collection (class)",
      "properties": {
        "autoTenantActivation": {
          "description": "Existing tenants should (not) be turned HOT implicitly when they are accessed and in another activity status (default: ` + "`" + `false` + "`" + `).",
          "type": "boolean",
          "x-omitempty": false
        },
        "autoTenantCreation": {
          "description": "Nonexistent tenants should (not) be created implicitly (default: ` + "`" + `false` + "`" + `).",
          "type": "boolean",
          "x-omitempty": false
        },
        "enabled": {
          "description": "Whether or not multi-tenancy is enabled for this collection (class) (default: ` + "`" + `false` + "`" + `).",
          "type": "boolean",
          "x-omitempty": false
        }
      }
    },
    "MultipleRef": {
      "description": "Multiple instances of references to other objects.",
      "type": "array",
      "items": {
        "$ref": "#/definitions/SingleRef"
      }
    },
    "NestedProperty": {
      "type": "object",
      "properties": {
        "dataType": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "description": {
          "type": "string"
        },
        "indexFilterable": {
          "type": "boolean",
          "x-nullable": true
        },
        "indexRangeFilters": {
          "type": "boolean",
          "x-nullable": true
        },
        "indexSearchable": {
          "type": "boolean",
          "x-nullable": true
        },
        "name": {
          "type": "string"
        },
        "nestedProperties": {
          "description": "The properties of the nested object(s). Applies to object and object[] data types.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/NestedProperty"
          },
          "x-omitempty": true
        },
        "tokenization": {
          "type": "string",
          "enum": [
            "word",
            "lowercase",
            "whitespace",
            "field",
            "trigram",
            "gse",
            "kagome_kr",
            "kagome_ja",
            "gse_ch"
          ]
        }
      }
    },
    "NodeShardStatus": {
      "description": "The definition of a node shard status response body",
      "properties": {
        "asyncReplicationStatus": {
          "description": "The status of the async replication.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/AsyncReplicationStatus"
          }
        },
        "class": {
          "description": "The name of shard's collection (class).",
          "type": "string",
          "x-omitempty": false
        },
        "compressed": {
          "description": "The status of vector compression/quantization.",
          "type": "boolean",
          "x-omitempty": false
        },
        "loaded": {
          "description": "The load status of the shard.",
          "type": "boolean",
          "x-omitempty": false
        },
        "name": {
          "description": "The name of the shard.",
          "type": "string",
          "x-omitempty": false
        },
        "numberOfReplicas": {
          "description": "Number of replicas for the shard.",
          "type": [
            "integer",
            "null"
          ],
          "format": "int64",
          "x-omitempty": true
        },
        "objectCount": {
          "description": "The number of objects in shard.",
          "type": "number",
          "format": "int64",
          "x-omitempty": false
        },
        "replicationFactor": {
          "description": "Minimum number of replicas for the shard.",
          "type": [
            "integer",
            "null"
          ],
          "format": "int64",
          "x-omitempty": true
        },
        "vectorIndexingStatus": {
          "description": "The status of the vector indexing process.",
          "type": "string",
          "x-omitempty": false
        },
        "vectorQueueLength": {
          "description": "The length of the vector indexing queue.",
          "type": "number",
          "format": "int64",
          "x-omitempty": false
        }
      }
    },
    "NodeStats": {
      "description": "The summary of Weaviate's statistics.",
      "properties": {
        "objectCount": {
          "description": "The total number of objects in DB.",
          "type": "number",
          "format": "int64",
          "x-omitempty": false
        },
        "shardCount": {
          "description": "The count of Weaviate's shards. To see this value, set ` + "`" + `output` + "`" + ` to ` + "`" + `verbose` + "`" + `.",
          "type": "number",
          "format": "int",
          "x-omitempty": false
        }
      }
    },
    "NodeStatus": {
      "description": "The definition of a backup node status response body",
      "properties": {
        "batchStats": {
          "description": "Weaviate batch statistics.",
          "type": "object",
          "$ref": "#/definitions/BatchStats"
        },
        "gitHash": {
          "description": "The gitHash of Weaviate.",
          "type": "string"
        },
        "name": {
          "description": "The name of the node.",
          "type": "string"
        },
        "operationalMode": {
          "description": "Which mode of operation the node is running in.",
          "type": "string",
          "enum": [
            "ReadWrite",
            "WriteOnly",
            "ReadOnly",
            "ScaleOut"
          ]
        },
        "shards": {
          "description": "The list of the shards with it's statistics.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/NodeShardStatus"
          }
        },
        "stats": {
          "description": "Weaviate overall statistics.",
          "type": "object",
          "$ref": "#/definitions/NodeStats"
        },
        "status": {
          "description": "Node's status.",
          "type": "string",
          "default": "HEALTHY",
          "enum": [
            "HEALTHY",
            "UNHEALTHY",
            "UNAVAILABLE",
            "TIMEOUT"
          ]
        },
        "version": {
          "description": "The version of Weaviate.",
          "type": "string"
        }
      }
    },
    "NodesStatusResponse": {
      "description": "The status of all of the Weaviate nodes",
      "type": "object",
      "properties": {
        "nodes": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/NodeStatus"
          }
        }
      }
    },
    "Object": {
      "type": "object",
      "properties": {
        "additional": {
          "$ref": "#/definitions/AdditionalProperties"
        },
        "class": {
          "description": "Name of the collection (class) the object belongs to.",
          "type": "string"
        },
        "creationTimeUnix": {
          "description": "(Response only) Timestamp of creation of this object in milliseconds since epoch UTC.",
          "type": "integer",
          "format": "int64"
        },
        "id": {
          "description": "The UUID of the object.",
          "type": "string",
          "format": "uuid"
        },
        "lastUpdateTimeUnix": {
          "description": "(Response only) Timestamp of the last object update in milliseconds since epoch UTC.",
          "type": "integer",
          "format": "int64"
        },
        "properties": {
          "$ref": "#/definitions/PropertySchema"
        },
        "tenant": {
          "description": "The name of the tenant the object belongs to.",
          "type": "string"
        },
        "vector": {
          "description": "This field returns vectors associated with the object. C11yVector, Vector or Vectors values are possible.",
          "$ref": "#/definitions/C11yVector"
        },
        "vectorWeights": {
          "$ref": "#/definitions/VectorWeights"
        },
        "vectors": {
          "description": "This field returns vectors associated with the object.",
          "$ref": "#/definitions/Vectors"
        }
      }
    },
    "ObjectTtlConfig": {
      "description": "Configuration of objects' time-to-live",
      "properties": {
        "defaultTtl": {
          "description": "Interval (in seconds) to be added to ` + "`" + `deleteOn` + "`" + ` value, denoting object's expiration time. Has to be positive for ` + "`" + `deleteOn` + "`" + ` set to ` + "`" + `_creationTimeUnix` + "`" + ` or ` + "`" + `_lastUpdateTimeUnix` + "`" + `, any for custom property (default: ` + "`" + `0` + "`" + `).",
          "type": "integer",
          "x-omitempty": false
        },
        "deleteOn": {
          "description": "Name of the property holding base time to compute object's expiration time (ttl = value of deleteOn property + defaultTtl). Can be set to ` + "`" + `_creationTimeUnix` + "`" + `, ` + "`" + `_lastUpdateTimeUnix` + "`" + ` or custom property of ` + "`" + `date` + "`" + ` datatype.",
          "type": "string",
          "x-omitempty": false
        },
        "enabled": {
          "description": "Whether or not object ttl is enabled for this collection (default: ` + "`" + `false` + "`" + `).",
          "type": "boolean",
          "x-omitempty": false
        },
        "filterExpiredObjects": {
          "description": "Whether remove from resultset expired, but not yet deleted by background process objects (default: ` + "`" + `false` + "`" + `).",
          "type": "boolean",
          "x-omitempty": false
        }
      }
    },
    "ObjectsGetResponse": {
      "type": "object",
      "allOf": [
        {
          "$ref": "#/definitions/Object"
        },
        {
          "properties": {
            "deprecations": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/Deprecation"
              }
            }
          }
        },
        {
          "properties": {
            "result": {
              "description": "Results for this specific object.",
              "format": "object",
              "properties": {
                "errors": {
                  "$ref": "#/definitions/ErrorResponse"
                },
                "status": {
                  "type": "string",
                  "default": "SUCCESS",
                  "enum": [
                    "SUCCESS",
                    "FAILED"
                  ]
                }
              }
            }
          }
        }
      ]
    },
    "ObjectsListResponse": {
      "description": "List of objects.",
      "type": "object",
      "properties": {
        "deprecations": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/Deprecation"
          }
        },
        "objects": {
          "description": "The actual list of objects.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/Object"
          }
        },
        "totalResults": {
          "description": "The total number of objects for the query. The number of items in a response may be smaller due to paging.",
          "type": "integer",
          "format": "int64"
        }
      }
    },
    "PatchDocumentAction": {
      "description": "Either a JSONPatch document as defined by RFC 6902 (from, op, path, value), or a merge document (RFC 7396).",
      "required": [
        "op",
        "path"
      ],
      "properties": {
        "from": {
          "description": "A string containing a JSON Pointer value.",
          "type": "string"
        },
        "merge": {
          "$ref": "#/definitions/Object"
        },
        "op": {
          "description": "The operation to be performed.",
          "type": "string",
          "enum": [
            "add",
            "remove",
            "replace",
            "move",
            "copy",
            "test"
          ]
        },
        "path": {
          "description": "A JSON-Pointer.",
          "type": "string"
        },
        "value": {
          "description": "The value to be used within the operations.",
          "type": "object"
        }
      }
    },
    "PatchDocumentObject": {
      "description": "Either a JSONPatch document as defined by RFC 6902 (from, op, path, value), or a merge document (RFC 7396).",
      "required": [
        "op",
        "path"
      ],
      "properties": {
        "from": {
          "description": "A string containing a JSON Pointer value.",
          "type": "string"
        },
        "merge": {
          "$ref": "#/definitions/Object"
        },
        "op": {
          "description": "The operation to be performed.",
          "type": "string",
          "enum": [
            "add",
            "remove",
            "replace",
            "move",
            "copy",
            "test"
          ]
        },
        "path": {
          "description": "A JSON-Pointer.",
          "type": "string"
        },
        "value": {
          "description": "The value to be used within the operations.",
          "type": "object"
        }
      }
    },
    "PeerUpdate": {
      "description": "A single peer in the network.",
      "properties": {
        "id": {
          "description": "The session ID of the peer.",
          "type": "string",
          "format": "uuid"
        },
        "name": {
          "description": "Human readable name.",
          "type": "string"
        },
        "schemaHash": {
          "description": "The latest known hash of the peer's schema.",
          "type": "string"
        },
        "uri": {
          "description": "The location where the peer is exposed to the internet.",
          "type": "string",
          "format": "uri"
        }
      }
    },
    "PeerUpdateList": {
      "description": "List of known peers.",
      "type": "array",
      "items": {
        "$ref": "#/definitions/PeerUpdate"
      }
    },
    "Permission": {
      "description": "Permissions attached to a role.",
      "type": "object",
      "required": [
        "action"
      ],
      "properties": {
        "action": {
          "description": "Allowed actions in weaviate.",
          "type": "string",
          "enum": [
            "manage_backups",
            "read_cluster",
            "create_data",
            "read_data",
            "update_data",
            "delete_data",
            "read_nodes",
            "create_roles",
            "read_roles",
            "update_roles",
            "delete_roles",
            "create_collections",
            "read_collections",
            "update_collections",
            "delete_collections",
            "assign_and_revoke_users",
            "create_users",
            "read_users",
            "update_users",
            "delete_users",
            "create_tenants",
            "read_tenants",
            "update_tenants",
            "delete_tenants",
            "create_replicate",
            "read_replicate",
            "update_replicate",
            "delete_replicate",
            "create_aliases",
            "read_aliases",
            "update_aliases",
            "delete_aliases",
            "assign_and_revoke_groups",
            "read_groups"
          ]
        },
        "aliases": {
          "description": "Resource definition for alias-related actions and permissions. Used to specify which aliases and collections can be accessed or modified.",
          "type": "object",
          "properties": {
            "alias": {
              "description": "A string that specifies which aliases this permission applies to. Can be an exact alias name or a regex pattern. The default value ` + "`" + `*` + "`" + ` applies the permission to all aliases.",
              "type": "string",
              "default": "*"
            },
            "collection": {
              "description": "A string that specifies which collections this permission applies to. Can be an exact collection name or a regex pattern. The default value ` + "`" + `*` + "`" + ` applies the permission to all collections.",
              "type": "string",
              "default": "*"
            }
          }
        },
        "backups": {
          "description": "Resources applicable for backup actions.",
          "type": "object",
          "properties": {
            "collection": {
              "description": "A string that specifies which collections this permission applies to. Can be an exact collection name or a regex pattern. The default value ` + "`" + `*` + "`" + ` applies the permission to all collections.",
              "type": "string",
              "default": "*"
            }
          }
        },
        "collections": {
          "description": "Resources applicable for collection and/or tenant actions.",
          "type": "object",
          "properties": {
            "collection": {
              "description": "A string that specifies which collections this permission applies to. Can be an exact collection name or a regex pattern. The default value ` + "`" + `*` + "`" + ` applies the permission to all collections.",
              "type": "string",
              "default": "*"
            }
          }
        },
        "data": {
          "description": "Resources applicable for data actions.",
          "type": "object",
          "properties": {
            "collection": {
              "description": "A string that specifies which collections this permission applies to. Can be an exact collection name or a regex pattern. The default value ` + "`" + `*` + "`" + ` applies the permission to all collections.",
              "type": "string",
              "default": "*"
            },
            "object": {
              "description": "A string that specifies which objects this permission applies to. Can be an exact object ID or a regex pattern. The default value ` + "`" + `*` + "`" + ` applies the permission to all objects.",
              "type": "string",
              "default": "*"
            },
            "tenant": {
              "description": "A string that specifies which tenants this permission applies to. Can be an exact tenant name or a regex pattern. The default value ` + "`" + `*` + "`" + ` applies the permission to all tenants.",
              "type": "string",
              "default": "*"
            }
          }
        },
        "groups": {
          "description": "Resources applicable for group actions.",
          "type": "object",
          "properties": {
            "group": {
              "description": "A string that specifies which groups this permission applies to. Can be an exact group name or a regex pattern. The default value ` + "`" + `*` + "`" + ` applies the permission to all groups.",
              "type": "string",
              "default": "*"
            },
            "groupType": {
              "$ref": "#/definitions/GroupType"
            }
          }
        },
        "nodes": {
          "description": "Resources applicable for cluster actions.",
          "type": "object",
          "properties": {
            "collection": {
              "description": "A string that specifies which collections this permission applies to. Can be an exact collection name or a regex pattern. The default value ` + "`" + `*` + "`" + ` applies the permission to all collections.",
              "type": "string",
              "default": "*"
            },
            "verbosity": {
              "description": "Whether to allow (verbose) returning shards and stats data in the response.",
              "type": "string",
              "default": "minimal",
              "enum": [
                "verbose",
                "minimal"
              ]
            }
          }
        },
        "replicate": {
          "description": "resources applicable for replicate actions",
          "type": "object",
          "properties": {
            "collection": {
              "description": "string or regex. if a specific collection name, if left empty it will be ALL or *",
              "type": "string",
              "default": "*"
            },
            "shard": {
              "description": "string or regex. if a specific shard name, if left empty it will be ALL or *",
              "type": "string",
              "default": "*"
            }
          }
        },
        "roles": {
          "description": "Resources applicable for role actions.",
          "type": "object",
          "properties": {
            "role": {
              "description": "A string that specifies which roles this permission applies to. Can be an exact role name or a regex pattern. The default value ` + "`" + `*` + "`" + ` applies the permission to all roles.",
              "type": "string",
              "default": "*"
            },
            "scope": {
              "description": "Set the scope for the manage role permission.",
              "type": "string",
              "default": "match",
              "enum": [
                "all",
                "match"
              ]
            }
          }
        },
        "tenants": {
          "description": "Resources applicable for tenant actions.",
          "type": "object",
          "properties": {
            "collection": {
              "description": "A string that specifies which collections this permission applies to. Can be an exact collection name or a regex pattern. The default value ` + "`" + `*` + "`" + ` applies the permission to all collections.",
              "type": "string",
              "default": "*"
            },
            "tenant": {
              "description": "A string that specifies which tenants this permission applies to. Can be an exact tenant name or a regex pattern. The default value ` + "`" + `*` + "`" + ` applies the permission to all tenants.",
              "type": "string",
              "default": "*"
            }
          }
        },
        "users": {
          "description": "Resources applicable for user actions.",
          "type": "object",
          "properties": {
            "users": {
              "description": "A string that specifies which users this permission applies to. Can be an exact user name or a regex pattern. The default value ` + "`" + `*` + "`" + ` applies the permission to all users.",
              "type": "string",
              "default": "*"
            }
          }
        }
      }
    },
    "PhoneNumber": {
      "properties": {
        "countryCode": {
          "description": "Read-only. The numerical country code (e.g. ` + "`" + `49` + "`" + `).",
          "type": "number",
          "format": "uint64"
        },
        "defaultCountry": {
          "description": "Optional. The ISO 3166-1 alpha-2 country code. This is used to figure out the correct ` + "`" + `countryCode` + "`" + ` and international format if only a national number (e.g. ` + "`" + `0123 4567` + "`" + `) is provided.",
          "type": "string"
        },
        "input": {
          "description": "The raw input as the phone number is present in your raw data set. It will be parsed into the standardized formats if valid.",
          "type": "string"
        },
        "internationalFormatted": {
          "description": "Read-only. Parsed result in the international format (e.g. ` + "`" + `+49 123 456789` + "`" + `).",
          "type": "string"
        },
        "national": {
          "description": "Read-only. The numerical representation of the national part.",
          "type": "number",
          "format": "uint64"
        },
        "nationalFormatted": {
          "description": "Read-only. Parsed result in the national format (e.g. ` + "`" + `0123 456789` + "`" + `).",
          "type": "string"
        },
        "valid": {
          "description": "Read-only. Indicates whether the parsed number is a valid phone number.",
          "type": "boolean"
        }
      }
    },
    "Principal": {
      "type": "object",
      "properties": {
        "groups": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "userType": {
          "$ref": "#/definitions/UserTypeInput"
        },
        "username": {
          "description": "The username that was extracted either from the authentication information",
          "type": "string"
        }
      }
    },
    "Property": {
      "type": "object",
      "properties": {
        "dataType": {
          "description": "Data type of the property (required). If it starts with a capital (for example Person), may be a reference to another type.",
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "description": {
          "description": "Description of the property.",
          "type": "string"
        },
        "indexFilterable": {
          "description": "Whether to include this property in the filterable, Roaring Bitmap index. If ` + "`" + `false` + "`" + `, this property cannot be used in ` + "`" + `where` + "`" + ` filters. \u003cbr/\u003e\u003cbr/\u003eNote: Unrelated to vectorization behavior.",
          "type": "boolean",
          "x-nullable": true
        },
        "indexInverted": {
          "description": "(Deprecated). Whether to include this property in the inverted index. If ` + "`" + `false` + "`" + `, this property cannot be used in ` + "`" + `where` + "`" + ` filters, ` + "`" + `bm25` + "`" + ` or ` + "`" + `hybrid` + "`" + ` search. \u003cbr/\u003e\u003cbr/\u003eUnrelated to vectorization behavior (deprecated as of v1.19; use indexFilterable or/and indexSearchable instead)",
          "type": "boolean",
          "x-nullable": true
        },
        "indexRangeFilters": {
          "description": "Whether to include this property in the filterable, range-based Roaring Bitmap index. Provides better performance for range queries compared to filterable index in large datasets. Applicable only to properties of data type int, number, date.",
          "type": "boolean",
          "x-nullable": true
        },
        "indexSearchable": {
          "description": "Optional. Should this property be indexed in the inverted index. Defaults to true. Applicable only to properties of data type text and text[]. If you choose false, you will not be able to use this property in bm25 or hybrid search. This property has no affect on vectorization decisions done by modules",
          "type": "boolean",
          "x-nullable": true
        },
        "moduleConfig": {
          "description": "Configuration specific to modules in a collection context.",
          "type": "object"
        },
        "name": {
          "description": "The name of the property (required). Multiple words should be concatenated in camelCase, e.g. ` + "`" + `nameOfAuthor` + "`" + `.",
          "type": "string"
        },
        "nestedProperties": {
          "description": "The properties of the nested object(s). Applies to object and object[] data types.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/NestedProperty"
          },
          "x-omitempty": true
        },
        "tokenization": {
          "description": "Determines how a property is indexed. This setting applies to ` + "`" + `text` + "`" + ` and ` + "`" + `text[]` + "`" + ` data types. The following tokenization methods are available:\u003cbr/\u003e\u003cbr/\u003e- ` + "`" + `word` + "`" + ` (default): Splits the text on any non-alphanumeric characters and lowercases the tokens.\u003cbr/\u003e- ` + "`" + `lowercase` + "`" + `: Splits the text on whitespace and lowercases the tokens.\u003cbr/\u003e- ` + "`" + `whitespace` + "`" + `: Splits the text on whitespace. This tokenization is case-sensitive.\u003cbr/\u003e- ` + "`" + `field` + "`" + `: Indexes the entire property value as a single token after trimming whitespace.\u003cbr/\u003e- ` + "`" + `trigram` + "`" + `: Splits the property into rolling trigrams (three-character sequences).\u003cbr/\u003e- ` + "`" + `gse` + "`" + `: Uses the ` + "`" + `gse` + "`" + ` tokenizer, suitable for Chinese language text. [See ` + "`" + `gse` + "`" + ` docs](https://pkg.go.dev/github.com/go-ego/gse#section-readme).\u003cbr/\u003e- ` + "`" + `kagome_ja` + "`" + `: Uses the ` + "`" + `Kagome` + "`" + ` tokenizer with a Japanese (IPA) dictionary. [See ` + "`" + `kagome` + "`" + ` docs](https://github.com/ikawaha/kagome).\u003cbr/\u003e- ` + "`" + `kagome_kr` + "`" + `: Uses the ` + "`" + `Kagome` + "`" + ` tokenizer with a Korean dictionary. [See ` + "`" + `kagome` + "`" + ` docs](https://github.com/ikawaha/kagome).\u003cbr/\u003e\u003cbr/\u003eSee [Reference: Tokenization](https://docs.weaviate.io/weaviate/config-refs/collections#tokenization) for details.",
          "type": "string",
          "enum": [
            "word",
            "lowercase",
            "whitespace",
            "field",
            "trigram",
            "gse",
            "kagome_kr",
            "kagome_ja",
            "gse_ch"
          ]
        }
      }
    },
    "PropertySchema": {
      "description": "Names and values of an individual property. A returned response may also contain additional metadata, such as from classification or feature projection.",
      "type": "object"
    },
    "RaftStatistics": {
      "description": "The definition of Raft statistics.",
      "properties": {
        "appliedIndex": {
          "type": "string"
        },
        "commitIndex": {
          "type": "string"
        },
        "fsmPending": {
          "type": "string"
        },
        "lastContact": {
          "type": "string"
        },
        "lastLogIndex": {
          "type": "string"
        },
        "lastLogTerm": {
          "type": "string"
        },
        "lastSnapshotIndex": {
          "type": "string"
        },
        "lastSnapshotTerm": {
          "type": "string"
        },
        "latestConfiguration": {
          "description": "Weaviate Raft nodes.",
          "type": "object"
        },
        "latestConfigurationIndex": {
          "type": "string"
        },
        "numPeers": {
          "type": "string"
        },
        "protocolVersion": {
          "type": "string"
        },
        "protocolVersionMax": {
          "type": "string"
        },
        "protocolVersionMin": {
          "type": "string"
        },
        "snapshotVersionMax": {
          "type": "string"
        },
        "snapshotVersionMin": {
          "type": "string"
        },
        "state": {
          "type": "string"
        },
        "term": {
          "type": "string"
        }
      }
    },
    "ReferenceMetaClassification": {
      "description": "This meta field contains additional info about the classified reference property",
      "properties": {
        "closestLosingDistance": {
          "description": "The lowest distance of a neighbor in the losing group. Optional. If k equals the size of the winning group, there is no losing group",
          "type": "number",
          "format": "float32",
          "x-nullable": true
        },
        "closestOverallDistance": {
          "description": "The lowest distance of any neighbor, regardless of whether they were in the winning or losing group",
          "type": "number",
          "format": "float32"
        },
        "closestWinningDistance": {
          "description": "Closest distance of a neighbor from the winning group",
          "type": "number",
          "format": "float32"
        },
        "losingCount": {
          "description": "size of the losing group, can be 0 if the winning group size equals k",
          "type": "number",
          "format": "int64"
        },
        "losingDistance": {
          "description": "deprecated - do not use, to be removed in 0.23.0",
          "type": "number",
          "format": "float32",
          "x-nullable": true
        },
        "meanLosingDistance": {
          "description": "Mean distance of all neighbors from the losing group. Optional. If k equals the size of the winning group, there is no losing group.",
          "type": "number",
          "format": "float32",
          "x-nullable": true
        },
        "meanWinningDistance": {
          "description": "Mean distance of all neighbors from the winning group",
          "type": "number",
          "format": "float32"
        },
        "overallCount": {
          "description": "overall neighbors checked as part of the classification. In most cases this will equal k, but could be lower than k - for example if not enough data was present",
          "type": "number",
          "format": "int64"
        },
        "winningCount": {
          "description": "size of the winning group, a number between 1..k",
          "type": "number",
          "format": "int64"
        },
        "winningDistance": {
          "description": "deprecated - do not use, to be removed in 0.23.0",
          "type": "number",
          "format": "float32"
        }
      }
    },
    "ReplicationConfig": {
      "description": "Configure how replication is executed in a cluster",
      "type": "object",
      "properties": {
        "asyncEnabled": {
          "description": "Enable asynchronous replication (default: ` + "`" + `false` + "`" + `).",
          "type": "boolean",
          "x-omitempty": false
        },
        "deletionStrategy": {
          "description": "Conflict resolution strategy for deleted objects.",
          "type": "string",
          "enum": [
            "NoAutomatedResolution",
            "DeleteOnConflict",
            "TimeBasedResolution"
          ],
          "x-omitempty": true
        },
        "factor": {
          "description": "Number of times a collection (class) is replicated (default: 1).",
          "type": "integer"
        }
      }
    },
    "ReplicationDeleteReplicaRequest": {
      "description": "Specifies the parameters required to permanently delete a specific shard replica from a particular node. This action will remove the replica's data from the node.",
      "type": "object",
      "required": [
        "node",
        "collection",
        "shard"
      ],
      "properties": {
        "collection": {
          "description": "The name of the collection to which the shard replica belongs.",
          "type": "string"
        },
        "node": {
          "description": "The name of the Weaviate node from which the shard replica will be deleted.",
          "type": "string"
        },
        "shard": {
          "description": "The ID of the shard whose replica is to be deleted.",
          "type": "string"
        }
      }
    },
    "ReplicationDisableReplicaRequest": {
      "description": "Specifies the parameters required to mark a specific shard replica as inactive (soft-delete) on a particular node. This action typically prevents the replica from serving requests but does not immediately remove its data.",
      "type": "object",
      "required": [
        "node",
        "collection",
        "shard"
      ],
      "properties": {
        "collection": {
          "description": "The name of the collection to which the shard replica belongs.",
          "type": "string"
        },
        "node": {
          "description": "The name of the Weaviate node hosting the shard replica that is to be disabled.",
          "type": "string"
        },
        "shard": {
          "description": "The ID of the shard whose replica is to be disabled.",
          "type": "string"
        }
      }
    },
    "ReplicationReplicateDetailsReplicaResponse": {
      "description": "Provides a comprehensive overview of a specific replication operation, detailing its unique ID, the involved collection, shard, source and target nodes, transfer type, current status, and optionally, its status history.",
      "required": [
        "id",
        "shard",
        "sourceNode",
        "targetNode",
        "collection",
        "status",
        "type"
      ],
      "properties": {
        "collection": {
          "description": "The name of the collection to which the shard being replicated belongs.",
          "type": "string"
        },
        "id": {
          "description": "The unique identifier (ID) of this specific replication operation.",
          "type": "string",
          "format": "uuid"
        },
        "scheduledForCancel": {
          "description": "Whether the replica operation is scheduled for cancellation.",
          "type": "boolean"
        },
        "scheduledForDelete": {
          "description": "Whether the replica operation is scheduled for deletion.",
          "type": "boolean"
        },
        "shard": {
          "description": "The name of the shard involved in this replication operation.",
          "type": "string"
        },
        "sourceNode": {
          "description": "The identifier of the node from which the replica is being moved or copied (the source node).",
          "type": "string"
        },
        "status": {
          "description": "An object detailing the current operational state of the replica movement and any errors encountered.",
          "type": "object",
          "$ref": "#/definitions/ReplicationReplicateDetailsReplicaStatus"
        },
        "statusHistory": {
          "description": "An array detailing the historical sequence of statuses the replication operation has transitioned through, if requested and available.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/ReplicationReplicateDetailsReplicaStatus"
          }
        },
        "targetNode": {
          "description": "The identifier of the node to which the replica is being moved or copied (the target node).",
          "type": "string"
        },
        "type": {
          "description": "Indicates whether the operation is a ` + "`" + `COPY` + "`" + ` (source replica remains) or a ` + "`" + `MOVE` + "`" + ` (source replica is removed after successful transfer).",
          "type": "string",
          "enum": [
            "COPY",
            "MOVE"
          ]
        },
        "uncancelable": {
          "description": "Whether the replica operation can't be cancelled.",
          "type": "boolean"
        },
        "whenStartedUnixMs": {
          "description": "The UNIX timestamp in ms when the replication operation was initiated. This is an approximate time and so should not be used for precise timing.",
          "type": "integer",
          "format": "int64"
        }
      }
    },
    "ReplicationReplicateDetailsReplicaStatus": {
      "description": "Represents the current or historical status of a shard replica involved in a replication operation, including its operational state and any associated errors.",
      "type": "object",
      "properties": {
        "errors": {
          "description": "A list of error messages encountered by this replica during the replication operation, if any.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/ReplicationReplicateDetailsReplicaStatusError"
          }
        },
        "state": {
          "description": "The current operational state of the replica during the replication process.",
          "type": "string",
          "enum": [
            "REGISTERED",
            "HYDRATING",
            "FINALIZING",
            "DEHYDRATING",
            "READY",
            "CANCELLED"
          ]
        },
        "whenStartedUnixMs": {
          "description": "The UNIX timestamp in ms when this state was first entered. This is an approximate time and so should not be used for precise timing.",
          "type": "integer",
          "format": "int64"
        }
      }
    },
    "ReplicationReplicateDetailsReplicaStatusError": {
      "description": "Represents an error encountered during a replication operation, including its timestamp and a human-readable message.",
      "type": "object",
      "properties": {
        "message": {
          "description": "A human-readable message describing the error.",
          "type": "string"
        },
        "whenErroredUnixMs": {
          "description": "The unix timestamp in ms when the error occurred. This is an approximate time and so should not be used for precise timing.",
          "type": "integer",
          "format": "int64"
        }
      }
    },
    "ReplicationReplicateForceDeleteRequest": {
      "description": "Specifies the parameters available when force deleting replication operations.",
      "type": "object",
      "properties": {
        "collection": {
          "description": "The name of the collection to which the shard being replicated belongs.",
          "type": "string"
        },
        "dryRun": {
          "description": "If true, the operation will not actually delete anything but will return the expected outcome of the deletion.",
          "type": "boolean",
          "default": false
        },
        "id": {
          "description": "The unique identifier (ID) of the replication operation to be forcefully deleted.",
          "type": "string",
          "format": "uuid"
        },
        "node": {
          "description": "The name of the target node where the replication operations are registered.",
          "type": "string"
        },
        "shard": {
          "description": "The identifier of the shard involved in the replication operations.",
          "type": "string"
        }
      }
    },
    "ReplicationReplicateForceDeleteResponse": {
      "description": "Provides the UUIDs that were successfully force deleted as part of the replication operation. If dryRun is true, this will return the expected outcome without actually deleting anything.",
      "type": "object",
      "properties": {
        "deleted": {
          "description": "The unique identifiers (IDs) of the replication operations that were forcefully deleted.",
          "type": "array",
          "items": {
            "type": "string",
            "format": "uuid"
          }
        },
        "dryRun": {
          "description": "Indicates whether the operation was a dry run (true) or an actual deletion (false).",
          "type": "boolean"
        }
      }
    },
    "ReplicationReplicateReplicaRequest": {
      "description": "Specifies the parameters required to initiate a shard replica movement operation between two nodes for a given collection and shard. This request defines the source and target node, the collection and type of transfer.",
      "type": "object",
      "required": [
        "sourceNode",
        "targetNode",
        "collection",
        "shard"
      ],
      "properties": {
        "collection": {
          "description": "The name of the collection to which the target shard belongs.",
          "type": "string"
        },
        "shard": {
          "description": "The name of the shard whose replica is to be moved or copied.",
          "type": "string"
        },
        "sourceNode": {
          "description": "The name of the Weaviate node currently hosting the shard replica that needs to be moved or copied.",
          "type": "string"
        },
        "targetNode": {
          "description": "The name of the Weaviate node where the new shard replica will be created as part of the movement or copy operation.",
          "type": "string"
        },
        "type": {
          "description": "Specifies the type of replication operation to perform. ` + "`" + `COPY` + "`" + ` creates a new replica on the target node while keeping the source replica. ` + "`" + `MOVE` + "`" + ` creates a new replica on the target node and then removes the source replica upon successful completion. Defaults to ` + "`" + `COPY` + "`" + ` if omitted.",
          "type": "string",
          "default": "COPY",
          "enum": [
            "COPY",
            "MOVE"
          ]
        }
      }
    },
    "ReplicationReplicateReplicaResponse": {
      "description": "Contains the unique identifier for a successfully initiated asynchronous replica movement operation. This ID can be used to track the progress of the operation.",
      "type": "object",
      "required": [
        "id"
      ],
      "properties": {
        "id": {
          "description": "The unique identifier (ID) assigned to the registered replication operation.",
          "type": "string",
          "format": "uuid"
        }
      }
    },
    "ReplicationScaleApplyResponse": {
      "description": "Response for the POST /replication/scale endpoint containing the list of initiated shard copy operation IDs.",
      "type": "object",
      "required": [
        "operationIds",
        "planId",
        "collection"
      ],
      "properties": {
        "collection": {
          "description": "The name of the collection associated with this replication scaling plan.",
          "type": "string",
          "x-nullable": false
        },
        "operationIds": {
          "description": "List of shard copy operation IDs created during scaling.",
          "type": "array",
          "items": {
            "type": "string",
            "format": "uuid"
          }
        },
        "planId": {
          "description": "The unique identifier of the replication scaling plan that generated these operations.",
          "type": "string",
          "format": "uuid",
          "x-nullable": false
        }
      }
    },
    "ReplicationScalePlan": {
      "description": "Defines a complete plan for scaling replication within a collection. Each shard entry specifies nodes to remove and nodes to add. Added nodes may either be initialized empty (null) or created by replicating data from a source node specified as a string. If a source node is also marked for removal in the same shard, it represents a move operation and can only be used once as a source for that shard. If a source node is not marked for removal, it represents a copy operation and can be used as the source for multiple additions in that shard. Nodes listed in 'removeNodes' cannot also appear as targets in 'addNodes' for the same shard, and the same node cannot be specified for both addition and removal in a single shard.",
      "type": "object",
      "required": [
        "planId",
        "collection",
        "shardScaleActions"
      ],
      "properties": {
        "collection": {
          "description": "The name of the collection to which this replication scaling plan applies.",
          "type": "string",
          "x-nullable": false
        },
        "planId": {
          "description": "A unique identifier for this replication scaling plan, useful for tracking and auditing purposes.",
          "type": "string",
          "format": "uuid",
          "x-nullable": false
        },
        "shardScaleActions": {
          "description": "A mapping of shard names to their corresponding scaling actions. Each key corresponds to a shard name, and its value defines which nodes should be removed and which should be added for that shard. If a source node listed for an addition is also in 'removeNodes' for the same shard, that addition is treated as a move operation. Such a node can appear only once as a source in that shard. Otherwise, if the source node is not being removed, it represents a copy operation and can be referenced multiple times as a source for additions.",
          "type": "object",
          "additionalProperties": {
            "description": "Scaling actions for a single shard, including which nodes to remove and which to add. Nodes listed in 'removeNodes' cannot appear as targets in 'addNodes' for the same shard. If a source node is also marked for removal, it is treated as a move operation and can only appear once as a source node in that shard. A source node that is not being removed can appear multiple times as a source node for additions in that shard (copy operations).",
            "type": "object",
            "properties": {
              "addNodes": {
                "description": "A mapping of target node identifiers to their addition configuration. Each key represents a target node where a new replica will be added. The value may be null, which means an empty replica will be created, or a string specifying the source node from which shard data will be copied. If the source node is also marked for removal in the same shard, this addition is treated as a move operation, and that source node can only appear once as a source node for that shard. If the source node is not being removed, it can be used as the source for multiple additions (copy operations).",
                "type": "object",
                "additionalProperties": {
                  "description": "Defines how the new replica should be created. If null, an empty shard is created. If a string, it specifies the source node from which data for this shard should be replicated.",
                  "type": [
                    "string",
                    "null"
                  ]
                }
              },
              "removeNodes": {
                "description": "List of node identifiers from which replicas of this shard should be removed. Nodes listed here must not appear in 'addNodes' for the same shard, and cannot be used as a source node for any addition in this shard except in the implicit move case, where they appear as both a source and a node to remove.",
                "type": "array",
                "items": {
                  "type": "string"
                }
              }
            }
          }
        }
      }
    },
    "ReplicationShardReplicas": {
      "description": "Represents a shard and lists the nodes that currently host its replicas.",
      "type": "object",
      "properties": {
        "replicas": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "shard": {
          "type": "string"
        }
      }
    },
    "ReplicationShardingState": {
      "description": "Details the sharding layout for a specific collection, mapping each shard to its set of replicas across the cluster.",
      "type": "object",
      "properties": {
        "collection": {
          "description": "The name of the collection.",
          "type": "string"
        },
        "shards": {
          "description": "An array detailing each shard within the collection and the nodes hosting its replicas.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/ReplicationShardReplicas"
          }
        }
      }
    },
    "ReplicationShardingStateResponse": {
      "description": "Provides the detailed sharding state for one or more collections, including the distribution of shards and their replicas across the cluster nodes.",
      "type": "object",
      "properties": {
        "shardingState": {
          "$ref": "#/definitions/ReplicationShardingState"
        }
      }
    },
    "RestoreConfig": {
      "description": "Backup custom configuration",
      "type": "object",
      "properties": {
        "Bucket": {
          "description": "Name of the bucket, container, volume, etc",
          "type": "string"
        },
        "CPUPercentage": {
          "description": "Desired CPU core utilization ranging from 1%-80%",
          "type": "integer",
          "default": 50,
          "maximum": 80,
          "minimum": 1,
          "x-nullable": false
        },
        "Endpoint": {
          "description": "name of the endpoint, e.g. s3.amazonaws.com",
          "type": "string"
        },
        "Path": {
          "description": "Path within the bucket",
          "type": "string"
        },
        "rolesOptions": {
          "description": "How roles should be restored",
          "type": "string",
          "default": "noRestore",
          "enum": [
            "noRestore",
            "all"
          ]
        },
        "usersOptions": {
          "description": "How users should be restored",
          "type": "string",
          "default": "noRestore",
          "enum": [
            "noRestore",
            "all"
          ]
        }
      }
    },
    "Role": {
      "type": "object",
      "required": [
        "name",
        "permissions"
      ],
      "properties": {
        "name": {
          "description": "The name (ID) of the role.",
          "type": "string"
        },
        "permissions": {
          "type": "array",
          "items": {
            "description": "The list of permissions assigned to this role (level, action, resource).",
            "type": "object",
            "$ref": "#/definitions/Permission"
          }
        }
      }
    },
    "RolesListResponse": {
      "description": "List of roles.",
      "type": "array",
      "items": {
        "$ref": "#/definitions/Role"
      }
    },
    "Schema": {
      "description": "Definitions of semantic schemas (also see: https://github.com/weaviate/weaviate-semantic-schemas).",
      "type": "object",
      "properties": {
        "classes": {
          "description": "Semantic classes that are available.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/Class"
          }
        },
        "maintainer": {
          "description": "Email of the maintainer.",
          "type": "string",
          "format": "email"
        },
        "name": {
          "description": "Name of the schema.",
          "type": "string"
        }
      }
    },
    "SchemaClusterStatus": {
      "description": "Indicates the health of the schema in a cluster.",
      "type": "object",
      "properties": {
        "error": {
          "description": "Contains the sync check error if one occurred",
          "type": "string",
          "x-omitempty": true
        },
        "healthy": {
          "description": "True if the cluster is in sync, false if there is an issue (see error).",
          "type": "boolean",
          "x-omitempty": false
        },
        "hostname": {
          "description": "Hostname of the coordinating node, i.e. the one that received the cluster. This can be useful information if the error message contains phrases such as 'other nodes agree, but local does not', etc.",
          "type": "string"
        },
        "ignoreSchemaSync": {
          "description": "The cluster check at startup can be ignored (to recover from an out-of-sync situation).",
          "type": "boolean",
          "x-omitempty": false
        },
        "nodeCount": {
          "description": "Number of nodes that participated in the sync check",
          "type": "number",
          "format": "int"
        }
      }
    },
    "SchemaHistory": {
      "description": "This is an open object, with OpenAPI Specification 3.0 this will be more detailed. See Weaviate docs for more info. In the future this will become a key/value OR a SingleRef definition.",
      "type": "object"
    },
    "ShardStatus": {
      "description": "The status of a single shard",
      "properties": {
        "status": {
          "description": "Status of the shard",
          "type": "string"
        }
      }
    },
    "ShardStatusGetResponse": {
      "description": "Response body of shard status get request",
      "properties": {
        "name": {
          "description": "Name of the shard",
          "type": "string"
        },
        "status": {
          "description": "Status of the shard",
          "type": "string"
        },
        "vectorQueueSize": {
          "description": "Size of the vector queue of the shard",
          "type": "integer",
          "x-omitempty": false
        }
      }
    },
    "ShardStatusList": {
      "description": "The status of all the shards of a Class",
      "type": "array",
      "items": {
        "$ref": "#/definitions/ShardStatusGetResponse"
      }
    },
    "SingleRef": {
      "description": "Either set beacon (direct reference) or set collection (class) and schema (concept reference)",
      "properties": {
        "beacon": {
          "description": "If using a direct reference, specify the URI to point to the cross-reference here. Should be in the form of weaviate://localhost/\u003cuuid\u003e for the example of a local cross-reference to an object",
          "type": "string",
          "format": "uri"
        },
        "class": {
          "description": "If using a concept reference (rather than a direct reference), specify the desired collection (class) name here.",
          "type": "string",
          "format": "uri"
        },
        "classification": {
          "description": "Additional Meta information about classifications if the item was part of one",
          "$ref": "#/definitions/ReferenceMetaClassification"
        },
        "href": {
          "description": "If using a direct reference, this read-only fields provides a link to the referenced resource. If 'origin' is globally configured, an absolute URI is shown - a relative URI otherwise.",
          "type": "string",
          "format": "uri"
        },
        "schema": {
          "description": "If using a concept reference (rather than a direct reference), specify the desired properties here",
          "$ref": "#/definitions/PropertySchema"
        }
      }
    },
    "Statistics": {
      "description": "The definition of node statistics.",
      "properties": {
        "bootstrapped": {
          "type": "boolean"
        },
        "candidates": {
          "type": "object"
        },
        "dbLoaded": {
          "type": "boolean"
        },
        "initialLastAppliedIndex": {
          "type": "number",
          "format": "uint64"
        },
        "isVoter": {
          "type": "boolean"
        },
        "lastAppliedIndex": {
          "type": "number"
        },
        "leaderAddress": {
          "type": "object"
        },
        "leaderId": {
          "type": "object"
        },
        "name": {
          "description": "The name of the node.",
          "type": "string"
        },
        "open": {
          "type": "boolean"
        },
        "raft": {
          "description": "Weaviate Raft statistics.",
          "type": "object",
          "$ref": "#/definitions/RaftStatistics"
        },
        "ready": {
          "type": "boolean"
        },
        "status": {
          "description": "Node's status.",
          "type": "string",
          "default": "HEALTHY",
          "enum": [
            "HEALTHY",
            "UNHEALTHY",
            "UNAVAILABLE",
            "TIMEOUT"
          ]
        }
      }
    },
    "StopwordConfig": {
      "description": "Fine-grained control over stopword list usage.",
      "type": "object",
      "properties": {
        "additions": {
          "description": "Stopwords to be considered additionally (default: []). Can be any array of custom strings.",
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "preset": {
          "description": "Pre-existing list of common words by language (default: ` + "`" + `en` + "`" + `). Options: [` + "`" + `en` + "`" + `, ` + "`" + `none` + "`" + `].",
          "type": "string"
        },
        "removals": {
          "description": "Stopwords to be removed from consideration (default: []). Can be any array of custom strings.",
          "type": "array",
          "items": {
            "type": "string"
          }
        }
      }
    },
    "Tenant": {
      "description": "Attributes representing a single tenant within Weaviate.",
      "type": "object",
      "properties": {
        "activityStatus": {
          "description": "The activity status of the tenant, which determines if it is queryable and where its data is stored.\u003cbr/\u003e\u003cbr/\u003e\u003cb\u003eAvailable Statuses:\u003c/b\u003e\u003cbr/\u003e- ` + "`" + `ACTIVE` + "`" + `: The tenant is fully operational and ready for queries. Data is stored on local, hot storage.\u003cbr/\u003e- ` + "`" + `INACTIVE` + "`" + `: The tenant is not queryable. Data is stored locally.\u003cbr/\u003e- ` + "`" + `OFFLOADED` + "`" + `: The tenant is inactive and its data is stored in a remote cloud backend.\u003cbr/\u003e\u003cbr/\u003e\u003cb\u003eUsage Rules:\u003c/b\u003e\u003cbr/\u003e- \u003cb\u003eOn Create:\u003c/b\u003e This field is optional and defaults to ` + "`" + `ACTIVE` + "`" + `. Allowed values are ` + "`" + `ACTIVE` + "`" + ` and ` + "`" + `INACTIVE` + "`" + `.\u003cbr/\u003e- \u003cb\u003eOn Update:\u003c/b\u003e This field is required. Allowed values are ` + "`" + `ACTIVE` + "`" + `, ` + "`" + `INACTIVE` + "`" + `, and ` + "`" + `OFFLOADED` + "`" + `.\u003cbr/\u003e\u003cbr/\u003e\u003cb\u003eRead-Only Statuses:\u003c/b\u003e\u003cbr/\u003eThe following statuses are set by the server and indicate a tenant is transitioning between states:\u003cbr/\u003e- ` + "`" + `OFFLOADING` + "`" + `\u003cbr/\u003e- ` + "`" + `ONLOADING` + "`" + `\u003cbr/\u003e\u003cbr/\u003e\u003cb\u003eNote on Deprecated Names:\u003c/b\u003e\u003cbr/\u003eFor backward compatibility, deprecated names are still accepted and are mapped to their modern equivalents: ` + "`" + `HOT` + "`" + ` (now ` + "`" + `ACTIVE` + "`" + `), ` + "`" + `COLD` + "`" + ` (now ` + "`" + `INACTIVE` + "`" + `), ` + "`" + `FROZEN` + "`" + ` (now ` + "`" + `OFFLOADED` + "`" + `), ` + "`" + `FREEZING` + "`" + ` (now ` + "`" + `OFFLOADING` + "`" + `), ` + "`" + `UNFREEZING` + "`" + ` (now ` + "`" + `ONLOADING` + "`" + `).",
          "type": "string",
          "enum": [
            "ACTIVE",
            "INACTIVE",
            "OFFLOADED",
            "OFFLOADING",
            "ONLOADING",
            "HOT",
            "COLD",
            "FROZEN",
            "FREEZING",
            "UNFREEZING"
          ]
        },
        "name": {
          "description": "The name of the tenant (required).",
          "type": "string"
        }
      }
    },
    "TokenizerUserDictConfig": {
      "description": "A list of pairs of strings that should be replaced with another string during tokenization.",
      "type": "object",
      "properties": {
        "replacements": {
          "type": "array",
          "items": {
            "type": "object",
            "required": [
              "source",
              "target"
            ],
            "properties": {
              "source": {
                "description": "The string to be replaced.",
                "type": "string"
              },
              "target": {
                "description": "The string to replace with.",
                "type": "string"
              }
            }
          }
        },
        "tokenizer": {
          "description": "The tokenizer to which the user dictionary should be applied. Currently, only the ` + "`" + `kagame` + "`" + ` ja and kr tokenizers supports user dictionaries.",
          "type": "string"
        }
      }
    },
    "UserApiKey": {
      "type": "object",
      "required": [
        "apikey"
      ],
      "properties": {
        "apikey": {
          "description": "The API key associated with the user.",
          "type": "string"
        }
      }
    },
    "UserOwnInfo": {
      "type": "object",
      "required": [
        "username"
      ],
      "properties": {
        "groups": {
          "description": "The groups associated with the user.",
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "roles": {
          "type": "array",
          "items": {
            "description": "The roles assigned to the user.",
            "type": "object",
            "$ref": "#/definitions/Role"
          }
        },
        "username": {
          "description": "The name (ID) of the user.",
          "type": "string"
        }
      }
    },
    "UserTypeInput": {
      "description": "The type of the user. ` + "`" + `db` + "`" + ` users are managed by Weaviate, ` + "`" + `oidc` + "`" + ` users are managed by an external OIDC provider.",
      "type": "string",
      "enum": [
        "db",
        "oidc"
      ]
    },
    "UserTypeOutput": {
      "description": "The type of the user. ` + "`" + `db_user` + "`" + ` users are created through the ` + "`" + `users` + "`" + ` API, ` + "`" + `db_env_user` + "`" + ` users are created through environment variables, and ` + "`" + `oidc` + "`" + ` users are managed by an external OIDC provider.",
      "type": "string",
      "enum": [
        "db_user",
        "db_env_user",
        "oidc"
      ]
    },
    "Vector": {
      "description": "A vector representation of the object. If provided at object creation, this wil take precedence over any vectorizer setting.",
      "type": "object"
    },
    "VectorConfig": {
      "type": "object",
      "properties": {
        "vectorIndexConfig": {
          "description": "Vector-index config, that is specific to the type of index selected in vectorIndexType",
          "type": "object"
        },
        "vectorIndexType": {
          "description": "Name of the vector index to use, eg. (HNSW)",
          "type": "string"
        },
        "vectorizer": {
          "description": "Configuration of a specific vectorizer used by this vector",
          "type": "object"
        }
      }
    },
    "VectorWeights": {
      "description": "Allow custom overrides of vector weights as math expressions. E.g. ` + "`" + `pancake` + "`" + `: ` + "`" + `7` + "`" + ` will set the weight for the word pancake to 7 in the vectorization, whereas ` + "`" + `w * 3` + "`" + ` would triple the originally calculated word. This is an open object, with OpenAPI Specification 3.0 this will be more detailed. See Weaviate docs for more info. In the future this will become a key/value (string/string) object.",
      "type": "object"
    },
    "Vectors": {
      "description": "A map of named vectors for multi-vector representations.",
      "type": "object",
      "additionalProperties": {
        "$ref": "#/definitions/Vector"
      }
    },
    "WhereFilter": {
      "description": "Filter search results using a where filter.",
      "type": "object",
      "properties": {
        "operands": {
          "description": "Combine multiple where filters, requires 'And' or 'Or' operator.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/WhereFilter"
          }
        },
        "operator": {
          "description": "Operator to use.",
          "type": "string",
          "enum": [
            "And",
            "Or",
            "Equal",
            "Like",
            "NotEqual",
            "GreaterThan",
            "GreaterThanEqual",
            "LessThan",
            "LessThanEqual",
            "WithinGeoRange",
            "IsNull",
            "ContainsAny",
            "ContainsAll",
            "ContainsNone",
            "Not"
          ],
          "example": "GreaterThanEqual"
        },
        "path": {
          "description": "Path to the property currently being filtered.",
          "type": "array",
          "items": {
            "type": "string"
          },
          "example": [
            "inCity",
            "city",
            "name"
          ]
        },
        "valueBoolean": {
          "description": "value as boolean",
          "type": "boolean",
          "x-nullable": true,
          "example": false
        },
        "valueBooleanArray": {
          "description": "value as boolean",
          "type": "array",
          "items": {
            "type": "boolean"
          },
          "x-nullable": true,
          "x-omitempty": true,
          "example": [
            true,
            false
          ]
        },
        "valueDate": {
          "description": "value as date (as string)",
          "type": "string",
          "x-nullable": true,
          "example": "TODO"
        },
        "valueDateArray": {
          "description": "value as date (as string)",
          "type": "array",
          "items": {
            "type": "string"
          },
          "x-nullable": true,
          "x-omitempty": true,
          "example": "TODO"
        },
        "valueGeoRange": {
          "description": "value as geo coordinates and distance",
          "type": "object",
          "x-nullable": true,
          "$ref": "#/definitions/WhereFilterGeoRange"
        },
        "valueInt": {
          "description": "value as integer",
          "type": "integer",
          "format": "int64",
          "x-nullable": true,
          "example": 2000
        },
        "valueIntArray": {
          "description": "value as integer",
          "type": "array",
          "items": {
            "type": "integer",
            "format": "int64"
          },
          "x-nullable": true,
          "x-omitempty": true,
          "example": "[100, 200]"
        },
        "valueNumber": {
          "description": "value as number/float",
          "type": "number",
          "format": "float64",
          "x-nullable": true,
          "example": 3.14
        },
        "valueNumberArray": {
          "description": "value as number/float",
          "type": "array",
          "items": {
            "type": "number",
            "format": "float64"
          },
          "x-nullable": true,
          "x-omitempty": true,
          "example": [
            3.14
          ]
        },
        "valueString": {
          "description": "value as text (deprecated as of v1.19; alias for valueText)",
          "type": "string",
          "x-nullable": true,
          "example": "my search term"
        },
        "valueStringArray": {
          "description": "value as text (deprecated as of v1.19; alias for valueText)",
          "type": "array",
          "items": {
            "type": "string"
          },
          "x-nullable": true,
          "x-omitempty": true,
          "example": [
            "my search term"
          ]
        },
        "valueText": {
          "description": "value as text",
          "type": "string",
          "x-nullable": true,
          "example": "my search term"
        },
        "valueTextArray": {
          "description": "value as text",
          "type": "array",
          "items": {
            "type": "string"
          },
          "x-nullable": true,
          "x-omitempty": true,
          "example": [
            "my search term"
          ]
        }
      }
    },
    "WhereFilterGeoRange": {
      "description": "Filter within a distance of a georange.",
      "type": "object",
      "properties": {
        "distance": {
          "type": "object",
          "properties": {
            "max": {
              "type": "number",
              "format": "float64"
            }
          }
        },
        "geoCoordinates": {
          "x-nullable": false,
          "$ref": "#/definitions/GeoCoordinates"
        }
      }
    }
  },
  "parameters": {
    "CommonAfterParameterQuery": {
      "type": "string",
      "description": "A threshold UUID of the objects to retrieve after, using an UUID-based ordering. This object is not part of the set. \u003cbr/\u003e\u003cbr/\u003eMust be used with collection name (` + "`" + `class` + "`" + `), typically in conjunction with ` + "`" + `limit` + "`" + `. \u003cbr/\u003e\u003cbr/\u003eNote ` + "`" + `after` + "`" + ` cannot be used with ` + "`" + `offset` + "`" + ` or ` + "`" + `sort` + "`" + `. \u003cbr/\u003e\u003cbr/\u003eFor a null value similar to offset=0, set an empty string in the request, i.e. ` + "`" + `after=` + "`" + ` or ` + "`" + `after` + "`" + `.",
      "name": "after",
      "in": "query"
    },
    "CommonClassParameterQuery": {
      "type": "string",
      "description": "The collection from which to query objects.  \u003cbr/\u003e\u003cbr/\u003eNote that if the collection name (` + "`" + `class` + "`" + `) is not provided, the response will not include any objects.",
      "name": "class",
      "in": "query"
    },
    "CommonConsistencyLevelParameterQuery": {
      "type": "string",
      "description": "Determines how many replicas must acknowledge a request before it is considered successful.",
      "name": "consistency_level",
      "in": "query"
    },
    "CommonIncludeParameterQuery": {
      "type": "string",
      "description": "Include additional information, such as classification information. Allowed values include: ` + "`" + `classification` + "`" + `, ` + "`" + `vector` + "`" + ` and ` + "`" + `interpretation` + "`" + `.",
      "name": "include",
      "in": "query"
    },
    "CommonLimitParameterQuery": {
      "type": "integer",
      "format": "int64",
      "description": "The maximum number of items to be returned per page. The default is 25 unless set otherwise as an environment variable.",
      "name": "limit",
      "in": "query"
    },
    "CommonNodeNameParameterQuery": {
      "type": "string",
      "description": "The target node which should fulfill the request.",
      "name": "node_name",
      "in": "query"
    },
    "CommonOffsetParameterQuery": {
      "type": "integer",
      "format": "int64",
      "default": 0,
      "description": "The starting index of the result window. Note ` + "`" + `offset` + "`" + ` will retrieve ` + "`" + `offset+limit` + "`" + ` results and return ` + "`" + `limit` + "`" + ` results from the object with index ` + "`" + `offset` + "`" + ` onwards. Limited by the value of ` + "`" + `QUERY_MAXIMUM_RESULTS` + "`" + `. \u003cbr/\u003e\u003cbr/\u003eShould be used in conjunction with ` + "`" + `limit` + "`" + `. \u003cbr/\u003e\u003cbr/\u003eCannot be used with ` + "`" + `after` + "`" + `.",
      "name": "offset",
      "in": "query"
    },
    "CommonOrderParameterQuery": {
      "type": "string",
      "description": "Order parameter to tell how to order (asc or desc) data within given field. Should be used in conjunction with ` + "`" + `sort` + "`" + ` parameter. If providing multiple ` + "`" + `sort` + "`" + ` values, provide multiple ` + "`" + `order` + "`" + ` values in corresponding order, e.g.: ` + "`" + `sort=author_name,title\u0026order=desc,asc` + "`" + `.",
      "name": "order",
      "in": "query"
    },
    "CommonOutputVerbosityParameterQuery": {
      "type": "string",
      "default": "minimal",
      "description": "Controls the verbosity of the output, possible values are: ` + "`" + `minimal` + "`" + `, ` + "`" + `verbose` + "`" + `. Defaults to ` + "`" + `minimal` + "`" + `.",
      "name": "output",
      "in": "query"
    },
    "CommonSortParameterQuery": {
      "type": "string",
      "description": "Name(s) of the property to sort by - e.g. ` + "`" + `city` + "`" + `, or ` + "`" + `country,city` + "`" + `.",
      "name": "sort",
      "in": "query"
    },
    "CommonTenantParameterQuery": {
      "type": "string",
      "description": "Specifies the tenant in a request targeting a multi-tenant collection (class).",
      "name": "tenant",
      "in": "query"
    }
  },
  "securityDefinitions": {
    "oidc": {
      "description": "OIDC (OpenConnect ID - based on OAuth2)",
      "type": "oauth2",
      "flow": "implicit",
      "authorizationUrl": "http://to-be-configured-in-the-application-config"
    }
  },
  "security": [
    {},
    {
      "oidc": []
    }
  ],
  "tags": [
    {
      "description": "Operations for managing individual data objects. Objects are the primary units of data stored within Weaviate collections. Each object conforms to the data schema definition of its parent collection, containing specific properties (data fields). Objects have one or multiple associated vector embeddings and can link to other objects via cross-references. These endpoints allow you to perform CRUD (Create, Read, Update, Delete) operations on individual data objects.",
      "name": "objects"
    },
    {
      "description": "Operations for performing actions on multiple data items (objects or references) in a single API request. Batch operations significantly improve performance and efficiency, especially for bulk data imports or large-scale deletions, by reducing network overhead compared to sending individual requests. These endpoints allow for creating multiple objects or deleting objects based on filters.",
      "name": "batch"
    },
    {
      "name": "graphql"
    },
    {
      "name": "meta"
    },
    {
      "description": "Operations related to managing collections. In Weaviate, 'collections' (formerly called 'classes') store your data objects. Each collection has a definition that specifies its data structure (properties and their data types), vectorizer settings (how vectors are generated or managed), and indexing configuration (how data is indexed for efficient search). These endpoints allow you to create, retrieve, update, and delete collection definitions. For detailed usage and code examples on interacting with collections, see the documentation: [https://weaviate.io/developers/weaviate/manage-data/collections](https://weaviate.io/developers/weaviate/manage-data/collections).",
      "name": "schema"
    },
    {
      "description": "Operations related to creating and managing backups of Weaviate data. This feature allows you to create snapshots of your collections and store them on external storage backends such as cloud object storage (S3, GCS, Azure) or a shared filesystem. These endpoints enable you to initiate backup and restore processes, monitor their status, list available backups on a backend, and delete unwanted backups. Backups are essential for disaster recovery, data migration, and maintaining point-in-time copies of your vector database.",
      "name": "backups"
    },
    {
      "description": "Endpoints for user account management in Weaviate. This includes operations specific to Weaviate-managed database users (` + "`" + `db` + "`" + ` users), such as creation (which generates an API key), listing, deletion, activation/deactivation, and API key rotation. It also provides operations applicable to any authenticated user (` + "`" + `db` + "`" + ` or ` + "`" + `oidc` + "`" + `), like retrieving their own information (username and assigned roles).\u003cbr/\u003e\u003cbr/\u003e**User Types:**\u003cbr/\u003e* **` + "`" + `db` + "`" + ` users:** Managed entirely within Weaviate (creation, deletion, API keys). Use these endpoints for full lifecycle management.\u003cbr/\u003e* **` + "`" + `oidc` + "`" + ` users:** Authenticated via an external OpenID Connect provider. Their lifecycle (creation, credentials) is managed externally, but their role assignments *within Weaviate* are managed via the ` + "`" + `authz` + "`" + ` endpoints.",
      "name": "users"
    },
    {
      "description": "Endpoints for managing Weaviate's Role-Based Access Control (RBAC) system. Access to Weaviate resources is granted through roles, which are collections of fine-grained permissions. \u003cbr/\u003e\u003cbr/\u003e**Permissions:** Define allowed actions (e.g., ` + "`" + `read_data` + "`" + `, ` + "`" + `create_collections` + "`" + `, ` + "`" + `delete_users` + "`" + `) on specific resources. Resources can be specified broadly (e.g., all collections: ` + "`" + `*` + "`" + `) or narrowly (e.g., a specific collection name, tenant pattern, user name, or role name).\u003cbr/\u003e\u003cbr/\u003e**Roles:** Are named sets of permissions. Managing roles involves creating roles with specific permissions, retrieving role definitions, deleting roles, and adding or removing permissions from existing roles.\u003cbr/\u003e\u003cbr/\u003e**Role assignment:** Roles grant their contained permissions to users or groups. These endpoints allow assigning roles to:\u003cbr/\u003e* ` + "`" + `db` + "`" + ` users: Users managed directly by Weaviate via API or environment variables, authenticating with API keys.\u003cbr/\u003e* ` + "`" + `oidc` + "`" + ` users: Users authenticated via an external OpenID Connect provider, managed externally but assigned roles within Weaviate.\u003cbr/\u003e* OIDC ` + "`" + `groups` + "`" + `: Users authenticated via OIDC who belong to a group automatically inherit roles assigned to that group.\u003cbr/\u003e\u003cbr/\u003eOperations also include revoking roles, checking if a role has a specific permission, listing roles assigned to a user, and listing users/groups assigned to a role. The authorization framework applies universally to both ` + "`" + `db` + "`" + ` and ` + "`" + `oidc` + "`" + ` users based on their assigned roles.",
      "name": "authz"
    },
    {
      "description": "Operations related to managing data replication, including initiating and monitoring shard replica movements between nodes, querying current sharding states, and managing the lifecycle of replication tasks.",
      "name": "replication"
    }
  ],
  "externalDocs": {
    "url": "https://github.com/weaviate/weaviate"
  }
}`))
	FlatSwaggerJSON = json.RawMessage([]byte(`{
  "consumes": [
    "application/json",
    "application/yaml"
  ],
  "produces": [
    "application/json"
  ],
  "schemes": [
    "https"
  ],
  "swagger": "2.0",
  "info": {
    "description": "# Introduction\u003cbr/\u003e Weaviate is an open source, AI-native vector database that helps developers create intuitive and reliable AI-powered applications. \u003cbr/\u003e ### Base Path \u003cbr/\u003eThe base path for the Weaviate server is structured as ` + "`" + `[YOUR-WEAVIATE-HOST]:[PORT]/v1` + "`" + `. As an example, if you wish to access the ` + "`" + `schema` + "`" + ` endpoint on a local instance, you would navigate to ` + "`" + `http://localhost:8080/v1/schema` + "`" + `. Ensure you replace ` + "`" + `[YOUR-WEAVIATE-HOST]` + "`" + ` and ` + "`" + `[PORT]` + "`" + ` with your actual server host and port number respectively. \u003cbr/\u003e ### Questions? \u003cbr/\u003eIf you have any comments or questions, please feel free to reach out to us at the community forum [https://forum.weaviate.io/](https://forum.weaviate.io/). \u003cbr/\u003e### Issues? \u003cbr/\u003eIf you find a bug or want to file a feature request, please open an issue on our GitHub repository for [Weaviate](https://github.com/weaviate/weaviate). \u003cbr/\u003e### Need more documentation? \u003cbr/\u003eFor a quickstart, code examples, concepts and more, please visit our [documentation page](https://docs.weaviate.io/weaviate).",
    "title": "Weaviate REST API",
    "contact": {
      "name": "Weaviate",
      "url": "https://github.com/weaviate",
      "email": "hello@weaviate.io"
    },
    "version": "1.36.0-dev"
  },
  "basePath": "/v1",
  "paths": {
    "/": {
      "get": {
        "description": "Get links to other endpoints to help discover the REST API.",
        "summary": "List available endpoints",
        "operationId": "weaviate.root",
        "responses": {
          "200": {
            "description": "Weaviate is alive and ready.",
            "schema": {
              "type": "object",
              "properties": {
                "links": {
                  "type": "array",
                  "items": {
                    "$ref": "#/definitions/Link"
                  }
                }
              }
            }
          }
        }
      }
    },
    "/.well-known/live": {
      "get": {
        "description": "Indicates if the Weaviate instance is running and responsive to basic HTTP requests. Primarily used for health checks, such as Kubernetes liveness probes.",
        "summary": "Check application liveness",
        "operationId": "weaviate.wellknown.liveness",
        "responses": {
          "200": {
            "description": "The application is alive and responding to HTTP requests."
          }
        }
      }
    },
    "/.well-known/openid-configuration": {
      "get": {
        "description": "Provides OpenID Connect (OIDC) discovery information if OIDC authentication is configured for Weaviate. Returns details like the token issuer URL, client ID, and required scopes.",
        "tags": [
          "well-known",
          "oidc",
          "discovery"
        ],
        "summary": "Get OIDC configuration",
        "responses": {
          "200": {
            "description": "OIDC configuration details returned successfully.",
            "schema": {
              "type": "object",
              "properties": {
                "clientId": {
                  "description": "The OAuth Client ID configured for Weaviate.",
                  "type": "string"
                },
                "href": {
                  "description": "The OIDC issuer URL to redirect to for authentication.",
                  "type": "string"
                },
                "scopes": {
                  "description": "The required OAuth scopes for authentication.",
                  "type": "array",
                  "items": {
                    "type": "string"
                  },
                  "x-omitempty": true
                }
              }
            }
          },
          "404": {
            "description": "OIDC provider is not configured for this Weaviate instance."
          },
          "500": {
            "description": "An internal server error occurred while retrieving OIDC configuration. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false
      }
    },
    "/.well-known/ready": {
      "get": {
        "description": "Indicates if the Weaviate instance has completed its startup routines and is prepared to accept user traffic (data import, queries, etc.). Used for readiness checks, such as Kubernetes readiness probes.",
        "summary": "Check application readiness",
        "operationId": "weaviate.wellknown.readiness",
        "responses": {
          "200": {
            "description": "The application is ready to serve traffic."
          },
          "503": {
            "description": "The application is not ready to serve traffic. Traffic should be directed to other available replicas if applicable."
          }
        }
      }
    },
    "/aliases": {
      "get": {
        "description": "Retrieve a list of all aliases in the system. Results can be filtered by specifying a collection (class) name to get aliases for a specific collection only.",
        "tags": [
          "schema"
        ],
        "summary": "List aliases",
        "operationId": "aliases.get",
        "parameters": [
          {
            "type": "string",
            "description": "Optional filter to retrieve aliases for a specific collection (class) only. If not provided, returns all aliases.",
            "name": "class",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Successfully retrieved the list of aliases",
            "schema": {
              "$ref": "#/definitions/AliasResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid collection (class) parameter provided",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        }
      },
      "post": {
        "description": "Create a new alias mapping between an alias name and a collection (class). The alias acts as an alternative name for accessing the collection.",
        "tags": [
          "schema"
        ],
        "summary": "Create a new alias",
        "operationId": "aliases.create",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/Alias"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Successfully created a new alias for the specified collection (class)",
            "schema": {
              "$ref": "#/definitions/Alias"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid create alias request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        }
      }
    },
    "/aliases/{aliasName}": {
      "get": {
        "description": "Retrieve details about a specific alias by its name, including which collection (class) it points to.",
        "tags": [
          "schema"
        ],
        "summary": "Get an alias",
        "operationId": "aliases.get.alias",
        "parameters": [
          {
            "type": "string",
            "name": "aliasName",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Successfully retrieved the alias details.",
            "schema": {
              "$ref": "#/definitions/Alias"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Not Found - Alias does not exist",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid alias name provided.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        }
      },
      "put": {
        "description": "Update an existing alias to point to a different collection (class). This allows you to redirect an alias from one collection to another without changing the alias name.",
        "tags": [
          "schema"
        ],
        "summary": "Update an alias",
        "operationId": "aliases.update",
        "parameters": [
          {
            "type": "string",
            "name": "aliasName",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "type": "object",
              "properties": {
                "class": {
                  "description": "The new collection (class) that the alias should point to.",
                  "type": "string"
                }
              }
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Successfully updated the alias to point to the new collection (class).",
            "schema": {
              "$ref": "#/definitions/Alias"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Not Found - Alias does not exist",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid update alias request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        }
      },
      "delete": {
        "description": "Remove an existing alias from the system. This will delete the alias mapping but will not affect the underlying collection (class).",
        "tags": [
          "schema"
        ],
        "summary": "Delete an alias",
        "operationId": "aliases.delete",
        "parameters": [
          {
            "type": "string",
            "name": "aliasName",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "Successfully deleted the alias."
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Not Found - Alias does not exist",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid delete alias request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        }
      }
    },
    "/authz/groups/{groupType}": {
      "get": {
        "description": "Retrieves a list of all available group names for a specified group type (` + "`" + `oidc` + "`" + ` or ` + "`" + `db` + "`" + `).",
        "tags": [
          "authz"
        ],
        "summary": "List all groups of a specific type",
        "operationId": "getGroups",
        "parameters": [
          {
            "enum": [
              "oidc"
            ],
            "type": "string",
            "description": "The type of group to retrieve.",
            "name": "groupType",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A list of group names for the specified type.",
            "schema": {
              "type": "array",
              "items": {
                "type": "string"
              }
            }
          },
          "400": {
            "description": "Bad request",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.authz.get.groups"
        ]
      }
    },
    "/authz/groups/{id}/assign": {
      "post": {
        "description": "Assign roles to the specified group.",
        "tags": [
          "authz"
        ],
        "summary": "Assign a role to a group",
        "operationId": "assignRoleToGroup",
        "parameters": [
          {
            "type": "string",
            "description": "The name of the group.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "type": "object",
              "properties": {
                "groupType": {
                  "$ref": "#/definitions/GroupType"
                },
                "roles": {
                  "description": "The roles to assign to the specified group.",
                  "type": "array",
                  "items": {
                    "type": "string"
                  }
                }
              }
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Roles assigned successfully."
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Role or group not found."
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.authz.assign.role"
        ]
      }
    },
    "/authz/groups/{id}/revoke": {
      "post": {
        "description": "Revoke roles from the specified group.",
        "tags": [
          "authz"
        ],
        "summary": "Revoke a role from a group",
        "operationId": "revokeRoleFromGroup",
        "parameters": [
          {
            "type": "string",
            "description": "The name of the group.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "type": "object",
              "properties": {
                "groupType": {
                  "$ref": "#/definitions/GroupType"
                },
                "roles": {
                  "description": "The roles to revoke from the specified group.",
                  "type": "array",
                  "items": {
                    "type": "string"
                  }
                }
              }
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Roles revoked successfully."
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Role or group not found."
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.authz.revoke.role.group"
        ]
      }
    },
    "/authz/groups/{id}/roles/{groupType}": {
      "get": {
        "description": "Retrieves a list of all roles assigned to a specific group. The group must be identified by both its name (` + "`" + `id` + "`" + `) and its type (` + "`" + `db` + "`" + ` or ` + "`" + `oidc` + "`" + `).",
        "tags": [
          "authz"
        ],
        "summary": "Get roles assigned to a specific group",
        "operationId": "getRolesForGroup",
        "parameters": [
          {
            "type": "string",
            "description": "The unique name of the group.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "enum": [
              "oidc"
            ],
            "type": "string",
            "description": "The type of the group.",
            "name": "groupType",
            "in": "path",
            "required": true
          },
          {
            "type": "boolean",
            "default": false,
            "description": "If true, the response will include the full role definitions with all associated permissions. If false, only role names are returned.",
            "name": "includeFullRoles",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "A list of roles assigned to the specified group.",
            "schema": {
              "$ref": "#/definitions/RolesListResponse"
            }
          },
          "400": {
            "description": "Bad request",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "The specified group was not found."
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.authz.get.groups.roles"
        ]
      }
    },
    "/authz/roles": {
      "get": {
        "description": "Get all roles and their assigned permissions.",
        "tags": [
          "authz"
        ],
        "summary": "Get all roles",
        "operationId": "getRoles",
        "responses": {
          "200": {
            "description": "Successful response.",
            "schema": {
              "$ref": "#/definitions/RolesListResponse"
            }
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.authz.get.roles"
        ]
      },
      "post": {
        "description": "Create a new role with the specified permissions.",
        "tags": [
          "authz"
        ],
        "summary": "Create new role",
        "operationId": "createRole",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/Role"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Role created successfully."
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "409": {
            "description": "Role already exists.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.authz.create.role"
        ]
      }
    },
    "/authz/roles/{id}": {
      "get": {
        "description": "Fetch a role by its name.",
        "tags": [
          "authz"
        ],
        "summary": "Get a role",
        "operationId": "getRole",
        "parameters": [
          {
            "type": "string",
            "description": "The name of the role.",
            "name": "id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Successful response.",
            "schema": {
              "$ref": "#/definitions/Role"
            }
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "No role found."
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.authz.get.role"
        ]
      },
      "delete": {
        "description": "Deleting a role will remove it from the system, and revoke the associated permissions from all users who had this role.",
        "tags": [
          "authz"
        ],
        "summary": "Delete a role",
        "operationId": "deleteRole",
        "parameters": [
          {
            "type": "string",
            "description": "The name of the role.",
            "name": "id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "Successfully deleted."
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.authz.delete.role"
        ]
      }
    },
    "/authz/roles/{id}/add-permissions": {
      "post": {
        "description": "Add new permissions to an existing role without affecting current permissions.",
        "tags": [
          "authz"
        ],
        "summary": "Add permissions to a role",
        "operationId": "addPermissions",
        "parameters": [
          {
            "type": "string",
            "description": "The name (ID) of the role being modified.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "type": "object",
              "required": [
                "name",
                "permissions"
              ],
              "properties": {
                "permissions": {
                  "description": "Permissions to be added to the role.",
                  "type": "array",
                  "items": {
                    "$ref": "#/definitions/Permission"
                  }
                }
              }
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Permissions added successfully."
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "No role found."
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.authz.add.role.permissions"
        ]
      }
    },
    "/authz/roles/{id}/group-assignments": {
      "get": {
        "description": "Retrieves a list of all groups that have been assigned a specific role, identified by its name.",
        "tags": [
          "authz"
        ],
        "summary": "Get groups that have a specific role assigned",
        "operationId": "getGroupsForRole",
        "parameters": [
          {
            "type": "string",
            "description": "The unique name of the role.",
            "name": "id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Successfully retrieved the list of groups that have the role assigned.",
            "schema": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/GetGroupsForRoleOKBodyItems0"
              }
            }
          },
          "400": {
            "description": "Bad request",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "The specified role was not found."
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.authz.get.roles.groups"
        ]
      }
    },
    "/authz/roles/{id}/has-permission": {
      "post": {
        "description": "Check whether a role has the specified permissions.",
        "tags": [
          "authz"
        ],
        "summary": "Check whether a role possesses a permission",
        "operationId": "hasPermission",
        "parameters": [
          {
            "type": "string",
            "description": "The name of the role.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "description": "The permissions to be checked.",
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/Permission"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Permission check was successful.",
            "schema": {
              "type": "boolean"
            }
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.authz.has.role.permission"
        ]
      }
    },
    "/authz/roles/{id}/remove-permissions": {
      "post": {
        "description": "Permissions can be revoked from a specified role. Removing all permissions from a role will delete the role itself.",
        "tags": [
          "authz"
        ],
        "summary": "Remove permissions from a role",
        "operationId": "removePermissions",
        "parameters": [
          {
            "type": "string",
            "description": "The name of the role being modified.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "type": "object",
              "required": [
                "permissions"
              ],
              "properties": {
                "permissions": {
                  "description": "Permissions to remove from the role.",
                  "type": "array",
                  "items": {
                    "$ref": "#/definitions/Permission"
                  }
                }
              }
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Permissions removed successfully."
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "No role found."
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.authz.remove.role.permissions"
        ]
      }
    },
    "/authz/roles/{id}/user-assignments": {
      "get": {
        "description": "Fetch a list of users which have the specified role.",
        "tags": [
          "authz"
        ],
        "summary": "Get users assigned to a role",
        "operationId": "getUsersForRole",
        "parameters": [
          {
            "type": "string",
            "description": "The name (ID) of the role.",
            "name": "id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Users assigned to this role.",
            "schema": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/GetUsersForRoleOKBodyItems0"
              }
            }
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "No role found."
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.authz.get.roles.users"
        ]
      }
    },
    "/authz/roles/{id}/users": {
      "get": {
        "description": "Get all the users (` + "`" + `db` + "`" + ` + ` + "`" + `oidc` + "`" + `) who have been assigned a specific role. Deprecated, will be removed when v1.29 is not supported anymore.",
        "tags": [
          "authz"
        ],
        "summary": "Get users assigned to a role",
        "operationId": "getUsersForRoleDeprecated",
        "deprecated": true,
        "parameters": [
          {
            "type": "string",
            "description": "The name of the role.",
            "name": "id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Users assigned to this role.",
            "schema": {
              "type": "array",
              "items": {
                "type": "string"
              }
            }
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "No role found."
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.authz.get.roles.users"
        ]
      }
    },
    "/authz/users/{id}/assign": {
      "post": {
        "description": "Assign one or more roles to a user. Users can have multiple roles.",
        "tags": [
          "authz"
        ],
        "summary": "Assign a role to a user",
        "operationId": "assignRoleToUser",
        "parameters": [
          {
            "type": "string",
            "description": "The name of the user.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "type": "object",
              "properties": {
                "roles": {
                  "description": "The roles that are assigned to the specified user.",
                  "type": "array",
                  "items": {
                    "type": "string"
                  }
                },
                "userType": {
                  "$ref": "#/definitions/UserTypeInput"
                }
              }
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Role assigned successfully."
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Specified role or user not found.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.authz.assign.role.user"
        ]
      }
    },
    "/authz/users/{id}/revoke": {
      "post": {
        "description": "Remove one or more roles from a user.",
        "tags": [
          "authz"
        ],
        "summary": "Revoke a role from a user",
        "operationId": "revokeRoleFromUser",
        "parameters": [
          {
            "type": "string",
            "description": "The name of the user.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "type": "object",
              "properties": {
                "roles": {
                  "description": "The roles to revoke from the specified user.",
                  "type": "array",
                  "items": {
                    "type": "string"
                  }
                },
                "userType": {
                  "$ref": "#/definitions/UserTypeInput"
                }
              }
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Roles revoked successfully."
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Specified role or user not found.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.authz.revoke.role.user"
        ]
      }
    },
    "/authz/users/{id}/roles": {
      "get": {
        "description": "Retrieve the roles assigned to a specific user (` + "`" + `db` + "`" + ` + ` + "`" + `oidc` + "`" + `). Deprecated, will be removed when 1.29 is not supported anymore",
        "tags": [
          "authz"
        ],
        "summary": "Get roles assigned to a user",
        "operationId": "getRolesForUserDeprecated",
        "deprecated": true,
        "parameters": [
          {
            "type": "string",
            "description": "The name of the user.",
            "name": "id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Roles assigned to the user.",
            "schema": {
              "$ref": "#/definitions/RolesListResponse"
            }
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "No roles found for specified user."
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.authz.get.users.roles"
        ]
      }
    },
    "/authz/users/{id}/roles/{userType}": {
      "get": {
        "description": "Get all the roles for a specific user (` + "`" + `db` + "`" + ` or ` + "`" + `oidc` + "`" + `).",
        "tags": [
          "authz"
        ],
        "summary": "Get roles assigned to a user",
        "operationId": "getRolesForUser",
        "parameters": [
          {
            "type": "string",
            "description": "The name of the user.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "enum": [
              "oidc",
              "db"
            ],
            "type": "string",
            "description": "The type of the user.",
            "name": "userType",
            "in": "path",
            "required": true
          },
          {
            "type": "boolean",
            "default": false,
            "description": "Whether to include detailed role information like its assigned permissions.",
            "name": "includeFullRoles",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Roles assigned to the user.",
            "schema": {
              "$ref": "#/definitions/RolesListResponse"
            }
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "No roles found for specified user."
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.authz.get.users.roles"
        ]
      }
    },
    "/backups/{backend}": {
      "get": {
        "description": "List all created backups IDs, Status",
        "tags": [
          "backups"
        ],
        "summary": "List all created backups",
        "operationId": "backups.list",
        "parameters": [
          {
            "type": "string",
            "description": "Specifies the backend storage system to list backups from (e.g., ` + "`" + `filesystem` + "`" + `, ` + "`" + `gcs` + "`" + `, ` + "`" + `s3` + "`" + `, ` + "`" + `azure` + "`" + `).",
            "name": "backend",
            "in": "path",
            "required": true
          },
          {
            "enum": [
              "asc",
              "desc"
            ],
            "type": "string",
            "default": "desc",
            "description": "Order of returned list of backups based on creation time. (asc or desc)",
            "name": "order",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Successfully retrieved the list of backups in progress.",
            "schema": {
              "$ref": "#/definitions/BackupListResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid request to list backups.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An internal server error occurred while listing backups. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.local.backup"
        ]
      },
      "post": {
        "description": "Initiates the creation of a backup for specified collections on a designated backend storage.\u003cbr/\u003e\u003cbr/\u003eNotes:\u003cbr/\u003e- Backups are compressed using gzip by default.\u003cbr/\u003e- Weaviate remains operational during the backup process.",
        "tags": [
          "backups"
        ],
        "summary": "Create a backup",
        "operationId": "backups.create",
        "parameters": [
          {
            "type": "string",
            "description": "Specifies the backend storage system where the backup will be stored (e.g., ` + "`" + `filesystem` + "`" + `, ` + "`" + `gcs` + "`" + `, ` + "`" + `s3` + "`" + `, ` + "`" + `azure` + "`" + `).",
            "name": "backend",
            "in": "path",
            "required": true
          },
          {
            "description": "Details of the backup request, including the backup ID and collections to include or exclude.",
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/BackupCreateRequest"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Backup creation process initiated successfully. Check the status endpoint for progress.",
            "schema": {
              "$ref": "#/definitions/BackupCreateResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid backup creation request. Check the request body and backend configuration.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An internal server error occurred during backup initiation. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.local.backup"
        ]
      }
    },
    "/backups/{backend}/{id}": {
      "get": {
        "description": "Checks the status of a specific backup creation process identified by its ID on the specified backend.\u003cbr/\u003e\u003cbr/\u003eClient libraries often provide a 'wait for completion' feature that polls this endpoint automatically. Use this endpoint for manual status checks or if 'wait for completion' is disabled.",
        "tags": [
          "backups"
        ],
        "summary": "Get backup creation status",
        "operationId": "backups.create.status",
        "parameters": [
          {
            "type": "string",
            "description": "Specifies the backend storage system where the backup resides (e.g., ` + "`" + `filesystem` + "`" + `, ` + "`" + `gcs` + "`" + `, ` + "`" + `s3` + "`" + `, ` + "`" + `azure` + "`" + `).",
            "name": "backend",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "The unique identifier of the backup. Must be URL-safe and compatible with filesystem paths (only lowercase, numbers, underscore, minus characters allowed).",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Optional: Specifies the bucket, container, or volume name if required by the backend.",
            "name": "bucket",
            "in": "query"
          },
          {
            "type": "string",
            "description": "Optional: Specifies the path within the bucket/container/volume if the backup is not at the root.",
            "name": "path",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Successfully retrieved the status of the backup creation process.",
            "schema": {
              "$ref": "#/definitions/BackupCreateStatusResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Backup not found on the specified backend with the given ID.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid request to check backup creation status.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An internal server error occurred while checking backup status. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.local.backup"
        ]
      },
      "delete": {
        "description": "Cancels an ongoing backup operation identified by its ID.",
        "tags": [
          "backups"
        ],
        "summary": "Cancel a backup",
        "operationId": "backups.cancel",
        "parameters": [
          {
            "type": "string",
            "description": "Specifies the backend storage system where the backup resides (e.g., ` + "`" + `filesystem` + "`" + `, ` + "`" + `gcs` + "`" + `, ` + "`" + `s3` + "`" + `, ` + "`" + `azure` + "`" + `).",
            "name": "backend",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "The unique identifier of the backup to cancel. Must be URL-safe and compatible with filesystem paths (only lowercase, numbers, underscore, minus characters allowed).",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Optional: Specifies the bucket, container, or volume name if required by the backend.",
            "name": "bucket",
            "in": "query"
          },
          {
            "type": "string",
            "description": "Optional: Specifies the path within the bucket/container/volume if the backup is not at the root.",
            "name": "path",
            "in": "query"
          }
        ],
        "responses": {
          "204": {
            "description": "Backup canceled successfully."
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid backup cancellation request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An internal server error occurred during backup cancellation. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.local.backup"
        ]
      }
    },
    "/backups/{backend}/{id}/restore": {
      "get": {
        "description": "Checks the status of a specific backup restoration process identified by the backup ID on the specified backend.\u003cbr/\u003e\u003cbr/\u003eClient libraries often provide a 'wait for completion' feature that polls this endpoint automatically. Use this endpoint for manual status checks or if 'wait for completion' is disabled.",
        "tags": [
          "backups"
        ],
        "summary": "Get backup restoration status",
        "operationId": "backups.restore.status",
        "parameters": [
          {
            "type": "string",
            "description": "Specifies the backend storage system where the backup resides (e.g., ` + "`" + `filesystem` + "`" + `, ` + "`" + `gcs` + "`" + `, ` + "`" + `s3` + "`" + `, ` + "`" + `azure` + "`" + `).",
            "name": "backend",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "The unique identifier of the backup being restored. Must be URL-safe and compatible with filesystem paths (only lowercase, numbers, underscore, minus characters allowed).",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Optional: Specifies the bucket, container, or volume name if required by the backend.",
            "name": "bucket",
            "in": "query"
          },
          {
            "type": "string",
            "description": "Optional: Specifies the path within the bucket.",
            "name": "path",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Successfully retrieved the status of the backup restoration process.",
            "schema": {
              "$ref": "#/definitions/BackupRestoreStatusResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Backup not found on the specified backend with the given ID.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An internal server error occurred while checking restore status. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.local.backup"
        ]
      },
      "post": {
        "description": "Initiates the restoration of collections from a specified backup located on a designated backend.\u003cbr/\u003e\u003cbr/\u003eRequirements:\u003cbr/\u003e- Target cluster must have the same number of nodes as the source cluster where the backup was created.\u003cbr/\u003e- Collections included in the restore must not already exist on the target cluster.\u003cbr/\u003e- Node names must match between the backup and the target cluster.",
        "tags": [
          "backups"
        ],
        "summary": "Restore from a backup",
        "operationId": "backups.restore",
        "parameters": [
          {
            "type": "string",
            "description": "Specifies the backend storage system where the backup resides (e.g., ` + "`" + `filesystem` + "`" + `, ` + "`" + `gcs` + "`" + `, ` + "`" + `s3` + "`" + `, ` + "`" + `azure` + "`" + `).",
            "name": "backend",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "The unique identifier of the backup to restore from. Must be URL-safe and compatible with filesystem paths (only lowercase, numbers, underscore, minus characters allowed).",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "description": "Details of the restore request, including collections to include or exclude and node mapping if necessary.",
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/BackupRestoreRequest"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Backup restoration process initiated successfully. Check the status endpoint for progress.",
            "schema": {
              "$ref": "#/definitions/BackupRestoreResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Backup not found on the specified backend with the given ID.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid backup restoration request. Check requirements and request body.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An internal server error occurred during restore initiation. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.local.backup"
        ]
      }
    },
    "/batch/objects": {
      "post": {
        "description": "Registers multiple data objects in a single request for efficiency. Metadata and schema values for each object are validated.\u003cbr/\u003e\u003cbr/\u003e**Note (idempotence)**:\u003cbr/\u003eThis operation is idempotent based on the object UUIDs provided. If an object with a given UUID already exists, it will be overwritten (similar to a PUT operation for that specific object within the batch).",
        "tags": [
          "batch",
          "objects"
        ],
        "summary": "Create objects in batch",
        "operationId": "batch.objects.create",
        "parameters": [
          {
            "description": "The request body containing the objects to be created.",
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "type": "object",
              "properties": {
                "fields": {
                  "description": "Controls which fields are returned in the response for each object. Default is ` + "`" + `ALL` + "`" + `.",
                  "type": "array",
                  "items": {
                    "type": "string",
                    "default": "ALL",
                    "enum": [
                      "ALL",
                      "class",
                      "schema",
                      "id",
                      "creationTimeUnix"
                    ]
                  }
                },
                "objects": {
                  "description": "Array of objects to be created.",
                  "type": "array",
                  "items": {
                    "$ref": "#/definitions/Object"
                  }
                }
              }
            }
          },
          {
            "type": "string",
            "description": "Determines how many replicas must acknowledge a request before it is considered successful.",
            "name": "consistency_level",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Request processed successfully. Individual object statuses are provided in the response body.",
            "schema": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/ObjectsGetResponse"
              }
            }
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request. Ensure the collection exists and the object properties are valid.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error occurred while trying to fulfill the request. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.add"
        ]
      },
      "delete": {
        "description": "Removes multiple data objects based on a filter specified in the request body.\u003cbr/\u003e\u003cbr/\u003eDeletion occurs based on the filter criteria provided in the ` + "`" + `where` + "`" + ` clause. There is a configurable limit (default 10,000, set via ` + "`" + `QUERY_MAXIMUM_RESULTS` + "`" + `) on how many objects can be deleted in a single batch request to prevent excessive resource usage. Objects are deleted in the order they match the filter. To delete more objects than the limit allows, repeat the request until no more matching objects are found.",
        "tags": [
          "batch",
          "objects"
        ],
        "summary": "Delete objects in batch",
        "operationId": "batch.objects.delete",
        "parameters": [
          {
            "description": "The request body containing the match filter and output configuration.",
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/BatchDelete"
            }
          },
          {
            "type": "string",
            "description": "Determines how many replicas must acknowledge a request before it is considered successful.",
            "name": "consistency_level",
            "in": "query"
          },
          {
            "type": "string",
            "description": "Specifies the tenant in a request targeting a multi-tenant collection (class).",
            "name": "tenant",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Request processed successfully. See response body for matching objects and deletion results.",
            "schema": {
              "$ref": "#/definitions/BatchDeleteResponse"
            }
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid data provided. Please check the values in your request (e.g., invalid filter).",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error occurred while trying to fulfill the request. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.manipulate"
        ]
      }
    },
    "/batch/references": {
      "post": {
        "description": "Batch create cross-references between collection items in bulk.",
        "tags": [
          "batch",
          "references"
        ],
        "summary": "Create cross-references in bulk",
        "operationId": "batch.references.create",
        "parameters": [
          {
            "description": "A list of references to be batched. The ideal size depends on the used database connector. Please see the documentation of the used connector for help.",
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/BatchReference"
              }
            }
          },
          {
            "type": "string",
            "description": "Determines how many replicas must acknowledge a request before it is considered successful.",
            "name": "consistency_level",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Request Successful. Warning: A successful request does not guarantee that every batched reference was successfully created. Inspect the response body to see which references succeeded and which failed.",
            "schema": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/BatchReferenceResponse"
              }
            }
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request. Ensure the collection exists and the object properties are valid.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.add"
        ]
      }
    },
    "/classifications/": {
      "post": {
        "description": "Initiates a background classification task based on the provided parameters. Use the GET /classifications/{id} endpoint to monitor the status and retrieve results.",
        "tags": [
          "classifications"
        ],
        "summary": "Start a classification",
        "operationId": "classifications.post",
        "parameters": [
          {
            "description": "Configuration parameters for the classification task, including type, target properties, and training data references.",
            "name": "params",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/Classification"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Classification task successfully initiated. The response body contains the classification details including its ID.",
            "schema": {
              "$ref": "#/definitions/Classification"
            }
          },
          "400": {
            "description": "Invalid request body or parameters.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An internal server error occurred while starting the classification task. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.classifications.post"
        ]
      }
    },
    "/classifications/{id}": {
      "get": {
        "description": "Retrieves the status, metadata, and results (if completed) of a classification task identified by its unique ID.",
        "tags": [
          "classifications"
        ],
        "summary": "Get classification status",
        "operationId": "classifications.get",
        "parameters": [
          {
            "type": "string",
            "description": "The unique identifier (UUID) of the classification task.",
            "name": "id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Successfully retrieved the classification details.",
            "schema": {
              "$ref": "#/definitions/Classification"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Classification with the given ID not found."
          },
          "500": {
            "description": "An internal server error occurred while retrieving the classification status. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.classifications.get"
        ]
      }
    },
    "/cluster/statistics": {
      "get": {
        "description": "Provides statistics about the internal Raft consensus protocol state for the Weaviate cluster.",
        "tags": [
          "cluster"
        ],
        "summary": "Get cluster statistics",
        "operationId": "cluster.get.statistics",
        "responses": {
          "200": {
            "description": "Successfully retrieved Raft cluster statistics.",
            "schema": {
              "$ref": "#/definitions/ClusterStatisticsResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid request for cluster statistics.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An internal server error occurred while retrieving cluster statistics. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.cluster.statistics.get"
        ]
      }
    },
    "/graphql": {
      "post": {
        "description": "Executes a single GraphQL query provided in the request body. Use this endpoint for all Weaviate data queries and exploration.",
        "tags": [
          "graphql"
        ],
        "summary": "Perform a GraphQL query",
        "operationId": "graphql.post",
        "parameters": [
          {
            "description": "The GraphQL query to execute, including the query string and optional variables.",
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/GraphQLQuery"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Query executed successfully. The response body contains the query result.",
            "schema": {
              "$ref": "#/definitions/GraphQLResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An internal server error occurred during query execution. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.query",
          "weaviate.local.query.meta",
          "weaviate.network.query",
          "weaviate.network.query.meta"
        ]
      }
    },
    "/graphql/batch": {
      "post": {
        "description": "Executes multiple GraphQL queries provided in the request body as an array. Allows performing several queries in a single network request for efficiency.",
        "tags": [
          "graphql"
        ],
        "summary": "Perform batched GraphQL queries",
        "operationId": "graphql.batch",
        "parameters": [
          {
            "description": "An array containing multiple GraphQL query objects to execute in batch.",
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/GraphQLQueries"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Batch request processed successfully. The response body contains an array of results corresponding to the input queries.",
            "schema": {
              "$ref": "#/definitions/GraphQLResponses"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An internal server error occurred during batch query execution. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.query",
          "weaviate.local.query.meta",
          "weaviate.network.query",
          "weaviate.network.query.meta"
        ]
      }
    },
    "/meta": {
      "get": {
        "description": "Provides meta-information about the running Weaviate instance, including its version, loaded modules, and network hostname. This information can be useful for monitoring, compatibility checks, or inter-instance communication.",
        "tags": [
          "meta"
        ],
        "summary": "Get instance metadata",
        "operationId": "meta.get",
        "responses": {
          "200": {
            "description": "Successfully retrieved meta information.",
            "schema": {
              "$ref": "#/definitions/Meta"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An internal server error occurred while retrieving meta information. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.query.meta"
        ]
      }
    },
    "/nodes": {
      "get": {
        "description": "Retrieves status information about all nodes in the cluster. Use the ` + "`" + `output` + "`" + ` query parameter to control the level of detail.",
        "tags": [
          "nodes"
        ],
        "summary": "Get node status",
        "operationId": "nodes.get",
        "parameters": [
          {
            "type": "string",
            "default": "minimal",
            "description": "Controls the verbosity of the output, possible values are: ` + "`" + `minimal` + "`" + `, ` + "`" + `verbose` + "`" + `. Defaults to ` + "`" + `minimal` + "`" + `.",
            "name": "output",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Successfully retrieved the status for all nodes.",
            "schema": {
              "$ref": "#/definitions/NodesStatusResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Not Found.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid request for node status.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An internal server error occurred while retrieving node status. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.nodes.status.get"
        ]
      }
    },
    "/nodes/{className}": {
      "get": {
        "description": "Retrieves status information only for the nodes that host shards for the specified collection (` + "`" + `className` + "`" + `). Use the ` + "`" + `output` + "`" + ` query parameter to control the level of detail.",
        "tags": [
          "nodes"
        ],
        "summary": "Get node status by collection",
        "operationId": "nodes.get.class",
        "parameters": [
          {
            "type": "string",
            "description": "The name of the collection (class) for which to retrieve node status.",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "shardName",
            "in": "query"
          },
          {
            "type": "string",
            "default": "minimal",
            "description": "Controls the verbosity of the output, possible values are: ` + "`" + `minimal` + "`" + `, ` + "`" + `verbose` + "`" + `. Defaults to ` + "`" + `minimal` + "`" + `.",
            "name": "output",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Successfully retrieved the status for nodes relevant to the specified collection.",
            "schema": {
              "$ref": "#/definitions/NodesStatusResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Not Found.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid request for node status.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An internal server error occurred while retrieving node status for the collection. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.nodes.status.get.class"
        ]
      }
    },
    "/objects": {
      "get": {
        "description": "Retrieves a list of data objects. By default, objects are returned in reverse order of creation. Requires a collection name (` + "`" + `class` + "`" + `) parameter to specify which collection's objects to list, otherwise, returns an empty list.",
        "tags": [
          "objects"
        ],
        "summary": "List objects",
        "operationId": "objects.list",
        "parameters": [
          {
            "type": "string",
            "description": "A threshold UUID of the objects to retrieve after, using an UUID-based ordering. This object is not part of the set. \u003cbr/\u003e\u003cbr/\u003eMust be used with collection name (` + "`" + `class` + "`" + `), typically in conjunction with ` + "`" + `limit` + "`" + `. \u003cbr/\u003e\u003cbr/\u003eNote ` + "`" + `after` + "`" + ` cannot be used with ` + "`" + `offset` + "`" + ` or ` + "`" + `sort` + "`" + `. \u003cbr/\u003e\u003cbr/\u003eFor a null value similar to offset=0, set an empty string in the request, i.e. ` + "`" + `after=` + "`" + ` or ` + "`" + `after` + "`" + `.",
            "name": "after",
            "in": "query"
          },
          {
            "type": "integer",
            "format": "int64",
            "default": 0,
            "description": "The starting index of the result window. Note ` + "`" + `offset` + "`" + ` will retrieve ` + "`" + `offset+limit` + "`" + ` results and return ` + "`" + `limit` + "`" + ` results from the object with index ` + "`" + `offset` + "`" + ` onwards. Limited by the value of ` + "`" + `QUERY_MAXIMUM_RESULTS` + "`" + `. \u003cbr/\u003e\u003cbr/\u003eShould be used in conjunction with ` + "`" + `limit` + "`" + `. \u003cbr/\u003e\u003cbr/\u003eCannot be used with ` + "`" + `after` + "`" + `.",
            "name": "offset",
            "in": "query"
          },
          {
            "type": "integer",
            "format": "int64",
            "description": "The maximum number of items to be returned per page. The default is 25 unless set otherwise as an environment variable.",
            "name": "limit",
            "in": "query"
          },
          {
            "type": "string",
            "description": "Include additional information, such as classification information. Allowed values include: ` + "`" + `classification` + "`" + `, ` + "`" + `vector` + "`" + ` and ` + "`" + `interpretation` + "`" + `.",
            "name": "include",
            "in": "query"
          },
          {
            "type": "string",
            "description": "Name(s) of the property to sort by - e.g. ` + "`" + `city` + "`" + `, or ` + "`" + `country,city` + "`" + `.",
            "name": "sort",
            "in": "query"
          },
          {
            "type": "string",
            "description": "Order parameter to tell how to order (asc or desc) data within given field. Should be used in conjunction with ` + "`" + `sort` + "`" + ` parameter. If providing multiple ` + "`" + `sort` + "`" + ` values, provide multiple ` + "`" + `order` + "`" + ` values in corresponding order, e.g.: ` + "`" + `sort=author_name,title\u0026order=desc,asc` + "`" + `.",
            "name": "order",
            "in": "query"
          },
          {
            "type": "string",
            "description": "The collection from which to query objects.  \u003cbr/\u003e\u003cbr/\u003eNote that if the collection name (` + "`" + `class` + "`" + `) is not provided, the response will not include any objects.",
            "name": "class",
            "in": "query"
          },
          {
            "type": "string",
            "description": "Specifies the tenant in a request targeting a multi-tenant collection (class).",
            "name": "tenant",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful response containing the list of objects. If the collection name (` + "`" + `class` + "`" + `) is not provided, the response will not include any objects.",
            "schema": {
              "$ref": "#/definitions/ObjectsListResponse"
            }
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Successful query result but no matching objects were found."
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request. Ensure the specified collection exists.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error occurred while trying to fulfill the request. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.query"
        ]
      },
      "post": {
        "description": "Creates a new data object. The object's metadata and schema values are validated before creation.\u003cbr/\u003e\u003cbr/\u003e**Note (batch import)**:\u003cbr/\u003eIf you plan on importing a large number of objects, using the ` + "`" + `/batch/objects` + "`" + ` endpoint is significantly more efficient than sending multiple single requests.\u003cbr/\u003e\u003cbr/\u003e**Note (idempotence)**:\u003cbr/\u003eThis operation (POST) fails if an object with the provided ID already exists. To update an existing object, use the PUT or PATCH methods.",
        "tags": [
          "objects"
        ],
        "summary": "Create an object",
        "operationId": "objects.create",
        "parameters": [
          {
            "description": "The object to be created.",
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/Object"
            }
          },
          {
            "type": "string",
            "description": "Determines how many replicas must acknowledge a request before it is considered successful.",
            "name": "consistency_level",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Object created successfully.",
            "schema": {
              "$ref": "#/definitions/Object"
            }
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request. Ensure the collection exists and the object properties are valid.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error occurred while trying to fulfill the request. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.add"
        ]
      }
    },
    "/objects/validate": {
      "post": {
        "description": "Checks if a data object's structure conforms to the specified collection schema and metadata rules without actually storing the object.\u003cbr/\u003e\u003cbr/\u003eA successful validation returns a 200 OK status code with no body. If validation fails, an error response with details is returned.",
        "tags": [
          "objects"
        ],
        "summary": "Validate an object",
        "operationId": "objects.validate",
        "parameters": [
          {
            "description": "The object definition to validate.",
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/Object"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Object is valid according to the schema."
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Request body is well-formed but the object is invalid according to the schema.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error occurred while trying to fulfill the request. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.query.meta"
        ]
      }
    },
    "/objects/{className}/{id}": {
      "get": {
        "description": "Get a data object based on its collection name (` + "`" + `className` + "`" + `) and UUID (` + "`" + `id` + "`" + `).",
        "tags": [
          "objects"
        ],
        "summary": "Get an object",
        "operationId": "objects.class.get",
        "parameters": [
          {
            "type": "string",
            "description": "Name of the collection (class) the object belongs to.",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "Unique UUID of the object to be retrieved.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Include additional information, such as classification information. Allowed values include: ` + "`" + `classification` + "`" + `, ` + "`" + `vector` + "`" + ` and ` + "`" + `interpretation` + "`" + `.",
            "name": "include",
            "in": "query"
          },
          {
            "type": "string",
            "description": "Determines how many replicas must acknowledge a request before it is considered successful.",
            "name": "consistency_level",
            "in": "query"
          },
          {
            "type": "string",
            "description": "The target node which should fulfill the request.",
            "name": "node_name",
            "in": "query"
          },
          {
            "type": "string",
            "description": "Specifies the tenant in a request targeting a multi-tenant collection (class).",
            "name": "tenant",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful response containing the object.",
            "schema": {
              "$ref": "#/definitions/Object"
            }
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Object not found."
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error occurred while trying to fulfill the request. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.query"
        ]
      },
      "put": {
        "description": "Replaces properties of an existing data object. The object is identified by its collection name (` + "`" + `className` + "`" + `) and UUID (` + "`" + `id` + "`" + `). The request body must contain the complete object definition with the new property values.",
        "tags": [
          "objects"
        ],
        "summary": "Replace an object",
        "operationId": "objects.class.put",
        "parameters": [
          {
            "type": "string",
            "description": "Name of the collection (class) the object belongs to.",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "Unique UUID of the object to be replaced.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "description": "The object definition to replace the existing object with.",
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/Object"
            }
          },
          {
            "type": "string",
            "description": "Determines how many replicas must acknowledge a request before it is considered successful.",
            "name": "consistency_level",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Object replaced successfully.",
            "schema": {
              "$ref": "#/definitions/Object"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Object not found."
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request. Ensure the collection exists and the object properties are valid.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error occurred while trying to fulfill the request. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.manipulate"
        ]
      },
      "delete": {
        "description": "Removes a data object from a specific collection, identified by its collection name (` + "`" + `className` + "`" + `) and UUID (` + "`" + `id` + "`" + `).\u003cbr/\u003e\u003cbr/\u003e**Note on deleting references (legacy format):**\u003cbr/\u003eFor backward compatibility with older beacon formats (lacking a collection name), deleting a reference requires the beacon in the request to exactly match the stored format. Beacons always use ` + "`" + `localhost` + "`" + ` as the host, indicating the target is within the same Weaviate instance.",
        "tags": [
          "objects"
        ],
        "summary": "Delete an object",
        "operationId": "objects.class.delete",
        "parameters": [
          {
            "type": "string",
            "description": "Name of the collection (class) the object belongs to.",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "Unique UUID of the object to be deleted.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Determines how many replicas must acknowledge a request before it is considered successful.",
            "name": "consistency_level",
            "in": "query"
          },
          {
            "type": "string",
            "description": "Specifies the tenant in a request targeting a multi-tenant collection (class).",
            "name": "tenant",
            "in": "query"
          }
        ],
        "responses": {
          "204": {
            "description": "Object deleted successfully."
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Object not found."
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error occurred while trying to fulfill the request. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": true,
        "x-available-in-websocket": true,
        "x-serviceIds": [
          "weaviate.local.manipulate"
        ]
      },
      "head": {
        "description": "Verifies the existence of a specific data object within a collection (class), identified by its collection name (` + "`" + `className` + "`" + `) and UUID (` + "`" + `id` + "`" + `), without returning the object itself.\u003cbr/\u003e\u003cbr/\u003eThis is faster than a GET request as it avoids retrieving and processing object data. Existence is confirmed by a 204 No Content status code, while non-existence results in a 404 Not Found.",
        "tags": [
          "objects"
        ],
        "summary": "Check if an object exists",
        "operationId": "objects.class.head",
        "parameters": [
          {
            "type": "string",
            "description": "Name of the collection (class) the object belongs to.",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "Unique UUID of the object to check.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Determines how many replicas must acknowledge a request before it is considered successful.",
            "name": "consistency_level",
            "in": "query"
          },
          {
            "type": "string",
            "description": "Specifies the tenant in a request targeting a multi-tenant collection (class).",
            "name": "tenant",
            "in": "query"
          }
        ],
        "responses": {
          "204": {
            "description": "Object exists."
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Object does not exist."
          },
          "422": {
            "description": "Invalid data provided. Please check the values in your request (e.g., invalid UUID format).",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error occurred while trying to fulfill the request. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": true,
        "x-available-in-websocket": true,
        "x-serviceIds": [
          "weaviate.local.manipulate"
        ]
      },
      "patch": {
        "description": "Updates specific properties of an existing data object using JSON merge patch semantics (RFC 7396). The object is identified by its collection name (` + "`" + `className` + "`" + `) and UUID (` + "`" + `id` + "`" + `). Only the fields provided in the request body are modified. Metadata and schema values are validated, and the object's ` + "`" + `lastUpdateTimeUnix` + "`" + ` is updated.",
        "tags": [
          "objects"
        ],
        "summary": "Patch an object",
        "operationId": "objects.class.patch",
        "parameters": [
          {
            "type": "string",
            "description": "Name of the collection (class) the object belongs to.",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "Unique UUID of the object to be patched.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "description": "RFC 7396-style JSON merge patch object containing the fields to update.",
            "name": "body",
            "in": "body",
            "schema": {
              "$ref": "#/definitions/Object"
            }
          },
          {
            "type": "string",
            "description": "Determines how many replicas must acknowledge a request before it is considered successful.",
            "name": "consistency_level",
            "in": "query"
          }
        ],
        "responses": {
          "204": {
            "description": "Object patched successfully."
          },
          "400": {
            "description": "Malformed patch request body.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Object not found."
          },
          "422": {
            "description": "The patch object is valid JSON but is unprocessable for other reasons (e.g., invalid schema).",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error occurred while trying to fulfill the request. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.manipulate"
        ]
      }
    },
    "/objects/{className}/{id}/references/{propertyName}": {
      "put": {
        "description": "Replaces all existing references for a specific reference property (` + "`" + `propertyName` + "`" + `) on a source data object. The source object is identified by its collection name (` + "`" + `className` + "`" + `) and UUID (` + "`" + `id` + "`" + `). The new set of references is provided in the request body.",
        "tags": [
          "objects"
        ],
        "summary": "Replace object references",
        "operationId": "objects.class.references.put",
        "parameters": [
          {
            "type": "string",
            "description": "Name of the collection (class) the source object belongs to.",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "Unique UUID of the source object.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Unique name of the reference property of the source object.",
            "name": "propertyName",
            "in": "path",
            "required": true
          },
          {
            "description": "The new list of references.",
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/MultipleRef"
            }
          },
          {
            "type": "string",
            "description": "Determines how many replicas must acknowledge a request before it is considered successful.",
            "name": "consistency_level",
            "in": "query"
          },
          {
            "type": "string",
            "description": "Specifies the tenant in a request targeting a multi-tenant collection (class).",
            "name": "tenant",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "References replaced successfully."
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Source object not found."
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request. Ensure the property exists and is a reference type.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error occurred while trying to fulfill the request. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.manipulate"
        ]
      },
      "post": {
        "description": "Adds a new reference to a reference property (` + "`" + `propertyName` + "`" + `) on a source data object. The source object is identified by its collection name (` + "`" + `className` + "`" + `) and UUID (` + "`" + `id` + "`" + `). The reference to add is specified in the request body.",
        "tags": [
          "objects"
        ],
        "summary": "Add an object reference",
        "operationId": "objects.class.references.create",
        "parameters": [
          {
            "type": "string",
            "description": "Name of the collection (class) the source object belongs to.",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "Unique UUID of the source object.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Unique name of the reference property of the source object.",
            "name": "propertyName",
            "in": "path",
            "required": true
          },
          {
            "description": "The reference to add.",
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/SingleRef"
            }
          },
          {
            "type": "string",
            "description": "Determines how many replicas must acknowledge a request before it is considered successful.",
            "name": "consistency_level",
            "in": "query"
          },
          {
            "type": "string",
            "description": "Specifies the tenant in a request targeting a multi-tenant collection (class).",
            "name": "tenant",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Reference added successfully."
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Source object not found."
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request. Ensure the property exists and is a reference type.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error occurred while trying to fulfill the request. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.manipulate"
        ]
      },
      "delete": {
        "description": "Removes a specific reference from a reference property (` + "`" + `propertyName` + "`" + `) of a source data object. The source object is identified by its collection name (` + "`" + `className` + "`" + `) and UUID (` + "`" + `id` + "`" + `). The reference to remove is specified in the request body.",
        "tags": [
          "objects"
        ],
        "summary": "Delete an object reference",
        "operationId": "objects.class.references.delete",
        "parameters": [
          {
            "type": "string",
            "description": "Name of the collection (class) the source object belongs to.",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "Unique UUID of the source object.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Unique name of the reference property of the source object.",
            "name": "propertyName",
            "in": "path",
            "required": true
          },
          {
            "description": "The reference to remove.",
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/SingleRef"
            }
          },
          {
            "type": "string",
            "description": "Determines how many replicas must acknowledge a request before it is considered successful.",
            "name": "consistency_level",
            "in": "query"
          },
          {
            "type": "string",
            "description": "Specifies the tenant in a request targeting a multi-tenant collection (class).",
            "name": "tenant",
            "in": "query"
          }
        ],
        "responses": {
          "204": {
            "description": "Reference deleted successfully."
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Object or reference not found.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request. Ensure the property exists and is a reference type.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error occurred while trying to fulfill the request. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.manipulate"
        ]
      }
    },
    "/objects/{id}": {
      "get": {
        "description": "Get a specific object based on its UUID. Also available as Websocket bus. \u003cbr/\u003e\u003cbr/\u003e**Note**: This endpoint is deprecated and will be removed in a future version. Use the ` + "`" + `/objects/{className}/{id}` + "`" + ` endpoint instead.",
        "tags": [
          "objects"
        ],
        "summary": "Get an object",
        "operationId": "objects.get",
        "deprecated": true,
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "Unique UUID of the object to be retrieved.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Include additional information, such as classification information. Allowed values include: ` + "`" + `classification` + "`" + `, ` + "`" + `vector` + "`" + ` and ` + "`" + `interpretation` + "`" + `.",
            "name": "include",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful response containing the object.",
            "schema": {
              "$ref": "#/definitions/Object"
            }
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Object not found."
          },
          "500": {
            "description": "An error occurred while trying to fulfill the request. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.query"
        ]
      },
      "put": {
        "description": "Updates an object based on its UUID. Given meta-data and schema values are validated. ` + "`" + `lastUpdateTimeUnix` + "`" + ` is set to the time this function is called. \u003cbr/\u003e\u003cbr/\u003e**Note**: This endpoint is deprecated and will be removed in a future version. Use the ` + "`" + `/objects/{className}/{id}` + "`" + ` endpoint instead.",
        "tags": [
          "objects"
        ],
        "summary": "Update an object",
        "operationId": "objects.update",
        "deprecated": true,
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "Unique UUID of the object to be replaced.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "description": "The object definition to replace the existing object with.",
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/Object"
            }
          },
          {
            "type": "string",
            "description": "Determines how many replicas must acknowledge a request before it is considered successful.",
            "name": "consistency_level",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Object replaced successfully.",
            "schema": {
              "$ref": "#/definitions/Object"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Object not found."
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request. Ensure the collection exists and the object properties are valid.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error occurred while trying to fulfill the request. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.manipulate"
        ]
      },
      "delete": {
        "description": "Deletes an object from the database based on its UUID. \u003cbr/\u003e\u003cbr/\u003e**Note**: This endpoint is deprecated and will be removed in a future version. Use the ` + "`" + `/objects/{className}/{id}` + "`" + ` endpoint instead.",
        "tags": [
          "objects"
        ],
        "summary": "Delete an object",
        "operationId": "objects.delete",
        "deprecated": true,
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "Unique UUID of the object to be deleted.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Determines how many replicas must acknowledge a request before it is considered successful.",
            "name": "consistency_level",
            "in": "query"
          },
          {
            "type": "string",
            "description": "Specifies the tenant in a request targeting a multi-tenant collection (class).",
            "name": "tenant",
            "in": "query"
          }
        ],
        "responses": {
          "204": {
            "description": "Object deleted successfully."
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Object not found."
          },
          "500": {
            "description": "An error occurred while trying to fulfill the request. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": true,
        "x-available-in-websocket": true,
        "x-serviceIds": [
          "weaviate.local.manipulate"
        ]
      },
      "head": {
        "description": "Checks if an object exists in the system based on its UUID. \u003cbr/\u003e\u003cbr/\u003e**Note**: This endpoint is deprecated and will be removed in a future version. Use the ` + "`" + `/objects/{className}/{id}` + "`" + ` endpoint instead.",
        "tags": [
          "objects"
        ],
        "summary": "Check if an object exists",
        "operationId": "objects.head",
        "deprecated": true,
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "Unique UUID of the object to check.",
            "name": "id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "Object exists."
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Object does not exist."
          },
          "500": {
            "description": "An error occurred while trying to fulfill the request. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": true,
        "x-available-in-websocket": true,
        "x-serviceIds": [
          "weaviate.objects.check"
        ]
      },
      "patch": {
        "description": "Update an object based on its UUID (using patch semantics). This method supports json-merge style patch semantics (RFC 7396). Provided meta-data and schema values are validated. ` + "`" + `lastUpdateTimeUnix` + "`" + ` is set to the time this function is called. \u003cbr/\u003e\u003cbr/\u003e**Note**: This endpoint is deprecated and will be removed in a future version. Use the ` + "`" + `/objects/{className}/{id}` + "`" + ` endpoint instead.",
        "tags": [
          "objects"
        ],
        "summary": "Patch an object",
        "operationId": "objects.patch",
        "deprecated": true,
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "Unique UUID of the object to be patched.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "description": "RFC 7396-style JSON merge patch object containing the fields to update.",
            "name": "body",
            "in": "body",
            "schema": {
              "$ref": "#/definitions/Object"
            }
          },
          {
            "type": "string",
            "description": "Determines how many replicas must acknowledge a request before it is considered successful.",
            "name": "consistency_level",
            "in": "query"
          }
        ],
        "responses": {
          "204": {
            "description": "Object patched successfully."
          },
          "400": {
            "description": "Malformed patch request body."
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Object not found."
          },
          "422": {
            "description": "The patch object is valid JSON but is unprocessable for other reasons (e.g., invalid schema).",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error occurred while trying to fulfill the request. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.manipulate"
        ]
      }
    },
    "/objects/{id}/references/{propertyName}": {
      "put": {
        "description": "Replace all references in cross-reference property of an object. \u003cbr/\u003e\u003cbr/\u003e**Note**: This endpoint is deprecated and will be removed in a future version. Use the ` + "`" + `/objects/{className}/{id}/references/{propertyName}` + "`" + ` endpoint instead.",
        "tags": [
          "objects"
        ],
        "summary": "Replace object references",
        "operationId": "objects.references.update",
        "deprecated": true,
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "Unique UUID of the source object.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Unique name of the reference property of the source object.",
            "name": "propertyName",
            "in": "path",
            "required": true
          },
          {
            "description": "The new list of references.",
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/MultipleRef"
            }
          },
          {
            "type": "string",
            "description": "Specifies the tenant in a request targeting a multi-tenant collection (class).",
            "name": "tenant",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "References replaced successfully."
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request. Ensure the property exists and is a reference type.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error occurred while trying to fulfill the request. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.manipulate"
        ]
      },
      "post": {
        "description": "Add a reference to a specific property of a data object. \u003cbr/\u003e\u003cbr/\u003e**Note**: This endpoint is deprecated and will be removed in a future version. Use the ` + "`" + `/objects/{className}/{id}/references/{propertyName}` + "`" + ` endpoint instead.",
        "tags": [
          "objects"
        ],
        "summary": "Add an object reference",
        "operationId": "objects.references.create",
        "deprecated": true,
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "Unique UUID of the source object.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Unique name of the reference property of the source object.",
            "name": "propertyName",
            "in": "path",
            "required": true
          },
          {
            "description": "The reference to add.",
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/SingleRef"
            }
          },
          {
            "type": "string",
            "description": "Specifies the tenant in a request targeting a multi-tenant collection (class).",
            "name": "tenant",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Reference added successfully."
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request. Ensure the property exists and is a reference type.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error occurred while trying to fulfill the request. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.manipulate"
        ]
      },
      "delete": {
        "description": "Delete the single reference that is given in the body from the list of references that this property has. \u003cbr/\u003e\u003cbr/\u003e**Note**: This endpoint is deprecated and will be removed in a future version. Use the ` + "`" + `/objects/{className}/{id}/references/{propertyName}` + "`" + ` endpoint instead.",
        "tags": [
          "objects"
        ],
        "summary": "Delete an object reference",
        "operationId": "objects.references.delete",
        "deprecated": true,
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "Unique UUID of the source object.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Unique name of the reference property of the source object.",
            "name": "propertyName",
            "in": "path",
            "required": true
          },
          {
            "description": "The reference to remove.",
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/SingleRef"
            }
          },
          {
            "type": "string",
            "description": "Specifies the tenant in a request targeting a multi-tenant collection (class).",
            "name": "tenant",
            "in": "query"
          }
        ],
        "responses": {
          "204": {
            "description": "Reference deleted successfully."
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Object or reference not found.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error occurred while trying to fulfill the request. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.manipulate"
        ]
      }
    },
    "/replication/replicate": {
      "post": {
        "description": "Begins an asynchronous operation to move or copy a specific shard replica from its current node to a designated target node. The operation involves copying data, synchronizing, and potentially decommissioning the source replica.",
        "tags": [
          "replication"
        ],
        "summary": "Initiate a replica movement",
        "operationId": "replicate",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/ReplicationReplicateReplicaRequest"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Replication operation registered successfully. ID of the operation is returned.",
            "schema": {
              "$ref": "#/definitions/ReplicationReplicateReplicaResponse"
            }
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "501": {
            "description": "Replica movement operations are disabled.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.replication.replicate"
        ]
      },
      "delete": {
        "description": "Schedules all replication operations for deletion across all collections, shards, and nodes.",
        "tags": [
          "replication"
        ],
        "summary": "Delete all replication operations",
        "operationId": "deleteAllReplications",
        "responses": {
          "204": {
            "description": "Replication operation registered successfully"
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "501": {
            "description": "Replica movement operations are disabled.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.replication.deleteAllReplications"
        ]
      }
    },
    "/replication/replicate/force-delete": {
      "post": {
        "description": "USE AT OWN RISK! Synchronously force delete operations from the FSM. This will not perform any checks on which state the operation is in so may lead to data corruption or loss. It is recommended to first scale the number of replication engine workers to 0 before calling this endpoint to ensure no operations are in-flight.",
        "tags": [
          "replication"
        ],
        "summary": "Force delete replication operations",
        "operationId": "forceDeleteReplications",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "schema": {
              "$ref": "#/definitions/ReplicationReplicateForceDeleteRequest"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Replication operations force deleted successfully.",
            "schema": {
              "$ref": "#/definitions/ReplicationReplicateForceDeleteResponse"
            }
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.replication.forceDeleteReplications"
        ]
      }
    },
    "/replication/replicate/list": {
      "get": {
        "description": "Retrieves a list of currently registered replication operations, optionally filtered by collection, shard, or node ID.",
        "tags": [
          "replication"
        ],
        "summary": "List replication operations",
        "operationId": "listReplication",
        "parameters": [
          {
            "type": "string",
            "description": "The name of the target node to get details for.",
            "name": "targetNode",
            "in": "query"
          },
          {
            "type": "string",
            "description": "The name of the collection to get details for.",
            "name": "collection",
            "in": "query"
          },
          {
            "type": "string",
            "description": "The shard to get details for.",
            "name": "shard",
            "in": "query"
          },
          {
            "type": "boolean",
            "description": "Whether to include the history of the replication operation.",
            "name": "includeHistory",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "The details of the replication operations.",
            "schema": {
              "type": "array",
              "items": {
                "type": "object",
                "$ref": "#/definitions/ReplicationReplicateDetailsReplicaResponse"
              }
            }
          },
          "400": {
            "description": "Bad request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "501": {
            "description": "Replica movement operations are disabled.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.replication.replicate.details"
        ]
      }
    },
    "/replication/replicate/{id}": {
      "get": {
        "description": "Fetches the current status and detailed information for a specific replication operation, identified by its unique ID. Optionally includes historical data of the operation's progress if requested.",
        "tags": [
          "replication"
        ],
        "summary": "Retrieve a replication operation",
        "operationId": "replicationDetails",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The ID of the replication operation to get details for.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "type": "boolean",
            "description": "Whether to include the history of the replication operation.",
            "name": "includeHistory",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "The details of the replication operation.",
            "schema": {
              "$ref": "#/definitions/ReplicationReplicateDetailsReplicaResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Shard replica operation not found."
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "501": {
            "description": "Replica movement operations are disabled.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.replication.replicate.details"
        ]
      },
      "delete": {
        "description": "Removes a specific replication operation. If the operation is currently active, it will be cancelled and its resources cleaned up before the operation is deleted.",
        "tags": [
          "replication"
        ],
        "summary": "Delete a replication operation",
        "operationId": "deleteReplication",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The ID of the replication operation to delete.",
            "name": "id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "Successfully deleted."
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Shard replica operation not found."
          },
          "409": {
            "description": "The operation is not in a deletable state, e.g. it is a MOVE op in the DEHYDRATING state.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "501": {
            "description": "Replica movement operations are disabled.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.replication.replicate.delete"
        ]
      }
    },
    "/replication/replicate/{id}/cancel": {
      "post": {
        "description": "Requests the cancellation of an active replication operation identified by its ID. The operation will be stopped, but its record will remain in the ` + "`" + `CANCELLED` + "`" + ` state (can't be resumed) and will not be automatically deleted.",
        "tags": [
          "replication"
        ],
        "summary": "Cancel a replication operation",
        "operationId": "cancelReplication",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "The ID of the replication operation to cancel.",
            "name": "id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "Successfully cancelled."
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Shard replica operation not found."
          },
          "409": {
            "description": "The operation is not in a cancellable state, e.g. it is READY or is a MOVE op in the DEHYDRATING state.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "501": {
            "description": "Replica movement operations are disabled.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.replication.replicate.cancel"
        ]
      }
    },
    "/replication/scale": {
      "get": {
        "description": "Computes and returns a replication scale plan for a given collection and desired replication factor. The plan includes, for each shard, a list of nodes to be added and a list of nodes to be removed.",
        "produces": [
          "application/json"
        ],
        "tags": [
          "replication"
        ],
        "summary": "Get replication scale plan",
        "operationId": "getReplicationScalePlan",
        "parameters": [
          {
            "type": "string",
            "description": "The collection name to get the scaling plan for.",
            "name": "collection",
            "in": "query",
            "required": true
          },
          {
            "minimum": 1,
            "type": "integer",
            "description": "The desired replication factor to scale to. Must be a positive integer greater than zero.",
            "name": "replicationFactor",
            "in": "query",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Replication scale plan showing node additions and removals per shard.",
            "schema": {
              "$ref": "#/definitions/ReplicationScalePlan"
            }
          },
          "400": {
            "description": "Bad request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Collection not found.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "501": {
            "description": "Replica movement operations are disabled.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.replication.scale.get"
        ]
      },
      "post": {
        "description": "Apply a replication scaling plan that specifies nodes to add or remove per shard for a given collection.",
        "consumes": [
          "application/json"
        ],
        "produces": [
          "application/json"
        ],
        "tags": [
          "replication"
        ],
        "summary": "Apply replication scaling plan",
        "operationId": "applyReplicationScalePlan",
        "parameters": [
          {
            "description": "The replication scaling plan specifying the collection and its shard-level replica adjustments.",
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/ReplicationScalePlan"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "List of replication shard copy operation IDs initiated for the scale operation",
            "schema": {
              "$ref": "#/definitions/ReplicationScaleApplyResponse"
            }
          },
          "400": {
            "description": "Bad request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Collection not found.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "501": {
            "description": "Replica movement operations are disabled.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.replication.scale.post"
        ]
      }
    },
    "/replication/sharding-state": {
      "get": {
        "description": "Fetches the current sharding state, including replica locations and statuses, for all collections or a specified collection. If a shard name is provided along with a collection, the state for that specific shard is returned.",
        "tags": [
          "replication"
        ],
        "summary": "Get sharding state",
        "operationId": "getCollectionShardingState",
        "parameters": [
          {
            "type": "string",
            "description": "The collection name to get the sharding state for.",
            "name": "collection",
            "in": "query"
          },
          {
            "type": "string",
            "description": "The shard to get the sharding state for.",
            "name": "shard",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Successfully retrieved sharding state.",
            "schema": {
              "$ref": "#/definitions/ReplicationShardingStateResponse"
            }
          },
          "400": {
            "description": "Bad request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Collection or shard not found.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "501": {
            "description": "Replica movement operations are disabled.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.replication.shardingstate.collection.get"
        ]
      }
    },
    "/schema": {
      "get": {
        "description": "Retrieves the definitions of all collections (classes) currently in the database schema.",
        "tags": [
          "schema"
        ],
        "summary": "Get all collection definitions",
        "operationId": "schema.dump",
        "parameters": [
          {
            "type": "boolean",
            "default": true,
            "description": "If true, the request is proxied to the cluster leader to ensure strong schema consistency. Default is true.",
            "name": "consistency",
            "in": "header"
          }
        ],
        "responses": {
          "200": {
            "description": "Successfully retrieved the database schema.",
            "schema": {
              "$ref": "#/definitions/Schema"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error occurred while retrieving the schema. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.local.query.meta"
        ]
      },
      "post": {
        "description": "Defines and creates a new collection (class).\u003cbr/\u003e\u003cbr/\u003eIf [` + "`" + `AutoSchema` + "`" + `](https://docs.weaviate.io/weaviate/config-refs/collections#auto-schema) is enabled (not recommended for production), Weaviate might attempt to infer schema from data during import. Manual definition via this endpoint provides explicit control.",
        "tags": [
          "schema"
        ],
        "summary": "Create a new collection",
        "operationId": "schema.objects.create",
        "parameters": [
          {
            "description": "The definition of the collection (class) to create.",
            "name": "objectClass",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/Class"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Collection created successfully and its definition returned.",
            "schema": {
              "$ref": "#/definitions/Class"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid collection definition provided. Check the definition structure and properties.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error occurred during collection creation. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.local.add.meta"
        ]
      }
    },
    "/schema/{className}": {
      "get": {
        "description": "Retrieve the definition of a specific collection (` + "`" + `className` + "`" + `), including its properties, configuration, and vectorizer settings.",
        "tags": [
          "schema"
        ],
        "summary": "Get a single collection",
        "operationId": "schema.objects.get",
        "parameters": [
          {
            "type": "string",
            "description": "The name of the collection (class) to retrieve.",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "type": "boolean",
            "default": true,
            "description": "If true, the request is proxied to the cluster leader to ensure strong schema consistency. Default is true.",
            "name": "consistency",
            "in": "header"
          }
        ],
        "responses": {
          "200": {
            "description": "Successfully retrieved the collection definition.",
            "schema": {
              "$ref": "#/definitions/Class"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Collection not found."
          },
          "500": {
            "description": "An error occurred while retrieving the collection definition. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.local.get.meta"
        ]
      },
      "put": {
        "description": "Updates the configuration settings of an existing collection (` + "`" + `className` + "`" + `) based on the provided definition. Note: This operation modifies mutable settings specified in the request body. It does not add properties (use ` + "`" + `POST /schema/{className}/properties` + "`" + ` for that) or change the collection name.",
        "tags": [
          "schema"
        ],
        "summary": "Update collection definition",
        "operationId": "schema.objects.update",
        "parameters": [
          {
            "type": "string",
            "description": "The name of the collection (class) to update.",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "description": "The updated collection definition containing the settings to modify.",
            "name": "objectClass",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/Class"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Collection settings updated successfully.",
            "schema": {
              "$ref": "#/definitions/Class"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Collection not found.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid update attempt.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error occurred while updating the collection. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.local.manipulate.meta"
        ]
      },
      "delete": {
        "description": "Removes a collection definition from the schema. WARNING: This action permanently deletes all data objects stored within the collection.",
        "tags": [
          "schema"
        ],
        "summary": "Delete a collection (and all associated data)",
        "operationId": "schema.objects.delete",
        "parameters": [
          {
            "type": "string",
            "description": "The name of the collection (class) to delete.",
            "name": "className",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Collection deleted successfully."
          },
          "400": {
            "description": "Could not delete the collection. See the error response for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error occurred during collection deletion. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.local.manipulate.meta"
        ]
      }
    },
    "/schema/{className}/properties": {
      "post": {
        "description": "Adds a new property definition to an existing collection (` + "`" + `className` + "`" + `) definition.",
        "tags": [
          "schema"
        ],
        "summary": "Add a property to a collection",
        "operationId": "schema.objects.properties.add",
        "parameters": [
          {
            "type": "string",
            "description": "The name of the collection (class) to add the property to.",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "description": "The definition of the property to add.",
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/Property"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Property added successfully and its definition returned.",
            "schema": {
              "$ref": "#/definitions/Property"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid property definition provided.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error occurred while adding the property. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.local.manipulate.meta"
        ]
      }
    },
    "/schema/{className}/shards": {
      "get": {
        "description": "Retrieves the status of all shards associated with the specified collection (` + "`" + `className` + "`" + `). For multi-tenant collections, use the ` + "`" + `tenant` + "`" + ` query parameter to retrieve status for a specific tenant's shards.",
        "tags": [
          "schema"
        ],
        "summary": "Get the shards status of a collection",
        "operationId": "schema.objects.shards.get",
        "parameters": [
          {
            "type": "string",
            "description": "The name of the collection (class) whose shards to query.",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "The name of the tenant for which to retrieve shard statuses (only applicable for multi-tenant collections).",
            "name": "tenant",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Shard statuses retrieved successfully.",
            "schema": {
              "$ref": "#/definitions/ShardStatusList"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Collection not found.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error occurred while retrieving shard statuses. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.local.get.meta"
        ]
      }
    },
    "/schema/{className}/shards/{shardName}": {
      "put": {
        "description": "Updates the status of a specific shard within a collection (e.g., sets it to ` + "`" + `READY` + "`" + ` or ` + "`" + `READONLY` + "`" + `). This is typically used after resolving an underlying issue (like disk space) that caused a shard to become non-operational. There is also a convenience function in each client to set the status of all shards of a collection.",
        "tags": [
          "schema"
        ],
        "summary": "Update a shard status",
        "operationId": "schema.objects.shards.update",
        "parameters": [
          {
            "type": "string",
            "description": "The name of the collection (class) containing the shard.",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "The name of the shard to update.",
            "name": "shardName",
            "in": "path",
            "required": true
          },
          {
            "description": "The shard status object containing the desired new status.",
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/ShardStatus"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Shard status updated successfully.",
            "schema": {
              "$ref": "#/definitions/ShardStatus"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Collection or shard not found.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid update attempt",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error occurred while updating the shard status. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.local.manipulate.meta"
        ]
      }
    },
    "/schema/{className}/tenants": {
      "get": {
        "description": "Retrieves a list of all tenants currently associated with the specified collection.",
        "tags": [
          "schema"
        ],
        "summary": "Get the list of tenants",
        "operationId": "tenants.get",
        "parameters": [
          {
            "type": "string",
            "description": "The name of the collection (class) whose tenants to list.",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "type": "boolean",
            "default": true,
            "description": "If true, the request is proxied to the cluster leader to ensure strong schema consistency. Default is true.",
            "name": "consistency",
            "in": "header"
          }
        ],
        "responses": {
          "200": {
            "description": "Successfully retrieved tenants.",
            "schema": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/Tenant"
              }
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error occurred while listing tenants. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        }
      },
      "put": {
        "description": "Updates the activity status (e.g., ` + "`" + `ACTIVE` + "`" + `, ` + "`" + `INACTIVE` + "`" + `, etc.) of one or more specified tenants within a collection (` + "`" + `className` + "`" + `).",
        "tags": [
          "schema"
        ],
        "summary": "Update a tenant",
        "operationId": "tenants.update",
        "parameters": [
          {
            "type": "string",
            "description": "The name of the collection (class) containing the tenants.",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "description": "An array of tenant objects specifying the tenants to update and their desired new status.",
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/Tenant"
              }
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Tenant statuses updated successfully.",
            "schema": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/Tenant"
              }
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid update request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error occurred while updating tenants. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        }
      },
      "post": {
        "description": "Creates one or more new tenants for a specified collection (` + "`" + `className` + "`" + `). Multi-tenancy must be enabled for the collection via its definition.",
        "tags": [
          "schema"
        ],
        "summary": "Create a new tenant",
        "operationId": "tenants.create",
        "parameters": [
          {
            "type": "string",
            "description": "The name of the multi-tenant enabled collection (class).",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "description": "An array of tenant objects to create.",
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/Tenant"
              }
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Tenants created successfully.",
            "schema": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/Tenant"
              }
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error occurred while creating tenants. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        }
      },
      "delete": {
        "description": "Deletes one or more specified tenants from a collection (` + "`" + `className` + "`" + `). WARNING: This action permanently deletes all data associated with the specified tenants.",
        "tags": [
          "schema"
        ],
        "summary": "Delete tenants",
        "operationId": "tenants.delete",
        "parameters": [
          {
            "type": "string",
            "description": "The name of the collection (class) from which to delete tenants.",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "description": "An array of tenant names to delete.",
            "name": "tenants",
            "in": "body",
            "required": true,
            "schema": {
              "type": "array",
              "items": {
                "description": "Name of a tenant to delete.",
                "type": "string"
              }
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Tenants deleted successfully."
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error occurred while deleting tenants. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        }
      }
    },
    "/schema/{className}/tenants/{tenantName}": {
      "get": {
        "description": "Retrieves details about a specific tenant within the given collection (` + "`" + `className` + "`" + `), such as its current activity status.",
        "tags": [
          "schema"
        ],
        "summary": "Get a specific tenant",
        "operationId": "tenants.get.one",
        "parameters": [
          {
            "type": "string",
            "description": "The name of the collection (class) containing the tenant.",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "The name of the tenant to retrieve.",
            "name": "tenantName",
            "in": "path",
            "required": true
          },
          {
            "type": "boolean",
            "default": true,
            "description": "If true, the request is proxied to the cluster leader to ensure strong schema consistency. Default is true.",
            "name": "consistency",
            "in": "header"
          }
        ],
        "responses": {
          "200": {
            "description": "Successfully retrieved tenant details.",
            "schema": {
              "$ref": "#/definitions/Tenant"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Tenant or collection not found."
          },
          "422": {
            "description": "Invalid request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error occurred while retrieving the tenant. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        }
      },
      "head": {
        "description": "Checks for the existence of a specific tenant within the given collection (` + "`" + `className` + "`" + `).",
        "tags": [
          "schema"
        ],
        "summary": "Check if a tenant exists",
        "operationId": "tenant.exists",
        "parameters": [
          {
            "type": "string",
            "description": "The name of the collection (class) to check within.",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "The name of the tenant to check for.",
            "name": "tenantName",
            "in": "path",
            "required": true
          },
          {
            "type": "boolean",
            "default": true,
            "description": "If true, the request is proxied to the cluster leader to ensure strong schema consistency. Default is true.",
            "name": "consistency",
            "in": "header"
          }
        ],
        "responses": {
          "200": {
            "description": "The tenant exists in the specified collection."
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Tenant or collection not found."
          },
          "422": {
            "description": "Invalid request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error occurred during the check. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        }
      }
    },
    "/tasks": {
      "get": {
        "tags": [
          "distributedTasks"
        ],
        "summary": "Lists all distributed tasks in the cluster",
        "operationId": "distributedTasks.get",
        "responses": {
          "200": {
            "description": "Distributed tasks successfully returned.",
            "schema": {
              "$ref": "#/definitions/DistributedTasks"
            }
          },
          "403": {
            "description": "Unauthorized or invalid credentials.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An internal server error occurred while retrieving distributed tasks. Check the ErrorResponse for details.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.distributedTasks.get"
        ]
      }
    },
    "/users/db": {
      "get": {
        "description": "Retrieves a list of all database (` + "`" + `db` + "`" + ` user type) users with their roles and status information.",
        "tags": [
          "users"
        ],
        "summary": "List all users",
        "operationId": "listAllUsers",
        "parameters": [
          {
            "type": "boolean",
            "default": false,
            "description": "Whether to include the last time the users were utilized.",
            "name": "includeLastUsedTime",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Info about the users.",
            "schema": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/DBUserInfo"
              }
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.users.db.list_all"
        ]
      }
    },
    "/users/db/{user_id}": {
      "get": {
        "description": "Retrieve detailed information about a specific database user (` + "`" + `db` + "`" + ` user type), including their roles, status, and type.",
        "tags": [
          "users"
        ],
        "summary": "Get user info",
        "operationId": "getUserInfo",
        "parameters": [
          {
            "type": "string",
            "description": "The name of the user.",
            "name": "user_id",
            "in": "path",
            "required": true
          },
          {
            "type": "boolean",
            "default": false,
            "description": "Whether to include the last used time of the given user",
            "name": "includeLastUsedTime",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Info about the user.",
            "schema": {
              "$ref": "#/definitions/DBUserInfo"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "User not found."
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.users.db.get"
        ]
      },
      "post": {
        "description": "Create a new database (` + "`" + `db` + "`" + ` user type) user with the specified name. Returns an API key for the newly created user.",
        "tags": [
          "users"
        ],
        "summary": "Create a new user",
        "operationId": "createUser",
        "parameters": [
          {
            "type": "string",
            "description": "The name of the user.",
            "name": "user_id",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "schema": {
              "type": "object",
              "properties": {
                "createTime": {
                  "description": "EXPERIMENTAL, DONT USE. THIS WILL BE REMOVED AGAIN. - set the given time as creation time",
                  "type": "string",
                  "format": "date-time"
                },
                "import": {
                  "description": "EXPERIMENTAL, DONT USE. THIS WILL BE REMOVED AGAIN. - import api key from static user",
                  "type": "boolean",
                  "default": false
                }
              }
            }
          }
        ],
        "responses": {
          "201": {
            "description": "User created successfully and API key returned.",
            "schema": {
              "$ref": "#/definitions/UserApiKey"
            }
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "User not found.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "409": {
            "description": "A user with the specified name already exists.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.users.db.create"
        ]
      },
      "delete": {
        "description": "Delete a database user. You can't delete your current user.",
        "tags": [
          "users"
        ],
        "summary": "Delete a user",
        "operationId": "deleteUser",
        "parameters": [
          {
            "type": "string",
            "description": "The name of the user.",
            "name": "user_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "Successfully deleted."
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "User not found."
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.users.db.delete"
        ]
      }
    },
    "/users/db/{user_id}/activate": {
      "post": {
        "description": "Activate a deactivated database user (` + "`" + `db` + "`" + ` user type).",
        "tags": [
          "users"
        ],
        "summary": "Activate a user",
        "operationId": "activateUser",
        "parameters": [
          {
            "type": "string",
            "description": "The name of the user.",
            "name": "user_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "User successfully activated."
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "User not found."
          },
          "409": {
            "description": "User already activated."
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.users.db.activateUser"
        ]
      }
    },
    "/users/db/{user_id}/deactivate": {
      "post": {
        "description": "Deactivate a database user (` + "`" + `db` + "`" + ` user type).",
        "tags": [
          "users"
        ],
        "summary": "Deactivate a user",
        "operationId": "deactivateUser",
        "parameters": [
          {
            "type": "string",
            "description": "The name of the user.",
            "name": "user_id",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "schema": {
              "type": "object",
              "properties": {
                "revoke_key": {
                  "description": "Whether the API key should be revoked when deactivating the user.",
                  "type": "boolean",
                  "default": false
                }
              }
            }
          }
        ],
        "responses": {
          "200": {
            "description": "User successfully deactivated."
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "User not found."
          },
          "409": {
            "description": "User already deactivated."
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.users.db.deactivateUser"
        ]
      }
    },
    "/users/db/{user_id}/rotate-key": {
      "post": {
        "description": "Revoke the current API key for the specified database user (` + "`" + `db` + "`" + ` user type) and generate a new one.",
        "tags": [
          "users"
        ],
        "summary": "Rotate API key of a user",
        "operationId": "rotateUserApiKey",
        "parameters": [
          {
            "type": "string",
            "description": "The name of the user.",
            "name": "user_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "API key successfully updated.",
            "schema": {
              "$ref": "#/definitions/UserApiKey"
            }
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "User not found."
          },
          "422": {
            "description": "The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.users.db.rotateApiKey"
        ]
      }
    },
    "/users/own-info": {
      "get": {
        "description": "Get information about the currently authenticated user, including username and assigned roles.",
        "tags": [
          "users"
        ],
        "summary": "Get current user info",
        "operationId": "getOwnInfo",
        "responses": {
          "200": {
            "description": "Info about the user.",
            "schema": {
              "$ref": "#/definitions/UserOwnInfo"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "501": {
            "description": "Replica movement operations are disabled.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.users.get.own-info"
        ]
      }
    }
  },
  "definitions": {
    "AdditionalProperties": {
      "description": "(Response only) Additional meta information about a single object.",
      "type": "object",
      "additionalProperties": {
        "type": "object"
      }
    },
    "Alias": {
      "description": "Represents the mapping between an alias name and a collection. An alias provides an alternative name for accessing a collection.",
      "type": "object",
      "properties": {
        "alias": {
          "description": "The unique name of the alias that serves as an alternative identifier for the collection.",
          "type": "string"
        },
        "class": {
          "description": "The name of the collection (class) to which this alias is mapped.",
          "type": "string"
        }
      }
    },
    "AliasResponse": {
      "description": "Response object containing a list of alias mappings.",
      "type": "object",
      "properties": {
        "aliases": {
          "description": "Array of alias objects, each containing an alias-to-collection mapping.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/Alias"
          }
        }
      }
    },
    "AsyncReplicationStatus": {
      "description": "The status of the async replication.",
      "properties": {
        "objectsPropagated": {
          "description": "The number of objects propagated in the most recent iteration.",
          "type": "number",
          "format": "uint64"
        },
        "startDiffTimeUnixMillis": {
          "description": "The start time of the most recent iteration.",
          "type": "number",
          "format": "int64"
        },
        "targetNode": {
          "description": "The target node of the replication, if set, otherwise empty.",
          "type": "string"
        }
      }
    },
    "BM25Config": {
      "description": "Tuning parameters for the BM25 algorithm.",
      "type": "object",
      "properties": {
        "b": {
          "description": "Calibrates term-weight scaling based on the document length (default: 0.75).",
          "type": "number",
          "format": "float"
        },
        "k1": {
          "description": "Calibrates term-weight scaling based on the term frequency within a document (default: 1.2).",
          "type": "number",
          "format": "float"
        }
      }
    },
    "BackupConfig": {
      "description": "Backup custom configuration.",
      "type": "object",
      "properties": {
        "Bucket": {
          "description": "Name of the bucket, container, volume, etc.",
          "type": "string"
        },
        "CPUPercentage": {
          "description": "Desired CPU core utilization ranging from 1%-80%",
          "type": "integer",
          "default": 50,
          "maximum": 80,
          "minimum": 1,
          "x-nullable": false
        },
        "ChunkSize": {
          "description": "Deprecated, has no effect.",
          "type": "integer",
          "x-deprecated": true,
          "x-nullable": false
        },
        "CompressionLevel": {
          "description": "compression level used by compression algorithm",
          "type": "string",
          "default": "DefaultCompression",
          "enum": [
            "DefaultCompression",
            "BestSpeed",
            "BestCompression",
            "ZstdDefaultCompression",
            "ZstdBestSpeed",
            "ZstdBestCompression",
            "NoCompression"
          ],
          "x-nullable": false
        },
        "Endpoint": {
          "description": "Name of the endpoint, e.g. s3.amazonaws.com.",
          "type": "string"
        },
        "Path": {
          "description": "Path or key within the bucket.",
          "type": "string"
        }
      }
    },
    "BackupCreateRequest": {
      "description": "Request body for creating a backup for a set of collections.",
      "properties": {
        "config": {
          "description": "Custom configuration for the backup creation process",
          "type": "object",
          "$ref": "#/definitions/BackupConfig"
        },
        "exclude": {
          "description": "List of collections to exclude from the backup creation process. If not set, all collections are included. Cannot be used together with ` + "`" + `include` + "`" + `.",
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "id": {
          "description": "The ID of the backup (required). Must be URL-safe and work as a filesystem path, only lowercase, numbers, underscore, minus characters allowed.",
          "type": "string"
        },
        "include": {
          "description": "List of collections to include in the backup creation process. If not set, all collections are included. Cannot be used together with ` + "`" + `exclude` + "`" + `.",
          "type": "array",
          "items": {
            "type": "string"
          }
        }
      }
    },
    "BackupCreateResponse": {
      "description": "The definition of a backup create response body",
      "properties": {
        "backend": {
          "description": "Backup backend name e.g. filesystem, gcs, s3.",
          "type": "string"
        },
        "bucket": {
          "description": "Name of the bucket, container, volume, etc",
          "type": "string"
        },
        "classes": {
          "description": "The list of collections (classes) for which the backup creation process was started.",
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "error": {
          "description": "error message if creation failed",
          "type": "string"
        },
        "id": {
          "description": "The ID of the backup. Must be URL-safe and work as a filesystem path, only lowercase, numbers, underscore, minus characters allowed.",
          "type": "string"
        },
        "path": {
          "description": "Path within bucket of backup",
          "type": "string"
        },
        "status": {
          "description": "phase of backup creation process",
          "type": "string",
          "default": "STARTED",
          "enum": [
            "STARTED",
            "TRANSFERRING",
            "TRANSFERRED",
            "SUCCESS",
            "FAILED",
            "CANCELED"
          ]
        }
      }
    },
    "BackupCreateStatusResponse": {
      "description": "The definition of a backup create metadata",
      "properties": {
        "backend": {
          "description": "Backup backend name e.g. filesystem, gcs, s3.",
          "type": "string"
        },
        "completedAt": {
          "description": "Timestamp when the backup process completed (successfully or with failure)",
          "type": "string",
          "format": "date-time"
        },
        "error": {
          "description": "error message if creation failed",
          "type": "string"
        },
        "id": {
          "description": "The ID of the backup. Must be URL-safe and work as a filesystem path, only lowercase, numbers, underscore, minus characters allowed.",
          "type": "string"
        },
        "path": {
          "description": "Destination path of backup files valid for the selected backend.",
          "type": "string"
        },
        "size": {
          "description": "Size of the backup in Gibs",
          "type": "number",
          "format": "float64"
        },
        "startedAt": {
          "description": "Timestamp when the backup process started",
          "type": "string",
          "format": "date-time"
        },
        "status": {
          "description": "phase of backup creation process",
          "type": "string",
          "default": "STARTED",
          "enum": [
            "STARTED",
            "TRANSFERRING",
            "TRANSFERRED",
            "SUCCESS",
            "FAILED",
            "CANCELED"
          ]
        }
      }
    },
    "BackupListResponse": {
      "description": "The definition of a backup create response body.",
      "type": "array",
      "items": {
        "$ref": "#/definitions/BackupListResponseItems0"
      }
    },
    "BackupListResponseItems0": {
      "type": "object",
      "properties": {
        "classes": {
          "description": "The list of collections (classes) for which the backup process was started.",
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "completedAt": {
          "description": "Timestamp when the backup process completed (successfully or with failure)",
          "type": "string",
          "format": "date-time"
        },
        "id": {
          "description": "The ID of the backup. Must be URL-safe and work as a filesystem path, only lowercase, numbers, underscore, minus characters allowed.",
          "type": "string"
        },
        "size": {
          "description": "Size of the backup in Gibs",
          "type": "number",
          "format": "float64"
        },
        "startedAt": {
          "description": "Timestamp when the backup process started",
          "type": "string",
          "format": "date-time"
        },
        "status": {
          "description": "Status of backup process.",
          "type": "string",
          "enum": [
            "STARTED",
            "TRANSFERRING",
            "TRANSFERRED",
            "SUCCESS",
            "FAILED",
            "CANCELED"
          ]
        }
      }
    },
    "BackupRestoreRequest": {
      "description": "Request body for restoring a backup for a set of collections (classes).",
      "properties": {
        "config": {
          "description": "Custom configuration for the backup restoration process.",
          "type": "object",
          "$ref": "#/definitions/RestoreConfig"
        },
        "exclude": {
          "description": "List of collections (classes) to exclude from the backup restoration process.",
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "include": {
          "description": "List of collections (classes) to include in the backup restoration process.",
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "node_mapping": {
          "description": "Allows overriding the node names stored in the backup with different ones. Useful when restoring backups to a different environment.",
          "type": "object",
          "additionalProperties": {
            "type": "string"
          }
        },
        "overwriteAlias": {
          "description": "Allows ovewriting the collection alias if there is a conflict",
          "type": "boolean"
        }
      }
    },
    "BackupRestoreResponse": {
      "description": "The definition of a backup restore response body.",
      "properties": {
        "backend": {
          "description": "Backup backend name e.g. filesystem, gcs, s3.",
          "type": "string"
        },
        "classes": {
          "description": "The list of collections (classes) for which the backup restoration process was started.",
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "error": {
          "description": "Error message if backup restoration failed.",
          "type": "string"
        },
        "id": {
          "description": "The ID of the backup. Must be URL-safe and work as a filesystem path, only lowercase, numbers, underscore, minus characters allowed.",
          "type": "string"
        },
        "path": {
          "description": "Destination path of backup files valid for the selected backend.",
          "type": "string"
        },
        "status": {
          "description": "Phase of backup restoration process.",
          "type": "string",
          "default": "STARTED",
          "enum": [
            "STARTED",
            "TRANSFERRING",
            "TRANSFERRED",
            "SUCCESS",
            "FAILED",
            "CANCELED"
          ]
        }
      }
    },
    "BackupRestoreStatusResponse": {
      "description": "The definition of a backup restore metadata.",
      "properties": {
        "backend": {
          "description": "Backup backend name e.g. filesystem, gcs, s3.",
          "type": "string"
        },
        "error": {
          "description": "Error message if backup restoration failed.",
          "type": "string"
        },
        "id": {
          "description": "The ID of the backup. Must be URL-safe and work as a filesystem path, only lowercase, numbers, underscore, minus characters allowed.",
          "type": "string"
        },
        "path": {
          "description": "Destination path of backup files valid for the selected backup backend, contains bucket and path.",
          "type": "string"
        },
        "status": {
          "description": "Phase of backup restoration process.",
          "type": "string",
          "default": "STARTED",
          "enum": [
            "STARTED",
            "TRANSFERRING",
            "TRANSFERRED",
            "SUCCESS",
            "FAILED",
            "CANCELED"
          ]
        }
      }
    },
    "BatchDelete": {
      "type": "object",
      "properties": {
        "deletionTimeUnixMilli": {
          "description": "Timestamp of deletion in milliseconds since epoch UTC.",
          "type": "integer",
          "format": "int64",
          "x-nullable": true
        },
        "dryRun": {
          "description": "If true, the call will show which objects would be matched using the specified filter without deleting any objects. \u003cbr/\u003e\u003cbr/\u003eDepending on the configured verbosity, you will either receive a count of affected objects, or a list of IDs.",
          "type": "boolean",
          "default": false
        },
        "match": {
          "description": "Outlines how to find the objects to be deleted.",
          "type": "object",
          "properties": {
            "class": {
              "description": "The name of the collection (class) from which to delete objects.",
              "type": "string",
              "example": "City"
            },
            "where": {
              "description": "Filter to limit the objects to be deleted.",
              "type": "object",
              "$ref": "#/definitions/WhereFilter"
            }
          }
        },
        "output": {
          "description": "Controls the verbosity of the output, possible values are: ` + "`" + `minimal` + "`" + `, ` + "`" + `verbose` + "`" + `. Defaults to ` + "`" + `minimal` + "`" + `.",
          "type": "string",
          "default": "minimal"
        }
      }
    },
    "BatchDeleteMatch": {
      "description": "Outlines how to find the objects to be deleted.",
      "type": "object",
      "properties": {
        "class": {
          "description": "The name of the collection (class) from which to delete objects.",
          "type": "string",
          "example": "City"
        },
        "where": {
          "description": "Filter to limit the objects to be deleted.",
          "type": "object",
          "$ref": "#/definitions/WhereFilter"
        }
      }
    },
    "BatchDeleteResponse": {
      "description": "Delete Objects response.",
      "type": "object",
      "properties": {
        "deletionTimeUnixMilli": {
          "description": "Timestamp of deletion in milliseconds since epoch UTC.",
          "type": "integer",
          "format": "int64",
          "x-nullable": true
        },
        "dryRun": {
          "description": "If true, objects will not be deleted yet, but merely listed. Defaults to false.",
          "type": "boolean",
          "default": false
        },
        "match": {
          "description": "Outlines how to find the objects to be deleted.",
          "type": "object",
          "properties": {
            "class": {
              "description": "The name of the collection (class) from which to delete objects.",
              "type": "string",
              "example": "City"
            },
            "where": {
              "description": "Filter to limit the objects to be deleted.",
              "type": "object",
              "$ref": "#/definitions/WhereFilter"
            }
          }
        },
        "output": {
          "description": "Controls the verbosity of the output, possible values are: ` + "`" + `minimal` + "`" + `, ` + "`" + `verbose` + "`" + `. Defaults to ` + "`" + `minimal` + "`" + `.",
          "type": "string",
          "default": "minimal"
        },
        "results": {
          "type": "object",
          "properties": {
            "failed": {
              "description": "How many objects should have been deleted but could not be deleted.",
              "type": "number",
              "format": "int64",
              "x-omitempty": false
            },
            "limit": {
              "description": "The most amount of objects that can be deleted in a single query, equals [` + "`" + `QUERY_MAXIMUM_RESULTS` + "`" + `](https://docs.weaviate.io/deploy/configuration/env-vars#QUERY_MAXIMUM_RESULTS).",
              "type": "number",
              "format": "int64",
              "x-omitempty": false
            },
            "matches": {
              "description": "How many objects were matched by the filter.",
              "type": "number",
              "format": "int64",
              "x-omitempty": false
            },
            "objects": {
              "description": "With output set to ` + "`" + `minimal` + "`" + ` only objects with error occurred will the be described. Successfully deleted objects would be omitted. Output set to ` + "`" + `verbose` + "`" + ` will list all of the objects with their respective statuses.",
              "type": "array",
              "items": {
                "$ref": "#/definitions/BatchDeleteResponseResultsObjectsItems0"
              }
            },
            "successful": {
              "description": "How many objects were successfully deleted in this round.",
              "type": "number",
              "format": "int64",
              "x-omitempty": false
            }
          }
        }
      }
    },
    "BatchDeleteResponseMatch": {
      "description": "Outlines how to find the objects to be deleted.",
      "type": "object",
      "properties": {
        "class": {
          "description": "The name of the collection (class) from which to delete objects.",
          "type": "string",
          "example": "City"
        },
        "where": {
          "description": "Filter to limit the objects to be deleted.",
          "type": "object",
          "$ref": "#/definitions/WhereFilter"
        }
      }
    },
    "BatchDeleteResponseResults": {
      "type": "object",
      "properties": {
        "failed": {
          "description": "How many objects should have been deleted but could not be deleted.",
          "type": "number",
          "format": "int64",
          "x-omitempty": false
        },
        "limit": {
          "description": "The most amount of objects that can be deleted in a single query, equals [` + "`" + `QUERY_MAXIMUM_RESULTS` + "`" + `](https://docs.weaviate.io/deploy/configuration/env-vars#QUERY_MAXIMUM_RESULTS).",
          "type": "number",
          "format": "int64",
          "x-omitempty": false
        },
        "matches": {
          "description": "How many objects were matched by the filter.",
          "type": "number",
          "format": "int64",
          "x-omitempty": false
        },
        "objects": {
          "description": "With output set to ` + "`" + `minimal` + "`" + ` only objects with error occurred will the be described. Successfully deleted objects would be omitted. Output set to ` + "`" + `verbose` + "`" + ` will list all of the objects with their respective statuses.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/BatchDeleteResponseResultsObjectsItems0"
          }
        },
        "successful": {
          "description": "How many objects were successfully deleted in this round.",
          "type": "number",
          "format": "int64",
          "x-omitempty": false
        }
      }
    },
    "BatchDeleteResponseResultsObjectsItems0": {
      "description": "Results for this specific Object.",
      "format": "object",
      "properties": {
        "errors": {
          "$ref": "#/definitions/ErrorResponse"
        },
        "id": {
          "description": "The UUID of the object.",
          "type": "string",
          "format": "uuid"
        },
        "status": {
          "type": "string",
          "default": "SUCCESS",
          "enum": [
            "SUCCESS",
            "DRYRUN",
            "FAILED"
          ]
        }
      }
    },
    "BatchReference": {
      "properties": {
        "from": {
          "description": "Long-form beacon-style URI to identify the source of the cross-reference, including the property name. Should be in the form of ` + "`" + `weaviate://localhost/objects/\u003cuuid\u003e/\u003cclassName\u003e/\u003cpropertyName\u003e` + "`" + `, where ` + "`" + `\u003cclassName\u003e` + "`" + ` and ` + "`" + `\u003cpropertyName\u003e` + "`" + ` must represent the cross-reference property of the source class to be used.",
          "type": "string",
          "format": "uri",
          "example": "weaviate://localhost/Zoo/a5d09582-4239-4702-81c9-92a6e0122bb4/hasAnimals"
        },
        "tenant": {
          "description": "Name of the reference tenant.",
          "type": "string"
        },
        "to": {
          "description": "Short-form URI to point to the cross-reference. Should be in the form of ` + "`" + `weaviate://localhost/\u003cuuid\u003e` + "`" + ` for the example of a local cross-reference to an object.",
          "type": "string",
          "format": "uri",
          "example": "weaviate://localhost/97525810-a9a5-4eb0-858a-71449aeb007f"
        }
      }
    },
    "BatchReferenceResponse": {
      "type": "object",
      "allOf": [
        {
          "$ref": "#/definitions/BatchReference"
        },
        {
          "properties": {
            "result": {
              "description": "Results for this specific reference.",
              "format": "object",
              "properties": {
                "errors": {
                  "$ref": "#/definitions/ErrorResponse"
                },
                "status": {
                  "type": "string",
                  "default": "SUCCESS",
                  "enum": [
                    "SUCCESS",
                    "FAILED"
                  ]
                }
              }
            }
          }
        }
      ]
    },
    "BatchReferenceResponseAO1Result": {
      "description": "Results for this specific reference.",
      "format": "object",
      "properties": {
        "errors": {
          "$ref": "#/definitions/ErrorResponse"
        },
        "status": {
          "type": "string",
          "default": "SUCCESS",
          "enum": [
            "SUCCESS",
            "FAILED"
          ]
        }
      }
    },
    "BatchStats": {
      "description": "The summary of a nodes batch queue congestion status.",
      "properties": {
        "queueLength": {
          "description": "How many objects are currently in the batch queue.",
          "type": "number",
          "format": "int",
          "x-nullable": true,
          "x-omitempty": true
        },
        "ratePerSecond": {
          "description": "How many objects are approximately processed from the batch queue per second.",
          "type": "number",
          "format": "int",
          "x-omitempty": false
        }
      }
    },
    "C11yExtension": {
      "description": "A resource describing an extension to the contextinoary, containing both the identifier and the definition of the extension",
      "properties": {
        "concept": {
          "description": "The new concept you want to extend. Must be an all-lowercase single word, or a space delimited compound word. Examples: 'foobarium', 'my custom concept'",
          "type": "string",
          "example": "foobarium"
        },
        "definition": {
          "description": "A list of space-delimited words or a sentence describing what the custom concept is about. Avoid using the custom concept itself. An Example definition for the custom concept 'foobarium': would be 'a naturally occurring element which can only be seen by programmers'",
          "type": "string"
        },
        "weight": {
          "description": "Weight of the definition of the new concept where 1='override existing definition entirely' and 0='ignore custom definition'. Note that if the custom concept is not present in the contextionary yet, the weight cannot be less than 1.",
          "type": "number",
          "format": "float"
        }
      }
    },
    "C11yNearestNeighbors": {
      "description": "C11y function to show the nearest neighbors to a word.",
      "type": "array",
      "items": {
        "$ref": "#/definitions/C11yNearestNeighborsItems0"
      }
    },
    "C11yNearestNeighborsItems0": {
      "type": "object",
      "properties": {
        "distance": {
          "type": "number",
          "format": "float"
        },
        "word": {
          "type": "string"
        }
      }
    },
    "C11yVector": {
      "description": "A vector representation of the object in the Contextionary. If provided at object creation, this wil take precedence over any vectorizer setting.",
      "type": "array",
      "items": {
        "type": "number",
        "format": "float"
      }
    },
    "C11yVectorBasedQuestion": {
      "description": "Receive question based on array of collection names (classes), properties and values.",
      "type": "array",
      "items": {
        "$ref": "#/definitions/C11yVectorBasedQuestionItems0"
      }
    },
    "C11yVectorBasedQuestionItems0": {
      "type": "object",
      "properties": {
        "classProps": {
          "description": "Vectorized properties.",
          "type": "array",
          "maxItems": 300,
          "minItems": 300,
          "items": {
            "$ref": "#/definitions/C11yVectorBasedQuestionItems0ClassPropsItems0"
          }
        },
        "classVectors": {
          "description": "Vectorized collection (class) name.",
          "type": "array",
          "maxItems": 300,
          "minItems": 300,
          "items": {
            "type": "number",
            "format": "float"
          }
        }
      }
    },
    "C11yVectorBasedQuestionItems0ClassPropsItems0": {
      "type": "object",
      "properties": {
        "propsVectors": {
          "type": "array",
          "items": {
            "type": "number",
            "format": "float"
          }
        },
        "value": {
          "description": "String with valuename.",
          "type": "string"
        }
      }
    },
    "C11yWordsResponse": {
      "description": "An array of available words and contexts.",
      "properties": {
        "concatenatedWord": {
          "description": "Weighted results for all words",
          "type": "object",
          "properties": {
            "concatenatedNearestNeighbors": {
              "$ref": "#/definitions/C11yNearestNeighbors"
            },
            "concatenatedVector": {
              "$ref": "#/definitions/C11yVector"
            },
            "concatenatedWord": {
              "type": "string"
            },
            "singleWords": {
              "type": "array",
              "items": {
                "format": "string"
              }
            }
          }
        },
        "individualWords": {
          "description": "Weighted results for per individual word",
          "type": "array",
          "items": {
            "$ref": "#/definitions/C11yWordsResponseIndividualWordsItems0"
          }
        }
      }
    },
    "C11yWordsResponseConcatenatedWord": {
      "description": "Weighted results for all words",
      "type": "object",
      "properties": {
        "concatenatedNearestNeighbors": {
          "$ref": "#/definitions/C11yNearestNeighbors"
        },
        "concatenatedVector": {
          "$ref": "#/definitions/C11yVector"
        },
        "concatenatedWord": {
          "type": "string"
        },
        "singleWords": {
          "type": "array",
          "items": {
            "format": "string"
          }
        }
      }
    },
    "C11yWordsResponseIndividualWordsItems0": {
      "type": "object",
      "properties": {
        "info": {
          "type": "object",
          "properties": {
            "nearestNeighbors": {
              "$ref": "#/definitions/C11yNearestNeighbors"
            },
            "vector": {
              "$ref": "#/definitions/C11yVector"
            }
          }
        },
        "present": {
          "type": "boolean"
        },
        "word": {
          "type": "string"
        }
      }
    },
    "C11yWordsResponseIndividualWordsItems0Info": {
      "type": "object",
      "properties": {
        "nearestNeighbors": {
          "$ref": "#/definitions/C11yNearestNeighbors"
        },
        "vector": {
          "$ref": "#/definitions/C11yVector"
        }
      }
    },
    "Class": {
      "type": "object",
      "properties": {
        "class": {
          "description": "Name of the collection (formerly 'class') (required). Multiple words should be concatenated in CamelCase, e.g. ` + "`" + `ArticleAuthor` + "`" + `.",
          "type": "string"
        },
        "description": {
          "description": "Description of the collection for metadata purposes.",
          "type": "string"
        },
        "invertedIndexConfig": {
          "$ref": "#/definitions/InvertedIndexConfig"
        },
        "moduleConfig": {
          "description": "Configuration specific to modules in a collection context.",
          "type": "object"
        },
        "multiTenancyConfig": {
          "$ref": "#/definitions/MultiTenancyConfig"
        },
        "objectTtlConfig": {
          "$ref": "#/definitions/ObjectTtlConfig"
        },
        "properties": {
          "description": "Define properties of the collection.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/Property"
          }
        },
        "replicationConfig": {
          "$ref": "#/definitions/ReplicationConfig"
        },
        "shardingConfig": {
          "description": "Manage how the index should be sharded and distributed in the cluster",
          "type": "object"
        },
        "vectorConfig": {
          "description": "Configure named vectors. Either use this field or ` + "`" + `vectorizer` + "`" + `, ` + "`" + `vectorIndexType` + "`" + `, and ` + "`" + `vectorIndexConfig` + "`" + ` fields. Available from ` + "`" + `v1.24.0` + "`" + `.",
          "type": "object",
          "additionalProperties": {
            "$ref": "#/definitions/VectorConfig"
          }
        },
        "vectorIndexConfig": {
          "description": "Vector-index config, that is specific to the type of index selected in vectorIndexType",
          "type": "object"
        },
        "vectorIndexType": {
          "description": "Name of the vector index type to use for the collection (e.g. ` + "`" + `hnsw` + "`" + ` or ` + "`" + `flat` + "`" + `).",
          "type": "string"
        },
        "vectorizer": {
          "description": "Specify how the vectors for this collection should be determined. The options are either ` + "`" + `none` + "`" + ` - this means you have to import a vector with each object yourself - or the name of a module that provides vectorization capabilities, such as ` + "`" + `text2vec-weaviate` + "`" + `. If left empty, it will use the globally configured default ([` + "`" + `DEFAULT_VECTORIZER_MODULE` + "`" + `](https://docs.weaviate.io/deploy/configuration/env-vars)) which can itself either be ` + "`" + `none` + "`" + ` or a specific module.",
          "type": "string"
        }
      }
    },
    "Classification": {
      "description": "Manage classifications, trigger them and view status of past classifications.",
      "type": "object",
      "properties": {
        "basedOnProperties": {
          "description": "Base the text-based classification on these fields (of type text).",
          "type": "array",
          "items": {
            "type": "string"
          },
          "example": [
            "description"
          ]
        },
        "class": {
          "description": "The name of the collection (class) which is used in this classification.",
          "type": "string",
          "example": "City"
        },
        "classifyProperties": {
          "description": "Which ref-property to set as part of the classification.",
          "type": "array",
          "items": {
            "type": "string"
          },
          "example": [
            "inCountry"
          ]
        },
        "error": {
          "description": "Error message if status == failed.",
          "type": "string",
          "default": "",
          "example": "classify xzy: something went wrong"
        },
        "filters": {
          "type": "object",
          "properties": {
            "sourceWhere": {
              "description": "Limit the objects to be classified.",
              "type": "object",
              "$ref": "#/definitions/WhereFilter"
            },
            "targetWhere": {
              "description": "Limit the possible sources when using an algorithm which doesn't really on training data, e.g. 'contextual'. When using an algorithm with a training set, such as 'knn', limit the training set instead.",
              "type": "object",
              "$ref": "#/definitions/WhereFilter"
            },
            "trainingSetWhere": {
              "description": "Limit the training objects to be considered during the classification. Can only be used on types with explicit training sets, such as 'knn'.",
              "type": "object",
              "$ref": "#/definitions/WhereFilter"
            }
          }
        },
        "id": {
          "description": "ID to uniquely identify this classification run.",
          "type": "string",
          "format": "uuid",
          "example": "ee722219-b8ec-4db1-8f8d-5150bb1a9e0c"
        },
        "meta": {
          "description": "Additional meta information about the classification.",
          "type": "object",
          "$ref": "#/definitions/ClassificationMeta"
        },
        "settings": {
          "description": "Classification-type specific settings.",
          "type": "object"
        },
        "status": {
          "description": "Status of this classification.",
          "type": "string",
          "enum": [
            "running",
            "completed",
            "failed"
          ],
          "example": "running"
        },
        "type": {
          "description": "Which algorithm to use for classifications.",
          "type": "string"
        }
      }
    },
    "ClassificationFilters": {
      "type": "object",
      "properties": {
        "sourceWhere": {
          "description": "Limit the objects to be classified.",
          "type": "object",
          "$ref": "#/definitions/WhereFilter"
        },
        "targetWhere": {
          "description": "Limit the possible sources when using an algorithm which doesn't really on training data, e.g. 'contextual'. When using an algorithm with a training set, such as 'knn', limit the training set instead.",
          "type": "object",
          "$ref": "#/definitions/WhereFilter"
        },
        "trainingSetWhere": {
          "description": "Limit the training objects to be considered during the classification. Can only be used on types with explicit training sets, such as 'knn'.",
          "type": "object",
          "$ref": "#/definitions/WhereFilter"
        }
      }
    },
    "ClassificationMeta": {
      "description": "Additional information to a specific classification.",
      "type": "object",
      "properties": {
        "completed": {
          "description": "Time when this classification finished.",
          "type": "string",
          "format": "date-time",
          "example": "2017-07-21T17:32:28Z"
        },
        "count": {
          "description": "Number of objects which were taken into consideration for classification.",
          "type": "integer",
          "example": 147
        },
        "countFailed": {
          "description": "Number of objects which could not be classified - see error message for details.",
          "type": "integer",
          "example": 7
        },
        "countSucceeded": {
          "description": "Number of objects successfully classified.",
          "type": "integer",
          "example": 140
        },
        "started": {
          "description": "Time when this classification was started.",
          "type": "string",
          "format": "date-time",
          "example": "2017-07-21T17:32:28Z"
        }
      }
    },
    "ClusterStatisticsResponse": {
      "description": "The cluster statistics of all of the Weaviate nodes",
      "type": "object",
      "properties": {
        "statistics": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/Statistics"
          }
        },
        "synchronized": {
          "type": "boolean",
          "x-omitempty": false
        }
      }
    },
    "DBUserInfo": {
      "type": "object",
      "required": [
        "userId",
        "dbUserType",
        "roles",
        "active"
      ],
      "properties": {
        "active": {
          "description": "Activity status of the returned user.",
          "type": "boolean"
        },
        "apiKeyFirstLetters": {
          "description": "First 3 letters of the associated API key.",
          "type": [
            "string",
            "null"
          ],
          "maxLength": 3
        },
        "createdAt": {
          "description": "Date and time in ISO 8601 format: YYYY-MM-DDTHH:MM:SSZ.",
          "type": [
            "string",
            "null"
          ],
          "format": "date-time"
        },
        "dbUserType": {
          "description": "Type of the returned user.",
          "type": "string",
          "enum": [
            "db_user",
            "db_env_user"
          ]
        },
        "lastUsedAt": {
          "description": "Date and time in ISO 8601 format: YYYY-MM-DDTHH:MM:SSZ.",
          "type": [
            "string",
            "null"
          ],
          "format": "date-time"
        },
        "roles": {
          "description": "The roles associated with the user.",
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "userId": {
          "description": "The name (ID) of the user.",
          "type": "string"
        }
      }
    },
    "Deprecation": {
      "type": "object",
      "properties": {
        "apiType": {
          "description": "Describes which API is affected, usually one of: REST, GraphQL and gRPC.",
          "type": "string"
        },
        "id": {
          "description": "The id that uniquely identifies this particular deprecation (mostly used internally).",
          "type": "string"
        },
        "locations": {
          "description": "The locations within the specified API affected by this deprecation.",
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "mitigation": {
          "description": "User-required object to not be affected by the (planned) removal.",
          "type": "string"
        },
        "msg": {
          "description": "What this deprecation is about.",
          "type": "string"
        },
        "plannedRemovalVersion": {
          "description": "A best-effort guess of which upcoming version will remove the feature entirely.",
          "type": "string"
        },
        "removedIn": {
          "description": "If the feature has already been removed, it was removed in this version.",
          "type": "string",
          "x-nullable": true
        },
        "removedTime": {
          "description": "If the feature has already been removed, it was removed at this timestamp.",
          "type": "string",
          "format": "date-time",
          "x-nullable": true
        },
        "sinceTime": {
          "description": "The deprecation was introduced at this timestamp.",
          "type": "string",
          "format": "date-time"
        },
        "sinceVersion": {
          "description": "The deprecation was introduced in this version.",
          "type": "string"
        },
        "status": {
          "description": "Whether the problematic API functionality is deprecated (planned to be removed) or already removed.",
          "type": "string"
        }
      }
    },
    "DistributedTask": {
      "description": "Distributed task metadata.",
      "type": "object",
      "properties": {
        "error": {
          "description": "The high level reason why the task failed.",
          "type": "string",
          "x-omitempty": true
        },
        "finishedAt": {
          "description": "The time when the task was finished.",
          "type": "string",
          "format": "date-time"
        },
        "finishedNodes": {
          "description": "The nodes that finished the task.",
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "id": {
          "description": "The ID of the task.",
          "type": "string"
        },
        "payload": {
          "description": "The payload of the task.",
          "type": "object"
        },
        "startedAt": {
          "description": "The time when the task was created.",
          "type": "string",
          "format": "date-time"
        },
        "status": {
          "description": "The status of the task.",
          "type": "string"
        },
        "version": {
          "description": "The version of the task.",
          "type": "integer"
        }
      }
    },
    "DistributedTasks": {
      "description": "Active distributed tasks by namespace.",
      "type": "object",
      "additionalProperties": {
        "type": "array",
        "items": {
          "$ref": "#/definitions/DistributedTask"
        }
      }
    },
    "ErrorResponse": {
      "description": "An error response returned by Weaviate endpoints.",
      "type": "object",
      "properties": {
        "error": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/ErrorResponseErrorItems0"
          }
        }
      }
    },
    "ErrorResponseErrorItems0": {
      "type": "object",
      "properties": {
        "message": {
          "type": "string"
        }
      }
    },
    "GeoCoordinates": {
      "properties": {
        "latitude": {
          "description": "The latitude of the point on earth in decimal form.",
          "type": "number",
          "format": "float",
          "x-nullable": true
        },
        "longitude": {
          "description": "The longitude of the point on earth in decimal form.",
          "type": "number",
          "format": "float",
          "x-nullable": true
        }
      }
    },
    "GetGroupsForRoleOKBodyItems0": {
      "type": "object",
      "required": [
        "name",
        "groupType"
      ],
      "properties": {
        "groupId": {
          "type": "string"
        },
        "groupType": {
          "$ref": "#/definitions/GroupType"
        }
      }
    },
    "GetUsersForRoleOKBodyItems0": {
      "type": "object",
      "required": [
        "name",
        "userType"
      ],
      "properties": {
        "userId": {
          "type": "string"
        },
        "userType": {
          "$ref": "#/definitions/UserTypeOutput"
        }
      }
    },
    "GraphQLError": {
      "description": "An error response caused by a GraphQL query.",
      "properties": {
        "locations": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/GraphQLErrorLocationsItems0"
          }
        },
        "message": {
          "type": "string"
        },
        "path": {
          "type": "array",
          "items": {
            "type": "string"
          }
        }
      }
    },
    "GraphQLErrorLocationsItems0": {
      "type": "object",
      "properties": {
        "column": {
          "type": "integer",
          "format": "int64"
        },
        "line": {
          "type": "integer",
          "format": "int64"
        }
      }
    },
    "GraphQLQueries": {
      "description": "A list of GraphQL queries.",
      "type": "array",
      "items": {
        "$ref": "#/definitions/GraphQLQuery"
      }
    },
    "GraphQLQuery": {
      "description": "GraphQL query based on: http://facebook.github.io/graphql/.",
      "type": "object",
      "properties": {
        "operationName": {
          "description": "The name of the operation if multiple exist in the query.",
          "type": "string"
        },
        "query": {
          "description": "Query based on GraphQL syntax.",
          "type": "string"
        },
        "variables": {
          "description": "Additional variables for the query.",
          "type": "object"
        }
      }
    },
    "GraphQLResponse": {
      "description": "GraphQL based response: http://facebook.github.io/graphql/.",
      "properties": {
        "data": {
          "description": "GraphQL data object.",
          "type": "object",
          "additionalProperties": {
            "$ref": "#/definitions/JsonObject"
          }
        },
        "errors": {
          "description": "Array with errors.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/GraphQLError"
          },
          "x-omitempty": true
        }
      }
    },
    "GraphQLResponses": {
      "description": "A list of GraphQL responses.",
      "type": "array",
      "items": {
        "$ref": "#/definitions/GraphQLResponse"
      }
    },
    "GroupType": {
      "description": "If the group contains OIDC or database users.",
      "type": "string",
      "enum": [
        "oidc"
      ]
    },
    "InvertedIndexConfig": {
      "description": "Configure the inverted index built into Weaviate. See [Reference: Inverted index](https://docs.weaviate.io/weaviate/config-refs/indexing/inverted-index#inverted-index-parameters) for details.",
      "type": "object",
      "properties": {
        "bm25": {
          "$ref": "#/definitions/BM25Config"
        },
        "cleanupIntervalSeconds": {
          "description": "Asynchronous index clean up happens every n seconds (default: 60).",
          "type": "number",
          "format": "int"
        },
        "indexNullState": {
          "description": "Index each object with the null state (default: ` + "`" + `false` + "`" + `).",
          "type": "boolean"
        },
        "indexPropertyLength": {
          "description": "Index length of properties (default: ` + "`" + `false` + "`" + `).",
          "type": "boolean"
        },
        "indexTimestamps": {
          "description": "Index each object by its internal timestamps (default: ` + "`" + `false` + "`" + `).",
          "type": "boolean"
        },
        "stopwords": {
          "$ref": "#/definitions/StopwordConfig"
        },
        "tokenizerUserDict": {
          "description": "User-defined dictionary for tokenization.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/TokenizerUserDictConfig"
          },
          "x-omitempty": true
        },
        "usingBlockMaxWAND": {
          "description": "Using BlockMax WAND for query execution (default: ` + "`" + `false` + "`" + `, will be ` + "`" + `true` + "`" + ` for new collections created after 1.30).",
          "type": "boolean"
        }
      }
    },
    "JsonObject": {
      "description": "JSON object value.",
      "type": "object"
    },
    "Link": {
      "type": "object",
      "properties": {
        "documentationHref": {
          "description": "Weaviate documentation about this resource group.",
          "type": "string"
        },
        "href": {
          "description": "Target of the link.",
          "type": "string"
        },
        "name": {
          "description": "Human readable name of the resource group.",
          "type": "string"
        },
        "rel": {
          "description": "Relationship if both resources are related, e.g. 'next', 'previous', 'parent', etc.",
          "type": "string"
        }
      }
    },
    "Meta": {
      "description": "Contains meta information of the current Weaviate instance.",
      "type": "object",
      "properties": {
        "grpcMaxMessageSize": {
          "description": "Max message size for GRPC connection in bytes.",
          "type": "integer"
        },
        "hostname": {
          "description": "The url of the host.",
          "type": "string",
          "format": "url"
        },
        "modules": {
          "description": "Module-specific meta information.",
          "type": "object"
        },
        "version": {
          "description": "The Weaviate server version.",
          "type": "string"
        }
      }
    },
    "MultiTenancyConfig": {
      "description": "Configuration related to multi-tenancy within a collection (class)",
      "properties": {
        "autoTenantActivation": {
          "description": "Existing tenants should (not) be turned HOT implicitly when they are accessed and in another activity status (default: ` + "`" + `false` + "`" + `).",
          "type": "boolean",
          "x-omitempty": false
        },
        "autoTenantCreation": {
          "description": "Nonexistent tenants should (not) be created implicitly (default: ` + "`" + `false` + "`" + `).",
          "type": "boolean",
          "x-omitempty": false
        },
        "enabled": {
          "description": "Whether or not multi-tenancy is enabled for this collection (class) (default: ` + "`" + `false` + "`" + `).",
          "type": "boolean",
          "x-omitempty": false
        }
      }
    },
    "MultipleRef": {
      "description": "Multiple instances of references to other objects.",
      "type": "array",
      "items": {
        "$ref": "#/definitions/SingleRef"
      }
    },
    "NestedProperty": {
      "type": "object",
      "properties": {
        "dataType": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "description": {
          "type": "string"
        },
        "indexFilterable": {
          "type": "boolean",
          "x-nullable": true
        },
        "indexRangeFilters": {
          "type": "boolean",
          "x-nullable": true
        },
        "indexSearchable": {
          "type": "boolean",
          "x-nullable": true
        },
        "name": {
          "type": "string"
        },
        "nestedProperties": {
          "description": "The properties of the nested object(s). Applies to object and object[] data types.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/NestedProperty"
          },
          "x-omitempty": true
        },
        "tokenization": {
          "type": "string",
          "enum": [
            "word",
            "lowercase",
            "whitespace",
            "field",
            "trigram",
            "gse",
            "kagome_kr",
            "kagome_ja",
            "gse_ch"
          ]
        }
      }
    },
    "NodeShardStatus": {
      "description": "The definition of a node shard status response body",
      "properties": {
        "asyncReplicationStatus": {
          "description": "The status of the async replication.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/AsyncReplicationStatus"
          }
        },
        "class": {
          "description": "The name of shard's collection (class).",
          "type": "string",
          "x-omitempty": false
        },
        "compressed": {
          "description": "The status of vector compression/quantization.",
          "type": "boolean",
          "x-omitempty": false
        },
        "loaded": {
          "description": "The load status of the shard.",
          "type": "boolean",
          "x-omitempty": false
        },
        "name": {
          "description": "The name of the shard.",
          "type": "string",
          "x-omitempty": false
        },
        "numberOfReplicas": {
          "description": "Number of replicas for the shard.",
          "type": [
            "integer",
            "null"
          ],
          "format": "int64",
          "x-omitempty": true
        },
        "objectCount": {
          "description": "The number of objects in shard.",
          "type": "number",
          "format": "int64",
          "x-omitempty": false
        },
        "replicationFactor": {
          "description": "Minimum number of replicas for the shard.",
          "type": [
            "integer",
            "null"
          ],
          "format": "int64",
          "x-omitempty": true
        },
        "vectorIndexingStatus": {
          "description": "The status of the vector indexing process.",
          "type": "string",
          "x-omitempty": false
        },
        "vectorQueueLength": {
          "description": "The length of the vector indexing queue.",
          "type": "number",
          "format": "int64",
          "x-omitempty": false
        }
      }
    },
    "NodeStats": {
      "description": "The summary of Weaviate's statistics.",
      "properties": {
        "objectCount": {
          "description": "The total number of objects in DB.",
          "type": "number",
          "format": "int64",
          "x-omitempty": false
        },
        "shardCount": {
          "description": "The count of Weaviate's shards. To see this value, set ` + "`" + `output` + "`" + ` to ` + "`" + `verbose` + "`" + `.",
          "type": "number",
          "format": "int",
          "x-omitempty": false
        }
      }
    },
    "NodeStatus": {
      "description": "The definition of a backup node status response body",
      "properties": {
        "batchStats": {
          "description": "Weaviate batch statistics.",
          "type": "object",
          "$ref": "#/definitions/BatchStats"
        },
        "gitHash": {
          "description": "The gitHash of Weaviate.",
          "type": "string"
        },
        "name": {
          "description": "The name of the node.",
          "type": "string"
        },
        "operationalMode": {
          "description": "Which mode of operation the node is running in.",
          "type": "string",
          "enum": [
            "ReadWrite",
            "WriteOnly",
            "ReadOnly",
            "ScaleOut"
          ]
        },
        "shards": {
          "description": "The list of the shards with it's statistics.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/NodeShardStatus"
          }
        },
        "stats": {
          "description": "Weaviate overall statistics.",
          "type": "object",
          "$ref": "#/definitions/NodeStats"
        },
        "status": {
          "description": "Node's status.",
          "type": "string",
          "default": "HEALTHY",
          "enum": [
            "HEALTHY",
            "UNHEALTHY",
            "UNAVAILABLE",
            "TIMEOUT"
          ]
        },
        "version": {
          "description": "The version of Weaviate.",
          "type": "string"
        }
      }
    },
    "NodesStatusResponse": {
      "description": "The status of all of the Weaviate nodes",
      "type": "object",
      "properties": {
        "nodes": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/NodeStatus"
          }
        }
      }
    },
    "Object": {
      "type": "object",
      "properties": {
        "additional": {
          "$ref": "#/definitions/AdditionalProperties"
        },
        "class": {
          "description": "Name of the collection (class) the object belongs to.",
          "type": "string"
        },
        "creationTimeUnix": {
          "description": "(Response only) Timestamp of creation of this object in milliseconds since epoch UTC.",
          "type": "integer",
          "format": "int64"
        },
        "id": {
          "description": "The UUID of the object.",
          "type": "string",
          "format": "uuid"
        },
        "lastUpdateTimeUnix": {
          "description": "(Response only) Timestamp of the last object update in milliseconds since epoch UTC.",
          "type": "integer",
          "format": "int64"
        },
        "properties": {
          "$ref": "#/definitions/PropertySchema"
        },
        "tenant": {
          "description": "The name of the tenant the object belongs to.",
          "type": "string"
        },
        "vector": {
          "description": "This field returns vectors associated with the object. C11yVector, Vector or Vectors values are possible.",
          "$ref": "#/definitions/C11yVector"
        },
        "vectorWeights": {
          "$ref": "#/definitions/VectorWeights"
        },
        "vectors": {
          "description": "This field returns vectors associated with the object.",
          "$ref": "#/definitions/Vectors"
        }
      }
    },
    "ObjectTtlConfig": {
      "description": "Configuration of objects' time-to-live",
      "properties": {
        "defaultTtl": {
          "description": "Interval (in seconds) to be added to ` + "`" + `deleteOn` + "`" + ` value, denoting object's expiration time. Has to be positive for ` + "`" + `deleteOn` + "`" + ` set to ` + "`" + `_creationTimeUnix` + "`" + ` or ` + "`" + `_lastUpdateTimeUnix` + "`" + `, any for custom property (default: ` + "`" + `0` + "`" + `).",
          "type": "integer",
          "x-omitempty": false
        },
        "deleteOn": {
          "description": "Name of the property holding base time to compute object's expiration time (ttl = value of deleteOn property + defaultTtl). Can be set to ` + "`" + `_creationTimeUnix` + "`" + `, ` + "`" + `_lastUpdateTimeUnix` + "`" + ` or custom property of ` + "`" + `date` + "`" + ` datatype.",
          "type": "string",
          "x-omitempty": false
        },
        "enabled": {
          "description": "Whether or not object ttl is enabled for this collection (default: ` + "`" + `false` + "`" + `).",
          "type": "boolean",
          "x-omitempty": false
        },
        "filterExpiredObjects": {
          "description": "Whether remove from resultset expired, but not yet deleted by background process objects (default: ` + "`" + `false` + "`" + `).",
          "type": "boolean",
          "x-omitempty": false
        }
      }
    },
    "ObjectsGetResponse": {
      "type": "object",
      "allOf": [
        {
          "$ref": "#/definitions/Object"
        },
        {
          "properties": {
            "deprecations": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/Deprecation"
              }
            }
          }
        },
        {
          "properties": {
            "result": {
              "description": "Results for this specific object.",
              "format": "object",
              "properties": {
                "errors": {
                  "$ref": "#/definitions/ErrorResponse"
                },
                "status": {
                  "type": "string",
                  "default": "SUCCESS",
                  "enum": [
                    "SUCCESS",
                    "FAILED"
                  ]
                }
              }
            }
          }
        }
      ]
    },
    "ObjectsGetResponseAO2Result": {
      "description": "Results for this specific object.",
      "format": "object",
      "properties": {
        "errors": {
          "$ref": "#/definitions/ErrorResponse"
        },
        "status": {
          "type": "string",
          "default": "SUCCESS",
          "enum": [
            "SUCCESS",
            "FAILED"
          ]
        }
      }
    },
    "ObjectsListResponse": {
      "description": "List of objects.",
      "type": "object",
      "properties": {
        "deprecations": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/Deprecation"
          }
        },
        "objects": {
          "description": "The actual list of objects.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/Object"
          }
        },
        "totalResults": {
          "description": "The total number of objects for the query. The number of items in a response may be smaller due to paging.",
          "type": "integer",
          "format": "int64"
        }
      }
    },
    "PatchDocumentAction": {
      "description": "Either a JSONPatch document as defined by RFC 6902 (from, op, path, value), or a merge document (RFC 7396).",
      "required": [
        "op",
        "path"
      ],
      "properties": {
        "from": {
          "description": "A string containing a JSON Pointer value.",
          "type": "string"
        },
        "merge": {
          "$ref": "#/definitions/Object"
        },
        "op": {
          "description": "The operation to be performed.",
          "type": "string",
          "enum": [
            "add",
            "remove",
            "replace",
            "move",
            "copy",
            "test"
          ]
        },
        "path": {
          "description": "A JSON-Pointer.",
          "type": "string"
        },
        "value": {
          "description": "The value to be used within the operations.",
          "type": "object"
        }
      }
    },
    "PatchDocumentObject": {
      "description": "Either a JSONPatch document as defined by RFC 6902 (from, op, path, value), or a merge document (RFC 7396).",
      "required": [
        "op",
        "path"
      ],
      "properties": {
        "from": {
          "description": "A string containing a JSON Pointer value.",
          "type": "string"
        },
        "merge": {
          "$ref": "#/definitions/Object"
        },
        "op": {
          "description": "The operation to be performed.",
          "type": "string",
          "enum": [
            "add",
            "remove",
            "replace",
            "move",
            "copy",
            "test"
          ]
        },
        "path": {
          "description": "A JSON-Pointer.",
          "type": "string"
        },
        "value": {
          "description": "The value to be used within the operations.",
          "type": "object"
        }
      }
    },
    "PeerUpdate": {
      "description": "A single peer in the network.",
      "properties": {
        "id": {
          "description": "The session ID of the peer.",
          "type": "string",
          "format": "uuid"
        },
        "name": {
          "description": "Human readable name.",
          "type": "string"
        },
        "schemaHash": {
          "description": "The latest known hash of the peer's schema.",
          "type": "string"
        },
        "uri": {
          "description": "The location where the peer is exposed to the internet.",
          "type": "string",
          "format": "uri"
        }
      }
    },
    "PeerUpdateList": {
      "description": "List of known peers.",
      "type": "array",
      "items": {
        "$ref": "#/definitions/PeerUpdate"
      }
    },
    "Permission": {
      "description": "Permissions attached to a role.",
      "type": "object",
      "required": [
        "action"
      ],
      "properties": {
        "action": {
          "description": "Allowed actions in weaviate.",
          "type": "string",
          "enum": [
            "manage_backups",
            "read_cluster",
            "create_data",
            "read_data",
            "update_data",
            "delete_data",
            "read_nodes",
            "create_roles",
            "read_roles",
            "update_roles",
            "delete_roles",
            "create_collections",
            "read_collections",
            "update_collections",
            "delete_collections",
            "assign_and_revoke_users",
            "create_users",
            "read_users",
            "update_users",
            "delete_users",
            "create_tenants",
            "read_tenants",
            "update_tenants",
            "delete_tenants",
            "create_replicate",
            "read_replicate",
            "update_replicate",
            "delete_replicate",
            "create_aliases",
            "read_aliases",
            "update_aliases",
            "delete_aliases",
            "assign_and_revoke_groups",
            "read_groups"
          ]
        },
        "aliases": {
          "description": "Resource definition for alias-related actions and permissions. Used to specify which aliases and collections can be accessed or modified.",
          "type": "object",
          "properties": {
            "alias": {
              "description": "A string that specifies which aliases this permission applies to. Can be an exact alias name or a regex pattern. The default value ` + "`" + `*` + "`" + ` applies the permission to all aliases.",
              "type": "string",
              "default": "*"
            },
            "collection": {
              "description": "A string that specifies which collections this permission applies to. Can be an exact collection name or a regex pattern. The default value ` + "`" + `*` + "`" + ` applies the permission to all collections.",
              "type": "string",
              "default": "*"
            }
          }
        },
        "backups": {
          "description": "Resources applicable for backup actions.",
          "type": "object",
          "properties": {
            "collection": {
              "description": "A string that specifies which collections this permission applies to. Can be an exact collection name or a regex pattern. The default value ` + "`" + `*` + "`" + ` applies the permission to all collections.",
              "type": "string",
              "default": "*"
            }
          }
        },
        "collections": {
          "description": "Resources applicable for collection and/or tenant actions.",
          "type": "object",
          "properties": {
            "collection": {
              "description": "A string that specifies which collections this permission applies to. Can be an exact collection name or a regex pattern. The default value ` + "`" + `*` + "`" + ` applies the permission to all collections.",
              "type": "string",
              "default": "*"
            }
          }
        },
        "data": {
          "description": "Resources applicable for data actions.",
          "type": "object",
          "properties": {
            "collection": {
              "description": "A string that specifies which collections this permission applies to. Can be an exact collection name or a regex pattern. The default value ` + "`" + `*` + "`" + ` applies the permission to all collections.",
              "type": "string",
              "default": "*"
            },
            "object": {
              "description": "A string that specifies which objects this permission applies to. Can be an exact object ID or a regex pattern. The default value ` + "`" + `*` + "`" + ` applies the permission to all objects.",
              "type": "string",
              "default": "*"
            },
            "tenant": {
              "description": "A string that specifies which tenants this permission applies to. Can be an exact tenant name or a regex pattern. The default value ` + "`" + `*` + "`" + ` applies the permission to all tenants.",
              "type": "string",
              "default": "*"
            }
          }
        },
        "groups": {
          "description": "Resources applicable for group actions.",
          "type": "object",
          "properties": {
            "group": {
              "description": "A string that specifies which groups this permission applies to. Can be an exact group name or a regex pattern. The default value ` + "`" + `*` + "`" + ` applies the permission to all groups.",
              "type": "string",
              "default": "*"
            },
            "groupType": {
              "$ref": "#/definitions/GroupType"
            }
          }
        },
        "nodes": {
          "description": "Resources applicable for cluster actions.",
          "type": "object",
          "properties": {
            "collection": {
              "description": "A string that specifies which collections this permission applies to. Can be an exact collection name or a regex pattern. The default value ` + "`" + `*` + "`" + ` applies the permission to all collections.",
              "type": "string",
              "default": "*"
            },
            "verbosity": {
              "description": "Whether to allow (verbose) returning shards and stats data in the response.",
              "type": "string",
              "default": "minimal",
              "enum": [
                "verbose",
                "minimal"
              ]
            }
          }
        },
        "replicate": {
          "description": "resources applicable for replicate actions",
          "type": "object",
          "properties": {
            "collection": {
              "description": "string or regex. if a specific collection name, if left empty it will be ALL or *",
              "type": "string",
              "default": "*"
            },
            "shard": {
              "description": "string or regex. if a specific shard name, if left empty it will be ALL or *",
              "type": "string",
              "default": "*"
            }
          }
        },
        "roles": {
          "description": "Resources applicable for role actions.",
          "type": "object",
          "properties": {
            "role": {
              "description": "A string that specifies which roles this permission applies to. Can be an exact role name or a regex pattern. The default value ` + "`" + `*` + "`" + ` applies the permission to all roles.",
              "type": "string",
              "default": "*"
            },
            "scope": {
              "description": "Set the scope for the manage role permission.",
              "type": "string",
              "default": "match",
              "enum": [
                "all",
                "match"
              ]
            }
          }
        },
        "tenants": {
          "description": "Resources applicable for tenant actions.",
          "type": "object",
          "properties": {
            "collection": {
              "description": "A string that specifies which collections this permission applies to. Can be an exact collection name or a regex pattern. The default value ` + "`" + `*` + "`" + ` applies the permission to all collections.",
              "type": "string",
              "default": "*"
            },
            "tenant": {
              "description": "A string that specifies which tenants this permission applies to. Can be an exact tenant name or a regex pattern. The default value ` + "`" + `*` + "`" + ` applies the permission to all tenants.",
              "type": "string",
              "default": "*"
            }
          }
        },
        "users": {
          "description": "Resources applicable for user actions.",
          "type": "object",
          "properties": {
            "users": {
              "description": "A string that specifies which users this permission applies to. Can be an exact user name or a regex pattern. The default value ` + "`" + `*` + "`" + ` applies the permission to all users.",
              "type": "string",
              "default": "*"
            }
          }
        }
      }
    },
    "PermissionAliases": {
      "description": "Resource definition for alias-related actions and permissions. Used to specify which aliases and collections can be accessed or modified.",
      "type": "object",
      "properties": {
        "alias": {
          "description": "A string that specifies which aliases this permission applies to. Can be an exact alias name or a regex pattern. The default value ` + "`" + `*` + "`" + ` applies the permission to all aliases.",
          "type": "string",
          "default": "*"
        },
        "collection": {
          "description": "A string that specifies which collections this permission applies to. Can be an exact collection name or a regex pattern. The default value ` + "`" + `*` + "`" + ` applies the permission to all collections.",
          "type": "string",
          "default": "*"
        }
      }
    },
    "PermissionBackups": {
      "description": "Resources applicable for backup actions.",
      "type": "object",
      "properties": {
        "collection": {
          "description": "A string that specifies which collections this permission applies to. Can be an exact collection name or a regex pattern. The default value ` + "`" + `*` + "`" + ` applies the permission to all collections.",
          "type": "string",
          "default": "*"
        }
      }
    },
    "PermissionCollections": {
      "description": "Resources applicable for collection and/or tenant actions.",
      "type": "object",
      "properties": {
        "collection": {
          "description": "A string that specifies which collections this permission applies to. Can be an exact collection name or a regex pattern. The default value ` + "`" + `*` + "`" + ` applies the permission to all collections.",
          "type": "string",
          "default": "*"
        }
      }
    },
    "PermissionData": {
      "description": "Resources applicable for data actions.",
      "type": "object",
      "properties": {
        "collection": {
          "description": "A string that specifies which collections this permission applies to. Can be an exact collection name or a regex pattern. The default value ` + "`" + `*` + "`" + ` applies the permission to all collections.",
          "type": "string",
          "default": "*"
        },
        "object": {
          "description": "A string that specifies which objects this permission applies to. Can be an exact object ID or a regex pattern. The default value ` + "`" + `*` + "`" + ` applies the permission to all objects.",
          "type": "string",
          "default": "*"
        },
        "tenant": {
          "description": "A string that specifies which tenants this permission applies to. Can be an exact tenant name or a regex pattern. The default value ` + "`" + `*` + "`" + ` applies the permission to all tenants.",
          "type": "string",
          "default": "*"
        }
      }
    },
    "PermissionGroups": {
      "description": "Resources applicable for group actions.",
      "type": "object",
      "properties": {
        "group": {
          "description": "A string that specifies which groups this permission applies to. Can be an exact group name or a regex pattern. The default value ` + "`" + `*` + "`" + ` applies the permission to all groups.",
          "type": "string",
          "default": "*"
        },
        "groupType": {
          "$ref": "#/definitions/GroupType"
        }
      }
    },
    "PermissionNodes": {
      "description": "Resources applicable for cluster actions.",
      "type": "object",
      "properties": {
        "collection": {
          "description": "A string that specifies which collections this permission applies to. Can be an exact collection name or a regex pattern. The default value ` + "`" + `*` + "`" + ` applies the permission to all collections.",
          "type": "string",
          "default": "*"
        },
        "verbosity": {
          "description": "Whether to allow (verbose) returning shards and stats data in the response.",
          "type": "string",
          "default": "minimal",
          "enum": [
            "verbose",
            "minimal"
          ]
        }
      }
    },
    "PermissionReplicate": {
      "description": "resources applicable for replicate actions",
      "type": "object",
      "properties": {
        "collection": {
          "description": "string or regex. if a specific collection name, if left empty it will be ALL or *",
          "type": "string",
          "default": "*"
        },
        "shard": {
          "description": "string or regex. if a specific shard name, if left empty it will be ALL or *",
          "type": "string",
          "default": "*"
        }
      }
    },
    "PermissionRoles": {
      "description": "Resources applicable for role actions.",
      "type": "object",
      "properties": {
        "role": {
          "description": "A string that specifies which roles this permission applies to. Can be an exact role name or a regex pattern. The default value ` + "`" + `*` + "`" + ` applies the permission to all roles.",
          "type": "string",
          "default": "*"
        },
        "scope": {
          "description": "Set the scope for the manage role permission.",
          "type": "string",
          "default": "match",
          "enum": [
            "all",
            "match"
          ]
        }
      }
    },
    "PermissionTenants": {
      "description": "Resources applicable for tenant actions.",
      "type": "object",
      "properties": {
        "collection": {
          "description": "A string that specifies which collections this permission applies to. Can be an exact collection name or a regex pattern. The default value ` + "`" + `*` + "`" + ` applies the permission to all collections.",
          "type": "string",
          "default": "*"
        },
        "tenant": {
          "description": "A string that specifies which tenants this permission applies to. Can be an exact tenant name or a regex pattern. The default value ` + "`" + `*` + "`" + ` applies the permission to all tenants.",
          "type": "string",
          "default": "*"
        }
      }
    },
    "PermissionUsers": {
      "description": "Resources applicable for user actions.",
      "type": "object",
      "properties": {
        "users": {
          "description": "A string that specifies which users this permission applies to. Can be an exact user name or a regex pattern. The default value ` + "`" + `*` + "`" + ` applies the permission to all users.",
          "type": "string",
          "default": "*"
        }
      }
    },
    "PhoneNumber": {
      "properties": {
        "countryCode": {
          "description": "Read-only. The numerical country code (e.g. ` + "`" + `49` + "`" + `).",
          "type": "number",
          "format": "uint64"
        },
        "defaultCountry": {
          "description": "Optional. The ISO 3166-1 alpha-2 country code. This is used to figure out the correct ` + "`" + `countryCode` + "`" + ` and international format if only a national number (e.g. ` + "`" + `0123 4567` + "`" + `) is provided.",
          "type": "string"
        },
        "input": {
          "description": "The raw input as the phone number is present in your raw data set. It will be parsed into the standardized formats if valid.",
          "type": "string"
        },
        "internationalFormatted": {
          "description": "Read-only. Parsed result in the international format (e.g. ` + "`" + `+49 123 456789` + "`" + `).",
          "type": "string"
        },
        "national": {
          "description": "Read-only. The numerical representation of the national part.",
          "type": "number",
          "format": "uint64"
        },
        "nationalFormatted": {
          "description": "Read-only. Parsed result in the national format (e.g. ` + "`" + `0123 456789` + "`" + `).",
          "type": "string"
        },
        "valid": {
          "description": "Read-only. Indicates whether the parsed number is a valid phone number.",
          "type": "boolean"
        }
      }
    },
    "Principal": {
      "type": "object",
      "properties": {
        "groups": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "userType": {
          "$ref": "#/definitions/UserTypeInput"
        },
        "username": {
          "description": "The username that was extracted either from the authentication information",
          "type": "string"
        }
      }
    },
    "Property": {
      "type": "object",
      "properties": {
        "dataType": {
          "description": "Data type of the property (required). If it starts with a capital (for example Person), may be a reference to another type.",
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "description": {
          "description": "Description of the property.",
          "type": "string"
        },
        "indexFilterable": {
          "description": "Whether to include this property in the filterable, Roaring Bitmap index. If ` + "`" + `false` + "`" + `, this property cannot be used in ` + "`" + `where` + "`" + ` filters. \u003cbr/\u003e\u003cbr/\u003eNote: Unrelated to vectorization behavior.",
          "type": "boolean",
          "x-nullable": true
        },
        "indexInverted": {
          "description": "(Deprecated). Whether to include this property in the inverted index. If ` + "`" + `false` + "`" + `, this property cannot be used in ` + "`" + `where` + "`" + ` filters, ` + "`" + `bm25` + "`" + ` or ` + "`" + `hybrid` + "`" + ` search. \u003cbr/\u003e\u003cbr/\u003eUnrelated to vectorization behavior (deprecated as of v1.19; use indexFilterable or/and indexSearchable instead)",
          "type": "boolean",
          "x-nullable": true
        },
        "indexRangeFilters": {
          "description": "Whether to include this property in the filterable, range-based Roaring Bitmap index. Provides better performance for range queries compared to filterable index in large datasets. Applicable only to properties of data type int, number, date.",
          "type": "boolean",
          "x-nullable": true
        },
        "indexSearchable": {
          "description": "Optional. Should this property be indexed in the inverted index. Defaults to true. Applicable only to properties of data type text and text[]. If you choose false, you will not be able to use this property in bm25 or hybrid search. This property has no affect on vectorization decisions done by modules",
          "type": "boolean",
          "x-nullable": true
        },
        "moduleConfig": {
          "description": "Configuration specific to modules in a collection context.",
          "type": "object"
        },
        "name": {
          "description": "The name of the property (required). Multiple words should be concatenated in camelCase, e.g. ` + "`" + `nameOfAuthor` + "`" + `.",
          "type": "string"
        },
        "nestedProperties": {
          "description": "The properties of the nested object(s). Applies to object and object[] data types.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/NestedProperty"
          },
          "x-omitempty": true
        },
        "tokenization": {
          "description": "Determines how a property is indexed. This setting applies to ` + "`" + `text` + "`" + ` and ` + "`" + `text[]` + "`" + ` data types. The following tokenization methods are available:\u003cbr/\u003e\u003cbr/\u003e- ` + "`" + `word` + "`" + ` (default): Splits the text on any non-alphanumeric characters and lowercases the tokens.\u003cbr/\u003e- ` + "`" + `lowercase` + "`" + `: Splits the text on whitespace and lowercases the tokens.\u003cbr/\u003e- ` + "`" + `whitespace` + "`" + `: Splits the text on whitespace. This tokenization is case-sensitive.\u003cbr/\u003e- ` + "`" + `field` + "`" + `: Indexes the entire property value as a single token after trimming whitespace.\u003cbr/\u003e- ` + "`" + `trigram` + "`" + `: Splits the property into rolling trigrams (three-character sequences).\u003cbr/\u003e- ` + "`" + `gse` + "`" + `: Uses the ` + "`" + `gse` + "`" + ` tokenizer, suitable for Chinese language text. [See ` + "`" + `gse` + "`" + ` docs](https://pkg.go.dev/github.com/go-ego/gse#section-readme).\u003cbr/\u003e- ` + "`" + `kagome_ja` + "`" + `: Uses the ` + "`" + `Kagome` + "`" + ` tokenizer with a Japanese (IPA) dictionary. [See ` + "`" + `kagome` + "`" + ` docs](https://github.com/ikawaha/kagome).\u003cbr/\u003e- ` + "`" + `kagome_kr` + "`" + `: Uses the ` + "`" + `Kagome` + "`" + ` tokenizer with a Korean dictionary. [See ` + "`" + `kagome` + "`" + ` docs](https://github.com/ikawaha/kagome).\u003cbr/\u003e\u003cbr/\u003eSee [Reference: Tokenization](https://docs.weaviate.io/weaviate/config-refs/collections#tokenization) for details.",
          "type": "string",
          "enum": [
            "word",
            "lowercase",
            "whitespace",
            "field",
            "trigram",
            "gse",
            "kagome_kr",
            "kagome_ja",
            "gse_ch"
          ]
        }
      }
    },
    "PropertySchema": {
      "description": "Names and values of an individual property. A returned response may also contain additional metadata, such as from classification or feature projection.",
      "type": "object"
    },
    "RaftStatistics": {
      "description": "The definition of Raft statistics.",
      "properties": {
        "appliedIndex": {
          "type": "string"
        },
        "commitIndex": {
          "type": "string"
        },
        "fsmPending": {
          "type": "string"
        },
        "lastContact": {
          "type": "string"
        },
        "lastLogIndex": {
          "type": "string"
        },
        "lastLogTerm": {
          "type": "string"
        },
        "lastSnapshotIndex": {
          "type": "string"
        },
        "lastSnapshotTerm": {
          "type": "string"
        },
        "latestConfiguration": {
          "description": "Weaviate Raft nodes.",
          "type": "object"
        },
        "latestConfigurationIndex": {
          "type": "string"
        },
        "numPeers": {
          "type": "string"
        },
        "protocolVersion": {
          "type": "string"
        },
        "protocolVersionMax": {
          "type": "string"
        },
        "protocolVersionMin": {
          "type": "string"
        },
        "snapshotVersionMax": {
          "type": "string"
        },
        "snapshotVersionMin": {
          "type": "string"
        },
        "state": {
          "type": "string"
        },
        "term": {
          "type": "string"
        }
      }
    },
    "ReferenceMetaClassification": {
      "description": "This meta field contains additional info about the classified reference property",
      "properties": {
        "closestLosingDistance": {
          "description": "The lowest distance of a neighbor in the losing group. Optional. If k equals the size of the winning group, there is no losing group",
          "type": "number",
          "format": "float32",
          "x-nullable": true
        },
        "closestOverallDistance": {
          "description": "The lowest distance of any neighbor, regardless of whether they were in the winning or losing group",
          "type": "number",
          "format": "float32"
        },
        "closestWinningDistance": {
          "description": "Closest distance of a neighbor from the winning group",
          "type": "number",
          "format": "float32"
        },
        "losingCount": {
          "description": "size of the losing group, can be 0 if the winning group size equals k",
          "type": "number",
          "format": "int64"
        },
        "losingDistance": {
          "description": "deprecated - do not use, to be removed in 0.23.0",
          "type": "number",
          "format": "float32",
          "x-nullable": true
        },
        "meanLosingDistance": {
          "description": "Mean distance of all neighbors from the losing group. Optional. If k equals the size of the winning group, there is no losing group.",
          "type": "number",
          "format": "float32",
          "x-nullable": true
        },
        "meanWinningDistance": {
          "description": "Mean distance of all neighbors from the winning group",
          "type": "number",
          "format": "float32"
        },
        "overallCount": {
          "description": "overall neighbors checked as part of the classification. In most cases this will equal k, but could be lower than k - for example if not enough data was present",
          "type": "number",
          "format": "int64"
        },
        "winningCount": {
          "description": "size of the winning group, a number between 1..k",
          "type": "number",
          "format": "int64"
        },
        "winningDistance": {
          "description": "deprecated - do not use, to be removed in 0.23.0",
          "type": "number",
          "format": "float32"
        }
      }
    },
    "ReplicationConfig": {
      "description": "Configure how replication is executed in a cluster",
      "type": "object",
      "properties": {
        "asyncEnabled": {
          "description": "Enable asynchronous replication (default: ` + "`" + `false` + "`" + `).",
          "type": "boolean",
          "x-omitempty": false
        },
        "deletionStrategy": {
          "description": "Conflict resolution strategy for deleted objects.",
          "type": "string",
          "enum": [
            "NoAutomatedResolution",
            "DeleteOnConflict",
            "TimeBasedResolution"
          ],
          "x-omitempty": true
        },
        "factor": {
          "description": "Number of times a collection (class) is replicated (default: 1).",
          "type": "integer"
        }
      }
    },
    "ReplicationDeleteReplicaRequest": {
      "description": "Specifies the parameters required to permanently delete a specific shard replica from a particular node. This action will remove the replica's data from the node.",
      "type": "object",
      "required": [
        "node",
        "collection",
        "shard"
      ],
      "properties": {
        "collection": {
          "description": "The name of the collection to which the shard replica belongs.",
          "type": "string"
        },
        "node": {
          "description": "The name of the Weaviate node from which the shard replica will be deleted.",
          "type": "string"
        },
        "shard": {
          "description": "The ID of the shard whose replica is to be deleted.",
          "type": "string"
        }
      }
    },
    "ReplicationDisableReplicaRequest": {
      "description": "Specifies the parameters required to mark a specific shard replica as inactive (soft-delete) on a particular node. This action typically prevents the replica from serving requests but does not immediately remove its data.",
      "type": "object",
      "required": [
        "node",
        "collection",
        "shard"
      ],
      "properties": {
        "collection": {
          "description": "The name of the collection to which the shard replica belongs.",
          "type": "string"
        },
        "node": {
          "description": "The name of the Weaviate node hosting the shard replica that is to be disabled.",
          "type": "string"
        },
        "shard": {
          "description": "The ID of the shard whose replica is to be disabled.",
          "type": "string"
        }
      }
    },
    "ReplicationReplicateDetailsReplicaResponse": {
      "description": "Provides a comprehensive overview of a specific replication operation, detailing its unique ID, the involved collection, shard, source and target nodes, transfer type, current status, and optionally, its status history.",
      "required": [
        "id",
        "shard",
        "sourceNode",
        "targetNode",
        "collection",
        "status",
        "type"
      ],
      "properties": {
        "collection": {
          "description": "The name of the collection to which the shard being replicated belongs.",
          "type": "string"
        },
        "id": {
          "description": "The unique identifier (ID) of this specific replication operation.",
          "type": "string",
          "format": "uuid"
        },
        "scheduledForCancel": {
          "description": "Whether the replica operation is scheduled for cancellation.",
          "type": "boolean"
        },
        "scheduledForDelete": {
          "description": "Whether the replica operation is scheduled for deletion.",
          "type": "boolean"
        },
        "shard": {
          "description": "The name of the shard involved in this replication operation.",
          "type": "string"
        },
        "sourceNode": {
          "description": "The identifier of the node from which the replica is being moved or copied (the source node).",
          "type": "string"
        },
        "status": {
          "description": "An object detailing the current operational state of the replica movement and any errors encountered.",
          "type": "object",
          "$ref": "#/definitions/ReplicationReplicateDetailsReplicaStatus"
        },
        "statusHistory": {
          "description": "An array detailing the historical sequence of statuses the replication operation has transitioned through, if requested and available.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/ReplicationReplicateDetailsReplicaStatus"
          }
        },
        "targetNode": {
          "description": "The identifier of the node to which the replica is being moved or copied (the target node).",
          "type": "string"
        },
        "type": {
          "description": "Indicates whether the operation is a ` + "`" + `COPY` + "`" + ` (source replica remains) or a ` + "`" + `MOVE` + "`" + ` (source replica is removed after successful transfer).",
          "type": "string",
          "enum": [
            "COPY",
            "MOVE"
          ]
        },
        "uncancelable": {
          "description": "Whether the replica operation can't be cancelled.",
          "type": "boolean"
        },
        "whenStartedUnixMs": {
          "description": "The UNIX timestamp in ms when the replication operation was initiated. This is an approximate time and so should not be used for precise timing.",
          "type": "integer",
          "format": "int64"
        }
      }
    },
    "ReplicationReplicateDetailsReplicaStatus": {
      "description": "Represents the current or historical status of a shard replica involved in a replication operation, including its operational state and any associated errors.",
      "type": "object",
      "properties": {
        "errors": {
          "description": "A list of error messages encountered by this replica during the replication operation, if any.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/ReplicationReplicateDetailsReplicaStatusError"
          }
        },
        "state": {
          "description": "The current operational state of the replica during the replication process.",
          "type": "string",
          "enum": [
            "REGISTERED",
            "HYDRATING",
            "FINALIZING",
            "DEHYDRATING",
            "READY",
            "CANCELLED"
          ]
        },
        "whenStartedUnixMs": {
          "description": "The UNIX timestamp in ms when this state was first entered. This is an approximate time and so should not be used for precise timing.",
          "type": "integer",
          "format": "int64"
        }
      }
    },
    "ReplicationReplicateDetailsReplicaStatusError": {
      "description": "Represents an error encountered during a replication operation, including its timestamp and a human-readable message.",
      "type": "object",
      "properties": {
        "message": {
          "description": "A human-readable message describing the error.",
          "type": "string"
        },
        "whenErroredUnixMs": {
          "description": "The unix timestamp in ms when the error occurred. This is an approximate time and so should not be used for precise timing.",
          "type": "integer",
          "format": "int64"
        }
      }
    },
    "ReplicationReplicateForceDeleteRequest": {
      "description": "Specifies the parameters available when force deleting replication operations.",
      "type": "object",
      "properties": {
        "collection": {
          "description": "The name of the collection to which the shard being replicated belongs.",
          "type": "string"
        },
        "dryRun": {
          "description": "If true, the operation will not actually delete anything but will return the expected outcome of the deletion.",
          "type": "boolean",
          "default": false
        },
        "id": {
          "description": "The unique identifier (ID) of the replication operation to be forcefully deleted.",
          "type": "string",
          "format": "uuid"
        },
        "node": {
          "description": "The name of the target node where the replication operations are registered.",
          "type": "string"
        },
        "shard": {
          "description": "The identifier of the shard involved in the replication operations.",
          "type": "string"
        }
      }
    },
    "ReplicationReplicateForceDeleteResponse": {
      "description": "Provides the UUIDs that were successfully force deleted as part of the replication operation. If dryRun is true, this will return the expected outcome without actually deleting anything.",
      "type": "object",
      "properties": {
        "deleted": {
          "description": "The unique identifiers (IDs) of the replication operations that were forcefully deleted.",
          "type": "array",
          "items": {
            "type": "string",
            "format": "uuid"
          }
        },
        "dryRun": {
          "description": "Indicates whether the operation was a dry run (true) or an actual deletion (false).",
          "type": "boolean"
        }
      }
    },
    "ReplicationReplicateReplicaRequest": {
      "description": "Specifies the parameters required to initiate a shard replica movement operation between two nodes for a given collection and shard. This request defines the source and target node, the collection and type of transfer.",
      "type": "object",
      "required": [
        "sourceNode",
        "targetNode",
        "collection",
        "shard"
      ],
      "properties": {
        "collection": {
          "description": "The name of the collection to which the target shard belongs.",
          "type": "string"
        },
        "shard": {
          "description": "The name of the shard whose replica is to be moved or copied.",
          "type": "string"
        },
        "sourceNode": {
          "description": "The name of the Weaviate node currently hosting the shard replica that needs to be moved or copied.",
          "type": "string"
        },
        "targetNode": {
          "description": "The name of the Weaviate node where the new shard replica will be created as part of the movement or copy operation.",
          "type": "string"
        },
        "type": {
          "description": "Specifies the type of replication operation to perform. ` + "`" + `COPY` + "`" + ` creates a new replica on the target node while keeping the source replica. ` + "`" + `MOVE` + "`" + ` creates a new replica on the target node and then removes the source replica upon successful completion. Defaults to ` + "`" + `COPY` + "`" + ` if omitted.",
          "type": "string",
          "default": "COPY",
          "enum": [
            "COPY",
            "MOVE"
          ]
        }
      }
    },
    "ReplicationReplicateReplicaResponse": {
      "description": "Contains the unique identifier for a successfully initiated asynchronous replica movement operation. This ID can be used to track the progress of the operation.",
      "type": "object",
      "required": [
        "id"
      ],
      "properties": {
        "id": {
          "description": "The unique identifier (ID) assigned to the registered replication operation.",
          "type": "string",
          "format": "uuid"
        }
      }
    },
    "ReplicationScaleApplyResponse": {
      "description": "Response for the POST /replication/scale endpoint containing the list of initiated shard copy operation IDs.",
      "type": "object",
      "required": [
        "operationIds",
        "planId",
        "collection"
      ],
      "properties": {
        "collection": {
          "description": "The name of the collection associated with this replication scaling plan.",
          "type": "string",
          "x-nullable": false
        },
        "operationIds": {
          "description": "List of shard copy operation IDs created during scaling.",
          "type": "array",
          "items": {
            "type": "string",
            "format": "uuid"
          }
        },
        "planId": {
          "description": "The unique identifier of the replication scaling plan that generated these operations.",
          "type": "string",
          "format": "uuid",
          "x-nullable": false
        }
      }
    },
    "ReplicationScalePlan": {
      "description": "Defines a complete plan for scaling replication within a collection. Each shard entry specifies nodes to remove and nodes to add. Added nodes may either be initialized empty (null) or created by replicating data from a source node specified as a string. If a source node is also marked for removal in the same shard, it represents a move operation and can only be used once as a source for that shard. If a source node is not marked for removal, it represents a copy operation and can be used as the source for multiple additions in that shard. Nodes listed in 'removeNodes' cannot also appear as targets in 'addNodes' for the same shard, and the same node cannot be specified for both addition and removal in a single shard.",
      "type": "object",
      "required": [
        "planId",
        "collection",
        "shardScaleActions"
      ],
      "properties": {
        "collection": {
          "description": "The name of the collection to which this replication scaling plan applies.",
          "type": "string",
          "x-nullable": false
        },
        "planId": {
          "description": "A unique identifier for this replication scaling plan, useful for tracking and auditing purposes.",
          "type": "string",
          "format": "uuid",
          "x-nullable": false
        },
        "shardScaleActions": {
          "description": "A mapping of shard names to their corresponding scaling actions. Each key corresponds to a shard name, and its value defines which nodes should be removed and which should be added for that shard. If a source node listed for an addition is also in 'removeNodes' for the same shard, that addition is treated as a move operation. Such a node can appear only once as a source in that shard. Otherwise, if the source node is not being removed, it represents a copy operation and can be referenced multiple times as a source for additions.",
          "type": "object",
          "additionalProperties": {
            "$ref": "#/definitions/ReplicationScalePlanShardScaleActionsAnon"
          }
        }
      }
    },
    "ReplicationScalePlanShardScaleActionsAnon": {
      "description": "Scaling actions for a single shard, including which nodes to remove and which to add. Nodes listed in 'removeNodes' cannot appear as targets in 'addNodes' for the same shard. If a source node is also marked for removal, it is treated as a move operation and can only appear once as a source node in that shard. A source node that is not being removed can appear multiple times as a source node for additions in that shard (copy operations).",
      "type": "object",
      "properties": {
        "addNodes": {
          "description": "A mapping of target node identifiers to their addition configuration. Each key represents a target node where a new replica will be added. The value may be null, which means an empty replica will be created, or a string specifying the source node from which shard data will be copied. If the source node is also marked for removal in the same shard, this addition is treated as a move operation, and that source node can only appear once as a source node for that shard. If the source node is not being removed, it can be used as the source for multiple additions (copy operations).",
          "type": "object",
          "additionalProperties": {
            "description": "Defines how the new replica should be created. If null, an empty shard is created. If a string, it specifies the source node from which data for this shard should be replicated.",
            "type": [
              "string",
              "null"
            ]
          }
        },
        "removeNodes": {
          "description": "List of node identifiers from which replicas of this shard should be removed. Nodes listed here must not appear in 'addNodes' for the same shard, and cannot be used as a source node for any addition in this shard except in the implicit move case, where they appear as both a source and a node to remove.",
          "type": "array",
          "items": {
            "type": "string"
          }
        }
      }
    },
    "ReplicationShardReplicas": {
      "description": "Represents a shard and lists the nodes that currently host its replicas.",
      "type": "object",
      "properties": {
        "replicas": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "shard": {
          "type": "string"
        }
      }
    },
    "ReplicationShardingState": {
      "description": "Details the sharding layout for a specific collection, mapping each shard to its set of replicas across the cluster.",
      "type": "object",
      "properties": {
        "collection": {
          "description": "The name of the collection.",
          "type": "string"
        },
        "shards": {
          "description": "An array detailing each shard within the collection and the nodes hosting its replicas.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/ReplicationShardReplicas"
          }
        }
      }
    },
    "ReplicationShardingStateResponse": {
      "description": "Provides the detailed sharding state for one or more collections, including the distribution of shards and their replicas across the cluster nodes.",
      "type": "object",
      "properties": {
        "shardingState": {
          "$ref": "#/definitions/ReplicationShardingState"
        }
      }
    },
    "RestoreConfig": {
      "description": "Backup custom configuration",
      "type": "object",
      "properties": {
        "Bucket": {
          "description": "Name of the bucket, container, volume, etc",
          "type": "string"
        },
        "CPUPercentage": {
          "description": "Desired CPU core utilization ranging from 1%-80%",
          "type": "integer",
          "default": 50,
          "maximum": 80,
          "minimum": 1,
          "x-nullable": false
        },
        "Endpoint": {
          "description": "name of the endpoint, e.g. s3.amazonaws.com",
          "type": "string"
        },
        "Path": {
          "description": "Path within the bucket",
          "type": "string"
        },
        "rolesOptions": {
          "description": "How roles should be restored",
          "type": "string",
          "default": "noRestore",
          "enum": [
            "noRestore",
            "all"
          ]
        },
        "usersOptions": {
          "description": "How users should be restored",
          "type": "string",
          "default": "noRestore",
          "enum": [
            "noRestore",
            "all"
          ]
        }
      }
    },
    "Role": {
      "type": "object",
      "required": [
        "name",
        "permissions"
      ],
      "properties": {
        "name": {
          "description": "The name (ID) of the role.",
          "type": "string"
        },
        "permissions": {
          "type": "array",
          "items": {
            "description": "The list of permissions assigned to this role (level, action, resource).",
            "type": "object",
            "$ref": "#/definitions/Permission"
          }
        }
      }
    },
    "RolesListResponse": {
      "description": "List of roles.",
      "type": "array",
      "items": {
        "$ref": "#/definitions/Role"
      }
    },
    "Schema": {
      "description": "Definitions of semantic schemas (also see: https://github.com/weaviate/weaviate-semantic-schemas).",
      "type": "object",
      "properties": {
        "classes": {
          "description": "Semantic classes that are available.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/Class"
          }
        },
        "maintainer": {
          "description": "Email of the maintainer.",
          "type": "string",
          "format": "email"
        },
        "name": {
          "description": "Name of the schema.",
          "type": "string"
        }
      }
    },
    "SchemaClusterStatus": {
      "description": "Indicates the health of the schema in a cluster.",
      "type": "object",
      "properties": {
        "error": {
          "description": "Contains the sync check error if one occurred",
          "type": "string",
          "x-omitempty": true
        },
        "healthy": {
          "description": "True if the cluster is in sync, false if there is an issue (see error).",
          "type": "boolean",
          "x-omitempty": false
        },
        "hostname": {
          "description": "Hostname of the coordinating node, i.e. the one that received the cluster. This can be useful information if the error message contains phrases such as 'other nodes agree, but local does not', etc.",
          "type": "string"
        },
        "ignoreSchemaSync": {
          "description": "The cluster check at startup can be ignored (to recover from an out-of-sync situation).",
          "type": "boolean",
          "x-omitempty": false
        },
        "nodeCount": {
          "description": "Number of nodes that participated in the sync check",
          "type": "number",
          "format": "int"
        }
      }
    },
    "SchemaHistory": {
      "description": "This is an open object, with OpenAPI Specification 3.0 this will be more detailed. See Weaviate docs for more info. In the future this will become a key/value OR a SingleRef definition.",
      "type": "object"
    },
    "ShardStatus": {
      "description": "The status of a single shard",
      "properties": {
        "status": {
          "description": "Status of the shard",
          "type": "string"
        }
      }
    },
    "ShardStatusGetResponse": {
      "description": "Response body of shard status get request",
      "properties": {
        "name": {
          "description": "Name of the shard",
          "type": "string"
        },
        "status": {
          "description": "Status of the shard",
          "type": "string"
        },
        "vectorQueueSize": {
          "description": "Size of the vector queue of the shard",
          "type": "integer",
          "x-omitempty": false
        }
      }
    },
    "ShardStatusList": {
      "description": "The status of all the shards of a Class",
      "type": "array",
      "items": {
        "$ref": "#/definitions/ShardStatusGetResponse"
      }
    },
    "SingleRef": {
      "description": "Either set beacon (direct reference) or set collection (class) and schema (concept reference)",
      "properties": {
        "beacon": {
          "description": "If using a direct reference, specify the URI to point to the cross-reference here. Should be in the form of weaviate://localhost/\u003cuuid\u003e for the example of a local cross-reference to an object",
          "type": "string",
          "format": "uri"
        },
        "class": {
          "description": "If using a concept reference (rather than a direct reference), specify the desired collection (class) name here.",
          "type": "string",
          "format": "uri"
        },
        "classification": {
          "description": "Additional Meta information about classifications if the item was part of one",
          "$ref": "#/definitions/ReferenceMetaClassification"
        },
        "href": {
          "description": "If using a direct reference, this read-only fields provides a link to the referenced resource. If 'origin' is globally configured, an absolute URI is shown - a relative URI otherwise.",
          "type": "string",
          "format": "uri"
        },
        "schema": {
          "description": "If using a concept reference (rather than a direct reference), specify the desired properties here",
          "$ref": "#/definitions/PropertySchema"
        }
      }
    },
    "Statistics": {
      "description": "The definition of node statistics.",
      "properties": {
        "bootstrapped": {
          "type": "boolean"
        },
        "candidates": {
          "type": "object"
        },
        "dbLoaded": {
          "type": "boolean"
        },
        "initialLastAppliedIndex": {
          "type": "number",
          "format": "uint64"
        },
        "isVoter": {
          "type": "boolean"
        },
        "lastAppliedIndex": {
          "type": "number"
        },
        "leaderAddress": {
          "type": "object"
        },
        "leaderId": {
          "type": "object"
        },
        "name": {
          "description": "The name of the node.",
          "type": "string"
        },
        "open": {
          "type": "boolean"
        },
        "raft": {
          "description": "Weaviate Raft statistics.",
          "type": "object",
          "$ref": "#/definitions/RaftStatistics"
        },
        "ready": {
          "type": "boolean"
        },
        "status": {
          "description": "Node's status.",
          "type": "string",
          "default": "HEALTHY",
          "enum": [
            "HEALTHY",
            "UNHEALTHY",
            "UNAVAILABLE",
            "TIMEOUT"
          ]
        }
      }
    },
    "StopwordConfig": {
      "description": "Fine-grained control over stopword list usage.",
      "type": "object",
      "properties": {
        "additions": {
          "description": "Stopwords to be considered additionally (default: []). Can be any array of custom strings.",
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "preset": {
          "description": "Pre-existing list of common words by language (default: ` + "`" + `en` + "`" + `). Options: [` + "`" + `en` + "`" + `, ` + "`" + `none` + "`" + `].",
          "type": "string"
        },
        "removals": {
          "description": "Stopwords to be removed from consideration (default: []). Can be any array of custom strings.",
          "type": "array",
          "items": {
            "type": "string"
          }
        }
      }
    },
    "Tenant": {
      "description": "Attributes representing a single tenant within Weaviate.",
      "type": "object",
      "properties": {
        "activityStatus": {
          "description": "The activity status of the tenant, which determines if it is queryable and where its data is stored.\u003cbr/\u003e\u003cbr/\u003e\u003cb\u003eAvailable Statuses:\u003c/b\u003e\u003cbr/\u003e- ` + "`" + `ACTIVE` + "`" + `: The tenant is fully operational and ready for queries. Data is stored on local, hot storage.\u003cbr/\u003e- ` + "`" + `INACTIVE` + "`" + `: The tenant is not queryable. Data is stored locally.\u003cbr/\u003e- ` + "`" + `OFFLOADED` + "`" + `: The tenant is inactive and its data is stored in a remote cloud backend.\u003cbr/\u003e\u003cbr/\u003e\u003cb\u003eUsage Rules:\u003c/b\u003e\u003cbr/\u003e- \u003cb\u003eOn Create:\u003c/b\u003e This field is optional and defaults to ` + "`" + `ACTIVE` + "`" + `. Allowed values are ` + "`" + `ACTIVE` + "`" + ` and ` + "`" + `INACTIVE` + "`" + `.\u003cbr/\u003e- \u003cb\u003eOn Update:\u003c/b\u003e This field is required. Allowed values are ` + "`" + `ACTIVE` + "`" + `, ` + "`" + `INACTIVE` + "`" + `, and ` + "`" + `OFFLOADED` + "`" + `.\u003cbr/\u003e\u003cbr/\u003e\u003cb\u003eRead-Only Statuses:\u003c/b\u003e\u003cbr/\u003eThe following statuses are set by the server and indicate a tenant is transitioning between states:\u003cbr/\u003e- ` + "`" + `OFFLOADING` + "`" + `\u003cbr/\u003e- ` + "`" + `ONLOADING` + "`" + `\u003cbr/\u003e\u003cbr/\u003e\u003cb\u003eNote on Deprecated Names:\u003c/b\u003e\u003cbr/\u003eFor backward compatibility, deprecated names are still accepted and are mapped to their modern equivalents: ` + "`" + `HOT` + "`" + ` (now ` + "`" + `ACTIVE` + "`" + `), ` + "`" + `COLD` + "`" + ` (now ` + "`" + `INACTIVE` + "`" + `), ` + "`" + `FROZEN` + "`" + ` (now ` + "`" + `OFFLOADED` + "`" + `), ` + "`" + `FREEZING` + "`" + ` (now ` + "`" + `OFFLOADING` + "`" + `), ` + "`" + `UNFREEZING` + "`" + ` (now ` + "`" + `ONLOADING` + "`" + `).",
          "type": "string",
          "enum": [
            "ACTIVE",
            "INACTIVE",
            "OFFLOADED",
            "OFFLOADING",
            "ONLOADING",
            "HOT",
            "COLD",
            "FROZEN",
            "FREEZING",
            "UNFREEZING"
          ]
        },
        "name": {
          "description": "The name of the tenant (required).",
          "type": "string"
        }
      }
    },
    "TokenizerUserDictConfig": {
      "description": "A list of pairs of strings that should be replaced with another string during tokenization.",
      "type": "object",
      "properties": {
        "replacements": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/TokenizerUserDictConfigReplacementsItems0"
          }
        },
        "tokenizer": {
          "description": "The tokenizer to which the user dictionary should be applied. Currently, only the ` + "`" + `kagame` + "`" + ` ja and kr tokenizers supports user dictionaries.",
          "type": "string"
        }
      }
    },
    "TokenizerUserDictConfigReplacementsItems0": {
      "type": "object",
      "required": [
        "source",
        "target"
      ],
      "properties": {
        "source": {
          "description": "The string to be replaced.",
          "type": "string"
        },
        "target": {
          "description": "The string to replace with.",
          "type": "string"
        }
      }
    },
    "UserApiKey": {
      "type": "object",
      "required": [
        "apikey"
      ],
      "properties": {
        "apikey": {
          "description": "The API key associated with the user.",
          "type": "string"
        }
      }
    },
    "UserOwnInfo": {
      "type": "object",
      "required": [
        "username"
      ],
      "properties": {
        "groups": {
          "description": "The groups associated with the user.",
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "roles": {
          "type": "array",
          "items": {
            "description": "The roles assigned to the user.",
            "type": "object",
            "$ref": "#/definitions/Role"
          }
        },
        "username": {
          "description": "The name (ID) of the user.",
          "type": "string"
        }
      }
    },
    "UserTypeInput": {
      "description": "The type of the user. ` + "`" + `db` + "`" + ` users are managed by Weaviate, ` + "`" + `oidc` + "`" + ` users are managed by an external OIDC provider.",
      "type": "string",
      "enum": [
        "db",
        "oidc"
      ]
    },
    "UserTypeOutput": {
      "description": "The type of the user. ` + "`" + `db_user` + "`" + ` users are created through the ` + "`" + `users` + "`" + ` API, ` + "`" + `db_env_user` + "`" + ` users are created through environment variables, and ` + "`" + `oidc` + "`" + ` users are managed by an external OIDC provider.",
      "type": "string",
      "enum": [
        "db_user",
        "db_env_user",
        "oidc"
      ]
    },
    "Vector": {
      "description": "A vector representation of the object. If provided at object creation, this wil take precedence over any vectorizer setting.",
      "type": "object"
    },
    "VectorConfig": {
      "type": "object",
      "properties": {
        "vectorIndexConfig": {
          "description": "Vector-index config, that is specific to the type of index selected in vectorIndexType",
          "type": "object"
        },
        "vectorIndexType": {
          "description": "Name of the vector index to use, eg. (HNSW)",
          "type": "string"
        },
        "vectorizer": {
          "description": "Configuration of a specific vectorizer used by this vector",
          "type": "object"
        }
      }
    },
    "VectorWeights": {
      "description": "Allow custom overrides of vector weights as math expressions. E.g. ` + "`" + `pancake` + "`" + `: ` + "`" + `7` + "`" + ` will set the weight for the word pancake to 7 in the vectorization, whereas ` + "`" + `w * 3` + "`" + ` would triple the originally calculated word. This is an open object, with OpenAPI Specification 3.0 this will be more detailed. See Weaviate docs for more info. In the future this will become a key/value (string/string) object.",
      "type": "object"
    },
    "Vectors": {
      "description": "A map of named vectors for multi-vector representations.",
      "type": "object",
      "additionalProperties": {
        "$ref": "#/definitions/Vector"
      }
    },
    "WhereFilter": {
      "description": "Filter search results using a where filter.",
      "type": "object",
      "properties": {
        "operands": {
          "description": "Combine multiple where filters, requires 'And' or 'Or' operator.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/WhereFilter"
          }
        },
        "operator": {
          "description": "Operator to use.",
          "type": "string",
          "enum": [
            "And",
            "Or",
            "Equal",
            "Like",
            "NotEqual",
            "GreaterThan",
            "GreaterThanEqual",
            "LessThan",
            "LessThanEqual",
            "WithinGeoRange",
            "IsNull",
            "ContainsAny",
            "ContainsAll",
            "ContainsNone",
            "Not"
          ],
          "example": "GreaterThanEqual"
        },
        "path": {
          "description": "Path to the property currently being filtered.",
          "type": "array",
          "items": {
            "type": "string"
          },
          "example": [
            "inCity",
            "city",
            "name"
          ]
        },
        "valueBoolean": {
          "description": "value as boolean",
          "type": "boolean",
          "x-nullable": true,
          "example": false
        },
        "valueBooleanArray": {
          "description": "value as boolean",
          "type": "array",
          "items": {
            "type": "boolean"
          },
          "x-nullable": true,
          "x-omitempty": true,
          "example": [
            true,
            false
          ]
        },
        "valueDate": {
          "description": "value as date (as string)",
          "type": "string",
          "x-nullable": true,
          "example": "TODO"
        },
        "valueDateArray": {
          "description": "value as date (as string)",
          "type": "array",
          "items": {
            "type": "string"
          },
          "x-nullable": true,
          "x-omitempty": true,
          "example": "TODO"
        },
        "valueGeoRange": {
          "description": "value as geo coordinates and distance",
          "type": "object",
          "x-nullable": true,
          "$ref": "#/definitions/WhereFilterGeoRange"
        },
        "valueInt": {
          "description": "value as integer",
          "type": "integer",
          "format": "int64",
          "x-nullable": true,
          "example": 2000
        },
        "valueIntArray": {
          "description": "value as integer",
          "type": "array",
          "items": {
            "type": "integer",
            "format": "int64"
          },
          "x-nullable": true,
          "x-omitempty": true,
          "example": "[100, 200]"
        },
        "valueNumber": {
          "description": "value as number/float",
          "type": "number",
          "format": "float64",
          "x-nullable": true,
          "example": 3.14
        },
        "valueNumberArray": {
          "description": "value as number/float",
          "type": "array",
          "items": {
            "type": "number",
            "format": "float64"
          },
          "x-nullable": true,
          "x-omitempty": true,
          "example": [
            3.14
          ]
        },
        "valueString": {
          "description": "value as text (deprecated as of v1.19; alias for valueText)",
          "type": "string",
          "x-nullable": true,
          "example": "my search term"
        },
        "valueStringArray": {
          "description": "value as text (deprecated as of v1.19; alias for valueText)",
          "type": "array",
          "items": {
            "type": "string"
          },
          "x-nullable": true,
          "x-omitempty": true,
          "example": [
            "my search term"
          ]
        },
        "valueText": {
          "description": "value as text",
          "type": "string",
          "x-nullable": true,
          "example": "my search term"
        },
        "valueTextArray": {
          "description": "value as text",
          "type": "array",
          "items": {
            "type": "string"
          },
          "x-nullable": true,
          "x-omitempty": true,
          "example": [
            "my search term"
          ]
        }
      }
    },
    "WhereFilterGeoRange": {
      "description": "Filter within a distance of a georange.",
      "type": "object",
      "properties": {
        "distance": {
          "type": "object",
          "properties": {
            "max": {
              "type": "number",
              "format": "float64"
            }
          }
        },
        "geoCoordinates": {
          "x-nullable": false,
          "$ref": "#/definitions/GeoCoordinates"
        }
      }
    },
    "WhereFilterGeoRangeDistance": {
      "type": "object",
      "properties": {
        "max": {
          "type": "number",
          "format": "float64"
        }
      }
    }
  },
  "parameters": {
    "CommonAfterParameterQuery": {
      "type": "string",
      "description": "A threshold UUID of the objects to retrieve after, using an UUID-based ordering. This object is not part of the set. \u003cbr/\u003e\u003cbr/\u003eMust be used with collection name (` + "`" + `class` + "`" + `), typically in conjunction with ` + "`" + `limit` + "`" + `. \u003cbr/\u003e\u003cbr/\u003eNote ` + "`" + `after` + "`" + ` cannot be used with ` + "`" + `offset` + "`" + ` or ` + "`" + `sort` + "`" + `. \u003cbr/\u003e\u003cbr/\u003eFor a null value similar to offset=0, set an empty string in the request, i.e. ` + "`" + `after=` + "`" + ` or ` + "`" + `after` + "`" + `.",
      "name": "after",
      "in": "query"
    },
    "CommonClassParameterQuery": {
      "type": "string",
      "description": "The collection from which to query objects.  \u003cbr/\u003e\u003cbr/\u003eNote that if the collection name (` + "`" + `class` + "`" + `) is not provided, the response will not include any objects.",
      "name": "class",
      "in": "query"
    },
    "CommonConsistencyLevelParameterQuery": {
      "type": "string",
      "description": "Determines how many replicas must acknowledge a request before it is considered successful.",
      "name": "consistency_level",
      "in": "query"
    },
    "CommonIncludeParameterQuery": {
      "type": "string",
      "description": "Include additional information, such as classification information. Allowed values include: ` + "`" + `classification` + "`" + `, ` + "`" + `vector` + "`" + ` and ` + "`" + `interpretation` + "`" + `.",
      "name": "include",
      "in": "query"
    },
    "CommonLimitParameterQuery": {
      "type": "integer",
      "format": "int64",
      "description": "The maximum number of items to be returned per page. The default is 25 unless set otherwise as an environment variable.",
      "name": "limit",
      "in": "query"
    },
    "CommonNodeNameParameterQuery": {
      "type": "string",
      "description": "The target node which should fulfill the request.",
      "name": "node_name",
      "in": "query"
    },
    "CommonOffsetParameterQuery": {
      "type": "integer",
      "format": "int64",
      "default": 0,
      "description": "The starting index of the result window. Note ` + "`" + `offset` + "`" + ` will retrieve ` + "`" + `offset+limit` + "`" + ` results and return ` + "`" + `limit` + "`" + ` results from the object with index ` + "`" + `offset` + "`" + ` onwards. Limited by the value of ` + "`" + `QUERY_MAXIMUM_RESULTS` + "`" + `. \u003cbr/\u003e\u003cbr/\u003eShould be used in conjunction with ` + "`" + `limit` + "`" + `. \u003cbr/\u003e\u003cbr/\u003eCannot be used with ` + "`" + `after` + "`" + `.",
      "name": "offset",
      "in": "query"
    },
    "CommonOrderParameterQuery": {
      "type": "string",
      "description": "Order parameter to tell how to order (asc or desc) data within given field. Should be used in conjunction with ` + "`" + `sort` + "`" + ` parameter. If providing multiple ` + "`" + `sort` + "`" + ` values, provide multiple ` + "`" + `order` + "`" + ` values in corresponding order, e.g.: ` + "`" + `sort=author_name,title\u0026order=desc,asc` + "`" + `.",
      "name": "order",
      "in": "query"
    },
    "CommonOutputVerbosityParameterQuery": {
      "type": "string",
      "default": "minimal",
      "description": "Controls the verbosity of the output, possible values are: ` + "`" + `minimal` + "`" + `, ` + "`" + `verbose` + "`" + `. Defaults to ` + "`" + `minimal` + "`" + `.",
      "name": "output",
      "in": "query"
    },
    "CommonSortParameterQuery": {
      "type": "string",
      "description": "Name(s) of the property to sort by - e.g. ` + "`" + `city` + "`" + `, or ` + "`" + `country,city` + "`" + `.",
      "name": "sort",
      "in": "query"
    },
    "CommonTenantParameterQuery": {
      "type": "string",
      "description": "Specifies the tenant in a request targeting a multi-tenant collection (class).",
      "name": "tenant",
      "in": "query"
    }
  },
  "securityDefinitions": {
    "oidc": {
      "description": "OIDC (OpenConnect ID - based on OAuth2)",
      "type": "oauth2",
      "flow": "implicit",
      "authorizationUrl": "http://to-be-configured-in-the-application-config"
    }
  },
  "security": [
    {},
    {
      "oidc": []
    }
  ],
  "tags": [
    {
      "description": "Operations for managing individual data objects. Objects are the primary units of data stored within Weaviate collections. Each object conforms to the data schema definition of its parent collection, containing specific properties (data fields). Objects have one or multiple associated vector embeddings and can link to other objects via cross-references. These endpoints allow you to perform CRUD (Create, Read, Update, Delete) operations on individual data objects.",
      "name": "objects"
    },
    {
      "description": "Operations for performing actions on multiple data items (objects or references) in a single API request. Batch operations significantly improve performance and efficiency, especially for bulk data imports or large-scale deletions, by reducing network overhead compared to sending individual requests. These endpoints allow for creating multiple objects or deleting objects based on filters.",
      "name": "batch"
    },
    {
      "name": "graphql"
    },
    {
      "name": "meta"
    },
    {
      "description": "Operations related to managing collections. In Weaviate, 'collections' (formerly called 'classes') store your data objects. Each collection has a definition that specifies its data structure (properties and their data types), vectorizer settings (how vectors are generated or managed), and indexing configuration (how data is indexed for efficient search). These endpoints allow you to create, retrieve, update, and delete collection definitions. For detailed usage and code examples on interacting with collections, see the documentation: [https://weaviate.io/developers/weaviate/manage-data/collections](https://weaviate.io/developers/weaviate/manage-data/collections).",
      "name": "schema"
    },
    {
      "description": "Operations related to creating and managing backups of Weaviate data. This feature allows you to create snapshots of your collections and store them on external storage backends such as cloud object storage (S3, GCS, Azure) or a shared filesystem. These endpoints enable you to initiate backup and restore processes, monitor their status, list available backups on a backend, and delete unwanted backups. Backups are essential for disaster recovery, data migration, and maintaining point-in-time copies of your vector database.",
      "name": "backups"
    },
    {
      "description": "Endpoints for user account management in Weaviate. This includes operations specific to Weaviate-managed database users (` + "`" + `db` + "`" + ` users), such as creation (which generates an API key), listing, deletion, activation/deactivation, and API key rotation. It also provides operations applicable to any authenticated user (` + "`" + `db` + "`" + ` or ` + "`" + `oidc` + "`" + `), like retrieving their own information (username and assigned roles).\u003cbr/\u003e\u003cbr/\u003e**User Types:**\u003cbr/\u003e* **` + "`" + `db` + "`" + ` users:** Managed entirely within Weaviate (creation, deletion, API keys). Use these endpoints for full lifecycle management.\u003cbr/\u003e* **` + "`" + `oidc` + "`" + ` users:** Authenticated via an external OpenID Connect provider. Their lifecycle (creation, credentials) is managed externally, but their role assignments *within Weaviate* are managed via the ` + "`" + `authz` + "`" + ` endpoints.",
      "name": "users"
    },
    {
      "description": "Endpoints for managing Weaviate's Role-Based Access Control (RBAC) system. Access to Weaviate resources is granted through roles, which are collections of fine-grained permissions. \u003cbr/\u003e\u003cbr/\u003e**Permissions:** Define allowed actions (e.g., ` + "`" + `read_data` + "`" + `, ` + "`" + `create_collections` + "`" + `, ` + "`" + `delete_users` + "`" + `) on specific resources. Resources can be specified broadly (e.g., all collections: ` + "`" + `*` + "`" + `) or narrowly (e.g., a specific collection name, tenant pattern, user name, or role name).\u003cbr/\u003e\u003cbr/\u003e**Roles:** Are named sets of permissions. Managing roles involves creating roles with specific permissions, retrieving role definitions, deleting roles, and adding or removing permissions from existing roles.\u003cbr/\u003e\u003cbr/\u003e**Role assignment:** Roles grant their contained permissions to users or groups. These endpoints allow assigning roles to:\u003cbr/\u003e* ` + "`" + `db` + "`" + ` users: Users managed directly by Weaviate via API or environment variables, authenticating with API keys.\u003cbr/\u003e* ` + "`" + `oidc` + "`" + ` users: Users authenticated via an external OpenID Connect provider, managed externally but assigned roles within Weaviate.\u003cbr/\u003e* OIDC ` + "`" + `groups` + "`" + `: Users authenticated via OIDC who belong to a group automatically inherit roles assigned to that group.\u003cbr/\u003e\u003cbr/\u003eOperations also include revoking roles, checking if a role has a specific permission, listing roles assigned to a user, and listing users/groups assigned to a role. The authorization framework applies universally to both ` + "`" + `db` + "`" + ` and ` + "`" + `oidc` + "`" + ` users based on their assigned roles.",
      "name": "authz"
    },
    {
      "description": "Operations related to managing data replication, including initiating and monitoring shard replica movements between nodes, querying current sharding states, and managing the lifecycle of replication tasks.",
      "name": "replication"
    }
  ],
  "externalDocs": {
    "url": "https://github.com/weaviate/weaviate"
  }
}`))
}
